/*
 * eiffel.cc - a test/example for eiffel.h
 * 
 * Copyright (c) 1997 Phil Maker
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 *
 * $Id: eiffel.cc,v 1.5 1997/05/10 16:22:15 pjm Exp $
 */

#include <stdio.h>

#define I_DEFAULT_HANDLER(e,f,l,p) printf("fail")

#include "../src/eiffel.h"
#include "check.h"

#define odd(n) ((n % 2) == 1)
#define even(n) ((n % 2) == 0)

class T {
  int i;
public:
  T(int);
  bool invariant(); // class invariant
  void up(int n);
  void down(int n);
};

bool T::invariant() {
  return i >= 0;
}

T::T(int j) {
  i = j;
}

void T::up(int n) {
  REQUIRE(even(n));
  i += n ;
  ENSURE(n == n);
}

void T::down(int n) {
  REQUIRE(odd(n));
  i -= n;
  ENSURE(n == n);
}

T t = 1;

main() {
  CHECKMESSAGE("* eiffel.cc");

  CHECKEMPTY(t.up(4)); // precondition ok + invariant ok
  CHECKEMPTY(t.down(1)); // precondition ok + invariant ok
  CHECKFAIL(t.down(2)); // precondition fail + invariant ok
  CHECKFAIL(t.up(3)); // precondition fail + invariant ok
  CHECKEMPTY(t.down(3));  // precondition ok + invariant ok 
  CHECKFAIL(t.down(105)); // precondition ok + invariant fail

}

