/*
 * DI.c - test the DI.h macros.
 *
 * Copyright (c) 1997 Phil Maker
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 *
 * $Id: DI.c,v 1.2 1997/05/04 14:37:40 pjm Exp $
 */


#include <stdio.h>

#define DI_DEFAULT_HANDLER(e,f,l,p) \
  @@call printf("fail")@@  \
  @@cont @@

#include "../src/DI.h"

#include "check.h"

int z = 0;
int o = 1;

inline void f(int i) {
     return ;
}

int main() {
    volatile int i = 0;
    
    CHECKMESSAGE("DI.h tests");
    CHECKMESSAGE(" note: with -O3 we need a volatile for i least we fail since");
    CHECKMESSAGE("   i isn't created till after the assertions");
    
    CHECKEMPTY(DI(0 == 0));
    CHECKFAIL(DI(0 == 1));
    
    i = 0; 
    f(i);
		 
    CHECKEMPTY(DI(i == 0));
    CHECKFAIL(DI(i == 1));

    i = 1;
    CHECKEMPTY(DI(i == 1));
    CHECKFAIL(DI(i == 0));
    
    i = 0;
    CHECKEMPTY(DI(i == 0));
    while(i < 10) {
	CHECKEMPTY(DI(i < 10));
	i++;
	CHECKEMPTY(DI(1 <= i && i <= 10));
    }
    CHECKEMPTY(DI(i == 10));

    i = 0;
    CHECKFAIL(DI(i == 1));
    while(i < 10) {
	CHECKFAIL(DI(i >= 10));
	i++;
	CHECKFAIL(DI(i < 1 && i <= 10));
    }
    CHECKFAIL(DI(i != 10));

#if 0 
/* this one causes an error to be detected, its used to test the test system */
    CHECKFAIL(DI(i == 10)); 
#endif

    return 0;
}

