/*
 * now.c - test out the now library.
 *
 * Copyright (c) 1997 Phil Maker
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 *
 * $Id: now.c,v 1.5 1997/05/18 21:02:28 pjm Exp $
 */

#include <stdio.h>
#include "../src/now.h"

#include <unistd.h>

double t, u, d;
int i;
  
int main() {
  printf("*** now.c: testing now.h\n");
  
  printf("**** test 0: time a sleep(1) with now()\n\t");
  for(i = 0; i != 6; i++) {
    t = now();
    sleep(1);
    d = now() - t;
    printf("%8.3fs ", d);
    if(!(0.9 <= d && d <= 1.1) ) { 
      printf("\nerror: now.c measurement of sleep(1) = %f >10%% error\n", d);
    }
  }
  printf("\n");
  
  printf("**** test 1: time a sleep(1) with now_delta()...now_delta()\n\t");
  for(i = 0; i != 6; i++) {
    (void) now_delta(&t); /* start timer */
    sleep(1);
    d = now() - t;
    printf("%8.3fs ", d);
    if(!(0.9 <= d && d <= 1.1) ) { 
      printf("\nerror: now.c measurement of sleep(1) = %f >10%% error\n", d);
    }
  }
  printf("\n");
  
  printf("**** test 2: time a sleep(1) with now_reset()\n\t");
  for(i = 0; i != 6; i++) {
    now_reset();
    sleep(1);
    d = now();
    printf("%8.3fs ", d);
    if(!(0.9 <= d && d <= 1.1) ) { 
      printf("\nerror: now.c measurement of sleep(1) = %f >10%% error\n", d);
    }
  }
  printf("\n");

  printf("**** test 4: speed test, now() call = ");
  (void) now_delta(&t);
  for(i = 0; i != 100*1000; i++) {
    u = now();
  }
  printf("  %8.3f us\n", (now_delta(&t)/i)*1.0e6);

  return 0;
}
































