/*
 * selftest.c - test the testing macros
 *
 * Copyright (c) 1997 Phil Maker
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 *
 * $Id: selftest.c,v 1.3 1997/05/15 04:42:59 pjm Exp $
 */

#include <stdio.h>

#include "check.h"

int main() {
     CHECKMESSAGE("selftest.c: 7 errors  out of 10 is a PASS for this FILE");

     CHECKMESSAGE(" each of the following pairs of tests should pass+fail");
     
     CHECKANSWER(printf("hello"),hello);
     CHECKANSWER(printf("hello*"),hello);

     CHECKEMPTY(/*skip*/);
     CHECKEMPTY(putchar('a'));

     CHECKFAIL(printf("fail"));
     CHECKFAIL(printf("fail*"));
	
     CHECKMESSAGE(" pattern of two ok followed by two fails");
     
     CHECKTRUE(1==1);
     CHECKTRUE(1==0);

     CHECKFALSE(1==0);
     CHECKFALSE(1==1);

     return 0;
}

     
     

