/*
 * Q.c - test the Q.h macros.
 *
 * Copyright (c) 1997 Phil Maker
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 *
 * $Id: Q.c,v 1.2 1997/05/04 14:37:47 pjm Exp $
 */


#include <stdio.h>

#include "../src/Q.h"

#include "check.h"

int z = 0;
int o = 1;

#define N 5

int v[N] = { 0, 1, 2, 3, 4 };

float fv[N] = { 1.0, 2.0, 3.0, 4.0, 5.0 };

float fvsum = 1.0+2.0+3.0+4.0+5.0;

float fvprod = 1.0*2.0*3.0*4.0*5.0;

int m[N][N] = { 
    { 1, 0, 0, 0, 0 },
    { 0, 1, 0, 0, 0 },
    { 0, 0, 1, 0, 0 },
    { 0, 0, 0, 1, 0 },
    { 0, 0, 0, 0, 1 }
};


int main() {
    CHECKMESSAGE("* Q.h tests");

    CHECKMESSAGE("** basic tests for each routine");

    CHECKTRUE(A(int i = 0, i < N, i++, v[i] == i));
    CHECKFALSE(A(int i = 0, i < N, i++, v[i] > i));

    CHECKTRUE(E(int i = 0, i < N, i++, v[i] == 4));
    CHECKTRUE(E(int i = 0, i < N, i++, v[i] == 0));
    CHECKTRUE(E(int i = 0, i < N, i++, v[i] == 1));

    CHECKFALSE(E(int i = 0, i < N, i++, v[i] == 5));
    CHECKFALSE(E(int i = 0, i < N, i++, v[i] == -1));
    CHECKFALSE(E(int i = 0, i < N, i++, v[i] > i));

    CHECKTRUE(C(int i = 0, i < N, i++, 1) == N);
    CHECKTRUE(C(int i = 0, i < N, i++, v[i] == 0) == 1);
    CHECKTRUE(C(int i = 0, i < N, i++, v[i] == 4) == 1);
    CHECKTRUE(C(int i = 0, i < N, i++, v[i] == 5) == 0);

    CHECKTRUE(E1(int i = 0, i < N, i++, v[i] == 4));
    CHECKTRUE(E1(int i = 0, i < N, i++, v[i] == 0));
    CHECKTRUE(E1(int i = 0, i < N, i++, v[i] == 1));

    CHECKFALSE(E1(int i = 0, i < N, i++, v[i] > 4));
    CHECKFALSE(E1(int i = 0, i < N, i++, v[i] == -1));
    CHECKFALSE(E1(int i = 0, i < N, i++, v[i] == i));

    CHECKTRUE(S(int i = 0, i < N, i++, v[i]) == 10);
    CHECKTRUE(S(int i = 0, i < 0, i++, v[i]) == 0);

    CHECKTRUE(S(int i = 0, i < N, i++, fv[i]) == fvsum);
    CHECKTRUE(S(int i = 0, i < 0, i++, fv[i]) == 0.0);

    CHECKTRUE(P(int i = 1, i < N, i++, v[i]) == 24);
    CHECKTRUE(P(int i = 1, i < 0, i++, v[i]) == 1);

    CHECKTRUE(P(int i = 0, i < N, i++, fv[i]) == fvprod);
    CHECKTRUE(P(int i = 0, i < 0, i++, fv[i]) == 1.0);
    

    CHECKMESSAGE("** check out nesting of operations");
    
    CHECKTRUE(A(int i = 0, i < N, i++,
		A(int j = 0, j < N, j++, 
		  m[i][j] == ((i == j) ? 1 : 0))));

    CHECKFALSE(A(int i = 0, i < N, i++,
		A(int j = 0, j < N, j++, 
		  m[i][j] == 0)));

    CHECKTRUE(A(int i = 0, i < N, i++,
		E(int j = 0, j < N, j++, 
		  m[i][j] == 1)));

    CHECKFALSE(E(int i = 0, i < N, i++,
		E(int j = 0, j < N, j++, 
		  m[i][j] == 2)));

    CHECKTRUE(A(int i = 0, i < N, i++,
		E1(int j = 0, j < N, j++, 
		  m[i][j] == 1)));

    CHECKFALSE(A(int i = 0, i < N, i++,
		E1(int j = 0, j < N, j++, 
		  m[i][j] == 2)));

    CHECKFALSE(A(int i = 0, i < N, i++,
		E1(int j = 0, j < N, j++, 
		  m[i][j] == 0)));

    CHECKFALSE(A(int i = 0, i < N, i++,
		E1(int j = 0, j < N, j++, 
		  m[i][j] == 4)));

    CHECKTRUE(S(int i = 0, i < N, i++,
	     S(int j = 0, j < N, j++, m[i][j])) == N);

    CHECKTRUE(P(int i = 0, i < N, i++,
	     S(int j = 0, j < N, j++, m[i][j])) == 1);

    CHECKTRUE(C(int i = 0, i < N, i++,
	     S(int j = 0, j < N, j++, m[i][j]) == 1) == N);

    CHECKTRUE(C(int i = 0, i < N, i++,
	     S(int j = 0, j < N, j++, m[i][j]) == 2) == 0);

    CHECKTRUE(A(int i = 0, i < N, i++,
	     C(int j = 0, j < N, j++, m[i][j] == 1)));
    
    CHECKMESSAGE("** test A(..)||E(..)");

#define T E(int i = 0, i < N, i++, v[i] == 1)
#define F A(int i = 0, i < N, i++, v[i] > i)

    CHECKTRUE(T && T);
    CHECKTRUE(T && 1);
    CHECKTRUE(!(F) && T);
    CHECKTRUE(F || T);
    CHECKTRUE(F || 1);
    CHECKTRUE(T || 1);
    CHECKTRUE(T && T && T && (!(F)) && 1);
    CHECKTRUE(T && T && T && T && T && (T || F));

    CHECKFALSE(F && T);
    CHECKFALSE(T && F);
    CHECKFALSE(T && 0);
    CHECKFALSE(!(F) && F);
    CHECKFALSE(F ? T : 0 );
    CHECKFALSE(F && F);
    CHECKFALSE(F || F);
    CHECKFALSE(T && T && T && F && 1);
    CHECKFALSE(T && T && T && F);


    /* perhaps some random sentence generator based bash testing? */

    return 0;
}

