/*
 * L_buffer.c - test out the L_buffer code.
 * 
 * Copyright (c) 1997 Phil Maker
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 *
 * $Id: L_buffer.c,v 1.2 1997/10/26 05:47:50 pjm Exp $
 */

#include <stdio.h> /* N.B. this isn't include automatically */
#include "nana.h"
#include "L_buffer.h"

int main() {
  L_BUFFER *tiny = L_buffer_create(8); 
  L_BUFFER *small = L_buffer_create(80); 
  L_BUFFER *large = L_buffer_create(16*1024);
  int i;

  /* check allocation of store */
  I(small != NULL);
  I(large != NULL);

  printf("0. dump both buffers which should be empty!\n"); 
  printf(" small =\n");
  L_buffer_dump(small,stdout);
  printf(" large =\n");
  L_buffer_dump(large,stdout);

  printf("1. Add 's' to small, 'l' to large using L_buffer_putchar\n");
  L_buffer_putchar(small,'s');
  L_buffer_putchar(large,'l');
  printf(" small =\n");
  L_buffer_dump(small,stdout);
  printf(" large =\n");
  L_buffer_dump(large,stdout);

  printf("2. Add 1..10 each on a single line to large using\n");
  printf("   L_buffer_printf and then dump it\n");
  for(i = 1; i <= 10; i++) {
    L_buffer_printf(large,"%d\n", i);
  }
  printf(" large =\n");
  L_buffer_dump(large,stdout);

  printf("3. Add 'x= 1..10000' each on a single line to small using\n");
  printf("   L_buffer_printf and then dump it\n");
  for(i = 1; i <= 10000; i++) {
    L_buffer_printf(small,"x= %d\n", i);
  }
  printf(" small =\n");
  L_buffer_dump(small,stdout);

  printf("4. Clear large log + add 10 'messages' to large using\n");
  printf("   L_buffer_puts and then dump it\n");
  L_buffer_clear(large);
  for(i = 1; i <= 10; i++) {
    /* Note: L_buffer_puts does NOT add a newline automatically */
    /* i.e. like fputs rather than puts */
    L_buffer_puts(large,"messages\n");
  }
  printf(" large =\n");
  L_buffer_dump(large,stdout);

  /* check wraparound */
  printf("5. wraparound off, send of lots of chars, expect 1..8\n");
  L_buffer_wraparound(tiny,0);
  L_buffer_printf(tiny,"12345678---------");
  L_buffer_dump(tiny,stdout);
  
  return 0;
}
