/*
 * L_times.c - test out the L_times component.
 * 
 * Copyright (c) 1997 Phil Maker
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 *
 * $Id: L_times.c,v 1.1.1.1 1997/11/23 11:45:50 pjm Exp $
 */

#include <stdio.h>

#include "../src/L_times.h"

L_TIMES *p;

int
main() {
  int i; 
  double t = 1.0; 


  printf("* L_times - testing L_times buffer\n");
  printf("** L_times_create(10)\n");
  p = L_times_create(10);
  printf("** Empty buffer\n");
  L_times_dump(p,stdout);
  printf("** Add one message\n");
  L_times_add(p, "Reactor is too hot", t+= 0.1);
  L_times_dump(p,stdout);
  printf("** Add 100 messages and dump\n");
  for(i = 0; i != 100; i++) {
    L_times_add(p, "Flow rate high", t += 0.3);
  }
  L_times_dump(p,stdout);
  printf("** Clear buffer\n");
  L_times_clear(p);
  L_times_dump(p,stdout);
  printf("** Set no wraparound\n");
  L_times_wraparound(p,0);
  printf("** Add 100 samples at t = 0..100\n");
  for(i = 0, t = 0.0; i != 100; i++, t += 1.0) {
    L_times_add(p, "World is flat", t);
  }
  L_times_dump(p,stdout);

  printf("L_times_delete\n");
  L_times_delete(p);
  
  return 0;
}
