/*
 * nana-config.h.in - contains configure generated parameters for nana which
 *    are mostly based on the canonical host type (sparc-sun-sunos4.1.4). 
 *
 * Note: the generated file (nana-config.h) can be (and is expected to be)
 *    edited by the user and kept in a local per project directory where 
 *    the include path will find it before the default system. DO NOT modify
 *    the nana-config.h in the standard include location since it will be 
 *    overwritten on the next configure.
 * 
 * Copyright (c) 1997 Phil Maker
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 *
 * $Id: nana-config.h.in,v 1.1.1.1 1997/11/23 11:45:50 pjm Exp $
 */

#ifndef _nana_config_h_
#define _nana_config_h_ 1

#define NANA_VERSION "2.0"
#define NANA_NAME "nana-2.0"

/*
 * The following definitions are generated by configure
 * based on the machine architecture and os. 
 */

#ifndef DI_MAKE_VALID_BREAKPOINT
#define DI_MAKE_VALID_BREAKPOINT(exprn) asm("nop")
#endif

#ifndef DL_MAKE_VALID_BREAKPOINT
#define DL_MAKE_VALID_BREAKPOINT() asm("nop")
#endif

#ifndef I_DEFAULT_HANDLER

#endif

/*
 * ALWAYS_INCLUDE_MALLOC - the following contortions arise thusly.
 *
 * 1. gdb requires malloc() to do some of its magic.
 * 2. on almost ALL machines using <stdio.h> brings in malloc 
 *    so happiness follows.
 * 3. except that on linux we don't get malloc() along with <stdio.h>
 *    automatically.
 * 
 * Current answer to this problem: make a reference to malloc from
 *    this header file to bring it in automatically (only on i386's Linux
 *    though).
 * 
 * Alternatives: just forget about the problem and put a call to malloc()
 *    in the checking programs.
 * 
 * The current answer is NOT a good one
 */

#define ALWAYS_INCLUDE_MALLOC/* no arguments */ 0
#if ALWAYS_INCLUDE_MALLOC
#include <stdlib.h> /* including stdlib.h brings in lots of rubbish */

static void *_nana_p = malloc; /* this costs us storage space */
#endif

#endif /* _nana_config_h_ */


