/*
 * cycles.c - test out the cycles.h library
 * 
 * Copyright (c) 1998 Phil Maker <pjm@gnu.org>
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 *
 * $Id$
 */

#include <stdio.h>
#include "../src/cycles.h"
#include "../src/now.h"

#if HAVE_CYCLES == 0

main() {
  printf("* cycles.c - testing out cycle level counting\n");
  printf("cycle counting not supported for this configuration\n");
  printf("  use ./configure --help for more information\n");
  printf("  e.g. ./configure --enable-rdtsc on pentiums\n");

  return 0;
}

#else

void arithmetic();

main() {
  double d;
  int nt, ns;
  CYCLES cps;

  printf("* cycles.c - testing out cycle level counting\n");

  printf("** test various calibration parameters\n");
#define CALIB_TRIAL(dur,nt) \
  do { \
   printf("cycles_per_second(%f,%d) = %qu cps", dur, nt, \
      cycles_per_second(dur,nt)); \
   printf(", max-min= %qu cps\n", \
	  cycles_per_second_max() - cycles_per_second_min()); \
  } while(0)

  CALIB_TRIAL(0.1,10);
  CALIB_TRIAL(0.5,4);
  CALIB_TRIAL(1.0,4);
  CALIB_TRIAL(1.0,16);
  CALIB_TRIAL(32.0,4);

  printf("** comparing it to sleep(n)\n");
#define SLEEP_TRIAL(n) \
  do { \
    CYCLES s, e; \
    double sn, en; \
    sn = now(); \
    s = cycles(); \
    sleep(n) ; \
    en = now(); \
    e = cycles(); \
    printf("sleep(%d), now(..) = %fs, cycles_diff(..) %f, error = %f\n", \
      n, en - sn, cycles_diff(s,e), \
      (en - sn) - cycles_diff(s,e)); \
  } while(0)

  printf("Note the errors in the following test should grow linearly\n");
  SLEEP_TRIAL(1);
  SLEEP_TRIAL(4);
  SLEEP_TRIAL(8);
  SLEEP_TRIAL(16);
  SLEEP_TRIAL(32);
  SLEEP_TRIAL(64);

  return 0;
}

#endif /* HAVE_CYCLES */
  





