/*-GNU-GPL-BEGIN-*
nepim - network pipemeter
Copyright (C) 2005 Everton da Silva Marques

nepim is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2, or (at your option)
any later version.

nepim is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with nepim; see the file COPYING.  If not, write to
the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
Boston, MA 02111-1307, USA.
*-GNU-GPL-END-*/


/* $Id: session.c,v 1.3 2005/08/12 23:30:58 evertonm Exp $ */

#include <assert.h>

#include "session.h"

void nepim_session_init(nepim_session_t *session, const nepim_greet_t *opt,
			nepim_session_type type, int index)
{
  switch(type) {
  case SESSION_PIPE:
    session->index.pipe_sd = index;
    break;
  case SESSION_SLOT:
    session->index.slot = index;
    break;
  default:
    assert(0);
  }

  session->type               = type;

  session->must_send             = opt->must_send;
  session->max_bit_rate          = opt->bit_rate;
  session->stat_interval         = opt->stat_interval;
  session->test_duration         = opt->test_duration;
  session->write_delay           = opt->write_delay;
  session->udp_keepalive_send    = opt->udp_keepalive_send;
  session->udp_keepalive_require = opt->udp_keepalive_require;

  session->duration_done      = 0;
  session->total_reads        = 0;
  session->total_writes       = 0;
  session->interval_reads     = 0;
  session->interval_writes    = 0;
  session->byte_total_sent    = 0;
  session->byte_total_recv    = 0;
  session->byte_interval_sent = 0;
  session->byte_interval_recv = 0;
}

