/*-GNU-GPL-BEGIN-*
nepim - network pipemeter
Copyright (C) 2005 Everton da Silva Marques

nepim is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2, or (at your option)
any later version.

nepim is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with nepim; see the file COPYING.  If not, write to
the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
Boston, MA 02111-1307, USA.
*-GNU-GPL-END-*/


/* $Id: session.h,v 1.9 2005/08/17 02:24:29 evertonm Exp $ */

#ifndef NEPIM_SESSION_H
#define NEPIM_SESSION_H

#include <sys/socket.h>
#include <netinet/in.h>
#include <sys/time.h>

#include "greet.h"

typedef enum { SESSION_PIPE, SESSION_SLOT } nepim_session_type;

typedef struct nepim_session_t nepim_session_t;

struct nepim_session_t {

  nepim_session_type type;
  union {
    int pipe_sd; /* map socket descriptor to pipe */
    int slot;    /* map slot index        to slot */
  } index;

  union {
    struct sockaddr_in inet;
    struct sockaddr_in6 inet6;
  }         remote;
  socklen_t remote_len;

  int must_send;
  long long max_bit_rate;
  int max_pkt_rate;
  int stat_interval;
  int test_duration;
  suseconds_t write_delay; /* usec, used when max_bit_rate > 0 */
  int duration_done;       /* boolean */
  int udp_keepalive_send;  /* boolean, non-senders */
  int udp_keepalive_require; /* boolean, receivers */

  int rate_remaining;        /* bytes, used when max_bit_rate > 0 */
  int pkt_remaining;         /* pkts, used when max_pkt_rate > 0 */

  int total_reads;
  int total_writes;
  int interval_reads;
  int interval_writes;

  long long byte_total_sent;
  long long byte_total_recv;

  long long byte_interval_sent;
  long long byte_interval_recv;

  struct timeval tv_duration;
  struct timeval tv_interval;
  struct timeval tv_start;
  struct timeval tv_send_rate;
  struct timeval tv_greet_rate; /* udp client */
  struct timeval tv_keepalive; /* udp non-sender keepalive period */
  struct timeval tv_keepalive_timer; /* udp keepalive receiver */
};

void nepim_session_init(nepim_session_t *session, const nepim_greet_t *opt,
			const struct sockaddr *remote, socklen_t remote_len,
			nepim_session_type type, int index);

void nepim_session_write_add(nepim_session_t *session, int len);
void nepim_session_read_add(nepim_session_t *session, int len);

#endif /* NEPIM_SESSION_H */

