/*-GNU-GPL-BEGIN-*
nepim - network pipemeter
Copyright (C) 2005 Everton da Silva Marques

nepim is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2, or (at your option)
any later version.

nepim is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with nepim; see the file COPYING.  If not, write to
the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
Boston, MA 02111-1307, USA.
*-GNU-GPL-END-*/


/* $Id: usock.h,v 1.5 2005/08/04 22:38:11 evertonm Exp $ */

#ifndef NEPIM_USOCK_H
#define NEPIM_USOCK_H

#include "array.h"

typedef struct nepim_usock_t nepim_usock_t;

typedef struct nepim_usock_set_t nepim_usock_set_t;

/*
  UDP socket info
 */
struct nepim_usock_t {
  int readers;
  int writers;
  int write_soft_errors;
  int read_soft_errors;
  int good_writes;
  int good_reads;
};

struct nepim_usock_set_t {
  nepim_array_t array;
};

void nepim_usock_set_init(nepim_usock_set_t *set);

nepim_usock_t *nepim_usock_set_get(const nepim_usock_set_t *set, int index);

void nepim_usock_set_add(nepim_usock_set_t *set, int index);

void nepim_usock_set_del(nepim_usock_set_t *set, int index);

int nepim_usock_writer_add(nepim_usock_set_t *set, int index);
int nepim_usock_writer_del(nepim_usock_set_t *set, int index);
int nepim_usock_reader_add(nepim_usock_set_t *set, int index);
int nepim_usock_reader_del(nepim_usock_set_t *set, int index);

void nepim_usock_write_error(nepim_usock_set_t *set, int index,
			     int local_slot, int remote_slot,
			     int err_no);
void nepim_usock_read_error(nepim_usock_set_t *set, int index,
			    int err_no);
void nepim_usock_write_good(nepim_usock_set_t *set, int index);
void nepim_usock_read_good(nepim_usock_set_t *set, int index);

#endif /* NEPIM_USOCK_H */

