/*-GNU-GPL-BEGIN-*
nepim - network pipemeter
Copyright (C) 2005 Everton da Silva Marques

nepim is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2, or (at your option)
any later version.

nepim is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with nepim; see the file COPYING.  If not, write to
the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
Boston, MA 02111-1307, USA.
*-GNU-GPL-END-*/

/* $Id: win.c,v 1.2 2005/09/02 11:59:24 evertonm Exp $ */

#include <stdio.h>
#include <assert.h>

#include "win.h"

void nepim_win_init(nepim_win_t *win, uint32_t max_size)
{
  assert(max_size > 0);
  
  nepim_bit_init(&win->bit_set, max_size);

  win->seq_begin  = 0;
  win->seq_expect = 0;
  win->max_size   = max_size;
}

void nepim_win_del(nepim_win_t *win)
{
  nepim_bit_del(&win->bit_set);
}

static void advance_begin(nepim_win_t *win, int end)
{
  int begin;

  assert(end >= 0);
  assert(end < win->max_size);
  assert(end >= (win->seq_begin % win->max_size));

  for (;;) {
    begin = win->seq_begin % win->max_size;
    if (begin > end)
      break;
    if (!nepim_bit_isset(&win->bit_set, begin))
      break;

    nepim_bit_clear(&win->bit_set, begin);
    ++win->seq_begin;
  }

  assert(win->seq_begin >= 0);
  assert(win->seq_begin < win->max_size);
  assert(end >= (win->seq_begin % win->max_size));
}

static int push_begin(nepim_win_t *win, uint32_t seq)
{
  assert(0);
  return 0;
}

int nepim_win_add(nepim_win_t *win, uint32_t seq, int *lost, int *dup)
{
  int begin;
  int expect;

  assert(win->seq_begin <= win->seq_expect);
  assert(lost);
  assert(dup);
  assert(*lost >= 0);
  assert(*dup >= 0);

  return 0;

  if (seq < win->seq_begin) {
    fprintf(stderr, 
	    "DEBUG %s %s: ignoring seq=%u lower than seq_begin=%u\n",
	    __FILE__, __PRETTY_FUNCTION__,
	    seq, win->seq_begin);
    return -1;
  }

  /* wrap into bit vector size */
  begin = win->seq_begin % win->max_size;
  expect = win->seq_expect % win->max_size;
  seq %= win->max_size;

  /* dup? */
  if (nepim_bit_isset(&win->bit_set, seq)) {
    ++*dup;
    return 0;
  }

  nepim_bit_set(&win->bit_set, seq);

  if (begin > expect) {

    assert(0);

    return 0;
  }

  assert(begin <= expect);

  /* expected? */
  if (seq >= expect) {
    win->seq_expect += expect - seq;

    /* window overflow? */
    if ((win->seq_expect % win->max_size) < begin)
      *lost += push_begin(win, win->seq_expect);

    return 0;
  }

  assert(seq < expect);

  advance_begin(win, expect);

  return 0;
}

