/*-GNU-GPL-BEGIN-*
nepim - network pipemeter
Copyright (C) 2005 Everton da Silva Marques

nepim is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2, or (at your option)
any later version.

nepim is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with nepim; see the file COPYING.  If not, write to
the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
Boston, MA 02111-1307, USA.
*-GNU-GPL-END-*/

/* $Id: win.h,v 1.1 2005/08/18 21:59:11 evertonm Exp $ */

#ifndef NEPIM_WIN_H
#define NEPIM_WIN_H

#include "int.h"
#include "bit.h"

typedef struct nepim_win_t nepim_win_t;

struct nepim_win_t {
  nepim_bit_t bit_set;
  uint32_t    seq_begin;
  uint32_t    seq_expect;
  int         max_size;
};

void nepim_win_init(nepim_win_t *win, uint32_t max_size);
void nepim_win_del(nepim_win_t *win);

int nepim_win_add(nepim_win_t *win, uint32_t seq, int *lost, int *dup);

#endif /* NEPIM_WIN_H */
