/*-GNU-GPL-BEGIN-*
nepim - network pipemeter
Copyright (C) 2005 Everton da Silva Marques

nepim is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2, or (at your option)
any later version.

nepim is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with nepim; see the file COPYING.  If not, write to
the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
Boston, MA 02111-1307, USA.
*-GNU-GPL-END-*/


/* $Id: array.h,v 1.2 2005/09/18 18:28:51 evertonm Exp $ */

#ifndef NEPIM_ARRAY_H
#define NEPIM_ARRAY_H

typedef struct nepim_array_t nepim_array_t;

struct nepim_array_t {
  void **head;
  int  capacity;
};

void nepim_array_init(nepim_array_t *array);
void nepim_array_delete(nepim_array_t *array);

void *nepim_array_get(const nepim_array_t *array, int index);
void *nepim_array_search(const nepim_array_t *array, int index);
void *nepim_array_find(const nepim_array_t *array,
		       int (*detector)(const void *context,
				       const void *element),
		       const void *context);
int nepim_array_find_free(nepim_array_t *array);

void nepim_array_add(nepim_array_t *array, int index, void *value);
void nepim_array_del(nepim_array_t *array, int index);

#endif /* NEPIM_ARRAY_H */
