/*-GNU-GPL-BEGIN-*
nepim - network pipemeter - measuring network bandwidth between hosts
Copyright (C) 2005  Everton da Silva Marques

This program is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2 of the License, or (at
your option) any later version.

This program is distributed in the hope that it will be useful, but
WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; see the file COPYING; if not, write to the
Free Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston,
MA 02110-1301 USA
*-GNU-GPL-END-*/

/* $Id: int.c,v 1.3 2005/11/04 09:56:14 evertonm Exp $ */


#include <assert.h>

#include "int.h"


void nepim_int_sanity()
{
  assert(sizeof(uint8_t)  == 1);
  assert(sizeof(uint16_t) == 2);
  assert(sizeof(uint32_t) == 4);
}

uint16_t nepim_uint16_read(const char *buf)
{
  uint16_t value;

  value = ((const uint8_t *) buf)[0];
  value *= 256;
  value += ((const uint8_t *) buf)[1];

  return value;
}

uint32_t nepim_uint32_read(const char *buf)
{
  uint32_t value;

  value = ((const uint8_t *) buf)[0];
  value *= 256;
  value += ((const uint8_t *) buf)[1];
  value *= 256;
  value += ((const uint8_t *) buf)[2];
  value *= 256;
  value += ((const uint8_t *) buf)[3];

  return value;
}

void nepim_uint16_write(char *buf, uint16_t value)
{
  ((uint8_t *) buf)[0] = value / 256;
  ((uint8_t *) buf)[1] = value % 256;
}

void nepim_uint32_write(char *buf, uint32_t value)
{
  int i;

  for (i = 3; i >= 0; --i, value /= 256)
    ((uint8_t *) buf)[i] = value % 256;
}
