/*-GNU-GPL-BEGIN-*
nepim - network pipemeter
Copyright (C) 2005 Everton da Silva Marques

nepim is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2, or (at your option)
any later version.

nepim is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with nepim; see the file COPYING.  If not, write to
the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
Boston, MA 02111-1307, USA.
*-GNU-GPL-END-*/


/* $Id: common.c,v 1.16 2005/07/27 12:01:46 evertonm Exp $ */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <assert.h>

#include "common.h"
#include "sock.h"
#include "conf.h"


const char * const NEPIM_LABEL_PARTIAL      = "part";
const char * const NEPIM_LABEL_TOTAL        = "avg";
const char * const NEPIM_LABEL_TOTAL_BROKEN = "avg(broken)";


const char *nepim_version()
{
  return "0.9";
}

static void nepim_dump_stat(FILE *out, const char *label,
			    long long bytes_recv, long long bytes_sent, 
			    float interval, long sec_start, 
			    long sec_duration, int reads, int writes)
{
  float kbps_recv = bytes_recv / (interval * 125); /* 8/1000 = 1/125 */
  float kbps_sent = bytes_sent / (interval * 125); /* 8/1000 = 1/125 */
  float read_rate = reads / interval;
  float write_rate = writes / interval;
  struct timeval now;
  int result;
      
  result = gettimeofday(&now, 0);
  assert(!result);

  fprintf(out,
	  ": %s %ld/%ld kbps_in=%.2f kbps_out=%.2f rcv/s=%.2f snd/s=%.2f\n", 
	  label,
	  now.tv_sec - sec_start,
	  sec_duration,
	  kbps_recv,
	  kbps_sent,
	  read_rate,
	  write_rate);
}

void nepim_pipe_stat(FILE *out, const char *label, int sd,
		     long long bytes_recv, long long bytes_sent, 
		     float interval, long sec_start, 
		     long sec_duration, int reads, int writes)
{
  fprintf(out, "%d", sd);

  nepim_dump_stat(out, label, bytes_recv, bytes_sent, 
		  interval, sec_start, sec_duration,
		  reads, writes);
}

void nepim_slot_stat(FILE *out, const char *label, int sd,
		     int local_slot, int remote_slot,
		     long long bytes_recv, long long bytes_sent, 
		     float interval, long sec_start, 
		     long sec_duration, int reads, int writes)
{
  fprintf(out, "%d %d-%d", sd, local_slot, remote_slot);

  nepim_dump_stat(out, label, bytes_recv, bytes_sent, 
		  interval, sec_start, sec_duration,
		  reads, writes);
}

void report_broken_pipe_stat(FILE *out, const nepim_pipe_t *pipe)
{
  struct timeval now;
  int result;
  float elapsed_sec;
  float elapsed_usec;
  float elapsed;
  const nepim_session_t *session = &pipe->session;
      
  result = gettimeofday(&now, 0);
  assert(!result);

  elapsed_sec = now.tv_sec - session->tv_start.tv_sec;
  elapsed_usec = now.tv_usec - session->tv_start.tv_usec;

  elapsed = elapsed_sec + elapsed_usec / 1000000;

  nepim_pipe_stat(out, 
		  NEPIM_LABEL_TOTAL_BROKEN,
		  pipe->sd, 
		  session->byte_total_recv,
		  session->byte_total_sent,
		  elapsed, 
		  session->tv_start.tv_sec,
		  session->test_duration,
		  session->total_reads,
		  session->total_writes);
}

void report_broken_slot_stat(FILE *out, const nepim_slot_t *slot)
{
  struct timeval now;
  int result;
  float elapsed_sec;
  float elapsed_usec;
  float elapsed;
  const nepim_session_t *session = &slot->session;
      
  result = gettimeofday(&now, 0);
  assert(!result);

  elapsed_sec = now.tv_sec - session->tv_start.tv_sec;
  elapsed_usec = now.tv_usec - session->tv_start.tv_usec;

  elapsed = elapsed_sec + elapsed_usec / 1000000;

  nepim_slot_stat(out, 
		  NEPIM_LABEL_TOTAL_BROKEN,
		  slot->udp_sd,
		  slot->index, 
		  slot->index_remote,
		  session->byte_total_recv,
		  session->byte_total_sent,
		  elapsed, 
		  session->tv_start.tv_sec,
		  session->test_duration,
		  session->total_reads,
		  session->total_writes);
}
