/*-GNU-GPL-BEGIN-*
nepim - network pipemeter
Copyright (C) 2005 Everton da Silva Marques

nepim is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2, or (at your option)
any later version.

nepim is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with nepim; see the file COPYING.  If not, write to
the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
Boston, MA 02111-1307, USA.
*-GNU-GPL-END-*/


/* $Id: pipe.c,v 1.4 2005/07/26 11:41:50 evertonm Exp $ */

#include <stdlib.h>
#include <stdio.h>
#include <assert.h>

#include "pipe.h"

void nepim_pipe_set_init(nepim_pipe_set_t *set)
{
  nepim_array_init(&set->array);
}

nepim_pipe_t *nepim_pipe_set_get(const nepim_pipe_set_t *set, int sd)
{
  return nepim_array_get(&set->array, sd);
}

void nepim_pipe_set_add(nepim_pipe_set_t *set, int sd, 
			const nepim_greet_t *opt)
{
  nepim_pipe_t *pipe = malloc(sizeof(nepim_pipe_t));
  assert(pipe);

  pipe->sd = sd;
  nepim_session_init(&pipe->session, opt, SESSION_PIPE, sd);

  nepim_array_add(&set->array, sd, pipe);
}

void nepim_pipe_set_del(nepim_pipe_set_t *set, int sd)
{
  nepim_pipe_t *pipe = nepim_pipe_set_get(set, sd);
  assert(pipe);
  free(pipe);
  nepim_array_del(&set->array, sd);
}

