/*-GNU-GPL-BEGIN-*
nepim - network pipemeter
Copyright (C) 2005 Everton da Silva Marques

nepim is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2, or (at your option)
any later version.

nepim is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with nepim; see the file COPYING.  If not, write to
the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
Boston, MA 02111-1307, USA.
*-GNU-GPL-END-*/


/* $Id: slot.c,v 1.6 2005/07/26 11:41:50 evertonm Exp $ */

#include <stdlib.h>
#include <string.h>
#include <assert.h>

#include "slot.h"

void nepim_slot_set_init(nepim_slot_set_t *set)
{
  nepim_array_init(&set->array);
}

nepim_slot_t *nepim_slot_set_get(const nepim_slot_set_t *set, int index)
{
  return nepim_array_get(&set->array, index);
}

nepim_slot_t *nepim_slot_set_search(const nepim_slot_set_t *set, int index)
{
  return nepim_array_search(&set->array, index);
}

int nepim_slot_find_free(nepim_slot_set_t *set)
{
  return nepim_array_find_free(&set->array);
}

void nepim_slot_set_add(nepim_slot_set_t *set, int sd,
			int index, int index_remote,
			const struct sockaddr *remote,
			socklen_t remote_len,
			const nepim_greet_t *opt)
{
  nepim_slot_t *slot = malloc(sizeof(nepim_slot_t));
  assert(slot);
  
  slot->index        = index;
  slot->index_remote = index_remote;
  slot->udp_sd       = sd;
  slot->seq          = 0;
  
  assert(sizeof(slot->remote) >= remote_len);
  memcpy(&slot->remote, remote, remote_len);
  slot->remote_len = remote_len;
  
  nepim_session_init(&slot->session, opt, SESSION_SLOT, index);
  
  nepim_array_add(&set->array, index, slot);
}

void nepim_slot_set_del(nepim_slot_set_t *set, int index)
{
  nepim_slot_t *slot = nepim_slot_set_get(set, index);
  assert(slot);
  free(slot);
  nepim_array_del(&set->array, index);
}

