/*-GNU-GPL-BEGIN-*
nepim - network pipemeter
Copyright (C) 2005 Everton da Silva Marques

nepim is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2, or (at your option)
any later version.

nepim is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with nepim; see the file COPYING.  If not, write to
the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
Boston, MA 02111-1307, USA.
*-GNU-GPL-END-*/


#ifndef NEPIM_SOCK_H
#define NEPIM_SOCK_H

#include <sys/types.h>
#include <sys/socket.h>

int nepim_socket_nonblock(int sd);
int nepim_socket_block(int sd);
int nepim_socket_ttl(int sd, int ttl);
int nepim_socket_mcast_ttl(int sd, int mcast_ttl);
int nepim_socket_pmtu(int sd, int pmtu_mode);
int nepim_socket_opt(int sd, int pmtu_mode, int ttl);
int nepim_socket_tcp_opt(int sd);

int nepim_socket_pmtu_get_mode(int sd);
int nepim_socket_pmtu_get_mtu(int sd);
int nepim_socket_get_ttl(int sd);

int nepim_create_socket(struct sockaddr *addr,
			int addr_len,
			int family,
			int type,
			int protocol,
			int pmtu_mode,
			int ttl,
			int mcast_join);
int nepim_create_listener_socket(struct sockaddr *addr,
				 int addr_len,
				 int family,
				 int type,
				 int protocol,
				 int backlog,
				 int pmtu_mode,
				 int ttl);
int nepim_connect_client_socket(struct sockaddr *addr,
				int addr_len,
				int family,
				int type,
				int protocol,
				int pmtu_mode,
				int ttl);

void nepim_sock_show_opt(FILE *out, int sd);

#endif /* NEPIM_SOCK_H */

