/*-GNU-GPL-BEGIN-*
nepim - network pipemeter
Copyright (C) 2005 Everton da Silva Marques

nepim is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2, or (at your option)
any later version.

nepim is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with nepim; see the file COPYING.  If not, write to
the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
Boston, MA 02111-1307, USA.
*-GNU-GPL-END-*/


/* $Id: udp_client.c,v 1.11 2005/07/27 19:47:15 evertonm Exp $ */


#include <stdio.h>
#include <string.h>
#include <sys/types.h>
#include <sys/socket.h>
#include <netdb.h>
#include <assert.h>

#include "conf.h"
#include "sock.h"
#include "pipe.h"
#include "common.h"
#include "usock.h"

extern nepim_slot_set_t slots;    /* from server.c */
extern nepim_usock_set_t udp_tab; /* from server.c */

static void *on_udp_time_greet(oop_source *src, struct timeval tv,
			       void *user)
{
  nepim_slot_t *slot = user;
  assert(slot);

  assert(0);

  return OOP_CONTINUE;
}

static void *on_udp_read_segment(oop_source *src, int sd,
				 oop_event event, void *user)
{
  assert(!user);

  assert(0);

  return OOP_CONTINUE;
}

static int spawn_udp_connection(struct sockaddr *remote, 
				socklen_t *remote_len)
{
  struct addrinfo hints;
  struct addrinfo *ai_res;
  struct addrinfo *ai;
  int result;
  int sd = -1;

  hints.ai_socktype = SOCK_DGRAM;
  hints.ai_protocol = IPPROTO_UDP;
  hints.ai_flags = AI_CANONNAME;
  hints.ai_family = PF_UNSPEC;
  hints.ai_addrlen = 0;
  hints.ai_addr = 0;
  hints.ai_canonname = 0;

  fprintf(stderr, 
	  "UDP socket solving %s,%s\n",
	  nepim_global.hostname, nepim_global.portname);

  result = getaddrinfo(nepim_global.hostname, nepim_global.portname,
		       &hints, &ai_res);
  if (result) {
    fprintf(stderr, "getaddrinfo(%s,%s): %s\n",
            nepim_global.hostname, nepim_global.portname,
	    gai_strerror(result));
    return -1;
  }

  for (ai = ai_res; ai; ai = ai->ai_next) {

    fprintf(stderr, 
	    "UDP socket trying %s,%s\n",
	    nepim_global.hostname, nepim_global.portname);

    if (nepim_global.no_inet6 && (ai->ai_family == PF_INET6))
      continue;

    sd = nepim_connect_client_socket(ai->ai_addr, ai->ai_addrlen,
				     ai->ai_family, ai->ai_socktype, 
				     ai->ai_protocol,
				     nepim_global.pmtu_mode,
				     nepim_global.ttl);
    if (sd < 0) {
      fprintf(stderr, 
	      "could not connect UDP socket to %s,%s: %d\n",
	      nepim_global.hostname, nepim_global.portname, sd);
      continue;
    }

    assert(*remote_len >= ai->ai_addrlen);
    memcpy(remote, ai->ai_addr, ai->ai_addrlen);
    *remote_len = ai->ai_addrlen;

    fprintf(stderr, 
	    "%d: UDP socket connected to: "
	    "host=%s,%s len=%d family=%d type=%d proto=%d\n",
	    sd, nepim_global.hostname, nepim_global.portname, 
	    ai->ai_addrlen, ai->ai_family, 
	    ai->ai_socktype, ai->ai_protocol);

    break;
  }

  freeaddrinfo(ai_res);

  return sd;
}

void nepim_udp_clients()
{
  union {
    struct sockaddr_in inet;
    struct sockaddr_in6 inet6;
  } remote;
  int remote_len = sizeof(remote);
  int i;
  int sd;
  nepim_greet_t opt;

  /* create UDP socket */
  sd = spawn_udp_connection((struct sockaddr *) &remote, &remote_len);
  if (sd < 0)
    return;

  opt.must_send     = nepim_global.duplex_mode || nepim_global.simplex_client_send;
  opt.bit_rate      = nepim_global.bit_rate;
  opt.stat_interval = nepim_global.stat_interval;
  opt.test_duration = nepim_global.test_duration;
  opt.write_delay   = nepim_global.write_delay;

  /* create UDP slots */
  for (i = 0; i < nepim_global.pipes; ++i) {
    int local_slot = nepim_slot_find_free(&slots);
    int remote_slot = 0xFFFF;

    nepim_slot_set_add(&slots, sd, 
		       local_slot, remote_slot,
		       (const struct sockaddr *) &remote,
		       remote_len, &opt);

    fprintf(stderr, "%d %d-%d: DEBUG FIXME\n",
	    sd, local_slot, remote_slot);
  }

  /* activate UDP socket */

  for (i = 0; i < slots.array.capacity; ++i) {
    nepim_slot_t *slot = nepim_slot_set_get(&slots, i);
    nepim_session_t *session;

    if (!slot)
      continue;

    session = &slot->session;

    /* 
       schedule periodic greetings 
       (until answer from server)
     */
    session->tv_rate = OOP_TIME_NOW;
    nepim_global.oop_src->on_time(nepim_global.oop_src,
				  session->tv_rate,
				  on_udp_time_greet, slot);
  }

  /* wait answers */
  nepim_global.oop_src->on_fd(nepim_global.oop_src,
			      sd, OOP_READ,
			      on_udp_read_segment, 0);
}
