/**  Skeleton classes generated by rpcdesign.
  */

using Gee;
using zcd;

namespace Andns
{
    public class AndnaResolveDispatcher : RPCDispatcher
    {
        private IAndnaResolveRootDispatcher root;
        public AndnaResolveDispatcher(IAndnaResolveRootDispatcher root)
        {
            this.root = root;
        }

        /** This method could be called *directly* for a dispatcher that does not need to transform
          * an exception into a remotable.
          */
        public override ISerializable _dispatch(Object? caller, RemoteCall data) throws Error
        {
            string[] pieces = data.method_name.split(".");
            if (pieces[0].length > 18 && pieces[0].substring(0, 18) == "get_query_handler(")
            {
                string remaining = pieces[0].substring(18);
                string curarg = "";
                while (remaining.substring(0, 1) in "1234567890")
                {
                    curarg += remaining.substring(0, 1);
                    remaining = remaining.substring(1);
                }
                remaining = remaining.substring(1);
                int request_id = int.parse(curarg);
                if (pieces[1] == "resolve")
                {
                    if (pieces.length != 2)
                        throw new RPCError.MALFORMED_PACKET(
                            "get_query_handler(request_id).resolve is a function.");
                    if (data.parameters.size != 1)
                        throw new RPCError.MALFORMED_PACKET(
                            "get_query_handler(request_id).resolve wants 1 parameter.");
                    ISerializable iser0 = data.parameters[0];
                    if (! iser0.get_type().is_a(typeof(AndnaQuery)))
                        throw new RPCError.MALFORMED_PACKET(
                            "get_query_handler(request_id).resolve parameter 1 is not a AndnaQuery.");
                    AndnaQuery query = (AndnaQuery)iser0;
                    return root.get_query_handler(request_id).resolve(query);
                }
            }
            return base._dispatch(caller, data);
        }
    }
}
