/* network_linux.c generated by valac 0.20.1, the Vala compiler
 * generated from network_linux.vala, do not modify */

/*
 *  This file is part of Netsukuku.
 *  (c) Copyright 2011 Luca Dionisi aka lukisi <luca.dionisi@gmail.com>
 *
 *  Netsukuku is free software: you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation, either version 3 of the License, or
 *  (at your option) any later version.
 *
 *  Netsukuku is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with Netsukuku.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <tasklet.h>
#include <glib/gstdio.h>
#include <stdio.h>
#include <errno.h>
#include <gee.h>
#include <gio/gio.h>
#include <zcd.h>
#include <netsukuku-rpc.h>
#include <math.h>
#include <float.h>

#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

#define NETSUKUKU_IMPL_LINUX_TYPE_STRUCT_HELPER_NTK_LINUX_SEQUENTIAL_COMMAND (netsukuku_impl_linux_struct_helper_ntk_linux_sequential_command_get_type ())
typedef struct _NetsukukuImplLinuxstruct_helper_ntk_linux_sequential_command NetsukukuImplLinuxstruct_helper_ntk_linux_sequential_command;
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _fclose0(var) ((var == NULL) ? NULL : (var = (fclose (var), NULL)))

#define NETSUKUKU_TYPE_NIC (netsukuku_nic_get_type ())
#define NETSUKUKU_NIC(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), NETSUKUKU_TYPE_NIC, NetsukukuNIC))
#define NETSUKUKU_NIC_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), NETSUKUKU_TYPE_NIC, NetsukukuNICClass))
#define NETSUKUKU_IS_NIC(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), NETSUKUKU_TYPE_NIC))
#define NETSUKUKU_IS_NIC_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), NETSUKUKU_TYPE_NIC))
#define NETSUKUKU_NIC_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), NETSUKUKU_TYPE_NIC, NetsukukuNICClass))

typedef struct _NetsukukuNIC NetsukukuNIC;
typedef struct _NetsukukuNICClass NetsukukuNICClass;
typedef struct _NetsukukuNICPrivate NetsukukuNICPrivate;

#define NETSUKUKU_IMPL_LINUX_TYPE_LINUX_NIC (netsukuku_impl_linux_linux_nic_get_type ())
#define NETSUKUKU_IMPL_LINUX_LINUX_NIC(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), NETSUKUKU_IMPL_LINUX_TYPE_LINUX_NIC, NetsukukuImplLinuxLinuxNIC))
#define NETSUKUKU_IMPL_LINUX_LINUX_NIC_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), NETSUKUKU_IMPL_LINUX_TYPE_LINUX_NIC, NetsukukuImplLinuxLinuxNICClass))
#define NETSUKUKU_IMPL_LINUX_IS_LINUX_NIC(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), NETSUKUKU_IMPL_LINUX_TYPE_LINUX_NIC))
#define NETSUKUKU_IMPL_LINUX_IS_LINUX_NIC_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), NETSUKUKU_IMPL_LINUX_TYPE_LINUX_NIC))
#define NETSUKUKU_IMPL_LINUX_LINUX_NIC_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), NETSUKUKU_IMPL_LINUX_TYPE_LINUX_NIC, NetsukukuImplLinuxLinuxNICClass))

typedef struct _NetsukukuImplLinuxLinuxNIC NetsukukuImplLinuxLinuxNIC;
typedef struct _NetsukukuImplLinuxLinuxNICClass NetsukukuImplLinuxLinuxNICClass;
typedef struct _NetsukukuImplLinuxLinuxNICPrivate NetsukukuImplLinuxLinuxNICPrivate;
#define _g_regex_unref0(var) ((var == NULL) ? NULL : (var = (g_regex_unref (var), NULL)))
#define _g_match_info_free0(var) ((var == NULL) ? NULL : (var = (g_match_info_free (var), NULL)))

#define NETSUKUKU_IMPL_LINUX_TYPE_STRUCT_HELPER_LINUXROUTE_ACTIVATE_MULTIPATH (netsukuku_impl_linux_struct_helper_linuxroute_activate_multipath_get_type ())

#define NETSUKUKU_TYPE_ROUTE_SETTER (netsukuku_route_setter_get_type ())
#define NETSUKUKU_ROUTE_SETTER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), NETSUKUKU_TYPE_ROUTE_SETTER, NetsukukuRouteSetter))
#define NETSUKUKU_ROUTE_SETTER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), NETSUKUKU_TYPE_ROUTE_SETTER, NetsukukuRouteSetterClass))
#define NETSUKUKU_IS_ROUTE_SETTER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), NETSUKUKU_TYPE_ROUTE_SETTER))
#define NETSUKUKU_IS_ROUTE_SETTER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), NETSUKUKU_TYPE_ROUTE_SETTER))
#define NETSUKUKU_ROUTE_SETTER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), NETSUKUKU_TYPE_ROUTE_SETTER, NetsukukuRouteSetterClass))

typedef struct _NetsukukuRouteSetter NetsukukuRouteSetter;
typedef struct _NetsukukuRouteSetterClass NetsukukuRouteSetterClass;

#define NETSUKUKU_IMPL_LINUX_TYPE_LINUX_ROUTE (netsukuku_impl_linux_linux_route_get_type ())
#define NETSUKUKU_IMPL_LINUX_LINUX_ROUTE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), NETSUKUKU_IMPL_LINUX_TYPE_LINUX_ROUTE, NetsukukuImplLinuxLinuxRoute))
#define NETSUKUKU_IMPL_LINUX_LINUX_ROUTE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), NETSUKUKU_IMPL_LINUX_TYPE_LINUX_ROUTE, NetsukukuImplLinuxLinuxRouteClass))
#define NETSUKUKU_IMPL_LINUX_IS_LINUX_ROUTE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), NETSUKUKU_IMPL_LINUX_TYPE_LINUX_ROUTE))
#define NETSUKUKU_IMPL_LINUX_IS_LINUX_ROUTE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), NETSUKUKU_IMPL_LINUX_TYPE_LINUX_ROUTE))
#define NETSUKUKU_IMPL_LINUX_LINUX_ROUTE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), NETSUKUKU_IMPL_LINUX_TYPE_LINUX_ROUTE, NetsukukuImplLinuxLinuxRouteClass))

typedef struct _NetsukukuImplLinuxLinuxRoute NetsukukuImplLinuxLinuxRoute;
typedef struct _NetsukukuImplLinuxLinuxRouteClass NetsukukuImplLinuxLinuxRouteClass;
typedef struct _NetsukukuImplLinuxstruct_helper_LinuxRoute_activate_multipath NetsukukuImplLinuxstruct_helper_LinuxRoute_activate_multipath;
typedef struct _NetsukukuRouteSetterPrivate NetsukukuRouteSetterPrivate;

#define NETSUKUKU_TYPE_BASE_ROUTE_SOLUTIONS (netsukuku_base_route_solutions_get_type ())
#define NETSUKUKU_BASE_ROUTE_SOLUTIONS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), NETSUKUKU_TYPE_BASE_ROUTE_SOLUTIONS, NetsukukuBaseRouteSolutions))
#define NETSUKUKU_BASE_ROUTE_SOLUTIONS_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), NETSUKUKU_TYPE_BASE_ROUTE_SOLUTIONS, NetsukukuBaseRouteSolutionsClass))
#define NETSUKUKU_IS_BASE_ROUTE_SOLUTIONS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), NETSUKUKU_TYPE_BASE_ROUTE_SOLUTIONS))
#define NETSUKUKU_IS_BASE_ROUTE_SOLUTIONS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), NETSUKUKU_TYPE_BASE_ROUTE_SOLUTIONS))
#define NETSUKUKU_BASE_ROUTE_SOLUTIONS_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), NETSUKUKU_TYPE_BASE_ROUTE_SOLUTIONS, NetsukukuBaseRouteSolutionsClass))

typedef struct _NetsukukuBaseRouteSolutions NetsukukuBaseRouteSolutions;
typedef struct _NetsukukuBaseRouteSolutionsClass NetsukukuBaseRouteSolutionsClass;

#define NETSUKUKU_TYPE_ROUTE_SOLUTIONS (netsukuku_route_solutions_get_type ())
#define NETSUKUKU_ROUTE_SOLUTIONS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), NETSUKUKU_TYPE_ROUTE_SOLUTIONS, NetsukukuRouteSolutions))
#define NETSUKUKU_ROUTE_SOLUTIONS_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), NETSUKUKU_TYPE_ROUTE_SOLUTIONS, NetsukukuRouteSolutionsClass))
#define NETSUKUKU_IS_ROUTE_SOLUTIONS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), NETSUKUKU_TYPE_ROUTE_SOLUTIONS))
#define NETSUKUKU_IS_ROUTE_SOLUTIONS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), NETSUKUKU_TYPE_ROUTE_SOLUTIONS))
#define NETSUKUKU_ROUTE_SOLUTIONS_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), NETSUKUKU_TYPE_ROUTE_SOLUTIONS, NetsukukuRouteSolutionsClass))

typedef struct _NetsukukuRouteSolutions NetsukukuRouteSolutions;
typedef struct _NetsukukuRouteSolutionsClass NetsukukuRouteSolutionsClass;

#define NETSUKUKU_TYPE_TUNNEL_ITEM (netsukuku_tunnel_item_get_type ())
#define NETSUKUKU_TUNNEL_ITEM(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), NETSUKUKU_TYPE_TUNNEL_ITEM, NetsukukuTunnelItem))
#define NETSUKUKU_TUNNEL_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), NETSUKUKU_TYPE_TUNNEL_ITEM, NetsukukuTunnelItemClass))
#define NETSUKUKU_IS_TUNNEL_ITEM(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), NETSUKUKU_TYPE_TUNNEL_ITEM))
#define NETSUKUKU_IS_TUNNEL_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), NETSUKUKU_TYPE_TUNNEL_ITEM))
#define NETSUKUKU_TUNNEL_ITEM_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), NETSUKUKU_TYPE_TUNNEL_ITEM, NetsukukuTunnelItemClass))

typedef struct _NetsukukuTunnelItem NetsukukuTunnelItem;
typedef struct _NetsukukuTunnelItemClass NetsukukuTunnelItemClass;
typedef struct _NetsukukuImplLinuxLinuxRoutePrivate NetsukukuImplLinuxLinuxRoutePrivate;

#define NETSUKUKU_TYPE_ROUTE_SOLUTION (netsukuku_route_solution_get_type ())
#define NETSUKUKU_ROUTE_SOLUTION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), NETSUKUKU_TYPE_ROUTE_SOLUTION, NetsukukuRouteSolution))
#define NETSUKUKU_ROUTE_SOLUTION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), NETSUKUKU_TYPE_ROUTE_SOLUTION, NetsukukuRouteSolutionClass))
#define NETSUKUKU_IS_ROUTE_SOLUTION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), NETSUKUKU_TYPE_ROUTE_SOLUTION))
#define NETSUKUKU_IS_ROUTE_SOLUTION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), NETSUKUKU_TYPE_ROUTE_SOLUTION))
#define NETSUKUKU_ROUTE_SOLUTION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), NETSUKUKU_TYPE_ROUTE_SOLUTION, NetsukukuRouteSolutionClass))

typedef struct _NetsukukuRouteSolution NetsukukuRouteSolution;
typedef struct _NetsukukuRouteSolutionClass NetsukukuRouteSolutionClass;

#define NETSUKUKU_TYPE_CONNECTIONS (netsukuku_connections_get_type ())
#define NETSUKUKU_CONNECTIONS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), NETSUKUKU_TYPE_CONNECTIONS, NetsukukuConnections))
#define NETSUKUKU_CONNECTIONS_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), NETSUKUKU_TYPE_CONNECTIONS, NetsukukuConnectionsClass))
#define NETSUKUKU_IS_CONNECTIONS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), NETSUKUKU_TYPE_CONNECTIONS))
#define NETSUKUKU_IS_CONNECTIONS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), NETSUKUKU_TYPE_CONNECTIONS))
#define NETSUKUKU_CONNECTIONS_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), NETSUKUKU_TYPE_CONNECTIONS, NetsukukuConnectionsClass))

typedef struct _NetsukukuConnections NetsukukuConnections;
typedef struct _NetsukukuConnectionsClass NetsukukuConnectionsClass;
typedef struct _NetsukukuConnectionsPrivate NetsukukuConnectionsPrivate;

#define NETSUKUKU_IMPL_LINUX_TYPE_LINUX_CONNECTIONS (netsukuku_impl_linux_linux_connections_get_type ())
#define NETSUKUKU_IMPL_LINUX_LINUX_CONNECTIONS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), NETSUKUKU_IMPL_LINUX_TYPE_LINUX_CONNECTIONS, NetsukukuImplLinuxLinuxConnections))
#define NETSUKUKU_IMPL_LINUX_LINUX_CONNECTIONS_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), NETSUKUKU_IMPL_LINUX_TYPE_LINUX_CONNECTIONS, NetsukukuImplLinuxLinuxConnectionsClass))
#define NETSUKUKU_IMPL_LINUX_IS_LINUX_CONNECTIONS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), NETSUKUKU_IMPL_LINUX_TYPE_LINUX_CONNECTIONS))
#define NETSUKUKU_IMPL_LINUX_IS_LINUX_CONNECTIONS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), NETSUKUKU_IMPL_LINUX_TYPE_LINUX_CONNECTIONS))
#define NETSUKUKU_IMPL_LINUX_LINUX_CONNECTIONS_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), NETSUKUKU_IMPL_LINUX_TYPE_LINUX_CONNECTIONS, NetsukukuImplLinuxLinuxConnectionsClass))

typedef struct _NetsukukuImplLinuxLinuxConnections NetsukukuImplLinuxLinuxConnections;
typedef struct _NetsukukuImplLinuxLinuxConnectionsClass NetsukukuImplLinuxLinuxConnectionsClass;
typedef struct _NetsukukuImplLinuxLinuxConnectionsPrivate NetsukukuImplLinuxLinuxConnectionsPrivate;

#define NETSUKUKU_TYPE_BASE_TUNNEL (netsukuku_base_tunnel_get_type ())
#define NETSUKUKU_BASE_TUNNEL(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), NETSUKUKU_TYPE_BASE_TUNNEL, NetsukukuBaseTunnel))
#define NETSUKUKU_BASE_TUNNEL_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), NETSUKUKU_TYPE_BASE_TUNNEL, NetsukukuBaseTunnelClass))
#define NETSUKUKU_IS_BASE_TUNNEL(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), NETSUKUKU_TYPE_BASE_TUNNEL))
#define NETSUKUKU_IS_BASE_TUNNEL_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), NETSUKUKU_TYPE_BASE_TUNNEL))
#define NETSUKUKU_BASE_TUNNEL_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), NETSUKUKU_TYPE_BASE_TUNNEL, NetsukukuBaseTunnelClass))

typedef struct _NetsukukuBaseTunnel NetsukukuBaseTunnel;
typedef struct _NetsukukuBaseTunnelClass NetsukukuBaseTunnelClass;
typedef struct _NetsukukuBaseTunnelPrivate NetsukukuBaseTunnelPrivate;

#define NETSUKUKU_IMPL_LINUX_TYPE_LINUX_TUNNEL (netsukuku_impl_linux_linux_tunnel_get_type ())
#define NETSUKUKU_IMPL_LINUX_LINUX_TUNNEL(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), NETSUKUKU_IMPL_LINUX_TYPE_LINUX_TUNNEL, NetsukukuImplLinuxLinuxTunnel))
#define NETSUKUKU_IMPL_LINUX_LINUX_TUNNEL_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), NETSUKUKU_IMPL_LINUX_TYPE_LINUX_TUNNEL, NetsukukuImplLinuxLinuxTunnelClass))
#define NETSUKUKU_IMPL_LINUX_IS_LINUX_TUNNEL(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), NETSUKUKU_IMPL_LINUX_TYPE_LINUX_TUNNEL))
#define NETSUKUKU_IMPL_LINUX_IS_LINUX_TUNNEL_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), NETSUKUKU_IMPL_LINUX_TYPE_LINUX_TUNNEL))
#define NETSUKUKU_IMPL_LINUX_LINUX_TUNNEL_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), NETSUKUKU_IMPL_LINUX_TYPE_LINUX_TUNNEL, NetsukukuImplLinuxLinuxTunnelClass))

typedef struct _NetsukukuImplLinuxLinuxTunnel NetsukukuImplLinuxLinuxTunnel;
typedef struct _NetsukukuImplLinuxLinuxTunnelClass NetsukukuImplLinuxLinuxTunnelClass;
typedef struct _NetsukukuImplLinuxLinuxTunnelPrivate NetsukukuImplLinuxLinuxTunnelPrivate;
#define _vala_assert(expr, msg) if G_LIKELY (expr) ; else g_assertion_message_expr (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);

struct _NetsukukuImplLinuxstruct_helper_ntk_linux_sequential_command {
	gchar* cmdline;
};

typedef enum  {
	NETSUKUKU_IMPL_LINUX_IPROUTE_COMMAND_ERROR_GENERIC
} NetsukukuImplLinuxIPROUTECommandError;
#define NETSUKUKU_IMPL_LINUX_IPROUTE_COMMAND_ERROR netsukuku_impl_linux_iproute_command_error_quark ()
typedef enum  {
	NETSUKUKU_IMPL_LINUX_IPTABLES_COMMAND_ERROR_GENERIC
} NetsukukuImplLinuxIPTABLESCommandError;
#define NETSUKUKU_IMPL_LINUX_IPTABLES_COMMAND_ERROR netsukuku_impl_linux_iptables_command_error_quark ()
struct _NetsukukuNIC {
	GObject parent_instance;
	NetsukukuNICPrivate * priv;
	gchar* name;
	GeeArrayList* addresses;
};

struct _NetsukukuNICClass {
	GObjectClass parent_class;
	void (*_up) (NetsukukuNIC* self);
	void (*_down) (NetsukukuNIC* self);
	void (*_add_address) (NetsukukuNIC* self, const gchar* address);
	void (*_remove_address) (NetsukukuNIC* self, const gchar* address);
	void (*_disable_filtering) (NetsukukuNIC* self);
	const gchar* (*_mac_getter) (NetsukukuNIC* self);
	gboolean (*_is_active_getter) (NetsukukuNIC* self);
};

struct _NetsukukuImplLinuxLinuxNIC {
	NetsukukuNIC parent_instance;
	NetsukukuImplLinuxLinuxNICPrivate * priv;
};

struct _NetsukukuImplLinuxLinuxNICClass {
	NetsukukuNICClass parent_class;
};

struct _NetsukukuImplLinuxLinuxNICPrivate {
	gchar* _mac;
};

typedef NetsukukuNIC* (*NetsukukuCreateNicDelegate) (const gchar* nic_name, void* user_data);
struct _NetsukukuImplLinuxstruct_helper_LinuxRoute_activate_multipath {
	NetsukukuImplLinuxLinuxRoute* self;
};

struct _NetsukukuRouteSetter {
	GObject parent_instance;
	NetsukukuRouteSetterPrivate * priv;
};

struct _NetsukukuRouteSetterClass {
	GObjectClass parent_class;
	void (*_add_outgoing_route) (NetsukukuRouteSetter* self, const gchar* ip, const gchar* cidr, NetsukukuRouteSolutions* route_solutions);
	void (*_add_forwarding_route) (NetsukukuRouteSetter* self, const gchar* ip, const gchar* cidr, const gchar* prev_hop, NetsukukuRouteSolutions* route_solutions, GError** error);
	void (*_add_forwarding_route_unreachable) (NetsukukuRouteSetter* self, const gchar* ip, const gchar* cidr, const gchar* prev_hop, GError** error);
	void (*_add_forwarding_route_drop) (NetsukukuRouteSetter* self, const gchar* ip, const gchar* cidr, const gchar* prev_hop, GError** error);
	void (*_change_outgoing_route) (NetsukukuRouteSetter* self, const gchar* ip, const gchar* cidr, NetsukukuRouteSolutions* route_solutions, NetsukukuRouteSolutions* old_route_solutions);
	void (*_change_forwarding_route) (NetsukukuRouteSetter* self, const gchar* ip, const gchar* cidr, const gchar* prev_hop, NetsukukuRouteSolutions* route_solutions, NetsukukuRouteSolutions* old_route_solutions, GError** error);
	void (*_change_forwarding_route_unreachable) (NetsukukuRouteSetter* self, const gchar* ip, const gchar* cidr, const gchar* prev_hop, NetsukukuRouteSolutions* old_route_solutions, GError** error);
	void (*_change_forwarding_route_drop) (NetsukukuRouteSetter* self, const gchar* ip, const gchar* cidr, const gchar* prev_hop, NetsukukuRouteSolutions* old_route_solutions, GError** error);
	void (*_change_forwarding_route_was_unreachable) (NetsukukuRouteSetter* self, const gchar* ip, const gchar* cidr, const gchar* prev_hop, NetsukukuRouteSolutions* route_solutions, GError** error);
	void (*_change_forwarding_route_drop_was_unreachable) (NetsukukuRouteSetter* self, const gchar* ip, const gchar* cidr, const gchar* prev_hop, GError** error);
	void (*_change_forwarding_route_was_drop) (NetsukukuRouteSetter* self, const gchar* ip, const gchar* cidr, const gchar* prev_hop, NetsukukuRouteSolutions* route_solutions, GError** error);
	void (*_change_forwarding_route_unreachable_was_drop) (NetsukukuRouteSetter* self, const gchar* ip, const gchar* cidr, const gchar* prev_hop, GError** error);
	void (*_remove_outgoing_route) (NetsukukuRouteSetter* self, const gchar* ip, const gchar* cidr, NetsukukuRouteSolutions* old_route_solutions);
	void (*_remove_forwarding_route) (NetsukukuRouteSetter* self, const gchar* ip, const gchar* cidr, const gchar* prev_hop, NetsukukuRouteSolutions* old_route_solutions, GError** error);
	void (*_remove_forwarding_route_was_unreachable) (NetsukukuRouteSetter* self, const gchar* ip, const gchar* cidr, const gchar* prev_hop, GError** error);
	void (*_remove_forwarding_route_was_drop) (NetsukukuRouteSetter* self, const gchar* ip, const gchar* cidr, const gchar* prev_hop, GError** error);
	void (*_forward_no_more_from) (NetsukukuRouteSetter* self, const gchar* prev_hop, GError** error);
	void (*_forward_no_more) (NetsukukuRouteSetter* self, GError** error);
	void (*_add_neighbour) (NetsukukuRouteSetter* self, const gchar* ip, const gchar* dev, const gchar* pref_src);
	void (*_change_neighbour) (NetsukukuRouteSetter* self, const gchar* ip, const gchar* dev, const gchar* pref_src, const gchar* old_dev);
	void (*_delete_neighbour) (NetsukukuRouteSetter* self, const gchar* ip, const gchar* old_dev);
	gboolean (*_igs_update_rules) (NetsukukuRouteSetter* self, const gchar* prev_mode, gboolean prev_announce_myself, GeeArrayList* prev_list_tunnels, const gchar* mode, gboolean announce_myself, GeeArrayList* list_tunnels, const gchar* pref_src, GError** error);
	gboolean (*check_ping) (NetsukukuRouteSetter* self, const gchar* ipstr);
	gboolean (*_reset_routes) (NetsukukuRouteSetter* self, const gchar* ip_whole_network, const gchar* cidr_whole_network);
	void (*activate_multipath) (NetsukukuRouteSetter* self);
	void (*ip_forward) (NetsukukuRouteSetter* self, gboolean enable);
};

struct _NetsukukuImplLinuxLinuxRoute {
	NetsukukuRouteSetter parent_instance;
	NetsukukuImplLinuxLinuxRoutePrivate * priv;
};

struct _NetsukukuImplLinuxLinuxRouteClass {
	NetsukukuRouteSetterClass parent_class;
};

struct _NetsukukuImplLinuxLinuxRoutePrivate {
	GeeHashMap* mac_table;
};

typedef NetsukukuRouteSetter* (*NetsukukuCreateRouteSetterDelegate) (void* user_data);
struct _NetsukukuConnections {
	GObject parent_instance;
	NetsukukuConnectionsPrivate * priv;
};

struct _NetsukukuConnectionsClass {
	GObjectClass parent_class;
	gboolean (*active_tcp_connections) (NetsukukuConnections* self, const gchar* ip);
};

struct _NetsukukuImplLinuxLinuxConnections {
	NetsukukuConnections parent_instance;
	NetsukukuImplLinuxLinuxConnectionsPrivate * priv;
};

struct _NetsukukuImplLinuxLinuxConnectionsClass {
	NetsukukuConnectionsClass parent_class;
};

typedef NetsukukuConnections* (*NetsukukuCreateConnectionsDelegate) (void* user_data);
typedef void (*NetsukukuCallbackSendDelegate) (zcdISerializable* msg, void* user_data, GError** error);
typedef zcdISerializable* (*NetsukukuCallbackRecvDelegate) (void* user_data, GError** error);
struct _NetsukukuBaseTunnel {
	GObject parent_instance;
	NetsukukuBaseTunnelPrivate * priv;
};

struct _NetsukukuBaseTunnelClass {
	GObjectClass parent_class;
	gchar* (*request) (NetsukukuBaseTunnel* self, NetsukukuCallbackSendDelegate cb_send, void* cb_send_target, NetsukukuCallbackRecvDelegate cb_recv, void* cb_recv_target, const gchar* my_address, const gchar* dest_address, GError** error);
	gchar* (*serve) (NetsukukuBaseTunnel* self, NetsukukuCallbackSendDelegate cb_send, void* cb_send_target, NetsukukuCallbackRecvDelegate cb_recv, void* cb_recv_target, const gchar* my_address, const gchar* dest_address, GError** error);
	void (*close) (NetsukukuBaseTunnel* self, const gchar* nic_name, const gchar* my_address, const gchar* dest_address, GError** error);
};

struct _NetsukukuImplLinuxLinuxTunnel {
	NetsukukuBaseTunnel parent_instance;
	NetsukukuImplLinuxLinuxTunnelPrivate * priv;
};

struct _NetsukukuImplLinuxLinuxTunnelClass {
	NetsukukuBaseTunnelClass parent_class;
};

struct _NetsukukuImplLinuxLinuxTunnelPrivate {
	GeeLinkedList* port_pool;
	GeeHashMap* used_ports;
};

typedef NetsukukuBaseTunnel* (*NetsukukuCreateTunnelDelegate) (void* user_data);

extern TaskletsChannel* netsukuku_impl_linux__sequential_command_channel;
TaskletsChannel* netsukuku_impl_linux__sequential_command_channel = NULL;
static gpointer netsukuku_impl_linux_linux_nic_parent_class = NULL;
extern gint netsukuku_impl_linux_NTK_TABLE;
gint netsukuku_impl_linux_NTK_TABLE = 200;
extern GRegex* netsukuku_impl_linux_NTK_IN_RT_TABLE;
GRegex* netsukuku_impl_linux_NTK_IN_RT_TABLE = NULL;
static gpointer netsukuku_impl_linux_linux_route_parent_class = NULL;
static gpointer netsukuku_impl_linux_linux_connections_parent_class = NULL;
static gpointer netsukuku_impl_linux_linux_tunnel_parent_class = NULL;

TaskletsCommandResult* netsukuku_impl_linux_exec_command (const gchar* cmdline, GError** error);
void netsukuku_log_info (const gchar* msg);
void netsukuku_log_debug (const gchar* msg);
GType netsukuku_impl_linux_struct_helper_ntk_linux_sequential_command_get_type (void) G_GNUC_CONST;
NetsukukuImplLinuxstruct_helper_ntk_linux_sequential_command* netsukuku_impl_linux_struct_helper_ntk_linux_sequential_command_dup (const NetsukukuImplLinuxstruct_helper_ntk_linux_sequential_command* self);
void netsukuku_impl_linux_struct_helper_ntk_linux_sequential_command_free (NetsukukuImplLinuxstruct_helper_ntk_linux_sequential_command* self);
void netsukuku_impl_linux_struct_helper_ntk_linux_sequential_command_copy (const NetsukukuImplLinuxstruct_helper_ntk_linux_sequential_command* self, NetsukukuImplLinuxstruct_helper_ntk_linux_sequential_command* dest);
void netsukuku_impl_linux_struct_helper_ntk_linux_sequential_command_destroy (NetsukukuImplLinuxstruct_helper_ntk_linux_sequential_command* self);
TaskletsChannel* netsukuku_impl_linux_get_sequential_command_channel (void);
void* netsukuku_impl_linux_helper_sequential_command (void* v);
void netsukuku_log_warn (const gchar* msg);
void netsukuku_impl_linux_sequential_command (const gchar* cmdline, gchar** cmdout, gchar** cmderr, gint* exit_status);
GQuark netsukuku_impl_linux_iproute_command_error_quark (void);
gchar* netsukuku_impl_linux_iproute (const gchar* args, GError** error);
const gchar* netsukuku_settings_get_IPROUTE_PATH (void);
void netsukuku_settings_set_IPROUTE_PATH (const gchar* value);
void netsukuku_impl_linux_iproute_exp (const gchar* args);
GQuark netsukuku_impl_linux_iptables_command_error_quark (void);
gchar* netsukuku_impl_linux_iptables (const gchar* args, GError** error);
const gchar* netsukuku_settings_get_IPTABLES_PATH (void);
void netsukuku_settings_set_IPTABLES_PATH (const gchar* value);
void netsukuku_impl_linux_iptables_exp (const gchar* args);
gboolean netsukuku_impl_linux_check_ping (const gchar* ipstr);
const gchar* netsukuku_settings_get_PING_PATH (void);
void netsukuku_settings_set_PING_PATH (const gchar* value);
void netsukuku_impl_linux_write_file (const gchar* pathname, guint8* buf, int buf_length1);
void netsukuku_log_error (const gchar* msg);
guint8* netsukuku_impl_linux_read_file (const gchar* pathname, gint maxlen, int* result_length1);
GType netsukuku_nic_get_type (void) G_GNUC_CONST;
GType netsukuku_impl_linux_linux_nic_get_type (void) G_GNUC_CONST;
#define NETSUKUKU_IMPL_LINUX_LINUX_NIC_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), NETSUKUKU_IMPL_LINUX_TYPE_LINUX_NIC, NetsukukuImplLinuxLinuxNICPrivate))
enum  {
	NETSUKUKU_IMPL_LINUX_LINUX_NIC_DUMMY_PROPERTY
};
static NetsukukuNIC* _netsukuku_impl_linux_linux_nic_create (const gchar* nic_name);
NetsukukuImplLinuxLinuxNIC* netsukuku_impl_linux_linux_nic_new (const gchar* nic_name);
NetsukukuImplLinuxLinuxNIC* netsukuku_impl_linux_linux_nic_construct (GType object_type, const gchar* nic_name);
void netsukuku_impl_linux_linux_nic_register (void);
void netsukuku_nic_register_class (const gchar* k, NetsukukuCreateNicDelegate create_new_nic, void* create_new_nic_target);
static NetsukukuNIC* __netsukuku_impl_linux_linux_nic_create_netsukuku_create_nic_delegate (const gchar* nic_name, gpointer self);
NetsukukuNIC* netsukuku_nic_construct (GType object_type, const gchar* nic_name);
static const gchar* netsukuku_impl_linux_linux_nic_real__mac_getter (NetsukukuNIC* base);
static gboolean netsukuku_impl_linux_linux_nic_real__is_active_getter (NetsukukuNIC* base);
static void netsukuku_impl_linux_linux_nic_real__up (NetsukukuNIC* base);
static void netsukuku_impl_linux_linux_nic_real__down (NetsukukuNIC* base);
static void netsukuku_impl_linux_linux_nic_real__add_address (NetsukukuNIC* base, const gchar* address);
static void netsukuku_impl_linux_linux_nic_real__remove_address (NetsukukuNIC* base, const gchar* address);
static void netsukuku_impl_linux_linux_nic_real__disable_filtering (NetsukukuNIC* base);
static void netsukuku_impl_linux_linux_nic_finalize (GObject* obj);
#define NETSUKUKU_IMPL_LINUX_RT_TABLE "/etc/iproute2/rt_tables"
void netsukuku_impl_linux_init_prdb (void);
GType netsukuku_impl_linux_struct_helper_linuxroute_activate_multipath_get_type (void) G_GNUC_CONST;
GType netsukuku_route_setter_get_type (void) G_GNUC_CONST;
GType netsukuku_impl_linux_linux_route_get_type (void) G_GNUC_CONST;
NetsukukuImplLinuxstruct_helper_LinuxRoute_activate_multipath* netsukuku_impl_linux_struct_helper_linuxroute_activate_multipath_dup (const NetsukukuImplLinuxstruct_helper_LinuxRoute_activate_multipath* self);
void netsukuku_impl_linux_struct_helper_linuxroute_activate_multipath_free (NetsukukuImplLinuxstruct_helper_LinuxRoute_activate_multipath* self);
void netsukuku_impl_linux_struct_helper_linuxroute_activate_multipath_copy (const NetsukukuImplLinuxstruct_helper_LinuxRoute_activate_multipath* self, NetsukukuImplLinuxstruct_helper_LinuxRoute_activate_multipath* dest);
void netsukuku_impl_linux_struct_helper_linuxroute_activate_multipath_destroy (NetsukukuImplLinuxstruct_helper_LinuxRoute_activate_multipath* self);
GType netsukuku_base_route_solutions_get_type (void) G_GNUC_CONST;
GType netsukuku_route_solutions_get_type (void) G_GNUC_CONST;
GType netsukuku_tunnel_item_get_type (void) G_GNUC_CONST;
#define NETSUKUKU_IMPL_LINUX_LINUX_ROUTE_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), NETSUKUKU_IMPL_LINUX_TYPE_LINUX_ROUTE, NetsukukuImplLinuxLinuxRoutePrivate))
enum  {
	NETSUKUKU_IMPL_LINUX_LINUX_ROUTE_DUMMY_PROPERTY
};
static NetsukukuRouteSetter* _netsukuku_impl_linux_linux_route_create (void);
gboolean netsukuku_settings_get_TESTING (void);
NetsukukuImplLinuxLinuxRoute* netsukuku_impl_linux_linux_route_new (void);
NetsukukuImplLinuxLinuxRoute* netsukuku_impl_linux_linux_route_construct (GType object_type);
void netsukuku_impl_linux_linux_route_register (void);
void netsukuku_route_setter_register_class (const gchar* k, NetsukukuCreateRouteSetterDelegate create_new_route, void* create_new_route_target);
static NetsukukuRouteSetter* __netsukuku_impl_linux_linux_route_create_netsukuku_create_route_setter_delegate (gpointer self);
NetsukukuRouteSetter* netsukuku_route_setter_construct (GType object_type);
static void netsukuku_impl_linux_linux_route_impl_activate_multipath (NetsukukuImplLinuxLinuxRoute* self, GError** error);
static void* netsukuku_impl_linux_linux_route_helper_activate_multipath (void* v, GError** error);
static void netsukuku_impl_linux_linux_route_real_activate_multipath (NetsukukuRouteSetter* base);
gint _netsukuku_impl_linux_linux_route_table_for_macaddr (NetsukukuImplLinuxLinuxRoute* self, const gchar* _macaddr, GError** error);
void _netsukuku_impl_linux_linux_route_table_for_macaddr_remove_all (NetsukukuImplLinuxLinuxRoute* self, GError** error);
void _netsukuku_impl_linux_linux_route_table_for_macaddr_remove (NetsukukuImplLinuxLinuxRoute* self, const gchar* _macaddr, GError** error);
gchar* _netsukuku_impl_linux_linux_route_modify_routes_cmd (NetsukukuImplLinuxLinuxRoute* self, const gchar* command, const gchar* ip, const gchar* cidr, NetsukukuRouteSolutions* route_solutions, const gchar* table);
const gchar* netsukuku_route_solutions_get_pref_src (NetsukukuRouteSolutions* self);
GType netsukuku_route_solution_get_type (void) G_GNUC_CONST;
GeeCollection* netsukuku_route_solutions_get_values (NetsukukuRouteSolutions* self);
const gchar* netsukuku_route_solution_get_gateway (NetsukukuRouteSolution* self);
const gchar* netsukuku_route_solution_get_dev (NetsukukuRouteSolution* self);
gint netsukuku_route_solution_get_weight (NetsukukuRouteSolution* self);
gchar* _netsukuku_impl_linux_linux_route_modify_neighbour_cmd (NetsukukuImplLinuxLinuxRoute* self, const gchar* command, const gchar* ip, const gchar* dev, const gchar* pref_src);
static void netsukuku_impl_linux_linux_route_real__add_outgoing_route (NetsukukuRouteSetter* base, const gchar* ip, const gchar* cidr, NetsukukuRouteSolutions* route_solutions);
gboolean netsukuku_route_solutions_contains_gw (NetsukukuRouteSolutions* self, const gchar* gateway);
static void netsukuku_impl_linux_linux_route_real__add_forwarding_route (NetsukukuRouteSetter* base, const gchar* ip, const gchar* cidr, const gchar* prev_hop, NetsukukuRouteSolutions* route_solutions, GError** error);
static void netsukuku_impl_linux_linux_route_real__add_forwarding_route_unreachable (NetsukukuRouteSetter* base, const gchar* ip, const gchar* cidr, const gchar* prev_hop, GError** error);
static void netsukuku_impl_linux_linux_route_real__add_forwarding_route_drop (NetsukukuRouteSetter* base, const gchar* ip, const gchar* cidr, const gchar* prev_hop, GError** error);
static void netsukuku_impl_linux_linux_route_real__change_outgoing_route (NetsukukuRouteSetter* base, const gchar* ip, const gchar* cidr, NetsukukuRouteSolutions* route_solutions, NetsukukuRouteSolutions* old_route_solutions);
static void netsukuku_impl_linux_linux_route_real__change_forwarding_route (NetsukukuRouteSetter* base, const gchar* ip, const gchar* cidr, const gchar* prev_hop, NetsukukuRouteSolutions* route_solutions, NetsukukuRouteSolutions* old_route_solutions, GError** error);
static void netsukuku_impl_linux_linux_route_real__change_forwarding_route_unreachable (NetsukukuRouteSetter* base, const gchar* ip, const gchar* cidr, const gchar* prev_hop, NetsukukuRouteSolutions* old_route_solutions, GError** error);
static void netsukuku_impl_linux_linux_route_real__change_forwarding_route_drop (NetsukukuRouteSetter* base, const gchar* ip, const gchar* cidr, const gchar* prev_hop, NetsukukuRouteSolutions* old_route_solutions, GError** error);
static void netsukuku_impl_linux_linux_route_real__change_forwarding_route_was_unreachable (NetsukukuRouteSetter* base, const gchar* ip, const gchar* cidr, const gchar* prev_hop, NetsukukuRouteSolutions* route_solutions, GError** error);
static void netsukuku_impl_linux_linux_route_real__change_forwarding_route_drop_was_unreachable (NetsukukuRouteSetter* base, const gchar* ip, const gchar* cidr, const gchar* prev_hop, GError** error);
static void netsukuku_impl_linux_linux_route_real__change_forwarding_route_was_drop (NetsukukuRouteSetter* base, const gchar* ip, const gchar* cidr, const gchar* prev_hop, NetsukukuRouteSolutions* route_solutions, GError** error);
static void netsukuku_impl_linux_linux_route_real__change_forwarding_route_unreachable_was_drop (NetsukukuRouteSetter* base, const gchar* ip, const gchar* cidr, const gchar* prev_hop, GError** error);
static void netsukuku_impl_linux_linux_route_real__remove_outgoing_route (NetsukukuRouteSetter* base, const gchar* ip, const gchar* cidr, NetsukukuRouteSolutions* old_route_solutions);
static void netsukuku_impl_linux_linux_route_real__remove_forwarding_route (NetsukukuRouteSetter* base, const gchar* ip, const gchar* cidr, const gchar* prev_hop, NetsukukuRouteSolutions* old_route_solutions, GError** error);
static void netsukuku_impl_linux_linux_route_real__remove_forwarding_route_was_unreachable (NetsukukuRouteSetter* base, const gchar* ip, const gchar* cidr, const gchar* prev_hop, GError** error);
static void netsukuku_impl_linux_linux_route_real__remove_forwarding_route_was_drop (NetsukukuRouteSetter* base, const gchar* ip, const gchar* cidr, const gchar* prev_hop, GError** error);
static void netsukuku_impl_linux_linux_route_real__forward_no_more_from (NetsukukuRouteSetter* base, const gchar* _prev_hop, GError** error);
static void netsukuku_impl_linux_linux_route_real__forward_no_more (NetsukukuRouteSetter* base, GError** error);
static void netsukuku_impl_linux_linux_route_real__add_neighbour (NetsukukuRouteSetter* base, const gchar* ip, const gchar* dev, const gchar* pref_src);
static void netsukuku_impl_linux_linux_route_real__change_neighbour (NetsukukuRouteSetter* base, const gchar* ip, const gchar* dev, const gchar* pref_src, const gchar* old_dev);
static void netsukuku_impl_linux_linux_route_real__delete_neighbour (NetsukukuRouteSetter* base, const gchar* ip, const gchar* old_dev);
void _netsukuku_impl_linux_linux_route_disable_rp_filter (NetsukukuImplLinuxLinuxRoute* self, const gchar* nicname);
static gboolean netsukuku_impl_linux_linux_route_real__igs_update_rules (NetsukukuRouteSetter* base, const gchar* prev_mode, gboolean prev_announce_myself, GeeArrayList* prev_list_tunnels, const gchar* mode, gboolean announce_myself, GeeArrayList* list_tunnels, const gchar* pref_src, GError** error);
gchar* netsukuku_tunnel_item_to_string (NetsukukuTunnelItem* self);
const gchar* netsukuku_tunnel_item_get_ipstr (NetsukukuTunnelItem* self);
static gboolean netsukuku_impl_linux_linux_route_real_check_ping (NetsukukuRouteSetter* base, const gchar* ipstr);
gboolean netsukuku_impl_linux_linux_route_impl_check_ping (NetsukukuImplLinuxLinuxRoute* self, const gchar* ipstr);
gboolean netsukuku_route_setter_check_ping (NetsukukuRouteSetter* self, const gchar* ipstr);
static gboolean netsukuku_impl_linux_linux_route_real__reset_routes (NetsukukuRouteSetter* base, const gchar* ip_whole_network, const gchar* cidr_whole_network);
static void netsukuku_impl_linux_linux_route_real_ip_forward (NetsukukuRouteSetter* base, gboolean enable);
static void netsukuku_impl_linux_linux_route_finalize (GObject* obj);
GType netsukuku_connections_get_type (void) G_GNUC_CONST;
GType netsukuku_impl_linux_linux_connections_get_type (void) G_GNUC_CONST;
enum  {
	NETSUKUKU_IMPL_LINUX_LINUX_CONNECTIONS_DUMMY_PROPERTY
};
static NetsukukuConnections* _netsukuku_impl_linux_linux_connections_create (void);
NetsukukuImplLinuxLinuxConnections* netsukuku_impl_linux_linux_connections_new (void);
NetsukukuImplLinuxLinuxConnections* netsukuku_impl_linux_linux_connections_construct (GType object_type);
void netsukuku_impl_linux_linux_connections_register (void);
void netsukuku_connections_register_class (const gchar* k, NetsukukuCreateConnectionsDelegate create_new_connections, void* create_new_connections_target);
static NetsukukuConnections* __netsukuku_impl_linux_linux_connections_create_netsukuku_create_connections_delegate (gpointer self);
static gboolean netsukuku_impl_linux_linux_connections_real_active_tcp_connections (NetsukukuConnections* base, const gchar* ip);
NetsukukuConnections* netsukuku_connections_construct (GType object_type);
GType netsukuku_base_tunnel_get_type (void) G_GNUC_CONST;
GType netsukuku_impl_linux_linux_tunnel_get_type (void) G_GNUC_CONST;
#define NETSUKUKU_IMPL_LINUX_LINUX_TUNNEL_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), NETSUKUKU_IMPL_LINUX_TYPE_LINUX_TUNNEL, NetsukukuImplLinuxLinuxTunnelPrivate))
enum  {
	NETSUKUKU_IMPL_LINUX_LINUX_TUNNEL_DUMMY_PROPERTY
};
static NetsukukuBaseTunnel* _netsukuku_impl_linux_linux_tunnel_create (void);
NetsukukuImplLinuxLinuxTunnel* netsukuku_impl_linux_linux_tunnel_new (void);
NetsukukuImplLinuxLinuxTunnel* netsukuku_impl_linux_linux_tunnel_construct (GType object_type);
void netsukuku_impl_linux_linux_tunnel_register (void);
void netsukuku_base_tunnel_register_class (const gchar* k, NetsukukuCreateTunnelDelegate create_new_nic, void* create_new_nic_target);
static NetsukukuBaseTunnel* __netsukuku_impl_linux_linux_tunnel_create_netsukuku_create_tunnel_delegate (gpointer self);
NetsukukuBaseTunnel* netsukuku_base_tunnel_construct (GType object_type);
static gchar* netsukuku_impl_linux_linux_tunnel_real_serve (NetsukukuBaseTunnel* base, NetsukukuCallbackSendDelegate cb_send, void* cb_send_target, NetsukukuCallbackRecvDelegate cb_recv, void* cb_recv_target, const gchar* my_address, const gchar* dest_address, GError** error);
static gchar* netsukuku_impl_linux_linux_tunnel_real_request (NetsukukuBaseTunnel* base, NetsukukuCallbackSendDelegate cb_send, void* cb_send_target, NetsukukuCallbackRecvDelegate cb_recv, void* cb_recv_target, const gchar* my_address, const gchar* dest_address, GError** error);
static void netsukuku_impl_linux_linux_tunnel_real_close (NetsukukuBaseTunnel* base, const gchar* nic_name, const gchar* my_address, const gchar* dest_address, GError** error);
static void netsukuku_impl_linux_linux_tunnel_finalize (GObject* obj);


/** Launch a process and block this tasklet till it ends.
      * Returns exit status, stdout and stderr.
      */
static gboolean string_contains (const gchar* self, const gchar* needle) {
	gboolean result = FALSE;
	const gchar* _tmp0_;
	gchar* _tmp1_ = NULL;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (needle != NULL, FALSE);
	_tmp0_ = needle;
	_tmp1_ = strstr ((gchar*) self, (gchar*) _tmp0_);
	result = _tmp1_ != NULL;
	return result;
}


static const gchar* string_to_string (const gchar* self) {
	const gchar* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	result = self;
	return result;
}


TaskletsCommandResult* netsukuku_impl_linux_exec_command (const gchar* cmdline, GError** error) {
	TaskletsCommandResult* result = NULL;
	const gchar* _tmp0_;
	gboolean _tmp1_ = FALSE;
	const gchar* _tmp6_;
	TaskletsCommandResult* _tmp7_ = NULL;
	TaskletsCommandResult* com_ret;
	gint _tmp8_;
	gchar* _tmp9_ = NULL;
	gchar* _tmp10_;
	gchar* _tmp11_ = NULL;
	gchar* _tmp12_;
	gchar* report;
	const gchar* _tmp13_;
	const gchar* _tmp18_;
	const gchar* _tmp19_ = NULL;
	const gchar* _tmp20_;
	const gchar* _tmp21_ = NULL;
	gchar* _tmp22_ = NULL;
	gboolean _tmp23_ = FALSE;
	const gchar* _tmp24_;
	gboolean _tmp26_;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (cmdline != NULL, NULL);
	_tmp0_ = cmdline;
	_tmp1_ = string_contains (_tmp0_, "route flush cache");
	if (!_tmp1_) {
		const gchar* _tmp2_;
		const gchar* _tmp3_ = NULL;
		gchar* _tmp4_ = NULL;
		gchar* _tmp5_;
		_tmp2_ = cmdline;
		_tmp3_ = string_to_string (_tmp2_);
		_tmp4_ = g_strconcat ("ImplLinux: going to execute...: ", _tmp3_, NULL);
		_tmp5_ = _tmp4_;
		netsukuku_log_info (_tmp5_);
		_g_free0 (_tmp5_);
	}
	_tmp6_ = cmdline;
	_tmp7_ = tasklets_tasklet_exec_command (_tmp6_, &_inner_error_);
	com_ret = _tmp7_;
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == G_SPAWN_ERROR) {
			g_propagate_error (error, _inner_error_);
			return NULL;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	}
	_tmp8_ = com_ret->exit_status;
	_tmp9_ = g_strdup_printf ("%i", _tmp8_);
	_tmp10_ = _tmp9_;
	_tmp11_ = g_strconcat (" with exit value ", _tmp10_, " and stderr ", NULL);
	_tmp12_ = _tmp11_;
	_g_free0 (_tmp10_);
	report = _tmp12_;
	_tmp13_ = com_ret->cmderr;
	if (g_strcmp0 (_tmp13_, "") == 0) {
		const gchar* _tmp14_;
		gchar* _tmp15_;
		_tmp14_ = report;
		_tmp15_ = g_strconcat (_tmp14_, "null", NULL);
		_g_free0 (report);
		report = _tmp15_;
	} else {
		const gchar* _tmp16_;
		gchar* _tmp17_;
		_tmp16_ = report;
		_tmp17_ = g_strconcat (_tmp16_, "NOT null", NULL);
		_g_free0 (report);
		report = _tmp17_;
	}
	_tmp18_ = report;
	_tmp19_ = string_to_string (_tmp18_);
	_tmp20_ = cmdline;
	_tmp21_ = string_to_string (_tmp20_);
	_tmp22_ = g_strconcat ("ImplLinux: completed", _tmp19_, ": ", _tmp21_, NULL);
	_g_free0 (report);
	report = _tmp22_;
	_tmp24_ = com_ret->cmderr;
	if (g_strcmp0 (_tmp24_, "") != 0) {
		_tmp23_ = TRUE;
	} else {
		gint _tmp25_;
		_tmp25_ = com_ret->exit_status;
		_tmp23_ = _tmp25_ != 0;
	}
	_tmp26_ = _tmp23_;
	if (_tmp26_) {
		const gchar* _tmp27_;
		_tmp27_ = report;
		netsukuku_log_info (_tmp27_);
	} else {
		const gchar* _tmp28_;
		gboolean _tmp29_ = FALSE;
		_tmp28_ = cmdline;
		_tmp29_ = string_contains (_tmp28_, "route flush cache");
		if (!_tmp29_) {
			const gchar* _tmp30_;
			_tmp30_ = report;
			netsukuku_log_debug (_tmp30_);
		}
	}
	result = com_ret;
	_g_free0 (report);
	return result;
}


void netsukuku_impl_linux_struct_helper_ntk_linux_sequential_command_copy (const NetsukukuImplLinuxstruct_helper_ntk_linux_sequential_command* self, NetsukukuImplLinuxstruct_helper_ntk_linux_sequential_command* dest) {
	const gchar* _tmp0_;
	gchar* _tmp1_;
	_tmp0_ = (*self).cmdline;
	_tmp1_ = g_strdup (_tmp0_);
	_g_free0 ((*dest).cmdline);
	(*dest).cmdline = _tmp1_;
}


void netsukuku_impl_linux_struct_helper_ntk_linux_sequential_command_destroy (NetsukukuImplLinuxstruct_helper_ntk_linux_sequential_command* self) {
	_g_free0 ((*self).cmdline);
}


NetsukukuImplLinuxstruct_helper_ntk_linux_sequential_command* netsukuku_impl_linux_struct_helper_ntk_linux_sequential_command_dup (const NetsukukuImplLinuxstruct_helper_ntk_linux_sequential_command* self) {
	NetsukukuImplLinuxstruct_helper_ntk_linux_sequential_command* dup;
	dup = g_new0 (NetsukukuImplLinuxstruct_helper_ntk_linux_sequential_command, 1);
	netsukuku_impl_linux_struct_helper_ntk_linux_sequential_command_copy (self, dup);
	return dup;
}


void netsukuku_impl_linux_struct_helper_ntk_linux_sequential_command_free (NetsukukuImplLinuxstruct_helper_ntk_linux_sequential_command* self) {
	netsukuku_impl_linux_struct_helper_ntk_linux_sequential_command_destroy (self);
	g_free (self);
}


GType netsukuku_impl_linux_struct_helper_ntk_linux_sequential_command_get_type (void) {
	static volatile gsize netsukuku_impl_linux_struct_helper_ntk_linux_sequential_command_type_id__volatile = 0;
	if (g_once_init_enter (&netsukuku_impl_linux_struct_helper_ntk_linux_sequential_command_type_id__volatile)) {
		GType netsukuku_impl_linux_struct_helper_ntk_linux_sequential_command_type_id;
		netsukuku_impl_linux_struct_helper_ntk_linux_sequential_command_type_id = g_boxed_type_register_static ("NetsukukuImplLinuxstruct_helper_ntk_linux_sequential_command", (GBoxedCopyFunc) netsukuku_impl_linux_struct_helper_ntk_linux_sequential_command_dup, (GBoxedFreeFunc) netsukuku_impl_linux_struct_helper_ntk_linux_sequential_command_free);
		g_once_init_leave (&netsukuku_impl_linux_struct_helper_ntk_linux_sequential_command_type_id__volatile, netsukuku_impl_linux_struct_helper_ntk_linux_sequential_command_type_id);
	}
	return netsukuku_impl_linux_struct_helper_ntk_linux_sequential_command_type_id__volatile;
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


TaskletsChannel* netsukuku_impl_linux_get_sequential_command_channel (void) {
	TaskletsChannel* result = NULL;
	TaskletsChannel* _tmp0_;
	TaskletsChannel* _tmp2_;
	TaskletsChannel* _tmp4_;
	TaskletsChannel* _tmp5_;
	_tmp0_ = netsukuku_impl_linux__sequential_command_channel;
	if (_tmp0_ == NULL) {
		TaskletsChannel* _tmp1_ = NULL;
		_tmp1_ = tasklets_channel_find ("ntk_linux_sequential_command_channel");
		_g_object_unref0 (netsukuku_impl_linux__sequential_command_channel);
		netsukuku_impl_linux__sequential_command_channel = _tmp1_;
	}
	_tmp2_ = netsukuku_impl_linux__sequential_command_channel;
	if (_tmp2_ == NULL) {
		TaskletsChannel* _tmp3_;
		_tmp3_ = tasklets_channel_new ("ntk_linux_sequential_command_channel");
		_g_object_unref0 (netsukuku_impl_linux__sequential_command_channel);
		netsukuku_impl_linux__sequential_command_channel = _tmp3_;
	}
	_tmp4_ = netsukuku_impl_linux__sequential_command_channel;
	_tmp5_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp4_, TASKLETS_TYPE_CHANNEL, TaskletsChannel));
	result = _tmp5_;
	return result;
}


void* netsukuku_impl_linux_helper_sequential_command (void* v) {
	void* result = NULL;
	void* _tmp0_;
	Taskletsstruct_channel* ch_cont_p;
	Taskletsstruct_channel* _tmp1_;
	TaskletsChannel* _tmp2_;
	TaskletsChannel* _tmp3_;
	TaskletsChannel* ch;
	GError * _inner_error_ = NULL;
	tasklets_tasklet_declare_self ("ImplLinux.sequential_command dispatcher");
	_tmp0_ = v;
	ch_cont_p = (Taskletsstruct_channel*) _tmp0_;
	_tmp1_ = ch_cont_p;
	_tmp2_ = (*_tmp1_).self;
	_tmp3_ = _g_object_ref0 (_tmp2_);
	ch = _tmp3_;
	tasklets_tasklet_schedule_back ();
	_g_object_unref0 (netsukuku_impl_linux__sequential_command_channel);
	netsukuku_impl_linux__sequential_command_channel = NULL;
	while (TRUE) {
		gchar* doing;
		const gchar* _tmp56_;
		doing = NULL;
		{
			NetsukukuImplLinuxstruct_helper_ntk_linux_sequential_command tuple_p = {0};
			NetsukukuImplLinuxstruct_helper_ntk_linux_sequential_command _tmp8_;
			const gchar* _tmp9_;
			const gchar* _tmp10_ = NULL;
			gchar* _tmp11_;
			const gchar* _tmp12_;
			gchar* cmdout;
			gchar* cmderr;
			gint exit_status = 0;
			TaskletsChannel* _tmp39_ = NULL;
			TaskletsChannel* _tmp40_;
			gint _tmp41_;
			GValue _tmp42_ = {0};
			TaskletsChannel* _tmp43_ = NULL;
			TaskletsChannel* _tmp44_;
			const gchar* _tmp45_;
			GValue _tmp46_ = {0};
			TaskletsChannel* _tmp47_ = NULL;
			TaskletsChannel* _tmp48_;
			const gchar* _tmp49_;
			GValue _tmp50_ = {0};
			{
				TaskletsChannel* _tmp4_;
				GValue _tmp5_ = {0};
				GValue vv;
				void* _tmp6_ = NULL;
				NetsukukuImplLinuxstruct_helper_ntk_linux_sequential_command _tmp7_ = {0};
				_tmp4_ = ch;
				tasklets_channel_recv (_tmp4_, &_tmp5_);
				vv = _tmp5_;
				_tmp6_ = g_value_get_boxed (&vv);
				netsukuku_impl_linux_struct_helper_ntk_linux_sequential_command_copy ((NetsukukuImplLinuxstruct_helper_ntk_linux_sequential_command*) _tmp6_, &_tmp7_);
				netsukuku_impl_linux_struct_helper_ntk_linux_sequential_command_destroy (&tuple_p);
				tuple_p = _tmp7_;
				G_IS_VALUE (&vv) ? (g_value_unset (&vv), NULL) : NULL;
			}
			tasklets_ms_wait ((gint64) 10);
			_tmp8_ = tuple_p;
			_tmp9_ = _tmp8_.cmdline;
			_tmp10_ = string_to_string (_tmp9_);
			_tmp11_ = g_strdup (_tmp10_);
			_g_free0 (doing);
			doing = _tmp11_;
			_tmp12_ = doing;
			tasklets_tasklet_declare_self (_tmp12_);
			cmdout = NULL;
			cmderr = NULL;
			{
				NetsukukuImplLinuxstruct_helper_ntk_linux_sequential_command _tmp13_;
				const gchar* _tmp14_;
				TaskletsCommandResult* _tmp15_ = NULL;
				TaskletsCommandResult* com_ret;
				TaskletsCommandResult* _tmp16_;
				const gchar* _tmp17_;
				gchar* _tmp18_;
				TaskletsCommandResult* _tmp19_;
				const gchar* _tmp20_;
				gchar* _tmp21_;
				TaskletsCommandResult* _tmp22_;
				gint _tmp23_;
				_tmp13_ = tuple_p;
				_tmp14_ = _tmp13_.cmdline;
				_tmp15_ = netsukuku_impl_linux_exec_command (_tmp14_, &_inner_error_);
				com_ret = _tmp15_;
				if (_inner_error_ != NULL) {
					if (_inner_error_->domain == G_SPAWN_ERROR) {
						goto __catch64_g_spawn_error;
					}
					_g_free0 (cmderr);
					_g_free0 (cmdout);
					netsukuku_impl_linux_struct_helper_ntk_linux_sequential_command_destroy (&tuple_p);
					_g_free0 (doing);
					_g_object_unref0 (ch);
					g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
					g_clear_error (&_inner_error_);
					return NULL;
				}
				_tmp16_ = com_ret;
				_tmp17_ = _tmp16_->cmdout;
				_tmp18_ = g_strdup (_tmp17_);
				_g_free0 (cmdout);
				cmdout = _tmp18_;
				_tmp19_ = com_ret;
				_tmp20_ = _tmp19_->cmderr;
				_tmp21_ = g_strdup (_tmp20_);
				_g_free0 (cmderr);
				cmderr = _tmp21_;
				_tmp22_ = com_ret;
				_tmp23_ = _tmp22_->exit_status;
				exit_status = _tmp23_;
				_g_object_unref0 (com_ret);
			}
			goto __finally64;
			__catch64_g_spawn_error:
			{
				GError* e = NULL;
				GError* _tmp24_;
				GQuark _tmp25_;
				const gchar* _tmp26_ = NULL;
				GError* _tmp27_;
				gint _tmp28_;
				gchar* _tmp29_ = NULL;
				gchar* _tmp30_;
				GError* _tmp31_;
				const gchar* _tmp32_;
				const gchar* _tmp33_ = NULL;
				gchar* _tmp34_ = NULL;
				gchar* _tmp35_;
				gchar* x;
				const gchar* _tmp36_;
				gchar* _tmp37_;
				gchar* _tmp38_;
				e = _inner_error_;
				_inner_error_ = NULL;
				exit_status = -1;
				_tmp24_ = e;
				_tmp25_ = _tmp24_->domain;
				_tmp26_ = g_quark_to_string (_tmp25_);
				_tmp27_ = e;
				_tmp28_ = _tmp27_->code;
				_tmp29_ = g_strdup_printf ("%i", _tmp28_);
				_tmp30_ = _tmp29_;
				_tmp31_ = e;
				_tmp32_ = _tmp31_->message;
				_tmp33_ = string_to_string (_tmp32_);
				_tmp34_ = g_strconcat ("Got ", _tmp26_, " ", _tmp30_, " ", _tmp33_, NULL);
				_tmp35_ = _tmp34_;
				_g_free0 (_tmp30_);
				x = _tmp35_;
				_tmp36_ = x;
				_tmp37_ = g_strdup (_tmp36_);
				_g_free0 (cmderr);
				cmderr = _tmp37_;
				_tmp38_ = g_strdup ("");
				_g_free0 (cmdout);
				cmdout = _tmp38_;
				_g_free0 (x);
				_g_error_free0 (e);
			}
			__finally64:
			if (_inner_error_ != NULL) {
				_g_free0 (cmderr);
				_g_free0 (cmdout);
				netsukuku_impl_linux_struct_helper_ntk_linux_sequential_command_destroy (&tuple_p);
				goto __catch63_g_error;
			}
			tasklets_ms_wait ((gint64) 10);
			_tmp39_ = netsukuku_impl_linux_get_sequential_command_channel ();
			_tmp40_ = _tmp39_;
			_tmp41_ = exit_status;
			g_value_init (&_tmp42_, G_TYPE_INT);
			g_value_set_int (&_tmp42_, _tmp41_);
			tasklets_channel_send (_tmp40_, &_tmp42_);
			G_IS_VALUE (&_tmp42_) ? (g_value_unset (&_tmp42_), NULL) : NULL;
			_g_object_unref0 (_tmp40_);
			_tmp43_ = netsukuku_impl_linux_get_sequential_command_channel ();
			_tmp44_ = _tmp43_;
			_tmp45_ = cmdout;
			g_value_init (&_tmp46_, G_TYPE_STRING);
			g_value_set_string (&_tmp46_, _tmp45_);
			tasklets_channel_send (_tmp44_, &_tmp46_);
			G_IS_VALUE (&_tmp46_) ? (g_value_unset (&_tmp46_), NULL) : NULL;
			_g_object_unref0 (_tmp44_);
			_tmp47_ = netsukuku_impl_linux_get_sequential_command_channel ();
			_tmp48_ = _tmp47_;
			_tmp49_ = cmderr;
			g_value_init (&_tmp50_, G_TYPE_STRING);
			g_value_set_string (&_tmp50_, _tmp49_);
			tasklets_channel_send (_tmp48_, &_tmp50_);
			G_IS_VALUE (&_tmp50_) ? (g_value_unset (&_tmp50_), NULL) : NULL;
			_g_object_unref0 (_tmp48_);
			tasklets_tasklet_schedule (NULL);
			_g_free0 (cmderr);
			_g_free0 (cmdout);
			netsukuku_impl_linux_struct_helper_ntk_linux_sequential_command_destroy (&tuple_p);
		}
		goto __finally63;
		__catch63_g_error:
		{
			GError* e = NULL;
			GError* _tmp51_;
			const gchar* _tmp52_;
			const gchar* _tmp53_ = NULL;
			gchar* _tmp54_ = NULL;
			gchar* _tmp55_;
			e = _inner_error_;
			_inner_error_ = NULL;
			_tmp51_ = e;
			_tmp52_ = _tmp51_->message;
			_tmp53_ = string_to_string (_tmp52_);
			_tmp54_ = g_strconcat ("Sequential command spawning reported an error: ", _tmp53_, NULL);
			_tmp55_ = _tmp54_;
			netsukuku_log_warn (_tmp55_);
			_g_free0 (_tmp55_);
			_g_error_free0 (e);
		}
		__finally63:
		if (_inner_error_ != NULL) {
			_g_free0 (doing);
			_g_object_unref0 (ch);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
		_tmp56_ = doing;
		if (_tmp56_ != NULL) {
			const gchar* _tmp57_;
			_tmp57_ = doing;
			tasklets_tasklet_declare_finished (_tmp57_);
		}
		_g_free0 (doing);
	}
	_g_object_unref0 (ch);
	return result;
}


/** Launch a process and block this tasklet till it ends.
      * Makes sure that a previous call (from any other tasklet) has been completed.
      * Returns exit status, stdout and stderr.
      */
void netsukuku_impl_linux_sequential_command (const gchar* cmdline, gchar** cmdout, gchar** cmderr, gint* exit_status) {
	gchar* _vala_cmdout = NULL;
	gchar* _vala_cmderr = NULL;
	gint _vala_exit_status = 0;
	TaskletsChannel* _tmp0_ = NULL;
	TaskletsChannel* ch;
	NetsukukuImplLinuxstruct_helper_ntk_linux_sequential_command arg = {0};
	const gchar* _tmp1_;
	gchar* _tmp2_;
	NetsukukuImplLinuxstruct_helper_ntk_linux_sequential_command _tmp3_;
	GValue _tmp4_ = {0};
	TaskletsChannel* _tmp5_ = NULL;
	TaskletsChannel* _tmp6_;
	GValue _tmp7_ = {0};
	TaskletsChannel* _tmp8_ = NULL;
	TaskletsChannel* _tmp9_;
	GValue _tmp10_ = {0};
	TaskletsChannel* _tmp11_ = NULL;
	TaskletsChannel* _tmp12_;
	GValue _tmp13_ = {0};
	g_return_if_fail (cmdline != NULL);
	_tmp0_ = tasklets_tasklet_dispatcher_get_channel_for_helper ((FunctionDelegate) netsukuku_impl_linux_helper_sequential_command, -1);
	ch = _tmp0_;
	memset (&arg, 0, sizeof (NetsukukuImplLinuxstruct_helper_ntk_linux_sequential_command));
	_tmp1_ = cmdline;
	_tmp2_ = g_strdup (_tmp1_);
	_g_free0 (arg.cmdline);
	arg.cmdline = _tmp2_;
	_tmp3_ = arg;
	g_value_init (&_tmp4_, NETSUKUKU_IMPL_LINUX_TYPE_STRUCT_HELPER_NTK_LINUX_SEQUENTIAL_COMMAND);
	g_value_set_boxed (&_tmp4_, &_tmp3_);
	tasklets_channel_send (ch, &_tmp4_);
	G_IS_VALUE (&_tmp4_) ? (g_value_unset (&_tmp4_), NULL) : NULL;
	_tmp5_ = netsukuku_impl_linux_get_sequential_command_channel ();
	_tmp6_ = _tmp5_;
	tasklets_channel_recv (_tmp6_, &_tmp7_);
	_vala_exit_status = g_value_get_int (&_tmp7_);
	_g_object_unref0 (_tmp6_);
	_tmp8_ = netsukuku_impl_linux_get_sequential_command_channel ();
	_tmp9_ = _tmp8_;
	tasklets_channel_recv (_tmp9_, &_tmp10_);
	_g_free0 (_vala_cmdout);
	_vala_cmdout = g_value_get_string (&_tmp10_);
	_g_object_unref0 (_tmp9_);
	_tmp11_ = netsukuku_impl_linux_get_sequential_command_channel ();
	_tmp12_ = _tmp11_;
	tasklets_channel_recv (_tmp12_, &_tmp13_);
	_g_free0 (_vala_cmderr);
	_vala_cmderr = g_value_get_string (&_tmp13_);
	_g_object_unref0 (_tmp12_);
	netsukuku_impl_linux_struct_helper_ntk_linux_sequential_command_destroy (&arg);
	_g_object_unref0 (ch);
	if (cmdout) {
		*cmdout = _vala_cmdout;
	} else {
		_g_free0 (_vala_cmdout);
	}
	if (cmderr) {
		*cmderr = _vala_cmderr;
	} else {
		_g_free0 (_vala_cmderr);
	}
	if (exit_status) {
		*exit_status = _vala_exit_status;
	}
}


GQuark netsukuku_impl_linux_iproute_command_error_quark (void) {
	return g_quark_from_static_string ("netsukuku_impl_linux_iproute_command_error-quark");
}


/** An iproute wrapper
      */
gchar* netsukuku_impl_linux_iproute (const gchar* args, GError** error) {
	gchar* result = NULL;
	const gchar* _tmp0_;
	const gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* cmd;
	gboolean _tmp3_ = FALSE;
	const gchar* _tmp4_;
	gboolean _tmp6_;
	gchar* cmdout = NULL;
	gchar* cmderr = NULL;
	gint exit_status = 0;
	const gchar* _tmp12_;
	gchar* _tmp13_;
	gchar* _tmp14_;
	const gchar* _tmp15_;
	gchar* _tmp16_;
	gchar* _tmp17_;
	gchar* _tmp18_ = NULL;
	gchar* _tmp19_ = NULL;
	gint _tmp20_ = 0;
	gint _tmp21_;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (args != NULL, NULL);
	_tmp0_ = netsukuku_settings_get_IPROUTE_PATH ();
	_tmp1_ = _tmp0_;
	_tmp2_ = g_strdup (_tmp1_);
	cmd = _tmp2_;
	_tmp4_ = cmd;
	if (_tmp4_ == NULL) {
		_tmp3_ = TRUE;
	} else {
		const gchar* _tmp5_;
		_tmp5_ = cmd;
		_tmp3_ = g_strcmp0 (_tmp5_, "") == 0;
	}
	_tmp6_ = _tmp3_;
	if (_tmp6_) {
		const gchar* _tmp7_;
		const gchar* _tmp8_;
		const gchar* _tmp9_;
		const gchar* _tmp10_;
		gchar* _tmp11_;
		_tmp7_ = netsukuku_settings_get_IPROUTE_PATH ();
		_tmp8_ = _tmp7_;
		netsukuku_settings_set_IPROUTE_PATH ("ip");
		_tmp9_ = netsukuku_settings_get_IPROUTE_PATH ();
		_tmp10_ = _tmp9_;
		_tmp11_ = g_strdup (_tmp10_);
		_g_free0 (cmd);
		cmd = _tmp11_;
	}
	_tmp12_ = cmd;
	_tmp13_ = g_strconcat (_tmp12_, " ", NULL);
	_tmp14_ = _tmp13_;
	_tmp15_ = args;
	_tmp16_ = g_strconcat (_tmp14_, _tmp15_, NULL);
	_tmp17_ = _tmp16_;
	netsukuku_impl_linux_sequential_command (_tmp17_, &_tmp18_, &_tmp19_, &_tmp20_);
	_g_free0 (cmdout);
	cmdout = _tmp18_;
	_g_free0 (cmderr);
	cmderr = _tmp19_;
	exit_status = _tmp20_;
	_g_free0 (_tmp17_);
	_g_free0 (_tmp14_);
	_tmp21_ = exit_status;
	if (_tmp21_ != 0) {
		const gchar* _tmp22_;
		GError* _tmp23_;
		_tmp22_ = cmderr;
		_tmp23_ = g_error_new_literal (NETSUKUKU_IMPL_LINUX_IPROUTE_COMMAND_ERROR, NETSUKUKU_IMPL_LINUX_IPROUTE_COMMAND_ERROR_GENERIC, _tmp22_);
		_inner_error_ = _tmp23_;
		if (_inner_error_->domain == NETSUKUKU_IMPL_LINUX_IPROUTE_COMMAND_ERROR) {
			g_propagate_error (error, _inner_error_);
			_g_free0 (cmderr);
			_g_free0 (cmdout);
			_g_free0 (cmd);
			return NULL;
		} else {
			_g_free0 (cmderr);
			_g_free0 (cmdout);
			_g_free0 (cmd);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	}
	result = cmdout;
	_g_free0 (cmderr);
	_g_free0 (cmd);
	return result;
}


/** An iproute without exceptions
      */
void netsukuku_impl_linux_iproute_exp (const gchar* args) {
	GError * _inner_error_ = NULL;
	g_return_if_fail (args != NULL);
	{
		const gchar* _tmp0_;
		gchar* _tmp1_ = NULL;
		gchar* _tmp2_;
		_tmp0_ = args;
		_tmp1_ = netsukuku_impl_linux_iproute (_tmp0_, &_inner_error_);
		_tmp2_ = _tmp1_;
		_g_free0 (_tmp2_);
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == NETSUKUKU_IMPL_LINUX_IPROUTE_COMMAND_ERROR) {
				goto __catch65_netsukuku_impl_linux_iproute_command_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
	}
	goto __finally65;
	__catch65_netsukuku_impl_linux_iproute_command_error:
	{
		GError* e = NULL;
		GError* _tmp3_;
		const gchar* _tmp4_;
		const gchar* _tmp5_ = NULL;
		gchar* _tmp6_ = NULL;
		gchar* _tmp7_;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp3_ = e;
		_tmp4_ = _tmp3_->message;
		_tmp5_ = string_to_string (_tmp4_);
		_tmp6_ = g_strconcat ("Iproute: Got following exception, but proceeding anyway: ", _tmp5_, NULL);
		_tmp7_ = _tmp6_;
		netsukuku_log_warn (_tmp7_);
		_g_free0 (_tmp7_);
		_g_error_free0 (e);
	}
	__finally65:
	if (_inner_error_ != NULL) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
}


GQuark netsukuku_impl_linux_iptables_command_error_quark (void) {
	return g_quark_from_static_string ("netsukuku_impl_linux_iptables_command_error-quark");
}


/** An iptables wrapper
      */
gchar* netsukuku_impl_linux_iptables (const gchar* args, GError** error) {
	gchar* result = NULL;
	const gchar* _tmp0_;
	const gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* cmd;
	gboolean _tmp3_ = FALSE;
	const gchar* _tmp4_;
	gboolean _tmp6_;
	gchar* cmdout = NULL;
	gchar* cmderr = NULL;
	gint exit_status = 0;
	const gchar* _tmp12_;
	gchar* _tmp13_;
	gchar* _tmp14_;
	const gchar* _tmp15_;
	gchar* _tmp16_;
	gchar* _tmp17_;
	gchar* _tmp18_ = NULL;
	gchar* _tmp19_ = NULL;
	gint _tmp20_ = 0;
	gint _tmp21_;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (args != NULL, NULL);
	_tmp0_ = netsukuku_settings_get_IPTABLES_PATH ();
	_tmp1_ = _tmp0_;
	_tmp2_ = g_strdup (_tmp1_);
	cmd = _tmp2_;
	_tmp4_ = cmd;
	if (_tmp4_ == NULL) {
		_tmp3_ = TRUE;
	} else {
		const gchar* _tmp5_;
		_tmp5_ = cmd;
		_tmp3_ = g_strcmp0 (_tmp5_, "") == 0;
	}
	_tmp6_ = _tmp3_;
	if (_tmp6_) {
		const gchar* _tmp7_;
		const gchar* _tmp8_;
		const gchar* _tmp9_;
		const gchar* _tmp10_;
		gchar* _tmp11_;
		_tmp7_ = netsukuku_settings_get_IPTABLES_PATH ();
		_tmp8_ = _tmp7_;
		netsukuku_settings_set_IPTABLES_PATH ("iptables");
		_tmp9_ = netsukuku_settings_get_IPTABLES_PATH ();
		_tmp10_ = _tmp9_;
		_tmp11_ = g_strdup (_tmp10_);
		_g_free0 (cmd);
		cmd = _tmp11_;
	}
	_tmp12_ = cmd;
	_tmp13_ = g_strconcat (_tmp12_, " ", NULL);
	_tmp14_ = _tmp13_;
	_tmp15_ = args;
	_tmp16_ = g_strconcat (_tmp14_, _tmp15_, NULL);
	_tmp17_ = _tmp16_;
	netsukuku_impl_linux_sequential_command (_tmp17_, &_tmp18_, &_tmp19_, &_tmp20_);
	_g_free0 (cmdout);
	cmdout = _tmp18_;
	_g_free0 (cmderr);
	cmderr = _tmp19_;
	exit_status = _tmp20_;
	_g_free0 (_tmp17_);
	_g_free0 (_tmp14_);
	_tmp21_ = exit_status;
	if (_tmp21_ != 0) {
		const gchar* _tmp22_;
		GError* _tmp23_;
		_tmp22_ = cmderr;
		_tmp23_ = g_error_new_literal (NETSUKUKU_IMPL_LINUX_IPTABLES_COMMAND_ERROR, NETSUKUKU_IMPL_LINUX_IPTABLES_COMMAND_ERROR_GENERIC, _tmp22_);
		_inner_error_ = _tmp23_;
		if (_inner_error_->domain == NETSUKUKU_IMPL_LINUX_IPTABLES_COMMAND_ERROR) {
			g_propagate_error (error, _inner_error_);
			_g_free0 (cmderr);
			_g_free0 (cmdout);
			_g_free0 (cmd);
			return NULL;
		} else {
			_g_free0 (cmderr);
			_g_free0 (cmdout);
			_g_free0 (cmd);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	}
	result = cmdout;
	_g_free0 (cmderr);
	_g_free0 (cmd);
	return result;
}


/** An iptables without exceptions
      */
void netsukuku_impl_linux_iptables_exp (const gchar* args) {
	GError * _inner_error_ = NULL;
	g_return_if_fail (args != NULL);
	{
		const gchar* _tmp0_;
		gchar* _tmp1_ = NULL;
		gchar* _tmp2_;
		_tmp0_ = args;
		_tmp1_ = netsukuku_impl_linux_iptables (_tmp0_, &_inner_error_);
		_tmp2_ = _tmp1_;
		_g_free0 (_tmp2_);
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == NETSUKUKU_IMPL_LINUX_IPTABLES_COMMAND_ERROR) {
				goto __catch66_netsukuku_impl_linux_iptables_command_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
	}
	goto __finally66;
	__catch66_netsukuku_impl_linux_iptables_command_error:
	{
		GError* e = NULL;
		GError* _tmp3_;
		const gchar* _tmp4_;
		const gchar* _tmp5_ = NULL;
		gchar* _tmp6_ = NULL;
		gchar* _tmp7_;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp3_ = e;
		_tmp4_ = _tmp3_->message;
		_tmp5_ = string_to_string (_tmp4_);
		_tmp6_ = g_strconcat ("Iptables: Got following exception, but proceeding anyway: ", _tmp5_, NULL);
		_tmp7_ = _tmp6_;
		netsukuku_log_warn (_tmp7_);
		_g_free0 (_tmp7_);
		_g_error_free0 (e);
	}
	__finally66:
	if (_inner_error_ != NULL) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
}


/** Check reachability of an IP
      */
gboolean netsukuku_impl_linux_check_ping (const gchar* ipstr) {
	gboolean result = FALSE;
	const gchar* _tmp0_;
	const gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* cmd;
	gboolean _tmp3_ = FALSE;
	const gchar* _tmp4_;
	gboolean _tmp6_;
	gint exit_status = 0;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (ipstr != NULL, FALSE);
	_tmp0_ = netsukuku_settings_get_PING_PATH ();
	_tmp1_ = _tmp0_;
	_tmp2_ = g_strdup (_tmp1_);
	cmd = _tmp2_;
	_tmp4_ = cmd;
	if (_tmp4_ == NULL) {
		_tmp3_ = TRUE;
	} else {
		const gchar* _tmp5_;
		_tmp5_ = cmd;
		_tmp3_ = g_strcmp0 (_tmp5_, "") == 0;
	}
	_tmp6_ = _tmp3_;
	if (_tmp6_) {
		const gchar* _tmp7_;
		const gchar* _tmp8_;
		const gchar* _tmp9_;
		const gchar* _tmp10_;
		gchar* _tmp11_;
		_tmp7_ = netsukuku_settings_get_PING_PATH ();
		_tmp8_ = _tmp7_;
		netsukuku_settings_set_PING_PATH ("ping");
		_tmp9_ = netsukuku_settings_get_PING_PATH ();
		_tmp10_ = _tmp9_;
		_tmp11_ = g_strdup (_tmp10_);
		_g_free0 (cmd);
		cmd = _tmp11_;
	}
	{
		const gchar* _tmp12_;
		const gchar* _tmp13_ = NULL;
		const gchar* _tmp14_;
		const gchar* _tmp15_ = NULL;
		gchar* _tmp16_ = NULL;
		gchar* _tmp17_;
		TaskletsCommandResult* _tmp18_ = NULL;
		TaskletsCommandResult* _tmp19_;
		TaskletsCommandResult* com_ret;
		gint _tmp20_;
		_tmp12_ = cmd;
		_tmp13_ = string_to_string (_tmp12_);
		_tmp14_ = ipstr;
		_tmp15_ = string_to_string (_tmp14_);
		_tmp16_ = g_strconcat (_tmp13_, " -c 1 ", _tmp15_, " -W 1", NULL);
		_tmp17_ = _tmp16_;
		_tmp18_ = netsukuku_impl_linux_exec_command (_tmp17_, &_inner_error_);
		_tmp19_ = _tmp18_;
		_g_free0 (_tmp17_);
		com_ret = _tmp19_;
		if (_inner_error_ != NULL) {
			goto __catch67_g_error;
		}
		_tmp20_ = com_ret->exit_status;
		exit_status = _tmp20_;
		_g_object_unref0 (com_ret);
	}
	goto __finally67;
	__catch67_g_error:
	{
		GError* e = NULL;
		GQuark _tmp21_;
		const gchar* _tmp22_ = NULL;
		const gchar* _tmp23_ = NULL;
		gint _tmp24_;
		gchar* _tmp25_ = NULL;
		gchar* _tmp26_;
		const gchar* _tmp27_;
		const gchar* _tmp28_ = NULL;
		gchar* _tmp29_ = NULL;
		gchar* _tmp30_;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp21_ = e->domain;
		_tmp22_ = g_quark_to_string (_tmp21_);
		_tmp23_ = string_to_string (_tmp22_);
		_tmp24_ = e->code;
		_tmp25_ = g_strdup_printf ("%i", _tmp24_);
		_tmp26_ = _tmp25_;
		_tmp27_ = e->message;
		_tmp28_ = string_to_string (_tmp27_);
		_tmp29_ = g_strconcat ("linux: check_ping: ", _tmp23_, " ", _tmp26_, " ", _tmp28_, NULL);
		_tmp30_ = _tmp29_;
		g_error ("network_linux.vala:238: %s", _tmp30_);
		_g_free0 (_tmp30_);
		_g_free0 (_tmp26_);
		_g_error_free0 (e);
	}
	__finally67:
	if (_inner_error_ != NULL) {
		_g_free0 (cmd);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return FALSE;
	}
	result = exit_status == 0;
	_g_free0 (cmd);
	return result;
}


void netsukuku_impl_linux_write_file (const gchar* pathname, guint8* buf, int buf_length1) {
	const gchar* _tmp0_;
	FILE* _tmp1_ = NULL;
	FILE* fout;
	FILE* _tmp2_;
	FILE* _tmp8_;
	guint8* _tmp9_;
	gint _tmp9__length1;
	g_return_if_fail (pathname != NULL);
	_tmp0_ = pathname;
	_tmp1_ = g_fopen (_tmp0_, "w");
	fout = _tmp1_;
	_tmp2_ = fout;
	if (_tmp2_ == NULL) {
		gint _tmp3_;
		const gchar* _tmp4_ = NULL;
		const gchar* _tmp5_ = NULL;
		gchar* _tmp6_ = NULL;
		gchar* _tmp7_;
		_tmp3_ = errno;
		_tmp4_ = g_strerror (_tmp3_);
		_tmp5_ = string_to_string (_tmp4_);
		_tmp6_ = g_strconcat ("linux: write_file: ", _tmp5_, NULL);
		_tmp7_ = _tmp6_;
		netsukuku_log_error (_tmp7_);
		_g_free0 (_tmp7_);
		_vala_assert (FALSE, "false");
	}
	_tmp8_ = fout;
	_tmp9_ = buf;
	_tmp9__length1 = buf_length1;
	fwrite (_tmp9_, (gsize) 1, _tmp9__length1, _tmp8_);
	_fclose0 (fout);
}


guint8* netsukuku_impl_linux_read_file (const gchar* pathname, gint maxlen, int* result_length1) {
	guint8* result = NULL;
	gint _tmp0_;
	guint8* _tmp1_ = NULL;
	guint8* buf;
	gint buf_length1;
	gint _buf_size_;
	const gchar* _tmp2_;
	FILE* _tmp3_ = NULL;
	FILE* fin;
	FILE* _tmp4_;
	FILE* _tmp6_;
	guint8* _tmp7_;
	gint _tmp7__length1;
	gsize _tmp8_ = 0UL;
	gsize len;
	gsize _tmp9_;
	guint8* _tmp10_ = NULL;
	guint8* ret;
	gint ret_length1;
	gint _ret_size_;
	guint8* _tmp22_;
	gint _tmp22__length1;
	g_return_val_if_fail (pathname != NULL, NULL);
	_tmp0_ = maxlen;
	_tmp1_ = g_new0 (guint8, _tmp0_);
	buf = _tmp1_;
	buf_length1 = _tmp0_;
	_buf_size_ = buf_length1;
	_tmp2_ = pathname;
	_tmp3_ = g_fopen (_tmp2_, "r");
	fin = _tmp3_;
	_tmp4_ = fin;
	if (_tmp4_ == NULL) {
		guint8* _tmp5_;
		gint _tmp5__length1;
		_tmp5_ = NULL;
		_tmp5__length1 = 0;
		if (result_length1) {
			*result_length1 = _tmp5__length1;
		}
		result = _tmp5_;
		_fclose0 (fin);
		buf = (g_free (buf), NULL);
		return result;
	}
	_tmp6_ = fin;
	_tmp7_ = buf;
	_tmp7__length1 = buf_length1;
	_tmp8_ = fread (_tmp7_, (gsize) 1, _tmp7__length1, _tmp6_);
	len = _tmp8_;
	_tmp9_ = len;
	_tmp10_ = g_new0 (guint8, _tmp9_);
	ret = _tmp10_;
	ret_length1 = _tmp9_;
	_ret_size_ = ret_length1;
	{
		gint i;
		i = 0;
		{
			gboolean _tmp11_;
			_tmp11_ = TRUE;
			while (TRUE) {
				gboolean _tmp12_;
				gint _tmp14_;
				gsize _tmp15_;
				guint8* _tmp16_;
				gint _tmp16__length1;
				gint _tmp17_;
				guint8* _tmp18_;
				gint _tmp18__length1;
				gint _tmp19_;
				guint8 _tmp20_;
				guint8 _tmp21_;
				_tmp12_ = _tmp11_;
				if (!_tmp12_) {
					gint _tmp13_;
					_tmp13_ = i;
					i = _tmp13_ + 1;
				}
				_tmp11_ = FALSE;
				_tmp14_ = i;
				_tmp15_ = len;
				if (!(((gsize) _tmp14_) < _tmp15_)) {
					break;
				}
				_tmp16_ = ret;
				_tmp16__length1 = ret_length1;
				_tmp17_ = i;
				_tmp18_ = buf;
				_tmp18__length1 = buf_length1;
				_tmp19_ = i;
				_tmp20_ = _tmp18_[_tmp19_];
				_tmp16_[_tmp17_] = _tmp20_;
				_tmp21_ = _tmp16_[_tmp17_];
			}
		}
	}
	_tmp22_ = ret;
	_tmp22__length1 = ret_length1;
	if (result_length1) {
		*result_length1 = _tmp22__length1;
	}
	result = _tmp22_;
	_fclose0 (fin);
	buf = (g_free (buf), NULL);
	return result;
}


static NetsukukuNIC* _netsukuku_impl_linux_linux_nic_create (const gchar* nic_name) {
	NetsukukuNIC* result = NULL;
	const gchar* _tmp0_;
	NetsukukuImplLinuxLinuxNIC* _tmp1_;
	g_return_val_if_fail (nic_name != NULL, NULL);
	_tmp0_ = nic_name;
	_tmp1_ = netsukuku_impl_linux_linux_nic_new (_tmp0_);
	result = (NetsukukuNIC*) _tmp1_;
	return result;
}


static NetsukukuNIC* __netsukuku_impl_linux_linux_nic_create_netsukuku_create_nic_delegate (const gchar* nic_name, gpointer self) {
	NetsukukuNIC* result;
	result = _netsukuku_impl_linux_linux_nic_create (nic_name);
	return result;
}


void netsukuku_impl_linux_linux_nic_register (void) {
	netsukuku_nic_register_class ("linux", __netsukuku_impl_linux_linux_nic_create_netsukuku_create_nic_delegate, NULL);
}


NetsukukuImplLinuxLinuxNIC* netsukuku_impl_linux_linux_nic_construct (GType object_type, const gchar* nic_name) {
	NetsukukuImplLinuxLinuxNIC * self = NULL;
	const gchar* _tmp0_;
	g_return_val_if_fail (nic_name != NULL, NULL);
	_tmp0_ = nic_name;
	self = (NetsukukuImplLinuxLinuxNIC*) netsukuku_nic_construct (object_type, _tmp0_);
	_g_free0 (self->priv->_mac);
	self->priv->_mac = NULL;
	return self;
}


NetsukukuImplLinuxLinuxNIC* netsukuku_impl_linux_linux_nic_new (const gchar* nic_name) {
	return netsukuku_impl_linux_linux_nic_construct (NETSUKUKU_IMPL_LINUX_TYPE_LINUX_NIC, nic_name);
}


static const gchar* netsukuku_impl_linux_linux_nic_real__mac_getter (NetsukukuNIC* base) {
	NetsukukuImplLinuxLinuxNIC * self;
	const gchar* result = NULL;
	const gchar* _tmp0_;
	const gchar* _tmp13_;
	GError * _inner_error_ = NULL;
	self = (NetsukukuImplLinuxLinuxNIC*) base;
	_tmp0_ = self->priv->_mac;
	if (_tmp0_ == NULL) {
		{
			GRegex* _tmp1_;
			GRegex* r;
			const gchar* _tmp2_;
			const gchar* _tmp3_ = NULL;
			gchar* _tmp4_ = NULL;
			gchar* _tmp5_;
			gchar* _tmp6_ = NULL;
			gchar* _tmp7_;
			gchar* cmdout;
			GMatchInfo* match_info = NULL;
			GRegex* _tmp8_;
			const gchar* _tmp9_;
			GMatchInfo* _tmp10_ = NULL;
			GMatchInfo* _tmp11_;
			gchar* _tmp12_ = NULL;
			_tmp1_ = g_regex_new ("([a-fA-F0-9]{2}[:|\\-]?){6}", 0, 0, &_inner_error_);
			r = _tmp1_;
			if (_inner_error_ != NULL) {
				goto __catch68_g_error;
			}
			_tmp2_ = ((NetsukukuNIC*) self)->name;
			_tmp3_ = string_to_string (_tmp2_);
			_tmp4_ = g_strconcat ("link show ", _tmp3_, NULL);
			_tmp5_ = _tmp4_;
			_tmp6_ = netsukuku_impl_linux_iproute (_tmp5_, &_inner_error_);
			_tmp7_ = _tmp6_;
			_g_free0 (_tmp5_);
			cmdout = _tmp7_;
			if (_inner_error_ != NULL) {
				_g_regex_unref0 (r);
				goto __catch68_g_error;
			}
			_tmp8_ = r;
			_tmp9_ = cmdout;
			g_regex_match (_tmp8_, _tmp9_, 0, &_tmp10_);
			_g_match_info_free0 (match_info);
			match_info = _tmp10_;
			_tmp11_ = match_info;
			_tmp12_ = g_match_info_fetch (_tmp11_, 0);
			_g_free0 (self->priv->_mac);
			self->priv->_mac = _tmp12_;
			_g_match_info_free0 (match_info);
			_g_free0 (cmdout);
			_g_regex_unref0 (r);
		}
		goto __finally68;
		__catch68_g_error:
		{
			GError* e = NULL;
			e = _inner_error_;
			_inner_error_ = NULL;
			_g_error_free0 (e);
		}
		__finally68:
		if (_inner_error_ != NULL) {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	}
	_tmp13_ = self->priv->_mac;
	result = _tmp13_;
	return result;
}


static gboolean netsukuku_impl_linux_linux_nic_real__is_active_getter (NetsukukuNIC* base) {
	NetsukukuImplLinuxLinuxNIC * self;
	gboolean result = FALSE;
	GError * _inner_error_ = NULL;
	self = (NetsukukuImplLinuxLinuxNIC*) base;
	{
		GRegex* _tmp0_;
		GRegex* r2;
		const gchar* _tmp1_;
		const gchar* _tmp2_ = NULL;
		gchar* _tmp3_ = NULL;
		gchar* _tmp4_;
		gchar* _tmp5_ = NULL;
		gchar* _tmp6_;
		gchar* cmdout;
		GRegex* _tmp7_;
		const gchar* _tmp8_;
		gboolean _tmp9_ = FALSE;
		_tmp0_ = g_regex_new ("<.*,(UP),.*>", 0, 0, &_inner_error_);
		r2 = _tmp0_;
		if (_inner_error_ != NULL) {
			goto __catch69_g_error;
		}
		_tmp1_ = ((NetsukukuNIC*) self)->name;
		_tmp2_ = string_to_string (_tmp1_);
		_tmp3_ = g_strconcat ("link show ", _tmp2_, NULL);
		_tmp4_ = _tmp3_;
		_tmp5_ = netsukuku_impl_linux_iproute (_tmp4_, &_inner_error_);
		_tmp6_ = _tmp5_;
		_g_free0 (_tmp4_);
		cmdout = _tmp6_;
		if (_inner_error_ != NULL) {
			_g_regex_unref0 (r2);
			goto __catch69_g_error;
		}
		_tmp7_ = r2;
		_tmp8_ = cmdout;
		_tmp9_ = g_regex_match (_tmp7_, _tmp8_, 0, NULL);
		result = _tmp9_;
		_g_free0 (cmdout);
		_g_regex_unref0 (r2);
		return result;
	}
	goto __finally69;
	__catch69_g_error:
	{
		GError* e = NULL;
		e = _inner_error_;
		_inner_error_ = NULL;
		_g_error_free0 (e);
	}
	__finally69:
	if (_inner_error_ != NULL) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return FALSE;
	}
	result = FALSE;
	return result;
}


static void netsukuku_impl_linux_linux_nic_real__up (NetsukukuNIC* base) {
	NetsukukuImplLinuxLinuxNIC * self;
	GError * _inner_error_ = NULL;
	self = (NetsukukuImplLinuxLinuxNIC*) base;
	{
		const gchar* _tmp0_;
		const gchar* _tmp1_ = NULL;
		gchar* _tmp2_ = NULL;
		gchar* _tmp3_;
		gchar* _tmp4_ = NULL;
		gchar* _tmp5_;
		_tmp0_ = ((NetsukukuNIC*) self)->name;
		_tmp1_ = string_to_string (_tmp0_);
		_tmp2_ = g_strconcat ("link set ", _tmp1_, " up", NULL);
		_tmp3_ = _tmp2_;
		_tmp4_ = netsukuku_impl_linux_iproute (_tmp3_, &_inner_error_);
		_tmp5_ = _tmp4_;
		_g_free0 (_tmp5_);
		_g_free0 (_tmp3_);
		if (_inner_error_ != NULL) {
			goto __catch70_g_error;
		}
	}
	goto __finally70;
	__catch70_g_error:
	{
		GError* e = NULL;
		GQuark _tmp6_;
		const gchar* _tmp7_ = NULL;
		const gchar* _tmp8_ = NULL;
		gint _tmp9_;
		gchar* _tmp10_ = NULL;
		gchar* _tmp11_;
		const gchar* _tmp12_;
		const gchar* _tmp13_ = NULL;
		gchar* _tmp14_ = NULL;
		gchar* _tmp15_;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp6_ = e->domain;
		_tmp7_ = g_quark_to_string (_tmp6_);
		_tmp8_ = string_to_string (_tmp7_);
		_tmp9_ = e->code;
		_tmp10_ = g_strdup_printf ("%i", _tmp9_);
		_tmp11_ = _tmp10_;
		_tmp12_ = e->message;
		_tmp13_ = string_to_string (_tmp12_);
		_tmp14_ = g_strconcat ("LinuxNIC: _up: ", _tmp8_, " ", _tmp11_, " ", _tmp13_, NULL);
		_tmp15_ = _tmp14_;
		g_error ("network_linux.vala:313: %s", _tmp15_);
		_g_free0 (_tmp15_);
		_g_free0 (_tmp11_);
		_g_error_free0 (e);
	}
	__finally70:
	if (_inner_error_ != NULL) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
}


static void netsukuku_impl_linux_linux_nic_real__down (NetsukukuNIC* base) {
	NetsukukuImplLinuxLinuxNIC * self;
	GError * _inner_error_ = NULL;
	self = (NetsukukuImplLinuxLinuxNIC*) base;
	{
		const gchar* _tmp0_;
		const gchar* _tmp1_ = NULL;
		gchar* _tmp2_ = NULL;
		gchar* _tmp3_;
		gchar* _tmp4_ = NULL;
		gchar* _tmp5_;
		_tmp0_ = ((NetsukukuNIC*) self)->name;
		_tmp1_ = string_to_string (_tmp0_);
		_tmp2_ = g_strconcat ("link set ", _tmp1_, " down", NULL);
		_tmp3_ = _tmp2_;
		_tmp4_ = netsukuku_impl_linux_iproute (_tmp3_, &_inner_error_);
		_tmp5_ = _tmp4_;
		_g_free0 (_tmp5_);
		_g_free0 (_tmp3_);
		if (_inner_error_ != NULL) {
			goto __catch71_g_error;
		}
	}
	goto __finally71;
	__catch71_g_error:
	{
		GError* e = NULL;
		GQuark _tmp6_;
		const gchar* _tmp7_ = NULL;
		const gchar* _tmp8_ = NULL;
		gint _tmp9_;
		gchar* _tmp10_ = NULL;
		gchar* _tmp11_;
		const gchar* _tmp12_;
		const gchar* _tmp13_ = NULL;
		gchar* _tmp14_ = NULL;
		gchar* _tmp15_;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp6_ = e->domain;
		_tmp7_ = g_quark_to_string (_tmp6_);
		_tmp8_ = string_to_string (_tmp7_);
		_tmp9_ = e->code;
		_tmp10_ = g_strdup_printf ("%i", _tmp9_);
		_tmp11_ = _tmp10_;
		_tmp12_ = e->message;
		_tmp13_ = string_to_string (_tmp12_);
		_tmp14_ = g_strconcat ("LinuxNIC: _down: ", _tmp8_, " ", _tmp11_, " ", _tmp13_, NULL);
		_tmp15_ = _tmp14_;
		g_error ("network_linux.vala:321: %s", _tmp15_);
		_g_free0 (_tmp15_);
		_g_free0 (_tmp11_);
		_g_error_free0 (e);
	}
	__finally71:
	if (_inner_error_ != NULL) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
}


static void netsukuku_impl_linux_linux_nic_real__add_address (NetsukukuNIC* base, const gchar* address) {
	NetsukukuImplLinuxLinuxNIC * self;
	GError * _inner_error_ = NULL;
	self = (NetsukukuImplLinuxLinuxNIC*) base;
	g_return_if_fail (address != NULL);
	{
		const gchar* _tmp0_;
		const gchar* _tmp1_ = NULL;
		const gchar* _tmp2_;
		const gchar* _tmp3_ = NULL;
		gchar* _tmp4_ = NULL;
		gchar* _tmp5_;
		gchar* _tmp6_ = NULL;
		gchar* _tmp7_;
		_tmp0_ = address;
		_tmp1_ = string_to_string (_tmp0_);
		_tmp2_ = ((NetsukukuNIC*) self)->name;
		_tmp3_ = string_to_string (_tmp2_);
		_tmp4_ = g_strconcat ("addr add ", _tmp1_, " dev ", _tmp3_, NULL);
		_tmp5_ = _tmp4_;
		_tmp6_ = netsukuku_impl_linux_iproute (_tmp5_, &_inner_error_);
		_tmp7_ = _tmp6_;
		_g_free0 (_tmp7_);
		_g_free0 (_tmp5_);
		if (_inner_error_ != NULL) {
			goto __catch72_g_error;
		}
	}
	goto __finally72;
	__catch72_g_error:
	{
		GError* e = NULL;
		GQuark _tmp8_;
		const gchar* _tmp9_ = NULL;
		const gchar* _tmp10_ = NULL;
		gint _tmp11_;
		gchar* _tmp12_ = NULL;
		gchar* _tmp13_;
		const gchar* _tmp14_;
		const gchar* _tmp15_ = NULL;
		gchar* _tmp16_ = NULL;
		gchar* _tmp17_;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp8_ = e->domain;
		_tmp9_ = g_quark_to_string (_tmp8_);
		_tmp10_ = string_to_string (_tmp9_);
		_tmp11_ = e->code;
		_tmp12_ = g_strdup_printf ("%i", _tmp11_);
		_tmp13_ = _tmp12_;
		_tmp14_ = e->message;
		_tmp15_ = string_to_string (_tmp14_);
		_tmp16_ = g_strconcat ("LinuxNIC: _add_address: ", _tmp10_, " ", _tmp13_, " ", _tmp15_, NULL);
		_tmp17_ = _tmp16_;
		g_error ("network_linux.vala:329: %s", _tmp17_);
		_g_free0 (_tmp17_);
		_g_free0 (_tmp13_);
		_g_error_free0 (e);
	}
	__finally72:
	if (_inner_error_ != NULL) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
}


static void netsukuku_impl_linux_linux_nic_real__remove_address (NetsukukuNIC* base, const gchar* address) {
	NetsukukuImplLinuxLinuxNIC * self;
	GError * _inner_error_ = NULL;
	self = (NetsukukuImplLinuxLinuxNIC*) base;
	g_return_if_fail (address != NULL);
	{
		const gchar* _tmp0_;
		const gchar* _tmp1_ = NULL;
		const gchar* _tmp2_;
		const gchar* _tmp3_ = NULL;
		gchar* _tmp4_ = NULL;
		gchar* _tmp5_;
		_tmp0_ = address;
		_tmp1_ = string_to_string (_tmp0_);
		_tmp2_ = ((NetsukukuNIC*) self)->name;
		_tmp3_ = string_to_string (_tmp2_);
		_tmp4_ = g_strconcat ("addr del ", _tmp1_, "/32 dev ", _tmp3_, NULL);
		_tmp5_ = _tmp4_;
		netsukuku_impl_linux_iproute_exp (_tmp5_);
		_g_free0 (_tmp5_);
	}
	goto __finally73;
	__catch73_g_error:
	{
		GError* e = NULL;
		GError* _tmp6_;
		GQuark _tmp7_;
		const gchar* _tmp8_ = NULL;
		const gchar* _tmp9_ = NULL;
		GError* _tmp10_;
		gint _tmp11_;
		gchar* _tmp12_ = NULL;
		gchar* _tmp13_;
		GError* _tmp14_;
		const gchar* _tmp15_;
		const gchar* _tmp16_ = NULL;
		gchar* _tmp17_ = NULL;
		gchar* _tmp18_;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp6_ = e;
		_tmp7_ = _tmp6_->domain;
		_tmp8_ = g_quark_to_string (_tmp7_);
		_tmp9_ = string_to_string (_tmp8_);
		_tmp10_ = e;
		_tmp11_ = _tmp10_->code;
		_tmp12_ = g_strdup_printf ("%i", _tmp11_);
		_tmp13_ = _tmp12_;
		_tmp14_ = e;
		_tmp15_ = _tmp14_->message;
		_tmp16_ = string_to_string (_tmp15_);
		_tmp17_ = g_strconcat ("LinuxNIC: _remove_address: ", _tmp9_, " ", _tmp13_, " ", _tmp16_, NULL);
		_tmp18_ = _tmp17_;
		g_error ("network_linux.vala:337: %s", _tmp18_);
		_g_free0 (_tmp18_);
		_g_free0 (_tmp13_);
		_g_error_free0 (e);
	}
	__finally73:
	if (_inner_error_ != NULL) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
}


static guint8* string_get_data (const gchar* self, int* result_length1) {
	guint8* result;
	guint8* res;
	gint res_length1;
	gint _res_size_;
	gint _tmp0_;
	gint _tmp1_;
	gint _tmp2_;
	guint8* _tmp3_;
	gint _tmp3__length1;
	guint8* _tmp4_;
	gint _tmp4__length1;
	g_return_val_if_fail (self != NULL, NULL);
	res = (guint8*) self;
	res_length1 = -1;
	_res_size_ = res_length1;
	_tmp0_ = strlen (self);
	_tmp1_ = _tmp0_;
	res_length1 = (gint) _tmp1_;
	_tmp2_ = res_length1;
	_tmp3_ = res;
	_tmp3__length1 = res_length1;
	_tmp4_ = _tmp3_;
	_tmp4__length1 = _tmp3__length1;
	if (result_length1) {
		*result_length1 = _tmp4__length1;
	}
	result = _tmp4_;
	return result;
}


static void netsukuku_impl_linux_linux_nic_real__disable_filtering (NetsukukuNIC* base) {
	NetsukukuImplLinuxLinuxNIC * self;
	gchar* _tmp0_;
	gchar* path0;
	const gchar* _tmp1_;
	const gchar* _tmp2_ = NULL;
	gchar* _tmp3_ = NULL;
	gchar* path1;
	gchar* _tmp4_;
	gchar* content;
	GError * _inner_error_ = NULL;
	self = (NetsukukuImplLinuxLinuxNIC*) base;
	_tmp0_ = g_strdup ("/proc/sys/net/ipv4/conf/all/rp_filter");
	path0 = _tmp0_;
	_tmp1_ = ((NetsukukuNIC*) self)->name;
	_tmp2_ = string_to_string (_tmp1_);
	_tmp3_ = g_strconcat ("/proc/sys/net/ipv4/conf/", _tmp2_, "/rp_filter", NULL);
	path1 = _tmp3_;
	_tmp4_ = g_strdup ("0");
	content = _tmp4_;
	{
		guint8* _tmp5_;
		gint _tmp5__length1;
		guint8* _tmp6_;
		gint _tmp6__length1;
		_tmp5_ = string_get_data (content, &_tmp5__length1);
		_tmp6_ = _tmp5_;
		_tmp6__length1 = _tmp5__length1;
		netsukuku_impl_linux_write_file (path0, _tmp6_, _tmp6__length1);
	}
	goto __finally74;
	__catch74_g_error:
	{
		GError* e = NULL;
		const gchar* _tmp7_ = NULL;
		const gchar* _tmp8_ = NULL;
		gchar* _tmp9_ = NULL;
		gchar* _tmp10_;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp7_ = string_to_string (content);
		_tmp8_ = string_to_string (path0);
		_tmp9_ = g_strconcat ("rp_filter: error (ignored) writing '", _tmp7_, "' in '", _tmp8_, "'", NULL);
		_tmp10_ = _tmp9_;
		netsukuku_log_error (_tmp10_);
		_g_free0 (_tmp10_);
		_g_error_free0 (e);
	}
	__finally74:
	if (_inner_error_ != NULL) {
		_g_free0 (content);
		_g_free0 (path1);
		_g_free0 (path0);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
	{
		guint8* _tmp11_;
		gint _tmp11__length1;
		guint8* _tmp12_;
		gint _tmp12__length1;
		_tmp11_ = string_get_data (content, &_tmp11__length1);
		_tmp12_ = _tmp11_;
		_tmp12__length1 = _tmp11__length1;
		netsukuku_impl_linux_write_file (path0, _tmp12_, _tmp12__length1);
	}
	goto __finally75;
	__catch75_g_error:
	{
		GError* e = NULL;
		const gchar* _tmp13_ = NULL;
		const gchar* _tmp14_ = NULL;
		gchar* _tmp15_ = NULL;
		gchar* _tmp16_;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp13_ = string_to_string (content);
		_tmp14_ = string_to_string (path1);
		_tmp15_ = g_strconcat ("rp_filter: error (ignored) writing '", _tmp13_, "' in '", _tmp14_, "'", NULL);
		_tmp16_ = _tmp15_;
		netsukuku_log_error (_tmp16_);
		_g_free0 (_tmp16_);
		_g_error_free0 (e);
	}
	__finally75:
	if (_inner_error_ != NULL) {
		_g_free0 (content);
		_g_free0 (path1);
		_g_free0 (path0);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
	_g_free0 (content);
	_g_free0 (path1);
	_g_free0 (path0);
}


static void netsukuku_impl_linux_linux_nic_class_init (NetsukukuImplLinuxLinuxNICClass * klass) {
	netsukuku_impl_linux_linux_nic_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (NetsukukuImplLinuxLinuxNICPrivate));
	NETSUKUKU_NIC_CLASS (klass)->_mac_getter = netsukuku_impl_linux_linux_nic_real__mac_getter;
	NETSUKUKU_NIC_CLASS (klass)->_is_active_getter = netsukuku_impl_linux_linux_nic_real__is_active_getter;
	NETSUKUKU_NIC_CLASS (klass)->_up = netsukuku_impl_linux_linux_nic_real__up;
	NETSUKUKU_NIC_CLASS (klass)->_down = netsukuku_impl_linux_linux_nic_real__down;
	NETSUKUKU_NIC_CLASS (klass)->_add_address = netsukuku_impl_linux_linux_nic_real__add_address;
	NETSUKUKU_NIC_CLASS (klass)->_remove_address = netsukuku_impl_linux_linux_nic_real__remove_address;
	NETSUKUKU_NIC_CLASS (klass)->_disable_filtering = netsukuku_impl_linux_linux_nic_real__disable_filtering;
	G_OBJECT_CLASS (klass)->finalize = netsukuku_impl_linux_linux_nic_finalize;
}


static void netsukuku_impl_linux_linux_nic_instance_init (NetsukukuImplLinuxLinuxNIC * self) {
	self->priv = NETSUKUKU_IMPL_LINUX_LINUX_NIC_GET_PRIVATE (self);
}


static void netsukuku_impl_linux_linux_nic_finalize (GObject* obj) {
	NetsukukuImplLinuxLinuxNIC * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, NETSUKUKU_IMPL_LINUX_TYPE_LINUX_NIC, NetsukukuImplLinuxLinuxNIC);
	_g_free0 (self->priv->_mac);
	G_OBJECT_CLASS (netsukuku_impl_linux_linux_nic_parent_class)->finalize (obj);
}


GType netsukuku_impl_linux_linux_nic_get_type (void) {
	static volatile gsize netsukuku_impl_linux_linux_nic_type_id__volatile = 0;
	if (g_once_init_enter (&netsukuku_impl_linux_linux_nic_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (NetsukukuImplLinuxLinuxNICClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) netsukuku_impl_linux_linux_nic_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (NetsukukuImplLinuxLinuxNIC), 0, (GInstanceInitFunc) netsukuku_impl_linux_linux_nic_instance_init, NULL };
		GType netsukuku_impl_linux_linux_nic_type_id;
		netsukuku_impl_linux_linux_nic_type_id = g_type_register_static (NETSUKUKU_TYPE_NIC, "NetsukukuImplLinuxLinuxNIC", &g_define_type_info, 0);
		g_once_init_leave (&netsukuku_impl_linux_linux_nic_type_id__volatile, netsukuku_impl_linux_linux_nic_type_id);
	}
	return netsukuku_impl_linux_linux_nic_type_id__volatile;
}


/** Initialize linux policy routing db.
      */
static gchar string_get (const gchar* self, glong index) {
	gchar result = '\0';
	glong _tmp0_;
	gchar _tmp1_;
	g_return_val_if_fail (self != NULL, '\0');
	_tmp0_ = index;
	_tmp1_ = ((gchar*) self)[_tmp0_];
	result = _tmp1_;
	return result;
}


void netsukuku_impl_linux_init_prdb (void) {
	GError * _inner_error_ = NULL;
	{
		GRegex* _tmp0_;
		gchar* _tmp3_;
		gchar* conf;
		GFile* _tmp4_ = NULL;
		GFile* ftable;
		gchar* rt_table_content = NULL;
		guint8* rt_table_content_arr = NULL;
		gint rt_table_content_arr_length1 = 0;
		gint _rt_table_content_arr_size_ = 0;
		GFile* _tmp5_;
		guint8* _tmp6_ = NULL;
		gsize _tmp7_;
		guint8* _tmp8_;
		gint _tmp8__length1;
		gchar* _tmp9_;
		GRegex* _tmp10_;
		const gchar* _tmp11_;
		gboolean _tmp12_ = FALSE;
		gchar* _tmp36_ = NULL;
		gchar* pres;
		const gchar* _tmp37_;
		gboolean _tmp38_ = FALSE;
		_tmp0_ = netsukuku_impl_linux_NTK_IN_RT_TABLE;
		if (_tmp0_ == NULL) {
			GRegex* _tmp1_;
			GRegex* _tmp2_;
			_tmp1_ = g_regex_new ("\\d+\\s+ntk", 0, 0, &_inner_error_);
			_tmp2_ = _tmp1_;
			if (_inner_error_ != NULL) {
				goto __catch76_g_error;
			}
			_g_regex_unref0 (netsukuku_impl_linux_NTK_IN_RT_TABLE);
			netsukuku_impl_linux_NTK_IN_RT_TABLE = _tmp2_;
		}
		_tmp3_ = g_strdup ("");
		conf = _tmp3_;
		_tmp4_ = g_file_new_for_commandline_arg (NETSUKUKU_IMPL_LINUX_RT_TABLE);
		ftable = _tmp4_;
		_tmp5_ = ftable;
		g_file_load_contents (_tmp5_, NULL, &_tmp6_, &_tmp7_, NULL, &_inner_error_);
		rt_table_content_arr = (g_free (rt_table_content_arr), NULL);
		rt_table_content_arr = _tmp6_;
		rt_table_content_arr_length1 = _tmp7_;
		_rt_table_content_arr_size_ = rt_table_content_arr_length1;
		if (_inner_error_ != NULL) {
			rt_table_content_arr = (g_free (rt_table_content_arr), NULL);
			_g_free0 (rt_table_content);
			_g_object_unref0 (ftable);
			_g_free0 (conf);
			goto __catch76_g_error;
		}
		_tmp8_ = rt_table_content_arr;
		_tmp8__length1 = rt_table_content_arr_length1;
		_tmp9_ = g_strdup ((const gchar*) _tmp8_);
		_g_free0 (rt_table_content);
		rt_table_content = _tmp9_;
		_tmp10_ = netsukuku_impl_linux_NTK_IN_RT_TABLE;
		_tmp11_ = rt_table_content;
		_tmp12_ = g_regex_match (_tmp10_, _tmp11_, 0, NULL);
		if (!_tmp12_) {
			const gchar* _tmp13_;
			const gchar* _tmp14_;
			gint _tmp15_;
			gint _tmp16_;
			gchar _tmp17_ = '\0';
			const gchar* _tmp20_;
			gchar* _tmp21_;
			const gchar* _tmp22_;
			gint _tmp23_;
			gchar* _tmp24_ = NULL;
			gchar* _tmp25_;
			gchar* _tmp26_ = NULL;
			gchar* _tmp27_;
			gchar* _tmp28_;
			GFile* _tmp29_ = NULL;
			GFile* fout;
			GFile* _tmp30_;
			GFileOutputStream* _tmp31_ = NULL;
			GFileOutputStream* fos;
			GFileOutputStream* _tmp32_;
			const gchar* _tmp33_;
			guint8* _tmp34_;
			gint _tmp34__length1;
			guint8* _tmp35_;
			gint _tmp35__length1;
			_tmp13_ = rt_table_content;
			_tmp14_ = rt_table_content;
			_tmp15_ = strlen (_tmp14_);
			_tmp16_ = _tmp15_;
			_tmp17_ = string_get (_tmp13_, (glong) (_tmp16_ - 1));
			if (_tmp17_ != '\n') {
				const gchar* _tmp18_;
				gchar* _tmp19_;
				_tmp18_ = conf;
				_tmp19_ = g_strconcat (_tmp18_, "\n", NULL);
				_g_free0 (conf);
				conf = _tmp19_;
			}
			_tmp20_ = conf;
			_tmp21_ = g_strconcat (_tmp20_, "# Added by netsukuku\n", NULL);
			_g_free0 (conf);
			conf = _tmp21_;
			_tmp22_ = conf;
			_tmp23_ = netsukuku_impl_linux_NTK_TABLE;
			_tmp24_ = g_strdup_printf ("%i", _tmp23_);
			_tmp25_ = _tmp24_;
			_tmp26_ = g_strconcat (_tmp25_, "\tntk\n", NULL);
			_tmp27_ = _tmp26_;
			_tmp28_ = g_strconcat (_tmp22_, _tmp27_, NULL);
			_g_free0 (conf);
			conf = _tmp28_;
			_g_free0 (_tmp27_);
			_g_free0 (_tmp25_);
			_tmp29_ = g_file_new_for_commandline_arg (NETSUKUKU_IMPL_LINUX_RT_TABLE);
			fout = _tmp29_;
			_tmp30_ = fout;
			_tmp31_ = g_file_append_to (_tmp30_, G_FILE_CREATE_NONE, NULL, &_inner_error_);
			fos = _tmp31_;
			if (_inner_error_ != NULL) {
				_g_object_unref0 (fout);
				rt_table_content_arr = (g_free (rt_table_content_arr), NULL);
				_g_free0 (rt_table_content);
				_g_object_unref0 (ftable);
				_g_free0 (conf);
				goto __catch76_g_error;
			}
			_tmp32_ = fos;
			_tmp33_ = conf;
			_tmp34_ = string_get_data (_tmp33_, &_tmp34__length1);
			_tmp35_ = _tmp34_;
			_tmp35__length1 = _tmp34__length1;
			g_output_stream_write ((GOutputStream*) _tmp32_, _tmp35_, (gsize) _tmp35__length1, NULL, &_inner_error_);
			if (_inner_error_ != NULL) {
				_g_object_unref0 (fos);
				_g_object_unref0 (fout);
				rt_table_content_arr = (g_free (rt_table_content_arr), NULL);
				_g_free0 (rt_table_content);
				_g_object_unref0 (ftable);
				_g_free0 (conf);
				goto __catch76_g_error;
			}
			_g_object_unref0 (fos);
			_g_object_unref0 (fout);
		}
		_tmp36_ = netsukuku_impl_linux_iproute ("rule list", &_inner_error_);
		pres = _tmp36_;
		if (_inner_error_ != NULL) {
			rt_table_content_arr = (g_free (rt_table_content_arr), NULL);
			_g_free0 (rt_table_content);
			_g_object_unref0 (ftable);
			_g_free0 (conf);
			goto __catch76_g_error;
		}
		_tmp37_ = pres;
		_tmp38_ = string_contains (_tmp37_, " lookup ntk ");
		if (!_tmp38_) {
			gchar* _tmp39_ = NULL;
			gchar* _tmp40_;
			_tmp39_ = netsukuku_impl_linux_iproute ("rule add table ntk", &_inner_error_);
			_tmp40_ = _tmp39_;
			_g_free0 (_tmp40_);
			if (_inner_error_ != NULL) {
				_g_free0 (pres);
				rt_table_content_arr = (g_free (rt_table_content_arr), NULL);
				_g_free0 (rt_table_content);
				_g_object_unref0 (ftable);
				_g_free0 (conf);
				goto __catch76_g_error;
			}
		}
		_g_free0 (pres);
		rt_table_content_arr = (g_free (rt_table_content_arr), NULL);
		_g_free0 (rt_table_content);
		_g_object_unref0 (ftable);
		_g_free0 (conf);
	}
	goto __finally76;
	__catch76_g_error:
	{
		GError* e = NULL;
		GQuark _tmp41_;
		const gchar* _tmp42_ = NULL;
		gint _tmp43_;
		gchar* _tmp44_ = NULL;
		gchar* _tmp45_;
		const gchar* _tmp46_;
		const gchar* _tmp47_ = NULL;
		gchar* _tmp48_ = NULL;
		gchar* _tmp49_;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp41_ = e->domain;
		_tmp42_ = g_quark_to_string (_tmp41_);
		_tmp43_ = e->code;
		_tmp44_ = g_strdup_printf ("%i", _tmp43_);
		_tmp45_ = _tmp44_;
		_tmp46_ = e->message;
		_tmp47_ = string_to_string (_tmp46_);
		_tmp48_ = g_strconcat ("LinuxNic.init_prdb: Caught exception ", _tmp42_, " code ", _tmp45_, ": ", _tmp47_, NULL);
		_tmp49_ = _tmp48_;
		g_error ("network_linux.vala:398: %s", _tmp49_);
		_g_free0 (_tmp49_);
		_g_free0 (_tmp45_);
		_g_error_free0 (e);
	}
	__finally76:
	if (_inner_error_ != NULL) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
}


void netsukuku_impl_linux_struct_helper_linuxroute_activate_multipath_copy (const NetsukukuImplLinuxstruct_helper_LinuxRoute_activate_multipath* self, NetsukukuImplLinuxstruct_helper_LinuxRoute_activate_multipath* dest) {
	NetsukukuImplLinuxLinuxRoute* _tmp0_;
	NetsukukuImplLinuxLinuxRoute* _tmp1_;
	_tmp0_ = (*self).self;
	_tmp1_ = _g_object_ref0 (_tmp0_);
	_g_object_unref0 ((*dest).self);
	(*dest).self = _tmp1_;
}


void netsukuku_impl_linux_struct_helper_linuxroute_activate_multipath_destroy (NetsukukuImplLinuxstruct_helper_LinuxRoute_activate_multipath* self) {
	_g_object_unref0 ((*self).self);
}


NetsukukuImplLinuxstruct_helper_LinuxRoute_activate_multipath* netsukuku_impl_linux_struct_helper_linuxroute_activate_multipath_dup (const NetsukukuImplLinuxstruct_helper_LinuxRoute_activate_multipath* self) {
	NetsukukuImplLinuxstruct_helper_LinuxRoute_activate_multipath* dup;
	dup = g_new0 (NetsukukuImplLinuxstruct_helper_LinuxRoute_activate_multipath, 1);
	netsukuku_impl_linux_struct_helper_linuxroute_activate_multipath_copy (self, dup);
	return dup;
}


void netsukuku_impl_linux_struct_helper_linuxroute_activate_multipath_free (NetsukukuImplLinuxstruct_helper_LinuxRoute_activate_multipath* self) {
	netsukuku_impl_linux_struct_helper_linuxroute_activate_multipath_destroy (self);
	g_free (self);
}


GType netsukuku_impl_linux_struct_helper_linuxroute_activate_multipath_get_type (void) {
	static volatile gsize netsukuku_impl_linux_struct_helper_linuxroute_activate_multipath_type_id__volatile = 0;
	if (g_once_init_enter (&netsukuku_impl_linux_struct_helper_linuxroute_activate_multipath_type_id__volatile)) {
		GType netsukuku_impl_linux_struct_helper_linuxroute_activate_multipath_type_id;
		netsukuku_impl_linux_struct_helper_linuxroute_activate_multipath_type_id = g_boxed_type_register_static ("NetsukukuImplLinuxstruct_helper_LinuxRoute_activate_multipath", (GBoxedCopyFunc) netsukuku_impl_linux_struct_helper_linuxroute_activate_multipath_dup, (GBoxedFreeFunc) netsukuku_impl_linux_struct_helper_linuxroute_activate_multipath_free);
		g_once_init_leave (&netsukuku_impl_linux_struct_helper_linuxroute_activate_multipath_type_id__volatile, netsukuku_impl_linux_struct_helper_linuxroute_activate_multipath_type_id);
	}
	return netsukuku_impl_linux_struct_helper_linuxroute_activate_multipath_type_id__volatile;
}


static NetsukukuRouteSetter* _netsukuku_impl_linux_linux_route_create (void) {
	NetsukukuRouteSetter* result = NULL;
	gboolean _tmp0_;
	gboolean _tmp1_;
	NetsukukuImplLinuxLinuxRoute* _tmp2_;
	_tmp0_ = netsukuku_settings_get_TESTING ();
	_tmp1_ = _tmp0_;
	if (!_tmp1_) {
		netsukuku_impl_linux_init_prdb ();
	}
	_tmp2_ = netsukuku_impl_linux_linux_route_new ();
	result = (NetsukukuRouteSetter*) _tmp2_;
	return result;
}


static NetsukukuRouteSetter* __netsukuku_impl_linux_linux_route_create_netsukuku_create_route_setter_delegate (gpointer self) {
	NetsukukuRouteSetter* result;
	result = _netsukuku_impl_linux_linux_route_create ();
	return result;
}


void netsukuku_impl_linux_linux_route_register (void) {
	netsukuku_route_setter_register_class ("linux", __netsukuku_impl_linux_linux_route_create_netsukuku_create_route_setter_delegate, NULL);
}


NetsukukuImplLinuxLinuxRoute* netsukuku_impl_linux_linux_route_construct (GType object_type) {
	NetsukukuImplLinuxLinuxRoute * self = NULL;
	GeeHashMap* _tmp0_;
	self = (NetsukukuImplLinuxLinuxRoute*) netsukuku_route_setter_construct (object_type);
	_tmp0_ = gee_hash_map_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, G_TYPE_INT, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
	_g_object_unref0 (self->priv->mac_table);
	self->priv->mac_table = _tmp0_;
	return self;
}


NetsukukuImplLinuxLinuxRoute* netsukuku_impl_linux_linux_route_new (void) {
	return netsukuku_impl_linux_linux_route_construct (NETSUKUKU_IMPL_LINUX_TYPE_LINUX_ROUTE);
}


static void netsukuku_impl_linux_linux_route_impl_activate_multipath (NetsukukuImplLinuxLinuxRoute* self, GError** error) {
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	while (TRUE) {
		{
			gchar* _tmp0_ = NULL;
			gchar* _tmp1_;
			tasklets_ms_wait ((gint64) 1000);
			_tmp0_ = netsukuku_impl_linux_iproute ("route flush cache", &_inner_error_);
			_tmp1_ = _tmp0_;
			_g_free0 (_tmp1_);
			if (_inner_error_ != NULL) {
				goto __catch77_g_error;
			}
		}
		goto __finally77;
		__catch77_g_error:
		{
			GError* e = NULL;
			GError* _tmp2_;
			const gchar* _tmp3_;
			const gchar* _tmp4_ = NULL;
			gchar* _tmp5_ = NULL;
			gchar* _tmp6_;
			e = _inner_error_;
			_inner_error_ = NULL;
			_tmp2_ = e;
			_tmp3_ = _tmp2_->message;
			_tmp4_ = string_to_string (_tmp3_);
			_tmp5_ = g_strconcat ("LinuxRoute: Exception while keep_flushing: ", _tmp4_, NULL);
			_tmp6_ = _tmp5_;
			netsukuku_log_error (_tmp6_);
			_g_free0 (_tmp6_);
			_g_error_free0 (e);
		}
		__finally77:
		if (_inner_error_ != NULL) {
			g_propagate_error (error, _inner_error_);
			return;
		}
	}
}


static void* netsukuku_impl_linux_linux_route_helper_activate_multipath (void* v, GError** error) {
	void* result = NULL;
	void* _tmp0_;
	Taskletsstruct_channel* ch_cont_p;
	Taskletsstruct_channel* _tmp1_;
	TaskletsChannel* _tmp2_;
	TaskletsChannel* _tmp3_;
	TaskletsChannel* ch;
	GError * _inner_error_ = NULL;
	tasklets_tasklet_declare_self ("LinuxRoute.activate_multipath dispatcher");
	_tmp0_ = v;
	ch_cont_p = (Taskletsstruct_channel*) _tmp0_;
	_tmp1_ = ch_cont_p;
	_tmp2_ = (*_tmp1_).self;
	_tmp3_ = _g_object_ref0 (_tmp2_);
	ch = _tmp3_;
	tasklets_tasklet_schedule_back ();
	while (TRUE) {
		gchar* doing;
		const gchar* _tmp17_;
		doing = NULL;
		{
			NetsukukuImplLinuxstruct_helper_LinuxRoute_activate_multipath tuple_p = {0};
			gchar* _tmp8_;
			const gchar* _tmp9_;
			NetsukukuImplLinuxstruct_helper_LinuxRoute_activate_multipath _tmp10_;
			NetsukukuImplLinuxLinuxRoute* _tmp11_;
			{
				TaskletsChannel* _tmp4_;
				GValue _tmp5_ = {0};
				GValue vv;
				void* _tmp6_ = NULL;
				NetsukukuImplLinuxstruct_helper_LinuxRoute_activate_multipath _tmp7_ = {0};
				_tmp4_ = ch;
				tasklets_channel_recv (_tmp4_, &_tmp5_);
				vv = _tmp5_;
				_tmp6_ = g_value_get_boxed (&vv);
				netsukuku_impl_linux_struct_helper_linuxroute_activate_multipath_copy ((NetsukukuImplLinuxstruct_helper_LinuxRoute_activate_multipath*) _tmp6_, &_tmp7_);
				netsukuku_impl_linux_struct_helper_linuxroute_activate_multipath_destroy (&tuple_p);
				tuple_p = _tmp7_;
				G_IS_VALUE (&vv) ? (g_value_unset (&vv), NULL) : NULL;
			}
			_tmp8_ = g_strdup ("activate_multipath()");
			_g_free0 (doing);
			doing = _tmp8_;
			_tmp9_ = doing;
			tasklets_tasklet_declare_self (_tmp9_);
			_tmp10_ = tuple_p;
			_tmp11_ = _tmp10_.self;
			netsukuku_impl_linux_linux_route_impl_activate_multipath (_tmp11_, &_inner_error_);
			if (_inner_error_ != NULL) {
				netsukuku_impl_linux_struct_helper_linuxroute_activate_multipath_destroy (&tuple_p);
				goto __catch78_g_error;
			}
			tasklets_tasklet_nap ((glong) 0, (glong) 100);
			netsukuku_impl_linux_struct_helper_linuxroute_activate_multipath_destroy (&tuple_p);
		}
		goto __finally78;
		__catch78_g_error:
		{
			GError* e = NULL;
			GError* _tmp12_;
			const gchar* _tmp13_;
			const gchar* _tmp14_ = NULL;
			gchar* _tmp15_ = NULL;
			gchar* _tmp16_;
			e = _inner_error_;
			_inner_error_ = NULL;
			_tmp12_ = e;
			_tmp13_ = _tmp12_->message;
			_tmp14_ = string_to_string (_tmp13_);
			_tmp15_ = g_strconcat ("LinuxRoute: activate_multipath microfunc reported an error: ", _tmp14_, NULL);
			_tmp16_ = _tmp15_;
			netsukuku_log_warn (_tmp16_);
			_g_free0 (_tmp16_);
			_g_error_free0 (e);
		}
		__finally78:
		if (_inner_error_ != NULL) {
			g_propagate_error (error, _inner_error_);
			_g_free0 (doing);
			_g_object_unref0 (ch);
			return NULL;
		}
		_tmp17_ = doing;
		if (_tmp17_ != NULL) {
			const gchar* _tmp18_;
			_tmp18_ = doing;
			tasklets_tasklet_declare_finished (_tmp18_);
		}
		_g_free0 (doing);
	}
	_g_object_unref0 (ch);
	return result;
}


static void netsukuku_impl_linux_linux_route_real_activate_multipath (NetsukukuRouteSetter* base) {
	NetsukukuImplLinuxLinuxRoute * self;
	TaskletsChannel* _tmp0_ = NULL;
	TaskletsChannel* ch;
	NetsukukuImplLinuxstruct_helper_LinuxRoute_activate_multipath arg = {0};
	NetsukukuImplLinuxLinuxRoute* _tmp1_;
	NetsukukuImplLinuxstruct_helper_LinuxRoute_activate_multipath _tmp2_;
	GValue _tmp3_ = {0};
	self = (NetsukukuImplLinuxLinuxRoute*) base;
	_tmp0_ = tasklets_tasklet_dispatcher_get_channel_for_helper ((FunctionDelegate) netsukuku_impl_linux_linux_route_helper_activate_multipath, -1);
	ch = _tmp0_;
	memset (&arg, 0, sizeof (NetsukukuImplLinuxstruct_helper_LinuxRoute_activate_multipath));
	_tmp1_ = _g_object_ref0 (self);
	_g_object_unref0 (arg.self);
	arg.self = _tmp1_;
	_tmp2_ = arg;
	g_value_init (&_tmp3_, NETSUKUKU_IMPL_LINUX_TYPE_STRUCT_HELPER_LINUXROUTE_ACTIVATE_MULTIPATH);
	g_value_set_boxed (&_tmp3_, &_tmp2_);
	tasklets_channel_send_async (ch, &_tmp3_);
	G_IS_VALUE (&_tmp3_) ? (g_value_unset (&_tmp3_), NULL) : NULL;
	netsukuku_impl_linux_struct_helper_linuxroute_activate_multipath_destroy (&arg);
	_g_object_unref0 (ch);
}


/** Makes sure that a routing table exists for packets coming from macaddr.
          * Returns the number of that table.
          */
gint _netsukuku_impl_linux_linux_route_table_for_macaddr (NetsukukuImplLinuxLinuxRoute* self, const gchar* _macaddr, GError** error) {
	gint result = 0;
	const gchar* _tmp0_;
	gchar* _tmp1_ = NULL;
	gchar* macaddr;
	gint idn = 0;
	GeeHashMap* _tmp2_;
	const gchar* _tmp3_;
	gboolean _tmp4_ = FALSE;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, 0);
	g_return_val_if_fail (_macaddr != NULL, 0);
	_tmp0_ = _macaddr;
	_tmp1_ = g_utf8_strdown (_tmp0_, (gssize) (-1));
	macaddr = _tmp1_;
	_tmp2_ = self->priv->mac_table;
	_tmp3_ = macaddr;
	_tmp4_ = gee_abstract_map_has_key ((GeeAbstractMap*) _tmp2_, _tmp3_);
	if (!_tmp4_) {
		const gchar* _tmp13_;
		const gchar* _tmp14_ = NULL;
		gint _tmp15_;
		gchar* _tmp16_ = NULL;
		gchar* _tmp17_;
		gchar* _tmp18_ = NULL;
		gchar* _tmp19_;
		gchar* _tmp20_ = NULL;
		gchar* _tmp21_;
		gint _tmp22_;
		gchar* _tmp23_ = NULL;
		gchar* _tmp24_;
		gint _tmp25_;
		gchar* _tmp26_ = NULL;
		gchar* _tmp27_;
		gchar* _tmp28_ = NULL;
		gchar* _tmp29_;
		gchar* _tmp30_ = NULL;
		gchar* _tmp31_;
		GeeHashMap* _tmp32_;
		const gchar* _tmp33_;
		gint _tmp34_;
		idn = 199;
		while (TRUE) {
			GeeHashMap* _tmp5_;
			GeeCollection* _tmp6_;
			GeeCollection* _tmp7_;
			GeeCollection* _tmp8_;
			gint _tmp9_;
			gboolean _tmp10_ = FALSE;
			gboolean _tmp11_;
			gint _tmp12_;
			_tmp5_ = self->priv->mac_table;
			_tmp6_ = gee_abstract_map_get_values ((GeeMap*) _tmp5_);
			_tmp7_ = _tmp6_;
			_tmp8_ = _tmp7_;
			_tmp9_ = idn;
			_tmp10_ = gee_collection_contains (_tmp8_, (gpointer) ((gintptr) _tmp9_));
			_tmp11_ = !_tmp10_;
			_g_object_unref0 (_tmp8_);
			if (_tmp11_) {
				break;
			}
			_tmp12_ = idn;
			idn = _tmp12_ - 1;
		}
		_tmp13_ = macaddr;
		_tmp14_ = string_to_string (_tmp13_);
		_tmp15_ = idn;
		_tmp16_ = g_strdup_printf ("%i", _tmp15_);
		_tmp17_ = _tmp16_;
		_tmp18_ = g_strconcat ("-t mangle -A PREROUTING -m mac --mac-source ", _tmp14_, " -j MARK --set-mark ", _tmp17_, NULL);
		_tmp19_ = _tmp18_;
		_tmp20_ = netsukuku_impl_linux_iptables (_tmp19_, &_inner_error_);
		_tmp21_ = _tmp20_;
		_g_free0 (_tmp21_);
		_g_free0 (_tmp19_);
		_g_free0 (_tmp17_);
		if (_inner_error_ != NULL) {
			g_propagate_error (error, _inner_error_);
			_g_free0 (macaddr);
			return 0;
		}
		_tmp22_ = idn;
		_tmp23_ = g_strdup_printf ("%i", _tmp22_);
		_tmp24_ = _tmp23_;
		_tmp25_ = idn;
		_tmp26_ = g_strdup_printf ("%i", _tmp25_);
		_tmp27_ = _tmp26_;
		_tmp28_ = g_strconcat ("rule add fwmark ", _tmp24_, " table ", _tmp27_, NULL);
		_tmp29_ = _tmp28_;
		_tmp30_ = netsukuku_impl_linux_iproute (_tmp29_, &_inner_error_);
		_tmp31_ = _tmp30_;
		_g_free0 (_tmp31_);
		_g_free0 (_tmp29_);
		_g_free0 (_tmp27_);
		_g_free0 (_tmp24_);
		if (_inner_error_ != NULL) {
			g_propagate_error (error, _inner_error_);
			_g_free0 (macaddr);
			return 0;
		}
		_tmp32_ = self->priv->mac_table;
		_tmp33_ = macaddr;
		_tmp34_ = idn;
		gee_abstract_map_set ((GeeAbstractMap*) _tmp32_, _tmp33_, (gpointer) ((gintptr) _tmp34_));
	} else {
		GeeHashMap* _tmp35_;
		const gchar* _tmp36_;
		gpointer _tmp37_ = NULL;
		_tmp35_ = self->priv->mac_table;
		_tmp36_ = macaddr;
		_tmp37_ = gee_abstract_map_get ((GeeAbstractMap*) _tmp35_, _tmp36_);
		idn = (gint) ((gintptr) _tmp37_);
	}
	result = idn;
	_g_free0 (macaddr);
	return result;
}


/** Removes all routing table created for packets coming from any macaddr
          */
void _netsukuku_impl_linux_linux_route_table_for_macaddr_remove_all (NetsukukuImplLinuxLinuxRoute* self, GError** error) {
	GeeArrayList* _tmp0_;
	GeeArrayList* all_macs;
	GeeArrayList* _tmp1_;
	GeeHashMap* _tmp2_;
	GeeSet* _tmp3_;
	GeeSet* _tmp4_;
	GeeSet* _tmp5_;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = gee_array_list_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, NULL, NULL, NULL);
	all_macs = _tmp0_;
	_tmp1_ = all_macs;
	_tmp2_ = self->priv->mac_table;
	_tmp3_ = gee_abstract_map_get_keys ((GeeMap*) _tmp2_);
	_tmp4_ = _tmp3_;
	_tmp5_ = _tmp4_;
	gee_array_list_add_all (_tmp1_, (GeeCollection*) _tmp5_);
	_g_object_unref0 (_tmp5_);
	{
		GeeArrayList* _tmp6_;
		GeeArrayList* _tmp7_;
		GeeArrayList* _k_list;
		GeeArrayList* _tmp8_;
		gint _tmp9_;
		gint _tmp10_;
		gint _k_size;
		gint _k_index;
		_tmp6_ = all_macs;
		_tmp7_ = _g_object_ref0 (_tmp6_);
		_k_list = _tmp7_;
		_tmp8_ = _k_list;
		_tmp9_ = gee_abstract_collection_get_size ((GeeCollection*) _tmp8_);
		_tmp10_ = _tmp9_;
		_k_size = _tmp10_;
		_k_index = -1;
		while (TRUE) {
			gint _tmp11_;
			gint _tmp12_;
			gint _tmp13_;
			GeeArrayList* _tmp14_;
			gint _tmp15_;
			gpointer _tmp16_ = NULL;
			gchar* k;
			const gchar* _tmp17_;
			_tmp11_ = _k_index;
			_k_index = _tmp11_ + 1;
			_tmp12_ = _k_index;
			_tmp13_ = _k_size;
			if (!(_tmp12_ < _tmp13_)) {
				break;
			}
			_tmp14_ = _k_list;
			_tmp15_ = _k_index;
			_tmp16_ = gee_abstract_list_get ((GeeAbstractList*) _tmp14_, _tmp15_);
			k = (gchar*) _tmp16_;
			_tmp17_ = k;
			_netsukuku_impl_linux_linux_route_table_for_macaddr_remove (self, _tmp17_, &_inner_error_);
			if (_inner_error_ != NULL) {
				g_propagate_error (error, _inner_error_);
				_g_free0 (k);
				_g_object_unref0 (_k_list);
				_g_object_unref0 (all_macs);
				return;
			}
			_g_free0 (k);
		}
		_g_object_unref0 (_k_list);
	}
	_g_object_unref0 (all_macs);
}


/** Makes sure that a routing table doesn't exist anymore for packets coming from macaddr
          */
void _netsukuku_impl_linux_linux_route_table_for_macaddr_remove (NetsukukuImplLinuxLinuxRoute* self, const gchar* _macaddr, GError** error) {
	const gchar* _tmp0_;
	gchar* _tmp1_ = NULL;
	gchar* macaddr;
	GeeHashMap* _tmp2_;
	const gchar* _tmp3_;
	gboolean _tmp4_ = FALSE;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (_macaddr != NULL);
	_tmp0_ = _macaddr;
	_tmp1_ = g_utf8_strdown (_tmp0_, (gssize) (-1));
	macaddr = _tmp1_;
	_tmp2_ = self->priv->mac_table;
	_tmp3_ = macaddr;
	_tmp4_ = gee_abstract_map_has_key ((GeeAbstractMap*) _tmp2_, _tmp3_);
	if (_tmp4_) {
		GeeHashMap* _tmp5_;
		const gchar* _tmp6_;
		gpointer _tmp7_ = NULL;
		gint idn;
		const gchar* _tmp8_;
		const gchar* _tmp9_ = NULL;
		gint _tmp10_;
		gchar* _tmp11_ = NULL;
		gchar* _tmp12_;
		gchar* _tmp13_ = NULL;
		gchar* _tmp14_;
		gchar* _tmp15_ = NULL;
		gchar* _tmp16_;
		gint _tmp17_;
		gchar* _tmp18_ = NULL;
		gchar* _tmp19_;
		gint _tmp20_;
		gchar* _tmp21_ = NULL;
		gchar* _tmp22_;
		gchar* _tmp23_ = NULL;
		gchar* _tmp24_;
		gchar* _tmp25_ = NULL;
		gchar* _tmp26_;
		GeeHashMap* _tmp27_;
		const gchar* _tmp28_;
		_tmp5_ = self->priv->mac_table;
		_tmp6_ = macaddr;
		_tmp7_ = gee_abstract_map_get ((GeeAbstractMap*) _tmp5_, _tmp6_);
		idn = (gint) ((gintptr) _tmp7_);
		_tmp8_ = macaddr;
		_tmp9_ = string_to_string (_tmp8_);
		_tmp10_ = idn;
		_tmp11_ = g_strdup_printf ("%i", _tmp10_);
		_tmp12_ = _tmp11_;
		_tmp13_ = g_strconcat ("-t mangle -D PREROUTING -m mac --mac-source ", _tmp9_, " -j MARK --set-mark ", _tmp12_, NULL);
		_tmp14_ = _tmp13_;
		_tmp15_ = netsukuku_impl_linux_iptables (_tmp14_, &_inner_error_);
		_tmp16_ = _tmp15_;
		_g_free0 (_tmp16_);
		_g_free0 (_tmp14_);
		_g_free0 (_tmp12_);
		if (_inner_error_ != NULL) {
			g_propagate_error (error, _inner_error_);
			_g_free0 (macaddr);
			return;
		}
		_tmp17_ = idn;
		_tmp18_ = g_strdup_printf ("%i", _tmp17_);
		_tmp19_ = _tmp18_;
		_tmp20_ = idn;
		_tmp21_ = g_strdup_printf ("%i", _tmp20_);
		_tmp22_ = _tmp21_;
		_tmp23_ = g_strconcat ("rule del fwmark ", _tmp19_, " table ", _tmp22_, NULL);
		_tmp24_ = _tmp23_;
		_tmp25_ = netsukuku_impl_linux_iproute (_tmp24_, &_inner_error_);
		_tmp26_ = _tmp25_;
		_g_free0 (_tmp26_);
		_g_free0 (_tmp24_);
		_g_free0 (_tmp22_);
		_g_free0 (_tmp19_);
		if (_inner_error_ != NULL) {
			g_propagate_error (error, _inner_error_);
			_g_free0 (macaddr);
			return;
		}
		_tmp27_ = self->priv->mac_table;
		_tmp28_ = macaddr;
		gee_abstract_map_unset ((GeeAbstractMap*) _tmp27_, _tmp28_, NULL);
	}
	_g_free0 (macaddr);
}


/** Returns proper iproute command arguments to add/change/delete routes
          */
gchar* _netsukuku_impl_linux_linux_route_modify_routes_cmd (NetsukukuImplLinuxLinuxRoute* self, const gchar* command, const gchar* ip, const gchar* cidr, NetsukukuRouteSolutions* route_solutions, const gchar* table) {
	gchar* result = NULL;
	const gchar* _tmp0_;
	const gchar* _tmp1_ = NULL;
	const gchar* _tmp2_;
	const gchar* _tmp3_ = NULL;
	const gchar* _tmp4_;
	const gchar* _tmp5_ = NULL;
	gchar* _tmp6_ = NULL;
	gchar* cmd;
	const gchar* _tmp7_;
	NetsukukuRouteSolutions* _tmp16_;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (command != NULL, NULL);
	g_return_val_if_fail (ip != NULL, NULL);
	g_return_val_if_fail (cidr != NULL, NULL);
	_tmp0_ = command;
	_tmp1_ = string_to_string (_tmp0_);
	_tmp2_ = ip;
	_tmp3_ = string_to_string (_tmp2_);
	_tmp4_ = cidr;
	_tmp5_ = string_to_string (_tmp4_);
	_tmp6_ = g_strconcat ("route ", _tmp1_, " ", _tmp3_, "/", _tmp5_, NULL);
	cmd = _tmp6_;
	_tmp7_ = table;
	if (_tmp7_ != NULL) {
		const gchar* _tmp8_;
		const gchar* _tmp9_;
		const gchar* _tmp10_ = NULL;
		gchar* _tmp11_ = NULL;
		gchar* _tmp12_;
		gchar* _tmp13_;
		_tmp8_ = cmd;
		_tmp9_ = table;
		_tmp10_ = string_to_string (_tmp9_);
		_tmp11_ = g_strconcat (" table ", _tmp10_, NULL);
		_tmp12_ = _tmp11_;
		_tmp13_ = g_strconcat (_tmp8_, _tmp12_, NULL);
		_g_free0 (cmd);
		cmd = _tmp13_;
		_g_free0 (_tmp12_);
	} else {
		const gchar* _tmp14_;
		gchar* _tmp15_;
		_tmp14_ = cmd;
		_tmp15_ = g_strconcat (_tmp14_, " table ntk", NULL);
		_g_free0 (cmd);
		cmd = _tmp15_;
	}
	_tmp16_ = route_solutions;
	if (_tmp16_ != NULL) {
		NetsukukuRouteSolutions* _tmp17_;
		const gchar* _tmp18_;
		const gchar* _tmp19_;
		_tmp17_ = route_solutions;
		_tmp18_ = netsukuku_route_solutions_get_pref_src (_tmp17_);
		_tmp19_ = _tmp18_;
		if (_tmp19_ != NULL) {
			const gchar* _tmp20_;
			NetsukukuRouteSolutions* _tmp21_;
			const gchar* _tmp22_;
			const gchar* _tmp23_;
			const gchar* _tmp24_ = NULL;
			gchar* _tmp25_ = NULL;
			gchar* _tmp26_;
			gchar* _tmp27_;
			_tmp20_ = cmd;
			_tmp21_ = route_solutions;
			_tmp22_ = netsukuku_route_solutions_get_pref_src (_tmp21_);
			_tmp23_ = _tmp22_;
			_tmp24_ = string_to_string (_tmp23_);
			_tmp25_ = g_strconcat (" src ", _tmp24_, NULL);
			_tmp26_ = _tmp25_;
			_tmp27_ = g_strconcat (_tmp20_, _tmp26_, NULL);
			_g_free0 (cmd);
			cmd = _tmp27_;
			_g_free0 (_tmp26_);
		}
		{
			NetsukukuRouteSolutions* _tmp28_;
			GeeCollection* _tmp29_;
			GeeCollection* _tmp30_;
			GeeCollection* _tmp31_;
			GeeIterator* _tmp32_ = NULL;
			GeeIterator* _tmp33_;
			GeeIterator* _rs_it;
			_tmp28_ = route_solutions;
			_tmp29_ = netsukuku_route_solutions_get_values (_tmp28_);
			_tmp30_ = _tmp29_;
			_tmp31_ = _tmp30_;
			_tmp32_ = gee_iterable_iterator ((GeeIterable*) _tmp31_);
			_tmp33_ = _tmp32_;
			_g_object_unref0 (_tmp31_);
			_rs_it = _tmp33_;
			while (TRUE) {
				GeeIterator* _tmp34_;
				gboolean _tmp35_ = FALSE;
				GeeIterator* _tmp36_;
				gpointer _tmp37_ = NULL;
				NetsukukuRouteSolution* rs;
				const gchar* _tmp38_;
				NetsukukuRouteSolution* _tmp39_;
				const gchar* _tmp40_;
				const gchar* _tmp41_;
				const gchar* _tmp42_ = NULL;
				NetsukukuRouteSolution* _tmp43_;
				const gchar* _tmp44_;
				const gchar* _tmp45_;
				const gchar* _tmp46_ = NULL;
				NetsukukuRouteSolution* _tmp47_;
				gint _tmp48_;
				gint _tmp49_;
				gchar* _tmp50_ = NULL;
				gchar* _tmp51_;
				gchar* _tmp52_ = NULL;
				gchar* _tmp53_;
				gchar* _tmp54_;
				_tmp34_ = _rs_it;
				_tmp35_ = gee_iterator_next (_tmp34_);
				if (!_tmp35_) {
					break;
				}
				_tmp36_ = _rs_it;
				_tmp37_ = gee_iterator_get (_tmp36_);
				rs = (NetsukukuRouteSolution*) _tmp37_;
				_tmp38_ = cmd;
				_tmp39_ = rs;
				_tmp40_ = netsukuku_route_solution_get_gateway (_tmp39_);
				_tmp41_ = _tmp40_;
				_tmp42_ = string_to_string (_tmp41_);
				_tmp43_ = rs;
				_tmp44_ = netsukuku_route_solution_get_dev (_tmp43_);
				_tmp45_ = _tmp44_;
				_tmp46_ = string_to_string (_tmp45_);
				_tmp47_ = rs;
				_tmp48_ = netsukuku_route_solution_get_weight (_tmp47_);
				_tmp49_ = _tmp48_;
				_tmp50_ = g_strdup_printf ("%i", 1 + ((_tmp49_ * 255) / 1000));
				_tmp51_ = _tmp50_;
				_tmp52_ = g_strconcat (" nexthop via ", _tmp42_, " dev ", _tmp46_, " weight ", _tmp51_, NULL);
				_tmp53_ = _tmp52_;
				_tmp54_ = g_strconcat (_tmp38_, _tmp53_, NULL);
				_g_free0 (cmd);
				cmd = _tmp54_;
				_g_free0 (_tmp53_);
				_g_free0 (_tmp51_);
				_g_object_unref0 (rs);
			}
			_g_object_unref0 (_rs_it);
		}
	}
	result = cmd;
	return result;
}


/** Returns proper iproute command arguments to add/change/delete a neighbour
          */
gchar* _netsukuku_impl_linux_linux_route_modify_neighbour_cmd (NetsukukuImplLinuxLinuxRoute* self, const gchar* command, const gchar* ip, const gchar* dev, const gchar* pref_src) {
	gchar* result = NULL;
	const gchar* _tmp0_;
	const gchar* _tmp1_ = NULL;
	const gchar* _tmp2_;
	const gchar* _tmp3_ = NULL;
	gchar* _tmp4_ = NULL;
	gchar* cmd;
	const gchar* _tmp5_;
	const gchar* _tmp12_;
	gchar* _tmp13_;
	const gchar* _tmp14_;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (command != NULL, NULL);
	g_return_val_if_fail (ip != NULL, NULL);
	_tmp0_ = command;
	_tmp1_ = string_to_string (_tmp0_);
	_tmp2_ = ip;
	_tmp3_ = string_to_string (_tmp2_);
	_tmp4_ = g_strconcat ("route ", _tmp1_, " ", _tmp3_, NULL);
	cmd = _tmp4_;
	_tmp5_ = dev;
	if (_tmp5_ != NULL) {
		const gchar* _tmp6_;
		const gchar* _tmp7_;
		const gchar* _tmp8_ = NULL;
		gchar* _tmp9_ = NULL;
		gchar* _tmp10_;
		gchar* _tmp11_;
		_tmp6_ = cmd;
		_tmp7_ = dev;
		_tmp8_ = string_to_string (_tmp7_);
		_tmp9_ = g_strconcat (" dev ", _tmp8_, NULL);
		_tmp10_ = _tmp9_;
		_tmp11_ = g_strconcat (_tmp6_, _tmp10_, NULL);
		_g_free0 (cmd);
		cmd = _tmp11_;
		_g_free0 (_tmp10_);
	}
	_tmp12_ = cmd;
	_tmp13_ = g_strconcat (_tmp12_, " table ntk", NULL);
	_g_free0 (cmd);
	cmd = _tmp13_;
	_tmp14_ = pref_src;
	if (_tmp14_ != NULL) {
		const gchar* _tmp15_;
		const gchar* _tmp16_;
		const gchar* _tmp17_ = NULL;
		gchar* _tmp18_ = NULL;
		gchar* _tmp19_;
		gchar* _tmp20_;
		_tmp15_ = cmd;
		_tmp16_ = pref_src;
		_tmp17_ = string_to_string (_tmp16_);
		_tmp18_ = g_strconcat (" src ", _tmp17_, NULL);
		_tmp19_ = _tmp18_;
		_tmp20_ = g_strconcat (_tmp15_, _tmp19_, NULL);
		_g_free0 (cmd);
		cmd = _tmp20_;
		_g_free0 (_tmp19_);
	}
	result = cmd;
	return result;
}


/** Add a route (that was non existent) towards ip/cidr
          * for packets generated by this host.
          * The gateways are route_solutions
          */
static void netsukuku_impl_linux_linux_route_real__add_outgoing_route (NetsukukuRouteSetter* base, const gchar* ip, const gchar* cidr, NetsukukuRouteSolutions* route_solutions) {
	NetsukukuImplLinuxLinuxRoute * self;
	gboolean _tmp0_ = FALSE;
	const gchar* _tmp1_;
	gboolean _tmp5_;
	const gchar* _tmp6_;
	const gchar* _tmp7_;
	NetsukukuRouteSolutions* _tmp8_;
	gchar* _tmp9_ = NULL;
	gchar* _tmp10_;
	self = (NetsukukuImplLinuxLinuxRoute*) base;
	g_return_if_fail (ip != NULL);
	g_return_if_fail (cidr != NULL);
	g_return_if_fail (route_solutions != NULL);
	_tmp1_ = cidr;
	if (g_strcmp0 (_tmp1_, "32") == 0) {
		NetsukukuRouteSolutions* _tmp2_;
		const gchar* _tmp3_;
		gboolean _tmp4_ = FALSE;
		_tmp2_ = route_solutions;
		_tmp3_ = ip;
		_tmp4_ = netsukuku_route_solutions_contains_gw (_tmp2_, _tmp3_);
		_tmp0_ = _tmp4_;
	} else {
		_tmp0_ = FALSE;
	}
	_tmp5_ = _tmp0_;
	if (_tmp5_) {
		return;
	}
	_tmp6_ = ip;
	_tmp7_ = cidr;
	_tmp8_ = route_solutions;
	_tmp9_ = _netsukuku_impl_linux_linux_route_modify_routes_cmd (self, "add", _tmp6_, _tmp7_, _tmp8_, NULL);
	_tmp10_ = _tmp9_;
	netsukuku_impl_linux_iproute_exp (_tmp10_);
	_g_free0 (_tmp10_);
}


/** Add a route (that was non existent) towards ip/cidr
          * for packets coming from MAC prev_hop.
          * The gateways are route_solutions
          */
static void netsukuku_impl_linux_linux_route_real__add_forwarding_route (NetsukukuRouteSetter* base, const gchar* ip, const gchar* cidr, const gchar* prev_hop, NetsukukuRouteSolutions* route_solutions, GError** error) {
	NetsukukuImplLinuxLinuxRoute * self;
	gboolean _tmp0_ = FALSE;
	const gchar* _tmp1_;
	gboolean _tmp5_;
	const gchar* _tmp6_;
	gint _tmp7_ = 0;
	gint idn;
	const gchar* _tmp8_;
	const gchar* _tmp9_;
	NetsukukuRouteSolutions* _tmp10_;
	gint _tmp11_;
	gchar* _tmp12_ = NULL;
	gchar* _tmp13_;
	gchar* _tmp14_ = NULL;
	gchar* _tmp15_;
	GError * _inner_error_ = NULL;
	self = (NetsukukuImplLinuxLinuxRoute*) base;
	g_return_if_fail (ip != NULL);
	g_return_if_fail (cidr != NULL);
	g_return_if_fail (prev_hop != NULL);
	g_return_if_fail (route_solutions != NULL);
	_tmp1_ = cidr;
	if (g_strcmp0 (_tmp1_, "32") == 0) {
		NetsukukuRouteSolutions* _tmp2_;
		const gchar* _tmp3_;
		gboolean _tmp4_ = FALSE;
		_tmp2_ = route_solutions;
		_tmp3_ = ip;
		_tmp4_ = netsukuku_route_solutions_contains_gw (_tmp2_, _tmp3_);
		_tmp0_ = _tmp4_;
	} else {
		_tmp0_ = FALSE;
	}
	_tmp5_ = _tmp0_;
	if (_tmp5_) {
		return;
	}
	_tmp6_ = prev_hop;
	_tmp7_ = _netsukuku_impl_linux_linux_route_table_for_macaddr (self, _tmp6_, &_inner_error_);
	idn = _tmp7_;
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		return;
	}
	_tmp8_ = ip;
	_tmp9_ = cidr;
	_tmp10_ = route_solutions;
	_tmp11_ = idn;
	_tmp12_ = g_strdup_printf ("%i", _tmp11_);
	_tmp13_ = _tmp12_;
	_tmp14_ = _netsukuku_impl_linux_linux_route_modify_routes_cmd (self, "add", _tmp8_, _tmp9_, _tmp10_, _tmp13_);
	_tmp15_ = _tmp14_;
	netsukuku_impl_linux_iproute_exp (_tmp15_);
	_g_free0 (_tmp15_);
	_g_free0 (_tmp13_);
}


/** Add a route (that was non existent) towards ip/cidr
          * for packets coming from MAC prev_hop.
          * In fact this route is UNREACHABLE
          */
static void netsukuku_impl_linux_linux_route_real__add_forwarding_route_unreachable (NetsukukuRouteSetter* base, const gchar* ip, const gchar* cidr, const gchar* prev_hop, GError** error) {
	NetsukukuImplLinuxLinuxRoute * self;
	const gchar* _tmp0_;
	gint _tmp1_ = 0;
	gint idn;
	gchar* _tmp2_ = NULL;
	gchar* _tmp3_;
	const gchar* _tmp4_;
	const gchar* _tmp5_ = NULL;
	const gchar* _tmp6_;
	const gchar* _tmp7_ = NULL;
	gchar* _tmp8_ = NULL;
	gchar* _tmp9_;
	GError * _inner_error_ = NULL;
	self = (NetsukukuImplLinuxLinuxRoute*) base;
	g_return_if_fail (ip != NULL);
	g_return_if_fail (cidr != NULL);
	g_return_if_fail (prev_hop != NULL);
	_tmp0_ = prev_hop;
	_tmp1_ = _netsukuku_impl_linux_linux_route_table_for_macaddr (self, _tmp0_, &_inner_error_);
	idn = _tmp1_;
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		return;
	}
	_tmp2_ = g_strdup_printf ("%i", idn);
	_tmp3_ = _tmp2_;
	_tmp4_ = ip;
	_tmp5_ = string_to_string (_tmp4_);
	_tmp6_ = cidr;
	_tmp7_ = string_to_string (_tmp6_);
	_tmp8_ = g_strconcat ("route add table ", _tmp3_, " unreachable ", _tmp5_, "/", _tmp7_, NULL);
	_tmp9_ = _tmp8_;
	netsukuku_impl_linux_iproute_exp (_tmp9_);
	_g_free0 (_tmp9_);
	_g_free0 (_tmp3_);
}


/** Add a route (that was non existent) towards ip/cidr
          * for packets coming from MAC prev_hop.
          * In fact this route is DROP
          */
static void netsukuku_impl_linux_linux_route_real__add_forwarding_route_drop (NetsukukuRouteSetter* base, const gchar* ip, const gchar* cidr, const gchar* prev_hop, GError** error) {
	NetsukukuImplLinuxLinuxRoute * self;
	const gchar* _tmp0_;
	gint _tmp1_ = 0;
	gint idn;
	gchar* _tmp2_ = NULL;
	gchar* _tmp3_;
	const gchar* _tmp4_;
	const gchar* _tmp5_ = NULL;
	const gchar* _tmp6_;
	const gchar* _tmp7_ = NULL;
	gchar* _tmp8_ = NULL;
	gchar* _tmp9_;
	GError * _inner_error_ = NULL;
	self = (NetsukukuImplLinuxLinuxRoute*) base;
	g_return_if_fail (ip != NULL);
	g_return_if_fail (cidr != NULL);
	g_return_if_fail (prev_hop != NULL);
	_tmp0_ = prev_hop;
	_tmp1_ = _netsukuku_impl_linux_linux_route_table_for_macaddr (self, _tmp0_, &_inner_error_);
	idn = _tmp1_;
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		return;
	}
	_tmp2_ = g_strdup_printf ("%i", idn);
	_tmp3_ = _tmp2_;
	_tmp4_ = ip;
	_tmp5_ = string_to_string (_tmp4_);
	_tmp6_ = cidr;
	_tmp7_ = string_to_string (_tmp6_);
	_tmp8_ = g_strconcat ("route add table ", _tmp3_, " blackhole ", _tmp5_, "/", _tmp7_, NULL);
	_tmp9_ = _tmp8_;
	netsukuku_impl_linux_iproute_exp (_tmp9_);
	_g_free0 (_tmp9_);
	_g_free0 (_tmp3_);
}


/** Change a route (that was existent) towards ip/cidr
          * for packets generated by this host.
          * The gateways are route_solutions.
          * The old gateways were old_route_solutions
          */
static void netsukuku_impl_linux_linux_route_real__change_outgoing_route (NetsukukuRouteSetter* base, const gchar* ip, const gchar* cidr, NetsukukuRouteSolutions* route_solutions, NetsukukuRouteSolutions* old_route_solutions) {
	NetsukukuImplLinuxLinuxRoute * self;
	const gchar* _tmp0_;
	const gchar* _tmp19_;
	const gchar* _tmp20_;
	NetsukukuRouteSolutions* _tmp21_;
	gchar* _tmp22_ = NULL;
	gchar* _tmp23_;
	self = (NetsukukuImplLinuxLinuxRoute*) base;
	g_return_if_fail (ip != NULL);
	g_return_if_fail (cidr != NULL);
	g_return_if_fail (route_solutions != NULL);
	g_return_if_fail (old_route_solutions != NULL);
	_tmp0_ = cidr;
	if (g_strcmp0 (_tmp0_, "32") == 0) {
		NetsukukuRouteSolutions* _tmp1_;
		const gchar* _tmp2_;
		gboolean _tmp3_ = FALSE;
		_tmp1_ = route_solutions;
		_tmp2_ = ip;
		_tmp3_ = netsukuku_route_solutions_contains_gw (_tmp1_, _tmp2_);
		if (_tmp3_) {
			NetsukukuRouteSolutions* _tmp4_;
			const gchar* _tmp5_;
			gboolean _tmp6_ = FALSE;
			_tmp4_ = old_route_solutions;
			_tmp5_ = ip;
			_tmp6_ = netsukuku_route_solutions_contains_gw (_tmp4_, _tmp5_);
			if (_tmp6_) {
				return;
			} else {
				const gchar* _tmp7_;
				const gchar* _tmp8_;
				gchar* _tmp9_ = NULL;
				gchar* _tmp10_;
				_tmp7_ = ip;
				_tmp8_ = cidr;
				_tmp9_ = _netsukuku_impl_linux_linux_route_modify_routes_cmd (self, "del", _tmp7_, _tmp8_, NULL, NULL);
				_tmp10_ = _tmp9_;
				netsukuku_impl_linux_iproute_exp (_tmp10_);
				_g_free0 (_tmp10_);
				return;
			}
		} else {
			NetsukukuRouteSolutions* _tmp11_;
			const gchar* _tmp12_;
			gboolean _tmp13_ = FALSE;
			_tmp11_ = old_route_solutions;
			_tmp12_ = ip;
			_tmp13_ = netsukuku_route_solutions_contains_gw (_tmp11_, _tmp12_);
			if (_tmp13_) {
				const gchar* _tmp14_;
				const gchar* _tmp15_;
				NetsukukuRouteSolutions* _tmp16_;
				gchar* _tmp17_ = NULL;
				gchar* _tmp18_;
				_tmp14_ = ip;
				_tmp15_ = cidr;
				_tmp16_ = route_solutions;
				_tmp17_ = _netsukuku_impl_linux_linux_route_modify_routes_cmd (self, "add", _tmp14_, _tmp15_, _tmp16_, NULL);
				_tmp18_ = _tmp17_;
				netsukuku_impl_linux_iproute_exp (_tmp18_);
				_g_free0 (_tmp18_);
				return;
			}
		}
	}
	_tmp19_ = ip;
	_tmp20_ = cidr;
	_tmp21_ = route_solutions;
	_tmp22_ = _netsukuku_impl_linux_linux_route_modify_routes_cmd (self, "change", _tmp19_, _tmp20_, _tmp21_, NULL);
	_tmp23_ = _tmp22_;
	netsukuku_impl_linux_iproute_exp (_tmp23_);
	_g_free0 (_tmp23_);
}


/** Change a route (that was existent) towards ip/cidr
          * for packets coming from MAC prev_hop.
          * The gateways are route_solutions.
          * The old gateways were old_route_solutions
          */
static void netsukuku_impl_linux_linux_route_real__change_forwarding_route (NetsukukuRouteSetter* base, const gchar* ip, const gchar* cidr, const gchar* prev_hop, NetsukukuRouteSolutions* route_solutions, NetsukukuRouteSolutions* old_route_solutions, GError** error) {
	NetsukukuImplLinuxLinuxRoute * self;
	const gchar* _tmp0_;
	gint _tmp1_ = 0;
	gint idn;
	const gchar* _tmp2_;
	const gchar* _tmp25_;
	const gchar* _tmp26_;
	NetsukukuRouteSolutions* _tmp27_;
	gchar* _tmp28_ = NULL;
	gchar* _tmp29_;
	gchar* _tmp30_ = NULL;
	gchar* _tmp31_;
	GError * _inner_error_ = NULL;
	self = (NetsukukuImplLinuxLinuxRoute*) base;
	g_return_if_fail (ip != NULL);
	g_return_if_fail (cidr != NULL);
	g_return_if_fail (prev_hop != NULL);
	g_return_if_fail (route_solutions != NULL);
	g_return_if_fail (old_route_solutions != NULL);
	_tmp0_ = prev_hop;
	_tmp1_ = _netsukuku_impl_linux_linux_route_table_for_macaddr (self, _tmp0_, &_inner_error_);
	idn = _tmp1_;
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		return;
	}
	_tmp2_ = cidr;
	if (g_strcmp0 (_tmp2_, "32") == 0) {
		NetsukukuRouteSolutions* _tmp3_;
		const gchar* _tmp4_;
		gboolean _tmp5_ = FALSE;
		_tmp3_ = route_solutions;
		_tmp4_ = ip;
		_tmp5_ = netsukuku_route_solutions_contains_gw (_tmp3_, _tmp4_);
		if (_tmp5_) {
			NetsukukuRouteSolutions* _tmp6_;
			const gchar* _tmp7_;
			gboolean _tmp8_ = FALSE;
			_tmp6_ = old_route_solutions;
			_tmp7_ = ip;
			_tmp8_ = netsukuku_route_solutions_contains_gw (_tmp6_, _tmp7_);
			if (_tmp8_) {
				return;
			} else {
				const gchar* _tmp9_;
				const gchar* _tmp10_;
				gchar* _tmp11_ = NULL;
				gchar* _tmp12_;
				gchar* _tmp13_ = NULL;
				gchar* _tmp14_;
				_tmp9_ = ip;
				_tmp10_ = cidr;
				_tmp11_ = g_strdup_printf ("%i", idn);
				_tmp12_ = _tmp11_;
				_tmp13_ = _netsukuku_impl_linux_linux_route_modify_routes_cmd (self, "del", _tmp9_, _tmp10_, NULL, _tmp12_);
				_tmp14_ = _tmp13_;
				netsukuku_impl_linux_iproute_exp (_tmp14_);
				_g_free0 (_tmp14_);
				_g_free0 (_tmp12_);
				return;
			}
		} else {
			NetsukukuRouteSolutions* _tmp15_;
			const gchar* _tmp16_;
			gboolean _tmp17_ = FALSE;
			_tmp15_ = old_route_solutions;
			_tmp16_ = ip;
			_tmp17_ = netsukuku_route_solutions_contains_gw (_tmp15_, _tmp16_);
			if (_tmp17_) {
				const gchar* _tmp18_;
				const gchar* _tmp19_;
				NetsukukuRouteSolutions* _tmp20_;
				gchar* _tmp21_ = NULL;
				gchar* _tmp22_;
				gchar* _tmp23_ = NULL;
				gchar* _tmp24_;
				_tmp18_ = ip;
				_tmp19_ = cidr;
				_tmp20_ = route_solutions;
				_tmp21_ = g_strdup_printf ("%i", idn);
				_tmp22_ = _tmp21_;
				_tmp23_ = _netsukuku_impl_linux_linux_route_modify_routes_cmd (self, "add", _tmp18_, _tmp19_, _tmp20_, _tmp22_);
				_tmp24_ = _tmp23_;
				netsukuku_impl_linux_iproute_exp (_tmp24_);
				_g_free0 (_tmp24_);
				_g_free0 (_tmp22_);
				return;
			}
		}
	}
	_tmp25_ = ip;
	_tmp26_ = cidr;
	_tmp27_ = route_solutions;
	_tmp28_ = g_strdup_printf ("%i", idn);
	_tmp29_ = _tmp28_;
	_tmp30_ = _netsukuku_impl_linux_linux_route_modify_routes_cmd (self, "change", _tmp25_, _tmp26_, _tmp27_, _tmp29_);
	_tmp31_ = _tmp30_;
	netsukuku_impl_linux_iproute_exp (_tmp31_);
	_g_free0 (_tmp31_);
	_g_free0 (_tmp29_);
}


/** Change a route (that was existent) towards ip/cidr
          * for packets coming from MAC prev_hop.
          * In fact this route is UNREACHABLE
          * The old gateways were old_route_solutions
          */
static void netsukuku_impl_linux_linux_route_real__change_forwarding_route_unreachable (NetsukukuRouteSetter* base, const gchar* ip, const gchar* cidr, const gchar* prev_hop, NetsukukuRouteSolutions* old_route_solutions, GError** error) {
	NetsukukuImplLinuxLinuxRoute * self;
	const gchar* _tmp0_;
	gint _tmp1_ = 0;
	gint idn;
	gboolean _tmp2_ = FALSE;
	const gchar* _tmp3_;
	gboolean _tmp7_;
	gchar* _tmp16_ = NULL;
	gchar* _tmp17_;
	const gchar* _tmp18_;
	const gchar* _tmp19_ = NULL;
	const gchar* _tmp20_;
	const gchar* _tmp21_ = NULL;
	gchar* _tmp22_ = NULL;
	gchar* _tmp23_;
	GError * _inner_error_ = NULL;
	self = (NetsukukuImplLinuxLinuxRoute*) base;
	g_return_if_fail (ip != NULL);
	g_return_if_fail (cidr != NULL);
	g_return_if_fail (prev_hop != NULL);
	g_return_if_fail (old_route_solutions != NULL);
	_tmp0_ = prev_hop;
	_tmp1_ = _netsukuku_impl_linux_linux_route_table_for_macaddr (self, _tmp0_, &_inner_error_);
	idn = _tmp1_;
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		return;
	}
	_tmp3_ = cidr;
	if (g_strcmp0 (_tmp3_, "32") == 0) {
		NetsukukuRouteSolutions* _tmp4_;
		const gchar* _tmp5_;
		gboolean _tmp6_ = FALSE;
		_tmp4_ = old_route_solutions;
		_tmp5_ = ip;
		_tmp6_ = netsukuku_route_solutions_contains_gw (_tmp4_, _tmp5_);
		_tmp2_ = _tmp6_;
	} else {
		_tmp2_ = FALSE;
	}
	_tmp7_ = _tmp2_;
	if (_tmp7_) {
		gchar* _tmp8_ = NULL;
		gchar* _tmp9_;
		const gchar* _tmp10_;
		const gchar* _tmp11_ = NULL;
		const gchar* _tmp12_;
		const gchar* _tmp13_ = NULL;
		gchar* _tmp14_ = NULL;
		gchar* _tmp15_;
		_tmp8_ = g_strdup_printf ("%i", idn);
		_tmp9_ = _tmp8_;
		_tmp10_ = ip;
		_tmp11_ = string_to_string (_tmp10_);
		_tmp12_ = cidr;
		_tmp13_ = string_to_string (_tmp12_);
		_tmp14_ = g_strconcat ("route add table ", _tmp9_, " unreachable ", _tmp11_, "/", _tmp13_, NULL);
		_tmp15_ = _tmp14_;
		netsukuku_impl_linux_iproute_exp (_tmp15_);
		_g_free0 (_tmp15_);
		_g_free0 (_tmp9_);
		return;
	}
	_tmp16_ = g_strdup_printf ("%i", idn);
	_tmp17_ = _tmp16_;
	_tmp18_ = ip;
	_tmp19_ = string_to_string (_tmp18_);
	_tmp20_ = cidr;
	_tmp21_ = string_to_string (_tmp20_);
	_tmp22_ = g_strconcat ("route change table ", _tmp17_, " unreachable ", _tmp19_, "/", _tmp21_, NULL);
	_tmp23_ = _tmp22_;
	netsukuku_impl_linux_iproute_exp (_tmp23_);
	_g_free0 (_tmp23_);
	_g_free0 (_tmp17_);
}


/** Change a route (that was existent) towards ip/cidr
          * for packets coming from MAC prev_hop.
          * In fact this route is DROP
          * The old gateways were old_route_solutions
          */
static void netsukuku_impl_linux_linux_route_real__change_forwarding_route_drop (NetsukukuRouteSetter* base, const gchar* ip, const gchar* cidr, const gchar* prev_hop, NetsukukuRouteSolutions* old_route_solutions, GError** error) {
	NetsukukuImplLinuxLinuxRoute * self;
	const gchar* _tmp0_;
	gint _tmp1_ = 0;
	gint idn;
	gboolean _tmp2_ = FALSE;
	const gchar* _tmp3_;
	gboolean _tmp7_;
	gchar* _tmp16_ = NULL;
	gchar* _tmp17_;
	const gchar* _tmp18_;
	const gchar* _tmp19_ = NULL;
	const gchar* _tmp20_;
	const gchar* _tmp21_ = NULL;
	gchar* _tmp22_ = NULL;
	gchar* _tmp23_;
	GError * _inner_error_ = NULL;
	self = (NetsukukuImplLinuxLinuxRoute*) base;
	g_return_if_fail (ip != NULL);
	g_return_if_fail (cidr != NULL);
	g_return_if_fail (prev_hop != NULL);
	g_return_if_fail (old_route_solutions != NULL);
	_tmp0_ = prev_hop;
	_tmp1_ = _netsukuku_impl_linux_linux_route_table_for_macaddr (self, _tmp0_, &_inner_error_);
	idn = _tmp1_;
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		return;
	}
	_tmp3_ = cidr;
	if (g_strcmp0 (_tmp3_, "32") == 0) {
		NetsukukuRouteSolutions* _tmp4_;
		const gchar* _tmp5_;
		gboolean _tmp6_ = FALSE;
		_tmp4_ = old_route_solutions;
		_tmp5_ = ip;
		_tmp6_ = netsukuku_route_solutions_contains_gw (_tmp4_, _tmp5_);
		_tmp2_ = _tmp6_;
	} else {
		_tmp2_ = FALSE;
	}
	_tmp7_ = _tmp2_;
	if (_tmp7_) {
		gchar* _tmp8_ = NULL;
		gchar* _tmp9_;
		const gchar* _tmp10_;
		const gchar* _tmp11_ = NULL;
		const gchar* _tmp12_;
		const gchar* _tmp13_ = NULL;
		gchar* _tmp14_ = NULL;
		gchar* _tmp15_;
		_tmp8_ = g_strdup_printf ("%i", idn);
		_tmp9_ = _tmp8_;
		_tmp10_ = ip;
		_tmp11_ = string_to_string (_tmp10_);
		_tmp12_ = cidr;
		_tmp13_ = string_to_string (_tmp12_);
		_tmp14_ = g_strconcat ("route add table ", _tmp9_, " blackhole ", _tmp11_, "/", _tmp13_, NULL);
		_tmp15_ = _tmp14_;
		netsukuku_impl_linux_iproute_exp (_tmp15_);
		_g_free0 (_tmp15_);
		_g_free0 (_tmp9_);
		return;
	}
	_tmp16_ = g_strdup_printf ("%i", idn);
	_tmp17_ = _tmp16_;
	_tmp18_ = ip;
	_tmp19_ = string_to_string (_tmp18_);
	_tmp20_ = cidr;
	_tmp21_ = string_to_string (_tmp20_);
	_tmp22_ = g_strconcat ("route change table ", _tmp17_, " blackhole ", _tmp19_, "/", _tmp21_, NULL);
	_tmp23_ = _tmp22_;
	netsukuku_impl_linux_iproute_exp (_tmp23_);
	_g_free0 (_tmp23_);
	_g_free0 (_tmp17_);
}


/** Change a route (that was existent) towards ip/cidr
          * for packets coming from MAC prev_hop.
          * The gateways are route_solutions.
          * Previously the route was UNREACHABLE
          */
static void netsukuku_impl_linux_linux_route_real__change_forwarding_route_was_unreachable (NetsukukuRouteSetter* base, const gchar* ip, const gchar* cidr, const gchar* prev_hop, NetsukukuRouteSolutions* route_solutions, GError** error) {
	NetsukukuImplLinuxLinuxRoute * self;
	const gchar* _tmp0_;
	gint _tmp1_ = 0;
	gint idn;
	gboolean _tmp2_ = FALSE;
	const gchar* _tmp3_;
	gboolean _tmp7_;
	const gchar* _tmp16_;
	const gchar* _tmp17_;
	NetsukukuRouteSolutions* _tmp18_;
	gchar* _tmp19_ = NULL;
	gchar* _tmp20_;
	gchar* _tmp21_ = NULL;
	gchar* _tmp22_;
	GError * _inner_error_ = NULL;
	self = (NetsukukuImplLinuxLinuxRoute*) base;
	g_return_if_fail (ip != NULL);
	g_return_if_fail (cidr != NULL);
	g_return_if_fail (prev_hop != NULL);
	g_return_if_fail (route_solutions != NULL);
	_tmp0_ = prev_hop;
	_tmp1_ = _netsukuku_impl_linux_linux_route_table_for_macaddr (self, _tmp0_, &_inner_error_);
	idn = _tmp1_;
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		return;
	}
	_tmp3_ = cidr;
	if (g_strcmp0 (_tmp3_, "32") == 0) {
		NetsukukuRouteSolutions* _tmp4_;
		const gchar* _tmp5_;
		gboolean _tmp6_ = FALSE;
		_tmp4_ = route_solutions;
		_tmp5_ = ip;
		_tmp6_ = netsukuku_route_solutions_contains_gw (_tmp4_, _tmp5_);
		_tmp2_ = _tmp6_;
	} else {
		_tmp2_ = FALSE;
	}
	_tmp7_ = _tmp2_;
	if (_tmp7_) {
		gchar* _tmp8_ = NULL;
		gchar* _tmp9_;
		const gchar* _tmp10_;
		const gchar* _tmp11_ = NULL;
		const gchar* _tmp12_;
		const gchar* _tmp13_ = NULL;
		gchar* _tmp14_ = NULL;
		gchar* _tmp15_;
		_tmp8_ = g_strdup_printf ("%i", idn);
		_tmp9_ = _tmp8_;
		_tmp10_ = ip;
		_tmp11_ = string_to_string (_tmp10_);
		_tmp12_ = cidr;
		_tmp13_ = string_to_string (_tmp12_);
		_tmp14_ = g_strconcat ("route del table ", _tmp9_, " unreachable ", _tmp11_, "/", _tmp13_, NULL);
		_tmp15_ = _tmp14_;
		netsukuku_impl_linux_iproute_exp (_tmp15_);
		_g_free0 (_tmp15_);
		_g_free0 (_tmp9_);
		return;
	}
	_tmp16_ = ip;
	_tmp17_ = cidr;
	_tmp18_ = route_solutions;
	_tmp19_ = g_strdup_printf ("%i", idn);
	_tmp20_ = _tmp19_;
	_tmp21_ = _netsukuku_impl_linux_linux_route_modify_routes_cmd (self, "change", _tmp16_, _tmp17_, _tmp18_, _tmp20_);
	_tmp22_ = _tmp21_;
	netsukuku_impl_linux_iproute_exp (_tmp22_);
	_g_free0 (_tmp22_);
	_g_free0 (_tmp20_);
}


/** Change a route (that was existent) towards ip/cidr
          * for packets coming from MAC prev_hop.
          * In fact now this route is DROP
          * Previously the route was UNREACHABLE
          */
static void netsukuku_impl_linux_linux_route_real__change_forwarding_route_drop_was_unreachable (NetsukukuRouteSetter* base, const gchar* ip, const gchar* cidr, const gchar* prev_hop, GError** error) {
	NetsukukuImplLinuxLinuxRoute * self;
	const gchar* _tmp0_;
	gint _tmp1_ = 0;
	gint idn;
	gchar* _tmp2_ = NULL;
	gchar* _tmp3_;
	const gchar* _tmp4_;
	const gchar* _tmp5_ = NULL;
	const gchar* _tmp6_;
	const gchar* _tmp7_ = NULL;
	gchar* _tmp8_ = NULL;
	gchar* _tmp9_;
	GError * _inner_error_ = NULL;
	self = (NetsukukuImplLinuxLinuxRoute*) base;
	g_return_if_fail (ip != NULL);
	g_return_if_fail (cidr != NULL);
	g_return_if_fail (prev_hop != NULL);
	_tmp0_ = prev_hop;
	_tmp1_ = _netsukuku_impl_linux_linux_route_table_for_macaddr (self, _tmp0_, &_inner_error_);
	idn = _tmp1_;
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		return;
	}
	_tmp2_ = g_strdup_printf ("%i", idn);
	_tmp3_ = _tmp2_;
	_tmp4_ = ip;
	_tmp5_ = string_to_string (_tmp4_);
	_tmp6_ = cidr;
	_tmp7_ = string_to_string (_tmp6_);
	_tmp8_ = g_strconcat ("route change table ", _tmp3_, " blackhole ", _tmp5_, "/", _tmp7_, NULL);
	_tmp9_ = _tmp8_;
	netsukuku_impl_linux_iproute_exp (_tmp9_);
	_g_free0 (_tmp9_);
	_g_free0 (_tmp3_);
}


/** Change a route (that was existent) towards ip/cidr
          * for packets coming from MAC prev_hop.
          * The gateways are route_solutions.
          * Previously the route was DROP
          */
static void netsukuku_impl_linux_linux_route_real__change_forwarding_route_was_drop (NetsukukuRouteSetter* base, const gchar* ip, const gchar* cidr, const gchar* prev_hop, NetsukukuRouteSolutions* route_solutions, GError** error) {
	NetsukukuImplLinuxLinuxRoute * self;
	const gchar* _tmp0_;
	gint _tmp1_ = 0;
	gint idn;
	gboolean _tmp2_ = FALSE;
	const gchar* _tmp3_;
	gboolean _tmp7_;
	const gchar* _tmp16_;
	const gchar* _tmp17_;
	NetsukukuRouteSolutions* _tmp18_;
	gchar* _tmp19_ = NULL;
	gchar* _tmp20_;
	gchar* _tmp21_ = NULL;
	gchar* _tmp22_;
	GError * _inner_error_ = NULL;
	self = (NetsukukuImplLinuxLinuxRoute*) base;
	g_return_if_fail (ip != NULL);
	g_return_if_fail (cidr != NULL);
	g_return_if_fail (prev_hop != NULL);
	g_return_if_fail (route_solutions != NULL);
	_tmp0_ = prev_hop;
	_tmp1_ = _netsukuku_impl_linux_linux_route_table_for_macaddr (self, _tmp0_, &_inner_error_);
	idn = _tmp1_;
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		return;
	}
	_tmp3_ = cidr;
	if (g_strcmp0 (_tmp3_, "32") == 0) {
		NetsukukuRouteSolutions* _tmp4_;
		const gchar* _tmp5_;
		gboolean _tmp6_ = FALSE;
		_tmp4_ = route_solutions;
		_tmp5_ = ip;
		_tmp6_ = netsukuku_route_solutions_contains_gw (_tmp4_, _tmp5_);
		_tmp2_ = _tmp6_;
	} else {
		_tmp2_ = FALSE;
	}
	_tmp7_ = _tmp2_;
	if (_tmp7_) {
		gchar* _tmp8_ = NULL;
		gchar* _tmp9_;
		const gchar* _tmp10_;
		const gchar* _tmp11_ = NULL;
		const gchar* _tmp12_;
		const gchar* _tmp13_ = NULL;
		gchar* _tmp14_ = NULL;
		gchar* _tmp15_;
		_tmp8_ = g_strdup_printf ("%i", idn);
		_tmp9_ = _tmp8_;
		_tmp10_ = ip;
		_tmp11_ = string_to_string (_tmp10_);
		_tmp12_ = cidr;
		_tmp13_ = string_to_string (_tmp12_);
		_tmp14_ = g_strconcat ("route del table ", _tmp9_, " blackhole ", _tmp11_, "/", _tmp13_, NULL);
		_tmp15_ = _tmp14_;
		netsukuku_impl_linux_iproute_exp (_tmp15_);
		_g_free0 (_tmp15_);
		_g_free0 (_tmp9_);
		return;
	}
	_tmp16_ = ip;
	_tmp17_ = cidr;
	_tmp18_ = route_solutions;
	_tmp19_ = g_strdup_printf ("%i", idn);
	_tmp20_ = _tmp19_;
	_tmp21_ = _netsukuku_impl_linux_linux_route_modify_routes_cmd (self, "change", _tmp16_, _tmp17_, _tmp18_, _tmp20_);
	_tmp22_ = _tmp21_;
	netsukuku_impl_linux_iproute_exp (_tmp22_);
	_g_free0 (_tmp22_);
	_g_free0 (_tmp20_);
}


/** Change a route (that was existent) towards ip/cidr
          * for packets coming from MAC prev_hop.
          * In fact now this route is UNREACHABLE
          * Previously the route was DROP
          */
static void netsukuku_impl_linux_linux_route_real__change_forwarding_route_unreachable_was_drop (NetsukukuRouteSetter* base, const gchar* ip, const gchar* cidr, const gchar* prev_hop, GError** error) {
	NetsukukuImplLinuxLinuxRoute * self;
	const gchar* _tmp0_;
	gint _tmp1_ = 0;
	gint idn;
	gchar* _tmp2_ = NULL;
	gchar* _tmp3_;
	const gchar* _tmp4_;
	const gchar* _tmp5_ = NULL;
	const gchar* _tmp6_;
	const gchar* _tmp7_ = NULL;
	gchar* _tmp8_ = NULL;
	gchar* _tmp9_;
	GError * _inner_error_ = NULL;
	self = (NetsukukuImplLinuxLinuxRoute*) base;
	g_return_if_fail (ip != NULL);
	g_return_if_fail (cidr != NULL);
	g_return_if_fail (prev_hop != NULL);
	_tmp0_ = prev_hop;
	_tmp1_ = _netsukuku_impl_linux_linux_route_table_for_macaddr (self, _tmp0_, &_inner_error_);
	idn = _tmp1_;
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		return;
	}
	_tmp2_ = g_strdup_printf ("%i", idn);
	_tmp3_ = _tmp2_;
	_tmp4_ = ip;
	_tmp5_ = string_to_string (_tmp4_);
	_tmp6_ = cidr;
	_tmp7_ = string_to_string (_tmp6_);
	_tmp8_ = g_strconcat ("route change table ", _tmp3_, " unreachable ", _tmp5_, "/", _tmp7_, NULL);
	_tmp9_ = _tmp8_;
	netsukuku_impl_linux_iproute_exp (_tmp9_);
	_g_free0 (_tmp9_);
	_g_free0 (_tmp3_);
}


/** Remove a route (that was existent) towards ip/cidr
          * for packets generated by this host.
          * The old gateways were old_route_solutions
          */
static void netsukuku_impl_linux_linux_route_real__remove_outgoing_route (NetsukukuRouteSetter* base, const gchar* ip, const gchar* cidr, NetsukukuRouteSolutions* old_route_solutions) {
	NetsukukuImplLinuxLinuxRoute * self;
	const gchar* _tmp0_;
	const gchar* _tmp1_;
	gchar* _tmp2_ = NULL;
	gchar* _tmp3_;
	self = (NetsukukuImplLinuxLinuxRoute*) base;
	g_return_if_fail (ip != NULL);
	g_return_if_fail (cidr != NULL);
	g_return_if_fail (old_route_solutions != NULL);
	_tmp0_ = ip;
	_tmp1_ = cidr;
	_tmp2_ = _netsukuku_impl_linux_linux_route_modify_routes_cmd (self, "del", _tmp0_, _tmp1_, NULL, NULL);
	_tmp3_ = _tmp2_;
	netsukuku_impl_linux_iproute_exp (_tmp3_);
	_g_free0 (_tmp3_);
}


/** Remove a route (that was existent) towards ip/cidr
          * for packets coming from MAC prev_hop.
          * The old gateways were old_route_solutions
          */
static void netsukuku_impl_linux_linux_route_real__remove_forwarding_route (NetsukukuRouteSetter* base, const gchar* ip, const gchar* cidr, const gchar* prev_hop, NetsukukuRouteSolutions* old_route_solutions, GError** error) {
	NetsukukuImplLinuxLinuxRoute * self;
	const gchar* _tmp0_;
	gint _tmp1_ = 0;
	gint idn;
	const gchar* _tmp2_;
	const gchar* _tmp3_;
	gchar* _tmp4_ = NULL;
	gchar* _tmp5_;
	gchar* _tmp6_ = NULL;
	gchar* _tmp7_;
	GError * _inner_error_ = NULL;
	self = (NetsukukuImplLinuxLinuxRoute*) base;
	g_return_if_fail (ip != NULL);
	g_return_if_fail (cidr != NULL);
	g_return_if_fail (prev_hop != NULL);
	g_return_if_fail (old_route_solutions != NULL);
	_tmp0_ = prev_hop;
	_tmp1_ = _netsukuku_impl_linux_linux_route_table_for_macaddr (self, _tmp0_, &_inner_error_);
	idn = _tmp1_;
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		return;
	}
	_tmp2_ = ip;
	_tmp3_ = cidr;
	_tmp4_ = g_strdup_printf ("%i", idn);
	_tmp5_ = _tmp4_;
	_tmp6_ = _netsukuku_impl_linux_linux_route_modify_routes_cmd (self, "del", _tmp2_, _tmp3_, NULL, _tmp5_);
	_tmp7_ = _tmp6_;
	netsukuku_impl_linux_iproute_exp (_tmp7_);
	_g_free0 (_tmp7_);
	_g_free0 (_tmp5_);
}


/** Remove a route (that was existent) towards ip/cidr
          * for packets coming from MAC prev_hop.
          * Previously the route was UNREACHABLE
          */
static void netsukuku_impl_linux_linux_route_real__remove_forwarding_route_was_unreachable (NetsukukuRouteSetter* base, const gchar* ip, const gchar* cidr, const gchar* prev_hop, GError** error) {
	NetsukukuImplLinuxLinuxRoute * self;
	const gchar* _tmp0_;
	gint _tmp1_ = 0;
	gint idn;
	const gchar* _tmp2_;
	const gchar* _tmp3_;
	gchar* _tmp4_ = NULL;
	gchar* _tmp5_;
	gchar* _tmp6_ = NULL;
	gchar* _tmp7_;
	GError * _inner_error_ = NULL;
	self = (NetsukukuImplLinuxLinuxRoute*) base;
	g_return_if_fail (ip != NULL);
	g_return_if_fail (cidr != NULL);
	g_return_if_fail (prev_hop != NULL);
	_tmp0_ = prev_hop;
	_tmp1_ = _netsukuku_impl_linux_linux_route_table_for_macaddr (self, _tmp0_, &_inner_error_);
	idn = _tmp1_;
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		return;
	}
	_tmp2_ = ip;
	_tmp3_ = cidr;
	_tmp4_ = g_strdup_printf ("%i", idn);
	_tmp5_ = _tmp4_;
	_tmp6_ = _netsukuku_impl_linux_linux_route_modify_routes_cmd (self, "del", _tmp2_, _tmp3_, NULL, _tmp5_);
	_tmp7_ = _tmp6_;
	netsukuku_impl_linux_iproute_exp (_tmp7_);
	_g_free0 (_tmp7_);
	_g_free0 (_tmp5_);
}


/** Remove a route (that was existent) towards ip/cidr
          * for packets coming from MAC prev_hop.
          * Previously the route was DROP
          */
static void netsukuku_impl_linux_linux_route_real__remove_forwarding_route_was_drop (NetsukukuRouteSetter* base, const gchar* ip, const gchar* cidr, const gchar* prev_hop, GError** error) {
	NetsukukuImplLinuxLinuxRoute * self;
	const gchar* _tmp0_;
	gint _tmp1_ = 0;
	gint idn;
	const gchar* _tmp2_;
	const gchar* _tmp3_;
	gchar* _tmp4_ = NULL;
	gchar* _tmp5_;
	gchar* _tmp6_ = NULL;
	gchar* _tmp7_;
	GError * _inner_error_ = NULL;
	self = (NetsukukuImplLinuxLinuxRoute*) base;
	g_return_if_fail (ip != NULL);
	g_return_if_fail (cidr != NULL);
	g_return_if_fail (prev_hop != NULL);
	_tmp0_ = prev_hop;
	_tmp1_ = _netsukuku_impl_linux_linux_route_table_for_macaddr (self, _tmp0_, &_inner_error_);
	idn = _tmp1_;
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		return;
	}
	_tmp2_ = ip;
	_tmp3_ = cidr;
	_tmp4_ = g_strdup_printf ("%i", idn);
	_tmp5_ = _tmp4_;
	_tmp6_ = _netsukuku_impl_linux_linux_route_modify_routes_cmd (self, "del", _tmp2_, _tmp3_, NULL, _tmp5_);
	_tmp7_ = _tmp6_;
	netsukuku_impl_linux_iproute_exp (_tmp7_);
	_g_free0 (_tmp7_);
	_g_free0 (_tmp5_);
}


/** Stop forwarding (in fact it means delete all rules for...)
          * packets coming from MAC prev_hop.
          */
static void netsukuku_impl_linux_linux_route_real__forward_no_more_from (NetsukukuRouteSetter* base, const gchar* _prev_hop, GError** error) {
	NetsukukuImplLinuxLinuxRoute * self;
	const gchar* _tmp0_;
	gchar* _tmp1_ = NULL;
	gchar* prev_hop;
	GeeHashMap* _tmp2_;
	const gchar* _tmp3_;
	gboolean _tmp4_ = FALSE;
	GError * _inner_error_ = NULL;
	self = (NetsukukuImplLinuxLinuxRoute*) base;
	g_return_if_fail (_prev_hop != NULL);
	_tmp0_ = _prev_hop;
	_tmp1_ = g_utf8_strdown (_tmp0_, (gssize) (-1));
	prev_hop = _tmp1_;
	_tmp2_ = self->priv->mac_table;
	_tmp3_ = prev_hop;
	_tmp4_ = gee_abstract_map_has_key ((GeeAbstractMap*) _tmp2_, _tmp3_);
	if (_tmp4_) {
		const gchar* _tmp5_;
		gint _tmp6_ = 0;
		gint idn;
		const gchar* _tmp25_;
		_tmp5_ = prev_hop;
		_tmp6_ = _netsukuku_impl_linux_linux_route_table_for_macaddr (self, _tmp5_, &_inner_error_);
		idn = _tmp6_;
		if (_inner_error_ != NULL) {
			g_propagate_error (error, _inner_error_);
			_g_free0 (prev_hop);
			return;
		}
		{
			gint _tmp7_;
			gchar* _tmp8_ = NULL;
			gchar* _tmp9_;
			gchar* _tmp10_ = NULL;
			gchar* _tmp11_;
			gchar* _tmp12_ = NULL;
			gchar* _tmp13_;
			_tmp7_ = idn;
			_tmp8_ = g_strdup_printf ("%i", _tmp7_);
			_tmp9_ = _tmp8_;
			_tmp10_ = g_strconcat ("route flush table ", _tmp9_, NULL);
			_tmp11_ = _tmp10_;
			_tmp12_ = netsukuku_impl_linux_iproute (_tmp11_, &_inner_error_);
			_tmp13_ = _tmp12_;
			_g_free0 (_tmp13_);
			_g_free0 (_tmp11_);
			_g_free0 (_tmp9_);
			if (_inner_error_ != NULL) {
				goto __catch79_g_error;
			}
		}
		goto __finally79;
		__catch79_g_error:
		{
			GError* e = NULL;
			GError* _tmp14_;
			const gchar* _tmp15_;
			gboolean _tmp16_ = FALSE;
			e = _inner_error_;
			_inner_error_ = NULL;
			_tmp14_ = e;
			_tmp15_ = _tmp14_->message;
			_tmp16_ = string_contains (_tmp15_, "Nothing to flush");
			if (!_tmp16_) {
				gint _tmp17_;
				gchar* _tmp18_ = NULL;
				gchar* _tmp19_;
				GError* _tmp20_;
				const gchar* _tmp21_;
				const gchar* _tmp22_ = NULL;
				gchar* _tmp23_ = NULL;
				gchar* _tmp24_;
				_tmp17_ = idn;
				_tmp18_ = g_strdup_printf ("%i", _tmp17_);
				_tmp19_ = _tmp18_;
				_tmp20_ = e;
				_tmp21_ = _tmp20_->message;
				_tmp22_ = string_to_string (_tmp21_);
				_tmp23_ = g_strconcat ("ip route flush table ", _tmp19_, ": reported ", _tmp22_, ". Perhaps better to abort?", NULL);
				_tmp24_ = _tmp23_;
				netsukuku_log_error (_tmp24_);
				_g_free0 (_tmp24_);
				_g_free0 (_tmp19_);
			}
			_g_error_free0 (e);
		}
		__finally79:
		if (_inner_error_ != NULL) {
			g_propagate_error (error, _inner_error_);
			_g_free0 (prev_hop);
			return;
		}
		_tmp25_ = prev_hop;
		_netsukuku_impl_linux_linux_route_table_for_macaddr_remove (self, _tmp25_, &_inner_error_);
		if (_inner_error_ != NULL) {
			g_propagate_error (error, _inner_error_);
			_g_free0 (prev_hop);
			return;
		}
	}
	_g_free0 (prev_hop);
}


/** Delete all specific rules for any prev_hop.
          */
static void netsukuku_impl_linux_linux_route_real__forward_no_more (NetsukukuRouteSetter* base, GError** error) {
	NetsukukuImplLinuxLinuxRoute * self;
	GError * _inner_error_ = NULL;
	self = (NetsukukuImplLinuxLinuxRoute*) base;
	_netsukuku_impl_linux_linux_route_table_for_macaddr_remove_all (self, &_inner_error_);
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		return;
	}
}


/** Adds a new neighbour with corresponding properties.
          */
static void netsukuku_impl_linux_linux_route_real__add_neighbour (NetsukukuRouteSetter* base, const gchar* ip, const gchar* dev, const gchar* pref_src) {
	NetsukukuImplLinuxLinuxRoute * self;
	const gchar* _tmp0_;
	const gchar* _tmp1_;
	const gchar* _tmp2_;
	gchar* _tmp3_ = NULL;
	gchar* _tmp4_;
	self = (NetsukukuImplLinuxLinuxRoute*) base;
	g_return_if_fail (ip != NULL);
	g_return_if_fail (dev != NULL);
	g_return_if_fail (pref_src != NULL);
	_tmp0_ = ip;
	_tmp1_ = dev;
	_tmp2_ = pref_src;
	_tmp3_ = _netsukuku_impl_linux_linux_route_modify_neighbour_cmd (self, "add", _tmp0_, _tmp1_, _tmp2_);
	_tmp4_ = _tmp3_;
	netsukuku_impl_linux_iproute_exp (_tmp4_);
	_g_free0 (_tmp4_);
}


/** Edits the neighbour with the corresponding properties.
          */
static void netsukuku_impl_linux_linux_route_real__change_neighbour (NetsukukuRouteSetter* base, const gchar* ip, const gchar* dev, const gchar* pref_src, const gchar* old_dev) {
	NetsukukuImplLinuxLinuxRoute * self;
	const gchar* _tmp0_;
	const gchar* _tmp1_;
	const gchar* _tmp2_;
	gchar* _tmp3_ = NULL;
	gchar* _tmp4_;
	self = (NetsukukuImplLinuxLinuxRoute*) base;
	g_return_if_fail (ip != NULL);
	g_return_if_fail (dev != NULL);
	g_return_if_fail (pref_src != NULL);
	g_return_if_fail (old_dev != NULL);
	_tmp0_ = ip;
	_tmp1_ = dev;
	_tmp2_ = pref_src;
	_tmp3_ = _netsukuku_impl_linux_linux_route_modify_neighbour_cmd (self, "change", _tmp0_, _tmp1_, _tmp2_);
	_tmp4_ = _tmp3_;
	netsukuku_impl_linux_iproute_exp (_tmp4_);
	_g_free0 (_tmp4_);
}


/** Removes the neighbour with the corresponding properties.
          */
static void netsukuku_impl_linux_linux_route_real__delete_neighbour (NetsukukuRouteSetter* base, const gchar* ip, const gchar* old_dev) {
	NetsukukuImplLinuxLinuxRoute * self;
	const gchar* _tmp0_;
	gchar* _tmp1_ = NULL;
	gchar* _tmp2_;
	self = (NetsukukuImplLinuxLinuxRoute*) base;
	g_return_if_fail (ip != NULL);
	g_return_if_fail (old_dev != NULL);
	_tmp0_ = ip;
	_tmp1_ = _netsukuku_impl_linux_linux_route_modify_neighbour_cmd (self, "del", _tmp0_, NULL, NULL);
	_tmp2_ = _tmp1_;
	netsukuku_impl_linux_iproute_exp (_tmp2_);
	_g_free0 (_tmp2_);
}


/** IGS management **/
void _netsukuku_impl_linux_linux_route_disable_rp_filter (NetsukukuImplLinuxLinuxRoute* self, const gchar* nicname) {
	const gchar* _tmp0_;
	const gchar* _tmp1_ = NULL;
	gchar* _tmp2_ = NULL;
	gchar* path;
	gchar* _tmp3_;
	gchar* content;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (nicname != NULL);
	_tmp0_ = nicname;
	_tmp1_ = string_to_string (_tmp0_);
	_tmp2_ = g_strconcat ("/proc/sys/net/ipv4/conf/", _tmp1_, "/rp_filter", NULL);
	path = _tmp2_;
	_tmp3_ = g_strdup ("0");
	content = _tmp3_;
	{
		guint8* _tmp4_;
		gint _tmp4__length1;
		guint8* _tmp5_;
		gint _tmp5__length1;
		_tmp4_ = string_get_data (content, &_tmp4__length1);
		_tmp5_ = _tmp4_;
		_tmp5__length1 = _tmp4__length1;
		netsukuku_impl_linux_write_file (path, _tmp5_, _tmp5__length1);
	}
	goto __finally80;
	__catch80_g_error:
	{
		GError* e = NULL;
		const gchar* _tmp6_ = NULL;
		const gchar* _tmp7_ = NULL;
		gchar* _tmp8_ = NULL;
		gchar* _tmp9_;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp6_ = string_to_string (content);
		_tmp7_ = string_to_string (path);
		_tmp8_ = g_strconcat ("rp_filter: error (ignored) writing '", _tmp6_, "' in '", _tmp7_, "'", NULL);
		_tmp9_ = _tmp8_;
		netsukuku_log_error (_tmp9_);
		_g_free0 (_tmp9_);
		_g_error_free0 (e);
	}
	__finally80:
	if (_inner_error_ != NULL) {
		_g_free0 (content);
		_g_free0 (path);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
	_g_free0 (content);
	_g_free0 (path);
}


static gboolean netsukuku_impl_linux_linux_route_real__igs_update_rules (NetsukukuRouteSetter* base, const gchar* prev_mode, gboolean prev_announce_myself, GeeArrayList* prev_list_tunnels, const gchar* mode, gboolean announce_myself, GeeArrayList* list_tunnels, const gchar* pref_src, GError** error) {
	NetsukukuImplLinuxLinuxRoute * self;
	gboolean result = FALSE;
	const gchar* _tmp1_;
	const gchar* _tmp2_ = NULL;
	gchar* _tmp3_ = NULL;
	gchar* _tmp4_;
	const gchar* _tmp5_;
	const gchar* _tmp6_ = NULL;
	gchar* _tmp7_ = NULL;
	gchar* _tmp8_;
	gchar* _tmp9_;
	gchar* dbg_list_tunnels;
	const gchar* _tmp28_;
	gchar* _tmp29_;
	const gchar* _tmp30_;
	const gchar* _tmp31_ = NULL;
	gchar* _tmp32_ = NULL;
	gchar* _tmp33_;
	const gchar* _tmp34_;
	gboolean _tmp35_ = FALSE;
	const gchar* _tmp36_;
	gboolean _tmp38_;
	gboolean _tmp39_ = FALSE;
	const gchar* _tmp40_;
	gboolean _tmp42_;
	gboolean _tmp43_ = FALSE;
	gboolean _tmp44_ = FALSE;
	const gchar* _tmp45_;
	gboolean _tmp47_;
	gboolean _tmp51_;
	gboolean _tmp181_ = FALSE;
	gboolean _tmp182_ = FALSE;
	const gchar* _tmp183_;
	gboolean _tmp185_;
	gboolean _tmp189_;
	gboolean _tmp318_ = FALSE;
	gboolean _tmp319_ = FALSE;
	const gchar* _tmp320_;
	gboolean _tmp322_;
	gboolean _tmp331_;
	GError * _inner_error_ = NULL;
	self = (NetsukukuImplLinuxLinuxRoute*) base;
	g_return_val_if_fail (prev_mode != NULL, FALSE);
	g_return_val_if_fail (prev_list_tunnels != NULL, FALSE);
	g_return_val_if_fail (mode != NULL, FALSE);
	g_return_val_if_fail (list_tunnels != NULL, FALSE);
	g_return_val_if_fail (pref_src != NULL, FALSE);
	{
		TaskletsCommandResult* _tmp0_ = NULL;
		TaskletsCommandResult* com_ret;
		_tmp0_ = netsukuku_impl_linux_exec_command ("modprobe ipip", &_inner_error_);
		com_ret = _tmp0_;
		if (_inner_error_ != NULL) {
			goto __catch81_g_error;
		}
		_g_object_unref0 (com_ret);
	}
	goto __finally81;
	__catch81_g_error:
	{
		GError* e = NULL;
		e = _inner_error_;
		_inner_error_ = NULL;
		_g_error_free0 (e);
	}
	__finally81:
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		return FALSE;
	}
	_tmp1_ = prev_mode;
	_tmp2_ = string_to_string (_tmp1_);
	_tmp3_ = g_strconcat ("LinuxRoute: _igs_update_rules: prev_mode=", _tmp2_, NULL);
	_tmp4_ = _tmp3_;
	netsukuku_log_debug (_tmp4_);
	_g_free0 (_tmp4_);
	_tmp5_ = mode;
	_tmp6_ = string_to_string (_tmp5_);
	_tmp7_ = g_strconcat ("LinuxRoute: _igs_update_rules: mode=", _tmp6_, NULL);
	_tmp8_ = _tmp7_;
	netsukuku_log_debug (_tmp8_);
	_g_free0 (_tmp8_);
	_tmp9_ = g_strdup ("{");
	dbg_list_tunnels = _tmp9_;
	{
		GeeArrayList* _tmp10_;
		GeeArrayList* _tmp11_;
		GeeArrayList* _tun_list;
		GeeArrayList* _tmp12_;
		gint _tmp13_;
		gint _tmp14_;
		gint _tun_size;
		gint _tun_index;
		_tmp10_ = list_tunnels;
		_tmp11_ = _g_object_ref0 (_tmp10_);
		_tun_list = _tmp11_;
		_tmp12_ = _tun_list;
		_tmp13_ = gee_abstract_collection_get_size ((GeeCollection*) _tmp12_);
		_tmp14_ = _tmp13_;
		_tun_size = _tmp14_;
		_tun_index = -1;
		while (TRUE) {
			gint _tmp15_;
			gint _tmp16_;
			gint _tmp17_;
			GeeArrayList* _tmp18_;
			gint _tmp19_;
			gpointer _tmp20_ = NULL;
			NetsukukuTunnelItem* tun;
			const gchar* _tmp21_;
			NetsukukuTunnelItem* _tmp22_;
			gchar* _tmp23_ = NULL;
			gchar* _tmp24_;
			gchar* _tmp25_ = NULL;
			gchar* _tmp26_;
			gchar* _tmp27_;
			_tmp15_ = _tun_index;
			_tun_index = _tmp15_ + 1;
			_tmp16_ = _tun_index;
			_tmp17_ = _tun_size;
			if (!(_tmp16_ < _tmp17_)) {
				break;
			}
			_tmp18_ = _tun_list;
			_tmp19_ = _tun_index;
			_tmp20_ = gee_abstract_list_get ((GeeAbstractList*) _tmp18_, _tmp19_);
			tun = (NetsukukuTunnelItem*) _tmp20_;
			_tmp21_ = dbg_list_tunnels;
			_tmp22_ = tun;
			_tmp23_ = netsukuku_tunnel_item_to_string (_tmp22_);
			_tmp24_ = _tmp23_;
			_tmp25_ = g_strconcat (_tmp24_, ",", NULL);
			_tmp26_ = _tmp25_;
			_tmp27_ = g_strconcat (_tmp21_, _tmp26_, NULL);
			_g_free0 (dbg_list_tunnels);
			dbg_list_tunnels = _tmp27_;
			_g_free0 (_tmp26_);
			_g_free0 (_tmp24_);
			_g_object_unref0 (tun);
		}
		_g_object_unref0 (_tun_list);
	}
	_tmp28_ = dbg_list_tunnels;
	_tmp29_ = g_strconcat (_tmp28_, "}", NULL);
	_g_free0 (dbg_list_tunnels);
	dbg_list_tunnels = _tmp29_;
	_tmp30_ = dbg_list_tunnels;
	_tmp31_ = string_to_string (_tmp30_);
	_tmp32_ = g_strconcat ("LinuxRoute: _igs_update_rules: list_tunnels=", _tmp31_, NULL);
	_tmp33_ = _tmp32_;
	netsukuku_log_debug (_tmp33_);
	_g_free0 (_tmp33_);
	_tmp34_ = mode;
	_vala_assert (g_strcmp0 (_tmp34_, "BOTH") != 0, "mode != \"BOTH\"");
	_tmp36_ = prev_mode;
	if (g_strcmp0 (_tmp36_, "NONE") == 0) {
		const gchar* _tmp37_;
		_tmp37_ = mode;
		_tmp35_ = g_strcmp0 (_tmp37_, "SHARE") == 0;
	} else {
		_tmp35_ = FALSE;
	}
	_tmp38_ = _tmp35_;
	if (_tmp38_) {
		netsukuku_impl_linux_iptables_exp ("-t nat -A POSTROUTING -s 10.0.0.0/8 ! -d 10.0.0.0/8 -j MASQUERADE");
		netsukuku_impl_linux_iproute_exp ("tunnel add ntk-share-inet mode ipip");
		netsukuku_impl_linux_iproute_exp ("link set tunl0 up");
		_netsukuku_impl_linux_linux_route_disable_rp_filter (self, "tunl0");
	}
	_tmp40_ = mode;
	if (g_strcmp0 (_tmp40_, "NONE") == 0) {
		const gchar* _tmp41_;
		_tmp41_ = prev_mode;
		_tmp39_ = g_strcmp0 (_tmp41_, "SHARE") == 0;
	} else {
		_tmp39_ = FALSE;
	}
	_tmp42_ = _tmp39_;
	if (_tmp42_) {
		netsukuku_impl_linux_iptables_exp ("-t nat -D POSTROUTING -s 10.0.0.0/8 ! -d 10.0.0.0/8 -j MASQUERADE");
		netsukuku_impl_linux_iproute_exp ("link set tunl0 down");
		netsukuku_impl_linux_iproute_exp ("tunnel del ntk-share-inet mode ipip");
	}
	_tmp45_ = prev_mode;
	if (g_strcmp0 (_tmp45_, "NONE") == 0) {
		const gchar* _tmp46_;
		_tmp46_ = mode;
		_tmp44_ = g_strcmp0 (_tmp46_, "USE") == 0;
	} else {
		_tmp44_ = FALSE;
	}
	_tmp47_ = _tmp44_;
	if (_tmp47_) {
		GeeArrayList* _tmp48_;
		gboolean _tmp49_;
		gboolean _tmp50_;
		_tmp48_ = list_tunnels;
		_tmp49_ = gee_collection_get_is_empty ((GeeCollection*) _tmp48_);
		_tmp50_ = _tmp49_;
		_tmp43_ = !_tmp50_;
	} else {
		_tmp43_ = FALSE;
	}
	_tmp51_ = _tmp43_;
	if (_tmp51_) {
		gint* _tmp52_ = NULL;
		gint* weights;
		gint weights_length1;
		gint _weights_size_;
		gint i;
		gchar* _tmp91_ = NULL;
		gchar* _tmp92_;
		gchar* _tmp141_;
		gchar* cmd;
		const gchar* _tmp180_;
		_tmp52_ = g_new0 (gint, 10);
		_tmp52_[0] = 1;
		_tmp52_[1] = 3;
		_tmp52_[2] = 6;
		_tmp52_[3] = 10;
		_tmp52_[4] = 30;
		_tmp52_[5] = 60;
		_tmp52_[6] = 100;
		_tmp52_[7] = 150;
		_tmp52_[8] = 200;
		_tmp52_[9] = 255;
		weights = _tmp52_;
		weights_length1 = 10;
		_weights_size_ = weights_length1;
		i = 0;
		{
			GeeArrayList* _tmp53_;
			GeeArrayList* _tmp54_;
			GeeArrayList* _tun_list;
			GeeArrayList* _tmp55_;
			gint _tmp56_;
			gint _tmp57_;
			gint _tun_size;
			gint _tun_index;
			_tmp53_ = list_tunnels;
			_tmp54_ = _g_object_ref0 (_tmp53_);
			_tun_list = _tmp54_;
			_tmp55_ = _tun_list;
			_tmp56_ = gee_abstract_collection_get_size ((GeeCollection*) _tmp55_);
			_tmp57_ = _tmp56_;
			_tun_size = _tmp57_;
			_tun_index = -1;
			while (TRUE) {
				gint _tmp58_;
				gint _tmp59_;
				gint _tmp60_;
				GeeArrayList* _tmp61_;
				gint _tmp62_;
				gpointer _tmp63_ = NULL;
				NetsukukuTunnelItem* tun;
				NetsukukuTunnelItem* _tmp64_;
				const gchar* _tmp65_;
				const gchar* _tmp66_;
				gchar* _tmp67_;
				gchar* ipstr;
				gint _tmp68_;
				gchar* _tmp69_ = NULL;
				gchar* _tmp70_;
				gchar* _tmp71_ = NULL;
				gchar* _tmp72_;
				gchar* dev;
				const gchar* _tmp73_;
				const gchar* _tmp74_ = NULL;
				const gchar* _tmp75_;
				const gchar* _tmp76_ = NULL;
				gchar* _tmp77_ = NULL;
				gchar* _tmp78_;
				const gchar* _tmp79_;
				const gchar* _tmp80_ = NULL;
				gchar* _tmp81_ = NULL;
				gchar* _tmp82_;
				const gchar* _tmp83_;
				const gchar* _tmp84_;
				const gchar* _tmp85_ = NULL;
				const gchar* _tmp86_;
				const gchar* _tmp87_ = NULL;
				gchar* _tmp88_ = NULL;
				gchar* _tmp89_;
				gint _tmp90_;
				_tmp58_ = _tun_index;
				_tun_index = _tmp58_ + 1;
				_tmp59_ = _tun_index;
				_tmp60_ = _tun_size;
				if (!(_tmp59_ < _tmp60_)) {
					break;
				}
				_tmp61_ = _tun_list;
				_tmp62_ = _tun_index;
				_tmp63_ = gee_abstract_list_get ((GeeAbstractList*) _tmp61_, _tmp62_);
				tun = (NetsukukuTunnelItem*) _tmp63_;
				_tmp64_ = tun;
				_tmp65_ = netsukuku_tunnel_item_get_ipstr (_tmp64_);
				_tmp66_ = _tmp65_;
				_tmp67_ = g_strdup (_tmp66_);
				ipstr = _tmp67_;
				_tmp68_ = i;
				_tmp69_ = g_strdup_printf ("%i", _tmp68_);
				_tmp70_ = _tmp69_;
				_tmp71_ = g_strconcat ("ntk-to-inet-", _tmp70_, NULL);
				_tmp72_ = _tmp71_;
				_g_free0 (_tmp70_);
				dev = _tmp72_;
				_tmp73_ = dev;
				_tmp74_ = string_to_string (_tmp73_);
				_tmp75_ = ipstr;
				_tmp76_ = string_to_string (_tmp75_);
				_tmp77_ = g_strconcat ("tunnel add ", _tmp74_, " mode ipip remote ", _tmp76_, NULL);
				_tmp78_ = _tmp77_;
				netsukuku_impl_linux_iproute_exp (_tmp78_);
				_g_free0 (_tmp78_);
				_tmp79_ = dev;
				_tmp80_ = string_to_string (_tmp79_);
				_tmp81_ = g_strconcat ("link set ", _tmp80_, " up", NULL);
				_tmp82_ = _tmp81_;
				netsukuku_impl_linux_iproute_exp (_tmp82_);
				_g_free0 (_tmp82_);
				_netsukuku_impl_linux_linux_route_disable_rp_filter (self, "tunl0");
				_tmp83_ = dev;
				_netsukuku_impl_linux_linux_route_disable_rp_filter (self, _tmp83_);
				_tmp84_ = pref_src;
				_tmp85_ = string_to_string (_tmp84_);
				_tmp86_ = dev;
				_tmp87_ = string_to_string (_tmp86_);
				_tmp88_ = g_strconcat ("addr add ", _tmp85_, " dev ", _tmp87_, NULL);
				_tmp89_ = _tmp88_;
				netsukuku_impl_linux_iproute_exp (_tmp89_);
				_g_free0 (_tmp89_);
				_tmp90_ = i;
				i = _tmp90_ + 1;
				_g_free0 (dev);
				_g_free0 (ipstr);
				_g_object_unref0 (tun);
			}
			_g_object_unref0 (_tun_list);
		}
		_tmp91_ = netsukuku_impl_linux_iptables ("-t mangle -A OUTPUT -m conntrack --ctstate ESTABLISHED,RELATED  -j CON" \
"NMARK --restore-mark", &_inner_error_);
		_tmp92_ = _tmp91_;
		_g_free0 (_tmp92_);
		if (_inner_error_ != NULL) {
			g_propagate_error (error, _inner_error_);
			weights = (g_free (weights), NULL);
			_g_free0 (dbg_list_tunnels);
			return FALSE;
		}
		i = 0;
		{
			GeeArrayList* _tmp93_;
			GeeArrayList* _tmp94_;
			GeeArrayList* _tun_list;
			GeeArrayList* _tmp95_;
			gint _tmp96_;
			gint _tmp97_;
			gint _tun_size;
			gint _tun_index;
			_tmp93_ = list_tunnels;
			_tmp94_ = _g_object_ref0 (_tmp93_);
			_tun_list = _tmp94_;
			_tmp95_ = _tun_list;
			_tmp96_ = gee_abstract_collection_get_size ((GeeCollection*) _tmp95_);
			_tmp97_ = _tmp96_;
			_tun_size = _tmp97_;
			_tun_index = -1;
			while (TRUE) {
				gint _tmp98_;
				gint _tmp99_;
				gint _tmp100_;
				GeeArrayList* _tmp101_;
				gint _tmp102_;
				gpointer _tmp103_ = NULL;
				NetsukukuTunnelItem* tun;
				NetsukukuTunnelItem* _tmp104_;
				const gchar* _tmp105_;
				const gchar* _tmp106_;
				gchar* _tmp107_;
				gchar* ipstr;
				gint _tmp108_;
				gchar* _tmp109_ = NULL;
				gchar* _tmp110_;
				gchar* _tmp111_ = NULL;
				gchar* _tmp112_;
				gchar* dev;
				gint _tmp113_;
				gint tableid;
				const gchar* _tmp114_;
				const gchar* _tmp115_ = NULL;
				gint _tmp116_;
				gchar* _tmp117_ = NULL;
				gchar* _tmp118_;
				gchar* _tmp119_ = NULL;
				gchar* _tmp120_;
				gint _tmp121_;
				gchar* _tmp122_ = NULL;
				gchar* _tmp123_;
				gint _tmp124_;
				gchar* _tmp125_ = NULL;
				gchar* _tmp126_;
				gchar* _tmp127_ = NULL;
				gchar* _tmp128_;
				gint _tmp129_;
				gchar* _tmp130_ = NULL;
				gchar* _tmp131_;
				const gchar* _tmp132_;
				const gchar* _tmp133_ = NULL;
				const gchar* _tmp134_;
				const gchar* _tmp135_ = NULL;
				const gchar* _tmp136_;
				const gchar* _tmp137_ = NULL;
				gchar* _tmp138_ = NULL;
				gchar* _tmp139_;
				gint _tmp140_;
				_tmp98_ = _tun_index;
				_tun_index = _tmp98_ + 1;
				_tmp99_ = _tun_index;
				_tmp100_ = _tun_size;
				if (!(_tmp99_ < _tmp100_)) {
					break;
				}
				_tmp101_ = _tun_list;
				_tmp102_ = _tun_index;
				_tmp103_ = gee_abstract_list_get ((GeeAbstractList*) _tmp101_, _tmp102_);
				tun = (NetsukukuTunnelItem*) _tmp103_;
				_tmp104_ = tun;
				_tmp105_ = netsukuku_tunnel_item_get_ipstr (_tmp104_);
				_tmp106_ = _tmp105_;
				_tmp107_ = g_strdup (_tmp106_);
				ipstr = _tmp107_;
				_tmp108_ = i;
				_tmp109_ = g_strdup_printf ("%i", _tmp108_);
				_tmp110_ = _tmp109_;
				_tmp111_ = g_strconcat ("ntk-to-inet-", _tmp110_, NULL);
				_tmp112_ = _tmp111_;
				_g_free0 (_tmp110_);
				dev = _tmp112_;
				_tmp113_ = i;
				tableid = 99 - _tmp113_;
				_tmp114_ = dev;
				_tmp115_ = string_to_string (_tmp114_);
				_tmp116_ = tableid;
				_tmp117_ = g_strdup_printf ("%i", _tmp116_);
				_tmp118_ = _tmp117_;
				_tmp119_ = g_strconcat ("-t mangle -A POSTROUTING -o ", _tmp115_, " -m conntrack --ctstate NEW -j CONNMARK --set-mark ", _tmp118_, NULL);
				_tmp120_ = _tmp119_;
				netsukuku_impl_linux_iptables_exp (_tmp120_);
				_g_free0 (_tmp120_);
				_g_free0 (_tmp118_);
				_tmp121_ = tableid;
				_tmp122_ = g_strdup_printf ("%i", _tmp121_);
				_tmp123_ = _tmp122_;
				_tmp124_ = tableid;
				_tmp125_ = g_strdup_printf ("%i", _tmp124_);
				_tmp126_ = _tmp125_;
				_tmp127_ = g_strconcat ("rule add fwmark ", _tmp123_, " lookup ", _tmp126_, NULL);
				_tmp128_ = _tmp127_;
				netsukuku_impl_linux_iproute_exp (_tmp128_);
				_g_free0 (_tmp128_);
				_g_free0 (_tmp126_);
				_g_free0 (_tmp123_);
				_tmp129_ = tableid;
				_tmp130_ = g_strdup_printf ("%i", _tmp129_);
				_tmp131_ = _tmp130_;
				_tmp132_ = ipstr;
				_tmp133_ = string_to_string (_tmp132_);
				_tmp134_ = dev;
				_tmp135_ = string_to_string (_tmp134_);
				_tmp136_ = pref_src;
				_tmp137_ = string_to_string (_tmp136_);
				_tmp138_ = g_strconcat ("route add table ", _tmp131_, " default via ", _tmp133_, " dev ", _tmp135_, " src ", _tmp137_, " onlink", NULL);
				_tmp139_ = _tmp138_;
				netsukuku_impl_linux_iproute_exp (_tmp139_);
				_g_free0 (_tmp139_);
				_g_free0 (_tmp131_);
				_tmp140_ = i;
				i = _tmp140_ + 1;
				_g_free0 (dev);
				_g_free0 (ipstr);
				_g_object_unref0 (tun);
			}
			_g_object_unref0 (_tun_list);
		}
		_tmp141_ = g_strdup ("route add default ");
		cmd = _tmp141_;
		i = 0;
		{
			GeeArrayList* _tmp142_;
			GeeArrayList* _tmp143_;
			GeeArrayList* _tun_list;
			GeeArrayList* _tmp144_;
			gint _tmp145_;
			gint _tmp146_;
			gint _tun_size;
			gint _tun_index;
			_tmp142_ = list_tunnels;
			_tmp143_ = _g_object_ref0 (_tmp142_);
			_tun_list = _tmp143_;
			_tmp144_ = _tun_list;
			_tmp145_ = gee_abstract_collection_get_size ((GeeCollection*) _tmp144_);
			_tmp146_ = _tmp145_;
			_tun_size = _tmp146_;
			_tun_index = -1;
			while (TRUE) {
				gint _tmp147_;
				gint _tmp148_;
				gint _tmp149_;
				GeeArrayList* _tmp150_;
				gint _tmp151_;
				gpointer _tmp152_ = NULL;
				NetsukukuTunnelItem* tun;
				NetsukukuTunnelItem* _tmp153_;
				const gchar* _tmp154_;
				const gchar* _tmp155_;
				gchar* _tmp156_;
				gchar* ipstr;
				gint _tmp157_;
				gchar* _tmp158_ = NULL;
				gchar* _tmp159_;
				gchar* _tmp160_ = NULL;
				gchar* _tmp161_;
				gchar* dev;
				gint* _tmp162_;
				gint _tmp162__length1;
				GeeArrayList* _tmp163_;
				gint _tmp164_;
				gint _tmp165_;
				gint _tmp166_;
				gint _tmp167_;
				gint weight;
				const gchar* _tmp168_;
				const gchar* _tmp169_;
				const gchar* _tmp170_ = NULL;
				const gchar* _tmp171_;
				const gchar* _tmp172_ = NULL;
				gint _tmp173_;
				gchar* _tmp174_ = NULL;
				gchar* _tmp175_;
				gchar* _tmp176_ = NULL;
				gchar* _tmp177_;
				gchar* _tmp178_;
				gint _tmp179_;
				_tmp147_ = _tun_index;
				_tun_index = _tmp147_ + 1;
				_tmp148_ = _tun_index;
				_tmp149_ = _tun_size;
				if (!(_tmp148_ < _tmp149_)) {
					break;
				}
				_tmp150_ = _tun_list;
				_tmp151_ = _tun_index;
				_tmp152_ = gee_abstract_list_get ((GeeAbstractList*) _tmp150_, _tmp151_);
				tun = (NetsukukuTunnelItem*) _tmp152_;
				_tmp153_ = tun;
				_tmp154_ = netsukuku_tunnel_item_get_ipstr (_tmp153_);
				_tmp155_ = _tmp154_;
				_tmp156_ = g_strdup (_tmp155_);
				ipstr = _tmp156_;
				_tmp157_ = i;
				_tmp158_ = g_strdup_printf ("%i", _tmp157_);
				_tmp159_ = _tmp158_;
				_tmp160_ = g_strconcat ("ntk-to-inet-", _tmp159_, NULL);
				_tmp161_ = _tmp160_;
				_g_free0 (_tmp159_);
				dev = _tmp161_;
				_tmp162_ = weights;
				_tmp162__length1 = weights_length1;
				_tmp163_ = list_tunnels;
				_tmp164_ = gee_abstract_collection_get_size ((GeeCollection*) _tmp163_);
				_tmp165_ = _tmp164_;
				_tmp166_ = i;
				_tmp167_ = _tmp162_[(_tmp165_ - 1) - _tmp166_];
				weight = _tmp167_;
				_tmp168_ = cmd;
				_tmp169_ = ipstr;
				_tmp170_ = string_to_string (_tmp169_);
				_tmp171_ = dev;
				_tmp172_ = string_to_string (_tmp171_);
				_tmp173_ = weight;
				_tmp174_ = g_strdup_printf ("%i", _tmp173_);
				_tmp175_ = _tmp174_;
				_tmp176_ = g_strconcat ("nexthop via ", _tmp170_, " dev ", _tmp172_, " weight ", _tmp175_, " onlink ", NULL);
				_tmp177_ = _tmp176_;
				_tmp178_ = g_strconcat (_tmp168_, _tmp177_, NULL);
				_g_free0 (cmd);
				cmd = _tmp178_;
				_g_free0 (_tmp177_);
				_g_free0 (_tmp175_);
				_tmp179_ = i;
				i = _tmp179_ + 1;
				_g_free0 (dev);
				_g_free0 (ipstr);
				_g_object_unref0 (tun);
			}
			_g_object_unref0 (_tun_list);
		}
		_tmp180_ = cmd;
		netsukuku_impl_linux_iproute_exp (_tmp180_);
		_g_free0 (cmd);
		weights = (g_free (weights), NULL);
	}
	_tmp183_ = mode;
	if (g_strcmp0 (_tmp183_, "NONE") == 0) {
		const gchar* _tmp184_;
		_tmp184_ = prev_mode;
		_tmp182_ = g_strcmp0 (_tmp184_, "USE") == 0;
	} else {
		_tmp182_ = FALSE;
	}
	_tmp185_ = _tmp182_;
	if (_tmp185_) {
		GeeArrayList* _tmp186_;
		gboolean _tmp187_;
		gboolean _tmp188_;
		_tmp186_ = prev_list_tunnels;
		_tmp187_ = gee_collection_get_is_empty ((GeeCollection*) _tmp186_);
		_tmp188_ = _tmp187_;
		_tmp181_ = !_tmp188_;
	} else {
		_tmp181_ = FALSE;
	}
	_tmp189_ = _tmp181_;
	if (_tmp189_) {
		gint* _tmp190_ = NULL;
		gint* weights;
		gint weights_length1;
		gint _weights_size_;
		gint i;
		gchar* _tmp191_;
		gchar* cmd;
		const gchar* _tmp230_;
		gchar* _tmp279_ = NULL;
		gchar* _tmp280_;
		_tmp190_ = g_new0 (gint, 10);
		_tmp190_[0] = 1;
		_tmp190_[1] = 3;
		_tmp190_[2] = 6;
		_tmp190_[3] = 10;
		_tmp190_[4] = 30;
		_tmp190_[5] = 60;
		_tmp190_[6] = 100;
		_tmp190_[7] = 150;
		_tmp190_[8] = 200;
		_tmp190_[9] = 255;
		weights = _tmp190_;
		weights_length1 = 10;
		_weights_size_ = weights_length1;
		i = 0;
		_tmp191_ = g_strdup ("route del default ");
		cmd = _tmp191_;
		{
			GeeArrayList* _tmp192_;
			GeeArrayList* _tmp193_;
			GeeArrayList* _tun_list;
			GeeArrayList* _tmp194_;
			gint _tmp195_;
			gint _tmp196_;
			gint _tun_size;
			gint _tun_index;
			_tmp192_ = prev_list_tunnels;
			_tmp193_ = _g_object_ref0 (_tmp192_);
			_tun_list = _tmp193_;
			_tmp194_ = _tun_list;
			_tmp195_ = gee_abstract_collection_get_size ((GeeCollection*) _tmp194_);
			_tmp196_ = _tmp195_;
			_tun_size = _tmp196_;
			_tun_index = -1;
			while (TRUE) {
				gint _tmp197_;
				gint _tmp198_;
				gint _tmp199_;
				GeeArrayList* _tmp200_;
				gint _tmp201_;
				gpointer _tmp202_ = NULL;
				NetsukukuTunnelItem* tun;
				NetsukukuTunnelItem* _tmp203_;
				const gchar* _tmp204_;
				const gchar* _tmp205_;
				gchar* _tmp206_;
				gchar* ipstr;
				gint _tmp207_;
				gchar* _tmp208_ = NULL;
				gchar* _tmp209_;
				gchar* _tmp210_ = NULL;
				gchar* _tmp211_;
				gchar* dev;
				gint* _tmp212_;
				gint _tmp212__length1;
				GeeArrayList* _tmp213_;
				gint _tmp214_;
				gint _tmp215_;
				gint _tmp216_;
				gint _tmp217_;
				gint weight;
				const gchar* _tmp218_;
				const gchar* _tmp219_;
				const gchar* _tmp220_ = NULL;
				const gchar* _tmp221_;
				const gchar* _tmp222_ = NULL;
				gint _tmp223_;
				gchar* _tmp224_ = NULL;
				gchar* _tmp225_;
				gchar* _tmp226_ = NULL;
				gchar* _tmp227_;
				gchar* _tmp228_;
				gint _tmp229_;
				_tmp197_ = _tun_index;
				_tun_index = _tmp197_ + 1;
				_tmp198_ = _tun_index;
				_tmp199_ = _tun_size;
				if (!(_tmp198_ < _tmp199_)) {
					break;
				}
				_tmp200_ = _tun_list;
				_tmp201_ = _tun_index;
				_tmp202_ = gee_abstract_list_get ((GeeAbstractList*) _tmp200_, _tmp201_);
				tun = (NetsukukuTunnelItem*) _tmp202_;
				_tmp203_ = tun;
				_tmp204_ = netsukuku_tunnel_item_get_ipstr (_tmp203_);
				_tmp205_ = _tmp204_;
				_tmp206_ = g_strdup (_tmp205_);
				ipstr = _tmp206_;
				_tmp207_ = i;
				_tmp208_ = g_strdup_printf ("%i", _tmp207_);
				_tmp209_ = _tmp208_;
				_tmp210_ = g_strconcat ("ntk-to-inet-", _tmp209_, NULL);
				_tmp211_ = _tmp210_;
				_g_free0 (_tmp209_);
				dev = _tmp211_;
				_tmp212_ = weights;
				_tmp212__length1 = weights_length1;
				_tmp213_ = list_tunnels;
				_tmp214_ = gee_abstract_collection_get_size ((GeeCollection*) _tmp213_);
				_tmp215_ = _tmp214_;
				_tmp216_ = i;
				_tmp217_ = _tmp212_[(_tmp215_ - 1) - _tmp216_];
				weight = _tmp217_;
				_tmp218_ = cmd;
				_tmp219_ = ipstr;
				_tmp220_ = string_to_string (_tmp219_);
				_tmp221_ = dev;
				_tmp222_ = string_to_string (_tmp221_);
				_tmp223_ = weight;
				_tmp224_ = g_strdup_printf ("%i", _tmp223_);
				_tmp225_ = _tmp224_;
				_tmp226_ = g_strconcat ("nexthop via ", _tmp220_, " dev ", _tmp222_, " weight ", _tmp225_, " onlink ", NULL);
				_tmp227_ = _tmp226_;
				_tmp228_ = g_strconcat (_tmp218_, _tmp227_, NULL);
				_g_free0 (cmd);
				cmd = _tmp228_;
				_g_free0 (_tmp227_);
				_g_free0 (_tmp225_);
				_tmp229_ = i;
				i = _tmp229_ + 1;
				_g_free0 (dev);
				_g_free0 (ipstr);
				_g_object_unref0 (tun);
			}
			_g_object_unref0 (_tun_list);
		}
		_tmp230_ = cmd;
		netsukuku_impl_linux_iproute_exp (_tmp230_);
		i = 0;
		{
			GeeArrayList* _tmp231_;
			GeeArrayList* _tmp232_;
			GeeArrayList* _tun_list;
			GeeArrayList* _tmp233_;
			gint _tmp234_;
			gint _tmp235_;
			gint _tun_size;
			gint _tun_index;
			_tmp231_ = prev_list_tunnels;
			_tmp232_ = _g_object_ref0 (_tmp231_);
			_tun_list = _tmp232_;
			_tmp233_ = _tun_list;
			_tmp234_ = gee_abstract_collection_get_size ((GeeCollection*) _tmp233_);
			_tmp235_ = _tmp234_;
			_tun_size = _tmp235_;
			_tun_index = -1;
			while (TRUE) {
				gint _tmp236_;
				gint _tmp237_;
				gint _tmp238_;
				GeeArrayList* _tmp239_;
				gint _tmp240_;
				gpointer _tmp241_ = NULL;
				NetsukukuTunnelItem* tun;
				NetsukukuTunnelItem* _tmp242_;
				const gchar* _tmp243_;
				const gchar* _tmp244_;
				gchar* _tmp245_;
				gchar* ipstr;
				gint _tmp246_;
				gchar* _tmp247_ = NULL;
				gchar* _tmp248_;
				gchar* _tmp249_ = NULL;
				gchar* _tmp250_;
				gchar* dev;
				gint _tmp251_;
				gint tableid;
				const gchar* _tmp252_;
				const gchar* _tmp253_ = NULL;
				gint _tmp254_;
				gchar* _tmp255_ = NULL;
				gchar* _tmp256_;
				gchar* _tmp257_ = NULL;
				gchar* _tmp258_;
				gint _tmp259_;
				gchar* _tmp260_ = NULL;
				gchar* _tmp261_;
				gint _tmp262_;
				gchar* _tmp263_ = NULL;
				gchar* _tmp264_;
				gchar* _tmp265_ = NULL;
				gchar* _tmp266_;
				gint _tmp267_;
				gchar* _tmp268_ = NULL;
				gchar* _tmp269_;
				const gchar* _tmp270_;
				const gchar* _tmp271_ = NULL;
				const gchar* _tmp272_;
				const gchar* _tmp273_ = NULL;
				const gchar* _tmp274_;
				const gchar* _tmp275_ = NULL;
				gchar* _tmp276_ = NULL;
				gchar* _tmp277_;
				gint _tmp278_;
				_tmp236_ = _tun_index;
				_tun_index = _tmp236_ + 1;
				_tmp237_ = _tun_index;
				_tmp238_ = _tun_size;
				if (!(_tmp237_ < _tmp238_)) {
					break;
				}
				_tmp239_ = _tun_list;
				_tmp240_ = _tun_index;
				_tmp241_ = gee_abstract_list_get ((GeeAbstractList*) _tmp239_, _tmp240_);
				tun = (NetsukukuTunnelItem*) _tmp241_;
				_tmp242_ = tun;
				_tmp243_ = netsukuku_tunnel_item_get_ipstr (_tmp242_);
				_tmp244_ = _tmp243_;
				_tmp245_ = g_strdup (_tmp244_);
				ipstr = _tmp245_;
				_tmp246_ = i;
				_tmp247_ = g_strdup_printf ("%i", _tmp246_);
				_tmp248_ = _tmp247_;
				_tmp249_ = g_strconcat ("ntk-to-inet-", _tmp248_, NULL);
				_tmp250_ = _tmp249_;
				_g_free0 (_tmp248_);
				dev = _tmp250_;
				_tmp251_ = i;
				tableid = 99 - _tmp251_;
				_tmp252_ = dev;
				_tmp253_ = string_to_string (_tmp252_);
				_tmp254_ = tableid;
				_tmp255_ = g_strdup_printf ("%i", _tmp254_);
				_tmp256_ = _tmp255_;
				_tmp257_ = g_strconcat ("-t mangle -D POSTROUTING -o ", _tmp253_, " -m conntrack --ctstate NEW -j CONNMARK --set-mark ", _tmp256_, NULL);
				_tmp258_ = _tmp257_;
				netsukuku_impl_linux_iptables_exp (_tmp258_);
				_g_free0 (_tmp258_);
				_g_free0 (_tmp256_);
				_tmp259_ = tableid;
				_tmp260_ = g_strdup_printf ("%i", _tmp259_);
				_tmp261_ = _tmp260_;
				_tmp262_ = tableid;
				_tmp263_ = g_strdup_printf ("%i", _tmp262_);
				_tmp264_ = _tmp263_;
				_tmp265_ = g_strconcat ("rule del fwmark ", _tmp261_, " lookup ", _tmp264_, NULL);
				_tmp266_ = _tmp265_;
				netsukuku_impl_linux_iproute_exp (_tmp266_);
				_g_free0 (_tmp266_);
				_g_free0 (_tmp264_);
				_g_free0 (_tmp261_);
				_tmp267_ = tableid;
				_tmp268_ = g_strdup_printf ("%i", _tmp267_);
				_tmp269_ = _tmp268_;
				_tmp270_ = ipstr;
				_tmp271_ = string_to_string (_tmp270_);
				_tmp272_ = dev;
				_tmp273_ = string_to_string (_tmp272_);
				_tmp274_ = pref_src;
				_tmp275_ = string_to_string (_tmp274_);
				_tmp276_ = g_strconcat ("route del table ", _tmp269_, " default via ", _tmp271_, " dev ", _tmp273_, " src ", _tmp275_, " onlink", NULL);
				_tmp277_ = _tmp276_;
				netsukuku_impl_linux_iproute_exp (_tmp277_);
				_g_free0 (_tmp277_);
				_g_free0 (_tmp269_);
				_tmp278_ = i;
				i = _tmp278_ + 1;
				_g_free0 (dev);
				_g_free0 (ipstr);
				_g_object_unref0 (tun);
			}
			_g_object_unref0 (_tun_list);
		}
		_tmp279_ = netsukuku_impl_linux_iptables ("-t mangle -D OUTPUT -m conntrack --ctstate ESTABLISHED,RELATED  -j CON" \
"NMARK --restore-mark", &_inner_error_);
		_tmp280_ = _tmp279_;
		_g_free0 (_tmp280_);
		if (_inner_error_ != NULL) {
			g_propagate_error (error, _inner_error_);
			_g_free0 (cmd);
			weights = (g_free (weights), NULL);
			_g_free0 (dbg_list_tunnels);
			return FALSE;
		}
		i = 0;
		{
			GeeArrayList* _tmp281_;
			GeeArrayList* _tmp282_;
			GeeArrayList* _tun_list;
			GeeArrayList* _tmp283_;
			gint _tmp284_;
			gint _tmp285_;
			gint _tun_size;
			gint _tun_index;
			_tmp281_ = prev_list_tunnels;
			_tmp282_ = _g_object_ref0 (_tmp281_);
			_tun_list = _tmp282_;
			_tmp283_ = _tun_list;
			_tmp284_ = gee_abstract_collection_get_size ((GeeCollection*) _tmp283_);
			_tmp285_ = _tmp284_;
			_tun_size = _tmp285_;
			_tun_index = -1;
			while (TRUE) {
				gint _tmp286_;
				gint _tmp287_;
				gint _tmp288_;
				GeeArrayList* _tmp289_;
				gint _tmp290_;
				gpointer _tmp291_ = NULL;
				NetsukukuTunnelItem* tun;
				NetsukukuTunnelItem* _tmp292_;
				const gchar* _tmp293_;
				const gchar* _tmp294_;
				gchar* _tmp295_;
				gchar* ipstr;
				gint _tmp296_;
				gchar* _tmp297_ = NULL;
				gchar* _tmp298_;
				gchar* _tmp299_ = NULL;
				gchar* _tmp300_;
				gchar* dev;
				const gchar* _tmp301_;
				const gchar* _tmp302_ = NULL;
				const gchar* _tmp303_;
				const gchar* _tmp304_ = NULL;
				gchar* _tmp305_ = NULL;
				gchar* _tmp306_;
				const gchar* _tmp307_;
				const gchar* _tmp308_ = NULL;
				gchar* _tmp309_ = NULL;
				gchar* _tmp310_;
				const gchar* _tmp311_;
				const gchar* _tmp312_ = NULL;
				const gchar* _tmp313_;
				const gchar* _tmp314_ = NULL;
				gchar* _tmp315_ = NULL;
				gchar* _tmp316_;
				gint _tmp317_;
				_tmp286_ = _tun_index;
				_tun_index = _tmp286_ + 1;
				_tmp287_ = _tun_index;
				_tmp288_ = _tun_size;
				if (!(_tmp287_ < _tmp288_)) {
					break;
				}
				_tmp289_ = _tun_list;
				_tmp290_ = _tun_index;
				_tmp291_ = gee_abstract_list_get ((GeeAbstractList*) _tmp289_, _tmp290_);
				tun = (NetsukukuTunnelItem*) _tmp291_;
				_tmp292_ = tun;
				_tmp293_ = netsukuku_tunnel_item_get_ipstr (_tmp292_);
				_tmp294_ = _tmp293_;
				_tmp295_ = g_strdup (_tmp294_);
				ipstr = _tmp295_;
				_tmp296_ = i;
				_tmp297_ = g_strdup_printf ("%i", _tmp296_);
				_tmp298_ = _tmp297_;
				_tmp299_ = g_strconcat ("ntk-to-inet-", _tmp298_, NULL);
				_tmp300_ = _tmp299_;
				_g_free0 (_tmp298_);
				dev = _tmp300_;
				_tmp301_ = pref_src;
				_tmp302_ = string_to_string (_tmp301_);
				_tmp303_ = dev;
				_tmp304_ = string_to_string (_tmp303_);
				_tmp305_ = g_strconcat ("addr del ", _tmp302_, " dev ", _tmp304_, NULL);
				_tmp306_ = _tmp305_;
				netsukuku_impl_linux_iproute_exp (_tmp306_);
				_g_free0 (_tmp306_);
				_tmp307_ = dev;
				_tmp308_ = string_to_string (_tmp307_);
				_tmp309_ = g_strconcat ("link set ", _tmp308_, " down", NULL);
				_tmp310_ = _tmp309_;
				netsukuku_impl_linux_iproute_exp (_tmp310_);
				_g_free0 (_tmp310_);
				_tmp311_ = dev;
				_tmp312_ = string_to_string (_tmp311_);
				_tmp313_ = ipstr;
				_tmp314_ = string_to_string (_tmp313_);
				_tmp315_ = g_strconcat ("tunnel dek ", _tmp312_, " mode ipip remote ", _tmp314_, NULL);
				_tmp316_ = _tmp315_;
				netsukuku_impl_linux_iproute_exp (_tmp316_);
				_g_free0 (_tmp316_);
				_tmp317_ = i;
				i = _tmp317_ + 1;
				_g_free0 (dev);
				_g_free0 (ipstr);
				_g_object_unref0 (tun);
			}
			_g_object_unref0 (_tun_list);
		}
		_g_free0 (cmd);
		weights = (g_free (weights), NULL);
	}
	_tmp320_ = mode;
	if (g_strcmp0 (_tmp320_, "USE") == 0) {
		const gchar* _tmp321_;
		_tmp321_ = prev_mode;
		_tmp319_ = g_strcmp0 (_tmp321_, "USE") == 0;
	} else {
		_tmp319_ = FALSE;
	}
	_tmp322_ = _tmp319_;
	if (_tmp322_) {
		gboolean _tmp323_ = FALSE;
		GeeArrayList* _tmp324_;
		GeeArrayList* _tmp325_;
		gboolean _tmp326_ = FALSE;
		gboolean _tmp330_;
		_tmp324_ = prev_list_tunnels;
		_tmp325_ = list_tunnels;
		_tmp326_ = gee_collection_contains_all ((GeeCollection*) _tmp324_, (GeeCollection*) _tmp325_);
		if (_tmp326_) {
			GeeArrayList* _tmp327_;
			GeeArrayList* _tmp328_;
			gboolean _tmp329_ = FALSE;
			_tmp327_ = list_tunnels;
			_tmp328_ = prev_list_tunnels;
			_tmp329_ = gee_collection_contains_all ((GeeCollection*) _tmp327_, (GeeCollection*) _tmp328_);
			_tmp323_ = _tmp329_;
		} else {
			_tmp323_ = FALSE;
		}
		_tmp330_ = _tmp323_;
		_tmp318_ = !_tmp330_;
	} else {
		_tmp318_ = FALSE;
	}
	_tmp331_ = _tmp318_;
	if (_tmp331_) {
		gint* _tmp332_ = NULL;
		gint* weights;
		gint weights_length1;
		gint _weights_size_;
		GeeArrayList* _tmp333_;
		gboolean _tmp334_;
		gboolean _tmp335_;
		GeeArrayList* _tmp463_;
		gboolean _tmp464_;
		gboolean _tmp465_;
		_tmp332_ = g_new0 (gint, 10);
		_tmp332_[0] = 1;
		_tmp332_[1] = 3;
		_tmp332_[2] = 6;
		_tmp332_[3] = 10;
		_tmp332_[4] = 30;
		_tmp332_[5] = 60;
		_tmp332_[6] = 100;
		_tmp332_[7] = 150;
		_tmp332_[8] = 200;
		_tmp332_[9] = 255;
		weights = _tmp332_;
		weights_length1 = 10;
		_weights_size_ = weights_length1;
		_tmp333_ = prev_list_tunnels;
		_tmp334_ = gee_collection_get_is_empty ((GeeCollection*) _tmp333_);
		_tmp335_ = _tmp334_;
		if (!_tmp335_) {
			gint i;
			gchar* _tmp336_;
			gchar* cmd;
			const gchar* _tmp375_;
			gchar* _tmp424_ = NULL;
			gchar* _tmp425_;
			i = 0;
			_tmp336_ = g_strdup ("route del default ");
			cmd = _tmp336_;
			{
				GeeArrayList* _tmp337_;
				GeeArrayList* _tmp338_;
				GeeArrayList* _tun_list;
				GeeArrayList* _tmp339_;
				gint _tmp340_;
				gint _tmp341_;
				gint _tun_size;
				gint _tun_index;
				_tmp337_ = prev_list_tunnels;
				_tmp338_ = _g_object_ref0 (_tmp337_);
				_tun_list = _tmp338_;
				_tmp339_ = _tun_list;
				_tmp340_ = gee_abstract_collection_get_size ((GeeCollection*) _tmp339_);
				_tmp341_ = _tmp340_;
				_tun_size = _tmp341_;
				_tun_index = -1;
				while (TRUE) {
					gint _tmp342_;
					gint _tmp343_;
					gint _tmp344_;
					GeeArrayList* _tmp345_;
					gint _tmp346_;
					gpointer _tmp347_ = NULL;
					NetsukukuTunnelItem* tun;
					NetsukukuTunnelItem* _tmp348_;
					const gchar* _tmp349_;
					const gchar* _tmp350_;
					gchar* _tmp351_;
					gchar* ipstr;
					gint _tmp352_;
					gchar* _tmp353_ = NULL;
					gchar* _tmp354_;
					gchar* _tmp355_ = NULL;
					gchar* _tmp356_;
					gchar* dev;
					gint* _tmp357_;
					gint _tmp357__length1;
					GeeArrayList* _tmp358_;
					gint _tmp359_;
					gint _tmp360_;
					gint _tmp361_;
					gint _tmp362_;
					gint weight;
					const gchar* _tmp363_;
					const gchar* _tmp364_;
					const gchar* _tmp365_ = NULL;
					const gchar* _tmp366_;
					const gchar* _tmp367_ = NULL;
					gint _tmp368_;
					gchar* _tmp369_ = NULL;
					gchar* _tmp370_;
					gchar* _tmp371_ = NULL;
					gchar* _tmp372_;
					gchar* _tmp373_;
					gint _tmp374_;
					_tmp342_ = _tun_index;
					_tun_index = _tmp342_ + 1;
					_tmp343_ = _tun_index;
					_tmp344_ = _tun_size;
					if (!(_tmp343_ < _tmp344_)) {
						break;
					}
					_tmp345_ = _tun_list;
					_tmp346_ = _tun_index;
					_tmp347_ = gee_abstract_list_get ((GeeAbstractList*) _tmp345_, _tmp346_);
					tun = (NetsukukuTunnelItem*) _tmp347_;
					_tmp348_ = tun;
					_tmp349_ = netsukuku_tunnel_item_get_ipstr (_tmp348_);
					_tmp350_ = _tmp349_;
					_tmp351_ = g_strdup (_tmp350_);
					ipstr = _tmp351_;
					_tmp352_ = i;
					_tmp353_ = g_strdup_printf ("%i", _tmp352_);
					_tmp354_ = _tmp353_;
					_tmp355_ = g_strconcat ("ntk-to-inet-", _tmp354_, NULL);
					_tmp356_ = _tmp355_;
					_g_free0 (_tmp354_);
					dev = _tmp356_;
					_tmp357_ = weights;
					_tmp357__length1 = weights_length1;
					_tmp358_ = list_tunnels;
					_tmp359_ = gee_abstract_collection_get_size ((GeeCollection*) _tmp358_);
					_tmp360_ = _tmp359_;
					_tmp361_ = i;
					_tmp362_ = _tmp357_[(_tmp360_ - 1) - _tmp361_];
					weight = _tmp362_;
					_tmp363_ = cmd;
					_tmp364_ = ipstr;
					_tmp365_ = string_to_string (_tmp364_);
					_tmp366_ = dev;
					_tmp367_ = string_to_string (_tmp366_);
					_tmp368_ = weight;
					_tmp369_ = g_strdup_printf ("%i", _tmp368_);
					_tmp370_ = _tmp369_;
					_tmp371_ = g_strconcat ("nexthop via ", _tmp365_, " dev ", _tmp367_, " weight ", _tmp370_, " onlink ", NULL);
					_tmp372_ = _tmp371_;
					_tmp373_ = g_strconcat (_tmp363_, _tmp372_, NULL);
					_g_free0 (cmd);
					cmd = _tmp373_;
					_g_free0 (_tmp372_);
					_g_free0 (_tmp370_);
					_tmp374_ = i;
					i = _tmp374_ + 1;
					_g_free0 (dev);
					_g_free0 (ipstr);
					_g_object_unref0 (tun);
				}
				_g_object_unref0 (_tun_list);
			}
			_tmp375_ = cmd;
			netsukuku_impl_linux_iproute_exp (_tmp375_);
			i = 0;
			{
				GeeArrayList* _tmp376_;
				GeeArrayList* _tmp377_;
				GeeArrayList* _tun_list;
				GeeArrayList* _tmp378_;
				gint _tmp379_;
				gint _tmp380_;
				gint _tun_size;
				gint _tun_index;
				_tmp376_ = prev_list_tunnels;
				_tmp377_ = _g_object_ref0 (_tmp376_);
				_tun_list = _tmp377_;
				_tmp378_ = _tun_list;
				_tmp379_ = gee_abstract_collection_get_size ((GeeCollection*) _tmp378_);
				_tmp380_ = _tmp379_;
				_tun_size = _tmp380_;
				_tun_index = -1;
				while (TRUE) {
					gint _tmp381_;
					gint _tmp382_;
					gint _tmp383_;
					GeeArrayList* _tmp384_;
					gint _tmp385_;
					gpointer _tmp386_ = NULL;
					NetsukukuTunnelItem* tun;
					NetsukukuTunnelItem* _tmp387_;
					const gchar* _tmp388_;
					const gchar* _tmp389_;
					gchar* _tmp390_;
					gchar* ipstr;
					gint _tmp391_;
					gchar* _tmp392_ = NULL;
					gchar* _tmp393_;
					gchar* _tmp394_ = NULL;
					gchar* _tmp395_;
					gchar* dev;
					gint _tmp396_;
					gint tableid;
					const gchar* _tmp397_;
					const gchar* _tmp398_ = NULL;
					gint _tmp399_;
					gchar* _tmp400_ = NULL;
					gchar* _tmp401_;
					gchar* _tmp402_ = NULL;
					gchar* _tmp403_;
					gint _tmp404_;
					gchar* _tmp405_ = NULL;
					gchar* _tmp406_;
					gint _tmp407_;
					gchar* _tmp408_ = NULL;
					gchar* _tmp409_;
					gchar* _tmp410_ = NULL;
					gchar* _tmp411_;
					gint _tmp412_;
					gchar* _tmp413_ = NULL;
					gchar* _tmp414_;
					const gchar* _tmp415_;
					const gchar* _tmp416_ = NULL;
					const gchar* _tmp417_;
					const gchar* _tmp418_ = NULL;
					const gchar* _tmp419_;
					const gchar* _tmp420_ = NULL;
					gchar* _tmp421_ = NULL;
					gchar* _tmp422_;
					gint _tmp423_;
					_tmp381_ = _tun_index;
					_tun_index = _tmp381_ + 1;
					_tmp382_ = _tun_index;
					_tmp383_ = _tun_size;
					if (!(_tmp382_ < _tmp383_)) {
						break;
					}
					_tmp384_ = _tun_list;
					_tmp385_ = _tun_index;
					_tmp386_ = gee_abstract_list_get ((GeeAbstractList*) _tmp384_, _tmp385_);
					tun = (NetsukukuTunnelItem*) _tmp386_;
					_tmp387_ = tun;
					_tmp388_ = netsukuku_tunnel_item_get_ipstr (_tmp387_);
					_tmp389_ = _tmp388_;
					_tmp390_ = g_strdup (_tmp389_);
					ipstr = _tmp390_;
					_tmp391_ = i;
					_tmp392_ = g_strdup_printf ("%i", _tmp391_);
					_tmp393_ = _tmp392_;
					_tmp394_ = g_strconcat ("ntk-to-inet-", _tmp393_, NULL);
					_tmp395_ = _tmp394_;
					_g_free0 (_tmp393_);
					dev = _tmp395_;
					_tmp396_ = i;
					tableid = 99 - _tmp396_;
					_tmp397_ = dev;
					_tmp398_ = string_to_string (_tmp397_);
					_tmp399_ = tableid;
					_tmp400_ = g_strdup_printf ("%i", _tmp399_);
					_tmp401_ = _tmp400_;
					_tmp402_ = g_strconcat ("-t mangle -D POSTROUTING -o ", _tmp398_, " -m conntrack --ctstate NEW -j CONNMARK --set-mark ", _tmp401_, NULL);
					_tmp403_ = _tmp402_;
					netsukuku_impl_linux_iptables_exp (_tmp403_);
					_g_free0 (_tmp403_);
					_g_free0 (_tmp401_);
					_tmp404_ = tableid;
					_tmp405_ = g_strdup_printf ("%i", _tmp404_);
					_tmp406_ = _tmp405_;
					_tmp407_ = tableid;
					_tmp408_ = g_strdup_printf ("%i", _tmp407_);
					_tmp409_ = _tmp408_;
					_tmp410_ = g_strconcat ("rule del fwmark ", _tmp406_, " lookup ", _tmp409_, NULL);
					_tmp411_ = _tmp410_;
					netsukuku_impl_linux_iproute_exp (_tmp411_);
					_g_free0 (_tmp411_);
					_g_free0 (_tmp409_);
					_g_free0 (_tmp406_);
					_tmp412_ = tableid;
					_tmp413_ = g_strdup_printf ("%i", _tmp412_);
					_tmp414_ = _tmp413_;
					_tmp415_ = ipstr;
					_tmp416_ = string_to_string (_tmp415_);
					_tmp417_ = dev;
					_tmp418_ = string_to_string (_tmp417_);
					_tmp419_ = pref_src;
					_tmp420_ = string_to_string (_tmp419_);
					_tmp421_ = g_strconcat ("route del table ", _tmp414_, " default via ", _tmp416_, " dev ", _tmp418_, " src ", _tmp420_, " onlink", NULL);
					_tmp422_ = _tmp421_;
					netsukuku_impl_linux_iproute_exp (_tmp422_);
					_g_free0 (_tmp422_);
					_g_free0 (_tmp414_);
					_tmp423_ = i;
					i = _tmp423_ + 1;
					_g_free0 (dev);
					_g_free0 (ipstr);
					_g_object_unref0 (tun);
				}
				_g_object_unref0 (_tun_list);
			}
			_tmp424_ = netsukuku_impl_linux_iptables ("-t mangle -D OUTPUT -m conntrack --ctstate ESTABLISHED,RELATED  -j CON" \
"NMARK --restore-mark", &_inner_error_);
			_tmp425_ = _tmp424_;
			_g_free0 (_tmp425_);
			if (_inner_error_ != NULL) {
				g_propagate_error (error, _inner_error_);
				_g_free0 (cmd);
				weights = (g_free (weights), NULL);
				_g_free0 (dbg_list_tunnels);
				return FALSE;
			}
			i = 0;
			{
				GeeArrayList* _tmp426_;
				GeeArrayList* _tmp427_;
				GeeArrayList* _tun_list;
				GeeArrayList* _tmp428_;
				gint _tmp429_;
				gint _tmp430_;
				gint _tun_size;
				gint _tun_index;
				_tmp426_ = prev_list_tunnels;
				_tmp427_ = _g_object_ref0 (_tmp426_);
				_tun_list = _tmp427_;
				_tmp428_ = _tun_list;
				_tmp429_ = gee_abstract_collection_get_size ((GeeCollection*) _tmp428_);
				_tmp430_ = _tmp429_;
				_tun_size = _tmp430_;
				_tun_index = -1;
				while (TRUE) {
					gint _tmp431_;
					gint _tmp432_;
					gint _tmp433_;
					GeeArrayList* _tmp434_;
					gint _tmp435_;
					gpointer _tmp436_ = NULL;
					NetsukukuTunnelItem* tun;
					NetsukukuTunnelItem* _tmp437_;
					const gchar* _tmp438_;
					const gchar* _tmp439_;
					gchar* _tmp440_;
					gchar* ipstr;
					gint _tmp441_;
					gchar* _tmp442_ = NULL;
					gchar* _tmp443_;
					gchar* _tmp444_ = NULL;
					gchar* _tmp445_;
					gchar* dev;
					const gchar* _tmp446_;
					const gchar* _tmp447_ = NULL;
					const gchar* _tmp448_;
					const gchar* _tmp449_ = NULL;
					gchar* _tmp450_ = NULL;
					gchar* _tmp451_;
					const gchar* _tmp452_;
					const gchar* _tmp453_ = NULL;
					gchar* _tmp454_ = NULL;
					gchar* _tmp455_;
					const gchar* _tmp456_;
					const gchar* _tmp457_ = NULL;
					const gchar* _tmp458_;
					const gchar* _tmp459_ = NULL;
					gchar* _tmp460_ = NULL;
					gchar* _tmp461_;
					gint _tmp462_;
					_tmp431_ = _tun_index;
					_tun_index = _tmp431_ + 1;
					_tmp432_ = _tun_index;
					_tmp433_ = _tun_size;
					if (!(_tmp432_ < _tmp433_)) {
						break;
					}
					_tmp434_ = _tun_list;
					_tmp435_ = _tun_index;
					_tmp436_ = gee_abstract_list_get ((GeeAbstractList*) _tmp434_, _tmp435_);
					tun = (NetsukukuTunnelItem*) _tmp436_;
					_tmp437_ = tun;
					_tmp438_ = netsukuku_tunnel_item_get_ipstr (_tmp437_);
					_tmp439_ = _tmp438_;
					_tmp440_ = g_strdup (_tmp439_);
					ipstr = _tmp440_;
					_tmp441_ = i;
					_tmp442_ = g_strdup_printf ("%i", _tmp441_);
					_tmp443_ = _tmp442_;
					_tmp444_ = g_strconcat ("ntk-to-inet-", _tmp443_, NULL);
					_tmp445_ = _tmp444_;
					_g_free0 (_tmp443_);
					dev = _tmp445_;
					_tmp446_ = pref_src;
					_tmp447_ = string_to_string (_tmp446_);
					_tmp448_ = dev;
					_tmp449_ = string_to_string (_tmp448_);
					_tmp450_ = g_strconcat ("addr del ", _tmp447_, " dev ", _tmp449_, NULL);
					_tmp451_ = _tmp450_;
					netsukuku_impl_linux_iproute_exp (_tmp451_);
					_g_free0 (_tmp451_);
					_tmp452_ = dev;
					_tmp453_ = string_to_string (_tmp452_);
					_tmp454_ = g_strconcat ("link set ", _tmp453_, " down", NULL);
					_tmp455_ = _tmp454_;
					netsukuku_impl_linux_iproute_exp (_tmp455_);
					_g_free0 (_tmp455_);
					_tmp456_ = dev;
					_tmp457_ = string_to_string (_tmp456_);
					_tmp458_ = ipstr;
					_tmp459_ = string_to_string (_tmp458_);
					_tmp460_ = g_strconcat ("tunnel dek ", _tmp457_, " mode ipip remote ", _tmp459_, NULL);
					_tmp461_ = _tmp460_;
					netsukuku_impl_linux_iproute_exp (_tmp461_);
					_g_free0 (_tmp461_);
					_tmp462_ = i;
					i = _tmp462_ + 1;
					_g_free0 (dev);
					_g_free0 (ipstr);
					_g_object_unref0 (tun);
				}
				_g_object_unref0 (_tun_list);
			}
			_g_free0 (cmd);
		}
		_tmp463_ = list_tunnels;
		_tmp464_ = gee_collection_get_is_empty ((GeeCollection*) _tmp463_);
		_tmp465_ = _tmp464_;
		if (!_tmp465_) {
			gint i;
			gchar* _tmp504_ = NULL;
			gchar* _tmp505_;
			gchar* _tmp554_;
			gchar* cmd;
			const gchar* _tmp593_;
			i = 0;
			{
				GeeArrayList* _tmp466_;
				GeeArrayList* _tmp467_;
				GeeArrayList* _tun_list;
				GeeArrayList* _tmp468_;
				gint _tmp469_;
				gint _tmp470_;
				gint _tun_size;
				gint _tun_index;
				_tmp466_ = list_tunnels;
				_tmp467_ = _g_object_ref0 (_tmp466_);
				_tun_list = _tmp467_;
				_tmp468_ = _tun_list;
				_tmp469_ = gee_abstract_collection_get_size ((GeeCollection*) _tmp468_);
				_tmp470_ = _tmp469_;
				_tun_size = _tmp470_;
				_tun_index = -1;
				while (TRUE) {
					gint _tmp471_;
					gint _tmp472_;
					gint _tmp473_;
					GeeArrayList* _tmp474_;
					gint _tmp475_;
					gpointer _tmp476_ = NULL;
					NetsukukuTunnelItem* tun;
					NetsukukuTunnelItem* _tmp477_;
					const gchar* _tmp478_;
					const gchar* _tmp479_;
					gchar* _tmp480_;
					gchar* ipstr;
					gint _tmp481_;
					gchar* _tmp482_ = NULL;
					gchar* _tmp483_;
					gchar* _tmp484_ = NULL;
					gchar* _tmp485_;
					gchar* dev;
					const gchar* _tmp486_;
					const gchar* _tmp487_ = NULL;
					const gchar* _tmp488_;
					const gchar* _tmp489_ = NULL;
					gchar* _tmp490_ = NULL;
					gchar* _tmp491_;
					const gchar* _tmp492_;
					const gchar* _tmp493_ = NULL;
					gchar* _tmp494_ = NULL;
					gchar* _tmp495_;
					const gchar* _tmp496_;
					const gchar* _tmp497_;
					const gchar* _tmp498_ = NULL;
					const gchar* _tmp499_;
					const gchar* _tmp500_ = NULL;
					gchar* _tmp501_ = NULL;
					gchar* _tmp502_;
					gint _tmp503_;
					_tmp471_ = _tun_index;
					_tun_index = _tmp471_ + 1;
					_tmp472_ = _tun_index;
					_tmp473_ = _tun_size;
					if (!(_tmp472_ < _tmp473_)) {
						break;
					}
					_tmp474_ = _tun_list;
					_tmp475_ = _tun_index;
					_tmp476_ = gee_abstract_list_get ((GeeAbstractList*) _tmp474_, _tmp475_);
					tun = (NetsukukuTunnelItem*) _tmp476_;
					_tmp477_ = tun;
					_tmp478_ = netsukuku_tunnel_item_get_ipstr (_tmp477_);
					_tmp479_ = _tmp478_;
					_tmp480_ = g_strdup (_tmp479_);
					ipstr = _tmp480_;
					_tmp481_ = i;
					_tmp482_ = g_strdup_printf ("%i", _tmp481_);
					_tmp483_ = _tmp482_;
					_tmp484_ = g_strconcat ("ntk-to-inet-", _tmp483_, NULL);
					_tmp485_ = _tmp484_;
					_g_free0 (_tmp483_);
					dev = _tmp485_;
					_tmp486_ = dev;
					_tmp487_ = string_to_string (_tmp486_);
					_tmp488_ = ipstr;
					_tmp489_ = string_to_string (_tmp488_);
					_tmp490_ = g_strconcat ("tunnel add ", _tmp487_, " mode ipip remote ", _tmp489_, NULL);
					_tmp491_ = _tmp490_;
					netsukuku_impl_linux_iproute_exp (_tmp491_);
					_g_free0 (_tmp491_);
					_tmp492_ = dev;
					_tmp493_ = string_to_string (_tmp492_);
					_tmp494_ = g_strconcat ("link set ", _tmp493_, " up", NULL);
					_tmp495_ = _tmp494_;
					netsukuku_impl_linux_iproute_exp (_tmp495_);
					_g_free0 (_tmp495_);
					_netsukuku_impl_linux_linux_route_disable_rp_filter (self, "tunl0");
					_tmp496_ = dev;
					_netsukuku_impl_linux_linux_route_disable_rp_filter (self, _tmp496_);
					_tmp497_ = pref_src;
					_tmp498_ = string_to_string (_tmp497_);
					_tmp499_ = dev;
					_tmp500_ = string_to_string (_tmp499_);
					_tmp501_ = g_strconcat ("addr add ", _tmp498_, " dev ", _tmp500_, NULL);
					_tmp502_ = _tmp501_;
					netsukuku_impl_linux_iproute_exp (_tmp502_);
					_g_free0 (_tmp502_);
					_tmp503_ = i;
					i = _tmp503_ + 1;
					_g_free0 (dev);
					_g_free0 (ipstr);
					_g_object_unref0 (tun);
				}
				_g_object_unref0 (_tun_list);
			}
			_tmp504_ = netsukuku_impl_linux_iptables ("-t mangle -A OUTPUT -m conntrack --ctstate ESTABLISHED,RELATED  -j CON" \
"NMARK --restore-mark", &_inner_error_);
			_tmp505_ = _tmp504_;
			_g_free0 (_tmp505_);
			if (_inner_error_ != NULL) {
				g_propagate_error (error, _inner_error_);
				weights = (g_free (weights), NULL);
				_g_free0 (dbg_list_tunnels);
				return FALSE;
			}
			i = 0;
			{
				GeeArrayList* _tmp506_;
				GeeArrayList* _tmp507_;
				GeeArrayList* _tun_list;
				GeeArrayList* _tmp508_;
				gint _tmp509_;
				gint _tmp510_;
				gint _tun_size;
				gint _tun_index;
				_tmp506_ = list_tunnels;
				_tmp507_ = _g_object_ref0 (_tmp506_);
				_tun_list = _tmp507_;
				_tmp508_ = _tun_list;
				_tmp509_ = gee_abstract_collection_get_size ((GeeCollection*) _tmp508_);
				_tmp510_ = _tmp509_;
				_tun_size = _tmp510_;
				_tun_index = -1;
				while (TRUE) {
					gint _tmp511_;
					gint _tmp512_;
					gint _tmp513_;
					GeeArrayList* _tmp514_;
					gint _tmp515_;
					gpointer _tmp516_ = NULL;
					NetsukukuTunnelItem* tun;
					NetsukukuTunnelItem* _tmp517_;
					const gchar* _tmp518_;
					const gchar* _tmp519_;
					gchar* _tmp520_;
					gchar* ipstr;
					gint _tmp521_;
					gchar* _tmp522_ = NULL;
					gchar* _tmp523_;
					gchar* _tmp524_ = NULL;
					gchar* _tmp525_;
					gchar* dev;
					gint _tmp526_;
					gint tableid;
					const gchar* _tmp527_;
					const gchar* _tmp528_ = NULL;
					gint _tmp529_;
					gchar* _tmp530_ = NULL;
					gchar* _tmp531_;
					gchar* _tmp532_ = NULL;
					gchar* _tmp533_;
					gint _tmp534_;
					gchar* _tmp535_ = NULL;
					gchar* _tmp536_;
					gint _tmp537_;
					gchar* _tmp538_ = NULL;
					gchar* _tmp539_;
					gchar* _tmp540_ = NULL;
					gchar* _tmp541_;
					gint _tmp542_;
					gchar* _tmp543_ = NULL;
					gchar* _tmp544_;
					const gchar* _tmp545_;
					const gchar* _tmp546_ = NULL;
					const gchar* _tmp547_;
					const gchar* _tmp548_ = NULL;
					const gchar* _tmp549_;
					const gchar* _tmp550_ = NULL;
					gchar* _tmp551_ = NULL;
					gchar* _tmp552_;
					gint _tmp553_;
					_tmp511_ = _tun_index;
					_tun_index = _tmp511_ + 1;
					_tmp512_ = _tun_index;
					_tmp513_ = _tun_size;
					if (!(_tmp512_ < _tmp513_)) {
						break;
					}
					_tmp514_ = _tun_list;
					_tmp515_ = _tun_index;
					_tmp516_ = gee_abstract_list_get ((GeeAbstractList*) _tmp514_, _tmp515_);
					tun = (NetsukukuTunnelItem*) _tmp516_;
					_tmp517_ = tun;
					_tmp518_ = netsukuku_tunnel_item_get_ipstr (_tmp517_);
					_tmp519_ = _tmp518_;
					_tmp520_ = g_strdup (_tmp519_);
					ipstr = _tmp520_;
					_tmp521_ = i;
					_tmp522_ = g_strdup_printf ("%i", _tmp521_);
					_tmp523_ = _tmp522_;
					_tmp524_ = g_strconcat ("ntk-to-inet-", _tmp523_, NULL);
					_tmp525_ = _tmp524_;
					_g_free0 (_tmp523_);
					dev = _tmp525_;
					_tmp526_ = i;
					tableid = 99 - _tmp526_;
					_tmp527_ = dev;
					_tmp528_ = string_to_string (_tmp527_);
					_tmp529_ = tableid;
					_tmp530_ = g_strdup_printf ("%i", _tmp529_);
					_tmp531_ = _tmp530_;
					_tmp532_ = g_strconcat ("-t mangle -A POSTROUTING -o ", _tmp528_, " -m conntrack --ctstate NEW -j CONNMARK --set-mark ", _tmp531_, NULL);
					_tmp533_ = _tmp532_;
					netsukuku_impl_linux_iptables_exp (_tmp533_);
					_g_free0 (_tmp533_);
					_g_free0 (_tmp531_);
					_tmp534_ = tableid;
					_tmp535_ = g_strdup_printf ("%i", _tmp534_);
					_tmp536_ = _tmp535_;
					_tmp537_ = tableid;
					_tmp538_ = g_strdup_printf ("%i", _tmp537_);
					_tmp539_ = _tmp538_;
					_tmp540_ = g_strconcat ("rule add fwmark ", _tmp536_, " lookup ", _tmp539_, NULL);
					_tmp541_ = _tmp540_;
					netsukuku_impl_linux_iproute_exp (_tmp541_);
					_g_free0 (_tmp541_);
					_g_free0 (_tmp539_);
					_g_free0 (_tmp536_);
					_tmp542_ = tableid;
					_tmp543_ = g_strdup_printf ("%i", _tmp542_);
					_tmp544_ = _tmp543_;
					_tmp545_ = ipstr;
					_tmp546_ = string_to_string (_tmp545_);
					_tmp547_ = dev;
					_tmp548_ = string_to_string (_tmp547_);
					_tmp549_ = pref_src;
					_tmp550_ = string_to_string (_tmp549_);
					_tmp551_ = g_strconcat ("route add table ", _tmp544_, " default via ", _tmp546_, " dev ", _tmp548_, " src ", _tmp550_, " onlink", NULL);
					_tmp552_ = _tmp551_;
					netsukuku_impl_linux_iproute_exp (_tmp552_);
					_g_free0 (_tmp552_);
					_g_free0 (_tmp544_);
					_tmp553_ = i;
					i = _tmp553_ + 1;
					_g_free0 (dev);
					_g_free0 (ipstr);
					_g_object_unref0 (tun);
				}
				_g_object_unref0 (_tun_list);
			}
			_tmp554_ = g_strdup ("route add default ");
			cmd = _tmp554_;
			i = 0;
			{
				GeeArrayList* _tmp555_;
				GeeArrayList* _tmp556_;
				GeeArrayList* _tun_list;
				GeeArrayList* _tmp557_;
				gint _tmp558_;
				gint _tmp559_;
				gint _tun_size;
				gint _tun_index;
				_tmp555_ = list_tunnels;
				_tmp556_ = _g_object_ref0 (_tmp555_);
				_tun_list = _tmp556_;
				_tmp557_ = _tun_list;
				_tmp558_ = gee_abstract_collection_get_size ((GeeCollection*) _tmp557_);
				_tmp559_ = _tmp558_;
				_tun_size = _tmp559_;
				_tun_index = -1;
				while (TRUE) {
					gint _tmp560_;
					gint _tmp561_;
					gint _tmp562_;
					GeeArrayList* _tmp563_;
					gint _tmp564_;
					gpointer _tmp565_ = NULL;
					NetsukukuTunnelItem* tun;
					NetsukukuTunnelItem* _tmp566_;
					const gchar* _tmp567_;
					const gchar* _tmp568_;
					gchar* _tmp569_;
					gchar* ipstr;
					gint _tmp570_;
					gchar* _tmp571_ = NULL;
					gchar* _tmp572_;
					gchar* _tmp573_ = NULL;
					gchar* _tmp574_;
					gchar* dev;
					gint* _tmp575_;
					gint _tmp575__length1;
					GeeArrayList* _tmp576_;
					gint _tmp577_;
					gint _tmp578_;
					gint _tmp579_;
					gint _tmp580_;
					gint weight;
					const gchar* _tmp581_;
					const gchar* _tmp582_;
					const gchar* _tmp583_ = NULL;
					const gchar* _tmp584_;
					const gchar* _tmp585_ = NULL;
					gint _tmp586_;
					gchar* _tmp587_ = NULL;
					gchar* _tmp588_;
					gchar* _tmp589_ = NULL;
					gchar* _tmp590_;
					gchar* _tmp591_;
					gint _tmp592_;
					_tmp560_ = _tun_index;
					_tun_index = _tmp560_ + 1;
					_tmp561_ = _tun_index;
					_tmp562_ = _tun_size;
					if (!(_tmp561_ < _tmp562_)) {
						break;
					}
					_tmp563_ = _tun_list;
					_tmp564_ = _tun_index;
					_tmp565_ = gee_abstract_list_get ((GeeAbstractList*) _tmp563_, _tmp564_);
					tun = (NetsukukuTunnelItem*) _tmp565_;
					_tmp566_ = tun;
					_tmp567_ = netsukuku_tunnel_item_get_ipstr (_tmp566_);
					_tmp568_ = _tmp567_;
					_tmp569_ = g_strdup (_tmp568_);
					ipstr = _tmp569_;
					_tmp570_ = i;
					_tmp571_ = g_strdup_printf ("%i", _tmp570_);
					_tmp572_ = _tmp571_;
					_tmp573_ = g_strconcat ("ntk-to-inet-", _tmp572_, NULL);
					_tmp574_ = _tmp573_;
					_g_free0 (_tmp572_);
					dev = _tmp574_;
					_tmp575_ = weights;
					_tmp575__length1 = weights_length1;
					_tmp576_ = list_tunnels;
					_tmp577_ = gee_abstract_collection_get_size ((GeeCollection*) _tmp576_);
					_tmp578_ = _tmp577_;
					_tmp579_ = i;
					_tmp580_ = _tmp575_[(_tmp578_ - 1) - _tmp579_];
					weight = _tmp580_;
					_tmp581_ = cmd;
					_tmp582_ = ipstr;
					_tmp583_ = string_to_string (_tmp582_);
					_tmp584_ = dev;
					_tmp585_ = string_to_string (_tmp584_);
					_tmp586_ = weight;
					_tmp587_ = g_strdup_printf ("%i", _tmp586_);
					_tmp588_ = _tmp587_;
					_tmp589_ = g_strconcat ("nexthop via ", _tmp583_, " dev ", _tmp585_, " weight ", _tmp588_, " onlink ", NULL);
					_tmp590_ = _tmp589_;
					_tmp591_ = g_strconcat (_tmp581_, _tmp590_, NULL);
					_g_free0 (cmd);
					cmd = _tmp591_;
					_g_free0 (_tmp590_);
					_g_free0 (_tmp588_);
					_tmp592_ = i;
					i = _tmp592_ + 1;
					_g_free0 (dev);
					_g_free0 (ipstr);
					_g_object_unref0 (tun);
				}
				_g_object_unref0 (_tun_list);
			}
			_tmp593_ = cmd;
			netsukuku_impl_linux_iproute_exp (_tmp593_);
			_g_free0 (cmd);
		}
		weights = (g_free (weights), NULL);
	}
	result = TRUE;
	_g_free0 (dbg_list_tunnels);
	return result;
}


static gboolean netsukuku_impl_linux_linux_route_real_check_ping (NetsukukuRouteSetter* base, const gchar* ipstr) {
	NetsukukuImplLinuxLinuxRoute * self;
	gboolean result = FALSE;
	const gchar* _tmp0_;
	gboolean _tmp1_ = FALSE;
	self = (NetsukukuImplLinuxLinuxRoute*) base;
	g_return_val_if_fail (ipstr != NULL, FALSE);
	_tmp0_ = ipstr;
	_tmp1_ = netsukuku_impl_linux_check_ping (_tmp0_);
	result = _tmp1_;
	return result;
}


gboolean netsukuku_impl_linux_linux_route_impl_check_ping (NetsukukuImplLinuxLinuxRoute* self, const gchar* ipstr) {
	gboolean result = FALSE;
	const gchar* _tmp0_;
	gboolean _tmp1_ = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (ipstr != NULL, FALSE);
	_tmp0_ = ipstr;
	_tmp1_ = netsukuku_route_setter_check_ping ((NetsukukuRouteSetter*) self, _tmp0_);
	result = _tmp1_;
	return result;
}


static gboolean netsukuku_impl_linux_linux_route_real__reset_routes (NetsukukuRouteSetter* base, const gchar* ip_whole_network, const gchar* cidr_whole_network) {
	NetsukukuImplLinuxLinuxRoute * self;
	gboolean result = FALSE;
	const gchar* _tmp5_;
	const gchar* _tmp6_ = NULL;
	const gchar* _tmp7_;
	const gchar* _tmp8_ = NULL;
	gchar* _tmp9_ = NULL;
	gchar* _tmp10_;
	GeeArrayList* _tmp11_;
	GeeArrayList* done;
	GError * _inner_error_ = NULL;
	self = (NetsukukuImplLinuxLinuxRoute*) base;
	g_return_val_if_fail (ip_whole_network != NULL, FALSE);
	g_return_val_if_fail (cidr_whole_network != NULL, FALSE);
	{
		gchar* _tmp0_ = NULL;
		gchar* _tmp1_;
		_tmp0_ = netsukuku_impl_linux_iproute ("route flush table ntk", &_inner_error_);
		_tmp1_ = _tmp0_;
		_g_free0 (_tmp1_);
		if (_inner_error_ != NULL) {
			goto __catch82_g_error;
		}
	}
	goto __finally82;
	__catch82_g_error:
	{
		GError* e = NULL;
		GError* _tmp2_;
		const gchar* _tmp3_;
		gboolean _tmp4_ = FALSE;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp2_ = e;
		_tmp3_ = _tmp2_->message;
		_tmp4_ = string_contains (_tmp3_, "Nothing to flush");
		_vala_assert (_tmp4_, "e.message.contains(\"Nothing to flush\")");
		_g_error_free0 (e);
	}
	__finally82:
	if (_inner_error_ != NULL) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return FALSE;
	}
	_tmp5_ = ip_whole_network;
	_tmp6_ = string_to_string (_tmp5_);
	_tmp7_ = cidr_whole_network;
	_tmp8_ = string_to_string (_tmp7_);
	_tmp9_ = g_strconcat ("route add table ntk unreachable ", _tmp6_, "/", _tmp8_, NULL);
	_tmp10_ = _tmp9_;
	netsukuku_impl_linux_iproute_exp (_tmp10_);
	_g_free0 (_tmp10_);
	_tmp11_ = gee_array_list_new (G_TYPE_INT, NULL, NULL, NULL, NULL, NULL);
	done = _tmp11_;
	{
		GeeHashMap* _tmp12_;
		GeeCollection* _tmp13_;
		GeeCollection* _tmp14_;
		GeeCollection* _tmp15_;
		GeeIterator* _tmp16_ = NULL;
		GeeIterator* _tmp17_;
		GeeIterator* _idn_it;
		_tmp12_ = self->priv->mac_table;
		_tmp13_ = gee_abstract_map_get_values ((GeeMap*) _tmp12_);
		_tmp14_ = _tmp13_;
		_tmp15_ = _tmp14_;
		_tmp16_ = gee_iterable_iterator ((GeeIterable*) _tmp15_);
		_tmp17_ = _tmp16_;
		_g_object_unref0 (_tmp15_);
		_idn_it = _tmp17_;
		while (TRUE) {
			GeeIterator* _tmp18_;
			gboolean _tmp19_ = FALSE;
			GeeIterator* _tmp20_;
			gpointer _tmp21_ = NULL;
			gint idn;
			GeeArrayList* _tmp22_;
			gint _tmp23_;
			gboolean _tmp24_ = FALSE;
			_tmp18_ = _idn_it;
			_tmp19_ = gee_iterator_next (_tmp18_);
			if (!_tmp19_) {
				break;
			}
			_tmp20_ = _idn_it;
			_tmp21_ = gee_iterator_get (_tmp20_);
			idn = (gint) ((gintptr) _tmp21_);
			_tmp22_ = done;
			_tmp23_ = idn;
			_tmp24_ = gee_abstract_collection_contains ((GeeAbstractCollection*) _tmp22_, (gpointer) ((gintptr) _tmp23_));
			if (!_tmp24_) {
				GeeArrayList* _tmp25_;
				gint _tmp26_;
				_tmp25_ = done;
				_tmp26_ = idn;
				gee_abstract_collection_add ((GeeAbstractCollection*) _tmp25_, (gpointer) ((gintptr) _tmp26_));
				{
					gint _tmp27_;
					gchar* _tmp28_ = NULL;
					gchar* _tmp29_;
					gchar* _tmp30_ = NULL;
					gchar* _tmp31_;
					gchar* _tmp32_ = NULL;
					gchar* _tmp33_;
					_tmp27_ = idn;
					_tmp28_ = g_strdup_printf ("%i", _tmp27_);
					_tmp29_ = _tmp28_;
					_tmp30_ = g_strconcat ("route flush table ", _tmp29_, NULL);
					_tmp31_ = _tmp30_;
					_tmp32_ = netsukuku_impl_linux_iproute (_tmp31_, &_inner_error_);
					_tmp33_ = _tmp32_;
					_g_free0 (_tmp33_);
					_g_free0 (_tmp31_);
					_g_free0 (_tmp29_);
					if (_inner_error_ != NULL) {
						goto __catch83_g_error;
					}
				}
				goto __finally83;
				__catch83_g_error:
				{
					GError* e = NULL;
					GError* _tmp34_;
					const gchar* _tmp35_;
					gboolean _tmp36_ = FALSE;
					e = _inner_error_;
					_inner_error_ = NULL;
					_tmp34_ = e;
					_tmp35_ = _tmp34_->message;
					_tmp36_ = string_contains (_tmp35_, "Nothing to flush");
					_vala_assert (_tmp36_, "e.message.contains(\"Nothing to flush\")");
					_g_error_free0 (e);
				}
				__finally83:
				if (_inner_error_ != NULL) {
					_g_object_unref0 (_idn_it);
					_g_object_unref0 (done);
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
					g_clear_error (&_inner_error_);
					return FALSE;
				}
			}
		}
		_g_object_unref0 (_idn_it);
	}
	result = TRUE;
	_g_object_unref0 (done);
	return result;
}


static void netsukuku_impl_linux_linux_route_real_ip_forward (NetsukukuRouteSetter* base, gboolean enable) {
	NetsukukuImplLinuxLinuxRoute * self;
	gchar* _tmp0_;
	gchar* path;
	const gchar* _tmp1_ = NULL;
	gboolean _tmp2_;
	const gchar* _tmp3_;
	gchar* _tmp4_;
	gchar* content;
	GError * _inner_error_ = NULL;
	self = (NetsukukuImplLinuxLinuxRoute*) base;
	_tmp0_ = g_strdup ("/proc/sys/net/ipv4/ip_forward");
	path = _tmp0_;
	_tmp2_ = enable;
	if (_tmp2_) {
		_tmp1_ = "1";
	} else {
		_tmp1_ = "0";
	}
	_tmp3_ = _tmp1_;
	_tmp4_ = g_strdup (_tmp3_);
	content = _tmp4_;
	{
		const gchar* _tmp5_;
		guint8* _tmp6_;
		gint _tmp6__length1;
		guint8* _tmp7_;
		gint _tmp7__length1;
		_tmp5_ = path;
		_tmp6_ = string_get_data (content, &_tmp6__length1);
		_tmp7_ = _tmp6_;
		_tmp7__length1 = _tmp6__length1;
		netsukuku_impl_linux_write_file (_tmp5_, _tmp7_, _tmp7__length1);
	}
	goto __finally84;
	__catch84_g_error:
	{
		GError* e = NULL;
		const gchar* _tmp8_ = NULL;
		const gchar* _tmp9_;
		const gchar* _tmp10_ = NULL;
		gchar* _tmp11_ = NULL;
		gchar* _tmp12_;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp8_ = string_to_string (content);
		_tmp9_ = path;
		_tmp10_ = string_to_string (_tmp9_);
		_tmp11_ = g_strconcat ("ip_forward: error (ignored) writing '", _tmp8_, "' in '", _tmp10_, "'", NULL);
		_tmp12_ = _tmp11_;
		netsukuku_log_error (_tmp12_);
		_g_free0 (_tmp12_);
		_g_error_free0 (e);
	}
	__finally84:
	if (_inner_error_ != NULL) {
		_g_free0 (content);
		_g_free0 (path);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
	_g_free0 (content);
	_g_free0 (path);
}


static void netsukuku_impl_linux_linux_route_class_init (NetsukukuImplLinuxLinuxRouteClass * klass) {
	netsukuku_impl_linux_linux_route_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (NetsukukuImplLinuxLinuxRoutePrivate));
	NETSUKUKU_ROUTE_SETTER_CLASS (klass)->activate_multipath = netsukuku_impl_linux_linux_route_real_activate_multipath;
	NETSUKUKU_ROUTE_SETTER_CLASS (klass)->_add_outgoing_route = netsukuku_impl_linux_linux_route_real__add_outgoing_route;
	NETSUKUKU_ROUTE_SETTER_CLASS (klass)->_add_forwarding_route = netsukuku_impl_linux_linux_route_real__add_forwarding_route;
	NETSUKUKU_ROUTE_SETTER_CLASS (klass)->_add_forwarding_route_unreachable = netsukuku_impl_linux_linux_route_real__add_forwarding_route_unreachable;
	NETSUKUKU_ROUTE_SETTER_CLASS (klass)->_add_forwarding_route_drop = netsukuku_impl_linux_linux_route_real__add_forwarding_route_drop;
	NETSUKUKU_ROUTE_SETTER_CLASS (klass)->_change_outgoing_route = netsukuku_impl_linux_linux_route_real__change_outgoing_route;
	NETSUKUKU_ROUTE_SETTER_CLASS (klass)->_change_forwarding_route = netsukuku_impl_linux_linux_route_real__change_forwarding_route;
	NETSUKUKU_ROUTE_SETTER_CLASS (klass)->_change_forwarding_route_unreachable = netsukuku_impl_linux_linux_route_real__change_forwarding_route_unreachable;
	NETSUKUKU_ROUTE_SETTER_CLASS (klass)->_change_forwarding_route_drop = netsukuku_impl_linux_linux_route_real__change_forwarding_route_drop;
	NETSUKUKU_ROUTE_SETTER_CLASS (klass)->_change_forwarding_route_was_unreachable = netsukuku_impl_linux_linux_route_real__change_forwarding_route_was_unreachable;
	NETSUKUKU_ROUTE_SETTER_CLASS (klass)->_change_forwarding_route_drop_was_unreachable = netsukuku_impl_linux_linux_route_real__change_forwarding_route_drop_was_unreachable;
	NETSUKUKU_ROUTE_SETTER_CLASS (klass)->_change_forwarding_route_was_drop = netsukuku_impl_linux_linux_route_real__change_forwarding_route_was_drop;
	NETSUKUKU_ROUTE_SETTER_CLASS (klass)->_change_forwarding_route_unreachable_was_drop = netsukuku_impl_linux_linux_route_real__change_forwarding_route_unreachable_was_drop;
	NETSUKUKU_ROUTE_SETTER_CLASS (klass)->_remove_outgoing_route = netsukuku_impl_linux_linux_route_real__remove_outgoing_route;
	NETSUKUKU_ROUTE_SETTER_CLASS (klass)->_remove_forwarding_route = netsukuku_impl_linux_linux_route_real__remove_forwarding_route;
	NETSUKUKU_ROUTE_SETTER_CLASS (klass)->_remove_forwarding_route_was_unreachable = netsukuku_impl_linux_linux_route_real__remove_forwarding_route_was_unreachable;
	NETSUKUKU_ROUTE_SETTER_CLASS (klass)->_remove_forwarding_route_was_drop = netsukuku_impl_linux_linux_route_real__remove_forwarding_route_was_drop;
	NETSUKUKU_ROUTE_SETTER_CLASS (klass)->_forward_no_more_from = netsukuku_impl_linux_linux_route_real__forward_no_more_from;
	NETSUKUKU_ROUTE_SETTER_CLASS (klass)->_forward_no_more = netsukuku_impl_linux_linux_route_real__forward_no_more;
	NETSUKUKU_ROUTE_SETTER_CLASS (klass)->_add_neighbour = netsukuku_impl_linux_linux_route_real__add_neighbour;
	NETSUKUKU_ROUTE_SETTER_CLASS (klass)->_change_neighbour = netsukuku_impl_linux_linux_route_real__change_neighbour;
	NETSUKUKU_ROUTE_SETTER_CLASS (klass)->_delete_neighbour = netsukuku_impl_linux_linux_route_real__delete_neighbour;
	NETSUKUKU_ROUTE_SETTER_CLASS (klass)->_igs_update_rules = netsukuku_impl_linux_linux_route_real__igs_update_rules;
	NETSUKUKU_ROUTE_SETTER_CLASS (klass)->check_ping = netsukuku_impl_linux_linux_route_real_check_ping;
	NETSUKUKU_ROUTE_SETTER_CLASS (klass)->_reset_routes = netsukuku_impl_linux_linux_route_real__reset_routes;
	NETSUKUKU_ROUTE_SETTER_CLASS (klass)->ip_forward = netsukuku_impl_linux_linux_route_real_ip_forward;
	G_OBJECT_CLASS (klass)->finalize = netsukuku_impl_linux_linux_route_finalize;
}


static void netsukuku_impl_linux_linux_route_instance_init (NetsukukuImplLinuxLinuxRoute * self) {
	self->priv = NETSUKUKU_IMPL_LINUX_LINUX_ROUTE_GET_PRIVATE (self);
}


static void netsukuku_impl_linux_linux_route_finalize (GObject* obj) {
	NetsukukuImplLinuxLinuxRoute * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, NETSUKUKU_IMPL_LINUX_TYPE_LINUX_ROUTE, NetsukukuImplLinuxLinuxRoute);
	_g_object_unref0 (self->priv->mac_table);
	G_OBJECT_CLASS (netsukuku_impl_linux_linux_route_parent_class)->finalize (obj);
}


GType netsukuku_impl_linux_linux_route_get_type (void) {
	static volatile gsize netsukuku_impl_linux_linux_route_type_id__volatile = 0;
	if (g_once_init_enter (&netsukuku_impl_linux_linux_route_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (NetsukukuImplLinuxLinuxRouteClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) netsukuku_impl_linux_linux_route_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (NetsukukuImplLinuxLinuxRoute), 0, (GInstanceInitFunc) netsukuku_impl_linux_linux_route_instance_init, NULL };
		GType netsukuku_impl_linux_linux_route_type_id;
		netsukuku_impl_linux_linux_route_type_id = g_type_register_static (NETSUKUKU_TYPE_ROUTE_SETTER, "NetsukukuImplLinuxLinuxRoute", &g_define_type_info, 0);
		g_once_init_leave (&netsukuku_impl_linux_linux_route_type_id__volatile, netsukuku_impl_linux_linux_route_type_id);
	}
	return netsukuku_impl_linux_linux_route_type_id__volatile;
}


static NetsukukuConnections* _netsukuku_impl_linux_linux_connections_create (void) {
	NetsukukuConnections* result = NULL;
	NetsukukuImplLinuxLinuxConnections* _tmp0_;
	_tmp0_ = netsukuku_impl_linux_linux_connections_new ();
	result = (NetsukukuConnections*) _tmp0_;
	return result;
}


static NetsukukuConnections* __netsukuku_impl_linux_linux_connections_create_netsukuku_create_connections_delegate (gpointer self) {
	NetsukukuConnections* result;
	result = _netsukuku_impl_linux_linux_connections_create ();
	return result;
}


void netsukuku_impl_linux_linux_connections_register (void) {
	netsukuku_connections_register_class ("linux", __netsukuku_impl_linux_linux_connections_create_netsukuku_create_connections_delegate, NULL);
}


static gboolean netsukuku_impl_linux_linux_connections_real_active_tcp_connections (NetsukukuConnections* base, const gchar* ip) {
	NetsukukuImplLinuxLinuxConnections * self;
	gboolean result = FALSE;
	const gchar* _tmp0_;
	const gchar* _tmp1_ = NULL;
	gchar* _tmp2_ = NULL;
	gchar* _tmp3_;
	self = (NetsukukuImplLinuxLinuxConnections*) base;
	g_return_val_if_fail (ip != NULL, FALSE);
	_tmp0_ = ip;
	_tmp1_ = string_to_string (_tmp0_);
	_tmp2_ = g_strconcat ("Connections: issue: netstat -an | grep ^tcp | grep ESTABLISHED | grep ", _tmp1_, ":", NULL);
	_tmp3_ = _tmp2_;
	netsukuku_log_info (_tmp3_);
	_g_free0 (_tmp3_);
	result = FALSE;
	return result;
}


NetsukukuImplLinuxLinuxConnections* netsukuku_impl_linux_linux_connections_construct (GType object_type) {
	NetsukukuImplLinuxLinuxConnections * self = NULL;
	self = (NetsukukuImplLinuxLinuxConnections*) netsukuku_connections_construct (object_type);
	return self;
}


NetsukukuImplLinuxLinuxConnections* netsukuku_impl_linux_linux_connections_new (void) {
	return netsukuku_impl_linux_linux_connections_construct (NETSUKUKU_IMPL_LINUX_TYPE_LINUX_CONNECTIONS);
}


static void netsukuku_impl_linux_linux_connections_class_init (NetsukukuImplLinuxLinuxConnectionsClass * klass) {
	netsukuku_impl_linux_linux_connections_parent_class = g_type_class_peek_parent (klass);
	NETSUKUKU_CONNECTIONS_CLASS (klass)->active_tcp_connections = netsukuku_impl_linux_linux_connections_real_active_tcp_connections;
}


static void netsukuku_impl_linux_linux_connections_instance_init (NetsukukuImplLinuxLinuxConnections * self) {
}


GType netsukuku_impl_linux_linux_connections_get_type (void) {
	static volatile gsize netsukuku_impl_linux_linux_connections_type_id__volatile = 0;
	if (g_once_init_enter (&netsukuku_impl_linux_linux_connections_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (NetsukukuImplLinuxLinuxConnectionsClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) netsukuku_impl_linux_linux_connections_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (NetsukukuImplLinuxLinuxConnections), 0, (GInstanceInitFunc) netsukuku_impl_linux_linux_connections_instance_init, NULL };
		GType netsukuku_impl_linux_linux_connections_type_id;
		netsukuku_impl_linux_linux_connections_type_id = g_type_register_static (NETSUKUKU_TYPE_CONNECTIONS, "NetsukukuImplLinuxLinuxConnections", &g_define_type_info, 0);
		g_once_init_leave (&netsukuku_impl_linux_linux_connections_type_id__volatile, netsukuku_impl_linux_linux_connections_type_id);
	}
	return netsukuku_impl_linux_linux_connections_type_id__volatile;
}


static NetsukukuBaseTunnel* _netsukuku_impl_linux_linux_tunnel_create (void) {
	NetsukukuBaseTunnel* result = NULL;
	NetsukukuImplLinuxLinuxTunnel* _tmp0_;
	_tmp0_ = netsukuku_impl_linux_linux_tunnel_new ();
	result = (NetsukukuBaseTunnel*) _tmp0_;
	return result;
}


static NetsukukuBaseTunnel* __netsukuku_impl_linux_linux_tunnel_create_netsukuku_create_tunnel_delegate (gpointer self) {
	NetsukukuBaseTunnel* result;
	result = _netsukuku_impl_linux_linux_tunnel_create ();
	return result;
}


void netsukuku_impl_linux_linux_tunnel_register (void) {
	netsukuku_base_tunnel_register_class ("linux", __netsukuku_impl_linux_linux_tunnel_create_netsukuku_create_tunnel_delegate, NULL);
}


NetsukukuImplLinuxLinuxTunnel* netsukuku_impl_linux_linux_tunnel_construct (GType object_type) {
	NetsukukuImplLinuxLinuxTunnel * self = NULL;
	GeeLinkedList* _tmp0_;
	GeeHashMap* _tmp7_;
	self = (NetsukukuImplLinuxLinuxTunnel*) netsukuku_base_tunnel_construct (object_type);
	_tmp0_ = gee_linked_list_new (G_TYPE_INT, NULL, NULL, NULL, NULL, NULL);
	_g_object_unref0 (self->priv->port_pool);
	self->priv->port_pool = _tmp0_;
	{
		gint i;
		i = 50655;
		{
			gboolean _tmp1_;
			_tmp1_ = TRUE;
			while (TRUE) {
				gboolean _tmp2_;
				gint _tmp4_;
				GeeLinkedList* _tmp5_;
				gint _tmp6_;
				_tmp2_ = _tmp1_;
				if (!_tmp2_) {
					gint _tmp3_;
					_tmp3_ = i;
					i = _tmp3_ + 1;
				}
				_tmp1_ = FALSE;
				_tmp4_ = i;
				if (!(_tmp4_ < 50680)) {
					break;
				}
				_tmp5_ = self->priv->port_pool;
				_tmp6_ = i;
				gee_queue_offer ((GeeQueue*) _tmp5_, (gpointer) ((gintptr) _tmp6_));
			}
		}
	}
	_tmp7_ = gee_hash_map_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, G_TYPE_INT, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
	_g_object_unref0 (self->priv->used_ports);
	self->priv->used_ports = _tmp7_;
	return self;
}


NetsukukuImplLinuxLinuxTunnel* netsukuku_impl_linux_linux_tunnel_new (void) {
	return netsukuku_impl_linux_linux_tunnel_construct (NETSUKUKU_IMPL_LINUX_TYPE_LINUX_TUNNEL);
}


static gchar* netsukuku_impl_linux_linux_tunnel_real_serve (NetsukukuBaseTunnel* base, NetsukukuCallbackSendDelegate cb_send, void* cb_send_target, NetsukukuCallbackRecvDelegate cb_recv, void* cb_recv_target, const gchar* my_address, const gchar* dest_address, GError** error) {
	NetsukukuImplLinuxLinuxTunnel * self;
	gchar* result = NULL;
	GeeLinkedList* _tmp0_;
	gboolean _tmp1_;
	gboolean _tmp2_;
	GeeLinkedList* _tmp4_;
	gpointer _tmp5_ = NULL;
	gint my_port;
	NetsukukuCallbackRecvDelegate _tmp6_;
	void* _tmp6__target;
	zcdISerializable* _tmp7_ = NULL;
	zcdISerializable* _tmp8_;
	zcdSerializableString* _tmp9_;
	const gchar* _tmp10_;
	const gchar* _tmp11_;
	gchar* _tmp12_;
	gchar* _tmp13_;
	gchar* nic_name;
	GeeHashMap* _tmp14_;
	const gchar* _tmp15_;
	gint _tmp16_;
	gint _tmp17_;
	gchar* _tmp18_ = NULL;
	gchar* _tmp19_;
	const gchar* _tmp20_;
	const gchar* _tmp21_ = NULL;
	gchar* _tmp22_ = NULL;
	gchar* _tmp23_;
	gchar* cmdout = NULL;
	gchar* cmderr = NULL;
	gint exit_status = 0;
	const gchar* _tmp24_;
	const gchar* _tmp25_ = NULL;
	const gchar* _tmp26_;
	const gchar* _tmp27_ = NULL;
	gint _tmp28_;
	gchar* _tmp29_ = NULL;
	gchar* _tmp30_;
	gchar* _tmp31_ = NULL;
	gchar* _tmp32_;
	gchar* _tmp33_ = NULL;
	gchar* _tmp34_ = NULL;
	gint _tmp35_ = 0;
	gint _tmp36_;
	const gchar* _tmp43_;
	const gchar* _tmp44_ = NULL;
	gchar* _tmp45_ = NULL;
	gchar* _tmp46_;
	gint _tmp47_ = 0;
	guint8* _tmp48_ = NULL;
	guint8* _tmp49_;
	gint _tmp49__length1;
	guint8* key;
	gint key_length1;
	gint _key_size_;
	guint8* _tmp50_;
	gint _tmp50__length1;
	NetsukukuCallbackRecvDelegate _tmp52_;
	void* _tmp52__target;
	zcdISerializable* _tmp53_ = NULL;
	zcdISerializable* _tmp54_;
	zcdSerializableBuffer* peer_key;
	NetsukukuCallbackSendDelegate _tmp55_;
	void* _tmp55__target;
	guint8* _tmp56_;
	gint _tmp56__length1;
	zcdSerializableBuffer* _tmp57_;
	zcdSerializableBuffer* _tmp58_;
	const gchar* _tmp59_;
	const gchar* _tmp60_ = NULL;
	gchar* _tmp61_ = NULL;
	gchar* _tmp62_;
	zcdSerializableBuffer* _tmp63_;
	guint8* _tmp64_;
	gint _tmp64__length1;
	guint8* _tmp65_;
	gint _tmp65__length1;
	const gchar* _tmp66_;
	const gchar* _tmp67_ = NULL;
	const gchar* _tmp68_;
	const gchar* _tmp69_ = NULL;
	gint _tmp70_;
	gchar* _tmp71_ = NULL;
	gchar* _tmp72_;
	gchar* _tmp73_ = NULL;
	gchar* _tmp74_;
	gchar* _tmp75_ = NULL;
	gchar* _tmp76_ = NULL;
	gint _tmp77_ = 0;
	gint _tmp78_;
	GError * _inner_error_ = NULL;
	self = (NetsukukuImplLinuxLinuxTunnel*) base;
	g_return_val_if_fail (my_address != NULL, NULL);
	g_return_val_if_fail (dest_address != NULL, NULL);
	_tmp0_ = self->priv->port_pool;
	_tmp1_ = gee_collection_get_is_empty ((GeeCollection*) _tmp0_);
	_tmp2_ = _tmp1_;
	if (_tmp2_) {
		GError* _tmp3_;
		_tmp3_ = g_error_new_literal (NETSUKUKU_TUNNEL_ERROR, NETSUKUKU_TUNNEL_ERROR_GENERIC, "tincd: no more free ports. too many instances?");
		_inner_error_ = _tmp3_;
		if ((_inner_error_->domain == NETSUKUKU_TUNNEL_ERROR) || (_inner_error_->domain == ZCD_RPC_ERROR)) {
			g_propagate_error (error, _inner_error_);
			return NULL;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	}
	_tmp4_ = self->priv->port_pool;
	_tmp5_ = gee_queue_poll ((GeeQueue*) _tmp4_);
	my_port = (gint) ((gintptr) _tmp5_);
	_tmp6_ = cb_recv;
	_tmp6__target = cb_recv_target;
	_tmp7_ = _tmp6_ (_tmp6__target, &_inner_error_);
	_tmp8_ = _tmp7_;
	if (_inner_error_ != NULL) {
		if ((_inner_error_->domain == NETSUKUKU_TUNNEL_ERROR) || (_inner_error_->domain == ZCD_RPC_ERROR)) {
			g_propagate_error (error, _inner_error_);
			return NULL;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	}
	_tmp9_ = G_TYPE_CHECK_INSTANCE_CAST (_tmp8_, ZCD_TYPE_SERIALIZABLE_STRING, zcdSerializableString);
	_tmp10_ = zcd_serializable_string_get_s (_tmp9_);
	_tmp11_ = _tmp10_;
	_tmp12_ = g_strdup (_tmp11_);
	_tmp13_ = _tmp12_;
	_g_object_unref0 (_tmp9_);
	nic_name = _tmp13_;
	_tmp14_ = self->priv->used_ports;
	_tmp15_ = nic_name;
	_tmp16_ = my_port;
	gee_abstract_map_set ((GeeAbstractMap*) _tmp14_, _tmp15_, (gpointer) ((gintptr) _tmp16_));
	_tmp17_ = my_port;
	_tmp18_ = g_strdup_printf ("%i", _tmp17_);
	_tmp19_ = _tmp18_;
	_tmp20_ = nic_name;
	_tmp21_ = string_to_string (_tmp20_);
	_tmp22_ = g_strconcat ("tincd: port ", _tmp19_, " is now reserved for ", _tmp21_, NULL);
	_tmp23_ = _tmp22_;
	netsukuku_log_debug (_tmp23_);
	_g_free0 (_tmp23_);
	_g_free0 (_tmp19_);
	_tmp24_ = nic_name;
	_tmp25_ = string_to_string (_tmp24_);
	_tmp26_ = my_address;
	_tmp27_ = string_to_string (_tmp26_);
	_tmp28_ = my_port;
	_tmp29_ = g_strdup_printf ("%i", _tmp28_);
	_tmp30_ = _tmp29_;
	_tmp31_ = g_strconcat ("/etc/netsukuku/tinc configure_server ", _tmp25_, " ", _tmp27_, " ", _tmp30_, NULL);
	_tmp32_ = _tmp31_;
	netsukuku_impl_linux_sequential_command (_tmp32_, &_tmp33_, &_tmp34_, &_tmp35_);
	_g_free0 (cmdout);
	cmdout = _tmp33_;
	_g_free0 (cmderr);
	cmderr = _tmp34_;
	exit_status = _tmp35_;
	_g_free0 (_tmp32_);
	_g_free0 (_tmp30_);
	_tmp36_ = exit_status;
	if (_tmp36_ != 0) {
		const gchar* _tmp37_;
		const gchar* _tmp38_ = NULL;
		gchar* _tmp39_ = NULL;
		gchar* _tmp40_;
		GError* _tmp41_;
		GError* _tmp42_;
		_tmp37_ = cmderr;
		_tmp38_ = string_to_string (_tmp37_);
		_tmp39_ = g_strconcat ("tincd: ", _tmp38_, NULL);
		_tmp40_ = _tmp39_;
		_tmp41_ = g_error_new_literal (NETSUKUKU_TUNNEL_ERROR, NETSUKUKU_TUNNEL_ERROR_GENERIC, _tmp40_);
		_tmp42_ = _tmp41_;
		_g_free0 (_tmp40_);
		_inner_error_ = _tmp42_;
		if ((_inner_error_->domain == NETSUKUKU_TUNNEL_ERROR) || (_inner_error_->domain == ZCD_RPC_ERROR)) {
			g_propagate_error (error, _inner_error_);
			_g_free0 (cmderr);
			_g_free0 (cmdout);
			_g_free0 (nic_name);
			return NULL;
		} else {
			_g_free0 (cmderr);
			_g_free0 (cmdout);
			_g_free0 (nic_name);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	}
	_tmp43_ = nic_name;
	_tmp44_ = string_to_string (_tmp43_);
	_tmp45_ = g_strconcat ("/etc/tinc/", _tmp44_, "/hosts/node_server", NULL);
	_tmp46_ = _tmp45_;
	_tmp48_ = netsukuku_impl_linux_read_file (_tmp46_, 2000, &_tmp47_);
	_tmp49_ = _tmp48_;
	_tmp49__length1 = _tmp47_;
	_g_free0 (_tmp46_);
	key = _tmp49_;
	key_length1 = _tmp49__length1;
	_key_size_ = key_length1;
	_tmp50_ = key;
	_tmp50__length1 = key_length1;
	if (_tmp50_ == NULL) {
		GError* _tmp51_;
		_tmp51_ = g_error_new_literal (NETSUKUKU_TUNNEL_ERROR, NETSUKUKU_TUNNEL_ERROR_GENERIC, "tincd: key file not generated.");
		_inner_error_ = _tmp51_;
		if ((_inner_error_->domain == NETSUKUKU_TUNNEL_ERROR) || (_inner_error_->domain == ZCD_RPC_ERROR)) {
			g_propagate_error (error, _inner_error_);
			key = (g_free (key), NULL);
			_g_free0 (cmderr);
			_g_free0 (cmdout);
			_g_free0 (nic_name);
			return NULL;
		} else {
			key = (g_free (key), NULL);
			_g_free0 (cmderr);
			_g_free0 (cmdout);
			_g_free0 (nic_name);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	}
	_tmp52_ = cb_recv;
	_tmp52__target = cb_recv_target;
	_tmp53_ = _tmp52_ (_tmp52__target, &_inner_error_);
	_tmp54_ = _tmp53_;
	if (_inner_error_ != NULL) {
		if ((_inner_error_->domain == NETSUKUKU_TUNNEL_ERROR) || (_inner_error_->domain == ZCD_RPC_ERROR)) {
			g_propagate_error (error, _inner_error_);
			key = (g_free (key), NULL);
			_g_free0 (cmderr);
			_g_free0 (cmdout);
			_g_free0 (nic_name);
			return NULL;
		} else {
			key = (g_free (key), NULL);
			_g_free0 (cmderr);
			_g_free0 (cmdout);
			_g_free0 (nic_name);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	}
	peer_key = G_TYPE_CHECK_INSTANCE_CAST (_tmp54_, ZCD_TYPE_SERIALIZABLE_BUFFER, zcdSerializableBuffer);
	_tmp55_ = cb_send;
	_tmp55__target = cb_send_target;
	_tmp56_ = key;
	_tmp56__length1 = key_length1;
	_tmp57_ = zcd_serializable_buffer_new (_tmp56_, _tmp56__length1);
	_tmp58_ = _tmp57_;
	_tmp55_ ((zcdISerializable*) _tmp58_, _tmp55__target, &_inner_error_);
	_g_object_unref0 (_tmp58_);
	if (_inner_error_ != NULL) {
		if ((_inner_error_->domain == NETSUKUKU_TUNNEL_ERROR) || (_inner_error_->domain == ZCD_RPC_ERROR)) {
			g_propagate_error (error, _inner_error_);
			_g_object_unref0 (peer_key);
			key = (g_free (key), NULL);
			_g_free0 (cmderr);
			_g_free0 (cmdout);
			_g_free0 (nic_name);
			return NULL;
		} else {
			_g_object_unref0 (peer_key);
			key = (g_free (key), NULL);
			_g_free0 (cmderr);
			_g_free0 (cmdout);
			_g_free0 (nic_name);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	}
	_tmp59_ = nic_name;
	_tmp60_ = string_to_string (_tmp59_);
	_tmp61_ = g_strconcat ("/etc/tinc/", _tmp60_, "/hosts/node_client", NULL);
	_tmp62_ = _tmp61_;
	_tmp63_ = peer_key;
	_tmp64_ = zcd_serializable_buffer_get_buffer (_tmp63_, &_tmp64__length1);
	_tmp65_ = _tmp64_;
	_tmp65__length1 = _tmp64__length1;
	netsukuku_impl_linux_write_file (_tmp62_, _tmp65_, _tmp65__length1);
	_g_free0 (_tmp62_);
	_tmp66_ = nic_name;
	_tmp67_ = string_to_string (_tmp66_);
	_tmp68_ = my_address;
	_tmp69_ = string_to_string (_tmp68_);
	_tmp70_ = my_port;
	_tmp71_ = g_strdup_printf ("%i", _tmp70_);
	_tmp72_ = _tmp71_;
	_tmp73_ = g_strconcat ("/etc/netsukuku/tinc start ", _tmp67_, " ", _tmp69_, " ", _tmp72_, NULL);
	_tmp74_ = _tmp73_;
	netsukuku_impl_linux_sequential_command (_tmp74_, &_tmp75_, &_tmp76_, &_tmp77_);
	_g_free0 (cmdout);
	cmdout = _tmp75_;
	_g_free0 (cmderr);
	cmderr = _tmp76_;
	exit_status = _tmp77_;
	_g_free0 (_tmp74_);
	_g_free0 (_tmp72_);
	_tmp78_ = exit_status;
	if (_tmp78_ != 0) {
		const gchar* _tmp79_;
		const gchar* _tmp80_ = NULL;
		gchar* _tmp81_ = NULL;
		gchar* _tmp82_;
		GError* _tmp83_;
		GError* _tmp84_;
		_tmp79_ = cmderr;
		_tmp80_ = string_to_string (_tmp79_);
		_tmp81_ = g_strconcat ("tincd: ", _tmp80_, NULL);
		_tmp82_ = _tmp81_;
		_tmp83_ = g_error_new_literal (NETSUKUKU_TUNNEL_ERROR, NETSUKUKU_TUNNEL_ERROR_GENERIC, _tmp82_);
		_tmp84_ = _tmp83_;
		_g_free0 (_tmp82_);
		_inner_error_ = _tmp84_;
		if ((_inner_error_->domain == NETSUKUKU_TUNNEL_ERROR) || (_inner_error_->domain == ZCD_RPC_ERROR)) {
			g_propagate_error (error, _inner_error_);
			_g_object_unref0 (peer_key);
			key = (g_free (key), NULL);
			_g_free0 (cmderr);
			_g_free0 (cmdout);
			_g_free0 (nic_name);
			return NULL;
		} else {
			_g_object_unref0 (peer_key);
			key = (g_free (key), NULL);
			_g_free0 (cmderr);
			_g_free0 (cmdout);
			_g_free0 (nic_name);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	}
	result = nic_name;
	_g_object_unref0 (peer_key);
	key = (g_free (key), NULL);
	_g_free0 (cmderr);
	_g_free0 (cmdout);
	return result;
}


static gchar* netsukuku_impl_linux_linux_tunnel_real_request (NetsukukuBaseTunnel* base, NetsukukuCallbackSendDelegate cb_send, void* cb_send_target, NetsukukuCallbackRecvDelegate cb_recv, void* cb_recv_target, const gchar* my_address, const gchar* dest_address, GError** error) {
	NetsukukuImplLinuxLinuxTunnel * self;
	gchar* result = NULL;
	GeeLinkedList* _tmp0_;
	gboolean _tmp1_;
	gboolean _tmp2_;
	GeeLinkedList* _tmp4_;
	gpointer _tmp5_ = NULL;
	gint my_port;
	gdouble _tmp6_ = 0.0;
	gint32 _tmp7_ = 0;
	gint tunnel_id;
	gint _tmp8_;
	gchar* _tmp9_ = NULL;
	gchar* _tmp10_;
	gchar* _tmp11_ = NULL;
	gchar* _tmp12_;
	gchar* nic_name;
	GeeHashMap* _tmp13_;
	const gchar* _tmp14_;
	gint _tmp15_;
	gint _tmp16_;
	gchar* _tmp17_ = NULL;
	gchar* _tmp18_;
	const gchar* _tmp19_;
	const gchar* _tmp20_ = NULL;
	gchar* _tmp21_ = NULL;
	gchar* _tmp22_;
	NetsukukuCallbackSendDelegate _tmp23_;
	void* _tmp23__target;
	const gchar* _tmp24_;
	zcdSerializableString* _tmp25_;
	zcdSerializableString* _tmp26_;
	gchar* cmdout = NULL;
	gchar* cmderr = NULL;
	gint exit_status = 0;
	const gchar* _tmp27_;
	const gchar* _tmp28_ = NULL;
	const gchar* _tmp29_;
	const gchar* _tmp30_ = NULL;
	gint _tmp31_;
	gchar* _tmp32_ = NULL;
	gchar* _tmp33_;
	gchar* _tmp34_ = NULL;
	gchar* _tmp35_;
	gchar* _tmp36_ = NULL;
	gchar* _tmp37_ = NULL;
	gint _tmp38_ = 0;
	gint _tmp39_;
	const gchar* _tmp46_;
	const gchar* _tmp47_ = NULL;
	gchar* _tmp48_ = NULL;
	gchar* _tmp49_;
	gint _tmp50_ = 0;
	guint8* _tmp51_ = NULL;
	guint8* _tmp52_;
	gint _tmp52__length1;
	guint8* key;
	gint key_length1;
	gint _key_size_;
	guint8* _tmp53_;
	gint _tmp53__length1;
	NetsukukuCallbackSendDelegate _tmp55_;
	void* _tmp55__target;
	guint8* _tmp56_;
	gint _tmp56__length1;
	zcdSerializableBuffer* _tmp57_;
	zcdSerializableBuffer* _tmp58_;
	NetsukukuCallbackRecvDelegate _tmp59_;
	void* _tmp59__target;
	zcdISerializable* _tmp60_ = NULL;
	zcdISerializable* _tmp61_;
	zcdSerializableBuffer* peer_key;
	const gchar* _tmp62_;
	const gchar* _tmp63_ = NULL;
	gchar* _tmp64_ = NULL;
	gchar* _tmp65_;
	zcdSerializableBuffer* _tmp66_;
	guint8* _tmp67_;
	gint _tmp67__length1;
	guint8* _tmp68_;
	gint _tmp68__length1;
	const gchar* _tmp69_;
	const gchar* _tmp70_ = NULL;
	const gchar* _tmp71_;
	const gchar* _tmp72_ = NULL;
	gint _tmp73_;
	gchar* _tmp74_ = NULL;
	gchar* _tmp75_;
	gchar* _tmp76_ = NULL;
	gchar* _tmp77_;
	gchar* _tmp78_ = NULL;
	gchar* _tmp79_ = NULL;
	gint _tmp80_ = 0;
	gint _tmp81_;
	GError * _inner_error_ = NULL;
	self = (NetsukukuImplLinuxLinuxTunnel*) base;
	g_return_val_if_fail (my_address != NULL, NULL);
	g_return_val_if_fail (dest_address != NULL, NULL);
	_tmp0_ = self->priv->port_pool;
	_tmp1_ = gee_collection_get_is_empty ((GeeCollection*) _tmp0_);
	_tmp2_ = _tmp1_;
	if (_tmp2_) {
		GError* _tmp3_;
		_tmp3_ = g_error_new_literal (NETSUKUKU_TUNNEL_ERROR, NETSUKUKU_TUNNEL_ERROR_GENERIC, "tincd: no more free ports. too many instances?");
		_inner_error_ = _tmp3_;
		if ((_inner_error_->domain == NETSUKUKU_TUNNEL_ERROR) || (_inner_error_->domain == ZCD_RPC_ERROR)) {
			g_propagate_error (error, _inner_error_);
			return NULL;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	}
	_tmp4_ = self->priv->port_pool;
	_tmp5_ = gee_queue_poll ((GeeQueue*) _tmp4_);
	my_port = (gint) ((gintptr) _tmp5_);
	_tmp6_ = pow ((gdouble) 2, (gdouble) 32);
	_tmp7_ = g_random_int_range ((gint32) 0, (gint32) (((gint) _tmp6_) - 1));
	tunnel_id = (gint) _tmp7_;
	_tmp8_ = tunnel_id;
	_tmp9_ = g_strdup_printf ("%i", _tmp8_);
	_tmp10_ = _tmp9_;
	_tmp11_ = g_strconcat ("net_", _tmp10_, NULL);
	_tmp12_ = _tmp11_;
	_g_free0 (_tmp10_);
	nic_name = _tmp12_;
	_tmp13_ = self->priv->used_ports;
	_tmp14_ = nic_name;
	_tmp15_ = my_port;
	gee_abstract_map_set ((GeeAbstractMap*) _tmp13_, _tmp14_, (gpointer) ((gintptr) _tmp15_));
	_tmp16_ = my_port;
	_tmp17_ = g_strdup_printf ("%i", _tmp16_);
	_tmp18_ = _tmp17_;
	_tmp19_ = nic_name;
	_tmp20_ = string_to_string (_tmp19_);
	_tmp21_ = g_strconcat ("tincd: port ", _tmp18_, " is now reserved for ", _tmp20_, NULL);
	_tmp22_ = _tmp21_;
	netsukuku_log_debug (_tmp22_);
	_g_free0 (_tmp22_);
	_g_free0 (_tmp18_);
	_tmp23_ = cb_send;
	_tmp23__target = cb_send_target;
	_tmp24_ = nic_name;
	_tmp25_ = zcd_serializable_string_new (_tmp24_);
	_tmp26_ = _tmp25_;
	_tmp23_ ((zcdISerializable*) _tmp26_, _tmp23__target, &_inner_error_);
	_g_object_unref0 (_tmp26_);
	if (_inner_error_ != NULL) {
		if ((_inner_error_->domain == NETSUKUKU_TUNNEL_ERROR) || (_inner_error_->domain == ZCD_RPC_ERROR)) {
			g_propagate_error (error, _inner_error_);
			_g_free0 (nic_name);
			return NULL;
		} else {
			_g_free0 (nic_name);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	}
	_tmp27_ = nic_name;
	_tmp28_ = string_to_string (_tmp27_);
	_tmp29_ = my_address;
	_tmp30_ = string_to_string (_tmp29_);
	_tmp31_ = my_port;
	_tmp32_ = g_strdup_printf ("%i", _tmp31_);
	_tmp33_ = _tmp32_;
	_tmp34_ = g_strconcat ("/etc/netsukuku/tinc configure_client ", _tmp28_, " ", _tmp30_, " ", _tmp33_, NULL);
	_tmp35_ = _tmp34_;
	netsukuku_impl_linux_sequential_command (_tmp35_, &_tmp36_, &_tmp37_, &_tmp38_);
	_g_free0 (cmdout);
	cmdout = _tmp36_;
	_g_free0 (cmderr);
	cmderr = _tmp37_;
	exit_status = _tmp38_;
	_g_free0 (_tmp35_);
	_g_free0 (_tmp33_);
	_tmp39_ = exit_status;
	if (_tmp39_ != 0) {
		const gchar* _tmp40_;
		const gchar* _tmp41_ = NULL;
		gchar* _tmp42_ = NULL;
		gchar* _tmp43_;
		GError* _tmp44_;
		GError* _tmp45_;
		_tmp40_ = cmderr;
		_tmp41_ = string_to_string (_tmp40_);
		_tmp42_ = g_strconcat ("tincd: ", _tmp41_, NULL);
		_tmp43_ = _tmp42_;
		_tmp44_ = g_error_new_literal (NETSUKUKU_TUNNEL_ERROR, NETSUKUKU_TUNNEL_ERROR_GENERIC, _tmp43_);
		_tmp45_ = _tmp44_;
		_g_free0 (_tmp43_);
		_inner_error_ = _tmp45_;
		if ((_inner_error_->domain == NETSUKUKU_TUNNEL_ERROR) || (_inner_error_->domain == ZCD_RPC_ERROR)) {
			g_propagate_error (error, _inner_error_);
			_g_free0 (cmderr);
			_g_free0 (cmdout);
			_g_free0 (nic_name);
			return NULL;
		} else {
			_g_free0 (cmderr);
			_g_free0 (cmdout);
			_g_free0 (nic_name);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	}
	_tmp46_ = nic_name;
	_tmp47_ = string_to_string (_tmp46_);
	_tmp48_ = g_strconcat ("/etc/tinc/", _tmp47_, "/hosts/node_client", NULL);
	_tmp49_ = _tmp48_;
	_tmp51_ = netsukuku_impl_linux_read_file (_tmp49_, 2000, &_tmp50_);
	_tmp52_ = _tmp51_;
	_tmp52__length1 = _tmp50_;
	_g_free0 (_tmp49_);
	key = _tmp52_;
	key_length1 = _tmp52__length1;
	_key_size_ = key_length1;
	_tmp53_ = key;
	_tmp53__length1 = key_length1;
	if (_tmp53_ == NULL) {
		GError* _tmp54_;
		_tmp54_ = g_error_new_literal (NETSUKUKU_TUNNEL_ERROR, NETSUKUKU_TUNNEL_ERROR_GENERIC, "tincd: key file not generated.");
		_inner_error_ = _tmp54_;
		if ((_inner_error_->domain == NETSUKUKU_TUNNEL_ERROR) || (_inner_error_->domain == ZCD_RPC_ERROR)) {
			g_propagate_error (error, _inner_error_);
			key = (g_free (key), NULL);
			_g_free0 (cmderr);
			_g_free0 (cmdout);
			_g_free0 (nic_name);
			return NULL;
		} else {
			key = (g_free (key), NULL);
			_g_free0 (cmderr);
			_g_free0 (cmdout);
			_g_free0 (nic_name);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	}
	_tmp55_ = cb_send;
	_tmp55__target = cb_send_target;
	_tmp56_ = key;
	_tmp56__length1 = key_length1;
	_tmp57_ = zcd_serializable_buffer_new (_tmp56_, _tmp56__length1);
	_tmp58_ = _tmp57_;
	_tmp55_ ((zcdISerializable*) _tmp58_, _tmp55__target, &_inner_error_);
	_g_object_unref0 (_tmp58_);
	if (_inner_error_ != NULL) {
		if ((_inner_error_->domain == NETSUKUKU_TUNNEL_ERROR) || (_inner_error_->domain == ZCD_RPC_ERROR)) {
			g_propagate_error (error, _inner_error_);
			key = (g_free (key), NULL);
			_g_free0 (cmderr);
			_g_free0 (cmdout);
			_g_free0 (nic_name);
			return NULL;
		} else {
			key = (g_free (key), NULL);
			_g_free0 (cmderr);
			_g_free0 (cmdout);
			_g_free0 (nic_name);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	}
	_tmp59_ = cb_recv;
	_tmp59__target = cb_recv_target;
	_tmp60_ = _tmp59_ (_tmp59__target, &_inner_error_);
	_tmp61_ = _tmp60_;
	if (_inner_error_ != NULL) {
		if ((_inner_error_->domain == NETSUKUKU_TUNNEL_ERROR) || (_inner_error_->domain == ZCD_RPC_ERROR)) {
			g_propagate_error (error, _inner_error_);
			key = (g_free (key), NULL);
			_g_free0 (cmderr);
			_g_free0 (cmdout);
			_g_free0 (nic_name);
			return NULL;
		} else {
			key = (g_free (key), NULL);
			_g_free0 (cmderr);
			_g_free0 (cmdout);
			_g_free0 (nic_name);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	}
	peer_key = G_TYPE_CHECK_INSTANCE_CAST (_tmp61_, ZCD_TYPE_SERIALIZABLE_BUFFER, zcdSerializableBuffer);
	_tmp62_ = nic_name;
	_tmp63_ = string_to_string (_tmp62_);
	_tmp64_ = g_strconcat ("/etc/tinc/", _tmp63_, "/hosts/node_server", NULL);
	_tmp65_ = _tmp64_;
	_tmp66_ = peer_key;
	_tmp67_ = zcd_serializable_buffer_get_buffer (_tmp66_, &_tmp67__length1);
	_tmp68_ = _tmp67_;
	_tmp68__length1 = _tmp67__length1;
	netsukuku_impl_linux_write_file (_tmp65_, _tmp68_, _tmp68__length1);
	_g_free0 (_tmp65_);
	_tmp69_ = nic_name;
	_tmp70_ = string_to_string (_tmp69_);
	_tmp71_ = my_address;
	_tmp72_ = string_to_string (_tmp71_);
	_tmp73_ = my_port;
	_tmp74_ = g_strdup_printf ("%i", _tmp73_);
	_tmp75_ = _tmp74_;
	_tmp76_ = g_strconcat ("/etc/netsukuku/tinc start ", _tmp70_, " ", _tmp72_, " ", _tmp75_, NULL);
	_tmp77_ = _tmp76_;
	netsukuku_impl_linux_sequential_command (_tmp77_, &_tmp78_, &_tmp79_, &_tmp80_);
	_g_free0 (cmdout);
	cmdout = _tmp78_;
	_g_free0 (cmderr);
	cmderr = _tmp79_;
	exit_status = _tmp80_;
	_g_free0 (_tmp77_);
	_g_free0 (_tmp75_);
	_tmp81_ = exit_status;
	if (_tmp81_ != 0) {
		const gchar* _tmp82_;
		const gchar* _tmp83_ = NULL;
		gchar* _tmp84_ = NULL;
		gchar* _tmp85_;
		GError* _tmp86_;
		GError* _tmp87_;
		_tmp82_ = cmderr;
		_tmp83_ = string_to_string (_tmp82_);
		_tmp84_ = g_strconcat ("tincd: ", _tmp83_, NULL);
		_tmp85_ = _tmp84_;
		_tmp86_ = g_error_new_literal (NETSUKUKU_TUNNEL_ERROR, NETSUKUKU_TUNNEL_ERROR_GENERIC, _tmp85_);
		_tmp87_ = _tmp86_;
		_g_free0 (_tmp85_);
		_inner_error_ = _tmp87_;
		if ((_inner_error_->domain == NETSUKUKU_TUNNEL_ERROR) || (_inner_error_->domain == ZCD_RPC_ERROR)) {
			g_propagate_error (error, _inner_error_);
			_g_object_unref0 (peer_key);
			key = (g_free (key), NULL);
			_g_free0 (cmderr);
			_g_free0 (cmdout);
			_g_free0 (nic_name);
			return NULL;
		} else {
			_g_object_unref0 (peer_key);
			key = (g_free (key), NULL);
			_g_free0 (cmderr);
			_g_free0 (cmdout);
			_g_free0 (nic_name);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	}
	result = nic_name;
	_g_object_unref0 (peer_key);
	key = (g_free (key), NULL);
	_g_free0 (cmderr);
	_g_free0 (cmdout);
	return result;
}


static void netsukuku_impl_linux_linux_tunnel_real_close (NetsukukuBaseTunnel* base, const gchar* nic_name, const gchar* my_address, const gchar* dest_address, GError** error) {
	NetsukukuImplLinuxLinuxTunnel * self;
	gchar* cmdout = NULL;
	gchar* cmderr = NULL;
	gint exit_status = 0;
	const gchar* _tmp0_;
	const gchar* _tmp1_ = NULL;
	gchar* _tmp2_ = NULL;
	gchar* _tmp3_;
	gchar* _tmp4_ = NULL;
	gchar* _tmp5_ = NULL;
	gint _tmp6_ = 0;
	gint _tmp7_;
	const gchar* _tmp14_;
	const gchar* _tmp15_ = NULL;
	gchar* _tmp16_ = NULL;
	gchar* _tmp17_;
	gchar* _tmp18_ = NULL;
	gchar* _tmp19_ = NULL;
	gint _tmp20_ = 0;
	gint _tmp21_;
	GeeHashMap* _tmp28_;
	const gchar* _tmp29_;
	gpointer _tmp30_ = NULL;
	gint my_port;
	GeeLinkedList* _tmp31_;
	gint _tmp32_;
	GeeHashMap* _tmp33_;
	const gchar* _tmp34_;
	gint _tmp35_;
	gchar* _tmp36_ = NULL;
	gchar* _tmp37_;
	gchar* _tmp38_ = NULL;
	gchar* _tmp39_;
	GError * _inner_error_ = NULL;
	self = (NetsukukuImplLinuxLinuxTunnel*) base;
	g_return_if_fail (nic_name != NULL);
	g_return_if_fail (my_address != NULL);
	g_return_if_fail (dest_address != NULL);
	_tmp0_ = nic_name;
	_tmp1_ = string_to_string (_tmp0_);
	_tmp2_ = g_strconcat ("/etc/netsukuku/tinc stop ", _tmp1_, " none none", NULL);
	_tmp3_ = _tmp2_;
	netsukuku_impl_linux_sequential_command (_tmp3_, &_tmp4_, &_tmp5_, &_tmp6_);
	_g_free0 (cmdout);
	cmdout = _tmp4_;
	_g_free0 (cmderr);
	cmderr = _tmp5_;
	exit_status = _tmp6_;
	_g_free0 (_tmp3_);
	_tmp7_ = exit_status;
	if (_tmp7_ != 0) {
		const gchar* _tmp8_;
		const gchar* _tmp9_ = NULL;
		gchar* _tmp10_ = NULL;
		gchar* _tmp11_;
		GError* _tmp12_;
		GError* _tmp13_;
		_tmp8_ = cmderr;
		_tmp9_ = string_to_string (_tmp8_);
		_tmp10_ = g_strconcat ("tincd: ", _tmp9_, NULL);
		_tmp11_ = _tmp10_;
		_tmp12_ = g_error_new_literal (NETSUKUKU_TUNNEL_ERROR, NETSUKUKU_TUNNEL_ERROR_GENERIC, _tmp11_);
		_tmp13_ = _tmp12_;
		_g_free0 (_tmp11_);
		_inner_error_ = _tmp13_;
		if (_inner_error_->domain == NETSUKUKU_TUNNEL_ERROR) {
			g_propagate_error (error, _inner_error_);
			_g_free0 (cmderr);
			_g_free0 (cmdout);
			return;
		} else {
			_g_free0 (cmderr);
			_g_free0 (cmdout);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
	}
	_tmp14_ = nic_name;
	_tmp15_ = string_to_string (_tmp14_);
	_tmp16_ = g_strconcat ("/etc/netsukuku/tinc remove ", _tmp15_, " none none", NULL);
	_tmp17_ = _tmp16_;
	netsukuku_impl_linux_sequential_command (_tmp17_, &_tmp18_, &_tmp19_, &_tmp20_);
	_g_free0 (cmdout);
	cmdout = _tmp18_;
	_g_free0 (cmderr);
	cmderr = _tmp19_;
	exit_status = _tmp20_;
	_g_free0 (_tmp17_);
	_tmp21_ = exit_status;
	if (_tmp21_ != 0) {
		const gchar* _tmp22_;
		const gchar* _tmp23_ = NULL;
		gchar* _tmp24_ = NULL;
		gchar* _tmp25_;
		GError* _tmp26_;
		GError* _tmp27_;
		_tmp22_ = cmderr;
		_tmp23_ = string_to_string (_tmp22_);
		_tmp24_ = g_strconcat ("tincd: ", _tmp23_, NULL);
		_tmp25_ = _tmp24_;
		_tmp26_ = g_error_new_literal (NETSUKUKU_TUNNEL_ERROR, NETSUKUKU_TUNNEL_ERROR_GENERIC, _tmp25_);
		_tmp27_ = _tmp26_;
		_g_free0 (_tmp25_);
		_inner_error_ = _tmp27_;
		if (_inner_error_->domain == NETSUKUKU_TUNNEL_ERROR) {
			g_propagate_error (error, _inner_error_);
			_g_free0 (cmderr);
			_g_free0 (cmdout);
			return;
		} else {
			_g_free0 (cmderr);
			_g_free0 (cmdout);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
	}
	_tmp28_ = self->priv->used_ports;
	_tmp29_ = nic_name;
	_tmp30_ = gee_abstract_map_get ((GeeAbstractMap*) _tmp28_, _tmp29_);
	my_port = (gint) ((gintptr) _tmp30_);
	_tmp31_ = self->priv->port_pool;
	_tmp32_ = my_port;
	gee_queue_offer ((GeeQueue*) _tmp31_, (gpointer) ((gintptr) _tmp32_));
	_tmp33_ = self->priv->used_ports;
	_tmp34_ = nic_name;
	gee_abstract_map_unset ((GeeAbstractMap*) _tmp33_, _tmp34_, NULL);
	_tmp35_ = my_port;
	_tmp36_ = g_strdup_printf ("%i", _tmp35_);
	_tmp37_ = _tmp36_;
	_tmp38_ = g_strconcat ("tincd: port ", _tmp37_, " is now freed.", NULL);
	_tmp39_ = _tmp38_;
	netsukuku_log_debug (_tmp39_);
	_g_free0 (_tmp39_);
	_g_free0 (_tmp37_);
	_g_free0 (cmderr);
	_g_free0 (cmdout);
}


static void netsukuku_impl_linux_linux_tunnel_class_init (NetsukukuImplLinuxLinuxTunnelClass * klass) {
	netsukuku_impl_linux_linux_tunnel_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (NetsukukuImplLinuxLinuxTunnelPrivate));
	NETSUKUKU_BASE_TUNNEL_CLASS (klass)->serve = netsukuku_impl_linux_linux_tunnel_real_serve;
	NETSUKUKU_BASE_TUNNEL_CLASS (klass)->request = netsukuku_impl_linux_linux_tunnel_real_request;
	NETSUKUKU_BASE_TUNNEL_CLASS (klass)->close = netsukuku_impl_linux_linux_tunnel_real_close;
	G_OBJECT_CLASS (klass)->finalize = netsukuku_impl_linux_linux_tunnel_finalize;
}


static void netsukuku_impl_linux_linux_tunnel_instance_init (NetsukukuImplLinuxLinuxTunnel * self) {
	self->priv = NETSUKUKU_IMPL_LINUX_LINUX_TUNNEL_GET_PRIVATE (self);
}


static void netsukuku_impl_linux_linux_tunnel_finalize (GObject* obj) {
	NetsukukuImplLinuxLinuxTunnel * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, NETSUKUKU_IMPL_LINUX_TYPE_LINUX_TUNNEL, NetsukukuImplLinuxLinuxTunnel);
	_g_object_unref0 (self->priv->port_pool);
	_g_object_unref0 (self->priv->used_ports);
	G_OBJECT_CLASS (netsukuku_impl_linux_linux_tunnel_parent_class)->finalize (obj);
}


/** Managing tunnels via tincd in linux
      */
GType netsukuku_impl_linux_linux_tunnel_get_type (void) {
	static volatile gsize netsukuku_impl_linux_linux_tunnel_type_id__volatile = 0;
	if (g_once_init_enter (&netsukuku_impl_linux_linux_tunnel_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (NetsukukuImplLinuxLinuxTunnelClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) netsukuku_impl_linux_linux_tunnel_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (NetsukukuImplLinuxLinuxTunnel), 0, (GInstanceInitFunc) netsukuku_impl_linux_linux_tunnel_instance_init, NULL };
		GType netsukuku_impl_linux_linux_tunnel_type_id;
		netsukuku_impl_linux_linux_tunnel_type_id = g_type_register_static (NETSUKUKU_TYPE_BASE_TUNNEL, "NetsukukuImplLinuxLinuxTunnel", &g_define_type_info, 0);
		g_once_init_leave (&netsukuku_impl_linux_linux_tunnel_type_id__volatile, netsukuku_impl_linux_linux_tunnel_type_id);
	}
	return netsukuku_impl_linux_linux_tunnel_type_id__volatile;
}



