/* peer_to_peer.c generated by valac 0.20.1, the Vala compiler
 * generated from peer_to_peer.vala, do not modify */

/*
 *  This file is part of Netsukuku.
 *  (c) Copyright 2011 Luca Dionisi aka lukisi <luca.dionisi@gmail.com>
 *
 *  Netsukuku is free software: you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation, either version 3 of the License, or
 *  (at your option) any later version.
 *
 *  Netsukuku is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with Netsukuku.  If not, see <http://www.gnu.org/licenses/>.
 *
 *
 *  Implementation of the PeerToPeer Over Ntk RFC. See {-PeerToPeerNtk-}
 */
/** Helper functions for "routed" methods **/
/** Sending of messages **/

#include <glib.h>
#include <glib-object.h>
#include <netsukuku-rpc.h>
#include <gee.h>
#include <tasklet.h>
#include <string.h>
#include <stdlib.h>
#include <zcd.h>


#define NETSUKUKU_TYPE_STRUCT_HELPER_MAPPEERTOPEER_NODE_DEAD (netsukuku_struct_helper_mappeertopeer_node_dead_get_type ())

#define NETSUKUKU_TYPE_MAP (netsukuku_map_get_type ())
#define NETSUKUKU_MAP(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), NETSUKUKU_TYPE_MAP, NetsukukuMap))
#define NETSUKUKU_MAP_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), NETSUKUKU_TYPE_MAP, NetsukukuMapClass))
#define NETSUKUKU_IS_MAP(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), NETSUKUKU_TYPE_MAP))
#define NETSUKUKU_IS_MAP_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), NETSUKUKU_TYPE_MAP))
#define NETSUKUKU_MAP_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), NETSUKUKU_TYPE_MAP, NetsukukuMapClass))

typedef struct _NetsukukuMap NetsukukuMap;
typedef struct _NetsukukuMapClass NetsukukuMapClass;

#define NETSUKUKU_TYPE_MAP_PEER_TO_PEER (netsukuku_map_peer_to_peer_get_type ())
#define NETSUKUKU_MAP_PEER_TO_PEER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), NETSUKUKU_TYPE_MAP_PEER_TO_PEER, NetsukukuMapPeerToPeer))
#define NETSUKUKU_MAP_PEER_TO_PEER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), NETSUKUKU_TYPE_MAP_PEER_TO_PEER, NetsukukuMapPeerToPeerClass))
#define NETSUKUKU_IS_MAP_PEER_TO_PEER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), NETSUKUKU_TYPE_MAP_PEER_TO_PEER))
#define NETSUKUKU_IS_MAP_PEER_TO_PEER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), NETSUKUKU_TYPE_MAP_PEER_TO_PEER))
#define NETSUKUKU_MAP_PEER_TO_PEER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), NETSUKUKU_TYPE_MAP_PEER_TO_PEER, NetsukukuMapPeerToPeerClass))

typedef struct _NetsukukuMapPeerToPeer NetsukukuMapPeerToPeer;
typedef struct _NetsukukuMapPeerToPeerClass NetsukukuMapPeerToPeerClass;
typedef struct _Netsukukustruct_helper_MapPeerToPeer_node_dead Netsukukustruct_helper_MapPeerToPeer_node_dead;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
typedef struct _NetsukukuMapPrivate NetsukukuMapPrivate;
typedef struct _NetsukukuMapPeerToPeerPrivate NetsukukuMapPeerToPeerPrivate;
#define _g_free0(var) (var = (g_free (var), NULL))

#define NETSUKUKU_TYPE_PEER_TO_PEER (netsukuku_peer_to_peer_get_type ())
#define NETSUKUKU_PEER_TO_PEER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), NETSUKUKU_TYPE_PEER_TO_PEER, NetsukukuPeerToPeer))
#define NETSUKUKU_PEER_TO_PEER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), NETSUKUKU_TYPE_PEER_TO_PEER, NetsukukuPeerToPeerClass))
#define NETSUKUKU_IS_PEER_TO_PEER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), NETSUKUKU_TYPE_PEER_TO_PEER))
#define NETSUKUKU_IS_PEER_TO_PEER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), NETSUKUKU_TYPE_PEER_TO_PEER))
#define NETSUKUKU_PEER_TO_PEER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), NETSUKUKU_TYPE_PEER_TO_PEER, NetsukukuPeerToPeerClass))

typedef struct _NetsukukuPeerToPeer NetsukukuPeerToPeer;
typedef struct _NetsukukuPeerToPeerClass NetsukukuPeerToPeerClass;
typedef struct _NetsukukuPeerToPeerPrivate NetsukukuPeerToPeerPrivate;

#define NETSUKUKU_TYPE_MAP_ROUTE (netsukuku_map_route_get_type ())
#define NETSUKUKU_MAP_ROUTE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), NETSUKUKU_TYPE_MAP_ROUTE, NetsukukuMapRoute))
#define NETSUKUKU_MAP_ROUTE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), NETSUKUKU_TYPE_MAP_ROUTE, NetsukukuMapRouteClass))
#define NETSUKUKU_IS_MAP_ROUTE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), NETSUKUKU_TYPE_MAP_ROUTE))
#define NETSUKUKU_IS_MAP_ROUTE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), NETSUKUKU_TYPE_MAP_ROUTE))
#define NETSUKUKU_MAP_ROUTE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), NETSUKUKU_TYPE_MAP_ROUTE, NetsukukuMapRouteClass))

typedef struct _NetsukukuMapRoute NetsukukuMapRoute;
typedef struct _NetsukukuMapRouteClass NetsukukuMapRouteClass;

#define NETSUKUKU_TYPE_AGGREGATED_NEIGHBOUR_MANAGER (netsukuku_aggregated_neighbour_manager_get_type ())
#define NETSUKUKU_AGGREGATED_NEIGHBOUR_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), NETSUKUKU_TYPE_AGGREGATED_NEIGHBOUR_MANAGER, NetsukukuAggregatedNeighbourManager))
#define NETSUKUKU_AGGREGATED_NEIGHBOUR_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), NETSUKUKU_TYPE_AGGREGATED_NEIGHBOUR_MANAGER, NetsukukuAggregatedNeighbourManagerClass))
#define NETSUKUKU_IS_AGGREGATED_NEIGHBOUR_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), NETSUKUKU_TYPE_AGGREGATED_NEIGHBOUR_MANAGER))
#define NETSUKUKU_IS_AGGREGATED_NEIGHBOUR_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), NETSUKUKU_TYPE_AGGREGATED_NEIGHBOUR_MANAGER))
#define NETSUKUKU_AGGREGATED_NEIGHBOUR_MANAGER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), NETSUKUKU_TYPE_AGGREGATED_NEIGHBOUR_MANAGER, NetsukukuAggregatedNeighbourManagerClass))

typedef struct _NetsukukuAggregatedNeighbourManager NetsukukuAggregatedNeighbourManager;
typedef struct _NetsukukuAggregatedNeighbourManagerClass NetsukukuAggregatedNeighbourManagerClass;

#define NETSUKUKU_TYPE_ROUTE_NODE (netsukuku_route_node_get_type ())
#define NETSUKUKU_ROUTE_NODE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), NETSUKUKU_TYPE_ROUTE_NODE, NetsukukuRouteNode))
#define NETSUKUKU_ROUTE_NODE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), NETSUKUKU_TYPE_ROUTE_NODE, NetsukukuRouteNodeClass))
#define NETSUKUKU_IS_ROUTE_NODE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), NETSUKUKU_TYPE_ROUTE_NODE))
#define NETSUKUKU_IS_ROUTE_NODE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), NETSUKUKU_TYPE_ROUTE_NODE))
#define NETSUKUKU_ROUTE_NODE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), NETSUKUKU_TYPE_ROUTE_NODE, NetsukukuRouteNodeClass))

typedef struct _NetsukukuRouteNode NetsukukuRouteNode;
typedef struct _NetsukukuRouteNodeClass NetsukukuRouteNodeClass;

#define NETSUKUKU_TYPE_AGGREGATED_NEIGHBOUR (netsukuku_aggregated_neighbour_get_type ())
#define NETSUKUKU_AGGREGATED_NEIGHBOUR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), NETSUKUKU_TYPE_AGGREGATED_NEIGHBOUR, NetsukukuAggregatedNeighbour))
#define NETSUKUKU_AGGREGATED_NEIGHBOUR_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), NETSUKUKU_TYPE_AGGREGATED_NEIGHBOUR, NetsukukuAggregatedNeighbourClass))
#define NETSUKUKU_IS_AGGREGATED_NEIGHBOUR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), NETSUKUKU_TYPE_AGGREGATED_NEIGHBOUR))
#define NETSUKUKU_IS_AGGREGATED_NEIGHBOUR_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), NETSUKUKU_TYPE_AGGREGATED_NEIGHBOUR))
#define NETSUKUKU_AGGREGATED_NEIGHBOUR_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), NETSUKUKU_TYPE_AGGREGATED_NEIGHBOUR, NetsukukuAggregatedNeighbourClass))

typedef struct _NetsukukuAggregatedNeighbour NetsukukuAggregatedNeighbour;
typedef struct _NetsukukuAggregatedNeighbourClass NetsukukuAggregatedNeighbourClass;

#define NETSUKUKU_TYPE_ROUTE (netsukuku_route_get_type ())
#define NETSUKUKU_ROUTE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), NETSUKUKU_TYPE_ROUTE, NetsukukuRoute))
#define NETSUKUKU_ROUTE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), NETSUKUKU_TYPE_ROUTE, NetsukukuRouteClass))
#define NETSUKUKU_IS_ROUTE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), NETSUKUKU_TYPE_ROUTE))
#define NETSUKUKU_IS_ROUTE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), NETSUKUKU_TYPE_ROUTE))
#define NETSUKUKU_ROUTE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), NETSUKUKU_TYPE_ROUTE, NetsukukuRouteClass))

typedef struct _NetsukukuRoute NetsukukuRoute;
typedef struct _NetsukukuRouteClass NetsukukuRouteClass;
typedef struct _NetsukukuRoutePrivate NetsukukuRoutePrivate;
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))

#define NETSUKUKU_TYPE_RMT_PEER (netsukuku_rmt_peer_get_type ())
#define NETSUKUKU_RMT_PEER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), NETSUKUKU_TYPE_RMT_PEER, NetsukukuRmtPeer))
#define NETSUKUKU_RMT_PEER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), NETSUKUKU_TYPE_RMT_PEER, NetsukukuRmtPeerClass))
#define NETSUKUKU_IS_RMT_PEER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), NETSUKUKU_TYPE_RMT_PEER))
#define NETSUKUKU_IS_RMT_PEER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), NETSUKUKU_TYPE_RMT_PEER))
#define NETSUKUKU_RMT_PEER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), NETSUKUKU_TYPE_RMT_PEER, NetsukukuRmtPeerClass))

typedef struct _NetsukukuRmtPeer NetsukukuRmtPeer;
typedef struct _NetsukukuRmtPeerClass NetsukukuRmtPeerClass;
typedef struct _NetsukukuRmtPeerPrivate NetsukukuRmtPeerPrivate;

#define NETSUKUKU_TYPE_STRUCT_HELPER_OPTIONALPEERTOPEER_PARTICIPANT_SET (netsukuku_struct_helper_optionalpeertopeer_participant_set_get_type ())

#define NETSUKUKU_TYPE_OPTIONAL_PEER_TO_PEER (netsukuku_optional_peer_to_peer_get_type ())
#define NETSUKUKU_OPTIONAL_PEER_TO_PEER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), NETSUKUKU_TYPE_OPTIONAL_PEER_TO_PEER, NetsukukuOptionalPeerToPeer))
#define NETSUKUKU_OPTIONAL_PEER_TO_PEER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), NETSUKUKU_TYPE_OPTIONAL_PEER_TO_PEER, NetsukukuOptionalPeerToPeerClass))
#define NETSUKUKU_IS_OPTIONAL_PEER_TO_PEER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), NETSUKUKU_TYPE_OPTIONAL_PEER_TO_PEER))
#define NETSUKUKU_IS_OPTIONAL_PEER_TO_PEER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), NETSUKUKU_TYPE_OPTIONAL_PEER_TO_PEER))
#define NETSUKUKU_OPTIONAL_PEER_TO_PEER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), NETSUKUKU_TYPE_OPTIONAL_PEER_TO_PEER, NetsukukuOptionalPeerToPeerClass))

typedef struct _NetsukukuOptionalPeerToPeer NetsukukuOptionalPeerToPeer;
typedef struct _NetsukukuOptionalPeerToPeerClass NetsukukuOptionalPeerToPeerClass;
typedef struct _Netsukukustruct_helper_OptionalPeerToPeer_participant_set Netsukukustruct_helper_OptionalPeerToPeer_participant_set;

#define NETSUKUKU_TYPE_STRUCT_HELPER_OPTIONALPEERTOPEER_PARTICIPANT_REFRESH (netsukuku_struct_helper_optionalpeertopeer_participant_refresh_get_type ())
typedef struct _Netsukukustruct_helper_OptionalPeerToPeer_participant_refresh Netsukukustruct_helper_OptionalPeerToPeer_participant_refresh;

#define NETSUKUKU_TYPE_STRUCT_HELPER_OPTIONALPEERTOPEER_SEND_REFRESH_PERIODICALLY (netsukuku_struct_helper_optionalpeertopeer_send_refresh_periodically_get_type ())
typedef struct _Netsukukustruct_helper_OptionalPeerToPeer_send_refresh_periodically Netsukukustruct_helper_OptionalPeerToPeer_send_refresh_periodically;
typedef struct _NetsukukuOptionalPeerToPeerPrivate NetsukukuOptionalPeerToPeerPrivate;

#define NETSUKUKU_TYPE_ADDRESS_MANAGER (netsukuku_address_manager_get_type ())
#define NETSUKUKU_ADDRESS_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), NETSUKUKU_TYPE_ADDRESS_MANAGER, NetsukukuAddressManager))
#define NETSUKUKU_ADDRESS_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), NETSUKUKU_TYPE_ADDRESS_MANAGER, NetsukukuAddressManagerClass))
#define NETSUKUKU_IS_ADDRESS_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), NETSUKUKU_TYPE_ADDRESS_MANAGER))
#define NETSUKUKU_IS_ADDRESS_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), NETSUKUKU_TYPE_ADDRESS_MANAGER))
#define NETSUKUKU_ADDRESS_MANAGER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), NETSUKUKU_TYPE_ADDRESS_MANAGER, NetsukukuAddressManagerClass))

typedef struct _NetsukukuAddressManager NetsukukuAddressManager;
typedef struct _NetsukukuAddressManagerClass NetsukukuAddressManagerClass;

#define NETSUKUKU_TYPE_STRUCT_HELPER_PEERTOPEERALL_START_OPERATIONS (netsukuku_struct_helper_peertopeerall_start_operations_get_type ())

#define NETSUKUKU_TYPE_PEER_TO_PEER_ALL (netsukuku_peer_to_peer_all_get_type ())
#define NETSUKUKU_PEER_TO_PEER_ALL(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), NETSUKUKU_TYPE_PEER_TO_PEER_ALL, NetsukukuPeerToPeerAll))
#define NETSUKUKU_PEER_TO_PEER_ALL_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), NETSUKUKU_TYPE_PEER_TO_PEER_ALL, NetsukukuPeerToPeerAllClass))
#define NETSUKUKU_IS_PEER_TO_PEER_ALL(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), NETSUKUKU_TYPE_PEER_TO_PEER_ALL))
#define NETSUKUKU_IS_PEER_TO_PEER_ALL_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), NETSUKUKU_TYPE_PEER_TO_PEER_ALL))
#define NETSUKUKU_PEER_TO_PEER_ALL_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), NETSUKUKU_TYPE_PEER_TO_PEER_ALL, NetsukukuPeerToPeerAllClass))

typedef struct _NetsukukuPeerToPeerAll NetsukukuPeerToPeerAll;
typedef struct _NetsukukuPeerToPeerAllClass NetsukukuPeerToPeerAllClass;
typedef struct _Netsukukustruct_helper_PeerToPeerAll_start_operations Netsukukustruct_helper_PeerToPeerAll_start_operations;
typedef struct _NetsukukuPeerToPeerAllPrivate NetsukukuPeerToPeerAllPrivate;
typedef struct _NetsukukuAggregatedNeighbourPrivate NetsukukuAggregatedNeighbourPrivate;

typedef enum  {
	NETSUKUKU_PEER_TO_PEER_ERROR_REGISTER,
	NETSUKUKU_PEER_TO_PEER_ERROR_GENERIC
} NetsukukuPeerToPeerError;
#define NETSUKUKU_PEER_TO_PEER_ERROR netsukuku_peer_to_peer_error_quark ()
struct _Netsukukustruct_helper_MapPeerToPeer_node_dead {
	NetsukukuMapPeerToPeer* self;
	gint lvl;
	gint pos;
};

struct _NetsukukuMap {
	GObject parent_instance;
	NetsukukuMapPrivate * priv;
	NetsukukuDataClass** node;
	gint node_length1;
	gint node_length2;
};

struct _NetsukukuMapClass {
	GObjectClass parent_class;
	void (*stop_operations) (NetsukukuMap* self);
	gpointer (*node_get) (NetsukukuMap* self, gint lvl, gint pos);
};

struct _NetsukukuMapPeerToPeer {
	NetsukukuMap parent_instance;
	NetsukukuMapPeerToPeerPrivate * priv;
};

struct _NetsukukuMapPeerToPeerClass {
	NetsukukuMapClass parent_class;
};

struct _NetsukukuMapPeerToPeerPrivate {
	gint pid;
	gboolean participant;
};

struct _NetsukukuPeerToPeer {
	zcdRPCDispatcher parent_instance;
	NetsukukuPeerToPeerPrivate * priv;
	NetsukukuMapRoute* maproute;
	NetsukukuAggregatedNeighbourManager* aggregated_neighbour_manager;
	gint pid;
	gboolean has_valid_map;
};

struct _NetsukukuPeerToPeerClass {
	zcdRPCDispatcherClass parent_class;
	void (*start_operations) (NetsukukuPeerToPeer* self);
	void (*stop_operations) (NetsukukuPeerToPeer* self);
	gboolean (*is_participant) (NetsukukuPeerToPeer* self, gint lvl, gint pos);
	NetsukukuNIP* (*h) (NetsukukuPeerToPeer* self, GObject* key);
};

struct _NetsukukuRoute {
	GObject parent_instance;
	NetsukukuRoutePrivate * priv;
	NetsukukuRouteNode* routenode;
	NetsukukuAggregatedNeighbour* gw;
	NetsukukuREM* rem_at_gw;
	GeeList* hops;
	NetsukukuGNodeID* gid;
};

struct _NetsukukuRouteClass {
	GObjectClass parent_class;
};

struct _NetsukukuRmtPeer {
	GObject parent_instance;
	NetsukukuRmtPeerPrivate * priv;
};

struct _NetsukukuRmtPeerClass {
	GObjectClass parent_class;
	zcdISerializable* (*rmt) (NetsukukuRmtPeer* self, zcdRemoteCall* data, GError** error);
};

struct _NetsukukuRmtPeerPrivate {
	NetsukukuPeerToPeer* peer_to_peer_service;
	GObject* key;
	NetsukukuNIP* hIP;
	NetsukukuAggregatedNeighbour* aggregated_neighbour;
};

struct _Netsukukustruct_helper_OptionalPeerToPeer_participant_set {
	NetsukukuOptionalPeerToPeer* self;
	NetsukukuNIP* nip;
	gint lvl;
	gint pos;
	NetsukukuParticipantNode* participant_node;
};

struct _Netsukukustruct_helper_OptionalPeerToPeer_participant_refresh {
	NetsukukuOptionalPeerToPeer* self;
	NetsukukuNIP* nip;
	NetsukukuPackedParticipantNodes* packed_nodes;
};

struct _Netsukukustruct_helper_OptionalPeerToPeer_send_refresh_periodically {
	NetsukukuOptionalPeerToPeer* self;
};

struct _NetsukukuOptionalPeerToPeer {
	NetsukukuPeerToPeer parent_instance;
	NetsukukuOptionalPeerToPeerPrivate * priv;
	NetsukukuMapPeerToPeer* map_peer_to_peer;
	gboolean will_participate;
};

struct _NetsukukuOptionalPeerToPeerClass {
	NetsukukuPeerToPeerClass parent_class;
};

struct _NetsukukuOptionalPeerToPeerPrivate {
	TaskletsTasklet* send_refresh_handle;
};

struct _Netsukukustruct_helper_PeerToPeerAll_start_operations {
	NetsukukuPeerToPeerAll* self;
};

struct _NetsukukuPeerToPeerAll {
	GObject parent_instance;
	NetsukukuPeerToPeerAllPrivate * priv;
};

struct _NetsukukuPeerToPeerAllClass {
	GObjectClass parent_class;
	void (*peer_to_peer_register) (NetsukukuPeerToPeerAll* self, NetsukukuPeerToPeer* peer_to_peer, GError** error);
};

struct _NetsukukuPeerToPeerAllPrivate {
	NetsukukuAggregatedNeighbourManager* _aggregated_neighbour_manager;
	NetsukukuMapRoute* _maproute;
	gboolean left_all_optional_peer_to_peer;
	GeeHashMap* service;
};

struct _NetsukukuAggregatedNeighbour {
	GObject parent_instance;
	NetsukukuAggregatedNeighbourPrivate * priv;
	gint levels;
	gint gsize;
	NetsukukuNIP* nip;
	gint nodeid;
	NetsukukuNetworkID* netid;
	gboolean is_primary;
	gboolean is_auxiliary;
	GeeHashMap* interfaces;
	GeeList* macs;
	gint mod_seq_num;
};

struct _NetsukukuAggregatedNeighbourClass {
	GObjectClass parent_class;
};


static gpointer netsukuku_map_peer_to_peer_parent_class = NULL;
static gpointer netsukuku_peer_to_peer_parent_class = NULL;
static NetsukukuIPeerToPeerIface* netsukuku_peer_to_peer_netsukuku_ipeer_to_peer_parent_iface = NULL;
static gpointer netsukuku_rmt_peer_parent_class = NULL;
static gpointer netsukuku_optional_peer_to_peer_parent_class = NULL;
static NetsukukuIOptionalPeerToPeerIface* netsukuku_optional_peer_to_peer_netsukuku_ioptional_peer_to_peer_parent_iface = NULL;
static gpointer netsukuku_peer_to_peer_all_parent_class = NULL;
static NetsukukuIPeerToPeerAllIface* netsukuku_peer_to_peer_all_netsukuku_ipeer_to_peer_all_parent_iface = NULL;

GQuark netsukuku_peer_to_peer_error_quark (void);
GType netsukuku_struct_helper_mappeertopeer_node_dead_get_type (void) G_GNUC_CONST;
GType netsukuku_map_get_type (void) G_GNUC_CONST;
GType netsukuku_map_peer_to_peer_get_type (void) G_GNUC_CONST;
Netsukukustruct_helper_MapPeerToPeer_node_dead* netsukuku_struct_helper_mappeertopeer_node_dead_dup (const Netsukukustruct_helper_MapPeerToPeer_node_dead* self);
void netsukuku_struct_helper_mappeertopeer_node_dead_free (Netsukukustruct_helper_MapPeerToPeer_node_dead* self);
void netsukuku_struct_helper_mappeertopeer_node_dead_copy (const Netsukukustruct_helper_MapPeerToPeer_node_dead* self, Netsukukustruct_helper_MapPeerToPeer_node_dead* dest);
void netsukuku_struct_helper_mappeertopeer_node_dead_destroy (Netsukukustruct_helper_MapPeerToPeer_node_dead* self);
#define NETSUKUKU_MAP_PEER_TO_PEER_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), NETSUKUKU_TYPE_MAP_PEER_TO_PEER, NetsukukuMapPeerToPeerPrivate))
enum  {
	NETSUKUKU_MAP_PEER_TO_PEER_DUMMY_PROPERTY
};
NetsukukuMapPeerToPeer* netsukuku_map_peer_to_peer_new (gint levels, gint gsize, NetsukukuNIP* me, gint pid);
NetsukukuMapPeerToPeer* netsukuku_map_peer_to_peer_construct (GType object_type, gint levels, gint gsize, NetsukukuNIP* me, gint pid);
NetsukukuMap* netsukuku_map_new (GType t_type, GBoxedCopyFunc t_dup_func, GDestroyNotify t_destroy_func, gint levels, gint gsize, NetsukukuNIP* me);
NetsukukuMap* netsukuku_map_construct (GType object_type, GType t_type, GBoxedCopyFunc t_dup_func, GDestroyNotify t_destroy_func, gint levels, gint gsize, NetsukukuNIP* me);
void netsukuku_map_peer_to_peer_initialize_from_neighbour (NetsukukuMapPeerToPeer* self, NetsukukuNIP* nip, NetsukukuPackedParticipantNodes* packed_nodes);
gint netsukuku_map_nip_cmp (NetsukukuMap* self, gint* nipA, int nipA_length1);
gint netsukuku_map_get_levels (NetsukukuMap* self);
gint netsukuku_map_get_gsize (NetsukukuMap* self);
NetsukukuNIP* netsukuku_map_get_me (NetsukukuMap* self);
static NetsukukuParticipantNode* netsukuku_map_peer_to_peer_real_node_get (NetsukukuMap* base, gint lvl, gint pos);
gpointer netsukuku_map_node_get (NetsukukuMap* self, gint lvl, gint pos);
static void netsukuku_map_peer_to_peer_impl_node_dead (NetsukukuMapPeerToPeer* self, gint lvl, gint pos, GError** error);
void netsukuku_map_check_node (NetsukukuMap* self, gint lvl, gint pos);
static void* netsukuku_map_peer_to_peer_helper_node_dead (void* v, GError** error);
void netsukuku_map_peer_to_peer_node_dead (NetsukukuMapPeerToPeer* self, gint lvl, gint pos);
void netsukuku_map_peer_to_peer_participate (NetsukukuMapPeerToPeer* self);
void netsukuku_map_peer_to_peer_sit_out (NetsukukuMapPeerToPeer* self);
static gboolean netsukuku_map_peer_to_peer_not_impl_equal_func (GObject* a, GObject* b);
NetsukukuPackedParticipantNodes* netsukuku_map_peer_to_peer_get_packed_nodes (NetsukukuMapPeerToPeer* self);
static gboolean _netsukuku_map_peer_to_peer_not_impl_equal_func_gee_equal_data_func (gconstpointer a, gconstpointer b, gpointer self);
gchar* netsukuku_map_peer_to_peer_log_service (NetsukukuMapPeerToPeer* self);
static void netsukuku_map_peer_to_peer_finalize (GObject* obj);
GType netsukuku_peer_to_peer_get_type (void) G_GNUC_CONST;
GType netsukuku_map_route_get_type (void) G_GNUC_CONST;
GType netsukuku_aggregated_neighbour_manager_get_type (void) G_GNUC_CONST;
enum  {
	NETSUKUKU_PEER_TO_PEER_DUMMY_PROPERTY
};
NetsukukuPeerToPeer* netsukuku_peer_to_peer_new (NetsukukuAggregatedNeighbourManager* aggregated_neighbour_manager, NetsukukuMapRoute* maproute, gint pid);
NetsukukuPeerToPeer* netsukuku_peer_to_peer_construct (GType object_type, NetsukukuAggregatedNeighbourManager* aggregated_neighbour_manager, NetsukukuMapRoute* maproute, gint pid);
void netsukuku_peer_to_peer_start_operations (NetsukukuPeerToPeer* self);
static void netsukuku_peer_to_peer_real_start_operations (NetsukukuPeerToPeer* self);
void netsukuku_peer_to_peer_stop_operations (NetsukukuPeerToPeer* self);
static void netsukuku_peer_to_peer_real_stop_operations (NetsukukuPeerToPeer* self);
gchar* netsukuku_nip_to_str (gint levels, gint gsize, NetsukukuNIP* nip);
void netsukuku_log_debug (const gchar* msg);
gboolean netsukuku_peer_to_peer_is_participant (NetsukukuPeerToPeer* self, gint lvl, gint pos);
static gboolean netsukuku_peer_to_peer_real_is_participant (NetsukukuPeerToPeer* self, gint lvl, gint pos);
GType netsukuku_route_node_get_type (void) G_GNUC_CONST;
NetsukukuNIP* netsukuku_peer_to_peer_h (NetsukukuPeerToPeer* self, GObject* key);
static NetsukukuNIP* netsukuku_peer_to_peer_real_h (NetsukukuPeerToPeer* self, GObject* key);
GType netsukuku_aggregated_neighbour_get_type (void) G_GNUC_CONST;
GeeList* netsukuku_peer_to_peer_neighbours_get_from_lvl_pos (NetsukukuPeerToPeer* self, gint lvl, gint pos);
GType netsukuku_route_get_type (void) G_GNUC_CONST;
GeeList* netsukuku_route_node_all_valid_routes (NetsukukuRouteNode* self);
gboolean netsukuku_aggregated_neighbour_equal_func (NetsukukuAggregatedNeighbour* a, NetsukukuAggregatedNeighbour* b);
static gboolean _netsukuku_aggregated_neighbour_equal_func_gee_equal_data_func (gconstpointer a, gconstpointer b, gpointer self);
GeeList* netsukuku_peer_to_peer_list_ids (NetsukukuPeerToPeer* self, gint center, gint sign);
NetsukukuHCoord* netsukuku_peer_to_peer_search_participant (NetsukukuPeerToPeer* self, NetsukukuNIP* hIP, gint path_sign, GError** error);
NetsukukuPartialNIP* netsukuku_peer_to_peer_search_participant_as_nip (NetsukukuPeerToPeer* self, NetsukukuNIP* hIP, gint path_sign, GError** error);
static zcdISerializable* netsukuku_peer_to_peer_real_msg_send (NetsukukuIPeerToPeer* base, NetsukukuNIP* sender_nip, NetsukukuNIP* hip, zcdRemoteCall* data, GError** error);
void netsukuku_log_warn (const gchar* msg);
static gboolean netsukuku_peer_to_peer_not_impl_equal_func (GObject* a, GObject* b);
void netsukuku_peer_to_peer_execute (NetsukukuMapRoute* maproute, NetsukukuPeerToPeerTracerPacketList* ptptpl, GError** error);
static gboolean _netsukuku_peer_to_peer_not_impl_equal_func_gee_equal_data_func (gconstpointer a, gconstpointer b, gpointer self);
static zcdISerializable* netsukuku_peer_to_peer_real_msg_deliver (NetsukukuIPeerToPeer* base, NetsukukuPeerToPeerTracerPacketList* peer_to_peer_tpl, NetsukukuNIP* sender_nip, NetsukukuNIP* hip, zcdRemoteCall* data, GError** error);
zcdISerializable* netsukuku_peer_to_peer_msg_exec (NetsukukuPeerToPeer* self, NetsukukuNIP* sender_nip, zcdRemoteCall* data, GError** error);
gchar* netsukuku_aggregated_neighbour_to_string (NetsukukuAggregatedNeighbour* self);
NetsukukuAddressManagerTCPClient* netsukuku_aggregated_neighbour_get_tcp_client (NetsukukuAggregatedNeighbour* self);
GeeList* netsukuku_peer_to_peer_find_nearest_to_register (NetsukukuPeerToPeer* self, NetsukukuNIP* hash_nip, gint num_dupl, gint* inside_gnode_level, GError** error);
static gboolean _int_equal (const gint* s1, const gint* s2);
static GeeList* netsukuku_peer_to_peer_real_find_nearest (NetsukukuIPeerToPeer* base, NetsukukuPeerToPeerTracerPacketList* peer_to_peer_tpl, NetsukukuNIP* hash_nip, gint num_dupl, gint lvl, gint pos, GError** error);
GeeList* netsukuku_peer_to_peer_inside_find_nearest (NetsukukuPeerToPeer* self, NetsukukuPeerToPeerTracerPacketList* peer_to_peer_tpl, NetsukukuNIP* hash_nip, gint num_dupl, gint lvl, gint pos, GError** error);
static gboolean _netsukuku_partial_nip_equal_func_gee_equal_data_func (gconstpointer a, gconstpointer b, gpointer self);
gint netsukuku_peer_to_peer_get_number_of_participants (NetsukukuPeerToPeer* self, gint lvl, gint pos, gint timeout, GError** error);
static gint netsukuku_peer_to_peer_real_number_of_participants (NetsukukuIPeerToPeer* base, NetsukukuPeerToPeerTracerPacketList* peer_to_peer_tpl, gint lvl, gint pos, GError** error);
gint netsukuku_peer_to_peer_inside_number_of_participants (NetsukukuPeerToPeer* self, NetsukukuPeerToPeerTracerPacketList* peer_to_peer_tpl, gint lvl, gint pos, GError** error);
void netsukuku_peer_to_peer_find_hook_peers (NetsukukuPeerToPeer* self, gint** ret_first_forward, gint** ret_first_back, gint** ret_last_back, gint lvl, gint num_dupl, gint timeout);
static gint* _int_dup (gint* self);
static void netsukuku_peer_to_peer_finalize (GObject* obj);
GType netsukuku_rmt_peer_get_type (void) G_GNUC_CONST;
#define NETSUKUKU_RMT_PEER_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), NETSUKUKU_TYPE_RMT_PEER, NetsukukuRmtPeerPrivate))
enum  {
	NETSUKUKU_RMT_PEER_DUMMY_PROPERTY
};
NetsukukuRmtPeer* netsukuku_rmt_peer_construct (GType object_type, NetsukukuPeerToPeer* peer_to_peer_service, GObject* key, NetsukukuNIP* hIP, NetsukukuAggregatedNeighbour* aggregated_neighbour);
void netsukuku_rmt_peer_evaluate_hash_nip (NetsukukuRmtPeer* self, GError** error);
NetsukukuNIP* netsukuku_rmt_peer_get_hash_nip (NetsukukuRmtPeer* self, GError** error);
zcdISerializable* netsukuku_rmt_peer_rmt (NetsukukuRmtPeer* self, zcdRemoteCall* data, GError** error);
static zcdISerializable* netsukuku_rmt_peer_real_rmt (NetsukukuRmtPeer* self, zcdRemoteCall* data, GError** error);
NetsukukuAddressManagerFakeRmt* netsukuku_aggregated_neighbour_get_neighbour_client (NetsukukuAggregatedNeighbour* self);
static void netsukuku_rmt_peer_finalize (GObject* obj);
GType netsukuku_struct_helper_optionalpeertopeer_participant_set_get_type (void) G_GNUC_CONST;
GType netsukuku_optional_peer_to_peer_get_type (void) G_GNUC_CONST;
Netsukukustruct_helper_OptionalPeerToPeer_participant_set* netsukuku_struct_helper_optionalpeertopeer_participant_set_dup (const Netsukukustruct_helper_OptionalPeerToPeer_participant_set* self);
void netsukuku_struct_helper_optionalpeertopeer_participant_set_free (Netsukukustruct_helper_OptionalPeerToPeer_participant_set* self);
void netsukuku_struct_helper_optionalpeertopeer_participant_set_copy (const Netsukukustruct_helper_OptionalPeerToPeer_participant_set* self, Netsukukustruct_helper_OptionalPeerToPeer_participant_set* dest);
void netsukuku_struct_helper_optionalpeertopeer_participant_set_destroy (Netsukukustruct_helper_OptionalPeerToPeer_participant_set* self);
GType netsukuku_struct_helper_optionalpeertopeer_participant_refresh_get_type (void) G_GNUC_CONST;
Netsukukustruct_helper_OptionalPeerToPeer_participant_refresh* netsukuku_struct_helper_optionalpeertopeer_participant_refresh_dup (const Netsukukustruct_helper_OptionalPeerToPeer_participant_refresh* self);
void netsukuku_struct_helper_optionalpeertopeer_participant_refresh_free (Netsukukustruct_helper_OptionalPeerToPeer_participant_refresh* self);
void netsukuku_struct_helper_optionalpeertopeer_participant_refresh_copy (const Netsukukustruct_helper_OptionalPeerToPeer_participant_refresh* self, Netsukukustruct_helper_OptionalPeerToPeer_participant_refresh* dest);
void netsukuku_struct_helper_optionalpeertopeer_participant_refresh_destroy (Netsukukustruct_helper_OptionalPeerToPeer_participant_refresh* self);
GType netsukuku_struct_helper_optionalpeertopeer_send_refresh_periodically_get_type (void) G_GNUC_CONST;
Netsukukustruct_helper_OptionalPeerToPeer_send_refresh_periodically* netsukuku_struct_helper_optionalpeertopeer_send_refresh_periodically_dup (const Netsukukustruct_helper_OptionalPeerToPeer_send_refresh_periodically* self);
void netsukuku_struct_helper_optionalpeertopeer_send_refresh_periodically_free (Netsukukustruct_helper_OptionalPeerToPeer_send_refresh_periodically* self);
void netsukuku_struct_helper_optionalpeertopeer_send_refresh_periodically_copy (const Netsukukustruct_helper_OptionalPeerToPeer_send_refresh_periodically* self, Netsukukustruct_helper_OptionalPeerToPeer_send_refresh_periodically* dest);
void netsukuku_struct_helper_optionalpeertopeer_send_refresh_periodically_destroy (Netsukukustruct_helper_OptionalPeerToPeer_send_refresh_periodically* self);
#define NETSUKUKU_OPTIONAL_PEER_TO_PEER_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), NETSUKUKU_TYPE_OPTIONAL_PEER_TO_PEER, NetsukukuOptionalPeerToPeerPrivate))
enum  {
	NETSUKUKU_OPTIONAL_PEER_TO_PEER_DUMMY_PROPERTY,
	NETSUKUKU_OPTIONAL_PEER_TO_PEER_PARTICIPANT
};
NetsukukuOptionalPeerToPeer* netsukuku_optional_peer_to_peer_new (NetsukukuAggregatedNeighbourManager* aggregated_neighbour_manager, NetsukukuMapRoute* maproute, gint pid);
NetsukukuOptionalPeerToPeer* netsukuku_optional_peer_to_peer_construct (GType object_type, NetsukukuAggregatedNeighbourManager* aggregated_neighbour_manager, NetsukukuMapRoute* maproute, gint pid);
static void _netsukuku_map_peer_to_peer_node_dead_netsukuku_map_node_deleted (NetsukukuMap* _sender, gint lvl, gint pos, gpointer self);
NetsukukuParticipantNode* netsukuku_optional_peer_to_peer_get_my_node (NetsukukuOptionalPeerToPeer* self, gint lvl);
static void netsukuku_optional_peer_to_peer_impl_participant_set (NetsukukuOptionalPeerToPeer* self, NetsukukuNIP* nip, gint lvl, gint pos, NetsukukuParticipantNode* participant_node, GError** error);
GType netsukuku_address_manager_get_type (void) G_GNUC_CONST;
NetsukukuAddressManager* netsukuku_map_route_get_address_manager (NetsukukuMapRoute* self);
NetsukukuAddressManagerFakeRmt* netsukuku_address_manager_get_broadcast_client (NetsukukuAddressManager* self);
static void* netsukuku_optional_peer_to_peer_helper_participant_set (void* v, GError** error);
static void netsukuku_optional_peer_to_peer_real_participant_set (NetsukukuIOptionalPeerToPeer* base, NetsukukuNIP* nip, gint lvl, gint pos, NetsukukuParticipantNode* participant_node, GError** error);
static void netsukuku_optional_peer_to_peer_impl_participant_refresh (NetsukukuOptionalPeerToPeer* self, NetsukukuNIP* nip, NetsukukuPackedParticipantNodes* packed_nodes, GError** error);
static void* netsukuku_optional_peer_to_peer_helper_participant_refresh (void* v, GError** error);
static void netsukuku_optional_peer_to_peer_real_participant_refresh (NetsukukuIOptionalPeerToPeer* base, NetsukukuNIP* nip, NetsukukuPackedParticipantNodes* packed_nodes, GError** error);
static void netsukuku_optional_peer_to_peer_impl_send_refresh_periodically (NetsukukuOptionalPeerToPeer* self, GError** error);
static void* netsukuku_optional_peer_to_peer_helper_send_refresh_periodically (void* v, GError** error);
void netsukuku_optional_peer_to_peer_send_refresh_periodically (NetsukukuOptionalPeerToPeer* self);
static gboolean netsukuku_optional_peer_to_peer_real_is_participant (NetsukukuPeerToPeer* base, gint lvl, gint pos);
void netsukuku_optional_peer_to_peer_participate (NetsukukuOptionalPeerToPeer* self);
gboolean netsukuku_optional_peer_to_peer_get_participant (NetsukukuOptionalPeerToPeer* self);
void netsukuku_optional_peer_to_peer_sit_out (NetsukukuOptionalPeerToPeer* self);
static void netsukuku_optional_peer_to_peer_real_start_operations (NetsukukuPeerToPeer* base);
static void netsukuku_optional_peer_to_peer_real_stop_operations (NetsukukuPeerToPeer* base);
void netsukuku_map_stop_operations (NetsukukuMap* self);
gchar* netsukuku_optional_peer_to_peer_log_service (NetsukukuOptionalPeerToPeer* self);
static void netsukuku_optional_peer_to_peer_finalize (GObject* obj);
static void _vala_netsukuku_optional_peer_to_peer_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
GType netsukuku_struct_helper_peertopeerall_start_operations_get_type (void) G_GNUC_CONST;
GType netsukuku_peer_to_peer_all_get_type (void) G_GNUC_CONST;
Netsukukustruct_helper_PeerToPeerAll_start_operations* netsukuku_struct_helper_peertopeerall_start_operations_dup (const Netsukukustruct_helper_PeerToPeerAll_start_operations* self);
void netsukuku_struct_helper_peertopeerall_start_operations_free (Netsukukustruct_helper_PeerToPeerAll_start_operations* self);
void netsukuku_struct_helper_peertopeerall_start_operations_copy (const Netsukukustruct_helper_PeerToPeerAll_start_operations* self, Netsukukustruct_helper_PeerToPeerAll_start_operations* dest);
void netsukuku_struct_helper_peertopeerall_start_operations_destroy (Netsukukustruct_helper_PeerToPeerAll_start_operations* self);
#define NETSUKUKU_PEER_TO_PEER_ALL_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), NETSUKUKU_TYPE_PEER_TO_PEER_ALL, NetsukukuPeerToPeerAllPrivate))
enum  {
	NETSUKUKU_PEER_TO_PEER_ALL_DUMMY_PROPERTY,
	NETSUKUKU_PEER_TO_PEER_ALL_AGGREGATED_NEIGHBOUR_MANAGER,
	NETSUKUKU_PEER_TO_PEER_ALL_MAPROUTE
};
NetsukukuPeerToPeerAll* netsukuku_peer_to_peer_all_new (NetsukukuAggregatedNeighbourManager* aggregated_neighbour_manager, NetsukukuMapRoute* maproute);
NetsukukuPeerToPeerAll* netsukuku_peer_to_peer_all_construct (GType object_type, NetsukukuAggregatedNeighbourManager* aggregated_neighbour_manager, NetsukukuMapRoute* maproute);
static void netsukuku_peer_to_peer_all_set_aggregated_neighbour_manager (NetsukukuPeerToPeerAll* self, NetsukukuAggregatedNeighbourManager* value);
static void netsukuku_peer_to_peer_all_set_maproute (NetsukukuPeerToPeerAll* self, NetsukukuMapRoute* value);
NetsukukuPeerToPeer* netsukuku_peer_to_peer_all_pid_add (NetsukukuPeerToPeerAll* self, gint pid);
NetsukukuAggregatedNeighbourManager* netsukuku_peer_to_peer_all_get_aggregated_neighbour_manager (NetsukukuPeerToPeerAll* self);
NetsukukuMapRoute* netsukuku_peer_to_peer_all_get_maproute (NetsukukuPeerToPeerAll* self);
NetsukukuPeerToPeer* netsukuku_peer_to_peer_all_pid_get (NetsukukuPeerToPeerAll* self, gint pid);
void netsukuku_peer_to_peer_all_pid_del (NetsukukuPeerToPeerAll* self, gint pid);
void netsukuku_peer_to_peer_all_peer_to_peer_register (NetsukukuPeerToPeerAll* self, NetsukukuPeerToPeer* peer_to_peer, GError** error);
static void netsukuku_peer_to_peer_all_real_peer_to_peer_register (NetsukukuPeerToPeerAll* self, NetsukukuPeerToPeer* peer_to_peer, GError** error);
void netsukuku_log_error (const gchar* msg);
void netsukuku_peer_to_peer_all_leave_all_optional_peer_to_peer (NetsukukuPeerToPeerAll* self);
static gboolean netsukuku_peer_to_peer_all_not_impl_equal_func (GObject* a, GObject* b);
static NetsukukuSetOptionalServiceParticipants* netsukuku_peer_to_peer_all_real_get_optional_participants (NetsukukuIPeerToPeerAll* base, GError** error);
static gboolean _netsukuku_peer_to_peer_all_not_impl_equal_func_gee_equal_data_func (gconstpointer a, gconstpointer b, gpointer self);
void netsukuku_peer_to_peer_all_retrieve_optional_services_and_participants (NetsukukuPeerToPeerAll* self);
static gchar* netsukuku_peer_to_peer_all_log_services (NetsukukuPeerToPeerAll* self);
GeeList* netsukuku_aggregated_neighbour_manager_neighbour_list (NetsukukuAggregatedNeighbourManager* self, gboolean* in_my_network, NetsukukuNetworkID* with_this_netid);
static void netsukuku_peer_to_peer_all_impl_start_operations (NetsukukuPeerToPeerAll* self, GError** error);
static void* netsukuku_peer_to_peer_all_helper_start_operations (void* v, GError** error);
void netsukuku_peer_to_peer_all_start_operations (NetsukukuPeerToPeerAll* self);
void netsukuku_peer_to_peer_all_stop_operations (NetsukukuPeerToPeerAll* self);
static void netsukuku_peer_to_peer_all_finalize (GObject* obj);
static void _vala_netsukuku_peer_to_peer_all_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void _vala_netsukuku_peer_to_peer_all_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);


GQuark netsukuku_peer_to_peer_error_quark (void) {
	return g_quark_from_static_string ("netsukuku_peer_to_peer_error-quark");
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


void netsukuku_struct_helper_mappeertopeer_node_dead_copy (const Netsukukustruct_helper_MapPeerToPeer_node_dead* self, Netsukukustruct_helper_MapPeerToPeer_node_dead* dest) {
	NetsukukuMapPeerToPeer* _tmp0_;
	NetsukukuMapPeerToPeer* _tmp1_;
	gint _tmp2_;
	gint _tmp3_;
	_tmp0_ = (*self).self;
	_tmp1_ = _g_object_ref0 (_tmp0_);
	_g_object_unref0 ((*dest).self);
	(*dest).self = _tmp1_;
	_tmp2_ = (*self).lvl;
	(*dest).lvl = _tmp2_;
	_tmp3_ = (*self).pos;
	(*dest).pos = _tmp3_;
}


void netsukuku_struct_helper_mappeertopeer_node_dead_destroy (Netsukukustruct_helper_MapPeerToPeer_node_dead* self) {
	_g_object_unref0 ((*self).self);
}


Netsukukustruct_helper_MapPeerToPeer_node_dead* netsukuku_struct_helper_mappeertopeer_node_dead_dup (const Netsukukustruct_helper_MapPeerToPeer_node_dead* self) {
	Netsukukustruct_helper_MapPeerToPeer_node_dead* dup;
	dup = g_new0 (Netsukukustruct_helper_MapPeerToPeer_node_dead, 1);
	netsukuku_struct_helper_mappeertopeer_node_dead_copy (self, dup);
	return dup;
}


void netsukuku_struct_helper_mappeertopeer_node_dead_free (Netsukukustruct_helper_MapPeerToPeer_node_dead* self) {
	netsukuku_struct_helper_mappeertopeer_node_dead_destroy (self);
	g_free (self);
}


GType netsukuku_struct_helper_mappeertopeer_node_dead_get_type (void) {
	static volatile gsize netsukuku_struct_helper_mappeertopeer_node_dead_type_id__volatile = 0;
	if (g_once_init_enter (&netsukuku_struct_helper_mappeertopeer_node_dead_type_id__volatile)) {
		GType netsukuku_struct_helper_mappeertopeer_node_dead_type_id;
		netsukuku_struct_helper_mappeertopeer_node_dead_type_id = g_boxed_type_register_static ("Netsukukustruct_helper_MapPeerToPeer_node_dead", (GBoxedCopyFunc) netsukuku_struct_helper_mappeertopeer_node_dead_dup, (GBoxedFreeFunc) netsukuku_struct_helper_mappeertopeer_node_dead_free);
		g_once_init_leave (&netsukuku_struct_helper_mappeertopeer_node_dead_type_id__volatile, netsukuku_struct_helper_mappeertopeer_node_dead_type_id);
	}
	return netsukuku_struct_helper_mappeertopeer_node_dead_type_id__volatile;
}


/** levels, gsize, me: the same of Map
          * pid: PeerToPeer id of the service associated to this map
          */
NetsukukuMapPeerToPeer* netsukuku_map_peer_to_peer_construct (GType object_type, gint levels, gint gsize, NetsukukuNIP* me, gint pid) {
	NetsukukuMapPeerToPeer * self = NULL;
	gint _tmp0_;
	gint _tmp1_;
	NetsukukuNIP* _tmp2_;
	gint _tmp22_;
	g_return_val_if_fail (me != NULL, NULL);
	_tmp0_ = levels;
	_tmp1_ = gsize;
	_tmp2_ = me;
	self = (NetsukukuMapPeerToPeer*) netsukuku_map_construct (object_type, NETSUKUKU_TYPE_PARTICIPANT_NODE, (GBoxedCopyFunc) g_object_ref, g_object_unref, _tmp0_, _tmp1_, _tmp2_);
	{
		gint lvl;
		lvl = 0;
		{
			gboolean _tmp3_;
			_tmp3_ = TRUE;
			while (TRUE) {
				gboolean _tmp4_;
				gint _tmp6_;
				gint _tmp7_;
				_tmp4_ = _tmp3_;
				if (!_tmp4_) {
					gint _tmp5_;
					_tmp5_ = lvl;
					lvl = _tmp5_ + 1;
				}
				_tmp3_ = FALSE;
				_tmp6_ = lvl;
				_tmp7_ = levels;
				if (!(_tmp6_ < _tmp7_)) {
					break;
				}
				{
					gint pos;
					pos = 0;
					{
						gboolean _tmp8_;
						_tmp8_ = TRUE;
						while (TRUE) {
							gboolean _tmp9_;
							gint _tmp11_;
							gint _tmp12_;
							NetsukukuNIP* _tmp13_;
							gint _tmp14_;
							gint _tmp15_ = 0;
							gint _tmp16_;
							_tmp9_ = _tmp8_;
							if (!_tmp9_) {
								gint _tmp10_;
								_tmp10_ = pos;
								pos = _tmp10_ + 1;
							}
							_tmp8_ = FALSE;
							_tmp11_ = pos;
							_tmp12_ = gsize;
							if (!(_tmp11_ < _tmp12_)) {
								break;
							}
							_tmp13_ = me;
							_tmp14_ = lvl;
							_tmp15_ = netsukuku_partial_nip_position_at ((NetsukukuPartialNIP*) _tmp13_, _tmp14_);
							_tmp16_ = pos;
							if (_tmp15_ != _tmp16_) {
								NetsukukuDataClass** _tmp17_;
								gint _tmp17__length1;
								gint _tmp17__length2;
								gint _tmp18_;
								gint _tmp19_;
								NetsukukuParticipantNode* _tmp20_;
								NetsukukuDataClass* _tmp21_;
								_tmp17_ = ((NetsukukuMap*) self)->node;
								_tmp17__length1 = ((NetsukukuMap*) self)->node_length1;
								_tmp17__length2 = ((NetsukukuMap*) self)->node_length2;
								_tmp18_ = lvl;
								_tmp19_ = pos;
								_tmp20_ = netsukuku_participant_node_new (FALSE, NULL);
								_g_object_unref0 (_tmp17_[(_tmp18_ * _tmp17__length2) + _tmp19_]);
								_tmp17_[(_tmp18_ * _tmp17__length2) + _tmp19_] = (NetsukukuDataClass*) _tmp20_;
								_tmp21_ = _tmp17_[(_tmp18_ * _tmp17__length2) + _tmp19_];
							}
						}
					}
				}
			}
		}
	}
	_tmp22_ = pid;
	self->priv->pid = _tmp22_;
	self->priv->participant = FALSE;
	return self;
}


NetsukukuMapPeerToPeer* netsukuku_map_peer_to_peer_new (gint levels, gint gsize, NetsukukuNIP* me, gint pid) {
	return netsukuku_map_peer_to_peer_construct (NETSUKUKU_TYPE_MAP_PEER_TO_PEER, levels, gsize, me, pid);
}


/** Initialize map from a neighbour's data.
          */
void netsukuku_map_peer_to_peer_initialize_from_neighbour (NetsukukuMapPeerToPeer* self, NetsukukuNIP* nip, NetsukukuPackedParticipantNodes* packed_nodes) {
	NetsukukuNIP* _tmp0_;
	gint _tmp1_ = 0;
	gint* _tmp2_ = NULL;
	gint* _tmp3_;
	gint _tmp3__length1;
	gint _tmp4_ = 0;
	gint _tmp5_;
	gint lvl;
	g_return_if_fail (self != NULL);
	g_return_if_fail (nip != NULL);
	g_return_if_fail (packed_nodes != NULL);
	_tmp0_ = nip;
	_tmp2_ = netsukuku_partial_nip_get_positions ((NetsukukuPartialNIP*) _tmp0_, &_tmp1_);
	_tmp3_ = _tmp2_;
	_tmp3__length1 = _tmp1_;
	_tmp4_ = netsukuku_map_nip_cmp ((NetsukukuMap*) self, _tmp3_, _tmp1_);
	_tmp5_ = _tmp4_;
	_tmp3_ = (g_free (_tmp3_), NULL);
	lvl = _tmp5_;
	{
		gint _tmp6_;
		gint l;
		_tmp6_ = lvl;
		l = _tmp6_;
		{
			gboolean _tmp7_;
			_tmp7_ = TRUE;
			while (TRUE) {
				gboolean _tmp8_;
				gint _tmp10_;
				gint _tmp11_;
				gint _tmp12_;
				_tmp8_ = _tmp7_;
				if (!_tmp8_) {
					gint _tmp9_;
					_tmp9_ = l;
					l = _tmp9_ + 1;
				}
				_tmp7_ = FALSE;
				_tmp10_ = l;
				_tmp11_ = netsukuku_map_get_levels ((NetsukukuMap*) self);
				_tmp12_ = _tmp11_;
				if (!(_tmp10_ < _tmp12_)) {
					break;
				}
				{
					gint pos;
					pos = 0;
					{
						gboolean _tmp13_;
						_tmp13_ = TRUE;
						while (TRUE) {
							gboolean _tmp14_;
							gint _tmp16_;
							gint _tmp17_;
							gint _tmp18_;
							NetsukukuNIP* _tmp19_;
							NetsukukuNIP* _tmp20_;
							gint _tmp21_;
							gint _tmp22_ = 0;
							gint _tmp23_;
							_tmp14_ = _tmp13_;
							if (!_tmp14_) {
								gint _tmp15_;
								_tmp15_ = pos;
								pos = _tmp15_ + 1;
							}
							_tmp13_ = FALSE;
							_tmp16_ = pos;
							_tmp17_ = netsukuku_map_get_gsize ((NetsukukuMap*) self);
							_tmp18_ = _tmp17_;
							if (!(_tmp16_ < _tmp18_)) {
								break;
							}
							_tmp19_ = netsukuku_map_get_me ((NetsukukuMap*) self);
							_tmp20_ = _tmp19_;
							_tmp21_ = l;
							_tmp22_ = netsukuku_partial_nip_position_at ((NetsukukuPartialNIP*) _tmp20_, _tmp21_);
							_tmp23_ = pos;
							if (_tmp22_ != _tmp23_) {
								NetsukukuDataClass** _tmp24_;
								gint _tmp24__length1;
								gint _tmp24__length2;
								gint _tmp25_;
								gint _tmp26_;
								NetsukukuPackedParticipantNodes* _tmp27_;
								GeeArrayList* _tmp28_;
								gint _tmp29_;
								gpointer _tmp30_ = NULL;
								GeeArrayList* _tmp31_;
								gint _tmp32_;
								gpointer _tmp33_ = NULL;
								NetsukukuDataClass* _tmp34_;
								_tmp24_ = ((NetsukukuMap*) self)->node;
								_tmp24__length1 = ((NetsukukuMap*) self)->node_length1;
								_tmp24__length2 = ((NetsukukuMap*) self)->node_length2;
								_tmp25_ = l;
								_tmp26_ = pos;
								_tmp27_ = packed_nodes;
								_tmp28_ = _tmp27_->packednodes;
								_tmp29_ = l;
								_tmp30_ = gee_abstract_list_get ((GeeAbstractList*) _tmp28_, _tmp29_);
								_tmp31_ = (GeeArrayList*) _tmp30_;
								_tmp32_ = pos;
								_tmp33_ = gee_abstract_list_get ((GeeAbstractList*) _tmp31_, _tmp32_);
								_g_object_unref0 (_tmp24_[(_tmp25_ * _tmp24__length2) + _tmp26_]);
								_tmp24_[(_tmp25_ * _tmp24__length2) + _tmp26_] = (NetsukukuDataClass*) ((NetsukukuParticipantNode*) _tmp33_);
								_tmp34_ = _tmp24_[(_tmp25_ * _tmp24__length2) + _tmp26_];
								_g_object_unref0 (_tmp31_);
							}
						}
					}
				}
			}
		}
	}
}


/** A new instance is created for a position that represents me. Otherwise, the usual behaviour.
          */
static NetsukukuParticipantNode* netsukuku_map_peer_to_peer_real_node_get (NetsukukuMap* base, gint lvl, gint pos) {
	NetsukukuMapPeerToPeer * self;
	NetsukukuParticipantNode* result = NULL;
	NetsukukuNIP* _tmp0_;
	NetsukukuNIP* _tmp1_;
	gint _tmp2_;
	gint _tmp3_ = 0;
	gint _tmp4_;
	self = (NetsukukuMapPeerToPeer*) base;
	_tmp0_ = netsukuku_map_get_me ((NetsukukuMap*) self);
	_tmp1_ = _tmp0_;
	_tmp2_ = lvl;
	_tmp3_ = netsukuku_partial_nip_position_at ((NetsukukuPartialNIP*) _tmp1_, _tmp2_);
	_tmp4_ = pos;
	if (_tmp3_ == _tmp4_) {
		gboolean _tmp5_;
		_tmp5_ = self->priv->participant;
		if (_tmp5_) {
			NetsukukuTimeCapsule* _tmp6_;
			NetsukukuTimeCapsule* _tmp7_;
			NetsukukuParticipantNode* _tmp8_;
			NetsukukuParticipantNode* _tmp9_;
			_tmp6_ = netsukuku_time_capsule_new ((gint64) 0);
			_tmp7_ = _tmp6_;
			_tmp8_ = netsukuku_participant_node_new (TRUE, _tmp7_);
			_tmp9_ = _tmp8_;
			_g_object_unref0 (_tmp7_);
			result = _tmp9_;
			return result;
		} else {
			gint _tmp10_;
			_tmp10_ = lvl;
			if (_tmp10_ == 0) {
				NetsukukuTimeCapsule* _tmp11_;
				NetsukukuTimeCapsule* _tmp12_;
				NetsukukuParticipantNode* _tmp13_;
				NetsukukuParticipantNode* _tmp14_;
				_tmp11_ = netsukuku_time_capsule_new ((gint64) 0);
				_tmp12_ = _tmp11_;
				_tmp13_ = netsukuku_participant_node_new (FALSE, _tmp12_);
				_tmp14_ = _tmp13_;
				_g_object_unref0 (_tmp12_);
				result = _tmp14_;
				return result;
			} else {
				NetsukukuTimeCapsule* _tmp31_;
				NetsukukuTimeCapsule* _tmp32_;
				NetsukukuParticipantNode* _tmp33_;
				NetsukukuParticipantNode* _tmp34_;
				{
					gint pos2;
					pos2 = 0;
					{
						gboolean _tmp15_;
						_tmp15_ = TRUE;
						while (TRUE) {
							gboolean _tmp16_;
							gint _tmp18_;
							gint _tmp19_;
							gint _tmp20_;
							gint _tmp21_;
							gint _tmp22_;
							gpointer _tmp23_ = NULL;
							NetsukukuParticipantNode* _tmp24_;
							gboolean _tmp25_;
							gboolean _tmp26_;
							_tmp16_ = _tmp15_;
							if (!_tmp16_) {
								gint _tmp17_;
								_tmp17_ = pos2;
								pos2 = _tmp17_ + 1;
							}
							_tmp15_ = FALSE;
							_tmp18_ = pos2;
							_tmp19_ = netsukuku_map_get_gsize ((NetsukukuMap*) self);
							_tmp20_ = _tmp19_;
							if (!(_tmp18_ < _tmp20_)) {
								break;
							}
							_tmp21_ = lvl;
							_tmp22_ = pos2;
							_tmp23_ = netsukuku_map_node_get ((NetsukukuMap*) self, _tmp21_ - 1, _tmp22_);
							_tmp24_ = (NetsukukuParticipantNode*) _tmp23_;
							_tmp25_ = _tmp24_->participant;
							_tmp26_ = _tmp25_;
							_g_object_unref0 (_tmp24_);
							if (_tmp26_) {
								NetsukukuTimeCapsule* _tmp27_;
								NetsukukuTimeCapsule* _tmp28_;
								NetsukukuParticipantNode* _tmp29_;
								NetsukukuParticipantNode* _tmp30_;
								_tmp27_ = netsukuku_time_capsule_new ((gint64) 0);
								_tmp28_ = _tmp27_;
								_tmp29_ = netsukuku_participant_node_new (TRUE, _tmp28_);
								_tmp30_ = _tmp29_;
								_g_object_unref0 (_tmp28_);
								result = _tmp30_;
								return result;
							}
						}
					}
				}
				_tmp31_ = netsukuku_time_capsule_new ((gint64) 0);
				_tmp32_ = _tmp31_;
				_tmp33_ = netsukuku_participant_node_new (FALSE, _tmp32_);
				_tmp34_ = _tmp33_;
				_g_object_unref0 (_tmp32_);
				result = _tmp34_;
				return result;
			}
		}
	} else {
		gint _tmp35_;
		gint _tmp36_;
		gpointer _tmp37_ = NULL;
		_tmp35_ = lvl;
		_tmp36_ = pos;
		_tmp37_ = NETSUKUKU_MAP_CLASS (netsukuku_map_peer_to_peer_parent_class)->node_get (G_TYPE_CHECK_INSTANCE_CAST (self, NETSUKUKU_TYPE_MAP, NetsukukuMap), _tmp35_, _tmp36_);
		result = (NetsukukuParticipantNode*) _tmp37_;
		return result;
	}
}


static void netsukuku_map_peer_to_peer_impl_node_dead (NetsukukuMapPeerToPeer* self, gint lvl, gint pos, GError** error) {
	NetsukukuDataClass** _tmp0_;
	gint _tmp0__length1;
	gint _tmp0__length2;
	gint _tmp1_;
	gint _tmp2_;
	NetsukukuParticipantNode* _tmp3_;
	NetsukukuDataClass* _tmp4_;
	gint _tmp5_;
	gint _tmp6_;
	g_return_if_fail (self != NULL);
	tasklets_tasklet_declare_self ("MapPeerToPeer.node_dead");
	_tmp0_ = ((NetsukukuMap*) self)->node;
	_tmp0__length1 = ((NetsukukuMap*) self)->node_length1;
	_tmp0__length2 = ((NetsukukuMap*) self)->node_length2;
	_tmp1_ = lvl;
	_tmp2_ = pos;
	_tmp3_ = netsukuku_participant_node_new (FALSE, NULL);
	_g_object_unref0 (_tmp0_[(_tmp1_ * _tmp0__length2) + _tmp2_]);
	_tmp0_[(_tmp1_ * _tmp0__length2) + _tmp2_] = (NetsukukuDataClass*) _tmp3_;
	_tmp4_ = _tmp0_[(_tmp1_ * _tmp0__length2) + _tmp2_];
	_tmp5_ = lvl;
	_tmp6_ = pos;
	netsukuku_map_check_node ((NetsukukuMap*) self, _tmp5_, _tmp6_);
}


static void* netsukuku_map_peer_to_peer_helper_node_dead (void* v, GError** error) {
	void* result = NULL;
	void* _tmp0_;
	Netsukukustruct_helper_MapPeerToPeer_node_dead* tuple_p;
	NetsukukuMapPeerToPeer* _tmp1_;
	NetsukukuMapPeerToPeer* _tmp2_;
	NetsukukuMapPeerToPeer* self_save;
	gint _tmp3_;
	gint lvl_save;
	gint _tmp4_;
	gint pos_save;
	GError * _inner_error_ = NULL;
	_tmp0_ = v;
	tuple_p = (Netsukukustruct_helper_MapPeerToPeer_node_dead*) _tmp0_;
	_tmp1_ = (*tuple_p).self;
	_tmp2_ = _g_object_ref0 (_tmp1_);
	self_save = _tmp2_;
	_tmp3_ = (*tuple_p).lvl;
	lvl_save = _tmp3_;
	_tmp4_ = (*tuple_p).pos;
	pos_save = _tmp4_;
	tasklets_tasklet_schedule_back ();
	netsukuku_map_peer_to_peer_impl_node_dead (self_save, lvl_save, pos_save, &_inner_error_);
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		_g_object_unref0 (self_save);
		return NULL;
	}
	result = NULL;
	_g_object_unref0 (self_save);
	return result;
}


void netsukuku_map_peer_to_peer_node_dead (NetsukukuMapPeerToPeer* self, gint lvl, gint pos) {
	Netsukukustruct_helper_MapPeerToPeer_node_dead arg = {0};
	NetsukukuMapPeerToPeer* _tmp0_;
	gint _tmp1_;
	gint _tmp2_;
	TaskletsTasklet* _tmp3_ = NULL;
	TaskletsTasklet* _tmp4_;
	g_return_if_fail (self != NULL);
	memset (&arg, 0, sizeof (Netsukukustruct_helper_MapPeerToPeer_node_dead));
	_tmp0_ = _g_object_ref0 (self);
	_g_object_unref0 (arg.self);
	arg.self = _tmp0_;
	_tmp1_ = lvl;
	arg.lvl = _tmp1_;
	_tmp2_ = pos;
	arg.pos = _tmp2_;
	_tmp3_ = tasklets_tasklet_spawn ((FunctionDelegate) netsukuku_map_peer_to_peer_helper_node_dead, &arg, FALSE, -1);
	_tmp4_ = _tmp3_;
	_g_object_unref0 (_tmp4_);
	netsukuku_struct_helper_mappeertopeer_node_dead_destroy (&arg);
}


/** Set me to be a participant node.
          */
void netsukuku_map_peer_to_peer_participate (NetsukukuMapPeerToPeer* self) {
	g_return_if_fail (self != NULL);
	self->priv->participant = TRUE;
}


/** Set me to be a non-participant node.
          */
void netsukuku_map_peer_to_peer_sit_out (NetsukukuMapPeerToPeer* self) {
	g_return_if_fail (self != NULL);
	self->priv->participant = FALSE;
}


static gboolean netsukuku_map_peer_to_peer_not_impl_equal_func (GObject* a, GObject* b) {
	gboolean result = FALSE;
	g_error ("peer_to_peer.vala:153: MapPeerToPeer.get_packed_nodes: equal_func not " \
"implemented");
	return result;
}


/** Prepares a packed map_peer_to_peer to be passed to refresh participations
          */
static gboolean _netsukuku_map_peer_to_peer_not_impl_equal_func_gee_equal_data_func (gconstpointer a, gconstpointer b, gpointer self) {
	gboolean result;
	result = netsukuku_map_peer_to_peer_not_impl_equal_func (a, b);
	return result;
}


NetsukukuPackedParticipantNodes* netsukuku_map_peer_to_peer_get_packed_nodes (NetsukukuMapPeerToPeer* self) {
	NetsukukuPackedParticipantNodes* result = NULL;
	GeeArrayList* _tmp0_;
	GeeArrayList* l1;
	GeeArrayList* _tmp21_;
	NetsukukuPackedParticipantNodes* _tmp22_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = gee_array_list_new (GEE_TYPE_ARRAY_LIST, (GBoxedCopyFunc) g_object_ref, g_object_unref, _netsukuku_map_peer_to_peer_not_impl_equal_func_gee_equal_data_func, NULL, NULL);
	l1 = _tmp0_;
	{
		gint lvl;
		lvl = 0;
		{
			gboolean _tmp1_;
			_tmp1_ = TRUE;
			while (TRUE) {
				gboolean _tmp2_;
				gint _tmp4_;
				gint _tmp5_;
				gint _tmp6_;
				GeeArrayList* _tmp7_;
				GeeArrayList* l0;
				GeeArrayList* _tmp19_;
				GeeArrayList* _tmp20_;
				_tmp2_ = _tmp1_;
				if (!_tmp2_) {
					gint _tmp3_;
					_tmp3_ = lvl;
					lvl = _tmp3_ + 1;
				}
				_tmp1_ = FALSE;
				_tmp4_ = lvl;
				_tmp5_ = netsukuku_map_get_levels ((NetsukukuMap*) self);
				_tmp6_ = _tmp5_;
				if (!(_tmp4_ < _tmp6_)) {
					break;
				}
				_tmp7_ = gee_array_list_new (NETSUKUKU_TYPE_PARTICIPANT_NODE, (GBoxedCopyFunc) g_object_ref, g_object_unref, NULL, NULL, NULL);
				l0 = _tmp7_;
				{
					gint pos;
					pos = 0;
					{
						gboolean _tmp8_;
						_tmp8_ = TRUE;
						while (TRUE) {
							gboolean _tmp9_;
							gint _tmp11_;
							gint _tmp12_;
							gint _tmp13_;
							GeeArrayList* _tmp14_;
							gint _tmp15_;
							gint _tmp16_;
							gpointer _tmp17_ = NULL;
							NetsukukuParticipantNode* _tmp18_;
							_tmp9_ = _tmp8_;
							if (!_tmp9_) {
								gint _tmp10_;
								_tmp10_ = pos;
								pos = _tmp10_ + 1;
							}
							_tmp8_ = FALSE;
							_tmp11_ = pos;
							_tmp12_ = netsukuku_map_get_gsize ((NetsukukuMap*) self);
							_tmp13_ = _tmp12_;
							if (!(_tmp11_ < _tmp13_)) {
								break;
							}
							_tmp14_ = l0;
							_tmp15_ = lvl;
							_tmp16_ = pos;
							_tmp17_ = netsukuku_map_node_get ((NetsukukuMap*) self, _tmp15_, _tmp16_);
							_tmp18_ = (NetsukukuParticipantNode*) _tmp17_;
							gee_abstract_collection_add ((GeeAbstractCollection*) _tmp14_, _tmp18_);
							_g_object_unref0 (_tmp18_);
						}
					}
				}
				_tmp19_ = l1;
				_tmp20_ = l0;
				gee_abstract_collection_add ((GeeAbstractCollection*) _tmp19_, _tmp20_);
				_g_object_unref0 (l0);
			}
		}
	}
	_tmp21_ = l1;
	_tmp22_ = netsukuku_packed_participant_nodes_new ((GeeList*) _tmp21_);
	result = _tmp22_;
	_g_object_unref0 (l1);
	return result;
}


gchar* netsukuku_map_peer_to_peer_log_service (NetsukukuMapPeerToPeer* self) {
	gchar* result = NULL;
	gchar* _tmp0_;
	gchar* ret;
	const gchar* _tmp30_;
	gchar* _tmp31_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = g_strdup ("{");
	ret = _tmp0_;
	{
		gint lvl;
		lvl = 0;
		{
			gboolean _tmp1_;
			_tmp1_ = TRUE;
			while (TRUE) {
				gboolean _tmp2_;
				gint _tmp4_;
				gint _tmp5_;
				gint _tmp6_;
				gint tot;
				const gchar* _tmp20_;
				gint _tmp21_;
				gchar* _tmp22_ = NULL;
				gchar* _tmp23_;
				gint _tmp24_;
				gchar* _tmp25_ = NULL;
				gchar* _tmp26_;
				gchar* _tmp27_ = NULL;
				gchar* _tmp28_;
				gchar* _tmp29_;
				_tmp2_ = _tmp1_;
				if (!_tmp2_) {
					gint _tmp3_;
					_tmp3_ = lvl;
					lvl = _tmp3_ + 1;
				}
				_tmp1_ = FALSE;
				_tmp4_ = lvl;
				_tmp5_ = netsukuku_map_get_levels ((NetsukukuMap*) self);
				_tmp6_ = _tmp5_;
				if (!(_tmp4_ < _tmp6_)) {
					break;
				}
				tot = 0;
				{
					gint i;
					i = 0;
					{
						gboolean _tmp7_;
						_tmp7_ = TRUE;
						while (TRUE) {
							gboolean _tmp8_;
							gint _tmp10_;
							gint _tmp11_;
							gint _tmp12_;
							gint _tmp13_;
							gint _tmp14_;
							gpointer _tmp15_ = NULL;
							NetsukukuParticipantNode* _tmp16_;
							gboolean _tmp17_;
							gboolean _tmp18_;
							_tmp8_ = _tmp7_;
							if (!_tmp8_) {
								gint _tmp9_;
								_tmp9_ = i;
								i = _tmp9_ + 1;
							}
							_tmp7_ = FALSE;
							_tmp10_ = i;
							_tmp11_ = netsukuku_map_get_gsize ((NetsukukuMap*) self);
							_tmp12_ = _tmp11_;
							if (!(_tmp10_ < _tmp12_)) {
								break;
							}
							_tmp13_ = lvl;
							_tmp14_ = i;
							_tmp15_ = netsukuku_map_node_get ((NetsukukuMap*) self, _tmp13_, _tmp14_);
							_tmp16_ = (NetsukukuParticipantNode*) _tmp15_;
							_tmp17_ = _tmp16_->participant;
							_tmp18_ = _tmp17_;
							_g_object_unref0 (_tmp16_);
							if (_tmp18_) {
								gint _tmp19_;
								_tmp19_ = tot;
								tot = _tmp19_ + 1;
							}
						}
					}
				}
				_tmp20_ = ret;
				_tmp21_ = tot;
				_tmp22_ = g_strdup_printf ("%i", _tmp21_);
				_tmp23_ = _tmp22_;
				_tmp24_ = lvl;
				_tmp25_ = g_strdup_printf ("%i", _tmp24_);
				_tmp26_ = _tmp25_;
				_tmp27_ = g_strconcat (_tmp23_, " at level ", _tmp26_, ", ", NULL);
				_tmp28_ = _tmp27_;
				_tmp29_ = g_strconcat (_tmp20_, _tmp28_, NULL);
				_g_free0 (ret);
				ret = _tmp29_;
				_g_free0 (_tmp28_);
				_g_free0 (_tmp26_);
				_g_free0 (_tmp23_);
			}
		}
	}
	_tmp30_ = ret;
	_tmp31_ = g_strconcat (_tmp30_, "}", NULL);
	_g_free0 (ret);
	ret = _tmp31_;
	result = ret;
	return result;
}


static void netsukuku_map_peer_to_peer_class_init (NetsukukuMapPeerToPeerClass * klass) {
	netsukuku_map_peer_to_peer_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (NetsukukuMapPeerToPeerPrivate));
	NETSUKUKU_MAP_CLASS (klass)->node_get = netsukuku_map_peer_to_peer_real_node_get;
	G_OBJECT_CLASS (klass)->finalize = netsukuku_map_peer_to_peer_finalize;
}


static void netsukuku_map_peer_to_peer_instance_init (NetsukukuMapPeerToPeer * self) {
	self->priv = NETSUKUKU_MAP_PEER_TO_PEER_GET_PRIVATE (self);
}


static void netsukuku_map_peer_to_peer_finalize (GObject* obj) {
	NetsukukuMapPeerToPeer * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, NETSUKUKU_TYPE_MAP_PEER_TO_PEER, NetsukukuMapPeerToPeer);
	G_OBJECT_CLASS (netsukuku_map_peer_to_peer_parent_class)->finalize (obj);
}


GType netsukuku_map_peer_to_peer_get_type (void) {
	static volatile gsize netsukuku_map_peer_to_peer_type_id__volatile = 0;
	if (g_once_init_enter (&netsukuku_map_peer_to_peer_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (NetsukukuMapPeerToPeerClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) netsukuku_map_peer_to_peer_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (NetsukukuMapPeerToPeer), 0, (GInstanceInitFunc) netsukuku_map_peer_to_peer_instance_init, NULL };
		GType netsukuku_map_peer_to_peer_type_id;
		netsukuku_map_peer_to_peer_type_id = g_type_register_static (NETSUKUKU_TYPE_MAP, "NetsukukuMapPeerToPeer", &g_define_type_info, 0);
		g_once_init_leave (&netsukuku_map_peer_to_peer_type_id__volatile, netsukuku_map_peer_to_peer_type_id);
	}
	return netsukuku_map_peer_to_peer_type_id__volatile;
}


NetsukukuPeerToPeer* netsukuku_peer_to_peer_construct (GType object_type, NetsukukuAggregatedNeighbourManager* aggregated_neighbour_manager, NetsukukuMapRoute* maproute, gint pid) {
	NetsukukuPeerToPeer * self = NULL;
	NetsukukuAggregatedNeighbourManager* _tmp0_;
	NetsukukuMapRoute* _tmp1_;
	gint _tmp2_;
	g_return_val_if_fail (aggregated_neighbour_manager != NULL, NULL);
	g_return_val_if_fail (maproute != NULL, NULL);
	self = (NetsukukuPeerToPeer*) zcd_rpc_dispatcher_construct (object_type);
	_tmp0_ = aggregated_neighbour_manager;
	self->aggregated_neighbour_manager = _tmp0_;
	_tmp1_ = maproute;
	self->maproute = _tmp1_;
	_tmp2_ = pid;
	self->pid = _tmp2_;
	self->has_valid_map = FALSE;
	return self;
}


NetsukukuPeerToPeer* netsukuku_peer_to_peer_new (NetsukukuAggregatedNeighbourManager* aggregated_neighbour_manager, NetsukukuMapRoute* maproute, gint pid) {
	return netsukuku_peer_to_peer_construct (NETSUKUKU_TYPE_PEER_TO_PEER, aggregated_neighbour_manager, maproute, pid);
}


/** Called after peer_to_peer_hook. Overridable (eg in OptionalPeerToPeer)
          */
static void netsukuku_peer_to_peer_real_start_operations (NetsukukuPeerToPeer* self) {
	self->has_valid_map = TRUE;
	g_signal_emit_by_name (self, "map-peer-to-peer-validated");
}


void netsukuku_peer_to_peer_start_operations (NetsukukuPeerToPeer* self) {
	g_return_if_fail (self != NULL);
	NETSUKUKU_PEER_TO_PEER_GET_CLASS (self)->start_operations (self);
}


/** Called when address is dying. Overridable (eg in OptionalPeerToPeer)
          */
static const gchar* string_to_string (const gchar* self) {
	const gchar* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	result = self;
	return result;
}


static void netsukuku_peer_to_peer_real_stop_operations (NetsukukuPeerToPeer* self) {
	NetsukukuMapRoute* _tmp0_;
	gint _tmp1_;
	gint _tmp2_;
	NetsukukuMapRoute* _tmp3_;
	gint _tmp4_;
	gint _tmp5_;
	NetsukukuMapRoute* _tmp6_;
	NetsukukuNIP* _tmp7_;
	NetsukukuNIP* _tmp8_;
	gchar* _tmp9_ = NULL;
	gchar* ipstr;
	const gchar* _tmp10_ = NULL;
	gchar* _tmp11_ = NULL;
	gchar* _tmp12_;
	_tmp0_ = self->maproute;
	_tmp1_ = netsukuku_map_get_levels ((NetsukukuMap*) _tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = self->maproute;
	_tmp4_ = netsukuku_map_get_gsize ((NetsukukuMap*) _tmp3_);
	_tmp5_ = _tmp4_;
	_tmp6_ = self->maproute;
	_tmp7_ = netsukuku_map_get_me ((NetsukukuMap*) _tmp6_);
	_tmp8_ = _tmp7_;
	_tmp9_ = netsukuku_nip_to_str (_tmp2_, _tmp5_, _tmp8_);
	ipstr = _tmp9_;
	_tmp10_ = string_to_string (ipstr);
	_tmp11_ = g_strconcat ("PeerToPeer: stopping operations for ", _tmp10_, NULL);
	_tmp12_ = _tmp11_;
	netsukuku_log_debug (_tmp12_);
	_g_free0 (_tmp12_);
	_g_free0 (ipstr);
}


void netsukuku_peer_to_peer_stop_operations (NetsukukuPeerToPeer* self) {
	g_return_if_fail (self != NULL);
	NETSUKUKU_PEER_TO_PEER_GET_CLASS (self)->stop_operations (self);
}


/** Returns True iff the node lvl,pos is participating
          * to the service. For a "strict PeerToPeer" it means iff the node
          * exists in maproute.
          * An inheriting class could override the function.
          */
static gboolean netsukuku_peer_to_peer_real_is_participant (NetsukukuPeerToPeer* self, gint lvl, gint pos) {
	gboolean result = FALSE;
	NetsukukuMapRoute* _tmp0_;
	gint _tmp1_;
	gint _tmp2_;
	gpointer _tmp3_ = NULL;
	NetsukukuRouteNode* x;
	gboolean _tmp4_ = FALSE;
	_tmp0_ = self->maproute;
	_tmp1_ = lvl;
	_tmp2_ = pos;
	_tmp3_ = netsukuku_map_node_get ((NetsukukuMap*) _tmp0_, _tmp1_, _tmp2_);
	x = (NetsukukuRouteNode*) _tmp3_;
	_tmp4_ = netsukuku_dataclass_is_free ((NetsukukuDataClass*) x);
	result = !_tmp4_;
	_g_object_unref0 (x);
	return result;
}


gboolean netsukuku_peer_to_peer_is_participant (NetsukukuPeerToPeer* self, gint lvl, gint pos) {
	g_return_val_if_fail (self != NULL, FALSE);
	return NETSUKUKU_PEER_TO_PEER_GET_CLASS (self)->is_participant (self, lvl, pos);
}


/** This is the function h:KEY-->hIP.
          *
          * You should override it with your own mapping function.
          */
static NetsukukuNIP* netsukuku_peer_to_peer_real_h (NetsukukuPeerToPeer* self, GObject* key) {
	NetsukukuNIP* result = NULL;
	GObject* _tmp0_;
	NetsukukuNIP* _tmp1_;
	g_return_val_if_fail (key != NULL, NULL);
	_tmp0_ = key;
	_tmp1_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, NETSUKUKU_TYPE_NIP, NetsukukuNIP));
	result = _tmp1_;
	return result;
}


NetsukukuNIP* netsukuku_peer_to_peer_h (NetsukukuPeerToPeer* self, GObject* key) {
	g_return_val_if_fail (self != NULL, NULL);
	return NETSUKUKU_PEER_TO_PEER_GET_CLASS (self)->h (self, key);
}


/** Returns the AggregatedNeighbour instances of the neighbours we can use to reach
          * the hash node, in order of efficiency.
          */
static gboolean _netsukuku_aggregated_neighbour_equal_func_gee_equal_data_func (gconstpointer a, gconstpointer b, gpointer self) {
	gboolean result;
	result = netsukuku_aggregated_neighbour_equal_func (a, b);
	return result;
}


GeeList* netsukuku_peer_to_peer_neighbours_get_from_lvl_pos (NetsukukuPeerToPeer* self, gint lvl, gint pos) {
	GeeList* result = NULL;
	NetsukukuMapRoute* _tmp0_;
	gint _tmp1_;
	gint _tmp2_;
	gpointer _tmp3_ = NULL;
	NetsukukuRouteNode* _tmp4_;
	GeeList* _tmp5_ = NULL;
	GeeList* _tmp6_;
	GeeList* routes;
	GeeArrayList* _tmp7_;
	GeeArrayList* ret;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->maproute;
	_tmp1_ = lvl;
	_tmp2_ = pos;
	_tmp3_ = netsukuku_map_node_get ((NetsukukuMap*) _tmp0_, _tmp1_, _tmp2_);
	_tmp4_ = (NetsukukuRouteNode*) _tmp3_;
	_tmp5_ = netsukuku_route_node_all_valid_routes (_tmp4_);
	_tmp6_ = _tmp5_;
	_g_object_unref0 (_tmp4_);
	routes = _tmp6_;
	_tmp7_ = gee_array_list_new (NETSUKUKU_TYPE_AGGREGATED_NEIGHBOUR, (GBoxedCopyFunc) g_object_ref, g_object_unref, _netsukuku_aggregated_neighbour_equal_func_gee_equal_data_func, NULL, NULL);
	ret = _tmp7_;
	{
		GeeList* _tmp8_;
		GeeList* _tmp9_;
		GeeList* _r_list;
		GeeList* _tmp10_;
		gint _tmp11_;
		gint _tmp12_;
		gint _r_size;
		gint _r_index;
		_tmp8_ = routes;
		_tmp9_ = _g_object_ref0 (_tmp8_);
		_r_list = _tmp9_;
		_tmp10_ = _r_list;
		_tmp11_ = gee_collection_get_size ((GeeCollection*) _tmp10_);
		_tmp12_ = _tmp11_;
		_r_size = _tmp12_;
		_r_index = -1;
		while (TRUE) {
			gint _tmp13_;
			gint _tmp14_;
			gint _tmp15_;
			GeeList* _tmp16_;
			gint _tmp17_;
			gpointer _tmp18_ = NULL;
			NetsukukuRoute* r;
			GeeArrayList* _tmp19_;
			NetsukukuRoute* _tmp20_;
			NetsukukuAggregatedNeighbour* _tmp21_;
			_tmp13_ = _r_index;
			_r_index = _tmp13_ + 1;
			_tmp14_ = _r_index;
			_tmp15_ = _r_size;
			if (!(_tmp14_ < _tmp15_)) {
				break;
			}
			_tmp16_ = _r_list;
			_tmp17_ = _r_index;
			_tmp18_ = gee_list_get (_tmp16_, _tmp17_);
			r = (NetsukukuRoute*) _tmp18_;
			_tmp19_ = ret;
			_tmp20_ = r;
			_tmp21_ = _tmp20_->gw;
			gee_abstract_collection_add ((GeeAbstractCollection*) _tmp19_, _tmp21_);
			_g_object_unref0 (r);
		}
		_g_object_unref0 (_r_list);
	}
	result = (GeeList*) ret;
	_g_object_unref0 (routes);
	return result;
}


GeeList* netsukuku_peer_to_peer_list_ids (NetsukukuPeerToPeer* self, gint center, gint sign) {
	GeeList* result = NULL;
	GeeArrayList* _tmp0_;
	GeeArrayList* ret;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = gee_array_list_new (G_TYPE_INT, NULL, NULL, NULL, NULL, NULL);
	ret = _tmp0_;
	{
		gint i;
		i = 0;
		{
			gboolean _tmp1_;
			_tmp1_ = TRUE;
			while (TRUE) {
				gboolean _tmp2_;
				gint _tmp4_;
				NetsukukuMapRoute* _tmp5_;
				gint _tmp6_;
				gint _tmp7_;
				GeeArrayList* _tmp8_;
				gint _tmp9_;
				NetsukukuMapRoute* _tmp10_;
				gint _tmp11_;
				gint _tmp12_;
				gint _tmp13_;
				gint _tmp14_;
				NetsukukuMapRoute* _tmp15_;
				gint _tmp16_;
				gint _tmp17_;
				_tmp2_ = _tmp1_;
				if (!_tmp2_) {
					gint _tmp3_;
					_tmp3_ = i;
					i = _tmp3_ + 1;
				}
				_tmp1_ = FALSE;
				_tmp4_ = i;
				_tmp5_ = self->maproute;
				_tmp6_ = netsukuku_map_get_gsize ((NetsukukuMap*) _tmp5_);
				_tmp7_ = _tmp6_;
				if (!(_tmp4_ < _tmp7_)) {
					break;
				}
				_tmp8_ = ret;
				_tmp9_ = center;
				_tmp10_ = self->maproute;
				_tmp11_ = netsukuku_map_get_gsize ((NetsukukuMap*) _tmp10_);
				_tmp12_ = _tmp11_;
				_tmp13_ = i;
				_tmp14_ = sign;
				_tmp15_ = self->maproute;
				_tmp16_ = netsukuku_map_get_gsize ((NetsukukuMap*) _tmp15_);
				_tmp17_ = _tmp16_;
				gee_abstract_collection_add ((GeeAbstractCollection*) _tmp8_, (gpointer) ((gintptr) (((_tmp9_ + _tmp12_) + (_tmp13_ * _tmp14_)) % _tmp17_)));
			}
		}
	}
	result = (GeeList*) ret;
	return result;
}


/** Returns the destination in hierarchical coordinates of the best
          *  approximation of the passed NIP as a participant to the service.
          * Returns null iff it's me.
          */
NetsukukuHCoord* netsukuku_peer_to_peer_search_participant (NetsukukuPeerToPeer* self, NetsukukuNIP* hIP, gint path_sign, GError** error) {
	NetsukukuHCoord* result = NULL;
	NetsukukuMapRoute* _tmp0_;
	gint _tmp1_;
	gint _tmp2_;
	gint* _tmp3_ = NULL;
	gint* H_hIP;
	gint H_hIP_length1;
	gint _H_hIP_size_;
	gint l = 0;
	gboolean found;
	gboolean _tmp54_;
	gint _tmp55_;
	gint* _tmp56_;
	gint _tmp56__length1;
	gint _tmp57_;
	gint _tmp58_;
	NetsukukuHCoord* _tmp59_;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (hIP != NULL, NULL);
	_tmp0_ = self->maproute;
	_tmp1_ = netsukuku_map_get_levels ((NetsukukuMap*) _tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = g_new0 (gint, _tmp2_);
	H_hIP = _tmp3_;
	H_hIP_length1 = _tmp2_;
	_H_hIP_size_ = H_hIP_length1;
	{
		gint i;
		i = 0;
		{
			gboolean _tmp4_;
			_tmp4_ = TRUE;
			while (TRUE) {
				gboolean _tmp5_;
				gint _tmp7_;
				NetsukukuMapRoute* _tmp8_;
				gint _tmp9_;
				gint _tmp10_;
				gint* _tmp11_;
				gint _tmp11__length1;
				gint _tmp12_;
				gint _tmp13_;
				_tmp5_ = _tmp4_;
				if (!_tmp5_) {
					gint _tmp6_;
					_tmp6_ = i;
					i = _tmp6_ + 1;
				}
				_tmp4_ = FALSE;
				_tmp7_ = i;
				_tmp8_ = self->maproute;
				_tmp9_ = netsukuku_map_get_levels ((NetsukukuMap*) _tmp8_);
				_tmp10_ = _tmp9_;
				if (!(_tmp7_ < _tmp10_)) {
					break;
				}
				_tmp11_ = H_hIP;
				_tmp11__length1 = H_hIP_length1;
				_tmp12_ = i;
				_tmp11_[_tmp12_] = -1;
				_tmp13_ = _tmp11_[_tmp12_];
			}
		}
	}
	found = FALSE;
	{
		NetsukukuMapRoute* _tmp14_;
		gint _tmp15_;
		gint _tmp16_;
		gboolean _tmp17_;
		_tmp14_ = self->maproute;
		_tmp15_ = netsukuku_map_get_levels ((NetsukukuMap*) _tmp14_);
		_tmp16_ = _tmp15_;
		l = _tmp16_ - 1;
		_tmp17_ = TRUE;
		while (TRUE) {
			gboolean _tmp18_;
			gint _tmp20_;
			gint* _tmp42_;
			gint _tmp42__length1;
			gint _tmp43_;
			gint _tmp44_;
			gint* _tmp46_;
			gint _tmp46__length1;
			gint _tmp47_;
			gint _tmp48_;
			NetsukukuMapRoute* _tmp49_;
			NetsukukuNIP* _tmp50_;
			NetsukukuNIP* _tmp51_;
			gint _tmp52_;
			gint _tmp53_ = 0;
			_tmp18_ = _tmp17_;
			if (!_tmp18_) {
				gint _tmp19_;
				_tmp19_ = l;
				l = _tmp19_ - 1;
			}
			_tmp17_ = FALSE;
			_tmp20_ = l;
			if (!(_tmp20_ >= 0)) {
				break;
			}
			{
				NetsukukuNIP* _tmp21_;
				gint _tmp22_;
				gint _tmp23_ = 0;
				gint _tmp24_;
				GeeList* _tmp25_ = NULL;
				GeeList* _hid_list;
				GeeList* _tmp26_;
				gint _tmp27_;
				gint _tmp28_;
				gint _hid_size;
				gint _hid_index;
				_tmp21_ = hIP;
				_tmp22_ = l;
				_tmp23_ = netsukuku_partial_nip_position_at ((NetsukukuPartialNIP*) _tmp21_, _tmp22_);
				_tmp24_ = path_sign;
				_tmp25_ = netsukuku_peer_to_peer_list_ids (self, _tmp23_, _tmp24_);
				_hid_list = _tmp25_;
				_tmp26_ = _hid_list;
				_tmp27_ = gee_collection_get_size ((GeeCollection*) _tmp26_);
				_tmp28_ = _tmp27_;
				_hid_size = _tmp28_;
				_hid_index = -1;
				while (TRUE) {
					gint _tmp29_;
					gint _tmp30_;
					gint _tmp31_;
					GeeList* _tmp32_;
					gint _tmp33_;
					gpointer _tmp34_ = NULL;
					gint hid;
					gint _tmp35_;
					gint _tmp36_;
					gboolean _tmp37_ = FALSE;
					_tmp29_ = _hid_index;
					_hid_index = _tmp29_ + 1;
					_tmp30_ = _hid_index;
					_tmp31_ = _hid_size;
					if (!(_tmp30_ < _tmp31_)) {
						break;
					}
					_tmp32_ = _hid_list;
					_tmp33_ = _hid_index;
					_tmp34_ = gee_list_get (_tmp32_, _tmp33_);
					hid = (gint) ((gintptr) _tmp34_);
					_tmp35_ = l;
					_tmp36_ = hid;
					_tmp37_ = netsukuku_peer_to_peer_is_participant (self, _tmp35_, _tmp36_);
					if (_tmp37_) {
						gint* _tmp38_;
						gint _tmp38__length1;
						gint _tmp39_;
						gint _tmp40_;
						gint _tmp41_;
						_tmp38_ = H_hIP;
						_tmp38__length1 = H_hIP_length1;
						_tmp39_ = l;
						_tmp40_ = hid;
						_tmp38_[_tmp39_] = _tmp40_;
						_tmp41_ = _tmp38_[_tmp39_];
						break;
					}
				}
				_g_object_unref0 (_hid_list);
			}
			_tmp42_ = H_hIP;
			_tmp42__length1 = H_hIP_length1;
			_tmp43_ = l;
			_tmp44_ = _tmp42_[_tmp43_];
			if (_tmp44_ == (-1)) {
				GError* _tmp45_;
				_tmp45_ = g_error_new_literal (NETSUKUKU_PEER_TO_PEER_ERROR, NETSUKUKU_PEER_TO_PEER_ERROR_GENERIC, "No participants.");
				_inner_error_ = _tmp45_;
				if (_inner_error_->domain == NETSUKUKU_PEER_TO_PEER_ERROR) {
					g_propagate_error (error, _inner_error_);
					H_hIP = (g_free (H_hIP), NULL);
					return NULL;
				} else {
					H_hIP = (g_free (H_hIP), NULL);
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
					g_clear_error (&_inner_error_);
					return NULL;
				}
			}
			_tmp46_ = H_hIP;
			_tmp46__length1 = H_hIP_length1;
			_tmp47_ = l;
			_tmp48_ = _tmp46_[_tmp47_];
			_tmp49_ = self->maproute;
			_tmp50_ = netsukuku_map_get_me ((NetsukukuMap*) _tmp49_);
			_tmp51_ = _tmp50_;
			_tmp52_ = l;
			_tmp53_ = netsukuku_partial_nip_position_at ((NetsukukuPartialNIP*) _tmp51_, _tmp52_);
			if (_tmp48_ != _tmp53_) {
				found = TRUE;
				break;
			}
		}
	}
	_tmp54_ = found;
	if (!_tmp54_) {
		result = NULL;
		H_hIP = (g_free (H_hIP), NULL);
		return result;
	}
	_tmp55_ = l;
	_tmp56_ = H_hIP;
	_tmp56__length1 = H_hIP_length1;
	_tmp57_ = l;
	_tmp58_ = _tmp56_[_tmp57_];
	_tmp59_ = netsukuku_hcoord_new (_tmp55_, _tmp58_);
	result = _tmp59_;
	H_hIP = (g_free (H_hIP), NULL);
	return result;
}


NetsukukuPartialNIP* netsukuku_peer_to_peer_search_participant_as_nip (NetsukukuPeerToPeer* self, NetsukukuNIP* hIP, gint path_sign, GError** error) {
	NetsukukuPartialNIP* result = NULL;
	NetsukukuMapRoute* _tmp0_;
	NetsukukuNIP* _tmp1_;
	NetsukukuNIP* _tmp2_;
	gint _tmp3_ = 0;
	gint* _tmp4_ = NULL;
	gint* positions;
	gint positions_length1;
	gint _positions_size_;
	NetsukukuNIP* _tmp5_;
	gint _tmp6_;
	NetsukukuHCoord* _tmp7_ = NULL;
	NetsukukuHCoord* lvlpos;
	NetsukukuPartialNIP* _tmp22_;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (hIP != NULL, NULL);
	_tmp0_ = self->maproute;
	_tmp1_ = netsukuku_map_get_me ((NetsukukuMap*) _tmp0_);
	_tmp2_ = _tmp1_;
	_tmp4_ = netsukuku_partial_nip_get_positions ((NetsukukuPartialNIP*) _tmp2_, &_tmp3_);
	positions = _tmp4_;
	positions_length1 = _tmp3_;
	_positions_size_ = positions_length1;
	_tmp5_ = hIP;
	_tmp6_ = path_sign;
	_tmp7_ = netsukuku_peer_to_peer_search_participant (self, _tmp5_, _tmp6_, &_inner_error_);
	lvlpos = _tmp7_;
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == NETSUKUKU_PEER_TO_PEER_ERROR) {
			g_propagate_error (error, _inner_error_);
			positions = (g_free (positions), NULL);
			return NULL;
		} else {
			positions = (g_free (positions), NULL);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	}
	if (lvlpos != NULL) {
		gint _tmp8_;
		gint _tmp9_;
		gint lvl;
		gint _tmp10_;
		gint _tmp11_;
		gint pos;
		gint _tmp12_;
		gint _tmp13_;
		gint _tmp14_;
		_tmp8_ = netsukuku_hcoord_get_lvl (lvlpos);
		_tmp9_ = _tmp8_;
		lvl = _tmp9_;
		_tmp10_ = netsukuku_hcoord_get_pos (lvlpos);
		_tmp11_ = _tmp10_;
		pos = _tmp11_;
		_tmp12_ = lvl;
		_tmp13_ = pos;
		positions[_tmp12_] = _tmp13_;
		_tmp14_ = positions[_tmp12_];
		{
			gint _tmp15_;
			gint i;
			_tmp15_ = lvl;
			i = _tmp15_ - 1;
			{
				gboolean _tmp16_;
				_tmp16_ = TRUE;
				while (TRUE) {
					gboolean _tmp17_;
					gint _tmp19_;
					gint _tmp20_;
					gint _tmp21_;
					_tmp17_ = _tmp16_;
					if (!_tmp17_) {
						gint _tmp18_;
						_tmp18_ = i;
						i = _tmp18_ - 1;
					}
					_tmp16_ = FALSE;
					_tmp19_ = i;
					if (!(_tmp19_ >= 0)) {
						break;
					}
					_tmp20_ = i;
					positions[_tmp20_] = -1;
					_tmp21_ = positions[_tmp20_];
				}
			}
		}
	}
	_tmp22_ = netsukuku_partial_nip_new (positions, positions_length1);
	result = _tmp22_;
	_g_object_unref0 (lvlpos);
	positions = (g_free (positions), NULL);
	return result;
}


/** Start a tentative to send a message to a certain
          * perfect hip
          */
static gpointer _g_error_copy0 (gpointer self) {
	return self ? g_error_copy (self) : NULL;
}


static zcdISerializable* netsukuku_peer_to_peer_real_msg_send (NetsukukuIPeerToPeer* base, NetsukukuNIP* sender_nip, NetsukukuNIP* hip, zcdRemoteCall* data, GError** error) {
	NetsukukuPeerToPeer * self;
	zcdISerializable* result = NULL;
	NetsukukuPeerToPeerTracerPacketList* _tmp0_;
	NetsukukuPeerToPeerTracerPacketList* peer_to_peer_tpl;
	zcdISerializable* ret = NULL;
	GError * _inner_error_ = NULL;
	self = (NetsukukuPeerToPeer*) base;
	g_return_val_if_fail (sender_nip != NULL, NULL);
	g_return_val_if_fail (hip != NULL, NULL);
	g_return_val_if_fail (data != NULL, NULL);
	_tmp0_ = netsukuku_peer_to_peer_tracer_packet_list_new (120000);
	peer_to_peer_tpl = _tmp0_;
	while (TRUE) {
		{
			NetsukukuPeerToPeerTracerPacketList* _tmp1_;
			NetsukukuNIP* _tmp2_;
			NetsukukuNIP* _tmp3_;
			zcdRemoteCall* _tmp4_;
			zcdISerializable* _tmp5_ = NULL;
			zcdISerializable* _tmp6_;
			netsukuku_log_debug ("calling msg_deliver...");
			_tmp1_ = peer_to_peer_tpl;
			_tmp2_ = sender_nip;
			_tmp3_ = hip;
			_tmp4_ = data;
			_tmp5_ = netsukuku_ipeer_to_peer_msg_deliver ((NetsukukuIPeerToPeer*) self, _tmp1_, _tmp2_, _tmp3_, _tmp4_, &_inner_error_);
			_tmp6_ = _tmp5_;
			if (_inner_error_ != NULL) {
				if (_inner_error_->domain == ZCD_RPC_ERROR) {
					goto __catch94_zcd_rpc_error;
				}
				goto __finally94;
			}
			_g_object_unref0 (ret);
			ret = _tmp6_;
			break;
		}
		goto __finally94;
		__catch94_zcd_rpc_error:
		{
			GError* e = NULL;
			GError* _tmp7_;
			e = _inner_error_;
			_inner_error_ = NULL;
			_tmp7_ = e;
			if (g_error_matches (_tmp7_, ZCD_RPC_ERROR, ZCD_RPC_ERROR_NOT_VALID_MAP_YET)) {
				NetsukukuPeerToPeerTracerPacketList* _tmp8_;
				NetsukukuTimeCapsule* _tmp9_;
				gboolean _tmp10_ = FALSE;
				_tmp8_ = peer_to_peer_tpl;
				_tmp9_ = _tmp8_->tc;
				_tmp10_ = tasklets_timer_is_expired ((TaskletsTimer*) _tmp9_);
				if (_tmp10_) {
					GError* _tmp11_;
					GError* _tmp12_;
					netsukuku_log_warn ("PeerToPeer routing: Too long. Giving up.");
					_tmp11_ = e;
					_tmp12_ = _g_error_copy0 (_tmp11_);
					_inner_error_ = _tmp12_;
					_g_error_free0 (e);
					goto __finally94;
				} else {
					netsukuku_log_warn ("PeerToPeer routing: Temporary failure. Wait a bit and try again.");
					tasklets_ms_wait ((gint64) 1000);
				}
			} else {
				GError* _tmp13_;
				GError* _tmp14_;
				_tmp13_ = e;
				_tmp14_ = _g_error_copy0 (_tmp13_);
				_inner_error_ = _tmp14_;
				_g_error_free0 (e);
				goto __finally94;
			}
			_g_error_free0 (e);
		}
		__finally94:
		if (_inner_error_ != NULL) {
			g_propagate_error (error, _inner_error_);
			_g_object_unref0 (ret);
			_g_object_unref0 (peer_to_peer_tpl);
			return NULL;
		}
	}
	result = ret;
	_g_object_unref0 (peer_to_peer_tpl);
	return result;
}


/** Avoid loops, neverending stories, and the like.
          *
          * When a message is routed through the net by the peer_to_peer module,
          * we keep track of the path walked, through an instance of PeerToPeerTracerPacketList.
          * There are several functions in module peer_to_peer that try to
          * route messages, such as msg_deliver, find_nearest,
          * number_of_participants, and so on. Each function receives
          * as a parameter a PeerToPeerTracerPacketList instance,
          * calls this method execute (passing its own maproute)
          * and then passes it to the next hop.
          * The first caller instantiate it by passing no parameters or
          * can specify the timeout.
          */
static gboolean netsukuku_peer_to_peer_not_impl_equal_func (GObject* a, GObject* b) {
	gboolean result = FALSE;
	g_error ("peer_to_peer.vala:405: PeerToPeerTracerPacketList: equal_func not impl" \
"emented");
	return result;
}


static gboolean _netsukuku_peer_to_peer_not_impl_equal_func_gee_equal_data_func (gconstpointer a, gconstpointer b, gpointer self) {
	gboolean result;
	result = netsukuku_peer_to_peer_not_impl_equal_func (a, b);
	return result;
}


void netsukuku_peer_to_peer_execute (NetsukukuMapRoute* maproute, NetsukukuPeerToPeerTracerPacketList* ptptpl, GError** error) {
	NetsukukuPeerToPeerTracerPacketList* _tmp0_;
	gchar* _tmp1_ = NULL;
	gchar* _tmp2_;
	gchar* _tmp3_ = NULL;
	gchar* _tmp4_;
	NetsukukuPeerToPeerTracerPacketList* _tmp5_;
	NetsukukuTimeCapsule* _tmp6_;
	gboolean _tmp7_ = FALSE;
	NetsukukuPeerToPeerTracerPacketList* _tmp9_;
	GeeArrayList* _tmp10_;
	NetsukukuPeerToPeerTracerPacketList* _tmp116_;
	gchar* _tmp117_ = NULL;
	gchar* _tmp118_;
	gchar* _tmp119_ = NULL;
	gchar* _tmp120_;
	GError * _inner_error_ = NULL;
	g_return_if_fail (maproute != NULL);
	g_return_if_fail (ptptpl != NULL);
	_tmp0_ = ptptpl;
	_tmp1_ = netsukuku_peer_to_peer_tracer_packet_list_to_string (_tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = g_strconcat ("PeerToPeerTracerPacketList: before pass: ", _tmp2_, NULL);
	_tmp4_ = _tmp3_;
	netsukuku_log_debug (_tmp4_);
	_g_free0 (_tmp4_);
	_g_free0 (_tmp2_);
	_tmp5_ = ptptpl;
	_tmp6_ = _tmp5_->tc;
	_tmp7_ = tasklets_timer_is_expired ((TaskletsTimer*) _tmp6_);
	if (_tmp7_) {
		GError* _tmp8_;
		_tmp8_ = g_error_new_literal (ZCD_RPC_ERROR, ZCD_RPC_ERROR_DROP, "PeerToPeer message timed out.");
		_inner_error_ = _tmp8_;
		if (_inner_error_->domain == ZCD_RPC_ERROR) {
			g_propagate_error (error, _inner_error_);
			return;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
	}
	_tmp9_ = ptptpl;
	_tmp10_ = _tmp9_->tpl;
	if (_tmp10_ == NULL) {
		NetsukukuPeerToPeerTracerPacketList* _tmp11_;
		GeeArrayList* _tmp12_;
		NetsukukuMapRoute* _tmp13_;
		NetsukukuNIP* _tmp14_;
		NetsukukuNIP* _tmp15_;
		gint _tmp16_ = 0;
		gint* _tmp17_ = NULL;
		_tmp11_ = ptptpl;
		_tmp12_ = gee_array_list_new (GEE_TYPE_ARRAY_LIST, (GBoxedCopyFunc) g_object_ref, g_object_unref, _netsukuku_peer_to_peer_not_impl_equal_func_gee_equal_data_func, NULL, NULL);
		_g_object_unref0 (_tmp11_->tpl);
		_tmp11_->tpl = _tmp12_;
		_tmp13_ = maproute;
		_tmp14_ = netsukuku_map_get_me ((NetsukukuMap*) _tmp13_);
		_tmp15_ = _tmp14_;
		_tmp17_ = netsukuku_partial_nip_get_positions ((NetsukukuPartialNIP*) _tmp15_, &_tmp16_);
		{
			gint* i_collection = NULL;
			gint i_collection_length1 = 0;
			gint _i_collection_size_ = 0;
			gint i_it = 0;
			i_collection = _tmp17_;
			i_collection_length1 = _tmp16_;
			for (i_it = 0; i_it < _tmp16_; i_it = i_it + 1) {
				gint i = 0;
				i = i_collection[i_it];
				{
					GeeArrayList* _tmp18_;
					GeeArrayList* tpl_1;
					GeeArrayList* _tmp19_;
					gint _tmp20_;
					NetsukukuPeerToPeerTracerPacketList* _tmp21_;
					GeeArrayList* _tmp22_;
					GeeArrayList* _tmp23_;
					_tmp18_ = gee_array_list_new (G_TYPE_INT, NULL, NULL, NULL, NULL, NULL);
					tpl_1 = _tmp18_;
					_tmp19_ = tpl_1;
					_tmp20_ = i;
					gee_abstract_collection_add ((GeeAbstractCollection*) _tmp19_, (gpointer) ((gintptr) _tmp20_));
					_tmp21_ = ptptpl;
					_tmp22_ = _tmp21_->tpl;
					_tmp23_ = tpl_1;
					gee_abstract_collection_add ((GeeAbstractCollection*) _tmp22_, _tmp23_);
					_g_object_unref0 (tpl_1);
				}
			}
			i_collection = (g_free (i_collection), NULL);
		}
	} else {
		NetsukukuPeerToPeerTracerPacketList* _tmp24_;
		GeeArrayList* _tmp25_;
		gint _tmp26_;
		gint _tmp27_;
		gint tplsize;
		NetsukukuPeerToPeerTracerPacketList* _tmp28_;
		GeeArrayList* _tmp29_;
		gint _tmp30_;
		gint _tmp31_;
		gint* _tmp32_ = NULL;
		gint* from_nip;
		gint from_nip_length1;
		gint _from_nip_size_;
		NetsukukuMapRoute* _tmp50_;
		gint* _tmp51_;
		gint _tmp51__length1;
		gint _tmp52_ = 0;
		gint last_lvl;
		gint _tmp53_;
		_tmp24_ = ptptpl;
		_tmp25_ = _tmp24_->tpl;
		_tmp26_ = gee_abstract_collection_get_size ((GeeCollection*) _tmp25_);
		_tmp27_ = _tmp26_;
		tplsize = _tmp27_;
		_tmp28_ = ptptpl;
		_tmp29_ = _tmp28_->tpl;
		_tmp30_ = gee_abstract_collection_get_size ((GeeCollection*) _tmp29_);
		_tmp31_ = _tmp30_;
		_tmp32_ = g_new0 (gint, _tmp31_);
		from_nip = _tmp32_;
		from_nip_length1 = _tmp31_;
		_from_nip_size_ = from_nip_length1;
		{
			gint i;
			i = 0;
			{
				gboolean _tmp33_;
				_tmp33_ = TRUE;
				while (TRUE) {
					gboolean _tmp34_;
					gint _tmp36_;
					gint _tmp37_;
					NetsukukuPeerToPeerTracerPacketList* _tmp38_;
					GeeArrayList* _tmp39_;
					gint _tmp40_;
					gpointer _tmp41_ = NULL;
					GeeArrayList* tpl_1;
					gint* _tmp42_;
					gint _tmp42__length1;
					gint _tmp43_;
					GeeArrayList* _tmp44_;
					GeeArrayList* _tmp45_;
					gint _tmp46_;
					gint _tmp47_;
					gpointer _tmp48_ = NULL;
					gint _tmp49_;
					_tmp34_ = _tmp33_;
					if (!_tmp34_) {
						gint _tmp35_;
						_tmp35_ = i;
						i = _tmp35_ + 1;
					}
					_tmp33_ = FALSE;
					_tmp36_ = i;
					_tmp37_ = tplsize;
					if (!(_tmp36_ < _tmp37_)) {
						break;
					}
					_tmp38_ = ptptpl;
					_tmp39_ = _tmp38_->tpl;
					_tmp40_ = i;
					_tmp41_ = gee_abstract_list_get ((GeeAbstractList*) _tmp39_, _tmp40_);
					tpl_1 = (GeeArrayList*) _tmp41_;
					_tmp42_ = from_nip;
					_tmp42__length1 = from_nip_length1;
					_tmp43_ = i;
					_tmp44_ = tpl_1;
					_tmp45_ = tpl_1;
					_tmp46_ = gee_abstract_collection_get_size ((GeeCollection*) _tmp45_);
					_tmp47_ = _tmp46_;
					_tmp48_ = gee_abstract_list_get ((GeeAbstractList*) _tmp44_, _tmp47_ - 1);
					_tmp42_[_tmp43_] = (gint) ((gintptr) _tmp48_);
					_tmp49_ = _tmp42_[_tmp43_];
					_g_object_unref0 (tpl_1);
				}
			}
		}
		_tmp50_ = maproute;
		_tmp51_ = from_nip;
		_tmp51__length1 = from_nip_length1;
		_tmp52_ = netsukuku_map_nip_cmp ((NetsukukuMap*) _tmp50_, _tmp51_, _tmp51__length1);
		last_lvl = _tmp52_;
		_tmp53_ = last_lvl;
		if (_tmp53_ > (-1)) {
			GeeArrayList* _tmp54_;
			GeeArrayList* unchanged;
			GeeArrayList* _tmp55_;
			NetsukukuPeerToPeerTracerPacketList* _tmp56_;
			GeeArrayList* _tmp57_;
			gint _tmp58_;
			gint _tmp59_;
			GeeList* _tmp60_ = NULL;
			GeeList* _tmp61_;
			GeeArrayList* _tmp62_;
			gpointer _tmp63_ = NULL;
			GeeArrayList* last_path;
			GeeArrayList* _tmp64_;
			NetsukukuMapRoute* _tmp65_;
			NetsukukuNIP* _tmp66_;
			NetsukukuNIP* _tmp67_;
			gint _tmp68_;
			gint _tmp69_ = 0;
			gboolean _tmp70_ = FALSE;
			GeeArrayList* _tmp84_;
			NetsukukuMapRoute* _tmp85_;
			NetsukukuNIP* _tmp86_;
			NetsukukuNIP* _tmp87_;
			gint _tmp88_;
			gint _tmp89_ = 0;
			GeeArrayList* _tmp90_;
			GeeArrayList* new_part;
			NetsukukuPeerToPeerTracerPacketList* _tmp110_;
			GeeArrayList* _tmp111_;
			GeeArrayList* _tmp112_;
			NetsukukuPeerToPeerTracerPacketList* _tmp113_;
			GeeArrayList* _tmp114_;
			GeeArrayList* _tmp115_;
			_tmp54_ = gee_array_list_new (GEE_TYPE_ARRAY_LIST, (GBoxedCopyFunc) g_object_ref, g_object_unref, _netsukuku_peer_to_peer_not_impl_equal_func_gee_equal_data_func, NULL, NULL);
			unchanged = _tmp54_;
			_tmp55_ = unchanged;
			_tmp56_ = ptptpl;
			_tmp57_ = _tmp56_->tpl;
			_tmp58_ = last_lvl;
			_tmp59_ = tplsize;
			_tmp60_ = gee_abstract_list_slice ((GeeAbstractList*) _tmp57_, _tmp58_, _tmp59_);
			_tmp61_ = _tmp60_;
			gee_array_list_add_all (_tmp55_, (GeeCollection*) _tmp61_);
			_g_object_unref0 (_tmp61_);
			_tmp62_ = unchanged;
			_tmp63_ = gee_abstract_list_get ((GeeAbstractList*) _tmp62_, 0);
			last_path = (GeeArrayList*) _tmp63_;
			_tmp64_ = last_path;
			_tmp65_ = maproute;
			_tmp66_ = netsukuku_map_get_me ((NetsukukuMap*) _tmp65_);
			_tmp67_ = _tmp66_;
			_tmp68_ = last_lvl;
			_tmp69_ = netsukuku_partial_nip_position_at ((NetsukukuPartialNIP*) _tmp67_, _tmp68_);
			_tmp70_ = gee_abstract_collection_contains ((GeeAbstractCollection*) _tmp64_, (gpointer) ((gintptr) _tmp69_));
			if (_tmp70_) {
				GeeArrayList* _tmp71_;
				NetsukukuMapRoute* _tmp72_;
				NetsukukuNIP* _tmp73_;
				NetsukukuNIP* _tmp74_;
				gint _tmp75_;
				gint _tmp76_ = 0;
				gint _tmp77_ = 0;
				gint pos;
				_tmp71_ = last_path;
				_tmp72_ = maproute;
				_tmp73_ = netsukuku_map_get_me ((NetsukukuMap*) _tmp72_);
				_tmp74_ = _tmp73_;
				_tmp75_ = last_lvl;
				_tmp76_ = netsukuku_partial_nip_position_at ((NetsukukuPartialNIP*) _tmp74_, _tmp75_);
				_tmp77_ = gee_abstract_list_index_of ((GeeAbstractList*) _tmp71_, (gpointer) ((gintptr) _tmp76_));
				pos = _tmp77_;
				while (TRUE) {
					GeeArrayList* _tmp78_;
					gint _tmp79_;
					gint _tmp80_;
					gint _tmp81_;
					GeeArrayList* _tmp82_;
					gint _tmp83_;
					_tmp78_ = last_path;
					_tmp79_ = gee_abstract_collection_get_size ((GeeCollection*) _tmp78_);
					_tmp80_ = _tmp79_;
					_tmp81_ = pos;
					if (!(_tmp80_ > _tmp81_)) {
						break;
					}
					_tmp82_ = last_path;
					_tmp83_ = pos;
					gee_abstract_list_remove_at ((GeeAbstractList*) _tmp82_, _tmp83_);
				}
				netsukuku_log_debug ("PeerToPeer Routing: loop detected. wait a bit.");
				tasklets_ms_wait ((gint64) 2000);
			}
			_tmp84_ = last_path;
			_tmp85_ = maproute;
			_tmp86_ = netsukuku_map_get_me ((NetsukukuMap*) _tmp85_);
			_tmp87_ = _tmp86_;
			_tmp88_ = last_lvl;
			_tmp89_ = netsukuku_partial_nip_position_at ((NetsukukuPartialNIP*) _tmp87_, _tmp88_);
			gee_abstract_collection_add ((GeeAbstractCollection*) _tmp84_, (gpointer) ((gintptr) _tmp89_));
			_tmp90_ = gee_array_list_new (GEE_TYPE_ARRAY_LIST, (GBoxedCopyFunc) g_object_ref, g_object_unref, _netsukuku_peer_to_peer_not_impl_equal_func_gee_equal_data_func, NULL, NULL);
			new_part = _tmp90_;
			{
				gint k;
				k = 0;
				{
					gboolean _tmp91_;
					_tmp91_ = TRUE;
					while (TRUE) {
						gboolean _tmp92_;
						gint _tmp94_;
						gint _tmp95_;
						NetsukukuMapRoute* _tmp96_;
						NetsukukuNIP* _tmp97_;
						NetsukukuNIP* _tmp98_;
						gint _tmp99_ = 0;
						gint* _tmp100_ = NULL;
						gint* _tmp101_;
						gint _tmp101__length1;
						gint _tmp102_;
						gint _tmp103_;
						gint _tmp104_;
						gint ki;
						GeeArrayList* _tmp105_;
						GeeArrayList* tpl_1;
						GeeArrayList* _tmp106_;
						gint _tmp107_;
						GeeArrayList* _tmp108_;
						GeeArrayList* _tmp109_;
						_tmp92_ = _tmp91_;
						if (!_tmp92_) {
							gint _tmp93_;
							_tmp93_ = k;
							k = _tmp93_ + 1;
						}
						_tmp91_ = FALSE;
						_tmp94_ = k;
						_tmp95_ = last_lvl;
						if (!(_tmp94_ < _tmp95_)) {
							break;
						}
						_tmp96_ = maproute;
						_tmp97_ = netsukuku_map_get_me ((NetsukukuMap*) _tmp96_);
						_tmp98_ = _tmp97_;
						_tmp100_ = netsukuku_partial_nip_get_positions ((NetsukukuPartialNIP*) _tmp98_, &_tmp99_);
						_tmp101_ = _tmp100_;
						_tmp101__length1 = _tmp99_;
						_tmp102_ = k;
						_tmp103_ = _tmp101_[_tmp102_];
						_tmp104_ = _tmp103_;
						_tmp101_ = (g_free (_tmp101_), NULL);
						ki = _tmp104_;
						_tmp105_ = gee_array_list_new (G_TYPE_INT, NULL, NULL, NULL, NULL, NULL);
						tpl_1 = _tmp105_;
						_tmp106_ = tpl_1;
						_tmp107_ = ki;
						gee_abstract_collection_add ((GeeAbstractCollection*) _tmp106_, (gpointer) ((gintptr) _tmp107_));
						_tmp108_ = new_part;
						_tmp109_ = tpl_1;
						gee_abstract_collection_add ((GeeAbstractCollection*) _tmp108_, _tmp109_);
						_g_object_unref0 (tpl_1);
					}
				}
			}
			_tmp110_ = ptptpl;
			_tmp111_ = new_part;
			_tmp112_ = _g_object_ref0 (_tmp111_);
			_g_object_unref0 (_tmp110_->tpl);
			_tmp110_->tpl = _tmp112_;
			_tmp113_ = ptptpl;
			_tmp114_ = _tmp113_->tpl;
			_tmp115_ = unchanged;
			gee_array_list_add_all (_tmp114_, (GeeCollection*) _tmp115_);
			_g_object_unref0 (new_part);
			_g_object_unref0 (last_path);
			_g_object_unref0 (unchanged);
		}
		from_nip = (g_free (from_nip), NULL);
	}
	_tmp116_ = ptptpl;
	_tmp117_ = netsukuku_peer_to_peer_tracer_packet_list_to_string (_tmp116_);
	_tmp118_ = _tmp117_;
	_tmp119_ = g_strconcat ("PeerToPeerTracerPacketList: after pass: ", _tmp118_, NULL);
	_tmp120_ = _tmp119_;
	netsukuku_log_debug (_tmp120_);
	_g_free0 (_tmp120_);
	_g_free0 (_tmp118_);
}


/** Delivers a msg to the nearest to hip
          */
static zcdISerializable* netsukuku_peer_to_peer_real_msg_deliver (NetsukukuIPeerToPeer* base, NetsukukuPeerToPeerTracerPacketList* peer_to_peer_tpl, NetsukukuNIP* sender_nip, NetsukukuNIP* hip, zcdRemoteCall* data, GError** error) {
	NetsukukuPeerToPeer * self;
	zcdISerializable* result = NULL;
	gboolean _tmp0_;
	NetsukukuMapRoute* _tmp8_;
	NetsukukuPeerToPeerTracerPacketList* _tmp9_;
	zcdSerializableNone* _tmp10_;
	zcdISerializable* ret;
	GError* last_e;
	zcdISerializable* _tmp93_;
	GType _tmp94_ = 0UL;
	const gchar* _tmp95_ = NULL;
	const gchar* _tmp96_ = NULL;
	gchar* _tmp97_ = NULL;
	gchar* _tmp98_;
	GError * _inner_error_ = NULL;
	self = (NetsukukuPeerToPeer*) base;
	g_return_val_if_fail (peer_to_peer_tpl != NULL, NULL);
	g_return_val_if_fail (sender_nip != NULL, NULL);
	g_return_val_if_fail (hip != NULL, NULL);
	g_return_val_if_fail (data != NULL, NULL);
	_tmp0_ = self->has_valid_map;
	if (!_tmp0_) {
		GType _tmp1_ = 0UL;
		const gchar* _tmp2_ = NULL;
		const gchar* _tmp3_ = NULL;
		gchar* _tmp4_ = NULL;
		gchar* _tmp5_;
		GError* _tmp6_;
		GError* _tmp7_;
		_tmp1_ = G_TYPE_FROM_INSTANCE ((GObject*) self);
		_tmp2_ = g_type_name (_tmp1_);
		_tmp3_ = string_to_string (_tmp2_);
		_tmp4_ = g_strconcat ("Not a valid map yet for ", _tmp3_, ". Request not valid.", NULL);
		_tmp5_ = _tmp4_;
		_tmp6_ = g_error_new_literal (ZCD_RPC_ERROR, ZCD_RPC_ERROR_NOT_VALID_MAP_YET, _tmp5_);
		_tmp7_ = _tmp6_;
		_g_free0 (_tmp5_);
		_inner_error_ = _tmp7_;
		g_propagate_error (error, _inner_error_);
		return NULL;
	}
	_tmp8_ = self->maproute;
	_tmp9_ = peer_to_peer_tpl;
	netsukuku_peer_to_peer_execute (_tmp8_, _tmp9_, &_inner_error_);
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		return NULL;
	}
	_tmp10_ = zcd_serializable_none_new ();
	ret = (zcdISerializable*) _tmp10_;
	last_e = NULL;
	while (TRUE) {
		gboolean done;
		NetsukukuNIP* _tmp11_;
		NetsukukuHCoord* _tmp12_ = NULL;
		NetsukukuHCoord* lvlpos;
		NetsukukuHCoord* _tmp13_;
		done = FALSE;
		_tmp11_ = hip;
		_tmp12_ = netsukuku_peer_to_peer_search_participant (self, _tmp11_, 1, &_inner_error_);
		lvlpos = _tmp12_;
		if (_inner_error_ != NULL) {
			g_propagate_error (error, _inner_error_);
			_g_error_free0 (last_e);
			_g_object_unref0 (ret);
			return NULL;
		}
		_tmp13_ = lvlpos;
		if (_tmp13_ == NULL) {
			NetsukukuNIP* _tmp14_;
			zcdRemoteCall* _tmp15_;
			zcdISerializable* _tmp16_ = NULL;
			zcdISerializable* _tmp17_;
			_tmp14_ = sender_nip;
			_tmp15_ = data;
			_tmp16_ = netsukuku_peer_to_peer_msg_exec (self, _tmp14_, _tmp15_, &_inner_error_);
			_tmp17_ = _tmp16_;
			if (_inner_error_ != NULL) {
				g_propagate_error (error, _inner_error_);
				_g_object_unref0 (lvlpos);
				_g_error_free0 (last_e);
				_g_object_unref0 (ret);
				return NULL;
			}
			result = _tmp17_;
			_g_object_unref0 (lvlpos);
			_g_error_free0 (last_e);
			_g_object_unref0 (ret);
			return result;
		} else {
			NetsukukuHCoord* _tmp18_;
			gint _tmp19_;
			gint _tmp20_;
			gint lvl;
			NetsukukuHCoord* _tmp21_;
			gint _tmp22_;
			gint _tmp23_;
			gint pos;
			gint _tmp24_;
			gchar* _tmp25_ = NULL;
			gchar* _tmp26_;
			gint _tmp27_;
			gchar* _tmp28_ = NULL;
			gchar* _tmp29_;
			gchar* _tmp30_ = NULL;
			gchar* _tmp31_;
			gint _tmp32_;
			gint _tmp33_;
			GeeList* _tmp34_ = NULL;
			GeeList* list_of_n;
			GeeList* _tmp35_;
			gboolean _tmp36_;
			gboolean _tmp37_;
			gboolean _tmp85_;
			NetsukukuPeerToPeerTracerPacketList* _tmp86_;
			NetsukukuTimeCapsule* _tmp87_;
			gboolean _tmp88_ = FALSE;
			_tmp18_ = lvlpos;
			_tmp19_ = netsukuku_hcoord_get_lvl (_tmp18_);
			_tmp20_ = _tmp19_;
			lvl = _tmp20_;
			_tmp21_ = lvlpos;
			_tmp22_ = netsukuku_hcoord_get_pos (_tmp21_);
			_tmp23_ = _tmp22_;
			pos = _tmp23_;
			_tmp24_ = lvl;
			_tmp25_ = g_strdup_printf ("%i", _tmp24_);
			_tmp26_ = _tmp25_;
			_tmp27_ = pos;
			_tmp28_ = g_strdup_printf ("%i", _tmp27_);
			_tmp29_ = _tmp28_;
			_tmp30_ = g_strconcat ("PeerToPeer routing: msg_deliver to (", _tmp26_, ", ", _tmp29_, ")", NULL);
			_tmp31_ = _tmp30_;
			netsukuku_log_debug (_tmp31_);
			_g_free0 (_tmp31_);
			_g_free0 (_tmp29_);
			_g_free0 (_tmp26_);
			_tmp32_ = lvl;
			_tmp33_ = pos;
			_tmp34_ = netsukuku_peer_to_peer_neighbours_get_from_lvl_pos (self, _tmp32_, _tmp33_);
			list_of_n = _tmp34_;
			_tmp35_ = list_of_n;
			_tmp36_ = gee_collection_get_is_empty ((GeeCollection*) _tmp35_);
			_tmp37_ = _tmp36_;
			if (!_tmp37_) {
				{
					GeeList* _tmp38_;
					GeeList* _tmp39_;
					GeeList* _n_list;
					GeeList* _tmp40_;
					gint _tmp41_;
					gint _tmp42_;
					gint _n_size;
					gint _n_index;
					_tmp38_ = list_of_n;
					_tmp39_ = _g_object_ref0 (_tmp38_);
					_n_list = _tmp39_;
					_tmp40_ = _n_list;
					_tmp41_ = gee_collection_get_size ((GeeCollection*) _tmp40_);
					_tmp42_ = _tmp41_;
					_n_size = _tmp42_;
					_n_index = -1;
					while (TRUE) {
						gint _tmp43_;
						gint _tmp44_;
						gint _tmp45_;
						GeeList* _tmp46_;
						gint _tmp47_;
						gpointer _tmp48_ = NULL;
						NetsukukuAggregatedNeighbour* n;
						NetsukukuAggregatedNeighbour* _tmp49_;
						gchar* _tmp50_ = NULL;
						gchar* _tmp51_;
						gchar* _tmp52_ = NULL;
						gchar* _tmp53_;
						_tmp43_ = _n_index;
						_n_index = _tmp43_ + 1;
						_tmp44_ = _n_index;
						_tmp45_ = _n_size;
						if (!(_tmp44_ < _tmp45_)) {
							break;
						}
						_tmp46_ = _n_list;
						_tmp47_ = _n_index;
						_tmp48_ = gee_list_get (_tmp46_, _tmp47_);
						n = (NetsukukuAggregatedNeighbour*) _tmp48_;
						_tmp49_ = n;
						_tmp50_ = netsukuku_aggregated_neighbour_to_string (_tmp49_);
						_tmp51_ = _tmp50_;
						_tmp52_ = g_strconcat ("PeerToPeer routing: pass through ", _tmp51_, NULL);
						_tmp53_ = _tmp52_;
						netsukuku_log_debug (_tmp53_);
						_g_free0 (_tmp53_);
						_g_free0 (_tmp51_);
						{
							NetsukukuAggregatedNeighbour* _tmp54_;
							NetsukukuAddressManagerTCPClient* _tmp55_;
							NetsukukuAddressManagerTCPClient* _tmp56_;
							gint _tmp57_;
							NetsukukuIPeerToPeer* _tmp58_ = NULL;
							NetsukukuIPeerToPeer* _tmp59_;
							NetsukukuPeerToPeerTracerPacketList* _tmp60_;
							NetsukukuNIP* _tmp61_;
							NetsukukuNIP* _tmp62_;
							zcdRemoteCall* _tmp63_;
							zcdISerializable* _tmp64_ = NULL;
							zcdISerializable* _tmp65_;
							zcdISerializable* _tmp66_;
							_tmp54_ = n;
							_tmp55_ = netsukuku_aggregated_neighbour_get_tcp_client (_tmp54_);
							_tmp56_ = _tmp55_;
							_tmp57_ = self->pid;
							_tmp58_ = netsukuku_iaddress_manager_root_dispatcher_get_peer_to_peer_service ((NetsukukuIAddressManagerRootDispatcher*) _tmp56_, _tmp57_);
							_tmp59_ = _tmp58_;
							_tmp60_ = peer_to_peer_tpl;
							_tmp61_ = sender_nip;
							_tmp62_ = hip;
							_tmp63_ = data;
							_tmp64_ = netsukuku_ipeer_to_peer_msg_deliver (_tmp59_, _tmp60_, _tmp61_, _tmp62_, _tmp63_, &_inner_error_);
							_tmp65_ = _tmp64_;
							_g_object_unref0 (_tmp59_);
							_tmp66_ = _tmp65_;
							if (_inner_error_ != NULL) {
								if (_inner_error_->domain == ZCD_RPC_ERROR) {
									goto __catch95_zcd_rpc_error;
								}
								goto __finally95;
							}
							_g_object_unref0 (ret);
							ret = _tmp66_;
							done = TRUE;
							_g_object_unref0 (n);
							break;
						}
						goto __finally95;
						__catch95_zcd_rpc_error:
						{
							GError* e = NULL;
							GError* _tmp67_;
							e = _inner_error_;
							_inner_error_ = NULL;
							_tmp67_ = e;
							if (g_error_matches (_tmp67_, ZCD_RPC_ERROR, ZCD_RPC_ERROR_NOT_VALID_MAP_YET)) {
								GError* _tmp68_;
								GQuark _tmp69_;
								const gchar* _tmp70_ = NULL;
								const gchar* _tmp71_ = NULL;
								GError* _tmp72_;
								gint _tmp73_;
								gchar* _tmp74_ = NULL;
								gchar* _tmp75_;
								GError* _tmp76_;
								const gchar* _tmp77_;
								const gchar* _tmp78_ = NULL;
								gchar* _tmp79_ = NULL;
								gchar* _tmp80_;
								GError* _tmp81_;
								GError* _tmp82_;
								_tmp68_ = e;
								_tmp69_ = _tmp68_->domain;
								_tmp70_ = g_quark_to_string (_tmp69_);
								_tmp71_ = string_to_string (_tmp70_);
								_tmp72_ = e;
								_tmp73_ = _tmp72_->code;
								_tmp74_ = g_strdup_printf ("%i", _tmp73_);
								_tmp75_ = _tmp74_;
								_tmp76_ = e;
								_tmp77_ = _tmp76_->message;
								_tmp78_ = string_to_string (_tmp77_);
								_tmp79_ = g_strconcat ("PeerToPeer routing: got ", _tmp71_, " ", _tmp75_, " ", _tmp78_, NULL);
								_tmp80_ = _tmp79_;
								netsukuku_log_debug (_tmp80_);
								_g_free0 (_tmp80_);
								_g_free0 (_tmp75_);
								_tmp81_ = e;
								_tmp82_ = _g_error_copy0 (_tmp81_);
								_g_error_free0 (last_e);
								last_e = _tmp82_;
							} else {
								GError* _tmp83_;
								GError* _tmp84_;
								_tmp83_ = e;
								_tmp84_ = _g_error_copy0 (_tmp83_);
								_inner_error_ = _tmp84_;
								_g_error_free0 (e);
								goto __finally95;
							}
							_g_error_free0 (e);
						}
						__finally95:
						if (_inner_error_ != NULL) {
							g_propagate_error (error, _inner_error_);
							_g_object_unref0 (n);
							_g_object_unref0 (_n_list);
							_g_object_unref0 (list_of_n);
							_g_object_unref0 (lvlpos);
							_g_error_free0 (last_e);
							_g_object_unref0 (ret);
							return NULL;
						}
						_g_object_unref0 (n);
					}
					_g_object_unref0 (_n_list);
				}
			} else {
				netsukuku_log_debug ("PeerToPeer routing: unknown route.");
				_g_error_free0 (last_e);
				last_e = NULL;
			}
			_tmp85_ = done;
			if (_tmp85_) {
				_g_object_unref0 (list_of_n);
				_g_object_unref0 (lvlpos);
				break;
			}
			_tmp86_ = peer_to_peer_tpl;
			_tmp87_ = _tmp86_->tc;
			_tmp88_ = tasklets_timer_is_expired ((TaskletsTimer*) _tmp87_);
			if (_tmp88_) {
				GError* _tmp89_;
				GError* _tmp92_;
				netsukuku_log_warn ("PeerToPeer routing: Too many errors. Giving up.");
				_tmp89_ = last_e;
				if (_tmp89_ != NULL) {
					GError* _tmp90_;
					GError* _tmp91_;
					_tmp90_ = last_e;
					_tmp91_ = _g_error_copy0 (_tmp90_);
					_inner_error_ = _tmp91_;
					g_propagate_error (error, _inner_error_);
					_g_object_unref0 (list_of_n);
					_g_object_unref0 (lvlpos);
					_g_error_free0 (last_e);
					_g_object_unref0 (ret);
					return NULL;
				}
				_tmp92_ = g_error_new_literal (ZCD_RPC_ERROR, ZCD_RPC_ERROR_GENERIC, "Unreachable PeerToPeer destination.");
				_inner_error_ = _tmp92_;
				g_propagate_error (error, _inner_error_);
				_g_object_unref0 (list_of_n);
				_g_object_unref0 (lvlpos);
				_g_error_free0 (last_e);
				_g_object_unref0 (ret);
				return NULL;
			} else {
				netsukuku_log_debug ("PeerToPeer routing: Temporary failure. Wait a bit and try again.");
				tasklets_ms_wait ((gint64) 1000);
			}
			_g_object_unref0 (list_of_n);
		}
		_g_object_unref0 (lvlpos);
	}
	_tmp93_ = ret;
	_tmp94_ = G_TYPE_FROM_INSTANCE ((GObject*) _tmp93_);
	_tmp95_ = g_type_name (_tmp94_);
	_tmp96_ = string_to_string (_tmp95_);
	_tmp97_ = g_strconcat ("PeerToPeer routing: Returning an ", _tmp96_, NULL);
	_tmp98_ = _tmp97_;
	netsukuku_log_debug (_tmp98_);
	_g_free0 (_tmp98_);
	result = ret;
	_g_error_free0 (last_e);
	return result;
}


/** Execution of a msg
          */
zcdISerializable* netsukuku_peer_to_peer_msg_exec (NetsukukuPeerToPeer* self, NetsukukuNIP* sender_nip, zcdRemoteCall* data, GError** error) {
	zcdISerializable* result = NULL;
	zcdRemoteCall* _tmp0_;
	zcdISerializable* _tmp1_ = NULL;
	zcdISerializable* _tmp2_;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (sender_nip != NULL, NULL);
	g_return_val_if_fail (data != NULL, NULL);
	_tmp0_ = data;
	_tmp1_ = _zcd_rpc_dispatcher_dispatch ((zcdRPCDispatcher*) self, NULL, _tmp0_, &_inner_error_);
	_tmp2_ = _tmp1_;
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		return NULL;
	}
	result = _tmp2_;
	return result;
}


/** Search functions for registration with replica. Routed. **/
static gboolean _int_equal (const gint* s1, const gint* s2) {
	if (s1 == s2) {
		return TRUE;
	}
	if (s1 == NULL) {
		return FALSE;
	}
	if (s2 == NULL) {
		return FALSE;
	}
	return (*s1) == (*s2);
}


GeeList* netsukuku_peer_to_peer_find_nearest_to_register (NetsukukuPeerToPeer* self, NetsukukuNIP* hash_nip, gint num_dupl, gint* inside_gnode_level, GError** error) {
	GeeList* result = NULL;
	gint* _tmp0_;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (hash_nip != NULL, NULL);
	_tmp0_ = inside_gnode_level;
	if (_tmp0_ == NULL) {
		NetsukukuPeerToPeerTracerPacketList* _tmp1_;
		NetsukukuPeerToPeerTracerPacketList* _tmp2_;
		NetsukukuNIP* _tmp3_;
		gint _tmp4_;
		NetsukukuMapRoute* _tmp5_;
		gint _tmp6_;
		gint _tmp7_;
		GeeList* _tmp8_ = NULL;
		GeeList* _tmp9_;
		GeeList* _tmp10_;
		_tmp1_ = netsukuku_peer_to_peer_tracer_packet_list_new (120000);
		_tmp2_ = _tmp1_;
		_tmp3_ = hash_nip;
		_tmp4_ = num_dupl;
		_tmp5_ = self->maproute;
		_tmp6_ = netsukuku_map_get_levels ((NetsukukuMap*) _tmp5_);
		_tmp7_ = _tmp6_;
		_tmp8_ = netsukuku_ipeer_to_peer_find_nearest ((NetsukukuIPeerToPeer*) self, _tmp2_, _tmp3_, _tmp4_, _tmp7_, 0, &_inner_error_);
		_tmp9_ = _tmp8_;
		_g_object_unref0 (_tmp2_);
		_tmp10_ = _tmp9_;
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == ZCD_RPC_ERROR) {
				g_propagate_error (error, _inner_error_);
				return NULL;
			} else {
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return NULL;
			}
		}
		result = _tmp10_;
		return result;
	} else {
		gint _tmp11_ = 0;
		gint* _tmp12_;
		NetsukukuMapRoute* _tmp13_;
		gint _tmp14_;
		gint _tmp15_;
		gint _tmp21_;
		gint pos;
		NetsukukuPeerToPeerTracerPacketList* _tmp22_;
		NetsukukuPeerToPeerTracerPacketList* _tmp23_;
		NetsukukuNIP* _tmp24_;
		gint _tmp25_;
		gint* _tmp26_;
		gint _tmp27_;
		GeeList* _tmp28_ = NULL;
		GeeList* _tmp29_;
		GeeList* _tmp30_;
		_tmp12_ = inside_gnode_level;
		_tmp13_ = self->maproute;
		_tmp14_ = netsukuku_map_get_levels ((NetsukukuMap*) _tmp13_);
		_tmp15_ = _tmp14_;
		if (_int_equal (_tmp12_, &_tmp15_) == TRUE) {
			_tmp11_ = 0;
		} else {
			NetsukukuMapRoute* _tmp16_;
			NetsukukuNIP* _tmp17_;
			NetsukukuNIP* _tmp18_;
			gint* _tmp19_;
			gint _tmp20_ = 0;
			_tmp16_ = self->maproute;
			_tmp17_ = netsukuku_map_get_me ((NetsukukuMap*) _tmp16_);
			_tmp18_ = _tmp17_;
			_tmp19_ = inside_gnode_level;
			_tmp20_ = netsukuku_partial_nip_position_at ((NetsukukuPartialNIP*) _tmp18_, *_tmp19_);
			_tmp11_ = _tmp20_;
		}
		_tmp21_ = _tmp11_;
		pos = _tmp21_;
		_tmp22_ = netsukuku_peer_to_peer_tracer_packet_list_new (120000);
		_tmp23_ = _tmp22_;
		_tmp24_ = hash_nip;
		_tmp25_ = num_dupl;
		_tmp26_ = inside_gnode_level;
		_tmp27_ = pos;
		_tmp28_ = netsukuku_ipeer_to_peer_find_nearest ((NetsukukuIPeerToPeer*) self, _tmp23_, _tmp24_, _tmp25_, *_tmp26_, _tmp27_, &_inner_error_);
		_tmp29_ = _tmp28_;
		_g_object_unref0 (_tmp23_);
		_tmp30_ = _tmp29_;
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == ZCD_RPC_ERROR) {
				g_propagate_error (error, _inner_error_);
				return NULL;
			} else {
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return NULL;
			}
		}
		result = _tmp30_;
		return result;
	}
}


static GeeList* netsukuku_peer_to_peer_real_find_nearest (NetsukukuIPeerToPeer* base, NetsukukuPeerToPeerTracerPacketList* peer_to_peer_tpl, NetsukukuNIP* hash_nip, gint num_dupl, gint lvl, gint pos, GError** error) {
	NetsukukuPeerToPeer * self;
	GeeList* result = NULL;
	gboolean _tmp0_;
	NetsukukuMapRoute* _tmp8_;
	NetsukukuPeerToPeerTracerPacketList* _tmp9_;
	NetsukukuPeerToPeerTracerPacketList* _tmp10_;
	NetsukukuNIP* _tmp11_;
	gint _tmp12_;
	gint _tmp13_;
	gint _tmp14_;
	GeeList* _tmp15_ = NULL;
	GeeList* _tmp16_;
	GError * _inner_error_ = NULL;
	self = (NetsukukuPeerToPeer*) base;
	g_return_val_if_fail (peer_to_peer_tpl != NULL, NULL);
	g_return_val_if_fail (hash_nip != NULL, NULL);
	_tmp0_ = self->has_valid_map;
	if (!_tmp0_) {
		GType _tmp1_ = 0UL;
		const gchar* _tmp2_ = NULL;
		const gchar* _tmp3_ = NULL;
		gchar* _tmp4_ = NULL;
		gchar* _tmp5_;
		GError* _tmp6_;
		GError* _tmp7_;
		_tmp1_ = G_TYPE_FROM_INSTANCE ((GObject*) self);
		_tmp2_ = g_type_name (_tmp1_);
		_tmp3_ = string_to_string (_tmp2_);
		_tmp4_ = g_strconcat ("Not a valid map yet for ", _tmp3_, ". Request not valid.", NULL);
		_tmp5_ = _tmp4_;
		_tmp6_ = g_error_new_literal (ZCD_RPC_ERROR, ZCD_RPC_ERROR_NOT_VALID_MAP_YET, _tmp5_);
		_tmp7_ = _tmp6_;
		_g_free0 (_tmp5_);
		_inner_error_ = _tmp7_;
		if (_inner_error_->domain == ZCD_RPC_ERROR) {
			g_propagate_error (error, _inner_error_);
			return NULL;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	}
	_tmp8_ = self->maproute;
	_tmp9_ = peer_to_peer_tpl;
	netsukuku_peer_to_peer_execute (_tmp8_, _tmp9_, &_inner_error_);
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == ZCD_RPC_ERROR) {
			g_propagate_error (error, _inner_error_);
			return NULL;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	}
	_tmp10_ = peer_to_peer_tpl;
	_tmp11_ = hash_nip;
	_tmp12_ = num_dupl;
	_tmp13_ = lvl;
	_tmp14_ = pos;
	_tmp15_ = netsukuku_peer_to_peer_inside_find_nearest (self, _tmp10_, _tmp11_, _tmp12_, _tmp13_, _tmp14_, &_inner_error_);
	_tmp16_ = _tmp15_;
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == ZCD_RPC_ERROR) {
			g_propagate_error (error, _inner_error_);
			return NULL;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	}
	result = _tmp16_;
	return result;
}


static gboolean _netsukuku_partial_nip_equal_func_gee_equal_data_func (gconstpointer a, gconstpointer b, gpointer self) {
	gboolean result;
	result = netsukuku_partial_nip_equal_func (a, b);
	return result;
}


GeeList* netsukuku_peer_to_peer_inside_find_nearest (NetsukukuPeerToPeer* self, NetsukukuPeerToPeerTracerPacketList* peer_to_peer_tpl, NetsukukuNIP* hash_nip, gint num_dupl, gint lvl, gint pos, GError** error) {
	GeeList* result = NULL;
	gint _tmp0_;
	gint _tmp2_;
	NetsukukuMapRoute* _tmp3_;
	gint _tmp4_;
	gint _tmp5_;
	gboolean _tmp26_ = FALSE;
	gint _tmp27_;
	NetsukukuMapRoute* _tmp28_;
	gint _tmp29_;
	gint _tmp30_;
	gboolean _tmp37_;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (peer_to_peer_tpl != NULL, NULL);
	g_return_val_if_fail (hash_nip != NULL, NULL);
	_tmp0_ = num_dupl;
	if (_tmp0_ == 0) {
		GeeArrayList* _tmp1_;
		_tmp1_ = gee_array_list_new (NETSUKUKU_TYPE_NIP, (GBoxedCopyFunc) g_object_ref, g_object_unref, _netsukuku_partial_nip_equal_func_gee_equal_data_func, NULL, NULL);
		result = (GeeList*) _tmp1_;
		return result;
	}
	_tmp2_ = lvl;
	_tmp3_ = self->maproute;
	_tmp4_ = netsukuku_map_get_levels ((NetsukukuMap*) _tmp3_);
	_tmp5_ = _tmp4_;
	if (_tmp2_ < _tmp5_) {
		gint _tmp6_;
		gint _tmp22_;
		gint _tmp23_;
		gboolean _tmp24_ = FALSE;
		_tmp6_ = lvl;
		if (_tmp6_ == 0) {
			GeeArrayList* _tmp7_;
			GeeArrayList* ret;
			gint _tmp8_;
			gboolean _tmp9_ = FALSE;
			_tmp7_ = gee_array_list_new (NETSUKUKU_TYPE_NIP, (GBoxedCopyFunc) g_object_ref, g_object_unref, _netsukuku_partial_nip_equal_func_gee_equal_data_func, NULL, NULL);
			ret = _tmp7_;
			_tmp8_ = pos;
			_tmp9_ = netsukuku_peer_to_peer_is_participant (self, 0, _tmp8_);
			if (_tmp9_) {
				NetsukukuMapRoute* _tmp10_;
				NetsukukuNIP* _tmp11_;
				NetsukukuNIP* _tmp12_;
				gint _tmp13_ = 0;
				gint* _tmp14_ = NULL;
				gint* positions;
				gint positions_length1;
				gint _positions_size_;
				gint* _tmp15_;
				gint _tmp15__length1;
				gint _tmp16_;
				gint _tmp17_;
				GeeArrayList* _tmp18_;
				gint* _tmp19_;
				gint _tmp19__length1;
				NetsukukuNIP* _tmp20_;
				NetsukukuNIP* _tmp21_;
				_tmp10_ = self->maproute;
				_tmp11_ = netsukuku_map_get_me ((NetsukukuMap*) _tmp10_);
				_tmp12_ = _tmp11_;
				_tmp14_ = netsukuku_partial_nip_get_positions ((NetsukukuPartialNIP*) _tmp12_, &_tmp13_);
				positions = _tmp14_;
				positions_length1 = _tmp13_;
				_positions_size_ = positions_length1;
				_tmp15_ = positions;
				_tmp15__length1 = positions_length1;
				_tmp16_ = pos;
				_tmp15_[0] = _tmp16_;
				_tmp17_ = _tmp15_[0];
				_tmp18_ = ret;
				_tmp19_ = positions;
				_tmp19__length1 = positions_length1;
				_tmp20_ = netsukuku_nip_new (_tmp19_, _tmp19__length1);
				_tmp21_ = _tmp20_;
				gee_abstract_collection_add ((GeeAbstractCollection*) _tmp18_, _tmp21_);
				_g_object_unref0 (_tmp21_);
				positions = (g_free (positions), NULL);
			}
			result = (GeeList*) ret;
			return result;
		}
		_tmp22_ = lvl;
		_tmp23_ = pos;
		_tmp24_ = netsukuku_peer_to_peer_is_participant (self, _tmp22_, _tmp23_);
		if (!_tmp24_) {
			GeeArrayList* _tmp25_;
			_tmp25_ = gee_array_list_new (NETSUKUKU_TYPE_NIP, (GBoxedCopyFunc) g_object_ref, g_object_unref, _netsukuku_partial_nip_equal_func_gee_equal_data_func, NULL, NULL);
			result = (GeeList*) _tmp25_;
			return result;
		}
	}
	_tmp27_ = lvl;
	_tmp28_ = self->maproute;
	_tmp29_ = netsukuku_map_get_levels ((NetsukukuMap*) _tmp28_);
	_tmp30_ = _tmp29_;
	if (_tmp27_ == _tmp30_) {
		_tmp26_ = TRUE;
	} else {
		NetsukukuMapRoute* _tmp31_;
		NetsukukuNIP* _tmp32_;
		NetsukukuNIP* _tmp33_;
		gint _tmp34_;
		gint _tmp35_ = 0;
		gint _tmp36_;
		_tmp31_ = self->maproute;
		_tmp32_ = netsukuku_map_get_me ((NetsukukuMap*) _tmp31_);
		_tmp33_ = _tmp32_;
		_tmp34_ = lvl;
		_tmp35_ = netsukuku_partial_nip_position_at ((NetsukukuPartialNIP*) _tmp33_, _tmp34_);
		_tmp36_ = pos;
		_tmp26_ = _tmp35_ == _tmp36_;
	}
	_tmp37_ = _tmp26_;
	if (_tmp37_) {
		GeeArrayList* _tmp38_;
		GeeArrayList* sequence;
		gint _tmp39_;
		gint new_lvl;
		_tmp38_ = gee_array_list_new (NETSUKUKU_TYPE_NIP, (GBoxedCopyFunc) g_object_ref, g_object_unref, _netsukuku_partial_nip_equal_func_gee_equal_data_func, NULL, NULL);
		sequence = _tmp38_;
		_tmp39_ = lvl;
		new_lvl = _tmp39_ - 1;
		{
			NetsukukuNIP* _tmp40_;
			gint _tmp41_;
			gint _tmp42_ = 0;
			GeeList* _tmp43_ = NULL;
			GeeList* _new_pos_list;
			GeeList* _tmp44_;
			gint _tmp45_;
			gint _tmp46_;
			gint _new_pos_size;
			gint _new_pos_index;
			_tmp40_ = hash_nip;
			_tmp41_ = new_lvl;
			_tmp42_ = netsukuku_partial_nip_position_at ((NetsukukuPartialNIP*) _tmp40_, _tmp41_);
			_tmp43_ = netsukuku_peer_to_peer_list_ids (self, _tmp42_, 1);
			_new_pos_list = _tmp43_;
			_tmp44_ = _new_pos_list;
			_tmp45_ = gee_collection_get_size ((GeeCollection*) _tmp44_);
			_tmp46_ = _tmp45_;
			_new_pos_size = _tmp46_;
			_new_pos_index = -1;
			while (TRUE) {
				gint _tmp47_;
				gint _tmp48_;
				gint _tmp49_;
				GeeList* _tmp50_;
				gint _tmp51_;
				gpointer _tmp52_ = NULL;
				gint new_pos;
				NetsukukuPeerToPeerTracerPacketList* _tmp53_;
				NetsukukuNIP* _tmp54_;
				gint _tmp55_;
				GeeArrayList* _tmp56_;
				gint _tmp57_;
				gint _tmp58_;
				gint _tmp59_;
				gint _tmp60_;
				GeeList* _tmp61_ = NULL;
				GeeList* adding;
				GeeArrayList* _tmp62_;
				GeeList* _tmp63_;
				GeeArrayList* _tmp64_;
				gint _tmp65_;
				gint _tmp66_;
				gint _tmp67_;
				_tmp47_ = _new_pos_index;
				_new_pos_index = _tmp47_ + 1;
				_tmp48_ = _new_pos_index;
				_tmp49_ = _new_pos_size;
				if (!(_tmp48_ < _tmp49_)) {
					break;
				}
				_tmp50_ = _new_pos_list;
				_tmp51_ = _new_pos_index;
				_tmp52_ = gee_list_get (_tmp50_, _tmp51_);
				new_pos = (gint) ((gintptr) _tmp52_);
				_tmp53_ = peer_to_peer_tpl;
				_tmp54_ = hash_nip;
				_tmp55_ = num_dupl;
				_tmp56_ = sequence;
				_tmp57_ = gee_abstract_collection_get_size ((GeeCollection*) _tmp56_);
				_tmp58_ = _tmp57_;
				_tmp59_ = new_lvl;
				_tmp60_ = new_pos;
				_tmp61_ = netsukuku_peer_to_peer_inside_find_nearest (self, _tmp53_, _tmp54_, _tmp55_ - _tmp58_, _tmp59_, _tmp60_, &_inner_error_);
				adding = _tmp61_;
				if (_inner_error_ != NULL) {
					if (_inner_error_->domain == ZCD_RPC_ERROR) {
						g_propagate_error (error, _inner_error_);
						_g_object_unref0 (_new_pos_list);
						_g_object_unref0 (sequence);
						return NULL;
					} else {
						_g_object_unref0 (_new_pos_list);
						_g_object_unref0 (sequence);
						g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
						g_clear_error (&_inner_error_);
						return NULL;
					}
				}
				_tmp62_ = sequence;
				_tmp63_ = adding;
				gee_array_list_add_all (_tmp62_, (GeeCollection*) _tmp63_);
				_tmp64_ = sequence;
				_tmp65_ = gee_abstract_collection_get_size ((GeeCollection*) _tmp64_);
				_tmp66_ = _tmp65_;
				_tmp67_ = num_dupl;
				if (_tmp66_ >= _tmp67_) {
					_g_object_unref0 (adding);
					break;
				}
				_g_object_unref0 (adding);
			}
			_g_object_unref0 (_new_pos_list);
		}
		result = (GeeList*) sequence;
		return result;
	} else {
		GeeArrayList* _tmp68_;
		GeeList* ret;
		gchar* _tmp142_;
		gchar* nips;
		gchar* _tmp143_;
		gchar* nips_next;
		const gchar* _tmp164_;
		const gchar* _tmp165_ = NULL;
		gchar* _tmp166_ = NULL;
		gchar* _tmp167_;
		_tmp68_ = gee_array_list_new (NETSUKUKU_TYPE_NIP, (GBoxedCopyFunc) g_object_ref, g_object_unref, _netsukuku_partial_nip_equal_func_gee_equal_data_func, NULL, NULL);
		ret = (GeeList*) _tmp68_;
		while (TRUE) {
			GError* last_e;
			gboolean done;
			NetsukukuNIP* _tmp69_;
			gchar* _tmp70_ = NULL;
			gchar* _tmp71_;
			gint _tmp72_;
			gchar* _tmp73_ = NULL;
			gchar* _tmp74_;
			gint _tmp75_;
			gchar* _tmp76_ = NULL;
			gchar* _tmp77_;
			gchar* _tmp78_ = NULL;
			gchar* _tmp79_;
			gint _tmp80_;
			gint _tmp81_;
			GeeList* _tmp82_ = NULL;
			GeeList* list_of_n;
			GeeList* _tmp83_;
			gboolean _tmp84_;
			gboolean _tmp85_;
			gboolean _tmp134_;
			NetsukukuPeerToPeerTracerPacketList* _tmp135_;
			NetsukukuTimeCapsule* _tmp136_;
			gboolean _tmp137_ = FALSE;
			last_e = NULL;
			done = FALSE;
			_tmp69_ = hash_nip;
			_tmp70_ = netsukuku_partial_nip_to_string ((NetsukukuPartialNIP*) _tmp69_);
			_tmp71_ = _tmp70_;
			_tmp72_ = lvl;
			_tmp73_ = g_strdup_printf ("%i", _tmp72_);
			_tmp74_ = _tmp73_;
			_tmp75_ = pos;
			_tmp76_ = g_strdup_printf ("%i", _tmp75_);
			_tmp77_ = _tmp76_;
			_tmp78_ = g_strconcat ("PeerToPeer routing: route_find_nearest to ", _tmp71_, " in (", _tmp74_, ", ", _tmp77_, ")", NULL);
			_tmp79_ = _tmp78_;
			netsukuku_log_debug (_tmp79_);
			_g_free0 (_tmp79_);
			_g_free0 (_tmp77_);
			_g_free0 (_tmp74_);
			_g_free0 (_tmp71_);
			_tmp80_ = lvl;
			_tmp81_ = pos;
			_tmp82_ = netsukuku_peer_to_peer_neighbours_get_from_lvl_pos (self, _tmp80_, _tmp81_);
			list_of_n = _tmp82_;
			_tmp83_ = list_of_n;
			_tmp84_ = gee_collection_get_is_empty ((GeeCollection*) _tmp83_);
			_tmp85_ = _tmp84_;
			if (!_tmp85_) {
				{
					GeeList* _tmp86_;
					GeeList* _tmp87_;
					GeeList* _n_list;
					GeeList* _tmp88_;
					gint _tmp89_;
					gint _tmp90_;
					gint _n_size;
					gint _n_index;
					_tmp86_ = list_of_n;
					_tmp87_ = _g_object_ref0 (_tmp86_);
					_n_list = _tmp87_;
					_tmp88_ = _n_list;
					_tmp89_ = gee_collection_get_size ((GeeCollection*) _tmp88_);
					_tmp90_ = _tmp89_;
					_n_size = _tmp90_;
					_n_index = -1;
					while (TRUE) {
						gint _tmp91_;
						gint _tmp92_;
						gint _tmp93_;
						GeeList* _tmp94_;
						gint _tmp95_;
						gpointer _tmp96_ = NULL;
						NetsukukuAggregatedNeighbour* n;
						NetsukukuAggregatedNeighbour* _tmp97_;
						gchar* _tmp98_ = NULL;
						gchar* _tmp99_;
						gchar* _tmp100_ = NULL;
						gchar* _tmp101_;
						_tmp91_ = _n_index;
						_n_index = _tmp91_ + 1;
						_tmp92_ = _n_index;
						_tmp93_ = _n_size;
						if (!(_tmp92_ < _tmp93_)) {
							break;
						}
						_tmp94_ = _n_list;
						_tmp95_ = _n_index;
						_tmp96_ = gee_list_get (_tmp94_, _tmp95_);
						n = (NetsukukuAggregatedNeighbour*) _tmp96_;
						_tmp97_ = n;
						_tmp98_ = netsukuku_aggregated_neighbour_to_string (_tmp97_);
						_tmp99_ = _tmp98_;
						_tmp100_ = g_strconcat ("PeerToPeer routing: pass through ", _tmp99_, NULL);
						_tmp101_ = _tmp100_;
						netsukuku_log_debug (_tmp101_);
						_g_free0 (_tmp101_);
						_g_free0 (_tmp99_);
						{
							NetsukukuAggregatedNeighbour* _tmp102_;
							NetsukukuAddressManagerTCPClient* _tmp103_;
							NetsukukuAddressManagerTCPClient* _tmp104_;
							gint _tmp105_;
							NetsukukuIPeerToPeer* _tmp106_ = NULL;
							NetsukukuIPeerToPeer* _tmp107_;
							NetsukukuPeerToPeerTracerPacketList* _tmp108_;
							NetsukukuNIP* _tmp109_;
							gint _tmp110_;
							gint _tmp111_;
							gint _tmp112_;
							GeeList* _tmp113_ = NULL;
							GeeList* _tmp114_;
							GeeList* _tmp115_;
							_tmp102_ = n;
							_tmp103_ = netsukuku_aggregated_neighbour_get_tcp_client (_tmp102_);
							_tmp104_ = _tmp103_;
							_tmp105_ = self->pid;
							_tmp106_ = netsukuku_iaddress_manager_root_dispatcher_get_peer_to_peer_service ((NetsukukuIAddressManagerRootDispatcher*) _tmp104_, _tmp105_);
							_tmp107_ = _tmp106_;
							_tmp108_ = peer_to_peer_tpl;
							_tmp109_ = hash_nip;
							_tmp110_ = num_dupl;
							_tmp111_ = lvl;
							_tmp112_ = pos;
							_tmp113_ = netsukuku_ipeer_to_peer_find_nearest (_tmp107_, _tmp108_, _tmp109_, _tmp110_, _tmp111_, _tmp112_, &_inner_error_);
							_tmp114_ = _tmp113_;
							_g_object_unref0 (_tmp107_);
							_tmp115_ = _tmp114_;
							if (_inner_error_ != NULL) {
								if (_inner_error_->domain == ZCD_RPC_ERROR) {
									goto __catch96_zcd_rpc_error;
								}
								_g_object_unref0 (n);
								_g_object_unref0 (_n_list);
								_g_object_unref0 (list_of_n);
								_g_error_free0 (last_e);
								_g_object_unref0 (ret);
								g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
								g_clear_error (&_inner_error_);
								return NULL;
							}
							_g_object_unref0 (ret);
							ret = _tmp115_;
							done = TRUE;
							_g_object_unref0 (n);
							break;
						}
						goto __finally96;
						__catch96_zcd_rpc_error:
						{
							GError* e = NULL;
							GError* _tmp116_;
							e = _inner_error_;
							_inner_error_ = NULL;
							_tmp116_ = e;
							if (g_error_matches (_tmp116_, ZCD_RPC_ERROR, ZCD_RPC_ERROR_NOT_VALID_MAP_YET)) {
								GError* _tmp117_;
								GQuark _tmp118_;
								const gchar* _tmp119_ = NULL;
								const gchar* _tmp120_ = NULL;
								GError* _tmp121_;
								gint _tmp122_;
								gchar* _tmp123_ = NULL;
								gchar* _tmp124_;
								GError* _tmp125_;
								const gchar* _tmp126_;
								const gchar* _tmp127_ = NULL;
								gchar* _tmp128_ = NULL;
								gchar* _tmp129_;
								GError* _tmp130_;
								GError* _tmp131_;
								_tmp117_ = e;
								_tmp118_ = _tmp117_->domain;
								_tmp119_ = g_quark_to_string (_tmp118_);
								_tmp120_ = string_to_string (_tmp119_);
								_tmp121_ = e;
								_tmp122_ = _tmp121_->code;
								_tmp123_ = g_strdup_printf ("%i", _tmp122_);
								_tmp124_ = _tmp123_;
								_tmp125_ = e;
								_tmp126_ = _tmp125_->message;
								_tmp127_ = string_to_string (_tmp126_);
								_tmp128_ = g_strconcat ("PeerToPeer routing: got ", _tmp120_, " ", _tmp124_, " ", _tmp127_, NULL);
								_tmp129_ = _tmp128_;
								netsukuku_log_debug (_tmp129_);
								_g_free0 (_tmp129_);
								_g_free0 (_tmp124_);
								_tmp130_ = e;
								_tmp131_ = _g_error_copy0 (_tmp130_);
								_g_error_free0 (last_e);
								last_e = _tmp131_;
							} else {
								GError* _tmp132_;
								GError* _tmp133_;
								_tmp132_ = e;
								_tmp133_ = _g_error_copy0 (_tmp132_);
								_inner_error_ = _tmp133_;
								_g_error_free0 (e);
								goto __finally96;
							}
							_g_error_free0 (e);
						}
						__finally96:
						if (_inner_error_ != NULL) {
							if (_inner_error_->domain == ZCD_RPC_ERROR) {
								g_propagate_error (error, _inner_error_);
								_g_object_unref0 (n);
								_g_object_unref0 (_n_list);
								_g_object_unref0 (list_of_n);
								_g_error_free0 (last_e);
								_g_object_unref0 (ret);
								return NULL;
							} else {
								_g_object_unref0 (n);
								_g_object_unref0 (_n_list);
								_g_object_unref0 (list_of_n);
								_g_error_free0 (last_e);
								_g_object_unref0 (ret);
								g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
								g_clear_error (&_inner_error_);
								return NULL;
							}
						}
						_g_object_unref0 (n);
					}
					_g_object_unref0 (_n_list);
				}
			} else {
				netsukuku_log_debug ("PeerToPeer routing: unknown route.");
				_g_error_free0 (last_e);
				last_e = NULL;
			}
			_tmp134_ = done;
			if (_tmp134_) {
				_g_object_unref0 (list_of_n);
				_g_error_free0 (last_e);
				break;
			}
			_tmp135_ = peer_to_peer_tpl;
			_tmp136_ = _tmp135_->tc;
			_tmp137_ = tasklets_timer_is_expired ((TaskletsTimer*) _tmp136_);
			if (_tmp137_) {
				GError* _tmp138_;
				GError* _tmp141_;
				netsukuku_log_warn ("PeerToPeer routing: Too many errors. Giving up.");
				_tmp138_ = last_e;
				if (_tmp138_ != NULL) {
					GError* _tmp139_;
					GError* _tmp140_;
					_tmp139_ = last_e;
					_tmp140_ = _g_error_copy0 (_tmp139_);
					_inner_error_ = _tmp140_;
					if (_inner_error_->domain == ZCD_RPC_ERROR) {
						g_propagate_error (error, _inner_error_);
						_g_object_unref0 (list_of_n);
						_g_error_free0 (last_e);
						_g_object_unref0 (ret);
						return NULL;
					} else {
						_g_object_unref0 (list_of_n);
						_g_error_free0 (last_e);
						_g_object_unref0 (ret);
						g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
						g_clear_error (&_inner_error_);
						return NULL;
					}
				}
				_tmp141_ = g_error_new_literal (ZCD_RPC_ERROR, ZCD_RPC_ERROR_GENERIC, "Unreachable PeerToPeer destination.");
				_inner_error_ = _tmp141_;
				if (_inner_error_->domain == ZCD_RPC_ERROR) {
					g_propagate_error (error, _inner_error_);
					_g_object_unref0 (list_of_n);
					_g_error_free0 (last_e);
					_g_object_unref0 (ret);
					return NULL;
				} else {
					_g_object_unref0 (list_of_n);
					_g_error_free0 (last_e);
					_g_object_unref0 (ret);
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
					g_clear_error (&_inner_error_);
					return NULL;
				}
			} else {
				netsukuku_log_debug ("PeerToPeer routing: Temporary failure. Wait a bit and try again.");
				tasklets_ms_wait ((gint64) 1000);
			}
			_g_object_unref0 (list_of_n);
			_g_error_free0 (last_e);
		}
		_tmp142_ = g_strdup ("");
		nips = _tmp142_;
		_tmp143_ = g_strdup ("");
		nips_next = _tmp143_;
		{
			GeeList* _tmp144_;
			GeeList* _tmp145_;
			GeeList* _one_nip_list;
			GeeList* _tmp146_;
			gint _tmp147_;
			gint _tmp148_;
			gint _one_nip_size;
			gint _one_nip_index;
			_tmp144_ = ret;
			_tmp145_ = _g_object_ref0 (_tmp144_);
			_one_nip_list = _tmp145_;
			_tmp146_ = _one_nip_list;
			_tmp147_ = gee_collection_get_size ((GeeCollection*) _tmp146_);
			_tmp148_ = _tmp147_;
			_one_nip_size = _tmp148_;
			_one_nip_index = -1;
			while (TRUE) {
				gint _tmp149_;
				gint _tmp150_;
				gint _tmp151_;
				GeeList* _tmp152_;
				gint _tmp153_;
				gpointer _tmp154_ = NULL;
				NetsukukuNIP* one_nip;
				const gchar* _tmp155_;
				const gchar* _tmp156_;
				NetsukukuNIP* _tmp157_;
				gchar* _tmp158_ = NULL;
				gchar* _tmp159_;
				gchar* _tmp160_;
				gchar* _tmp161_;
				gchar* _tmp162_;
				gchar* _tmp163_;
				_tmp149_ = _one_nip_index;
				_one_nip_index = _tmp149_ + 1;
				_tmp150_ = _one_nip_index;
				_tmp151_ = _one_nip_size;
				if (!(_tmp150_ < _tmp151_)) {
					break;
				}
				_tmp152_ = _one_nip_list;
				_tmp153_ = _one_nip_index;
				_tmp154_ = gee_list_get (_tmp152_, _tmp153_);
				one_nip = (NetsukukuNIP*) _tmp154_;
				_tmp155_ = nips;
				_tmp156_ = nips_next;
				_tmp157_ = one_nip;
				_tmp158_ = netsukuku_partial_nip_to_string ((NetsukukuPartialNIP*) _tmp157_);
				_tmp159_ = _tmp158_;
				_tmp160_ = g_strconcat (_tmp156_, _tmp159_, NULL);
				_tmp161_ = _tmp160_;
				_tmp162_ = g_strconcat (_tmp155_, _tmp161_, NULL);
				_g_free0 (nips);
				nips = _tmp162_;
				_g_free0 (_tmp161_);
				_g_free0 (_tmp159_);
				_tmp163_ = g_strdup (", ");
				_g_free0 (nips_next);
				nips_next = _tmp163_;
				_g_object_unref0 (one_nip);
			}
			_g_object_unref0 (_one_nip_list);
		}
		_tmp164_ = nips;
		_tmp165_ = string_to_string (_tmp164_);
		_tmp166_ = g_strconcat ("PeerToPeer routing: Returning NIPs ", _tmp165_, ".", NULL);
		_tmp167_ = _tmp166_;
		netsukuku_log_debug (_tmp167_);
		_g_free0 (_tmp167_);
		result = ret;
		_g_free0 (nips_next);
		_g_free0 (nips);
		return result;
	}
}


/** Search functions for hooking phase. Routed. **/
gint netsukuku_peer_to_peer_get_number_of_participants (NetsukukuPeerToPeer* self, gint lvl, gint pos, gint timeout, GError** error) {
	gint result = 0;
	gint _tmp0_;
	NetsukukuPeerToPeerTracerPacketList* _tmp1_;
	NetsukukuPeerToPeerTracerPacketList* _tmp2_;
	gint _tmp3_;
	gint _tmp4_;
	gint _tmp5_ = 0;
	gint _tmp6_;
	gint _tmp7_;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = timeout;
	_tmp1_ = netsukuku_peer_to_peer_tracer_packet_list_new (_tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = lvl;
	_tmp4_ = pos;
	_tmp5_ = netsukuku_ipeer_to_peer_number_of_participants ((NetsukukuIPeerToPeer*) self, _tmp2_, _tmp3_, _tmp4_, &_inner_error_);
	_tmp6_ = _tmp5_;
	_g_object_unref0 (_tmp2_);
	_tmp7_ = _tmp6_;
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == ZCD_RPC_ERROR) {
			g_propagate_error (error, _inner_error_);
			return 0;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return 0;
		}
	}
	result = _tmp7_;
	return result;
}


static gint netsukuku_peer_to_peer_real_number_of_participants (NetsukukuIPeerToPeer* base, NetsukukuPeerToPeerTracerPacketList* peer_to_peer_tpl, gint lvl, gint pos, GError** error) {
	NetsukukuPeerToPeer * self;
	gint result = 0;
	gboolean _tmp0_;
	NetsukukuMapRoute* _tmp8_;
	NetsukukuPeerToPeerTracerPacketList* _tmp9_;
	NetsukukuPeerToPeerTracerPacketList* _tmp10_;
	gchar* _tmp11_ = NULL;
	gchar* _tmp12_;
	gint _tmp13_;
	gchar* _tmp14_ = NULL;
	gchar* _tmp15_;
	gint _tmp16_;
	gchar* _tmp17_ = NULL;
	gchar* _tmp18_;
	gchar* _tmp19_ = NULL;
	gchar* _tmp20_;
	NetsukukuPeerToPeerTracerPacketList* _tmp21_;
	gint _tmp22_;
	gint _tmp23_;
	gint _tmp24_ = 0;
	gint ret;
	gint _tmp25_;
	gchar* _tmp26_ = NULL;
	gchar* _tmp27_;
	gint _tmp28_;
	gchar* _tmp29_ = NULL;
	gchar* _tmp30_;
	gint _tmp31_;
	gchar* _tmp32_ = NULL;
	gchar* _tmp33_;
	gchar* _tmp34_ = NULL;
	gchar* _tmp35_;
	GError * _inner_error_ = NULL;
	self = (NetsukukuPeerToPeer*) base;
	g_return_val_if_fail (peer_to_peer_tpl != NULL, 0);
	_tmp0_ = self->has_valid_map;
	if (!_tmp0_) {
		GType _tmp1_ = 0UL;
		const gchar* _tmp2_ = NULL;
		const gchar* _tmp3_ = NULL;
		gchar* _tmp4_ = NULL;
		gchar* _tmp5_;
		GError* _tmp6_;
		GError* _tmp7_;
		_tmp1_ = G_TYPE_FROM_INSTANCE ((GObject*) self);
		_tmp2_ = g_type_name (_tmp1_);
		_tmp3_ = string_to_string (_tmp2_);
		_tmp4_ = g_strconcat ("Not a valid map yet for ", _tmp3_, ". Request not valid.", NULL);
		_tmp5_ = _tmp4_;
		_tmp6_ = g_error_new_literal (ZCD_RPC_ERROR, ZCD_RPC_ERROR_NOT_VALID_MAP_YET, _tmp5_);
		_tmp7_ = _tmp6_;
		_g_free0 (_tmp5_);
		_inner_error_ = _tmp7_;
		if (_inner_error_->domain == ZCD_RPC_ERROR) {
			g_propagate_error (error, _inner_error_);
			return 0;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return 0;
		}
	}
	_tmp8_ = self->maproute;
	_tmp9_ = peer_to_peer_tpl;
	netsukuku_peer_to_peer_execute (_tmp8_, _tmp9_, &_inner_error_);
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == ZCD_RPC_ERROR) {
			g_propagate_error (error, _inner_error_);
			return 0;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return 0;
		}
	}
	_tmp10_ = peer_to_peer_tpl;
	_tmp11_ = netsukuku_peer_to_peer_tracer_packet_list_to_string (_tmp10_);
	_tmp12_ = _tmp11_;
	_tmp13_ = lvl;
	_tmp14_ = g_strdup_printf ("%i", _tmp13_);
	_tmp15_ = _tmp14_;
	_tmp16_ = pos;
	_tmp17_ = g_strdup_printf ("%i", _tmp16_);
	_tmp18_ = _tmp17_;
	_tmp19_ = g_strconcat ("peertopeer: calling inside_number_of_participants(", _tmp12_, ", ", _tmp15_, ", ", _tmp18_, ");", NULL);
	_tmp20_ = _tmp19_;
	netsukuku_log_debug (_tmp20_);
	_g_free0 (_tmp20_);
	_g_free0 (_tmp18_);
	_g_free0 (_tmp15_);
	_g_free0 (_tmp12_);
	_tmp21_ = peer_to_peer_tpl;
	_tmp22_ = lvl;
	_tmp23_ = pos;
	_tmp24_ = netsukuku_peer_to_peer_inside_number_of_participants (self, _tmp21_, _tmp22_, _tmp23_, &_inner_error_);
	ret = _tmp24_;
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == ZCD_RPC_ERROR) {
			g_propagate_error (error, _inner_error_);
			return 0;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return 0;
		}
	}
	_tmp25_ = lvl;
	_tmp26_ = g_strdup_printf ("%i", _tmp25_);
	_tmp27_ = _tmp26_;
	_tmp28_ = pos;
	_tmp29_ = g_strdup_printf ("%i", _tmp28_);
	_tmp30_ = _tmp29_;
	_tmp31_ = ret;
	_tmp32_ = g_strdup_printf ("%i", _tmp31_);
	_tmp33_ = _tmp32_;
	_tmp34_ = g_strconcat ("peertopeer: inside_number_of_participants(..., ", _tmp27_, ", ", _tmp30_, ") returns ", _tmp33_, NULL);
	_tmp35_ = _tmp34_;
	netsukuku_log_debug (_tmp35_);
	_g_free0 (_tmp35_);
	_g_free0 (_tmp33_);
	_g_free0 (_tmp30_);
	_g_free0 (_tmp27_);
	result = ret;
	return result;
}


gint netsukuku_peer_to_peer_inside_number_of_participants (NetsukukuPeerToPeer* self, NetsukukuPeerToPeerTracerPacketList* peer_to_peer_tpl, gint lvl, gint pos, GError** error) {
	gint result = 0;
	gint _tmp0_;
	gint _tmp3_;
	gint _tmp4_;
	gboolean _tmp5_ = FALSE;
	NetsukukuMapRoute* _tmp6_;
	NetsukukuNIP* _tmp7_;
	NetsukukuNIP* _tmp8_;
	gint _tmp9_;
	gint _tmp10_ = 0;
	gint _tmp11_;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, 0);
	g_return_val_if_fail (peer_to_peer_tpl != NULL, 0);
	_tmp0_ = lvl;
	if (_tmp0_ == 0) {
		gint _tmp1_;
		gboolean _tmp2_ = FALSE;
		_tmp1_ = pos;
		_tmp2_ = netsukuku_peer_to_peer_is_participant (self, 0, _tmp1_);
		if (_tmp2_) {
			result = 1;
			return result;
		}
		result = 0;
		return result;
	}
	_tmp3_ = lvl;
	_tmp4_ = pos;
	_tmp5_ = netsukuku_peer_to_peer_is_participant (self, _tmp3_, _tmp4_);
	if (!_tmp5_) {
		result = 0;
		return result;
	}
	_tmp6_ = self->maproute;
	_tmp7_ = netsukuku_map_get_me ((NetsukukuMap*) _tmp6_);
	_tmp8_ = _tmp7_;
	_tmp9_ = lvl;
	_tmp10_ = netsukuku_partial_nip_position_at ((NetsukukuPartialNIP*) _tmp8_, _tmp9_);
	_tmp11_ = pos;
	if (_tmp10_ == _tmp11_) {
		gint _tmp12_;
		gint new_lvl;
		gint ret;
		_tmp12_ = lvl;
		new_lvl = _tmp12_ - 1;
		ret = 0;
		{
			gint new_pos;
			new_pos = 0;
			{
				gboolean _tmp13_;
				_tmp13_ = TRUE;
				while (TRUE) {
					gboolean _tmp14_;
					gint _tmp16_;
					NetsukukuMapRoute* _tmp17_;
					gint _tmp18_;
					gint _tmp19_;
					NetsukukuPeerToPeerTracerPacketList* _tmp20_;
					gchar* _tmp21_ = NULL;
					gchar* _tmp22_;
					gint _tmp23_;
					gchar* _tmp24_ = NULL;
					gchar* _tmp25_;
					gint _tmp26_;
					gchar* _tmp27_ = NULL;
					gchar* _tmp28_;
					gchar* _tmp29_ = NULL;
					gchar* _tmp30_;
					NetsukukuPeerToPeerTracerPacketList* _tmp31_;
					gint _tmp32_;
					gint _tmp33_;
					gint _tmp34_ = 0;
					gint _tmp35_;
					gint _tmp36_;
					_tmp14_ = _tmp13_;
					if (!_tmp14_) {
						gint _tmp15_;
						_tmp15_ = new_pos;
						new_pos = _tmp15_ + 1;
					}
					_tmp13_ = FALSE;
					_tmp16_ = new_pos;
					_tmp17_ = self->maproute;
					_tmp18_ = netsukuku_map_get_gsize ((NetsukukuMap*) _tmp17_);
					_tmp19_ = _tmp18_;
					if (!(_tmp16_ < _tmp19_)) {
						break;
					}
					_tmp20_ = peer_to_peer_tpl;
					_tmp21_ = netsukuku_peer_to_peer_tracer_packet_list_to_string (_tmp20_);
					_tmp22_ = _tmp21_;
					_tmp23_ = lvl;
					_tmp24_ = g_strdup_printf ("%i", _tmp23_);
					_tmp25_ = _tmp24_;
					_tmp26_ = pos;
					_tmp27_ = g_strdup_printf ("%i", _tmp26_);
					_tmp28_ = _tmp27_;
					_tmp29_ = g_strconcat ("peertopeer: down one level: inside_number_of_participants(", _tmp22_, ", ", _tmp25_, ", ", _tmp28_, ");", NULL);
					_tmp30_ = _tmp29_;
					netsukuku_log_debug (_tmp30_);
					_g_free0 (_tmp30_);
					_g_free0 (_tmp28_);
					_g_free0 (_tmp25_);
					_g_free0 (_tmp22_);
					_tmp31_ = peer_to_peer_tpl;
					_tmp32_ = new_lvl;
					_tmp33_ = new_pos;
					_tmp34_ = netsukuku_peer_to_peer_inside_number_of_participants (self, _tmp31_, _tmp32_, _tmp33_, &_inner_error_);
					_tmp35_ = _tmp34_;
					if (_inner_error_ != NULL) {
						if (_inner_error_->domain == ZCD_RPC_ERROR) {
							g_propagate_error (error, _inner_error_);
							return 0;
						} else {
							g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
							g_clear_error (&_inner_error_);
							return 0;
						}
					}
					_tmp36_ = ret;
					ret = _tmp36_ + _tmp35_;
				}
			}
		}
		result = ret;
		return result;
	} else {
		gint ret;
		gint _tmp105_;
		gchar* _tmp106_ = NULL;
		gchar* _tmp107_;
		gchar* _tmp108_ = NULL;
		gchar* _tmp109_;
		ret = 0;
		while (TRUE) {
			GError* last_e;
			gboolean done;
			gint _tmp37_;
			gchar* _tmp38_ = NULL;
			gchar* _tmp39_;
			gint _tmp40_;
			gchar* _tmp41_ = NULL;
			gchar* _tmp42_;
			gchar* _tmp43_ = NULL;
			gchar* _tmp44_;
			gint _tmp45_;
			gint _tmp46_;
			GeeList* _tmp47_ = NULL;
			GeeList* list_of_n;
			GeeList* _tmp48_;
			gboolean _tmp49_;
			gboolean _tmp50_;
			gboolean _tmp97_;
			NetsukukuPeerToPeerTracerPacketList* _tmp98_;
			NetsukukuTimeCapsule* _tmp99_;
			gboolean _tmp100_ = FALSE;
			last_e = NULL;
			done = FALSE;
			_tmp37_ = lvl;
			_tmp38_ = g_strdup_printf ("%i", _tmp37_);
			_tmp39_ = _tmp38_;
			_tmp40_ = pos;
			_tmp41_ = g_strdup_printf ("%i", _tmp40_);
			_tmp42_ = _tmp41_;
			_tmp43_ = g_strconcat ("PeerToPeer routing: route_number_of_participants in (", _tmp39_, ", ", _tmp42_, ")", NULL);
			_tmp44_ = _tmp43_;
			netsukuku_log_debug (_tmp44_);
			_g_free0 (_tmp44_);
			_g_free0 (_tmp42_);
			_g_free0 (_tmp39_);
			_tmp45_ = lvl;
			_tmp46_ = pos;
			_tmp47_ = netsukuku_peer_to_peer_neighbours_get_from_lvl_pos (self, _tmp45_, _tmp46_);
			list_of_n = _tmp47_;
			_tmp48_ = list_of_n;
			_tmp49_ = gee_collection_get_is_empty ((GeeCollection*) _tmp48_);
			_tmp50_ = _tmp49_;
			if (!_tmp50_) {
				{
					GeeList* _tmp51_;
					GeeList* _tmp52_;
					GeeList* _n_list;
					GeeList* _tmp53_;
					gint _tmp54_;
					gint _tmp55_;
					gint _n_size;
					gint _n_index;
					_tmp51_ = list_of_n;
					_tmp52_ = _g_object_ref0 (_tmp51_);
					_n_list = _tmp52_;
					_tmp53_ = _n_list;
					_tmp54_ = gee_collection_get_size ((GeeCollection*) _tmp53_);
					_tmp55_ = _tmp54_;
					_n_size = _tmp55_;
					_n_index = -1;
					while (TRUE) {
						gint _tmp56_;
						gint _tmp57_;
						gint _tmp58_;
						GeeList* _tmp59_;
						gint _tmp60_;
						gpointer _tmp61_ = NULL;
						NetsukukuAggregatedNeighbour* n;
						NetsukukuAggregatedNeighbour* _tmp62_;
						gchar* _tmp63_ = NULL;
						gchar* _tmp64_;
						gchar* _tmp65_ = NULL;
						gchar* _tmp66_;
						_tmp56_ = _n_index;
						_n_index = _tmp56_ + 1;
						_tmp57_ = _n_index;
						_tmp58_ = _n_size;
						if (!(_tmp57_ < _tmp58_)) {
							break;
						}
						_tmp59_ = _n_list;
						_tmp60_ = _n_index;
						_tmp61_ = gee_list_get (_tmp59_, _tmp60_);
						n = (NetsukukuAggregatedNeighbour*) _tmp61_;
						_tmp62_ = n;
						_tmp63_ = netsukuku_aggregated_neighbour_to_string (_tmp62_);
						_tmp64_ = _tmp63_;
						_tmp65_ = g_strconcat ("PeerToPeer routing: pass through ", _tmp64_, NULL);
						_tmp66_ = _tmp65_;
						netsukuku_log_debug (_tmp66_);
						_g_free0 (_tmp66_);
						_g_free0 (_tmp64_);
						{
							NetsukukuAggregatedNeighbour* _tmp67_;
							NetsukukuAddressManagerTCPClient* _tmp68_;
							NetsukukuAddressManagerTCPClient* _tmp69_;
							gint _tmp70_;
							NetsukukuIPeerToPeer* _tmp71_ = NULL;
							NetsukukuIPeerToPeer* _tmp72_;
							NetsukukuPeerToPeerTracerPacketList* _tmp73_;
							gint _tmp74_;
							gint _tmp75_;
							gint _tmp76_ = 0;
							gint _tmp77_;
							gint _tmp78_;
							_tmp67_ = n;
							_tmp68_ = netsukuku_aggregated_neighbour_get_tcp_client (_tmp67_);
							_tmp69_ = _tmp68_;
							_tmp70_ = self->pid;
							_tmp71_ = netsukuku_iaddress_manager_root_dispatcher_get_peer_to_peer_service ((NetsukukuIAddressManagerRootDispatcher*) _tmp69_, _tmp70_);
							_tmp72_ = _tmp71_;
							_tmp73_ = peer_to_peer_tpl;
							_tmp74_ = lvl;
							_tmp75_ = pos;
							_tmp76_ = netsukuku_ipeer_to_peer_number_of_participants (_tmp72_, _tmp73_, _tmp74_, _tmp75_, &_inner_error_);
							_tmp77_ = _tmp76_;
							_g_object_unref0 (_tmp72_);
							_tmp78_ = _tmp77_;
							if (_inner_error_ != NULL) {
								if (_inner_error_->domain == ZCD_RPC_ERROR) {
									goto __catch97_zcd_rpc_error;
								}
								_g_object_unref0 (n);
								_g_object_unref0 (_n_list);
								_g_object_unref0 (list_of_n);
								_g_error_free0 (last_e);
								g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
								g_clear_error (&_inner_error_);
								return 0;
							}
							ret = _tmp78_;
							done = TRUE;
						}
						goto __finally97;
						__catch97_zcd_rpc_error:
						{
							GError* e = NULL;
							GError* _tmp79_;
							e = _inner_error_;
							_inner_error_ = NULL;
							_tmp79_ = e;
							if (g_error_matches (_tmp79_, ZCD_RPC_ERROR, ZCD_RPC_ERROR_NOT_VALID_MAP_YET)) {
								GError* _tmp80_;
								GQuark _tmp81_;
								const gchar* _tmp82_ = NULL;
								const gchar* _tmp83_ = NULL;
								GError* _tmp84_;
								gint _tmp85_;
								gchar* _tmp86_ = NULL;
								gchar* _tmp87_;
								GError* _tmp88_;
								const gchar* _tmp89_;
								const gchar* _tmp90_ = NULL;
								gchar* _tmp91_ = NULL;
								gchar* _tmp92_;
								GError* _tmp93_;
								GError* _tmp94_;
								_tmp80_ = e;
								_tmp81_ = _tmp80_->domain;
								_tmp82_ = g_quark_to_string (_tmp81_);
								_tmp83_ = string_to_string (_tmp82_);
								_tmp84_ = e;
								_tmp85_ = _tmp84_->code;
								_tmp86_ = g_strdup_printf ("%i", _tmp85_);
								_tmp87_ = _tmp86_;
								_tmp88_ = e;
								_tmp89_ = _tmp88_->message;
								_tmp90_ = string_to_string (_tmp89_);
								_tmp91_ = g_strconcat ("PeerToPeer routing: got ", _tmp83_, " ", _tmp87_, " ", _tmp90_, NULL);
								_tmp92_ = _tmp91_;
								netsukuku_log_debug (_tmp92_);
								_g_free0 (_tmp92_);
								_g_free0 (_tmp87_);
								_tmp93_ = e;
								_tmp94_ = _g_error_copy0 (_tmp93_);
								_g_error_free0 (last_e);
								last_e = _tmp94_;
							} else {
								GError* _tmp95_;
								GError* _tmp96_;
								_tmp95_ = e;
								_tmp96_ = _g_error_copy0 (_tmp95_);
								_inner_error_ = _tmp96_;
								_g_error_free0 (e);
								goto __finally97;
							}
							_g_error_free0 (e);
						}
						__finally97:
						if (_inner_error_ != NULL) {
							if (_inner_error_->domain == ZCD_RPC_ERROR) {
								g_propagate_error (error, _inner_error_);
								_g_object_unref0 (n);
								_g_object_unref0 (_n_list);
								_g_object_unref0 (list_of_n);
								_g_error_free0 (last_e);
								return 0;
							} else {
								_g_object_unref0 (n);
								_g_object_unref0 (_n_list);
								_g_object_unref0 (list_of_n);
								_g_error_free0 (last_e);
								g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
								g_clear_error (&_inner_error_);
								return 0;
							}
						}
						_g_object_unref0 (n);
					}
					_g_object_unref0 (_n_list);
				}
			} else {
				netsukuku_log_debug ("PeerToPeer routing: unknown route.");
				_g_error_free0 (last_e);
				last_e = NULL;
			}
			_tmp97_ = done;
			if (_tmp97_) {
				_g_object_unref0 (list_of_n);
				_g_error_free0 (last_e);
				break;
			}
			_tmp98_ = peer_to_peer_tpl;
			_tmp99_ = _tmp98_->tc;
			_tmp100_ = tasklets_timer_is_expired ((TaskletsTimer*) _tmp99_);
			if (_tmp100_) {
				GError* _tmp101_;
				GError* _tmp104_;
				netsukuku_log_warn ("PeerToPeer routing: Too many errors. Giving up.");
				_tmp101_ = last_e;
				if (_tmp101_ != NULL) {
					GError* _tmp102_;
					GError* _tmp103_;
					_tmp102_ = last_e;
					_tmp103_ = _g_error_copy0 (_tmp102_);
					_inner_error_ = _tmp103_;
					if (_inner_error_->domain == ZCD_RPC_ERROR) {
						g_propagate_error (error, _inner_error_);
						_g_object_unref0 (list_of_n);
						_g_error_free0 (last_e);
						return 0;
					} else {
						_g_object_unref0 (list_of_n);
						_g_error_free0 (last_e);
						g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
						g_clear_error (&_inner_error_);
						return 0;
					}
				}
				_tmp104_ = g_error_new_literal (ZCD_RPC_ERROR, ZCD_RPC_ERROR_GENERIC, "Unreachable PeerToPeer destination.");
				_inner_error_ = _tmp104_;
				if (_inner_error_->domain == ZCD_RPC_ERROR) {
					g_propagate_error (error, _inner_error_);
					_g_object_unref0 (list_of_n);
					_g_error_free0 (last_e);
					return 0;
				} else {
					_g_object_unref0 (list_of_n);
					_g_error_free0 (last_e);
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
					g_clear_error (&_inner_error_);
					return 0;
				}
			} else {
				netsukuku_log_debug ("PeerToPeer routing: Temporary failure. Wait a bit and try again.");
				tasklets_ms_wait ((gint64) 1000);
			}
			_g_object_unref0 (list_of_n);
			_g_error_free0 (last_e);
		}
		_tmp105_ = ret;
		_tmp106_ = g_strdup_printf ("%i", _tmp105_);
		_tmp107_ = _tmp106_;
		_tmp108_ = g_strconcat ("PeerToPeer routing: Returning stuff ", _tmp107_, NULL);
		_tmp109_ = _tmp108_;
		netsukuku_log_debug (_tmp109_);
		_g_free0 (_tmp109_);
		_g_free0 (_tmp107_);
		result = ret;
		return result;
	}
}


/** Helper functions for hooking phase. **/
static gint* _int_dup (gint* self) {
	gint* dup;
	dup = g_new0 (gint, 1);
	memcpy (dup, self, sizeof (gint));
	return dup;
}


static gpointer __int_dup0 (gpointer self) {
	return self ? _int_dup (self) : NULL;
}


void netsukuku_peer_to_peer_find_hook_peers (NetsukukuPeerToPeer* self, gint** ret_first_forward, gint** ret_first_back, gint** ret_last_back, gint lvl, gint num_dupl, gint timeout) {
	gint* _vala_ret_first_forward = NULL;
	gint* _vala_ret_first_back = NULL;
	gint* _vala_ret_last_back = NULL;
	NetsukukuMapRoute* _tmp0_;
	NetsukukuNIP* _tmp1_;
	NetsukukuNIP* _tmp2_;
	gint _tmp3_;
	gint _tmp4_ = 0;
	GeeList* _tmp5_ = NULL;
	GeeList* ids_me_forward;
	GeeList* _tmp6_;
	gint* _tmp26_;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	_g_free0 (_vala_ret_first_forward);
	_vala_ret_first_forward = NULL;
	_g_free0 (_vala_ret_first_back);
	_vala_ret_first_back = NULL;
	_g_free0 (_vala_ret_last_back);
	_vala_ret_last_back = NULL;
	_tmp0_ = self->maproute;
	_tmp1_ = netsukuku_map_get_me ((NetsukukuMap*) _tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = lvl;
	_tmp4_ = netsukuku_partial_nip_position_at ((NetsukukuPartialNIP*) _tmp2_, _tmp3_);
	_tmp5_ = netsukuku_peer_to_peer_list_ids (self, _tmp4_, 1);
	ids_me_forward = _tmp5_;
	_tmp6_ = ids_me_forward;
	gee_list_remove_at (_tmp6_, 0);
	{
		GeeList* _tmp7_;
		GeeList* _tmp8_;
		GeeList* __id_list;
		GeeList* _tmp9_;
		gint _tmp10_;
		gint _tmp11_;
		gint __id_size;
		gint __id_index;
		_tmp7_ = ids_me_forward;
		_tmp8_ = _g_object_ref0 (_tmp7_);
		__id_list = _tmp8_;
		_tmp9_ = __id_list;
		_tmp10_ = gee_collection_get_size ((GeeCollection*) _tmp9_);
		_tmp11_ = _tmp10_;
		__id_size = _tmp11_;
		__id_index = -1;
		while (TRUE) {
			gint _tmp12_;
			gint _tmp13_;
			gint _tmp14_;
			GeeList* _tmp15_;
			gint _tmp16_;
			gpointer _tmp17_ = NULL;
			gint _id;
			gint num;
			gint _tmp23_;
			_tmp12_ = __id_index;
			__id_index = _tmp12_ + 1;
			_tmp13_ = __id_index;
			_tmp14_ = __id_size;
			if (!(_tmp13_ < _tmp14_)) {
				break;
			}
			_tmp15_ = __id_list;
			_tmp16_ = __id_index;
			_tmp17_ = gee_list_get (_tmp15_, _tmp16_);
			_id = (gint) ((gintptr) _tmp17_);
			num = 0;
			{
				gint _tmp18_;
				gint _tmp19_;
				gint _tmp20_;
				gint _tmp21_ = 0;
				gint _tmp22_;
				_tmp18_ = lvl;
				_tmp19_ = _id;
				_tmp20_ = timeout;
				_tmp21_ = netsukuku_peer_to_peer_get_number_of_participants (self, _tmp18_, _tmp19_, _tmp20_, &_inner_error_);
				_tmp22_ = _tmp21_;
				if (_inner_error_ != NULL) {
					if (_inner_error_->domain == ZCD_RPC_ERROR) {
						goto __catch98_zcd_rpc_error;
					}
					_g_object_unref0 (__id_list);
					_g_object_unref0 (ids_me_forward);
					g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
					g_clear_error (&_inner_error_);
					return;
				}
				num = _tmp22_;
			}
			goto __finally98;
			__catch98_zcd_rpc_error:
			{
				GError* e = NULL;
				e = _inner_error_;
				_inner_error_ = NULL;
				_g_error_free0 (e);
			}
			__finally98:
			if (_inner_error_ != NULL) {
				_g_object_unref0 (__id_list);
				_g_object_unref0 (ids_me_forward);
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return;
			}
			_tmp23_ = num;
			if (_tmp23_ > 0) {
				gint _tmp24_;
				gint* _tmp25_;
				_tmp24_ = _id;
				_tmp25_ = __int_dup0 (&_tmp24_);
				_g_free0 (_vala_ret_first_forward);
				_vala_ret_first_forward = _tmp25_;
				break;
			}
		}
		_g_object_unref0 (__id_list);
	}
	_tmp26_ = _vala_ret_first_forward;
	if (_tmp26_ != NULL) {
		NetsukukuMapRoute* _tmp27_;
		NetsukukuNIP* _tmp28_;
		NetsukukuNIP* _tmp29_;
		gint _tmp30_;
		gint _tmp31_ = 0;
		GeeList* _tmp32_ = NULL;
		GeeList* ids_me_back;
		GeeList* _tmp33_;
		gint _tmp34_;
		gint remaining;
		gint _tmp62_;
		_tmp27_ = self->maproute;
		_tmp28_ = netsukuku_map_get_me ((NetsukukuMap*) _tmp27_);
		_tmp29_ = _tmp28_;
		_tmp30_ = lvl;
		_tmp31_ = netsukuku_partial_nip_position_at ((NetsukukuPartialNIP*) _tmp29_, _tmp30_);
		_tmp32_ = netsukuku_peer_to_peer_list_ids (self, _tmp31_, -1);
		ids_me_back = _tmp32_;
		_tmp33_ = ids_me_back;
		gee_list_remove_at (_tmp33_, 0);
		_tmp34_ = num_dupl;
		remaining = _tmp34_;
		{
			GeeList* _tmp35_;
			GeeList* _tmp36_;
			GeeList* __id_list;
			GeeList* _tmp37_;
			gint _tmp38_;
			gint _tmp39_;
			gint __id_size;
			gint __id_index;
			_tmp35_ = ids_me_back;
			_tmp36_ = _g_object_ref0 (_tmp35_);
			__id_list = _tmp36_;
			_tmp37_ = __id_list;
			_tmp38_ = gee_collection_get_size ((GeeCollection*) _tmp37_);
			_tmp39_ = _tmp38_;
			__id_size = _tmp39_;
			__id_index = -1;
			while (TRUE) {
				gint _tmp40_;
				gint _tmp41_;
				gint _tmp42_;
				GeeList* _tmp43_;
				gint _tmp44_;
				gpointer _tmp45_ = NULL;
				gint _id;
				gint num;
				gboolean _tmp51_ = FALSE;
				gint _tmp52_;
				gboolean _tmp54_;
				gint _tmp57_;
				gint _tmp58_;
				gint _tmp59_;
				_tmp40_ = __id_index;
				__id_index = _tmp40_ + 1;
				_tmp41_ = __id_index;
				_tmp42_ = __id_size;
				if (!(_tmp41_ < _tmp42_)) {
					break;
				}
				_tmp43_ = __id_list;
				_tmp44_ = __id_index;
				_tmp45_ = gee_list_get (_tmp43_, _tmp44_);
				_id = (gint) ((gintptr) _tmp45_);
				num = 0;
				{
					gint _tmp46_;
					gint _tmp47_;
					gint _tmp48_;
					gint _tmp49_ = 0;
					gint _tmp50_;
					_tmp46_ = lvl;
					_tmp47_ = _id;
					_tmp48_ = timeout;
					_tmp49_ = netsukuku_peer_to_peer_get_number_of_participants (self, _tmp46_, _tmp47_, _tmp48_, &_inner_error_);
					_tmp50_ = _tmp49_;
					if (_inner_error_ != NULL) {
						if (_inner_error_->domain == ZCD_RPC_ERROR) {
							goto __catch99_zcd_rpc_error;
						}
						_g_object_unref0 (__id_list);
						_g_object_unref0 (ids_me_back);
						_g_object_unref0 (ids_me_forward);
						g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
						g_clear_error (&_inner_error_);
						return;
					}
					num = _tmp50_;
				}
				goto __finally99;
				__catch99_zcd_rpc_error:
				{
					GError* e = NULL;
					e = _inner_error_;
					_inner_error_ = NULL;
					_g_error_free0 (e);
				}
				__finally99:
				if (_inner_error_ != NULL) {
					_g_object_unref0 (__id_list);
					_g_object_unref0 (ids_me_back);
					_g_object_unref0 (ids_me_forward);
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
					g_clear_error (&_inner_error_);
					return;
				}
				_tmp52_ = num;
				if (_tmp52_ > 0) {
					gint* _tmp53_;
					_tmp53_ = _vala_ret_first_back;
					_tmp51_ = _tmp53_ == NULL;
				} else {
					_tmp51_ = FALSE;
				}
				_tmp54_ = _tmp51_;
				if (_tmp54_) {
					gint _tmp55_;
					gint* _tmp56_;
					_tmp55_ = _id;
					_tmp56_ = __int_dup0 (&_tmp55_);
					_g_free0 (_vala_ret_first_back);
					_vala_ret_first_back = _tmp56_;
				}
				_tmp57_ = remaining;
				_tmp58_ = num;
				remaining = _tmp57_ - _tmp58_;
				_tmp59_ = remaining;
				if (_tmp59_ <= 0) {
					gint _tmp60_;
					gint* _tmp61_;
					_tmp60_ = _id;
					_tmp61_ = __int_dup0 (&_tmp60_);
					_g_free0 (_vala_ret_last_back);
					_vala_ret_last_back = _tmp61_;
					break;
				}
			}
			_g_object_unref0 (__id_list);
		}
		_tmp62_ = remaining;
		if (_tmp62_ > 0) {
			_g_free0 (_vala_ret_first_back);
			_vala_ret_first_back = NULL;
		}
		_g_object_unref0 (ids_me_back);
	}
	_g_object_unref0 (ids_me_forward);
	if (ret_first_forward) {
		*ret_first_forward = _vala_ret_first_forward;
	} else {
		_g_free0 (_vala_ret_first_forward);
	}
	if (ret_first_back) {
		*ret_first_back = _vala_ret_first_back;
	} else {
		_g_free0 (_vala_ret_first_back);
	}
	if (ret_last_back) {
		*ret_last_back = _vala_ret_last_back;
	} else {
		_g_free0 (_vala_ret_last_back);
	}
}


static void netsukuku_peer_to_peer_class_init (NetsukukuPeerToPeerClass * klass) {
	netsukuku_peer_to_peer_parent_class = g_type_class_peek_parent (klass);
	NETSUKUKU_PEER_TO_PEER_CLASS (klass)->start_operations = netsukuku_peer_to_peer_real_start_operations;
	NETSUKUKU_PEER_TO_PEER_CLASS (klass)->stop_operations = netsukuku_peer_to_peer_real_stop_operations;
	NETSUKUKU_PEER_TO_PEER_CLASS (klass)->is_participant = netsukuku_peer_to_peer_real_is_participant;
	NETSUKUKU_PEER_TO_PEER_CLASS (klass)->h = netsukuku_peer_to_peer_real_h;
	G_OBJECT_CLASS (klass)->finalize = netsukuku_peer_to_peer_finalize;
	g_signal_new ("map_peer_to_peer_validated", NETSUKUKU_TYPE_PEER_TO_PEER, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
}


static void netsukuku_peer_to_peer_netsukuku_ipeer_to_peer_interface_init (NetsukukuIPeerToPeerIface * iface) {
	netsukuku_peer_to_peer_netsukuku_ipeer_to_peer_parent_iface = g_type_interface_peek_parent (iface);
	iface->msg_send = (zcdISerializable* (*)(NetsukukuIPeerToPeer*, NetsukukuNIP*, NetsukukuNIP*, zcdRemoteCall*, GError**)) netsukuku_peer_to_peer_real_msg_send;
	iface->msg_deliver = (zcdISerializable* (*)(NetsukukuIPeerToPeer*, NetsukukuPeerToPeerTracerPacketList*, NetsukukuNIP*, NetsukukuNIP*, zcdRemoteCall*, GError**)) netsukuku_peer_to_peer_real_msg_deliver;
	iface->find_nearest = (GeeList* (*)(NetsukukuIPeerToPeer*, NetsukukuPeerToPeerTracerPacketList*, NetsukukuNIP*, gint, gint, gint, GError**)) netsukuku_peer_to_peer_real_find_nearest;
	iface->number_of_participants = (gint (*)(NetsukukuIPeerToPeer*, NetsukukuPeerToPeerTracerPacketList*, gint, gint, GError**)) netsukuku_peer_to_peer_real_number_of_participants;
}


static void netsukuku_peer_to_peer_instance_init (NetsukukuPeerToPeer * self) {
}


static void netsukuku_peer_to_peer_finalize (GObject* obj) {
	NetsukukuPeerToPeer * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, NETSUKUKU_TYPE_PEER_TO_PEER, NetsukukuPeerToPeer);
	G_OBJECT_CLASS (netsukuku_peer_to_peer_parent_class)->finalize (obj);
}


/** This is the class that must be inherited to create a Strict PeerToPeer module
      *  service. A strict service is a service where all the hosts connected 
      *  to Netsukuku are participant, so the MapPeerToPeer is not used here.
      */
GType netsukuku_peer_to_peer_get_type (void) {
	static volatile gsize netsukuku_peer_to_peer_type_id__volatile = 0;
	if (g_once_init_enter (&netsukuku_peer_to_peer_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (NetsukukuPeerToPeerClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) netsukuku_peer_to_peer_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (NetsukukuPeerToPeer), 0, (GInstanceInitFunc) netsukuku_peer_to_peer_instance_init, NULL };
		static const GInterfaceInfo netsukuku_ipeer_to_peer_info = { (GInterfaceInitFunc) netsukuku_peer_to_peer_netsukuku_ipeer_to_peer_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
		GType netsukuku_peer_to_peer_type_id;
		netsukuku_peer_to_peer_type_id = g_type_register_static (ZCD_TYPE_RPC_DISPATCHER, "NetsukukuPeerToPeer", &g_define_type_info, 0);
		g_type_add_interface_static (netsukuku_peer_to_peer_type_id, NETSUKUKU_TYPE_IPEER_TO_PEER, &netsukuku_ipeer_to_peer_info);
		g_once_init_leave (&netsukuku_peer_to_peer_type_id__volatile, netsukuku_peer_to_peer_type_id);
	}
	return netsukuku_peer_to_peer_type_id__volatile;
}


NetsukukuRmtPeer* netsukuku_rmt_peer_construct (GType object_type, NetsukukuPeerToPeer* peer_to_peer_service, GObject* key, NetsukukuNIP* hIP, NetsukukuAggregatedNeighbour* aggregated_neighbour) {
	NetsukukuRmtPeer * self = NULL;
	NetsukukuPeerToPeer* _tmp0_;
	NetsukukuPeerToPeer* _tmp1_;
	GObject* _tmp2_;
	GObject* _tmp3_;
	NetsukukuNIP* _tmp4_;
	NetsukukuNIP* _tmp5_;
	NetsukukuAggregatedNeighbour* _tmp6_;
	NetsukukuAggregatedNeighbour* _tmp7_;
	g_return_val_if_fail (peer_to_peer_service != NULL, NULL);
	self = (NetsukukuRmtPeer*) g_object_new (object_type, NULL);
	_tmp0_ = peer_to_peer_service;
	_tmp1_ = _g_object_ref0 (_tmp0_);
	_g_object_unref0 (self->priv->peer_to_peer_service);
	self->priv->peer_to_peer_service = _tmp1_;
	_tmp2_ = key;
	_tmp3_ = _g_object_ref0 (_tmp2_);
	_g_object_unref0 (self->priv->key);
	self->priv->key = _tmp3_;
	_tmp4_ = hIP;
	_tmp5_ = _g_object_ref0 (_tmp4_);
	_g_object_unref0 (self->priv->hIP);
	self->priv->hIP = _tmp5_;
	_tmp6_ = aggregated_neighbour;
	_tmp7_ = _g_object_ref0 (_tmp6_);
	_g_object_unref0 (self->priv->aggregated_neighbour);
	self->priv->aggregated_neighbour = _tmp7_;
	return self;
}


void netsukuku_rmt_peer_evaluate_hash_nip (NetsukukuRmtPeer* self, GError** error) {
	NetsukukuNIP* _tmp0_;
	NetsukukuNIP* _tmp4_;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->hIP;
	if (_tmp0_ == NULL) {
		NetsukukuPeerToPeer* _tmp1_;
		GObject* _tmp2_;
		NetsukukuNIP* _tmp3_ = NULL;
		_tmp1_ = self->priv->peer_to_peer_service;
		_tmp2_ = self->priv->key;
		_tmp3_ = netsukuku_peer_to_peer_h (_tmp1_, _tmp2_);
		_g_object_unref0 (self->priv->hIP);
		self->priv->hIP = _tmp3_;
	}
	_tmp4_ = self->priv->hIP;
	if (_tmp4_ == NULL) {
		NetsukukuPeerToPeer* _tmp5_;
		gint _tmp6_;
		gint pid;
		gint _tmp7_;
		gchar* _tmp8_ = NULL;
		gchar* _tmp9_;
		gchar* _tmp10_ = NULL;
		gchar* _tmp11_;
		GError* _tmp12_;
		GError* _tmp13_;
		_tmp5_ = self->priv->peer_to_peer_service;
		_tmp6_ = _tmp5_->pid;
		pid = _tmp6_;
		_tmp7_ = pid;
		_tmp8_ = g_strdup_printf ("%i", _tmp7_);
		_tmp9_ = _tmp8_;
		_tmp10_ = g_strconcat ("PeerToPeer # ", _tmp9_, ": key does not map to a IP.", NULL);
		_tmp11_ = _tmp10_;
		_tmp12_ = g_error_new_literal (NETSUKUKU_PEER_TO_PEER_ERROR, NETSUKUKU_PEER_TO_PEER_ERROR_GENERIC, _tmp11_);
		_tmp13_ = _tmp12_;
		_g_free0 (_tmp11_);
		_g_free0 (_tmp9_);
		_inner_error_ = _tmp13_;
		if (_inner_error_->domain == NETSUKUKU_PEER_TO_PEER_ERROR) {
			g_propagate_error (error, _inner_error_);
			return;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
	}
}


NetsukukuNIP* netsukuku_rmt_peer_get_hash_nip (NetsukukuRmtPeer* self, GError** error) {
	NetsukukuNIP* result = NULL;
	NetsukukuNIP* _tmp0_;
	NetsukukuNIP* _tmp1_;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	netsukuku_rmt_peer_evaluate_hash_nip (self, &_inner_error_);
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == NETSUKUKU_PEER_TO_PEER_ERROR) {
			g_propagate_error (error, _inner_error_);
			return NULL;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	}
	_tmp0_ = self->priv->hIP;
	_tmp1_ = _g_object_ref0 (_tmp0_);
	result = _tmp1_;
	return result;
}


/** Overridable. Similar to FakeRmt.rmt()
          */
static zcdISerializable* netsukuku_rmt_peer_real_rmt (NetsukukuRmtPeer* self, zcdRemoteCall* data, GError** error) {
	zcdISerializable* result = NULL;
	NetsukukuAggregatedNeighbour* _tmp0_;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (data != NULL, NULL);
	netsukuku_rmt_peer_evaluate_hash_nip (self, &_inner_error_);
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		return NULL;
	}
	_tmp0_ = self->priv->aggregated_neighbour;
	if (_tmp0_ != NULL) {
		NetsukukuAggregatedNeighbour* _tmp1_;
		gchar* _tmp2_ = NULL;
		gchar* _tmp3_;
		gchar* _tmp4_ = NULL;
		gchar* _tmp5_;
		NetsukukuAggregatedNeighbour* _tmp6_;
		NetsukukuAddressManagerFakeRmt* _tmp7_;
		NetsukukuAddressManagerFakeRmt* _tmp8_;
		NetsukukuAddressManagerFakeRmt* _tmp9_;
		NetsukukuAddressManagerFakeRmt* nclient;
		NetsukukuAddressManagerFakeRmt* _tmp10_;
		NetsukukuPeerToPeer* _tmp11_;
		gint _tmp12_;
		NetsukukuIPeerToPeer* _tmp13_ = NULL;
		NetsukukuIPeerToPeer* caller;
		NetsukukuIPeerToPeer* _tmp14_;
		NetsukukuPeerToPeer* _tmp15_;
		NetsukukuMapRoute* _tmp16_;
		NetsukukuNIP* _tmp17_;
		NetsukukuNIP* _tmp18_;
		NetsukukuNIP* _tmp19_;
		zcdRemoteCall* _tmp20_;
		zcdISerializable* _tmp21_ = NULL;
		zcdISerializable* _tmp22_;
		_tmp1_ = self->priv->aggregated_neighbour;
		_tmp2_ = netsukuku_aggregated_neighbour_to_string (_tmp1_);
		_tmp3_ = _tmp2_;
		_tmp4_ = g_strconcat ("PeerToPeer: Use UDP via ", _tmp3_, " to reach peer.", NULL);
		_tmp5_ = _tmp4_;
		netsukuku_log_debug (_tmp5_);
		_g_free0 (_tmp5_);
		_g_free0 (_tmp3_);
		_tmp6_ = self->priv->aggregated_neighbour;
		_tmp7_ = netsukuku_aggregated_neighbour_get_neighbour_client (_tmp6_);
		_tmp8_ = _tmp7_;
		_tmp9_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp8_, NETSUKUKU_TYPE_ADDRESS_MANAGER_FAKE_RMT, NetsukukuAddressManagerFakeRmt));
		nclient = _tmp9_;
		_tmp10_ = nclient;
		_tmp11_ = self->priv->peer_to_peer_service;
		_tmp12_ = _tmp11_->pid;
		_tmp13_ = netsukuku_iaddress_manager_root_dispatcher_get_peer_to_peer_service ((NetsukukuIAddressManagerRootDispatcher*) _tmp10_, _tmp12_);
		caller = _tmp13_;
		_tmp14_ = caller;
		_tmp15_ = self->priv->peer_to_peer_service;
		_tmp16_ = _tmp15_->maproute;
		_tmp17_ = netsukuku_map_get_me ((NetsukukuMap*) _tmp16_);
		_tmp18_ = _tmp17_;
		_tmp19_ = self->priv->hIP;
		_tmp20_ = data;
		_tmp21_ = netsukuku_ipeer_to_peer_msg_send (_tmp14_, _tmp18_, _tmp19_, _tmp20_, &_inner_error_);
		_tmp22_ = _tmp21_;
		if (_inner_error_ != NULL) {
			g_propagate_error (error, _inner_error_);
			_g_object_unref0 (caller);
			_g_object_unref0 (nclient);
			return NULL;
		}
		result = _tmp22_;
		_g_object_unref0 (caller);
		_g_object_unref0 (nclient);
		return result;
	} else {
		NetsukukuPeerToPeer* _tmp23_;
		NetsukukuPeerToPeer* _tmp24_;
		NetsukukuMapRoute* _tmp25_;
		NetsukukuNIP* _tmp26_;
		NetsukukuNIP* _tmp27_;
		NetsukukuNIP* _tmp28_;
		zcdRemoteCall* _tmp29_;
		zcdISerializable* _tmp30_ = NULL;
		zcdISerializable* _tmp31_;
		netsukuku_log_debug ("PeerToPeer: Use TCP to reach peer.");
		_tmp23_ = self->priv->peer_to_peer_service;
		_tmp24_ = self->priv->peer_to_peer_service;
		_tmp25_ = _tmp24_->maproute;
		_tmp26_ = netsukuku_map_get_me ((NetsukukuMap*) _tmp25_);
		_tmp27_ = _tmp26_;
		_tmp28_ = self->priv->hIP;
		_tmp29_ = data;
		_tmp30_ = netsukuku_ipeer_to_peer_msg_send ((NetsukukuIPeerToPeer*) _tmp23_, _tmp27_, _tmp28_, _tmp29_, &_inner_error_);
		_tmp31_ = _tmp30_;
		if (_inner_error_ != NULL) {
			g_propagate_error (error, _inner_error_);
			return NULL;
		}
		result = _tmp31_;
		return result;
	}
}


zcdISerializable* netsukuku_rmt_peer_rmt (NetsukukuRmtPeer* self, zcdRemoteCall* data, GError** error) {
	g_return_val_if_fail (self != NULL, NULL);
	return NETSUKUKU_RMT_PEER_GET_CLASS (self)->rmt (self, data, error);
}


static void netsukuku_rmt_peer_class_init (NetsukukuRmtPeerClass * klass) {
	netsukuku_rmt_peer_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (NetsukukuRmtPeerPrivate));
	NETSUKUKU_RMT_PEER_CLASS (klass)->rmt = netsukuku_rmt_peer_real_rmt;
	G_OBJECT_CLASS (klass)->finalize = netsukuku_rmt_peer_finalize;
}


static void netsukuku_rmt_peer_instance_init (NetsukukuRmtPeer * self) {
	self->priv = NETSUKUKU_RMT_PEER_GET_PRIVATE (self);
}


static void netsukuku_rmt_peer_finalize (GObject* obj) {
	NetsukukuRmtPeer * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, NETSUKUKU_TYPE_RMT_PEER, NetsukukuRmtPeer);
	_g_object_unref0 (self->priv->peer_to_peer_service);
	_g_object_unref0 (self->priv->key);
	_g_object_unref0 (self->priv->hIP);
	_g_object_unref0 (self->priv->aggregated_neighbour);
	G_OBJECT_CLASS (netsukuku_rmt_peer_parent_class)->finalize (obj);
}


GType netsukuku_rmt_peer_get_type (void) {
	static volatile gsize netsukuku_rmt_peer_type_id__volatile = 0;
	if (g_once_init_enter (&netsukuku_rmt_peer_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (NetsukukuRmtPeerClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) netsukuku_rmt_peer_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (NetsukukuRmtPeer), 0, (GInstanceInitFunc) netsukuku_rmt_peer_instance_init, NULL };
		GType netsukuku_rmt_peer_type_id;
		netsukuku_rmt_peer_type_id = g_type_register_static (G_TYPE_OBJECT, "NetsukukuRmtPeer", &g_define_type_info, G_TYPE_FLAG_ABSTRACT);
		g_once_init_leave (&netsukuku_rmt_peer_type_id__volatile, netsukuku_rmt_peer_type_id);
	}
	return netsukuku_rmt_peer_type_id__volatile;
}


void netsukuku_struct_helper_optionalpeertopeer_participant_set_copy (const Netsukukustruct_helper_OptionalPeerToPeer_participant_set* self, Netsukukustruct_helper_OptionalPeerToPeer_participant_set* dest) {
	NetsukukuOptionalPeerToPeer* _tmp0_;
	NetsukukuOptionalPeerToPeer* _tmp1_;
	NetsukukuNIP* _tmp2_;
	NetsukukuNIP* _tmp3_;
	gint _tmp4_;
	gint _tmp5_;
	NetsukukuParticipantNode* _tmp6_;
	NetsukukuParticipantNode* _tmp7_;
	_tmp0_ = (*self).self;
	_tmp1_ = _g_object_ref0 (_tmp0_);
	_g_object_unref0 ((*dest).self);
	(*dest).self = _tmp1_;
	_tmp2_ = (*self).nip;
	_tmp3_ = _g_object_ref0 (_tmp2_);
	_g_object_unref0 ((*dest).nip);
	(*dest).nip = _tmp3_;
	_tmp4_ = (*self).lvl;
	(*dest).lvl = _tmp4_;
	_tmp5_ = (*self).pos;
	(*dest).pos = _tmp5_;
	_tmp6_ = (*self).participant_node;
	_tmp7_ = _g_object_ref0 (_tmp6_);
	_g_object_unref0 ((*dest).participant_node);
	(*dest).participant_node = _tmp7_;
}


void netsukuku_struct_helper_optionalpeertopeer_participant_set_destroy (Netsukukustruct_helper_OptionalPeerToPeer_participant_set* self) {
	_g_object_unref0 ((*self).self);
	_g_object_unref0 ((*self).nip);
	_g_object_unref0 ((*self).participant_node);
}


Netsukukustruct_helper_OptionalPeerToPeer_participant_set* netsukuku_struct_helper_optionalpeertopeer_participant_set_dup (const Netsukukustruct_helper_OptionalPeerToPeer_participant_set* self) {
	Netsukukustruct_helper_OptionalPeerToPeer_participant_set* dup;
	dup = g_new0 (Netsukukustruct_helper_OptionalPeerToPeer_participant_set, 1);
	netsukuku_struct_helper_optionalpeertopeer_participant_set_copy (self, dup);
	return dup;
}


void netsukuku_struct_helper_optionalpeertopeer_participant_set_free (Netsukukustruct_helper_OptionalPeerToPeer_participant_set* self) {
	netsukuku_struct_helper_optionalpeertopeer_participant_set_destroy (self);
	g_free (self);
}


GType netsukuku_struct_helper_optionalpeertopeer_participant_set_get_type (void) {
	static volatile gsize netsukuku_struct_helper_optionalpeertopeer_participant_set_type_id__volatile = 0;
	if (g_once_init_enter (&netsukuku_struct_helper_optionalpeertopeer_participant_set_type_id__volatile)) {
		GType netsukuku_struct_helper_optionalpeertopeer_participant_set_type_id;
		netsukuku_struct_helper_optionalpeertopeer_participant_set_type_id = g_boxed_type_register_static ("Netsukukustruct_helper_OptionalPeerToPeer_participant_set", (GBoxedCopyFunc) netsukuku_struct_helper_optionalpeertopeer_participant_set_dup, (GBoxedFreeFunc) netsukuku_struct_helper_optionalpeertopeer_participant_set_free);
		g_once_init_leave (&netsukuku_struct_helper_optionalpeertopeer_participant_set_type_id__volatile, netsukuku_struct_helper_optionalpeertopeer_participant_set_type_id);
	}
	return netsukuku_struct_helper_optionalpeertopeer_participant_set_type_id__volatile;
}


void netsukuku_struct_helper_optionalpeertopeer_participant_refresh_copy (const Netsukukustruct_helper_OptionalPeerToPeer_participant_refresh* self, Netsukukustruct_helper_OptionalPeerToPeer_participant_refresh* dest) {
	NetsukukuOptionalPeerToPeer* _tmp0_;
	NetsukukuOptionalPeerToPeer* _tmp1_;
	NetsukukuNIP* _tmp2_;
	NetsukukuNIP* _tmp3_;
	NetsukukuPackedParticipantNodes* _tmp4_;
	NetsukukuPackedParticipantNodes* _tmp5_;
	_tmp0_ = (*self).self;
	_tmp1_ = _g_object_ref0 (_tmp0_);
	_g_object_unref0 ((*dest).self);
	(*dest).self = _tmp1_;
	_tmp2_ = (*self).nip;
	_tmp3_ = _g_object_ref0 (_tmp2_);
	_g_object_unref0 ((*dest).nip);
	(*dest).nip = _tmp3_;
	_tmp4_ = (*self).packed_nodes;
	_tmp5_ = _g_object_ref0 (_tmp4_);
	_g_object_unref0 ((*dest).packed_nodes);
	(*dest).packed_nodes = _tmp5_;
}


void netsukuku_struct_helper_optionalpeertopeer_participant_refresh_destroy (Netsukukustruct_helper_OptionalPeerToPeer_participant_refresh* self) {
	_g_object_unref0 ((*self).self);
	_g_object_unref0 ((*self).nip);
	_g_object_unref0 ((*self).packed_nodes);
}


Netsukukustruct_helper_OptionalPeerToPeer_participant_refresh* netsukuku_struct_helper_optionalpeertopeer_participant_refresh_dup (const Netsukukustruct_helper_OptionalPeerToPeer_participant_refresh* self) {
	Netsukukustruct_helper_OptionalPeerToPeer_participant_refresh* dup;
	dup = g_new0 (Netsukukustruct_helper_OptionalPeerToPeer_participant_refresh, 1);
	netsukuku_struct_helper_optionalpeertopeer_participant_refresh_copy (self, dup);
	return dup;
}


void netsukuku_struct_helper_optionalpeertopeer_participant_refresh_free (Netsukukustruct_helper_OptionalPeerToPeer_participant_refresh* self) {
	netsukuku_struct_helper_optionalpeertopeer_participant_refresh_destroy (self);
	g_free (self);
}


GType netsukuku_struct_helper_optionalpeertopeer_participant_refresh_get_type (void) {
	static volatile gsize netsukuku_struct_helper_optionalpeertopeer_participant_refresh_type_id__volatile = 0;
	if (g_once_init_enter (&netsukuku_struct_helper_optionalpeertopeer_participant_refresh_type_id__volatile)) {
		GType netsukuku_struct_helper_optionalpeertopeer_participant_refresh_type_id;
		netsukuku_struct_helper_optionalpeertopeer_participant_refresh_type_id = g_boxed_type_register_static ("Netsukukustruct_helper_OptionalPeerToPeer_participant_refresh", (GBoxedCopyFunc) netsukuku_struct_helper_optionalpeertopeer_participant_refresh_dup, (GBoxedFreeFunc) netsukuku_struct_helper_optionalpeertopeer_participant_refresh_free);
		g_once_init_leave (&netsukuku_struct_helper_optionalpeertopeer_participant_refresh_type_id__volatile, netsukuku_struct_helper_optionalpeertopeer_participant_refresh_type_id);
	}
	return netsukuku_struct_helper_optionalpeertopeer_participant_refresh_type_id__volatile;
}


void netsukuku_struct_helper_optionalpeertopeer_send_refresh_periodically_copy (const Netsukukustruct_helper_OptionalPeerToPeer_send_refresh_periodically* self, Netsukukustruct_helper_OptionalPeerToPeer_send_refresh_periodically* dest) {
	NetsukukuOptionalPeerToPeer* _tmp0_;
	NetsukukuOptionalPeerToPeer* _tmp1_;
	_tmp0_ = (*self).self;
	_tmp1_ = _g_object_ref0 (_tmp0_);
	_g_object_unref0 ((*dest).self);
	(*dest).self = _tmp1_;
}


void netsukuku_struct_helper_optionalpeertopeer_send_refresh_periodically_destroy (Netsukukustruct_helper_OptionalPeerToPeer_send_refresh_periodically* self) {
	_g_object_unref0 ((*self).self);
}


Netsukukustruct_helper_OptionalPeerToPeer_send_refresh_periodically* netsukuku_struct_helper_optionalpeertopeer_send_refresh_periodically_dup (const Netsukukustruct_helper_OptionalPeerToPeer_send_refresh_periodically* self) {
	Netsukukustruct_helper_OptionalPeerToPeer_send_refresh_periodically* dup;
	dup = g_new0 (Netsukukustruct_helper_OptionalPeerToPeer_send_refresh_periodically, 1);
	netsukuku_struct_helper_optionalpeertopeer_send_refresh_periodically_copy (self, dup);
	return dup;
}


void netsukuku_struct_helper_optionalpeertopeer_send_refresh_periodically_free (Netsukukustruct_helper_OptionalPeerToPeer_send_refresh_periodically* self) {
	netsukuku_struct_helper_optionalpeertopeer_send_refresh_periodically_destroy (self);
	g_free (self);
}


GType netsukuku_struct_helper_optionalpeertopeer_send_refresh_periodically_get_type (void) {
	static volatile gsize netsukuku_struct_helper_optionalpeertopeer_send_refresh_periodically_type_id__volatile = 0;
	if (g_once_init_enter (&netsukuku_struct_helper_optionalpeertopeer_send_refresh_periodically_type_id__volatile)) {
		GType netsukuku_struct_helper_optionalpeertopeer_send_refresh_periodically_type_id;
		netsukuku_struct_helper_optionalpeertopeer_send_refresh_periodically_type_id = g_boxed_type_register_static ("Netsukukustruct_helper_OptionalPeerToPeer_send_refresh_periodically", (GBoxedCopyFunc) netsukuku_struct_helper_optionalpeertopeer_send_refresh_periodically_dup, (GBoxedFreeFunc) netsukuku_struct_helper_optionalpeertopeer_send_refresh_periodically_free);
		g_once_init_leave (&netsukuku_struct_helper_optionalpeertopeer_send_refresh_periodically_type_id__volatile, netsukuku_struct_helper_optionalpeertopeer_send_refresh_periodically_type_id);
	}
	return netsukuku_struct_helper_optionalpeertopeer_send_refresh_periodically_type_id__volatile;
}


static void _netsukuku_map_peer_to_peer_node_dead_netsukuku_map_node_deleted (NetsukukuMap* _sender, gint lvl, gint pos, gpointer self) {
	netsukuku_map_peer_to_peer_node_dead (self, lvl, pos);
}


NetsukukuOptionalPeerToPeer* netsukuku_optional_peer_to_peer_construct (GType object_type, NetsukukuAggregatedNeighbourManager* aggregated_neighbour_manager, NetsukukuMapRoute* maproute, gint pid) {
	NetsukukuOptionalPeerToPeer * self = NULL;
	NetsukukuAggregatedNeighbourManager* _tmp0_;
	NetsukukuMapRoute* _tmp1_;
	gint _tmp2_;
	NetsukukuMapRoute* _tmp3_;
	gint _tmp4_;
	gint _tmp5_;
	NetsukukuMapRoute* _tmp6_;
	gint _tmp7_;
	gint _tmp8_;
	NetsukukuMapRoute* _tmp9_;
	NetsukukuNIP* _tmp10_;
	NetsukukuNIP* _tmp11_;
	gint _tmp12_;
	NetsukukuMapPeerToPeer* _tmp13_;
	NetsukukuMapRoute* _tmp14_;
	NetsukukuMapPeerToPeer* _tmp15_;
	g_return_val_if_fail (aggregated_neighbour_manager != NULL, NULL);
	g_return_val_if_fail (maproute != NULL, NULL);
	_tmp0_ = aggregated_neighbour_manager;
	_tmp1_ = maproute;
	_tmp2_ = pid;
	self = (NetsukukuOptionalPeerToPeer*) netsukuku_peer_to_peer_construct (object_type, _tmp0_, _tmp1_, _tmp2_);
	_tmp3_ = maproute;
	_tmp4_ = netsukuku_map_get_levels ((NetsukukuMap*) _tmp3_);
	_tmp5_ = _tmp4_;
	_tmp6_ = maproute;
	_tmp7_ = netsukuku_map_get_gsize ((NetsukukuMap*) _tmp6_);
	_tmp8_ = _tmp7_;
	_tmp9_ = maproute;
	_tmp10_ = netsukuku_map_get_me ((NetsukukuMap*) _tmp9_);
	_tmp11_ = _tmp10_;
	_tmp12_ = pid;
	_tmp13_ = netsukuku_map_peer_to_peer_new (_tmp5_, _tmp8_, _tmp11_, _tmp12_);
	_g_object_unref0 (self->map_peer_to_peer);
	self->map_peer_to_peer = _tmp13_;
	self->will_participate = FALSE;
	_tmp14_ = maproute;
	_tmp15_ = self->map_peer_to_peer;
	g_signal_connect_object ((NetsukukuMap*) _tmp14_, "node-deleted", (GCallback) _netsukuku_map_peer_to_peer_node_dead_netsukuku_map_node_deleted, _tmp15_, 0);
	_g_object_unref0 (self->priv->send_refresh_handle);
	self->priv->send_refresh_handle = NULL;
	return self;
}


NetsukukuOptionalPeerToPeer* netsukuku_optional_peer_to_peer_new (NetsukukuAggregatedNeighbourManager* aggregated_neighbour_manager, NetsukukuMapRoute* maproute, gint pid) {
	return netsukuku_optional_peer_to_peer_construct (NETSUKUKU_TYPE_OPTIONAL_PEER_TO_PEER, aggregated_neighbour_manager, maproute, pid);
}


NetsukukuParticipantNode* netsukuku_optional_peer_to_peer_get_my_node (NetsukukuOptionalPeerToPeer* self, gint lvl) {
	NetsukukuParticipantNode* result = NULL;
	NetsukukuMapPeerToPeer* _tmp0_;
	gint _tmp1_;
	NetsukukuMapRoute* _tmp2_;
	NetsukukuNIP* _tmp3_;
	NetsukukuNIP* _tmp4_;
	gint _tmp5_;
	gint _tmp6_ = 0;
	gpointer _tmp7_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->map_peer_to_peer;
	_tmp1_ = lvl;
	_tmp2_ = ((NetsukukuPeerToPeer*) self)->maproute;
	_tmp3_ = netsukuku_map_get_me ((NetsukukuMap*) _tmp2_);
	_tmp4_ = _tmp3_;
	_tmp5_ = lvl;
	_tmp6_ = netsukuku_partial_nip_position_at ((NetsukukuPartialNIP*) _tmp4_, _tmp5_);
	_tmp7_ = netsukuku_map_node_get ((NetsukukuMap*) _tmp0_, _tmp1_, _tmp6_);
	result = (NetsukukuParticipantNode*) _tmp7_;
	return result;
}


static gchar* bool_to_string (gboolean self) {
	gchar* result = NULL;
	if (self) {
		gchar* _tmp0_;
		_tmp0_ = g_strdup ("true");
		result = _tmp0_;
		return result;
	} else {
		gchar* _tmp1_;
		_tmp1_ = g_strdup ("false");
		result = _tmp1_;
		return result;
	}
}


static void netsukuku_optional_peer_to_peer_impl_participant_set (NetsukukuOptionalPeerToPeer* self, NetsukukuNIP* nip, gint lvl, gint pos, NetsukukuParticipantNode* participant_node, GError** error) {
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (nip != NULL);
	g_return_if_fail (participant_node != NULL);
	tasklets_tasklet_declare_self ("OptionalPeerToPeer.participant_set");
	{
		NetsukukuNIP* _tmp0_;
		gchar* _tmp1_ = NULL;
		gchar* _tmp2_;
		gint _tmp3_;
		gchar* _tmp4_ = NULL;
		gchar* _tmp5_;
		gint _tmp6_;
		gchar* _tmp7_ = NULL;
		gchar* _tmp8_;
		NetsukukuParticipantNode* _tmp9_;
		gboolean _tmp10_;
		gchar* _tmp11_ = NULL;
		gchar* _tmp12_;
		gchar* _tmp13_ = NULL;
		gchar* _tmp14_;
		NetsukukuParticipantNode* _tmp15_;
		gboolean _tmp16_;
		gboolean participant;
		NetsukukuParticipantNode* _tmp17_;
		NetsukukuTimeCapsule* _tmp18_;
		NetsukukuTimeCapsule* _tmp19_;
		NetsukukuTimeCapsule* tc;
		NetsukukuMapRoute* _tmp20_;
		NetsukukuNIP* _tmp21_;
		gint _tmp22_ = 0;
		gint* _tmp23_ = NULL;
		gint* _tmp24_;
		gint _tmp24__length1;
		gint _tmp25_ = 0;
		gint _tmp26_;
		gint commonlvl;
		gint _tmp27_;
		gchar* _tmp28_ = NULL;
		gchar* _tmp29_;
		gchar* _tmp30_ = NULL;
		gchar* _tmp31_;
		gint _tmp32_;
		gint _tmp33_;
		gint _tmp34_;
		NetsukukuMapRoute* _tmp48_;
		NetsukukuNIP* _tmp49_;
		NetsukukuNIP* _tmp50_;
		gint _tmp51_;
		gint _tmp52_ = 0;
		gint _tmp53_;
		NetsukukuMapPeerToPeer* _tmp54_;
		gint _tmp55_;
		gint _tmp56_;
		gpointer _tmp57_ = NULL;
		NetsukukuParticipantNode* node;
		NetsukukuMapRoute* _tmp58_;
		gint _tmp59_;
		gint _tmp60_;
		gpointer _tmp61_ = NULL;
		NetsukukuRouteNode* node_route;
		NetsukukuTimeCapsule* _tmp62_;
		NetsukukuParticipantNode* _tmp63_;
		NetsukukuTimeCapsule* _tmp64_;
		gboolean _tmp65_ = FALSE;
		NetsukukuRouteNode* _tmp66_;
		gboolean _tmp67_ = FALSE;
		gboolean _tmp68_;
		NetsukukuParticipantNode* _tmp69_;
		gboolean _tmp70_;
		gboolean change;
		gboolean _tmp71_;
		gboolean _tmp79_ = FALSE;
		NetsukukuRouteNode* _tmp80_;
		gboolean _tmp81_ = FALSE;
		gboolean _tmp86_;
		_tmp0_ = nip;
		_tmp1_ = netsukuku_partial_nip_to_string ((NetsukukuPartialNIP*) _tmp0_);
		_tmp2_ = _tmp1_;
		_tmp3_ = lvl;
		_tmp4_ = g_strdup_printf ("%i", _tmp3_);
		_tmp5_ = _tmp4_;
		_tmp6_ = pos;
		_tmp7_ = g_strdup_printf ("%i", _tmp6_);
		_tmp8_ = _tmp7_;
		_tmp9_ = participant_node;
		_tmp10_ = _tmp9_->participant;
		_tmp11_ = bool_to_string (_tmp10_);
		_tmp12_ = _tmp11_;
		_tmp13_ = g_strconcat ("participant_set: (", _tmp2_, ", ", _tmp5_, ", ", _tmp8_, ", ", _tmp12_, ")", NULL);
		_tmp14_ = _tmp13_;
		netsukuku_log_debug (_tmp14_);
		_g_free0 (_tmp14_);
		_g_free0 (_tmp12_);
		_g_free0 (_tmp8_);
		_g_free0 (_tmp5_);
		_g_free0 (_tmp2_);
		_tmp15_ = participant_node;
		_tmp16_ = _tmp15_->participant;
		participant = _tmp16_;
		_tmp17_ = participant_node;
		_tmp18_ = _tmp17_->tc;
		_tmp19_ = _g_object_ref0 (_tmp18_);
		tc = _tmp19_;
		_tmp20_ = ((NetsukukuPeerToPeer*) self)->maproute;
		_tmp21_ = nip;
		_tmp23_ = netsukuku_partial_nip_get_positions ((NetsukukuPartialNIP*) _tmp21_, &_tmp22_);
		_tmp24_ = _tmp23_;
		_tmp24__length1 = _tmp22_;
		_tmp25_ = netsukuku_map_nip_cmp ((NetsukukuMap*) _tmp20_, _tmp24_, _tmp22_);
		_tmp26_ = _tmp25_;
		_tmp24_ = (g_free (_tmp24_), NULL);
		commonlvl = _tmp26_;
		_tmp27_ = commonlvl;
		_tmp28_ = g_strdup_printf ("%i", _tmp27_);
		_tmp29_ = _tmp28_;
		_tmp30_ = g_strconcat ("participant_set: commonlvl = ", _tmp29_, NULL);
		_tmp31_ = _tmp30_;
		netsukuku_log_debug (_tmp31_);
		_g_free0 (_tmp31_);
		_g_free0 (_tmp29_);
		_tmp32_ = commonlvl;
		if (_tmp32_ == (-1)) {
			_g_object_unref0 (tc);
			{
				netsukuku_log_debug ("tasklet participant_set finishes.");
			}
			return;
		}
		_tmp33_ = lvl;
		_tmp34_ = commonlvl;
		if (_tmp33_ < _tmp34_) {
			gboolean _tmp35_;
			_tmp35_ = participant;
			if (_tmp35_) {
				gint _tmp36_;
				NetsukukuNIP* _tmp37_;
				gint _tmp38_;
				gint _tmp39_ = 0;
				gint _tmp40_;
				gchar* _tmp41_ = NULL;
				gchar* _tmp42_;
				gint _tmp43_;
				gchar* _tmp44_ = NULL;
				gchar* _tmp45_;
				gchar* _tmp46_ = NULL;
				gchar* _tmp47_;
				_tmp36_ = commonlvl;
				lvl = _tmp36_;
				_tmp37_ = nip;
				_tmp38_ = lvl;
				_tmp39_ = netsukuku_partial_nip_position_at ((NetsukukuPartialNIP*) _tmp37_, _tmp38_);
				pos = _tmp39_;
				_tmp40_ = lvl;
				_tmp41_ = g_strdup_printf ("%i", _tmp40_);
				_tmp42_ = _tmp41_;
				_tmp43_ = pos;
				_tmp44_ = g_strdup_printf ("%i", _tmp43_);
				_tmp45_ = _tmp44_;
				_tmp46_ = g_strconcat ("participant_set: for me is ", _tmp42_, ", ", _tmp45_, NULL);
				_tmp47_ = _tmp46_;
				netsukuku_log_debug (_tmp47_);
				_g_free0 (_tmp47_);
				_g_free0 (_tmp45_);
				_g_free0 (_tmp42_);
			} else {
				_g_object_unref0 (tc);
				{
					netsukuku_log_debug ("tasklet participant_set finishes.");
				}
				return;
			}
		}
		_tmp48_ = ((NetsukukuPeerToPeer*) self)->maproute;
		_tmp49_ = netsukuku_map_get_me ((NetsukukuMap*) _tmp48_);
		_tmp50_ = _tmp49_;
		_tmp51_ = lvl;
		_tmp52_ = netsukuku_partial_nip_position_at ((NetsukukuPartialNIP*) _tmp50_, _tmp51_);
		_tmp53_ = pos;
		if (_tmp52_ == _tmp53_) {
			_g_object_unref0 (tc);
			{
				netsukuku_log_debug ("tasklet participant_set finishes.");
			}
			return;
		}
		netsukuku_log_debug ("participant_set: still here");
		_tmp54_ = self->map_peer_to_peer;
		_tmp55_ = lvl;
		_tmp56_ = pos;
		_tmp57_ = netsukuku_map_node_get ((NetsukukuMap*) _tmp54_, _tmp55_, _tmp56_);
		node = (NetsukukuParticipantNode*) _tmp57_;
		_tmp58_ = ((NetsukukuPeerToPeer*) self)->maproute;
		_tmp59_ = lvl;
		_tmp60_ = pos;
		_tmp61_ = netsukuku_map_node_get ((NetsukukuMap*) _tmp58_, _tmp59_, _tmp60_);
		node_route = (NetsukukuRouteNode*) _tmp61_;
		_tmp62_ = tc;
		_tmp63_ = node;
		_tmp64_ = _tmp63_->tc;
		_tmp65_ = tasklets_timer_is_younger ((TaskletsTimer*) _tmp62_, (TaskletsTimer*) _tmp64_);
		if (_tmp65_) {
			netsukuku_log_debug ("participant_set: newer data");
		}
		_tmp66_ = node_route;
		_tmp67_ = netsukuku_dataclass_is_free ((NetsukukuDataClass*) _tmp66_);
		if (!_tmp67_) {
			netsukuku_log_debug ("participant_set: node present in maproute");
		}
		_tmp68_ = participant;
		_tmp69_ = node;
		_tmp70_ = _tmp69_->participant;
		change = _tmp68_ != _tmp70_;
		_tmp71_ = change;
		if (!_tmp71_) {
			NetsukukuTimeCapsule* _tmp72_;
			NetsukukuParticipantNode* _tmp73_;
			NetsukukuTimeCapsule* _tmp74_;
			gboolean _tmp75_ = FALSE;
			netsukuku_log_debug ("participant_set: no change");
			_tmp72_ = tc;
			_tmp73_ = node;
			_tmp74_ = _tmp73_->tc;
			_tmp75_ = tasklets_timer_is_younger ((TaskletsTimer*) _tmp72_, (TaskletsTimer*) _tmp74_);
			if (_tmp75_) {
				NetsukukuParticipantNode* _tmp76_;
				NetsukukuTimeCapsule* _tmp77_;
				NetsukukuTimeCapsule* _tmp78_;
				_tmp76_ = node;
				_tmp77_ = tc;
				_tmp78_ = _g_object_ref0 (_tmp77_);
				_g_object_unref0 (_tmp76_->tc);
				_tmp76_->tc = _tmp78_;
				netsukuku_log_debug ("participant_set: just refresh");
			}
			_g_object_unref0 (node_route);
			_g_object_unref0 (node);
			_g_object_unref0 (tc);
			{
				netsukuku_log_debug ("tasklet participant_set finishes.");
			}
			return;
		}
		_tmp80_ = node_route;
		_tmp81_ = netsukuku_dataclass_is_free ((NetsukukuDataClass*) _tmp80_);
		if (!_tmp81_) {
			NetsukukuTimeCapsule* _tmp82_;
			NetsukukuParticipantNode* _tmp83_;
			NetsukukuTimeCapsule* _tmp84_;
			gboolean _tmp85_ = FALSE;
			_tmp82_ = tc;
			_tmp83_ = node;
			_tmp84_ = _tmp83_->tc;
			_tmp85_ = tasklets_timer_is_younger ((TaskletsTimer*) _tmp82_, (TaskletsTimer*) _tmp84_);
			_tmp79_ = _tmp85_;
		} else {
			_tmp79_ = FALSE;
		}
		_tmp86_ = _tmp79_;
		if (_tmp86_) {
			NetsukukuMapRoute* _tmp87_;
			gint _tmp88_;
			gint _tmp89_;
			gboolean* _tmp90_ = NULL;
			gboolean* old_myself;
			gint old_myself_length1;
			gint _old_myself_size_;
			NetsukukuParticipantNode* _tmp105_;
			gboolean _tmp106_;
			NetsukukuParticipantNode* _tmp107_;
			NetsukukuTimeCapsule* _tmp108_;
			NetsukukuTimeCapsule* _tmp109_;
			NetsukukuMapPeerToPeer* _tmp110_;
			gint _tmp111_;
			gint _tmp112_;
			gint _tmp113_;
			gchar* _tmp114_ = NULL;
			gchar* _tmp115_;
			gchar* _tmp116_ = NULL;
			gchar* _tmp117_;
			NetsukukuMapRoute* _tmp118_;
			NetsukukuAddressManager* _tmp119_;
			NetsukukuAddressManager* _tmp120_;
			NetsukukuAddressManagerFakeRmt* _tmp121_ = NULL;
			NetsukukuAddressManagerFakeRmt* bclient;
			NetsukukuAddressManagerFakeRmt* _tmp122_;
			gint _tmp123_;
			NetsukukuIOptionalPeerToPeer* _tmp124_ = NULL;
			NetsukukuIOptionalPeerToPeer* service;
			gint _tmp125_;
			gchar* _tmp126_ = NULL;
			gchar* _tmp127_;
			gint _tmp128_;
			gchar* _tmp129_ = NULL;
			gchar* _tmp130_;
			NetsukukuParticipantNode* _tmp131_;
			gboolean _tmp132_;
			gchar* _tmp133_ = NULL;
			gchar* _tmp134_;
			gchar* _tmp135_ = NULL;
			gchar* _tmp136_;
			NetsukukuIOptionalPeerToPeer* _tmp137_;
			NetsukukuMapRoute* _tmp138_;
			NetsukukuNIP* _tmp139_;
			NetsukukuNIP* _tmp140_;
			gint _tmp141_;
			gint _tmp142_;
			NetsukukuParticipantNode* _tmp143_;
			_tmp87_ = ((NetsukukuPeerToPeer*) self)->maproute;
			_tmp88_ = netsukuku_map_get_levels ((NetsukukuMap*) _tmp87_);
			_tmp89_ = _tmp88_;
			_tmp90_ = g_new0 (gboolean, _tmp89_);
			old_myself = _tmp90_;
			old_myself_length1 = _tmp89_;
			_old_myself_size_ = old_myself_length1;
			{
				gint l;
				l = 0;
				{
					gboolean _tmp91_;
					_tmp91_ = TRUE;
					while (TRUE) {
						gboolean _tmp92_;
						gint _tmp94_;
						NetsukukuMapRoute* _tmp95_;
						gint _tmp96_;
						gint _tmp97_;
						gboolean* _tmp98_;
						gint _tmp98__length1;
						gint _tmp99_;
						gint _tmp100_;
						NetsukukuParticipantNode* _tmp101_ = NULL;
						NetsukukuParticipantNode* _tmp102_;
						gboolean _tmp103_;
						gboolean _tmp104_;
						_tmp92_ = _tmp91_;
						if (!_tmp92_) {
							gint _tmp93_;
							_tmp93_ = l;
							l = _tmp93_ + 1;
						}
						_tmp91_ = FALSE;
						_tmp94_ = l;
						_tmp95_ = ((NetsukukuPeerToPeer*) self)->maproute;
						_tmp96_ = netsukuku_map_get_levels ((NetsukukuMap*) _tmp95_);
						_tmp97_ = _tmp96_;
						if (!(_tmp94_ < _tmp97_)) {
							break;
						}
						_tmp98_ = old_myself;
						_tmp98__length1 = old_myself_length1;
						_tmp99_ = l;
						_tmp100_ = l;
						_tmp101_ = netsukuku_optional_peer_to_peer_get_my_node (self, _tmp100_);
						_tmp102_ = _tmp101_;
						_tmp103_ = _tmp102_->participant;
						_tmp98_[_tmp99_] = _tmp103_;
						_tmp104_ = _tmp98_[_tmp99_];
						_g_object_unref0 (_tmp102_);
					}
				}
			}
			_tmp105_ = node;
			_tmp106_ = participant;
			_tmp105_->participant = _tmp106_;
			_tmp107_ = node;
			_tmp108_ = tc;
			_tmp109_ = _g_object_ref0 (_tmp108_);
			_g_object_unref0 (_tmp107_->tc);
			_tmp107_->tc = _tmp109_;
			_tmp110_ = self->map_peer_to_peer;
			_tmp111_ = lvl;
			_tmp112_ = pos;
			netsukuku_map_check_node ((NetsukukuMap*) _tmp110_, _tmp111_, _tmp112_);
			_tmp113_ = ((NetsukukuPeerToPeer*) self)->pid;
			_tmp114_ = g_strdup_printf ("%i", _tmp113_);
			_tmp115_ = _tmp114_;
			_tmp116_ = g_strconcat ("getting Remote for optional_peer_to_peer for service ", _tmp115_, " in broadcast", NULL);
			_tmp117_ = _tmp116_;
			netsukuku_log_debug (_tmp117_);
			_g_free0 (_tmp117_);
			_g_free0 (_tmp115_);
			_tmp118_ = ((NetsukukuPeerToPeer*) self)->maproute;
			_tmp119_ = netsukuku_map_route_get_address_manager (_tmp118_);
			_tmp120_ = _tmp119_;
			_tmp121_ = netsukuku_address_manager_get_broadcast_client (_tmp120_);
			bclient = _tmp121_;
			_tmp122_ = bclient;
			_tmp123_ = ((NetsukukuPeerToPeer*) self)->pid;
			_tmp124_ = netsukuku_iaddress_manager_root_dispatcher_get_optional_peer_to_peer_service ((NetsukukuIAddressManagerRootDispatcher*) _tmp122_, _tmp123_);
			service = _tmp124_;
			_tmp125_ = lvl;
			_tmp126_ = g_strdup_printf ("%i", _tmp125_);
			_tmp127_ = _tmp126_;
			_tmp128_ = pos;
			_tmp129_ = g_strdup_printf ("%i", _tmp128_);
			_tmp130_ = _tmp129_;
			_tmp131_ = node;
			_tmp132_ = _tmp131_->participant;
			_tmp133_ = bool_to_string (_tmp132_);
			_tmp134_ = _tmp133_;
			_tmp135_ = g_strconcat ("calling participant_set(", _tmp127_, ", ", _tmp130_, ", ", _tmp134_, ") in broadcast", NULL);
			_tmp136_ = _tmp135_;
			netsukuku_log_debug (_tmp136_);
			_g_free0 (_tmp136_);
			_g_free0 (_tmp134_);
			_g_free0 (_tmp130_);
			_g_free0 (_tmp127_);
			_tmp137_ = service;
			_tmp138_ = ((NetsukukuPeerToPeer*) self)->maproute;
			_tmp139_ = netsukuku_map_get_me ((NetsukukuMap*) _tmp138_);
			_tmp140_ = _tmp139_;
			_tmp141_ = lvl;
			_tmp142_ = pos;
			_tmp143_ = node;
			netsukuku_ioptional_peer_to_peer_participant_set (_tmp137_, _tmp140_, _tmp141_, _tmp142_, _tmp143_, &_inner_error_);
			if (_inner_error_ != NULL) {
				_g_object_unref0 (service);
				_g_object_unref0 (bclient);
				old_myself = (g_free (old_myself), NULL);
				_g_object_unref0 (node_route);
				_g_object_unref0 (node);
				_g_object_unref0 (tc);
				goto __finally100;
			}
			netsukuku_log_debug ("done");
			{
				gint l;
				l = 0;
				{
					gboolean _tmp144_;
					_tmp144_ = TRUE;
					while (TRUE) {
						gboolean _tmp145_;
						gint _tmp147_;
						NetsukukuMapRoute* _tmp148_;
						gint _tmp149_;
						gint _tmp150_;
						gboolean _tmp151_ = FALSE;
						gboolean* _tmp152_;
						gint _tmp152__length1;
						gint _tmp153_;
						gboolean _tmp154_;
						gboolean _tmp159_;
						gboolean _tmp185_ = FALSE;
						gboolean* _tmp186_;
						gint _tmp186__length1;
						gint _tmp187_;
						gboolean _tmp188_;
						gboolean _tmp193_;
						_tmp145_ = _tmp144_;
						if (!_tmp145_) {
							gint _tmp146_;
							_tmp146_ = l;
							l = _tmp146_ + 1;
						}
						_tmp144_ = FALSE;
						_tmp147_ = l;
						_tmp148_ = ((NetsukukuPeerToPeer*) self)->maproute;
						_tmp149_ = netsukuku_map_get_levels ((NetsukukuMap*) _tmp148_);
						_tmp150_ = _tmp149_;
						if (!(_tmp147_ < _tmp150_)) {
							break;
						}
						_tmp152_ = old_myself;
						_tmp152__length1 = old_myself_length1;
						_tmp153_ = l;
						_tmp154_ = _tmp152_[_tmp153_];
						if (!_tmp154_) {
							gint _tmp155_;
							NetsukukuParticipantNode* _tmp156_ = NULL;
							NetsukukuParticipantNode* _tmp157_;
							gboolean _tmp158_;
							_tmp155_ = l;
							_tmp156_ = netsukuku_optional_peer_to_peer_get_my_node (self, _tmp155_);
							_tmp157_ = _tmp156_;
							_tmp158_ = _tmp157_->participant;
							_tmp151_ = _tmp158_;
							_g_object_unref0 (_tmp157_);
						} else {
							_tmp151_ = FALSE;
						}
						_tmp159_ = _tmp151_;
						if (_tmp159_) {
							gint _tmp160_;
							gchar* _tmp161_ = NULL;
							gchar* _tmp162_;
							NetsukukuMapRoute* _tmp163_;
							NetsukukuNIP* _tmp164_;
							NetsukukuNIP* _tmp165_;
							gint _tmp166_;
							gint _tmp167_ = 0;
							gchar* _tmp168_ = NULL;
							gchar* _tmp169_;
							gchar* _tmp170_ = NULL;
							gchar* _tmp171_;
							NetsukukuIOptionalPeerToPeer* _tmp172_;
							NetsukukuMapRoute* _tmp173_;
							NetsukukuNIP* _tmp174_;
							NetsukukuNIP* _tmp175_;
							gint _tmp176_;
							NetsukukuMapRoute* _tmp177_;
							NetsukukuNIP* _tmp178_;
							NetsukukuNIP* _tmp179_;
							gint _tmp180_;
							gint _tmp181_ = 0;
							gint _tmp182_;
							NetsukukuParticipantNode* _tmp183_ = NULL;
							NetsukukuParticipantNode* _tmp184_;
							_tmp160_ = l;
							_tmp161_ = g_strdup_printf ("%i", _tmp160_);
							_tmp162_ = _tmp161_;
							_tmp163_ = ((NetsukukuPeerToPeer*) self)->maproute;
							_tmp164_ = netsukuku_map_get_me ((NetsukukuMap*) _tmp163_);
							_tmp165_ = _tmp164_;
							_tmp166_ = l;
							_tmp167_ = netsukuku_partial_nip_position_at ((NetsukukuPartialNIP*) _tmp165_, _tmp166_);
							_tmp168_ = g_strdup_printf ("%i", _tmp167_);
							_tmp169_ = _tmp168_;
							_tmp170_ = g_strconcat ("calling participant_set(", _tmp162_, ", ", _tmp169_, ", <true>) in broadcast", NULL);
							_tmp171_ = _tmp170_;
							netsukuku_log_debug (_tmp171_);
							_g_free0 (_tmp171_);
							_g_free0 (_tmp169_);
							_g_free0 (_tmp162_);
							_tmp172_ = service;
							_tmp173_ = ((NetsukukuPeerToPeer*) self)->maproute;
							_tmp174_ = netsukuku_map_get_me ((NetsukukuMap*) _tmp173_);
							_tmp175_ = _tmp174_;
							_tmp176_ = l;
							_tmp177_ = ((NetsukukuPeerToPeer*) self)->maproute;
							_tmp178_ = netsukuku_map_get_me ((NetsukukuMap*) _tmp177_);
							_tmp179_ = _tmp178_;
							_tmp180_ = l;
							_tmp181_ = netsukuku_partial_nip_position_at ((NetsukukuPartialNIP*) _tmp179_, _tmp180_);
							_tmp182_ = l;
							_tmp183_ = netsukuku_optional_peer_to_peer_get_my_node (self, _tmp182_);
							_tmp184_ = _tmp183_;
							netsukuku_ioptional_peer_to_peer_participant_set (_tmp172_, _tmp175_, _tmp176_, _tmp181_, _tmp184_, &_inner_error_);
							_g_object_unref0 (_tmp184_);
							if (_inner_error_ != NULL) {
								_g_object_unref0 (service);
								_g_object_unref0 (bclient);
								old_myself = (g_free (old_myself), NULL);
								_g_object_unref0 (node_route);
								_g_object_unref0 (node);
								_g_object_unref0 (tc);
								goto __finally100;
							}
							netsukuku_log_debug ("done");
							_g_object_unref0 (service);
							_g_object_unref0 (bclient);
							old_myself = (g_free (old_myself), NULL);
							_g_object_unref0 (node_route);
							_g_object_unref0 (node);
							_g_object_unref0 (tc);
							{
								netsukuku_log_debug ("tasklet participant_set finishes.");
							}
							return;
						}
						_tmp186_ = old_myself;
						_tmp186__length1 = old_myself_length1;
						_tmp187_ = l;
						_tmp188_ = _tmp186_[_tmp187_];
						if (_tmp188_) {
							gint _tmp189_;
							NetsukukuParticipantNode* _tmp190_ = NULL;
							NetsukukuParticipantNode* _tmp191_;
							gboolean _tmp192_;
							_tmp189_ = l;
							_tmp190_ = netsukuku_optional_peer_to_peer_get_my_node (self, _tmp189_);
							_tmp191_ = _tmp190_;
							_tmp192_ = _tmp191_->participant;
							_tmp185_ = !_tmp192_;
							_g_object_unref0 (_tmp191_);
						} else {
							_tmp185_ = FALSE;
						}
						_tmp193_ = _tmp185_;
						if (_tmp193_) {
							gint _tmp194_;
							gchar* _tmp195_ = NULL;
							gchar* _tmp196_;
							NetsukukuMapRoute* _tmp197_;
							NetsukukuNIP* _tmp198_;
							NetsukukuNIP* _tmp199_;
							gint _tmp200_;
							gint _tmp201_ = 0;
							gchar* _tmp202_ = NULL;
							gchar* _tmp203_;
							gchar* _tmp204_ = NULL;
							gchar* _tmp205_;
							NetsukukuIOptionalPeerToPeer* _tmp206_;
							NetsukukuMapRoute* _tmp207_;
							NetsukukuNIP* _tmp208_;
							NetsukukuNIP* _tmp209_;
							gint _tmp210_;
							NetsukukuMapRoute* _tmp211_;
							NetsukukuNIP* _tmp212_;
							NetsukukuNIP* _tmp213_;
							gint _tmp214_;
							gint _tmp215_ = 0;
							gint _tmp216_;
							NetsukukuParticipantNode* _tmp217_ = NULL;
							NetsukukuParticipantNode* _tmp218_;
							_tmp194_ = l;
							_tmp195_ = g_strdup_printf ("%i", _tmp194_);
							_tmp196_ = _tmp195_;
							_tmp197_ = ((NetsukukuPeerToPeer*) self)->maproute;
							_tmp198_ = netsukuku_map_get_me ((NetsukukuMap*) _tmp197_);
							_tmp199_ = _tmp198_;
							_tmp200_ = l;
							_tmp201_ = netsukuku_partial_nip_position_at ((NetsukukuPartialNIP*) _tmp199_, _tmp200_);
							_tmp202_ = g_strdup_printf ("%i", _tmp201_);
							_tmp203_ = _tmp202_;
							_tmp204_ = g_strconcat ("calling participant_set(", _tmp196_, ", ", _tmp203_, ", <false>) in broadcast", NULL);
							_tmp205_ = _tmp204_;
							netsukuku_log_debug (_tmp205_);
							_g_free0 (_tmp205_);
							_g_free0 (_tmp203_);
							_g_free0 (_tmp196_);
							_tmp206_ = service;
							_tmp207_ = ((NetsukukuPeerToPeer*) self)->maproute;
							_tmp208_ = netsukuku_map_get_me ((NetsukukuMap*) _tmp207_);
							_tmp209_ = _tmp208_;
							_tmp210_ = l;
							_tmp211_ = ((NetsukukuPeerToPeer*) self)->maproute;
							_tmp212_ = netsukuku_map_get_me ((NetsukukuMap*) _tmp211_);
							_tmp213_ = _tmp212_;
							_tmp214_ = l;
							_tmp215_ = netsukuku_partial_nip_position_at ((NetsukukuPartialNIP*) _tmp213_, _tmp214_);
							_tmp216_ = l;
							_tmp217_ = netsukuku_optional_peer_to_peer_get_my_node (self, _tmp216_);
							_tmp218_ = _tmp217_;
							netsukuku_ioptional_peer_to_peer_participant_set (_tmp206_, _tmp209_, _tmp210_, _tmp215_, _tmp218_, &_inner_error_);
							_g_object_unref0 (_tmp218_);
							if (_inner_error_ != NULL) {
								_g_object_unref0 (service);
								_g_object_unref0 (bclient);
								old_myself = (g_free (old_myself), NULL);
								_g_object_unref0 (node_route);
								_g_object_unref0 (node);
								_g_object_unref0 (tc);
								goto __finally100;
							}
							netsukuku_log_debug ("done");
						}
					}
				}
			}
			_g_object_unref0 (service);
			_g_object_unref0 (bclient);
			old_myself = (g_free (old_myself), NULL);
		}
		_g_object_unref0 (node_route);
		_g_object_unref0 (node);
		_g_object_unref0 (tc);
	}
	__finally100:
	{
		netsukuku_log_debug ("tasklet participant_set finishes.");
	}
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		return;
	}
}


static void* netsukuku_optional_peer_to_peer_helper_participant_set (void* v, GError** error) {
	void* result = NULL;
	void* _tmp0_;
	Netsukukustruct_helper_OptionalPeerToPeer_participant_set* tuple_p;
	NetsukukuOptionalPeerToPeer* _tmp1_;
	NetsukukuOptionalPeerToPeer* _tmp2_;
	NetsukukuOptionalPeerToPeer* self_save;
	NetsukukuNIP* _tmp3_;
	NetsukukuNIP* _tmp4_;
	NetsukukuNIP* nip_save;
	NetsukukuParticipantNode* _tmp5_;
	NetsukukuParticipantNode* _tmp6_;
	NetsukukuParticipantNode* participant_node_save;
	gint _tmp7_;
	gint lvl_save;
	gint _tmp8_;
	gint pos_save;
	GError * _inner_error_ = NULL;
	_tmp0_ = v;
	tuple_p = (Netsukukustruct_helper_OptionalPeerToPeer_participant_set*) _tmp0_;
	_tmp1_ = (*tuple_p).self;
	_tmp2_ = _g_object_ref0 (_tmp1_);
	self_save = _tmp2_;
	_tmp3_ = (*tuple_p).nip;
	_tmp4_ = _g_object_ref0 (_tmp3_);
	nip_save = _tmp4_;
	_tmp5_ = (*tuple_p).participant_node;
	_tmp6_ = _g_object_ref0 (_tmp5_);
	participant_node_save = _tmp6_;
	_tmp7_ = (*tuple_p).lvl;
	lvl_save = _tmp7_;
	_tmp8_ = (*tuple_p).pos;
	pos_save = _tmp8_;
	tasklets_tasklet_schedule_back ();
	netsukuku_optional_peer_to_peer_impl_participant_set (self_save, nip_save, lvl_save, pos_save, participant_node_save, &_inner_error_);
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		_g_object_unref0 (participant_node_save);
		_g_object_unref0 (nip_save);
		_g_object_unref0 (self_save);
		return NULL;
	}
	result = NULL;
	_g_object_unref0 (participant_node_save);
	_g_object_unref0 (nip_save);
	_g_object_unref0 (self_save);
	return result;
}


static void netsukuku_optional_peer_to_peer_real_participant_set (NetsukukuIOptionalPeerToPeer* base, NetsukukuNIP* nip, gint lvl, gint pos, NetsukukuParticipantNode* participant_node, GError** error) {
	NetsukukuOptionalPeerToPeer * self;
	Netsukukustruct_helper_OptionalPeerToPeer_participant_set arg = {0};
	NetsukukuOptionalPeerToPeer* _tmp0_;
	NetsukukuNIP* _tmp1_;
	NetsukukuNIP* _tmp2_;
	gint _tmp3_;
	gint _tmp4_;
	NetsukukuParticipantNode* _tmp5_;
	NetsukukuParticipantNode* _tmp6_;
	TaskletsTasklet* _tmp7_ = NULL;
	TaskletsTasklet* _tmp8_;
	self = (NetsukukuOptionalPeerToPeer*) base;
	g_return_if_fail (nip != NULL);
	g_return_if_fail (participant_node != NULL);
	memset (&arg, 0, sizeof (Netsukukustruct_helper_OptionalPeerToPeer_participant_set));
	_tmp0_ = _g_object_ref0 (self);
	_g_object_unref0 (arg.self);
	arg.self = _tmp0_;
	_tmp1_ = nip;
	_tmp2_ = _g_object_ref0 (_tmp1_);
	_g_object_unref0 (arg.nip);
	arg.nip = _tmp2_;
	_tmp3_ = lvl;
	arg.lvl = _tmp3_;
	_tmp4_ = pos;
	arg.pos = _tmp4_;
	_tmp5_ = participant_node;
	_tmp6_ = _g_object_ref0 (_tmp5_);
	_g_object_unref0 (arg.participant_node);
	arg.participant_node = _tmp6_;
	_tmp7_ = tasklets_tasklet_spawn ((FunctionDelegate) netsukuku_optional_peer_to_peer_helper_participant_set, &arg, FALSE, -1);
	_tmp8_ = _tmp7_;
	_g_object_unref0 (_tmp8_);
	netsukuku_struct_helper_optionalpeertopeer_participant_set_destroy (&arg);
}


static void netsukuku_optional_peer_to_peer_impl_participant_refresh (NetsukukuOptionalPeerToPeer* self, NetsukukuNIP* nip, NetsukukuPackedParticipantNodes* packed_nodes, GError** error) {
	gint lvl;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (nip != NULL);
	g_return_if_fail (packed_nodes != NULL);
	tasklets_tasklet_declare_self ("OptionalPeerToPeer.participant_refresh");
	lvl = 0;
	{
		NetsukukuPackedParticipantNodes* _tmp0_;
		GeeArrayList* _tmp1_;
		GeeArrayList* _tmp2_;
		GeeArrayList* _list_lvl_list;
		GeeArrayList* _tmp3_;
		gint _tmp4_;
		gint _tmp5_;
		gint _list_lvl_size;
		gint _list_lvl_index;
		_tmp0_ = packed_nodes;
		_tmp1_ = _tmp0_->packednodes;
		_tmp2_ = _g_object_ref0 (_tmp1_);
		_list_lvl_list = _tmp2_;
		_tmp3_ = _list_lvl_list;
		_tmp4_ = gee_abstract_collection_get_size ((GeeCollection*) _tmp3_);
		_tmp5_ = _tmp4_;
		_list_lvl_size = _tmp5_;
		_list_lvl_index = -1;
		while (TRUE) {
			gint _tmp6_;
			gint _tmp7_;
			gint _tmp8_;
			GeeArrayList* _tmp9_;
			gint _tmp10_;
			gpointer _tmp11_ = NULL;
			GeeArrayList* list_lvl;
			gint pos;
			gint _tmp28_;
			_tmp6_ = _list_lvl_index;
			_list_lvl_index = _tmp6_ + 1;
			_tmp7_ = _list_lvl_index;
			_tmp8_ = _list_lvl_size;
			if (!(_tmp7_ < _tmp8_)) {
				break;
			}
			_tmp9_ = _list_lvl_list;
			_tmp10_ = _list_lvl_index;
			_tmp11_ = gee_abstract_list_get ((GeeAbstractList*) _tmp9_, _tmp10_);
			list_lvl = (GeeArrayList*) _tmp11_;
			pos = 0;
			{
				GeeArrayList* _tmp12_;
				GeeArrayList* _tmp13_;
				GeeArrayList* _lvl_pos_list;
				GeeArrayList* _tmp14_;
				gint _tmp15_;
				gint _tmp16_;
				gint _lvl_pos_size;
				gint _lvl_pos_index;
				_tmp12_ = list_lvl;
				_tmp13_ = _g_object_ref0 (_tmp12_);
				_lvl_pos_list = _tmp13_;
				_tmp14_ = _lvl_pos_list;
				_tmp15_ = gee_abstract_collection_get_size ((GeeCollection*) _tmp14_);
				_tmp16_ = _tmp15_;
				_lvl_pos_size = _tmp16_;
				_lvl_pos_index = -1;
				while (TRUE) {
					gint _tmp17_;
					gint _tmp18_;
					gint _tmp19_;
					GeeArrayList* _tmp20_;
					gint _tmp21_;
					gpointer _tmp22_ = NULL;
					NetsukukuParticipantNode* lvl_pos;
					NetsukukuNIP* _tmp23_;
					gint _tmp24_;
					gint _tmp25_;
					NetsukukuParticipantNode* _tmp26_;
					gint _tmp27_;
					_tmp17_ = _lvl_pos_index;
					_lvl_pos_index = _tmp17_ + 1;
					_tmp18_ = _lvl_pos_index;
					_tmp19_ = _lvl_pos_size;
					if (!(_tmp18_ < _tmp19_)) {
						break;
					}
					_tmp20_ = _lvl_pos_list;
					_tmp21_ = _lvl_pos_index;
					_tmp22_ = gee_abstract_list_get ((GeeAbstractList*) _tmp20_, _tmp21_);
					lvl_pos = (NetsukukuParticipantNode*) _tmp22_;
					_tmp23_ = nip;
					_tmp24_ = lvl;
					_tmp25_ = pos;
					_tmp26_ = lvl_pos;
					netsukuku_ioptional_peer_to_peer_participant_set ((NetsukukuIOptionalPeerToPeer*) self, _tmp23_, _tmp24_, _tmp25_, _tmp26_, &_inner_error_);
					if (_inner_error_ != NULL) {
						g_propagate_error (error, _inner_error_);
						_g_object_unref0 (lvl_pos);
						_g_object_unref0 (_lvl_pos_list);
						_g_object_unref0 (list_lvl);
						_g_object_unref0 (_list_lvl_list);
						return;
					}
					_tmp27_ = pos;
					pos = _tmp27_ + 1;
					_g_object_unref0 (lvl_pos);
				}
				_g_object_unref0 (_lvl_pos_list);
			}
			_tmp28_ = lvl;
			lvl = _tmp28_ + 1;
			_g_object_unref0 (list_lvl);
		}
		_g_object_unref0 (_list_lvl_list);
	}
}


static void* netsukuku_optional_peer_to_peer_helper_participant_refresh (void* v, GError** error) {
	void* result = NULL;
	void* _tmp0_;
	Netsukukustruct_helper_OptionalPeerToPeer_participant_refresh* tuple_p;
	NetsukukuOptionalPeerToPeer* _tmp1_;
	NetsukukuOptionalPeerToPeer* _tmp2_;
	NetsukukuOptionalPeerToPeer* self_save;
	NetsukukuNIP* _tmp3_;
	NetsukukuNIP* _tmp4_;
	NetsukukuNIP* nip_save;
	NetsukukuPackedParticipantNodes* _tmp5_;
	NetsukukuPackedParticipantNodes* _tmp6_;
	NetsukukuPackedParticipantNodes* packed_nodes_save;
	GError * _inner_error_ = NULL;
	_tmp0_ = v;
	tuple_p = (Netsukukustruct_helper_OptionalPeerToPeer_participant_refresh*) _tmp0_;
	_tmp1_ = (*tuple_p).self;
	_tmp2_ = _g_object_ref0 (_tmp1_);
	self_save = _tmp2_;
	_tmp3_ = (*tuple_p).nip;
	_tmp4_ = _g_object_ref0 (_tmp3_);
	nip_save = _tmp4_;
	_tmp5_ = (*tuple_p).packed_nodes;
	_tmp6_ = _g_object_ref0 (_tmp5_);
	packed_nodes_save = _tmp6_;
	tasklets_tasklet_schedule_back ();
	netsukuku_optional_peer_to_peer_impl_participant_refresh (self_save, nip_save, packed_nodes_save, &_inner_error_);
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		_g_object_unref0 (packed_nodes_save);
		_g_object_unref0 (nip_save);
		_g_object_unref0 (self_save);
		return NULL;
	}
	result = NULL;
	_g_object_unref0 (packed_nodes_save);
	_g_object_unref0 (nip_save);
	_g_object_unref0 (self_save);
	return result;
}


static void netsukuku_optional_peer_to_peer_real_participant_refresh (NetsukukuIOptionalPeerToPeer* base, NetsukukuNIP* nip, NetsukukuPackedParticipantNodes* packed_nodes, GError** error) {
	NetsukukuOptionalPeerToPeer * self;
	Netsukukustruct_helper_OptionalPeerToPeer_participant_refresh arg = {0};
	NetsukukuOptionalPeerToPeer* _tmp0_;
	NetsukukuNIP* _tmp1_;
	NetsukukuNIP* _tmp2_;
	NetsukukuPackedParticipantNodes* _tmp3_;
	NetsukukuPackedParticipantNodes* _tmp4_;
	TaskletsTasklet* _tmp5_ = NULL;
	TaskletsTasklet* _tmp6_;
	self = (NetsukukuOptionalPeerToPeer*) base;
	g_return_if_fail (nip != NULL);
	g_return_if_fail (packed_nodes != NULL);
	memset (&arg, 0, sizeof (Netsukukustruct_helper_OptionalPeerToPeer_participant_refresh));
	_tmp0_ = _g_object_ref0 (self);
	_g_object_unref0 (arg.self);
	arg.self = _tmp0_;
	_tmp1_ = nip;
	_tmp2_ = _g_object_ref0 (_tmp1_);
	_g_object_unref0 (arg.nip);
	arg.nip = _tmp2_;
	_tmp3_ = packed_nodes;
	_tmp4_ = _g_object_ref0 (_tmp3_);
	_g_object_unref0 (arg.packed_nodes);
	arg.packed_nodes = _tmp4_;
	_tmp5_ = tasklets_tasklet_spawn ((FunctionDelegate) netsukuku_optional_peer_to_peer_helper_participant_refresh, &arg, FALSE, -1);
	_tmp6_ = _tmp5_;
	_g_object_unref0 (_tmp6_);
	netsukuku_struct_helper_optionalpeertopeer_participant_refresh_destroy (&arg);
}


static void netsukuku_optional_peer_to_peer_impl_send_refresh_periodically (NetsukukuOptionalPeerToPeer* self, GError** error) {
	TaskletsTasklet* _tmp0_ = NULL;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	tasklets_tasklet_declare_self ("OptionalPeerToPeer.send_refresh_periodically");
	_tmp0_ = tasklets_tasklet_self ();
	_g_object_unref0 (self->priv->send_refresh_handle);
	self->priv->send_refresh_handle = _tmp0_;
	while (TRUE) {
		NetsukukuMapRoute* _tmp1_;
		NetsukukuAddressManager* _tmp2_;
		NetsukukuAddressManager* _tmp3_;
		NetsukukuAddressManagerFakeRmt* _tmp4_ = NULL;
		NetsukukuAddressManagerFakeRmt* bclient;
		NetsukukuAddressManagerFakeRmt* _tmp5_;
		gint _tmp6_;
		NetsukukuIOptionalPeerToPeer* _tmp7_ = NULL;
		NetsukukuIOptionalPeerToPeer* _tmp8_;
		NetsukukuMapRoute* _tmp9_;
		NetsukukuNIP* _tmp10_;
		NetsukukuNIP* _tmp11_;
		NetsukukuMapPeerToPeer* _tmp12_;
		NetsukukuPackedParticipantNodes* _tmp13_ = NULL;
		NetsukukuPackedParticipantNodes* _tmp14_;
		tasklets_ms_wait ((gint64) 60000);
		_tmp1_ = ((NetsukukuPeerToPeer*) self)->maproute;
		_tmp2_ = netsukuku_map_route_get_address_manager (_tmp1_);
		_tmp3_ = _tmp2_;
		_tmp4_ = netsukuku_address_manager_get_broadcast_client (_tmp3_);
		bclient = _tmp4_;
		_tmp5_ = bclient;
		_tmp6_ = ((NetsukukuPeerToPeer*) self)->pid;
		_tmp7_ = netsukuku_iaddress_manager_root_dispatcher_get_optional_peer_to_peer_service ((NetsukukuIAddressManagerRootDispatcher*) _tmp5_, _tmp6_);
		_tmp8_ = _tmp7_;
		_tmp9_ = ((NetsukukuPeerToPeer*) self)->maproute;
		_tmp10_ = netsukuku_map_get_me ((NetsukukuMap*) _tmp9_);
		_tmp11_ = _tmp10_;
		_tmp12_ = self->map_peer_to_peer;
		_tmp13_ = netsukuku_map_peer_to_peer_get_packed_nodes (_tmp12_);
		_tmp14_ = _tmp13_;
		netsukuku_ioptional_peer_to_peer_participant_refresh (_tmp8_, _tmp11_, _tmp14_, &_inner_error_);
		_g_object_unref0 (_tmp14_);
		_g_object_unref0 (_tmp8_);
		if (_inner_error_ != NULL) {
			g_propagate_error (error, _inner_error_);
			_g_object_unref0 (bclient);
			return;
		}
		_g_object_unref0 (bclient);
	}
}


static void* netsukuku_optional_peer_to_peer_helper_send_refresh_periodically (void* v, GError** error) {
	void* result = NULL;
	void* _tmp0_;
	Netsukukustruct_helper_OptionalPeerToPeer_send_refresh_periodically* tuple_p;
	NetsukukuOptionalPeerToPeer* _tmp1_;
	NetsukukuOptionalPeerToPeer* _tmp2_;
	NetsukukuOptionalPeerToPeer* self_save;
	GError * _inner_error_ = NULL;
	_tmp0_ = v;
	tuple_p = (Netsukukustruct_helper_OptionalPeerToPeer_send_refresh_periodically*) _tmp0_;
	_tmp1_ = (*tuple_p).self;
	_tmp2_ = _g_object_ref0 (_tmp1_);
	self_save = _tmp2_;
	tasklets_tasklet_schedule_back ();
	netsukuku_optional_peer_to_peer_impl_send_refresh_periodically (self_save, &_inner_error_);
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		_g_object_unref0 (self_save);
		return NULL;
	}
	result = NULL;
	_g_object_unref0 (self_save);
	return result;
}


void netsukuku_optional_peer_to_peer_send_refresh_periodically (NetsukukuOptionalPeerToPeer* self) {
	Netsukukustruct_helper_OptionalPeerToPeer_send_refresh_periodically arg = {0};
	NetsukukuOptionalPeerToPeer* _tmp0_;
	TaskletsTasklet* _tmp1_ = NULL;
	TaskletsTasklet* _tmp2_;
	g_return_if_fail (self != NULL);
	memset (&arg, 0, sizeof (Netsukukustruct_helper_OptionalPeerToPeer_send_refresh_periodically));
	_tmp0_ = _g_object_ref0 (self);
	_g_object_unref0 (arg.self);
	arg.self = _tmp0_;
	_tmp1_ = tasklets_tasklet_spawn ((FunctionDelegate) netsukuku_optional_peer_to_peer_helper_send_refresh_periodically, &arg, FALSE, -1);
	_tmp2_ = _tmp1_;
	_g_object_unref0 (_tmp2_);
	netsukuku_struct_helper_optionalpeertopeer_send_refresh_periodically_destroy (&arg);
}


/** Returns True iff the node lvl, pos is participating
          * to the service.
          */
static gboolean netsukuku_optional_peer_to_peer_real_is_participant (NetsukukuPeerToPeer* base, gint lvl, gint pos) {
	NetsukukuOptionalPeerToPeer * self;
	gboolean result = FALSE;
	NetsukukuMapPeerToPeer* _tmp0_;
	gint _tmp1_;
	gint _tmp2_;
	gpointer _tmp3_ = NULL;
	NetsukukuParticipantNode* _tmp4_;
	gboolean _tmp5_;
	gboolean _tmp6_;
	self = (NetsukukuOptionalPeerToPeer*) base;
	_tmp0_ = self->map_peer_to_peer;
	_tmp1_ = lvl;
	_tmp2_ = pos;
	_tmp3_ = netsukuku_map_node_get ((NetsukukuMap*) _tmp0_, _tmp1_, _tmp2_);
	_tmp4_ = (NetsukukuParticipantNode*) _tmp3_;
	_tmp5_ = _tmp4_->participant;
	_tmp6_ = _tmp5_;
	_g_object_unref0 (_tmp4_);
	result = _tmp6_;
	return result;
}


/** Become a participant node.
          */
void netsukuku_optional_peer_to_peer_participate (NetsukukuOptionalPeerToPeer* self) {
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	{
		gboolean _tmp0_;
		gboolean _tmp1_;
		_tmp0_ = netsukuku_optional_peer_to_peer_get_participant (self);
		_tmp1_ = _tmp0_;
		if (!_tmp1_) {
			NetsukukuMapPeerToPeer* _tmp2_;
			NetsukukuMapRoute* _tmp3_;
			NetsukukuAddressManager* _tmp4_;
			NetsukukuAddressManager* _tmp5_;
			NetsukukuAddressManagerFakeRmt* _tmp6_ = NULL;
			NetsukukuAddressManagerFakeRmt* bclient;
			NetsukukuAddressManagerFakeRmt* _tmp7_;
			gint _tmp8_;
			NetsukukuIOptionalPeerToPeer* _tmp9_ = NULL;
			NetsukukuIOptionalPeerToPeer* _tmp10_;
			NetsukukuMapRoute* _tmp11_;
			NetsukukuNIP* _tmp12_;
			NetsukukuNIP* _tmp13_;
			NetsukukuMapRoute* _tmp14_;
			NetsukukuNIP* _tmp15_;
			NetsukukuNIP* _tmp16_;
			gint _tmp17_ = 0;
			NetsukukuParticipantNode* _tmp18_ = NULL;
			NetsukukuParticipantNode* _tmp19_;
			_tmp2_ = self->map_peer_to_peer;
			netsukuku_map_peer_to_peer_participate (_tmp2_);
			_tmp3_ = ((NetsukukuPeerToPeer*) self)->maproute;
			_tmp4_ = netsukuku_map_route_get_address_manager (_tmp3_);
			_tmp5_ = _tmp4_;
			_tmp6_ = netsukuku_address_manager_get_broadcast_client (_tmp5_);
			bclient = _tmp6_;
			_tmp7_ = bclient;
			_tmp8_ = ((NetsukukuPeerToPeer*) self)->pid;
			_tmp9_ = netsukuku_iaddress_manager_root_dispatcher_get_optional_peer_to_peer_service ((NetsukukuIAddressManagerRootDispatcher*) _tmp7_, _tmp8_);
			_tmp10_ = _tmp9_;
			_tmp11_ = ((NetsukukuPeerToPeer*) self)->maproute;
			_tmp12_ = netsukuku_map_get_me ((NetsukukuMap*) _tmp11_);
			_tmp13_ = _tmp12_;
			_tmp14_ = ((NetsukukuPeerToPeer*) self)->maproute;
			_tmp15_ = netsukuku_map_get_me ((NetsukukuMap*) _tmp14_);
			_tmp16_ = _tmp15_;
			_tmp17_ = netsukuku_partial_nip_position_at ((NetsukukuPartialNIP*) _tmp16_, 0);
			_tmp18_ = netsukuku_optional_peer_to_peer_get_my_node (self, 0);
			_tmp19_ = _tmp18_;
			netsukuku_ioptional_peer_to_peer_participant_set (_tmp10_, _tmp13_, 0, _tmp17_, _tmp19_, &_inner_error_);
			_g_object_unref0 (_tmp19_);
			_g_object_unref0 (_tmp10_);
			if (_inner_error_ != NULL) {
				_g_object_unref0 (bclient);
				if (_inner_error_->domain == ZCD_RPC_ERROR) {
					goto __catch101_zcd_rpc_error;
				}
				_g_object_unref0 (bclient);
				g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return;
			}
			_g_object_unref0 (bclient);
		}
	}
	goto __finally101;
	__catch101_zcd_rpc_error:
	{
		GError* ne = NULL;
		ne = _inner_error_;
		_inner_error_ = NULL;
		_g_error_free0 (ne);
	}
	__finally101:
	if (_inner_error_ != NULL) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
}


/** Go outside and don't participate to the service.
          */
void netsukuku_optional_peer_to_peer_sit_out (NetsukukuOptionalPeerToPeer* self) {
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	{
		gboolean _tmp0_;
		gboolean _tmp1_;
		_tmp0_ = netsukuku_optional_peer_to_peer_get_participant (self);
		_tmp1_ = _tmp0_;
		if (_tmp1_) {
			GeeArrayList* _tmp2_;
			GeeArrayList* changes;
			NetsukukuMapPeerToPeer* _tmp19_;
			NetsukukuMapRoute* _tmp20_;
			NetsukukuAddressManager* _tmp21_;
			NetsukukuAddressManager* _tmp22_;
			NetsukukuAddressManagerFakeRmt* _tmp23_ = NULL;
			NetsukukuAddressManagerFakeRmt* bclient;
			_tmp2_ = gee_array_list_new (G_TYPE_INT, NULL, NULL, NULL, NULL, NULL);
			changes = _tmp2_;
			{
				gint lvl;
				lvl = 0;
				{
					gboolean _tmp3_;
					_tmp3_ = TRUE;
					while (TRUE) {
						gboolean _tmp4_;
						gint _tmp6_;
						NetsukukuMapRoute* _tmp7_;
						gint _tmp8_;
						gint _tmp9_;
						gint _tmp10_;
						NetsukukuMapRoute* _tmp11_;
						NetsukukuNIP* _tmp12_;
						NetsukukuNIP* _tmp13_;
						gint _tmp14_;
						gint _tmp15_ = 0;
						gboolean _tmp16_ = FALSE;
						_tmp4_ = _tmp3_;
						if (!_tmp4_) {
							gint _tmp5_;
							_tmp5_ = lvl;
							lvl = _tmp5_ + 1;
						}
						_tmp3_ = FALSE;
						_tmp6_ = lvl;
						_tmp7_ = ((NetsukukuPeerToPeer*) self)->maproute;
						_tmp8_ = netsukuku_map_get_levels ((NetsukukuMap*) _tmp7_);
						_tmp9_ = _tmp8_;
						if (!(_tmp6_ < _tmp9_)) {
							break;
						}
						_tmp10_ = lvl;
						_tmp11_ = ((NetsukukuPeerToPeer*) self)->maproute;
						_tmp12_ = netsukuku_map_get_me ((NetsukukuMap*) _tmp11_);
						_tmp13_ = _tmp12_;
						_tmp14_ = lvl;
						_tmp15_ = netsukuku_partial_nip_position_at ((NetsukukuPartialNIP*) _tmp13_, _tmp14_);
						_tmp16_ = netsukuku_peer_to_peer_is_participant ((NetsukukuPeerToPeer*) self, _tmp10_, _tmp15_);
						if (_tmp16_) {
							GeeArrayList* _tmp17_;
							gint _tmp18_;
							_tmp17_ = changes;
							_tmp18_ = lvl;
							gee_abstract_collection_add ((GeeAbstractCollection*) _tmp17_, (gpointer) ((gintptr) _tmp18_));
						}
					}
				}
			}
			_tmp19_ = self->map_peer_to_peer;
			netsukuku_map_peer_to_peer_sit_out (_tmp19_);
			_tmp20_ = ((NetsukukuPeerToPeer*) self)->maproute;
			_tmp21_ = netsukuku_map_route_get_address_manager (_tmp20_);
			_tmp22_ = _tmp21_;
			_tmp23_ = netsukuku_address_manager_get_broadcast_client (_tmp22_);
			bclient = _tmp23_;
			{
				GeeArrayList* _tmp24_;
				GeeArrayList* _tmp25_;
				GeeArrayList* _lvl_list;
				GeeArrayList* _tmp26_;
				gint _tmp27_;
				gint _tmp28_;
				gint _lvl_size;
				gint _lvl_index;
				_tmp24_ = changes;
				_tmp25_ = _g_object_ref0 (_tmp24_);
				_lvl_list = _tmp25_;
				_tmp26_ = _lvl_list;
				_tmp27_ = gee_abstract_collection_get_size ((GeeCollection*) _tmp26_);
				_tmp28_ = _tmp27_;
				_lvl_size = _tmp28_;
				_lvl_index = -1;
				while (TRUE) {
					gint _tmp29_;
					gint _tmp30_;
					gint _tmp31_;
					GeeArrayList* _tmp32_;
					gint _tmp33_;
					gpointer _tmp34_ = NULL;
					gint lvl;
					NetsukukuAddressManagerFakeRmt* _tmp35_;
					gint _tmp36_;
					NetsukukuIOptionalPeerToPeer* _tmp37_ = NULL;
					NetsukukuIOptionalPeerToPeer* _tmp38_;
					NetsukukuMapRoute* _tmp39_;
					NetsukukuNIP* _tmp40_;
					NetsukukuNIP* _tmp41_;
					gint _tmp42_;
					NetsukukuMapRoute* _tmp43_;
					NetsukukuNIP* _tmp44_;
					NetsukukuNIP* _tmp45_;
					gint _tmp46_;
					gint _tmp47_ = 0;
					gint _tmp48_;
					NetsukukuParticipantNode* _tmp49_ = NULL;
					NetsukukuParticipantNode* _tmp50_;
					_tmp29_ = _lvl_index;
					_lvl_index = _tmp29_ + 1;
					_tmp30_ = _lvl_index;
					_tmp31_ = _lvl_size;
					if (!(_tmp30_ < _tmp31_)) {
						break;
					}
					_tmp32_ = _lvl_list;
					_tmp33_ = _lvl_index;
					_tmp34_ = gee_abstract_list_get ((GeeAbstractList*) _tmp32_, _tmp33_);
					lvl = (gint) ((gintptr) _tmp34_);
					_tmp35_ = bclient;
					_tmp36_ = ((NetsukukuPeerToPeer*) self)->pid;
					_tmp37_ = netsukuku_iaddress_manager_root_dispatcher_get_optional_peer_to_peer_service ((NetsukukuIAddressManagerRootDispatcher*) _tmp35_, _tmp36_);
					_tmp38_ = _tmp37_;
					_tmp39_ = ((NetsukukuPeerToPeer*) self)->maproute;
					_tmp40_ = netsukuku_map_get_me ((NetsukukuMap*) _tmp39_);
					_tmp41_ = _tmp40_;
					_tmp42_ = lvl;
					_tmp43_ = ((NetsukukuPeerToPeer*) self)->maproute;
					_tmp44_ = netsukuku_map_get_me ((NetsukukuMap*) _tmp43_);
					_tmp45_ = _tmp44_;
					_tmp46_ = lvl;
					_tmp47_ = netsukuku_partial_nip_position_at ((NetsukukuPartialNIP*) _tmp45_, _tmp46_);
					_tmp48_ = lvl;
					_tmp49_ = netsukuku_optional_peer_to_peer_get_my_node (self, _tmp48_);
					_tmp50_ = _tmp49_;
					netsukuku_ioptional_peer_to_peer_participant_set (_tmp38_, _tmp41_, _tmp42_, _tmp47_, _tmp50_, &_inner_error_);
					_g_object_unref0 (_tmp50_);
					_g_object_unref0 (_tmp38_);
					if (_inner_error_ != NULL) {
						_g_object_unref0 (_lvl_list);
						_g_object_unref0 (bclient);
						_g_object_unref0 (changes);
						if (_inner_error_->domain == ZCD_RPC_ERROR) {
							goto __catch102_zcd_rpc_error;
						}
						_g_object_unref0 (_lvl_list);
						_g_object_unref0 (bclient);
						_g_object_unref0 (changes);
						g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
						g_clear_error (&_inner_error_);
						return;
					}
				}
				_g_object_unref0 (_lvl_list);
			}
			_g_object_unref0 (bclient);
			_g_object_unref0 (changes);
		}
	}
	goto __finally102;
	__catch102_zcd_rpc_error:
	{
		GError* ne = NULL;
		ne = _inner_error_;
		_inner_error_ = NULL;
		_g_error_free0 (ne);
	}
	__finally102:
	if (_inner_error_ != NULL) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
}


static void netsukuku_optional_peer_to_peer_real_start_operations (NetsukukuPeerToPeer* base) {
	NetsukukuOptionalPeerToPeer * self;
	self = (NetsukukuOptionalPeerToPeer*) base;
	NETSUKUKU_PEER_TO_PEER_CLASS (netsukuku_optional_peer_to_peer_parent_class)->start_operations (G_TYPE_CHECK_INSTANCE_CAST (self, NETSUKUKU_TYPE_PEER_TO_PEER, NetsukukuPeerToPeer));
	netsukuku_optional_peer_to_peer_send_refresh_periodically (self);
}


static void netsukuku_optional_peer_to_peer_real_stop_operations (NetsukukuPeerToPeer* base) {
	NetsukukuOptionalPeerToPeer * self;
	NetsukukuMapRoute* _tmp0_;
	gint _tmp1_;
	gint _tmp2_;
	NetsukukuMapRoute* _tmp3_;
	gint _tmp4_;
	gint _tmp5_;
	NetsukukuMapRoute* _tmp6_;
	NetsukukuNIP* _tmp7_;
	NetsukukuNIP* _tmp8_;
	gchar* _tmp9_ = NULL;
	gchar* ipstr;
	const gchar* _tmp10_;
	const gchar* _tmp11_ = NULL;
	gchar* _tmp12_ = NULL;
	gchar* _tmp13_;
	gboolean _tmp14_;
	gboolean _tmp15_;
	TaskletsTasklet* _tmp16_;
	const gchar* _tmp22_;
	const gchar* _tmp23_ = NULL;
	gchar* _tmp24_ = NULL;
	gchar* _tmp25_;
	NetsukukuMapPeerToPeer* _tmp26_;
	self = (NetsukukuOptionalPeerToPeer*) base;
	_tmp0_ = ((NetsukukuPeerToPeer*) self)->maproute;
	_tmp1_ = netsukuku_map_get_levels ((NetsukukuMap*) _tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = ((NetsukukuPeerToPeer*) self)->maproute;
	_tmp4_ = netsukuku_map_get_gsize ((NetsukukuMap*) _tmp3_);
	_tmp5_ = _tmp4_;
	_tmp6_ = ((NetsukukuPeerToPeer*) self)->maproute;
	_tmp7_ = netsukuku_map_get_me ((NetsukukuMap*) _tmp6_);
	_tmp8_ = _tmp7_;
	_tmp9_ = netsukuku_nip_to_str (_tmp2_, _tmp5_, _tmp8_);
	ipstr = _tmp9_;
	_tmp10_ = ipstr;
	_tmp11_ = string_to_string (_tmp10_);
	_tmp12_ = g_strconcat ("OptionalPeerToPeer: stopping operations for ", _tmp11_, NULL);
	_tmp13_ = _tmp12_;
	netsukuku_log_debug (_tmp13_);
	_g_free0 (_tmp13_);
	netsukuku_log_debug ("Coord: calling base");
	NETSUKUKU_PEER_TO_PEER_CLASS (netsukuku_optional_peer_to_peer_parent_class)->stop_operations (G_TYPE_CHECK_INSTANCE_CAST (self, NETSUKUKU_TYPE_PEER_TO_PEER, NetsukukuPeerToPeer));
	netsukuku_log_debug ("Coord: base done");
	_tmp14_ = netsukuku_optional_peer_to_peer_get_participant (self);
	_tmp15_ = _tmp14_;
	if (_tmp15_) {
		netsukuku_optional_peer_to_peer_sit_out (self);
	}
	_tmp16_ = self->priv->send_refresh_handle;
	if (_tmp16_ != NULL) {
		const gchar* _tmp17_;
		const gchar* _tmp18_ = NULL;
		gchar* _tmp19_ = NULL;
		gchar* _tmp20_;
		TaskletsTasklet* _tmp21_;
		_tmp17_ = ipstr;
		_tmp18_ = string_to_string (_tmp17_);
		_tmp19_ = g_strconcat ("OptionalPeerToPeer: aborting send_refresh for ", _tmp18_, NULL);
		_tmp20_ = _tmp19_;
		netsukuku_log_debug (_tmp20_);
		_g_free0 (_tmp20_);
		_tmp21_ = self->priv->send_refresh_handle;
		tasklets_tasklet_abort (_tmp21_);
		_g_object_unref0 (self->priv->send_refresh_handle);
		self->priv->send_refresh_handle = NULL;
	}
	_tmp22_ = ipstr;
	_tmp23_ = string_to_string (_tmp22_);
	_tmp24_ = g_strconcat ("OptionalPeerToPeer: calling stop_operations on map_peer_to_peer for ", _tmp23_, NULL);
	_tmp25_ = _tmp24_;
	netsukuku_log_debug (_tmp25_);
	_g_free0 (_tmp25_);
	_tmp26_ = self->map_peer_to_peer;
	netsukuku_map_stop_operations ((NetsukukuMap*) _tmp26_);
	_g_free0 (ipstr);
}


gchar* netsukuku_optional_peer_to_peer_log_service (NetsukukuOptionalPeerToPeer* self) {
	gchar* result = NULL;
	gint _tmp0_;
	gchar* _tmp1_ = NULL;
	gchar* _tmp2_;
	NetsukukuMapPeerToPeer* _tmp3_;
	gchar* _tmp4_ = NULL;
	gchar* _tmp5_;
	const gchar* _tmp6_ = NULL;
	gchar* _tmp7_ = NULL;
	gchar* _tmp8_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = ((NetsukukuPeerToPeer*) self)->pid;
	_tmp1_ = g_strdup_printf ("%i", _tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = self->map_peer_to_peer;
	_tmp4_ = netsukuku_map_peer_to_peer_log_service (_tmp3_);
	_tmp5_ = _tmp4_;
	_tmp6_ = string_to_string (_tmp5_);
	_tmp7_ = g_strconcat ("[", _tmp2_, ", ", _tmp6_, "]", NULL);
	_tmp8_ = _tmp7_;
	_g_free0 (_tmp5_);
	_g_free0 (_tmp2_);
	result = _tmp8_;
	return result;
}


gboolean netsukuku_optional_peer_to_peer_get_participant (NetsukukuOptionalPeerToPeer* self) {
	gboolean result;
	NetsukukuParticipantNode* _tmp0_ = NULL;
	NetsukukuParticipantNode* _tmp1_;
	gboolean _tmp2_;
	gboolean _tmp3_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = netsukuku_optional_peer_to_peer_get_my_node (self, 0);
	_tmp1_ = _tmp0_;
	_tmp2_ = _tmp1_->participant;
	_tmp3_ = _tmp2_;
	_g_object_unref0 (_tmp1_);
	result = _tmp3_;
	return result;
}


static void netsukuku_optional_peer_to_peer_class_init (NetsukukuOptionalPeerToPeerClass * klass) {
	netsukuku_optional_peer_to_peer_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (NetsukukuOptionalPeerToPeerPrivate));
	NETSUKUKU_PEER_TO_PEER_CLASS (klass)->is_participant = netsukuku_optional_peer_to_peer_real_is_participant;
	NETSUKUKU_PEER_TO_PEER_CLASS (klass)->start_operations = netsukuku_optional_peer_to_peer_real_start_operations;
	NETSUKUKU_PEER_TO_PEER_CLASS (klass)->stop_operations = netsukuku_optional_peer_to_peer_real_stop_operations;
	G_OBJECT_CLASS (klass)->get_property = _vala_netsukuku_optional_peer_to_peer_get_property;
	G_OBJECT_CLASS (klass)->finalize = netsukuku_optional_peer_to_peer_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), NETSUKUKU_OPTIONAL_PEER_TO_PEER_PARTICIPANT, g_param_spec_boolean ("participant", "participant", "participant", FALSE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
}


static void netsukuku_optional_peer_to_peer_netsukuku_ioptional_peer_to_peer_interface_init (NetsukukuIOptionalPeerToPeerIface * iface) {
	netsukuku_optional_peer_to_peer_netsukuku_ioptional_peer_to_peer_parent_iface = g_type_interface_peek_parent (iface);
	iface->participant_set = (void (*)(NetsukukuIOptionalPeerToPeer*, NetsukukuNIP*, gint, gint, NetsukukuParticipantNode*, GError**)) netsukuku_optional_peer_to_peer_real_participant_set;
	iface->participant_refresh = (void (*)(NetsukukuIOptionalPeerToPeer*, NetsukukuNIP*, NetsukukuPackedParticipantNodes*, GError**)) netsukuku_optional_peer_to_peer_real_participant_refresh;
}


static void netsukuku_optional_peer_to_peer_instance_init (NetsukukuOptionalPeerToPeer * self) {
	self->priv = NETSUKUKU_OPTIONAL_PEER_TO_PEER_GET_PRIVATE (self);
}


static void netsukuku_optional_peer_to_peer_finalize (GObject* obj) {
	NetsukukuOptionalPeerToPeer * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, NETSUKUKU_TYPE_OPTIONAL_PEER_TO_PEER, NetsukukuOptionalPeerToPeer);
	_g_object_unref0 (self->map_peer_to_peer);
	_g_object_unref0 (self->priv->send_refresh_handle);
	G_OBJECT_CLASS (netsukuku_optional_peer_to_peer_parent_class)->finalize (obj);
}


/** This is the class that must be inherited to create a PeerToPeer module.
      * A PeerToPeer service which is not Strict (optional) has these features:
      *  * It is not mandatory that all the nodes of the network know about
      *    this service. Hence, a node may not even have the code of this service
      *    nor know that the service-id number is in use.
      *    Nevertheless, every node will participate to the routing of messages
      *    towards the nodes participating to the service.
      *  * A node might have the code necessary to participate to the service
      *    and so be able to serve requests. A node might have the code necessary
      *    to be a client of the service and so be able to be served. It is not
      *    necessary, however, to split the code: usually a node has all the code
      *    or nothing.
      *  * A node that knows about a service (has the code) might participate to
      *    the service or not. Even if it does not participate, it is able to
      *    make requests to the service and the nodes that participate will be
      *    able to answer.
      */
GType netsukuku_optional_peer_to_peer_get_type (void) {
	static volatile gsize netsukuku_optional_peer_to_peer_type_id__volatile = 0;
	if (g_once_init_enter (&netsukuku_optional_peer_to_peer_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (NetsukukuOptionalPeerToPeerClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) netsukuku_optional_peer_to_peer_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (NetsukukuOptionalPeerToPeer), 0, (GInstanceInitFunc) netsukuku_optional_peer_to_peer_instance_init, NULL };
		static const GInterfaceInfo netsukuku_ioptional_peer_to_peer_info = { (GInterfaceInitFunc) netsukuku_optional_peer_to_peer_netsukuku_ioptional_peer_to_peer_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
		GType netsukuku_optional_peer_to_peer_type_id;
		netsukuku_optional_peer_to_peer_type_id = g_type_register_static (NETSUKUKU_TYPE_PEER_TO_PEER, "NetsukukuOptionalPeerToPeer", &g_define_type_info, 0);
		g_type_add_interface_static (netsukuku_optional_peer_to_peer_type_id, NETSUKUKU_TYPE_IOPTIONAL_PEER_TO_PEER, &netsukuku_ioptional_peer_to_peer_info);
		g_once_init_leave (&netsukuku_optional_peer_to_peer_type_id__volatile, netsukuku_optional_peer_to_peer_type_id);
	}
	return netsukuku_optional_peer_to_peer_type_id__volatile;
}


static void _vala_netsukuku_optional_peer_to_peer_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	NetsukukuOptionalPeerToPeer * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, NETSUKUKU_TYPE_OPTIONAL_PEER_TO_PEER, NetsukukuOptionalPeerToPeer);
	switch (property_id) {
		case NETSUKUKU_OPTIONAL_PEER_TO_PEER_PARTICIPANT:
		g_value_set_boolean (value, netsukuku_optional_peer_to_peer_get_participant (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


void netsukuku_struct_helper_peertopeerall_start_operations_copy (const Netsukukustruct_helper_PeerToPeerAll_start_operations* self, Netsukukustruct_helper_PeerToPeerAll_start_operations* dest) {
	NetsukukuPeerToPeerAll* _tmp0_;
	NetsukukuPeerToPeerAll* _tmp1_;
	_tmp0_ = (*self).self;
	_tmp1_ = _g_object_ref0 (_tmp0_);
	_g_object_unref0 ((*dest).self);
	(*dest).self = _tmp1_;
}


void netsukuku_struct_helper_peertopeerall_start_operations_destroy (Netsukukustruct_helper_PeerToPeerAll_start_operations* self) {
	_g_object_unref0 ((*self).self);
}


Netsukukustruct_helper_PeerToPeerAll_start_operations* netsukuku_struct_helper_peertopeerall_start_operations_dup (const Netsukukustruct_helper_PeerToPeerAll_start_operations* self) {
	Netsukukustruct_helper_PeerToPeerAll_start_operations* dup;
	dup = g_new0 (Netsukukustruct_helper_PeerToPeerAll_start_operations, 1);
	netsukuku_struct_helper_peertopeerall_start_operations_copy (self, dup);
	return dup;
}


void netsukuku_struct_helper_peertopeerall_start_operations_free (Netsukukustruct_helper_PeerToPeerAll_start_operations* self) {
	netsukuku_struct_helper_peertopeerall_start_operations_destroy (self);
	g_free (self);
}


GType netsukuku_struct_helper_peertopeerall_start_operations_get_type (void) {
	static volatile gsize netsukuku_struct_helper_peertopeerall_start_operations_type_id__volatile = 0;
	if (g_once_init_enter (&netsukuku_struct_helper_peertopeerall_start_operations_type_id__volatile)) {
		GType netsukuku_struct_helper_peertopeerall_start_operations_type_id;
		netsukuku_struct_helper_peertopeerall_start_operations_type_id = g_boxed_type_register_static ("Netsukukustruct_helper_PeerToPeerAll_start_operations", (GBoxedCopyFunc) netsukuku_struct_helper_peertopeerall_start_operations_dup, (GBoxedFreeFunc) netsukuku_struct_helper_peertopeerall_start_operations_free);
		g_once_init_leave (&netsukuku_struct_helper_peertopeerall_start_operations_type_id__volatile, netsukuku_struct_helper_peertopeerall_start_operations_type_id);
	}
	return netsukuku_struct_helper_peertopeerall_start_operations_type_id__volatile;
}


NetsukukuPeerToPeerAll* netsukuku_peer_to_peer_all_construct (GType object_type, NetsukukuAggregatedNeighbourManager* aggregated_neighbour_manager, NetsukukuMapRoute* maproute) {
	NetsukukuPeerToPeerAll * self = NULL;
	NetsukukuAggregatedNeighbourManager* _tmp0_;
	NetsukukuMapRoute* _tmp1_;
	GeeHashMap* _tmp2_;
	g_return_val_if_fail (aggregated_neighbour_manager != NULL, NULL);
	g_return_val_if_fail (maproute != NULL, NULL);
	self = (NetsukukuPeerToPeerAll*) g_object_new (object_type, NULL);
	_tmp0_ = aggregated_neighbour_manager;
	netsukuku_peer_to_peer_all_set_aggregated_neighbour_manager (self, _tmp0_);
	_tmp1_ = maproute;
	netsukuku_peer_to_peer_all_set_maproute (self, _tmp1_);
	self->priv->left_all_optional_peer_to_peer = FALSE;
	_tmp2_ = gee_hash_map_new (G_TYPE_INT, NULL, NULL, NETSUKUKU_TYPE_PEER_TO_PEER, (GBoxedCopyFunc) g_object_ref, g_object_unref, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
	_g_object_unref0 (self->priv->service);
	self->priv->service = _tmp2_;
	return self;
}


NetsukukuPeerToPeerAll* netsukuku_peer_to_peer_all_new (NetsukukuAggregatedNeighbourManager* aggregated_neighbour_manager, NetsukukuMapRoute* maproute) {
	return netsukuku_peer_to_peer_all_construct (NETSUKUKU_TYPE_PEER_TO_PEER_ALL, aggregated_neighbour_manager, maproute);
}


NetsukukuPeerToPeer* netsukuku_peer_to_peer_all_pid_add (NetsukukuPeerToPeerAll* self, gint pid) {
	NetsukukuPeerToPeer* result = NULL;
	GeeHashMap* _tmp0_;
	gint _tmp1_;
	NetsukukuAggregatedNeighbourManager* _tmp2_;
	NetsukukuMapRoute* _tmp3_;
	gint _tmp4_;
	NetsukukuOptionalPeerToPeer* _tmp5_;
	NetsukukuOptionalPeerToPeer* _tmp6_;
	GeeHashMap* _tmp7_;
	gint _tmp8_;
	gpointer _tmp9_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->service;
	_tmp1_ = pid;
	_tmp2_ = self->priv->_aggregated_neighbour_manager;
	_tmp3_ = self->priv->_maproute;
	_tmp4_ = pid;
	_tmp5_ = netsukuku_optional_peer_to_peer_new (_tmp2_, _tmp3_, _tmp4_);
	_tmp6_ = _tmp5_;
	gee_abstract_map_set ((GeeAbstractMap*) _tmp0_, (gpointer) ((gintptr) _tmp1_), (NetsukukuPeerToPeer*) _tmp6_);
	_g_object_unref0 (_tmp6_);
	_tmp7_ = self->priv->service;
	_tmp8_ = pid;
	_tmp9_ = gee_abstract_map_get ((GeeAbstractMap*) _tmp7_, (gpointer) ((gintptr) _tmp8_));
	result = (NetsukukuPeerToPeer*) _tmp9_;
	return result;
}


NetsukukuPeerToPeer* netsukuku_peer_to_peer_all_pid_get (NetsukukuPeerToPeerAll* self, gint pid) {
	NetsukukuPeerToPeer* result = NULL;
	GeeHashMap* _tmp0_;
	gint _tmp1_;
	gboolean _tmp2_ = FALSE;
	gint _tmp6_;
	NetsukukuPeerToPeer* _tmp7_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->service;
	_tmp1_ = pid;
	_tmp2_ = gee_abstract_map_has_key ((GeeAbstractMap*) _tmp0_, (gpointer) ((gintptr) _tmp1_));
	if (_tmp2_) {
		GeeHashMap* _tmp3_;
		gint _tmp4_;
		gpointer _tmp5_ = NULL;
		_tmp3_ = self->priv->service;
		_tmp4_ = pid;
		_tmp5_ = gee_abstract_map_get ((GeeAbstractMap*) _tmp3_, (gpointer) ((gintptr) _tmp4_));
		result = (NetsukukuPeerToPeer*) _tmp5_;
		return result;
	}
	_tmp6_ = pid;
	_tmp7_ = netsukuku_peer_to_peer_all_pid_add (self, _tmp6_);
	result = _tmp7_;
	return result;
}


void netsukuku_peer_to_peer_all_pid_del (NetsukukuPeerToPeerAll* self, gint pid) {
	GeeHashMap* _tmp0_;
	gint _tmp1_;
	gboolean _tmp2_ = FALSE;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->service;
	_tmp1_ = pid;
	_tmp2_ = gee_abstract_map_has_key ((GeeAbstractMap*) _tmp0_, (gpointer) ((gintptr) _tmp1_));
	if (_tmp2_) {
		GeeHashMap* _tmp3_;
		gint _tmp4_;
		_tmp3_ = self->priv->service;
		_tmp4_ = pid;
		gee_abstract_map_unset ((GeeAbstractMap*) _tmp3_, (gpointer) ((gintptr) _tmp4_), NULL);
	}
}


/** Used to add for the first time a PeerToPeer instance of a module in the
          * PeerToPeerAll dictionary.
          */
static void netsukuku_peer_to_peer_all_real_peer_to_peer_register (NetsukukuPeerToPeerAll* self, NetsukukuPeerToPeer* peer_to_peer, GError** error) {
	NetsukukuPeerToPeer* _tmp0_;
	gint _tmp1_;
	gchar* _tmp2_ = NULL;
	gchar* _tmp3_;
	gchar* _tmp4_ = NULL;
	gchar* _tmp5_;
	GeeHashMap* _tmp6_;
	NetsukukuPeerToPeer* _tmp7_;
	gint _tmp8_;
	gboolean _tmp9_ = FALSE;
	GeeHashMap* _tmp46_;
	NetsukukuPeerToPeer* _tmp47_;
	gint _tmp48_;
	NetsukukuPeerToPeer* _tmp49_;
	GError * _inner_error_ = NULL;
	g_return_if_fail (peer_to_peer != NULL);
	_tmp0_ = peer_to_peer;
	_tmp1_ = _tmp0_->pid;
	_tmp2_ = g_strdup_printf ("%i", _tmp1_);
	_tmp3_ = _tmp2_;
	_tmp4_ = g_strconcat ("Called PeerToPeerAll.peer_to_peer_register for ", _tmp3_, NULL);
	_tmp5_ = _tmp4_;
	netsukuku_log_debug (_tmp5_);
	_g_free0 (_tmp5_);
	_g_free0 (_tmp3_);
	_tmp6_ = self->priv->service;
	_tmp7_ = peer_to_peer;
	_tmp8_ = _tmp7_->pid;
	_tmp9_ = gee_abstract_map_has_key ((GeeAbstractMap*) _tmp6_, (gpointer) ((gintptr) _tmp8_));
	if (_tmp9_) {
		NetsukukuPeerToPeer* _tmp10_;
		GType _tmp11_ = 0UL;
		gboolean _tmp12_ = FALSE;
		NetsukukuPeerToPeer* _tmp14_;
		NetsukukuOptionalPeerToPeer* _tmp15_;
		NetsukukuOptionalPeerToPeer* optional_peer_to_peer;
		NetsukukuPeerToPeer* _tmp16_;
		gint _tmp17_;
		NetsukukuPeerToPeer* _tmp18_ = NULL;
		NetsukukuPeerToPeer* pre;
		NetsukukuPeerToPeer* _tmp19_;
		GType _tmp20_ = 0UL;
		NetsukukuPeerToPeer* _tmp40_;
		NetsukukuOptionalPeerToPeer* _tmp41_;
		NetsukukuOptionalPeerToPeer* optional_pre;
		NetsukukuOptionalPeerToPeer* _tmp42_;
		NetsukukuOptionalPeerToPeer* _tmp43_;
		NetsukukuMapPeerToPeer* _tmp44_;
		NetsukukuMapPeerToPeer* _tmp45_;
		_tmp10_ = peer_to_peer;
		_tmp11_ = G_TYPE_FROM_INSTANCE ((GObject*) _tmp10_);
		_tmp12_ = g_type_is_a (_tmp11_, NETSUKUKU_TYPE_OPTIONAL_PEER_TO_PEER);
		if (!_tmp12_) {
			GError* _tmp13_;
			_tmp13_ = g_error_new_literal (NETSUKUKU_PEER_TO_PEER_ERROR, NETSUKUKU_PEER_TO_PEER_ERROR_REGISTER, "Strict services have to be registered once.");
			_inner_error_ = _tmp13_;
			if (_inner_error_->domain == NETSUKUKU_PEER_TO_PEER_ERROR) {
				g_propagate_error (error, _inner_error_);
				return;
			} else {
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return;
			}
		}
		_tmp14_ = peer_to_peer;
		_tmp15_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp14_, NETSUKUKU_TYPE_OPTIONAL_PEER_TO_PEER, NetsukukuOptionalPeerToPeer));
		optional_peer_to_peer = _tmp15_;
		_tmp16_ = peer_to_peer;
		_tmp17_ = _tmp16_->pid;
		_tmp18_ = netsukuku_peer_to_peer_all_pid_get (self, _tmp17_);
		pre = _tmp18_;
		_tmp19_ = peer_to_peer;
		_tmp20_ = G_TYPE_FROM_INSTANCE ((GObject*) _tmp19_);
		if (_tmp20_ != NETSUKUKU_TYPE_OPTIONAL_PEER_TO_PEER) {
			NetsukukuPeerToPeer* _tmp21_;
			GType _tmp22_ = 0UL;
			const gchar* _tmp23_ = NULL;
			const gchar* _tmp24_ = NULL;
			gchar* _tmp25_ = NULL;
			gchar* _tmp26_;
			NetsukukuPeerToPeer* _tmp27_;
			gint _tmp28_;
			gchar* _tmp29_ = NULL;
			gchar* _tmp30_;
			NetsukukuPeerToPeer* _tmp31_;
			GType _tmp32_ = 0UL;
			const gchar* _tmp33_ = NULL;
			const gchar* _tmp34_ = NULL;
			gchar* _tmp35_ = NULL;
			gchar* _tmp36_;
			gchar* _tmp37_;
			gchar* _tmp38_;
			GError* _tmp39_;
			_tmp21_ = peer_to_peer;
			_tmp22_ = G_TYPE_FROM_INSTANCE ((GObject*) _tmp21_);
			_tmp23_ = g_type_name (_tmp22_);
			_tmp24_ = string_to_string (_tmp23_);
			_tmp25_ = g_strconcat (_tmp24_, " is trying to use", NULL);
			_tmp26_ = _tmp25_;
			_tmp27_ = peer_to_peer;
			_tmp28_ = _tmp27_->pid;
			_tmp29_ = g_strdup_printf ("%i", _tmp28_);
			_tmp30_ = _tmp29_;
			_tmp31_ = pre;
			_tmp32_ = G_TYPE_FROM_INSTANCE ((GObject*) _tmp31_);
			_tmp33_ = g_type_name (_tmp32_);
			_tmp34_ = string_to_string (_tmp33_);
			_tmp35_ = g_strconcat (" pid ", _tmp30_, " but it is used by ", _tmp34_, NULL);
			_tmp36_ = _tmp35_;
			_tmp37_ = g_strconcat (_tmp26_, _tmp36_, NULL);
			_tmp38_ = _tmp37_;
			netsukuku_log_error (_tmp38_);
			_g_free0 (_tmp38_);
			_g_free0 (_tmp36_);
			_g_free0 (_tmp30_);
			_g_free0 (_tmp26_);
			_tmp39_ = g_error_new_literal (NETSUKUKU_PEER_TO_PEER_ERROR, NETSUKUKU_PEER_TO_PEER_ERROR_REGISTER, "Optional services have to use unique IDs.");
			_inner_error_ = _tmp39_;
			if (_inner_error_->domain == NETSUKUKU_PEER_TO_PEER_ERROR) {
				g_propagate_error (error, _inner_error_);
				_g_object_unref0 (pre);
				_g_object_unref0 (optional_peer_to_peer);
				return;
			} else {
				_g_object_unref0 (pre);
				_g_object_unref0 (optional_peer_to_peer);
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return;
			}
		}
		_tmp40_ = pre;
		_tmp41_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp40_, NETSUKUKU_TYPE_OPTIONAL_PEER_TO_PEER, NetsukukuOptionalPeerToPeer));
		optional_pre = _tmp41_;
		_tmp42_ = optional_peer_to_peer;
		_tmp43_ = optional_pre;
		_tmp44_ = _tmp43_->map_peer_to_peer;
		_tmp45_ = _g_object_ref0 (_tmp44_);
		_g_object_unref0 (_tmp42_->map_peer_to_peer);
		_tmp42_->map_peer_to_peer = _tmp45_;
		_g_object_unref0 (optional_pre);
		_g_object_unref0 (pre);
		_g_object_unref0 (optional_peer_to_peer);
	}
	_tmp46_ = self->priv->service;
	_tmp47_ = peer_to_peer;
	_tmp48_ = _tmp47_->pid;
	_tmp49_ = peer_to_peer;
	gee_abstract_map_set ((GeeAbstractMap*) _tmp46_, (gpointer) ((gintptr) _tmp48_), _tmp49_);
}


void netsukuku_peer_to_peer_all_peer_to_peer_register (NetsukukuPeerToPeerAll* self, NetsukukuPeerToPeer* peer_to_peer, GError** error) {
	g_return_if_fail (self != NULL);
	NETSUKUKU_PEER_TO_PEER_ALL_GET_CLASS (self)->peer_to_peer_register (self, peer_to_peer, error);
}


void netsukuku_peer_to_peer_all_leave_all_optional_peer_to_peer (NetsukukuPeerToPeerAll* self) {
	g_return_if_fail (self != NULL);
	{
		GeeHashMap* _tmp0_;
		GeeCollection* _tmp1_;
		GeeCollection* _tmp2_;
		GeeCollection* _tmp3_;
		GeeIterator* _tmp4_ = NULL;
		GeeIterator* _tmp5_;
		GeeIterator* _peer_to_peer_it;
		_tmp0_ = self->priv->service;
		_tmp1_ = gee_abstract_map_get_values ((GeeMap*) _tmp0_);
		_tmp2_ = _tmp1_;
		_tmp3_ = _tmp2_;
		_tmp4_ = gee_iterable_iterator ((GeeIterable*) _tmp3_);
		_tmp5_ = _tmp4_;
		_g_object_unref0 (_tmp3_);
		_peer_to_peer_it = _tmp5_;
		while (TRUE) {
			GeeIterator* _tmp6_;
			gboolean _tmp7_ = FALSE;
			GeeIterator* _tmp8_;
			gpointer _tmp9_ = NULL;
			NetsukukuPeerToPeer* peer_to_peer;
			NetsukukuPeerToPeer* _tmp10_;
			GType _tmp11_ = 0UL;
			gboolean _tmp12_ = FALSE;
			_tmp6_ = _peer_to_peer_it;
			_tmp7_ = gee_iterator_next (_tmp6_);
			if (!_tmp7_) {
				break;
			}
			_tmp8_ = _peer_to_peer_it;
			_tmp9_ = gee_iterator_get (_tmp8_);
			peer_to_peer = (NetsukukuPeerToPeer*) _tmp9_;
			_tmp10_ = peer_to_peer;
			_tmp11_ = G_TYPE_FROM_INSTANCE ((GObject*) _tmp10_);
			_tmp12_ = g_type_is_a (_tmp11_, NETSUKUKU_TYPE_OPTIONAL_PEER_TO_PEER);
			if (_tmp12_) {
				NetsukukuPeerToPeer* _tmp13_;
				NetsukukuOptionalPeerToPeer* _tmp14_;
				NetsukukuOptionalPeerToPeer* optional_peer_to_peer;
				NetsukukuOptionalPeerToPeer* _tmp15_;
				NetsukukuOptionalPeerToPeer* _tmp16_;
				_tmp13_ = peer_to_peer;
				_tmp14_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp13_, NETSUKUKU_TYPE_OPTIONAL_PEER_TO_PEER, NetsukukuOptionalPeerToPeer));
				optional_peer_to_peer = _tmp14_;
				_tmp15_ = optional_peer_to_peer;
				_tmp15_->will_participate = FALSE;
				_tmp16_ = optional_peer_to_peer;
				netsukuku_optional_peer_to_peer_sit_out (_tmp16_);
				_g_object_unref0 (optional_peer_to_peer);
			}
			_g_object_unref0 (peer_to_peer);
		}
		_g_object_unref0 (_peer_to_peer_it);
	}
	self->priv->left_all_optional_peer_to_peer = TRUE;
}


static gboolean netsukuku_peer_to_peer_all_not_impl_equal_func (GObject* a, GObject* b) {
	gboolean result = FALSE;
	g_error ("peer_to_peer.vala:1382: PeerToPeerAll.get_optional_participants: equal" \
"_func not implemented");
	return result;
}


static gboolean _netsukuku_peer_to_peer_all_not_impl_equal_func_gee_equal_data_func (gconstpointer a, gconstpointer b, gpointer self) {
	gboolean result;
	result = netsukuku_peer_to_peer_all_not_impl_equal_func (a, b);
	return result;
}


static NetsukukuSetOptionalServiceParticipants* netsukuku_peer_to_peer_all_real_get_optional_participants (NetsukukuIPeerToPeerAll* base, GError** error) {
	NetsukukuPeerToPeerAll * self;
	NetsukukuSetOptionalServiceParticipants* result = NULL;
	GeeArrayList* _tmp0_;
	GeeArrayList* l_osp;
	GeeArrayList* _tmp26_;
	NetsukukuSetOptionalServiceParticipants* _tmp27_;
	self = (NetsukukuPeerToPeerAll*) base;
	_tmp0_ = gee_array_list_new (NETSUKUKU_TYPE_OPTIONAL_SERVICE_PARTICIPANTS, (GBoxedCopyFunc) g_object_ref, g_object_unref, _netsukuku_peer_to_peer_all_not_impl_equal_func_gee_equal_data_func, NULL, NULL);
	l_osp = _tmp0_;
	{
		GeeHashMap* _tmp1_;
		GeeCollection* _tmp2_;
		GeeCollection* _tmp3_;
		GeeCollection* _tmp4_;
		GeeIterator* _tmp5_ = NULL;
		GeeIterator* _tmp6_;
		GeeIterator* _peer_to_peer_it;
		_tmp1_ = self->priv->service;
		_tmp2_ = gee_abstract_map_get_values ((GeeMap*) _tmp1_);
		_tmp3_ = _tmp2_;
		_tmp4_ = _tmp3_;
		_tmp5_ = gee_iterable_iterator ((GeeIterable*) _tmp4_);
		_tmp6_ = _tmp5_;
		_g_object_unref0 (_tmp4_);
		_peer_to_peer_it = _tmp6_;
		while (TRUE) {
			GeeIterator* _tmp7_;
			gboolean _tmp8_ = FALSE;
			GeeIterator* _tmp9_;
			gpointer _tmp10_ = NULL;
			NetsukukuPeerToPeer* peer_to_peer;
			NetsukukuPeerToPeer* _tmp11_;
			GType _tmp12_ = 0UL;
			gboolean _tmp13_ = FALSE;
			_tmp7_ = _peer_to_peer_it;
			_tmp8_ = gee_iterator_next (_tmp7_);
			if (!_tmp8_) {
				break;
			}
			_tmp9_ = _peer_to_peer_it;
			_tmp10_ = gee_iterator_get (_tmp9_);
			peer_to_peer = (NetsukukuPeerToPeer*) _tmp10_;
			_tmp11_ = peer_to_peer;
			_tmp12_ = G_TYPE_FROM_INSTANCE ((GObject*) _tmp11_);
			_tmp13_ = g_type_is_a (_tmp12_, NETSUKUKU_TYPE_OPTIONAL_PEER_TO_PEER);
			if (_tmp13_) {
				NetsukukuPeerToPeer* _tmp14_;
				NetsukukuOptionalPeerToPeer* _tmp15_;
				NetsukukuOptionalPeerToPeer* optional_peer_to_peer;
				NetsukukuOptionalServiceParticipants* _tmp16_;
				NetsukukuOptionalServiceParticipants* osp;
				NetsukukuOptionalServiceParticipants* _tmp17_;
				NetsukukuOptionalPeerToPeer* _tmp18_;
				gint _tmp19_;
				NetsukukuOptionalServiceParticipants* _tmp20_;
				NetsukukuOptionalPeerToPeer* _tmp21_;
				NetsukukuMapPeerToPeer* _tmp22_;
				NetsukukuPackedParticipantNodes* _tmp23_ = NULL;
				GeeArrayList* _tmp24_;
				NetsukukuOptionalServiceParticipants* _tmp25_;
				_tmp14_ = peer_to_peer;
				_tmp15_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp14_, NETSUKUKU_TYPE_OPTIONAL_PEER_TO_PEER, NetsukukuOptionalPeerToPeer));
				optional_peer_to_peer = _tmp15_;
				_tmp16_ = netsukuku_optional_service_participants_new ();
				osp = _tmp16_;
				_tmp17_ = osp;
				_tmp18_ = optional_peer_to_peer;
				_tmp19_ = ((NetsukukuPeerToPeer*) _tmp18_)->pid;
				_tmp17_->pid = _tmp19_;
				_tmp20_ = osp;
				_tmp21_ = optional_peer_to_peer;
				_tmp22_ = _tmp21_->map_peer_to_peer;
				_tmp23_ = netsukuku_map_peer_to_peer_get_packed_nodes (_tmp22_);
				_g_object_unref0 (_tmp20_->ppnodes);
				_tmp20_->ppnodes = _tmp23_;
				_tmp24_ = l_osp;
				_tmp25_ = osp;
				gee_abstract_collection_add ((GeeAbstractCollection*) _tmp24_, _tmp25_);
				_g_object_unref0 (osp);
				_g_object_unref0 (optional_peer_to_peer);
			}
			_g_object_unref0 (peer_to_peer);
		}
		_g_object_unref0 (_peer_to_peer_it);
	}
	_tmp26_ = l_osp;
	_tmp27_ = netsukuku_set_optional_service_participants_new ((GeeList*) _tmp26_);
	result = _tmp27_;
	_g_object_unref0 (l_osp);
	return result;
}


/** It gets the peer_to_peer maps from our nearest neighbour.
          */
void netsukuku_peer_to_peer_all_retrieve_optional_services_and_participants (NetsukukuPeerToPeerAll* self) {
	gchar* _tmp0_ = NULL;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	NetsukukuAggregatedNeighbourManager* _tmp4_;
	gboolean _tmp5_;
	GeeList* _tmp6_ = NULL;
	GeeList* neighbours_in_net;
	gboolean got_answer;
	gboolean try_again;
	NetsukukuSetOptionalServiceParticipants* nr_optional_participants;
	NetsukukuAggregatedNeighbour* minnr;
	gboolean _tmp80_;
	gchar* _tmp102_ = NULL;
	gchar* _tmp103_;
	gchar* _tmp104_;
	gchar* _tmp105_;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	netsukuku_log_debug ("PeerToPeerAll retrieve_optional_services_and_participants: started");
	_tmp0_ = netsukuku_peer_to_peer_all_log_services (self);
	_tmp1_ = _tmp0_;
	_tmp2_ = g_strconcat ("PeerToPeerAll retrieve_optional_services_and_participants: list ", _tmp1_, NULL);
	_tmp3_ = _tmp2_;
	netsukuku_log_debug (_tmp3_);
	_g_free0 (_tmp3_);
	_g_free0 (_tmp1_);
	_tmp4_ = self->priv->_aggregated_neighbour_manager;
	_tmp5_ = TRUE;
	_tmp6_ = netsukuku_aggregated_neighbour_manager_neighbour_list (_tmp4_, &_tmp5_, NULL);
	neighbours_in_net = _tmp6_;
	got_answer = FALSE;
	try_again = TRUE;
	nr_optional_participants = NULL;
	minnr = NULL;
	while (TRUE) {
		gboolean _tmp7_ = FALSE;
		gboolean _tmp8_;
		gboolean _tmp10_;
		NetsukukuMapRoute* _tmp11_;
		gint _tmp12_;
		gint _tmp13_;
		gint minlvl;
		NetsukukuAggregatedNeighbour* _tmp38_;
		_tmp8_ = got_answer;
		if (!_tmp8_) {
			gboolean _tmp9_;
			_tmp9_ = try_again;
			_tmp7_ = _tmp9_;
		} else {
			_tmp7_ = FALSE;
		}
		_tmp10_ = _tmp7_;
		if (!_tmp10_) {
			break;
		}
		_g_object_unref0 (minnr);
		minnr = NULL;
		_tmp11_ = self->priv->_maproute;
		_tmp12_ = netsukuku_map_get_levels ((NetsukukuMap*) _tmp11_);
		_tmp13_ = _tmp12_;
		minlvl = _tmp13_;
		{
			GeeList* _tmp14_;
			GeeList* _tmp15_;
			GeeList* _nr_list;
			GeeList* _tmp16_;
			gint _tmp17_;
			gint _tmp18_;
			gint _nr_size;
			gint _nr_index;
			_tmp14_ = neighbours_in_net;
			_tmp15_ = _g_object_ref0 (_tmp14_);
			_nr_list = _tmp15_;
			_tmp16_ = _nr_list;
			_tmp17_ = gee_collection_get_size ((GeeCollection*) _tmp16_);
			_tmp18_ = _tmp17_;
			_nr_size = _tmp18_;
			_nr_index = -1;
			while (TRUE) {
				gint _tmp19_;
				gint _tmp20_;
				gint _tmp21_;
				GeeList* _tmp22_;
				gint _tmp23_;
				gpointer _tmp24_ = NULL;
				NetsukukuAggregatedNeighbour* nr;
				NetsukukuMapRoute* _tmp25_;
				NetsukukuAggregatedNeighbour* _tmp26_;
				NetsukukuNIP* _tmp27_;
				gint _tmp28_ = 0;
				gint* _tmp29_ = NULL;
				gint* _tmp30_;
				gint _tmp30__length1;
				gint _tmp31_ = 0;
				gint _tmp32_;
				gint lvl;
				gint _tmp33_;
				gint _tmp34_;
				_tmp19_ = _nr_index;
				_nr_index = _tmp19_ + 1;
				_tmp20_ = _nr_index;
				_tmp21_ = _nr_size;
				if (!(_tmp20_ < _tmp21_)) {
					break;
				}
				_tmp22_ = _nr_list;
				_tmp23_ = _nr_index;
				_tmp24_ = gee_list_get (_tmp22_, _tmp23_);
				nr = (NetsukukuAggregatedNeighbour*) _tmp24_;
				_tmp25_ = self->priv->_maproute;
				_tmp26_ = nr;
				_tmp27_ = _tmp26_->nip;
				_tmp29_ = netsukuku_partial_nip_get_positions ((NetsukukuPartialNIP*) _tmp27_, &_tmp28_);
				_tmp30_ = _tmp29_;
				_tmp30__length1 = _tmp28_;
				_tmp31_ = netsukuku_map_nip_cmp ((NetsukukuMap*) _tmp25_, _tmp30_, _tmp28_);
				_tmp32_ = _tmp31_;
				_tmp30_ = (g_free (_tmp30_), NULL);
				lvl = _tmp32_;
				_tmp33_ = lvl;
				_tmp34_ = minlvl;
				if (_tmp33_ < _tmp34_) {
					gint _tmp35_;
					NetsukukuAggregatedNeighbour* _tmp36_;
					NetsukukuAggregatedNeighbour* _tmp37_;
					_tmp35_ = lvl;
					minlvl = _tmp35_;
					_tmp36_ = nr;
					_tmp37_ = _g_object_ref0 (_tmp36_);
					_g_object_unref0 (minnr);
					minnr = _tmp37_;
				}
				_g_object_unref0 (nr);
			}
			_g_object_unref0 (_nr_list);
		}
		_tmp38_ = minnr;
		if (_tmp38_ == NULL) {
			netsukuku_log_debug ("PeerToPeerAll retrieve_optional_services_and_participants: No neighbou" \
"rs");
			try_again = FALSE;
		} else {
			NetsukukuAggregatedNeighbour* _tmp39_;
			NetsukukuNIP* _tmp40_;
			gchar* _tmp41_ = NULL;
			gchar* _tmp42_;
			gchar* _tmp43_;
			gchar* _tmp44_;
			_tmp39_ = minnr;
			_tmp40_ = _tmp39_->nip;
			_tmp41_ = netsukuku_partial_nip_to_string ((NetsukukuPartialNIP*) _tmp40_);
			_tmp42_ = _tmp41_;
			_tmp43_ = g_strconcat ("PeerToPeerAll retrieve_optional_services_and_participants: " "ask to ", _tmp42_, NULL);
			_tmp44_ = _tmp43_;
			netsukuku_log_debug (_tmp44_);
			_g_free0 (_tmp44_);
			_g_free0 (_tmp42_);
			{
				NetsukukuAggregatedNeighbour* _tmp45_;
				NetsukukuAddressManagerTCPClient* _tmp46_;
				NetsukukuAddressManagerTCPClient* _tmp47_;
				NetsukukuIPeerToPeerAll* _tmp48_;
				NetsukukuIPeerToPeerAll* _tmp49_;
				NetsukukuSetOptionalServiceParticipants* _tmp50_ = NULL;
				NetsukukuSetOptionalServiceParticipants* _tmp51_;
				NetsukukuAggregatedNeighbour* _tmp52_;
				NetsukukuNIP* _tmp53_;
				gchar* _tmp54_ = NULL;
				gchar* _tmp55_;
				gchar* _tmp56_ = NULL;
				gchar* _tmp57_;
				gchar* _tmp58_;
				gchar* _tmp59_;
				_tmp45_ = minnr;
				_tmp46_ = netsukuku_aggregated_neighbour_get_tcp_client (_tmp45_);
				_tmp47_ = _tmp46_;
				_tmp48_ = netsukuku_iaddress_manager_root_dispatcher_get_peer_to_peer_all ((NetsukukuIAddressManagerRootDispatcher*) _tmp47_);
				_tmp49_ = _tmp48_;
				_tmp50_ = netsukuku_ipeer_to_peer_all_get_optional_participants (_tmp49_, &_inner_error_);
				_tmp51_ = _tmp50_;
				if (_inner_error_ != NULL) {
					goto __catch103_g_error;
				}
				_g_object_unref0 (nr_optional_participants);
				nr_optional_participants = _tmp51_;
				_tmp52_ = minnr;
				_tmp53_ = _tmp52_->nip;
				_tmp54_ = netsukuku_partial_nip_to_string ((NetsukukuPartialNIP*) _tmp53_);
				_tmp55_ = _tmp54_;
				_tmp56_ = g_strconcat ("Asking to ", _tmp55_, " succeeded", NULL);
				_tmp57_ = _tmp56_;
				_tmp58_ = g_strconcat ("PeerToPeerAll retrieve_optional_services_and_participants: ", _tmp57_, NULL);
				_tmp59_ = _tmp58_;
				netsukuku_log_debug (_tmp59_);
				_g_free0 (_tmp59_);
				_g_free0 (_tmp57_);
				_g_free0 (_tmp55_);
				got_answer = TRUE;
			}
			goto __finally103;
			__catch103_g_error:
			{
				GError* e = NULL;
				NetsukukuAggregatedNeighbour* _tmp60_;
				NetsukukuNIP* _tmp61_;
				gchar* _tmp62_ = NULL;
				gchar* _tmp63_;
				GError* _tmp64_;
				GQuark _tmp65_;
				const gchar* _tmp66_ = NULL;
				GError* _tmp67_;
				gint _tmp68_;
				gchar* _tmp69_ = NULL;
				gchar* _tmp70_;
				GError* _tmp71_;
				const gchar* _tmp72_;
				const gchar* _tmp73_ = NULL;
				gchar* _tmp74_ = NULL;
				gchar* _tmp75_;
				gchar* _tmp76_;
				gchar* _tmp77_;
				GeeList* _tmp78_;
				NetsukukuAggregatedNeighbour* _tmp79_;
				e = _inner_error_;
				_inner_error_ = NULL;
				_tmp60_ = minnr;
				_tmp61_ = _tmp60_->nip;
				_tmp62_ = netsukuku_partial_nip_to_string ((NetsukukuPartialNIP*) _tmp61_);
				_tmp63_ = _tmp62_;
				_tmp64_ = e;
				_tmp65_ = _tmp64_->domain;
				_tmp66_ = g_quark_to_string (_tmp65_);
				_tmp67_ = e;
				_tmp68_ = _tmp67_->code;
				_tmp69_ = g_strdup_printf ("%i", _tmp68_);
				_tmp70_ = _tmp69_;
				_tmp71_ = e;
				_tmp72_ = _tmp71_->message;
				_tmp73_ = string_to_string (_tmp72_);
				_tmp74_ = g_strconcat ("Asking to ", _tmp63_, " failed: got ", _tmp66_, " code ", _tmp70_, ": ", _tmp73_, NULL);
				_tmp75_ = _tmp74_;
				_tmp76_ = g_strconcat ("PeerToPeerAll retrieve_optional_services_and_participants: ", _tmp75_, NULL);
				_tmp77_ = _tmp76_;
				netsukuku_log_warn (_tmp77_);
				_g_free0 (_tmp77_);
				_g_free0 (_tmp75_);
				_g_free0 (_tmp70_);
				_g_free0 (_tmp63_);
				_tmp78_ = neighbours_in_net;
				_tmp79_ = minnr;
				gee_collection_remove ((GeeCollection*) _tmp78_, _tmp79_);
				_g_error_free0 (e);
			}
			__finally103:
			if (_inner_error_ != NULL) {
				_g_object_unref0 (minnr);
				_g_object_unref0 (nr_optional_participants);
				_g_object_unref0 (neighbours_in_net);
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return;
			}
		}
	}
	_tmp80_ = got_answer;
	if (_tmp80_) {
		{
			NetsukukuSetOptionalServiceParticipants* _tmp81_;
			GeeArrayList* _tmp82_;
			GeeArrayList* _tmp83_;
			GeeArrayList* _osp_list;
			GeeArrayList* _tmp84_;
			gint _tmp85_;
			gint _tmp86_;
			gint _osp_size;
			gint _osp_index;
			_tmp81_ = nr_optional_participants;
			_tmp82_ = _tmp81_->o_s_participants;
			_tmp83_ = _g_object_ref0 (_tmp82_);
			_osp_list = _tmp83_;
			_tmp84_ = _osp_list;
			_tmp85_ = gee_abstract_collection_get_size ((GeeCollection*) _tmp84_);
			_tmp86_ = _tmp85_;
			_osp_size = _tmp86_;
			_osp_index = -1;
			while (TRUE) {
				gint _tmp87_;
				gint _tmp88_;
				gint _tmp89_;
				GeeArrayList* _tmp90_;
				gint _tmp91_;
				gpointer _tmp92_ = NULL;
				NetsukukuOptionalServiceParticipants* osp;
				NetsukukuOptionalServiceParticipants* _tmp93_;
				gint _tmp94_;
				NetsukukuPeerToPeer* _tmp95_ = NULL;
				NetsukukuOptionalPeerToPeer* _tmp96_;
				NetsukukuMapPeerToPeer* _tmp97_;
				NetsukukuAggregatedNeighbour* _tmp98_;
				NetsukukuNIP* _tmp99_;
				NetsukukuOptionalServiceParticipants* _tmp100_;
				NetsukukuPackedParticipantNodes* _tmp101_;
				_tmp87_ = _osp_index;
				_osp_index = _tmp87_ + 1;
				_tmp88_ = _osp_index;
				_tmp89_ = _osp_size;
				if (!(_tmp88_ < _tmp89_)) {
					break;
				}
				_tmp90_ = _osp_list;
				_tmp91_ = _osp_index;
				_tmp92_ = gee_abstract_list_get ((GeeAbstractList*) _tmp90_, _tmp91_);
				osp = (NetsukukuOptionalServiceParticipants*) _tmp92_;
				_tmp93_ = osp;
				_tmp94_ = _tmp93_->pid;
				_tmp95_ = netsukuku_peer_to_peer_all_pid_get (self, _tmp94_);
				_tmp96_ = G_TYPE_CHECK_INSTANCE_CAST (_tmp95_, NETSUKUKU_TYPE_OPTIONAL_PEER_TO_PEER, NetsukukuOptionalPeerToPeer);
				_tmp97_ = _tmp96_->map_peer_to_peer;
				_tmp98_ = minnr;
				_tmp99_ = _tmp98_->nip;
				_tmp100_ = osp;
				_tmp101_ = _tmp100_->ppnodes;
				netsukuku_map_peer_to_peer_initialize_from_neighbour (_tmp97_, _tmp99_, _tmp101_);
				_g_object_unref0 (_tmp96_);
				_g_object_unref0 (osp);
			}
			_g_object_unref0 (_osp_list);
		}
	}
	_tmp102_ = netsukuku_peer_to_peer_all_log_services (self);
	_tmp103_ = _tmp102_;
	_tmp104_ = g_strconcat ("PeerToPeerAll retrieve_optional_services_and_participants: final list ", _tmp103_, NULL);
	_tmp105_ = _tmp104_;
	netsukuku_log_debug (_tmp105_);
	_g_free0 (_tmp105_);
	_g_free0 (_tmp103_);
	_g_object_unref0 (minnr);
	_g_object_unref0 (nr_optional_participants);
	_g_object_unref0 (neighbours_in_net);
}


static gchar* netsukuku_peer_to_peer_all_log_services (NetsukukuPeerToPeerAll* self) {
	gchar* result = NULL;
	gchar* _tmp0_;
	gchar* ret;
	const gchar* _tmp23_;
	gchar* _tmp24_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = g_strdup ("{");
	ret = _tmp0_;
	{
		GeeHashMap* _tmp1_;
		GeeCollection* _tmp2_;
		GeeCollection* _tmp3_;
		GeeCollection* _tmp4_;
		GeeIterator* _tmp5_ = NULL;
		GeeIterator* _tmp6_;
		GeeIterator* _peer_to_peer_it;
		_tmp1_ = self->priv->service;
		_tmp2_ = gee_abstract_map_get_values ((GeeMap*) _tmp1_);
		_tmp3_ = _tmp2_;
		_tmp4_ = _tmp3_;
		_tmp5_ = gee_iterable_iterator ((GeeIterable*) _tmp4_);
		_tmp6_ = _tmp5_;
		_g_object_unref0 (_tmp4_);
		_peer_to_peer_it = _tmp6_;
		while (TRUE) {
			GeeIterator* _tmp7_;
			gboolean _tmp8_ = FALSE;
			GeeIterator* _tmp9_;
			gpointer _tmp10_ = NULL;
			NetsukukuPeerToPeer* peer_to_peer;
			NetsukukuPeerToPeer* _tmp11_;
			GType _tmp12_ = 0UL;
			gboolean _tmp13_ = FALSE;
			_tmp7_ = _peer_to_peer_it;
			_tmp8_ = gee_iterator_next (_tmp7_);
			if (!_tmp8_) {
				break;
			}
			_tmp9_ = _peer_to_peer_it;
			_tmp10_ = gee_iterator_get (_tmp9_);
			peer_to_peer = (NetsukukuPeerToPeer*) _tmp10_;
			_tmp11_ = peer_to_peer;
			_tmp12_ = G_TYPE_FROM_INSTANCE ((GObject*) _tmp11_);
			_tmp13_ = g_type_is_a (_tmp12_, NETSUKUKU_TYPE_OPTIONAL_PEER_TO_PEER);
			if (_tmp13_) {
				NetsukukuPeerToPeer* _tmp14_;
				NetsukukuOptionalPeerToPeer* _tmp15_;
				NetsukukuOptionalPeerToPeer* optional_peer_to_peer;
				const gchar* _tmp16_;
				NetsukukuOptionalPeerToPeer* _tmp17_;
				gchar* _tmp18_ = NULL;
				gchar* _tmp19_;
				gchar* _tmp20_;
				const gchar* _tmp21_;
				gchar* _tmp22_;
				_tmp14_ = peer_to_peer;
				_tmp15_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp14_, NETSUKUKU_TYPE_OPTIONAL_PEER_TO_PEER, NetsukukuOptionalPeerToPeer));
				optional_peer_to_peer = _tmp15_;
				_tmp16_ = ret;
				_tmp17_ = optional_peer_to_peer;
				_tmp18_ = netsukuku_optional_peer_to_peer_log_service (_tmp17_);
				_tmp19_ = _tmp18_;
				_tmp20_ = g_strconcat (_tmp16_, _tmp19_, NULL);
				_g_free0 (ret);
				ret = _tmp20_;
				_g_free0 (_tmp19_);
				_tmp21_ = ret;
				_tmp22_ = g_strconcat (_tmp21_, ", ", NULL);
				_g_free0 (ret);
				ret = _tmp22_;
				_g_object_unref0 (optional_peer_to_peer);
			}
			_g_object_unref0 (peer_to_peer);
		}
		_g_object_unref0 (_peer_to_peer_it);
	}
	_tmp23_ = ret;
	_tmp24_ = g_strconcat (_tmp23_, "}", NULL);
	_g_free0 (ret);
	ret = _tmp24_;
	result = ret;
	return result;
}


/** Start operations on various peer_to_peer services.
          */
static void netsukuku_peer_to_peer_all_impl_start_operations (NetsukukuPeerToPeerAll* self, GError** error) {
	g_return_if_fail (self != NULL);
	tasklets_tasklet_declare_self ("PeerToPeerAll.start_operations");
	{
		GeeHashMap* _tmp0_;
		GeeCollection* _tmp1_;
		GeeCollection* _tmp2_;
		GeeCollection* _tmp3_;
		GeeIterator* _tmp4_ = NULL;
		GeeIterator* _tmp5_;
		GeeIterator* _peer_to_peer_it;
		_tmp0_ = self->priv->service;
		_tmp1_ = gee_abstract_map_get_values ((GeeMap*) _tmp0_);
		_tmp2_ = _tmp1_;
		_tmp3_ = _tmp2_;
		_tmp4_ = gee_iterable_iterator ((GeeIterable*) _tmp3_);
		_tmp5_ = _tmp4_;
		_g_object_unref0 (_tmp3_);
		_peer_to_peer_it = _tmp5_;
		while (TRUE) {
			GeeIterator* _tmp6_;
			gboolean _tmp7_ = FALSE;
			GeeIterator* _tmp8_;
			gpointer _tmp9_ = NULL;
			NetsukukuPeerToPeer* peer_to_peer;
			NetsukukuPeerToPeer* _tmp10_;
			GType _tmp11_ = 0UL;
			gboolean _tmp12_ = FALSE;
			_tmp6_ = _peer_to_peer_it;
			_tmp7_ = gee_iterator_next (_tmp6_);
			if (!_tmp7_) {
				break;
			}
			_tmp8_ = _peer_to_peer_it;
			_tmp9_ = gee_iterator_get (_tmp8_);
			peer_to_peer = (NetsukukuPeerToPeer*) _tmp9_;
			_tmp10_ = peer_to_peer;
			_tmp11_ = G_TYPE_FROM_INSTANCE ((GObject*) _tmp10_);
			_tmp12_ = g_type_is_a (_tmp11_, NETSUKUKU_TYPE_OPTIONAL_PEER_TO_PEER);
			if (!_tmp12_) {
				NetsukukuPeerToPeer* _tmp13_;
				_tmp13_ = peer_to_peer;
				netsukuku_peer_to_peer_start_operations (_tmp13_);
			}
			_g_object_unref0 (peer_to_peer);
		}
		_g_object_unref0 (_peer_to_peer_it);
	}
	netsukuku_peer_to_peer_all_retrieve_optional_services_and_participants (self);
	{
		GeeHashMap* _tmp14_;
		GeeCollection* _tmp15_;
		GeeCollection* _tmp16_;
		GeeCollection* _tmp17_;
		GeeIterator* _tmp18_ = NULL;
		GeeIterator* _tmp19_;
		GeeIterator* _peer_to_peer_it;
		_tmp14_ = self->priv->service;
		_tmp15_ = gee_abstract_map_get_values ((GeeMap*) _tmp14_);
		_tmp16_ = _tmp15_;
		_tmp17_ = _tmp16_;
		_tmp18_ = gee_iterable_iterator ((GeeIterable*) _tmp17_);
		_tmp19_ = _tmp18_;
		_g_object_unref0 (_tmp17_);
		_peer_to_peer_it = _tmp19_;
		while (TRUE) {
			GeeIterator* _tmp20_;
			gboolean _tmp21_ = FALSE;
			GeeIterator* _tmp22_;
			gpointer _tmp23_ = NULL;
			NetsukukuPeerToPeer* peer_to_peer;
			NetsukukuPeerToPeer* _tmp24_;
			GType _tmp25_ = 0UL;
			gboolean _tmp26_ = FALSE;
			_tmp20_ = _peer_to_peer_it;
			_tmp21_ = gee_iterator_next (_tmp20_);
			if (!_tmp21_) {
				break;
			}
			_tmp22_ = _peer_to_peer_it;
			_tmp23_ = gee_iterator_get (_tmp22_);
			peer_to_peer = (NetsukukuPeerToPeer*) _tmp23_;
			_tmp24_ = peer_to_peer;
			_tmp25_ = G_TYPE_FROM_INSTANCE ((GObject*) _tmp24_);
			_tmp26_ = g_type_is_a (_tmp25_, NETSUKUKU_TYPE_OPTIONAL_PEER_TO_PEER);
			if (_tmp26_) {
				NetsukukuPeerToPeer* _tmp27_;
				_tmp27_ = peer_to_peer;
				netsukuku_peer_to_peer_start_operations (_tmp27_);
			}
			_g_object_unref0 (peer_to_peer);
		}
		_g_object_unref0 (_peer_to_peer_it);
	}
}


static void* netsukuku_peer_to_peer_all_helper_start_operations (void* v, GError** error) {
	void* result = NULL;
	void* _tmp0_;
	Netsukukustruct_helper_PeerToPeerAll_start_operations* tuple_p;
	NetsukukuPeerToPeerAll* _tmp1_;
	NetsukukuPeerToPeerAll* _tmp2_;
	NetsukukuPeerToPeerAll* self_save;
	GError * _inner_error_ = NULL;
	_tmp0_ = v;
	tuple_p = (Netsukukustruct_helper_PeerToPeerAll_start_operations*) _tmp0_;
	_tmp1_ = (*tuple_p).self;
	_tmp2_ = _g_object_ref0 (_tmp1_);
	self_save = _tmp2_;
	tasklets_tasklet_schedule_back ();
	netsukuku_peer_to_peer_all_impl_start_operations (self_save, &_inner_error_);
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		_g_object_unref0 (self_save);
		return NULL;
	}
	result = NULL;
	_g_object_unref0 (self_save);
	return result;
}


void netsukuku_peer_to_peer_all_start_operations (NetsukukuPeerToPeerAll* self) {
	Netsukukustruct_helper_PeerToPeerAll_start_operations arg = {0};
	NetsukukuPeerToPeerAll* _tmp0_;
	TaskletsTasklet* _tmp1_ = NULL;
	TaskletsTasklet* _tmp2_;
	g_return_if_fail (self != NULL);
	memset (&arg, 0, sizeof (Netsukukustruct_helper_PeerToPeerAll_start_operations));
	_tmp0_ = _g_object_ref0 (self);
	_g_object_unref0 (arg.self);
	arg.self = _tmp0_;
	_tmp1_ = tasklets_tasklet_spawn ((FunctionDelegate) netsukuku_peer_to_peer_all_helper_start_operations, &arg, FALSE, -1);
	_tmp2_ = _tmp1_;
	_g_object_unref0 (_tmp2_);
	netsukuku_struct_helper_peertopeerall_start_operations_destroy (&arg);
}


void netsukuku_peer_to_peer_all_stop_operations (NetsukukuPeerToPeerAll* self) {
	NetsukukuMapRoute* _tmp0_;
	gint _tmp1_;
	gint _tmp2_;
	NetsukukuMapRoute* _tmp3_;
	gint _tmp4_;
	gint _tmp5_;
	NetsukukuMapRoute* _tmp6_;
	NetsukukuNIP* _tmp7_;
	NetsukukuNIP* _tmp8_;
	gchar* _tmp9_ = NULL;
	gchar* ipstr;
	const gchar* _tmp10_;
	const gchar* _tmp11_ = NULL;
	gchar* _tmp12_ = NULL;
	gchar* _tmp13_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->_maproute;
	_tmp1_ = netsukuku_map_get_levels ((NetsukukuMap*) _tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = self->priv->_maproute;
	_tmp4_ = netsukuku_map_get_gsize ((NetsukukuMap*) _tmp3_);
	_tmp5_ = _tmp4_;
	_tmp6_ = self->priv->_maproute;
	_tmp7_ = netsukuku_map_get_me ((NetsukukuMap*) _tmp6_);
	_tmp8_ = _tmp7_;
	_tmp9_ = netsukuku_nip_to_str (_tmp2_, _tmp5_, _tmp8_);
	ipstr = _tmp9_;
	_tmp10_ = ipstr;
	_tmp11_ = string_to_string (_tmp10_);
	_tmp12_ = g_strconcat ("PeerToPeerAll: stopping operations for ", _tmp11_, NULL);
	_tmp13_ = _tmp12_;
	netsukuku_log_debug (_tmp13_);
	_g_free0 (_tmp13_);
	{
		GeeHashMap* _tmp14_;
		GeeCollection* _tmp15_;
		GeeCollection* _tmp16_;
		GeeCollection* _tmp17_;
		GeeIterator* _tmp18_ = NULL;
		GeeIterator* _tmp19_;
		GeeIterator* _peer_to_peer_it;
		_tmp14_ = self->priv->service;
		_tmp15_ = gee_abstract_map_get_values ((GeeMap*) _tmp14_);
		_tmp16_ = _tmp15_;
		_tmp17_ = _tmp16_;
		_tmp18_ = gee_iterable_iterator ((GeeIterable*) _tmp17_);
		_tmp19_ = _tmp18_;
		_g_object_unref0 (_tmp17_);
		_peer_to_peer_it = _tmp19_;
		while (TRUE) {
			GeeIterator* _tmp20_;
			gboolean _tmp21_ = FALSE;
			GeeIterator* _tmp22_;
			gpointer _tmp23_ = NULL;
			NetsukukuPeerToPeer* peer_to_peer;
			NetsukukuPeerToPeer* _tmp24_;
			gint _tmp25_;
			gchar* _tmp26_ = NULL;
			gchar* _tmp27_;
			NetsukukuPeerToPeer* _tmp28_;
			GType _tmp29_ = 0UL;
			const gchar* _tmp30_ = NULL;
			const gchar* _tmp31_ = NULL;
			const gchar* _tmp32_;
			const gchar* _tmp33_ = NULL;
			gchar* _tmp34_ = NULL;
			gchar* _tmp35_;
			NetsukukuPeerToPeer* _tmp36_;
			_tmp20_ = _peer_to_peer_it;
			_tmp21_ = gee_iterator_next (_tmp20_);
			if (!_tmp21_) {
				break;
			}
			_tmp22_ = _peer_to_peer_it;
			_tmp23_ = gee_iterator_get (_tmp22_);
			peer_to_peer = (NetsukukuPeerToPeer*) _tmp23_;
			_tmp24_ = peer_to_peer;
			_tmp25_ = _tmp24_->pid;
			_tmp26_ = g_strdup_printf ("%i", _tmp25_);
			_tmp27_ = _tmp26_;
			_tmp28_ = peer_to_peer;
			_tmp29_ = G_TYPE_FROM_INSTANCE ((GObject*) _tmp28_);
			_tmp30_ = g_type_name (_tmp29_);
			_tmp31_ = string_to_string (_tmp30_);
			_tmp32_ = ipstr;
			_tmp33_ = string_to_string (_tmp32_);
			_tmp34_ = g_strconcat ("PeerToPeerAll: calling stop_operations on ", _tmp27_, " (", _tmp31_, ") for ", _tmp33_, NULL);
			_tmp35_ = _tmp34_;
			netsukuku_log_debug (_tmp35_);
			_g_free0 (_tmp35_);
			_g_free0 (_tmp27_);
			_tmp36_ = peer_to_peer;
			netsukuku_peer_to_peer_stop_operations (_tmp36_);
			_g_object_unref0 (peer_to_peer);
		}
		_g_object_unref0 (_peer_to_peer_it);
	}
	_g_free0 (ipstr);
}


NetsukukuAggregatedNeighbourManager* netsukuku_peer_to_peer_all_get_aggregated_neighbour_manager (NetsukukuPeerToPeerAll* self) {
	NetsukukuAggregatedNeighbourManager* result;
	NetsukukuAggregatedNeighbourManager* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_aggregated_neighbour_manager;
	result = _tmp0_;
	return result;
}


static void netsukuku_peer_to_peer_all_set_aggregated_neighbour_manager (NetsukukuPeerToPeerAll* self, NetsukukuAggregatedNeighbourManager* value) {
	NetsukukuAggregatedNeighbourManager* _tmp0_;
	NetsukukuAggregatedNeighbourManager* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	_tmp1_ = _g_object_ref0 (_tmp0_);
	_g_object_unref0 (self->priv->_aggregated_neighbour_manager);
	self->priv->_aggregated_neighbour_manager = _tmp1_;
	g_object_notify ((GObject *) self, "aggregated-neighbour-manager");
}


NetsukukuMapRoute* netsukuku_peer_to_peer_all_get_maproute (NetsukukuPeerToPeerAll* self) {
	NetsukukuMapRoute* result;
	NetsukukuMapRoute* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_maproute;
	result = _tmp0_;
	return result;
}


static void netsukuku_peer_to_peer_all_set_maproute (NetsukukuPeerToPeerAll* self, NetsukukuMapRoute* value) {
	NetsukukuMapRoute* _tmp0_;
	NetsukukuMapRoute* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	_tmp1_ = _g_object_ref0 (_tmp0_);
	_g_object_unref0 (self->priv->_maproute);
	self->priv->_maproute = _tmp1_;
	g_object_notify ((GObject *) self, "maproute");
}


static void netsukuku_peer_to_peer_all_class_init (NetsukukuPeerToPeerAllClass * klass) {
	netsukuku_peer_to_peer_all_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (NetsukukuPeerToPeerAllPrivate));
	NETSUKUKU_PEER_TO_PEER_ALL_CLASS (klass)->peer_to_peer_register = netsukuku_peer_to_peer_all_real_peer_to_peer_register;
	G_OBJECT_CLASS (klass)->get_property = _vala_netsukuku_peer_to_peer_all_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_netsukuku_peer_to_peer_all_set_property;
	G_OBJECT_CLASS (klass)->finalize = netsukuku_peer_to_peer_all_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), NETSUKUKU_PEER_TO_PEER_ALL_AGGREGATED_NEIGHBOUR_MANAGER, g_param_spec_object ("aggregated-neighbour-manager", "aggregated-neighbour-manager", "aggregated-neighbour-manager", NETSUKUKU_TYPE_AGGREGATED_NEIGHBOUR_MANAGER, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), NETSUKUKU_PEER_TO_PEER_ALL_MAPROUTE, g_param_spec_object ("maproute", "maproute", "maproute", NETSUKUKU_TYPE_MAP_ROUTE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
}


static void netsukuku_peer_to_peer_all_netsukuku_ipeer_to_peer_all_interface_init (NetsukukuIPeerToPeerAllIface * iface) {
	netsukuku_peer_to_peer_all_netsukuku_ipeer_to_peer_all_parent_iface = g_type_interface_peek_parent (iface);
	iface->get_optional_participants = (NetsukukuSetOptionalServiceParticipants* (*)(NetsukukuIPeerToPeerAll*, GError**)) netsukuku_peer_to_peer_all_real_get_optional_participants;
}


static void netsukuku_peer_to_peer_all_instance_init (NetsukukuPeerToPeerAll * self) {
	self->priv = NETSUKUKU_PEER_TO_PEER_ALL_GET_PRIVATE (self);
}


static void netsukuku_peer_to_peer_all_finalize (GObject* obj) {
	NetsukukuPeerToPeerAll * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, NETSUKUKU_TYPE_PEER_TO_PEER_ALL, NetsukukuPeerToPeerAll);
	_g_object_unref0 (self->priv->_aggregated_neighbour_manager);
	_g_object_unref0 (self->priv->_maproute);
	_g_object_unref0 (self->priv->service);
	G_OBJECT_CLASS (netsukuku_peer_to_peer_all_parent_class)->finalize (obj);
}


/** Class of all the registered peer_to_peer services
      */
GType netsukuku_peer_to_peer_all_get_type (void) {
	static volatile gsize netsukuku_peer_to_peer_all_type_id__volatile = 0;
	if (g_once_init_enter (&netsukuku_peer_to_peer_all_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (NetsukukuPeerToPeerAllClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) netsukuku_peer_to_peer_all_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (NetsukukuPeerToPeerAll), 0, (GInstanceInitFunc) netsukuku_peer_to_peer_all_instance_init, NULL };
		static const GInterfaceInfo netsukuku_ipeer_to_peer_all_info = { (GInterfaceInitFunc) netsukuku_peer_to_peer_all_netsukuku_ipeer_to_peer_all_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
		GType netsukuku_peer_to_peer_all_type_id;
		netsukuku_peer_to_peer_all_type_id = g_type_register_static (G_TYPE_OBJECT, "NetsukukuPeerToPeerAll", &g_define_type_info, 0);
		g_type_add_interface_static (netsukuku_peer_to_peer_all_type_id, NETSUKUKU_TYPE_IPEER_TO_PEER_ALL, &netsukuku_ipeer_to_peer_all_info);
		g_once_init_leave (&netsukuku_peer_to_peer_all_type_id__volatile, netsukuku_peer_to_peer_all_type_id);
	}
	return netsukuku_peer_to_peer_all_type_id__volatile;
}


static void _vala_netsukuku_peer_to_peer_all_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	NetsukukuPeerToPeerAll * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, NETSUKUKU_TYPE_PEER_TO_PEER_ALL, NetsukukuPeerToPeerAll);
	switch (property_id) {
		case NETSUKUKU_PEER_TO_PEER_ALL_AGGREGATED_NEIGHBOUR_MANAGER:
		g_value_set_object (value, netsukuku_peer_to_peer_all_get_aggregated_neighbour_manager (self));
		break;
		case NETSUKUKU_PEER_TO_PEER_ALL_MAPROUTE:
		g_value_set_object (value, netsukuku_peer_to_peer_all_get_maproute (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _vala_netsukuku_peer_to_peer_all_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	NetsukukuPeerToPeerAll * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, NETSUKUKU_TYPE_PEER_TO_PEER_ALL, NetsukukuPeerToPeerAll);
	switch (property_id) {
		case NETSUKUKU_PEER_TO_PEER_ALL_AGGREGATED_NEIGHBOUR_MANAGER:
		netsukuku_peer_to_peer_all_set_aggregated_neighbour_manager (self, g_value_get_object (value));
		break;
		case NETSUKUKU_PEER_TO_PEER_ALL_MAPROUTE:
		netsukuku_peer_to_peer_all_set_maproute (self, g_value_get_object (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}



