/* dht_tester.c generated by valac 0.20.1, the Vala compiler
 * generated from dht_tester.vala, do not modify */

/*
 *  This file is part of Netsukuku.
 *  (c) Copyright 2011-2014 Luca Dionisi aka lukisi <luca.dionisi@gmail.com>
 *
 *  Netsukuku is free software: you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation, either version 3 of the License, or
 *  (at your option) any later version.
 *
 *  Netsukuku is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with Netsukuku.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <tasklet.h>
#include <zcd.h>
#include <netsukuku-rpc.h>
#include <gee.h>

#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

#define NETSUKUKU_TYPE_RMT_PEER (netsukuku_rmt_peer_get_type ())
#define NETSUKUKU_RMT_PEER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), NETSUKUKU_TYPE_RMT_PEER, NetsukukuRmtPeer))
#define NETSUKUKU_RMT_PEER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), NETSUKUKU_TYPE_RMT_PEER, NetsukukuRmtPeerClass))
#define NETSUKUKU_IS_RMT_PEER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), NETSUKUKU_TYPE_RMT_PEER))
#define NETSUKUKU_IS_RMT_PEER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), NETSUKUKU_TYPE_RMT_PEER))
#define NETSUKUKU_RMT_PEER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), NETSUKUKU_TYPE_RMT_PEER, NetsukukuRmtPeerClass))

typedef struct _NetsukukuRmtPeer NetsukukuRmtPeer;
typedef struct _NetsukukuRmtPeerClass NetsukukuRmtPeerClass;
typedef struct _NetsukukuRmtPeerPrivate NetsukukuRmtPeerPrivate;

#define NETSUKUKU_TYPE_PEER_TO_PEER (netsukuku_peer_to_peer_get_type ())
#define NETSUKUKU_PEER_TO_PEER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), NETSUKUKU_TYPE_PEER_TO_PEER, NetsukukuPeerToPeer))
#define NETSUKUKU_PEER_TO_PEER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), NETSUKUKU_TYPE_PEER_TO_PEER, NetsukukuPeerToPeerClass))
#define NETSUKUKU_IS_PEER_TO_PEER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), NETSUKUKU_TYPE_PEER_TO_PEER))
#define NETSUKUKU_IS_PEER_TO_PEER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), NETSUKUKU_TYPE_PEER_TO_PEER))
#define NETSUKUKU_PEER_TO_PEER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), NETSUKUKU_TYPE_PEER_TO_PEER, NetsukukuPeerToPeerClass))

typedef struct _NetsukukuPeerToPeer NetsukukuPeerToPeer;
typedef struct _NetsukukuPeerToPeerClass NetsukukuPeerToPeerClass;

#define NETSUKUKU_TYPE_OPTIONAL_PEER_TO_PEER (netsukuku_optional_peer_to_peer_get_type ())
#define NETSUKUKU_OPTIONAL_PEER_TO_PEER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), NETSUKUKU_TYPE_OPTIONAL_PEER_TO_PEER, NetsukukuOptionalPeerToPeer))
#define NETSUKUKU_OPTIONAL_PEER_TO_PEER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), NETSUKUKU_TYPE_OPTIONAL_PEER_TO_PEER, NetsukukuOptionalPeerToPeerClass))
#define NETSUKUKU_IS_OPTIONAL_PEER_TO_PEER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), NETSUKUKU_TYPE_OPTIONAL_PEER_TO_PEER))
#define NETSUKUKU_IS_OPTIONAL_PEER_TO_PEER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), NETSUKUKU_TYPE_OPTIONAL_PEER_TO_PEER))
#define NETSUKUKU_OPTIONAL_PEER_TO_PEER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), NETSUKUKU_TYPE_OPTIONAL_PEER_TO_PEER, NetsukukuOptionalPeerToPeerClass))

typedef struct _NetsukukuOptionalPeerToPeer NetsukukuOptionalPeerToPeer;
typedef struct _NetsukukuOptionalPeerToPeerClass NetsukukuOptionalPeerToPeerClass;

#define NETSUKUKU_TYPE_DISTRIBUTED_HASH_TABLE (netsukuku_distributed_hash_table_get_type ())
#define NETSUKUKU_DISTRIBUTED_HASH_TABLE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), NETSUKUKU_TYPE_DISTRIBUTED_HASH_TABLE, NetsukukuDistributedHashTable))
#define NETSUKUKU_DISTRIBUTED_HASH_TABLE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), NETSUKUKU_TYPE_DISTRIBUTED_HASH_TABLE, NetsukukuDistributedHashTableClass))
#define NETSUKUKU_IS_DISTRIBUTED_HASH_TABLE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), NETSUKUKU_TYPE_DISTRIBUTED_HASH_TABLE))
#define NETSUKUKU_IS_DISTRIBUTED_HASH_TABLE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), NETSUKUKU_TYPE_DISTRIBUTED_HASH_TABLE))
#define NETSUKUKU_DISTRIBUTED_HASH_TABLE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), NETSUKUKU_TYPE_DISTRIBUTED_HASH_TABLE, NetsukukuDistributedHashTableClass))

typedef struct _NetsukukuDistributedHashTable NetsukukuDistributedHashTable;
typedef struct _NetsukukuDistributedHashTableClass NetsukukuDistributedHashTableClass;

#define NETSUKUKU_TYPE_AGGREGATED_NEIGHBOUR (netsukuku_aggregated_neighbour_get_type ())
#define NETSUKUKU_AGGREGATED_NEIGHBOUR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), NETSUKUKU_TYPE_AGGREGATED_NEIGHBOUR, NetsukukuAggregatedNeighbour))
#define NETSUKUKU_AGGREGATED_NEIGHBOUR_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), NETSUKUKU_TYPE_AGGREGATED_NEIGHBOUR, NetsukukuAggregatedNeighbourClass))
#define NETSUKUKU_IS_AGGREGATED_NEIGHBOUR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), NETSUKUKU_TYPE_AGGREGATED_NEIGHBOUR))
#define NETSUKUKU_IS_AGGREGATED_NEIGHBOUR_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), NETSUKUKU_TYPE_AGGREGATED_NEIGHBOUR))
#define NETSUKUKU_AGGREGATED_NEIGHBOUR_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), NETSUKUKU_TYPE_AGGREGATED_NEIGHBOUR, NetsukukuAggregatedNeighbourClass))

typedef struct _NetsukukuAggregatedNeighbour NetsukukuAggregatedNeighbour;
typedef struct _NetsukukuAggregatedNeighbourClass NetsukukuAggregatedNeighbourClass;
typedef struct _NetsukukuPeerToPeerPrivate NetsukukuPeerToPeerPrivate;

#define NETSUKUKU_TYPE_MAP_ROUTE (netsukuku_map_route_get_type ())
#define NETSUKUKU_MAP_ROUTE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), NETSUKUKU_TYPE_MAP_ROUTE, NetsukukuMapRoute))
#define NETSUKUKU_MAP_ROUTE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), NETSUKUKU_TYPE_MAP_ROUTE, NetsukukuMapRouteClass))
#define NETSUKUKU_IS_MAP_ROUTE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), NETSUKUKU_TYPE_MAP_ROUTE))
#define NETSUKUKU_IS_MAP_ROUTE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), NETSUKUKU_TYPE_MAP_ROUTE))
#define NETSUKUKU_MAP_ROUTE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), NETSUKUKU_TYPE_MAP_ROUTE, NetsukukuMapRouteClass))

typedef struct _NetsukukuMapRoute NetsukukuMapRoute;
typedef struct _NetsukukuMapRouteClass NetsukukuMapRouteClass;
typedef struct _NetsukukuMapRoutePrivate NetsukukuMapRoutePrivate;

#define NETSUKUKU_TYPE_PEER_TO_PEER_ALL (netsukuku_peer_to_peer_all_get_type ())
#define NETSUKUKU_PEER_TO_PEER_ALL(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), NETSUKUKU_TYPE_PEER_TO_PEER_ALL, NetsukukuPeerToPeerAll))
#define NETSUKUKU_PEER_TO_PEER_ALL_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), NETSUKUKU_TYPE_PEER_TO_PEER_ALL, NetsukukuPeerToPeerAllClass))
#define NETSUKUKU_IS_PEER_TO_PEER_ALL(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), NETSUKUKU_TYPE_PEER_TO_PEER_ALL))
#define NETSUKUKU_IS_PEER_TO_PEER_ALL_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), NETSUKUKU_TYPE_PEER_TO_PEER_ALL))
#define NETSUKUKU_PEER_TO_PEER_ALL_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), NETSUKUKU_TYPE_PEER_TO_PEER_ALL, NetsukukuPeerToPeerAllClass))

typedef struct _NetsukukuPeerToPeerAll NetsukukuPeerToPeerAll;
typedef struct _NetsukukuPeerToPeerAllClass NetsukukuPeerToPeerAllClass;
typedef struct _NetsukukuPeerToPeerAllPrivate NetsukukuPeerToPeerAllPrivate;

#define NETSUKUKU_TYPE_AGGREGATED_NEIGHBOUR_MANAGER (netsukuku_aggregated_neighbour_manager_get_type ())
#define NETSUKUKU_AGGREGATED_NEIGHBOUR_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), NETSUKUKU_TYPE_AGGREGATED_NEIGHBOUR_MANAGER, NetsukukuAggregatedNeighbourManager))
#define NETSUKUKU_AGGREGATED_NEIGHBOUR_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), NETSUKUKU_TYPE_AGGREGATED_NEIGHBOUR_MANAGER, NetsukukuAggregatedNeighbourManagerClass))
#define NETSUKUKU_IS_AGGREGATED_NEIGHBOUR_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), NETSUKUKU_TYPE_AGGREGATED_NEIGHBOUR_MANAGER))
#define NETSUKUKU_IS_AGGREGATED_NEIGHBOUR_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), NETSUKUKU_TYPE_AGGREGATED_NEIGHBOUR_MANAGER))
#define NETSUKUKU_AGGREGATED_NEIGHBOUR_MANAGER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), NETSUKUKU_TYPE_AGGREGATED_NEIGHBOUR_MANAGER, NetsukukuAggregatedNeighbourManagerClass))

typedef struct _NetsukukuAggregatedNeighbourManager NetsukukuAggregatedNeighbourManager;
typedef struct _NetsukukuAggregatedNeighbourManagerClass NetsukukuAggregatedNeighbourManagerClass;
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
typedef struct _NetsukukuOptionalPeerToPeerPrivate NetsukukuOptionalPeerToPeerPrivate;
typedef struct _NetsukukuAggregatedNeighbourManagerPrivate NetsukukuAggregatedNeighbourManagerPrivate;
typedef struct _NetsukukuAggregatedNeighbourPrivate NetsukukuAggregatedNeighbourPrivate;

#define NTK_TEST_TYPE_DHT_TESTER (ntk_test_dht_tester_get_type ())
#define NTK_TEST_DHT_TESTER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), NTK_TEST_TYPE_DHT_TESTER, NtkTestDhtTester))
#define NTK_TEST_DHT_TESTER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), NTK_TEST_TYPE_DHT_TESTER, NtkTestDhtTesterClass))
#define NTK_TEST_IS_DHT_TESTER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), NTK_TEST_TYPE_DHT_TESTER))
#define NTK_TEST_IS_DHT_TESTER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), NTK_TEST_TYPE_DHT_TESTER))
#define NTK_TEST_DHT_TESTER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), NTK_TEST_TYPE_DHT_TESTER, NtkTestDhtTesterClass))

typedef struct _NtkTestDhtTester NtkTestDhtTester;
typedef struct _NtkTestDhtTesterClass NtkTestDhtTesterClass;
typedef struct _NtkTestDhtTesterPrivate NtkTestDhtTesterPrivate;

#define NETSUKUKU_TYPE_RMT_DISTRIBUTED_HASH_TABLE_PEER (netsukuku_rmt_distributed_hash_table_peer_get_type ())
#define NETSUKUKU_RMT_DISTRIBUTED_HASH_TABLE_PEER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), NETSUKUKU_TYPE_RMT_DISTRIBUTED_HASH_TABLE_PEER, NetsukukuRmtDistributedHashTablePeer))
#define NETSUKUKU_RMT_DISTRIBUTED_HASH_TABLE_PEER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), NETSUKUKU_TYPE_RMT_DISTRIBUTED_HASH_TABLE_PEER, NetsukukuRmtDistributedHashTablePeerClass))
#define NETSUKUKU_IS_RMT_DISTRIBUTED_HASH_TABLE_PEER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), NETSUKUKU_TYPE_RMT_DISTRIBUTED_HASH_TABLE_PEER))
#define NETSUKUKU_IS_RMT_DISTRIBUTED_HASH_TABLE_PEER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), NETSUKUKU_TYPE_RMT_DISTRIBUTED_HASH_TABLE_PEER))
#define NETSUKUKU_RMT_DISTRIBUTED_HASH_TABLE_PEER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), NETSUKUKU_TYPE_RMT_DISTRIBUTED_HASH_TABLE_PEER, NetsukukuRmtDistributedHashTablePeerClass))

typedef struct _NetsukukuRmtDistributedHashTablePeer NetsukukuRmtDistributedHashTablePeer;
typedef struct _NetsukukuRmtDistributedHashTablePeerClass NetsukukuRmtDistributedHashTablePeerClass;

#define NETSUKUKU_TYPE_IDISTRIBUTED_HASH_TABLE (netsukuku_idistributed_hash_table_get_type ())
#define NETSUKUKU_IDISTRIBUTED_HASH_TABLE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), NETSUKUKU_TYPE_IDISTRIBUTED_HASH_TABLE, NetsukukuIDistributedHashTable))
#define NETSUKUKU_IS_IDISTRIBUTED_HASH_TABLE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), NETSUKUKU_TYPE_IDISTRIBUTED_HASH_TABLE))
#define NETSUKUKU_IDISTRIBUTED_HASH_TABLE_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), NETSUKUKU_TYPE_IDISTRIBUTED_HASH_TABLE, NetsukukuIDistributedHashTableIface))

typedef struct _NetsukukuIDistributedHashTable NetsukukuIDistributedHashTable;
typedef struct _NetsukukuIDistributedHashTableIface NetsukukuIDistributedHashTableIface;
#define _vala_assert(expr, msg) if G_LIKELY (expr) ; else g_assertion_message_expr (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);

typedef enum  {
	NETSUKUKU_PEER_TO_PEER_ERROR_REGISTER,
	NETSUKUKU_PEER_TO_PEER_ERROR_GENERIC
} NetsukukuPeerToPeerError;
#define NETSUKUKU_PEER_TO_PEER_ERROR netsukuku_peer_to_peer_error_quark ()
struct _NetsukukuRmtPeer {
	GObject parent_instance;
	NetsukukuRmtPeerPrivate * priv;
};

struct _NetsukukuRmtPeerClass {
	GObjectClass parent_class;
	zcdISerializable* (*rmt) (NetsukukuRmtPeer* self, zcdRemoteCall* data, GError** error);
};

struct _NetsukukuRmtPeerPrivate {
	NetsukukuDistributedHashTable* realdest;
};

struct _NetsukukuPeerToPeer {
	GObject parent_instance;
	NetsukukuPeerToPeerPrivate * priv;
	NetsukukuMapRoute* maproute;
};

struct _NetsukukuPeerToPeerClass {
	GObjectClass parent_class;
	zcdISerializable* (*_dispatch) (NetsukukuPeerToPeer* self, GObject* caller, zcdRemoteCall* data, GError** error);
	NetsukukuNIP* (*h) (NetsukukuPeerToPeer* self, GObject* key);
};

struct _NetsukukuMapRoute {
	GObject parent_instance;
	NetsukukuMapRoutePrivate * priv;
	gint levels;
	gint gsize;
	NetsukukuNIP* me;
};

struct _NetsukukuMapRouteClass {
	GObjectClass parent_class;
};

struct _NetsukukuPeerToPeerAll {
	GObject parent_instance;
	NetsukukuPeerToPeerAllPrivate * priv;
};

struct _NetsukukuPeerToPeerAllClass {
	GObjectClass parent_class;
	void (*peer_to_peer_register) (NetsukukuPeerToPeerAll* self, NetsukukuPeerToPeer* peer_to_peer, GError** error);
};

struct _NetsukukuOptionalPeerToPeer {
	NetsukukuPeerToPeer parent_instance;
	NetsukukuOptionalPeerToPeerPrivate * priv;
	gboolean will_participate;
	gboolean hooked;
};

struct _NetsukukuOptionalPeerToPeerClass {
	NetsukukuPeerToPeerClass parent_class;
};

struct _NetsukukuAggregatedNeighbourManager {
	GObject parent_instance;
	NetsukukuAggregatedNeighbourManagerPrivate * priv;
};

struct _NetsukukuAggregatedNeighbourManagerClass {
	GObjectClass parent_class;
};

struct _NetsukukuAggregatedNeighbour {
	GObject parent_instance;
	NetsukukuAggregatedNeighbourPrivate * priv;
};

struct _NetsukukuAggregatedNeighbourClass {
	GObjectClass parent_class;
};

struct _NtkTestDhtTester {
	GObject parent_instance;
	NtkTestDhtTesterPrivate * priv;
};

struct _NtkTestDhtTesterClass {
	GObjectClass parent_class;
};

struct _NetsukukuIDistributedHashTableIface {
	GTypeInterface parent_iface;
	void (*store) (NetsukukuIDistributedHashTable* self, NetsukukuDHTRecord* rec, gboolean replicate, GError** error);
	NetsukukuDHTRecord* (*retrieve) (NetsukukuIDistributedHashTable* self, NetsukukuDHTKey* key, GError** error);
	GeeList* (*get_cache) (NetsukukuIDistributedHashTable* self, GError** error);
};


static gpointer netsukuku_rmt_peer_parent_class = NULL;
static gpointer netsukuku_peer_to_peer_all_parent_class = NULL;
static gpointer netsukuku_peer_to_peer_parent_class = NULL;
extern GeeHashMap* ntk_test_nodes;
static gpointer netsukuku_optional_peer_to_peer_parent_class = NULL;
static gpointer netsukuku_aggregated_neighbour_manager_parent_class = NULL;
static gpointer netsukuku_aggregated_neighbour_parent_class = NULL;
static gpointer netsukuku_map_route_parent_class = NULL;
extern gchar* ntk_test_logger;
gchar* ntk_test_logger = NULL;
GeeHashMap* ntk_test_nodes = NULL;
static gpointer ntk_test_dht_tester_parent_class = NULL;

gchar* netsukuku_tasklet_id (void);
void netsukuku_log_debug (const gchar* msg);
void ntk_test_print_out (const gchar* s);
void netsukuku_log_info (const gchar* msg);
void netsukuku_log_notice (const gchar* msg);
void netsukuku_log_warn (const gchar* msg);
void netsukuku_log_error (const gchar* msg);
void netsukuku_log_critical (const gchar* msg);
GQuark netsukuku_peer_to_peer_error_quark (void);
GType netsukuku_rmt_peer_get_type (void) G_GNUC_CONST;
GType netsukuku_peer_to_peer_get_type (void) G_GNUC_CONST;
GType netsukuku_optional_peer_to_peer_get_type (void) G_GNUC_CONST;
GType netsukuku_distributed_hash_table_get_type (void) G_GNUC_CONST;
#define NETSUKUKU_RMT_PEER_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), NETSUKUKU_TYPE_RMT_PEER, NetsukukuRmtPeerPrivate))
enum  {
	NETSUKUKU_RMT_PEER_DUMMY_PROPERTY
};
GType netsukuku_aggregated_neighbour_get_type (void) G_GNUC_CONST;
NetsukukuRmtPeer* netsukuku_rmt_peer_new (NetsukukuPeerToPeer* peer_to_peer_service, GObject* key, NetsukukuNIP* hIP, NetsukukuAggregatedNeighbour* aggregated_neighbour);
NetsukukuRmtPeer* netsukuku_rmt_peer_construct (GType object_type, NetsukukuPeerToPeer* peer_to_peer_service, GObject* key, NetsukukuNIP* hIP, NetsukukuAggregatedNeighbour* aggregated_neighbour);
GType netsukuku_map_route_get_type (void) G_GNUC_CONST;
NetsukukuNIP* netsukuku_peer_to_peer_h (NetsukukuPeerToPeer* self, GObject* key);
NetsukukuDistributedHashTable* ntk_test_best_approximation (gint levels, gint gsize, NetsukukuNIP* hIP, gint sign);
zcdISerializable* netsukuku_rmt_peer_rmt (NetsukukuRmtPeer* self, zcdRemoteCall* data, GError** error);
static zcdISerializable* netsukuku_rmt_peer_real_rmt (NetsukukuRmtPeer* self, zcdRemoteCall* data, GError** error);
zcdISerializable* _netsukuku_peer_to_peer_dispatch (NetsukukuPeerToPeer* self, GObject* caller, zcdRemoteCall* data, GError** error);
static void netsukuku_rmt_peer_finalize (GObject* obj);
GType netsukuku_peer_to_peer_all_get_type (void) G_GNUC_CONST;
enum  {
	NETSUKUKU_PEER_TO_PEER_ALL_DUMMY_PROPERTY
};
void netsukuku_peer_to_peer_all_peer_to_peer_register (NetsukukuPeerToPeerAll* self, NetsukukuPeerToPeer* peer_to_peer, GError** error);
static void netsukuku_peer_to_peer_all_real_peer_to_peer_register (NetsukukuPeerToPeerAll* self, NetsukukuPeerToPeer* peer_to_peer, GError** error);
NetsukukuPeerToPeerAll* netsukuku_peer_to_peer_all_new (void);
NetsukukuPeerToPeerAll* netsukuku_peer_to_peer_all_construct (GType object_type);
enum  {
	NETSUKUKU_PEER_TO_PEER_DUMMY_PROPERTY
};
GType netsukuku_aggregated_neighbour_manager_get_type (void) G_GNUC_CONST;
NetsukukuPeerToPeer* netsukuku_peer_to_peer_new (NetsukukuAggregatedNeighbourManager* aggregated_neighbour_manager, NetsukukuMapRoute* maproute, gint pid);
NetsukukuPeerToPeer* netsukuku_peer_to_peer_construct (GType object_type, NetsukukuAggregatedNeighbourManager* aggregated_neighbour_manager, NetsukukuMapRoute* maproute, gint pid);
static zcdISerializable* netsukuku_peer_to_peer_real__dispatch (NetsukukuPeerToPeer* self, GObject* caller, zcdRemoteCall* data, GError** error);
static NetsukukuNIP* netsukuku_peer_to_peer_real_h (NetsukukuPeerToPeer* self, GObject* key);
GeeList* netsukuku_peer_to_peer_list_ids (NetsukukuPeerToPeer* self, gint center, gint sign);
GeeArrayList* ntk_test_list_positions (gint startpos, gint sign, gint gsize);
void netsukuku_peer_to_peer_find_hook_peers (NetsukukuPeerToPeer* self, gint** ret_first_forward, gint** ret_first_back, gint** ret_last_back, gint lvl, gint num_dupl, gint timeout);
gint netsukuku_peer_to_peer_get_number_of_participants (NetsukukuPeerToPeer* self, gint lvl, gint pos, gint timeout);
static gint* _int_dup (gint* self);
GeeList* netsukuku_peer_to_peer_find_nearest_to_register (NetsukukuPeerToPeer* self, NetsukukuNIP* hash_nip, gint num_dupl);
static gboolean _netsukuku_partial_nip_equal_func_gee_equal_data_func (gconstpointer a, gconstpointer b, gpointer self);
GeeArrayList* ntk_test_ordered_lookup (gint levels, gint gsize, NetsukukuNIP* hIP, gint sign);
NetsukukuHCoord* netsukuku_peer_to_peer_search_participant (NetsukukuPeerToPeer* self, NetsukukuNIP* hIP, gint path_sign, GError** error);
NetsukukuNIP* ntk_test_best_approximation_nip (gint levels, gint gsize, NetsukukuNIP* hIP, gint sign);
static void netsukuku_peer_to_peer_finalize (GObject* obj);
enum  {
	NETSUKUKU_OPTIONAL_PEER_TO_PEER_DUMMY_PROPERTY
};
NetsukukuOptionalPeerToPeer* netsukuku_optional_peer_to_peer_new (NetsukukuAggregatedNeighbourManager* aggregated_neighbour_manager, NetsukukuMapRoute* maproute, gint pid);
NetsukukuOptionalPeerToPeer* netsukuku_optional_peer_to_peer_construct (GType object_type, NetsukukuAggregatedNeighbourManager* aggregated_neighbour_manager, NetsukukuMapRoute* maproute, gint pid);
void netsukuku_optional_peer_to_peer_participate (NetsukukuOptionalPeerToPeer* self);
static void netsukuku_optional_peer_to_peer_finalize (GObject* obj);
enum  {
	NETSUKUKU_AGGREGATED_NEIGHBOUR_MANAGER_DUMMY_PROPERTY
};
NetsukukuAggregatedNeighbourManager* netsukuku_aggregated_neighbour_manager_new (void);
NetsukukuAggregatedNeighbourManager* netsukuku_aggregated_neighbour_manager_construct (GType object_type);
enum  {
	NETSUKUKU_AGGREGATED_NEIGHBOUR_DUMMY_PROPERTY
};
NetsukukuAggregatedNeighbour* netsukuku_aggregated_neighbour_new (void);
NetsukukuAggregatedNeighbour* netsukuku_aggregated_neighbour_construct (GType object_type);
enum  {
	NETSUKUKU_MAP_ROUTE_DUMMY_PROPERTY
};
NetsukukuMapRoute* netsukuku_map_route_new (gint l, gint s, NetsukukuNIP* n);
NetsukukuMapRoute* netsukuku_map_route_construct (GType object_type, gint l, gint s, NetsukukuNIP* n);
static void netsukuku_map_route_finalize (GObject* obj);
#define NTK_TEST_output FALSE
GType ntk_test_dht_tester_get_type (void) G_GNUC_CONST;
enum  {
	NTK_TEST_DHT_TESTER_DUMMY_PROPERTY
};
void ntk_test_dht_tester_set_up (NtkTestDhtTester* self);
void ntk_test_dht_tester_tear_down (NtkTestDhtTester* self);
void ntk_test_dht_tester_test_hook_and_replica (NtkTestDhtTester* self);
static guint _netsukuku_partial_nip_hash_func_gee_hash_data_func (gconstpointer v, gpointer self);
static void _vala_array_add1 (NetsukukuNIP*** array, int* length, int* size, NetsukukuNIP* value);
static void _vala_array_add2 (NetsukukuMapRoute*** array, int* length, int* size, NetsukukuMapRoute* value);
NetsukukuDistributedHashTable* netsukuku_distributed_hash_table_new (NetsukukuAggregatedNeighbourManager* aggregated_neighbour_manager, NetsukukuMapRoute* maproute, NetsukukuPeerToPeerAll* peer_to_peer_all);
NetsukukuDistributedHashTable* netsukuku_distributed_hash_table_construct (GType object_type, NetsukukuAggregatedNeighbourManager* aggregated_neighbour_manager, NetsukukuMapRoute* maproute, NetsukukuPeerToPeerAll* peer_to_peer_all);
GType netsukuku_rmt_distributed_hash_table_peer_get_type (void) G_GNUC_CONST;
NetsukukuRmtDistributedHashTablePeer* netsukuku_distributed_hash_table_peer (NetsukukuDistributedHashTable* self, NetsukukuNIP* hIP, GObject* key, NetsukukuAggregatedNeighbour* aggregated_neighbour);
GType netsukuku_idistributed_hash_table_get_type (void) G_GNUC_CONST;
void netsukuku_idistributed_hash_table_store (NetsukukuIDistributedHashTable* self, NetsukukuDHTRecord* rec, gboolean replicate, GError** error);
NetsukukuDHTRecord* netsukuku_idistributed_hash_table_retrieve (NetsukukuIDistributedHashTable* self, NetsukukuDHTKey* key, GError** error);
GeeHashMap* netsukuku_distributed_hash_table_get_cache (NetsukukuDistributedHashTable* self);
#define NETSUKUKU_DHT_DUPLICATION 10
void ntk_test_dht_tester_test_impl_hook_to_service (NtkTestDhtTester* self);
void ntk_test_dht_tester_test_hash (NtkTestDhtTester* self);
void ntk_test_dht_tester_test_hash_equal_func (NtkTestDhtTester* self);
static guint _netsukuku_dht_key_hash_func_gee_hash_data_func (gconstpointer v, gpointer self);
static gboolean _netsukuku_dht_key_equal_func_gee_equal_data_func (gconstpointer a, gconstpointer b, gpointer self);
gint ntk_test_dht_tester_main (gchar** args, int args_length1);
static void __lambda8_ (void);
NtkTestDhtTester* ntk_test_dht_tester_new (void);
NtkTestDhtTester* ntk_test_dht_tester_construct (GType object_type);
static void ___lambda8__gcallback (void);
static void __lambda9_ (void);
static void ___lambda9__gcallback (void);
static void __lambda10_ (void);
static void ___lambda10__gcallback (void);
static void __lambda11_ (void);
static void ___lambda11__gcallback (void);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);


gchar* netsukuku_tasklet_id (void) {
	gchar* result = NULL;
	TaskletsTasklet* _tmp0_ = NULL;
	TaskletsTasklet* _tmp1_;
	gint _tmp2_;
	gint _tmp3_;
	gchar* _tmp4_ = NULL;
	gchar* _tmp5_;
	gchar* _tmp6_ = NULL;
	gchar* _tmp7_;
	_tmp0_ = tasklets_tasklet_self ();
	_tmp1_ = _tmp0_;
	_tmp2_ = tasklets_tasklet_get_id (_tmp1_);
	_tmp3_ = _tmp2_;
	_tmp4_ = g_strdup_printf ("%i", _tmp3_);
	_tmp5_ = _tmp4_;
	_tmp6_ = g_strconcat ("[", _tmp5_, "] ", NULL);
	_tmp7_ = _tmp6_;
	_g_free0 (_tmp5_);
	_g_object_unref0 (_tmp1_);
	result = _tmp7_;
	return result;
}


void netsukuku_log_debug (const gchar* msg) {
	gchar* _tmp0_ = NULL;
	gchar* _tmp1_;
	const gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	gchar* _tmp5_;
	gchar* _tmp6_;
	g_return_if_fail (msg != NULL);
	_tmp0_ = netsukuku_tasklet_id ();
	_tmp1_ = _tmp0_;
	_tmp2_ = msg;
	_tmp3_ = g_strconcat (_tmp1_, _tmp2_, NULL);
	_tmp4_ = _tmp3_;
	_tmp5_ = g_strconcat (_tmp4_, "\n", NULL);
	_tmp6_ = _tmp5_;
	ntk_test_print_out (_tmp6_);
	_g_free0 (_tmp6_);
	_g_free0 (_tmp4_);
	_g_free0 (_tmp1_);
}


void netsukuku_log_info (const gchar* msg) {
	gchar* _tmp0_ = NULL;
	gchar* _tmp1_;
	const gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	gchar* _tmp5_;
	gchar* _tmp6_;
	g_return_if_fail (msg != NULL);
	_tmp0_ = netsukuku_tasklet_id ();
	_tmp1_ = _tmp0_;
	_tmp2_ = msg;
	_tmp3_ = g_strconcat (_tmp1_, _tmp2_, NULL);
	_tmp4_ = _tmp3_;
	_tmp5_ = g_strconcat (_tmp4_, "\n", NULL);
	_tmp6_ = _tmp5_;
	ntk_test_print_out (_tmp6_);
	_g_free0 (_tmp6_);
	_g_free0 (_tmp4_);
	_g_free0 (_tmp1_);
}


void netsukuku_log_notice (const gchar* msg) {
	gchar* _tmp0_ = NULL;
	gchar* _tmp1_;
	const gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	gchar* _tmp5_;
	gchar* _tmp6_;
	g_return_if_fail (msg != NULL);
	_tmp0_ = netsukuku_tasklet_id ();
	_tmp1_ = _tmp0_;
	_tmp2_ = msg;
	_tmp3_ = g_strconcat (_tmp1_, _tmp2_, NULL);
	_tmp4_ = _tmp3_;
	_tmp5_ = g_strconcat (_tmp4_, "\n", NULL);
	_tmp6_ = _tmp5_;
	ntk_test_print_out (_tmp6_);
	_g_free0 (_tmp6_);
	_g_free0 (_tmp4_);
	_g_free0 (_tmp1_);
}


void netsukuku_log_warn (const gchar* msg) {
	gchar* _tmp0_ = NULL;
	gchar* _tmp1_;
	const gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	gchar* _tmp5_;
	gchar* _tmp6_;
	g_return_if_fail (msg != NULL);
	_tmp0_ = netsukuku_tasklet_id ();
	_tmp1_ = _tmp0_;
	_tmp2_ = msg;
	_tmp3_ = g_strconcat (_tmp1_, _tmp2_, NULL);
	_tmp4_ = _tmp3_;
	_tmp5_ = g_strconcat (_tmp4_, "\n", NULL);
	_tmp6_ = _tmp5_;
	ntk_test_print_out (_tmp6_);
	_g_free0 (_tmp6_);
	_g_free0 (_tmp4_);
	_g_free0 (_tmp1_);
}


void netsukuku_log_error (const gchar* msg) {
	gchar* _tmp0_ = NULL;
	gchar* _tmp1_;
	const gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	gchar* _tmp5_;
	gchar* _tmp6_;
	g_return_if_fail (msg != NULL);
	_tmp0_ = netsukuku_tasklet_id ();
	_tmp1_ = _tmp0_;
	_tmp2_ = msg;
	_tmp3_ = g_strconcat (_tmp1_, _tmp2_, NULL);
	_tmp4_ = _tmp3_;
	_tmp5_ = g_strconcat (_tmp4_, "\n", NULL);
	_tmp6_ = _tmp5_;
	ntk_test_print_out (_tmp6_);
	_g_free0 (_tmp6_);
	_g_free0 (_tmp4_);
	_g_free0 (_tmp1_);
}


void netsukuku_log_critical (const gchar* msg) {
	gchar* _tmp0_ = NULL;
	gchar* _tmp1_;
	const gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	gchar* _tmp5_;
	gchar* _tmp6_;
	g_return_if_fail (msg != NULL);
	_tmp0_ = netsukuku_tasklet_id ();
	_tmp1_ = _tmp0_;
	_tmp2_ = msg;
	_tmp3_ = g_strconcat (_tmp1_, _tmp2_, NULL);
	_tmp4_ = _tmp3_;
	_tmp5_ = g_strconcat (_tmp4_, "\n", NULL);
	_tmp6_ = _tmp5_;
	ntk_test_print_out (_tmp6_);
	_g_free0 (_tmp6_);
	_g_free0 (_tmp4_);
	_g_free0 (_tmp1_);
}


GQuark netsukuku_peer_to_peer_error_quark (void) {
	return g_quark_from_static_string ("netsukuku_peer_to_peer_error-quark");
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


NetsukukuRmtPeer* netsukuku_rmt_peer_construct (GType object_type, NetsukukuPeerToPeer* peer_to_peer_service, GObject* key, NetsukukuNIP* hIP, NetsukukuAggregatedNeighbour* aggregated_neighbour) {
	NetsukukuRmtPeer * self = NULL;
	NetsukukuPeerToPeer* _tmp0_;
	NetsukukuMapRoute* _tmp1_;
	NetsukukuMapRoute* _tmp2_;
	NetsukukuMapRoute* mr;
	NetsukukuNIP* dest = NULL;
	NetsukukuNIP* _tmp3_;
	NetsukukuMapRoute* _tmp9_;
	gint _tmp10_;
	NetsukukuMapRoute* _tmp11_;
	gint _tmp12_;
	NetsukukuNIP* _tmp13_;
	NetsukukuDistributedHashTable* _tmp14_ = NULL;
	g_return_val_if_fail (peer_to_peer_service != NULL, NULL);
	self = (NetsukukuRmtPeer*) g_object_new (object_type, NULL);
	_tmp0_ = peer_to_peer_service;
	_tmp1_ = _tmp0_->maproute;
	_tmp2_ = _g_object_ref0 (_tmp1_);
	mr = _tmp2_;
	_tmp3_ = hIP;
	if (_tmp3_ == NULL) {
		NetsukukuPeerToPeer* _tmp4_;
		GObject* _tmp5_;
		NetsukukuNIP* _tmp6_ = NULL;
		_tmp4_ = peer_to_peer_service;
		_tmp5_ = key;
		_tmp6_ = netsukuku_peer_to_peer_h (_tmp4_, _tmp5_);
		_g_object_unref0 (dest);
		dest = _tmp6_;
	} else {
		NetsukukuNIP* _tmp7_;
		NetsukukuNIP* _tmp8_;
		_tmp7_ = hIP;
		_tmp8_ = _g_object_ref0 (_tmp7_);
		_g_object_unref0 (dest);
		dest = _tmp8_;
	}
	_tmp9_ = mr;
	_tmp10_ = _tmp9_->levels;
	_tmp11_ = mr;
	_tmp12_ = _tmp11_->gsize;
	_tmp13_ = dest;
	_tmp14_ = ntk_test_best_approximation (_tmp10_, _tmp12_, _tmp13_, 1);
	_g_object_unref0 (self->priv->realdest);
	self->priv->realdest = _tmp14_;
	_g_object_unref0 (dest);
	_g_object_unref0 (mr);
	return self;
}


NetsukukuRmtPeer* netsukuku_rmt_peer_new (NetsukukuPeerToPeer* peer_to_peer_service, GObject* key, NetsukukuNIP* hIP, NetsukukuAggregatedNeighbour* aggregated_neighbour) {
	return netsukuku_rmt_peer_construct (NETSUKUKU_TYPE_RMT_PEER, peer_to_peer_service, key, hIP, aggregated_neighbour);
}


static zcdISerializable* netsukuku_rmt_peer_real_rmt (NetsukukuRmtPeer* self, zcdRemoteCall* data, GError** error) {
	zcdISerializable* result = NULL;
	zcdRemoteCall* _tmp0_;
	gchar* _tmp1_ = NULL;
	gchar* _tmp2_;
	gchar* _tmp3_ = NULL;
	gchar* _tmp4_;
	NetsukukuDistributedHashTable* _tmp5_;
	NetsukukuMapRoute* _tmp6_;
	NetsukukuNIP* _tmp7_;
	gchar* _tmp8_ = NULL;
	gchar* _tmp9_;
	gchar* _tmp10_ = NULL;
	gchar* _tmp11_;
	NetsukukuDistributedHashTable* _tmp12_;
	zcdRemoteCall* _tmp13_;
	zcdISerializable* _tmp14_ = NULL;
	zcdISerializable* _tmp15_;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (data != NULL, NULL);
	_tmp0_ = data;
	_tmp1_ = zcd_remote_call_to_string (_tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = g_strconcat ("RmtPeer.rmt(data ", _tmp2_, ")\n", NULL);
	_tmp4_ = _tmp3_;
	ntk_test_print_out (_tmp4_);
	_g_free0 (_tmp4_);
	_g_free0 (_tmp2_);
	_tmp5_ = self->priv->realdest;
	_tmp6_ = ((NetsukukuPeerToPeer*) _tmp5_)->maproute;
	_tmp7_ = _tmp6_->me;
	_tmp8_ = netsukuku_partial_nip_to_string ((NetsukukuPartialNIP*) _tmp7_);
	_tmp9_ = _tmp8_;
	_tmp10_ = g_strconcat ("sent to ", _tmp9_, "\n", NULL);
	_tmp11_ = _tmp10_;
	ntk_test_print_out (_tmp11_);
	_g_free0 (_tmp11_);
	_g_free0 (_tmp9_);
	_tmp12_ = self->priv->realdest;
	_tmp13_ = data;
	_tmp14_ = _netsukuku_peer_to_peer_dispatch ((NetsukukuPeerToPeer*) _tmp12_, NULL, _tmp13_, &_inner_error_);
	_tmp15_ = _tmp14_;
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		return NULL;
	}
	result = _tmp15_;
	return result;
}


zcdISerializable* netsukuku_rmt_peer_rmt (NetsukukuRmtPeer* self, zcdRemoteCall* data, GError** error) {
	g_return_val_if_fail (self != NULL, NULL);
	return NETSUKUKU_RMT_PEER_GET_CLASS (self)->rmt (self, data, error);
}


static void netsukuku_rmt_peer_class_init (NetsukukuRmtPeerClass * klass) {
	netsukuku_rmt_peer_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (NetsukukuRmtPeerPrivate));
	NETSUKUKU_RMT_PEER_CLASS (klass)->rmt = netsukuku_rmt_peer_real_rmt;
	G_OBJECT_CLASS (klass)->finalize = netsukuku_rmt_peer_finalize;
}


static void netsukuku_rmt_peer_instance_init (NetsukukuRmtPeer * self) {
	self->priv = NETSUKUKU_RMT_PEER_GET_PRIVATE (self);
}


static void netsukuku_rmt_peer_finalize (GObject* obj) {
	NetsukukuRmtPeer * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, NETSUKUKU_TYPE_RMT_PEER, NetsukukuRmtPeer);
	_g_object_unref0 (self->priv->realdest);
	G_OBJECT_CLASS (netsukuku_rmt_peer_parent_class)->finalize (obj);
}


GType netsukuku_rmt_peer_get_type (void) {
	static volatile gsize netsukuku_rmt_peer_type_id__volatile = 0;
	if (g_once_init_enter (&netsukuku_rmt_peer_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (NetsukukuRmtPeerClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) netsukuku_rmt_peer_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (NetsukukuRmtPeer), 0, (GInstanceInitFunc) netsukuku_rmt_peer_instance_init, NULL };
		GType netsukuku_rmt_peer_type_id;
		netsukuku_rmt_peer_type_id = g_type_register_static (G_TYPE_OBJECT, "NetsukukuRmtPeer", &g_define_type_info, 0);
		g_once_init_leave (&netsukuku_rmt_peer_type_id__volatile, netsukuku_rmt_peer_type_id);
	}
	return netsukuku_rmt_peer_type_id__volatile;
}


static void netsukuku_peer_to_peer_all_real_peer_to_peer_register (NetsukukuPeerToPeerAll* self, NetsukukuPeerToPeer* peer_to_peer, GError** error) {
	g_return_if_fail (peer_to_peer != NULL);
}


void netsukuku_peer_to_peer_all_peer_to_peer_register (NetsukukuPeerToPeerAll* self, NetsukukuPeerToPeer* peer_to_peer, GError** error) {
	g_return_if_fail (self != NULL);
	NETSUKUKU_PEER_TO_PEER_ALL_GET_CLASS (self)->peer_to_peer_register (self, peer_to_peer, error);
}


NetsukukuPeerToPeerAll* netsukuku_peer_to_peer_all_construct (GType object_type) {
	NetsukukuPeerToPeerAll * self = NULL;
	self = (NetsukukuPeerToPeerAll*) g_object_new (object_type, NULL);
	return self;
}


NetsukukuPeerToPeerAll* netsukuku_peer_to_peer_all_new (void) {
	return netsukuku_peer_to_peer_all_construct (NETSUKUKU_TYPE_PEER_TO_PEER_ALL);
}


static void netsukuku_peer_to_peer_all_class_init (NetsukukuPeerToPeerAllClass * klass) {
	netsukuku_peer_to_peer_all_parent_class = g_type_class_peek_parent (klass);
	NETSUKUKU_PEER_TO_PEER_ALL_CLASS (klass)->peer_to_peer_register = netsukuku_peer_to_peer_all_real_peer_to_peer_register;
}


static void netsukuku_peer_to_peer_all_instance_init (NetsukukuPeerToPeerAll * self) {
}


GType netsukuku_peer_to_peer_all_get_type (void) {
	static volatile gsize netsukuku_peer_to_peer_all_type_id__volatile = 0;
	if (g_once_init_enter (&netsukuku_peer_to_peer_all_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (NetsukukuPeerToPeerAllClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) netsukuku_peer_to_peer_all_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (NetsukukuPeerToPeerAll), 0, (GInstanceInitFunc) netsukuku_peer_to_peer_all_instance_init, NULL };
		GType netsukuku_peer_to_peer_all_type_id;
		netsukuku_peer_to_peer_all_type_id = g_type_register_static (G_TYPE_OBJECT, "NetsukukuPeerToPeerAll", &g_define_type_info, 0);
		g_once_init_leave (&netsukuku_peer_to_peer_all_type_id__volatile, netsukuku_peer_to_peer_all_type_id);
	}
	return netsukuku_peer_to_peer_all_type_id__volatile;
}


NetsukukuPeerToPeer* netsukuku_peer_to_peer_construct (GType object_type, NetsukukuAggregatedNeighbourManager* aggregated_neighbour_manager, NetsukukuMapRoute* maproute, gint pid) {
	NetsukukuPeerToPeer * self = NULL;
	NetsukukuMapRoute* _tmp0_;
	g_return_val_if_fail (aggregated_neighbour_manager != NULL, NULL);
	g_return_val_if_fail (maproute != NULL, NULL);
	self = (NetsukukuPeerToPeer*) g_object_new (object_type, NULL);
	_tmp0_ = maproute;
	self->maproute = _tmp0_;
	return self;
}


NetsukukuPeerToPeer* netsukuku_peer_to_peer_new (NetsukukuAggregatedNeighbourManager* aggregated_neighbour_manager, NetsukukuMapRoute* maproute, gint pid) {
	return netsukuku_peer_to_peer_construct (NETSUKUKU_TYPE_PEER_TO_PEER, aggregated_neighbour_manager, maproute, pid);
}


static zcdISerializable* netsukuku_peer_to_peer_real__dispatch (NetsukukuPeerToPeer* self, GObject* caller, zcdRemoteCall* data, GError** error) {
	zcdISerializable* result = NULL;
	g_return_val_if_fail (data != NULL, NULL);
	result = NULL;
	return result;
}


zcdISerializable* _netsukuku_peer_to_peer_dispatch (NetsukukuPeerToPeer* self, GObject* caller, zcdRemoteCall* data, GError** error) {
	g_return_val_if_fail (self != NULL, NULL);
	return NETSUKUKU_PEER_TO_PEER_GET_CLASS (self)->_dispatch (self, caller, data, error);
}


static NetsukukuNIP* netsukuku_peer_to_peer_real_h (NetsukukuPeerToPeer* self, GObject* key) {
	NetsukukuNIP* result = NULL;
	GObject* _tmp0_;
	NetsukukuNIP* _tmp1_;
	g_return_val_if_fail (key != NULL, NULL);
	_tmp0_ = key;
	_tmp1_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, NETSUKUKU_TYPE_NIP, NetsukukuNIP));
	result = _tmp1_;
	return result;
}


NetsukukuNIP* netsukuku_peer_to_peer_h (NetsukukuPeerToPeer* self, GObject* key) {
	g_return_val_if_fail (self != NULL, NULL);
	return NETSUKUKU_PEER_TO_PEER_GET_CLASS (self)->h (self, key);
}


static const gchar* string_to_string (const gchar* self) {
	const gchar* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	result = self;
	return result;
}


GeeList* netsukuku_peer_to_peer_list_ids (NetsukukuPeerToPeer* self, gint center, gint sign) {
	GeeList* result = NULL;
	NetsukukuMapRoute* _tmp0_;
	NetsukukuNIP* _tmp1_;
	gchar* _tmp2_ = NULL;
	gchar* _tmp3_;
	gint _tmp4_;
	gchar* _tmp5_ = NULL;
	gchar* _tmp6_;
	gint _tmp7_;
	gchar* _tmp8_ = NULL;
	gchar* _tmp9_;
	gchar* _tmp10_ = NULL;
	gchar* _tmp11_;
	gint _tmp12_;
	gint _tmp13_;
	NetsukukuMapRoute* _tmp14_;
	gint _tmp15_;
	GeeArrayList* _tmp16_ = NULL;
	GeeArrayList* ret;
	gchar* _tmp17_;
	gchar* strret;
	NetsukukuMapRoute* _tmp36_;
	NetsukukuNIP* _tmp37_;
	gchar* _tmp38_ = NULL;
	gchar* _tmp39_;
	const gchar* _tmp40_;
	const gchar* _tmp41_ = NULL;
	gchar* _tmp42_ = NULL;
	gchar* _tmp43_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->maproute;
	_tmp1_ = _tmp0_->me;
	_tmp2_ = netsukuku_partial_nip_to_string ((NetsukukuPartialNIP*) _tmp1_);
	_tmp3_ = _tmp2_;
	_tmp4_ = center;
	_tmp5_ = g_strdup_printf ("%i", _tmp4_);
	_tmp6_ = _tmp5_;
	_tmp7_ = sign;
	_tmp8_ = g_strdup_printf ("%i", _tmp7_);
	_tmp9_ = _tmp8_;
	_tmp10_ = g_strconcat ("[", _tmp3_, "]: list_ids(center ", _tmp6_, ", sign ", _tmp9_, ")\n", NULL);
	_tmp11_ = _tmp10_;
	ntk_test_print_out (_tmp11_);
	_g_free0 (_tmp11_);
	_g_free0 (_tmp9_);
	_g_free0 (_tmp6_);
	_g_free0 (_tmp3_);
	_tmp12_ = center;
	_tmp13_ = sign;
	_tmp14_ = self->maproute;
	_tmp15_ = _tmp14_->gsize;
	_tmp16_ = ntk_test_list_positions (_tmp12_, _tmp13_, _tmp15_);
	ret = _tmp16_;
	_tmp17_ = g_strdup ("");
	strret = _tmp17_;
	{
		GeeArrayList* _tmp18_;
		GeeArrayList* _tmp19_;
		GeeArrayList* _r_list;
		GeeArrayList* _tmp20_;
		gint _tmp21_;
		gint _tmp22_;
		gint _r_size;
		gint _r_index;
		_tmp18_ = ret;
		_tmp19_ = _g_object_ref0 (_tmp18_);
		_r_list = _tmp19_;
		_tmp20_ = _r_list;
		_tmp21_ = gee_abstract_collection_get_size ((GeeCollection*) _tmp20_);
		_tmp22_ = _tmp21_;
		_r_size = _tmp22_;
		_r_index = -1;
		while (TRUE) {
			gint _tmp23_;
			gint _tmp24_;
			gint _tmp25_;
			GeeArrayList* _tmp26_;
			gint _tmp27_;
			gpointer _tmp28_ = NULL;
			gint r;
			const gchar* _tmp29_;
			gint _tmp30_;
			gchar* _tmp31_ = NULL;
			gchar* _tmp32_;
			gchar* _tmp33_ = NULL;
			gchar* _tmp34_;
			gchar* _tmp35_;
			_tmp23_ = _r_index;
			_r_index = _tmp23_ + 1;
			_tmp24_ = _r_index;
			_tmp25_ = _r_size;
			if (!(_tmp24_ < _tmp25_)) {
				break;
			}
			_tmp26_ = _r_list;
			_tmp27_ = _r_index;
			_tmp28_ = gee_abstract_list_get ((GeeAbstractList*) _tmp26_, _tmp27_);
			r = (gint) ((gintptr) _tmp28_);
			_tmp29_ = strret;
			_tmp30_ = r;
			_tmp31_ = g_strdup_printf ("%i", _tmp30_);
			_tmp32_ = _tmp31_;
			_tmp33_ = g_strconcat (" ", _tmp32_, " ", NULL);
			_tmp34_ = _tmp33_;
			_tmp35_ = g_strconcat (_tmp29_, _tmp34_, NULL);
			_g_free0 (strret);
			strret = _tmp35_;
			_g_free0 (_tmp34_);
			_g_free0 (_tmp32_);
		}
		_g_object_unref0 (_r_list);
	}
	_tmp36_ = self->maproute;
	_tmp37_ = _tmp36_->me;
	_tmp38_ = netsukuku_partial_nip_to_string ((NetsukukuPartialNIP*) _tmp37_);
	_tmp39_ = _tmp38_;
	_tmp40_ = strret;
	_tmp41_ = string_to_string (_tmp40_);
	_tmp42_ = g_strconcat ("[", _tmp39_, "]: list_ids = ", _tmp41_, "\n", NULL);
	_tmp43_ = _tmp42_;
	ntk_test_print_out (_tmp43_);
	_g_free0 (_tmp43_);
	_g_free0 (_tmp39_);
	result = (GeeList*) ret;
	_g_free0 (strret);
	return result;
}


static gint* _int_dup (gint* self) {
	gint* dup;
	dup = g_new0 (gint, 1);
	memcpy (dup, self, sizeof (gint));
	return dup;
}


static gpointer __int_dup0 (gpointer self) {
	return self ? _int_dup (self) : NULL;
}


void netsukuku_peer_to_peer_find_hook_peers (NetsukukuPeerToPeer* self, gint** ret_first_forward, gint** ret_first_back, gint** ret_last_back, gint lvl, gint num_dupl, gint timeout) {
	gint* _vala_ret_first_forward = NULL;
	gint* _vala_ret_first_back = NULL;
	gint* _vala_ret_last_back = NULL;
	NetsukukuMapRoute* _tmp0_;
	NetsukukuNIP* _tmp1_;
	gchar* _tmp2_ = NULL;
	gchar* _tmp3_;
	gint _tmp4_;
	gchar* _tmp5_ = NULL;
	gchar* _tmp6_;
	gint _tmp7_;
	gchar* _tmp8_ = NULL;
	gchar* _tmp9_;
	gchar* _tmp10_ = NULL;
	gchar* _tmp11_;
	NetsukukuMapRoute* _tmp12_;
	NetsukukuNIP* _tmp13_;
	gint _tmp14_;
	gint _tmp15_ = 0;
	GeeList* _tmp16_ = NULL;
	GeeList* ids_me_forward;
	GeeList* _tmp17_;
	gint* _tmp36_;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->maproute;
	_tmp1_ = _tmp0_->me;
	_tmp2_ = netsukuku_partial_nip_to_string ((NetsukukuPartialNIP*) _tmp1_);
	_tmp3_ = _tmp2_;
	_tmp4_ = lvl;
	_tmp5_ = g_strdup_printf ("%i", _tmp4_);
	_tmp6_ = _tmp5_;
	_tmp7_ = num_dupl;
	_tmp8_ = g_strdup_printf ("%i", _tmp7_);
	_tmp9_ = _tmp8_;
	_tmp10_ = g_strconcat ("[", _tmp3_, "]: find_hook_peers(lvl ", _tmp6_, ", num_dupl ", _tmp9_, ")\n", NULL);
	_tmp11_ = _tmp10_;
	ntk_test_print_out (_tmp11_);
	_g_free0 (_tmp11_);
	_g_free0 (_tmp9_);
	_g_free0 (_tmp6_);
	_g_free0 (_tmp3_);
	_g_free0 (_vala_ret_first_forward);
	_vala_ret_first_forward = NULL;
	_g_free0 (_vala_ret_first_back);
	_vala_ret_first_back = NULL;
	_g_free0 (_vala_ret_last_back);
	_vala_ret_last_back = NULL;
	_tmp12_ = self->maproute;
	_tmp13_ = _tmp12_->me;
	_tmp14_ = lvl;
	_tmp15_ = netsukuku_partial_nip_position_at ((NetsukukuPartialNIP*) _tmp13_, _tmp14_);
	_tmp16_ = netsukuku_peer_to_peer_list_ids (self, _tmp15_, 1);
	ids_me_forward = _tmp16_;
	_tmp17_ = ids_me_forward;
	gee_list_remove_at (_tmp17_, 0);
	{
		GeeList* _tmp18_;
		GeeList* _tmp19_;
		GeeList* __id_list;
		GeeList* _tmp20_;
		gint _tmp21_;
		gint _tmp22_;
		gint __id_size;
		gint __id_index;
		_tmp18_ = ids_me_forward;
		_tmp19_ = _g_object_ref0 (_tmp18_);
		__id_list = _tmp19_;
		_tmp20_ = __id_list;
		_tmp21_ = gee_collection_get_size ((GeeCollection*) _tmp20_);
		_tmp22_ = _tmp21_;
		__id_size = _tmp22_;
		__id_index = -1;
		while (TRUE) {
			gint _tmp23_;
			gint _tmp24_;
			gint _tmp25_;
			GeeList* _tmp26_;
			gint _tmp27_;
			gpointer _tmp28_ = NULL;
			gint _id;
			gint num;
			gint _tmp33_;
			_tmp23_ = __id_index;
			__id_index = _tmp23_ + 1;
			_tmp24_ = __id_index;
			_tmp25_ = __id_size;
			if (!(_tmp24_ < _tmp25_)) {
				break;
			}
			_tmp26_ = __id_list;
			_tmp27_ = __id_index;
			_tmp28_ = gee_list_get (_tmp26_, _tmp27_);
			_id = (gint) ((gintptr) _tmp28_);
			num = 0;
			{
				gint _tmp29_;
				gint _tmp30_;
				gint _tmp31_;
				gint _tmp32_ = 0;
				_tmp29_ = lvl;
				_tmp30_ = _id;
				_tmp31_ = timeout;
				_tmp32_ = netsukuku_peer_to_peer_get_number_of_participants (self, _tmp29_, _tmp30_, _tmp31_);
				num = _tmp32_;
			}
			goto __finally0;
			__catch0_zcd_rpc_error:
			{
				GError* e = NULL;
				e = _inner_error_;
				_inner_error_ = NULL;
				_g_error_free0 (e);
			}
			__finally0:
			if (_inner_error_ != NULL) {
				_g_object_unref0 (__id_list);
				_g_object_unref0 (ids_me_forward);
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return;
			}
			_tmp33_ = num;
			if (_tmp33_ > 0) {
				gint _tmp34_;
				gint* _tmp35_;
				_tmp34_ = _id;
				_tmp35_ = __int_dup0 (&_tmp34_);
				_g_free0 (_vala_ret_first_forward);
				_vala_ret_first_forward = _tmp35_;
				break;
			}
		}
		_g_object_unref0 (__id_list);
	}
	_tmp36_ = _vala_ret_first_forward;
	if (_tmp36_ != NULL) {
		NetsukukuMapRoute* _tmp37_;
		NetsukukuNIP* _tmp38_;
		gint _tmp39_;
		gint _tmp40_ = 0;
		GeeList* _tmp41_ = NULL;
		GeeList* ids_me_back;
		GeeList* _tmp42_;
		gint _tmp43_;
		gint remaining;
		gint _tmp70_;
		_tmp37_ = self->maproute;
		_tmp38_ = _tmp37_->me;
		_tmp39_ = lvl;
		_tmp40_ = netsukuku_partial_nip_position_at ((NetsukukuPartialNIP*) _tmp38_, _tmp39_);
		_tmp41_ = netsukuku_peer_to_peer_list_ids (self, _tmp40_, -1);
		ids_me_back = _tmp41_;
		_tmp42_ = ids_me_back;
		gee_list_remove_at (_tmp42_, 0);
		_tmp43_ = num_dupl;
		remaining = _tmp43_;
		{
			GeeList* _tmp44_;
			GeeList* _tmp45_;
			GeeList* __id_list;
			GeeList* _tmp46_;
			gint _tmp47_;
			gint _tmp48_;
			gint __id_size;
			gint __id_index;
			_tmp44_ = ids_me_back;
			_tmp45_ = _g_object_ref0 (_tmp44_);
			__id_list = _tmp45_;
			_tmp46_ = __id_list;
			_tmp47_ = gee_collection_get_size ((GeeCollection*) _tmp46_);
			_tmp48_ = _tmp47_;
			__id_size = _tmp48_;
			__id_index = -1;
			while (TRUE) {
				gint _tmp49_;
				gint _tmp50_;
				gint _tmp51_;
				GeeList* _tmp52_;
				gint _tmp53_;
				gpointer _tmp54_ = NULL;
				gint _id;
				gint num;
				gboolean _tmp59_ = FALSE;
				gint _tmp60_;
				gboolean _tmp62_;
				gint _tmp65_;
				gint _tmp66_;
				gint _tmp67_;
				_tmp49_ = __id_index;
				__id_index = _tmp49_ + 1;
				_tmp50_ = __id_index;
				_tmp51_ = __id_size;
				if (!(_tmp50_ < _tmp51_)) {
					break;
				}
				_tmp52_ = __id_list;
				_tmp53_ = __id_index;
				_tmp54_ = gee_list_get (_tmp52_, _tmp53_);
				_id = (gint) ((gintptr) _tmp54_);
				num = 0;
				{
					gint _tmp55_;
					gint _tmp56_;
					gint _tmp57_;
					gint _tmp58_ = 0;
					_tmp55_ = lvl;
					_tmp56_ = _id;
					_tmp57_ = timeout;
					_tmp58_ = netsukuku_peer_to_peer_get_number_of_participants (self, _tmp55_, _tmp56_, _tmp57_);
					num = _tmp58_;
				}
				goto __finally1;
				__catch1_zcd_rpc_error:
				{
					GError* e = NULL;
					e = _inner_error_;
					_inner_error_ = NULL;
					_g_error_free0 (e);
				}
				__finally1:
				if (_inner_error_ != NULL) {
					_g_object_unref0 (__id_list);
					_g_object_unref0 (ids_me_back);
					_g_object_unref0 (ids_me_forward);
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
					g_clear_error (&_inner_error_);
					return;
				}
				_tmp60_ = num;
				if (_tmp60_ > 0) {
					gint* _tmp61_;
					_tmp61_ = _vala_ret_first_back;
					_tmp59_ = _tmp61_ == NULL;
				} else {
					_tmp59_ = FALSE;
				}
				_tmp62_ = _tmp59_;
				if (_tmp62_) {
					gint _tmp63_;
					gint* _tmp64_;
					_tmp63_ = _id;
					_tmp64_ = __int_dup0 (&_tmp63_);
					_g_free0 (_vala_ret_first_back);
					_vala_ret_first_back = _tmp64_;
				}
				_tmp65_ = remaining;
				_tmp66_ = num;
				remaining = _tmp65_ - _tmp66_;
				_tmp67_ = remaining;
				if (_tmp67_ <= 0) {
					gint _tmp68_;
					gint* _tmp69_;
					_tmp68_ = _id;
					_tmp69_ = __int_dup0 (&_tmp68_);
					_g_free0 (_vala_ret_last_back);
					_vala_ret_last_back = _tmp69_;
					break;
				}
			}
			_g_object_unref0 (__id_list);
		}
		_tmp70_ = remaining;
		if (_tmp70_ > 0) {
			_g_free0 (_vala_ret_first_back);
			_vala_ret_first_back = NULL;
		}
		_g_object_unref0 (ids_me_back);
	}
	_g_object_unref0 (ids_me_forward);
	if (ret_first_forward) {
		*ret_first_forward = _vala_ret_first_forward;
	} else {
		_g_free0 (_vala_ret_first_forward);
	}
	if (ret_first_back) {
		*ret_first_back = _vala_ret_first_back;
	} else {
		_g_free0 (_vala_ret_first_back);
	}
	if (ret_last_back) {
		*ret_last_back = _vala_ret_last_back;
	} else {
		_g_free0 (_vala_ret_last_back);
	}
}


gint netsukuku_peer_to_peer_get_number_of_participants (NetsukukuPeerToPeer* self, gint lvl, gint pos, gint timeout) {
	gint result = 0;
	NetsukukuMapRoute* _tmp0_;
	NetsukukuNIP* _tmp1_;
	gchar* _tmp2_ = NULL;
	gchar* _tmp3_;
	gint _tmp4_;
	gchar* _tmp5_ = NULL;
	gchar* _tmp6_;
	gint _tmp7_;
	gchar* _tmp8_ = NULL;
	gchar* _tmp9_;
	gchar* _tmp10_ = NULL;
	gchar* _tmp11_;
	gint ret;
	NetsukukuMapRoute* _tmp37_;
	NetsukukuNIP* _tmp38_;
	gchar* _tmp39_ = NULL;
	gchar* _tmp40_;
	gint _tmp41_;
	gchar* _tmp42_ = NULL;
	gchar* _tmp43_;
	gchar* _tmp44_ = NULL;
	gchar* _tmp45_;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = self->maproute;
	_tmp1_ = _tmp0_->me;
	_tmp2_ = netsukuku_partial_nip_to_string ((NetsukukuPartialNIP*) _tmp1_);
	_tmp3_ = _tmp2_;
	_tmp4_ = lvl;
	_tmp5_ = g_strdup_printf ("%i", _tmp4_);
	_tmp6_ = _tmp5_;
	_tmp7_ = pos;
	_tmp8_ = g_strdup_printf ("%i", _tmp7_);
	_tmp9_ = _tmp8_;
	_tmp10_ = g_strconcat ("[", _tmp3_, "]: get_number_of_participants(lvl ", _tmp6_, ", pos ", _tmp9_, ")\n", NULL);
	_tmp11_ = _tmp10_;
	ntk_test_print_out (_tmp11_);
	_g_free0 (_tmp11_);
	_g_free0 (_tmp9_);
	_g_free0 (_tmp6_);
	_g_free0 (_tmp3_);
	ret = 0;
	{
		GeeHashMap* _tmp12_;
		GeeSet* _tmp13_;
		GeeSet* _tmp14_;
		GeeSet* _tmp15_;
		GeeIterator* _tmp16_ = NULL;
		GeeIterator* _tmp17_;
		GeeIterator* _n_it;
		_tmp12_ = ntk_test_nodes;
		_tmp13_ = gee_abstract_map_get_keys ((GeeMap*) _tmp12_);
		_tmp14_ = _tmp13_;
		_tmp15_ = _tmp14_;
		_tmp16_ = gee_iterable_iterator ((GeeIterable*) _tmp15_);
		_tmp17_ = _tmp16_;
		_g_object_unref0 (_tmp15_);
		_n_it = _tmp17_;
		while (TRUE) {
			GeeIterator* _tmp18_;
			gboolean _tmp19_ = FALSE;
			GeeIterator* _tmp20_;
			gpointer _tmp21_ = NULL;
			NetsukukuNIP* n;
			NetsukukuNIP* _tmp22_;
			NetsukukuMapRoute* _tmp23_;
			NetsukukuNIP* _tmp24_;
			NetsukukuHCoord* _tmp25_ = NULL;
			NetsukukuHCoord* hcn;
			gboolean _tmp26_ = FALSE;
			NetsukukuHCoord* _tmp27_;
			gint _tmp28_;
			gint _tmp29_;
			gint _tmp30_;
			gboolean _tmp35_;
			_tmp18_ = _n_it;
			_tmp19_ = gee_iterator_next (_tmp18_);
			if (!_tmp19_) {
				break;
			}
			_tmp20_ = _n_it;
			_tmp21_ = gee_iterator_get (_tmp20_);
			n = (NetsukukuNIP*) _tmp21_;
			_tmp22_ = n;
			_tmp23_ = self->maproute;
			_tmp24_ = _tmp23_->me;
			_tmp25_ = netsukuku_partial_nip_get_hcoord_relative_to ((NetsukukuPartialNIP*) _tmp22_, _tmp24_);
			hcn = _tmp25_;
			_tmp27_ = hcn;
			_tmp28_ = netsukuku_hcoord_get_lvl (_tmp27_);
			_tmp29_ = _tmp28_;
			_tmp30_ = lvl;
			if (_tmp29_ == _tmp30_) {
				NetsukukuHCoord* _tmp31_;
				gint _tmp32_;
				gint _tmp33_;
				gint _tmp34_;
				_tmp31_ = hcn;
				_tmp32_ = netsukuku_hcoord_get_pos (_tmp31_);
				_tmp33_ = _tmp32_;
				_tmp34_ = pos;
				_tmp26_ = _tmp33_ == _tmp34_;
			} else {
				_tmp26_ = FALSE;
			}
			_tmp35_ = _tmp26_;
			if (_tmp35_) {
				gint _tmp36_;
				_tmp36_ = ret;
				ret = _tmp36_ + 1;
			}
			_g_object_unref0 (hcn);
			_g_object_unref0 (n);
		}
		_g_object_unref0 (_n_it);
	}
	_tmp37_ = self->maproute;
	_tmp38_ = _tmp37_->me;
	_tmp39_ = netsukuku_partial_nip_to_string ((NetsukukuPartialNIP*) _tmp38_);
	_tmp40_ = _tmp39_;
	_tmp41_ = ret;
	_tmp42_ = g_strdup_printf ("%i", _tmp41_);
	_tmp43_ = _tmp42_;
	_tmp44_ = g_strconcat ("[", _tmp40_, "]:   ", _tmp43_, "\n", NULL);
	_tmp45_ = _tmp44_;
	ntk_test_print_out (_tmp45_);
	_g_free0 (_tmp45_);
	_g_free0 (_tmp43_);
	_g_free0 (_tmp40_);
	result = ret;
	return result;
}


static gboolean _netsukuku_partial_nip_equal_func_gee_equal_data_func (gconstpointer a, gconstpointer b, gpointer self) {
	gboolean result;
	result = netsukuku_partial_nip_equal_func (a, b);
	return result;
}


GeeList* netsukuku_peer_to_peer_find_nearest_to_register (NetsukukuPeerToPeer* self, NetsukukuNIP* hash_nip, gint num_dupl) {
	GeeList* result = NULL;
	NetsukukuMapRoute* _tmp0_;
	NetsukukuNIP* _tmp1_;
	gchar* _tmp2_ = NULL;
	gchar* _tmp3_;
	NetsukukuNIP* _tmp4_;
	gchar* _tmp5_ = NULL;
	gchar* _tmp6_;
	gint _tmp7_;
	gchar* _tmp8_ = NULL;
	gchar* _tmp9_;
	gchar* _tmp10_ = NULL;
	gchar* _tmp11_;
	GeeArrayList* _tmp12_;
	GeeArrayList* ret;
	NetsukukuMapRoute* _tmp13_;
	gint _tmp14_;
	NetsukukuMapRoute* _tmp15_;
	gint _tmp16_;
	NetsukukuNIP* _tmp17_;
	GeeArrayList* _tmp18_ = NULL;
	GeeArrayList* lst;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (hash_nip != NULL, NULL);
	_tmp0_ = self->maproute;
	_tmp1_ = _tmp0_->me;
	_tmp2_ = netsukuku_partial_nip_to_string ((NetsukukuPartialNIP*) _tmp1_);
	_tmp3_ = _tmp2_;
	_tmp4_ = hash_nip;
	_tmp5_ = netsukuku_partial_nip_to_string ((NetsukukuPartialNIP*) _tmp4_);
	_tmp6_ = _tmp5_;
	_tmp7_ = num_dupl;
	_tmp8_ = g_strdup_printf ("%i", _tmp7_);
	_tmp9_ = _tmp8_;
	_tmp10_ = g_strconcat ("[", _tmp3_, "]: find_nearest_to_register(hash_nip ", _tmp6_, ", num_dupl ", _tmp9_, ")\n", NULL);
	_tmp11_ = _tmp10_;
	ntk_test_print_out (_tmp11_);
	_g_free0 (_tmp11_);
	_g_free0 (_tmp9_);
	_g_free0 (_tmp6_);
	_g_free0 (_tmp3_);
	_tmp12_ = gee_array_list_new (NETSUKUKU_TYPE_NIP, (GBoxedCopyFunc) g_object_ref, g_object_unref, _netsukuku_partial_nip_equal_func_gee_equal_data_func, NULL, NULL);
	ret = _tmp12_;
	_tmp13_ = self->maproute;
	_tmp14_ = _tmp13_->levels;
	_tmp15_ = self->maproute;
	_tmp16_ = _tmp15_->gsize;
	_tmp17_ = hash_nip;
	_tmp18_ = ntk_test_ordered_lookup (_tmp14_, _tmp16_, _tmp17_, 1);
	lst = _tmp18_;
	{
		GeeArrayList* _tmp19_;
		GeeArrayList* _tmp20_;
		GeeArrayList* _s_list;
		GeeArrayList* _tmp21_;
		gint _tmp22_;
		gint _tmp23_;
		gint _s_size;
		gint _s_index;
		_tmp19_ = lst;
		_tmp20_ = _g_object_ref0 (_tmp19_);
		_s_list = _tmp20_;
		_tmp21_ = _s_list;
		_tmp22_ = gee_abstract_collection_get_size ((GeeCollection*) _tmp21_);
		_tmp23_ = _tmp22_;
		_s_size = _tmp23_;
		_s_index = -1;
		while (TRUE) {
			gint _tmp24_;
			gint _tmp25_;
			gint _tmp26_;
			GeeArrayList* _tmp27_;
			gint _tmp28_;
			gpointer _tmp29_ = NULL;
			NetsukukuNIP* s;
			GeeHashMap* _tmp30_;
			NetsukukuNIP* _tmp31_;
			gboolean _tmp32_ = FALSE;
			GeeArrayList* _tmp35_;
			gint _tmp36_;
			gint _tmp37_;
			gint _tmp38_;
			_tmp24_ = _s_index;
			_s_index = _tmp24_ + 1;
			_tmp25_ = _s_index;
			_tmp26_ = _s_size;
			if (!(_tmp25_ < _tmp26_)) {
				break;
			}
			_tmp27_ = _s_list;
			_tmp28_ = _s_index;
			_tmp29_ = gee_abstract_list_get ((GeeAbstractList*) _tmp27_, _tmp28_);
			s = (NetsukukuNIP*) _tmp29_;
			_tmp30_ = ntk_test_nodes;
			_tmp31_ = s;
			_tmp32_ = gee_abstract_map_has_key ((GeeAbstractMap*) _tmp30_, _tmp31_);
			if (_tmp32_) {
				GeeArrayList* _tmp33_;
				NetsukukuNIP* _tmp34_;
				_tmp33_ = ret;
				_tmp34_ = s;
				gee_abstract_collection_add ((GeeAbstractCollection*) _tmp33_, _tmp34_);
			}
			_tmp35_ = ret;
			_tmp36_ = gee_abstract_collection_get_size ((GeeCollection*) _tmp35_);
			_tmp37_ = _tmp36_;
			_tmp38_ = num_dupl;
			if (_tmp37_ >= _tmp38_) {
				_g_object_unref0 (s);
				break;
			}
			_g_object_unref0 (s);
		}
		_g_object_unref0 (_s_list);
	}
	{
		GeeArrayList* _tmp39_;
		GeeArrayList* _tmp40_;
		GeeArrayList* _s_list;
		GeeArrayList* _tmp41_;
		gint _tmp42_;
		gint _tmp43_;
		gint _s_size;
		gint _s_index;
		_tmp39_ = ret;
		_tmp40_ = _g_object_ref0 (_tmp39_);
		_s_list = _tmp40_;
		_tmp41_ = _s_list;
		_tmp42_ = gee_abstract_collection_get_size ((GeeCollection*) _tmp41_);
		_tmp43_ = _tmp42_;
		_s_size = _tmp43_;
		_s_index = -1;
		while (TRUE) {
			gint _tmp44_;
			gint _tmp45_;
			gint _tmp46_;
			GeeArrayList* _tmp47_;
			gint _tmp48_;
			gpointer _tmp49_ = NULL;
			NetsukukuNIP* s;
			NetsukukuMapRoute* _tmp50_;
			NetsukukuNIP* _tmp51_;
			gchar* _tmp52_ = NULL;
			gchar* _tmp53_;
			NetsukukuNIP* _tmp54_;
			gchar* _tmp55_ = NULL;
			gchar* _tmp56_;
			gchar* _tmp57_ = NULL;
			gchar* _tmp58_;
			_tmp44_ = _s_index;
			_s_index = _tmp44_ + 1;
			_tmp45_ = _s_index;
			_tmp46_ = _s_size;
			if (!(_tmp45_ < _tmp46_)) {
				break;
			}
			_tmp47_ = _s_list;
			_tmp48_ = _s_index;
			_tmp49_ = gee_abstract_list_get ((GeeAbstractList*) _tmp47_, _tmp48_);
			s = (NetsukukuNIP*) _tmp49_;
			_tmp50_ = self->maproute;
			_tmp51_ = _tmp50_->me;
			_tmp52_ = netsukuku_partial_nip_to_string ((NetsukukuPartialNIP*) _tmp51_);
			_tmp53_ = _tmp52_;
			_tmp54_ = s;
			_tmp55_ = netsukuku_partial_nip_to_string ((NetsukukuPartialNIP*) _tmp54_);
			_tmp56_ = _tmp55_;
			_tmp57_ = g_strconcat ("[", _tmp53_, "]:   ", _tmp56_, "\n", NULL);
			_tmp58_ = _tmp57_;
			ntk_test_print_out (_tmp58_);
			_g_free0 (_tmp58_);
			_g_free0 (_tmp56_);
			_g_free0 (_tmp53_);
			_g_object_unref0 (s);
		}
		_g_object_unref0 (_s_list);
	}
	result = (GeeList*) ret;
	_g_object_unref0 (lst);
	return result;
}


NetsukukuHCoord* netsukuku_peer_to_peer_search_participant (NetsukukuPeerToPeer* self, NetsukukuNIP* hIP, gint path_sign, GError** error) {
	NetsukukuHCoord* result = NULL;
	NetsukukuMapRoute* _tmp0_;
	NetsukukuNIP* _tmp1_;
	gchar* _tmp2_ = NULL;
	gchar* _tmp3_;
	NetsukukuNIP* _tmp4_;
	gchar* _tmp5_ = NULL;
	gchar* _tmp6_;
	gint _tmp7_;
	gchar* _tmp8_ = NULL;
	gchar* _tmp9_;
	gchar* _tmp10_ = NULL;
	gchar* _tmp11_;
	NetsukukuMapRoute* _tmp12_;
	gint _tmp13_;
	NetsukukuMapRoute* _tmp14_;
	gint _tmp15_;
	NetsukukuNIP* _tmp16_;
	gint _tmp17_;
	NetsukukuNIP* _tmp18_ = NULL;
	NetsukukuNIP* first;
	NetsukukuNIP* _tmp19_;
	NetsukukuNIP* _tmp35_;
	NetsukukuNIP* _tmp37_;
	NetsukukuMapRoute* _tmp38_;
	NetsukukuNIP* _tmp39_;
	gboolean _tmp40_ = FALSE;
	NetsukukuNIP* _tmp41_;
	NetsukukuMapRoute* _tmp42_;
	NetsukukuNIP* _tmp43_;
	NetsukukuHCoord* _tmp44_ = NULL;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (hIP != NULL, NULL);
	_tmp0_ = self->maproute;
	_tmp1_ = _tmp0_->me;
	_tmp2_ = netsukuku_partial_nip_to_string ((NetsukukuPartialNIP*) _tmp1_);
	_tmp3_ = _tmp2_;
	_tmp4_ = hIP;
	_tmp5_ = netsukuku_partial_nip_to_string ((NetsukukuPartialNIP*) _tmp4_);
	_tmp6_ = _tmp5_;
	_tmp7_ = path_sign;
	_tmp8_ = g_strdup_printf ("%i", _tmp7_);
	_tmp9_ = _tmp8_;
	_tmp10_ = g_strconcat ("[", _tmp3_, "]: search_participant(hIP ", _tmp6_, ", path_sign ", _tmp9_, ")\n", NULL);
	_tmp11_ = _tmp10_;
	ntk_test_print_out (_tmp11_);
	_g_free0 (_tmp11_);
	_g_free0 (_tmp9_);
	_g_free0 (_tmp6_);
	_g_free0 (_tmp3_);
	_tmp12_ = self->maproute;
	_tmp13_ = _tmp12_->levels;
	_tmp14_ = self->maproute;
	_tmp15_ = _tmp14_->gsize;
	_tmp16_ = hIP;
	_tmp17_ = path_sign;
	_tmp18_ = ntk_test_best_approximation_nip (_tmp13_, _tmp15_, _tmp16_, _tmp17_);
	first = _tmp18_;
	_tmp19_ = first;
	if (_tmp19_ == NULL) {
		NetsukukuMapRoute* _tmp20_;
		NetsukukuNIP* _tmp21_;
		gchar* _tmp22_ = NULL;
		gchar* _tmp23_;
		gchar* _tmp24_ = NULL;
		gchar* _tmp25_;
		_tmp20_ = self->maproute;
		_tmp21_ = _tmp20_->me;
		_tmp22_ = netsukuku_partial_nip_to_string ((NetsukukuPartialNIP*) _tmp21_);
		_tmp23_ = _tmp22_;
		_tmp24_ = g_strconcat ("[", _tmp23_, "]: search_participant: first null\n", NULL);
		_tmp25_ = _tmp24_;
		ntk_test_print_out (_tmp25_);
		_g_free0 (_tmp25_);
		_g_free0 (_tmp23_);
	} else {
		NetsukukuMapRoute* _tmp26_;
		NetsukukuNIP* _tmp27_;
		gchar* _tmp28_ = NULL;
		gchar* _tmp29_;
		NetsukukuNIP* _tmp30_;
		gchar* _tmp31_ = NULL;
		gchar* _tmp32_;
		gchar* _tmp33_ = NULL;
		gchar* _tmp34_;
		_tmp26_ = self->maproute;
		_tmp27_ = _tmp26_->me;
		_tmp28_ = netsukuku_partial_nip_to_string ((NetsukukuPartialNIP*) _tmp27_);
		_tmp29_ = _tmp28_;
		_tmp30_ = first;
		_tmp31_ = netsukuku_partial_nip_to_string ((NetsukukuPartialNIP*) _tmp30_);
		_tmp32_ = _tmp31_;
		_tmp33_ = g_strconcat ("[", _tmp29_, "]: search_participant: first ", _tmp32_, "\n", NULL);
		_tmp34_ = _tmp33_;
		ntk_test_print_out (_tmp34_);
		_g_free0 (_tmp34_);
		_g_free0 (_tmp32_);
		_g_free0 (_tmp29_);
	}
	_tmp35_ = first;
	if (_tmp35_ == NULL) {
		GError* _tmp36_;
		_tmp36_ = g_error_new_literal (NETSUKUKU_PEER_TO_PEER_ERROR, NETSUKUKU_PEER_TO_PEER_ERROR_GENERIC, "No participants.");
		_inner_error_ = _tmp36_;
		if (_inner_error_->domain == NETSUKUKU_PEER_TO_PEER_ERROR) {
			g_propagate_error (error, _inner_error_);
			_g_object_unref0 (first);
			return NULL;
		} else {
			_g_object_unref0 (first);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	}
	_tmp37_ = first;
	_tmp38_ = self->maproute;
	_tmp39_ = _tmp38_->me;
	_tmp40_ = netsukuku_partial_nip_is_equal ((NetsukukuPartialNIP*) _tmp37_, (NetsukukuPartialNIP*) _tmp39_);
	if (_tmp40_) {
		result = NULL;
		_g_object_unref0 (first);
		return result;
	}
	_tmp41_ = first;
	_tmp42_ = self->maproute;
	_tmp43_ = _tmp42_->me;
	_tmp44_ = netsukuku_partial_nip_get_hcoord_relative_to ((NetsukukuPartialNIP*) _tmp41_, _tmp43_);
	result = _tmp44_;
	_g_object_unref0 (first);
	return result;
}


static void netsukuku_peer_to_peer_class_init (NetsukukuPeerToPeerClass * klass) {
	netsukuku_peer_to_peer_parent_class = g_type_class_peek_parent (klass);
	NETSUKUKU_PEER_TO_PEER_CLASS (klass)->_dispatch = netsukuku_peer_to_peer_real__dispatch;
	NETSUKUKU_PEER_TO_PEER_CLASS (klass)->h = netsukuku_peer_to_peer_real_h;
	G_OBJECT_CLASS (klass)->finalize = netsukuku_peer_to_peer_finalize;
	g_signal_new ("map_peer_to_peer_validated", NETSUKUKU_TYPE_PEER_TO_PEER, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
}


static void netsukuku_peer_to_peer_instance_init (NetsukukuPeerToPeer * self) {
}


static void netsukuku_peer_to_peer_finalize (GObject* obj) {
	NetsukukuPeerToPeer * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, NETSUKUKU_TYPE_PEER_TO_PEER, NetsukukuPeerToPeer);
	G_OBJECT_CLASS (netsukuku_peer_to_peer_parent_class)->finalize (obj);
}


GType netsukuku_peer_to_peer_get_type (void) {
	static volatile gsize netsukuku_peer_to_peer_type_id__volatile = 0;
	if (g_once_init_enter (&netsukuku_peer_to_peer_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (NetsukukuPeerToPeerClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) netsukuku_peer_to_peer_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (NetsukukuPeerToPeer), 0, (GInstanceInitFunc) netsukuku_peer_to_peer_instance_init, NULL };
		GType netsukuku_peer_to_peer_type_id;
		netsukuku_peer_to_peer_type_id = g_type_register_static (G_TYPE_OBJECT, "NetsukukuPeerToPeer", &g_define_type_info, 0);
		g_once_init_leave (&netsukuku_peer_to_peer_type_id__volatile, netsukuku_peer_to_peer_type_id);
	}
	return netsukuku_peer_to_peer_type_id__volatile;
}


NetsukukuOptionalPeerToPeer* netsukuku_optional_peer_to_peer_construct (GType object_type, NetsukukuAggregatedNeighbourManager* aggregated_neighbour_manager, NetsukukuMapRoute* maproute, gint pid) {
	NetsukukuOptionalPeerToPeer * self = NULL;
	NetsukukuAggregatedNeighbourManager* _tmp0_;
	NetsukukuMapRoute* _tmp1_;
	gint _tmp2_;
	g_return_val_if_fail (aggregated_neighbour_manager != NULL, NULL);
	g_return_val_if_fail (maproute != NULL, NULL);
	_tmp0_ = aggregated_neighbour_manager;
	_tmp1_ = maproute;
	_tmp2_ = pid;
	self = (NetsukukuOptionalPeerToPeer*) netsukuku_peer_to_peer_construct (object_type, _tmp0_, _tmp1_, _tmp2_);
	return self;
}


NetsukukuOptionalPeerToPeer* netsukuku_optional_peer_to_peer_new (NetsukukuAggregatedNeighbourManager* aggregated_neighbour_manager, NetsukukuMapRoute* maproute, gint pid) {
	return netsukuku_optional_peer_to_peer_construct (NETSUKUKU_TYPE_OPTIONAL_PEER_TO_PEER, aggregated_neighbour_manager, maproute, pid);
}


void netsukuku_optional_peer_to_peer_participate (NetsukukuOptionalPeerToPeer* self) {
	g_return_if_fail (self != NULL);
	self->hooked = TRUE;
}


static void netsukuku_optional_peer_to_peer_class_init (NetsukukuOptionalPeerToPeerClass * klass) {
	netsukuku_optional_peer_to_peer_parent_class = g_type_class_peek_parent (klass);
	G_OBJECT_CLASS (klass)->finalize = netsukuku_optional_peer_to_peer_finalize;
}


static void netsukuku_optional_peer_to_peer_instance_init (NetsukukuOptionalPeerToPeer * self) {
	self->hooked = FALSE;
}


static void netsukuku_optional_peer_to_peer_finalize (GObject* obj) {
	NetsukukuOptionalPeerToPeer * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, NETSUKUKU_TYPE_OPTIONAL_PEER_TO_PEER, NetsukukuOptionalPeerToPeer);
	G_OBJECT_CLASS (netsukuku_optional_peer_to_peer_parent_class)->finalize (obj);
}


GType netsukuku_optional_peer_to_peer_get_type (void) {
	static volatile gsize netsukuku_optional_peer_to_peer_type_id__volatile = 0;
	if (g_once_init_enter (&netsukuku_optional_peer_to_peer_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (NetsukukuOptionalPeerToPeerClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) netsukuku_optional_peer_to_peer_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (NetsukukuOptionalPeerToPeer), 0, (GInstanceInitFunc) netsukuku_optional_peer_to_peer_instance_init, NULL };
		GType netsukuku_optional_peer_to_peer_type_id;
		netsukuku_optional_peer_to_peer_type_id = g_type_register_static (NETSUKUKU_TYPE_PEER_TO_PEER, "NetsukukuOptionalPeerToPeer", &g_define_type_info, 0);
		g_once_init_leave (&netsukuku_optional_peer_to_peer_type_id__volatile, netsukuku_optional_peer_to_peer_type_id);
	}
	return netsukuku_optional_peer_to_peer_type_id__volatile;
}


NetsukukuAggregatedNeighbourManager* netsukuku_aggregated_neighbour_manager_construct (GType object_type) {
	NetsukukuAggregatedNeighbourManager * self = NULL;
	self = (NetsukukuAggregatedNeighbourManager*) g_object_new (object_type, NULL);
	return self;
}


NetsukukuAggregatedNeighbourManager* netsukuku_aggregated_neighbour_manager_new (void) {
	return netsukuku_aggregated_neighbour_manager_construct (NETSUKUKU_TYPE_AGGREGATED_NEIGHBOUR_MANAGER);
}


static void netsukuku_aggregated_neighbour_manager_class_init (NetsukukuAggregatedNeighbourManagerClass * klass) {
	netsukuku_aggregated_neighbour_manager_parent_class = g_type_class_peek_parent (klass);
}


static void netsukuku_aggregated_neighbour_manager_instance_init (NetsukukuAggregatedNeighbourManager * self) {
}


GType netsukuku_aggregated_neighbour_manager_get_type (void) {
	static volatile gsize netsukuku_aggregated_neighbour_manager_type_id__volatile = 0;
	if (g_once_init_enter (&netsukuku_aggregated_neighbour_manager_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (NetsukukuAggregatedNeighbourManagerClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) netsukuku_aggregated_neighbour_manager_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (NetsukukuAggregatedNeighbourManager), 0, (GInstanceInitFunc) netsukuku_aggregated_neighbour_manager_instance_init, NULL };
		GType netsukuku_aggregated_neighbour_manager_type_id;
		netsukuku_aggregated_neighbour_manager_type_id = g_type_register_static (G_TYPE_OBJECT, "NetsukukuAggregatedNeighbourManager", &g_define_type_info, 0);
		g_once_init_leave (&netsukuku_aggregated_neighbour_manager_type_id__volatile, netsukuku_aggregated_neighbour_manager_type_id);
	}
	return netsukuku_aggregated_neighbour_manager_type_id__volatile;
}


NetsukukuAggregatedNeighbour* netsukuku_aggregated_neighbour_construct (GType object_type) {
	NetsukukuAggregatedNeighbour * self = NULL;
	self = (NetsukukuAggregatedNeighbour*) g_object_new (object_type, NULL);
	return self;
}


NetsukukuAggregatedNeighbour* netsukuku_aggregated_neighbour_new (void) {
	return netsukuku_aggregated_neighbour_construct (NETSUKUKU_TYPE_AGGREGATED_NEIGHBOUR);
}


static void netsukuku_aggregated_neighbour_class_init (NetsukukuAggregatedNeighbourClass * klass) {
	netsukuku_aggregated_neighbour_parent_class = g_type_class_peek_parent (klass);
}


static void netsukuku_aggregated_neighbour_instance_init (NetsukukuAggregatedNeighbour * self) {
}


GType netsukuku_aggregated_neighbour_get_type (void) {
	static volatile gsize netsukuku_aggregated_neighbour_type_id__volatile = 0;
	if (g_once_init_enter (&netsukuku_aggregated_neighbour_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (NetsukukuAggregatedNeighbourClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) netsukuku_aggregated_neighbour_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (NetsukukuAggregatedNeighbour), 0, (GInstanceInitFunc) netsukuku_aggregated_neighbour_instance_init, NULL };
		GType netsukuku_aggregated_neighbour_type_id;
		netsukuku_aggregated_neighbour_type_id = g_type_register_static (G_TYPE_OBJECT, "NetsukukuAggregatedNeighbour", &g_define_type_info, 0);
		g_once_init_leave (&netsukuku_aggregated_neighbour_type_id__volatile, netsukuku_aggregated_neighbour_type_id);
	}
	return netsukuku_aggregated_neighbour_type_id__volatile;
}


NetsukukuMapRoute* netsukuku_map_route_construct (GType object_type, gint l, gint s, NetsukukuNIP* n) {
	NetsukukuMapRoute * self = NULL;
	gint _tmp0_;
	gint _tmp1_;
	NetsukukuNIP* _tmp2_;
	NetsukukuNIP* _tmp3_;
	g_return_val_if_fail (n != NULL, NULL);
	self = (NetsukukuMapRoute*) g_object_new (object_type, NULL);
	_tmp0_ = l;
	self->levels = _tmp0_;
	_tmp1_ = s;
	self->gsize = _tmp1_;
	_tmp2_ = n;
	_tmp3_ = _g_object_ref0 (_tmp2_);
	_g_object_unref0 (self->me);
	self->me = _tmp3_;
	return self;
}


NetsukukuMapRoute* netsukuku_map_route_new (gint l, gint s, NetsukukuNIP* n) {
	return netsukuku_map_route_construct (NETSUKUKU_TYPE_MAP_ROUTE, l, s, n);
}


static void netsukuku_map_route_class_init (NetsukukuMapRouteClass * klass) {
	netsukuku_map_route_parent_class = g_type_class_peek_parent (klass);
	G_OBJECT_CLASS (klass)->finalize = netsukuku_map_route_finalize;
}


static void netsukuku_map_route_instance_init (NetsukukuMapRoute * self) {
}


static void netsukuku_map_route_finalize (GObject* obj) {
	NetsukukuMapRoute * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, NETSUKUKU_TYPE_MAP_ROUTE, NetsukukuMapRoute);
	_g_object_unref0 (self->me);
	G_OBJECT_CLASS (netsukuku_map_route_parent_class)->finalize (obj);
}


GType netsukuku_map_route_get_type (void) {
	static volatile gsize netsukuku_map_route_type_id__volatile = 0;
	if (g_once_init_enter (&netsukuku_map_route_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (NetsukukuMapRouteClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) netsukuku_map_route_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (NetsukukuMapRoute), 0, (GInstanceInitFunc) netsukuku_map_route_instance_init, NULL };
		GType netsukuku_map_route_type_id;
		netsukuku_map_route_type_id = g_type_register_static (G_TYPE_OBJECT, "NetsukukuMapRoute", &g_define_type_info, 0);
		g_once_init_leave (&netsukuku_map_route_type_id__volatile, netsukuku_map_route_type_id);
	}
	return netsukuku_map_route_type_id__volatile;
}


void ntk_test_print_out (const gchar* s) {
	g_return_if_fail (s != NULL);
	if (NTK_TEST_output) {
		const gchar* _tmp0_;
		_tmp0_ = s;
		g_print ("%s", _tmp0_);
	}
}


NetsukukuNIP* ntk_test_best_approximation_nip (gint levels, gint gsize, NetsukukuNIP* hIP, gint sign) {
	NetsukukuNIP* result = NULL;
	NetsukukuNIP* ret;
	gint _tmp0_;
	gint _tmp1_;
	NetsukukuNIP* _tmp2_;
	gint _tmp3_;
	GeeArrayList* _tmp4_ = NULL;
	GeeArrayList* lst;
	g_return_val_if_fail (hIP != NULL, NULL);
	ret = NULL;
	_tmp0_ = levels;
	_tmp1_ = gsize;
	_tmp2_ = hIP;
	_tmp3_ = sign;
	_tmp4_ = ntk_test_ordered_lookup (_tmp0_, _tmp1_, _tmp2_, _tmp3_);
	lst = _tmp4_;
	{
		GeeArrayList* _tmp5_;
		GeeArrayList* _tmp6_;
		GeeArrayList* _s_list;
		GeeArrayList* _tmp7_;
		gint _tmp8_;
		gint _tmp9_;
		gint _s_size;
		gint _s_index;
		_tmp5_ = lst;
		_tmp6_ = _g_object_ref0 (_tmp5_);
		_s_list = _tmp6_;
		_tmp7_ = _s_list;
		_tmp8_ = gee_abstract_collection_get_size ((GeeCollection*) _tmp7_);
		_tmp9_ = _tmp8_;
		_s_size = _tmp9_;
		_s_index = -1;
		while (TRUE) {
			gint _tmp10_;
			gint _tmp11_;
			gint _tmp12_;
			GeeArrayList* _tmp13_;
			gint _tmp14_;
			gpointer _tmp15_ = NULL;
			NetsukukuNIP* s;
			GeeHashMap* _tmp16_;
			NetsukukuNIP* _tmp17_;
			gboolean _tmp18_ = FALSE;
			_tmp10_ = _s_index;
			_s_index = _tmp10_ + 1;
			_tmp11_ = _s_index;
			_tmp12_ = _s_size;
			if (!(_tmp11_ < _tmp12_)) {
				break;
			}
			_tmp13_ = _s_list;
			_tmp14_ = _s_index;
			_tmp15_ = gee_abstract_list_get ((GeeAbstractList*) _tmp13_, _tmp14_);
			s = (NetsukukuNIP*) _tmp15_;
			_tmp16_ = ntk_test_nodes;
			_tmp17_ = s;
			_tmp18_ = gee_abstract_map_has_key ((GeeAbstractMap*) _tmp16_, _tmp17_);
			if (_tmp18_) {
				NetsukukuNIP* _tmp19_;
				NetsukukuNIP* _tmp20_;
				_tmp19_ = s;
				_tmp20_ = _g_object_ref0 (_tmp19_);
				_g_object_unref0 (ret);
				ret = _tmp20_;
				_g_object_unref0 (s);
				break;
			}
			_g_object_unref0 (s);
		}
		_g_object_unref0 (_s_list);
	}
	result = ret;
	_g_object_unref0 (lst);
	return result;
}


NetsukukuDistributedHashTable* ntk_test_best_approximation (gint levels, gint gsize, NetsukukuNIP* hIP, gint sign) {
	NetsukukuDistributedHashTable* result = NULL;
	gint _tmp0_;
	gint _tmp1_;
	NetsukukuNIP* _tmp2_;
	gint _tmp3_;
	NetsukukuNIP* _tmp4_ = NULL;
	NetsukukuNIP* nip;
	GeeHashMap* _tmp5_;
	gboolean _tmp6_ = FALSE;
	GeeHashMap* _tmp7_;
	gpointer _tmp8_ = NULL;
	g_return_val_if_fail (hIP != NULL, NULL);
	_tmp0_ = levels;
	_tmp1_ = gsize;
	_tmp2_ = hIP;
	_tmp3_ = sign;
	_tmp4_ = ntk_test_best_approximation_nip (_tmp0_, _tmp1_, _tmp2_, _tmp3_);
	nip = _tmp4_;
	_vala_assert (nip != NULL, "nip != null");
	_tmp5_ = ntk_test_nodes;
	_tmp6_ = gee_abstract_map_has_key ((GeeAbstractMap*) _tmp5_, nip);
	_vala_assert (_tmp6_, "Ntk.Test.nodes.has_key(nip)");
	_tmp7_ = ntk_test_nodes;
	_tmp8_ = gee_abstract_map_get ((GeeAbstractMap*) _tmp7_, nip);
	result = (NetsukukuDistributedHashTable*) _tmp8_;
	_g_object_unref0 (nip);
	return result;
}


GeeArrayList* ntk_test_list_positions (gint startpos, gint sign, gint gsize) {
	GeeArrayList* result = NULL;
	GeeArrayList* _tmp0_;
	GeeArrayList* ret;
	_tmp0_ = gee_array_list_new (G_TYPE_INT, NULL, NULL, NULL, NULL, NULL);
	ret = _tmp0_;
	{
		gint i;
		i = 0;
		{
			gboolean _tmp1_;
			_tmp1_ = TRUE;
			while (TRUE) {
				gboolean _tmp2_;
				gint _tmp4_;
				gint _tmp5_;
				GeeArrayList* _tmp6_;
				gint _tmp7_;
				gint _tmp8_;
				gint _tmp9_;
				gint _tmp10_;
				gint _tmp11_;
				_tmp2_ = _tmp1_;
				if (!_tmp2_) {
					gint _tmp3_;
					_tmp3_ = i;
					i = _tmp3_ + 1;
				}
				_tmp1_ = FALSE;
				_tmp4_ = i;
				_tmp5_ = gsize;
				if (!(_tmp4_ < _tmp5_)) {
					break;
				}
				_tmp6_ = ret;
				_tmp7_ = startpos;
				_tmp8_ = gsize;
				_tmp9_ = i;
				_tmp10_ = sign;
				_tmp11_ = gsize;
				gee_abstract_collection_add ((GeeAbstractCollection*) _tmp6_, (gpointer) ((gintptr) (((_tmp7_ + _tmp8_) + (_tmp9_ * _tmp10_)) % _tmp11_)));
			}
		}
	}
	result = ret;
	return result;
}


GeeArrayList* ntk_test_ordered_lookup (gint levels, gint gsize, NetsukukuNIP* hIP, gint sign) {
	GeeArrayList* result = NULL;
	GeeArrayList* _tmp0_;
	GeeArrayList* tot;
	g_return_val_if_fail (hIP != NULL, NULL);
	_tmp0_ = gee_array_list_new (NETSUKUKU_TYPE_NIP, (GBoxedCopyFunc) g_object_ref, g_object_unref, NULL, NULL, NULL);
	tot = _tmp0_;
	{
		gint lvl;
		lvl = 0;
		{
			gboolean _tmp1_;
			_tmp1_ = TRUE;
			while (TRUE) {
				gboolean _tmp2_;
				gint _tmp4_;
				gint _tmp5_;
				GeeArrayList* _tmp6_;
				GeeArrayList* tmp;
				GeeArrayList* _tmp66_;
				GeeArrayList* _tmp67_;
				_tmp2_ = _tmp1_;
				if (!_tmp2_) {
					gint _tmp3_;
					_tmp3_ = lvl;
					lvl = _tmp3_ + 1;
				}
				_tmp1_ = FALSE;
				_tmp4_ = lvl;
				_tmp5_ = levels;
				if (!(_tmp4_ < _tmp5_)) {
					break;
				}
				_tmp6_ = gee_array_list_new (NETSUKUKU_TYPE_NIP, (GBoxedCopyFunc) g_object_ref, g_object_unref, NULL, NULL, NULL);
				tmp = _tmp6_;
				{
					NetsukukuNIP* _tmp7_;
					gint _tmp8_;
					gint _tmp9_ = 0;
					gint _tmp10_;
					gint _tmp11_;
					GeeArrayList* _tmp12_ = NULL;
					GeeArrayList* _n_list;
					GeeArrayList* _tmp13_;
					gint _tmp14_;
					gint _tmp15_;
					gint _n_size;
					gint _n_index;
					_tmp7_ = hIP;
					_tmp8_ = lvl;
					_tmp9_ = netsukuku_partial_nip_position_at ((NetsukukuPartialNIP*) _tmp7_, _tmp8_);
					_tmp10_ = sign;
					_tmp11_ = gsize;
					_tmp12_ = ntk_test_list_positions (_tmp9_, _tmp10_, _tmp11_);
					_n_list = _tmp12_;
					_tmp13_ = _n_list;
					_tmp14_ = gee_abstract_collection_get_size ((GeeCollection*) _tmp13_);
					_tmp15_ = _tmp14_;
					_n_size = _tmp15_;
					_n_index = -1;
					while (TRUE) {
						gint _tmp16_;
						gint _tmp17_;
						gint _tmp18_;
						GeeArrayList* _tmp19_;
						gint _tmp20_;
						gpointer _tmp21_ = NULL;
						gint n;
						GeeArrayList* _tmp22_;
						gboolean _tmp23_;
						gboolean _tmp24_;
						_tmp16_ = _n_index;
						_n_index = _tmp16_ + 1;
						_tmp17_ = _n_index;
						_tmp18_ = _n_size;
						if (!(_tmp17_ < _tmp18_)) {
							break;
						}
						_tmp19_ = _n_list;
						_tmp20_ = _n_index;
						_tmp21_ = gee_abstract_list_get ((GeeAbstractList*) _tmp19_, _tmp20_);
						n = (gint) ((gintptr) _tmp21_);
						_tmp22_ = tot;
						_tmp23_ = gee_collection_get_is_empty ((GeeCollection*) _tmp22_);
						_tmp24_ = _tmp23_;
						if (_tmp24_) {
							GeeArrayList* _tmp25_;
							gint _tmp26_;
							gint* _tmp27_ = NULL;
							gint* _tmp28_;
							gint _tmp28__length1;
							NetsukukuNIP* _tmp29_;
							NetsukukuNIP* _tmp30_;
							_tmp25_ = tmp;
							_tmp26_ = n;
							_tmp27_ = g_new0 (gint, 1);
							_tmp27_[0] = _tmp26_;
							_tmp28_ = _tmp27_;
							_tmp28__length1 = 1;
							_tmp29_ = netsukuku_nip_new (_tmp28_, 1);
							_tmp30_ = _tmp29_;
							gee_abstract_collection_add ((GeeAbstractCollection*) _tmp25_, _tmp30_);
							_g_object_unref0 (_tmp30_);
							_tmp28_ = (g_free (_tmp28_), NULL);
						} else {
							{
								GeeArrayList* _tmp31_;
								GeeArrayList* _tmp32_;
								GeeArrayList* _s_list;
								GeeArrayList* _tmp33_;
								gint _tmp34_;
								gint _tmp35_;
								gint _s_size;
								gint _s_index;
								_tmp31_ = tot;
								_tmp32_ = _g_object_ref0 (_tmp31_);
								_s_list = _tmp32_;
								_tmp33_ = _s_list;
								_tmp34_ = gee_abstract_collection_get_size ((GeeCollection*) _tmp33_);
								_tmp35_ = _tmp34_;
								_s_size = _tmp35_;
								_s_index = -1;
								while (TRUE) {
									gint _tmp36_;
									gint _tmp37_;
									gint _tmp38_;
									GeeArrayList* _tmp39_;
									gint _tmp40_;
									gpointer _tmp41_ = NULL;
									NetsukukuNIP* s;
									gint _tmp42_;
									gint* _tmp43_ = NULL;
									gint* n_s_pos;
									gint n_s_pos_length1;
									gint _n_s_pos_size_;
									NetsukukuNIP* _tmp44_;
									gint _tmp45_ = 0;
									gint* _tmp46_ = NULL;
									gint* s_pos;
									gint s_pos_length1;
									gint _s_pos_size_;
									gint* _tmp58_;
									gint _tmp58__length1;
									gint _tmp59_;
									gint _tmp60_;
									gint _tmp61_;
									GeeArrayList* _tmp62_;
									gint* _tmp63_;
									gint _tmp63__length1;
									NetsukukuNIP* _tmp64_;
									NetsukukuNIP* _tmp65_;
									_tmp36_ = _s_index;
									_s_index = _tmp36_ + 1;
									_tmp37_ = _s_index;
									_tmp38_ = _s_size;
									if (!(_tmp37_ < _tmp38_)) {
										break;
									}
									_tmp39_ = _s_list;
									_tmp40_ = _s_index;
									_tmp41_ = gee_abstract_list_get ((GeeAbstractList*) _tmp39_, _tmp40_);
									s = (NetsukukuNIP*) _tmp41_;
									_tmp42_ = lvl;
									_tmp43_ = g_new0 (gint, _tmp42_ + 1);
									n_s_pos = _tmp43_;
									n_s_pos_length1 = _tmp42_ + 1;
									_n_s_pos_size_ = n_s_pos_length1;
									_tmp44_ = s;
									_tmp46_ = netsukuku_partial_nip_get_positions ((NetsukukuPartialNIP*) _tmp44_, &_tmp45_);
									s_pos = _tmp46_;
									s_pos_length1 = _tmp45_;
									_s_pos_size_ = s_pos_length1;
									{
										gint l;
										l = 0;
										{
											gboolean _tmp47_;
											_tmp47_ = TRUE;
											while (TRUE) {
												gboolean _tmp48_;
												gint _tmp50_;
												gint _tmp51_;
												gint* _tmp52_;
												gint _tmp52__length1;
												gint _tmp53_;
												gint* _tmp54_;
												gint _tmp54__length1;
												gint _tmp55_;
												gint _tmp56_;
												gint _tmp57_;
												_tmp48_ = _tmp47_;
												if (!_tmp48_) {
													gint _tmp49_;
													_tmp49_ = l;
													l = _tmp49_ + 1;
												}
												_tmp47_ = FALSE;
												_tmp50_ = l;
												_tmp51_ = lvl;
												if (!(_tmp50_ < _tmp51_)) {
													break;
												}
												_tmp52_ = n_s_pos;
												_tmp52__length1 = n_s_pos_length1;
												_tmp53_ = l;
												_tmp54_ = s_pos;
												_tmp54__length1 = s_pos_length1;
												_tmp55_ = l;
												_tmp56_ = _tmp54_[_tmp55_];
												_tmp52_[_tmp53_] = _tmp56_;
												_tmp57_ = _tmp52_[_tmp53_];
											}
										}
									}
									_tmp58_ = n_s_pos;
									_tmp58__length1 = n_s_pos_length1;
									_tmp59_ = lvl;
									_tmp60_ = n;
									_tmp58_[_tmp59_] = _tmp60_;
									_tmp61_ = _tmp58_[_tmp59_];
									_tmp62_ = tmp;
									_tmp63_ = n_s_pos;
									_tmp63__length1 = n_s_pos_length1;
									_tmp64_ = netsukuku_nip_new (_tmp63_, _tmp63__length1);
									_tmp65_ = _tmp64_;
									gee_abstract_collection_add ((GeeAbstractCollection*) _tmp62_, _tmp65_);
									_g_object_unref0 (_tmp65_);
									s_pos = (g_free (s_pos), NULL);
									n_s_pos = (g_free (n_s_pos), NULL);
									_g_object_unref0 (s);
								}
								_g_object_unref0 (_s_list);
							}
						}
					}
					_g_object_unref0 (_n_list);
				}
				_tmp66_ = tmp;
				_tmp67_ = _g_object_ref0 (_tmp66_);
				_g_object_unref0 (tot);
				tot = _tmp67_;
				_g_object_unref0 (tmp);
			}
		}
	}
	result = tot;
	return result;
}


void ntk_test_dht_tester_set_up (NtkTestDhtTester* self) {
	gchar* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = g_strdup ("");
	_g_free0 (ntk_test_logger);
	ntk_test_logger = _tmp0_;
}


void ntk_test_dht_tester_tear_down (NtkTestDhtTester* self) {
	gchar* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = g_strdup ("");
	_g_free0 (ntk_test_logger);
	ntk_test_logger = _tmp0_;
}


static guint _netsukuku_partial_nip_hash_func_gee_hash_data_func (gconstpointer v, gpointer self) {
	guint result;
	result = netsukuku_partial_nip_hash_func (v);
	return result;
}


static void _vala_array_add1 (NetsukukuNIP*** array, int* length, int* size, NetsukukuNIP* value) {
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (NetsukukuNIP*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}


static void _vala_array_add2 (NetsukukuMapRoute*** array, int* length, int* size, NetsukukuMapRoute* value) {
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (NetsukukuMapRoute*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}


void ntk_test_dht_tester_test_hook_and_replica (NtkTestDhtTester* self) {
	gint int_set_1_counter;
	gint* _tmp0_ = NULL;
	gint* int_set_1;
	gint int_set_1_length1;
	gint _int_set_1_size_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	gchar* _tmp5_;
	gchar* _tmp6_;
	gchar* _tmp7_;
	gchar* _tmp8_;
	gchar* _tmp9_;
	gchar* _tmp10_;
	gchar* _tmp11_;
	gchar* _tmp12_;
	gchar* _tmp13_;
	gchar* _tmp14_;
	gchar* _tmp15_;
	gchar* _tmp16_;
	gchar* _tmp17_;
	gchar* _tmp18_;
	gchar** _tmp19_ = NULL;
	gchar** records;
	gint records_length1;
	gint _records_size_;
	gchar* _tmp20_;
	gchar* _tmp21_;
	gchar* _tmp22_;
	gchar* _tmp23_;
	gchar* _tmp24_;
	gchar* _tmp25_;
	gchar* _tmp26_;
	gchar* _tmp27_;
	gchar* _tmp28_;
	gchar* _tmp29_;
	gchar* _tmp30_;
	gchar* _tmp31_;
	gchar** _tmp32_ = NULL;
	gchar** searchkeys;
	gint searchkeys_length1;
	gint _searchkeys_size_;
	GeeHashMap* _tmp33_;
	NetsukukuNIP** _tmp34_ = NULL;
	NetsukukuNIP** nips;
	gint nips_length1;
	gint _nips_size_;
	gint* _tmp35_;
	gint _tmp35__length1;
	gint _tmp36_;
	gint _tmp37_;
	gint levels;
	gint* _tmp38_;
	gint _tmp38__length1;
	gint _tmp39_;
	gint _tmp40_;
	gint gsize;
	NetsukukuMapRoute** _tmp63_ = NULL;
	NetsukukuMapRoute** mrs;
	gint mrs_length1;
	gint _mrs_size_;
	gint records_counter;
	gint searchkeys_counter;
	NetsukukuNIP** _tmp64_;
	gint _tmp64__length1;
	GeeHashMap* _tmp155_;
	GeeHashMap* number_hits;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	ntk_test_print_out ("test_hook_and_replica started\n");
	int_set_1_counter = 0;
	_tmp0_ = g_new0 (gint, 102);
	_tmp0_[0] = 3;
	_tmp0_[1] = 4;
	_tmp0_[2] = 3;
	_tmp0_[3] = 0;
	_tmp0_[4] = 2;
	_tmp0_[5] = 0;
	_tmp0_[6] = 0;
	_tmp0_[7] = 2;
	_tmp0_[8] = 0;
	_tmp0_[9] = 1;
	_tmp0_[10] = 0;
	_tmp0_[11] = 0;
	_tmp0_[12] = 1;
	_tmp0_[13] = 1;
	_tmp0_[14] = 3;
	_tmp0_[15] = 2;
	_tmp0_[16] = 0;
	_tmp0_[17] = 0;
	_tmp0_[18] = 3;
	_tmp0_[19] = 2;
	_tmp0_[20] = 0;
	_tmp0_[21] = 1;
	_tmp0_[22] = 0;
	_tmp0_[23] = 2;
	_tmp0_[24] = 2;
	_tmp0_[25] = 0;
	_tmp0_[26] = 0;
	_tmp0_[27] = 3;
	_tmp0_[28] = 1;
	_tmp0_[29] = 3;
	_tmp0_[30] = 0;
	_tmp0_[31] = 0;
	_tmp0_[32] = 2;
	_tmp0_[33] = 1;
	_tmp0_[34] = 1;
	_tmp0_[35] = 0;
	_tmp0_[36] = 0;
	_tmp0_[37] = 3;
	_tmp0_[38] = 0;
	_tmp0_[39] = 3;
	_tmp0_[40] = 0;
	_tmp0_[41] = 0;
	_tmp0_[42] = 2;
	_tmp0_[43] = 0;
	_tmp0_[44] = 2;
	_tmp0_[45] = 0;
	_tmp0_[46] = 0;
	_tmp0_[47] = 3;
	_tmp0_[48] = 1;
	_tmp0_[49] = 1;
	_tmp0_[50] = 0;
	_tmp0_[51] = 0;
	_tmp0_[52] = 2;
	_tmp0_[53] = 2;
	_tmp0_[54] = 2;
	_tmp0_[55] = 0;
	_tmp0_[56] = 0;
	_tmp0_[57] = 0;
	_tmp0_[58] = 2;
	_tmp0_[59] = 3;
	_tmp0_[60] = 0;
	_tmp0_[61] = 0;
	_tmp0_[62] = 1;
	_tmp0_[63] = 1;
	_tmp0_[64] = 1;
	_tmp0_[65] = 0;
	_tmp0_[66] = 0;
	_tmp0_[67] = 2;
	_tmp0_[68] = 2;
	_tmp0_[69] = 1;
	_tmp0_[70] = 0;
	_tmp0_[71] = 0;
	_tmp0_[72] = 0;
	_tmp0_[73] = 0;
	_tmp0_[74] = 2;
	_tmp0_[75] = 0;
	_tmp0_[76] = 0;
	_tmp0_[77] = 2;
	_tmp0_[78] = 3;
	_tmp0_[79] = 0;
	_tmp0_[80] = 0;
	_tmp0_[81] = 0;
	_tmp0_[82] = 3;
	_tmp0_[83] = 3;
	_tmp0_[84] = 1;
	_tmp0_[85] = 0;
	_tmp0_[86] = 0;
	_tmp0_[87] = 3;
	_tmp0_[88] = 2;
	_tmp0_[89] = 2;
	_tmp0_[90] = 0;
	_tmp0_[91] = 0;
	_tmp0_[92] = 0;
	_tmp0_[93] = 2;
	_tmp0_[94] = 0;
	_tmp0_[95] = 0;
	_tmp0_[96] = 2;
	_tmp0_[97] = 3;
	_tmp0_[98] = 3;
	_tmp0_[99] = 2;
	_tmp0_[100] = 7;
	_tmp0_[101] = 3;
	int_set_1 = _tmp0_;
	int_set_1_length1 = 102;
	_int_set_1_size_ = int_set_1_length1;
	_tmp1_ = g_strdup ("k1");
	_tmp2_ = g_strdup ("v1");
	_tmp3_ = g_strdup ("kn");
	_tmp4_ = g_strdup ("vn");
	_tmp5_ = g_strdup ("pegasus");
	_tmp6_ = g_strdup ("192.168.14.32");
	_tmp7_ = g_strdup ("zeus");
	_tmp8_ = g_strdup ("192.168.14.22");
	_tmp9_ = g_strdup ("andromeda");
	_tmp10_ = g_strdup ("192.168.14.124");
	_tmp11_ = g_strdup ("athena");
	_tmp12_ = g_strdup ("192.168.14.56");
	_tmp13_ = g_strdup ("sirio");
	_tmp14_ = g_strdup ("192.168.14.3");
	_tmp15_ = g_strdup ("euliste");
	_tmp16_ = g_strdup ("192.168.14.5");
	_tmp17_ = g_strdup ("dedalo");
	_tmp18_ = g_strdup ("192.168.14.1");
	_tmp19_ = g_new0 (gchar*, 18 + 1);
	_tmp19_[0] = _tmp1_;
	_tmp19_[1] = _tmp2_;
	_tmp19_[2] = _tmp3_;
	_tmp19_[3] = _tmp4_;
	_tmp19_[4] = _tmp5_;
	_tmp19_[5] = _tmp6_;
	_tmp19_[6] = _tmp7_;
	_tmp19_[7] = _tmp8_;
	_tmp19_[8] = _tmp9_;
	_tmp19_[9] = _tmp10_;
	_tmp19_[10] = _tmp11_;
	_tmp19_[11] = _tmp12_;
	_tmp19_[12] = _tmp13_;
	_tmp19_[13] = _tmp14_;
	_tmp19_[14] = _tmp15_;
	_tmp19_[15] = _tmp16_;
	_tmp19_[16] = _tmp17_;
	_tmp19_[17] = _tmp18_;
	records = _tmp19_;
	records_length1 = 18;
	_records_size_ = records_length1;
	_tmp20_ = g_strdup ("k1");
	_tmp21_ = g_strdup ("1");
	_tmp22_ = g_strdup ("kn");
	_tmp23_ = g_strdup ("1");
	_tmp24_ = g_strdup ("pippo");
	_tmp25_ = g_strdup ("");
	_tmp26_ = g_strdup ("athena");
	_tmp27_ = g_strdup ("1");
	_tmp28_ = g_strdup ("zeus");
	_tmp29_ = g_strdup ("1");
	_tmp30_ = g_strdup ("dedalo");
	_tmp31_ = g_strdup ("1");
	_tmp32_ = g_new0 (gchar*, 12 + 1);
	_tmp32_[0] = _tmp20_;
	_tmp32_[1] = _tmp21_;
	_tmp32_[2] = _tmp22_;
	_tmp32_[3] = _tmp23_;
	_tmp32_[4] = _tmp24_;
	_tmp32_[5] = _tmp25_;
	_tmp32_[6] = _tmp26_;
	_tmp32_[7] = _tmp27_;
	_tmp32_[8] = _tmp28_;
	_tmp32_[9] = _tmp29_;
	_tmp32_[10] = _tmp30_;
	_tmp32_[11] = _tmp31_;
	searchkeys = _tmp32_;
	searchkeys_length1 = 12;
	_searchkeys_size_ = searchkeys_length1;
	_tmp33_ = gee_hash_map_new (NETSUKUKU_TYPE_NIP, (GBoxedCopyFunc) g_object_ref, g_object_unref, NETSUKUKU_TYPE_DISTRIBUTED_HASH_TABLE, (GBoxedCopyFunc) g_object_ref, g_object_unref, _netsukuku_partial_nip_hash_func_gee_hash_data_func, NULL, NULL, _netsukuku_partial_nip_equal_func_gee_equal_data_func, NULL, NULL, NULL, NULL, NULL);
	_g_object_unref0 (ntk_test_nodes);
	ntk_test_nodes = _tmp33_;
	_tmp34_ = g_new0 (NetsukukuNIP*, 0 + 1);
	nips = _tmp34_;
	nips_length1 = 0;
	_nips_size_ = nips_length1;
	_tmp35_ = int_set_1;
	_tmp35__length1 = int_set_1_length1;
	_tmp36_ = int_set_1_counter;
	int_set_1_counter = _tmp36_ + 1;
	_tmp37_ = _tmp35_[_tmp36_];
	levels = _tmp37_;
	_tmp38_ = int_set_1;
	_tmp38__length1 = int_set_1_length1;
	_tmp39_ = int_set_1_counter;
	int_set_1_counter = _tmp39_ + 1;
	_tmp40_ = _tmp38_[_tmp39_];
	gsize = _tmp40_;
	while (TRUE) {
		gint _tmp41_;
		gint* _tmp42_ = NULL;
		gint* positions;
		gint positions_length1;
		gint _positions_size_;
		gint* _tmp54_;
		gint _tmp54__length1;
		NetsukukuNIP* _tmp55_;
		NetsukukuNIP* nip;
		NetsukukuNIP** _tmp56_;
		gint _tmp56__length1;
		NetsukukuNIP* _tmp57_;
		NetsukukuNIP* _tmp58_;
		gint _tmp59_;
		gint _tmp60_;
		gint _tmp61_;
		gint* _tmp62_;
		gint _tmp62__length1;
		_tmp41_ = levels;
		_tmp42_ = g_new0 (gint, _tmp41_);
		positions = _tmp42_;
		positions_length1 = _tmp41_;
		_positions_size_ = positions_length1;
		{
			gint _tmp43_;
			gint i;
			_tmp43_ = levels;
			i = _tmp43_ - 1;
			{
				gboolean _tmp44_;
				_tmp44_ = TRUE;
				while (TRUE) {
					gboolean _tmp45_;
					gint _tmp47_;
					gint* _tmp48_;
					gint _tmp48__length1;
					gint _tmp49_;
					gint* _tmp50_;
					gint _tmp50__length1;
					gint _tmp51_;
					gint _tmp52_;
					gint _tmp53_;
					_tmp45_ = _tmp44_;
					if (!_tmp45_) {
						gint _tmp46_;
						_tmp46_ = i;
						i = _tmp46_ - 1;
					}
					_tmp44_ = FALSE;
					_tmp47_ = i;
					if (!(_tmp47_ >= 0)) {
						break;
					}
					_tmp48_ = positions;
					_tmp48__length1 = positions_length1;
					_tmp49_ = i;
					_tmp50_ = int_set_1;
					_tmp50__length1 = int_set_1_length1;
					_tmp51_ = int_set_1_counter;
					int_set_1_counter = _tmp51_ + 1;
					_tmp52_ = _tmp50_[_tmp51_];
					_tmp48_[_tmp49_] = _tmp52_;
					_tmp53_ = _tmp48_[_tmp49_];
				}
			}
		}
		_tmp54_ = positions;
		_tmp54__length1 = positions_length1;
		_tmp55_ = netsukuku_nip_new (_tmp54_, _tmp54__length1);
		nip = _tmp55_;
		_tmp56_ = nips;
		_tmp56__length1 = nips_length1;
		_tmp57_ = nip;
		_tmp58_ = _g_object_ref0 (_tmp57_);
		_vala_array_add1 (&nips, &nips_length1, &_nips_size_, _tmp58_);
		_tmp59_ = int_set_1_counter;
		int_set_1_counter = _tmp59_ + 1;
		_tmp60_ = int_set_1_counter;
		int_set_1_counter = _tmp60_ + 1;
		_tmp61_ = int_set_1_counter;
		_tmp62_ = int_set_1;
		_tmp62__length1 = int_set_1_length1;
		if (_tmp61_ >= _tmp62__length1) {
			_g_object_unref0 (nip);
			positions = (g_free (positions), NULL);
			break;
		}
		_g_object_unref0 (nip);
		positions = (g_free (positions), NULL);
	}
	_tmp63_ = g_new0 (NetsukukuMapRoute*, 0 + 1);
	mrs = _tmp63_;
	mrs_length1 = 0;
	_mrs_size_ = mrs_length1;
	int_set_1_counter = 2;
	records_counter = 0;
	searchkeys_counter = 0;
	_tmp64_ = nips;
	_tmp64__length1 = nips_length1;
	{
		NetsukukuNIP** nip_collection = NULL;
		gint nip_collection_length1 = 0;
		gint _nip_collection_size_ = 0;
		gint nip_it = 0;
		nip_collection = _tmp64_;
		nip_collection_length1 = _tmp64__length1;
		for (nip_it = 0; nip_it < _tmp64__length1; nip_it = nip_it + 1) {
			NetsukukuNIP* _tmp65_;
			NetsukukuNIP* nip = NULL;
			_tmp65_ = _g_object_ref0 (nip_collection[nip_it]);
			nip = _tmp65_;
			{
				NetsukukuAggregatedNeighbourManager* _tmp66_;
				NetsukukuAggregatedNeighbourManager* anm;
				gint _tmp67_;
				gint _tmp68_;
				NetsukukuNIP* _tmp69_;
				NetsukukuMapRoute* _tmp70_;
				NetsukukuMapRoute* mr;
				NetsukukuMapRoute** _tmp71_;
				gint _tmp71__length1;
				NetsukukuMapRoute* _tmp72_;
				NetsukukuMapRoute* _tmp73_;
				NetsukukuPeerToPeerAll* _tmp74_;
				NetsukukuPeerToPeerAll* ptpall;
				NetsukukuAggregatedNeighbourManager* _tmp75_;
				NetsukukuMapRoute* _tmp76_;
				NetsukukuPeerToPeerAll* _tmp77_;
				NetsukukuDistributedHashTable* _tmp78_;
				NetsukukuDistributedHashTable* dht;
				NetsukukuDistributedHashTable* _tmp79_;
				GeeHashMap* _tmp82_;
				NetsukukuMapRoute* _tmp83_;
				NetsukukuNIP* _tmp84_;
				NetsukukuDistributedHashTable* _tmp85_;
				gint _tmp86_;
				gint _tmp87_;
				gint* _tmp88_;
				gint _tmp88__length1;
				gint _tmp89_;
				gint _tmp90_;
				gint store;
				gint* _tmp91_;
				gint _tmp91__length1;
				gint _tmp92_;
				gint _tmp93_;
				gint search;
				_tmp66_ = netsukuku_aggregated_neighbour_manager_new ();
				anm = _tmp66_;
				_tmp67_ = levels;
				_tmp68_ = gsize;
				_tmp69_ = nip;
				_tmp70_ = netsukuku_map_route_new (_tmp67_, _tmp68_, _tmp69_);
				mr = _tmp70_;
				_tmp71_ = mrs;
				_tmp71__length1 = mrs_length1;
				_tmp72_ = mr;
				_tmp73_ = _g_object_ref0 (_tmp72_);
				_vala_array_add2 (&mrs, &mrs_length1, &_mrs_size_, _tmp73_);
				_tmp74_ = netsukuku_peer_to_peer_all_new ();
				ptpall = _tmp74_;
				_tmp75_ = anm;
				_tmp76_ = mr;
				_tmp77_ = ptpall;
				_tmp78_ = netsukuku_distributed_hash_table_new (_tmp75_, _tmp76_, _tmp77_);
				dht = _tmp78_;
				_tmp79_ = dht;
				g_signal_emit_by_name ((NetsukukuPeerToPeer*) _tmp79_, "map-peer-to-peer-validated");
				while (TRUE) {
					NetsukukuDistributedHashTable* _tmp80_;
					gboolean _tmp81_;
					_tmp80_ = dht;
					_tmp81_ = ((NetsukukuOptionalPeerToPeer*) _tmp80_)->hooked;
					if (!(!_tmp81_)) {
						break;
					}
					tasklets_tasklet_nap ((glong) 0, (glong) 10000);
				}
				_tmp82_ = ntk_test_nodes;
				_tmp83_ = mr;
				_tmp84_ = _tmp83_->me;
				_tmp85_ = dht;
				gee_abstract_map_set ((GeeAbstractMap*) _tmp82_, _tmp84_, _tmp85_);
				_tmp86_ = int_set_1_counter;
				_tmp87_ = levels;
				int_set_1_counter = _tmp86_ + _tmp87_;
				_tmp88_ = int_set_1;
				_tmp88__length1 = int_set_1_length1;
				_tmp89_ = int_set_1_counter;
				int_set_1_counter = _tmp89_ + 1;
				_tmp90_ = _tmp88_[_tmp89_];
				store = _tmp90_;
				_tmp91_ = int_set_1;
				_tmp91__length1 = int_set_1_length1;
				_tmp92_ = int_set_1_counter;
				int_set_1_counter = _tmp92_ + 1;
				_tmp93_ = _tmp91_[_tmp92_];
				search = _tmp93_;
				while (TRUE) {
					gint _tmp94_;
					gchar** _tmp95_;
					gint _tmp95__length1;
					gint _tmp96_;
					const gchar* _tmp97_;
					NetsukukuDHTKey* _tmp98_;
					NetsukukuDHTKey* k;
					NetsukukuDHTKey* _tmp99_;
					gchar** _tmp100_;
					gint _tmp100__length1;
					gint _tmp101_;
					const gchar* _tmp102_;
					NetsukukuDHTRecord* _tmp103_;
					NetsukukuDHTRecord* rec;
					NetsukukuDHTKey* _tmp104_;
					const gchar* _tmp105_;
					const gchar* _tmp106_;
					const gchar* _tmp107_ = NULL;
					NetsukukuDHTRecord* _tmp108_;
					const gchar* _tmp109_;
					const gchar* _tmp110_;
					const gchar* _tmp111_ = NULL;
					gchar* _tmp112_ = NULL;
					gchar* _tmp113_;
					NetsukukuDistributedHashTable* _tmp114_;
					NetsukukuDistributedHashTable* _tmp115_;
					NetsukukuDHTKey* _tmp116_;
					NetsukukuNIP* _tmp117_ = NULL;
					NetsukukuNIP* _tmp118_;
					NetsukukuRmtDistributedHashTablePeer* _tmp119_ = NULL;
					NetsukukuRmtDistributedHashTablePeer* _tmp120_;
					NetsukukuDHTRecord* _tmp121_;
					_tmp94_ = store;
					store = _tmp94_ - 1;
					if (!(_tmp94_ > 0)) {
						break;
					}
					_tmp95_ = records;
					_tmp95__length1 = records_length1;
					_tmp96_ = records_counter;
					records_counter = _tmp96_ + 1;
					_tmp97_ = _tmp95_[_tmp96_];
					_tmp98_ = netsukuku_dht_key_new (_tmp97_);
					k = _tmp98_;
					_tmp99_ = k;
					_tmp100_ = records;
					_tmp100__length1 = records_length1;
					_tmp101_ = records_counter;
					records_counter = _tmp101_ + 1;
					_tmp102_ = _tmp100_[_tmp101_];
					_tmp103_ = netsukuku_dht_record_new (_tmp99_, _tmp102_, NULL);
					rec = _tmp103_;
					_tmp104_ = k;
					_tmp105_ = netsukuku_dht_key_get_key (_tmp104_);
					_tmp106_ = _tmp105_;
					_tmp107_ = string_to_string (_tmp106_);
					_tmp108_ = rec;
					_tmp109_ = netsukuku_dht_record_get_value (_tmp108_);
					_tmp110_ = _tmp109_;
					_tmp111_ = string_to_string (_tmp110_);
					_tmp112_ = g_strconcat ("store ", _tmp107_, " ", _tmp111_, "\n", NULL);
					_tmp113_ = _tmp112_;
					ntk_test_print_out (_tmp113_);
					_g_free0 (_tmp113_);
					_tmp114_ = dht;
					_tmp115_ = dht;
					_tmp116_ = k;
					_tmp117_ = netsukuku_peer_to_peer_h ((NetsukukuPeerToPeer*) _tmp115_, (GObject*) _tmp116_);
					_tmp118_ = _tmp117_;
					_tmp119_ = netsukuku_distributed_hash_table_peer (_tmp114_, _tmp118_, NULL, NULL);
					_tmp120_ = _tmp119_;
					_tmp121_ = rec;
					netsukuku_idistributed_hash_table_store ((NetsukukuIDistributedHashTable*) _tmp120_, _tmp121_, TRUE, &_inner_error_);
					_g_object_unref0 (_tmp120_);
					_g_object_unref0 (_tmp118_);
					if (_inner_error_ != NULL) {
						_g_object_unref0 (rec);
						_g_object_unref0 (k);
						_g_object_unref0 (dht);
						_g_object_unref0 (ptpall);
						_g_object_unref0 (mr);
						_g_object_unref0 (anm);
						_g_object_unref0 (nip);
						mrs = (_vala_array_free (mrs, mrs_length1, (GDestroyNotify) g_object_unref), NULL);
						nips = (_vala_array_free (nips, nips_length1, (GDestroyNotify) g_object_unref), NULL);
						searchkeys = (_vala_array_free (searchkeys, searchkeys_length1, (GDestroyNotify) g_free), NULL);
						records = (_vala_array_free (records, records_length1, (GDestroyNotify) g_free), NULL);
						int_set_1 = (g_free (int_set_1), NULL);
						g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
						g_clear_error (&_inner_error_);
						return;
					}
					tasklets_tasklet_nap ((glong) 0, (glong) 10000);
					_g_object_unref0 (rec);
					_g_object_unref0 (k);
				}
				while (TRUE) {
					gint _tmp122_;
					gchar** _tmp123_;
					gint _tmp123__length1;
					gint _tmp124_;
					const gchar* _tmp125_;
					NetsukukuDHTKey* _tmp126_;
					NetsukukuDHTKey* k;
					NetsukukuDHTKey* _tmp127_;
					const gchar* _tmp128_;
					const gchar* _tmp129_;
					const gchar* _tmp130_ = NULL;
					gchar* _tmp131_ = NULL;
					gchar* _tmp132_;
					NetsukukuDistributedHashTable* _tmp133_;
					NetsukukuDistributedHashTable* _tmp134_;
					NetsukukuDHTKey* _tmp135_;
					NetsukukuNIP* _tmp136_ = NULL;
					NetsukukuNIP* _tmp137_;
					NetsukukuRmtDistributedHashTablePeer* _tmp138_ = NULL;
					NetsukukuRmtDistributedHashTablePeer* _tmp139_;
					NetsukukuDHTKey* _tmp140_;
					NetsukukuDHTRecord* _tmp141_ = NULL;
					NetsukukuDHTRecord* _tmp142_;
					NetsukukuDHTRecord* rec;
					NetsukukuDHTRecord* _tmp143_;
					gchar** _tmp150_;
					gint _tmp150__length1;
					gint _tmp151_;
					const gchar* _tmp152_;
					_tmp122_ = search;
					search = _tmp122_ - 1;
					if (!(_tmp122_ > 0)) {
						break;
					}
					_tmp123_ = searchkeys;
					_tmp123__length1 = searchkeys_length1;
					_tmp124_ = searchkeys_counter;
					searchkeys_counter = _tmp124_ + 1;
					_tmp125_ = _tmp123_[_tmp124_];
					_tmp126_ = netsukuku_dht_key_new (_tmp125_);
					k = _tmp126_;
					_tmp127_ = k;
					_tmp128_ = netsukuku_dht_key_get_key (_tmp127_);
					_tmp129_ = _tmp128_;
					_tmp130_ = string_to_string (_tmp129_);
					_tmp131_ = g_strconcat ("search ", _tmp130_, "\n", NULL);
					_tmp132_ = _tmp131_;
					ntk_test_print_out (_tmp132_);
					_g_free0 (_tmp132_);
					_tmp133_ = dht;
					_tmp134_ = dht;
					_tmp135_ = k;
					_tmp136_ = netsukuku_peer_to_peer_h ((NetsukukuPeerToPeer*) _tmp134_, (GObject*) _tmp135_);
					_tmp137_ = _tmp136_;
					_tmp138_ = netsukuku_distributed_hash_table_peer (_tmp133_, _tmp137_, NULL, NULL);
					_tmp139_ = _tmp138_;
					_tmp140_ = k;
					_tmp141_ = netsukuku_idistributed_hash_table_retrieve ((NetsukukuIDistributedHashTable*) _tmp139_, _tmp140_, &_inner_error_);
					_tmp142_ = _tmp141_;
					_g_object_unref0 (_tmp139_);
					_g_object_unref0 (_tmp137_);
					rec = _tmp142_;
					if (_inner_error_ != NULL) {
						_g_object_unref0 (k);
						_g_object_unref0 (dht);
						_g_object_unref0 (ptpall);
						_g_object_unref0 (mr);
						_g_object_unref0 (anm);
						_g_object_unref0 (nip);
						mrs = (_vala_array_free (mrs, mrs_length1, (GDestroyNotify) g_object_unref), NULL);
						nips = (_vala_array_free (nips, nips_length1, (GDestroyNotify) g_object_unref), NULL);
						searchkeys = (_vala_array_free (searchkeys, searchkeys_length1, (GDestroyNotify) g_free), NULL);
						records = (_vala_array_free (records, records_length1, (GDestroyNotify) g_free), NULL);
						int_set_1 = (g_free (int_set_1), NULL);
						g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
						g_clear_error (&_inner_error_);
						return;
					}
					_tmp143_ = rec;
					if (_tmp143_ == NULL) {
						ntk_test_print_out ("not found\n");
					} else {
						NetsukukuDHTRecord* _tmp144_;
						const gchar* _tmp145_;
						const gchar* _tmp146_;
						const gchar* _tmp147_ = NULL;
						gchar* _tmp148_ = NULL;
						gchar* _tmp149_;
						_tmp144_ = rec;
						_tmp145_ = netsukuku_dht_record_get_value (_tmp144_);
						_tmp146_ = _tmp145_;
						_tmp147_ = string_to_string (_tmp146_);
						_tmp148_ = g_strconcat ("found: ", _tmp147_, "\n", NULL);
						_tmp149_ = _tmp148_;
						ntk_test_print_out (_tmp149_);
						_g_free0 (_tmp149_);
					}
					_tmp150_ = searchkeys;
					_tmp150__length1 = searchkeys_length1;
					_tmp151_ = searchkeys_counter;
					searchkeys_counter = _tmp151_ + 1;
					_tmp152_ = _tmp150_[_tmp151_];
					if (g_strcmp0 (_tmp152_, "") == 0) {
						NetsukukuDHTRecord* _tmp153_;
						_tmp153_ = rec;
						_vala_assert (_tmp153_ == NULL, "rec == null");
					} else {
						NetsukukuDHTRecord* _tmp154_;
						_tmp154_ = rec;
						_vala_assert (_tmp154_ != NULL, "rec != null");
					}
					_g_object_unref0 (rec);
					_g_object_unref0 (k);
				}
				_g_object_unref0 (dht);
				_g_object_unref0 (ptpall);
				_g_object_unref0 (mr);
				_g_object_unref0 (anm);
				_g_object_unref0 (nip);
			}
		}
	}
	_tmp155_ = gee_hash_map_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, G_TYPE_INT, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
	number_hits = _tmp155_;
	{
		GeeHashMap* _tmp156_;
		GeeCollection* _tmp157_;
		GeeCollection* _tmp158_;
		GeeCollection* _tmp159_;
		GeeIterator* _tmp160_ = NULL;
		GeeIterator* _tmp161_;
		GeeIterator* _dht_it;
		_tmp156_ = ntk_test_nodes;
		_tmp157_ = gee_abstract_map_get_values ((GeeMap*) _tmp156_);
		_tmp158_ = _tmp157_;
		_tmp159_ = _tmp158_;
		_tmp160_ = gee_iterable_iterator ((GeeIterable*) _tmp159_);
		_tmp161_ = _tmp160_;
		_g_object_unref0 (_tmp159_);
		_dht_it = _tmp161_;
		while (TRUE) {
			GeeIterator* _tmp162_;
			gboolean _tmp163_ = FALSE;
			GeeIterator* _tmp164_;
			gpointer _tmp165_ = NULL;
			NetsukukuDistributedHashTable* dht;
			NetsukukuDistributedHashTable* _tmp166_;
			NetsukukuMapRoute* _tmp167_;
			NetsukukuNIP* _tmp168_;
			gchar* _tmp169_ = NULL;
			gchar* _tmp170_;
			NetsukukuDistributedHashTable* _tmp171_;
			GeeHashMap* _tmp172_;
			GeeHashMap* _tmp173_;
			gint _tmp174_;
			gint _tmp175_;
			gchar* _tmp176_ = NULL;
			gchar* _tmp177_;
			gchar* _tmp178_ = NULL;
			gchar* _tmp179_;
			_tmp162_ = _dht_it;
			_tmp163_ = gee_iterator_next (_tmp162_);
			if (!_tmp163_) {
				break;
			}
			_tmp164_ = _dht_it;
			_tmp165_ = gee_iterator_get (_tmp164_);
			dht = (NetsukukuDistributedHashTable*) _tmp165_;
			_tmp166_ = dht;
			_tmp167_ = ((NetsukukuPeerToPeer*) _tmp166_)->maproute;
			_tmp168_ = _tmp167_->me;
			_tmp169_ = netsukuku_partial_nip_to_string ((NetsukukuPartialNIP*) _tmp168_);
			_tmp170_ = _tmp169_;
			_tmp171_ = dht;
			_tmp172_ = netsukuku_distributed_hash_table_get_cache (_tmp171_);
			_tmp173_ = _tmp172_;
			_tmp174_ = gee_abstract_map_get_size ((GeeMap*) _tmp173_);
			_tmp175_ = _tmp174_;
			_tmp176_ = g_strdup_printf ("%i", _tmp175_);
			_tmp177_ = _tmp176_;
			_tmp178_ = g_strconcat ("Node ", _tmp170_, " has ", _tmp177_, " records:\n", NULL);
			_tmp179_ = _tmp178_;
			ntk_test_print_out (_tmp179_);
			_g_free0 (_tmp179_);
			_g_free0 (_tmp177_);
			_g_free0 (_tmp170_);
			{
				NetsukukuDistributedHashTable* _tmp180_;
				GeeHashMap* _tmp181_;
				GeeHashMap* _tmp182_;
				GeeCollection* _tmp183_;
				GeeCollection* _tmp184_;
				GeeCollection* _tmp185_;
				GeeIterator* _tmp186_ = NULL;
				GeeIterator* _tmp187_;
				GeeIterator* _rec_it;
				_tmp180_ = dht;
				_tmp181_ = netsukuku_distributed_hash_table_get_cache (_tmp180_);
				_tmp182_ = _tmp181_;
				_tmp183_ = gee_abstract_map_get_values ((GeeMap*) _tmp182_);
				_tmp184_ = _tmp183_;
				_tmp185_ = _tmp184_;
				_tmp186_ = gee_iterable_iterator ((GeeIterable*) _tmp185_);
				_tmp187_ = _tmp186_;
				_g_object_unref0 (_tmp185_);
				_rec_it = _tmp187_;
				while (TRUE) {
					GeeIterator* _tmp188_;
					gboolean _tmp189_ = FALSE;
					GeeIterator* _tmp190_;
					gpointer _tmp191_ = NULL;
					NetsukukuDHTRecord* rec;
					NetsukukuDHTRecord* _tmp192_;
					NetsukukuDHTKey* _tmp193_;
					NetsukukuDHTKey* _tmp194_;
					const gchar* _tmp195_;
					const gchar* _tmp196_;
					const gchar* _tmp197_ = NULL;
					NetsukukuDHTRecord* _tmp198_;
					const gchar* _tmp199_;
					const gchar* _tmp200_;
					const gchar* _tmp201_ = NULL;
					gchar* _tmp202_ = NULL;
					gchar* _tmp203_;
					GeeHashMap* _tmp204_;
					NetsukukuDHTRecord* _tmp205_;
					NetsukukuDHTKey* _tmp206_;
					NetsukukuDHTKey* _tmp207_;
					const gchar* _tmp208_;
					const gchar* _tmp209_;
					gboolean _tmp210_ = FALSE;
					_tmp188_ = _rec_it;
					_tmp189_ = gee_iterator_next (_tmp188_);
					if (!_tmp189_) {
						break;
					}
					_tmp190_ = _rec_it;
					_tmp191_ = gee_iterator_get (_tmp190_);
					rec = (NetsukukuDHTRecord*) _tmp191_;
					_tmp192_ = rec;
					_tmp193_ = netsukuku_dht_record_get_key (_tmp192_);
					_tmp194_ = _tmp193_;
					_tmp195_ = netsukuku_dht_key_get_key (_tmp194_);
					_tmp196_ = _tmp195_;
					_tmp197_ = string_to_string (_tmp196_);
					_tmp198_ = rec;
					_tmp199_ = netsukuku_dht_record_get_value (_tmp198_);
					_tmp200_ = _tmp199_;
					_tmp201_ = string_to_string (_tmp200_);
					_tmp202_ = g_strconcat ("  ", _tmp197_, " = ", _tmp201_, "\n", NULL);
					_tmp203_ = _tmp202_;
					ntk_test_print_out (_tmp203_);
					_g_free0 (_tmp203_);
					_tmp204_ = number_hits;
					_tmp205_ = rec;
					_tmp206_ = netsukuku_dht_record_get_key (_tmp205_);
					_tmp207_ = _tmp206_;
					_tmp208_ = netsukuku_dht_key_get_key (_tmp207_);
					_tmp209_ = _tmp208_;
					_tmp210_ = gee_abstract_map_has_key ((GeeAbstractMap*) _tmp204_, _tmp209_);
					if (_tmp210_) {
						GeeHashMap* _tmp211_;
						NetsukukuDHTRecord* _tmp212_;
						NetsukukuDHTKey* _tmp213_;
						NetsukukuDHTKey* _tmp214_;
						const gchar* _tmp215_;
						const gchar* _tmp216_;
						GeeHashMap* _tmp217_;
						NetsukukuDHTRecord* _tmp218_;
						NetsukukuDHTKey* _tmp219_;
						NetsukukuDHTKey* _tmp220_;
						const gchar* _tmp221_;
						const gchar* _tmp222_;
						gpointer _tmp223_ = NULL;
						_tmp211_ = number_hits;
						_tmp212_ = rec;
						_tmp213_ = netsukuku_dht_record_get_key (_tmp212_);
						_tmp214_ = _tmp213_;
						_tmp215_ = netsukuku_dht_key_get_key (_tmp214_);
						_tmp216_ = _tmp215_;
						_tmp217_ = number_hits;
						_tmp218_ = rec;
						_tmp219_ = netsukuku_dht_record_get_key (_tmp218_);
						_tmp220_ = _tmp219_;
						_tmp221_ = netsukuku_dht_key_get_key (_tmp220_);
						_tmp222_ = _tmp221_;
						_tmp223_ = gee_abstract_map_get ((GeeAbstractMap*) _tmp217_, _tmp222_);
						gee_abstract_map_set ((GeeAbstractMap*) _tmp211_, _tmp216_, (gpointer) ((gintptr) (((gint) ((gintptr) _tmp223_)) + 1)));
					} else {
						GeeHashMap* _tmp224_;
						NetsukukuDHTRecord* _tmp225_;
						NetsukukuDHTKey* _tmp226_;
						NetsukukuDHTKey* _tmp227_;
						const gchar* _tmp228_;
						const gchar* _tmp229_;
						_tmp224_ = number_hits;
						_tmp225_ = rec;
						_tmp226_ = netsukuku_dht_record_get_key (_tmp225_);
						_tmp227_ = _tmp226_;
						_tmp228_ = netsukuku_dht_key_get_key (_tmp227_);
						_tmp229_ = _tmp228_;
						gee_abstract_map_set ((GeeAbstractMap*) _tmp224_, _tmp229_, (gpointer) ((gintptr) 1));
					}
					_g_object_unref0 (rec);
				}
				_g_object_unref0 (_rec_it);
			}
			_g_object_unref0 (dht);
		}
		_g_object_unref0 (_dht_it);
	}
	{
		GeeHashMap* _tmp230_;
		GeeCollection* _tmp231_;
		GeeCollection* _tmp232_;
		GeeCollection* _tmp233_;
		GeeIterator* _tmp234_ = NULL;
		GeeIterator* _tmp235_;
		GeeIterator* _num_it;
		_tmp230_ = number_hits;
		_tmp231_ = gee_abstract_map_get_values ((GeeMap*) _tmp230_);
		_tmp232_ = _tmp231_;
		_tmp233_ = _tmp232_;
		_tmp234_ = gee_iterable_iterator ((GeeIterable*) _tmp233_);
		_tmp235_ = _tmp234_;
		_g_object_unref0 (_tmp233_);
		_num_it = _tmp235_;
		while (TRUE) {
			GeeIterator* _tmp236_;
			gboolean _tmp237_ = FALSE;
			GeeIterator* _tmp238_;
			gpointer _tmp239_ = NULL;
			gint num;
			gint _tmp240_;
			_tmp236_ = _num_it;
			_tmp237_ = gee_iterator_next (_tmp236_);
			if (!_tmp237_) {
				break;
			}
			_tmp238_ = _num_it;
			_tmp239_ = gee_iterator_get (_tmp238_);
			num = (gint) ((gintptr) _tmp239_);
			_tmp240_ = num;
			_vala_assert (_tmp240_ >= NETSUKUKU_DHT_DUPLICATION, "num >= DHT_DUPLICATION");
		}
		_g_object_unref0 (_num_it);
	}
	_g_object_unref0 (number_hits);
	mrs = (_vala_array_free (mrs, mrs_length1, (GDestroyNotify) g_object_unref), NULL);
	nips = (_vala_array_free (nips, nips_length1, (GDestroyNotify) g_object_unref), NULL);
	searchkeys = (_vala_array_free (searchkeys, searchkeys_length1, (GDestroyNotify) g_free), NULL);
	records = (_vala_array_free (records, records_length1, (GDestroyNotify) g_free), NULL);
	int_set_1 = (g_free (int_set_1), NULL);
}


void ntk_test_dht_tester_test_impl_hook_to_service (NtkTestDhtTester* self) {
	GeeHashMap* _tmp0_;
	NetsukukuAggregatedNeighbourManager* _tmp1_;
	NetsukukuAggregatedNeighbourManager* anm;
	gint* _tmp2_ = NULL;
	gint* _tmp3_;
	gint _tmp3__length1;
	NetsukukuNIP* _tmp4_;
	NetsukukuNIP* _tmp5_;
	NetsukukuMapRoute* _tmp6_;
	NetsukukuMapRoute* _tmp7_;
	NetsukukuMapRoute* mr;
	NetsukukuPeerToPeerAll* _tmp8_;
	NetsukukuPeerToPeerAll* ptpall;
	NetsukukuAggregatedNeighbourManager* _tmp9_;
	NetsukukuMapRoute* _tmp10_;
	NetsukukuPeerToPeerAll* _tmp11_;
	NetsukukuDistributedHashTable* _tmp12_;
	NetsukukuDistributedHashTable* dht;
	NetsukukuDistributedHashTable* _tmp13_;
	GeeHashMap* _tmp16_;
	NetsukukuMapRoute* _tmp17_;
	NetsukukuNIP* _tmp18_;
	NetsukukuDistributedHashTable* _tmp19_;
	NetsukukuDistributedHashTable* _tmp20_;
	NetsukukuDHTKey* _tmp21_;
	NetsukukuDHTKey* _tmp22_;
	NetsukukuDHTRecord* _tmp23_;
	NetsukukuDHTRecord* _tmp24_;
	NetsukukuAggregatedNeighbourManager* _tmp25_;
	NetsukukuAggregatedNeighbourManager* anm2;
	gint* _tmp26_ = NULL;
	gint* _tmp27_;
	gint _tmp27__length1;
	NetsukukuNIP* _tmp28_;
	NetsukukuNIP* _tmp29_;
	NetsukukuMapRoute* _tmp30_;
	NetsukukuMapRoute* _tmp31_;
	NetsukukuMapRoute* mr2;
	NetsukukuPeerToPeerAll* _tmp32_;
	NetsukukuPeerToPeerAll* ptpall2;
	NetsukukuAggregatedNeighbourManager* _tmp33_;
	NetsukukuMapRoute* _tmp34_;
	NetsukukuPeerToPeerAll* _tmp35_;
	NetsukukuDistributedHashTable* _tmp36_;
	NetsukukuDistributedHashTable* dht2;
	NetsukukuDistributedHashTable* _tmp37_;
	GeeHashMap* _tmp40_;
	NetsukukuMapRoute* _tmp41_;
	NetsukukuNIP* _tmp42_;
	NetsukukuDistributedHashTable* _tmp43_;
	NetsukukuDHTKey* _tmp44_;
	NetsukukuDHTKey* key1;
	NetsukukuDistributedHashTable* _tmp45_;
	NetsukukuDHTKey* _tmp46_;
	NetsukukuDHTRecord* _tmp47_ = NULL;
	NetsukukuDHTRecord* rec;
	NetsukukuDHTRecord* _tmp48_;
	NetsukukuDHTRecord* _tmp49_;
	const gchar* _tmp50_;
	const gchar* _tmp51_;
	NetsukukuDHTKey* _tmp52_;
	NetsukukuDHTKey* _tmp53_;
	NetsukukuDHTRecord* _tmp54_;
	NetsukukuDHTRecord* _tmp55_;
	NetsukukuDHTRecord* another;
	NetsukukuDistributedHashTable* _tmp56_;
	NetsukukuDHTRecord* _tmp57_;
	NetsukukuDHTKey* _tmp58_;
	NetsukukuDHTKey* key2;
	NetsukukuDistributedHashTable* _tmp59_;
	GeeHashMap* _tmp60_;
	GeeHashMap* _tmp61_;
	NetsukukuDHTKey* _tmp62_;
	gboolean _tmp63_ = FALSE;
	NetsukukuDistributedHashTable* _tmp64_;
	GeeHashMap* _tmp65_;
	GeeHashMap* _tmp66_;
	NetsukukuDHTKey* _tmp67_;
	gpointer _tmp68_ = NULL;
	NetsukukuDHTRecord* _tmp69_;
	const gchar* _tmp70_;
	const gchar* _tmp71_;
	NetsukukuAggregatedNeighbourManager* _tmp72_;
	NetsukukuAggregatedNeighbourManager* anm3;
	gint* _tmp73_ = NULL;
	gint* _tmp74_;
	gint _tmp74__length1;
	NetsukukuNIP* _tmp75_;
	NetsukukuNIP* _tmp76_;
	NetsukukuMapRoute* _tmp77_;
	NetsukukuMapRoute* _tmp78_;
	NetsukukuMapRoute* mr3;
	NetsukukuPeerToPeerAll* _tmp79_;
	NetsukukuPeerToPeerAll* ptpall3;
	NetsukukuAggregatedNeighbourManager* _tmp80_;
	NetsukukuMapRoute* _tmp81_;
	NetsukukuPeerToPeerAll* _tmp82_;
	NetsukukuDistributedHashTable* _tmp83_;
	NetsukukuDistributedHashTable* dht3;
	NetsukukuDistributedHashTable* _tmp84_;
	GeeHashMap* _tmp87_;
	NetsukukuMapRoute* _tmp88_;
	NetsukukuNIP* _tmp89_;
	NetsukukuDistributedHashTable* _tmp90_;
	NetsukukuDistributedHashTable* _tmp91_;
	GeeHashMap* _tmp92_;
	GeeHashMap* _tmp93_;
	NetsukukuDHTKey* _tmp94_;
	gboolean _tmp95_ = FALSE;
	NetsukukuDistributedHashTable* _tmp96_;
	GeeHashMap* _tmp97_;
	GeeHashMap* _tmp98_;
	NetsukukuDHTKey* _tmp99_;
	gpointer _tmp100_ = NULL;
	NetsukukuDHTRecord* _tmp101_;
	const gchar* _tmp102_;
	const gchar* _tmp103_;
	NetsukukuDistributedHashTable* _tmp104_;
	GeeHashMap* _tmp105_;
	GeeHashMap* _tmp106_;
	NetsukukuDHTKey* _tmp107_;
	gboolean _tmp108_ = FALSE;
	NetsukukuDistributedHashTable* _tmp109_;
	GeeHashMap* _tmp110_;
	GeeHashMap* _tmp111_;
	NetsukukuDHTKey* _tmp112_;
	gpointer _tmp113_ = NULL;
	NetsukukuDHTRecord* _tmp114_;
	const gchar* _tmp115_;
	const gchar* _tmp116_;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	ntk_test_print_out ("test_impl_hook_to_service started\n");
	_tmp0_ = gee_hash_map_new (NETSUKUKU_TYPE_NIP, (GBoxedCopyFunc) g_object_ref, g_object_unref, NETSUKUKU_TYPE_DISTRIBUTED_HASH_TABLE, (GBoxedCopyFunc) g_object_ref, g_object_unref, _netsukuku_partial_nip_hash_func_gee_hash_data_func, NULL, NULL, _netsukuku_partial_nip_equal_func_gee_equal_data_func, NULL, NULL, NULL, NULL, NULL);
	_g_object_unref0 (ntk_test_nodes);
	ntk_test_nodes = _tmp0_;
	_tmp1_ = netsukuku_aggregated_neighbour_manager_new ();
	anm = _tmp1_;
	_tmp2_ = g_new0 (gint, 3);
	_tmp2_[0] = 2;
	_tmp2_[1] = 0;
	_tmp2_[2] = 3;
	_tmp3_ = _tmp2_;
	_tmp3__length1 = 3;
	_tmp4_ = netsukuku_nip_new (_tmp3_, 3);
	_tmp5_ = _tmp4_;
	_tmp6_ = netsukuku_map_route_new (3, 4, _tmp5_);
	_tmp7_ = _tmp6_;
	_g_object_unref0 (_tmp5_);
	_tmp3_ = (g_free (_tmp3_), NULL);
	mr = _tmp7_;
	_tmp8_ = netsukuku_peer_to_peer_all_new ();
	ptpall = _tmp8_;
	_tmp9_ = anm;
	_tmp10_ = mr;
	_tmp11_ = ptpall;
	_tmp12_ = netsukuku_distributed_hash_table_new (_tmp9_, _tmp10_, _tmp11_);
	dht = _tmp12_;
	_tmp13_ = dht;
	g_signal_emit_by_name ((NetsukukuPeerToPeer*) _tmp13_, "map-peer-to-peer-validated");
	while (TRUE) {
		NetsukukuDistributedHashTable* _tmp14_;
		gboolean _tmp15_;
		_tmp14_ = dht;
		_tmp15_ = ((NetsukukuOptionalPeerToPeer*) _tmp14_)->hooked;
		if (!(!_tmp15_)) {
			break;
		}
		tasklets_tasklet_nap ((glong) 0, (glong) 10000);
	}
	_tmp16_ = ntk_test_nodes;
	_tmp17_ = mr;
	_tmp18_ = _tmp17_->me;
	_tmp19_ = dht;
	gee_abstract_map_set ((GeeAbstractMap*) _tmp16_, _tmp18_, _tmp19_);
	_tmp20_ = dht;
	_tmp21_ = netsukuku_dht_key_new ("k1");
	_tmp22_ = _tmp21_;
	_tmp23_ = netsukuku_dht_record_new (_tmp22_, "v1", NULL);
	_tmp24_ = _tmp23_;
	netsukuku_idistributed_hash_table_store ((NetsukukuIDistributedHashTable*) _tmp20_, _tmp24_, TRUE, &_inner_error_);
	_g_object_unref0 (_tmp24_);
	_g_object_unref0 (_tmp22_);
	if (_inner_error_ != NULL) {
		_g_object_unref0 (dht);
		_g_object_unref0 (ptpall);
		_g_object_unref0 (mr);
		_g_object_unref0 (anm);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
	_tmp25_ = netsukuku_aggregated_neighbour_manager_new ();
	anm2 = _tmp25_;
	_tmp26_ = g_new0 (gint, 3);
	_tmp26_[0] = 1;
	_tmp26_[1] = 0;
	_tmp26_[2] = 2;
	_tmp27_ = _tmp26_;
	_tmp27__length1 = 3;
	_tmp28_ = netsukuku_nip_new (_tmp27_, 3);
	_tmp29_ = _tmp28_;
	_tmp30_ = netsukuku_map_route_new (3, 4, _tmp29_);
	_tmp31_ = _tmp30_;
	_g_object_unref0 (_tmp29_);
	_tmp27_ = (g_free (_tmp27_), NULL);
	mr2 = _tmp31_;
	_tmp32_ = netsukuku_peer_to_peer_all_new ();
	ptpall2 = _tmp32_;
	_tmp33_ = anm2;
	_tmp34_ = mr2;
	_tmp35_ = ptpall2;
	_tmp36_ = netsukuku_distributed_hash_table_new (_tmp33_, _tmp34_, _tmp35_);
	dht2 = _tmp36_;
	_tmp37_ = dht2;
	g_signal_emit_by_name ((NetsukukuPeerToPeer*) _tmp37_, "map-peer-to-peer-validated");
	while (TRUE) {
		NetsukukuDistributedHashTable* _tmp38_;
		gboolean _tmp39_;
		_tmp38_ = dht2;
		_tmp39_ = ((NetsukukuOptionalPeerToPeer*) _tmp38_)->hooked;
		if (!(!_tmp39_)) {
			break;
		}
		tasklets_tasklet_nap ((glong) 0, (glong) 10000);
	}
	_tmp40_ = ntk_test_nodes;
	_tmp41_ = mr2;
	_tmp42_ = _tmp41_->me;
	_tmp43_ = dht2;
	gee_abstract_map_set ((GeeAbstractMap*) _tmp40_, _tmp42_, _tmp43_);
	_tmp44_ = netsukuku_dht_key_new ("k1");
	key1 = _tmp44_;
	_tmp45_ = dht2;
	_tmp46_ = key1;
	_tmp47_ = netsukuku_idistributed_hash_table_retrieve ((NetsukukuIDistributedHashTable*) _tmp45_, _tmp46_, &_inner_error_);
	rec = _tmp47_;
	if (_inner_error_ != NULL) {
		_g_object_unref0 (key1);
		_g_object_unref0 (dht2);
		_g_object_unref0 (ptpall2);
		_g_object_unref0 (mr2);
		_g_object_unref0 (anm2);
		_g_object_unref0 (dht);
		_g_object_unref0 (ptpall);
		_g_object_unref0 (mr);
		_g_object_unref0 (anm);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
	_tmp48_ = rec;
	_vala_assert (_tmp48_ != NULL, "rec != null");
	_tmp49_ = rec;
	_tmp50_ = netsukuku_dht_record_get_value (_tmp49_);
	_tmp51_ = _tmp50_;
	_vala_assert (g_strcmp0 (_tmp51_, "v1") == 0, "rec.@value == \"v1\"");
	_tmp52_ = netsukuku_dht_key_new ("Ohz7thie");
	_tmp53_ = _tmp52_;
	_tmp54_ = netsukuku_dht_record_new (_tmp53_, "secret", NULL);
	_tmp55_ = _tmp54_;
	_g_object_unref0 (_tmp53_);
	another = _tmp55_;
	_tmp56_ = dht2;
	_tmp57_ = another;
	netsukuku_idistributed_hash_table_store ((NetsukukuIDistributedHashTable*) _tmp56_, _tmp57_, TRUE, &_inner_error_);
	if (_inner_error_ != NULL) {
		_g_object_unref0 (another);
		_g_object_unref0 (rec);
		_g_object_unref0 (key1);
		_g_object_unref0 (dht2);
		_g_object_unref0 (ptpall2);
		_g_object_unref0 (mr2);
		_g_object_unref0 (anm2);
		_g_object_unref0 (dht);
		_g_object_unref0 (ptpall);
		_g_object_unref0 (mr);
		_g_object_unref0 (anm);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
	tasklets_tasklet_nap ((glong) 0, (glong) 100000);
	_tmp58_ = netsukuku_dht_key_new ("Ohz7thie");
	key2 = _tmp58_;
	_tmp59_ = dht;
	_tmp60_ = netsukuku_distributed_hash_table_get_cache (_tmp59_);
	_tmp61_ = _tmp60_;
	_tmp62_ = key2;
	_tmp63_ = gee_abstract_map_has_key ((GeeAbstractMap*) _tmp61_, _tmp62_);
	_vala_assert (_tmp63_, "dht.cache.has_key(key2)");
	_tmp64_ = dht;
	_tmp65_ = netsukuku_distributed_hash_table_get_cache (_tmp64_);
	_tmp66_ = _tmp65_;
	_tmp67_ = key2;
	_tmp68_ = gee_abstract_map_get ((GeeAbstractMap*) _tmp66_, _tmp67_);
	_tmp69_ = (NetsukukuDHTRecord*) _tmp68_;
	_tmp70_ = netsukuku_dht_record_get_value (_tmp69_);
	_tmp71_ = _tmp70_;
	_vala_assert (g_strcmp0 (_tmp71_, "secret") == 0, "dht.cache[key2].@value == \"secret\"");
	_g_object_unref0 (_tmp69_);
	_tmp72_ = netsukuku_aggregated_neighbour_manager_new ();
	anm3 = _tmp72_;
	_tmp73_ = g_new0 (gint, 3);
	_tmp73_[0] = 3;
	_tmp73_[1] = 1;
	_tmp73_[2] = 1;
	_tmp74_ = _tmp73_;
	_tmp74__length1 = 3;
	_tmp75_ = netsukuku_nip_new (_tmp74_, 3);
	_tmp76_ = _tmp75_;
	_tmp77_ = netsukuku_map_route_new (3, 4, _tmp76_);
	_tmp78_ = _tmp77_;
	_g_object_unref0 (_tmp76_);
	_tmp74_ = (g_free (_tmp74_), NULL);
	mr3 = _tmp78_;
	_tmp79_ = netsukuku_peer_to_peer_all_new ();
	ptpall3 = _tmp79_;
	_tmp80_ = anm3;
	_tmp81_ = mr3;
	_tmp82_ = ptpall3;
	_tmp83_ = netsukuku_distributed_hash_table_new (_tmp80_, _tmp81_, _tmp82_);
	dht3 = _tmp83_;
	_tmp84_ = dht3;
	g_signal_emit_by_name ((NetsukukuPeerToPeer*) _tmp84_, "map-peer-to-peer-validated");
	while (TRUE) {
		NetsukukuDistributedHashTable* _tmp85_;
		gboolean _tmp86_;
		_tmp85_ = dht3;
		_tmp86_ = ((NetsukukuOptionalPeerToPeer*) _tmp85_)->hooked;
		if (!(!_tmp86_)) {
			break;
		}
		tasklets_tasklet_nap ((glong) 0, (glong) 10000);
	}
	_tmp87_ = ntk_test_nodes;
	_tmp88_ = mr3;
	_tmp89_ = _tmp88_->me;
	_tmp90_ = dht3;
	gee_abstract_map_set ((GeeAbstractMap*) _tmp87_, _tmp89_, _tmp90_);
	_tmp91_ = dht3;
	_tmp92_ = netsukuku_distributed_hash_table_get_cache (_tmp91_);
	_tmp93_ = _tmp92_;
	_tmp94_ = key1;
	_tmp95_ = gee_abstract_map_has_key ((GeeAbstractMap*) _tmp93_, _tmp94_);
	_vala_assert (_tmp95_, "dht3.cache.has_key(key1)");
	_tmp96_ = dht3;
	_tmp97_ = netsukuku_distributed_hash_table_get_cache (_tmp96_);
	_tmp98_ = _tmp97_;
	_tmp99_ = key1;
	_tmp100_ = gee_abstract_map_get ((GeeAbstractMap*) _tmp98_, _tmp99_);
	_tmp101_ = (NetsukukuDHTRecord*) _tmp100_;
	_tmp102_ = netsukuku_dht_record_get_value (_tmp101_);
	_tmp103_ = _tmp102_;
	_vala_assert (g_strcmp0 (_tmp103_, "v1") == 0, "dht3.cache[key1].@value == \"v1\"");
	_g_object_unref0 (_tmp101_);
	_tmp104_ = dht3;
	_tmp105_ = netsukuku_distributed_hash_table_get_cache (_tmp104_);
	_tmp106_ = _tmp105_;
	_tmp107_ = key2;
	_tmp108_ = gee_abstract_map_has_key ((GeeAbstractMap*) _tmp106_, _tmp107_);
	_vala_assert (_tmp108_, "dht3.cache.has_key(key2)");
	_tmp109_ = dht3;
	_tmp110_ = netsukuku_distributed_hash_table_get_cache (_tmp109_);
	_tmp111_ = _tmp110_;
	_tmp112_ = key2;
	_tmp113_ = gee_abstract_map_get ((GeeAbstractMap*) _tmp111_, _tmp112_);
	_tmp114_ = (NetsukukuDHTRecord*) _tmp113_;
	_tmp115_ = netsukuku_dht_record_get_value (_tmp114_);
	_tmp116_ = _tmp115_;
	_vala_assert (g_strcmp0 (_tmp116_, "secret") == 0, "dht3.cache[key2].@value == \"secret\"");
	_g_object_unref0 (_tmp114_);
	_g_object_unref0 (dht3);
	_g_object_unref0 (ptpall3);
	_g_object_unref0 (mr3);
	_g_object_unref0 (anm3);
	_g_object_unref0 (key2);
	_g_object_unref0 (another);
	_g_object_unref0 (rec);
	_g_object_unref0 (key1);
	_g_object_unref0 (dht2);
	_g_object_unref0 (ptpall2);
	_g_object_unref0 (mr2);
	_g_object_unref0 (anm2);
	_g_object_unref0 (dht);
	_g_object_unref0 (ptpall);
	_g_object_unref0 (mr);
	_g_object_unref0 (anm);
}


void ntk_test_dht_tester_test_hash (NtkTestDhtTester* self) {
	NetsukukuAggregatedNeighbourManager* _tmp0_;
	NetsukukuAggregatedNeighbourManager* anm;
	gint* _tmp1_ = NULL;
	gint* _tmp2_;
	gint _tmp2__length1;
	NetsukukuNIP* _tmp3_;
	NetsukukuNIP* _tmp4_;
	NetsukukuMapRoute* _tmp5_;
	NetsukukuMapRoute* _tmp6_;
	NetsukukuMapRoute* mr;
	NetsukukuPeerToPeerAll* _tmp7_;
	NetsukukuPeerToPeerAll* ptpall;
	NetsukukuMapRoute* _tmp8_;
	NetsukukuDistributedHashTable* _tmp9_;
	NetsukukuDistributedHashTable* dht;
	NetsukukuDistributedHashTable* _tmp10_;
	NetsukukuDHTKey* _tmp11_;
	NetsukukuDHTKey* _tmp12_;
	NetsukukuNIP* _tmp13_ = NULL;
	NetsukukuNIP* _tmp14_;
	NetsukukuNIP* n1;
	gint* _tmp15_ = NULL;
	gint* _tmp16_;
	gint _tmp16__length1;
	NetsukukuNIP* _tmp17_;
	NetsukukuNIP* _tmp18_;
	gboolean _tmp19_ = FALSE;
	NetsukukuDistributedHashTable* _tmp20_;
	NetsukukuDHTKey* _tmp21_;
	NetsukukuDHTKey* _tmp22_;
	NetsukukuNIP* _tmp23_ = NULL;
	NetsukukuNIP* _tmp24_;
	NetsukukuNIP* n2;
	gint* _tmp25_ = NULL;
	gint* _tmp26_;
	gint _tmp26__length1;
	NetsukukuNIP* _tmp27_;
	NetsukukuNIP* _tmp28_;
	gboolean _tmp29_ = FALSE;
	NetsukukuDistributedHashTable* _tmp30_;
	NetsukukuDHTKey* _tmp31_;
	NetsukukuDHTKey* _tmp32_;
	NetsukukuNIP* _tmp33_ = NULL;
	NetsukukuNIP* _tmp34_;
	NetsukukuNIP* n3;
	gint* _tmp35_ = NULL;
	gint* _tmp36_;
	gint _tmp36__length1;
	NetsukukuNIP* _tmp37_;
	NetsukukuNIP* _tmp38_;
	gboolean _tmp39_ = FALSE;
	gint* _tmp40_ = NULL;
	gint* _tmp41_;
	gint _tmp41__length1;
	NetsukukuNIP* _tmp42_;
	NetsukukuNIP* _tmp43_;
	NetsukukuMapRoute* _tmp44_;
	NetsukukuMapRoute* _tmp45_;
	NetsukukuDistributedHashTable* _tmp46_;
	NetsukukuDistributedHashTable* _tmp47_;
	NetsukukuDHTKey* _tmp48_;
	NetsukukuDHTKey* _tmp49_;
	NetsukukuNIP* _tmp50_ = NULL;
	NetsukukuNIP* _tmp51_;
	NetsukukuNIP* n4;
	gint* _tmp52_ = NULL;
	gint* _tmp53_;
	gint _tmp53__length1;
	NetsukukuNIP* _tmp54_;
	NetsukukuNIP* _tmp55_;
	gboolean _tmp56_ = FALSE;
	NetsukukuDistributedHashTable* _tmp57_;
	NetsukukuDHTKey* _tmp58_;
	NetsukukuDHTKey* _tmp59_;
	NetsukukuNIP* _tmp60_ = NULL;
	NetsukukuNIP* _tmp61_;
	NetsukukuNIP* n5;
	gint* _tmp62_ = NULL;
	gint* _tmp63_;
	gint _tmp63__length1;
	NetsukukuNIP* _tmp64_;
	NetsukukuNIP* _tmp65_;
	gboolean _tmp66_ = FALSE;
	NetsukukuDistributedHashTable* _tmp67_;
	NetsukukuDHTKey* _tmp68_;
	NetsukukuDHTKey* _tmp69_;
	NetsukukuNIP* _tmp70_ = NULL;
	NetsukukuNIP* _tmp71_;
	NetsukukuNIP* n6;
	gint* _tmp72_ = NULL;
	gint* _tmp73_;
	gint _tmp73__length1;
	NetsukukuNIP* _tmp74_;
	NetsukukuNIP* _tmp75_;
	gboolean _tmp76_ = FALSE;
	g_return_if_fail (self != NULL);
	ntk_test_print_out ("test_hash started\n");
	_tmp0_ = netsukuku_aggregated_neighbour_manager_new ();
	anm = _tmp0_;
	_tmp1_ = g_new0 (gint, 3);
	_tmp1_[0] = 2;
	_tmp1_[1] = 0;
	_tmp1_[2] = 3;
	_tmp2_ = _tmp1_;
	_tmp2__length1 = 3;
	_tmp3_ = netsukuku_nip_new (_tmp2_, 3);
	_tmp4_ = _tmp3_;
	_tmp5_ = netsukuku_map_route_new (3, 4, _tmp4_);
	_tmp6_ = _tmp5_;
	_g_object_unref0 (_tmp4_);
	_tmp2_ = (g_free (_tmp2_), NULL);
	mr = _tmp6_;
	_tmp7_ = netsukuku_peer_to_peer_all_new ();
	ptpall = _tmp7_;
	_tmp8_ = mr;
	_tmp9_ = netsukuku_distributed_hash_table_new (anm, _tmp8_, ptpall);
	dht = _tmp9_;
	_tmp10_ = dht;
	_tmp11_ = netsukuku_dht_key_new ("k1");
	_tmp12_ = _tmp11_;
	_tmp13_ = netsukuku_peer_to_peer_h ((NetsukukuPeerToPeer*) _tmp10_, (GObject*) _tmp12_);
	_tmp14_ = _tmp13_;
	_g_object_unref0 (_tmp12_);
	n1 = _tmp14_;
	_tmp15_ = g_new0 (gint, 3);
	_tmp15_[0] = 1;
	_tmp15_[1] = 0;
	_tmp15_[2] = 0;
	_tmp16_ = _tmp15_;
	_tmp16__length1 = 3;
	_tmp17_ = netsukuku_nip_new (_tmp16_, 3);
	_tmp18_ = _tmp17_;
	_tmp19_ = netsukuku_partial_nip_is_equal ((NetsukukuPartialNIP*) n1, (NetsukukuPartialNIP*) _tmp18_);
	_vala_assert (_tmp19_, "n1.is_equal(new NIP({1,0,0}))");
	_g_object_unref0 (_tmp18_);
	_tmp16_ = (g_free (_tmp16_), NULL);
	_tmp20_ = dht;
	_tmp21_ = netsukuku_dht_key_new ("another value");
	_tmp22_ = _tmp21_;
	_tmp23_ = netsukuku_peer_to_peer_h ((NetsukukuPeerToPeer*) _tmp20_, (GObject*) _tmp22_);
	_tmp24_ = _tmp23_;
	_g_object_unref0 (_tmp22_);
	n2 = _tmp24_;
	_tmp25_ = g_new0 (gint, 3);
	_tmp25_[0] = 3;
	_tmp25_[1] = 0;
	_tmp25_[2] = 3;
	_tmp26_ = _tmp25_;
	_tmp26__length1 = 3;
	_tmp27_ = netsukuku_nip_new (_tmp26_, 3);
	_tmp28_ = _tmp27_;
	_tmp29_ = netsukuku_partial_nip_is_equal ((NetsukukuPartialNIP*) n2, (NetsukukuPartialNIP*) _tmp28_);
	_vala_assert (_tmp29_, "n2.is_equal(new NIP({3,0,3}))");
	_g_object_unref0 (_tmp28_);
	_tmp26_ = (g_free (_tmp26_), NULL);
	_tmp30_ = dht;
	_tmp31_ = netsukuku_dht_key_new ("lorem ipsum");
	_tmp32_ = _tmp31_;
	_tmp33_ = netsukuku_peer_to_peer_h ((NetsukukuPeerToPeer*) _tmp30_, (GObject*) _tmp32_);
	_tmp34_ = _tmp33_;
	_g_object_unref0 (_tmp32_);
	n3 = _tmp34_;
	_tmp35_ = g_new0 (gint, 3);
	_tmp35_[0] = 2;
	_tmp35_[1] = 0;
	_tmp35_[2] = 3;
	_tmp36_ = _tmp35_;
	_tmp36__length1 = 3;
	_tmp37_ = netsukuku_nip_new (_tmp36_, 3);
	_tmp38_ = _tmp37_;
	_tmp39_ = netsukuku_partial_nip_is_equal ((NetsukukuPartialNIP*) n3, (NetsukukuPartialNIP*) _tmp38_);
	_vala_assert (_tmp39_, "n3.is_equal(new NIP({2,0,3}))");
	_g_object_unref0 (_tmp38_);
	_tmp36_ = (g_free (_tmp36_), NULL);
	_tmp40_ = g_new0 (gint, 4);
	_tmp40_[0] = 141;
	_tmp40_[1] = 250;
	_tmp40_[2] = 0;
	_tmp40_[3] = 3;
	_tmp41_ = _tmp40_;
	_tmp41__length1 = 4;
	_tmp42_ = netsukuku_nip_new (_tmp41_, 4);
	_tmp43_ = _tmp42_;
	_tmp44_ = netsukuku_map_route_new (4, 256, _tmp43_);
	_g_object_unref0 (mr);
	mr = _tmp44_;
	_g_object_unref0 (_tmp43_);
	_tmp41_ = (g_free (_tmp41_), NULL);
	_tmp45_ = mr;
	_tmp46_ = netsukuku_distributed_hash_table_new (anm, _tmp45_, ptpall);
	_g_object_unref0 (dht);
	dht = _tmp46_;
	_tmp47_ = dht;
	_tmp48_ = netsukuku_dht_key_new ("k1");
	_tmp49_ = _tmp48_;
	_tmp50_ = netsukuku_peer_to_peer_h ((NetsukukuPeerToPeer*) _tmp47_, (GObject*) _tmp49_);
	_tmp51_ = _tmp50_;
	_g_object_unref0 (_tmp49_);
	n4 = _tmp51_;
	_tmp52_ = g_new0 (gint, 4);
	_tmp52_[0] = 65;
	_tmp52_[1] = 120;
	_tmp52_[2] = 89;
	_tmp52_[3] = 0;
	_tmp53_ = _tmp52_;
	_tmp53__length1 = 4;
	_tmp54_ = netsukuku_nip_new (_tmp53_, 4);
	_tmp55_ = _tmp54_;
	_tmp56_ = netsukuku_partial_nip_is_equal ((NetsukukuPartialNIP*) n4, (NetsukukuPartialNIP*) _tmp55_);
	_vala_assert (_tmp56_, "n4.is_equal(new NIP({65,120,89,0}))");
	_g_object_unref0 (_tmp55_);
	_tmp53_ = (g_free (_tmp53_), NULL);
	_tmp57_ = dht;
	_tmp58_ = netsukuku_dht_key_new ("another value");
	_tmp59_ = _tmp58_;
	_tmp60_ = netsukuku_peer_to_peer_h ((NetsukukuPeerToPeer*) _tmp57_, (GObject*) _tmp59_);
	_tmp61_ = _tmp60_;
	_g_object_unref0 (_tmp59_);
	n5 = _tmp61_;
	_tmp62_ = g_new0 (gint, 4);
	_tmp62_[0] = 51;
	_tmp62_[1] = 199;
	_tmp62_[2] = 181;
	_tmp62_[3] = 83;
	_tmp63_ = _tmp62_;
	_tmp63__length1 = 4;
	_tmp64_ = netsukuku_nip_new (_tmp63_, 4);
	_tmp65_ = _tmp64_;
	_tmp66_ = netsukuku_partial_nip_is_equal ((NetsukukuPartialNIP*) n5, (NetsukukuPartialNIP*) _tmp65_);
	_vala_assert (_tmp66_, "n5.is_equal(new NIP({51,199,181,83}))");
	_g_object_unref0 (_tmp65_);
	_tmp63_ = (g_free (_tmp63_), NULL);
	_tmp67_ = dht;
	_tmp68_ = netsukuku_dht_key_new ("lorem ipsum");
	_tmp69_ = _tmp68_;
	_tmp70_ = netsukuku_peer_to_peer_h ((NetsukukuPeerToPeer*) _tmp67_, (GObject*) _tmp69_);
	_tmp71_ = _tmp70_;
	_g_object_unref0 (_tmp69_);
	n6 = _tmp71_;
	_tmp72_ = g_new0 (gint, 4);
	_tmp72_[0] = 50;
	_tmp72_[1] = 222;
	_tmp72_[2] = 90;
	_tmp72_[3] = 29;
	_tmp73_ = _tmp72_;
	_tmp73__length1 = 4;
	_tmp74_ = netsukuku_nip_new (_tmp73_, 4);
	_tmp75_ = _tmp74_;
	_tmp76_ = netsukuku_partial_nip_is_equal ((NetsukukuPartialNIP*) n6, (NetsukukuPartialNIP*) _tmp75_);
	_vala_assert (_tmp76_, "n6.is_equal(new NIP({50,222,90,29}))");
	_g_object_unref0 (_tmp75_);
	_tmp73_ = (g_free (_tmp73_), NULL);
	_g_object_unref0 (n6);
	_g_object_unref0 (n5);
	_g_object_unref0 (n4);
	_g_object_unref0 (n3);
	_g_object_unref0 (n2);
	_g_object_unref0 (n1);
	_g_object_unref0 (dht);
	_g_object_unref0 (ptpall);
	_g_object_unref0 (mr);
	_g_object_unref0 (anm);
}


static guint _netsukuku_dht_key_hash_func_gee_hash_data_func (gconstpointer v, gpointer self) {
	guint result;
	result = netsukuku_dht_key_hash_func (v);
	return result;
}


static gboolean _netsukuku_dht_key_equal_func_gee_equal_data_func (gconstpointer a, gconstpointer b, gpointer self) {
	gboolean result;
	result = netsukuku_dht_key_equal_func (a, b);
	return result;
}


void ntk_test_dht_tester_test_hash_equal_func (NtkTestDhtTester* self) {
	GeeHashMap* _tmp0_;
	GeeHashMap* cache;
	NetsukukuDHTKey* _tmp1_;
	NetsukukuDHTKey* _tmp2_;
	NetsukukuDHTRecord* _tmp3_;
	NetsukukuDHTRecord* _tmp4_;
	NetsukukuDHTRecord* recone;
	NetsukukuDHTKey* _tmp5_;
	NetsukukuDHTKey* _tmp6_;
	NetsukukuDHTKey* _tmp7_;
	NetsukukuDHTKey* _tmp8_;
	gboolean _tmp9_ = FALSE;
	NetsukukuDHTKey* _tmp10_;
	NetsukukuDHTKey* _tmp11_;
	NetsukukuDHTRecord* _tmp12_;
	NetsukukuDHTRecord* _tmp13_;
	NetsukukuDHTRecord* rectwo;
	NetsukukuDHTKey* _tmp14_;
	NetsukukuDHTKey* _tmp15_;
	NetsukukuDHTKey* _tmp16_;
	NetsukukuDHTKey* _tmp17_;
	gboolean _tmp18_ = FALSE;
	NetsukukuDHTKey* _tmp19_;
	NetsukukuDHTKey* _tmp20_;
	gboolean _tmp21_ = FALSE;
	g_return_if_fail (self != NULL);
	ntk_test_print_out ("test_hash_equal_func started\n");
	_tmp0_ = gee_hash_map_new (NETSUKUKU_TYPE_DHT_KEY, (GBoxedCopyFunc) g_object_ref, g_object_unref, NETSUKUKU_TYPE_DHT_RECORD, (GBoxedCopyFunc) g_object_ref, g_object_unref, _netsukuku_dht_key_hash_func_gee_hash_data_func, NULL, NULL, _netsukuku_dht_key_equal_func_gee_equal_data_func, NULL, NULL, NULL, NULL, NULL);
	cache = _tmp0_;
	_tmp1_ = netsukuku_dht_key_new ("k1");
	_tmp2_ = _tmp1_;
	_tmp3_ = netsukuku_dht_record_new (_tmp2_, "v1", NULL);
	_tmp4_ = _tmp3_;
	_g_object_unref0 (_tmp2_);
	recone = _tmp4_;
	_tmp5_ = netsukuku_dht_record_get_key (recone);
	_tmp6_ = _tmp5_;
	gee_abstract_map_set ((GeeAbstractMap*) cache, _tmp6_, recone);
	_tmp7_ = netsukuku_dht_key_new ("k1");
	_tmp8_ = _tmp7_;
	_tmp9_ = gee_abstract_map_has_key ((GeeAbstractMap*) cache, _tmp8_);
	_vala_assert (_tmp9_, "cache.has_key(new DHTKey(\"k1\"))");
	_g_object_unref0 (_tmp8_);
	_tmp10_ = netsukuku_dht_key_new ("Ohz7thie");
	_tmp11_ = _tmp10_;
	_tmp12_ = netsukuku_dht_record_new (_tmp11_, "secret", NULL);
	_tmp13_ = _tmp12_;
	_g_object_unref0 (_tmp11_);
	rectwo = _tmp13_;
	_tmp14_ = netsukuku_dht_record_get_key (rectwo);
	_tmp15_ = _tmp14_;
	gee_abstract_map_set ((GeeAbstractMap*) cache, _tmp15_, rectwo);
	_tmp16_ = netsukuku_dht_key_new ("Ohz7thie");
	_tmp17_ = _tmp16_;
	_tmp18_ = gee_abstract_map_has_key ((GeeAbstractMap*) cache, _tmp17_);
	_vala_assert (_tmp18_, "cache.has_key(new DHTKey(\"Ohz7thie\"))");
	_g_object_unref0 (_tmp17_);
	_tmp19_ = netsukuku_dht_key_new ("pippo");
	_tmp20_ = _tmp19_;
	_tmp21_ = gee_abstract_map_has_key ((GeeAbstractMap*) cache, _tmp20_);
	_vala_assert (!_tmp21_, "!cache.has_key(new DHTKey(\"pippo\"))");
	_g_object_unref0 (_tmp20_);
	_g_object_unref0 (rectwo);
	_g_object_unref0 (recone);
	_g_object_unref0 (cache);
}


static void __lambda8_ (void) {
	NtkTestDhtTester* _tmp0_;
	NtkTestDhtTester* x;
	_tmp0_ = ntk_test_dht_tester_new ();
	x = _tmp0_;
	ntk_test_dht_tester_set_up (x);
	ntk_test_dht_tester_test_hash (x);
	ntk_test_dht_tester_tear_down (x);
	_g_object_unref0 (x);
}


static void ___lambda8__gcallback (void) {
	__lambda8_ ();
}


static void __lambda9_ (void) {
	NtkTestDhtTester* _tmp0_;
	NtkTestDhtTester* x;
	_tmp0_ = ntk_test_dht_tester_new ();
	x = _tmp0_;
	ntk_test_dht_tester_set_up (x);
	ntk_test_dht_tester_test_hash_equal_func (x);
	ntk_test_dht_tester_tear_down (x);
	_g_object_unref0 (x);
}


static void ___lambda9__gcallback (void) {
	__lambda9_ ();
}


static void __lambda10_ (void) {
	NtkTestDhtTester* _tmp0_;
	NtkTestDhtTester* x;
	_tmp0_ = ntk_test_dht_tester_new ();
	x = _tmp0_;
	ntk_test_dht_tester_set_up (x);
	ntk_test_dht_tester_test_impl_hook_to_service (x);
	ntk_test_dht_tester_tear_down (x);
	_g_object_unref0 (x);
}


static void ___lambda10__gcallback (void) {
	__lambda10_ ();
}


static void __lambda11_ (void) {
	NtkTestDhtTester* _tmp0_;
	NtkTestDhtTester* x;
	_tmp0_ = ntk_test_dht_tester_new ();
	x = _tmp0_;
	ntk_test_dht_tester_set_up (x);
	ntk_test_dht_tester_test_hook_and_replica (x);
	ntk_test_dht_tester_tear_down (x);
	_g_object_unref0 (x);
}


static void ___lambda11__gcallback (void) {
	__lambda11_ ();
}


gint ntk_test_dht_tester_main (gchar** args, int args_length1) {
	gint result = 0;
	g_test_init (&args_length1, &args, NULL);
	tasklets_tasklet_init (64);
	g_test_add_func ("/DistributedHashTable/Hash", ___lambda8__gcallback);
	g_test_add_func ("/DistributedHashTable/Collections", ___lambda9__gcallback);
	g_test_add_func ("/DistributedHashTable/Hooking", ___lambda10__gcallback);
	g_test_add_func ("/DistributedHashTable/HookingAndReplica", ___lambda11__gcallback);
	g_test_run ();
	tasklets_tasklet_kill ();
	result = 0;
	return result;
}


int main (int argc, char ** argv) {
	g_type_init ();
	return ntk_test_dht_tester_main (argv, argc);
}


NtkTestDhtTester* ntk_test_dht_tester_construct (GType object_type) {
	NtkTestDhtTester * self = NULL;
	self = (NtkTestDhtTester*) g_object_new (object_type, NULL);
	return self;
}


NtkTestDhtTester* ntk_test_dht_tester_new (void) {
	return ntk_test_dht_tester_construct (NTK_TEST_TYPE_DHT_TESTER);
}


static void ntk_test_dht_tester_class_init (NtkTestDhtTesterClass * klass) {
	ntk_test_dht_tester_parent_class = g_type_class_peek_parent (klass);
}


static void ntk_test_dht_tester_instance_init (NtkTestDhtTester * self) {
}


GType ntk_test_dht_tester_get_type (void) {
	static volatile gsize ntk_test_dht_tester_type_id__volatile = 0;
	if (g_once_init_enter (&ntk_test_dht_tester_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (NtkTestDhtTesterClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) ntk_test_dht_tester_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (NtkTestDhtTester), 0, (GInstanceInitFunc) ntk_test_dht_tester_instance_init, NULL };
		GType ntk_test_dht_tester_type_id;
		ntk_test_dht_tester_type_id = g_type_register_static (G_TYPE_OBJECT, "NtkTestDhtTester", &g_define_type_info, 0);
		g_once_init_leave (&ntk_test_dht_tester_type_id__volatile, ntk_test_dht_tester_type_id);
	}
	return ntk_test_dht_tester_type_id__volatile;
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}



