/* counter.c generated by valac 0.20.1, the Vala compiler
 * generated from counter.vala, do not modify */

/*
 *  This file is part of Netsukuku.
 *  (c) Copyright 2011-2014 Luca Dionisi aka lukisi <luca.dionisi@gmail.com>
 *
 *  Netsukuku is free software: you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation, either version 3 of the License, or
 *  (at your option) any later version.
 *
 *  Netsukuku is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with Netsukuku.  If not, see <http://www.gnu.org/licenses/>.
 */
/*   peerbuilder.in
errors:
 HookingError
  INEXISTENT_GNODE
  GENERIC
 QspnError
  NOT_YOUR_GATEWAY
  ALREADY_UP_TO_DATE
  GENERIC
 PeerRefuseServiceError
  GENERIC
 TunnelError
  GENERIC
 BorderNodesError
  WRONG_GNODE
  NOT_BORDER_NODE
  WILL_NOT_TUNNEL
  TIMEOUT
  GENERIC
 AndnaError
  GENERIC
serializables:
 TimeCapsule
 ParticipantNode
 PackedParticipantNodes
 OptionalServiceParticipants
 SetOptionalServiceParticipants
 PeerToPeerTracerPacketList
 PairNipDistance
 HookReservation
 BookingRecord
 Bookings
 BnodeRecord
 BnodeList
 CoordinatorKnowledge
 CoordinatorKnowledgeSet
 PairLvlNumberOfFreeNodes
 HCoord
 PartialNIP
 NIP
 REM
 NullREM
 DeadREM
 AlmostDeadREM
 RTT
 TracerPacketList
 RouteInSet
 PositionInRoutesSetPerLevel
 RoutesSetPerLevel
 RoutesSet
 ExtendedTracerPacket
 GNodeID
 NetworkID
 InfoNeighbour
 InfoRoute
 InfoNode
 QspnStats
 InfoBorderNode
 InfoCoord
 DHTKey
 DHTRecord
 PublicKey
 AndnaServiceKey
 AndnaServerRecord
 AndnaDomainRecord
 AndnaServer
 AndnaServers
 RegisterHostnameArguments
 CounterNipRecord
 CounterSetDataResponse
 CounterCheckHostnameResponse
 CounterGetCacheRecordsResponse
 AndnaConfirmPubkResponse
 AndnaRegisterMainResponse
 AndnaRegisterSpreadResponse
 AndnaGetServersResponse
 AndnaGetRegistrarResponse
 AndnaGetCacheRecordsResponse
 BroadcastID
 UnicastID
peers:
 Counter
  methods:
   CounterSetDataResponse set_data_for_pubk
    arguments:
     NIP nip
     Gee.List<string> hashed_domains
     PublicKey pubkey
     SerializableBuffer signature
     bool replicate
    throws:
     PeerRefuseServiceError
   CounterCheckHostnameResponse check_hostname
    arguments:
     NIP nip
     string hashed_domain
     PublicKey pubkey
    throws:
     PeerRefuseServiceError
   CounterNipRecord? get_hostnames
    arguments:
     NIP nip
    throws:
     PeerRefuseServiceError
   CounterGetCacheRecordsResponse get_cache_records
    arguments:
    throws:
     PeerRefuseServiceError
*/

#include <glib.h>
#include <glib-object.h>
#include <netsukuku-rpc.h>
#include <gee.h>
#include <stdlib.h>
#include <string.h>
#include <zcd.h>
#include <tasklet.h>
#include <unistd.h>


#define NETSUKUKU_TYPE_ICOUNTER_AS_PEER (netsukuku_icounter_as_peer_get_type ())
#define NETSUKUKU_ICOUNTER_AS_PEER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), NETSUKUKU_TYPE_ICOUNTER_AS_PEER, NetsukukuICounterAsPeer))
#define NETSUKUKU_IS_ICOUNTER_AS_PEER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), NETSUKUKU_TYPE_ICOUNTER_AS_PEER))
#define NETSUKUKU_ICOUNTER_AS_PEER_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), NETSUKUKU_TYPE_ICOUNTER_AS_PEER, NetsukukuICounterAsPeerIface))

typedef struct _NetsukukuICounterAsPeer NetsukukuICounterAsPeer;
typedef struct _NetsukukuICounterAsPeerIface NetsukukuICounterAsPeerIface;

#define NETSUKUKU_TYPE_RMT_PEER (netsukuku_rmt_peer_get_type ())
#define NETSUKUKU_RMT_PEER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), NETSUKUKU_TYPE_RMT_PEER, NetsukukuRmtPeer))
#define NETSUKUKU_RMT_PEER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), NETSUKUKU_TYPE_RMT_PEER, NetsukukuRmtPeerClass))
#define NETSUKUKU_IS_RMT_PEER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), NETSUKUKU_TYPE_RMT_PEER))
#define NETSUKUKU_IS_RMT_PEER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), NETSUKUKU_TYPE_RMT_PEER))
#define NETSUKUKU_RMT_PEER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), NETSUKUKU_TYPE_RMT_PEER, NetsukukuRmtPeerClass))

typedef struct _NetsukukuRmtPeer NetsukukuRmtPeer;
typedef struct _NetsukukuRmtPeerClass NetsukukuRmtPeerClass;
typedef struct _NetsukukuRmtPeerPrivate NetsukukuRmtPeerPrivate;

#define NETSUKUKU_TYPE_RMT_COUNTER_PEER (netsukuku_rmt_counter_peer_get_type ())
#define NETSUKUKU_RMT_COUNTER_PEER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), NETSUKUKU_TYPE_RMT_COUNTER_PEER, NetsukukuRmtCounterPeer))
#define NETSUKUKU_RMT_COUNTER_PEER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), NETSUKUKU_TYPE_RMT_COUNTER_PEER, NetsukukuRmtCounterPeerClass))
#define NETSUKUKU_IS_RMT_COUNTER_PEER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), NETSUKUKU_TYPE_RMT_COUNTER_PEER))
#define NETSUKUKU_IS_RMT_COUNTER_PEER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), NETSUKUKU_TYPE_RMT_COUNTER_PEER))
#define NETSUKUKU_RMT_COUNTER_PEER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), NETSUKUKU_TYPE_RMT_COUNTER_PEER, NetsukukuRmtCounterPeerClass))

typedef struct _NetsukukuRmtCounterPeer NetsukukuRmtCounterPeer;
typedef struct _NetsukukuRmtCounterPeerClass NetsukukuRmtCounterPeerClass;
typedef struct _NetsukukuRmtCounterPeerPrivate NetsukukuRmtCounterPeerPrivate;

#define NETSUKUKU_TYPE_PEER_TO_PEER (netsukuku_peer_to_peer_get_type ())
#define NETSUKUKU_PEER_TO_PEER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), NETSUKUKU_TYPE_PEER_TO_PEER, NetsukukuPeerToPeer))
#define NETSUKUKU_PEER_TO_PEER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), NETSUKUKU_TYPE_PEER_TO_PEER, NetsukukuPeerToPeerClass))
#define NETSUKUKU_IS_PEER_TO_PEER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), NETSUKUKU_TYPE_PEER_TO_PEER))
#define NETSUKUKU_IS_PEER_TO_PEER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), NETSUKUKU_TYPE_PEER_TO_PEER))
#define NETSUKUKU_PEER_TO_PEER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), NETSUKUKU_TYPE_PEER_TO_PEER, NetsukukuPeerToPeerClass))

typedef struct _NetsukukuPeerToPeer NetsukukuPeerToPeer;
typedef struct _NetsukukuPeerToPeerClass NetsukukuPeerToPeerClass;

#define NETSUKUKU_TYPE_AGGREGATED_NEIGHBOUR (netsukuku_aggregated_neighbour_get_type ())
#define NETSUKUKU_AGGREGATED_NEIGHBOUR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), NETSUKUKU_TYPE_AGGREGATED_NEIGHBOUR, NetsukukuAggregatedNeighbour))
#define NETSUKUKU_AGGREGATED_NEIGHBOUR_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), NETSUKUKU_TYPE_AGGREGATED_NEIGHBOUR, NetsukukuAggregatedNeighbourClass))
#define NETSUKUKU_IS_AGGREGATED_NEIGHBOUR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), NETSUKUKU_TYPE_AGGREGATED_NEIGHBOUR))
#define NETSUKUKU_IS_AGGREGATED_NEIGHBOUR_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), NETSUKUKU_TYPE_AGGREGATED_NEIGHBOUR))
#define NETSUKUKU_AGGREGATED_NEIGHBOUR_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), NETSUKUKU_TYPE_AGGREGATED_NEIGHBOUR, NetsukukuAggregatedNeighbourClass))

typedef struct _NetsukukuAggregatedNeighbour NetsukukuAggregatedNeighbour;
typedef struct _NetsukukuAggregatedNeighbourClass NetsukukuAggregatedNeighbourClass;
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))

#define NETSUKUKU_TYPE_ARGUMENTS_FOR_DUPLICATION_SET_DATA (netsukuku_arguments_for_duplication_set_data_get_type ())
#define NETSUKUKU_ARGUMENTS_FOR_DUPLICATION_SET_DATA(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), NETSUKUKU_TYPE_ARGUMENTS_FOR_DUPLICATION_SET_DATA, NetsukukuArgumentsForDuplicationSetData))
#define NETSUKUKU_ARGUMENTS_FOR_DUPLICATION_SET_DATA_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), NETSUKUKU_TYPE_ARGUMENTS_FOR_DUPLICATION_SET_DATA, NetsukukuArgumentsForDuplicationSetDataClass))
#define NETSUKUKU_IS_ARGUMENTS_FOR_DUPLICATION_SET_DATA(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), NETSUKUKU_TYPE_ARGUMENTS_FOR_DUPLICATION_SET_DATA))
#define NETSUKUKU_IS_ARGUMENTS_FOR_DUPLICATION_SET_DATA_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), NETSUKUKU_TYPE_ARGUMENTS_FOR_DUPLICATION_SET_DATA))
#define NETSUKUKU_ARGUMENTS_FOR_DUPLICATION_SET_DATA_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), NETSUKUKU_TYPE_ARGUMENTS_FOR_DUPLICATION_SET_DATA, NetsukukuArgumentsForDuplicationSetDataClass))

typedef struct _NetsukukuArgumentsForDuplicationSetData NetsukukuArgumentsForDuplicationSetData;
typedef struct _NetsukukuArgumentsForDuplicationSetDataClass NetsukukuArgumentsForDuplicationSetDataClass;
typedef struct _NetsukukuArgumentsForDuplicationSetDataPrivate NetsukukuArgumentsForDuplicationSetDataPrivate;

#define NETSUKUKU_TYPE_STRUCT_HELPER_COUNTER_HOOK_TO_SERVICE (netsukuku_struct_helper_counter_hook_to_service_get_type ())

#define NETSUKUKU_TYPE_OPTIONAL_PEER_TO_PEER (netsukuku_optional_peer_to_peer_get_type ())
#define NETSUKUKU_OPTIONAL_PEER_TO_PEER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), NETSUKUKU_TYPE_OPTIONAL_PEER_TO_PEER, NetsukukuOptionalPeerToPeer))
#define NETSUKUKU_OPTIONAL_PEER_TO_PEER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), NETSUKUKU_TYPE_OPTIONAL_PEER_TO_PEER, NetsukukuOptionalPeerToPeerClass))
#define NETSUKUKU_IS_OPTIONAL_PEER_TO_PEER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), NETSUKUKU_TYPE_OPTIONAL_PEER_TO_PEER))
#define NETSUKUKU_IS_OPTIONAL_PEER_TO_PEER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), NETSUKUKU_TYPE_OPTIONAL_PEER_TO_PEER))
#define NETSUKUKU_OPTIONAL_PEER_TO_PEER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), NETSUKUKU_TYPE_OPTIONAL_PEER_TO_PEER, NetsukukuOptionalPeerToPeerClass))

typedef struct _NetsukukuOptionalPeerToPeer NetsukukuOptionalPeerToPeer;
typedef struct _NetsukukuOptionalPeerToPeerClass NetsukukuOptionalPeerToPeerClass;

#define NETSUKUKU_TYPE_COUNTER (netsukuku_counter_get_type ())
#define NETSUKUKU_COUNTER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), NETSUKUKU_TYPE_COUNTER, NetsukukuCounter))
#define NETSUKUKU_COUNTER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), NETSUKUKU_TYPE_COUNTER, NetsukukuCounterClass))
#define NETSUKUKU_IS_COUNTER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), NETSUKUKU_TYPE_COUNTER))
#define NETSUKUKU_IS_COUNTER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), NETSUKUKU_TYPE_COUNTER))
#define NETSUKUKU_COUNTER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), NETSUKUKU_TYPE_COUNTER, NetsukukuCounterClass))

typedef struct _NetsukukuCounter NetsukukuCounter;
typedef struct _NetsukukuCounterClass NetsukukuCounterClass;
typedef struct _Netsukukustruct_helper_Counter_hook_to_service Netsukukustruct_helper_Counter_hook_to_service;

#define NETSUKUKU_TYPE_STRUCT_HELPER_COUNTER_RESET_MY_COUNTER_NODE (netsukuku_struct_helper_counter_reset_my_counter_node_get_type ())
typedef struct _Netsukukustruct_helper_Counter_reset_my_counter_node Netsukukustruct_helper_Counter_reset_my_counter_node;
typedef struct _NetsukukuPeerToPeerPrivate NetsukukuPeerToPeerPrivate;

#define NETSUKUKU_TYPE_MAP (netsukuku_map_get_type ())
#define NETSUKUKU_MAP(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), NETSUKUKU_TYPE_MAP, NetsukukuMap))
#define NETSUKUKU_MAP_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), NETSUKUKU_TYPE_MAP, NetsukukuMapClass))
#define NETSUKUKU_IS_MAP(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), NETSUKUKU_TYPE_MAP))
#define NETSUKUKU_IS_MAP_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), NETSUKUKU_TYPE_MAP))
#define NETSUKUKU_MAP_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), NETSUKUKU_TYPE_MAP, NetsukukuMapClass))

typedef struct _NetsukukuMap NetsukukuMap;
typedef struct _NetsukukuMapClass NetsukukuMapClass;

#define NETSUKUKU_TYPE_MAP_ROUTE (netsukuku_map_route_get_type ())
#define NETSUKUKU_MAP_ROUTE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), NETSUKUKU_TYPE_MAP_ROUTE, NetsukukuMapRoute))
#define NETSUKUKU_MAP_ROUTE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), NETSUKUKU_TYPE_MAP_ROUTE, NetsukukuMapRouteClass))
#define NETSUKUKU_IS_MAP_ROUTE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), NETSUKUKU_TYPE_MAP_ROUTE))
#define NETSUKUKU_IS_MAP_ROUTE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), NETSUKUKU_TYPE_MAP_ROUTE))
#define NETSUKUKU_MAP_ROUTE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), NETSUKUKU_TYPE_MAP_ROUTE, NetsukukuMapRouteClass))

typedef struct _NetsukukuMapRoute NetsukukuMapRoute;
typedef struct _NetsukukuMapRouteClass NetsukukuMapRouteClass;

#define NETSUKUKU_TYPE_AGGREGATED_NEIGHBOUR_MANAGER (netsukuku_aggregated_neighbour_manager_get_type ())
#define NETSUKUKU_AGGREGATED_NEIGHBOUR_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), NETSUKUKU_TYPE_AGGREGATED_NEIGHBOUR_MANAGER, NetsukukuAggregatedNeighbourManager))
#define NETSUKUKU_AGGREGATED_NEIGHBOUR_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), NETSUKUKU_TYPE_AGGREGATED_NEIGHBOUR_MANAGER, NetsukukuAggregatedNeighbourManagerClass))
#define NETSUKUKU_IS_AGGREGATED_NEIGHBOUR_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), NETSUKUKU_TYPE_AGGREGATED_NEIGHBOUR_MANAGER))
#define NETSUKUKU_IS_AGGREGATED_NEIGHBOUR_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), NETSUKUKU_TYPE_AGGREGATED_NEIGHBOUR_MANAGER))
#define NETSUKUKU_AGGREGATED_NEIGHBOUR_MANAGER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), NETSUKUKU_TYPE_AGGREGATED_NEIGHBOUR_MANAGER, NetsukukuAggregatedNeighbourManagerClass))

typedef struct _NetsukukuAggregatedNeighbourManager NetsukukuAggregatedNeighbourManager;
typedef struct _NetsukukuAggregatedNeighbourManagerClass NetsukukuAggregatedNeighbourManagerClass;
typedef struct _NetsukukuOptionalPeerToPeerPrivate NetsukukuOptionalPeerToPeerPrivate;

#define NETSUKUKU_TYPE_MAP_PEER_TO_PEER (netsukuku_map_peer_to_peer_get_type ())
#define NETSUKUKU_MAP_PEER_TO_PEER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), NETSUKUKU_TYPE_MAP_PEER_TO_PEER, NetsukukuMapPeerToPeer))
#define NETSUKUKU_MAP_PEER_TO_PEER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), NETSUKUKU_TYPE_MAP_PEER_TO_PEER, NetsukukuMapPeerToPeerClass))
#define NETSUKUKU_IS_MAP_PEER_TO_PEER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), NETSUKUKU_TYPE_MAP_PEER_TO_PEER))
#define NETSUKUKU_IS_MAP_PEER_TO_PEER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), NETSUKUKU_TYPE_MAP_PEER_TO_PEER))
#define NETSUKUKU_MAP_PEER_TO_PEER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), NETSUKUKU_TYPE_MAP_PEER_TO_PEER, NetsukukuMapPeerToPeerClass))

typedef struct _NetsukukuMapPeerToPeer NetsukukuMapPeerToPeer;
typedef struct _NetsukukuMapPeerToPeerClass NetsukukuMapPeerToPeerClass;
typedef struct _NetsukukuCounterPrivate NetsukukuCounterPrivate;

#define NETSUKUKU_TYPE_PEER_TO_PEER_ALL (netsukuku_peer_to_peer_all_get_type ())
#define NETSUKUKU_PEER_TO_PEER_ALL(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), NETSUKUKU_TYPE_PEER_TO_PEER_ALL, NetsukukuPeerToPeerAll))
#define NETSUKUKU_PEER_TO_PEER_ALL_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), NETSUKUKU_TYPE_PEER_TO_PEER_ALL, NetsukukuPeerToPeerAllClass))
#define NETSUKUKU_IS_PEER_TO_PEER_ALL(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), NETSUKUKU_TYPE_PEER_TO_PEER_ALL))
#define NETSUKUKU_IS_PEER_TO_PEER_ALL_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), NETSUKUKU_TYPE_PEER_TO_PEER_ALL))
#define NETSUKUKU_PEER_TO_PEER_ALL_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), NETSUKUKU_TYPE_PEER_TO_PEER_ALL, NetsukukuPeerToPeerAllClass))

typedef struct _NetsukukuPeerToPeerAll NetsukukuPeerToPeerAll;
typedef struct _NetsukukuPeerToPeerAllClass NetsukukuPeerToPeerAllClass;

#define NETSUKUKU_TYPE_ANDNA (netsukuku_andna_get_type ())
#define NETSUKUKU_ANDNA(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), NETSUKUKU_TYPE_ANDNA, NetsukukuAndna))
#define NETSUKUKU_ANDNA_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), NETSUKUKU_TYPE_ANDNA, NetsukukuAndnaClass))
#define NETSUKUKU_IS_ANDNA(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), NETSUKUKU_TYPE_ANDNA))
#define NETSUKUKU_IS_ANDNA_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), NETSUKUKU_TYPE_ANDNA))
#define NETSUKUKU_ANDNA_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), NETSUKUKU_TYPE_ANDNA, NetsukukuAndnaClass))

typedef struct _NetsukukuAndna NetsukukuAndna;
typedef struct _NetsukukuAndnaClass NetsukukuAndnaClass;

#define NETSUKUKU_TYPE_KEY_PAIR (netsukuku_key_pair_get_type ())
#define NETSUKUKU_KEY_PAIR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), NETSUKUKU_TYPE_KEY_PAIR, NetsukukuKeyPair))
#define NETSUKUKU_KEY_PAIR_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), NETSUKUKU_TYPE_KEY_PAIR, NetsukukuKeyPairClass))
#define NETSUKUKU_IS_KEY_PAIR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), NETSUKUKU_TYPE_KEY_PAIR))
#define NETSUKUKU_IS_KEY_PAIR_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), NETSUKUKU_TYPE_KEY_PAIR))
#define NETSUKUKU_KEY_PAIR_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), NETSUKUKU_TYPE_KEY_PAIR, NetsukukuKeyPairClass))

typedef struct _NetsukukuKeyPair NetsukukuKeyPair;
typedef struct _NetsukukuKeyPairClass NetsukukuKeyPairClass;

#define NETSUKUKU_TYPE_PUBLIC_KEY_WRAPPER (netsukuku_public_key_wrapper_get_type ())
#define NETSUKUKU_PUBLIC_KEY_WRAPPER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), NETSUKUKU_TYPE_PUBLIC_KEY_WRAPPER, NetsukukuPublicKeyWrapper))
#define NETSUKUKU_PUBLIC_KEY_WRAPPER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), NETSUKUKU_TYPE_PUBLIC_KEY_WRAPPER, NetsukukuPublicKeyWrapperClass))
#define NETSUKUKU_IS_PUBLIC_KEY_WRAPPER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), NETSUKUKU_TYPE_PUBLIC_KEY_WRAPPER))
#define NETSUKUKU_IS_PUBLIC_KEY_WRAPPER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), NETSUKUKU_TYPE_PUBLIC_KEY_WRAPPER))
#define NETSUKUKU_PUBLIC_KEY_WRAPPER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), NETSUKUKU_TYPE_PUBLIC_KEY_WRAPPER, NetsukukuPublicKeyWrapperClass))

typedef struct _NetsukukuPublicKeyWrapper NetsukukuPublicKeyWrapper;
typedef struct _NetsukukuPublicKeyWrapperClass NetsukukuPublicKeyWrapperClass;
typedef struct _Block5Data Block5Data;
#define _g_string_free0(var) ((var == NULL) ? NULL : (var = (g_string_free (var, TRUE), NULL)))
#define _vala_assert(expr, msg) if G_LIKELY (expr) ; else g_assertion_message_expr (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);

struct _NetsukukuICounterAsPeerIface {
	GTypeInterface parent_iface;
	NetsukukuCounterSetDataResponse* (*set_data_for_pubk) (NetsukukuICounterAsPeer* self, NetsukukuNIP* nip, GeeList* hashed_domains, NetsukukuPublicKey* pubkey, zcdSerializableBuffer* signature, gboolean replicate, GError** error);
	NetsukukuCounterCheckHostnameResponse* (*check_hostname) (NetsukukuICounterAsPeer* self, NetsukukuNIP* nip, const gchar* hashed_domain, NetsukukuPublicKey* pubkey, GError** error);
	NetsukukuCounterNipRecord* (*get_hostnames) (NetsukukuICounterAsPeer* self, NetsukukuNIP* nip, GError** error);
	NetsukukuCounterGetCacheRecordsResponse* (*get_cache_records) (NetsukukuICounterAsPeer* self, GError** error);
};

struct _NetsukukuRmtPeer {
	GObject parent_instance;
	NetsukukuRmtPeerPrivate * priv;
};

struct _NetsukukuRmtPeerClass {
	GObjectClass parent_class;
	zcdISerializable* (*rmt) (NetsukukuRmtPeer* self, zcdRemoteCall* data, GError** error);
};

struct _NetsukukuRmtCounterPeer {
	NetsukukuRmtPeer parent_instance;
	NetsukukuRmtCounterPeerPrivate * priv;
};

struct _NetsukukuRmtCounterPeerClass {
	NetsukukuRmtPeerClass parent_class;
};

struct _NetsukukuArgumentsForDuplicationSetData {
	GObject parent_instance;
	NetsukukuArgumentsForDuplicationSetDataPrivate * priv;
	NetsukukuNIP* nip;
	GeeList* hashed_domains;
	NetsukukuPublicKey* pubkey;
	zcdSerializableBuffer* signature;
	NetsukukuNIP* hashnode;
};

struct _NetsukukuArgumentsForDuplicationSetDataClass {
	GObjectClass parent_class;
};

struct _Netsukukustruct_helper_Counter_hook_to_service {
	NetsukukuCounter* self;
};

struct _Netsukukustruct_helper_Counter_reset_my_counter_node {
	NetsukukuCounter* self;
};

struct _NetsukukuPeerToPeer {
	zcdRPCDispatcher parent_instance;
	NetsukukuPeerToPeerPrivate * priv;
	NetsukukuMapRoute* maproute;
	NetsukukuAggregatedNeighbourManager* aggregated_neighbour_manager;
	gint pid;
	gboolean has_valid_map;
};

struct _NetsukukuPeerToPeerClass {
	zcdRPCDispatcherClass parent_class;
	void (*start_operations) (NetsukukuPeerToPeer* self);
	void (*stop_operations) (NetsukukuPeerToPeer* self);
	gboolean (*is_participant) (NetsukukuPeerToPeer* self, gint lvl, gint pos);
	NetsukukuNIP* (*h) (NetsukukuPeerToPeer* self, GObject* key);
};

struct _NetsukukuOptionalPeerToPeer {
	NetsukukuPeerToPeer parent_instance;
	NetsukukuOptionalPeerToPeerPrivate * priv;
	NetsukukuMapPeerToPeer* map_peer_to_peer;
	gboolean will_participate;
};

struct _NetsukukuOptionalPeerToPeerClass {
	NetsukukuPeerToPeerClass parent_class;
};

struct _NetsukukuCounter {
	NetsukukuOptionalPeerToPeer parent_instance;
	NetsukukuCounterPrivate * priv;
};

struct _NetsukukuCounterClass {
	NetsukukuOptionalPeerToPeerClass parent_class;
	NetsukukuIAddressManagerRootDispatcher* (*contact_registrar) (NetsukukuCounter* self, const gchar* registrar_address);
};

struct _NetsukukuCounterPrivate {
	GeeArrayList* _hashednames;
	NetsukukuPeerToPeerAll* peer_to_peer_all;
	gboolean hooked_to_service;
	TaskletsTasklet* reset_my_counter_node_tasklet;
	NetsukukuAndna* _andna;
	NetsukukuKeyPair* my_keys;
	NetsukukuPublicKey* pubk;
	GeeHashMap* cache;
};

typedef enum  {
	NETSUKUKU_PEER_TO_PEER_ERROR_REGISTER,
	NETSUKUKU_PEER_TO_PEER_ERROR_GENERIC
} NetsukukuPeerToPeerError;
#define NETSUKUKU_PEER_TO_PEER_ERROR netsukuku_peer_to_peer_error_quark ()
typedef enum  {
	NETSUKUKU_CRYPTO_GCRYPT_ERROR_FAILED
} NetsukukuCryptoGCryptError;
#define NETSUKUKU_CRYPTO_GCRYPT_ERROR netsukuku_crypto_gcrypt_error_quark ()
struct _Block5Data {
	int _ref_count_;
	NetsukukuCounter * self;
	gchar* response_msg;
	NetsukukuTimeCapsule* response_ttl;
	NetsukukuNIP* nip;
	GeeList* hashed_domains;
	NetsukukuPublicKey* pubkey;
	zcdSerializableBuffer* signature;
};

typedef gboolean (*NetsukukuAcceptRecordCallback) (void* user_data, GError** error);
typedef void (*NetsukukuForwardRecordCallback) (GObject* obj1, GeeList* replica_nodes, void* user_data, GError** error);
typedef void (*NetsukukuRefuseRecordCallback) (void* user_data, GError** error);

static gpointer netsukuku_rmt_counter_peer_parent_class = NULL;
static NetsukukuICounterAsPeerIface* netsukuku_rmt_counter_peer_netsukuku_icounter_as_peer_parent_iface = NULL;
static gpointer netsukuku_arguments_for_duplication_set_data_parent_class = NULL;
static gpointer netsukuku_counter_parent_class = NULL;
static NetsukukuICounterAsPeerIface* netsukuku_counter_netsukuku_icounter_as_peer_parent_iface = NULL;

GType netsukuku_icounter_as_peer_get_type (void) G_GNUC_CONST;
NetsukukuCounterSetDataResponse* netsukuku_icounter_as_peer_set_data_for_pubk (NetsukukuICounterAsPeer* self, NetsukukuNIP* nip, GeeList* hashed_domains, NetsukukuPublicKey* pubkey, zcdSerializableBuffer* signature, gboolean replicate, GError** error);
NetsukukuCounterCheckHostnameResponse* netsukuku_icounter_as_peer_check_hostname (NetsukukuICounterAsPeer* self, NetsukukuNIP* nip, const gchar* hashed_domain, NetsukukuPublicKey* pubkey, GError** error);
NetsukukuCounterNipRecord* netsukuku_icounter_as_peer_get_hostnames (NetsukukuICounterAsPeer* self, NetsukukuNIP* nip, GError** error);
NetsukukuCounterGetCacheRecordsResponse* netsukuku_icounter_as_peer_get_cache_records (NetsukukuICounterAsPeer* self, GError** error);
GType netsukuku_rmt_peer_get_type (void) G_GNUC_CONST;
GType netsukuku_rmt_counter_peer_get_type (void) G_GNUC_CONST;
enum  {
	NETSUKUKU_RMT_COUNTER_PEER_DUMMY_PROPERTY
};
GType netsukuku_peer_to_peer_get_type (void) G_GNUC_CONST;
GType netsukuku_aggregated_neighbour_get_type (void) G_GNUC_CONST;
NetsukukuRmtCounterPeer* netsukuku_rmt_counter_peer_new (NetsukukuPeerToPeer* peer_to_peer_service, GObject* key, NetsukukuNIP* hIP, NetsukukuAggregatedNeighbour* aggregated_neighbour);
NetsukukuRmtCounterPeer* netsukuku_rmt_counter_peer_construct (GType object_type, NetsukukuPeerToPeer* peer_to_peer_service, GObject* key, NetsukukuNIP* hIP, NetsukukuAggregatedNeighbour* aggregated_neighbour);
NetsukukuRmtPeer* netsukuku_rmt_peer_construct (GType object_type, NetsukukuPeerToPeer* peer_to_peer_service, GObject* key, NetsukukuNIP* hIP, NetsukukuAggregatedNeighbour* aggregated_neighbour);
static NetsukukuCounterSetDataResponse* netsukuku_rmt_counter_peer_real_set_data_for_pubk (NetsukukuICounterAsPeer* base, NetsukukuNIP* nip, GeeList* hashed_domains, NetsukukuPublicKey* pubkey, zcdSerializableBuffer* signature, gboolean replicate, GError** error);
zcdISerializable* netsukuku_rmt_peer_rmt (NetsukukuRmtPeer* self, zcdRemoteCall* data, GError** error);
static NetsukukuCounterCheckHostnameResponse* netsukuku_rmt_counter_peer_real_check_hostname (NetsukukuICounterAsPeer* base, NetsukukuNIP* nip, const gchar* hashed_domain, NetsukukuPublicKey* pubkey, GError** error);
static NetsukukuCounterNipRecord* netsukuku_rmt_counter_peer_real_get_hostnames (NetsukukuICounterAsPeer* base, NetsukukuNIP* nip, GError** error);
static NetsukukuCounterGetCacheRecordsResponse* netsukuku_rmt_counter_peer_real_get_cache_records (NetsukukuICounterAsPeer* base, GError** error);
GType netsukuku_arguments_for_duplication_set_data_get_type (void) G_GNUC_CONST;
enum  {
	NETSUKUKU_ARGUMENTS_FOR_DUPLICATION_SET_DATA_DUMMY_PROPERTY
};
NetsukukuArgumentsForDuplicationSetData* netsukuku_arguments_for_duplication_set_data_new (void);
NetsukukuArgumentsForDuplicationSetData* netsukuku_arguments_for_duplication_set_data_construct (GType object_type);
static void netsukuku_arguments_for_duplication_set_data_finalize (GObject* obj);
GType netsukuku_struct_helper_counter_hook_to_service_get_type (void) G_GNUC_CONST;
GType netsukuku_optional_peer_to_peer_get_type (void) G_GNUC_CONST;
GType netsukuku_counter_get_type (void) G_GNUC_CONST;
Netsukukustruct_helper_Counter_hook_to_service* netsukuku_struct_helper_counter_hook_to_service_dup (const Netsukukustruct_helper_Counter_hook_to_service* self);
void netsukuku_struct_helper_counter_hook_to_service_free (Netsukukustruct_helper_Counter_hook_to_service* self);
void netsukuku_struct_helper_counter_hook_to_service_copy (const Netsukukustruct_helper_Counter_hook_to_service* self, Netsukukustruct_helper_Counter_hook_to_service* dest);
void netsukuku_struct_helper_counter_hook_to_service_destroy (Netsukukustruct_helper_Counter_hook_to_service* self);
GType netsukuku_struct_helper_counter_reset_my_counter_node_get_type (void) G_GNUC_CONST;
Netsukukustruct_helper_Counter_reset_my_counter_node* netsukuku_struct_helper_counter_reset_my_counter_node_dup (const Netsukukustruct_helper_Counter_reset_my_counter_node* self);
void netsukuku_struct_helper_counter_reset_my_counter_node_free (Netsukukustruct_helper_Counter_reset_my_counter_node* self);
void netsukuku_struct_helper_counter_reset_my_counter_node_copy (const Netsukukustruct_helper_Counter_reset_my_counter_node* self, Netsukukustruct_helper_Counter_reset_my_counter_node* dest);
void netsukuku_struct_helper_counter_reset_my_counter_node_destroy (Netsukukustruct_helper_Counter_reset_my_counter_node* self);
GType netsukuku_map_get_type (void) G_GNUC_CONST;
GType netsukuku_map_route_get_type (void) G_GNUC_CONST;
GType netsukuku_aggregated_neighbour_manager_get_type (void) G_GNUC_CONST;
GType netsukuku_map_peer_to_peer_get_type (void) G_GNUC_CONST;
GType netsukuku_peer_to_peer_all_get_type (void) G_GNUC_CONST;
GType netsukuku_andna_get_type (void) G_GNUC_CONST;
GType netsukuku_key_pair_get_type (void) G_GNUC_CONST;
#define NETSUKUKU_COUNTER_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), NETSUKUKU_TYPE_COUNTER, NetsukukuCounterPrivate))
enum  {
	NETSUKUKU_COUNTER_DUMMY_PROPERTY,
	NETSUKUKU_COUNTER_ANDNA
};
#define NETSUKUKU_COUNTER_mypid 2
NetsukukuCounter* netsukuku_counter_new (NetsukukuKeyPair* keypair, NetsukukuAggregatedNeighbourManager* aggregated_neighbour_manager, NetsukukuMapRoute* maproute, NetsukukuPeerToPeerAll* peer_to_peer_all);
NetsukukuCounter* netsukuku_counter_construct (GType object_type, NetsukukuKeyPair* keypair, NetsukukuAggregatedNeighbourManager* aggregated_neighbour_manager, NetsukukuMapRoute* maproute, NetsukukuPeerToPeerAll* peer_to_peer_all);
NetsukukuOptionalPeerToPeer* netsukuku_optional_peer_to_peer_new (NetsukukuAggregatedNeighbourManager* aggregated_neighbour_manager, NetsukukuMapRoute* maproute, gint pid);
NetsukukuOptionalPeerToPeer* netsukuku_optional_peer_to_peer_construct (GType object_type, NetsukukuAggregatedNeighbourManager* aggregated_neighbour_manager, NetsukukuMapRoute* maproute, gint pid);
GType netsukuku_public_key_wrapper_get_type (void) G_GNUC_CONST;
NetsukukuPublicKeyWrapper* netsukuku_key_pair_get_pub_key (NetsukukuKeyPair* self);
NetsukukuPublicKey* netsukuku_public_key_wrapper_to_pubkey (NetsukukuPublicKeyWrapper* self);
GQuark netsukuku_peer_to_peer_error_quark (void);
void netsukuku_peer_to_peer_all_peer_to_peer_register (NetsukukuPeerToPeerAll* self, NetsukukuPeerToPeer* peer_to_peer, GError** error);
void netsukuku_counter_hook_to_service (NetsukukuCounter* self);
static void _netsukuku_counter_hook_to_service_netsukuku_peer_to_peer_map_peer_to_peer_validated (NetsukukuPeerToPeer* _sender, gpointer self);
static guint _netsukuku_pair_public_key_nip_hash_func_gee_hash_data_func (gconstpointer v, gpointer self);
static gboolean _netsukuku_pair_public_key_nip_equal_func_gee_equal_data_func (gconstpointer a, gconstpointer b, gpointer self);
NetsukukuRmtCounterPeer* netsukuku_counter_peer (NetsukukuCounter* self, NetsukukuNIP* hIP, GObject* key, NetsukukuAggregatedNeighbour* aggregated_neighbour);
static zcdISerializable* netsukuku_counter_real__dispatch (zcdRPCDispatcher* base, GObject* caller, zcdRemoteCall* data, GError** error);
void netsukuku_log_debug (const gchar* msg);
static NetsukukuNIP* netsukuku_counter_nip_for_lvl_pos (NetsukukuCounter* self, gint lvl, gint pos);
NetsukukuNIP* netsukuku_map_get_me (NetsukukuMap* self);
static void netsukuku_counter_impl_hook_to_service (NetsukukuCounter* self, GError** error);
gint netsukuku_map_get_levels (NetsukukuMap* self);
void netsukuku_peer_to_peer_find_hook_peers (NetsukukuPeerToPeer* self, gint** ret_first_forward, gint** ret_first_back, gint** ret_last_back, gint lvl, gint num_dupl, gint timeout);
#define NETSUKUKU_COUNTER_DUPLICATION 10
static gboolean _int_equal (const gint* s1, const gint* s2);
NetsukukuNIP* netsukuku_peer_to_peer_h (NetsukukuPeerToPeer* self, GObject* key);
GeeList* netsukuku_peer_to_peer_list_ids (NetsukukuPeerToPeer* self, gint center, gint sign);
void netsukuku_optional_peer_to_peer_participate (NetsukukuOptionalPeerToPeer* self);
void netsukuku_log_info (const gchar* msg);
static void* netsukuku_counter_helper_hook_to_service (void* v, GError** error);
static NetsukukuNIP* netsukuku_counter_real_h (NetsukukuPeerToPeer* base, GObject* key);
GQuark netsukuku_crypto_gcrypt_error_quark (void);
guint8* netsukuku_crypto_md5 (guint8* buffer, int buffer_length1, int* result_length1, GError** error);
gint netsukuku_map_get_gsize (NetsukukuMap* self);
static void netsukuku_counter_impl_reset_my_counter_node (NetsukukuCounter* self, GError** error);
static NetsukukuCounterSetDataResponse* netsukuku_counter_ask_set_data_for_pubk (NetsukukuCounter* self);
#define NETSUKUKU_MAX_WAIT_REFRESH_COUNTER ((((gint64) 1000) * ((gint64) 60)) * ((gint64) 60))
static void* netsukuku_counter_helper_reset_my_counter_node (void* v, GError** error);
void netsukuku_counter_reset_my_counter_node (NetsukukuCounter* self);
void netsukuku_counter_stop_reset_my_counter_node (NetsukukuCounter* self);
gboolean netsukuku_counter_reset_my_counter_node_ongoing (NetsukukuCounter* self);
static zcdSerializableBuffer* _netsukuku_counter_sign (NetsukukuCounter* self, GeeList* hashed_domains);
static GeeArrayList* netsukuku_counter_get_hashednames (NetsukukuCounter* self);
guchar* netsukuku_key_pair_sign (NetsukukuKeyPair* self, guchar* msg, int msg_length1, int* result_length1, GError** error);
guchar* netsukuku_counter_utilities_prepare_msg (NetsukukuNIP* nip, GeeList* hashed_domains, int* result_length1);
static gboolean _netsukuku_counter_verify (NetsukukuCounter* self, NetsukukuNIP* nip, GeeList* hashed_domains, NetsukukuPublicKey* pubk, zcdSerializableBuffer* signature);
NetsukukuPublicKeyWrapper* netsukuku_public_key_wrapper_new_from_pubk (NetsukukuPublicKey* from_pubk, GError** error);
NetsukukuPublicKeyWrapper* netsukuku_public_key_wrapper_construct_from_pubk (GType object_type, NetsukukuPublicKey* from_pubk, GError** error);
gboolean netsukuku_public_key_wrapper_verify (NetsukukuPublicKeyWrapper* self, guchar* msg, int msg_length1, guchar* signature, int signature_length1, GError** error);
NetsukukuCounterCheckHostnameResponse* netsukuku_counter_ask_check_hostname (NetsukukuCounter* self, NetsukukuNIP* nip, const gchar* hashed_domain, NetsukukuPublicKey* pubkey, GError** error);
NetsukukuCounterNipRecord* netsukuku_counter_ask_get_hostnames (NetsukukuCounter* self, NetsukukuNIP* nip);
static void netsukuku_counter_str_debug_cache (NetsukukuCounter* self);
void netsukuku_counter_check_expirations_cache (NetsukukuCounter* self);
NetsukukuIAddressManagerRootDispatcher* netsukuku_counter_contact_registrar (NetsukukuCounter* self, const gchar* registrar_address);
static NetsukukuIAddressManagerRootDispatcher* netsukuku_counter_real_contact_registrar (NetsukukuCounter* self, const gchar* registrar_address);
static NetsukukuCounterSetDataResponse* netsukuku_counter_real_set_data_for_pubk (NetsukukuICounterAsPeer* base, NetsukukuNIP* nip, GeeList* hashed_domains, NetsukukuPublicKey* pubkey, zcdSerializableBuffer* signature, gboolean replicate, GError** error);
static Block5Data* block5_data_ref (Block5Data* _data5_);
static void block5_data_unref (void * _userdata_);
void netsukuku_check_hash_and_start_replica (NetsukukuPeerToPeer* service, NetsukukuNIP* hash_nip, gboolean replicate, GObject* obj1, gint replica_nodes_max, NetsukukuAcceptRecordCallback accept_callback, void* accept_callback_target, NetsukukuForwardRecordCallback forward_callback, void* forward_callback_target, NetsukukuRefuseRecordCallback refuse_callback, void* refuse_callback_target, GError** error);
static gboolean __lambda14_ (Block5Data* _data5_, GError** error);
#define NETSUKUKU_MAX_HOSTNAMES 256
gchar* netsukuku_nip_to_str (gint levels, gint gsize, NetsukukuNIP* nip);
#define NETSUKUKU_MAX_TTL_COUNTER ((((((gint64) 1000) * ((gint64) 60)) * ((gint64) 60)) * ((gint64) 24)) * ((gint64) 30))
static gboolean ___lambda14__netsukuku_accept_record_callback (gpointer self, GError** error);
static void __lambda15_ (NetsukukuCounter* self, GObject* tasklet_obj1, GeeList* tasklet_replica_nodes, GError** error);
GeeList* netsukuku_peer_to_peer_find_nearest_to_register (NetsukukuPeerToPeer* self, NetsukukuNIP* hash_nip, gint num_dupl, gint* inside_gnode_level, GError** error);
static void _____lambda16_ (NetsukukuCounter* self, GObject* tpar1, GObject* tpar2, GError** error);
void netsukuku_log_warn (const gchar* msg);
static void ______lambda16__tasklets_tasklet_callback (GObject* obj1, GObject* obj2, GObject* obj3, GObject* obj4, gpointer self, GError** error);
static void ___lambda15__netsukuku_forward_record_callback (GObject* obj1, GeeList* replica_nodes, gpointer self, GError** error);
static NetsukukuCounterCheckHostnameResponse* netsukuku_counter_real_check_hostname (NetsukukuICounterAsPeer* base, NetsukukuNIP* nip, const gchar* hashed_domain, NetsukukuPublicKey* pubkey, GError** error);
NetsukukuHCoord* netsukuku_peer_to_peer_search_participant (NetsukukuPeerToPeer* self, NetsukukuNIP* hIP, gint path_sign, GError** error);
static NetsukukuCounterNipRecord* netsukuku_counter_real_get_hostnames (NetsukukuICounterAsPeer* base, NetsukukuNIP* nip, GError** error);
static NetsukukuCounterGetCacheRecordsResponse* netsukuku_counter_real_get_cache_records (NetsukukuICounterAsPeer* base, GError** error);
gchar* netsukuku_andna_crypto_hash (const gchar* hostname);
static NetsukukuAndna* netsukuku_counter_get_andna (NetsukukuCounter* self);
void netsukuku_counter_set_andna (NetsukukuCounter* self, NetsukukuAndna* value);
static void netsukuku_counter_finalize (GObject* obj);
static void _vala_netsukuku_counter_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void _vala_netsukuku_counter_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);
static gint _vala_array_length (gpointer array);


NetsukukuCounterSetDataResponse* netsukuku_icounter_as_peer_set_data_for_pubk (NetsukukuICounterAsPeer* self, NetsukukuNIP* nip, GeeList* hashed_domains, NetsukukuPublicKey* pubkey, zcdSerializableBuffer* signature, gboolean replicate, GError** error) {
	g_return_val_if_fail (self != NULL, NULL);
	return NETSUKUKU_ICOUNTER_AS_PEER_GET_INTERFACE (self)->set_data_for_pubk (self, nip, hashed_domains, pubkey, signature, replicate, error);
}


NetsukukuCounterCheckHostnameResponse* netsukuku_icounter_as_peer_check_hostname (NetsukukuICounterAsPeer* self, NetsukukuNIP* nip, const gchar* hashed_domain, NetsukukuPublicKey* pubkey, GError** error) {
	g_return_val_if_fail (self != NULL, NULL);
	return NETSUKUKU_ICOUNTER_AS_PEER_GET_INTERFACE (self)->check_hostname (self, nip, hashed_domain, pubkey, error);
}


NetsukukuCounterNipRecord* netsukuku_icounter_as_peer_get_hostnames (NetsukukuICounterAsPeer* self, NetsukukuNIP* nip, GError** error) {
	g_return_val_if_fail (self != NULL, NULL);
	return NETSUKUKU_ICOUNTER_AS_PEER_GET_INTERFACE (self)->get_hostnames (self, nip, error);
}


NetsukukuCounterGetCacheRecordsResponse* netsukuku_icounter_as_peer_get_cache_records (NetsukukuICounterAsPeer* self, GError** error) {
	g_return_val_if_fail (self != NULL, NULL);
	return NETSUKUKU_ICOUNTER_AS_PEER_GET_INTERFACE (self)->get_cache_records (self, error);
}


static void netsukuku_icounter_as_peer_base_init (NetsukukuICounterAsPeerIface * iface) {
	static gboolean initialized = FALSE;
	if (!initialized) {
		initialized = TRUE;
	}
}


GType netsukuku_icounter_as_peer_get_type (void) {
	static volatile gsize netsukuku_icounter_as_peer_type_id__volatile = 0;
	if (g_once_init_enter (&netsukuku_icounter_as_peer_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (NetsukukuICounterAsPeerIface), (GBaseInitFunc) netsukuku_icounter_as_peer_base_init, (GBaseFinalizeFunc) NULL, (GClassInitFunc) NULL, (GClassFinalizeFunc) NULL, NULL, 0, 0, (GInstanceInitFunc) NULL, NULL };
		GType netsukuku_icounter_as_peer_type_id;
		netsukuku_icounter_as_peer_type_id = g_type_register_static (G_TYPE_INTERFACE, "NetsukukuICounterAsPeer", &g_define_type_info, 0);
		g_type_interface_add_prerequisite (netsukuku_icounter_as_peer_type_id, G_TYPE_OBJECT);
		g_once_init_leave (&netsukuku_icounter_as_peer_type_id__volatile, netsukuku_icounter_as_peer_type_id);
	}
	return netsukuku_icounter_as_peer_type_id__volatile;
}


NetsukukuRmtCounterPeer* netsukuku_rmt_counter_peer_construct (GType object_type, NetsukukuPeerToPeer* peer_to_peer_service, GObject* key, NetsukukuNIP* hIP, NetsukukuAggregatedNeighbour* aggregated_neighbour) {
	NetsukukuRmtCounterPeer * self = NULL;
	NetsukukuPeerToPeer* _tmp0_;
	GObject* _tmp1_;
	NetsukukuNIP* _tmp2_;
	NetsukukuAggregatedNeighbour* _tmp3_;
	g_return_val_if_fail (peer_to_peer_service != NULL, NULL);
	_tmp0_ = peer_to_peer_service;
	_tmp1_ = key;
	_tmp2_ = hIP;
	_tmp3_ = aggregated_neighbour;
	self = (NetsukukuRmtCounterPeer*) netsukuku_rmt_peer_construct (object_type, _tmp0_, _tmp1_, _tmp2_, _tmp3_);
	return self;
}


NetsukukuRmtCounterPeer* netsukuku_rmt_counter_peer_new (NetsukukuPeerToPeer* peer_to_peer_service, GObject* key, NetsukukuNIP* hIP, NetsukukuAggregatedNeighbour* aggregated_neighbour) {
	return netsukuku_rmt_counter_peer_construct (NETSUKUKU_TYPE_RMT_COUNTER_PEER, peer_to_peer_service, key, hIP, aggregated_neighbour);
}


static gpointer _g_error_copy0 (gpointer self) {
	return self ? g_error_copy (self) : NULL;
}


static const gchar* string_to_string (const gchar* self) {
	const gchar* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	result = self;
	return result;
}


static NetsukukuCounterSetDataResponse* netsukuku_rmt_counter_peer_real_set_data_for_pubk (NetsukukuICounterAsPeer* base, NetsukukuNIP* nip, GeeList* hashed_domains, NetsukukuPublicKey* pubkey, zcdSerializableBuffer* signature, gboolean replicate, GError** error) {
	NetsukukuRmtCounterPeer * self;
	NetsukukuCounterSetDataResponse* result = NULL;
	zcdRemoteCall* _tmp0_;
	zcdRemoteCall* rc;
	zcdRemoteCall* _tmp1_;
	gchar* _tmp2_;
	zcdRemoteCall* _tmp3_;
	NetsukukuNIP* _tmp4_;
	GeeList* _tmp5_;
	zcdListString* _tmp6_;
	zcdListString* _hashed_domains;
	zcdRemoteCall* _tmp7_;
	zcdListString* _tmp8_;
	zcdRemoteCall* _tmp9_;
	NetsukukuPublicKey* _tmp10_;
	zcdRemoteCall* _tmp11_;
	zcdSerializableBuffer* _tmp12_;
	zcdRemoteCall* _tmp13_;
	gboolean _tmp14_;
	zcdSerializableBool* _tmp15_;
	zcdSerializableBool* _tmp16_;
	GError * _inner_error_ = NULL;
	self = (NetsukukuRmtCounterPeer*) base;
	g_return_val_if_fail (nip != NULL, NULL);
	g_return_val_if_fail (hashed_domains != NULL, NULL);
	g_return_val_if_fail (pubkey != NULL, NULL);
	g_return_val_if_fail (signature != NULL, NULL);
	_tmp0_ = zcd_remote_call_new ();
	rc = _tmp0_;
	_tmp1_ = rc;
	_tmp2_ = g_strdup ("set_data_for_pubk");
	_g_free0 (_tmp1_->method_name);
	_tmp1_->method_name = _tmp2_;
	_tmp3_ = rc;
	_tmp4_ = nip;
	zcd_remote_call_add_parameter (_tmp3_, (zcdISerializable*) _tmp4_);
	_tmp5_ = hashed_domains;
	_tmp6_ = zcd_list_string_new_with_backer (_tmp5_);
	_hashed_domains = _tmp6_;
	_tmp7_ = rc;
	_tmp8_ = _hashed_domains;
	zcd_remote_call_add_parameter (_tmp7_, (zcdISerializable*) _tmp8_);
	_tmp9_ = rc;
	_tmp10_ = pubkey;
	zcd_remote_call_add_parameter (_tmp9_, (zcdISerializable*) _tmp10_);
	_tmp11_ = rc;
	_tmp12_ = signature;
	zcd_remote_call_add_parameter (_tmp11_, (zcdISerializable*) _tmp12_);
	_tmp13_ = rc;
	_tmp14_ = replicate;
	_tmp15_ = zcd_serializable_bool_new (_tmp14_);
	_tmp16_ = _tmp15_;
	zcd_remote_call_add_parameter (_tmp13_, (zcdISerializable*) _tmp16_);
	_g_object_unref0 (_tmp16_);
	{
		zcdRemoteCall* _tmp17_;
		zcdISerializable* _tmp18_ = NULL;
		zcdISerializable* _tmp19_;
		zcdISerializable* _tmp20_;
		zcdISerializable* _tmp21_ = NULL;
		zcdISerializable* _tmp22_;
		zcdISerializable* _tmp23_;
		zcdISerializable* _tmp24_;
		zcdISerializable* _tmp25_ = NULL;
		zcdISerializable* _tmp26_;
		zcdISerializable* _tmp27_;
		_tmp17_ = rc;
		_tmp18_ = netsukuku_rmt_peer_rmt ((NetsukukuRmtPeer*) self, _tmp17_, &_inner_error_);
		_tmp19_ = _tmp18_;
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == ZCD_RPC_ERROR) {
				goto __catch38_zcd_rpc_error;
			}
			goto __catch38_g_error;
		}
		_tmp20_ = _tmp19_;
		_tmp21_ = netsukuku_filter_exception_PeerRefuseServiceError (_tmp20_, &_inner_error_);
		_tmp22_ = _tmp21_;
		_g_object_unref0 (_tmp20_);
		_tmp23_ = _tmp22_;
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == ZCD_RPC_ERROR) {
				goto __catch38_zcd_rpc_error;
			}
			goto __catch38_g_error;
		}
		_tmp24_ = _tmp23_;
		_tmp25_ = zcd_filter_exception (_tmp24_, &_inner_error_);
		_tmp26_ = _tmp25_;
		_g_object_unref0 (_tmp24_);
		_tmp27_ = _tmp26_;
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == ZCD_RPC_ERROR) {
				goto __catch38_zcd_rpc_error;
			}
			goto __catch38_g_error;
		}
		result = G_TYPE_CHECK_INSTANCE_CAST (_tmp27_, NETSUKUKU_TYPE_COUNTER_SET_DATA_RESPONSE, NetsukukuCounterSetDataResponse);
		_g_object_unref0 (_hashed_domains);
		_g_object_unref0 (rc);
		return result;
	}
	goto __finally38;
	__catch38_zcd_rpc_error:
	{
		GError* e = NULL;
		GError* _tmp28_;
		GError* _tmp29_;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp28_ = e;
		_tmp29_ = _g_error_copy0 (_tmp28_);
		_inner_error_ = _tmp29_;
		_g_error_free0 (e);
		goto __finally38;
	}
	goto __finally38;
	__catch38_g_error:
	{
		GError* e = NULL;
		GError* _tmp30_;
		GQuark _tmp31_;
		const gchar* _tmp32_ = NULL;
		GError* _tmp33_;
		gint _tmp34_;
		gchar* _tmp35_ = NULL;
		gchar* _tmp36_;
		GError* _tmp37_;
		const gchar* _tmp38_;
		const gchar* _tmp39_ = NULL;
		gchar* _tmp40_ = NULL;
		gchar* _tmp41_;
		GError* _tmp42_;
		GError* _tmp43_;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp30_ = e;
		_tmp31_ = _tmp30_->domain;
		_tmp32_ = g_quark_to_string (_tmp31_);
		_tmp33_ = e;
		_tmp34_ = _tmp33_->code;
		_tmp35_ = g_strdup_printf ("%i", _tmp34_);
		_tmp36_ = _tmp35_;
		_tmp37_ = e;
		_tmp38_ = _tmp37_->message;
		_tmp39_ = string_to_string (_tmp38_);
		_tmp40_ = g_strconcat ("Unexpected error ", _tmp32_, ".", _tmp36_, " '", _tmp39_, "'", NULL);
		_tmp41_ = _tmp40_;
		_tmp42_ = g_error_new_literal (ZCD_RPC_ERROR, ZCD_RPC_ERROR_GENERIC, _tmp41_);
		_tmp43_ = _tmp42_;
		_g_free0 (_tmp41_);
		_g_free0 (_tmp36_);
		_inner_error_ = _tmp43_;
		_g_error_free0 (e);
		goto __finally38;
	}
	__finally38:
	if ((_inner_error_->domain == ZCD_RPC_ERROR) || (_inner_error_->domain == NETSUKUKU_PEER_REFUSE_SERVICE_ERROR)) {
		g_propagate_error (error, _inner_error_);
		_g_object_unref0 (_hashed_domains);
		_g_object_unref0 (rc);
		return NULL;
	} else {
		_g_object_unref0 (_hashed_domains);
		_g_object_unref0 (rc);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return NULL;
	}
	_g_object_unref0 (_hashed_domains);
	_g_object_unref0 (rc);
}


static NetsukukuCounterCheckHostnameResponse* netsukuku_rmt_counter_peer_real_check_hostname (NetsukukuICounterAsPeer* base, NetsukukuNIP* nip, const gchar* hashed_domain, NetsukukuPublicKey* pubkey, GError** error) {
	NetsukukuRmtCounterPeer * self;
	NetsukukuCounterCheckHostnameResponse* result = NULL;
	zcdRemoteCall* _tmp0_;
	zcdRemoteCall* rc;
	zcdRemoteCall* _tmp1_;
	gchar* _tmp2_;
	zcdRemoteCall* _tmp3_;
	NetsukukuNIP* _tmp4_;
	zcdRemoteCall* _tmp5_;
	const gchar* _tmp6_;
	zcdSerializableString* _tmp7_;
	zcdSerializableString* _tmp8_;
	zcdRemoteCall* _tmp9_;
	NetsukukuPublicKey* _tmp10_;
	GError * _inner_error_ = NULL;
	self = (NetsukukuRmtCounterPeer*) base;
	g_return_val_if_fail (nip != NULL, NULL);
	g_return_val_if_fail (hashed_domain != NULL, NULL);
	g_return_val_if_fail (pubkey != NULL, NULL);
	_tmp0_ = zcd_remote_call_new ();
	rc = _tmp0_;
	_tmp1_ = rc;
	_tmp2_ = g_strdup ("check_hostname");
	_g_free0 (_tmp1_->method_name);
	_tmp1_->method_name = _tmp2_;
	_tmp3_ = rc;
	_tmp4_ = nip;
	zcd_remote_call_add_parameter (_tmp3_, (zcdISerializable*) _tmp4_);
	_tmp5_ = rc;
	_tmp6_ = hashed_domain;
	_tmp7_ = zcd_serializable_string_new (_tmp6_);
	_tmp8_ = _tmp7_;
	zcd_remote_call_add_parameter (_tmp5_, (zcdISerializable*) _tmp8_);
	_g_object_unref0 (_tmp8_);
	_tmp9_ = rc;
	_tmp10_ = pubkey;
	zcd_remote_call_add_parameter (_tmp9_, (zcdISerializable*) _tmp10_);
	{
		zcdRemoteCall* _tmp11_;
		zcdISerializable* _tmp12_ = NULL;
		zcdISerializable* _tmp13_;
		zcdISerializable* _tmp14_;
		zcdISerializable* _tmp15_ = NULL;
		zcdISerializable* _tmp16_;
		zcdISerializable* _tmp17_;
		zcdISerializable* _tmp18_;
		zcdISerializable* _tmp19_ = NULL;
		zcdISerializable* _tmp20_;
		zcdISerializable* _tmp21_;
		_tmp11_ = rc;
		_tmp12_ = netsukuku_rmt_peer_rmt ((NetsukukuRmtPeer*) self, _tmp11_, &_inner_error_);
		_tmp13_ = _tmp12_;
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == ZCD_RPC_ERROR) {
				goto __catch39_zcd_rpc_error;
			}
			goto __catch39_g_error;
		}
		_tmp14_ = _tmp13_;
		_tmp15_ = netsukuku_filter_exception_PeerRefuseServiceError (_tmp14_, &_inner_error_);
		_tmp16_ = _tmp15_;
		_g_object_unref0 (_tmp14_);
		_tmp17_ = _tmp16_;
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == ZCD_RPC_ERROR) {
				goto __catch39_zcd_rpc_error;
			}
			goto __catch39_g_error;
		}
		_tmp18_ = _tmp17_;
		_tmp19_ = zcd_filter_exception (_tmp18_, &_inner_error_);
		_tmp20_ = _tmp19_;
		_g_object_unref0 (_tmp18_);
		_tmp21_ = _tmp20_;
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == ZCD_RPC_ERROR) {
				goto __catch39_zcd_rpc_error;
			}
			goto __catch39_g_error;
		}
		result = G_TYPE_CHECK_INSTANCE_CAST (_tmp21_, NETSUKUKU_TYPE_COUNTER_CHECK_HOSTNAME_RESPONSE, NetsukukuCounterCheckHostnameResponse);
		_g_object_unref0 (rc);
		return result;
	}
	goto __finally39;
	__catch39_zcd_rpc_error:
	{
		GError* e = NULL;
		GError* _tmp22_;
		GError* _tmp23_;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp22_ = e;
		_tmp23_ = _g_error_copy0 (_tmp22_);
		_inner_error_ = _tmp23_;
		_g_error_free0 (e);
		goto __finally39;
	}
	goto __finally39;
	__catch39_g_error:
	{
		GError* e = NULL;
		GError* _tmp24_;
		GQuark _tmp25_;
		const gchar* _tmp26_ = NULL;
		GError* _tmp27_;
		gint _tmp28_;
		gchar* _tmp29_ = NULL;
		gchar* _tmp30_;
		GError* _tmp31_;
		const gchar* _tmp32_;
		const gchar* _tmp33_ = NULL;
		gchar* _tmp34_ = NULL;
		gchar* _tmp35_;
		GError* _tmp36_;
		GError* _tmp37_;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp24_ = e;
		_tmp25_ = _tmp24_->domain;
		_tmp26_ = g_quark_to_string (_tmp25_);
		_tmp27_ = e;
		_tmp28_ = _tmp27_->code;
		_tmp29_ = g_strdup_printf ("%i", _tmp28_);
		_tmp30_ = _tmp29_;
		_tmp31_ = e;
		_tmp32_ = _tmp31_->message;
		_tmp33_ = string_to_string (_tmp32_);
		_tmp34_ = g_strconcat ("Unexpected error ", _tmp26_, ".", _tmp30_, " '", _tmp33_, "'", NULL);
		_tmp35_ = _tmp34_;
		_tmp36_ = g_error_new_literal (ZCD_RPC_ERROR, ZCD_RPC_ERROR_GENERIC, _tmp35_);
		_tmp37_ = _tmp36_;
		_g_free0 (_tmp35_);
		_g_free0 (_tmp30_);
		_inner_error_ = _tmp37_;
		_g_error_free0 (e);
		goto __finally39;
	}
	__finally39:
	if ((_inner_error_->domain == ZCD_RPC_ERROR) || (_inner_error_->domain == NETSUKUKU_PEER_REFUSE_SERVICE_ERROR)) {
		g_propagate_error (error, _inner_error_);
		_g_object_unref0 (rc);
		return NULL;
	} else {
		_g_object_unref0 (rc);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return NULL;
	}
	_g_object_unref0 (rc);
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


static NetsukukuCounterNipRecord* netsukuku_rmt_counter_peer_real_get_hostnames (NetsukukuICounterAsPeer* base, NetsukukuNIP* nip, GError** error) {
	NetsukukuRmtCounterPeer * self;
	NetsukukuCounterNipRecord* result = NULL;
	zcdRemoteCall* _tmp0_;
	zcdRemoteCall* rc;
	zcdRemoteCall* _tmp1_;
	gchar* _tmp2_;
	zcdRemoteCall* _tmp3_;
	NetsukukuNIP* _tmp4_;
	GError * _inner_error_ = NULL;
	self = (NetsukukuRmtCounterPeer*) base;
	g_return_val_if_fail (nip != NULL, NULL);
	_tmp0_ = zcd_remote_call_new ();
	rc = _tmp0_;
	_tmp1_ = rc;
	_tmp2_ = g_strdup ("get_hostnames");
	_g_free0 (_tmp1_->method_name);
	_tmp1_->method_name = _tmp2_;
	_tmp3_ = rc;
	_tmp4_ = nip;
	zcd_remote_call_add_parameter (_tmp3_, (zcdISerializable*) _tmp4_);
	{
		zcdRemoteCall* _tmp5_;
		zcdISerializable* _tmp6_ = NULL;
		zcdISerializable* _tmp7_;
		zcdISerializable* _tmp8_;
		zcdISerializable* _tmp9_ = NULL;
		zcdISerializable* _tmp10_;
		zcdISerializable* _tmp11_;
		zcdISerializable* _tmp12_;
		zcdISerializable* _tmp13_ = NULL;
		zcdISerializable* _tmp14_;
		zcdISerializable* ret;
		zcdISerializable* _tmp15_;
		GType _tmp16_ = 0UL;
		gboolean _tmp17_ = FALSE;
		_tmp5_ = rc;
		_tmp6_ = netsukuku_rmt_peer_rmt ((NetsukukuRmtPeer*) self, _tmp5_, &_inner_error_);
		_tmp7_ = _tmp6_;
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == ZCD_RPC_ERROR) {
				goto __catch40_zcd_rpc_error;
			}
			goto __catch40_g_error;
		}
		_tmp8_ = _tmp7_;
		_tmp9_ = netsukuku_filter_exception_PeerRefuseServiceError (_tmp8_, &_inner_error_);
		_tmp10_ = _tmp9_;
		_g_object_unref0 (_tmp8_);
		_tmp11_ = _tmp10_;
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == ZCD_RPC_ERROR) {
				goto __catch40_zcd_rpc_error;
			}
			goto __catch40_g_error;
		}
		_tmp12_ = _tmp11_;
		_tmp13_ = zcd_filter_exception (_tmp12_, &_inner_error_);
		_tmp14_ = _tmp13_;
		_g_object_unref0 (_tmp12_);
		ret = _tmp14_;
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == ZCD_RPC_ERROR) {
				goto __catch40_zcd_rpc_error;
			}
			goto __catch40_g_error;
		}
		_tmp15_ = ret;
		_tmp16_ = G_TYPE_FROM_INSTANCE ((GObject*) _tmp15_);
		_tmp17_ = g_type_is_a (_tmp16_, ZCD_TYPE_SERIALIZABLE_NONE);
		if (_tmp17_) {
			result = NULL;
			_g_object_unref0 (ret);
			_g_object_unref0 (rc);
			return result;
		} else {
			zcdISerializable* _tmp18_;
			NetsukukuCounterNipRecord* _tmp19_;
			_tmp18_ = ret;
			_tmp19_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp18_, NETSUKUKU_TYPE_COUNTER_NIP_RECORD, NetsukukuCounterNipRecord));
			result = _tmp19_;
			_g_object_unref0 (ret);
			_g_object_unref0 (rc);
			return result;
		}
		_g_object_unref0 (ret);
	}
	goto __finally40;
	__catch40_zcd_rpc_error:
	{
		GError* e = NULL;
		GError* _tmp20_;
		GError* _tmp21_;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp20_ = e;
		_tmp21_ = _g_error_copy0 (_tmp20_);
		_inner_error_ = _tmp21_;
		_g_error_free0 (e);
		goto __finally40;
	}
	goto __finally40;
	__catch40_g_error:
	{
		GError* e = NULL;
		GError* _tmp22_;
		GQuark _tmp23_;
		const gchar* _tmp24_ = NULL;
		GError* _tmp25_;
		gint _tmp26_;
		gchar* _tmp27_ = NULL;
		gchar* _tmp28_;
		GError* _tmp29_;
		const gchar* _tmp30_;
		const gchar* _tmp31_ = NULL;
		gchar* _tmp32_ = NULL;
		gchar* _tmp33_;
		GError* _tmp34_;
		GError* _tmp35_;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp22_ = e;
		_tmp23_ = _tmp22_->domain;
		_tmp24_ = g_quark_to_string (_tmp23_);
		_tmp25_ = e;
		_tmp26_ = _tmp25_->code;
		_tmp27_ = g_strdup_printf ("%i", _tmp26_);
		_tmp28_ = _tmp27_;
		_tmp29_ = e;
		_tmp30_ = _tmp29_->message;
		_tmp31_ = string_to_string (_tmp30_);
		_tmp32_ = g_strconcat ("Unexpected error ", _tmp24_, ".", _tmp28_, " '", _tmp31_, "'", NULL);
		_tmp33_ = _tmp32_;
		_tmp34_ = g_error_new_literal (ZCD_RPC_ERROR, ZCD_RPC_ERROR_GENERIC, _tmp33_);
		_tmp35_ = _tmp34_;
		_g_free0 (_tmp33_);
		_g_free0 (_tmp28_);
		_inner_error_ = _tmp35_;
		_g_error_free0 (e);
		goto __finally40;
	}
	__finally40:
	if ((_inner_error_->domain == ZCD_RPC_ERROR) || (_inner_error_->domain == NETSUKUKU_PEER_REFUSE_SERVICE_ERROR)) {
		g_propagate_error (error, _inner_error_);
		_g_object_unref0 (rc);
		return NULL;
	} else {
		_g_object_unref0 (rc);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return NULL;
	}
	_g_object_unref0 (rc);
}


static NetsukukuCounterGetCacheRecordsResponse* netsukuku_rmt_counter_peer_real_get_cache_records (NetsukukuICounterAsPeer* base, GError** error) {
	NetsukukuRmtCounterPeer * self;
	NetsukukuCounterGetCacheRecordsResponse* result = NULL;
	zcdRemoteCall* _tmp0_;
	zcdRemoteCall* rc;
	zcdRemoteCall* _tmp1_;
	gchar* _tmp2_;
	GError * _inner_error_ = NULL;
	self = (NetsukukuRmtCounterPeer*) base;
	_tmp0_ = zcd_remote_call_new ();
	rc = _tmp0_;
	_tmp1_ = rc;
	_tmp2_ = g_strdup ("get_cache_records");
	_g_free0 (_tmp1_->method_name);
	_tmp1_->method_name = _tmp2_;
	{
		zcdRemoteCall* _tmp3_;
		zcdISerializable* _tmp4_ = NULL;
		zcdISerializable* _tmp5_;
		zcdISerializable* _tmp6_;
		zcdISerializable* _tmp7_ = NULL;
		zcdISerializable* _tmp8_;
		zcdISerializable* _tmp9_;
		zcdISerializable* _tmp10_;
		zcdISerializable* _tmp11_ = NULL;
		zcdISerializable* _tmp12_;
		zcdISerializable* _tmp13_;
		_tmp3_ = rc;
		_tmp4_ = netsukuku_rmt_peer_rmt ((NetsukukuRmtPeer*) self, _tmp3_, &_inner_error_);
		_tmp5_ = _tmp4_;
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == ZCD_RPC_ERROR) {
				goto __catch41_zcd_rpc_error;
			}
			goto __catch41_g_error;
		}
		_tmp6_ = _tmp5_;
		_tmp7_ = netsukuku_filter_exception_PeerRefuseServiceError (_tmp6_, &_inner_error_);
		_tmp8_ = _tmp7_;
		_g_object_unref0 (_tmp6_);
		_tmp9_ = _tmp8_;
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == ZCD_RPC_ERROR) {
				goto __catch41_zcd_rpc_error;
			}
			goto __catch41_g_error;
		}
		_tmp10_ = _tmp9_;
		_tmp11_ = zcd_filter_exception (_tmp10_, &_inner_error_);
		_tmp12_ = _tmp11_;
		_g_object_unref0 (_tmp10_);
		_tmp13_ = _tmp12_;
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == ZCD_RPC_ERROR) {
				goto __catch41_zcd_rpc_error;
			}
			goto __catch41_g_error;
		}
		result = G_TYPE_CHECK_INSTANCE_CAST (_tmp13_, NETSUKUKU_TYPE_COUNTER_GET_CACHE_RECORDS_RESPONSE, NetsukukuCounterGetCacheRecordsResponse);
		_g_object_unref0 (rc);
		return result;
	}
	goto __finally41;
	__catch41_zcd_rpc_error:
	{
		GError* e = NULL;
		GError* _tmp14_;
		GError* _tmp15_;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp14_ = e;
		_tmp15_ = _g_error_copy0 (_tmp14_);
		_inner_error_ = _tmp15_;
		_g_error_free0 (e);
		goto __finally41;
	}
	goto __finally41;
	__catch41_g_error:
	{
		GError* e = NULL;
		GError* _tmp16_;
		GQuark _tmp17_;
		const gchar* _tmp18_ = NULL;
		GError* _tmp19_;
		gint _tmp20_;
		gchar* _tmp21_ = NULL;
		gchar* _tmp22_;
		GError* _tmp23_;
		const gchar* _tmp24_;
		const gchar* _tmp25_ = NULL;
		gchar* _tmp26_ = NULL;
		gchar* _tmp27_;
		GError* _tmp28_;
		GError* _tmp29_;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp16_ = e;
		_tmp17_ = _tmp16_->domain;
		_tmp18_ = g_quark_to_string (_tmp17_);
		_tmp19_ = e;
		_tmp20_ = _tmp19_->code;
		_tmp21_ = g_strdup_printf ("%i", _tmp20_);
		_tmp22_ = _tmp21_;
		_tmp23_ = e;
		_tmp24_ = _tmp23_->message;
		_tmp25_ = string_to_string (_tmp24_);
		_tmp26_ = g_strconcat ("Unexpected error ", _tmp18_, ".", _tmp22_, " '", _tmp25_, "'", NULL);
		_tmp27_ = _tmp26_;
		_tmp28_ = g_error_new_literal (ZCD_RPC_ERROR, ZCD_RPC_ERROR_GENERIC, _tmp27_);
		_tmp29_ = _tmp28_;
		_g_free0 (_tmp27_);
		_g_free0 (_tmp22_);
		_inner_error_ = _tmp29_;
		_g_error_free0 (e);
		goto __finally41;
	}
	__finally41:
	if ((_inner_error_->domain == ZCD_RPC_ERROR) || (_inner_error_->domain == NETSUKUKU_PEER_REFUSE_SERVICE_ERROR)) {
		g_propagate_error (error, _inner_error_);
		_g_object_unref0 (rc);
		return NULL;
	} else {
		_g_object_unref0 (rc);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return NULL;
	}
	_g_object_unref0 (rc);
}


static void netsukuku_rmt_counter_peer_class_init (NetsukukuRmtCounterPeerClass * klass) {
	netsukuku_rmt_counter_peer_parent_class = g_type_class_peek_parent (klass);
}


static void netsukuku_rmt_counter_peer_netsukuku_icounter_as_peer_interface_init (NetsukukuICounterAsPeerIface * iface) {
	netsukuku_rmt_counter_peer_netsukuku_icounter_as_peer_parent_iface = g_type_interface_peek_parent (iface);
	iface->set_data_for_pubk = (NetsukukuCounterSetDataResponse* (*)(NetsukukuICounterAsPeer*, NetsukukuNIP*, GeeList*, NetsukukuPublicKey*, zcdSerializableBuffer*, gboolean, GError**)) netsukuku_rmt_counter_peer_real_set_data_for_pubk;
	iface->check_hostname = (NetsukukuCounterCheckHostnameResponse* (*)(NetsukukuICounterAsPeer*, NetsukukuNIP*, const gchar*, NetsukukuPublicKey*, GError**)) netsukuku_rmt_counter_peer_real_check_hostname;
	iface->get_hostnames = (NetsukukuCounterNipRecord* (*)(NetsukukuICounterAsPeer*, NetsukukuNIP*, GError**)) netsukuku_rmt_counter_peer_real_get_hostnames;
	iface->get_cache_records = (NetsukukuCounterGetCacheRecordsResponse* (*)(NetsukukuICounterAsPeer*, GError**)) netsukuku_rmt_counter_peer_real_get_cache_records;
}


static void netsukuku_rmt_counter_peer_instance_init (NetsukukuRmtCounterPeer * self) {
}


GType netsukuku_rmt_counter_peer_get_type (void) {
	static volatile gsize netsukuku_rmt_counter_peer_type_id__volatile = 0;
	if (g_once_init_enter (&netsukuku_rmt_counter_peer_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (NetsukukuRmtCounterPeerClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) netsukuku_rmt_counter_peer_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (NetsukukuRmtCounterPeer), 0, (GInstanceInitFunc) netsukuku_rmt_counter_peer_instance_init, NULL };
		static const GInterfaceInfo netsukuku_icounter_as_peer_info = { (GInterfaceInitFunc) netsukuku_rmt_counter_peer_netsukuku_icounter_as_peer_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
		GType netsukuku_rmt_counter_peer_type_id;
		netsukuku_rmt_counter_peer_type_id = g_type_register_static (NETSUKUKU_TYPE_RMT_PEER, "NetsukukuRmtCounterPeer", &g_define_type_info, 0);
		g_type_add_interface_static (netsukuku_rmt_counter_peer_type_id, NETSUKUKU_TYPE_ICOUNTER_AS_PEER, &netsukuku_icounter_as_peer_info);
		g_once_init_leave (&netsukuku_rmt_counter_peer_type_id__volatile, netsukuku_rmt_counter_peer_type_id);
	}
	return netsukuku_rmt_counter_peer_type_id__volatile;
}


NetsukukuArgumentsForDuplicationSetData* netsukuku_arguments_for_duplication_set_data_construct (GType object_type) {
	NetsukukuArgumentsForDuplicationSetData * self = NULL;
	self = (NetsukukuArgumentsForDuplicationSetData*) g_object_new (object_type, NULL);
	return self;
}


NetsukukuArgumentsForDuplicationSetData* netsukuku_arguments_for_duplication_set_data_new (void) {
	return netsukuku_arguments_for_duplication_set_data_construct (NETSUKUKU_TYPE_ARGUMENTS_FOR_DUPLICATION_SET_DATA);
}


static void netsukuku_arguments_for_duplication_set_data_class_init (NetsukukuArgumentsForDuplicationSetDataClass * klass) {
	netsukuku_arguments_for_duplication_set_data_parent_class = g_type_class_peek_parent (klass);
	G_OBJECT_CLASS (klass)->finalize = netsukuku_arguments_for_duplication_set_data_finalize;
}


static void netsukuku_arguments_for_duplication_set_data_instance_init (NetsukukuArgumentsForDuplicationSetData * self) {
}


static void netsukuku_arguments_for_duplication_set_data_finalize (GObject* obj) {
	NetsukukuArgumentsForDuplicationSetData * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, NETSUKUKU_TYPE_ARGUMENTS_FOR_DUPLICATION_SET_DATA, NetsukukuArgumentsForDuplicationSetData);
	_g_object_unref0 (self->nip);
	_g_object_unref0 (self->hashed_domains);
	_g_object_unref0 (self->pubkey);
	_g_object_unref0 (self->signature);
	_g_object_unref0 (self->hashnode);
	G_OBJECT_CLASS (netsukuku_arguments_for_duplication_set_data_parent_class)->finalize (obj);
}


GType netsukuku_arguments_for_duplication_set_data_get_type (void) {
	static volatile gsize netsukuku_arguments_for_duplication_set_data_type_id__volatile = 0;
	if (g_once_init_enter (&netsukuku_arguments_for_duplication_set_data_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (NetsukukuArgumentsForDuplicationSetDataClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) netsukuku_arguments_for_duplication_set_data_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (NetsukukuArgumentsForDuplicationSetData), 0, (GInstanceInitFunc) netsukuku_arguments_for_duplication_set_data_instance_init, NULL };
		GType netsukuku_arguments_for_duplication_set_data_type_id;
		netsukuku_arguments_for_duplication_set_data_type_id = g_type_register_static (G_TYPE_OBJECT, "NetsukukuArgumentsForDuplicationSetData", &g_define_type_info, 0);
		g_once_init_leave (&netsukuku_arguments_for_duplication_set_data_type_id__volatile, netsukuku_arguments_for_duplication_set_data_type_id);
	}
	return netsukuku_arguments_for_duplication_set_data_type_id__volatile;
}


void netsukuku_struct_helper_counter_hook_to_service_copy (const Netsukukustruct_helper_Counter_hook_to_service* self, Netsukukustruct_helper_Counter_hook_to_service* dest) {
	NetsukukuCounter* _tmp0_;
	NetsukukuCounter* _tmp1_;
	_tmp0_ = (*self).self;
	_tmp1_ = _g_object_ref0 (_tmp0_);
	_g_object_unref0 ((*dest).self);
	(*dest).self = _tmp1_;
}


void netsukuku_struct_helper_counter_hook_to_service_destroy (Netsukukustruct_helper_Counter_hook_to_service* self) {
	_g_object_unref0 ((*self).self);
}


Netsukukustruct_helper_Counter_hook_to_service* netsukuku_struct_helper_counter_hook_to_service_dup (const Netsukukustruct_helper_Counter_hook_to_service* self) {
	Netsukukustruct_helper_Counter_hook_to_service* dup;
	dup = g_new0 (Netsukukustruct_helper_Counter_hook_to_service, 1);
	netsukuku_struct_helper_counter_hook_to_service_copy (self, dup);
	return dup;
}


void netsukuku_struct_helper_counter_hook_to_service_free (Netsukukustruct_helper_Counter_hook_to_service* self) {
	netsukuku_struct_helper_counter_hook_to_service_destroy (self);
	g_free (self);
}


GType netsukuku_struct_helper_counter_hook_to_service_get_type (void) {
	static volatile gsize netsukuku_struct_helper_counter_hook_to_service_type_id__volatile = 0;
	if (g_once_init_enter (&netsukuku_struct_helper_counter_hook_to_service_type_id__volatile)) {
		GType netsukuku_struct_helper_counter_hook_to_service_type_id;
		netsukuku_struct_helper_counter_hook_to_service_type_id = g_boxed_type_register_static ("Netsukukustruct_helper_Counter_hook_to_service", (GBoxedCopyFunc) netsukuku_struct_helper_counter_hook_to_service_dup, (GBoxedFreeFunc) netsukuku_struct_helper_counter_hook_to_service_free);
		g_once_init_leave (&netsukuku_struct_helper_counter_hook_to_service_type_id__volatile, netsukuku_struct_helper_counter_hook_to_service_type_id);
	}
	return netsukuku_struct_helper_counter_hook_to_service_type_id__volatile;
}


void netsukuku_struct_helper_counter_reset_my_counter_node_copy (const Netsukukustruct_helper_Counter_reset_my_counter_node* self, Netsukukustruct_helper_Counter_reset_my_counter_node* dest) {
	NetsukukuCounter* _tmp0_;
	NetsukukuCounter* _tmp1_;
	_tmp0_ = (*self).self;
	_tmp1_ = _g_object_ref0 (_tmp0_);
	_g_object_unref0 ((*dest).self);
	(*dest).self = _tmp1_;
}


void netsukuku_struct_helper_counter_reset_my_counter_node_destroy (Netsukukustruct_helper_Counter_reset_my_counter_node* self) {
	_g_object_unref0 ((*self).self);
}


Netsukukustruct_helper_Counter_reset_my_counter_node* netsukuku_struct_helper_counter_reset_my_counter_node_dup (const Netsukukustruct_helper_Counter_reset_my_counter_node* self) {
	Netsukukustruct_helper_Counter_reset_my_counter_node* dup;
	dup = g_new0 (Netsukukustruct_helper_Counter_reset_my_counter_node, 1);
	netsukuku_struct_helper_counter_reset_my_counter_node_copy (self, dup);
	return dup;
}


void netsukuku_struct_helper_counter_reset_my_counter_node_free (Netsukukustruct_helper_Counter_reset_my_counter_node* self) {
	netsukuku_struct_helper_counter_reset_my_counter_node_destroy (self);
	g_free (self);
}


GType netsukuku_struct_helper_counter_reset_my_counter_node_get_type (void) {
	static volatile gsize netsukuku_struct_helper_counter_reset_my_counter_node_type_id__volatile = 0;
	if (g_once_init_enter (&netsukuku_struct_helper_counter_reset_my_counter_node_type_id__volatile)) {
		GType netsukuku_struct_helper_counter_reset_my_counter_node_type_id;
		netsukuku_struct_helper_counter_reset_my_counter_node_type_id = g_boxed_type_register_static ("Netsukukustruct_helper_Counter_reset_my_counter_node", (GBoxedCopyFunc) netsukuku_struct_helper_counter_reset_my_counter_node_dup, (GBoxedFreeFunc) netsukuku_struct_helper_counter_reset_my_counter_node_free);
		g_once_init_leave (&netsukuku_struct_helper_counter_reset_my_counter_node_type_id__volatile, netsukuku_struct_helper_counter_reset_my_counter_node_type_id);
	}
	return netsukuku_struct_helper_counter_reset_my_counter_node_type_id__volatile;
}


static void _netsukuku_counter_hook_to_service_netsukuku_peer_to_peer_map_peer_to_peer_validated (NetsukukuPeerToPeer* _sender, gpointer self) {
	netsukuku_counter_hook_to_service (self);
}


static guint _netsukuku_pair_public_key_nip_hash_func_gee_hash_data_func (gconstpointer v, gpointer self) {
	guint result;
	result = netsukuku_pair_public_key_nip_hash_func (v);
	return result;
}


static gboolean _netsukuku_pair_public_key_nip_equal_func_gee_equal_data_func (gconstpointer a, gconstpointer b, gpointer self) {
	gboolean result;
	result = netsukuku_pair_public_key_nip_equal_func (a, b);
	return result;
}


NetsukukuCounter* netsukuku_counter_construct (GType object_type, NetsukukuKeyPair* keypair, NetsukukuAggregatedNeighbourManager* aggregated_neighbour_manager, NetsukukuMapRoute* maproute, NetsukukuPeerToPeerAll* peer_to_peer_all) {
	NetsukukuCounter * self = NULL;
	NetsukukuAggregatedNeighbourManager* _tmp0_;
	NetsukukuMapRoute* _tmp1_;
	NetsukukuPeerToPeerAll* _tmp2_;
	NetsukukuPeerToPeerAll* _tmp3_;
	NetsukukuKeyPair* _tmp4_;
	NetsukukuKeyPair* _tmp5_;
	NetsukukuKeyPair* _tmp6_;
	NetsukukuPublicKeyWrapper* _tmp7_;
	NetsukukuPublicKeyWrapper* _tmp8_;
	NetsukukuPublicKey* _tmp9_ = NULL;
	NetsukukuPeerToPeerAll* _tmp10_;
	GeeHashMap* _tmp11_;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (keypair != NULL, NULL);
	g_return_val_if_fail (aggregated_neighbour_manager != NULL, NULL);
	g_return_val_if_fail (maproute != NULL, NULL);
	g_return_val_if_fail (peer_to_peer_all != NULL, NULL);
	_tmp0_ = aggregated_neighbour_manager;
	_tmp1_ = maproute;
	self = (NetsukukuCounter*) netsukuku_optional_peer_to_peer_construct (object_type, _tmp0_, _tmp1_, NETSUKUKU_COUNTER_mypid);
	_tmp2_ = peer_to_peer_all;
	_tmp3_ = _g_object_ref0 (_tmp2_);
	_g_object_unref0 (self->priv->peer_to_peer_all);
	self->priv->peer_to_peer_all = _tmp3_;
	_tmp4_ = keypair;
	_tmp5_ = _g_object_ref0 (_tmp4_);
	_g_object_unref0 (self->priv->my_keys);
	self->priv->my_keys = _tmp5_;
	_tmp6_ = self->priv->my_keys;
	_tmp7_ = netsukuku_key_pair_get_pub_key (_tmp6_);
	_tmp8_ = _tmp7_;
	_tmp9_ = netsukuku_public_key_wrapper_to_pubkey (_tmp8_);
	_g_object_unref0 (self->priv->pubk);
	self->priv->pubk = _tmp9_;
	_g_object_unref0 (self->priv->reset_my_counter_node_tasklet);
	self->priv->reset_my_counter_node_tasklet = NULL;
	((NetsukukuOptionalPeerToPeer*) self)->will_participate = TRUE;
	_tmp10_ = self->priv->peer_to_peer_all;
	netsukuku_peer_to_peer_all_peer_to_peer_register (_tmp10_, (NetsukukuPeerToPeer*) self, &_inner_error_);
	if (_inner_error_ != NULL) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return NULL;
	}
	self->priv->hooked_to_service = FALSE;
	g_signal_connect_object ((NetsukukuPeerToPeer*) self, "map-peer-to-peer-validated", (GCallback) _netsukuku_counter_hook_to_service_netsukuku_peer_to_peer_map_peer_to_peer_validated, self, 0);
	_tmp11_ = gee_hash_map_new (NETSUKUKU_TYPE_PAIR_PUBLIC_KEY_NIP, (GBoxedCopyFunc) g_object_ref, g_object_unref, NETSUKUKU_TYPE_COUNTER_NIP_RECORD, (GBoxedCopyFunc) g_object_ref, g_object_unref, _netsukuku_pair_public_key_nip_hash_func_gee_hash_data_func, NULL, NULL, _netsukuku_pair_public_key_nip_equal_func_gee_equal_data_func, NULL, NULL, NULL, NULL, NULL);
	_g_object_unref0 (self->priv->cache);
	self->priv->cache = _tmp11_;
	return self;
}


NetsukukuCounter* netsukuku_counter_new (NetsukukuKeyPair* keypair, NetsukukuAggregatedNeighbourManager* aggregated_neighbour_manager, NetsukukuMapRoute* maproute, NetsukukuPeerToPeerAll* peer_to_peer_all) {
	return netsukuku_counter_construct (NETSUKUKU_TYPE_COUNTER, keypair, aggregated_neighbour_manager, maproute, peer_to_peer_all);
}


NetsukukuRmtCounterPeer* netsukuku_counter_peer (NetsukukuCounter* self, NetsukukuNIP* hIP, GObject* key, NetsukukuAggregatedNeighbour* aggregated_neighbour) {
	NetsukukuRmtCounterPeer* result = NULL;
	gboolean _tmp0_ = FALSE;
	NetsukukuNIP* _tmp1_;
	gboolean _tmp3_;
	GObject* _tmp4_;
	NetsukukuNIP* _tmp5_;
	NetsukukuAggregatedNeighbour* _tmp6_;
	NetsukukuRmtCounterPeer* _tmp7_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp1_ = hIP;
	if (_tmp1_ != NULL) {
		_tmp0_ = TRUE;
	} else {
		GObject* _tmp2_;
		_tmp2_ = key;
		_tmp0_ = _tmp2_ != NULL;
	}
	_tmp3_ = _tmp0_;
	_vala_assert (_tmp3_, "hIP != null || key != null");
	_tmp4_ = key;
	_tmp5_ = hIP;
	_tmp6_ = aggregated_neighbour;
	_tmp7_ = netsukuku_rmt_counter_peer_new ((NetsukukuPeerToPeer*) self, _tmp4_, _tmp5_, _tmp6_);
	result = _tmp7_;
	return result;
}


/** This method could be called *directly* for a dispatcher that does not need to transform
          * an exception into a remotable.
          */
static zcdISerializable* netsukuku_counter_real__dispatch (zcdRPCDispatcher* base, GObject* caller, zcdRemoteCall* data, GError** error) {
	NetsukukuCounter * self;
	zcdISerializable* result = NULL;
	GType _tmp0_ = 0UL;
	const gchar* _tmp1_ = NULL;
	const gchar* _tmp2_ = NULL;
	zcdRemoteCall* _tmp3_;
	gchar* _tmp4_ = NULL;
	gchar* _tmp5_;
	gchar* _tmp6_ = NULL;
	gchar* _tmp7_;
	zcdRemoteCall* _tmp8_;
	const gchar* _tmp9_;
	gchar** _tmp10_;
	gchar** _tmp11_ = NULL;
	gchar** pieces;
	gint pieces_length1;
	gint _pieces_size_;
	gchar** _tmp12_;
	gint _tmp12__length1;
	const gchar* _tmp13_;
	gchar** _tmp83_;
	gint _tmp83__length1;
	const gchar* _tmp84_;
	gchar** _tmp130_;
	gint _tmp130__length1;
	const gchar* _tmp131_;
	gchar** _tmp154_;
	gint _tmp154__length1;
	const gchar* _tmp155_;
	GObject* _tmp166_;
	zcdRemoteCall* _tmp167_;
	zcdISerializable* _tmp168_ = NULL;
	zcdISerializable* _tmp169_;
	GError * _inner_error_ = NULL;
	self = (NetsukukuCounter*) base;
	g_return_val_if_fail (data != NULL, NULL);
	_tmp0_ = G_TYPE_FROM_INSTANCE ((GObject*) self);
	_tmp1_ = g_type_name (_tmp0_);
	_tmp2_ = string_to_string (_tmp1_);
	_tmp3_ = data;
	_tmp4_ = zcd_remote_call_to_string (_tmp3_);
	_tmp5_ = _tmp4_;
	_tmp6_ = g_strconcat (_tmp2_, ": dispatching ", _tmp5_, NULL);
	_tmp7_ = _tmp6_;
	netsukuku_log_debug (_tmp7_);
	_g_free0 (_tmp7_);
	_g_free0 (_tmp5_);
	_tmp8_ = data;
	_tmp9_ = _tmp8_->method_name;
	_tmp11_ = _tmp10_ = g_strsplit (_tmp9_, ".", 0);
	pieces = _tmp11_;
	pieces_length1 = _vala_array_length (_tmp10_);
	_pieces_size_ = pieces_length1;
	_tmp12_ = pieces;
	_tmp12__length1 = pieces_length1;
	_tmp13_ = _tmp12_[0];
	if (g_strcmp0 (_tmp13_, "set_data_for_pubk") == 0) {
		gchar** _tmp14_;
		gint _tmp14__length1;
		zcdRemoteCall* _tmp16_;
		GeeList* _tmp17_;
		GeeList* _tmp18_;
		gint _tmp19_;
		gint _tmp20_;
		zcdRemoteCall* _tmp22_;
		GeeList* _tmp23_;
		GeeList* _tmp24_;
		gpointer _tmp25_ = NULL;
		zcdISerializable* iser0;
		zcdISerializable* _tmp26_;
		GType _tmp27_ = 0UL;
		gboolean _tmp28_ = FALSE;
		zcdISerializable* _tmp30_;
		NetsukukuNIP* _tmp31_;
		NetsukukuNIP* nip;
		zcdRemoteCall* _tmp32_;
		GeeList* _tmp33_;
		GeeList* _tmp34_;
		gpointer _tmp35_ = NULL;
		zcdISerializable* iser1;
		zcdISerializable* _tmp36_;
		GType _tmp37_ = 0UL;
		gboolean _tmp38_ = FALSE;
		zcdISerializable* _tmp40_;
		zcdListString* _tmp41_;
		zcdListString* _hashed_domains;
		zcdListString* _tmp42_;
		GeeList* _tmp43_;
		GeeList* _tmp44_;
		GeeList* hashed_domains;
		zcdRemoteCall* _tmp45_;
		GeeList* _tmp46_;
		GeeList* _tmp47_;
		gpointer _tmp48_ = NULL;
		zcdISerializable* iser2;
		zcdISerializable* _tmp49_;
		GType _tmp50_ = 0UL;
		gboolean _tmp51_ = FALSE;
		zcdISerializable* _tmp53_;
		NetsukukuPublicKey* _tmp54_;
		NetsukukuPublicKey* pubkey;
		zcdRemoteCall* _tmp55_;
		GeeList* _tmp56_;
		GeeList* _tmp57_;
		gpointer _tmp58_ = NULL;
		zcdISerializable* iser3;
		zcdISerializable* _tmp59_;
		GType _tmp60_ = 0UL;
		gboolean _tmp61_ = FALSE;
		zcdISerializable* _tmp63_;
		zcdSerializableBuffer* _tmp64_;
		zcdSerializableBuffer* signature;
		zcdRemoteCall* _tmp65_;
		GeeList* _tmp66_;
		GeeList* _tmp67_;
		gpointer _tmp68_ = NULL;
		zcdISerializable* iser4;
		zcdISerializable* _tmp69_;
		GType _tmp70_ = 0UL;
		gboolean _tmp71_ = FALSE;
		zcdISerializable* _tmp73_;
		gboolean _tmp74_;
		gboolean _tmp75_;
		gboolean replicate;
		NetsukukuNIP* _tmp76_;
		GeeList* _tmp77_;
		NetsukukuPublicKey* _tmp78_;
		zcdSerializableBuffer* _tmp79_;
		gboolean _tmp80_;
		NetsukukuCounterSetDataResponse* _tmp81_ = NULL;
		NetsukukuCounterSetDataResponse* _tmp82_;
		_tmp14_ = pieces;
		_tmp14__length1 = pieces_length1;
		if (_tmp14__length1 != 1) {
			GError* _tmp15_;
			_tmp15_ = g_error_new_literal (ZCD_RPC_ERROR, ZCD_RPC_ERROR_MALFORMED_PACKET, "set_data_for_pubk is a function.");
			_inner_error_ = _tmp15_;
			g_propagate_error (error, _inner_error_);
			pieces = (_vala_array_free (pieces, pieces_length1, (GDestroyNotify) g_free), NULL);
			return NULL;
		}
		_tmp16_ = data;
		_tmp17_ = zcd_remote_call_get_parameters (_tmp16_);
		_tmp18_ = _tmp17_;
		_tmp19_ = gee_collection_get_size ((GeeCollection*) _tmp18_);
		_tmp20_ = _tmp19_;
		if (_tmp20_ != 5) {
			GError* _tmp21_;
			_tmp21_ = g_error_new_literal (ZCD_RPC_ERROR, ZCD_RPC_ERROR_MALFORMED_PACKET, "set_data_for_pubk wants 5 parameters.");
			_inner_error_ = _tmp21_;
			g_propagate_error (error, _inner_error_);
			pieces = (_vala_array_free (pieces, pieces_length1, (GDestroyNotify) g_free), NULL);
			return NULL;
		}
		_tmp22_ = data;
		_tmp23_ = zcd_remote_call_get_parameters (_tmp22_);
		_tmp24_ = _tmp23_;
		_tmp25_ = gee_list_get (_tmp24_, 0);
		iser0 = (zcdISerializable*) _tmp25_;
		_tmp26_ = iser0;
		_tmp27_ = G_TYPE_FROM_INSTANCE ((GObject*) _tmp26_);
		_tmp28_ = g_type_is_a (_tmp27_, NETSUKUKU_TYPE_NIP);
		if (!_tmp28_) {
			GError* _tmp29_;
			_tmp29_ = g_error_new_literal (ZCD_RPC_ERROR, ZCD_RPC_ERROR_MALFORMED_PACKET, "set_data_for_pubk parameter 1 is not a NIP.");
			_inner_error_ = _tmp29_;
			g_propagate_error (error, _inner_error_);
			_g_object_unref0 (iser0);
			pieces = (_vala_array_free (pieces, pieces_length1, (GDestroyNotify) g_free), NULL);
			return NULL;
		}
		_tmp30_ = iser0;
		_tmp31_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp30_, NETSUKUKU_TYPE_NIP, NetsukukuNIP));
		nip = _tmp31_;
		_tmp32_ = data;
		_tmp33_ = zcd_remote_call_get_parameters (_tmp32_);
		_tmp34_ = _tmp33_;
		_tmp35_ = gee_list_get (_tmp34_, 1);
		iser1 = (zcdISerializable*) _tmp35_;
		_tmp36_ = iser1;
		_tmp37_ = G_TYPE_FROM_INSTANCE ((GObject*) _tmp36_);
		_tmp38_ = g_type_is_a (_tmp37_, ZCD_TYPE_LIST_STRING);
		if (!_tmp38_) {
			GError* _tmp39_;
			_tmp39_ = g_error_new_literal (ZCD_RPC_ERROR, ZCD_RPC_ERROR_MALFORMED_PACKET, "set_data_for_pubk parameter 2 is not a List<string>.");
			_inner_error_ = _tmp39_;
			g_propagate_error (error, _inner_error_);
			_g_object_unref0 (iser1);
			_g_object_unref0 (nip);
			_g_object_unref0 (iser0);
			pieces = (_vala_array_free (pieces, pieces_length1, (GDestroyNotify) g_free), NULL);
			return NULL;
		}
		_tmp40_ = iser1;
		_tmp41_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp40_, ZCD_TYPE_LIST_STRING, zcdListString));
		_hashed_domains = _tmp41_;
		_tmp42_ = _hashed_domains;
		_tmp43_ = _tmp42_->backed;
		_tmp44_ = _g_object_ref0 (_tmp43_);
		hashed_domains = _tmp44_;
		_tmp45_ = data;
		_tmp46_ = zcd_remote_call_get_parameters (_tmp45_);
		_tmp47_ = _tmp46_;
		_tmp48_ = gee_list_get (_tmp47_, 2);
		iser2 = (zcdISerializable*) _tmp48_;
		_tmp49_ = iser2;
		_tmp50_ = G_TYPE_FROM_INSTANCE ((GObject*) _tmp49_);
		_tmp51_ = g_type_is_a (_tmp50_, NETSUKUKU_TYPE_PUBLIC_KEY);
		if (!_tmp51_) {
			GError* _tmp52_;
			_tmp52_ = g_error_new_literal (ZCD_RPC_ERROR, ZCD_RPC_ERROR_MALFORMED_PACKET, "set_data_for_pubk parameter 3 is not a PublicKey.");
			_inner_error_ = _tmp52_;
			g_propagate_error (error, _inner_error_);
			_g_object_unref0 (iser2);
			_g_object_unref0 (hashed_domains);
			_g_object_unref0 (_hashed_domains);
			_g_object_unref0 (iser1);
			_g_object_unref0 (nip);
			_g_object_unref0 (iser0);
			pieces = (_vala_array_free (pieces, pieces_length1, (GDestroyNotify) g_free), NULL);
			return NULL;
		}
		_tmp53_ = iser2;
		_tmp54_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp53_, NETSUKUKU_TYPE_PUBLIC_KEY, NetsukukuPublicKey));
		pubkey = _tmp54_;
		_tmp55_ = data;
		_tmp56_ = zcd_remote_call_get_parameters (_tmp55_);
		_tmp57_ = _tmp56_;
		_tmp58_ = gee_list_get (_tmp57_, 3);
		iser3 = (zcdISerializable*) _tmp58_;
		_tmp59_ = iser3;
		_tmp60_ = G_TYPE_FROM_INSTANCE ((GObject*) _tmp59_);
		_tmp61_ = g_type_is_a (_tmp60_, ZCD_TYPE_SERIALIZABLE_BUFFER);
		if (!_tmp61_) {
			GError* _tmp62_;
			_tmp62_ = g_error_new_literal (ZCD_RPC_ERROR, ZCD_RPC_ERROR_MALFORMED_PACKET, "set_data_for_pubk parameter 4 is not a SerializableBuffer.");
			_inner_error_ = _tmp62_;
			g_propagate_error (error, _inner_error_);
			_g_object_unref0 (iser3);
			_g_object_unref0 (pubkey);
			_g_object_unref0 (iser2);
			_g_object_unref0 (hashed_domains);
			_g_object_unref0 (_hashed_domains);
			_g_object_unref0 (iser1);
			_g_object_unref0 (nip);
			_g_object_unref0 (iser0);
			pieces = (_vala_array_free (pieces, pieces_length1, (GDestroyNotify) g_free), NULL);
			return NULL;
		}
		_tmp63_ = iser3;
		_tmp64_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp63_, ZCD_TYPE_SERIALIZABLE_BUFFER, zcdSerializableBuffer));
		signature = _tmp64_;
		_tmp65_ = data;
		_tmp66_ = zcd_remote_call_get_parameters (_tmp65_);
		_tmp67_ = _tmp66_;
		_tmp68_ = gee_list_get (_tmp67_, 4);
		iser4 = (zcdISerializable*) _tmp68_;
		_tmp69_ = iser4;
		_tmp70_ = G_TYPE_FROM_INSTANCE ((GObject*) _tmp69_);
		_tmp71_ = g_type_is_a (_tmp70_, ZCD_TYPE_SERIALIZABLE_BOOL);
		if (!_tmp71_) {
			GError* _tmp72_;
			_tmp72_ = g_error_new_literal (ZCD_RPC_ERROR, ZCD_RPC_ERROR_MALFORMED_PACKET, "set_data_for_pubk parameter 5 is not a bool.");
			_inner_error_ = _tmp72_;
			g_propagate_error (error, _inner_error_);
			_g_object_unref0 (iser4);
			_g_object_unref0 (signature);
			_g_object_unref0 (iser3);
			_g_object_unref0 (pubkey);
			_g_object_unref0 (iser2);
			_g_object_unref0 (hashed_domains);
			_g_object_unref0 (_hashed_domains);
			_g_object_unref0 (iser1);
			_g_object_unref0 (nip);
			_g_object_unref0 (iser0);
			pieces = (_vala_array_free (pieces, pieces_length1, (GDestroyNotify) g_free), NULL);
			return NULL;
		}
		_tmp73_ = iser4;
		_tmp74_ = zcd_serializable_bool_get_b (G_TYPE_CHECK_INSTANCE_CAST (_tmp73_, ZCD_TYPE_SERIALIZABLE_BOOL, zcdSerializableBool));
		_tmp75_ = _tmp74_;
		replicate = _tmp75_;
		_tmp76_ = nip;
		_tmp77_ = hashed_domains;
		_tmp78_ = pubkey;
		_tmp79_ = signature;
		_tmp80_ = replicate;
		_tmp81_ = netsukuku_icounter_as_peer_set_data_for_pubk ((NetsukukuICounterAsPeer*) self, _tmp76_, _tmp77_, _tmp78_, _tmp79_, _tmp80_, &_inner_error_);
		_tmp82_ = _tmp81_;
		if (_inner_error_ != NULL) {
			g_propagate_error (error, _inner_error_);
			_g_object_unref0 (iser4);
			_g_object_unref0 (signature);
			_g_object_unref0 (iser3);
			_g_object_unref0 (pubkey);
			_g_object_unref0 (iser2);
			_g_object_unref0 (hashed_domains);
			_g_object_unref0 (_hashed_domains);
			_g_object_unref0 (iser1);
			_g_object_unref0 (nip);
			_g_object_unref0 (iser0);
			pieces = (_vala_array_free (pieces, pieces_length1, (GDestroyNotify) g_free), NULL);
			return NULL;
		}
		result = (zcdISerializable*) _tmp82_;
		_g_object_unref0 (iser4);
		_g_object_unref0 (signature);
		_g_object_unref0 (iser3);
		_g_object_unref0 (pubkey);
		_g_object_unref0 (iser2);
		_g_object_unref0 (hashed_domains);
		_g_object_unref0 (_hashed_domains);
		_g_object_unref0 (iser1);
		_g_object_unref0 (nip);
		_g_object_unref0 (iser0);
		pieces = (_vala_array_free (pieces, pieces_length1, (GDestroyNotify) g_free), NULL);
		return result;
	}
	_tmp83_ = pieces;
	_tmp83__length1 = pieces_length1;
	_tmp84_ = _tmp83_[0];
	if (g_strcmp0 (_tmp84_, "check_hostname") == 0) {
		gchar** _tmp85_;
		gint _tmp85__length1;
		zcdRemoteCall* _tmp87_;
		GeeList* _tmp88_;
		GeeList* _tmp89_;
		gint _tmp90_;
		gint _tmp91_;
		zcdRemoteCall* _tmp93_;
		GeeList* _tmp94_;
		GeeList* _tmp95_;
		gpointer _tmp96_ = NULL;
		zcdISerializable* iser0;
		zcdISerializable* _tmp97_;
		GType _tmp98_ = 0UL;
		gboolean _tmp99_ = FALSE;
		zcdISerializable* _tmp101_;
		NetsukukuNIP* _tmp102_;
		NetsukukuNIP* nip;
		zcdRemoteCall* _tmp103_;
		GeeList* _tmp104_;
		GeeList* _tmp105_;
		gpointer _tmp106_ = NULL;
		zcdISerializable* iser1;
		zcdISerializable* _tmp107_;
		GType _tmp108_ = 0UL;
		gboolean _tmp109_ = FALSE;
		zcdISerializable* _tmp111_;
		const gchar* _tmp112_;
		const gchar* _tmp113_;
		gchar* _tmp114_;
		gchar* hashed_domain;
		zcdRemoteCall* _tmp115_;
		GeeList* _tmp116_;
		GeeList* _tmp117_;
		gpointer _tmp118_ = NULL;
		zcdISerializable* iser2;
		zcdISerializable* _tmp119_;
		GType _tmp120_ = 0UL;
		gboolean _tmp121_ = FALSE;
		zcdISerializable* _tmp123_;
		NetsukukuPublicKey* _tmp124_;
		NetsukukuPublicKey* pubkey;
		NetsukukuNIP* _tmp125_;
		const gchar* _tmp126_;
		NetsukukuPublicKey* _tmp127_;
		NetsukukuCounterCheckHostnameResponse* _tmp128_ = NULL;
		NetsukukuCounterCheckHostnameResponse* _tmp129_;
		_tmp85_ = pieces;
		_tmp85__length1 = pieces_length1;
		if (_tmp85__length1 != 1) {
			GError* _tmp86_;
			_tmp86_ = g_error_new_literal (ZCD_RPC_ERROR, ZCD_RPC_ERROR_MALFORMED_PACKET, "check_hostname is a function.");
			_inner_error_ = _tmp86_;
			g_propagate_error (error, _inner_error_);
			pieces = (_vala_array_free (pieces, pieces_length1, (GDestroyNotify) g_free), NULL);
			return NULL;
		}
		_tmp87_ = data;
		_tmp88_ = zcd_remote_call_get_parameters (_tmp87_);
		_tmp89_ = _tmp88_;
		_tmp90_ = gee_collection_get_size ((GeeCollection*) _tmp89_);
		_tmp91_ = _tmp90_;
		if (_tmp91_ != 3) {
			GError* _tmp92_;
			_tmp92_ = g_error_new_literal (ZCD_RPC_ERROR, ZCD_RPC_ERROR_MALFORMED_PACKET, "check_hostname wants 3 parameters.");
			_inner_error_ = _tmp92_;
			g_propagate_error (error, _inner_error_);
			pieces = (_vala_array_free (pieces, pieces_length1, (GDestroyNotify) g_free), NULL);
			return NULL;
		}
		_tmp93_ = data;
		_tmp94_ = zcd_remote_call_get_parameters (_tmp93_);
		_tmp95_ = _tmp94_;
		_tmp96_ = gee_list_get (_tmp95_, 0);
		iser0 = (zcdISerializable*) _tmp96_;
		_tmp97_ = iser0;
		_tmp98_ = G_TYPE_FROM_INSTANCE ((GObject*) _tmp97_);
		_tmp99_ = g_type_is_a (_tmp98_, NETSUKUKU_TYPE_NIP);
		if (!_tmp99_) {
			GError* _tmp100_;
			_tmp100_ = g_error_new_literal (ZCD_RPC_ERROR, ZCD_RPC_ERROR_MALFORMED_PACKET, "check_hostname parameter 1 is not a NIP.");
			_inner_error_ = _tmp100_;
			g_propagate_error (error, _inner_error_);
			_g_object_unref0 (iser0);
			pieces = (_vala_array_free (pieces, pieces_length1, (GDestroyNotify) g_free), NULL);
			return NULL;
		}
		_tmp101_ = iser0;
		_tmp102_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp101_, NETSUKUKU_TYPE_NIP, NetsukukuNIP));
		nip = _tmp102_;
		_tmp103_ = data;
		_tmp104_ = zcd_remote_call_get_parameters (_tmp103_);
		_tmp105_ = _tmp104_;
		_tmp106_ = gee_list_get (_tmp105_, 1);
		iser1 = (zcdISerializable*) _tmp106_;
		_tmp107_ = iser1;
		_tmp108_ = G_TYPE_FROM_INSTANCE ((GObject*) _tmp107_);
		_tmp109_ = g_type_is_a (_tmp108_, ZCD_TYPE_SERIALIZABLE_STRING);
		if (!_tmp109_) {
			GError* _tmp110_;
			_tmp110_ = g_error_new_literal (ZCD_RPC_ERROR, ZCD_RPC_ERROR_MALFORMED_PACKET, "check_hostname parameter 2 is not a string.");
			_inner_error_ = _tmp110_;
			g_propagate_error (error, _inner_error_);
			_g_object_unref0 (iser1);
			_g_object_unref0 (nip);
			_g_object_unref0 (iser0);
			pieces = (_vala_array_free (pieces, pieces_length1, (GDestroyNotify) g_free), NULL);
			return NULL;
		}
		_tmp111_ = iser1;
		_tmp112_ = zcd_serializable_string_get_s (G_TYPE_CHECK_INSTANCE_CAST (_tmp111_, ZCD_TYPE_SERIALIZABLE_STRING, zcdSerializableString));
		_tmp113_ = _tmp112_;
		_tmp114_ = g_strdup (_tmp113_);
		hashed_domain = _tmp114_;
		_tmp115_ = data;
		_tmp116_ = zcd_remote_call_get_parameters (_tmp115_);
		_tmp117_ = _tmp116_;
		_tmp118_ = gee_list_get (_tmp117_, 2);
		iser2 = (zcdISerializable*) _tmp118_;
		_tmp119_ = iser2;
		_tmp120_ = G_TYPE_FROM_INSTANCE ((GObject*) _tmp119_);
		_tmp121_ = g_type_is_a (_tmp120_, NETSUKUKU_TYPE_PUBLIC_KEY);
		if (!_tmp121_) {
			GError* _tmp122_;
			_tmp122_ = g_error_new_literal (ZCD_RPC_ERROR, ZCD_RPC_ERROR_MALFORMED_PACKET, "check_hostname parameter 3 is not a PublicKey.");
			_inner_error_ = _tmp122_;
			g_propagate_error (error, _inner_error_);
			_g_object_unref0 (iser2);
			_g_free0 (hashed_domain);
			_g_object_unref0 (iser1);
			_g_object_unref0 (nip);
			_g_object_unref0 (iser0);
			pieces = (_vala_array_free (pieces, pieces_length1, (GDestroyNotify) g_free), NULL);
			return NULL;
		}
		_tmp123_ = iser2;
		_tmp124_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp123_, NETSUKUKU_TYPE_PUBLIC_KEY, NetsukukuPublicKey));
		pubkey = _tmp124_;
		_tmp125_ = nip;
		_tmp126_ = hashed_domain;
		_tmp127_ = pubkey;
		_tmp128_ = netsukuku_icounter_as_peer_check_hostname ((NetsukukuICounterAsPeer*) self, _tmp125_, _tmp126_, _tmp127_, &_inner_error_);
		_tmp129_ = _tmp128_;
		if (_inner_error_ != NULL) {
			g_propagate_error (error, _inner_error_);
			_g_object_unref0 (pubkey);
			_g_object_unref0 (iser2);
			_g_free0 (hashed_domain);
			_g_object_unref0 (iser1);
			_g_object_unref0 (nip);
			_g_object_unref0 (iser0);
			pieces = (_vala_array_free (pieces, pieces_length1, (GDestroyNotify) g_free), NULL);
			return NULL;
		}
		result = (zcdISerializable*) _tmp129_;
		_g_object_unref0 (pubkey);
		_g_object_unref0 (iser2);
		_g_free0 (hashed_domain);
		_g_object_unref0 (iser1);
		_g_object_unref0 (nip);
		_g_object_unref0 (iser0);
		pieces = (_vala_array_free (pieces, pieces_length1, (GDestroyNotify) g_free), NULL);
		return result;
	}
	_tmp130_ = pieces;
	_tmp130__length1 = pieces_length1;
	_tmp131_ = _tmp130_[0];
	if (g_strcmp0 (_tmp131_, "get_hostnames") == 0) {
		gchar** _tmp132_;
		gint _tmp132__length1;
		zcdRemoteCall* _tmp134_;
		GeeList* _tmp135_;
		GeeList* _tmp136_;
		gint _tmp137_;
		gint _tmp138_;
		zcdRemoteCall* _tmp140_;
		GeeList* _tmp141_;
		GeeList* _tmp142_;
		gpointer _tmp143_ = NULL;
		zcdISerializable* iser0;
		zcdISerializable* _tmp144_;
		GType _tmp145_ = 0UL;
		gboolean _tmp146_ = FALSE;
		zcdISerializable* _tmp148_;
		NetsukukuNIP* _tmp149_;
		NetsukukuNIP* nip;
		NetsukukuNIP* _tmp150_;
		NetsukukuCounterNipRecord* _tmp151_ = NULL;
		NetsukukuCounterNipRecord* ret;
		NetsukukuCounterNipRecord* _tmp152_;
		_tmp132_ = pieces;
		_tmp132__length1 = pieces_length1;
		if (_tmp132__length1 != 1) {
			GError* _tmp133_;
			_tmp133_ = g_error_new_literal (ZCD_RPC_ERROR, ZCD_RPC_ERROR_MALFORMED_PACKET, "get_hostnames is a function.");
			_inner_error_ = _tmp133_;
			g_propagate_error (error, _inner_error_);
			pieces = (_vala_array_free (pieces, pieces_length1, (GDestroyNotify) g_free), NULL);
			return NULL;
		}
		_tmp134_ = data;
		_tmp135_ = zcd_remote_call_get_parameters (_tmp134_);
		_tmp136_ = _tmp135_;
		_tmp137_ = gee_collection_get_size ((GeeCollection*) _tmp136_);
		_tmp138_ = _tmp137_;
		if (_tmp138_ != 1) {
			GError* _tmp139_;
			_tmp139_ = g_error_new_literal (ZCD_RPC_ERROR, ZCD_RPC_ERROR_MALFORMED_PACKET, "get_hostnames wants 1 parameter.");
			_inner_error_ = _tmp139_;
			g_propagate_error (error, _inner_error_);
			pieces = (_vala_array_free (pieces, pieces_length1, (GDestroyNotify) g_free), NULL);
			return NULL;
		}
		_tmp140_ = data;
		_tmp141_ = zcd_remote_call_get_parameters (_tmp140_);
		_tmp142_ = _tmp141_;
		_tmp143_ = gee_list_get (_tmp142_, 0);
		iser0 = (zcdISerializable*) _tmp143_;
		_tmp144_ = iser0;
		_tmp145_ = G_TYPE_FROM_INSTANCE ((GObject*) _tmp144_);
		_tmp146_ = g_type_is_a (_tmp145_, NETSUKUKU_TYPE_NIP);
		if (!_tmp146_) {
			GError* _tmp147_;
			_tmp147_ = g_error_new_literal (ZCD_RPC_ERROR, ZCD_RPC_ERROR_MALFORMED_PACKET, "get_hostnames parameter 1 is not a NIP.");
			_inner_error_ = _tmp147_;
			g_propagate_error (error, _inner_error_);
			_g_object_unref0 (iser0);
			pieces = (_vala_array_free (pieces, pieces_length1, (GDestroyNotify) g_free), NULL);
			return NULL;
		}
		_tmp148_ = iser0;
		_tmp149_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp148_, NETSUKUKU_TYPE_NIP, NetsukukuNIP));
		nip = _tmp149_;
		_tmp150_ = nip;
		_tmp151_ = netsukuku_icounter_as_peer_get_hostnames ((NetsukukuICounterAsPeer*) self, _tmp150_, &_inner_error_);
		ret = _tmp151_;
		if (_inner_error_ != NULL) {
			g_propagate_error (error, _inner_error_);
			_g_object_unref0 (nip);
			_g_object_unref0 (iser0);
			pieces = (_vala_array_free (pieces, pieces_length1, (GDestroyNotify) g_free), NULL);
			return NULL;
		}
		_tmp152_ = ret;
		if (_tmp152_ == NULL) {
			zcdSerializableNone* _tmp153_;
			_tmp153_ = zcd_serializable_none_new ();
			result = (zcdISerializable*) _tmp153_;
			_g_object_unref0 (ret);
			_g_object_unref0 (nip);
			_g_object_unref0 (iser0);
			pieces = (_vala_array_free (pieces, pieces_length1, (GDestroyNotify) g_free), NULL);
			return result;
		}
		result = (zcdISerializable*) ret;
		_g_object_unref0 (nip);
		_g_object_unref0 (iser0);
		pieces = (_vala_array_free (pieces, pieces_length1, (GDestroyNotify) g_free), NULL);
		return result;
	}
	_tmp154_ = pieces;
	_tmp154__length1 = pieces_length1;
	_tmp155_ = _tmp154_[0];
	if (g_strcmp0 (_tmp155_, "get_cache_records") == 0) {
		gchar** _tmp156_;
		gint _tmp156__length1;
		zcdRemoteCall* _tmp158_;
		GeeList* _tmp159_;
		GeeList* _tmp160_;
		gint _tmp161_;
		gint _tmp162_;
		NetsukukuCounterGetCacheRecordsResponse* _tmp164_ = NULL;
		NetsukukuCounterGetCacheRecordsResponse* _tmp165_;
		_tmp156_ = pieces;
		_tmp156__length1 = pieces_length1;
		if (_tmp156__length1 != 1) {
			GError* _tmp157_;
			_tmp157_ = g_error_new_literal (ZCD_RPC_ERROR, ZCD_RPC_ERROR_MALFORMED_PACKET, "get_cache_records is a function.");
			_inner_error_ = _tmp157_;
			g_propagate_error (error, _inner_error_);
			pieces = (_vala_array_free (pieces, pieces_length1, (GDestroyNotify) g_free), NULL);
			return NULL;
		}
		_tmp158_ = data;
		_tmp159_ = zcd_remote_call_get_parameters (_tmp158_);
		_tmp160_ = _tmp159_;
		_tmp161_ = gee_collection_get_size ((GeeCollection*) _tmp160_);
		_tmp162_ = _tmp161_;
		if (_tmp162_ != 0) {
			GError* _tmp163_;
			_tmp163_ = g_error_new_literal (ZCD_RPC_ERROR, ZCD_RPC_ERROR_MALFORMED_PACKET, "get_cache_records wants no parameters.");
			_inner_error_ = _tmp163_;
			g_propagate_error (error, _inner_error_);
			pieces = (_vala_array_free (pieces, pieces_length1, (GDestroyNotify) g_free), NULL);
			return NULL;
		}
		_tmp164_ = netsukuku_icounter_as_peer_get_cache_records ((NetsukukuICounterAsPeer*) self, &_inner_error_);
		_tmp165_ = _tmp164_;
		if (_inner_error_ != NULL) {
			g_propagate_error (error, _inner_error_);
			pieces = (_vala_array_free (pieces, pieces_length1, (GDestroyNotify) g_free), NULL);
			return NULL;
		}
		result = (zcdISerializable*) _tmp165_;
		pieces = (_vala_array_free (pieces, pieces_length1, (GDestroyNotify) g_free), NULL);
		return result;
	}
	_tmp166_ = caller;
	_tmp167_ = data;
	_tmp168_ = ZCD_RPC_DISPATCHER_CLASS (netsukuku_counter_parent_class)->_dispatch ((zcdRPCDispatcher*) G_TYPE_CHECK_INSTANCE_CAST (self, NETSUKUKU_TYPE_OPTIONAL_PEER_TO_PEER, NetsukukuOptionalPeerToPeer), _tmp166_, _tmp167_, &_inner_error_);
	_tmp169_ = _tmp168_;
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		pieces = (_vala_array_free (pieces, pieces_length1, (GDestroyNotify) g_free), NULL);
		return NULL;
	}
	result = _tmp169_;
	pieces = (_vala_array_free (pieces, pieces_length1, (GDestroyNotify) g_free), NULL);
	return result;
}


static NetsukukuNIP* netsukuku_counter_nip_for_lvl_pos (NetsukukuCounter* self, gint lvl, gint pos) {
	NetsukukuNIP* result = NULL;
	NetsukukuMapRoute* _tmp0_;
	NetsukukuNIP* _tmp1_;
	NetsukukuNIP* _tmp2_;
	gint _tmp3_ = 0;
	gint* _tmp4_ = NULL;
	gint* ret;
	gint ret_length1;
	gint _ret_size_;
	gint _tmp5_;
	gint _tmp6_;
	gint _tmp7_;
	NetsukukuNIP* _tmp8_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = ((NetsukukuPeerToPeer*) self)->maproute;
	_tmp1_ = netsukuku_map_get_me ((NetsukukuMap*) _tmp0_);
	_tmp2_ = _tmp1_;
	_tmp4_ = netsukuku_partial_nip_get_positions ((NetsukukuPartialNIP*) _tmp2_, &_tmp3_);
	ret = _tmp4_;
	ret_length1 = _tmp3_;
	_ret_size_ = ret_length1;
	_tmp5_ = lvl;
	_tmp6_ = pos;
	ret[_tmp5_] = _tmp6_;
	_tmp7_ = ret[_tmp5_];
	_tmp8_ = netsukuku_nip_new (ret, ret_length1);
	result = _tmp8_;
	ret = (g_free (ret), NULL);
	return result;
}


static gboolean _int_equal (const gint* s1, const gint* s2) {
	if (s1 == s2) {
		return TRUE;
	}
	if (s1 == NULL) {
		return FALSE;
	}
	if (s2 == NULL) {
		return FALSE;
	}
	return (*s1) == (*s2);
}


static void netsukuku_counter_impl_hook_to_service (NetsukukuCounter* self, GError** error) {
	gboolean _tmp0_;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	tasklets_tasklet_declare_self ("Counter.hook_to_service");
	_tmp0_ = ((NetsukukuOptionalPeerToPeer*) self)->will_participate;
	if (_tmp0_) {
		GeeHashMap* _tmp1_;
		GType _tmp242_ = 0UL;
		const gchar* _tmp243_ = NULL;
		const gchar* _tmp244_ = NULL;
		gchar* _tmp245_ = NULL;
		gchar* _tmp246_;
		_tmp1_ = self->priv->cache;
		gee_abstract_map_clear ((GeeAbstractMap*) _tmp1_);
		{
			gint lvl;
			lvl = 0;
			{
				gboolean _tmp2_;
				_tmp2_ = TRUE;
				while (TRUE) {
					gboolean _tmp3_;
					gint _tmp5_;
					NetsukukuMapRoute* _tmp6_;
					gint _tmp7_;
					gint _tmp8_;
					gint* first_forward = NULL;
					gint* first_back = NULL;
					gint* last_back = NULL;
					GType _tmp9_ = 0UL;
					const gchar* _tmp10_ = NULL;
					const gchar* _tmp11_ = NULL;
					NetsukukuMapRoute* _tmp12_;
					NetsukukuNIP* _tmp13_;
					NetsukukuNIP* _tmp14_;
					gchar* _tmp15_ = NULL;
					gchar* _tmp16_;
					gint _tmp17_;
					gchar* _tmp18_ = NULL;
					gchar* _tmp19_;
					gchar* _tmp20_ = NULL;
					gchar* _tmp21_;
					gint _tmp22_;
					gint* _tmp23_ = NULL;
					gint* _tmp24_ = NULL;
					gint* _tmp25_ = NULL;
					gint* _tmp26_;
					_tmp3_ = _tmp2_;
					if (!_tmp3_) {
						gint _tmp4_;
						_tmp4_ = lvl;
						lvl = _tmp4_ + 1;
					}
					_tmp2_ = FALSE;
					_tmp5_ = lvl;
					_tmp6_ = ((NetsukukuPeerToPeer*) self)->maproute;
					_tmp7_ = netsukuku_map_get_levels ((NetsukukuMap*) _tmp6_);
					_tmp8_ = _tmp7_;
					if (!(_tmp5_ < _tmp8_)) {
						break;
					}
					_tmp9_ = G_TYPE_FROM_INSTANCE ((GObject*) self);
					_tmp10_ = g_type_name (_tmp9_);
					_tmp11_ = string_to_string (_tmp10_);
					_tmp12_ = ((NetsukukuPeerToPeer*) self)->maproute;
					_tmp13_ = netsukuku_map_get_me ((NetsukukuMap*) _tmp12_);
					_tmp14_ = _tmp13_;
					_tmp15_ = netsukuku_partial_nip_to_string ((NetsukukuPartialNIP*) _tmp14_);
					_tmp16_ = _tmp15_;
					_tmp17_ = lvl;
					_tmp18_ = g_strdup_printf ("%i", _tmp17_);
					_tmp19_ = _tmp18_;
					_tmp20_ = g_strconcat (_tmp11_, ": hook: ", _tmp16_, " finding peers at lvl ", _tmp19_, NULL);
					_tmp21_ = _tmp20_;
					netsukuku_log_debug (_tmp21_);
					_g_free0 (_tmp21_);
					_g_free0 (_tmp19_);
					_g_free0 (_tmp16_);
					_tmp22_ = lvl;
					netsukuku_peer_to_peer_find_hook_peers ((NetsukukuPeerToPeer*) self, &_tmp23_, &_tmp24_, &_tmp25_, _tmp22_, NETSUKUKU_COUNTER_DUPLICATION, 120000);
					_g_free0 (first_forward);
					first_forward = _tmp23_;
					_g_free0 (first_back);
					first_back = _tmp24_;
					_g_free0 (last_back);
					last_back = _tmp25_;
					_tmp26_ = first_forward;
					if (_tmp26_ == NULL) {
						GType _tmp27_ = 0UL;
						const gchar* _tmp28_ = NULL;
						const gchar* _tmp29_ = NULL;
						gchar* _tmp30_ = NULL;
						gchar* _tmp31_;
						_tmp27_ = G_TYPE_FROM_INSTANCE ((GObject*) self);
						_tmp28_ = g_type_name (_tmp27_);
						_tmp29_ = string_to_string (_tmp28_);
						_tmp30_ = g_strconcat (_tmp29_, ": hook: no one in network at this level (except me)", NULL);
						_tmp31_ = _tmp30_;
						netsukuku_log_debug (_tmp31_);
						_g_free0 (_tmp31_);
					} else {
						gint* _tmp32_;
						_tmp32_ = first_back;
						if (_tmp32_ == NULL) {
							GType _tmp33_ = 0UL;
							const gchar* _tmp34_ = NULL;
							const gchar* _tmp35_ = NULL;
							gint* _tmp36_;
							gchar* _tmp37_ = NULL;
							gchar* _tmp38_;
							gchar* _tmp39_ = NULL;
							gchar* _tmp40_;
							gint _tmp41_;
							gint* _tmp42_;
							NetsukukuNIP* _tmp43_ = NULL;
							NetsukukuNIP* nip_first_forward;
							NetsukukuNIP* _tmp44_;
							NetsukukuRmtCounterPeer* _tmp45_ = NULL;
							NetsukukuRmtCounterPeer* peer_first_forward;
							NetsukukuRmtCounterPeer* _tmp46_;
							NetsukukuCounterGetCacheRecordsResponse* _tmp47_ = NULL;
							NetsukukuCounterGetCacheRecordsResponse* cache_first_forward;
							_tmp33_ = G_TYPE_FROM_INSTANCE ((GObject*) self);
							_tmp34_ = g_type_name (_tmp33_);
							_tmp35_ = string_to_string (_tmp34_);
							_tmp36_ = first_forward;
							_tmp37_ = g_strdup_printf ("%i", *_tmp36_);
							_tmp38_ = _tmp37_;
							_tmp39_ = g_strconcat (_tmp35_, ": hook: few nodes at this level. get all from ", _tmp38_, ".", NULL);
							_tmp40_ = _tmp39_;
							netsukuku_log_debug (_tmp40_);
							_g_free0 (_tmp40_);
							_g_free0 (_tmp38_);
							_tmp41_ = lvl;
							_tmp42_ = first_forward;
							_tmp43_ = netsukuku_counter_nip_for_lvl_pos (self, _tmp41_, *_tmp42_);
							nip_first_forward = _tmp43_;
							_tmp44_ = nip_first_forward;
							_tmp45_ = netsukuku_counter_peer (self, _tmp44_, NULL, NULL);
							peer_first_forward = _tmp45_;
							_tmp46_ = peer_first_forward;
							_tmp47_ = netsukuku_icounter_as_peer_get_cache_records ((NetsukukuICounterAsPeer*) _tmp46_, &_inner_error_);
							cache_first_forward = _tmp47_;
							if (_inner_error_ != NULL) {
								g_propagate_error (error, _inner_error_);
								_g_object_unref0 (peer_first_forward);
								_g_object_unref0 (nip_first_forward);
								_g_free0 (last_back);
								_g_free0 (first_back);
								_g_free0 (first_forward);
								return;
							}
							{
								NetsukukuCounterGetCacheRecordsResponse* _tmp48_;
								GeeHashMap* _tmp49_;
								GeeHashMap* _tmp50_;
								GeeSet* _tmp51_;
								GeeSet* _tmp52_;
								GeeSet* _tmp53_;
								GeeIterator* _tmp54_ = NULL;
								GeeIterator* _tmp55_;
								GeeIterator* _pk_nip_it;
								_tmp48_ = cache_first_forward;
								_tmp49_ = netsukuku_counter_get_cache_records_response_get_cache (_tmp48_);
								_tmp50_ = _tmp49_;
								_tmp51_ = gee_abstract_map_get_keys ((GeeMap*) _tmp50_);
								_tmp52_ = _tmp51_;
								_tmp53_ = _tmp52_;
								_tmp54_ = gee_iterable_iterator ((GeeIterable*) _tmp53_);
								_tmp55_ = _tmp54_;
								_g_object_unref0 (_tmp53_);
								_pk_nip_it = _tmp55_;
								while (TRUE) {
									GeeIterator* _tmp56_;
									gboolean _tmp57_ = FALSE;
									GeeIterator* _tmp58_;
									gpointer _tmp59_ = NULL;
									NetsukukuPairPublicKeyNIP* pk_nip;
									GType _tmp60_ = 0UL;
									const gchar* _tmp61_ = NULL;
									const gchar* _tmp62_ = NULL;
									NetsukukuPairPublicKeyNIP* _tmp63_;
									gchar* _tmp64_ = NULL;
									gchar* _tmp65_;
									gint* _tmp66_;
									gchar* _tmp67_ = NULL;
									gchar* _tmp68_;
									gchar* _tmp69_ = NULL;
									gchar* _tmp70_;
									GeeHashMap* _tmp71_;
									NetsukukuPairPublicKeyNIP* _tmp72_;
									gboolean _tmp73_ = FALSE;
									_tmp56_ = _pk_nip_it;
									_tmp57_ = gee_iterator_next (_tmp56_);
									if (!_tmp57_) {
										break;
									}
									_tmp58_ = _pk_nip_it;
									_tmp59_ = gee_iterator_get (_tmp58_);
									pk_nip = (NetsukukuPairPublicKeyNIP*) _tmp59_;
									_tmp60_ = G_TYPE_FROM_INSTANCE ((GObject*) self);
									_tmp61_ = g_type_name (_tmp60_);
									_tmp62_ = string_to_string (_tmp61_);
									_tmp63_ = pk_nip;
									_tmp64_ = netsukuku_pair_public_key_nip_to_string (_tmp63_);
									_tmp65_ = _tmp64_;
									_tmp66_ = first_forward;
									_tmp67_ = g_strdup_printf ("%i", *_tmp66_);
									_tmp68_ = _tmp67_;
									_tmp69_ = g_strconcat (_tmp62_, ": hook: there is ", _tmp65_, " in cache of ", _tmp68_, NULL);
									_tmp70_ = _tmp69_;
									netsukuku_log_debug (_tmp70_);
									_g_free0 (_tmp70_);
									_g_free0 (_tmp68_);
									_g_free0 (_tmp65_);
									_tmp71_ = self->priv->cache;
									_tmp72_ = pk_nip;
									_tmp73_ = gee_abstract_map_has_key ((GeeAbstractMap*) _tmp71_, _tmp72_);
									if (!_tmp73_) {
										GeeHashMap* _tmp74_;
										NetsukukuPairPublicKeyNIP* _tmp75_;
										NetsukukuCounterGetCacheRecordsResponse* _tmp76_;
										GeeHashMap* _tmp77_;
										GeeHashMap* _tmp78_;
										NetsukukuPairPublicKeyNIP* _tmp79_;
										gpointer _tmp80_ = NULL;
										NetsukukuCounterNipRecord* _tmp81_;
										GType _tmp82_ = 0UL;
										const gchar* _tmp83_ = NULL;
										const gchar* _tmp84_ = NULL;
										NetsukukuPairPublicKeyNIP* _tmp85_;
										gchar* _tmp86_ = NULL;
										gchar* _tmp87_;
										gchar* _tmp88_ = NULL;
										gchar* _tmp89_;
										_tmp74_ = self->priv->cache;
										_tmp75_ = pk_nip;
										_tmp76_ = cache_first_forward;
										_tmp77_ = netsukuku_counter_get_cache_records_response_get_cache (_tmp76_);
										_tmp78_ = _tmp77_;
										_tmp79_ = pk_nip;
										_tmp80_ = gee_abstract_map_get ((GeeAbstractMap*) _tmp78_, _tmp79_);
										_tmp81_ = (NetsukukuCounterNipRecord*) _tmp80_;
										gee_abstract_map_set ((GeeAbstractMap*) _tmp74_, _tmp75_, _tmp81_);
										_g_object_unref0 (_tmp81_);
										_tmp82_ = G_TYPE_FROM_INSTANCE ((GObject*) self);
										_tmp83_ = g_type_name (_tmp82_);
										_tmp84_ = string_to_string (_tmp83_);
										_tmp85_ = pk_nip;
										_tmp86_ = netsukuku_pair_public_key_nip_to_string (_tmp85_);
										_tmp87_ = _tmp86_;
										_tmp88_ = g_strconcat (_tmp84_, ": hook: got ", _tmp87_, " in my cache", NULL);
										_tmp89_ = _tmp88_;
										netsukuku_log_debug (_tmp89_);
										_g_free0 (_tmp89_);
										_g_free0 (_tmp87_);
									}
									_g_object_unref0 (pk_nip);
								}
								_g_object_unref0 (_pk_nip_it);
							}
							_g_object_unref0 (cache_first_forward);
							_g_object_unref0 (peer_first_forward);
							_g_object_unref0 (nip_first_forward);
							_g_free0 (last_back);
							_g_free0 (first_back);
							_g_free0 (first_forward);
							break;
						} else {
							gint* _tmp90_;
							gint* _tmp91_;
							gint _tmp172_;
							gint* _tmp173_;
							NetsukukuNIP* _tmp174_ = NULL;
							NetsukukuNIP* nip_first_forward;
							NetsukukuNIP* _tmp175_;
							NetsukukuRmtCounterPeer* _tmp176_ = NULL;
							NetsukukuRmtCounterPeer* peer_first_forward;
							NetsukukuRmtCounterPeer* _tmp177_;
							NetsukukuCounterGetCacheRecordsResponse* _tmp178_ = NULL;
							NetsukukuCounterGetCacheRecordsResponse* cache_first_forward;
							_tmp90_ = first_back;
							_tmp91_ = last_back;
							if (_int_equal (_tmp90_, _tmp91_) != TRUE) {
								gint _tmp92_;
								gint* _tmp93_;
								NetsukukuNIP* _tmp94_ = NULL;
								NetsukukuNIP* nip_first_back;
								NetsukukuNIP* _tmp95_;
								NetsukukuRmtCounterPeer* _tmp96_ = NULL;
								NetsukukuRmtCounterPeer* peer_first_back;
								gint _tmp97_;
								gint* _tmp98_;
								NetsukukuNIP* _tmp99_ = NULL;
								NetsukukuNIP* nip_last_back;
								NetsukukuNIP* _tmp100_;
								NetsukukuRmtCounterPeer* _tmp101_ = NULL;
								NetsukukuRmtCounterPeer* peer_last_back;
								NetsukukuRmtCounterPeer* _tmp102_;
								NetsukukuCounterGetCacheRecordsResponse* _tmp103_ = NULL;
								NetsukukuCounterGetCacheRecordsResponse* recs_first;
								NetsukukuRmtCounterPeer* _tmp104_;
								NetsukukuCounterGetCacheRecordsResponse* _tmp105_ = NULL;
								NetsukukuCounterGetCacheRecordsResponse* recs_last;
								_tmp92_ = lvl;
								_tmp93_ = first_back;
								_tmp94_ = netsukuku_counter_nip_for_lvl_pos (self, _tmp92_, *_tmp93_);
								nip_first_back = _tmp94_;
								_tmp95_ = nip_first_back;
								_tmp96_ = netsukuku_counter_peer (self, _tmp95_, NULL, NULL);
								peer_first_back = _tmp96_;
								_tmp97_ = lvl;
								_tmp98_ = last_back;
								_tmp99_ = netsukuku_counter_nip_for_lvl_pos (self, _tmp97_, *_tmp98_);
								nip_last_back = _tmp99_;
								_tmp100_ = nip_last_back;
								_tmp101_ = netsukuku_counter_peer (self, _tmp100_, NULL, NULL);
								peer_last_back = _tmp101_;
								_tmp102_ = peer_first_back;
								_tmp103_ = netsukuku_icounter_as_peer_get_cache_records ((NetsukukuICounterAsPeer*) _tmp102_, &_inner_error_);
								recs_first = _tmp103_;
								if (_inner_error_ != NULL) {
									g_propagate_error (error, _inner_error_);
									_g_object_unref0 (peer_last_back);
									_g_object_unref0 (nip_last_back);
									_g_object_unref0 (peer_first_back);
									_g_object_unref0 (nip_first_back);
									_g_free0 (last_back);
									_g_free0 (first_back);
									_g_free0 (first_forward);
									return;
								}
								_tmp104_ = peer_last_back;
								_tmp105_ = netsukuku_icounter_as_peer_get_cache_records ((NetsukukuICounterAsPeer*) _tmp104_, &_inner_error_);
								recs_last = _tmp105_;
								if (_inner_error_ != NULL) {
									g_propagate_error (error, _inner_error_);
									_g_object_unref0 (recs_first);
									_g_object_unref0 (peer_last_back);
									_g_object_unref0 (nip_last_back);
									_g_object_unref0 (peer_first_back);
									_g_object_unref0 (nip_first_back);
									_g_free0 (last_back);
									_g_free0 (first_back);
									_g_free0 (first_forward);
									return;
								}
								{
									NetsukukuCounterGetCacheRecordsResponse* _tmp106_;
									GeeHashMap* _tmp107_;
									GeeHashMap* _tmp108_;
									GeeSet* _tmp109_;
									GeeSet* _tmp110_;
									GeeSet* _tmp111_;
									GeeIterator* _tmp112_ = NULL;
									GeeIterator* _tmp113_;
									GeeIterator* _pk_nip_it;
									_tmp106_ = recs_first;
									_tmp107_ = netsukuku_counter_get_cache_records_response_get_cache (_tmp106_);
									_tmp108_ = _tmp107_;
									_tmp109_ = gee_abstract_map_get_keys ((GeeMap*) _tmp108_);
									_tmp110_ = _tmp109_;
									_tmp111_ = _tmp110_;
									_tmp112_ = gee_iterable_iterator ((GeeIterable*) _tmp111_);
									_tmp113_ = _tmp112_;
									_g_object_unref0 (_tmp111_);
									_pk_nip_it = _tmp113_;
									while (TRUE) {
										GeeIterator* _tmp114_;
										gboolean _tmp115_ = FALSE;
										GeeIterator* _tmp116_;
										gpointer _tmp117_ = NULL;
										NetsukukuPairPublicKeyNIP* pk_nip;
										GType _tmp118_ = 0UL;
										const gchar* _tmp119_ = NULL;
										const gchar* _tmp120_ = NULL;
										NetsukukuPairPublicKeyNIP* _tmp121_;
										gchar* _tmp122_ = NULL;
										gchar* _tmp123_;
										gint* _tmp124_;
										gchar* _tmp125_ = NULL;
										gchar* _tmp126_;
										gchar* _tmp127_ = NULL;
										gchar* _tmp128_;
										GeeHashMap* _tmp129_;
										NetsukukuPairPublicKeyNIP* _tmp130_;
										gboolean _tmp131_ = FALSE;
										_tmp114_ = _pk_nip_it;
										_tmp115_ = gee_iterator_next (_tmp114_);
										if (!_tmp115_) {
											break;
										}
										_tmp116_ = _pk_nip_it;
										_tmp117_ = gee_iterator_get (_tmp116_);
										pk_nip = (NetsukukuPairPublicKeyNIP*) _tmp117_;
										_tmp118_ = G_TYPE_FROM_INSTANCE ((GObject*) self);
										_tmp119_ = g_type_name (_tmp118_);
										_tmp120_ = string_to_string (_tmp119_);
										_tmp121_ = pk_nip;
										_tmp122_ = netsukuku_pair_public_key_nip_to_string (_tmp121_);
										_tmp123_ = _tmp122_;
										_tmp124_ = first_back;
										_tmp125_ = g_strdup_printf ("%i", *_tmp124_);
										_tmp126_ = _tmp125_;
										_tmp127_ = g_strconcat (_tmp120_, ": hook: there is ", _tmp123_, " in cache of ", _tmp126_, NULL);
										_tmp128_ = _tmp127_;
										netsukuku_log_debug (_tmp128_);
										_g_free0 (_tmp128_);
										_g_free0 (_tmp126_);
										_g_free0 (_tmp123_);
										_tmp129_ = self->priv->cache;
										_tmp130_ = pk_nip;
										_tmp131_ = gee_abstract_map_has_key ((GeeAbstractMap*) _tmp129_, _tmp130_);
										if (!_tmp131_) {
											gboolean found;
											gboolean _tmp155_;
											found = FALSE;
											{
												NetsukukuCounterGetCacheRecordsResponse* _tmp132_;
												GeeHashMap* _tmp133_;
												GeeHashMap* _tmp134_;
												GeeSet* _tmp135_;
												GeeSet* _tmp136_;
												GeeSet* _tmp137_;
												GeeIterator* _tmp138_ = NULL;
												GeeIterator* _tmp139_;
												GeeIterator* _pk_nip2_it;
												_tmp132_ = recs_last;
												_tmp133_ = netsukuku_counter_get_cache_records_response_get_cache (_tmp132_);
												_tmp134_ = _tmp133_;
												_tmp135_ = gee_abstract_map_get_keys ((GeeMap*) _tmp134_);
												_tmp136_ = _tmp135_;
												_tmp137_ = _tmp136_;
												_tmp138_ = gee_iterable_iterator ((GeeIterable*) _tmp137_);
												_tmp139_ = _tmp138_;
												_g_object_unref0 (_tmp137_);
												_pk_nip2_it = _tmp139_;
												while (TRUE) {
													GeeIterator* _tmp140_;
													gboolean _tmp141_ = FALSE;
													GeeIterator* _tmp142_;
													gpointer _tmp143_ = NULL;
													NetsukukuPairPublicKeyNIP* pk_nip2;
													NetsukukuPairPublicKeyNIP* _tmp144_;
													NetsukukuPairPublicKeyNIP* _tmp145_;
													gboolean _tmp146_ = FALSE;
													_tmp140_ = _pk_nip2_it;
													_tmp141_ = gee_iterator_next (_tmp140_);
													if (!_tmp141_) {
														break;
													}
													_tmp142_ = _pk_nip2_it;
													_tmp143_ = gee_iterator_get (_tmp142_);
													pk_nip2 = (NetsukukuPairPublicKeyNIP*) _tmp143_;
													_tmp144_ = pk_nip2;
													_tmp145_ = pk_nip;
													_tmp146_ = netsukuku_pair_public_key_nip_equal_func (_tmp144_, _tmp145_);
													if (_tmp146_) {
														GType _tmp147_ = 0UL;
														const gchar* _tmp148_ = NULL;
														const gchar* _tmp149_ = NULL;
														gint* _tmp150_;
														gchar* _tmp151_ = NULL;
														gchar* _tmp152_;
														gchar* _tmp153_ = NULL;
														gchar* _tmp154_;
														found = TRUE;
														_tmp147_ = G_TYPE_FROM_INSTANCE ((GObject*) self);
														_tmp148_ = g_type_name (_tmp147_);
														_tmp149_ = string_to_string (_tmp148_);
														_tmp150_ = last_back;
														_tmp151_ = g_strdup_printf ("%i", *_tmp150_);
														_tmp152_ = _tmp151_;
														_tmp153_ = g_strconcat (_tmp149_, ": hook: but also in cache of ", _tmp152_, NULL);
														_tmp154_ = _tmp153_;
														netsukuku_log_debug (_tmp154_);
														_g_free0 (_tmp154_);
														_g_free0 (_tmp152_);
														_g_object_unref0 (pk_nip2);
														break;
													}
													_g_object_unref0 (pk_nip2);
												}
												_g_object_unref0 (_pk_nip2_it);
											}
											_tmp155_ = found;
											if (!_tmp155_) {
												GeeHashMap* _tmp156_;
												NetsukukuPairPublicKeyNIP* _tmp157_;
												NetsukukuCounterGetCacheRecordsResponse* _tmp158_;
												GeeHashMap* _tmp159_;
												GeeHashMap* _tmp160_;
												NetsukukuPairPublicKeyNIP* _tmp161_;
												gpointer _tmp162_ = NULL;
												NetsukukuCounterNipRecord* _tmp163_;
												GType _tmp164_ = 0UL;
												const gchar* _tmp165_ = NULL;
												const gchar* _tmp166_ = NULL;
												NetsukukuPairPublicKeyNIP* _tmp167_;
												gchar* _tmp168_ = NULL;
												gchar* _tmp169_;
												gchar* _tmp170_ = NULL;
												gchar* _tmp171_;
												_tmp156_ = self->priv->cache;
												_tmp157_ = pk_nip;
												_tmp158_ = recs_first;
												_tmp159_ = netsukuku_counter_get_cache_records_response_get_cache (_tmp158_);
												_tmp160_ = _tmp159_;
												_tmp161_ = pk_nip;
												_tmp162_ = gee_abstract_map_get ((GeeAbstractMap*) _tmp160_, _tmp161_);
												_tmp163_ = (NetsukukuCounterNipRecord*) _tmp162_;
												gee_abstract_map_set ((GeeAbstractMap*) _tmp156_, _tmp157_, _tmp163_);
												_g_object_unref0 (_tmp163_);
												_tmp164_ = G_TYPE_FROM_INSTANCE ((GObject*) self);
												_tmp165_ = g_type_name (_tmp164_);
												_tmp166_ = string_to_string (_tmp165_);
												_tmp167_ = pk_nip;
												_tmp168_ = netsukuku_pair_public_key_nip_to_string (_tmp167_);
												_tmp169_ = _tmp168_;
												_tmp170_ = g_strconcat (_tmp166_, ": hook: got ", _tmp169_, " in my cache", NULL);
												_tmp171_ = _tmp170_;
												netsukuku_log_debug (_tmp171_);
												_g_free0 (_tmp171_);
												_g_free0 (_tmp169_);
											}
										}
										_g_object_unref0 (pk_nip);
									}
									_g_object_unref0 (_pk_nip_it);
								}
								_g_object_unref0 (recs_last);
								_g_object_unref0 (recs_first);
								_g_object_unref0 (peer_last_back);
								_g_object_unref0 (nip_last_back);
								_g_object_unref0 (peer_first_back);
								_g_object_unref0 (nip_first_back);
							}
							_tmp172_ = lvl;
							_tmp173_ = first_forward;
							_tmp174_ = netsukuku_counter_nip_for_lvl_pos (self, _tmp172_, *_tmp173_);
							nip_first_forward = _tmp174_;
							_tmp175_ = nip_first_forward;
							_tmp176_ = netsukuku_counter_peer (self, _tmp175_, NULL, NULL);
							peer_first_forward = _tmp176_;
							_tmp177_ = peer_first_forward;
							_tmp178_ = netsukuku_icounter_as_peer_get_cache_records ((NetsukukuICounterAsPeer*) _tmp177_, &_inner_error_);
							cache_first_forward = _tmp178_;
							if (_inner_error_ != NULL) {
								g_propagate_error (error, _inner_error_);
								_g_object_unref0 (peer_first_forward);
								_g_object_unref0 (nip_first_forward);
								_g_free0 (last_back);
								_g_free0 (first_back);
								_g_free0 (first_forward);
								return;
							}
							{
								NetsukukuCounterGetCacheRecordsResponse* _tmp179_;
								GeeHashMap* _tmp180_;
								GeeHashMap* _tmp181_;
								GeeSet* _tmp182_;
								GeeSet* _tmp183_;
								GeeSet* _tmp184_;
								GeeIterator* _tmp185_ = NULL;
								GeeIterator* _tmp186_;
								GeeIterator* _pk_nip_it;
								_tmp179_ = cache_first_forward;
								_tmp180_ = netsukuku_counter_get_cache_records_response_get_cache (_tmp179_);
								_tmp181_ = _tmp180_;
								_tmp182_ = gee_abstract_map_get_keys ((GeeMap*) _tmp181_);
								_tmp183_ = _tmp182_;
								_tmp184_ = _tmp183_;
								_tmp185_ = gee_iterable_iterator ((GeeIterable*) _tmp184_);
								_tmp186_ = _tmp185_;
								_g_object_unref0 (_tmp184_);
								_pk_nip_it = _tmp186_;
								while (TRUE) {
									GeeIterator* _tmp187_;
									gboolean _tmp188_ = FALSE;
									GeeIterator* _tmp189_;
									gpointer _tmp190_ = NULL;
									NetsukukuPairPublicKeyNIP* pk_nip;
									GType _tmp191_ = 0UL;
									const gchar* _tmp192_ = NULL;
									const gchar* _tmp193_ = NULL;
									NetsukukuPairPublicKeyNIP* _tmp194_;
									gchar* _tmp195_ = NULL;
									gchar* _tmp196_;
									gint* _tmp197_;
									gchar* _tmp198_ = NULL;
									gchar* _tmp199_;
									gchar* _tmp200_ = NULL;
									gchar* _tmp201_;
									GeeHashMap* _tmp202_;
									NetsukukuPairPublicKeyNIP* _tmp203_;
									gboolean _tmp204_ = FALSE;
									_tmp187_ = _pk_nip_it;
									_tmp188_ = gee_iterator_next (_tmp187_);
									if (!_tmp188_) {
										break;
									}
									_tmp189_ = _pk_nip_it;
									_tmp190_ = gee_iterator_get (_tmp189_);
									pk_nip = (NetsukukuPairPublicKeyNIP*) _tmp190_;
									_tmp191_ = G_TYPE_FROM_INSTANCE ((GObject*) self);
									_tmp192_ = g_type_name (_tmp191_);
									_tmp193_ = string_to_string (_tmp192_);
									_tmp194_ = pk_nip;
									_tmp195_ = netsukuku_pair_public_key_nip_to_string (_tmp194_);
									_tmp196_ = _tmp195_;
									_tmp197_ = first_forward;
									_tmp198_ = g_strdup_printf ("%i", *_tmp197_);
									_tmp199_ = _tmp198_;
									_tmp200_ = g_strconcat (_tmp193_, ": hook: there is ", _tmp196_, " in cache of ", _tmp199_, NULL);
									_tmp201_ = _tmp200_;
									netsukuku_log_debug (_tmp201_);
									_g_free0 (_tmp201_);
									_g_free0 (_tmp199_);
									_g_free0 (_tmp196_);
									_tmp202_ = self->priv->cache;
									_tmp203_ = pk_nip;
									_tmp204_ = gee_abstract_map_has_key ((GeeAbstractMap*) _tmp202_, _tmp203_);
									if (!_tmp204_) {
										gboolean check;
										NetsukukuPairPublicKeyNIP* _tmp205_;
										NetsukukuNIP* _tmp206_;
										NetsukukuNIP* _tmp207_;
										NetsukukuNIP* _tmp208_ = NULL;
										NetsukukuNIP* _tmp209_;
										gint _tmp210_;
										gint _tmp211_ = 0;
										gint _tmp212_;
										gint hk;
										gint _tmp213_;
										GeeList* _tmp214_ = NULL;
										GeeList* ids;
										GeeList* _tmp215_;
										gint* _tmp216_;
										gint _tmp217_ = 0;
										GeeList* _tmp218_;
										NetsukukuMapRoute* _tmp219_;
										NetsukukuNIP* _tmp220_;
										NetsukukuNIP* _tmp221_;
										gint _tmp222_;
										gint _tmp223_ = 0;
										gint _tmp224_ = 0;
										gboolean _tmp225_;
										check = FALSE;
										_tmp205_ = pk_nip;
										_tmp206_ = netsukuku_pair_public_key_nip_get_nip (_tmp205_);
										_tmp207_ = _tmp206_;
										_tmp208_ = netsukuku_peer_to_peer_h ((NetsukukuPeerToPeer*) self, (GObject*) _tmp207_);
										_tmp209_ = _tmp208_;
										_tmp210_ = lvl;
										_tmp211_ = netsukuku_partial_nip_position_at ((NetsukukuPartialNIP*) _tmp209_, _tmp210_);
										_tmp212_ = _tmp211_;
										_g_object_unref0 (_tmp209_);
										hk = _tmp212_;
										_tmp213_ = hk;
										_tmp214_ = netsukuku_peer_to_peer_list_ids ((NetsukukuPeerToPeer*) self, _tmp213_, 1);
										ids = _tmp214_;
										_tmp215_ = ids;
										_tmp216_ = first_forward;
										_tmp217_ = gee_list_index_of (_tmp215_, (gpointer) ((gintptr) (*_tmp216_)));
										_tmp218_ = ids;
										_tmp219_ = ((NetsukukuPeerToPeer*) self)->maproute;
										_tmp220_ = netsukuku_map_get_me ((NetsukukuMap*) _tmp219_);
										_tmp221_ = _tmp220_;
										_tmp222_ = lvl;
										_tmp223_ = netsukuku_partial_nip_position_at ((NetsukukuPartialNIP*) _tmp221_, _tmp222_);
										_tmp224_ = gee_list_index_of (_tmp218_, (gpointer) ((gintptr) _tmp223_));
										if (_tmp217_ > _tmp224_) {
											check = TRUE;
										}
										_tmp225_ = check;
										if (_tmp225_) {
											GeeHashMap* _tmp226_;
											NetsukukuPairPublicKeyNIP* _tmp227_;
											NetsukukuCounterGetCacheRecordsResponse* _tmp228_;
											GeeHashMap* _tmp229_;
											GeeHashMap* _tmp230_;
											NetsukukuPairPublicKeyNIP* _tmp231_;
											gpointer _tmp232_ = NULL;
											NetsukukuCounterNipRecord* _tmp233_;
											GType _tmp234_ = 0UL;
											const gchar* _tmp235_ = NULL;
											const gchar* _tmp236_ = NULL;
											NetsukukuPairPublicKeyNIP* _tmp237_;
											gchar* _tmp238_ = NULL;
											gchar* _tmp239_;
											gchar* _tmp240_ = NULL;
											gchar* _tmp241_;
											_tmp226_ = self->priv->cache;
											_tmp227_ = pk_nip;
											_tmp228_ = cache_first_forward;
											_tmp229_ = netsukuku_counter_get_cache_records_response_get_cache (_tmp228_);
											_tmp230_ = _tmp229_;
											_tmp231_ = pk_nip;
											_tmp232_ = gee_abstract_map_get ((GeeAbstractMap*) _tmp230_, _tmp231_);
											_tmp233_ = (NetsukukuCounterNipRecord*) _tmp232_;
											gee_abstract_map_set ((GeeAbstractMap*) _tmp226_, _tmp227_, _tmp233_);
											_g_object_unref0 (_tmp233_);
											_tmp234_ = G_TYPE_FROM_INSTANCE ((GObject*) self);
											_tmp235_ = g_type_name (_tmp234_);
											_tmp236_ = string_to_string (_tmp235_);
											_tmp237_ = pk_nip;
											_tmp238_ = netsukuku_pair_public_key_nip_to_string (_tmp237_);
											_tmp239_ = _tmp238_;
											_tmp240_ = g_strconcat (_tmp236_, ": hook: got ", _tmp239_, " in my cache", NULL);
											_tmp241_ = _tmp240_;
											netsukuku_log_debug (_tmp241_);
											_g_free0 (_tmp241_);
											_g_free0 (_tmp239_);
										}
										_g_object_unref0 (ids);
									}
									_g_object_unref0 (pk_nip);
								}
								_g_object_unref0 (_pk_nip_it);
							}
							_g_object_unref0 (cache_first_forward);
							_g_object_unref0 (peer_first_forward);
							_g_object_unref0 (nip_first_forward);
							_g_free0 (last_back);
							_g_free0 (first_back);
							_g_free0 (first_forward);
							break;
						}
					}
					_g_free0 (last_back);
					_g_free0 (first_back);
					_g_free0 (first_forward);
				}
			}
		}
		g_signal_emit_by_name (self, "counter-hooked");
		self->priv->hooked_to_service = TRUE;
		_tmp242_ = G_TYPE_FROM_INSTANCE ((GObject*) self);
		_tmp243_ = g_type_name (_tmp242_);
		_tmp244_ = string_to_string (_tmp243_);
		_tmp245_ = g_strconcat (_tmp244_, ": hook: finished.", NULL);
		_tmp246_ = _tmp245_;
		netsukuku_log_debug (_tmp246_);
		_g_free0 (_tmp246_);
		netsukuku_optional_peer_to_peer_participate ((NetsukukuOptionalPeerToPeer*) self);
		netsukuku_log_info ("Counter service: participating.");
	}
}


static void* netsukuku_counter_helper_hook_to_service (void* v, GError** error) {
	void* result = NULL;
	void* _tmp0_;
	Netsukukustruct_helper_Counter_hook_to_service* tuple_p;
	NetsukukuCounter* _tmp1_;
	NetsukukuCounter* _tmp2_;
	NetsukukuCounter* self_save;
	GError * _inner_error_ = NULL;
	_tmp0_ = v;
	tuple_p = (Netsukukustruct_helper_Counter_hook_to_service*) _tmp0_;
	_tmp1_ = (*tuple_p).self;
	_tmp2_ = _g_object_ref0 (_tmp1_);
	self_save = _tmp2_;
	tasklets_tasklet_schedule_back ();
	netsukuku_counter_impl_hook_to_service (self_save, &_inner_error_);
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		_g_object_unref0 (self_save);
		return NULL;
	}
	result = NULL;
	_g_object_unref0 (self_save);
	return result;
}


void netsukuku_counter_hook_to_service (NetsukukuCounter* self) {
	Netsukukustruct_helper_Counter_hook_to_service arg = {0};
	NetsukukuCounter* _tmp0_;
	TaskletsTasklet* _tmp1_ = NULL;
	TaskletsTasklet* _tmp2_;
	g_return_if_fail (self != NULL);
	memset (&arg, 0, sizeof (Netsukukustruct_helper_Counter_hook_to_service));
	_tmp0_ = _g_object_ref0 (self);
	_g_object_unref0 (arg.self);
	arg.self = _tmp0_;
	_tmp1_ = tasklets_tasklet_spawn ((FunctionDelegate) netsukuku_counter_helper_hook_to_service, &arg, FALSE, -1);
	_tmp2_ = _tmp1_;
	_g_object_unref0 (_tmp2_);
	netsukuku_struct_helper_counter_hook_to_service_destroy (&arg);
}


/** This is the function h:KEY-->hIP.
          */
static guint8* string_get_data (const gchar* self, int* result_length1) {
	guint8* result;
	guint8* res;
	gint res_length1;
	gint _res_size_;
	gint _tmp0_;
	gint _tmp1_;
	gint _tmp2_;
	guint8* _tmp3_;
	gint _tmp3__length1;
	guint8* _tmp4_;
	gint _tmp4__length1;
	g_return_val_if_fail (self != NULL, NULL);
	res = (guint8*) self;
	res_length1 = -1;
	_res_size_ = res_length1;
	_tmp0_ = strlen (self);
	_tmp1_ = _tmp0_;
	res_length1 = (gint) _tmp1_;
	_tmp2_ = res_length1;
	_tmp3_ = res;
	_tmp3__length1 = res_length1;
	_tmp4_ = _tmp3_;
	_tmp4__length1 = _tmp3__length1;
	if (result_length1) {
		*result_length1 = _tmp4__length1;
	}
	result = _tmp4_;
	return result;
}


static NetsukukuNIP* netsukuku_counter_real_h (NetsukukuPeerToPeer* base, GObject* key) {
	NetsukukuCounter * self;
	NetsukukuNIP* result = NULL;
	GObject* _tmp0_;
	NetsukukuNIP* _tmp1_;
	NetsukukuNIP* _key;
	gchar* _tmp2_ = NULL;
	gchar* _tmp3_;
	guint8* _tmp4_;
	gint _tmp4__length1;
	guint8* _tmp5_;
	gint _tmp5__length1;
	gint _tmp6_ = 0;
	guint8* _tmp7_ = NULL;
	guint8* _tmp8_;
	gint _tmp8__length1;
	guint8* hash;
	gint hash_length1;
	gint _hash_size_;
	guint8 _tmp9_;
	guint8 _tmp10_;
	guint8 _tmp11_;
	guint8 _tmp12_;
	guint32 basic_hash;
	NetsukukuMapRoute* _tmp13_;
	gint _tmp14_;
	gint _tmp15_;
	gint* _tmp16_ = NULL;
	gint* positions;
	gint positions_length1;
	gint _positions_size_;
	gint* _tmp36_;
	gint _tmp36__length1;
	NetsukukuNIP* _tmp37_;
	NetsukukuNIP* ret;
	GType _tmp38_ = 0UL;
	const gchar* _tmp39_ = NULL;
	const gchar* _tmp40_ = NULL;
	gchar* _tmp41_ = NULL;
	gchar* _tmp42_;
	NetsukukuNIP* _tmp43_;
	gchar* _tmp44_ = NULL;
	gchar* _tmp45_;
	gchar* _tmp46_ = NULL;
	gchar* _tmp47_;
	GError * _inner_error_ = NULL;
	self = (NetsukukuCounter*) base;
	g_return_val_if_fail (key != NULL, NULL);
	_tmp0_ = key;
	_tmp1_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, NETSUKUKU_TYPE_NIP, NetsukukuNIP));
	_key = _tmp1_;
	_tmp2_ = netsukuku_partial_nip_to_string ((NetsukukuPartialNIP*) _key);
	_tmp3_ = _tmp2_;
	_tmp4_ = string_get_data (_tmp3_, &_tmp4__length1);
	_tmp5_ = _tmp4_;
	_tmp5__length1 = _tmp4__length1;
	_tmp7_ = netsukuku_crypto_md5 (_tmp5_, _tmp5__length1, &_tmp6_, &_inner_error_);
	_tmp8_ = _tmp7_;
	_tmp8__length1 = _tmp6_;
	_g_free0 (_tmp3_);
	hash = _tmp8_;
	hash_length1 = _tmp8__length1;
	_hash_size_ = hash_length1;
	if (_inner_error_ != NULL) {
		_g_object_unref0 (_key);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return NULL;
	}
	_tmp9_ = hash[15];
	_tmp10_ = hash[14];
	_tmp11_ = hash[13];
	_tmp12_ = hash[12];
	basic_hash = ((((guint32) _tmp9_) + (((guint32) _tmp10_) * ((guint32) 256))) + ((((guint32) _tmp11_) * ((guint32) 256)) * ((guint32) 256))) + (((((guint32) _tmp12_) * ((guint32) 256)) * ((guint32) 256)) * ((guint32) 256));
	_tmp13_ = ((NetsukukuPeerToPeer*) self)->maproute;
	_tmp14_ = netsukuku_map_get_levels ((NetsukukuMap*) _tmp13_);
	_tmp15_ = _tmp14_;
	_tmp16_ = g_new0 (gint, _tmp15_);
	positions = _tmp16_;
	positions_length1 = _tmp15_;
	_positions_size_ = positions_length1;
	{
		gint lvl;
		lvl = 0;
		{
			gboolean _tmp17_;
			_tmp17_ = TRUE;
			while (TRUE) {
				gboolean _tmp18_;
				gint _tmp20_;
				NetsukukuMapRoute* _tmp21_;
				gint _tmp22_;
				gint _tmp23_;
				guint32 _tmp24_;
				NetsukukuMapRoute* _tmp25_;
				gint _tmp26_;
				gint _tmp27_;
				guint pos;
				gint* _tmp28_;
				gint _tmp28__length1;
				gint _tmp29_;
				guint _tmp30_;
				gint _tmp31_;
				guint32 _tmp32_;
				NetsukukuMapRoute* _tmp33_;
				gint _tmp34_;
				gint _tmp35_;
				_tmp18_ = _tmp17_;
				if (!_tmp18_) {
					gint _tmp19_;
					_tmp19_ = lvl;
					lvl = _tmp19_ + 1;
				}
				_tmp17_ = FALSE;
				_tmp20_ = lvl;
				_tmp21_ = ((NetsukukuPeerToPeer*) self)->maproute;
				_tmp22_ = netsukuku_map_get_levels ((NetsukukuMap*) _tmp21_);
				_tmp23_ = _tmp22_;
				if (!(_tmp20_ < _tmp23_)) {
					break;
				}
				_tmp24_ = basic_hash;
				_tmp25_ = ((NetsukukuPeerToPeer*) self)->maproute;
				_tmp26_ = netsukuku_map_get_gsize ((NetsukukuMap*) _tmp25_);
				_tmp27_ = _tmp26_;
				pos = (guint) (_tmp24_ % _tmp27_);
				_tmp28_ = positions;
				_tmp28__length1 = positions_length1;
				_tmp29_ = lvl;
				_tmp30_ = pos;
				_tmp28_[_tmp29_] = (gint) _tmp30_;
				_tmp31_ = _tmp28_[_tmp29_];
				_tmp32_ = basic_hash;
				_tmp33_ = ((NetsukukuPeerToPeer*) self)->maproute;
				_tmp34_ = netsukuku_map_get_gsize ((NetsukukuMap*) _tmp33_);
				_tmp35_ = _tmp34_;
				basic_hash = _tmp32_ / _tmp35_;
			}
		}
	}
	_tmp36_ = positions;
	_tmp36__length1 = positions_length1;
	_tmp37_ = netsukuku_nip_new (_tmp36_, _tmp36__length1);
	ret = _tmp37_;
	_tmp38_ = G_TYPE_FROM_INSTANCE ((GObject*) self);
	_tmp39_ = g_type_name (_tmp38_);
	_tmp40_ = string_to_string (_tmp39_);
	_tmp41_ = netsukuku_partial_nip_to_string ((NetsukukuPartialNIP*) _key);
	_tmp42_ = _tmp41_;
	_tmp43_ = ret;
	_tmp44_ = netsukuku_partial_nip_to_string ((NetsukukuPartialNIP*) _tmp43_);
	_tmp45_ = _tmp44_;
	_tmp46_ = g_strconcat (_tmp40_, ": hash: '", _tmp42_, "' becomes ", _tmp45_, NULL);
	_tmp47_ = _tmp46_;
	netsukuku_log_debug (_tmp47_);
	_g_free0 (_tmp47_);
	_g_free0 (_tmp45_);
	_g_free0 (_tmp42_);
	result = ret;
	positions = (g_free (positions), NULL);
	hash = (g_free (hash), NULL);
	_g_object_unref0 (_key);
	return result;
}


static void netsukuku_counter_impl_reset_my_counter_node (NetsukukuCounter* self, GError** error) {
	TaskletsTasklet* _tmp0_ = NULL;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	tasklets_tasklet_declare_self ("Counter.reset_my_counter_node");
	_tmp0_ = tasklets_tasklet_self ();
	_g_object_unref0 (self->priv->reset_my_counter_node_tasklet);
	self->priv->reset_my_counter_node_tasklet = _tmp0_;
	while (TRUE) {
		NetsukukuTimeCapsule* ttl = NULL;
		{
			NetsukukuCounterSetDataResponse* _tmp1_ = NULL;
			NetsukukuCounterSetDataResponse* resp;
			NetsukukuCounterSetDataResponse* _tmp2_;
			const gchar* _tmp3_;
			const gchar* _tmp4_;
			_tmp1_ = netsukuku_counter_ask_set_data_for_pubk (self);
			resp = _tmp1_;
			_tmp2_ = resp;
			_tmp3_ = netsukuku_counter_set_data_response_get_response (_tmp2_);
			_tmp4_ = _tmp3_;
			if (g_strcmp0 (_tmp4_, "OK") == 0) {
				NetsukukuCounterSetDataResponse* _tmp5_;
				NetsukukuTimeCapsule* _tmp6_;
				NetsukukuTimeCapsule* _tmp7_;
				NetsukukuTimeCapsule* _tmp8_;
				NetsukukuTimeCapsule* _tmp9_;
				gint64 _tmp10_ = 0LL;
				NetsukukuTimeCapsule* _tmp11_;
				NetsukukuTimeCapsule* _tmp12_;
				NetsukukuTimeCapsule* maxttl;
				NetsukukuTimeCapsule* _tmp13_;
				NetsukukuTimeCapsule* _tmp14_;
				gboolean _tmp15_ = FALSE;
				g_signal_emit_by_name (self, "counter-registered");
				_tmp5_ = resp;
				_tmp6_ = netsukuku_counter_set_data_response_get_expires (_tmp5_);
				_tmp7_ = _tmp6_;
				_tmp8_ = _g_object_ref0 (_tmp7_);
				_g_object_unref0 (ttl);
				ttl = _tmp8_;
				_tmp9_ = ttl;
				_tmp10_ = tasklets_timer_get_msec_ttl ((TaskletsTimer*) _tmp9_);
				_tmp11_ = netsukuku_time_capsule_new (_tmp10_ - ((((gint64) 1000) * ((gint64) 60)) * ((gint64) 10)));
				_g_object_unref0 (ttl);
				ttl = _tmp11_;
				_tmp12_ = netsukuku_time_capsule_new (NETSUKUKU_MAX_WAIT_REFRESH_COUNTER);
				maxttl = _tmp12_;
				_tmp13_ = ttl;
				_tmp14_ = maxttl;
				_tmp15_ = tasklets_timer_is_younger ((TaskletsTimer*) _tmp13_, (TaskletsTimer*) _tmp14_);
				if (_tmp15_) {
					NetsukukuTimeCapsule* _tmp16_;
					NetsukukuTimeCapsule* _tmp17_;
					_tmp16_ = maxttl;
					_tmp17_ = _g_object_ref0 (_tmp16_);
					_g_object_unref0 (ttl);
					ttl = _tmp17_;
				}
				_g_object_unref0 (maxttl);
			} else {
				NetsukukuTimeCapsule* _tmp18_;
				_tmp18_ = netsukuku_time_capsule_new ((((gint64) 1000) * ((gint64) 60)) * ((gint64) 2));
				_g_object_unref0 (ttl);
				ttl = _tmp18_;
			}
			_g_object_unref0 (resp);
		}
		goto __finally42;
		__catch42_g_error:
		{
			GError* e = NULL;
			NetsukukuTimeCapsule* _tmp19_;
			e = _inner_error_;
			_inner_error_ = NULL;
			_tmp19_ = netsukuku_time_capsule_new ((((gint64) 1000) * ((gint64) 60)) * ((gint64) 2));
			_g_object_unref0 (ttl);
			ttl = _tmp19_;
			_g_error_free0 (e);
		}
		__finally42:
		if (_inner_error_ != NULL) {
			g_propagate_error (error, _inner_error_);
			_g_object_unref0 (ttl);
			return;
		}
		while (TRUE) {
			NetsukukuTimeCapsule* _tmp20_;
			gboolean _tmp21_ = FALSE;
			_tmp20_ = ttl;
			_tmp21_ = tasklets_timer_is_expired ((TaskletsTimer*) _tmp20_);
			if (!(!_tmp21_)) {
				break;
			}
			tasklets_tasklet_nap ((glong) 0, (glong) 100000);
		}
		_g_object_unref0 (ttl);
	}
}


static void* netsukuku_counter_helper_reset_my_counter_node (void* v, GError** error) {
	void* result = NULL;
	void* _tmp0_;
	Netsukukustruct_helper_Counter_reset_my_counter_node* tuple_p;
	NetsukukuCounter* _tmp1_;
	NetsukukuCounter* _tmp2_;
	NetsukukuCounter* self_save;
	GError * _inner_error_ = NULL;
	_tmp0_ = v;
	tuple_p = (Netsukukustruct_helper_Counter_reset_my_counter_node*) _tmp0_;
	_tmp1_ = (*tuple_p).self;
	_tmp2_ = _g_object_ref0 (_tmp1_);
	self_save = _tmp2_;
	tasklets_tasklet_schedule_back ();
	netsukuku_counter_impl_reset_my_counter_node (self_save, &_inner_error_);
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		_g_object_unref0 (self_save);
		return NULL;
	}
	result = NULL;
	_g_object_unref0 (self_save);
	return result;
}


void netsukuku_counter_reset_my_counter_node (NetsukukuCounter* self) {
	Netsukukustruct_helper_Counter_reset_my_counter_node arg = {0};
	NetsukukuCounter* _tmp0_;
	TaskletsTasklet* _tmp1_ = NULL;
	TaskletsTasklet* _tmp2_;
	g_return_if_fail (self != NULL);
	memset (&arg, 0, sizeof (Netsukukustruct_helper_Counter_reset_my_counter_node));
	_tmp0_ = _g_object_ref0 (self);
	_g_object_unref0 (arg.self);
	arg.self = _tmp0_;
	_tmp1_ = tasklets_tasklet_spawn ((FunctionDelegate) netsukuku_counter_helper_reset_my_counter_node, &arg, FALSE, -1);
	_tmp2_ = _tmp1_;
	_g_object_unref0 (_tmp2_);
	netsukuku_struct_helper_counter_reset_my_counter_node_destroy (&arg);
}


void netsukuku_counter_stop_reset_my_counter_node (NetsukukuCounter* self) {
	TaskletsTasklet* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->reset_my_counter_node_tasklet;
	if (_tmp0_ != NULL) {
		TaskletsTasklet* _tmp1_;
		_tmp1_ = self->priv->reset_my_counter_node_tasklet;
		tasklets_tasklet_abort (_tmp1_);
	}
	_g_object_unref0 (self->priv->reset_my_counter_node_tasklet);
	self->priv->reset_my_counter_node_tasklet = NULL;
}


gboolean netsukuku_counter_reset_my_counter_node_ongoing (NetsukukuCounter* self) {
	gboolean result = FALSE;
	TaskletsTasklet* _tmp0_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->reset_my_counter_node_tasklet;
	result = _tmp0_ != NULL;
	return result;
}


static NetsukukuCounterSetDataResponse* netsukuku_counter_ask_set_data_for_pubk (NetsukukuCounter* self) {
	NetsukukuCounterSetDataResponse* result = NULL;
	GeeArrayList* _tmp0_;
	GeeArrayList* _tmp1_;
	zcdSerializableBuffer* _tmp2_ = NULL;
	zcdSerializableBuffer* signature;
	NetsukukuMapRoute* _tmp3_;
	NetsukukuNIP* _tmp4_;
	NetsukukuNIP* _tmp5_;
	NetsukukuRmtCounterPeer* _tmp6_ = NULL;
	NetsukukuRmtCounterPeer* _tmp7_;
	NetsukukuMapRoute* _tmp8_;
	NetsukukuNIP* _tmp9_;
	NetsukukuNIP* _tmp10_;
	GeeArrayList* _tmp11_;
	GeeArrayList* _tmp12_;
	NetsukukuPublicKey* _tmp13_;
	NetsukukuCounterSetDataResponse* _tmp14_ = NULL;
	NetsukukuCounterSetDataResponse* _tmp15_;
	NetsukukuCounterSetDataResponse* _tmp16_;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	netsukuku_log_debug ("COUNTER: ask_set_data_for_pubk");
	_tmp0_ = netsukuku_counter_get_hashednames (self);
	_tmp1_ = _tmp0_;
	_tmp2_ = _netsukuku_counter_sign (self, (GeeList*) _tmp1_);
	signature = _tmp2_;
	_tmp3_ = ((NetsukukuPeerToPeer*) self)->maproute;
	_tmp4_ = netsukuku_map_get_me ((NetsukukuMap*) _tmp3_);
	_tmp5_ = _tmp4_;
	_tmp6_ = netsukuku_counter_peer (self, NULL, (GObject*) _tmp5_, NULL);
	_tmp7_ = _tmp6_;
	_tmp8_ = ((NetsukukuPeerToPeer*) self)->maproute;
	_tmp9_ = netsukuku_map_get_me ((NetsukukuMap*) _tmp8_);
	_tmp10_ = _tmp9_;
	_tmp11_ = netsukuku_counter_get_hashednames (self);
	_tmp12_ = _tmp11_;
	_tmp13_ = self->priv->pubk;
	_tmp14_ = netsukuku_icounter_as_peer_set_data_for_pubk ((NetsukukuICounterAsPeer*) _tmp7_, _tmp10_, (GeeList*) _tmp12_, _tmp13_, signature, TRUE, &_inner_error_);
	_tmp15_ = _tmp14_;
	_g_object_unref0 (_tmp7_);
	_tmp16_ = _tmp15_;
	if (_inner_error_ != NULL) {
		_g_object_unref0 (signature);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return NULL;
	}
	result = _tmp16_;
	_g_object_unref0 (signature);
	return result;
}


static zcdSerializableBuffer* _netsukuku_counter_sign (NetsukukuCounter* self, GeeList* hashed_domains) {
	zcdSerializableBuffer* result = NULL;
	NetsukukuKeyPair* _tmp0_;
	NetsukukuMapRoute* _tmp1_;
	NetsukukuNIP* _tmp2_;
	NetsukukuNIP* _tmp3_;
	GeeList* _tmp4_;
	gint _tmp5_ = 0;
	guchar* _tmp6_ = NULL;
	guchar* _tmp7_;
	gint _tmp7__length1;
	gint _tmp8_ = 0;
	guchar* _tmp9_ = NULL;
	guchar* _tmp10_;
	gint _tmp10__length1;
	guchar* _signed_;
	gint _signed__length1;
	gint __signed__size_;
	zcdSerializableBuffer* _tmp11_;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (hashed_domains != NULL, NULL);
	_tmp0_ = self->priv->my_keys;
	_tmp1_ = ((NetsukukuPeerToPeer*) self)->maproute;
	_tmp2_ = netsukuku_map_get_me ((NetsukukuMap*) _tmp1_);
	_tmp3_ = _tmp2_;
	_tmp4_ = hashed_domains;
	_tmp6_ = netsukuku_counter_utilities_prepare_msg (_tmp3_, _tmp4_, &_tmp5_);
	_tmp7_ = _tmp6_;
	_tmp7__length1 = _tmp5_;
	_tmp9_ = netsukuku_key_pair_sign (_tmp0_, _tmp7_, _tmp5_, &_tmp8_, &_inner_error_);
	_tmp10_ = _tmp9_;
	_tmp10__length1 = _tmp8_;
	_tmp7_ = (g_free (_tmp7_), NULL);
	_signed_ = _tmp10_;
	_signed__length1 = _tmp10__length1;
	__signed__size_ = _signed__length1;
	if (_inner_error_ != NULL) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return NULL;
	}
	_tmp11_ = zcd_serializable_buffer_new ((guint8*) _signed_, (_signed__length1 * sizeof (guchar)) / sizeof (guint8));
	result = _tmp11_;
	_signed_ = (g_free (_signed_), NULL);
	return result;
}


static gboolean _netsukuku_counter_verify (NetsukukuCounter* self, NetsukukuNIP* nip, GeeList* hashed_domains, NetsukukuPublicKey* pubk, zcdSerializableBuffer* signature) {
	gboolean result = FALSE;
	NetsukukuPublicKey* _tmp0_;
	NetsukukuPublicKeyWrapper* _tmp1_;
	NetsukukuPublicKeyWrapper* pkw;
	NetsukukuPublicKeyWrapper* _tmp2_;
	NetsukukuNIP* _tmp3_;
	GeeList* _tmp4_;
	gint _tmp5_ = 0;
	guchar* _tmp6_ = NULL;
	guchar* _tmp7_;
	gint _tmp7__length1;
	zcdSerializableBuffer* _tmp8_;
	guint8* _tmp9_;
	gint _tmp9__length1;
	guint8* _tmp10_;
	gint _tmp10__length1;
	gboolean _tmp11_ = FALSE;
	gboolean _tmp12_;
	gboolean _tmp13_;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (nip != NULL, FALSE);
	g_return_val_if_fail (hashed_domains != NULL, FALSE);
	g_return_val_if_fail (pubk != NULL, FALSE);
	g_return_val_if_fail (signature != NULL, FALSE);
	_tmp0_ = pubk;
	_tmp1_ = netsukuku_public_key_wrapper_new_from_pubk (_tmp0_, &_inner_error_);
	pkw = _tmp1_;
	if (_inner_error_ != NULL) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return FALSE;
	}
	_tmp2_ = pkw;
	_tmp3_ = nip;
	_tmp4_ = hashed_domains;
	_tmp6_ = netsukuku_counter_utilities_prepare_msg (_tmp3_, _tmp4_, &_tmp5_);
	_tmp7_ = _tmp6_;
	_tmp7__length1 = _tmp5_;
	_tmp8_ = signature;
	_tmp9_ = zcd_serializable_buffer_get_buffer (_tmp8_, &_tmp9__length1);
	_tmp10_ = _tmp9_;
	_tmp10__length1 = _tmp9__length1;
	_tmp11_ = netsukuku_public_key_wrapper_verify (_tmp2_, _tmp7_, _tmp5_, (guchar*) _tmp10_, (_tmp10__length1 * sizeof (guint8)) / sizeof (guchar), &_inner_error_);
	_tmp12_ = _tmp11_;
	_tmp7_ = (g_free (_tmp7_), NULL);
	_tmp13_ = _tmp12_;
	if (_inner_error_ != NULL) {
		_g_object_unref0 (pkw);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return FALSE;
	}
	result = _tmp13_;
	_g_object_unref0 (pkw);
	return result;
}


NetsukukuCounterCheckHostnameResponse* netsukuku_counter_ask_check_hostname (NetsukukuCounter* self, NetsukukuNIP* nip, const gchar* hashed_domain, NetsukukuPublicKey* pubkey, GError** error) {
	NetsukukuCounterCheckHostnameResponse* result = NULL;
	NetsukukuNIP* _tmp0_;
	NetsukukuRmtCounterPeer* _tmp1_ = NULL;
	NetsukukuRmtCounterPeer* _tmp2_;
	NetsukukuNIP* _tmp3_;
	const gchar* _tmp4_;
	NetsukukuPublicKey* _tmp5_;
	NetsukukuCounterCheckHostnameResponse* _tmp6_ = NULL;
	NetsukukuCounterCheckHostnameResponse* _tmp7_;
	NetsukukuCounterCheckHostnameResponse* _tmp8_;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (nip != NULL, NULL);
	g_return_val_if_fail (hashed_domain != NULL, NULL);
	g_return_val_if_fail (pubkey != NULL, NULL);
	_tmp0_ = nip;
	_tmp1_ = netsukuku_counter_peer (self, NULL, (GObject*) _tmp0_, NULL);
	_tmp2_ = _tmp1_;
	_tmp3_ = nip;
	_tmp4_ = hashed_domain;
	_tmp5_ = pubkey;
	_tmp6_ = netsukuku_icounter_as_peer_check_hostname ((NetsukukuICounterAsPeer*) _tmp2_, _tmp3_, _tmp4_, _tmp5_, &_inner_error_);
	_tmp7_ = _tmp6_;
	_g_object_unref0 (_tmp2_);
	_tmp8_ = _tmp7_;
	if (_inner_error_ != NULL) {
		if ((_inner_error_->domain == ZCD_RPC_ERROR) || (_inner_error_->domain == NETSUKUKU_PEER_REFUSE_SERVICE_ERROR)) {
			g_propagate_error (error, _inner_error_);
			return NULL;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	}
	result = _tmp8_;
	return result;
}


NetsukukuCounterNipRecord* netsukuku_counter_ask_get_hostnames (NetsukukuCounter* self, NetsukukuNIP* nip) {
	NetsukukuCounterNipRecord* result = NULL;
	NetsukukuNIP* _tmp0_;
	NetsukukuRmtCounterPeer* _tmp1_ = NULL;
	NetsukukuRmtCounterPeer* node;
	NetsukukuNIP* _tmp2_;
	NetsukukuCounterNipRecord* _tmp3_ = NULL;
	NetsukukuCounterNipRecord* ret;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (nip != NULL, NULL);
	_tmp0_ = nip;
	_tmp1_ = netsukuku_counter_peer (self, NULL, (GObject*) _tmp0_, NULL);
	node = _tmp1_;
	_tmp2_ = nip;
	_tmp3_ = netsukuku_icounter_as_peer_get_hostnames ((NetsukukuICounterAsPeer*) node, _tmp2_, &_inner_error_);
	ret = _tmp3_;
	if (_inner_error_ != NULL) {
		_g_object_unref0 (node);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return NULL;
	}
	result = ret;
	_g_object_unref0 (node);
	return result;
}


/** Helper methods used as a server
          */
static void netsukuku_counter_str_debug_cache (NetsukukuCounter* self) {
	g_return_if_fail (self != NULL);
	{
		GeeHashMap* _tmp0_;
		GeeSet* _tmp1_;
		GeeSet* _tmp2_;
		GeeSet* _tmp3_;
		GeeIterator* _tmp4_ = NULL;
		GeeIterator* _tmp5_;
		GeeIterator* _k_it;
		_tmp0_ = self->priv->cache;
		_tmp1_ = gee_abstract_map_get_keys ((GeeMap*) _tmp0_);
		_tmp2_ = _tmp1_;
		_tmp3_ = _tmp2_;
		_tmp4_ = gee_iterable_iterator ((GeeIterable*) _tmp3_);
		_tmp5_ = _tmp4_;
		_g_object_unref0 (_tmp3_);
		_k_it = _tmp5_;
		while (TRUE) {
			GeeIterator* _tmp6_;
			gboolean _tmp7_ = FALSE;
			GeeIterator* _tmp8_;
			gpointer _tmp9_ = NULL;
			NetsukukuPairPublicKeyNIP* k;
			NetsukukuPairPublicKeyNIP* _tmp10_;
			gchar* _tmp11_ = NULL;
			gchar* _tmp12_;
			gchar* _tmp13_ = NULL;
			gchar* _tmp14_;
			GeeHashMap* _tmp15_;
			NetsukukuPairPublicKeyNIP* _tmp16_;
			gpointer _tmp17_ = NULL;
			NetsukukuCounterNipRecord* _tmp18_;
			NetsukukuTimeCapsule* _tmp19_;
			NetsukukuTimeCapsule* _tmp20_;
			gchar* _tmp21_ = NULL;
			gchar* _tmp22_;
			const gchar* _tmp23_ = NULL;
			gchar* _tmp24_;
			gchar* _tmp25_;
			_tmp6_ = _k_it;
			_tmp7_ = gee_iterator_next (_tmp6_);
			if (!_tmp7_) {
				break;
			}
			_tmp8_ = _k_it;
			_tmp9_ = gee_iterator_get (_tmp8_);
			k = (NetsukukuPairPublicKeyNIP*) _tmp9_;
			_tmp10_ = k;
			_tmp11_ = netsukuku_pair_public_key_nip_to_string (_tmp10_);
			_tmp12_ = _tmp11_;
			_tmp13_ = g_strconcat ("COUNTER:        ", _tmp12_, " ttl ", NULL);
			_tmp14_ = _tmp13_;
			_tmp15_ = self->priv->cache;
			_tmp16_ = k;
			_tmp17_ = gee_abstract_map_get ((GeeAbstractMap*) _tmp15_, _tmp16_);
			_tmp18_ = (NetsukukuCounterNipRecord*) _tmp17_;
			_tmp19_ = netsukuku_counter_nip_record_get_expires (_tmp18_);
			_tmp20_ = _tmp19_;
			_tmp21_ = tasklets_timer_get_string_msec_ttl ((TaskletsTimer*) _tmp20_);
			_tmp22_ = _tmp21_;
			_tmp23_ = string_to_string (_tmp22_);
			_tmp24_ = g_strconcat (_tmp14_, _tmp23_, NULL);
			_tmp25_ = _tmp24_;
			netsukuku_log_debug (_tmp25_);
			_g_free0 (_tmp25_);
			_g_free0 (_tmp22_);
			_g_object_unref0 (_tmp18_);
			_g_free0 (_tmp14_);
			_g_free0 (_tmp12_);
			_g_object_unref0 (k);
		}
		_g_object_unref0 (_k_it);
	}
}


void netsukuku_counter_check_expirations_cache (NetsukukuCounter* self) {
	GeeArrayList* _tmp0_;
	GeeArrayList* todel;
	g_return_if_fail (self != NULL);
	netsukuku_log_debug ("COUNTER: cleaning expired entries - if any - from our COUNTER cache...");
	netsukuku_log_debug ("COUNTER: cache was:");
	netsukuku_counter_str_debug_cache (self);
	_tmp0_ = gee_array_list_new (NETSUKUKU_TYPE_PAIR_PUBLIC_KEY_NIP, (GBoxedCopyFunc) g_object_ref, g_object_unref, _netsukuku_pair_public_key_nip_equal_func_gee_equal_data_func, NULL, NULL);
	todel = _tmp0_;
	{
		GeeHashMap* _tmp1_;
		GeeSet* _tmp2_;
		GeeSet* _tmp3_;
		GeeSet* _tmp4_;
		GeeIterator* _tmp5_ = NULL;
		GeeIterator* _tmp6_;
		GeeIterator* _k_it;
		_tmp1_ = self->priv->cache;
		_tmp2_ = gee_abstract_map_get_keys ((GeeMap*) _tmp1_);
		_tmp3_ = _tmp2_;
		_tmp4_ = _tmp3_;
		_tmp5_ = gee_iterable_iterator ((GeeIterable*) _tmp4_);
		_tmp6_ = _tmp5_;
		_g_object_unref0 (_tmp4_);
		_k_it = _tmp6_;
		while (TRUE) {
			GeeIterator* _tmp7_;
			gboolean _tmp8_ = FALSE;
			GeeIterator* _tmp9_;
			gpointer _tmp10_ = NULL;
			NetsukukuPairPublicKeyNIP* k;
			GeeHashMap* _tmp11_;
			NetsukukuPairPublicKeyNIP* _tmp12_;
			gpointer _tmp13_ = NULL;
			NetsukukuCounterNipRecord* record;
			NetsukukuCounterNipRecord* _tmp14_;
			NetsukukuTimeCapsule* _tmp15_;
			NetsukukuTimeCapsule* _tmp16_;
			gboolean _tmp17_ = FALSE;
			_tmp7_ = _k_it;
			_tmp8_ = gee_iterator_next (_tmp7_);
			if (!_tmp8_) {
				break;
			}
			_tmp9_ = _k_it;
			_tmp10_ = gee_iterator_get (_tmp9_);
			k = (NetsukukuPairPublicKeyNIP*) _tmp10_;
			_tmp11_ = self->priv->cache;
			_tmp12_ = k;
			_tmp13_ = gee_abstract_map_get ((GeeAbstractMap*) _tmp11_, _tmp12_);
			record = (NetsukukuCounterNipRecord*) _tmp13_;
			_tmp14_ = record;
			_tmp15_ = netsukuku_counter_nip_record_get_expires (_tmp14_);
			_tmp16_ = _tmp15_;
			_tmp17_ = tasklets_timer_is_expired ((TaskletsTimer*) _tmp16_);
			if (_tmp17_) {
				GeeArrayList* _tmp18_;
				NetsukukuPairPublicKeyNIP* _tmp19_;
				_tmp18_ = todel;
				_tmp19_ = k;
				gee_abstract_collection_add ((GeeAbstractCollection*) _tmp18_, _tmp19_);
			}
			_g_object_unref0 (record);
			_g_object_unref0 (k);
		}
		_g_object_unref0 (_k_it);
	}
	{
		GeeArrayList* _tmp20_;
		GeeArrayList* _tmp21_;
		GeeArrayList* _k_list;
		GeeArrayList* _tmp22_;
		gint _tmp23_;
		gint _tmp24_;
		gint _k_size;
		gint _k_index;
		_tmp20_ = todel;
		_tmp21_ = _g_object_ref0 (_tmp20_);
		_k_list = _tmp21_;
		_tmp22_ = _k_list;
		_tmp23_ = gee_abstract_collection_get_size ((GeeCollection*) _tmp22_);
		_tmp24_ = _tmp23_;
		_k_size = _tmp24_;
		_k_index = -1;
		while (TRUE) {
			gint _tmp25_;
			gint _tmp26_;
			gint _tmp27_;
			GeeArrayList* _tmp28_;
			gint _tmp29_;
			gpointer _tmp30_ = NULL;
			NetsukukuPairPublicKeyNIP* k;
			GeeHashMap* _tmp31_;
			NetsukukuPairPublicKeyNIP* _tmp32_;
			NetsukukuPairPublicKeyNIP* _tmp33_;
			gchar* _tmp34_ = NULL;
			gchar* _tmp35_;
			gchar* _tmp36_ = NULL;
			gchar* _tmp37_;
			_tmp25_ = _k_index;
			_k_index = _tmp25_ + 1;
			_tmp26_ = _k_index;
			_tmp27_ = _k_size;
			if (!(_tmp26_ < _tmp27_)) {
				break;
			}
			_tmp28_ = _k_list;
			_tmp29_ = _k_index;
			_tmp30_ = gee_abstract_list_get ((GeeAbstractList*) _tmp28_, _tmp29_);
			k = (NetsukukuPairPublicKeyNIP*) _tmp30_;
			_tmp31_ = self->priv->cache;
			_tmp32_ = k;
			gee_abstract_map_unset ((GeeAbstractMap*) _tmp31_, _tmp32_, NULL);
			_tmp33_ = k;
			_tmp34_ = netsukuku_pair_public_key_nip_to_string (_tmp33_);
			_tmp35_ = _tmp34_;
			_tmp36_ = g_strconcat ("COUNTER: cleaned ", _tmp35_, NULL);
			_tmp37_ = _tmp36_;
			netsukuku_log_debug (_tmp37_);
			_g_free0 (_tmp37_);
			_g_free0 (_tmp35_);
			_g_object_unref0 (k);
		}
		_g_object_unref0 (_k_list);
	}
	netsukuku_log_debug ("COUNTER: cache now is:");
	netsukuku_counter_str_debug_cache (self);
	_g_object_unref0 (todel);
}


static NetsukukuIAddressManagerRootDispatcher* netsukuku_counter_real_contact_registrar (NetsukukuCounter* self, const gchar* registrar_address) {
	NetsukukuIAddressManagerRootDispatcher* result = NULL;
	const gchar* _tmp0_;
	NetsukukuAddressManagerTCPClient* _tmp1_;
	g_return_val_if_fail (registrar_address != NULL, NULL);
	_tmp0_ = registrar_address;
	_tmp1_ = netsukuku_address_manager_tcp_client_new (_tmp0_, NULL, NULL, TRUE);
	result = (NetsukukuIAddressManagerRootDispatcher*) _tmp1_;
	return result;
}


NetsukukuIAddressManagerRootDispatcher* netsukuku_counter_contact_registrar (NetsukukuCounter* self, const gchar* registrar_address) {
	g_return_val_if_fail (self != NULL, NULL);
	return NETSUKUKU_COUNTER_GET_CLASS (self)->contact_registrar (self, registrar_address);
}


/** Remotable methods as peer()
          */
static Block5Data* block5_data_ref (Block5Data* _data5_) {
	g_atomic_int_inc (&_data5_->_ref_count_);
	return _data5_;
}


static void block5_data_unref (void * _userdata_) {
	Block5Data* _data5_;
	_data5_ = (Block5Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data5_->_ref_count_)) {
		NetsukukuCounter * self;
		self = _data5_->self;
		_g_object_unref0 (_data5_->response_ttl);
		_g_free0 (_data5_->response_msg);
		_g_object_unref0 (_data5_->nip);
		_g_object_unref0 (_data5_->hashed_domains);
		_g_object_unref0 (_data5_->pubkey);
		_g_object_unref0 (_data5_->signature);
		_g_object_unref0 (self);
		g_slice_free (Block5Data, _data5_);
	}
}


static gboolean __lambda14_ (Block5Data* _data5_, GError** error) {
	NetsukukuCounter * self;
	gboolean result = FALSE;
	NetsukukuNIP* _tmp0_;
	GeeList* _tmp1_;
	NetsukukuPublicKey* _tmp2_;
	zcdSerializableBuffer* _tmp3_;
	gboolean _tmp4_ = FALSE;
	GeeList* _tmp6_;
	gint _tmp7_;
	gint _tmp8_;
	NetsukukuMapRoute* _tmp10_;
	gint _tmp11_;
	gint _tmp12_;
	NetsukukuMapRoute* _tmp13_;
	gint _tmp14_;
	gint _tmp15_;
	NetsukukuNIP* _tmp16_;
	gchar* _tmp17_ = NULL;
	gchar* dest_addr;
	const gchar* _tmp18_;
	NetsukukuIAddressManagerRootDispatcher* _tmp19_ = NULL;
	NetsukukuIAddressManagerRootDispatcher* client;
	gint32 _tmp20_ = 0;
	gint to_be_signed;
	NetsukukuIAddressManagerRootDispatcher* _tmp21_;
	NetsukukuIAndna* _tmp22_;
	NetsukukuIAndna* _tmp23_;
	NetsukukuNIP* _tmp24_;
	NetsukukuPublicKey* _tmp25_;
	gint _tmp26_;
	NetsukukuAndnaConfirmPubkResponse* _tmp27_ = NULL;
	NetsukukuAndnaConfirmPubkResponse* resp;
	NetsukukuAndnaConfirmPubkResponse* _tmp28_;
	const gchar* _tmp29_;
	const gchar* _tmp30_;
	NetsukukuPairPublicKeyNIP* to_del;
	NetsukukuPairPublicKeyNIP* _tmp62_;
	NetsukukuTimeCapsule* _tmp65_;
	NetsukukuTimeCapsule* ttl;
	GeeHashMap* _tmp66_;
	NetsukukuPublicKey* _tmp67_;
	NetsukukuNIP* _tmp68_;
	NetsukukuPairPublicKeyNIP* _tmp69_;
	NetsukukuPairPublicKeyNIP* _tmp70_;
	NetsukukuPublicKey* _tmp71_;
	NetsukukuNIP* _tmp72_;
	GeeList* _tmp73_;
	zcdListString* _tmp74_;
	zcdListString* _tmp75_;
	NetsukukuTimeCapsule* _tmp76_;
	NetsukukuCounterNipRecord* _tmp77_;
	NetsukukuCounterNipRecord* _tmp78_;
	gchar* _tmp79_;
	NetsukukuTimeCapsule* _tmp80_;
	NetsukukuTimeCapsule* _tmp81_;
	GError * _inner_error_ = NULL;
	self = _data5_->self;
	_tmp0_ = _data5_->nip;
	_tmp1_ = _data5_->hashed_domains;
	_tmp2_ = _data5_->pubkey;
	_tmp3_ = _data5_->signature;
	_tmp4_ = _netsukuku_counter_verify (self, _tmp0_, _tmp1_, _tmp2_, _tmp3_);
	if (!_tmp4_) {
		GError* _tmp5_;
		_tmp5_ = g_error_new_literal (NETSUKUKU_PEER_REFUSE_SERVICE_ERROR, NETSUKUKU_PEER_REFUSE_SERVICE_ERROR_GENERIC, "Not your signature.");
		_inner_error_ = _tmp5_;
		if (_inner_error_->domain == NETSUKUKU_PEER_REFUSE_SERVICE_ERROR) {
			g_propagate_error (error, _inner_error_);
			return FALSE;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return FALSE;
		}
	}
	_tmp6_ = _data5_->hashed_domains;
	_tmp7_ = gee_collection_get_size ((GeeCollection*) _tmp6_);
	_tmp8_ = _tmp7_;
	if (_tmp8_ > NETSUKUKU_MAX_HOSTNAMES) {
		GError* _tmp9_;
		_tmp9_ = g_error_new_literal (NETSUKUKU_PEER_REFUSE_SERVICE_ERROR, NETSUKUKU_PEER_REFUSE_SERVICE_ERROR_GENERIC, "Too many names.");
		_inner_error_ = _tmp9_;
		if (_inner_error_->domain == NETSUKUKU_PEER_REFUSE_SERVICE_ERROR) {
			g_propagate_error (error, _inner_error_);
			return FALSE;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return FALSE;
		}
	}
	_tmp10_ = ((NetsukukuPeerToPeer*) self)->maproute;
	_tmp11_ = netsukuku_map_get_levels ((NetsukukuMap*) _tmp10_);
	_tmp12_ = _tmp11_;
	_tmp13_ = ((NetsukukuPeerToPeer*) self)->maproute;
	_tmp14_ = netsukuku_map_get_gsize ((NetsukukuMap*) _tmp13_);
	_tmp15_ = _tmp14_;
	_tmp16_ = _data5_->nip;
	_tmp17_ = netsukuku_nip_to_str (_tmp12_, _tmp15_, _tmp16_);
	dest_addr = _tmp17_;
	_tmp18_ = dest_addr;
	_tmp19_ = netsukuku_counter_contact_registrar (self, _tmp18_);
	client = _tmp19_;
	_tmp20_ = g_random_int_range ((gint32) 0, (gint32) 64000);
	to_be_signed = (gint) _tmp20_;
	_tmp21_ = client;
	_tmp22_ = netsukuku_iaddress_manager_root_dispatcher_get_andna (_tmp21_);
	_tmp23_ = _tmp22_;
	_tmp24_ = _data5_->nip;
	_tmp25_ = _data5_->pubkey;
	_tmp26_ = to_be_signed;
	_tmp27_ = netsukuku_iandna_confirm_pubk (_tmp23_, _tmp24_, _tmp25_, _tmp26_, &_inner_error_);
	resp = _tmp27_;
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == NETSUKUKU_PEER_REFUSE_SERVICE_ERROR) {
			g_propagate_error (error, _inner_error_);
			_g_object_unref0 (client);
			_g_free0 (dest_addr);
			return FALSE;
		} else {
			_g_object_unref0 (client);
			_g_free0 (dest_addr);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return FALSE;
		}
	}
	_tmp28_ = resp;
	_tmp29_ = netsukuku_andna_confirm_pubk_response_get_response (_tmp28_);
	_tmp30_ = _tmp29_;
	if (g_strcmp0 (_tmp30_, "OK") == 0) {
		NetsukukuPublicKey* _tmp31_;
		NetsukukuPublicKeyWrapper* _tmp32_;
		NetsukukuPublicKeyWrapper* pk;
		NetsukukuPublicKeyWrapper* _tmp33_;
		gint _tmp34_;
		gchar* _tmp35_ = NULL;
		gchar* _tmp36_;
		guint8* _tmp37_;
		gint _tmp37__length1;
		guint8* _tmp38_;
		gint _tmp38__length1;
		NetsukukuAndnaConfirmPubkResponse* _tmp39_;
		zcdSerializableBuffer* _tmp40_;
		zcdSerializableBuffer* _tmp41_;
		guint8* _tmp42_;
		gint _tmp42__length1;
		guint8* _tmp43_;
		gint _tmp43__length1;
		_tmp31_ = _data5_->pubkey;
		_tmp32_ = netsukuku_public_key_wrapper_new_from_pubk (_tmp31_, &_inner_error_);
		pk = _tmp32_;
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == NETSUKUKU_PEER_REFUSE_SERVICE_ERROR) {
				g_propagate_error (error, _inner_error_);
				_g_object_unref0 (resp);
				_g_object_unref0 (client);
				_g_free0 (dest_addr);
				return FALSE;
			} else {
				_g_object_unref0 (resp);
				_g_object_unref0 (client);
				_g_free0 (dest_addr);
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return FALSE;
			}
		}
		_tmp33_ = pk;
		_tmp34_ = to_be_signed;
		_tmp35_ = g_strdup_printf ("%i", _tmp34_);
		_tmp36_ = _tmp35_;
		_tmp37_ = string_get_data (_tmp36_, &_tmp37__length1);
		_tmp38_ = _tmp37_;
		_tmp38__length1 = _tmp37__length1;
		_tmp39_ = resp;
		_tmp40_ = netsukuku_andna_confirm_pubk_response_get_signature (_tmp39_);
		_tmp41_ = _tmp40_;
		_tmp42_ = zcd_serializable_buffer_get_buffer (_tmp41_, &_tmp42__length1);
		_tmp43_ = _tmp42_;
		_tmp43__length1 = _tmp42__length1;
		netsukuku_public_key_wrapper_verify (_tmp33_, (guchar*) _tmp38_, (_tmp38__length1 * sizeof (guint8)) / sizeof (guchar), (guchar*) _tmp43_, (_tmp43__length1 * sizeof (guint8)) / sizeof (guchar), &_inner_error_);
		_g_free0 (_tmp36_);
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == NETSUKUKU_PEER_REFUSE_SERVICE_ERROR) {
				g_propagate_error (error, _inner_error_);
				_g_object_unref0 (pk);
				_g_object_unref0 (resp);
				_g_object_unref0 (client);
				_g_free0 (dest_addr);
				return FALSE;
			} else {
				_g_object_unref0 (pk);
				_g_object_unref0 (resp);
				_g_object_unref0 (client);
				_g_free0 (dest_addr);
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return FALSE;
			}
		}
		_g_object_unref0 (pk);
	} else {
		GError* _tmp44_;
		_tmp44_ = g_error_new_literal (NETSUKUKU_PEER_REFUSE_SERVICE_ERROR, NETSUKUKU_PEER_REFUSE_SERVICE_ERROR_GENERIC, "Not your NIP.");
		_inner_error_ = _tmp44_;
		if (_inner_error_->domain == NETSUKUKU_PEER_REFUSE_SERVICE_ERROR) {
			g_propagate_error (error, _inner_error_);
			_g_object_unref0 (resp);
			_g_object_unref0 (client);
			_g_free0 (dest_addr);
			return FALSE;
		} else {
			_g_object_unref0 (resp);
			_g_object_unref0 (client);
			_g_free0 (dest_addr);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return FALSE;
		}
	}
	to_del = NULL;
	{
		GeeHashMap* _tmp45_;
		GeeSet* _tmp46_;
		GeeSet* _tmp47_;
		GeeSet* _tmp48_;
		GeeIterator* _tmp49_ = NULL;
		GeeIterator* _tmp50_;
		GeeIterator* _pk_nip_it;
		_tmp45_ = self->priv->cache;
		_tmp46_ = gee_abstract_map_get_keys ((GeeMap*) _tmp45_);
		_tmp47_ = _tmp46_;
		_tmp48_ = _tmp47_;
		_tmp49_ = gee_iterable_iterator ((GeeIterable*) _tmp48_);
		_tmp50_ = _tmp49_;
		_g_object_unref0 (_tmp48_);
		_pk_nip_it = _tmp50_;
		while (TRUE) {
			GeeIterator* _tmp51_;
			gboolean _tmp52_ = FALSE;
			GeeIterator* _tmp53_;
			gpointer _tmp54_ = NULL;
			NetsukukuPairPublicKeyNIP* pk_nip;
			NetsukukuPairPublicKeyNIP* _tmp55_;
			NetsukukuPublicKey* _tmp56_;
			NetsukukuPublicKey* _tmp57_;
			NetsukukuPublicKey* _tmp58_;
			gboolean _tmp59_ = FALSE;
			_tmp51_ = _pk_nip_it;
			_tmp52_ = gee_iterator_next (_tmp51_);
			if (!_tmp52_) {
				break;
			}
			_tmp53_ = _pk_nip_it;
			_tmp54_ = gee_iterator_get (_tmp53_);
			pk_nip = (NetsukukuPairPublicKeyNIP*) _tmp54_;
			_tmp55_ = pk_nip;
			_tmp56_ = netsukuku_pair_public_key_nip_get_pk (_tmp55_);
			_tmp57_ = _tmp56_;
			_tmp58_ = _data5_->pubkey;
			_tmp59_ = netsukuku_public_key_equal_func (_tmp57_, _tmp58_);
			if (_tmp59_) {
				NetsukukuPairPublicKeyNIP* _tmp60_;
				NetsukukuPairPublicKeyNIP* _tmp61_;
				_tmp60_ = pk_nip;
				_tmp61_ = _g_object_ref0 (_tmp60_);
				_g_object_unref0 (to_del);
				to_del = _tmp61_;
				_g_object_unref0 (pk_nip);
				break;
			}
			_g_object_unref0 (pk_nip);
		}
		_g_object_unref0 (_pk_nip_it);
	}
	_tmp62_ = to_del;
	if (_tmp62_ != NULL) {
		GeeHashMap* _tmp63_;
		NetsukukuPairPublicKeyNIP* _tmp64_;
		_tmp63_ = self->priv->cache;
		_tmp64_ = to_del;
		gee_abstract_map_unset ((GeeAbstractMap*) _tmp63_, _tmp64_, NULL);
	}
	_tmp65_ = netsukuku_time_capsule_new (NETSUKUKU_MAX_TTL_COUNTER);
	ttl = _tmp65_;
	_tmp66_ = self->priv->cache;
	_tmp67_ = _data5_->pubkey;
	_tmp68_ = _data5_->nip;
	_tmp69_ = netsukuku_pair_public_key_nip_new (_tmp67_, _tmp68_);
	_tmp70_ = _tmp69_;
	_tmp71_ = _data5_->pubkey;
	_tmp72_ = _data5_->nip;
	_tmp73_ = _data5_->hashed_domains;
	_tmp74_ = zcd_list_string_new_with_backer (_tmp73_);
	_tmp75_ = _tmp74_;
	_tmp76_ = ttl;
	_tmp77_ = netsukuku_counter_nip_record_new (_tmp71_, _tmp72_, _tmp75_, _tmp76_);
	_tmp78_ = _tmp77_;
	gee_abstract_map_set ((GeeAbstractMap*) _tmp66_, _tmp70_, _tmp78_);
	_g_object_unref0 (_tmp78_);
	_g_object_unref0 (_tmp75_);
	_g_object_unref0 (_tmp70_);
	_tmp79_ = g_strdup ("OK");
	_g_free0 (_data5_->response_msg);
	_data5_->response_msg = _tmp79_;
	_tmp80_ = ttl;
	_tmp81_ = _g_object_ref0 (_tmp80_);
	_g_object_unref0 (_data5_->response_ttl);
	_data5_->response_ttl = _tmp81_;
	result = TRUE;
	_g_object_unref0 (ttl);
	_g_object_unref0 (to_del);
	_g_object_unref0 (resp);
	_g_object_unref0 (client);
	_g_free0 (dest_addr);
	return result;
}


static gboolean ___lambda14__netsukuku_accept_record_callback (gpointer self, GError** error) {
	gboolean result;
	result = __lambda14_ (self, error);
	return result;
}


static void _____lambda16_ (NetsukukuCounter* self, GObject* tpar1, GObject* tpar2, GError** error) {
	GObject* _tmp0_;
	NetsukukuNIP* _tmp1_;
	NetsukukuNIP* tonip;
	GObject* _tmp2_;
	NetsukukuArgumentsForDuplicationSetData* _tmp3_;
	NetsukukuArgumentsForDuplicationSetData* arec;
	GError * _inner_error_ = NULL;
	_tmp0_ = tpar1;
	_tmp1_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, NETSUKUKU_TYPE_NIP, NetsukukuNIP));
	tonip = _tmp1_;
	_tmp2_ = tpar2;
	_tmp3_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp2_, NETSUKUKU_TYPE_ARGUMENTS_FOR_DUPLICATION_SET_DATA, NetsukukuArgumentsForDuplicationSetData));
	arec = _tmp3_;
	tasklets_tasklet_declare_self ("Counter.forward_record");
	{
		NetsukukuRmtCounterPeer* _tmp4_ = NULL;
		NetsukukuRmtCounterPeer* _tmp5_;
		NetsukukuNIP* _tmp6_;
		GeeList* _tmp7_;
		NetsukukuPublicKey* _tmp8_;
		zcdSerializableBuffer* _tmp9_;
		NetsukukuCounterSetDataResponse* _tmp10_ = NULL;
		NetsukukuCounterSetDataResponse* _tmp11_;
		_tmp4_ = netsukuku_counter_peer (self, tonip, NULL, NULL);
		_tmp5_ = _tmp4_;
		_tmp6_ = arec->nip;
		_tmp7_ = arec->hashed_domains;
		_tmp8_ = arec->pubkey;
		_tmp9_ = arec->signature;
		_tmp10_ = netsukuku_icounter_as_peer_set_data_for_pubk ((NetsukukuICounterAsPeer*) _tmp5_, _tmp6_, _tmp7_, _tmp8_, _tmp9_, FALSE, &_inner_error_);
		_tmp11_ = _tmp10_;
		_g_object_unref0 (_tmp11_);
		_g_object_unref0 (_tmp5_);
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == ZCD_RPC_ERROR) {
				goto __catch43_zcd_rpc_error;
			}
			goto __finally43;
		}
	}
	goto __finally43;
	__catch43_zcd_rpc_error:
	{
		GError* e = NULL;
		gchar* _tmp12_ = NULL;
		gchar* _tmp13_;
		gchar* _tmp14_ = NULL;
		gchar* _tmp15_;
		GError* _tmp16_;
		GQuark _tmp17_;
		const gchar* _tmp18_ = NULL;
		const gchar* _tmp19_ = NULL;
		GError* _tmp20_;
		gint _tmp21_;
		gchar* _tmp22_ = NULL;
		gchar* _tmp23_;
		GError* _tmp24_;
		const gchar* _tmp25_;
		const gchar* _tmp26_ = NULL;
		gchar* _tmp27_ = NULL;
		gchar* _tmp28_;
		gchar* _tmp29_;
		gchar* _tmp30_;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp12_ = netsukuku_partial_nip_to_string ((NetsukukuPartialNIP*) tonip);
		_tmp13_ = _tmp12_;
		_tmp14_ = g_strconcat ("Counter.forward_record: forwarding to ", _tmp13_, ":", NULL);
		_tmp15_ = _tmp14_;
		_tmp16_ = e;
		_tmp17_ = _tmp16_->domain;
		_tmp18_ = g_quark_to_string (_tmp17_);
		_tmp19_ = string_to_string (_tmp18_);
		_tmp20_ = e;
		_tmp21_ = _tmp20_->code;
		_tmp22_ = g_strdup_printf ("%i", _tmp21_);
		_tmp23_ = _tmp22_;
		_tmp24_ = e;
		_tmp25_ = _tmp24_->message;
		_tmp26_ = string_to_string (_tmp25_);
		_tmp27_ = g_strconcat (" got ", _tmp19_, " ", _tmp23_, " ", _tmp26_, NULL);
		_tmp28_ = _tmp27_;
		_tmp29_ = g_strconcat (_tmp15_, _tmp28_, NULL);
		_tmp30_ = _tmp29_;
		netsukuku_log_warn (_tmp30_);
		_g_free0 (_tmp30_);
		_g_free0 (_tmp28_);
		_g_free0 (_tmp23_);
		_g_free0 (_tmp15_);
		_g_free0 (_tmp13_);
		_g_error_free0 (e);
	}
	__finally43:
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		_g_object_unref0 (arec);
		_g_object_unref0 (tonip);
		return;
	}
	_g_object_unref0 (arec);
	_g_object_unref0 (tonip);
}


static void ______lambda16__tasklets_tasklet_callback (GObject* obj1, GObject* obj2, GObject* obj3, GObject* obj4, gpointer self, GError** error) {
	_____lambda16_ (self, obj1, obj2, error);
}


static void __lambda15_ (NetsukukuCounter* self, GObject* tasklet_obj1, GeeList* tasklet_replica_nodes, GError** error) {
	GObject* _tmp0_;
	NetsukukuArgumentsForDuplicationSetData* _tmp1_;
	NetsukukuArgumentsForDuplicationSetData* tasklet_rec;
	GeeList* _tmp2_;
	GError * _inner_error_ = NULL;
	_tmp0_ = tasklet_obj1;
	_tmp1_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, NETSUKUKU_TYPE_ARGUMENTS_FOR_DUPLICATION_SET_DATA, NetsukukuArgumentsForDuplicationSetData));
	tasklet_rec = _tmp1_;
	_tmp2_ = tasklet_replica_nodes;
	if (_tmp2_ == NULL) {
		NetsukukuArgumentsForDuplicationSetData* _tmp3_;
		NetsukukuNIP* _tmp4_;
		GeeList* _tmp5_ = NULL;
		GeeList* _tmp6_;
		_tmp3_ = tasklet_rec;
		_tmp4_ = _tmp3_->hashnode;
		_tmp5_ = netsukuku_peer_to_peer_find_nearest_to_register ((NetsukukuPeerToPeer*) self, _tmp4_, NETSUKUKU_COUNTER_DUPLICATION, NULL, &_inner_error_);
		_tmp6_ = _tmp5_;
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == NETSUKUKU_PEER_REFUSE_SERVICE_ERROR) {
				g_propagate_error (error, _inner_error_);
				_g_object_unref0 (tasklet_rec);
				_g_object_unref0 (tasklet_replica_nodes);
				return;
			} else {
				_g_object_unref0 (tasklet_rec);
				_g_object_unref0 (tasklet_replica_nodes);
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return;
			}
		}
		_g_object_unref0 (tasklet_replica_nodes);
		tasklet_replica_nodes = _tmp6_;
	}
	{
		GeeList* _tmp7_;
		GeeList* _tmp8_;
		GeeList* _replica_node_list;
		GeeList* _tmp9_;
		gint _tmp10_;
		gint _tmp11_;
		gint _replica_node_size;
		gint _replica_node_index;
		_tmp7_ = tasklet_replica_nodes;
		_tmp8_ = _g_object_ref0 (_tmp7_);
		_replica_node_list = _tmp8_;
		_tmp9_ = _replica_node_list;
		_tmp10_ = gee_collection_get_size ((GeeCollection*) _tmp9_);
		_tmp11_ = _tmp10_;
		_replica_node_size = _tmp11_;
		_replica_node_index = -1;
		while (TRUE) {
			gint _tmp12_;
			gint _tmp13_;
			gint _tmp14_;
			GeeList* _tmp15_;
			gint _tmp16_;
			gpointer _tmp17_ = NULL;
			NetsukukuNIP* replica_node;
			NetsukukuNIP* _tmp18_;
			NetsukukuMapRoute* _tmp19_;
			NetsukukuNIP* _tmp20_;
			NetsukukuNIP* _tmp21_;
			gboolean _tmp22_ = FALSE;
			_tmp12_ = _replica_node_index;
			_replica_node_index = _tmp12_ + 1;
			_tmp13_ = _replica_node_index;
			_tmp14_ = _replica_node_size;
			if (!(_tmp13_ < _tmp14_)) {
				break;
			}
			_tmp15_ = _replica_node_list;
			_tmp16_ = _replica_node_index;
			_tmp17_ = gee_list_get (_tmp15_, _tmp16_);
			replica_node = (NetsukukuNIP*) _tmp17_;
			_tmp18_ = replica_node;
			_tmp19_ = ((NetsukukuPeerToPeer*) self)->maproute;
			_tmp20_ = netsukuku_map_get_me ((NetsukukuMap*) _tmp19_);
			_tmp21_ = _tmp20_;
			_tmp22_ = netsukuku_partial_nip_is_equal ((NetsukukuPartialNIP*) _tmp18_, (NetsukukuPartialNIP*) _tmp21_);
			if (!_tmp22_) {
				NetsukukuNIP* _tmp23_;
				NetsukukuArgumentsForDuplicationSetData* _tmp24_;
				TaskletsTasklet* _tmp25_ = NULL;
				TaskletsTasklet* _tmp26_;
				_tmp23_ = replica_node;
				_tmp24_ = tasklet_rec;
				_tmp25_ = tasklets_tasklet_tasklet_callback (______lambda16__tasklets_tasklet_callback, self, (GObject*) _tmp23_, (GObject*) _tmp24_, NULL, NULL);
				_tmp26_ = _tmp25_;
				_g_object_unref0 (_tmp26_);
			}
			_g_object_unref0 (replica_node);
		}
		_g_object_unref0 (_replica_node_list);
	}
	_g_object_unref0 (tasklet_rec);
	_g_object_unref0 (tasklet_replica_nodes);
}


static void ___lambda15__netsukuku_forward_record_callback (GObject* obj1, GeeList* replica_nodes, gpointer self, GError** error) {
	__lambda15_ (self, obj1, replica_nodes, error);
}


static NetsukukuCounterSetDataResponse* netsukuku_counter_real_set_data_for_pubk (NetsukukuICounterAsPeer* base, NetsukukuNIP* nip, GeeList* hashed_domains, NetsukukuPublicKey* pubkey, zcdSerializableBuffer* signature, gboolean replicate, GError** error) {
	NetsukukuCounter * self;
	NetsukukuCounterSetDataResponse* result = NULL;
	Block5Data* _data5_;
	NetsukukuNIP* _tmp0_;
	NetsukukuNIP* _tmp1_;
	GeeList* _tmp2_;
	GeeList* _tmp3_;
	NetsukukuPublicKey* _tmp4_;
	NetsukukuPublicKey* _tmp5_;
	zcdSerializableBuffer* _tmp6_;
	zcdSerializableBuffer* _tmp7_;
	gboolean _tmp8_;
	gchar* _tmp16_;
	NetsukukuTimeCapsule* _tmp17_;
	NetsukukuNIP* _tmp18_;
	NetsukukuNIP* _tmp19_ = NULL;
	NetsukukuNIP* hashnode;
	NetsukukuArgumentsForDuplicationSetData* _tmp20_;
	NetsukukuArgumentsForDuplicationSetData* rec;
	NetsukukuArgumentsForDuplicationSetData* _tmp21_;
	NetsukukuNIP* _tmp22_;
	NetsukukuNIP* _tmp23_;
	NetsukukuArgumentsForDuplicationSetData* _tmp24_;
	GeeList* _tmp25_;
	GeeList* _tmp26_;
	NetsukukuArgumentsForDuplicationSetData* _tmp27_;
	NetsukukuPublicKey* _tmp28_;
	NetsukukuPublicKey* _tmp29_;
	NetsukukuArgumentsForDuplicationSetData* _tmp30_;
	zcdSerializableBuffer* _tmp31_;
	zcdSerializableBuffer* _tmp32_;
	NetsukukuArgumentsForDuplicationSetData* _tmp33_;
	NetsukukuNIP* _tmp34_;
	NetsukukuNIP* _tmp35_;
	NetsukukuNIP* _tmp36_;
	gboolean _tmp37_;
	NetsukukuArgumentsForDuplicationSetData* _tmp38_;
	const gchar* _tmp39_;
	NetsukukuTimeCapsule* _tmp40_;
	NetsukukuCounterSetDataResponse* _tmp41_;
	GError * _inner_error_ = NULL;
	self = (NetsukukuCounter*) base;
	g_return_val_if_fail (nip != NULL, NULL);
	g_return_val_if_fail (hashed_domains != NULL, NULL);
	g_return_val_if_fail (pubkey != NULL, NULL);
	g_return_val_if_fail (signature != NULL, NULL);
	_data5_ = g_slice_new0 (Block5Data);
	_data5_->_ref_count_ = 1;
	_data5_->self = g_object_ref (self);
	_tmp0_ = nip;
	_tmp1_ = _g_object_ref0 (_tmp0_);
	_g_object_unref0 (_data5_->nip);
	_data5_->nip = _tmp1_;
	_tmp2_ = hashed_domains;
	_tmp3_ = _g_object_ref0 (_tmp2_);
	_g_object_unref0 (_data5_->hashed_domains);
	_data5_->hashed_domains = _tmp3_;
	_tmp4_ = pubkey;
	_tmp5_ = _g_object_ref0 (_tmp4_);
	_g_object_unref0 (_data5_->pubkey);
	_data5_->pubkey = _tmp5_;
	_tmp6_ = signature;
	_tmp7_ = _g_object_ref0 (_tmp6_);
	_g_object_unref0 (_data5_->signature);
	_data5_->signature = _tmp7_;
	_tmp8_ = self->priv->hooked_to_service;
	if (!_tmp8_) {
		gboolean _tmp9_;
		_tmp9_ = replicate;
		if (_tmp9_) {
			TaskletsTimer* _tmp10_;
			TaskletsTimer* w;
			_tmp10_ = tasklets_timer_new ((gint64) 10000);
			w = _tmp10_;
			while (TRUE) {
				gboolean _tmp11_;
				TaskletsTimer* _tmp12_;
				gboolean _tmp13_ = FALSE;
				_tmp11_ = self->priv->hooked_to_service;
				if (!(!_tmp11_)) {
					break;
				}
				_tmp12_ = w;
				_tmp13_ = tasklets_timer_is_expired (_tmp12_);
				if (_tmp13_) {
					GError* _tmp14_;
					_tmp14_ = g_error_new_literal (NETSUKUKU_PEER_REFUSE_SERVICE_ERROR, NETSUKUKU_PEER_REFUSE_SERVICE_ERROR_GENERIC, "Not hooked yet");
					_inner_error_ = _tmp14_;
					if (_inner_error_->domain == NETSUKUKU_PEER_REFUSE_SERVICE_ERROR) {
						g_propagate_error (error, _inner_error_);
						_g_object_unref0 (w);
						block5_data_unref (_data5_);
						_data5_ = NULL;
						return NULL;
					} else {
						_g_object_unref0 (w);
						block5_data_unref (_data5_);
						_data5_ = NULL;
						g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
						g_clear_error (&_inner_error_);
						return NULL;
					}
				}
				tasklets_tasklet_nap ((glong) 0, (glong) 1000);
			}
			_g_object_unref0 (w);
		} else {
			while (TRUE) {
				gboolean _tmp15_;
				_tmp15_ = self->priv->hooked_to_service;
				if (!(!_tmp15_)) {
					break;
				}
				tasklets_tasklet_nap ((glong) 0, (glong) 1000);
			}
		}
	}
	_tmp16_ = g_strdup ("Noooo");
	_data5_->response_msg = _tmp16_;
	_tmp17_ = netsukuku_time_capsule_new ((gint64) 0);
	_data5_->response_ttl = _tmp17_;
	netsukuku_counter_check_expirations_cache (self);
	_tmp18_ = _data5_->nip;
	_tmp19_ = netsukuku_peer_to_peer_h ((NetsukukuPeerToPeer*) self, (GObject*) _tmp18_);
	hashnode = _tmp19_;
	_tmp20_ = netsukuku_arguments_for_duplication_set_data_new ();
	rec = _tmp20_;
	_tmp21_ = rec;
	_tmp22_ = _data5_->nip;
	_tmp23_ = _g_object_ref0 (_tmp22_);
	_g_object_unref0 (_tmp21_->nip);
	_tmp21_->nip = _tmp23_;
	_tmp24_ = rec;
	_tmp25_ = _data5_->hashed_domains;
	_tmp26_ = _g_object_ref0 (_tmp25_);
	_g_object_unref0 (_tmp24_->hashed_domains);
	_tmp24_->hashed_domains = _tmp26_;
	_tmp27_ = rec;
	_tmp28_ = _data5_->pubkey;
	_tmp29_ = _g_object_ref0 (_tmp28_);
	_g_object_unref0 (_tmp27_->pubkey);
	_tmp27_->pubkey = _tmp29_;
	_tmp30_ = rec;
	_tmp31_ = _data5_->signature;
	_tmp32_ = _g_object_ref0 (_tmp31_);
	_g_object_unref0 (_tmp30_->signature);
	_tmp30_->signature = _tmp32_;
	_tmp33_ = rec;
	_tmp34_ = hashnode;
	_tmp35_ = _g_object_ref0 (_tmp34_);
	_g_object_unref0 (_tmp33_->hashnode);
	_tmp33_->hashnode = _tmp35_;
	_tmp36_ = hashnode;
	_tmp37_ = replicate;
	_tmp38_ = rec;
	netsukuku_check_hash_and_start_replica ((NetsukukuPeerToPeer*) self, _tmp36_, _tmp37_, (GObject*) _tmp38_, NETSUKUKU_COUNTER_DUPLICATION, ___lambda14__netsukuku_accept_record_callback, _data5_, ___lambda15__netsukuku_forward_record_callback, self, NULL, NULL, &_inner_error_);
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == NETSUKUKU_PEER_REFUSE_SERVICE_ERROR) {
			g_propagate_error (error, _inner_error_);
			_g_object_unref0 (rec);
			_g_object_unref0 (hashnode);
			block5_data_unref (_data5_);
			_data5_ = NULL;
			return NULL;
		} else {
			_g_object_unref0 (rec);
			_g_object_unref0 (hashnode);
			block5_data_unref (_data5_);
			_data5_ = NULL;
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	}
	_tmp39_ = _data5_->response_msg;
	_tmp40_ = _data5_->response_ttl;
	_tmp41_ = netsukuku_counter_set_data_response_new (_tmp39_, _tmp40_);
	result = _tmp41_;
	_g_object_unref0 (rec);
	_g_object_unref0 (hashnode);
	block5_data_unref (_data5_);
	_data5_ = NULL;
	return result;
}


static NetsukukuCounterCheckHostnameResponse* netsukuku_counter_real_check_hostname (NetsukukuICounterAsPeer* base, NetsukukuNIP* nip, const gchar* hashed_domain, NetsukukuPublicKey* pubkey, GError** error) {
	NetsukukuCounter * self;
	NetsukukuCounterCheckHostnameResponse* result = NULL;
	gboolean _tmp0_;
	NetsukukuNIP* _tmp6_;
	NetsukukuNIP* _tmp7_ = NULL;
	NetsukukuNIP* hashnode;
	NetsukukuNIP* _tmp8_;
	NetsukukuHCoord* _tmp9_ = NULL;
	NetsukukuHCoord* _tmp10_;
	NetsukukuHCoord* _tmp11_;
	gboolean _tmp12_;
	gboolean response;
	NetsukukuTimeCapsule* _tmp14_;
	NetsukukuTimeCapsule* ttl;
	NetsukukuPairPublicKeyNIP* found;
	NetsukukuPairPublicKeyNIP* _tmp32_;
	gboolean _tmp40_;
	NetsukukuTimeCapsule* _tmp41_;
	NetsukukuCounterCheckHostnameResponse* _tmp42_;
	GError * _inner_error_ = NULL;
	self = (NetsukukuCounter*) base;
	g_return_val_if_fail (nip != NULL, NULL);
	g_return_val_if_fail (hashed_domain != NULL, NULL);
	g_return_val_if_fail (pubkey != NULL, NULL);
	_tmp0_ = self->priv->hooked_to_service;
	if (!_tmp0_) {
		TaskletsTimer* _tmp1_;
		TaskletsTimer* w;
		_tmp1_ = tasklets_timer_new ((gint64) 10000);
		w = _tmp1_;
		while (TRUE) {
			gboolean _tmp2_;
			TaskletsTimer* _tmp3_;
			gboolean _tmp4_ = FALSE;
			_tmp2_ = self->priv->hooked_to_service;
			if (!(!_tmp2_)) {
				break;
			}
			_tmp3_ = w;
			_tmp4_ = tasklets_timer_is_expired (_tmp3_);
			if (_tmp4_) {
				GError* _tmp5_;
				_tmp5_ = g_error_new_literal (NETSUKUKU_PEER_REFUSE_SERVICE_ERROR, NETSUKUKU_PEER_REFUSE_SERVICE_ERROR_GENERIC, "Not hooked yet");
				_inner_error_ = _tmp5_;
				if (_inner_error_->domain == NETSUKUKU_PEER_REFUSE_SERVICE_ERROR) {
					g_propagate_error (error, _inner_error_);
					_g_object_unref0 (w);
					return NULL;
				} else {
					_g_object_unref0 (w);
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
					g_clear_error (&_inner_error_);
					return NULL;
				}
			}
			tasklets_tasklet_nap ((glong) 0, (glong) 1000);
		}
		_g_object_unref0 (w);
	}
	netsukuku_counter_check_expirations_cache (self);
	_tmp6_ = nip;
	_tmp7_ = netsukuku_peer_to_peer_h ((NetsukukuPeerToPeer*) self, (GObject*) _tmp6_);
	hashnode = _tmp7_;
	_tmp8_ = hashnode;
	_tmp9_ = netsukuku_peer_to_peer_search_participant ((NetsukukuPeerToPeer*) self, _tmp8_, 1, &_inner_error_);
	_tmp10_ = _tmp9_;
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == NETSUKUKU_PEER_REFUSE_SERVICE_ERROR) {
			g_propagate_error (error, _inner_error_);
			_g_object_unref0 (hashnode);
			return NULL;
		} else {
			_g_object_unref0 (hashnode);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	}
	_tmp11_ = _tmp10_;
	_tmp12_ = _tmp11_ != NULL;
	_g_object_unref0 (_tmp11_);
	if (_tmp12_) {
		GError* _tmp13_;
		_tmp13_ = g_error_new_literal (NETSUKUKU_PEER_REFUSE_SERVICE_ERROR, NETSUKUKU_PEER_REFUSE_SERVICE_ERROR_GENERIC, "Not the correct hashnode");
		_inner_error_ = _tmp13_;
		if (_inner_error_->domain == NETSUKUKU_PEER_REFUSE_SERVICE_ERROR) {
			g_propagate_error (error, _inner_error_);
			_g_object_unref0 (hashnode);
			return NULL;
		} else {
			_g_object_unref0 (hashnode);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	}
	response = FALSE;
	_tmp14_ = netsukuku_time_capsule_new ((gint64) 0);
	ttl = _tmp14_;
	found = NULL;
	{
		GeeHashMap* _tmp15_;
		GeeSet* _tmp16_;
		GeeSet* _tmp17_;
		GeeSet* _tmp18_;
		GeeIterator* _tmp19_ = NULL;
		GeeIterator* _tmp20_;
		GeeIterator* _pk_nip_it;
		_tmp15_ = self->priv->cache;
		_tmp16_ = gee_abstract_map_get_keys ((GeeMap*) _tmp15_);
		_tmp17_ = _tmp16_;
		_tmp18_ = _tmp17_;
		_tmp19_ = gee_iterable_iterator ((GeeIterable*) _tmp18_);
		_tmp20_ = _tmp19_;
		_g_object_unref0 (_tmp18_);
		_pk_nip_it = _tmp20_;
		while (TRUE) {
			GeeIterator* _tmp21_;
			gboolean _tmp22_ = FALSE;
			GeeIterator* _tmp23_;
			gpointer _tmp24_ = NULL;
			NetsukukuPairPublicKeyNIP* pk_nip;
			NetsukukuPairPublicKeyNIP* _tmp25_;
			NetsukukuNIP* _tmp26_;
			NetsukukuNIP* _tmp27_;
			NetsukukuNIP* _tmp28_;
			gboolean _tmp29_ = FALSE;
			_tmp21_ = _pk_nip_it;
			_tmp22_ = gee_iterator_next (_tmp21_);
			if (!_tmp22_) {
				break;
			}
			_tmp23_ = _pk_nip_it;
			_tmp24_ = gee_iterator_get (_tmp23_);
			pk_nip = (NetsukukuPairPublicKeyNIP*) _tmp24_;
			_tmp25_ = pk_nip;
			_tmp26_ = netsukuku_pair_public_key_nip_get_nip (_tmp25_);
			_tmp27_ = _tmp26_;
			_tmp28_ = nip;
			_tmp29_ = netsukuku_partial_nip_equal_func ((NetsukukuPartialNIP*) _tmp27_, (NetsukukuPartialNIP*) _tmp28_);
			if (_tmp29_) {
				NetsukukuPairPublicKeyNIP* _tmp30_;
				NetsukukuPairPublicKeyNIP* _tmp31_;
				_tmp30_ = pk_nip;
				_tmp31_ = _g_object_ref0 (_tmp30_);
				_g_object_unref0 (found);
				found = _tmp31_;
				_g_object_unref0 (pk_nip);
				break;
			}
			_g_object_unref0 (pk_nip);
		}
		_g_object_unref0 (_pk_nip_it);
	}
	_tmp32_ = found;
	if (_tmp32_ != NULL) {
		GeeHashMap* _tmp33_;
		NetsukukuPairPublicKeyNIP* _tmp34_;
		gpointer _tmp35_ = NULL;
		NetsukukuCounterNipRecord* _tmp36_;
		NetsukukuTimeCapsule* _tmp37_;
		NetsukukuTimeCapsule* _tmp38_;
		NetsukukuTimeCapsule* _tmp39_;
		response = TRUE;
		_tmp33_ = self->priv->cache;
		_tmp34_ = found;
		_tmp35_ = gee_abstract_map_get ((GeeAbstractMap*) _tmp33_, _tmp34_);
		_tmp36_ = (NetsukukuCounterNipRecord*) _tmp35_;
		_tmp37_ = netsukuku_counter_nip_record_get_expires (_tmp36_);
		_tmp38_ = _tmp37_;
		_tmp39_ = _g_object_ref0 (_tmp38_);
		_g_object_unref0 (ttl);
		ttl = _tmp39_;
		_g_object_unref0 (_tmp36_);
	}
	_tmp40_ = response;
	_tmp41_ = ttl;
	_tmp42_ = netsukuku_counter_check_hostname_response_new (_tmp40_, _tmp41_);
	result = _tmp42_;
	_g_object_unref0 (found);
	_g_object_unref0 (ttl);
	_g_object_unref0 (hashnode);
	return result;
}


static NetsukukuCounterNipRecord* netsukuku_counter_real_get_hostnames (NetsukukuICounterAsPeer* base, NetsukukuNIP* nip, GError** error) {
	NetsukukuCounter * self;
	NetsukukuCounterNipRecord* result = NULL;
	gboolean _tmp0_;
	NetsukukuNIP* _tmp6_;
	NetsukukuNIP* _tmp7_ = NULL;
	NetsukukuNIP* hashnode;
	NetsukukuNIP* _tmp8_;
	NetsukukuHCoord* _tmp9_ = NULL;
	NetsukukuHCoord* _tmp10_;
	NetsukukuHCoord* _tmp11_;
	gboolean _tmp12_;
	NetsukukuPairPublicKeyNIP* found;
	NetsukukuPairPublicKeyNIP* _tmp31_;
	GError * _inner_error_ = NULL;
	self = (NetsukukuCounter*) base;
	g_return_val_if_fail (nip != NULL, NULL);
	_tmp0_ = self->priv->hooked_to_service;
	if (!_tmp0_) {
		TaskletsTimer* _tmp1_;
		TaskletsTimer* w;
		_tmp1_ = tasklets_timer_new ((gint64) 10000);
		w = _tmp1_;
		while (TRUE) {
			gboolean _tmp2_;
			TaskletsTimer* _tmp3_;
			gboolean _tmp4_ = FALSE;
			_tmp2_ = self->priv->hooked_to_service;
			if (!(!_tmp2_)) {
				break;
			}
			_tmp3_ = w;
			_tmp4_ = tasklets_timer_is_expired (_tmp3_);
			if (_tmp4_) {
				GError* _tmp5_;
				_tmp5_ = g_error_new_literal (NETSUKUKU_PEER_REFUSE_SERVICE_ERROR, NETSUKUKU_PEER_REFUSE_SERVICE_ERROR_GENERIC, "Not hooked yet");
				_inner_error_ = _tmp5_;
				if (_inner_error_->domain == NETSUKUKU_PEER_REFUSE_SERVICE_ERROR) {
					g_propagate_error (error, _inner_error_);
					_g_object_unref0 (w);
					return NULL;
				} else {
					_g_object_unref0 (w);
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
					g_clear_error (&_inner_error_);
					return NULL;
				}
			}
			tasklets_tasklet_nap ((glong) 0, (glong) 1000);
		}
		_g_object_unref0 (w);
	}
	netsukuku_counter_check_expirations_cache (self);
	_tmp6_ = nip;
	_tmp7_ = netsukuku_peer_to_peer_h ((NetsukukuPeerToPeer*) self, (GObject*) _tmp6_);
	hashnode = _tmp7_;
	_tmp8_ = hashnode;
	_tmp9_ = netsukuku_peer_to_peer_search_participant ((NetsukukuPeerToPeer*) self, _tmp8_, 1, &_inner_error_);
	_tmp10_ = _tmp9_;
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == NETSUKUKU_PEER_REFUSE_SERVICE_ERROR) {
			g_propagate_error (error, _inner_error_);
			_g_object_unref0 (hashnode);
			return NULL;
		} else {
			_g_object_unref0 (hashnode);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	}
	_tmp11_ = _tmp10_;
	_tmp12_ = _tmp11_ != NULL;
	_g_object_unref0 (_tmp11_);
	if (_tmp12_) {
		GError* _tmp13_;
		_tmp13_ = g_error_new_literal (NETSUKUKU_PEER_REFUSE_SERVICE_ERROR, NETSUKUKU_PEER_REFUSE_SERVICE_ERROR_GENERIC, "Not the correct hashnode");
		_inner_error_ = _tmp13_;
		if (_inner_error_->domain == NETSUKUKU_PEER_REFUSE_SERVICE_ERROR) {
			g_propagate_error (error, _inner_error_);
			_g_object_unref0 (hashnode);
			return NULL;
		} else {
			_g_object_unref0 (hashnode);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	}
	found = NULL;
	{
		GeeHashMap* _tmp14_;
		GeeSet* _tmp15_;
		GeeSet* _tmp16_;
		GeeSet* _tmp17_;
		GeeIterator* _tmp18_ = NULL;
		GeeIterator* _tmp19_;
		GeeIterator* _pk_nip_it;
		_tmp14_ = self->priv->cache;
		_tmp15_ = gee_abstract_map_get_keys ((GeeMap*) _tmp14_);
		_tmp16_ = _tmp15_;
		_tmp17_ = _tmp16_;
		_tmp18_ = gee_iterable_iterator ((GeeIterable*) _tmp17_);
		_tmp19_ = _tmp18_;
		_g_object_unref0 (_tmp17_);
		_pk_nip_it = _tmp19_;
		while (TRUE) {
			GeeIterator* _tmp20_;
			gboolean _tmp21_ = FALSE;
			GeeIterator* _tmp22_;
			gpointer _tmp23_ = NULL;
			NetsukukuPairPublicKeyNIP* pk_nip;
			NetsukukuPairPublicKeyNIP* _tmp24_;
			NetsukukuNIP* _tmp25_;
			NetsukukuNIP* _tmp26_;
			NetsukukuNIP* _tmp27_;
			gboolean _tmp28_ = FALSE;
			_tmp20_ = _pk_nip_it;
			_tmp21_ = gee_iterator_next (_tmp20_);
			if (!_tmp21_) {
				break;
			}
			_tmp22_ = _pk_nip_it;
			_tmp23_ = gee_iterator_get (_tmp22_);
			pk_nip = (NetsukukuPairPublicKeyNIP*) _tmp23_;
			_tmp24_ = pk_nip;
			_tmp25_ = netsukuku_pair_public_key_nip_get_nip (_tmp24_);
			_tmp26_ = _tmp25_;
			_tmp27_ = nip;
			_tmp28_ = netsukuku_partial_nip_equal_func ((NetsukukuPartialNIP*) _tmp26_, (NetsukukuPartialNIP*) _tmp27_);
			if (_tmp28_) {
				NetsukukuPairPublicKeyNIP* _tmp29_;
				NetsukukuPairPublicKeyNIP* _tmp30_;
				_tmp29_ = pk_nip;
				_tmp30_ = _g_object_ref0 (_tmp29_);
				_g_object_unref0 (found);
				found = _tmp30_;
				_g_object_unref0 (pk_nip);
				break;
			}
			_g_object_unref0 (pk_nip);
		}
		_g_object_unref0 (_pk_nip_it);
	}
	_tmp31_ = found;
	if (_tmp31_ != NULL) {
		GeeHashMap* _tmp32_;
		NetsukukuPairPublicKeyNIP* _tmp33_;
		gpointer _tmp34_ = NULL;
		_tmp32_ = self->priv->cache;
		_tmp33_ = found;
		_tmp34_ = gee_abstract_map_get ((GeeAbstractMap*) _tmp32_, _tmp33_);
		result = (NetsukukuCounterNipRecord*) _tmp34_;
		_g_object_unref0 (found);
		_g_object_unref0 (hashnode);
		return result;
	}
	result = NULL;
	_g_object_unref0 (found);
	_g_object_unref0 (hashnode);
	return result;
}


static NetsukukuCounterGetCacheRecordsResponse* netsukuku_counter_real_get_cache_records (NetsukukuICounterAsPeer* base, GError** error) {
	NetsukukuCounter * self;
	NetsukukuCounterGetCacheRecordsResponse* result = NULL;
	TaskletsTimer* _tmp0_;
	TaskletsTimer* w;
	GeeHashMap* _tmp5_;
	NetsukukuCounterGetCacheRecordsResponse* _tmp6_;
	GError * _inner_error_ = NULL;
	self = (NetsukukuCounter*) base;
	_tmp0_ = tasklets_timer_new ((gint64) 10000);
	w = _tmp0_;
	while (TRUE) {
		gboolean _tmp1_;
		TaskletsTimer* _tmp2_;
		gboolean _tmp3_ = FALSE;
		_tmp1_ = self->priv->hooked_to_service;
		if (!(!_tmp1_)) {
			break;
		}
		_tmp2_ = w;
		_tmp3_ = tasklets_timer_is_expired (_tmp2_);
		if (_tmp3_) {
			GError* _tmp4_;
			_tmp4_ = g_error_new_literal (NETSUKUKU_PEER_REFUSE_SERVICE_ERROR, NETSUKUKU_PEER_REFUSE_SERVICE_ERROR_GENERIC, "Not hooked yet");
			_inner_error_ = _tmp4_;
			if (_inner_error_->domain == NETSUKUKU_PEER_REFUSE_SERVICE_ERROR) {
				g_propagate_error (error, _inner_error_);
				_g_object_unref0 (w);
				return NULL;
			} else {
				_g_object_unref0 (w);
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return NULL;
			}
		}
		tasklets_tasklet_nap ((glong) 0, (glong) 1000);
	}
	_tmp5_ = self->priv->cache;
	_tmp6_ = netsukuku_counter_get_cache_records_response_new (_tmp5_);
	result = _tmp6_;
	_g_object_unref0 (w);
	return result;
}


static GeeArrayList* netsukuku_counter_get_hashednames (NetsukukuCounter* self) {
	GeeArrayList* result;
	GeeArrayList* _tmp0_;
	GeeArrayList* _tmp18_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_hashednames;
	if (_tmp0_ == NULL) {
		GeeArrayList* _tmp1_;
		gchar buffer[256] = {0};
		gchar* myhostname;
		gint _tmp2_ = 0;
		const gchar* _tmp13_;
		_tmp1_ = gee_array_list_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, NULL, NULL, NULL);
		_g_object_unref0 (self->priv->_hashednames);
		self->priv->_hashednames = _tmp1_;
		myhostname = NULL;
		_tmp2_ = gethostname (buffer, 256);
		if (_tmp2_ == 0) {
			GString* _tmp3_;
			GString* sb;
			gint pos;
			GString* _tmp9_;
			GString* _tmp10_;
			const gchar* _tmp11_;
			gchar* _tmp12_;
			_tmp3_ = g_string_new ("");
			sb = _tmp3_;
			pos = 0;
			while (TRUE) {
				gint _tmp4_;
				gchar _tmp5_;
				GString* _tmp6_;
				gint _tmp7_;
				gchar _tmp8_;
				_tmp4_ = pos;
				_tmp5_ = buffer[_tmp4_];
				if (!(_tmp5_ != '\0')) {
					break;
				}
				_tmp6_ = sb;
				_tmp7_ = pos;
				pos = _tmp7_ + 1;
				_tmp8_ = buffer[_tmp7_];
				g_string_append_c (_tmp6_, _tmp8_);
			}
			_tmp9_ = sb;
			g_string_append_c (_tmp9_, '\0');
			_tmp10_ = sb;
			_tmp11_ = _tmp10_->str;
			_tmp12_ = g_strdup (_tmp11_);
			_g_free0 (myhostname);
			myhostname = _tmp12_;
			_g_string_free0 (sb);
		}
		_tmp13_ = myhostname;
		if (_tmp13_ != NULL) {
			GeeArrayList* _tmp14_;
			const gchar* _tmp15_;
			gchar* _tmp16_ = NULL;
			gchar* _tmp17_;
			_tmp14_ = self->priv->_hashednames;
			_tmp15_ = myhostname;
			_tmp16_ = netsukuku_andna_crypto_hash (_tmp15_);
			_tmp17_ = _tmp16_;
			gee_abstract_collection_add ((GeeAbstractCollection*) _tmp14_, _tmp17_);
			_g_free0 (_tmp17_);
		}
		_g_free0 (myhostname);
	}
	_tmp18_ = self->priv->_hashednames;
	result = _tmp18_;
	return result;
}


static NetsukukuAndna* netsukuku_counter_get_andna (NetsukukuCounter* self) {
	NetsukukuAndna* result;
	NetsukukuAndna* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_andna;
	result = _tmp0_;
	return result;
}


void netsukuku_counter_set_andna (NetsukukuCounter* self, NetsukukuAndna* value) {
	NetsukukuAndna* _tmp0_;
	NetsukukuAndna* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	_tmp1_ = _g_object_ref0 (_tmp0_);
	_g_object_unref0 (self->priv->_andna);
	self->priv->_andna = _tmp1_;
	g_object_notify ((GObject *) self, "andna");
}


static void netsukuku_counter_class_init (NetsukukuCounterClass * klass) {
	netsukuku_counter_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (NetsukukuCounterPrivate));
	ZCD_RPC_DISPATCHER_CLASS (klass)->_dispatch = netsukuku_counter_real__dispatch;
	NETSUKUKU_PEER_TO_PEER_CLASS (klass)->h = netsukuku_counter_real_h;
	NETSUKUKU_COUNTER_CLASS (klass)->contact_registrar = netsukuku_counter_real_contact_registrar;
	G_OBJECT_CLASS (klass)->get_property = _vala_netsukuku_counter_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_netsukuku_counter_set_property;
	G_OBJECT_CLASS (klass)->finalize = netsukuku_counter_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), NETSUKUKU_COUNTER_ANDNA, g_param_spec_object ("andna", "andna", "andna", NETSUKUKU_TYPE_ANDNA, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_WRITABLE));
	g_signal_new ("counter_hooked", NETSUKUKU_TYPE_COUNTER, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
	g_signal_new ("counter_registered", NETSUKUKU_TYPE_COUNTER, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
}


static void netsukuku_counter_netsukuku_icounter_as_peer_interface_init (NetsukukuICounterAsPeerIface * iface) {
	netsukuku_counter_netsukuku_icounter_as_peer_parent_iface = g_type_interface_peek_parent (iface);
	iface->set_data_for_pubk = (NetsukukuCounterSetDataResponse* (*)(NetsukukuICounterAsPeer*, NetsukukuNIP*, GeeList*, NetsukukuPublicKey*, zcdSerializableBuffer*, gboolean, GError**)) netsukuku_counter_real_set_data_for_pubk;
	iface->check_hostname = (NetsukukuCounterCheckHostnameResponse* (*)(NetsukukuICounterAsPeer*, NetsukukuNIP*, const gchar*, NetsukukuPublicKey*, GError**)) netsukuku_counter_real_check_hostname;
	iface->get_hostnames = (NetsukukuCounterNipRecord* (*)(NetsukukuICounterAsPeer*, NetsukukuNIP*, GError**)) netsukuku_counter_real_get_hostnames;
	iface->get_cache_records = (NetsukukuCounterGetCacheRecordsResponse* (*)(NetsukukuICounterAsPeer*, GError**)) netsukuku_counter_real_get_cache_records;
}


static void netsukuku_counter_instance_init (NetsukukuCounter * self) {
	self->priv = NETSUKUKU_COUNTER_GET_PRIVATE (self);
}


static void netsukuku_counter_finalize (GObject* obj) {
	NetsukukuCounter * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, NETSUKUKU_TYPE_COUNTER, NetsukukuCounter);
	_g_object_unref0 (self->priv->_hashednames);
	_g_object_unref0 (self->priv->peer_to_peer_all);
	_g_object_unref0 (self->priv->reset_my_counter_node_tasklet);
	_g_object_unref0 (self->priv->_andna);
	_g_object_unref0 (self->priv->my_keys);
	_g_object_unref0 (self->priv->pubk);
	_g_object_unref0 (self->priv->cache);
	G_OBJECT_CLASS (netsukuku_counter_parent_class)->finalize (obj);
}


GType netsukuku_counter_get_type (void) {
	static volatile gsize netsukuku_counter_type_id__volatile = 0;
	if (g_once_init_enter (&netsukuku_counter_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (NetsukukuCounterClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) netsukuku_counter_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (NetsukukuCounter), 0, (GInstanceInitFunc) netsukuku_counter_instance_init, NULL };
		static const GInterfaceInfo netsukuku_icounter_as_peer_info = { (GInterfaceInitFunc) netsukuku_counter_netsukuku_icounter_as_peer_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
		GType netsukuku_counter_type_id;
		netsukuku_counter_type_id = g_type_register_static (NETSUKUKU_TYPE_OPTIONAL_PEER_TO_PEER, "NetsukukuCounter", &g_define_type_info, 0);
		g_type_add_interface_static (netsukuku_counter_type_id, NETSUKUKU_TYPE_ICOUNTER_AS_PEER, &netsukuku_icounter_as_peer_info);
		g_once_init_leave (&netsukuku_counter_type_id__volatile, netsukuku_counter_type_id);
	}
	return netsukuku_counter_type_id__volatile;
}


static void _vala_netsukuku_counter_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	NetsukukuCounter * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, NETSUKUKU_TYPE_COUNTER, NetsukukuCounter);
	switch (property_id) {
		case NETSUKUKU_COUNTER_ANDNA:
		g_value_set_object (value, netsukuku_counter_get_andna (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _vala_netsukuku_counter_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	NetsukukuCounter * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, NETSUKUKU_TYPE_COUNTER, NetsukukuCounter);
	switch (property_id) {
		case NETSUKUKU_COUNTER_ANDNA:
		netsukuku_counter_set_andna (self, g_value_get_object (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}


static gint _vala_array_length (gpointer array) {
	int length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}



