/* andna_utils.c generated by valac 0.20.1, the Vala compiler
 * generated from andna_utils.vala, do not modify */

/*
 *  This file is part of Netsukuku.
 *  (c) Copyright 2011-2014 Luca Dionisi aka lukisi <luca.dionisi@gmail.com>
 *
 *  Netsukuku is free software: you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation, either version 3 of the License, or
 *  (at your option) any later version.
 *
 *  Netsukuku is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with Netsukuku.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <glib.h>
#include <glib-object.h>
#include <netsukuku-rpc.h>
#include <stdlib.h>
#include <string.h>


#define NETSUKUKU_TYPE_ANDNA_SERVICE_HASHNODE_KEY (netsukuku_andna_service_hashnode_key_get_type ())
#define NETSUKUKU_ANDNA_SERVICE_HASHNODE_KEY(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), NETSUKUKU_TYPE_ANDNA_SERVICE_HASHNODE_KEY, NetsukukuAndnaServiceHashnodeKey))
#define NETSUKUKU_ANDNA_SERVICE_HASHNODE_KEY_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), NETSUKUKU_TYPE_ANDNA_SERVICE_HASHNODE_KEY, NetsukukuAndnaServiceHashnodeKeyClass))
#define NETSUKUKU_IS_ANDNA_SERVICE_HASHNODE_KEY(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), NETSUKUKU_TYPE_ANDNA_SERVICE_HASHNODE_KEY))
#define NETSUKUKU_IS_ANDNA_SERVICE_HASHNODE_KEY_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), NETSUKUKU_TYPE_ANDNA_SERVICE_HASHNODE_KEY))
#define NETSUKUKU_ANDNA_SERVICE_HASHNODE_KEY_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), NETSUKUKU_TYPE_ANDNA_SERVICE_HASHNODE_KEY, NetsukukuAndnaServiceHashnodeKeyClass))

typedef struct _NetsukukuAndnaServiceHashnodeKey NetsukukuAndnaServiceHashnodeKey;
typedef struct _NetsukukuAndnaServiceHashnodeKeyClass NetsukukuAndnaServiceHashnodeKeyClass;
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

typedef enum  {
	NETSUKUKU_CRYPTO_GCRYPT_ERROR_FAILED
} NetsukukuCryptoGCryptError;
#define NETSUKUKU_CRYPTO_GCRYPT_ERROR netsukuku_crypto_gcrypt_error_quark ()


GType netsukuku_andna_service_hashnode_key_get_type (void) G_GNUC_CONST;
NetsukukuNIP* netsukuku_andna_utilities_key_to_hashnode_converter (NetsukukuAndnaServiceHashnodeKey* key, gint levels, gint gsize);
const gchar* netsukuku_andna_service_hashnode_key_get_hashed_domain (NetsukukuAndnaServiceHashnodeKey* self);
gint netsukuku_andna_service_hashnode_key_get_spread_num (NetsukukuAndnaServiceHashnodeKey* self);
void netsukuku_log_debug (const gchar* msg);
gchar* netsukuku_andna_utilities_crypto_hash (const gchar* hostname);
GQuark netsukuku_crypto_gcrypt_error_quark (void);
guint8* netsukuku_crypto_md5 (guint8* buffer, int buffer_length1, int* result_length1, GError** error);


static const gchar* string_to_string (const gchar* self) {
	const gchar* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	result = self;
	return result;
}


NetsukukuNIP* netsukuku_andna_utilities_key_to_hashnode_converter (NetsukukuAndnaServiceHashnodeKey* key, gint levels, gint gsize) {
	NetsukukuNIP* result = NULL;
	NetsukukuAndnaServiceHashnodeKey* _tmp0_;
	const gchar* _tmp1_;
	const gchar* _tmp2_;
	const gchar* _tmp3_ = NULL;
	NetsukukuAndnaServiceHashnodeKey* _tmp4_;
	gint _tmp5_;
	gint _tmp6_;
	gchar* _tmp7_ = NULL;
	gchar* _tmp8_;
	gchar* _tmp9_ = NULL;
	gchar* _tmp10_;
	guint _tmp11_ = 0U;
	guint _tmp12_;
	guint hash;
	gint _tmp13_;
	gint* _tmp14_ = NULL;
	gint* positions;
	gint positions_length1;
	gint _positions_size_;
	gint* _tmp28_;
	gint _tmp28__length1;
	NetsukukuNIP* _tmp29_;
	NetsukukuNIP* ret;
	NetsukukuAndnaServiceHashnodeKey* _tmp30_;
	const gchar* _tmp31_;
	const gchar* _tmp32_;
	const gchar* _tmp33_ = NULL;
	gchar* _tmp34_ = NULL;
	gchar* _tmp35_;
	NetsukukuAndnaServiceHashnodeKey* _tmp36_;
	gint _tmp37_;
	gint _tmp38_;
	gchar* _tmp39_ = NULL;
	gchar* _tmp40_;
	gchar* _tmp41_ = NULL;
	gchar* _tmp42_;
	gchar* _tmp43_ = NULL;
	gchar* _tmp44_;
	gchar* _tmp45_;
	gchar* _tmp46_;
	g_return_val_if_fail (key != NULL, NULL);
	_tmp0_ = key;
	_tmp1_ = netsukuku_andna_service_hashnode_key_get_hashed_domain (_tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = string_to_string (_tmp2_);
	_tmp4_ = key;
	_tmp5_ = netsukuku_andna_service_hashnode_key_get_spread_num (_tmp4_);
	_tmp6_ = _tmp5_;
	_tmp7_ = g_strdup_printf ("%i", _tmp6_);
	_tmp8_ = _tmp7_;
	_tmp9_ = g_strconcat (_tmp3_, "_", _tmp8_, NULL);
	_tmp10_ = _tmp9_;
	_tmp11_ = g_str_hash (_tmp10_);
	_tmp12_ = _tmp11_;
	_g_free0 (_tmp10_);
	_g_free0 (_tmp8_);
	hash = _tmp12_;
	_tmp13_ = levels;
	_tmp14_ = g_new0 (gint, _tmp13_);
	positions = _tmp14_;
	positions_length1 = _tmp13_;
	_positions_size_ = positions_length1;
	{
		gint lvl;
		lvl = 0;
		{
			gboolean _tmp15_;
			_tmp15_ = TRUE;
			while (TRUE) {
				gboolean _tmp16_;
				gint _tmp18_;
				gint _tmp19_;
				guint _tmp20_;
				gint _tmp21_;
				guint pos;
				gint* _tmp22_;
				gint _tmp22__length1;
				gint _tmp23_;
				guint _tmp24_;
				gint _tmp25_;
				guint _tmp26_;
				gint _tmp27_;
				_tmp16_ = _tmp15_;
				if (!_tmp16_) {
					gint _tmp17_;
					_tmp17_ = lvl;
					lvl = _tmp17_ + 1;
				}
				_tmp15_ = FALSE;
				_tmp18_ = lvl;
				_tmp19_ = levels;
				if (!(_tmp18_ < _tmp19_)) {
					break;
				}
				_tmp20_ = hash;
				_tmp21_ = gsize;
				pos = _tmp20_ % _tmp21_;
				_tmp22_ = positions;
				_tmp22__length1 = positions_length1;
				_tmp23_ = lvl;
				_tmp24_ = pos;
				_tmp22_[_tmp23_] = (gint) _tmp24_;
				_tmp25_ = _tmp22_[_tmp23_];
				_tmp26_ = hash;
				_tmp27_ = gsize;
				hash = _tmp26_ / _tmp27_;
			}
		}
	}
	_tmp28_ = positions;
	_tmp28__length1 = positions_length1;
	_tmp29_ = netsukuku_nip_new (_tmp28_, _tmp28__length1);
	ret = _tmp29_;
	_tmp30_ = key;
	_tmp31_ = netsukuku_andna_service_hashnode_key_get_hashed_domain (_tmp30_);
	_tmp32_ = _tmp31_;
	_tmp33_ = string_to_string (_tmp32_);
	_tmp34_ = g_strconcat ("AndnaUtilities: hash: '", _tmp33_, NULL);
	_tmp35_ = _tmp34_;
	_tmp36_ = key;
	_tmp37_ = netsukuku_andna_service_hashnode_key_get_spread_num (_tmp36_);
	_tmp38_ = _tmp37_;
	_tmp39_ = g_strdup_printf ("%i", _tmp38_);
	_tmp40_ = _tmp39_;
	_tmp41_ = netsukuku_partial_nip_to_string ((NetsukukuPartialNIP*) ret);
	_tmp42_ = _tmp41_;
	_tmp43_ = g_strconcat ("_", _tmp40_, "' becomes ", _tmp42_, NULL);
	_tmp44_ = _tmp43_;
	_tmp45_ = g_strconcat (_tmp35_, _tmp44_, NULL);
	_tmp46_ = _tmp45_;
	netsukuku_log_debug (_tmp46_);
	_g_free0 (_tmp46_);
	_g_free0 (_tmp44_);
	_g_free0 (_tmp42_);
	_g_free0 (_tmp40_);
	_g_free0 (_tmp35_);
	result = ret;
	positions = (g_free (positions), NULL);
	return result;
}


static guint8* string_get_data (const gchar* self, int* result_length1) {
	guint8* result;
	guint8* res;
	gint res_length1;
	gint _res_size_;
	gint _tmp0_;
	gint _tmp1_;
	gint _tmp2_;
	guint8* _tmp3_;
	gint _tmp3__length1;
	guint8* _tmp4_;
	gint _tmp4__length1;
	g_return_val_if_fail (self != NULL, NULL);
	res = (guint8*) self;
	res_length1 = -1;
	_res_size_ = res_length1;
	_tmp0_ = strlen (self);
	_tmp1_ = _tmp0_;
	res_length1 = (gint) _tmp1_;
	_tmp2_ = res_length1;
	_tmp3_ = res;
	_tmp3__length1 = res_length1;
	_tmp4_ = _tmp3_;
	_tmp4__length1 = _tmp3__length1;
	if (result_length1) {
		*result_length1 = _tmp4__length1;
	}
	result = _tmp4_;
	return result;
}


static glong string_strnlen (gchar* str, glong maxlen) {
	glong result = 0L;
	gchar* _tmp0_;
	glong _tmp1_;
	gchar* _tmp2_ = NULL;
	gchar* end;
	gchar* _tmp3_;
	_tmp0_ = str;
	_tmp1_ = maxlen;
	_tmp2_ = memchr (_tmp0_, 0, (gsize) _tmp1_);
	end = _tmp2_;
	_tmp3_ = end;
	if (_tmp3_ == NULL) {
		glong _tmp4_;
		_tmp4_ = maxlen;
		result = _tmp4_;
		return result;
	} else {
		gchar* _tmp5_;
		gchar* _tmp6_;
		_tmp5_ = end;
		_tmp6_ = str;
		result = (glong) (_tmp5_ - _tmp6_);
		return result;
	}
}


static gchar* string_substring (const gchar* self, glong offset, glong len) {
	gchar* result = NULL;
	glong string_length = 0L;
	gboolean _tmp0_ = FALSE;
	glong _tmp1_;
	gboolean _tmp3_;
	glong _tmp9_;
	glong _tmp15_;
	glong _tmp18_;
	glong _tmp19_;
	glong _tmp20_;
	glong _tmp21_;
	glong _tmp22_;
	gchar* _tmp23_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp1_ = offset;
	if (_tmp1_ >= ((glong) 0)) {
		glong _tmp2_;
		_tmp2_ = len;
		_tmp0_ = _tmp2_ >= ((glong) 0);
	} else {
		_tmp0_ = FALSE;
	}
	_tmp3_ = _tmp0_;
	if (_tmp3_) {
		glong _tmp4_;
		glong _tmp5_;
		glong _tmp6_ = 0L;
		_tmp4_ = offset;
		_tmp5_ = len;
		_tmp6_ = string_strnlen ((gchar*) self, _tmp4_ + _tmp5_);
		string_length = _tmp6_;
	} else {
		gint _tmp7_;
		gint _tmp8_;
		_tmp7_ = strlen (self);
		_tmp8_ = _tmp7_;
		string_length = (glong) _tmp8_;
	}
	_tmp9_ = offset;
	if (_tmp9_ < ((glong) 0)) {
		glong _tmp10_;
		glong _tmp11_;
		glong _tmp12_;
		_tmp10_ = string_length;
		_tmp11_ = offset;
		offset = _tmp10_ + _tmp11_;
		_tmp12_ = offset;
		g_return_val_if_fail (_tmp12_ >= ((glong) 0), NULL);
	} else {
		glong _tmp13_;
		glong _tmp14_;
		_tmp13_ = offset;
		_tmp14_ = string_length;
		g_return_val_if_fail (_tmp13_ <= _tmp14_, NULL);
	}
	_tmp15_ = len;
	if (_tmp15_ < ((glong) 0)) {
		glong _tmp16_;
		glong _tmp17_;
		_tmp16_ = string_length;
		_tmp17_ = offset;
		len = _tmp16_ - _tmp17_;
	}
	_tmp18_ = offset;
	_tmp19_ = len;
	_tmp20_ = string_length;
	g_return_val_if_fail ((_tmp18_ + _tmp19_) <= _tmp20_, NULL);
	_tmp21_ = offset;
	_tmp22_ = len;
	_tmp23_ = g_strndup (((gchar*) self) + _tmp21_, (gsize) _tmp22_);
	result = _tmp23_;
	return result;
}


gchar* netsukuku_andna_utilities_crypto_hash (const gchar* hostname) {
	gchar* result = NULL;
	const gchar* _tmp0_;
	gchar* _tmp1_ = NULL;
	gchar* ci_hname;
	guint8* _tmp2_;
	gint _tmp2__length1;
	guint8* _tmp3_;
	gint _tmp3__length1;
	gint _tmp4_ = 0;
	guint8* _tmp5_ = NULL;
	guint8* hash;
	gint hash_length1;
	gint _hash_size_;
	gchar* _tmp6_ = NULL;
	gchar* _tmp7_;
	gchar* _tmp8_ = NULL;
	gchar* _tmp9_;
	gchar* ret;
	const gchar* _tmp10_;
	const gchar* _tmp11_ = NULL;
	const gchar* _tmp12_;
	const gchar* _tmp13_ = NULL;
	gchar* _tmp14_ = NULL;
	gchar* _tmp15_;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (hostname != NULL, NULL);
	_tmp0_ = hostname;
	_tmp1_ = g_utf8_strup (_tmp0_, (gssize) (-1));
	ci_hname = _tmp1_;
	_tmp2_ = string_get_data (ci_hname, &_tmp2__length1);
	_tmp3_ = _tmp2_;
	_tmp3__length1 = _tmp2__length1;
	_tmp5_ = netsukuku_crypto_md5 (_tmp3_, _tmp3__length1, &_tmp4_, &_inner_error_);
	hash = _tmp5_;
	hash_length1 = _tmp4_;
	_hash_size_ = hash_length1;
	if (_inner_error_ != NULL) {
		_g_free0 (ci_hname);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return NULL;
	}
	_tmp6_ = g_base64_encode ((guchar*) hash, (hash_length1 * sizeof (guint8)) / sizeof (guchar));
	_tmp7_ = _tmp6_;
	_tmp8_ = string_substring (_tmp7_, (glong) 0, (glong) 22);
	_tmp9_ = _tmp8_;
	_g_free0 (_tmp7_);
	ret = _tmp9_;
	_tmp10_ = hostname;
	_tmp11_ = string_to_string (_tmp10_);
	_tmp12_ = ret;
	_tmp13_ = string_to_string (_tmp12_);
	_tmp14_ = g_strconcat ("AndnaUtilities.crypto_hash: ", _tmp11_, " becomes ", _tmp13_, NULL);
	_tmp15_ = _tmp14_;
	netsukuku_log_debug (_tmp15_);
	_g_free0 (_tmp15_);
	result = ret;
	hash = (g_free (hash), NULL);
	_g_free0 (ci_hname);
	return result;
}



