/* networkinterface_manager.c generated by valac 0.20.1, the Vala compiler
 * generated from networkinterface_manager.vala, do not modify */

/*
 *  This file is part of Netsukuku.
 *  (c) Copyright 2011 Luca Dionisi aka lukisi <luca.dionisi@gmail.com>
 *
 *  Netsukuku is free software: you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation, either version 3 of the License, or
 *  (at your option) any later version.
 *
 *  Netsukuku is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with Netsukuku.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <glib.h>
#include <glib-object.h>
#include <gee.h>
#include <stdlib.h>
#include <string.h>
#include <zcd.h>
#include <netsukuku-rpc.h>
#include <tasklet.h>


#define NETSUKUKU_TYPE_NETWORK_INTERFACE_MANAGER (netsukuku_network_interface_manager_get_type ())
#define NETSUKUKU_NETWORK_INTERFACE_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), NETSUKUKU_TYPE_NETWORK_INTERFACE_MANAGER, NetsukukuNetworkInterfaceManager))
#define NETSUKUKU_NETWORK_INTERFACE_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), NETSUKUKU_TYPE_NETWORK_INTERFACE_MANAGER, NetsukukuNetworkInterfaceManagerClass))
#define NETSUKUKU_IS_NETWORK_INTERFACE_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), NETSUKUKU_TYPE_NETWORK_INTERFACE_MANAGER))
#define NETSUKUKU_IS_NETWORK_INTERFACE_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), NETSUKUKU_TYPE_NETWORK_INTERFACE_MANAGER))
#define NETSUKUKU_NETWORK_INTERFACE_MANAGER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), NETSUKUKU_TYPE_NETWORK_INTERFACE_MANAGER, NetsukukuNetworkInterfaceManagerClass))

typedef struct _NetsukukuNetworkInterfaceManager NetsukukuNetworkInterfaceManager;
typedef struct _NetsukukuNetworkInterfaceManagerClass NetsukukuNetworkInterfaceManagerClass;
typedef struct _NetsukukuNetworkInterfaceManagerPrivate NetsukukuNetworkInterfaceManagerPrivate;

#define NETSUKUKU_TYPE_ADDRESS_MANAGER (netsukuku_address_manager_get_type ())
#define NETSUKUKU_ADDRESS_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), NETSUKUKU_TYPE_ADDRESS_MANAGER, NetsukukuAddressManager))
#define NETSUKUKU_ADDRESS_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), NETSUKUKU_TYPE_ADDRESS_MANAGER, NetsukukuAddressManagerClass))
#define NETSUKUKU_IS_ADDRESS_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), NETSUKUKU_TYPE_ADDRESS_MANAGER))
#define NETSUKUKU_IS_ADDRESS_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), NETSUKUKU_TYPE_ADDRESS_MANAGER))
#define NETSUKUKU_ADDRESS_MANAGER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), NETSUKUKU_TYPE_ADDRESS_MANAGER, NetsukukuAddressManagerClass))

typedef struct _NetsukukuAddressManager NetsukukuAddressManager;
typedef struct _NetsukukuAddressManagerClass NetsukukuAddressManagerClass;

#define NETSUKUKU_TYPE_NEIGHBOUR_MANAGER (netsukuku_neighbour_manager_get_type ())
#define NETSUKUKU_NEIGHBOUR_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), NETSUKUKU_TYPE_NEIGHBOUR_MANAGER, NetsukukuNeighbourManager))
#define NETSUKUKU_NEIGHBOUR_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), NETSUKUKU_TYPE_NEIGHBOUR_MANAGER, NetsukukuNeighbourManagerClass))
#define NETSUKUKU_IS_NEIGHBOUR_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), NETSUKUKU_TYPE_NEIGHBOUR_MANAGER))
#define NETSUKUKU_IS_NEIGHBOUR_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), NETSUKUKU_TYPE_NEIGHBOUR_MANAGER))
#define NETSUKUKU_NEIGHBOUR_MANAGER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), NETSUKUKU_TYPE_NEIGHBOUR_MANAGER, NetsukukuNeighbourManagerClass))

typedef struct _NetsukukuNeighbourManager NetsukukuNeighbourManager;
typedef struct _NetsukukuNeighbourManagerClass NetsukukuNeighbourManagerClass;

#define NETSUKUKU_TYPE_NIC (netsukuku_nic_get_type ())
#define NETSUKUKU_NIC(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), NETSUKUKU_TYPE_NIC, NetsukukuNIC))
#define NETSUKUKU_NIC_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), NETSUKUKU_TYPE_NIC, NetsukukuNICClass))
#define NETSUKUKU_IS_NIC(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), NETSUKUKU_TYPE_NIC))
#define NETSUKUKU_IS_NIC_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), NETSUKUKU_TYPE_NIC))
#define NETSUKUKU_NIC_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), NETSUKUKU_TYPE_NIC, NetsukukuNICClass))

typedef struct _NetsukukuNIC NetsukukuNIC;
typedef struct _NetsukukuNICClass NetsukukuNICClass;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
typedef struct _NetsukukuAddressManagerPrivate NetsukukuAddressManagerPrivate;

#define NETSUKUKU_TYPE_HOOK_INFORMATION (netsukuku_hook_information_get_type ())
#define NETSUKUKU_HOOK_INFORMATION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), NETSUKUKU_TYPE_HOOK_INFORMATION, NetsukukuHookInformation))
#define NETSUKUKU_HOOK_INFORMATION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), NETSUKUKU_TYPE_HOOK_INFORMATION, NetsukukuHookInformationClass))
#define NETSUKUKU_IS_HOOK_INFORMATION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), NETSUKUKU_TYPE_HOOK_INFORMATION))
#define NETSUKUKU_IS_HOOK_INFORMATION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), NETSUKUKU_TYPE_HOOK_INFORMATION))
#define NETSUKUKU_HOOK_INFORMATION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), NETSUKUKU_TYPE_HOOK_INFORMATION, NetsukukuHookInformationClass))

typedef struct _NetsukukuHookInformation NetsukukuHookInformation;
typedef struct _NetsukukuHookInformationClass NetsukukuHookInformationClass;

#define NETSUKUKU_TYPE_INCOMING_NODES (netsukuku_incoming_nodes_get_type ())
#define NETSUKUKU_INCOMING_NODES(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), NETSUKUKU_TYPE_INCOMING_NODES, NetsukukuIncomingNodes))
#define NETSUKUKU_INCOMING_NODES_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), NETSUKUKU_TYPE_INCOMING_NODES, NetsukukuIncomingNodesClass))
#define NETSUKUKU_IS_INCOMING_NODES(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), NETSUKUKU_TYPE_INCOMING_NODES))
#define NETSUKUKU_IS_INCOMING_NODES_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), NETSUKUKU_TYPE_INCOMING_NODES))
#define NETSUKUKU_INCOMING_NODES_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), NETSUKUKU_TYPE_INCOMING_NODES, NetsukukuIncomingNodesClass))

typedef struct _NetsukukuIncomingNodes NetsukukuIncomingNodes;
typedef struct _NetsukukuIncomingNodesClass NetsukukuIncomingNodesClass;

#define NETSUKUKU_TYPE_MAP (netsukuku_map_get_type ())
#define NETSUKUKU_MAP(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), NETSUKUKU_TYPE_MAP, NetsukukuMap))
#define NETSUKUKU_MAP_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), NETSUKUKU_TYPE_MAP, NetsukukuMapClass))
#define NETSUKUKU_IS_MAP(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), NETSUKUKU_TYPE_MAP))
#define NETSUKUKU_IS_MAP_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), NETSUKUKU_TYPE_MAP))
#define NETSUKUKU_MAP_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), NETSUKUKU_TYPE_MAP, NetsukukuMapClass))

typedef struct _NetsukukuMap NetsukukuMap;
typedef struct _NetsukukuMapClass NetsukukuMapClass;

#define NETSUKUKU_TYPE_MAP_ROUTE (netsukuku_map_route_get_type ())
#define NETSUKUKU_MAP_ROUTE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), NETSUKUKU_TYPE_MAP_ROUTE, NetsukukuMapRoute))
#define NETSUKUKU_MAP_ROUTE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), NETSUKUKU_TYPE_MAP_ROUTE, NetsukukuMapRouteClass))
#define NETSUKUKU_IS_MAP_ROUTE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), NETSUKUKU_TYPE_MAP_ROUTE))
#define NETSUKUKU_IS_MAP_ROUTE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), NETSUKUKU_TYPE_MAP_ROUTE))
#define NETSUKUKU_MAP_ROUTE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), NETSUKUKU_TYPE_MAP_ROUTE, NetsukukuMapRouteClass))

typedef struct _NetsukukuMapRoute NetsukukuMapRoute;
typedef struct _NetsukukuMapRouteClass NetsukukuMapRouteClass;

#define NETSUKUKU_TYPE_AGGREGATED_NEIGHBOUR_MANAGER (netsukuku_aggregated_neighbour_manager_get_type ())
#define NETSUKUKU_AGGREGATED_NEIGHBOUR_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), NETSUKUKU_TYPE_AGGREGATED_NEIGHBOUR_MANAGER, NetsukukuAggregatedNeighbourManager))
#define NETSUKUKU_AGGREGATED_NEIGHBOUR_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), NETSUKUKU_TYPE_AGGREGATED_NEIGHBOUR_MANAGER, NetsukukuAggregatedNeighbourManagerClass))
#define NETSUKUKU_IS_AGGREGATED_NEIGHBOUR_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), NETSUKUKU_TYPE_AGGREGATED_NEIGHBOUR_MANAGER))
#define NETSUKUKU_IS_AGGREGATED_NEIGHBOUR_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), NETSUKUKU_TYPE_AGGREGATED_NEIGHBOUR_MANAGER))
#define NETSUKUKU_AGGREGATED_NEIGHBOUR_MANAGER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), NETSUKUKU_TYPE_AGGREGATED_NEIGHBOUR_MANAGER, NetsukukuAggregatedNeighbourManagerClass))

typedef struct _NetsukukuAggregatedNeighbourManager NetsukukuAggregatedNeighbourManager;
typedef struct _NetsukukuAggregatedNeighbourManagerClass NetsukukuAggregatedNeighbourManagerClass;

#define NETSUKUKU_TYPE_ETP (netsukuku_etp_get_type ())
#define NETSUKUKU_ETP(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), NETSUKUKU_TYPE_ETP, NetsukukuEtp))
#define NETSUKUKU_ETP_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), NETSUKUKU_TYPE_ETP, NetsukukuEtpClass))
#define NETSUKUKU_IS_ETP(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), NETSUKUKU_TYPE_ETP))
#define NETSUKUKU_IS_ETP_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), NETSUKUKU_TYPE_ETP))
#define NETSUKUKU_ETP_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), NETSUKUKU_TYPE_ETP, NetsukukuEtpClass))

typedef struct _NetsukukuEtp NetsukukuEtp;
typedef struct _NetsukukuEtpClass NetsukukuEtpClass;

#define NETSUKUKU_TYPE_PEER_TO_PEER_ALL (netsukuku_peer_to_peer_all_get_type ())
#define NETSUKUKU_PEER_TO_PEER_ALL(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), NETSUKUKU_TYPE_PEER_TO_PEER_ALL, NetsukukuPeerToPeerAll))
#define NETSUKUKU_PEER_TO_PEER_ALL_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), NETSUKUKU_TYPE_PEER_TO_PEER_ALL, NetsukukuPeerToPeerAllClass))
#define NETSUKUKU_IS_PEER_TO_PEER_ALL(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), NETSUKUKU_TYPE_PEER_TO_PEER_ALL))
#define NETSUKUKU_IS_PEER_TO_PEER_ALL_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), NETSUKUKU_TYPE_PEER_TO_PEER_ALL))
#define NETSUKUKU_PEER_TO_PEER_ALL_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), NETSUKUKU_TYPE_PEER_TO_PEER_ALL, NetsukukuPeerToPeerAllClass))

typedef struct _NetsukukuPeerToPeerAll NetsukukuPeerToPeerAll;
typedef struct _NetsukukuPeerToPeerAllClass NetsukukuPeerToPeerAllClass;

#define NETSUKUKU_TYPE_PEER_TO_PEER (netsukuku_peer_to_peer_get_type ())
#define NETSUKUKU_PEER_TO_PEER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), NETSUKUKU_TYPE_PEER_TO_PEER, NetsukukuPeerToPeer))
#define NETSUKUKU_PEER_TO_PEER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), NETSUKUKU_TYPE_PEER_TO_PEER, NetsukukuPeerToPeerClass))
#define NETSUKUKU_IS_PEER_TO_PEER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), NETSUKUKU_TYPE_PEER_TO_PEER))
#define NETSUKUKU_IS_PEER_TO_PEER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), NETSUKUKU_TYPE_PEER_TO_PEER))
#define NETSUKUKU_PEER_TO_PEER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), NETSUKUKU_TYPE_PEER_TO_PEER, NetsukukuPeerToPeerClass))

typedef struct _NetsukukuPeerToPeer NetsukukuPeerToPeer;
typedef struct _NetsukukuPeerToPeerClass NetsukukuPeerToPeerClass;

#define NETSUKUKU_TYPE_COORDINATOR (netsukuku_coordinator_get_type ())
#define NETSUKUKU_COORDINATOR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), NETSUKUKU_TYPE_COORDINATOR, NetsukukuCoordinator))
#define NETSUKUKU_COORDINATOR_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), NETSUKUKU_TYPE_COORDINATOR, NetsukukuCoordinatorClass))
#define NETSUKUKU_IS_COORDINATOR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), NETSUKUKU_TYPE_COORDINATOR))
#define NETSUKUKU_IS_COORDINATOR_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), NETSUKUKU_TYPE_COORDINATOR))
#define NETSUKUKU_COORDINATOR_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), NETSUKUKU_TYPE_COORDINATOR, NetsukukuCoordinatorClass))

typedef struct _NetsukukuCoordinator NetsukukuCoordinator;
typedef struct _NetsukukuCoordinatorClass NetsukukuCoordinatorClass;

#define NETSUKUKU_TYPE_KEY_PAIR (netsukuku_key_pair_get_type ())
#define NETSUKUKU_KEY_PAIR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), NETSUKUKU_TYPE_KEY_PAIR, NetsukukuKeyPair))
#define NETSUKUKU_KEY_PAIR_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), NETSUKUKU_TYPE_KEY_PAIR, NetsukukuKeyPairClass))
#define NETSUKUKU_IS_KEY_PAIR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), NETSUKUKU_TYPE_KEY_PAIR))
#define NETSUKUKU_IS_KEY_PAIR_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), NETSUKUKU_TYPE_KEY_PAIR))
#define NETSUKUKU_KEY_PAIR_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), NETSUKUKU_TYPE_KEY_PAIR, NetsukukuKeyPairClass))

typedef struct _NetsukukuKeyPair NetsukukuKeyPair;
typedef struct _NetsukukuKeyPairClass NetsukukuKeyPairClass;

#define NETSUKUKU_TYPE_COUNTER (netsukuku_counter_get_type ())
#define NETSUKUKU_COUNTER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), NETSUKUKU_TYPE_COUNTER, NetsukukuCounter))
#define NETSUKUKU_COUNTER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), NETSUKUKU_TYPE_COUNTER, NetsukukuCounterClass))
#define NETSUKUKU_IS_COUNTER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), NETSUKUKU_TYPE_COUNTER))
#define NETSUKUKU_IS_COUNTER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), NETSUKUKU_TYPE_COUNTER))
#define NETSUKUKU_COUNTER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), NETSUKUKU_TYPE_COUNTER, NetsukukuCounterClass))

typedef struct _NetsukukuCounter NetsukukuCounter;
typedef struct _NetsukukuCounterClass NetsukukuCounterClass;

#define NETSUKUKU_TYPE_ANDNA (netsukuku_andna_get_type ())
#define NETSUKUKU_ANDNA(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), NETSUKUKU_TYPE_ANDNA, NetsukukuAndna))
#define NETSUKUKU_ANDNA_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), NETSUKUKU_TYPE_ANDNA, NetsukukuAndnaClass))
#define NETSUKUKU_IS_ANDNA(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), NETSUKUKU_TYPE_ANDNA))
#define NETSUKUKU_IS_ANDNA_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), NETSUKUKU_TYPE_ANDNA))
#define NETSUKUKU_ANDNA_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), NETSUKUKU_TYPE_ANDNA, NetsukukuAndnaClass))

typedef struct _NetsukukuAndna NetsukukuAndna;
typedef struct _NetsukukuAndnaClass NetsukukuAndnaClass;

#define NETSUKUKU_TYPE_TUNNEL_MANAGER (netsukuku_tunnel_manager_get_type ())
#define NETSUKUKU_TUNNEL_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), NETSUKUKU_TYPE_TUNNEL_MANAGER, NetsukukuTunnelManager))
#define NETSUKUKU_TUNNEL_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), NETSUKUKU_TYPE_TUNNEL_MANAGER, NetsukukuTunnelManagerClass))
#define NETSUKUKU_IS_TUNNEL_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), NETSUKUKU_TYPE_TUNNEL_MANAGER))
#define NETSUKUKU_IS_TUNNEL_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), NETSUKUKU_TYPE_TUNNEL_MANAGER))
#define NETSUKUKU_TUNNEL_MANAGER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), NETSUKUKU_TYPE_TUNNEL_MANAGER, NetsukukuTunnelManagerClass))

typedef struct _NetsukukuTunnelManager NetsukukuTunnelManager;
typedef struct _NetsukukuTunnelManagerClass NetsukukuTunnelManagerClass;

#define NETSUKUKU_TYPE_HOOK (netsukuku_hook_get_type ())
#define NETSUKUKU_HOOK(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), NETSUKUKU_TYPE_HOOK, NetsukukuHook))
#define NETSUKUKU_HOOK_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), NETSUKUKU_TYPE_HOOK, NetsukukuHookClass))
#define NETSUKUKU_IS_HOOK(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), NETSUKUKU_TYPE_HOOK))
#define NETSUKUKU_IS_HOOK_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), NETSUKUKU_TYPE_HOOK))
#define NETSUKUKU_HOOK_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), NETSUKUKU_TYPE_HOOK, NetsukukuHookClass))

typedef struct _NetsukukuHook NetsukukuHook;
typedef struct _NetsukukuHookClass NetsukukuHookClass;

#define NETSUKUKU_TYPE_BORDER_NODES_MANAGER (netsukuku_border_nodes_manager_get_type ())
#define NETSUKUKU_BORDER_NODES_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), NETSUKUKU_TYPE_BORDER_NODES_MANAGER, NetsukukuBorderNodesManager))
#define NETSUKUKU_BORDER_NODES_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), NETSUKUKU_TYPE_BORDER_NODES_MANAGER, NetsukukuBorderNodesManagerClass))
#define NETSUKUKU_IS_BORDER_NODES_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), NETSUKUKU_TYPE_BORDER_NODES_MANAGER))
#define NETSUKUKU_IS_BORDER_NODES_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), NETSUKUKU_TYPE_BORDER_NODES_MANAGER))
#define NETSUKUKU_BORDER_NODES_MANAGER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), NETSUKUKU_TYPE_BORDER_NODES_MANAGER, NetsukukuBorderNodesManagerClass))

typedef struct _NetsukukuBorderNodesManager NetsukukuBorderNodesManager;
typedef struct _NetsukukuBorderNodesManagerClass NetsukukuBorderNodesManagerClass;

#define NETSUKUKU_TYPE_MIGRATION_MANAGER (netsukuku_migration_manager_get_type ())
#define NETSUKUKU_MIGRATION_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), NETSUKUKU_TYPE_MIGRATION_MANAGER, NetsukukuMigrationManager))
#define NETSUKUKU_MIGRATION_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), NETSUKUKU_TYPE_MIGRATION_MANAGER, NetsukukuMigrationManagerClass))
#define NETSUKUKU_IS_MIGRATION_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), NETSUKUKU_TYPE_MIGRATION_MANAGER))
#define NETSUKUKU_IS_MIGRATION_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), NETSUKUKU_TYPE_MIGRATION_MANAGER))
#define NETSUKUKU_MIGRATION_MANAGER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), NETSUKUKU_TYPE_MIGRATION_MANAGER, NetsukukuMigrationManagerClass))

typedef struct _NetsukukuMigrationManager NetsukukuMigrationManager;
typedef struct _NetsukukuMigrationManagerClass NetsukukuMigrationManagerClass;

#define NETSUKUKU_TYPE_IGS_MANAGER_DISPATCHER (netsukuku_igs_manager_dispatcher_get_type ())
#define NETSUKUKU_IGS_MANAGER_DISPATCHER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), NETSUKUKU_TYPE_IGS_MANAGER_DISPATCHER, NetsukukuIGSManagerDispatcher))
#define NETSUKUKU_IGS_MANAGER_DISPATCHER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), NETSUKUKU_TYPE_IGS_MANAGER_DISPATCHER, NetsukukuIGSManagerDispatcherClass))
#define NETSUKUKU_IS_IGS_MANAGER_DISPATCHER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), NETSUKUKU_TYPE_IGS_MANAGER_DISPATCHER))
#define NETSUKUKU_IS_IGS_MANAGER_DISPATCHER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), NETSUKUKU_TYPE_IGS_MANAGER_DISPATCHER))
#define NETSUKUKU_IGS_MANAGER_DISPATCHER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), NETSUKUKU_TYPE_IGS_MANAGER_DISPATCHER, NetsukukuIGSManagerDispatcherClass))

typedef struct _NetsukukuIGSManagerDispatcher NetsukukuIGSManagerDispatcher;
typedef struct _NetsukukuIGSManagerDispatcherClass NetsukukuIGSManagerDispatcherClass;

#define NETSUKUKU_TYPE_RADAR (netsukuku_radar_get_type ())
#define NETSUKUKU_RADAR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), NETSUKUKU_TYPE_RADAR, NetsukukuRadar))
#define NETSUKUKU_RADAR_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), NETSUKUKU_TYPE_RADAR, NetsukukuRadarClass))
#define NETSUKUKU_IS_RADAR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), NETSUKUKU_TYPE_RADAR))
#define NETSUKUKU_IS_RADAR_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), NETSUKUKU_TYPE_RADAR))
#define NETSUKUKU_RADAR_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), NETSUKUKU_TYPE_RADAR, NetsukukuRadarClass))

typedef struct _NetsukukuRadar NetsukukuRadar;
typedef struct _NetsukukuRadarClass NetsukukuRadarClass;

#define NETSUKUKU_TYPE_STRUCT_HELPER_GLUENETWORKINTERFACEMANAGER_KEEP_UPDATING_NETID (netsukuku_struct_helper_gluenetworkinterfacemanager_keep_updating_netid_get_type ())

#define NETSUKUKU_TYPE_GLUE_NETWORK_INTERFACE_MANAGER (netsukuku_glue_network_interface_manager_get_type ())
#define NETSUKUKU_GLUE_NETWORK_INTERFACE_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), NETSUKUKU_TYPE_GLUE_NETWORK_INTERFACE_MANAGER, NetsukukuGlueNetworkInterfaceManager))
#define NETSUKUKU_GLUE_NETWORK_INTERFACE_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), NETSUKUKU_TYPE_GLUE_NETWORK_INTERFACE_MANAGER, NetsukukuGlueNetworkInterfaceManagerClass))
#define NETSUKUKU_IS_GLUE_NETWORK_INTERFACE_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), NETSUKUKU_TYPE_GLUE_NETWORK_INTERFACE_MANAGER))
#define NETSUKUKU_IS_GLUE_NETWORK_INTERFACE_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), NETSUKUKU_TYPE_GLUE_NETWORK_INTERFACE_MANAGER))
#define NETSUKUKU_GLUE_NETWORK_INTERFACE_MANAGER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), NETSUKUKU_TYPE_GLUE_NETWORK_INTERFACE_MANAGER, NetsukukuGlueNetworkInterfaceManagerClass))

typedef struct _NetsukukuGlueNetworkInterfaceManager NetsukukuGlueNetworkInterfaceManager;
typedef struct _NetsukukuGlueNetworkInterfaceManagerClass NetsukukuGlueNetworkInterfaceManagerClass;
typedef struct _Netsukukustruct_helper_GlueNetworkInterfaceManager_keep_updating_netid Netsukukustruct_helper_GlueNetworkInterfaceManager_keep_updating_netid;
typedef struct _NetsukukuGlueNetworkInterfaceManagerPrivate NetsukukuGlueNetworkInterfaceManagerPrivate;

#define NETSUKUKU_TYPE_GLUE_RADAR (netsukuku_glue_radar_get_type ())
#define NETSUKUKU_GLUE_RADAR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), NETSUKUKU_TYPE_GLUE_RADAR, NetsukukuGlueRadar))
#define NETSUKUKU_GLUE_RADAR_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), NETSUKUKU_TYPE_GLUE_RADAR, NetsukukuGlueRadarClass))
#define NETSUKUKU_IS_GLUE_RADAR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), NETSUKUKU_TYPE_GLUE_RADAR))
#define NETSUKUKU_IS_GLUE_RADAR_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), NETSUKUKU_TYPE_GLUE_RADAR))
#define NETSUKUKU_GLUE_RADAR_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), NETSUKUKU_TYPE_GLUE_RADAR, NetsukukuGlueRadarClass))

typedef struct _NetsukukuGlueRadar NetsukukuGlueRadar;
typedef struct _NetsukukuGlueRadarClass NetsukukuGlueRadarClass;

#define NETSUKUKU_TYPE_GLUE_NEIGHBOUR_MANAGER (netsukuku_glue_neighbour_manager_get_type ())
#define NETSUKUKU_GLUE_NEIGHBOUR_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), NETSUKUKU_TYPE_GLUE_NEIGHBOUR_MANAGER, NetsukukuGlueNeighbourManager))
#define NETSUKUKU_GLUE_NEIGHBOUR_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), NETSUKUKU_TYPE_GLUE_NEIGHBOUR_MANAGER, NetsukukuGlueNeighbourManagerClass))
#define NETSUKUKU_IS_GLUE_NEIGHBOUR_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), NETSUKUKU_TYPE_GLUE_NEIGHBOUR_MANAGER))
#define NETSUKUKU_IS_GLUE_NEIGHBOUR_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), NETSUKUKU_TYPE_GLUE_NEIGHBOUR_MANAGER))
#define NETSUKUKU_GLUE_NEIGHBOUR_MANAGER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), NETSUKUKU_TYPE_GLUE_NEIGHBOUR_MANAGER, NetsukukuGlueNeighbourManagerClass))

typedef struct _NetsukukuGlueNeighbourManager NetsukukuGlueNeighbourManager;
typedef struct _NetsukukuGlueNeighbourManagerClass NetsukukuGlueNeighbourManagerClass;

#define NETSUKUKU_TYPE_NEIGHBOUR (netsukuku_neighbour_get_type ())
#define NETSUKUKU_NEIGHBOUR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), NETSUKUKU_TYPE_NEIGHBOUR, NetsukukuNeighbour))
#define NETSUKUKU_NEIGHBOUR_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), NETSUKUKU_TYPE_NEIGHBOUR, NetsukukuNeighbourClass))
#define NETSUKUKU_IS_NEIGHBOUR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), NETSUKUKU_TYPE_NEIGHBOUR))
#define NETSUKUKU_IS_NEIGHBOUR_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), NETSUKUKU_TYPE_NEIGHBOUR))
#define NETSUKUKU_NEIGHBOUR_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), NETSUKUKU_TYPE_NEIGHBOUR, NetsukukuNeighbourClass))

typedef struct _NetsukukuNeighbour NetsukukuNeighbour;
typedef struct _NetsukukuNeighbourClass NetsukukuNeighbourClass;
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
typedef struct _NetsukukuRadarPrivate NetsukukuRadarPrivate;
typedef struct _NetsukukuGlueRadarPrivate NetsukukuGlueRadarPrivate;
typedef struct _NetsukukuNeighbourManagerPrivate NetsukukuNeighbourManagerPrivate;
typedef struct _NetsukukuGlueNeighbourManagerPrivate NetsukukuGlueNeighbourManagerPrivate;

struct _NetsukukuNetworkInterfaceManager {
	GObject parent_instance;
	NetsukukuNetworkInterfaceManagerPrivate * priv;
	gboolean to_be_managed;
	gboolean to_be_copied;
	gboolean initialized;
	GeeArrayList* addrs;
};

struct _NetsukukuNetworkInterfaceManagerClass {
	GObjectClass parent_class;
	NetsukukuNeighbourManager* (*create_neighbour_manager) (NetsukukuNetworkInterfaceManager* self, NetsukukuAddressManager* addr_man);
	void (*dispose_neighbour_manager) (NetsukukuNetworkInterfaceManager* self, NetsukukuAddressManager* addr_man, NetsukukuNeighbourManager* neighbour_manager);
	void (*add_address) (NetsukukuNetworkInterfaceManager* self, NetsukukuAddressManager* address_manager);
	void (*remove_address) (NetsukukuNetworkInterfaceManager* self, NetsukukuAddressManager* address_manager);
};

struct _NetsukukuNetworkInterfaceManagerPrivate {
	NetsukukuNIC* _nic_class;
	gchar* _nic_name;
	zcdUnicastCallbackDelegate udp_unicast_callback;
	zcdBroadcastCallbackDelegate udp_broadcast_callback;
	zcdUDPServer* udpserver;
};

typedef NetsukukuNIC* (*NetsukukuCreateNicDelegate) (const gchar* nic_name, void* user_data);
struct _NetsukukuAddressManager {
	GObject parent_instance;
	NetsukukuAddressManagerPrivate * priv;
	GeeArrayList* auxiliary_addresses;
	gint levels;
	gint gsize;
	NetsukukuKeyPair* keypair;
	NetsukukuCreateNicDelegate create_new_nic;
	gpointer create_new_nic_target;
	GDestroyNotify create_new_nic_target_destroy_notify;
	gboolean operative;
	gboolean is_mature;
	NetsukukuIncomingNodes* incoming_nodes;
	NetsukukuMapRoute* maproute;
	NetsukukuAggregatedNeighbourManager* aggregated_neighbour_manager;
	NetsukukuEtp* etp;
	NetsukukuPeerToPeerAll* peer_to_peer_all;
	NetsukukuCoordinator* coordinator;
	NetsukukuCounter* counter;
	NetsukukuAndna* andna;
	NetsukukuTunnelManager* tunnel_manager;
	NetsukukuHook* hook;
	NetsukukuBorderNodesManager* border_nodes_manager;
	NetsukukuMigrationManager* migration_manager;
	NetsukukuIGSManagerDispatcher* igs_manager;
	GeeArrayList* nics;
	GeeHashMap* neighbour_managers;
};

struct _NetsukukuAddressManagerClass {
	GObjectClass parent_class;
	void (*_get_data_from_hook_information) (NetsukukuAddressManager* self, gint levels, gint gsize, NetsukukuHookInformation* hook_information, NetsukukuNIP** nip, NetsukukuGNodeID*** id_myself, int* id_myself_length1);
	NetsukukuIncomingNodes* (*create_IncomingNodes) (NetsukukuAddressManager* self);
	NetsukukuMapRoute* (*create_MapRoute) (NetsukukuAddressManager* self, gint levels, gint gsize, NetsukukuNIP* nip, NetsukukuGNodeID** id_myself, int id_myself_length1);
	NetsukukuAggregatedNeighbourManager* (*create_AggregatedNeighbourManager) (NetsukukuAddressManager* self);
	NetsukukuEtp* (*create_Etp) (NetsukukuAddressManager* self, NetsukukuAggregatedNeighbourManager* aggregated_neighbour_manager, NetsukukuMapRoute* maproute);
	NetsukukuPeerToPeerAll* (*create_PeerToPeerAll) (NetsukukuAddressManager* self, NetsukukuAggregatedNeighbourManager* aggregated_neighbour_manager, NetsukukuMapRoute* maproute);
	NetsukukuCoordinator* (*create_Coordinator) (NetsukukuAddressManager* self, NetsukukuAggregatedNeighbourManager* aggregated_neighbour_manager, NetsukukuMapRoute* maproute, NetsukukuPeerToPeerAll* peer_to_peer_all);
	NetsukukuCounter* (*create_Counter) (NetsukukuAddressManager* self, NetsukukuKeyPair* keypair, NetsukukuAggregatedNeighbourManager* aggregated_neighbour_manager, NetsukukuMapRoute* maproute, NetsukukuPeerToPeerAll* peer_to_peer_all);
	NetsukukuAndna* (*create_Andna) (NetsukukuAddressManager* self, NetsukukuKeyPair* keypair, NetsukukuCounter* counter, NetsukukuAggregatedNeighbourManager* aggregated_neighbour_manager, NetsukukuMapRoute* maproute, NetsukukuPeerToPeerAll* peer_to_peer_all);
	NetsukukuTunnelManager* (*create_TunnelManager) (NetsukukuAddressManager* self, const gchar* ipstr);
	NetsukukuHook* (*create_Hook) (NetsukukuAddressManager* self, NetsukukuMapRoute* maproute);
	NetsukukuBorderNodesManager* (*create_BorderNodesManager) (NetsukukuAddressManager* self, NetsukukuMapRoute* maproute, NetsukukuAggregatedNeighbourManager* aggregated_neighbour_manager);
	NetsukukuMigrationManager* (*create_MigrationManager) (NetsukukuAddressManager* self, NetsukukuMapRoute* maproute, NetsukukuAggregatedNeighbourManager* aggregated_neighbour_manager);
	gboolean (*do_i_act_as_gateway_for) (NetsukukuAddressManager* self, NetsukukuNIP* nip, gint nodeid, NetsukukuNetworkID* netid);
	gboolean (*do_i_act_as_gateway_for_local) (NetsukukuAddressManager* self);
	gboolean (*do_i_participate_in_routing_tables) (NetsukukuAddressManager* self);
	gboolean (*get_is_auxiliary) (NetsukukuAddressManager* self);
	gboolean (*get_is_autonomous) (NetsukukuAddressManager* self);
};

struct _Netsukukustruct_helper_GlueNetworkInterfaceManager_keep_updating_netid {
	NetsukukuGlueNetworkInterfaceManager* self;
};

struct _NetsukukuGlueNetworkInterfaceManager {
	NetsukukuNetworkInterfaceManager parent_instance;
	NetsukukuGlueNetworkInterfaceManagerPrivate * priv;
};

struct _NetsukukuGlueNetworkInterfaceManagerClass {
	NetsukukuNetworkInterfaceManagerClass parent_class;
};

struct _NetsukukuGlueNetworkInterfaceManagerPrivate {
	NetsukukuNeighbourManager* neighbour_manager;
};

struct _NetsukukuRadar {
	GObject parent_instance;
	NetsukukuRadarPrivate * priv;
	gchar* dev_name;
	NetsukukuAddressManager* address_manager;
	gint bouquet_numb;
	gint max_bouquet;
	gint wait_time;
	NetsukukuAddressManagerBroadcastClient* bcastclient;
	GeeArrayList* radar_ids;
};

struct _NetsukukuRadarClass {
	GObjectClass parent_class;
	void (*radar) (NetsukukuRadar* self);
	void (*time_register) (NetsukukuRadar* self, gint radar_id, gint levels, gint gsize, NetsukukuNIP* nip, gint nodeid, NetsukukuNetworkID* netid, const gchar* mac, gboolean is_primary, gboolean is_auxiliary);
	GeeHashMap* (*get_all_avg_rtt) (NetsukukuRadar* self);
};

struct _NetsukukuGlueRadar {
	NetsukukuRadar parent_instance;
	NetsukukuGlueRadarPrivate * priv;
};

struct _NetsukukuGlueRadarClass {
	NetsukukuRadarClass parent_class;
};

struct _NetsukukuNeighbourManager {
	GObject parent_instance;
	NetsukukuNeighbourManagerPrivate * priv;
};

struct _NetsukukuNeighbourManagerClass {
	GObjectClass parent_class;
	GeeList* (*neighbour_list) (NetsukukuNeighbourManager* self);
	void (*declare_dead) (NetsukukuNeighbourManager* self, NetsukukuNIP* nip, gint nodeid);
};

struct _NetsukukuGlueNeighbourManager {
	NetsukukuNeighbourManager parent_instance;
	NetsukukuGlueNeighbourManagerPrivate * priv;
};

struct _NetsukukuGlueNeighbourManagerClass {
	NetsukukuNeighbourManagerClass parent_class;
};

struct _NetsukukuGlueNeighbourManagerPrivate {
	NetsukukuGlueNetworkInterfaceManager* gluenic;
};


static gpointer netsukuku_network_interface_manager_parent_class = NULL;
static gpointer netsukuku_glue_network_interface_manager_parent_class = NULL;
static gpointer netsukuku_glue_radar_parent_class = NULL;
static gpointer netsukuku_glue_neighbour_manager_parent_class = NULL;

GType netsukuku_network_interface_manager_get_type (void) G_GNUC_CONST;
GType netsukuku_address_manager_get_type (void) G_GNUC_CONST;
GType netsukuku_neighbour_manager_get_type (void) G_GNUC_CONST;
GType netsukuku_nic_get_type (void) G_GNUC_CONST;
#define NETSUKUKU_NETWORK_INTERFACE_MANAGER_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), NETSUKUKU_TYPE_NETWORK_INTERFACE_MANAGER, NetsukukuNetworkInterfaceManagerPrivate))
enum  {
	NETSUKUKU_NETWORK_INTERFACE_MANAGER_DUMMY_PROPERTY,
	NETSUKUKU_NETWORK_INTERFACE_MANAGER_NIC_CLASS,
	NETSUKUKU_NETWORK_INTERFACE_MANAGER_NIC_NAME
};
NetsukukuNetworkInterfaceManager* netsukuku_network_interface_manager_new_fake (void);
NetsukukuNetworkInterfaceManager* netsukuku_network_interface_manager_construct_fake (GType object_type);
NetsukukuNetworkInterfaceManager* netsukuku_network_interface_manager_new (const gchar* nic_name, NetsukukuNIC* nic_class, zcdUnicastCallbackDelegate udp_unicast_callback, zcdBroadcastCallbackDelegate udp_broadcast_callback);
NetsukukuNetworkInterfaceManager* netsukuku_network_interface_manager_construct (GType object_type, const gchar* nic_name, NetsukukuNIC* nic_class, zcdUnicastCallbackDelegate udp_unicast_callback, zcdBroadcastCallbackDelegate udp_broadcast_callback);
void netsukuku_network_interface_manager_set_nic_class (NetsukukuNetworkInterfaceManager* self, NetsukukuNIC* value);
void netsukuku_network_interface_manager_set_nic_name (NetsukukuNetworkInterfaceManager* self, const gchar* value);
void netsukuku_network_interface_manager_initialize (NetsukukuNetworkInterfaceManager* self);
const gchar* netsukuku_network_interface_manager_get_nic_name (NetsukukuNetworkInterfaceManager* self);
NetsukukuNIC* netsukuku_network_interface_manager_get_nic_class (NetsukukuNetworkInterfaceManager* self);
void netsukuku_nic_disable_filtering (NetsukukuNIC* self);
NetsukukuNeighbourManager* netsukuku_network_interface_manager_create_neighbour_manager (NetsukukuNetworkInterfaceManager* self, NetsukukuAddressManager* addr_man);
static NetsukukuNeighbourManager* netsukuku_network_interface_manager_real_create_neighbour_manager (NetsukukuNetworkInterfaceManager* self, NetsukukuAddressManager* addr_man);
gchar* netsukuku_nip_to_str (gint levels, gint gsize, NetsukukuNIP* nip);
GType netsukuku_hook_information_get_type (void) G_GNUC_CONST;
GType netsukuku_incoming_nodes_get_type (void) G_GNUC_CONST;
GType netsukuku_map_get_type (void) G_GNUC_CONST;
GType netsukuku_map_route_get_type (void) G_GNUC_CONST;
GType netsukuku_aggregated_neighbour_manager_get_type (void) G_GNUC_CONST;
GType netsukuku_etp_get_type (void) G_GNUC_CONST;
GType netsukuku_peer_to_peer_all_get_type (void) G_GNUC_CONST;
GType netsukuku_peer_to_peer_get_type (void) G_GNUC_CONST;
GType netsukuku_coordinator_get_type (void) G_GNUC_CONST;
GType netsukuku_key_pair_get_type (void) G_GNUC_CONST;
GType netsukuku_counter_get_type (void) G_GNUC_CONST;
GType netsukuku_andna_get_type (void) G_GNUC_CONST;
GType netsukuku_tunnel_manager_get_type (void) G_GNUC_CONST;
GType netsukuku_hook_get_type (void) G_GNUC_CONST;
GType netsukuku_border_nodes_manager_get_type (void) G_GNUC_CONST;
GType netsukuku_migration_manager_get_type (void) G_GNUC_CONST;
GType netsukuku_igs_manager_dispatcher_get_type (void) G_GNUC_CONST;
gint netsukuku_map_get_levels (NetsukukuMap* self);
gint netsukuku_map_get_gsize (NetsukukuMap* self);
NetsukukuNIP* netsukuku_map_get_me (NetsukukuMap* self);
void netsukuku_nic_add_address (NetsukukuNIC* self, const gchar* address);
void netsukuku_log_debug (const gchar* msg);
NetsukukuRadar* netsukuku_radar_new (const gchar* dev_name, NetsukukuAddressManager* address_manager);
NetsukukuRadar* netsukuku_radar_construct (GType object_type, const gchar* dev_name, NetsukukuAddressManager* address_manager);
GType netsukuku_radar_get_type (void) G_GNUC_CONST;
NetsukukuNeighbourManager* netsukuku_neighbour_manager_new (NetsukukuRadar* radar, gint max_neighbours);
NetsukukuNeighbourManager* netsukuku_neighbour_manager_construct (GType object_type, NetsukukuRadar* radar, gint max_neighbours);
void netsukuku_radar_run (NetsukukuRadar* self);
void netsukuku_network_interface_manager_dispose_neighbour_manager (NetsukukuNetworkInterfaceManager* self, NetsukukuAddressManager* addr_man, NetsukukuNeighbourManager* neighbour_manager);
static void netsukuku_network_interface_manager_real_dispose_neighbour_manager (NetsukukuNetworkInterfaceManager* self, NetsukukuAddressManager* addr_man, NetsukukuNeighbourManager* neighbour_manager);
NetsukukuRadar* netsukuku_neighbour_manager_get_radar (NetsukukuNeighbourManager* self);
void netsukuku_radar_stop (NetsukukuRadar* self);
void netsukuku_nic_remove_address (NetsukukuNIC* self, const gchar* address);
void netsukuku_network_interface_manager_add_address (NetsukukuNetworkInterfaceManager* self, NetsukukuAddressManager* address_manager);
static void netsukuku_network_interface_manager_real_add_address (NetsukukuNetworkInterfaceManager* self, NetsukukuAddressManager* address_manager);
void netsukuku_network_interface_manager_remove_address (NetsukukuNetworkInterfaceManager* self, NetsukukuAddressManager* address_manager);
static void netsukuku_network_interface_manager_real_remove_address (NetsukukuNetworkInterfaceManager* self, NetsukukuAddressManager* address_manager);
static void netsukuku_network_interface_manager_finalize (GObject* obj);
static void _vala_netsukuku_network_interface_manager_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void _vala_netsukuku_network_interface_manager_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);
GType netsukuku_struct_helper_gluenetworkinterfacemanager_keep_updating_netid_get_type (void) G_GNUC_CONST;
GType netsukuku_glue_network_interface_manager_get_type (void) G_GNUC_CONST;
Netsukukustruct_helper_GlueNetworkInterfaceManager_keep_updating_netid* netsukuku_struct_helper_gluenetworkinterfacemanager_keep_updating_netid_dup (const Netsukukustruct_helper_GlueNetworkInterfaceManager_keep_updating_netid* self);
void netsukuku_struct_helper_gluenetworkinterfacemanager_keep_updating_netid_free (Netsukukustruct_helper_GlueNetworkInterfaceManager_keep_updating_netid* self);
void netsukuku_struct_helper_gluenetworkinterfacemanager_keep_updating_netid_copy (const Netsukukustruct_helper_GlueNetworkInterfaceManager_keep_updating_netid* self, Netsukukustruct_helper_GlueNetworkInterfaceManager_keep_updating_netid* dest);
void netsukuku_struct_helper_gluenetworkinterfacemanager_keep_updating_netid_destroy (Netsukukustruct_helper_GlueNetworkInterfaceManager_keep_updating_netid* self);
#define NETSUKUKU_GLUE_NETWORK_INTERFACE_MANAGER_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), NETSUKUKU_TYPE_GLUE_NETWORK_INTERFACE_MANAGER, NetsukukuGlueNetworkInterfaceManagerPrivate))
enum  {
	NETSUKUKU_GLUE_NETWORK_INTERFACE_MANAGER_DUMMY_PROPERTY
};
NetsukukuGlueNetworkInterfaceManager* netsukuku_glue_network_interface_manager_new (void);
NetsukukuGlueNetworkInterfaceManager* netsukuku_glue_network_interface_manager_construct (GType object_type);
NetsukukuGlueRadar* netsukuku_glue_radar_new (void);
NetsukukuGlueRadar* netsukuku_glue_radar_construct (GType object_type);
GType netsukuku_glue_radar_get_type (void) G_GNUC_CONST;
NetsukukuGlueNeighbourManager* netsukuku_glue_neighbour_manager_new (NetsukukuRadar* radar, NetsukukuGlueNetworkInterfaceManager* gluenic);
NetsukukuGlueNeighbourManager* netsukuku_glue_neighbour_manager_construct (GType object_type, NetsukukuRadar* radar, NetsukukuGlueNetworkInterfaceManager* gluenic);
GType netsukuku_glue_neighbour_manager_get_type (void) G_GNUC_CONST;
void netsukuku_glue_network_interface_manager_keep_updating_netid (NetsukukuGlueNetworkInterfaceManager* self);
static void netsukuku_glue_network_interface_manager_impl_keep_updating_netid (NetsukukuGlueNetworkInterfaceManager* self, GError** error);
NetsukukuNetworkID* netsukuku_address_manager_get_main_netid (NetsukukuAddressManager* self);
gboolean netsukuku_address_manager_get_is_primary (NetsukukuAddressManager* self);
gboolean netsukuku_address_manager_get_is_auxiliary (NetsukukuAddressManager* self);
gint netsukuku_address_manager_get_my_id (NetsukukuAddressManager* self);
NetsukukuNeighbour* netsukuku_neighbour_new_with_local_dispatcher (gint levels, gint gsize, NetsukukuNIP* nip, gint nodeid, NetsukukuNetworkID* netid, gboolean is_primary, gboolean is_auxiliary, zcdRPCDispatcher* rpcdispatcher);
NetsukukuNeighbour* netsukuku_neighbour_construct_with_local_dispatcher (GType object_type, gint levels, gint gsize, NetsukukuNIP* nip, gint nodeid, NetsukukuNetworkID* netid, gboolean is_primary, gboolean is_auxiliary, zcdRPCDispatcher* rpcdispatcher);
GType netsukuku_neighbour_get_type (void) G_GNUC_CONST;
void netsukuku_log_info (const gchar* msg);
static void* netsukuku_glue_network_interface_manager_helper_keep_updating_netid (void* v, GError** error);
static NetsukukuNeighbourManager* netsukuku_glue_network_interface_manager_real_create_neighbour_manager (NetsukukuNetworkInterfaceManager* base, NetsukukuAddressManager* addr_man);
static void netsukuku_glue_network_interface_manager_real_dispose_neighbour_manager (NetsukukuNetworkInterfaceManager* base, NetsukukuAddressManager* addr_man, NetsukukuNeighbourManager* neighbour_manager);
static void netsukuku_glue_network_interface_manager_real_add_address (NetsukukuNetworkInterfaceManager* base, NetsukukuAddressManager* address);
gboolean netsukuku_address_manager_do_i_act_as_gateway_for_local (NetsukukuAddressManager* self);
static void netsukuku_glue_network_interface_manager_real_remove_address (NetsukukuNetworkInterfaceManager* base, NetsukukuAddressManager* address);
GeeList* netsukuku_glue_network_interface_manager_neighbour_list (NetsukukuGlueNetworkInterfaceManager* self);
GeeList* netsukuku_neighbour_manager_neighbour_list (NetsukukuNeighbourManager* self);
GeeArrayList* netsukuku_glue_network_interface_manager_get_addrs (NetsukukuGlueNetworkInterfaceManager* self);
static void netsukuku_glue_network_interface_manager_finalize (GObject* obj);
enum  {
	NETSUKUKU_GLUE_RADAR_DUMMY_PROPERTY
};
NetsukukuRadar* netsukuku_radar_new_fake (void);
NetsukukuRadar* netsukuku_radar_construct_fake (GType object_type);
static void netsukuku_glue_radar_real_time_register (NetsukukuRadar* base, gint radar_id, gint levels, gint gsize, NetsukukuNIP* nip, gint nodeid, NetsukukuNetworkID* netid, const gchar* mac, gboolean is_primary, gboolean is_auxiliary);
#define NETSUKUKU_GLUE_NEIGHBOUR_MANAGER_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), NETSUKUKU_TYPE_GLUE_NEIGHBOUR_MANAGER, NetsukukuGlueNeighbourManagerPrivate))
enum  {
	NETSUKUKU_GLUE_NEIGHBOUR_MANAGER_DUMMY_PROPERTY
};
NetsukukuNeighbourManager* netsukuku_neighbour_manager_new_fake (void);
NetsukukuNeighbourManager* netsukuku_neighbour_manager_construct_fake (GType object_type);
void netsukuku_neighbour_manager_set_radar (NetsukukuNeighbourManager* self, NetsukukuRadar* value);
static void netsukuku_glue_neighbour_manager_real_declare_dead (NetsukukuNeighbourManager* base, NetsukukuNIP* nip, gint nodeid);
static GeeList* netsukuku_glue_neighbour_manager_real_neighbour_list (NetsukukuNeighbourManager* base);
gboolean netsukuku_neighbour_equal_func (NetsukukuNeighbour* a, NetsukukuNeighbour* b);
static gboolean _netsukuku_neighbour_equal_func_gee_equal_data_func (gconstpointer a, gconstpointer b, gpointer self);
static void netsukuku_glue_neighbour_manager_finalize (GObject* obj);


NetsukukuNetworkInterfaceManager* netsukuku_network_interface_manager_construct_fake (GType object_type) {
	NetsukukuNetworkInterfaceManager * self = NULL;
	self = (NetsukukuNetworkInterfaceManager*) g_object_new (object_type, NULL);
	return self;
}


NetsukukuNetworkInterfaceManager* netsukuku_network_interface_manager_new_fake (void) {
	return netsukuku_network_interface_manager_construct_fake (NETSUKUKU_TYPE_NETWORK_INTERFACE_MANAGER);
}


NetsukukuNetworkInterfaceManager* netsukuku_network_interface_manager_construct (GType object_type, const gchar* nic_name, NetsukukuNIC* nic_class, zcdUnicastCallbackDelegate udp_unicast_callback, zcdBroadcastCallbackDelegate udp_broadcast_callback) {
	NetsukukuNetworkInterfaceManager * self = NULL;
	NetsukukuNIC* _tmp0_;
	const gchar* _tmp1_;
	zcdUnicastCallbackDelegate _tmp2_;
	zcdBroadcastCallbackDelegate _tmp3_;
	GeeArrayList* _tmp4_;
	g_return_val_if_fail (nic_name != NULL, NULL);
	g_return_val_if_fail (nic_class != NULL, NULL);
	self = (NetsukukuNetworkInterfaceManager*) g_object_new (object_type, NULL);
	_tmp0_ = nic_class;
	netsukuku_network_interface_manager_set_nic_class (self, _tmp0_);
	_tmp1_ = nic_name;
	netsukuku_network_interface_manager_set_nic_name (self, _tmp1_);
	_tmp2_ = udp_unicast_callback;
	self->priv->udp_unicast_callback = _tmp2_;
	_tmp3_ = udp_broadcast_callback;
	self->priv->udp_broadcast_callback = _tmp3_;
	self->to_be_managed = TRUE;
	self->to_be_copied = TRUE;
	self->initialized = FALSE;
	_tmp4_ = gee_array_list_new (NETSUKUKU_TYPE_ADDRESS_MANAGER, (GBoxedCopyFunc) g_object_ref, g_object_unref, NULL, NULL, NULL);
	_g_object_unref0 (self->addrs);
	self->addrs = _tmp4_;
	_g_object_unref0 (self->priv->udpserver);
	self->priv->udpserver = NULL;
	return self;
}


NetsukukuNetworkInterfaceManager* netsukuku_network_interface_manager_new (const gchar* nic_name, NetsukukuNIC* nic_class, zcdUnicastCallbackDelegate udp_unicast_callback, zcdBroadcastCallbackDelegate udp_broadcast_callback) {
	return netsukuku_network_interface_manager_construct (NETSUKUKU_TYPE_NETWORK_INTERFACE_MANAGER, nic_name, nic_class, udp_unicast_callback, udp_broadcast_callback);
}


void netsukuku_network_interface_manager_initialize (NetsukukuNetworkInterfaceManager* self) {
	gboolean _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->to_be_managed;
	if (_tmp0_) {
		zcdUnicastCallbackDelegate _tmp1_;
		zcdBroadcastCallbackDelegate _tmp2_;
		const gchar* _tmp3_;
		zcdUDPServer* _tmp4_;
		NetsukukuNIC* _tmp5_;
		_tmp1_ = self->priv->udp_unicast_callback;
		_tmp2_ = self->priv->udp_broadcast_callback;
		_tmp3_ = self->priv->_nic_name;
		_tmp4_ = zcd_udp_server_new (_tmp1_, _tmp2_, _tmp3_, NULL, NULL);
		_g_object_unref0 (self->priv->udpserver);
		self->priv->udpserver = _tmp4_;
		_tmp5_ = self->priv->_nic_class;
		netsukuku_nic_disable_filtering (_tmp5_);
	}
	self->initialized = TRUE;
}


static const gchar* string_to_string (const gchar* self) {
	const gchar* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	result = self;
	return result;
}


static NetsukukuNeighbourManager* netsukuku_network_interface_manager_real_create_neighbour_manager (NetsukukuNetworkInterfaceManager* self, NetsukukuAddressManager* addr_man) {
	NetsukukuNeighbourManager* result = NULL;
	NetsukukuAddressManager* _tmp0_;
	NetsukukuMapRoute* _tmp1_;
	gint _tmp2_;
	gint _tmp3_;
	NetsukukuAddressManager* _tmp4_;
	NetsukukuMapRoute* _tmp5_;
	gint _tmp6_;
	gint _tmp7_;
	NetsukukuAddressManager* _tmp8_;
	NetsukukuMapRoute* _tmp9_;
	NetsukukuNIP* _tmp10_;
	NetsukukuNIP* _tmp11_;
	gchar* _tmp12_ = NULL;
	gchar* my_addr;
	NetsukukuNIC* _tmp13_;
	NetsukukuAddressManager* _tmp14_;
	NetsukukuMapRoute* _tmp15_;
	NetsukukuNIP* _tmp16_;
	NetsukukuNIP* _tmp17_;
	gchar* _tmp18_ = NULL;
	gchar* _tmp19_;
	const gchar* _tmp20_;
	const gchar* _tmp21_ = NULL;
	gchar* _tmp22_ = NULL;
	gchar* _tmp23_;
	const gchar* _tmp24_;
	NetsukukuAddressManager* _tmp25_;
	NetsukukuRadar* _tmp26_;
	NetsukukuRadar* radar;
	NetsukukuNeighbourManager* _tmp27_;
	NetsukukuNeighbourManager* neighbour_manager;
	g_return_val_if_fail (addr_man != NULL, NULL);
	_tmp0_ = addr_man;
	_tmp1_ = _tmp0_->maproute;
	_tmp2_ = netsukuku_map_get_levels ((NetsukukuMap*) _tmp1_);
	_tmp3_ = _tmp2_;
	_tmp4_ = addr_man;
	_tmp5_ = _tmp4_->maproute;
	_tmp6_ = netsukuku_map_get_gsize ((NetsukukuMap*) _tmp5_);
	_tmp7_ = _tmp6_;
	_tmp8_ = addr_man;
	_tmp9_ = _tmp8_->maproute;
	_tmp10_ = netsukuku_map_get_me ((NetsukukuMap*) _tmp9_);
	_tmp11_ = _tmp10_;
	_tmp12_ = netsukuku_nip_to_str (_tmp3_, _tmp7_, _tmp11_);
	my_addr = _tmp12_;
	_tmp13_ = self->priv->_nic_class;
	netsukuku_nic_add_address (_tmp13_, my_addr);
	_tmp14_ = addr_man;
	_tmp15_ = _tmp14_->maproute;
	_tmp16_ = netsukuku_map_get_me ((NetsukukuMap*) _tmp15_);
	_tmp17_ = _tmp16_;
	_tmp18_ = netsukuku_partial_nip_to_string ((NetsukukuPartialNIP*) _tmp17_);
	_tmp19_ = _tmp18_;
	_tmp20_ = self->priv->_nic_name;
	_tmp21_ = string_to_string (_tmp20_);
	_tmp22_ = g_strconcat ("With ", _tmp19_, " handle ", _tmp21_, NULL);
	_tmp23_ = _tmp22_;
	netsukuku_log_debug (_tmp23_);
	_g_free0 (_tmp23_);
	_g_free0 (_tmp19_);
	_tmp24_ = self->priv->_nic_name;
	_tmp25_ = addr_man;
	_tmp26_ = netsukuku_radar_new (_tmp24_, _tmp25_);
	radar = _tmp26_;
	_tmp27_ = netsukuku_neighbour_manager_new (radar, -1);
	neighbour_manager = _tmp27_;
	netsukuku_radar_run (radar);
	result = neighbour_manager;
	_g_object_unref0 (radar);
	_g_free0 (my_addr);
	return result;
}


NetsukukuNeighbourManager* netsukuku_network_interface_manager_create_neighbour_manager (NetsukukuNetworkInterfaceManager* self, NetsukukuAddressManager* addr_man) {
	g_return_val_if_fail (self != NULL, NULL);
	return NETSUKUKU_NETWORK_INTERFACE_MANAGER_GET_CLASS (self)->create_neighbour_manager (self, addr_man);
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


static void netsukuku_network_interface_manager_real_dispose_neighbour_manager (NetsukukuNetworkInterfaceManager* self, NetsukukuAddressManager* addr_man, NetsukukuNeighbourManager* neighbour_manager) {
	NetsukukuNeighbourManager* _tmp0_;
	NetsukukuRadar* _tmp1_;
	NetsukukuRadar* _tmp2_;
	NetsukukuRadar* _tmp3_;
	NetsukukuRadar* radar;
	NetsukukuAddressManager* _tmp4_;
	NetsukukuMapRoute* _tmp5_;
	gint _tmp6_;
	gint _tmp7_;
	NetsukukuAddressManager* _tmp8_;
	NetsukukuMapRoute* _tmp9_;
	gint _tmp10_;
	gint _tmp11_;
	NetsukukuAddressManager* _tmp12_;
	NetsukukuMapRoute* _tmp13_;
	NetsukukuNIP* _tmp14_;
	NetsukukuNIP* _tmp15_;
	gchar* _tmp16_ = NULL;
	gchar* my_addr;
	NetsukukuNIC* _tmp17_;
	g_return_if_fail (addr_man != NULL);
	g_return_if_fail (neighbour_manager != NULL);
	_tmp0_ = neighbour_manager;
	_tmp1_ = netsukuku_neighbour_manager_get_radar (_tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = _g_object_ref0 (_tmp2_);
	radar = _tmp3_;
	netsukuku_radar_stop (radar);
	tasklets_tasklet_nap ((glong) 1, (glong) 0);
	_tmp4_ = addr_man;
	_tmp5_ = _tmp4_->maproute;
	_tmp6_ = netsukuku_map_get_levels ((NetsukukuMap*) _tmp5_);
	_tmp7_ = _tmp6_;
	_tmp8_ = addr_man;
	_tmp9_ = _tmp8_->maproute;
	_tmp10_ = netsukuku_map_get_gsize ((NetsukukuMap*) _tmp9_);
	_tmp11_ = _tmp10_;
	_tmp12_ = addr_man;
	_tmp13_ = _tmp12_->maproute;
	_tmp14_ = netsukuku_map_get_me ((NetsukukuMap*) _tmp13_);
	_tmp15_ = _tmp14_;
	_tmp16_ = netsukuku_nip_to_str (_tmp7_, _tmp11_, _tmp15_);
	my_addr = _tmp16_;
	_tmp17_ = self->priv->_nic_class;
	netsukuku_nic_remove_address (_tmp17_, my_addr);
	_g_free0 (my_addr);
	_g_object_unref0 (radar);
}


void netsukuku_network_interface_manager_dispose_neighbour_manager (NetsukukuNetworkInterfaceManager* self, NetsukukuAddressManager* addr_man, NetsukukuNeighbourManager* neighbour_manager) {
	g_return_if_fail (self != NULL);
	NETSUKUKU_NETWORK_INTERFACE_MANAGER_GET_CLASS (self)->dispose_neighbour_manager (self, addr_man, neighbour_manager);
}


static void netsukuku_network_interface_manager_real_add_address (NetsukukuNetworkInterfaceManager* self, NetsukukuAddressManager* address_manager) {
	gboolean _tmp0_;
	GeeArrayList* _tmp1_;
	NetsukukuAddressManager* _tmp2_;
	gboolean _tmp3_;
	g_return_if_fail (address_manager != NULL);
	_tmp0_ = self->initialized;
	if (!_tmp0_) {
		netsukuku_network_interface_manager_initialize (self);
	}
	_tmp1_ = self->addrs;
	_tmp2_ = address_manager;
	gee_abstract_collection_add ((GeeAbstractCollection*) _tmp1_, _tmp2_);
	_tmp3_ = self->to_be_managed;
	if (_tmp3_) {
		zcdUDPServer* _tmp4_;
		gboolean _tmp5_ = FALSE;
		_tmp4_ = self->priv->udpserver;
		_tmp5_ = zcd_udp_server_is_listening (_tmp4_);
		if (!_tmp5_) {
			zcdUDPServer* _tmp6_;
			_tmp6_ = self->priv->udpserver;
			zcd_udp_server_listen (_tmp6_);
		}
	}
}


void netsukuku_network_interface_manager_add_address (NetsukukuNetworkInterfaceManager* self, NetsukukuAddressManager* address_manager) {
	g_return_if_fail (self != NULL);
	NETSUKUKU_NETWORK_INTERFACE_MANAGER_GET_CLASS (self)->add_address (self, address_manager);
}


static void netsukuku_network_interface_manager_real_remove_address (NetsukukuNetworkInterfaceManager* self, NetsukukuAddressManager* address_manager) {
	GeeArrayList* _tmp0_;
	NetsukukuAddressManager* _tmp1_;
	gboolean _tmp2_;
	g_return_if_fail (address_manager != NULL);
	_tmp0_ = self->addrs;
	_tmp1_ = address_manager;
	gee_abstract_collection_remove ((GeeAbstractCollection*) _tmp0_, _tmp1_);
	_tmp2_ = self->to_be_managed;
	if (_tmp2_) {
		gboolean _tmp3_ = FALSE;
		zcdUDPServer* _tmp4_;
		gboolean _tmp5_ = FALSE;
		gboolean _tmp9_;
		_tmp4_ = self->priv->udpserver;
		_tmp5_ = zcd_udp_server_is_listening (_tmp4_);
		if (_tmp5_) {
			GeeArrayList* _tmp6_;
			gboolean _tmp7_;
			gboolean _tmp8_;
			_tmp6_ = self->addrs;
			_tmp7_ = gee_collection_get_is_empty ((GeeCollection*) _tmp6_);
			_tmp8_ = _tmp7_;
			_tmp3_ = _tmp8_;
		} else {
			_tmp3_ = FALSE;
		}
		_tmp9_ = _tmp3_;
		if (_tmp9_) {
			zcdUDPServer* _tmp10_;
			_tmp10_ = self->priv->udpserver;
			zcd_udp_server_stop (_tmp10_);
		}
	}
}


void netsukuku_network_interface_manager_remove_address (NetsukukuNetworkInterfaceManager* self, NetsukukuAddressManager* address_manager) {
	g_return_if_fail (self != NULL);
	NETSUKUKU_NETWORK_INTERFACE_MANAGER_GET_CLASS (self)->remove_address (self, address_manager);
}


NetsukukuNIC* netsukuku_network_interface_manager_get_nic_class (NetsukukuNetworkInterfaceManager* self) {
	NetsukukuNIC* result;
	NetsukukuNIC* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_nic_class;
	result = _tmp0_;
	return result;
}


void netsukuku_network_interface_manager_set_nic_class (NetsukukuNetworkInterfaceManager* self, NetsukukuNIC* value) {
	NetsukukuNIC* _tmp0_;
	NetsukukuNIC* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	_tmp1_ = _g_object_ref0 (_tmp0_);
	_g_object_unref0 (self->priv->_nic_class);
	self->priv->_nic_class = _tmp1_;
	g_object_notify ((GObject *) self, "nic-class");
}


const gchar* netsukuku_network_interface_manager_get_nic_name (NetsukukuNetworkInterfaceManager* self) {
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_nic_name;
	result = _tmp0_;
	return result;
}


void netsukuku_network_interface_manager_set_nic_name (NetsukukuNetworkInterfaceManager* self, const gchar* value) {
	const gchar* _tmp0_;
	gchar* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	_tmp1_ = g_strdup (_tmp0_);
	_g_free0 (self->priv->_nic_name);
	self->priv->_nic_name = _tmp1_;
	g_object_notify ((GObject *) self, "nic-name");
}


static void netsukuku_network_interface_manager_class_init (NetsukukuNetworkInterfaceManagerClass * klass) {
	netsukuku_network_interface_manager_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (NetsukukuNetworkInterfaceManagerPrivate));
	NETSUKUKU_NETWORK_INTERFACE_MANAGER_CLASS (klass)->create_neighbour_manager = netsukuku_network_interface_manager_real_create_neighbour_manager;
	NETSUKUKU_NETWORK_INTERFACE_MANAGER_CLASS (klass)->dispose_neighbour_manager = netsukuku_network_interface_manager_real_dispose_neighbour_manager;
	NETSUKUKU_NETWORK_INTERFACE_MANAGER_CLASS (klass)->add_address = netsukuku_network_interface_manager_real_add_address;
	NETSUKUKU_NETWORK_INTERFACE_MANAGER_CLASS (klass)->remove_address = netsukuku_network_interface_manager_real_remove_address;
	G_OBJECT_CLASS (klass)->get_property = _vala_netsukuku_network_interface_manager_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_netsukuku_network_interface_manager_set_property;
	G_OBJECT_CLASS (klass)->finalize = netsukuku_network_interface_manager_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), NETSUKUKU_NETWORK_INTERFACE_MANAGER_NIC_CLASS, g_param_spec_object ("nic-class", "nic-class", "nic-class", NETSUKUKU_TYPE_NIC, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), NETSUKUKU_NETWORK_INTERFACE_MANAGER_NIC_NAME, g_param_spec_string ("nic-name", "nic-name", "nic-name", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
}


static void netsukuku_network_interface_manager_instance_init (NetsukukuNetworkInterfaceManager * self) {
	self->priv = NETSUKUKU_NETWORK_INTERFACE_MANAGER_GET_PRIVATE (self);
}


static void netsukuku_network_interface_manager_finalize (GObject* obj) {
	NetsukukuNetworkInterfaceManager * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, NETSUKUKU_TYPE_NETWORK_INTERFACE_MANAGER, NetsukukuNetworkInterfaceManager);
	_g_object_unref0 (self->priv->_nic_class);
	_g_free0 (self->priv->_nic_name);
	_g_object_unref0 (self->addrs);
	_g_object_unref0 (self->priv->udpserver);
	G_OBJECT_CLASS (netsukuku_network_interface_manager_parent_class)->finalize (obj);
}


/** 
      */
GType netsukuku_network_interface_manager_get_type (void) {
	static volatile gsize netsukuku_network_interface_manager_type_id__volatile = 0;
	if (g_once_init_enter (&netsukuku_network_interface_manager_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (NetsukukuNetworkInterfaceManagerClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) netsukuku_network_interface_manager_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (NetsukukuNetworkInterfaceManager), 0, (GInstanceInitFunc) netsukuku_network_interface_manager_instance_init, NULL };
		GType netsukuku_network_interface_manager_type_id;
		netsukuku_network_interface_manager_type_id = g_type_register_static (G_TYPE_OBJECT, "NetsukukuNetworkInterfaceManager", &g_define_type_info, 0);
		g_once_init_leave (&netsukuku_network_interface_manager_type_id__volatile, netsukuku_network_interface_manager_type_id);
	}
	return netsukuku_network_interface_manager_type_id__volatile;
}


static void _vala_netsukuku_network_interface_manager_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	NetsukukuNetworkInterfaceManager * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, NETSUKUKU_TYPE_NETWORK_INTERFACE_MANAGER, NetsukukuNetworkInterfaceManager);
	switch (property_id) {
		case NETSUKUKU_NETWORK_INTERFACE_MANAGER_NIC_CLASS:
		g_value_set_object (value, netsukuku_network_interface_manager_get_nic_class (self));
		break;
		case NETSUKUKU_NETWORK_INTERFACE_MANAGER_NIC_NAME:
		g_value_set_string (value, netsukuku_network_interface_manager_get_nic_name (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _vala_netsukuku_network_interface_manager_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	NetsukukuNetworkInterfaceManager * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, NETSUKUKU_TYPE_NETWORK_INTERFACE_MANAGER, NetsukukuNetworkInterfaceManager);
	switch (property_id) {
		case NETSUKUKU_NETWORK_INTERFACE_MANAGER_NIC_CLASS:
		netsukuku_network_interface_manager_set_nic_class (self, g_value_get_object (value));
		break;
		case NETSUKUKU_NETWORK_INTERFACE_MANAGER_NIC_NAME:
		netsukuku_network_interface_manager_set_nic_name (self, g_value_get_string (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


void netsukuku_struct_helper_gluenetworkinterfacemanager_keep_updating_netid_copy (const Netsukukustruct_helper_GlueNetworkInterfaceManager_keep_updating_netid* self, Netsukukustruct_helper_GlueNetworkInterfaceManager_keep_updating_netid* dest) {
	NetsukukuGlueNetworkInterfaceManager* _tmp0_;
	NetsukukuGlueNetworkInterfaceManager* _tmp1_;
	_tmp0_ = (*self).self;
	_tmp1_ = _g_object_ref0 (_tmp0_);
	_g_object_unref0 ((*dest).self);
	(*dest).self = _tmp1_;
}


void netsukuku_struct_helper_gluenetworkinterfacemanager_keep_updating_netid_destroy (Netsukukustruct_helper_GlueNetworkInterfaceManager_keep_updating_netid* self) {
	_g_object_unref0 ((*self).self);
}


Netsukukustruct_helper_GlueNetworkInterfaceManager_keep_updating_netid* netsukuku_struct_helper_gluenetworkinterfacemanager_keep_updating_netid_dup (const Netsukukustruct_helper_GlueNetworkInterfaceManager_keep_updating_netid* self) {
	Netsukukustruct_helper_GlueNetworkInterfaceManager_keep_updating_netid* dup;
	dup = g_new0 (Netsukukustruct_helper_GlueNetworkInterfaceManager_keep_updating_netid, 1);
	netsukuku_struct_helper_gluenetworkinterfacemanager_keep_updating_netid_copy (self, dup);
	return dup;
}


void netsukuku_struct_helper_gluenetworkinterfacemanager_keep_updating_netid_free (Netsukukustruct_helper_GlueNetworkInterfaceManager_keep_updating_netid* self) {
	netsukuku_struct_helper_gluenetworkinterfacemanager_keep_updating_netid_destroy (self);
	g_free (self);
}


GType netsukuku_struct_helper_gluenetworkinterfacemanager_keep_updating_netid_get_type (void) {
	static volatile gsize netsukuku_struct_helper_gluenetworkinterfacemanager_keep_updating_netid_type_id__volatile = 0;
	if (g_once_init_enter (&netsukuku_struct_helper_gluenetworkinterfacemanager_keep_updating_netid_type_id__volatile)) {
		GType netsukuku_struct_helper_gluenetworkinterfacemanager_keep_updating_netid_type_id;
		netsukuku_struct_helper_gluenetworkinterfacemanager_keep_updating_netid_type_id = g_boxed_type_register_static ("Netsukukustruct_helper_GlueNetworkInterfaceManager_keep_updating_netid", (GBoxedCopyFunc) netsukuku_struct_helper_gluenetworkinterfacemanager_keep_updating_netid_dup, (GBoxedFreeFunc) netsukuku_struct_helper_gluenetworkinterfacemanager_keep_updating_netid_free);
		g_once_init_leave (&netsukuku_struct_helper_gluenetworkinterfacemanager_keep_updating_netid_type_id__volatile, netsukuku_struct_helper_gluenetworkinterfacemanager_keep_updating_netid_type_id);
	}
	return netsukuku_struct_helper_gluenetworkinterfacemanager_keep_updating_netid_type_id__volatile;
}


NetsukukuGlueNetworkInterfaceManager* netsukuku_glue_network_interface_manager_construct (GType object_type) {
	NetsukukuGlueNetworkInterfaceManager * self = NULL;
	NetsukukuGlueRadar* _tmp0_;
	NetsukukuRadar* radar;
	NetsukukuGlueNeighbourManager* _tmp1_;
	GeeArrayList* _tmp2_;
	self = (NetsukukuGlueNetworkInterfaceManager*) netsukuku_network_interface_manager_construct_fake (object_type);
	_tmp0_ = netsukuku_glue_radar_new ();
	radar = (NetsukukuRadar*) _tmp0_;
	_tmp1_ = netsukuku_glue_neighbour_manager_new (radar, self);
	_g_object_unref0 (self->priv->neighbour_manager);
	self->priv->neighbour_manager = (NetsukukuNeighbourManager*) _tmp1_;
	netsukuku_network_interface_manager_set_nic_name ((NetsukukuNetworkInterfaceManager*) self, "glue_nic");
	((NetsukukuNetworkInterfaceManager*) self)->to_be_managed = FALSE;
	((NetsukukuNetworkInterfaceManager*) self)->to_be_copied = TRUE;
	((NetsukukuNetworkInterfaceManager*) self)->initialized = FALSE;
	_tmp2_ = gee_array_list_new (NETSUKUKU_TYPE_ADDRESS_MANAGER, (GBoxedCopyFunc) g_object_ref, g_object_unref, NULL, NULL, NULL);
	_g_object_unref0 (((NetsukukuNetworkInterfaceManager*) self)->addrs);
	((NetsukukuNetworkInterfaceManager*) self)->addrs = _tmp2_;
	netsukuku_glue_network_interface_manager_keep_updating_netid (self);
	_g_object_unref0 (radar);
	return self;
}


NetsukukuGlueNetworkInterfaceManager* netsukuku_glue_network_interface_manager_new (void) {
	return netsukuku_glue_network_interface_manager_construct (NETSUKUKU_TYPE_GLUE_NETWORK_INTERFACE_MANAGER);
}


static void netsukuku_glue_network_interface_manager_impl_keep_updating_netid (NetsukukuGlueNetworkInterfaceManager* self, GError** error) {
	GeeHashMap* _tmp0_;
	GeeHashMap* addr_netid;
	GeeHashMap* _tmp1_;
	GeeHashMap* addr_primary;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	tasklets_tasklet_declare_self ("GlueNICManager.keep_updating_netid");
	_tmp0_ = gee_hash_map_new (NETSUKUKU_TYPE_ADDRESS_MANAGER, (GBoxedCopyFunc) g_object_ref, g_object_unref, NETSUKUKU_TYPE_NETWORK_ID, (GBoxedCopyFunc) g_object_ref, g_object_unref, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
	addr_netid = _tmp0_;
	_tmp1_ = gee_hash_map_new (NETSUKUKU_TYPE_ADDRESS_MANAGER, (GBoxedCopyFunc) g_object_ref, g_object_unref, G_TYPE_BOOLEAN, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
	addr_primary = _tmp1_;
	while (TRUE) {
		{
			GeeHashMap* _tmp2_;
			GeeHashMap* new_addr_netid;
			GeeHashMap* _tmp3_;
			GeeHashMap* new_addr_primary;
			GeeHashMap* _tmp76_;
			GeeHashMap* _tmp77_;
			GeeHashMap* _tmp78_;
			GeeHashMap* _tmp79_;
			tasklets_ms_wait ((gint64) 3000);
			_tmp2_ = gee_hash_map_new (NETSUKUKU_TYPE_ADDRESS_MANAGER, (GBoxedCopyFunc) g_object_ref, g_object_unref, NETSUKUKU_TYPE_NETWORK_ID, (GBoxedCopyFunc) g_object_ref, g_object_unref, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
			new_addr_netid = _tmp2_;
			_tmp3_ = gee_hash_map_new (NETSUKUKU_TYPE_ADDRESS_MANAGER, (GBoxedCopyFunc) g_object_ref, g_object_unref, G_TYPE_BOOLEAN, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
			new_addr_primary = _tmp3_;
			{
				GeeArrayList* _tmp4_;
				GeeArrayList* _tmp5_;
				GeeArrayList* _address_list;
				GeeArrayList* _tmp6_;
				gint _tmp7_;
				gint _tmp8_;
				gint _address_size;
				gint _address_index;
				_tmp4_ = ((NetsukukuNetworkInterfaceManager*) self)->addrs;
				_tmp5_ = _g_object_ref0 (_tmp4_);
				_address_list = _tmp5_;
				_tmp6_ = _address_list;
				_tmp7_ = gee_abstract_collection_get_size ((GeeCollection*) _tmp6_);
				_tmp8_ = _tmp7_;
				_address_size = _tmp8_;
				_address_index = -1;
				while (TRUE) {
					gint _tmp9_;
					gint _tmp10_;
					gint _tmp11_;
					GeeArrayList* _tmp12_;
					gint _tmp13_;
					gpointer _tmp14_ = NULL;
					NetsukukuAddressManager* address;
					NetsukukuAddressManager* _tmp15_;
					NetsukukuNetworkID* _tmp16_ = NULL;
					NetsukukuNetworkID* netid;
					NetsukukuAddressManager* _tmp17_;
					gboolean _tmp18_;
					gboolean _tmp19_;
					gboolean is_primary;
					GeeHashMap* _tmp20_;
					NetsukukuAddressManager* _tmp21_;
					NetsukukuNetworkID* _tmp22_;
					GeeHashMap* _tmp23_;
					NetsukukuAddressManager* _tmp24_;
					gboolean _tmp25_;
					GeeHashMap* _tmp26_;
					NetsukukuAddressManager* _tmp27_;
					gboolean _tmp28_ = FALSE;
					_tmp9_ = _address_index;
					_address_index = _tmp9_ + 1;
					_tmp10_ = _address_index;
					_tmp11_ = _address_size;
					if (!(_tmp10_ < _tmp11_)) {
						break;
					}
					_tmp12_ = _address_list;
					_tmp13_ = _address_index;
					_tmp14_ = gee_abstract_list_get ((GeeAbstractList*) _tmp12_, _tmp13_);
					address = (NetsukukuAddressManager*) _tmp14_;
					_tmp15_ = address;
					_tmp16_ = netsukuku_address_manager_get_main_netid (_tmp15_);
					netid = _tmp16_;
					_tmp17_ = address;
					_tmp18_ = netsukuku_address_manager_get_is_primary (_tmp17_);
					_tmp19_ = _tmp18_;
					is_primary = _tmp19_;
					_tmp20_ = new_addr_netid;
					_tmp21_ = address;
					_tmp22_ = netid;
					gee_abstract_map_set ((GeeAbstractMap*) _tmp20_, _tmp21_, _tmp22_);
					_tmp23_ = new_addr_primary;
					_tmp24_ = address;
					_tmp25_ = is_primary;
					gee_abstract_map_set ((GeeAbstractMap*) _tmp23_, _tmp24_, (gpointer) ((gintptr) _tmp25_));
					_tmp26_ = addr_netid;
					_tmp27_ = address;
					_tmp28_ = gee_abstract_map_has_key ((GeeAbstractMap*) _tmp26_, _tmp27_);
					if (_tmp28_) {
						GeeHashMap* _tmp29_;
						NetsukukuAddressManager* _tmp30_;
						gpointer _tmp31_ = NULL;
						NetsukukuNetworkID* old_netid;
						GeeHashMap* _tmp32_;
						NetsukukuAddressManager* _tmp33_;
						gpointer _tmp34_ = NULL;
						gboolean old_is_primary;
						gboolean _tmp35_ = FALSE;
						NetsukukuNetworkID* _tmp36_;
						NetsukukuNetworkID* _tmp37_;
						gboolean _tmp38_ = FALSE;
						gboolean _tmp41_;
						_tmp29_ = addr_netid;
						_tmp30_ = address;
						_tmp31_ = gee_abstract_map_get ((GeeAbstractMap*) _tmp29_, _tmp30_);
						old_netid = (NetsukukuNetworkID*) _tmp31_;
						_tmp32_ = addr_primary;
						_tmp33_ = address;
						_tmp34_ = gee_abstract_map_get ((GeeAbstractMap*) _tmp32_, _tmp33_);
						old_is_primary = (gboolean) ((gintptr) _tmp34_);
						_tmp36_ = old_netid;
						_tmp37_ = netid;
						_tmp38_ = netsukuku_network_id_is_same_network (_tmp36_, _tmp37_);
						if (!_tmp38_) {
							_tmp35_ = TRUE;
						} else {
							gboolean _tmp39_;
							gboolean _tmp40_;
							_tmp39_ = old_is_primary;
							_tmp40_ = is_primary;
							_tmp35_ = _tmp39_ != _tmp40_;
						}
						_tmp41_ = _tmp35_;
						if (_tmp41_) {
							NetsukukuAddressManager* _tmp42_;
							gboolean _tmp43_;
							gboolean _tmp44_;
							gboolean is_auxiliary;
							NetsukukuAddressManager* _tmp45_;
							gint _tmp46_ = 0;
							gint nodeid;
							NetsukukuAddressManager* _tmp47_;
							NetsukukuMapRoute* _tmp48_;
							NetsukukuNIP* _tmp49_;
							NetsukukuNIP* _tmp50_;
							NetsukukuNIP* _tmp51_;
							NetsukukuNIP* nip;
							NetsukukuAddressManager* _tmp52_;
							NetsukukuMapRoute* _tmp53_;
							gint _tmp54_;
							gint _tmp55_;
							gint levels;
							NetsukukuAddressManager* _tmp56_;
							NetsukukuMapRoute* _tmp57_;
							gint _tmp58_;
							gint _tmp59_;
							gint gsize;
							gint _tmp60_;
							gint _tmp61_;
							NetsukukuNIP* _tmp62_;
							gint _tmp63_;
							NetsukukuNetworkID* _tmp64_;
							gboolean _tmp65_;
							gboolean _tmp66_;
							NetsukukuAddressManager* _tmp67_;
							NetsukukuAddressManagerDispatcher* _tmp68_;
							NetsukukuAddressManagerDispatcher* _tmp69_;
							NetsukukuNeighbour* _tmp70_;
							NetsukukuNeighbour* _tmp71_;
							NetsukukuNeighbour* neighbour;
							NetsukukuNeighbourManager* _tmp72_;
							NetsukukuNeighbour* _tmp73_;
							NetsukukuNullREM* _tmp74_;
							NetsukukuNullREM* _tmp75_;
							_tmp42_ = address;
							_tmp43_ = netsukuku_address_manager_get_is_auxiliary (_tmp42_);
							_tmp44_ = _tmp43_;
							is_auxiliary = _tmp44_;
							_tmp45_ = address;
							_tmp46_ = netsukuku_address_manager_get_my_id (_tmp45_);
							nodeid = _tmp46_;
							_tmp47_ = address;
							_tmp48_ = _tmp47_->maproute;
							_tmp49_ = netsukuku_map_get_me ((NetsukukuMap*) _tmp48_);
							_tmp50_ = _tmp49_;
							_tmp51_ = _g_object_ref0 (_tmp50_);
							nip = _tmp51_;
							_tmp52_ = address;
							_tmp53_ = _tmp52_->maproute;
							_tmp54_ = netsukuku_map_get_levels ((NetsukukuMap*) _tmp53_);
							_tmp55_ = _tmp54_;
							levels = _tmp55_;
							_tmp56_ = address;
							_tmp57_ = _tmp56_->maproute;
							_tmp58_ = netsukuku_map_get_gsize ((NetsukukuMap*) _tmp57_);
							_tmp59_ = _tmp58_;
							gsize = _tmp59_;
							_tmp60_ = levels;
							_tmp61_ = gsize;
							_tmp62_ = nip;
							_tmp63_ = nodeid;
							_tmp64_ = netid;
							_tmp65_ = is_primary;
							_tmp66_ = is_auxiliary;
							_tmp67_ = address;
							_tmp68_ = netsukuku_address_manager_dispatcher_new ((NetsukukuIAddressManagerRootDispatcher*) _tmp67_);
							_tmp69_ = _tmp68_;
							_tmp70_ = netsukuku_neighbour_new_with_local_dispatcher (_tmp60_, _tmp61_, _tmp62_, _tmp63_, _tmp64_, _tmp65_, _tmp66_, (zcdRPCDispatcher*) _tmp69_);
							_tmp71_ = _tmp70_;
							_g_object_unref0 (_tmp69_);
							neighbour = _tmp71_;
							_tmp72_ = self->priv->neighbour_manager;
							_tmp73_ = neighbour;
							_tmp74_ = netsukuku_null_rem_new ();
							_tmp75_ = _tmp74_;
							g_signal_emit_by_name (_tmp72_, "neighbour-rem-chged", _tmp73_, (NetsukukuREM*) _tmp75_);
							_g_object_unref0 (_tmp75_);
							_g_object_unref0 (neighbour);
							_g_object_unref0 (nip);
						}
						_g_object_unref0 (old_netid);
					}
					_g_object_unref0 (netid);
					_g_object_unref0 (address);
				}
				_g_object_unref0 (_address_list);
			}
			_tmp76_ = new_addr_netid;
			_tmp77_ = _g_object_ref0 (_tmp76_);
			_g_object_unref0 (addr_netid);
			addr_netid = _tmp77_;
			_tmp78_ = new_addr_primary;
			_tmp79_ = _g_object_ref0 (_tmp78_);
			_g_object_unref0 (addr_primary);
			addr_primary = _tmp79_;
			_g_object_unref0 (new_addr_primary);
			_g_object_unref0 (new_addr_netid);
		}
		goto __finally60;
		__catch60_g_error:
		{
			GError* e = NULL;
			GError* _tmp80_;
			GQuark _tmp81_;
			const gchar* _tmp82_ = NULL;
			const gchar* _tmp83_ = NULL;
			GError* _tmp84_;
			gint _tmp85_;
			gchar* _tmp86_ = NULL;
			gchar* _tmp87_;
			GError* _tmp88_;
			const gchar* _tmp89_;
			const gchar* _tmp90_ = NULL;
			gchar* _tmp91_ = NULL;
			gchar* _tmp92_;
			e = _inner_error_;
			_inner_error_ = NULL;
			_tmp80_ = e;
			_tmp81_ = _tmp80_->domain;
			_tmp82_ = g_quark_to_string (_tmp81_);
			_tmp83_ = string_to_string (_tmp82_);
			_tmp84_ = e;
			_tmp85_ = _tmp84_->code;
			_tmp86_ = g_strdup_printf ("%i", _tmp85_);
			_tmp87_ = _tmp86_;
			_tmp88_ = e;
			_tmp89_ = _tmp88_->message;
			_tmp90_ = string_to_string (_tmp89_);
			_tmp91_ = g_strconcat ("GlueNetworkInterfaceManager.keep_updating_netid: Got following excepti" \
"on: ", _tmp83_, " ", _tmp87_, " ", _tmp90_, ", but proceeding anyway", NULL);
			_tmp92_ = _tmp91_;
			netsukuku_log_info (_tmp92_);
			_g_free0 (_tmp92_);
			_g_free0 (_tmp87_);
			_g_error_free0 (e);
		}
		__finally60:
		if (_inner_error_ != NULL) {
			g_propagate_error (error, _inner_error_);
			_g_object_unref0 (addr_primary);
			_g_object_unref0 (addr_netid);
			return;
		}
	}
	_g_object_unref0 (addr_primary);
	_g_object_unref0 (addr_netid);
}


static void* netsukuku_glue_network_interface_manager_helper_keep_updating_netid (void* v, GError** error) {
	void* result = NULL;
	void* _tmp0_;
	Netsukukustruct_helper_GlueNetworkInterfaceManager_keep_updating_netid* tuple_p;
	NetsukukuGlueNetworkInterfaceManager* _tmp1_;
	NetsukukuGlueNetworkInterfaceManager* _tmp2_;
	NetsukukuGlueNetworkInterfaceManager* self_save;
	GError * _inner_error_ = NULL;
	_tmp0_ = v;
	tuple_p = (Netsukukustruct_helper_GlueNetworkInterfaceManager_keep_updating_netid*) _tmp0_;
	_tmp1_ = (*tuple_p).self;
	_tmp2_ = _g_object_ref0 (_tmp1_);
	self_save = _tmp2_;
	tasklets_tasklet_schedule_back ();
	netsukuku_glue_network_interface_manager_impl_keep_updating_netid (self_save, &_inner_error_);
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		_g_object_unref0 (self_save);
		return NULL;
	}
	result = NULL;
	_g_object_unref0 (self_save);
	return result;
}


void netsukuku_glue_network_interface_manager_keep_updating_netid (NetsukukuGlueNetworkInterfaceManager* self) {
	Netsukukustruct_helper_GlueNetworkInterfaceManager_keep_updating_netid arg = {0};
	NetsukukuGlueNetworkInterfaceManager* _tmp0_;
	TaskletsTasklet* _tmp1_ = NULL;
	TaskletsTasklet* _tmp2_;
	g_return_if_fail (self != NULL);
	memset (&arg, 0, sizeof (Netsukukustruct_helper_GlueNetworkInterfaceManager_keep_updating_netid));
	_tmp0_ = _g_object_ref0 (self);
	_g_object_unref0 (arg.self);
	arg.self = _tmp0_;
	_tmp1_ = tasklets_tasklet_spawn ((TaskletsSpawnable) netsukuku_glue_network_interface_manager_helper_keep_updating_netid, &arg, FALSE, -1);
	_tmp2_ = _tmp1_;
	_g_object_unref0 (_tmp2_);
	netsukuku_struct_helper_gluenetworkinterfacemanager_keep_updating_netid_destroy (&arg);
}


static NetsukukuNeighbourManager* netsukuku_glue_network_interface_manager_real_create_neighbour_manager (NetsukukuNetworkInterfaceManager* base, NetsukukuAddressManager* addr_man) {
	NetsukukuGlueNetworkInterfaceManager * self;
	NetsukukuNeighbourManager* result = NULL;
	NetsukukuNeighbourManager* _tmp0_;
	NetsukukuNeighbourManager* _tmp1_;
	self = (NetsukukuGlueNetworkInterfaceManager*) base;
	g_return_val_if_fail (addr_man != NULL, NULL);
	_tmp0_ = self->priv->neighbour_manager;
	_tmp1_ = _g_object_ref0 (_tmp0_);
	result = _tmp1_;
	return result;
}


static void netsukuku_glue_network_interface_manager_real_dispose_neighbour_manager (NetsukukuNetworkInterfaceManager* base, NetsukukuAddressManager* addr_man, NetsukukuNeighbourManager* neighbour_manager) {
	NetsukukuGlueNetworkInterfaceManager * self;
	self = (NetsukukuGlueNetworkInterfaceManager*) base;
	g_return_if_fail (addr_man != NULL);
	g_return_if_fail (neighbour_manager != NULL);
}


static void netsukuku_glue_network_interface_manager_real_add_address (NetsukukuNetworkInterfaceManager* base, NetsukukuAddressManager* address) {
	NetsukukuGlueNetworkInterfaceManager * self;
	NetsukukuAddressManager* _tmp0_;
	gboolean _tmp1_ = FALSE;
	self = (NetsukukuGlueNetworkInterfaceManager*) base;
	g_return_if_fail (address != NULL);
	_tmp0_ = address;
	_tmp1_ = netsukuku_address_manager_do_i_act_as_gateway_for_local (_tmp0_);
	if (_tmp1_) {
		NetsukukuAddressManager* _tmp2_;
		NetsukukuAddressManager* _tmp3_;
		gboolean _tmp4_;
		gboolean _tmp5_;
		gboolean is_primary;
		NetsukukuAddressManager* _tmp6_;
		gboolean _tmp7_;
		gboolean _tmp8_;
		gboolean is_auxiliary;
		NetsukukuAddressManager* _tmp9_;
		NetsukukuNetworkID* _tmp10_ = NULL;
		NetsukukuNetworkID* netid;
		NetsukukuAddressManager* _tmp11_;
		gint _tmp12_ = 0;
		gint nodeid;
		NetsukukuAddressManager* _tmp13_;
		NetsukukuMapRoute* _tmp14_;
		NetsukukuNIP* _tmp15_;
		NetsukukuNIP* _tmp16_;
		NetsukukuNIP* _tmp17_;
		NetsukukuNIP* nip;
		NetsukukuAddressManager* _tmp18_;
		NetsukukuMapRoute* _tmp19_;
		gint _tmp20_;
		gint _tmp21_;
		gint levels;
		NetsukukuAddressManager* _tmp22_;
		NetsukukuMapRoute* _tmp23_;
		gint _tmp24_;
		gint _tmp25_;
		gint gsize;
		gint _tmp26_;
		gint _tmp27_;
		NetsukukuNIP* _tmp28_;
		gint _tmp29_;
		NetsukukuNetworkID* _tmp30_;
		gboolean _tmp31_;
		gboolean _tmp32_;
		NetsukukuAddressManager* _tmp33_;
		NetsukukuAddressManagerDispatcher* _tmp34_;
		NetsukukuAddressManagerDispatcher* _tmp35_;
		NetsukukuNeighbour* _tmp36_;
		NetsukukuNeighbour* _tmp37_;
		NetsukukuNeighbour* neighbour;
		NetsukukuNeighbourManager* _tmp38_;
		NetsukukuNeighbour* _tmp39_;
		_tmp2_ = address;
		NETSUKUKU_NETWORK_INTERFACE_MANAGER_CLASS (netsukuku_glue_network_interface_manager_parent_class)->add_address (G_TYPE_CHECK_INSTANCE_CAST (self, NETSUKUKU_TYPE_NETWORK_INTERFACE_MANAGER, NetsukukuNetworkInterfaceManager), _tmp2_);
		_tmp3_ = address;
		_tmp4_ = netsukuku_address_manager_get_is_primary (_tmp3_);
		_tmp5_ = _tmp4_;
		is_primary = _tmp5_;
		_tmp6_ = address;
		_tmp7_ = netsukuku_address_manager_get_is_auxiliary (_tmp6_);
		_tmp8_ = _tmp7_;
		is_auxiliary = _tmp8_;
		_tmp9_ = address;
		_tmp10_ = netsukuku_address_manager_get_main_netid (_tmp9_);
		netid = _tmp10_;
		_tmp11_ = address;
		_tmp12_ = netsukuku_address_manager_get_my_id (_tmp11_);
		nodeid = _tmp12_;
		_tmp13_ = address;
		_tmp14_ = _tmp13_->maproute;
		_tmp15_ = netsukuku_map_get_me ((NetsukukuMap*) _tmp14_);
		_tmp16_ = _tmp15_;
		_tmp17_ = _g_object_ref0 (_tmp16_);
		nip = _tmp17_;
		_tmp18_ = address;
		_tmp19_ = _tmp18_->maproute;
		_tmp20_ = netsukuku_map_get_levels ((NetsukukuMap*) _tmp19_);
		_tmp21_ = _tmp20_;
		levels = _tmp21_;
		_tmp22_ = address;
		_tmp23_ = _tmp22_->maproute;
		_tmp24_ = netsukuku_map_get_gsize ((NetsukukuMap*) _tmp23_);
		_tmp25_ = _tmp24_;
		gsize = _tmp25_;
		_tmp26_ = levels;
		_tmp27_ = gsize;
		_tmp28_ = nip;
		_tmp29_ = nodeid;
		_tmp30_ = netid;
		_tmp31_ = is_primary;
		_tmp32_ = is_auxiliary;
		_tmp33_ = address;
		_tmp34_ = netsukuku_address_manager_dispatcher_new ((NetsukukuIAddressManagerRootDispatcher*) _tmp33_);
		_tmp35_ = _tmp34_;
		_tmp36_ = netsukuku_neighbour_new_with_local_dispatcher (_tmp26_, _tmp27_, _tmp28_, _tmp29_, _tmp30_, _tmp31_, _tmp32_, (zcdRPCDispatcher*) _tmp35_);
		_tmp37_ = _tmp36_;
		_g_object_unref0 (_tmp35_);
		neighbour = _tmp37_;
		_tmp38_ = self->priv->neighbour_manager;
		_tmp39_ = neighbour;
		g_signal_emit_by_name (_tmp38_, "neighbour-new", _tmp39_);
		_g_object_unref0 (neighbour);
		_g_object_unref0 (nip);
		_g_object_unref0 (netid);
	}
}


static void netsukuku_glue_network_interface_manager_real_remove_address (NetsukukuNetworkInterfaceManager* base, NetsukukuAddressManager* address) {
	NetsukukuGlueNetworkInterfaceManager * self;
	NetsukukuAddressManager* _tmp0_;
	gboolean _tmp1_ = FALSE;
	self = (NetsukukuGlueNetworkInterfaceManager*) base;
	g_return_if_fail (address != NULL);
	_tmp0_ = address;
	_tmp1_ = netsukuku_address_manager_do_i_act_as_gateway_for_local (_tmp0_);
	if (_tmp1_) {
		NetsukukuAddressManager* _tmp2_;
		NetsukukuAddressManager* _tmp3_;
		gboolean _tmp4_;
		gboolean _tmp5_;
		gboolean is_primary;
		NetsukukuAddressManager* _tmp6_;
		gboolean _tmp7_;
		gboolean _tmp8_;
		gboolean is_auxiliary;
		NetsukukuAddressManager* _tmp9_;
		NetsukukuNetworkID* _tmp10_ = NULL;
		NetsukukuNetworkID* netid;
		NetsukukuAddressManager* _tmp11_;
		gint _tmp12_ = 0;
		gint nodeid;
		NetsukukuAddressManager* _tmp13_;
		NetsukukuMapRoute* _tmp14_;
		NetsukukuNIP* _tmp15_;
		NetsukukuNIP* _tmp16_;
		NetsukukuNIP* _tmp17_;
		NetsukukuNIP* nip;
		NetsukukuAddressManager* _tmp18_;
		NetsukukuMapRoute* _tmp19_;
		gint _tmp20_;
		gint _tmp21_;
		gint levels;
		NetsukukuAddressManager* _tmp22_;
		NetsukukuMapRoute* _tmp23_;
		gint _tmp24_;
		gint _tmp25_;
		gint gsize;
		gint _tmp26_;
		gint _tmp27_;
		NetsukukuNIP* _tmp28_;
		gint _tmp29_;
		NetsukukuNetworkID* _tmp30_;
		gboolean _tmp31_;
		gboolean _tmp32_;
		NetsukukuAddressManager* _tmp33_;
		NetsukukuAddressManagerDispatcher* _tmp34_;
		NetsukukuAddressManagerDispatcher* _tmp35_;
		NetsukukuNeighbour* _tmp36_;
		NetsukukuNeighbour* _tmp37_;
		NetsukukuNeighbour* neighbour;
		NetsukukuNeighbourManager* _tmp38_;
		NetsukukuNeighbour* _tmp39_;
		_tmp2_ = address;
		NETSUKUKU_NETWORK_INTERFACE_MANAGER_CLASS (netsukuku_glue_network_interface_manager_parent_class)->remove_address (G_TYPE_CHECK_INSTANCE_CAST (self, NETSUKUKU_TYPE_NETWORK_INTERFACE_MANAGER, NetsukukuNetworkInterfaceManager), _tmp2_);
		_tmp3_ = address;
		_tmp4_ = netsukuku_address_manager_get_is_primary (_tmp3_);
		_tmp5_ = _tmp4_;
		is_primary = _tmp5_;
		_tmp6_ = address;
		_tmp7_ = netsukuku_address_manager_get_is_auxiliary (_tmp6_);
		_tmp8_ = _tmp7_;
		is_auxiliary = _tmp8_;
		_tmp9_ = address;
		_tmp10_ = netsukuku_address_manager_get_main_netid (_tmp9_);
		netid = _tmp10_;
		_tmp11_ = address;
		_tmp12_ = netsukuku_address_manager_get_my_id (_tmp11_);
		nodeid = _tmp12_;
		_tmp13_ = address;
		_tmp14_ = _tmp13_->maproute;
		_tmp15_ = netsukuku_map_get_me ((NetsukukuMap*) _tmp14_);
		_tmp16_ = _tmp15_;
		_tmp17_ = _g_object_ref0 (_tmp16_);
		nip = _tmp17_;
		_tmp18_ = address;
		_tmp19_ = _tmp18_->maproute;
		_tmp20_ = netsukuku_map_get_levels ((NetsukukuMap*) _tmp19_);
		_tmp21_ = _tmp20_;
		levels = _tmp21_;
		_tmp22_ = address;
		_tmp23_ = _tmp22_->maproute;
		_tmp24_ = netsukuku_map_get_gsize ((NetsukukuMap*) _tmp23_);
		_tmp25_ = _tmp24_;
		gsize = _tmp25_;
		_tmp26_ = levels;
		_tmp27_ = gsize;
		_tmp28_ = nip;
		_tmp29_ = nodeid;
		_tmp30_ = netid;
		_tmp31_ = is_primary;
		_tmp32_ = is_auxiliary;
		_tmp33_ = address;
		_tmp34_ = netsukuku_address_manager_dispatcher_new ((NetsukukuIAddressManagerRootDispatcher*) _tmp33_);
		_tmp35_ = _tmp34_;
		_tmp36_ = netsukuku_neighbour_new_with_local_dispatcher (_tmp26_, _tmp27_, _tmp28_, _tmp29_, _tmp30_, _tmp31_, _tmp32_, (zcdRPCDispatcher*) _tmp35_);
		_tmp37_ = _tmp36_;
		_g_object_unref0 (_tmp35_);
		neighbour = _tmp37_;
		_tmp38_ = self->priv->neighbour_manager;
		_tmp39_ = neighbour;
		g_signal_emit_by_name (_tmp38_, "neighbour-deleted", _tmp39_);
		_g_object_unref0 (neighbour);
		_g_object_unref0 (nip);
		_g_object_unref0 (netid);
	}
}


GeeList* netsukuku_glue_network_interface_manager_neighbour_list (NetsukukuGlueNetworkInterfaceManager* self) {
	GeeList* result = NULL;
	NetsukukuNeighbourManager* _tmp0_;
	GeeList* _tmp1_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->neighbour_manager;
	_tmp1_ = netsukuku_neighbour_manager_neighbour_list (_tmp0_);
	result = _tmp1_;
	return result;
}


GeeArrayList* netsukuku_glue_network_interface_manager_get_addrs (NetsukukuGlueNetworkInterfaceManager* self) {
	GeeArrayList* result = NULL;
	GeeArrayList* _tmp0_;
	GeeArrayList* _tmp1_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = ((NetsukukuNetworkInterfaceManager*) self)->addrs;
	_tmp1_ = _g_object_ref0 (_tmp0_);
	result = _tmp1_;
	return result;
}


static void netsukuku_glue_network_interface_manager_class_init (NetsukukuGlueNetworkInterfaceManagerClass * klass) {
	netsukuku_glue_network_interface_manager_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (NetsukukuGlueNetworkInterfaceManagerPrivate));
	NETSUKUKU_NETWORK_INTERFACE_MANAGER_CLASS (klass)->create_neighbour_manager = netsukuku_glue_network_interface_manager_real_create_neighbour_manager;
	NETSUKUKU_NETWORK_INTERFACE_MANAGER_CLASS (klass)->dispose_neighbour_manager = netsukuku_glue_network_interface_manager_real_dispose_neighbour_manager;
	NETSUKUKU_NETWORK_INTERFACE_MANAGER_CLASS (klass)->add_address = netsukuku_glue_network_interface_manager_real_add_address;
	NETSUKUKU_NETWORK_INTERFACE_MANAGER_CLASS (klass)->remove_address = netsukuku_glue_network_interface_manager_real_remove_address;
	G_OBJECT_CLASS (klass)->finalize = netsukuku_glue_network_interface_manager_finalize;
}


static void netsukuku_glue_network_interface_manager_instance_init (NetsukukuGlueNetworkInterfaceManager * self) {
	self->priv = NETSUKUKU_GLUE_NETWORK_INTERFACE_MANAGER_GET_PRIVATE (self);
}


static void netsukuku_glue_network_interface_manager_finalize (GObject* obj) {
	NetsukukuGlueNetworkInterfaceManager * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, NETSUKUKU_TYPE_GLUE_NETWORK_INTERFACE_MANAGER, NetsukukuGlueNetworkInterfaceManager);
	_g_object_unref0 (self->priv->neighbour_manager);
	G_OBJECT_CLASS (netsukuku_glue_network_interface_manager_parent_class)->finalize (obj);
}


/** 
      */
GType netsukuku_glue_network_interface_manager_get_type (void) {
	static volatile gsize netsukuku_glue_network_interface_manager_type_id__volatile = 0;
	if (g_once_init_enter (&netsukuku_glue_network_interface_manager_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (NetsukukuGlueNetworkInterfaceManagerClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) netsukuku_glue_network_interface_manager_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (NetsukukuGlueNetworkInterfaceManager), 0, (GInstanceInitFunc) netsukuku_glue_network_interface_manager_instance_init, NULL };
		GType netsukuku_glue_network_interface_manager_type_id;
		netsukuku_glue_network_interface_manager_type_id = g_type_register_static (NETSUKUKU_TYPE_NETWORK_INTERFACE_MANAGER, "NetsukukuGlueNetworkInterfaceManager", &g_define_type_info, 0);
		g_once_init_leave (&netsukuku_glue_network_interface_manager_type_id__volatile, netsukuku_glue_network_interface_manager_type_id);
	}
	return netsukuku_glue_network_interface_manager_type_id__volatile;
}


NetsukukuGlueRadar* netsukuku_glue_radar_construct (GType object_type) {
	NetsukukuGlueRadar * self = NULL;
	self = (NetsukukuGlueRadar*) netsukuku_radar_construct_fake (object_type);
	return self;
}


NetsukukuGlueRadar* netsukuku_glue_radar_new (void) {
	return netsukuku_glue_radar_construct (NETSUKUKU_TYPE_GLUE_RADAR);
}


static void netsukuku_glue_radar_real_time_register (NetsukukuRadar* base, gint radar_id, gint levels, gint gsize, NetsukukuNIP* nip, gint nodeid, NetsukukuNetworkID* netid, const gchar* mac, gboolean is_primary, gboolean is_auxiliary) {
	NetsukukuGlueRadar * self;
	self = (NetsukukuGlueRadar*) base;
	g_return_if_fail (nip != NULL);
	g_return_if_fail (netid != NULL);
	g_return_if_fail (mac != NULL);
}


static void netsukuku_glue_radar_class_init (NetsukukuGlueRadarClass * klass) {
	netsukuku_glue_radar_parent_class = g_type_class_peek_parent (klass);
	NETSUKUKU_RADAR_CLASS (klass)->time_register = netsukuku_glue_radar_real_time_register;
}


static void netsukuku_glue_radar_instance_init (NetsukukuGlueRadar * self) {
}


GType netsukuku_glue_radar_get_type (void) {
	static volatile gsize netsukuku_glue_radar_type_id__volatile = 0;
	if (g_once_init_enter (&netsukuku_glue_radar_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (NetsukukuGlueRadarClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) netsukuku_glue_radar_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (NetsukukuGlueRadar), 0, (GInstanceInitFunc) netsukuku_glue_radar_instance_init, NULL };
		GType netsukuku_glue_radar_type_id;
		netsukuku_glue_radar_type_id = g_type_register_static (NETSUKUKU_TYPE_RADAR, "NetsukukuGlueRadar", &g_define_type_info, 0);
		g_once_init_leave (&netsukuku_glue_radar_type_id__volatile, netsukuku_glue_radar_type_id);
	}
	return netsukuku_glue_radar_type_id__volatile;
}


NetsukukuGlueNeighbourManager* netsukuku_glue_neighbour_manager_construct (GType object_type, NetsukukuRadar* radar, NetsukukuGlueNetworkInterfaceManager* gluenic) {
	NetsukukuGlueNeighbourManager * self = NULL;
	NetsukukuRadar* _tmp0_;
	NetsukukuGlueNetworkInterfaceManager* _tmp1_;
	NetsukukuGlueNetworkInterfaceManager* _tmp2_;
	g_return_val_if_fail (radar != NULL, NULL);
	g_return_val_if_fail (gluenic != NULL, NULL);
	self = (NetsukukuGlueNeighbourManager*) netsukuku_neighbour_manager_construct_fake (object_type);
	_tmp0_ = radar;
	netsukuku_neighbour_manager_set_radar ((NetsukukuNeighbourManager*) self, _tmp0_);
	_tmp1_ = gluenic;
	_tmp2_ = _g_object_ref0 (_tmp1_);
	_g_object_unref0 (self->priv->gluenic);
	self->priv->gluenic = _tmp2_;
	return self;
}


NetsukukuGlueNeighbourManager* netsukuku_glue_neighbour_manager_new (NetsukukuRadar* radar, NetsukukuGlueNetworkInterfaceManager* gluenic) {
	return netsukuku_glue_neighbour_manager_construct (NETSUKUKU_TYPE_GLUE_NEIGHBOUR_MANAGER, radar, gluenic);
}


static void netsukuku_glue_neighbour_manager_real_declare_dead (NetsukukuNeighbourManager* base, NetsukukuNIP* nip, gint nodeid) {
	NetsukukuGlueNeighbourManager * self;
	self = (NetsukukuGlueNeighbourManager*) base;
	g_return_if_fail (nip != NULL);
}


static gboolean _netsukuku_neighbour_equal_func_gee_equal_data_func (gconstpointer a, gconstpointer b, gpointer self) {
	gboolean result;
	result = netsukuku_neighbour_equal_func (a, b);
	return result;
}


static GeeList* netsukuku_glue_neighbour_manager_real_neighbour_list (NetsukukuNeighbourManager* base) {
	NetsukukuGlueNeighbourManager * self;
	GeeList* result = NULL;
	NetsukukuGlueNetworkInterfaceManager* _tmp0_;
	GeeArrayList* _tmp1_ = NULL;
	GeeArrayList* addrs;
	GeeArrayList* _tmp2_;
	GeeArrayList* nlist;
	self = (NetsukukuGlueNeighbourManager*) base;
	_tmp0_ = self->priv->gluenic;
	_tmp1_ = netsukuku_glue_network_interface_manager_get_addrs (_tmp0_);
	addrs = _tmp1_;
	_tmp2_ = gee_array_list_new (NETSUKUKU_TYPE_NEIGHBOUR, (GBoxedCopyFunc) g_object_ref, g_object_unref, _netsukuku_neighbour_equal_func_gee_equal_data_func, NULL, NULL);
	nlist = _tmp2_;
	{
		GeeArrayList* _tmp3_;
		GeeArrayList* _tmp4_;
		GeeArrayList* _address_list;
		GeeArrayList* _tmp5_;
		gint _tmp6_;
		gint _tmp7_;
		gint _address_size;
		gint _address_index;
		_tmp3_ = addrs;
		_tmp4_ = _g_object_ref0 (_tmp3_);
		_address_list = _tmp4_;
		_tmp5_ = _address_list;
		_tmp6_ = gee_abstract_collection_get_size ((GeeCollection*) _tmp5_);
		_tmp7_ = _tmp6_;
		_address_size = _tmp7_;
		_address_index = -1;
		while (TRUE) {
			gint _tmp8_;
			gint _tmp9_;
			gint _tmp10_;
			GeeArrayList* _tmp11_;
			gint _tmp12_;
			gpointer _tmp13_ = NULL;
			NetsukukuAddressManager* address;
			NetsukukuAddressManager* _tmp14_;
			gboolean _tmp15_;
			gboolean _tmp16_;
			gboolean is_primary;
			NetsukukuAddressManager* _tmp17_;
			gboolean _tmp18_;
			gboolean _tmp19_;
			gboolean is_auxiliary;
			NetsukukuAddressManager* _tmp20_;
			NetsukukuNetworkID* _tmp21_ = NULL;
			NetsukukuNetworkID* netid;
			NetsukukuAddressManager* _tmp22_;
			gint _tmp23_ = 0;
			gint nodeid;
			NetsukukuAddressManager* _tmp24_;
			NetsukukuMapRoute* _tmp25_;
			NetsukukuNIP* _tmp26_;
			NetsukukuNIP* _tmp27_;
			NetsukukuNIP* _tmp28_;
			NetsukukuNIP* nip;
			NetsukukuAddressManager* _tmp29_;
			NetsukukuMapRoute* _tmp30_;
			gint _tmp31_;
			gint _tmp32_;
			gint levels;
			NetsukukuAddressManager* _tmp33_;
			NetsukukuMapRoute* _tmp34_;
			gint _tmp35_;
			gint _tmp36_;
			gint gsize;
			gint _tmp37_;
			gint _tmp38_;
			NetsukukuNIP* _tmp39_;
			gint _tmp40_;
			NetsukukuNetworkID* _tmp41_;
			gboolean _tmp42_;
			gboolean _tmp43_;
			NetsukukuAddressManager* _tmp44_;
			NetsukukuAddressManagerDispatcher* _tmp45_;
			NetsukukuAddressManagerDispatcher* _tmp46_;
			NetsukukuNeighbour* _tmp47_;
			NetsukukuNeighbour* _tmp48_;
			NetsukukuNeighbour* neighbour;
			GeeArrayList* _tmp49_;
			NetsukukuNeighbour* _tmp50_;
			_tmp8_ = _address_index;
			_address_index = _tmp8_ + 1;
			_tmp9_ = _address_index;
			_tmp10_ = _address_size;
			if (!(_tmp9_ < _tmp10_)) {
				break;
			}
			_tmp11_ = _address_list;
			_tmp12_ = _address_index;
			_tmp13_ = gee_abstract_list_get ((GeeAbstractList*) _tmp11_, _tmp12_);
			address = (NetsukukuAddressManager*) _tmp13_;
			_tmp14_ = address;
			_tmp15_ = netsukuku_address_manager_get_is_primary (_tmp14_);
			_tmp16_ = _tmp15_;
			is_primary = _tmp16_;
			_tmp17_ = address;
			_tmp18_ = netsukuku_address_manager_get_is_auxiliary (_tmp17_);
			_tmp19_ = _tmp18_;
			is_auxiliary = _tmp19_;
			_tmp20_ = address;
			_tmp21_ = netsukuku_address_manager_get_main_netid (_tmp20_);
			netid = _tmp21_;
			_tmp22_ = address;
			_tmp23_ = netsukuku_address_manager_get_my_id (_tmp22_);
			nodeid = _tmp23_;
			_tmp24_ = address;
			_tmp25_ = _tmp24_->maproute;
			_tmp26_ = netsukuku_map_get_me ((NetsukukuMap*) _tmp25_);
			_tmp27_ = _tmp26_;
			_tmp28_ = _g_object_ref0 (_tmp27_);
			nip = _tmp28_;
			_tmp29_ = address;
			_tmp30_ = _tmp29_->maproute;
			_tmp31_ = netsukuku_map_get_levels ((NetsukukuMap*) _tmp30_);
			_tmp32_ = _tmp31_;
			levels = _tmp32_;
			_tmp33_ = address;
			_tmp34_ = _tmp33_->maproute;
			_tmp35_ = netsukuku_map_get_gsize ((NetsukukuMap*) _tmp34_);
			_tmp36_ = _tmp35_;
			gsize = _tmp36_;
			_tmp37_ = levels;
			_tmp38_ = gsize;
			_tmp39_ = nip;
			_tmp40_ = nodeid;
			_tmp41_ = netid;
			_tmp42_ = is_primary;
			_tmp43_ = is_auxiliary;
			_tmp44_ = address;
			_tmp45_ = netsukuku_address_manager_dispatcher_new ((NetsukukuIAddressManagerRootDispatcher*) _tmp44_);
			_tmp46_ = _tmp45_;
			_tmp47_ = netsukuku_neighbour_new_with_local_dispatcher (_tmp37_, _tmp38_, _tmp39_, _tmp40_, _tmp41_, _tmp42_, _tmp43_, (zcdRPCDispatcher*) _tmp46_);
			_tmp48_ = _tmp47_;
			_g_object_unref0 (_tmp46_);
			neighbour = _tmp48_;
			_tmp49_ = nlist;
			_tmp50_ = neighbour;
			gee_abstract_collection_add ((GeeAbstractCollection*) _tmp49_, _tmp50_);
			_g_object_unref0 (neighbour);
			_g_object_unref0 (nip);
			_g_object_unref0 (netid);
			_g_object_unref0 (address);
		}
		_g_object_unref0 (_address_list);
	}
	result = (GeeList*) nlist;
	_g_object_unref0 (addrs);
	return result;
}


static void netsukuku_glue_neighbour_manager_class_init (NetsukukuGlueNeighbourManagerClass * klass) {
	netsukuku_glue_neighbour_manager_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (NetsukukuGlueNeighbourManagerPrivate));
	NETSUKUKU_NEIGHBOUR_MANAGER_CLASS (klass)->declare_dead = netsukuku_glue_neighbour_manager_real_declare_dead;
	NETSUKUKU_NEIGHBOUR_MANAGER_CLASS (klass)->neighbour_list = netsukuku_glue_neighbour_manager_real_neighbour_list;
	G_OBJECT_CLASS (klass)->finalize = netsukuku_glue_neighbour_manager_finalize;
}


static void netsukuku_glue_neighbour_manager_instance_init (NetsukukuGlueNeighbourManager * self) {
	self->priv = NETSUKUKU_GLUE_NEIGHBOUR_MANAGER_GET_PRIVATE (self);
}


static void netsukuku_glue_neighbour_manager_finalize (GObject* obj) {
	NetsukukuGlueNeighbourManager * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, NETSUKUKU_TYPE_GLUE_NEIGHBOUR_MANAGER, NetsukukuGlueNeighbourManager);
	_g_object_unref0 (self->priv->gluenic);
	G_OBJECT_CLASS (netsukuku_glue_neighbour_manager_parent_class)->finalize (obj);
}


GType netsukuku_glue_neighbour_manager_get_type (void) {
	static volatile gsize netsukuku_glue_neighbour_manager_type_id__volatile = 0;
	if (g_once_init_enter (&netsukuku_glue_neighbour_manager_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (NetsukukuGlueNeighbourManagerClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) netsukuku_glue_neighbour_manager_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (NetsukukuGlueNeighbourManager), 0, (GInstanceInitFunc) netsukuku_glue_neighbour_manager_instance_init, NULL };
		GType netsukuku_glue_neighbour_manager_type_id;
		netsukuku_glue_neighbour_manager_type_id = g_type_register_static (NETSUKUKU_TYPE_NEIGHBOUR_MANAGER, "NetsukukuGlueNeighbourManager", &g_define_type_info, 0);
		g_once_init_leave (&netsukuku_glue_neighbour_manager_type_id__volatile, netsukuku_glue_neighbour_manager_type_id);
	}
	return netsukuku_glue_neighbour_manager_type_id__volatile;
}



