/*
 *  This file is part of Netsukuku.
 *  (c) Copyright 2011 Luca Dionisi aka lukisi <luca.dionisi@gmail.com>
 *
 *  Netsukuku is free software: you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation, either version 3 of the License, or
 *  (at your option) any later version.
 *
 *  Netsukuku is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with Netsukuku.  If not, see <http://www.gnu.org/licenses/>.
 */

using Gee;
using zcd;

namespace Netsukuku
{
    public abstract class NIC : Object
    {
        private static CreateNicDelegate? registered_class_linux = null;
        public static void register_class(string k, CreateNicDelegate create_new_nic)
        {
            if (k == "linux" && registered_class_linux == null) registered_class_linux = create_new_nic;
        }

        public static NIC create_instance(string nic_name)
        {
            string impl = Settings.NETWORK_IMPLEMENTATION;
            if (impl == "linux" && registered_class_linux != null) return registered_class_linux(nic_name);
            error(@"No valid real implementation of class NIC for $impl. Is your system supported?");
        }

        protected string name;
        protected ArrayList<string> addresses;

        protected NIC(string nic_name)
        {
            name = nic_name;
            addresses = new ArrayList<string>();
        }

        /** Brings the interface up.
          */
        public void up()
        {
            // common stuff?
            _up();
            addresses = new ArrayList<string>();
        }
        protected abstract void _up();

        /** Brings the interface down.
          */
        public void down()
        {
            // common stuff?
            _down();
            addresses = new ArrayList<string>();
        }
        protected abstract void _down();

        /** Add NIC address.
          */
        public void add_address(string address)
        {
            // common stuff?
            if (! addresses.contains(address))
            {
                _add_address(address);
                addresses.add(address);
            }
        }
        protected abstract void _add_address(string address);

        /** Remove NIC address.
          */
        public void remove_address(string address)
        {
            // common stuff?
            if (addresses.contains(address))
            {
                _remove_address(address);
                addresses.remove(address);
            }
        }
        protected abstract void _remove_address(string address);

        /** Disables filtering.
          */
        public void disable_filtering()
        {
            // common stuff?
            _disable_filtering();
        }
        protected abstract void _disable_filtering();

        public abstract unowned string _mac_getter();
        public string mac {
            get {
                return this._mac_getter();
            }
        }

        public abstract bool _is_active_getter();
        public bool is_active {
            get {
                return this._is_active_getter();
            }
        }
    }

    public delegate NIC CreateNicDelegate(string nic_name);

    public class DummyNIC : NIC
    {
        public DummyNIC(string nic_name)
        {
            base(nic_name);
        }

        private string _mac = "nil";

        public override unowned string _mac_getter()
        {
            return _mac;
        }

        public override bool _is_active_getter()
        {
            return true;
        }

        public override void _up() {}
        public override void _down() {}
        public override void _add_address(string address) {}
        public override void _remove_address(string address) {}
        public override void _disable_filtering() {}
    }
}

