
    public interface IAndnaAsPeer : Object
    {
        public abstract  AndnaRegisterMainResponse
                         register_main_for_pubk
                         (AndnaDomainRecord request,
                          SerializableBuffer signature,
                          bool replicate)
                         throws RPCError, PeerRefuseServiceError;
        public abstract  AndnaGetRegistrarResponse?
                         get_registrar
                         (string hashed_hostname)
                         throws RPCError, PeerRefuseServiceError;
        public abstract  AndnaDomainRecord
                         get_domain_record
                         (string hashed_hostname)
                         throws RPCError, PeerRefuseServiceError;
        public abstract  AndnaRegisterSpreadResponse
                         register_spread_record
                         (string hashed_hostname,
                          int spread_number,
                          bool replicate)
                         throws RPCError, PeerRefuseServiceError;
        public abstract  AndnaGetServersResponse
                         get_servers
                         (string hashed_hostname,
                          AndnaServiceKey srv_key,
                          int spread_number,
                          bool chain)
                         throws RPCError, PeerRefuseServiceError;
        public abstract  AndnaGetCacheRecordsResponse
                         get_cache_records ()
                         throws RPCError, PeerRefuseServiceError;
    }

    public class RmtAndnaPeer : RmtPeer, IAndnaAsPeer
    {
        public RmtAndnaPeer
               (PeerToPeer peer_to_peer_service,
                Object? key=null,
                NIP? hIP=null,
                AggregatedNeighbour? aggregated_neighbour=null)
        {
            base(peer_to_peer_service, key, hIP, aggregated_neighbour);
        }

        public  AndnaRegisterMainResponse
                register_main_for_pubk
                (AndnaDomainRecord request,
                 SerializableBuffer signature,
                 bool replicate)
                throws RPCError, PeerRefuseServiceError
        {
            RemoteCall rc = new RemoteCall();
            rc.method_name = "register_main_for_pubk";
            rc.add_parameter(request);
            rc.add_parameter(signature);
            rc.add_parameter(new SerializableBool(replicate));
            try {
                return (AndnaRegisterMainResponse)
                    filter_exception(
                    filter_exception_PeerRefuseServiceError(
                    this.rmt(rc))
                );
            }
            catch (RPCError e) {throw e;}
            catch (Error e)
            {
                throw new RPCError.GENERIC
                    (@"Unexpected error $(e.domain).$(e.code) '$(e.message)'");
            }
        }

        public  AndnaGetRegistrarResponse?
                get_registrar
                (string hashed_hostname)
                throws RPCError, PeerRefuseServiceError
        {
            RemoteCall rc = new RemoteCall();
            rc.method_name = "get_registrar";
            rc.add_parameter(new SerializableString(hashed_hostname));
            try {
                ISerializable ret =
                    filter_exception(
                    filter_exception_PeerRefuseServiceError(
                    this.rmt(rc))
                );
                if (ret.get_type().is_a(typeof(SerializableNone))) return null;
                else return (AndnaGetRegistrarResponse)ret;
            }
            catch (RPCError e) {throw e;}
            catch (Error e)
            {
                throw new RPCError.GENERIC
                    (@"Unexpected error $(e.domain).$(e.code) '$(e.message)'");
            }
        }

        public  AndnaDomainRecord
                get_domain_record
                (string hashed_hostname)
                throws RPCError, PeerRefuseServiceError
        {
            RemoteCall rc = new RemoteCall();
            rc.method_name = "get_domain_record";
            rc.add_parameter(new SerializableString(hashed_hostname));
            try {
                return (AndnaDomainRecord)
                    filter_exception(
                    filter_exception_PeerRefuseServiceError(
                    this.rmt(rc))
                );
            }
            catch (RPCError e) {throw e;}
            catch (Error e)
            {
                throw new RPCError.GENERIC
                    (@"Unexpected error $(e.domain).$(e.code) '$(e.message)'");
            }
        }

        public  AndnaRegisterSpreadResponse
                register_spread_record
                (string hashed_hostname,
                 int spread_number,
                 bool replicate)
                throws RPCError, PeerRefuseServiceError
        {
            RemoteCall rc = new RemoteCall();
            rc.method_name = "register_spread_record";
            rc.add_parameter(new SerializableString(hashed_hostname));
            rc.add_parameter(new SerializableInt(spread_number));
            rc.add_parameter(new SerializableBool(replicate));
            try {
                return (AndnaRegisterSpreadResponse)
                    filter_exception(
                    filter_exception_PeerRefuseServiceError(
                    this.rmt(rc))
                );
            }
            catch (RPCError e) {throw e;}
            catch (Error e)
            {
                throw new RPCError.GENERIC
                    (@"Unexpected error $(e.domain).$(e.code) '$(e.message)'");
            }
        }

        public  AndnaGetServersResponse
                get_servers
                (string hashed_hostname,
                 AndnaServiceKey srv_key,
                 int spread_number,
                 bool chain)
                throws RPCError, PeerRefuseServiceError
        {
            RemoteCall rc = new RemoteCall();
            rc.method_name = "get_servers";
            rc.add_parameter(new SerializableString(hashed_hostname));
            rc.add_parameter(srv_key);
            rc.add_parameter(new SerializableInt(spread_number));
            rc.add_parameter(new SerializableBool(chain));
            try {
                return (AndnaGetServersResponse)
                    filter_exception(
                    filter_exception_PeerRefuseServiceError(
                    this.rmt(rc))
                );
            }
            catch (RPCError e) {throw e;}
            catch (Error e)
            {
                throw new RPCError.GENERIC
                    (@"Unexpected error $(e.domain).$(e.code) '$(e.message)'");
            }
        }

        public  AndnaGetCacheRecordsResponse
                get_cache_records ()
                throws RPCError, PeerRefuseServiceError
        {
            RemoteCall rc = new RemoteCall();
            rc.method_name = "get_cache_records";
            try {
                return (AndnaGetCacheRecordsResponse)
                    filter_exception(
                    filter_exception_PeerRefuseServiceError(
                    this.rmt(rc))
                );
            }
            catch (RPCError e) {throw e;}
            catch (Error e)
            {
                throw new RPCError.GENERIC
                    (@"Unexpected error $(e.domain).$(e.code) '$(e.message)'");
            }
        }

    }

    public class Andna : OptionalPeerToPeer, IAndnaAsPeer, IAndna
    {

        public RmtAndnaPeer
               peer
               (NIP? hIP=null,
                Object? key=null,
                AggregatedNeighbour? aggregated_neighbour=null)
        {
            assert(hIP != null || key != null);
            return new RmtAndnaPeer(this, key, hIP, aggregated_neighbour);
        }

        /** This method could be called *directly* for a dispatcher that does not need to transform
          * an exception into a remotable.
          */
        public override ISerializable _dispatch(Object? caller, RemoteCall data) throws Error
        {
            string[] pieces = data.method_name.split(".");
            if (pieces[0] == "register_main_for_pubk")
            {
                if (pieces.length != 1)
                    throw new RPCError.MALFORMED_PACKET(
                        "register_main_for_pubk is a function.");
                if (data.parameters.size != 3)
                    throw new RPCError.MALFORMED_PACKET(
                        "register_main_for_pubk wants 3 parameters.");
                ISerializable iser0 = data.parameters[0];
                if (! iser0.get_type().is_a(typeof(AndnaDomainRecord)))
                    throw new RPCError.MALFORMED_PACKET(
                        "register_main_for_pubk parameter 1 is not a AndnaDomainRecord.");
                AndnaDomainRecord request = (AndnaDomainRecord)iser0;
                ISerializable iser1 = data.parameters[1];
                if (! iser1.get_type().is_a(typeof(SerializableBuffer)))
                    throw new RPCError.MALFORMED_PACKET(
                        "register_main_for_pubk parameter 2 is not a SerializableBuffer.");
                SerializableBuffer signature = (SerializableBuffer)iser1;
                ISerializable iser2 = data.parameters[2];
                if (! iser2.get_type().is_a(typeof(SerializableBool)))
                    throw new RPCError.MALFORMED_PACKET(
                        "register_main_for_pubk parameter 3 is not a bool.");
                bool replicate = ((SerializableBool)iser2).b;
                return register_main_for_pubk(request, signature, replicate);
            }
            if (pieces[0] == "get_registrar")
            {
                if (pieces.length != 1)
                    throw new RPCError.MALFORMED_PACKET(
                        "get_registrar is a function.");
                if (data.parameters.size != 1)
                    throw new RPCError.MALFORMED_PACKET(
                        "get_registrar wants 1 parameter.");
                ISerializable iser0 = data.parameters[0];
                if (! iser0.get_type().is_a(typeof(SerializableString)))
                    throw new RPCError.MALFORMED_PACKET(
                        "get_registrar parameter 1 is not a string.");
                string hashed_hostname = ((SerializableString)iser0).s;
                    AndnaGetRegistrarResponse? ret = get_registrar(hashed_hostname);
                    if (ret == null) return new SerializableNone();
                    return ret;
            }
            if (pieces[0] == "get_domain_record")
            {
                if (pieces.length != 1)
                    throw new RPCError.MALFORMED_PACKET(
                        "get_domain_record is a function.");
                if (data.parameters.size != 1)
                    throw new RPCError.MALFORMED_PACKET(
                        "get_domain_record wants 1 parameter.");
                ISerializable iser0 = data.parameters[0];
                if (! iser0.get_type().is_a(typeof(SerializableString)))
                    throw new RPCError.MALFORMED_PACKET(
                        "get_domain_record parameter 1 is not a string.");
                string hashed_hostname = ((SerializableString)iser0).s;
                return get_domain_record(hashed_hostname);
            }
            if (pieces[0] == "register_spread_record")
            {
                if (pieces.length != 1)
                    throw new RPCError.MALFORMED_PACKET(
                        "register_spread_record is a function.");
                if (data.parameters.size != 3)
                    throw new RPCError.MALFORMED_PACKET(
                        "register_spread_record wants 3 parameters.");
                ISerializable iser0 = data.parameters[0];
                if (! iser0.get_type().is_a(typeof(SerializableString)))
                    throw new RPCError.MALFORMED_PACKET(
                        "register_spread_record parameter 1 is not a string.");
                string hashed_hostname = ((SerializableString)iser0).s;
                ISerializable iser1 = data.parameters[1];
                if (! iser1.get_type().is_a(typeof(SerializableInt)))
                    throw new RPCError.MALFORMED_PACKET(
                        "register_spread_record parameter 2 is not a int.");
                int spread_number = ((SerializableInt)iser1).i;
                ISerializable iser2 = data.parameters[2];
                if (! iser2.get_type().is_a(typeof(SerializableBool)))
                    throw new RPCError.MALFORMED_PACKET(
                        "register_spread_record parameter 3 is not a bool.");
                bool replicate = ((SerializableBool)iser2).b;
                return register_spread_record(hashed_hostname, spread_number, replicate);
            }
            if (pieces[0] == "get_servers")
            {
                if (pieces.length != 1)
                    throw new RPCError.MALFORMED_PACKET(
                        "get_servers is a function.");
                if (data.parameters.size != 4)
                    throw new RPCError.MALFORMED_PACKET(
                        "get_servers wants 4 parameters.");
                ISerializable iser0 = data.parameters[0];
                if (! iser0.get_type().is_a(typeof(SerializableString)))
                    throw new RPCError.MALFORMED_PACKET(
                        "get_servers parameter 1 is not a string.");
                string hashed_hostname = ((SerializableString)iser0).s;
                ISerializable iser1 = data.parameters[1];
                if (! iser1.get_type().is_a(typeof(AndnaServiceKey)))
                    throw new RPCError.MALFORMED_PACKET(
                        "get_servers parameter 2 is not a AndnaServiceKey.");
                AndnaServiceKey srv_key = (AndnaServiceKey)iser1;
                ISerializable iser2 = data.parameters[2];
                if (! iser2.get_type().is_a(typeof(SerializableInt)))
                    throw new RPCError.MALFORMED_PACKET(
                        "get_servers parameter 3 is not a int.");
                int spread_number = ((SerializableInt)iser2).i;
                ISerializable iser3 = data.parameters[3];
                if (! iser3.get_type().is_a(typeof(SerializableBool)))
                    throw new RPCError.MALFORMED_PACKET(
                        "get_servers parameter 4 is not a bool.");
                bool chain = ((SerializableBool)iser3).b;
                return get_servers(hashed_hostname, srv_key, spread_number, chain);
            }
            if (pieces[0] == "get_cache_records")
            {
                if (pieces.length != 1)
                    throw new RPCError.MALFORMED_PACKET(
                        "get_cache_records is a function.");
                if (data.parameters.size != 0)
                    throw new RPCError.MALFORMED_PACKET(
                        "get_cache_records wants no parameters.");
                return get_cache_records();
            }
            return base._dispatch(caller, data);
        }
    }



