/* peer_to_peer_utils.c generated by valac 0.20.1, the Vala compiler
 * generated from peer_to_peer_utils.vala, do not modify */

/*
 *  This file is part of Netsukuku.
 *  (c) Copyright 2011 Luca Dionisi aka lukisi <luca.dionisi@gmail.com>
 *
 *  Netsukuku is free software: you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation, either version 3 of the License, or
 *  (at your option) any later version.
 *
 *  Netsukuku is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with Netsukuku.  If not, see <http://www.gnu.org/licenses/>.
 *
 *
 *  Implementation of the PeerToPeer Over Ntk RFC. See {-PeerToPeerNtk-}
 */

#include <glib.h>
#include <glib-object.h>
#include <gee.h>
#include <netsukuku-rpc.h>
#include <zcd.h>
#include <tasklet.h>


#define NETSUKUKU_TYPE_HELPER_CALLBACKS (netsukuku_helper_callbacks_get_type ())
#define NETSUKUKU_HELPER_CALLBACKS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), NETSUKUKU_TYPE_HELPER_CALLBACKS, NetsukukuHelperCallbacks))
#define NETSUKUKU_HELPER_CALLBACKS_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), NETSUKUKU_TYPE_HELPER_CALLBACKS, NetsukukuHelperCallbacksClass))
#define NETSUKUKU_IS_HELPER_CALLBACKS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), NETSUKUKU_TYPE_HELPER_CALLBACKS))
#define NETSUKUKU_IS_HELPER_CALLBACKS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), NETSUKUKU_TYPE_HELPER_CALLBACKS))
#define NETSUKUKU_HELPER_CALLBACKS_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), NETSUKUKU_TYPE_HELPER_CALLBACKS, NetsukukuHelperCallbacksClass))

typedef struct _NetsukukuHelperCallbacks NetsukukuHelperCallbacks;
typedef struct _NetsukukuHelperCallbacksClass NetsukukuHelperCallbacksClass;
typedef struct _NetsukukuHelperCallbacksPrivate NetsukukuHelperCallbacksPrivate;

#define NETSUKUKU_TYPE_PEER_TO_PEER (netsukuku_peer_to_peer_get_type ())
#define NETSUKUKU_PEER_TO_PEER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), NETSUKUKU_TYPE_PEER_TO_PEER, NetsukukuPeerToPeer))
#define NETSUKUKU_PEER_TO_PEER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), NETSUKUKU_TYPE_PEER_TO_PEER, NetsukukuPeerToPeerClass))
#define NETSUKUKU_IS_PEER_TO_PEER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), NETSUKUKU_TYPE_PEER_TO_PEER))
#define NETSUKUKU_IS_PEER_TO_PEER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), NETSUKUKU_TYPE_PEER_TO_PEER))
#define NETSUKUKU_PEER_TO_PEER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), NETSUKUKU_TYPE_PEER_TO_PEER, NetsukukuPeerToPeerClass))

typedef struct _NetsukukuPeerToPeer NetsukukuPeerToPeer;
typedef struct _NetsukukuPeerToPeerClass NetsukukuPeerToPeerClass;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
typedef struct _NetsukukuPeerToPeerPrivate NetsukukuPeerToPeerPrivate;

#define NETSUKUKU_TYPE_MAP (netsukuku_map_get_type ())
#define NETSUKUKU_MAP(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), NETSUKUKU_TYPE_MAP, NetsukukuMap))
#define NETSUKUKU_MAP_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), NETSUKUKU_TYPE_MAP, NetsukukuMapClass))
#define NETSUKUKU_IS_MAP(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), NETSUKUKU_TYPE_MAP))
#define NETSUKUKU_IS_MAP_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), NETSUKUKU_TYPE_MAP))
#define NETSUKUKU_MAP_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), NETSUKUKU_TYPE_MAP, NetsukukuMapClass))

typedef struct _NetsukukuMap NetsukukuMap;
typedef struct _NetsukukuMapClass NetsukukuMapClass;

#define NETSUKUKU_TYPE_MAP_ROUTE (netsukuku_map_route_get_type ())
#define NETSUKUKU_MAP_ROUTE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), NETSUKUKU_TYPE_MAP_ROUTE, NetsukukuMapRoute))
#define NETSUKUKU_MAP_ROUTE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), NETSUKUKU_TYPE_MAP_ROUTE, NetsukukuMapRouteClass))
#define NETSUKUKU_IS_MAP_ROUTE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), NETSUKUKU_TYPE_MAP_ROUTE))
#define NETSUKUKU_IS_MAP_ROUTE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), NETSUKUKU_TYPE_MAP_ROUTE))
#define NETSUKUKU_MAP_ROUTE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), NETSUKUKU_TYPE_MAP_ROUTE, NetsukukuMapRouteClass))

typedef struct _NetsukukuMapRoute NetsukukuMapRoute;
typedef struct _NetsukukuMapRouteClass NetsukukuMapRouteClass;

#define NETSUKUKU_TYPE_AGGREGATED_NEIGHBOUR_MANAGER (netsukuku_aggregated_neighbour_manager_get_type ())
#define NETSUKUKU_AGGREGATED_NEIGHBOUR_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), NETSUKUKU_TYPE_AGGREGATED_NEIGHBOUR_MANAGER, NetsukukuAggregatedNeighbourManager))
#define NETSUKUKU_AGGREGATED_NEIGHBOUR_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), NETSUKUKU_TYPE_AGGREGATED_NEIGHBOUR_MANAGER, NetsukukuAggregatedNeighbourManagerClass))
#define NETSUKUKU_IS_AGGREGATED_NEIGHBOUR_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), NETSUKUKU_TYPE_AGGREGATED_NEIGHBOUR_MANAGER))
#define NETSUKUKU_IS_AGGREGATED_NEIGHBOUR_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), NETSUKUKU_TYPE_AGGREGATED_NEIGHBOUR_MANAGER))
#define NETSUKUKU_AGGREGATED_NEIGHBOUR_MANAGER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), NETSUKUKU_TYPE_AGGREGATED_NEIGHBOUR_MANAGER, NetsukukuAggregatedNeighbourManagerClass))

typedef struct _NetsukukuAggregatedNeighbourManager NetsukukuAggregatedNeighbourManager;
typedef struct _NetsukukuAggregatedNeighbourManagerClass NetsukukuAggregatedNeighbourManagerClass;

typedef gboolean (*NetsukukuAcceptRecordCallback) (void* user_data, GError** error);
typedef void (*NetsukukuForwardRecordCallback) (GObject* obj1, GeeList* replica_nodes, void* user_data, GError** error);
typedef void (*NetsukukuRefuseRecordCallback) (void* user_data, GError** error);
struct _NetsukukuHelperCallbacks {
	GObject parent_instance;
	NetsukukuHelperCallbacksPrivate * priv;
	NetsukukuAcceptRecordCallback accept_callback;
	gpointer accept_callback_target;
	GDestroyNotify accept_callback_target_destroy_notify;
	NetsukukuForwardRecordCallback forward_callback;
	gpointer forward_callback_target;
	GDestroyNotify forward_callback_target_destroy_notify;
	NetsukukuRefuseRecordCallback refuse_callback;
	gpointer refuse_callback_target;
	GDestroyNotify refuse_callback_target_destroy_notify;
};

struct _NetsukukuHelperCallbacksClass {
	GObjectClass parent_class;
};

typedef enum  {
	NETSUKUKU_PEER_TO_PEER_ERROR_REGISTER,
	NETSUKUKU_PEER_TO_PEER_ERROR_GENERIC
} NetsukukuPeerToPeerError;
#define NETSUKUKU_PEER_TO_PEER_ERROR netsukuku_peer_to_peer_error_quark ()
struct _NetsukukuPeerToPeer {
	zcdRPCDispatcher parent_instance;
	NetsukukuPeerToPeerPrivate * priv;
	NetsukukuMapRoute* maproute;
	NetsukukuAggregatedNeighbourManager* aggregated_neighbour_manager;
	gint pid;
	gboolean has_valid_map;
};

struct _NetsukukuPeerToPeerClass {
	zcdRPCDispatcherClass parent_class;
	void (*start_operations) (NetsukukuPeerToPeer* self);
	void (*stop_operations) (NetsukukuPeerToPeer* self);
	gboolean (*is_participant) (NetsukukuPeerToPeer* self, gint lvl, gint pos);
	NetsukukuNIP* (*h) (NetsukukuPeerToPeer* self, GObject* key);
};


static gpointer netsukuku_helper_callbacks_parent_class = NULL;

GType netsukuku_helper_callbacks_get_type (void) G_GNUC_CONST;
enum  {
	NETSUKUKU_HELPER_CALLBACKS_DUMMY_PROPERTY
};
NetsukukuHelperCallbacks* netsukuku_helper_callbacks_new (void);
NetsukukuHelperCallbacks* netsukuku_helper_callbacks_construct (GType object_type);
static void netsukuku_helper_callbacks_finalize (GObject* obj);
GType netsukuku_peer_to_peer_get_type (void) G_GNUC_CONST;
void netsukuku_check_hash_and_start_replica (NetsukukuPeerToPeer* service, NetsukukuNIP* hash_nip, gboolean replicate, GObject* obj1, gint replica_nodes_max, NetsukukuAcceptRecordCallback accept_callback, void* accept_callback_target, NetsukukuForwardRecordCallback forward_callback, void* forward_callback_target, NetsukukuRefuseRecordCallback refuse_callback, void* refuse_callback_target, GError** error);
GQuark netsukuku_peer_to_peer_error_quark (void);
NetsukukuHCoord* netsukuku_peer_to_peer_search_participant (NetsukukuPeerToPeer* self, NetsukukuNIP* hIP, gint path_sign, GError** error);
static void ___lambda6_ (GObject* tpar1, GObject* tpar2, GError** error);
static void ____lambda6__tasklets_tasklet_callback (GObject* obj1, GObject* obj2, GObject* obj3, GObject* obj4, gpointer self, GError** error);
GeeList* netsukuku_peer_to_peer_find_nearest_to_register (NetsukukuPeerToPeer* self, NetsukukuNIP* hash_nip, gint num_dupl, gint* inside_gnode_level, GError** error);
GType netsukuku_map_get_type (void) G_GNUC_CONST;
GType netsukuku_map_route_get_type (void) G_GNUC_CONST;
GType netsukuku_aggregated_neighbour_manager_get_type (void) G_GNUC_CONST;
NetsukukuNIP* netsukuku_map_get_me (NetsukukuMap* self);
static void ____lambda7_ (GObject* tpar1, GObject* tpar2, GObject* tpar3, GError** error);
static void _____lambda7__tasklets_tasklet_callback (GObject* obj1, GObject* obj2, GObject* obj3, GObject* obj4, gpointer self, GError** error);


NetsukukuHelperCallbacks* netsukuku_helper_callbacks_construct (GType object_type) {
	NetsukukuHelperCallbacks * self = NULL;
	self = (NetsukukuHelperCallbacks*) g_object_new (object_type, NULL);
	return self;
}


NetsukukuHelperCallbacks* netsukuku_helper_callbacks_new (void) {
	return netsukuku_helper_callbacks_construct (NETSUKUKU_TYPE_HELPER_CALLBACKS);
}


static void netsukuku_helper_callbacks_class_init (NetsukukuHelperCallbacksClass * klass) {
	netsukuku_helper_callbacks_parent_class = g_type_class_peek_parent (klass);
	G_OBJECT_CLASS (klass)->finalize = netsukuku_helper_callbacks_finalize;
}


static void netsukuku_helper_callbacks_instance_init (NetsukukuHelperCallbacks * self) {
}


static void netsukuku_helper_callbacks_finalize (GObject* obj) {
	NetsukukuHelperCallbacks * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, NETSUKUKU_TYPE_HELPER_CALLBACKS, NetsukukuHelperCallbacks);
	(self->accept_callback_target_destroy_notify == NULL) ? NULL : (self->accept_callback_target_destroy_notify (self->accept_callback_target), NULL);
	self->accept_callback = NULL;
	self->accept_callback_target = NULL;
	self->accept_callback_target_destroy_notify = NULL;
	(self->forward_callback_target_destroy_notify == NULL) ? NULL : (self->forward_callback_target_destroy_notify (self->forward_callback_target), NULL);
	self->forward_callback = NULL;
	self->forward_callback_target = NULL;
	self->forward_callback_target_destroy_notify = NULL;
	(self->refuse_callback_target_destroy_notify == NULL) ? NULL : (self->refuse_callback_target_destroy_notify (self->refuse_callback_target), NULL);
	self->refuse_callback = NULL;
	self->refuse_callback_target = NULL;
	self->refuse_callback_target_destroy_notify = NULL;
	G_OBJECT_CLASS (netsukuku_helper_callbacks_parent_class)->finalize (obj);
}


/** Helper functions for replication of records **/
GType netsukuku_helper_callbacks_get_type (void) {
	static volatile gsize netsukuku_helper_callbacks_type_id__volatile = 0;
	if (g_once_init_enter (&netsukuku_helper_callbacks_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (NetsukukuHelperCallbacksClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) netsukuku_helper_callbacks_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (NetsukukuHelperCallbacks), 0, (GInstanceInitFunc) netsukuku_helper_callbacks_instance_init, NULL };
		GType netsukuku_helper_callbacks_type_id;
		netsukuku_helper_callbacks_type_id = g_type_register_static (G_TYPE_OBJECT, "NetsukukuHelperCallbacks", &g_define_type_info, 0);
		g_once_init_leave (&netsukuku_helper_callbacks_type_id__volatile, netsukuku_helper_callbacks_type_id);
	}
	return netsukuku_helper_callbacks_type_id__volatile;
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


static void ___lambda6_ (GObject* tpar1, GObject* tpar2, GError** error) {
	GObject* _tmp0_;
	GObject* _tmp1_;
	GObject* tasklet_obj1;
	GObject* _tmp2_;
	NetsukukuHelperCallbacks* _tmp3_;
	NetsukukuHelperCallbacks* tasklet_callbacks;
	NetsukukuForwardRecordCallback _tmp4_;
	void* _tmp4__target;
	GError * _inner_error_ = NULL;
	_tmp0_ = tpar1;
	_tmp1_ = _g_object_ref0 (_tmp0_);
	tasklet_obj1 = _tmp1_;
	_tmp2_ = tpar2;
	_tmp3_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp2_, NETSUKUKU_TYPE_HELPER_CALLBACKS, NetsukukuHelperCallbacks));
	tasklet_callbacks = _tmp3_;
	tasklets_tasklet_declare_self ("peer_to_peer_start_replica");
	_tmp4_ = tasklet_callbacks->forward_callback;
	_tmp4__target = tasklet_callbacks->forward_callback_target;
	_tmp4_ (tasklet_obj1, NULL, _tmp4__target, &_inner_error_);
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		_g_object_unref0 (tasklet_callbacks);
		_g_object_unref0 (tasklet_obj1);
		return;
	}
	_g_object_unref0 (tasklet_callbacks);
	_g_object_unref0 (tasklet_obj1);
}


static void ____lambda6__tasklets_tasklet_callback (GObject* obj1, GObject* obj2, GObject* obj3, GObject* obj4, gpointer self, GError** error) {
	___lambda6_ (obj1, obj2, error);
}


static void ____lambda7_ (GObject* tpar1, GObject* tpar2, GObject* tpar3, GError** error) {
	GObject* _tmp0_;
	GObject* _tmp1_;
	GObject* tasklet_obj1;
	GObject* _tmp2_;
	GeeList* _tmp3_;
	GeeList* tasklet_replica_nodes;
	GObject* _tmp4_;
	NetsukukuHelperCallbacks* _tmp5_;
	NetsukukuHelperCallbacks* tasklet_callbacks;
	NetsukukuForwardRecordCallback _tmp6_;
	void* _tmp6__target;
	GeeList* _tmp7_;
	GError * _inner_error_ = NULL;
	_tmp0_ = tpar1;
	_tmp1_ = _g_object_ref0 (_tmp0_);
	tasklet_obj1 = _tmp1_;
	_tmp2_ = tpar2;
	_tmp3_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp2_, GEE_TYPE_LIST, GeeList));
	tasklet_replica_nodes = _tmp3_;
	_tmp4_ = tpar3;
	_tmp5_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp4_, NETSUKUKU_TYPE_HELPER_CALLBACKS, NetsukukuHelperCallbacks));
	tasklet_callbacks = _tmp5_;
	tasklets_tasklet_declare_self ("peer_to_peer_start_replica");
	_tmp6_ = tasklet_callbacks->forward_callback;
	_tmp6__target = tasklet_callbacks->forward_callback_target;
	_tmp7_ = _g_object_ref0 (tasklet_replica_nodes);
	_tmp6_ (tasklet_obj1, _tmp7_, _tmp6__target, &_inner_error_);
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		_g_object_unref0 (tasklet_callbacks);
		_g_object_unref0 (tasklet_replica_nodes);
		_g_object_unref0 (tasklet_obj1);
		return;
	}
	_g_object_unref0 (tasklet_callbacks);
	_g_object_unref0 (tasklet_replica_nodes);
	_g_object_unref0 (tasklet_obj1);
}


static void _____lambda7__tasklets_tasklet_callback (GObject* obj1, GObject* obj2, GObject* obj3, GObject* obj4, gpointer self, GError** error) {
	____lambda7_ (obj1, obj2, obj3, error);
}


void netsukuku_check_hash_and_start_replica (NetsukukuPeerToPeer* service, NetsukukuNIP* hash_nip, gboolean replicate, GObject* obj1, gint replica_nodes_max, NetsukukuAcceptRecordCallback accept_callback, void* accept_callback_target, NetsukukuForwardRecordCallback forward_callback, void* forward_callback_target, NetsukukuRefuseRecordCallback refuse_callback, void* refuse_callback_target, GError** error) {
	NetsukukuHelperCallbacks* _tmp0_;
	NetsukukuHelperCallbacks* callbacks;
	NetsukukuHelperCallbacks* _tmp1_;
	NetsukukuAcceptRecordCallback _tmp2_;
	void* _tmp2__target;
	NetsukukuHelperCallbacks* _tmp3_;
	NetsukukuForwardRecordCallback _tmp4_;
	void* _tmp4__target;
	NetsukukuHelperCallbacks* _tmp5_;
	NetsukukuRefuseRecordCallback _tmp6_;
	void* _tmp6__target;
	NetsukukuPeerToPeer* _tmp7_;
	NetsukukuNIP* _tmp8_;
	NetsukukuHCoord* _tmp9_ = NULL;
	NetsukukuHCoord* participant_hash_nip;
	NetsukukuHCoord* _tmp10_;
	GError * _inner_error_ = NULL;
	g_return_if_fail (service != NULL);
	g_return_if_fail (hash_nip != NULL);
	_tmp0_ = netsukuku_helper_callbacks_new ();
	callbacks = _tmp0_;
	_tmp1_ = callbacks;
	_tmp2_ = accept_callback;
	_tmp2__target = accept_callback_target;
	(_tmp1_->accept_callback_target_destroy_notify == NULL) ? NULL : (_tmp1_->accept_callback_target_destroy_notify (_tmp1_->accept_callback_target), NULL);
	_tmp1_->accept_callback = NULL;
	_tmp1_->accept_callback_target = NULL;
	_tmp1_->accept_callback_target_destroy_notify = NULL;
	_tmp1_->accept_callback = _tmp2_;
	_tmp1_->accept_callback_target = _tmp2__target;
	_tmp1_->accept_callback_target_destroy_notify = NULL;
	_tmp3_ = callbacks;
	_tmp4_ = forward_callback;
	_tmp4__target = forward_callback_target;
	(_tmp3_->forward_callback_target_destroy_notify == NULL) ? NULL : (_tmp3_->forward_callback_target_destroy_notify (_tmp3_->forward_callback_target), NULL);
	_tmp3_->forward_callback = NULL;
	_tmp3_->forward_callback_target = NULL;
	_tmp3_->forward_callback_target_destroy_notify = NULL;
	_tmp3_->forward_callback = _tmp4_;
	_tmp3_->forward_callback_target = _tmp4__target;
	_tmp3_->forward_callback_target_destroy_notify = NULL;
	_tmp5_ = callbacks;
	_tmp6_ = refuse_callback;
	_tmp6__target = refuse_callback_target;
	(_tmp5_->refuse_callback_target_destroy_notify == NULL) ? NULL : (_tmp5_->refuse_callback_target_destroy_notify (_tmp5_->refuse_callback_target), NULL);
	_tmp5_->refuse_callback = NULL;
	_tmp5_->refuse_callback_target = NULL;
	_tmp5_->refuse_callback_target_destroy_notify = NULL;
	_tmp5_->refuse_callback = _tmp6_;
	_tmp5_->refuse_callback_target = _tmp6__target;
	_tmp5_->refuse_callback_target_destroy_notify = NULL;
	_tmp7_ = service;
	_tmp8_ = hash_nip;
	_tmp9_ = netsukuku_peer_to_peer_search_participant (_tmp7_, _tmp8_, 1, &_inner_error_);
	participant_hash_nip = _tmp9_;
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == NETSUKUKU_PEER_REFUSE_SERVICE_ERROR) {
			g_propagate_error (error, _inner_error_);
			_g_object_unref0 (callbacks);
			return;
		} else {
			_g_object_unref0 (callbacks);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
	}
	_tmp10_ = participant_hash_nip;
	if (_tmp10_ == NULL) {
		NetsukukuAcceptRecordCallback _tmp11_;
		void* _tmp11__target;
		gboolean _tmp12_ = FALSE;
		gboolean confirm;
		gboolean _tmp13_;
		gboolean _tmp14_;
		GObject* _tmp15_;
		NetsukukuHelperCallbacks* _tmp16_;
		TaskletsTasklet* _tmp17_ = NULL;
		TaskletsTasklet* _tmp18_;
		_tmp11_ = accept_callback;
		_tmp11__target = accept_callback_target;
		_tmp12_ = _tmp11_ (_tmp11__target, &_inner_error_);
		confirm = _tmp12_;
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == NETSUKUKU_PEER_REFUSE_SERVICE_ERROR) {
				g_propagate_error (error, _inner_error_);
				_g_object_unref0 (participant_hash_nip);
				_g_object_unref0 (callbacks);
				return;
			} else {
				_g_object_unref0 (participant_hash_nip);
				_g_object_unref0 (callbacks);
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return;
			}
		}
		_tmp13_ = confirm;
		if (!_tmp13_) {
			_g_object_unref0 (participant_hash_nip);
			_g_object_unref0 (callbacks);
			return;
		}
		_tmp14_ = replicate;
		if (!_tmp14_) {
			_g_object_unref0 (participant_hash_nip);
			_g_object_unref0 (callbacks);
			return;
		}
		_tmp15_ = obj1;
		_tmp16_ = callbacks;
		_tmp17_ = tasklets_tasklet_tasklet_callback (____lambda6__tasklets_tasklet_callback, NULL, _tmp15_, (GObject*) _tmp16_, NULL, NULL);
		_tmp18_ = _tmp17_;
		_g_object_unref0 (_tmp18_);
	} else {
		NetsukukuPeerToPeer* _tmp19_;
		NetsukukuNIP* _tmp20_;
		gint _tmp21_;
		GeeList* _tmp22_ = NULL;
		GeeList* replica_nodes;
		GeeList* _tmp23_;
		NetsukukuPeerToPeer* _tmp24_;
		NetsukukuMapRoute* _tmp25_;
		NetsukukuNIP* _tmp26_;
		NetsukukuNIP* _tmp27_;
		gboolean _tmp28_ = FALSE;
		_tmp19_ = service;
		_tmp20_ = hash_nip;
		_tmp21_ = replica_nodes_max;
		_tmp22_ = netsukuku_peer_to_peer_find_nearest_to_register (_tmp19_, _tmp20_, _tmp21_, NULL, &_inner_error_);
		replica_nodes = _tmp22_;
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == NETSUKUKU_PEER_REFUSE_SERVICE_ERROR) {
				g_propagate_error (error, _inner_error_);
				_g_object_unref0 (participant_hash_nip);
				_g_object_unref0 (callbacks);
				return;
			} else {
				_g_object_unref0 (participant_hash_nip);
				_g_object_unref0 (callbacks);
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return;
			}
		}
		_tmp23_ = replica_nodes;
		_tmp24_ = service;
		_tmp25_ = _tmp24_->maproute;
		_tmp26_ = netsukuku_map_get_me ((NetsukukuMap*) _tmp25_);
		_tmp27_ = _tmp26_;
		_tmp28_ = gee_collection_contains ((GeeCollection*) _tmp23_, _tmp27_);
		if (_tmp28_) {
			NetsukukuAcceptRecordCallback _tmp29_;
			void* _tmp29__target;
			gboolean _tmp30_ = FALSE;
			gboolean confirm;
			gboolean _tmp31_;
			gboolean _tmp32_;
			GObject* _tmp33_;
			GeeList* _tmp34_;
			NetsukukuHelperCallbacks* _tmp35_;
			TaskletsTasklet* _tmp36_ = NULL;
			TaskletsTasklet* _tmp37_;
			_tmp29_ = accept_callback;
			_tmp29__target = accept_callback_target;
			_tmp30_ = _tmp29_ (_tmp29__target, &_inner_error_);
			confirm = _tmp30_;
			if (_inner_error_ != NULL) {
				if (_inner_error_->domain == NETSUKUKU_PEER_REFUSE_SERVICE_ERROR) {
					g_propagate_error (error, _inner_error_);
					_g_object_unref0 (replica_nodes);
					_g_object_unref0 (participant_hash_nip);
					_g_object_unref0 (callbacks);
					return;
				} else {
					_g_object_unref0 (replica_nodes);
					_g_object_unref0 (participant_hash_nip);
					_g_object_unref0 (callbacks);
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
					g_clear_error (&_inner_error_);
					return;
				}
			}
			_tmp31_ = confirm;
			if (!_tmp31_) {
				_g_object_unref0 (replica_nodes);
				_g_object_unref0 (participant_hash_nip);
				_g_object_unref0 (callbacks);
				return;
			}
			_tmp32_ = replicate;
			if (!_tmp32_) {
				_g_object_unref0 (replica_nodes);
				_g_object_unref0 (participant_hash_nip);
				_g_object_unref0 (callbacks);
				return;
			}
			_tmp33_ = obj1;
			_tmp34_ = replica_nodes;
			_tmp35_ = callbacks;
			_tmp36_ = tasklets_tasklet_tasklet_callback (_____lambda7__tasklets_tasklet_callback, NULL, _tmp33_, (GObject*) _tmp34_, (GObject*) _tmp35_, NULL);
			_tmp37_ = _tmp36_;
			_g_object_unref0 (_tmp37_);
		} else {
			gboolean _tmp38_;
			NetsukukuRefuseRecordCallback _tmp39_;
			void* _tmp39__target;
			GError* _tmp41_;
			_tmp38_ = replicate;
			if (!_tmp38_) {
				_g_object_unref0 (replica_nodes);
				_g_object_unref0 (participant_hash_nip);
				_g_object_unref0 (callbacks);
				return;
			}
			_tmp39_ = refuse_callback;
			_tmp39__target = refuse_callback_target;
			if (_tmp39_ != NULL) {
				NetsukukuRefuseRecordCallback _tmp40_;
				void* _tmp40__target;
				_tmp40_ = refuse_callback;
				_tmp40__target = refuse_callback_target;
				_tmp40_ (_tmp40__target, &_inner_error_);
				if (_inner_error_ != NULL) {
					if (_inner_error_->domain == NETSUKUKU_PEER_REFUSE_SERVICE_ERROR) {
						g_propagate_error (error, _inner_error_);
						_g_object_unref0 (replica_nodes);
						_g_object_unref0 (participant_hash_nip);
						_g_object_unref0 (callbacks);
						return;
					} else {
						_g_object_unref0 (replica_nodes);
						_g_object_unref0 (participant_hash_nip);
						_g_object_unref0 (callbacks);
						g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
						g_clear_error (&_inner_error_);
						return;
					}
				}
			}
			_tmp41_ = g_error_new_literal (NETSUKUKU_PEER_REFUSE_SERVICE_ERROR, NETSUKUKU_PEER_REFUSE_SERVICE_ERROR_GENERIC, "The node is not one of the nearest to the perfect hash.");
			_inner_error_ = _tmp41_;
			if (_inner_error_->domain == NETSUKUKU_PEER_REFUSE_SERVICE_ERROR) {
				g_propagate_error (error, _inner_error_);
				_g_object_unref0 (replica_nodes);
				_g_object_unref0 (participant_hash_nip);
				_g_object_unref0 (callbacks);
				return;
			} else {
				_g_object_unref0 (replica_nodes);
				_g_object_unref0 (participant_hash_nip);
				_g_object_unref0 (callbacks);
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return;
			}
		}
		_g_object_unref0 (replica_nodes);
	}
	_g_object_unref0 (participant_hash_nip);
	_g_object_unref0 (callbacks);
}



