/* andna.c generated by valac 0.20.1, the Vala compiler
 * generated from andna.vala, do not modify */

/*
 *  This file is part of Netsukuku.
 *  (c) Copyright 2011-2014 Luca Dionisi aka lukisi <luca.dionisi@gmail.com>
 *
 *  Netsukuku is free software: you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation, either version 3 of the License, or
 *  (at your option) any later version.
 *
 *  Netsukuku is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with Netsukuku.  If not, see <http://www.gnu.org/licenses/>.
 */
/*   peerbuilder.in
errors:
 HookingError
  INEXISTENT_GNODE
  GENERIC
 QspnError
  NOT_YOUR_GATEWAY
  ALREADY_UP_TO_DATE
  GENERIC
 PeerRefuseServiceError
  GENERIC
 TunnelError
  GENERIC
 BorderNodesError
  WRONG_GNODE
  NOT_BORDER_NODE
  WILL_NOT_TUNNEL
  TIMEOUT
  GENERIC
 AndnaError
  GENERIC
serializables:
 TimeCapsule
 ParticipantNode
 PackedParticipantNodes
 OptionalServiceParticipants
 SetOptionalServiceParticipants
 PeerToPeerTracerPacketList
 PairNipDistance
 BnodeRecord
 BnodeList
 PairLvlNumberOfFreeNodes
 HCoord
 PartialNIP
 NIP
 REM
 NullREM
 DeadREM
 AlmostDeadREM
 RTT
 TracerPacketList
 RouteInSet
 PositionInRoutesSetPerLevel
 RoutesSetPerLevel
 RoutesSet
 ExtendedTracerPacket
 GNodeID
 NetworkID
 InfoNeighbour
 InfoRoute
 InfoNode
 QspnStats
 InfoBorderNode
 PublicKey
 AndnaServiceKey
 AndnaServerRecord
 AndnaDomainRecord
 AndnaServer
 AndnaServers
 RegisterHostnameArguments
 CounterNipRecord
 CounterSetDataResponse
 CounterCheckHostnameResponse
 AndnaConfirmPubkResponse
 AndnaRegisterMainResponse
 AndnaRegisterSpreadResponse
 AndnaGetServersResponse
 AndnaGetRegistrarResponse
 AndnaGetCacheRecordsResponse
 BroadcastID
 UnicastID
peers:
 Andna
  methods:
   AndnaRegisterMainResponse register_main_for_pubk
    arguments:
     AndnaDomainRequest request
     SerializableBuffer signature
     bool replicate
    throws:
     PeerRefuseServiceError
   AndnaGetRegistrarResponse? get_registrar
    arguments:
     string hashed_domain
    throws:
     PeerRefuseServiceError
   AndnaDomainRecord? get_domain_record
    arguments:
     string hashed_domain
    throws:
     PeerRefuseServiceError
   AndnaRegisterSpreadResponse register_spread_record
    arguments:
     string hashed_domain
     int spread_number
     bool replicate
    throws:
     PeerRefuseServiceError
   AndnaGetServersResponse get_servers
    arguments:
     string hashed_domain
     AndnaServiceKey srv_key
     int spread_number
     bool chain
    throws:
     PeerRefuseServiceError
   AndnaGetCacheRecordsResponse get_cache_records
    arguments:
    throws:
     PeerRefuseServiceError
*/

#include <glib.h>
#include <glib-object.h>
#include <netsukuku-rpc.h>
#include <zcd.h>
#include <stdlib.h>
#include <string.h>
#include <tasklet.h>
#include <gee.h>
#include <unistd.h>


#define NETSUKUKU_TYPE_IANDNA_AS_PEER (netsukuku_iandna_as_peer_get_type ())
#define NETSUKUKU_IANDNA_AS_PEER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), NETSUKUKU_TYPE_IANDNA_AS_PEER, NetsukukuIAndnaAsPeer))
#define NETSUKUKU_IS_IANDNA_AS_PEER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), NETSUKUKU_TYPE_IANDNA_AS_PEER))
#define NETSUKUKU_IANDNA_AS_PEER_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), NETSUKUKU_TYPE_IANDNA_AS_PEER, NetsukukuIAndnaAsPeerIface))

typedef struct _NetsukukuIAndnaAsPeer NetsukukuIAndnaAsPeer;
typedef struct _NetsukukuIAndnaAsPeerIface NetsukukuIAndnaAsPeerIface;

#define NETSUKUKU_TYPE_RMT_PEER (netsukuku_rmt_peer_get_type ())
#define NETSUKUKU_RMT_PEER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), NETSUKUKU_TYPE_RMT_PEER, NetsukukuRmtPeer))
#define NETSUKUKU_RMT_PEER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), NETSUKUKU_TYPE_RMT_PEER, NetsukukuRmtPeerClass))
#define NETSUKUKU_IS_RMT_PEER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), NETSUKUKU_TYPE_RMT_PEER))
#define NETSUKUKU_IS_RMT_PEER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), NETSUKUKU_TYPE_RMT_PEER))
#define NETSUKUKU_RMT_PEER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), NETSUKUKU_TYPE_RMT_PEER, NetsukukuRmtPeerClass))

typedef struct _NetsukukuRmtPeer NetsukukuRmtPeer;
typedef struct _NetsukukuRmtPeerClass NetsukukuRmtPeerClass;
typedef struct _NetsukukuRmtPeerPrivate NetsukukuRmtPeerPrivate;

#define NETSUKUKU_TYPE_RMT_ANDNA_PEER (netsukuku_rmt_andna_peer_get_type ())
#define NETSUKUKU_RMT_ANDNA_PEER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), NETSUKUKU_TYPE_RMT_ANDNA_PEER, NetsukukuRmtAndnaPeer))
#define NETSUKUKU_RMT_ANDNA_PEER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), NETSUKUKU_TYPE_RMT_ANDNA_PEER, NetsukukuRmtAndnaPeerClass))
#define NETSUKUKU_IS_RMT_ANDNA_PEER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), NETSUKUKU_TYPE_RMT_ANDNA_PEER))
#define NETSUKUKU_IS_RMT_ANDNA_PEER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), NETSUKUKU_TYPE_RMT_ANDNA_PEER))
#define NETSUKUKU_RMT_ANDNA_PEER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), NETSUKUKU_TYPE_RMT_ANDNA_PEER, NetsukukuRmtAndnaPeerClass))

typedef struct _NetsukukuRmtAndnaPeer NetsukukuRmtAndnaPeer;
typedef struct _NetsukukuRmtAndnaPeerClass NetsukukuRmtAndnaPeerClass;
typedef struct _NetsukukuRmtAndnaPeerPrivate NetsukukuRmtAndnaPeerPrivate;

#define NETSUKUKU_TYPE_PEER_TO_PEER (netsukuku_peer_to_peer_get_type ())
#define NETSUKUKU_PEER_TO_PEER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), NETSUKUKU_TYPE_PEER_TO_PEER, NetsukukuPeerToPeer))
#define NETSUKUKU_PEER_TO_PEER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), NETSUKUKU_TYPE_PEER_TO_PEER, NetsukukuPeerToPeerClass))
#define NETSUKUKU_IS_PEER_TO_PEER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), NETSUKUKU_TYPE_PEER_TO_PEER))
#define NETSUKUKU_IS_PEER_TO_PEER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), NETSUKUKU_TYPE_PEER_TO_PEER))
#define NETSUKUKU_PEER_TO_PEER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), NETSUKUKU_TYPE_PEER_TO_PEER, NetsukukuPeerToPeerClass))

typedef struct _NetsukukuPeerToPeer NetsukukuPeerToPeer;
typedef struct _NetsukukuPeerToPeerClass NetsukukuPeerToPeerClass;

#define NETSUKUKU_TYPE_AGGREGATED_NEIGHBOUR (netsukuku_aggregated_neighbour_get_type ())
#define NETSUKUKU_AGGREGATED_NEIGHBOUR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), NETSUKUKU_TYPE_AGGREGATED_NEIGHBOUR, NetsukukuAggregatedNeighbour))
#define NETSUKUKU_AGGREGATED_NEIGHBOUR_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), NETSUKUKU_TYPE_AGGREGATED_NEIGHBOUR, NetsukukuAggregatedNeighbourClass))
#define NETSUKUKU_IS_AGGREGATED_NEIGHBOUR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), NETSUKUKU_TYPE_AGGREGATED_NEIGHBOUR))
#define NETSUKUKU_IS_AGGREGATED_NEIGHBOUR_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), NETSUKUKU_TYPE_AGGREGATED_NEIGHBOUR))
#define NETSUKUKU_AGGREGATED_NEIGHBOUR_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), NETSUKUKU_TYPE_AGGREGATED_NEIGHBOUR, NetsukukuAggregatedNeighbourClass))

typedef struct _NetsukukuAggregatedNeighbour NetsukukuAggregatedNeighbour;
typedef struct _NetsukukuAggregatedNeighbourClass NetsukukuAggregatedNeighbourClass;
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))

#define NETSUKUKU_TYPE_ANDNA_SERVICE_HASHNODE_KEY (netsukuku_andna_service_hashnode_key_get_type ())
#define NETSUKUKU_ANDNA_SERVICE_HASHNODE_KEY(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), NETSUKUKU_TYPE_ANDNA_SERVICE_HASHNODE_KEY, NetsukukuAndnaServiceHashnodeKey))
#define NETSUKUKU_ANDNA_SERVICE_HASHNODE_KEY_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), NETSUKUKU_TYPE_ANDNA_SERVICE_HASHNODE_KEY, NetsukukuAndnaServiceHashnodeKeyClass))
#define NETSUKUKU_IS_ANDNA_SERVICE_HASHNODE_KEY(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), NETSUKUKU_TYPE_ANDNA_SERVICE_HASHNODE_KEY))
#define NETSUKUKU_IS_ANDNA_SERVICE_HASHNODE_KEY_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), NETSUKUKU_TYPE_ANDNA_SERVICE_HASHNODE_KEY))
#define NETSUKUKU_ANDNA_SERVICE_HASHNODE_KEY_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), NETSUKUKU_TYPE_ANDNA_SERVICE_HASHNODE_KEY, NetsukukuAndnaServiceHashnodeKeyClass))

typedef struct _NetsukukuAndnaServiceHashnodeKey NetsukukuAndnaServiceHashnodeKey;
typedef struct _NetsukukuAndnaServiceHashnodeKeyClass NetsukukuAndnaServiceHashnodeKeyClass;
typedef struct _NetsukukuAndnaServiceHashnodeKeyPrivate NetsukukuAndnaServiceHashnodeKeyPrivate;

#define NETSUKUKU_TYPE_ARGUMENTS_FOR_DUPLICATION_REGISTER_SPREAD (netsukuku_arguments_for_duplication_register_spread_get_type ())
#define NETSUKUKU_ARGUMENTS_FOR_DUPLICATION_REGISTER_SPREAD(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), NETSUKUKU_TYPE_ARGUMENTS_FOR_DUPLICATION_REGISTER_SPREAD, NetsukukuArgumentsForDuplicationRegisterSpread))
#define NETSUKUKU_ARGUMENTS_FOR_DUPLICATION_REGISTER_SPREAD_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), NETSUKUKU_TYPE_ARGUMENTS_FOR_DUPLICATION_REGISTER_SPREAD, NetsukukuArgumentsForDuplicationRegisterSpreadClass))
#define NETSUKUKU_IS_ARGUMENTS_FOR_DUPLICATION_REGISTER_SPREAD(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), NETSUKUKU_TYPE_ARGUMENTS_FOR_DUPLICATION_REGISTER_SPREAD))
#define NETSUKUKU_IS_ARGUMENTS_FOR_DUPLICATION_REGISTER_SPREAD_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), NETSUKUKU_TYPE_ARGUMENTS_FOR_DUPLICATION_REGISTER_SPREAD))
#define NETSUKUKU_ARGUMENTS_FOR_DUPLICATION_REGISTER_SPREAD_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), NETSUKUKU_TYPE_ARGUMENTS_FOR_DUPLICATION_REGISTER_SPREAD, NetsukukuArgumentsForDuplicationRegisterSpreadClass))

typedef struct _NetsukukuArgumentsForDuplicationRegisterSpread NetsukukuArgumentsForDuplicationRegisterSpread;
typedef struct _NetsukukuArgumentsForDuplicationRegisterSpreadClass NetsukukuArgumentsForDuplicationRegisterSpreadClass;
typedef struct _NetsukukuArgumentsForDuplicationRegisterSpreadPrivate NetsukukuArgumentsForDuplicationRegisterSpreadPrivate;

#define NETSUKUKU_TYPE_ARGUMENTS_FOR_DUPLICATION_REGISTER_MAIN (netsukuku_arguments_for_duplication_register_main_get_type ())
#define NETSUKUKU_ARGUMENTS_FOR_DUPLICATION_REGISTER_MAIN(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), NETSUKUKU_TYPE_ARGUMENTS_FOR_DUPLICATION_REGISTER_MAIN, NetsukukuArgumentsForDuplicationRegisterMain))
#define NETSUKUKU_ARGUMENTS_FOR_DUPLICATION_REGISTER_MAIN_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), NETSUKUKU_TYPE_ARGUMENTS_FOR_DUPLICATION_REGISTER_MAIN, NetsukukuArgumentsForDuplicationRegisterMainClass))
#define NETSUKUKU_IS_ARGUMENTS_FOR_DUPLICATION_REGISTER_MAIN(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), NETSUKUKU_TYPE_ARGUMENTS_FOR_DUPLICATION_REGISTER_MAIN))
#define NETSUKUKU_IS_ARGUMENTS_FOR_DUPLICATION_REGISTER_MAIN_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), NETSUKUKU_TYPE_ARGUMENTS_FOR_DUPLICATION_REGISTER_MAIN))
#define NETSUKUKU_ARGUMENTS_FOR_DUPLICATION_REGISTER_MAIN_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), NETSUKUKU_TYPE_ARGUMENTS_FOR_DUPLICATION_REGISTER_MAIN, NetsukukuArgumentsForDuplicationRegisterMainClass))

typedef struct _NetsukukuArgumentsForDuplicationRegisterMain NetsukukuArgumentsForDuplicationRegisterMain;
typedef struct _NetsukukuArgumentsForDuplicationRegisterMainClass NetsukukuArgumentsForDuplicationRegisterMainClass;
typedef struct _NetsukukuArgumentsForDuplicationRegisterMainPrivate NetsukukuArgumentsForDuplicationRegisterMainPrivate;

#define NETSUKUKU_TYPE_DOMAIN_WANTED (netsukuku_domain_wanted_get_type ())
#define NETSUKUKU_DOMAIN_WANTED(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), NETSUKUKU_TYPE_DOMAIN_WANTED, NetsukukuDomainWanted))
#define NETSUKUKU_DOMAIN_WANTED_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), NETSUKUKU_TYPE_DOMAIN_WANTED, NetsukukuDomainWantedClass))
#define NETSUKUKU_IS_DOMAIN_WANTED(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), NETSUKUKU_TYPE_DOMAIN_WANTED))
#define NETSUKUKU_IS_DOMAIN_WANTED_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), NETSUKUKU_TYPE_DOMAIN_WANTED))
#define NETSUKUKU_DOMAIN_WANTED_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), NETSUKUKU_TYPE_DOMAIN_WANTED, NetsukukuDomainWantedClass))

typedef struct _NetsukukuDomainWanted NetsukukuDomainWanted;
typedef struct _NetsukukuDomainWantedClass NetsukukuDomainWantedClass;
typedef struct _NetsukukuDomainWantedPrivate NetsukukuDomainWantedPrivate;
typedef struct _NetsukukuPeerToPeerPrivate NetsukukuPeerToPeerPrivate;

#define NETSUKUKU_TYPE_MAP_ROUTE (netsukuku_map_route_get_type ())
#define NETSUKUKU_MAP_ROUTE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), NETSUKUKU_TYPE_MAP_ROUTE, NetsukukuMapRoute))
#define NETSUKUKU_MAP_ROUTE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), NETSUKUKU_TYPE_MAP_ROUTE, NetsukukuMapRouteClass))
#define NETSUKUKU_IS_MAP_ROUTE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), NETSUKUKU_TYPE_MAP_ROUTE))
#define NETSUKUKU_IS_MAP_ROUTE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), NETSUKUKU_TYPE_MAP_ROUTE))
#define NETSUKUKU_MAP_ROUTE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), NETSUKUKU_TYPE_MAP_ROUTE, NetsukukuMapRouteClass))

typedef struct _NetsukukuMapRoute NetsukukuMapRoute;
typedef struct _NetsukukuMapRouteClass NetsukukuMapRouteClass;

#define NETSUKUKU_TYPE_ANDNA (netsukuku_andna_get_type ())
#define NETSUKUKU_ANDNA(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), NETSUKUKU_TYPE_ANDNA, NetsukukuAndna))
#define NETSUKUKU_ANDNA_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), NETSUKUKU_TYPE_ANDNA, NetsukukuAndnaClass))
#define NETSUKUKU_IS_ANDNA(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), NETSUKUKU_TYPE_ANDNA))
#define NETSUKUKU_IS_ANDNA_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), NETSUKUKU_TYPE_ANDNA))
#define NETSUKUKU_ANDNA_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), NETSUKUKU_TYPE_ANDNA, NetsukukuAndnaClass))

typedef struct _NetsukukuAndna NetsukukuAndna;
typedef struct _NetsukukuAndnaClass NetsukukuAndnaClass;
typedef struct _NetsukukuAndnaPrivate NetsukukuAndnaPrivate;

#define NETSUKUKU_TYPE_PEER_TO_PEER_ALL (netsukuku_peer_to_peer_all_get_type ())
#define NETSUKUKU_PEER_TO_PEER_ALL(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), NETSUKUKU_TYPE_PEER_TO_PEER_ALL, NetsukukuPeerToPeerAll))
#define NETSUKUKU_PEER_TO_PEER_ALL_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), NETSUKUKU_TYPE_PEER_TO_PEER_ALL, NetsukukuPeerToPeerAllClass))
#define NETSUKUKU_IS_PEER_TO_PEER_ALL(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), NETSUKUKU_TYPE_PEER_TO_PEER_ALL))
#define NETSUKUKU_IS_PEER_TO_PEER_ALL_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), NETSUKUKU_TYPE_PEER_TO_PEER_ALL))
#define NETSUKUKU_PEER_TO_PEER_ALL_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), NETSUKUKU_TYPE_PEER_TO_PEER_ALL, NetsukukuPeerToPeerAllClass))

typedef struct _NetsukukuPeerToPeerAll NetsukukuPeerToPeerAll;
typedef struct _NetsukukuPeerToPeerAllClass NetsukukuPeerToPeerAllClass;

#define NETSUKUKU_TYPE_COUNTER (netsukuku_counter_get_type ())
#define NETSUKUKU_COUNTER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), NETSUKUKU_TYPE_COUNTER, NetsukukuCounter))
#define NETSUKUKU_COUNTER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), NETSUKUKU_TYPE_COUNTER, NetsukukuCounterClass))
#define NETSUKUKU_IS_COUNTER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), NETSUKUKU_TYPE_COUNTER))
#define NETSUKUKU_IS_COUNTER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), NETSUKUKU_TYPE_COUNTER))
#define NETSUKUKU_COUNTER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), NETSUKUKU_TYPE_COUNTER, NetsukukuCounterClass))

typedef struct _NetsukukuCounter NetsukukuCounter;
typedef struct _NetsukukuCounterClass NetsukukuCounterClass;

#define NETSUKUKU_TYPE_KEY_PAIR (netsukuku_key_pair_get_type ())
#define NETSUKUKU_KEY_PAIR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), NETSUKUKU_TYPE_KEY_PAIR, NetsukukuKeyPair))
#define NETSUKUKU_KEY_PAIR_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), NETSUKUKU_TYPE_KEY_PAIR, NetsukukuKeyPairClass))
#define NETSUKUKU_IS_KEY_PAIR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), NETSUKUKU_TYPE_KEY_PAIR))
#define NETSUKUKU_IS_KEY_PAIR_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), NETSUKUKU_TYPE_KEY_PAIR))
#define NETSUKUKU_KEY_PAIR_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), NETSUKUKU_TYPE_KEY_PAIR, NetsukukuKeyPairClass))

typedef struct _NetsukukuKeyPair NetsukukuKeyPair;
typedef struct _NetsukukuKeyPairClass NetsukukuKeyPairClass;

#define NETSUKUKU_TYPE_AGGREGATED_NEIGHBOUR_MANAGER (netsukuku_aggregated_neighbour_manager_get_type ())
#define NETSUKUKU_AGGREGATED_NEIGHBOUR_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), NETSUKUKU_TYPE_AGGREGATED_NEIGHBOUR_MANAGER, NetsukukuAggregatedNeighbourManager))
#define NETSUKUKU_AGGREGATED_NEIGHBOUR_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), NETSUKUKU_TYPE_AGGREGATED_NEIGHBOUR_MANAGER, NetsukukuAggregatedNeighbourManagerClass))
#define NETSUKUKU_IS_AGGREGATED_NEIGHBOUR_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), NETSUKUKU_TYPE_AGGREGATED_NEIGHBOUR_MANAGER))
#define NETSUKUKU_IS_AGGREGATED_NEIGHBOUR_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), NETSUKUKU_TYPE_AGGREGATED_NEIGHBOUR_MANAGER))
#define NETSUKUKU_AGGREGATED_NEIGHBOUR_MANAGER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), NETSUKUKU_TYPE_AGGREGATED_NEIGHBOUR_MANAGER, NetsukukuAggregatedNeighbourManagerClass))

typedef struct _NetsukukuAggregatedNeighbourManager NetsukukuAggregatedNeighbourManager;
typedef struct _NetsukukuAggregatedNeighbourManagerClass NetsukukuAggregatedNeighbourManagerClass;
typedef struct _NetsukukuMapRoutePrivate NetsukukuMapRoutePrivate;

#define NETSUKUKU_TYPE_PUBLIC_KEY_WRAPPER (netsukuku_public_key_wrapper_get_type ())
#define NETSUKUKU_PUBLIC_KEY_WRAPPER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), NETSUKUKU_TYPE_PUBLIC_KEY_WRAPPER, NetsukukuPublicKeyWrapper))
#define NETSUKUKU_PUBLIC_KEY_WRAPPER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), NETSUKUKU_TYPE_PUBLIC_KEY_WRAPPER, NetsukukuPublicKeyWrapperClass))
#define NETSUKUKU_IS_PUBLIC_KEY_WRAPPER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), NETSUKUKU_TYPE_PUBLIC_KEY_WRAPPER))
#define NETSUKUKU_IS_PUBLIC_KEY_WRAPPER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), NETSUKUKU_TYPE_PUBLIC_KEY_WRAPPER))
#define NETSUKUKU_PUBLIC_KEY_WRAPPER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), NETSUKUKU_TYPE_PUBLIC_KEY_WRAPPER, NetsukukuPublicKeyWrapperClass))

typedef struct _NetsukukuPublicKeyWrapper NetsukukuPublicKeyWrapper;
typedef struct _NetsukukuPublicKeyWrapperClass NetsukukuPublicKeyWrapperClass;
typedef struct _Block1Data Block1Data;
typedef struct _Block2Data Block2Data;
#define _g_string_free0(var) ((var == NULL) ? NULL : (var = (g_string_free (var, TRUE), NULL)))
#define _vala_assert(expr, msg) if G_LIKELY (expr) ; else g_assertion_message_expr (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);

struct _NetsukukuIAndnaAsPeerIface {
	GTypeInterface parent_iface;
	NetsukukuAndnaRegisterMainResponse* (*register_main_for_pubk) (NetsukukuIAndnaAsPeer* self, NetsukukuAndnaDomainRequest* request, zcdSerializableBuffer* signature, gboolean replicate, GError** error);
	NetsukukuAndnaGetRegistrarResponse* (*get_registrar) (NetsukukuIAndnaAsPeer* self, const gchar* hashed_domain, GError** error);
	NetsukukuAndnaDomainRecord* (*get_domain_record) (NetsukukuIAndnaAsPeer* self, const gchar* hashed_domain, GError** error);
	NetsukukuAndnaRegisterSpreadResponse* (*register_spread_record) (NetsukukuIAndnaAsPeer* self, const gchar* hashed_domain, gint spread_number, gboolean replicate, GError** error);
	NetsukukuAndnaGetServersResponse* (*get_servers) (NetsukukuIAndnaAsPeer* self, const gchar* hashed_domain, NetsukukuAndnaServiceKey* srv_key, gint spread_number, gboolean chain, GError** error);
	NetsukukuAndnaGetCacheRecordsResponse* (*get_cache_records) (NetsukukuIAndnaAsPeer* self, GError** error);
};

struct _NetsukukuRmtPeer {
	GObject parent_instance;
	NetsukukuRmtPeerPrivate * priv;
};

struct _NetsukukuRmtPeerClass {
	GObjectClass parent_class;
	zcdISerializable* (*rmt) (NetsukukuRmtPeer* self, zcdRemoteCall* data, GError** error);
};

struct _NetsukukuRmtAndnaPeer {
	NetsukukuRmtPeer parent_instance;
	NetsukukuRmtAndnaPeerPrivate * priv;
};

struct _NetsukukuRmtAndnaPeerClass {
	NetsukukuRmtPeerClass parent_class;
};

struct _NetsukukuAndnaServiceHashnodeKey {
	GObject parent_instance;
	NetsukukuAndnaServiceHashnodeKeyPrivate * priv;
};

struct _NetsukukuAndnaServiceHashnodeKeyClass {
	GObjectClass parent_class;
};

struct _NetsukukuAndnaServiceHashnodeKeyPrivate {
	gchar* _hashed_domain;
	gint _spread_num;
};

struct _NetsukukuArgumentsForDuplicationRegisterSpread {
	GObject parent_instance;
	NetsukukuArgumentsForDuplicationRegisterSpreadPrivate * priv;
	gchar* hashed_domain;
	gint spread_number;
	NetsukukuNIP* hashnode;
};

struct _NetsukukuArgumentsForDuplicationRegisterSpreadClass {
	GObjectClass parent_class;
};

struct _NetsukukuArgumentsForDuplicationRegisterMain {
	GObject parent_instance;
	NetsukukuArgumentsForDuplicationRegisterMainPrivate * priv;
	NetsukukuAndnaDomainRequest* request;
	zcdSerializableBuffer* signature;
	NetsukukuNIP* hashnode;
};

struct _NetsukukuArgumentsForDuplicationRegisterMainClass {
	GObjectClass parent_class;
};

struct _NetsukukuDomainWanted {
	GObject parent_instance;
	NetsukukuDomainWantedPrivate * priv;
	gchar* hostname;
	NetsukukuTimeCapsule* ttl_before_request;
	TaskletsTasklet* tasklet;
	gboolean registered;
};

struct _NetsukukuDomainWantedClass {
	GObjectClass parent_class;
};

struct _NetsukukuPeerToPeer {
	GObject parent_instance;
	NetsukukuPeerToPeerPrivate * priv;
	NetsukukuMapRoute* maproute;
};

struct _NetsukukuPeerToPeerClass {
	GObjectClass parent_class;
	zcdISerializable* (*_dispatch) (NetsukukuPeerToPeer* self, GObject* caller, zcdRemoteCall* data, GError** error);
	NetsukukuNIP* (*h) (NetsukukuPeerToPeer* self, GObject* key);
};

struct _NetsukukuAndna {
	NetsukukuPeerToPeer parent_instance;
	NetsukukuAndnaPrivate * priv;
	gboolean memory_initialized;
};

struct _NetsukukuAndnaClass {
	NetsukukuPeerToPeerClass parent_class;
};

struct _NetsukukuAndnaPrivate {
	NetsukukuAndnaPrivateConfigurationList* _configuration;
	NetsukukuPeerToPeerAll* peer_to_peer_all;
	NetsukukuCounter* counter;
	NetsukukuKeyPair* my_keys;
	GeeHashMap* request_queue;
	GeeHashMap* cache;
	GeeArrayList* lst_domains;
	NetsukukuPublicKey* _mypubk;
};

typedef enum  {
	NETSUKUKU_PEER_TO_PEER_ERROR_REGISTER,
	NETSUKUKU_PEER_TO_PEER_ERROR_GENERIC
} NetsukukuPeerToPeerError;
#define NETSUKUKU_PEER_TO_PEER_ERROR netsukuku_peer_to_peer_error_quark ()
struct _NetsukukuMapRoute {
	GObject parent_instance;
	NetsukukuMapRoutePrivate * priv;
	gint levels;
	gint gsize;
	NetsukukuNIP* me;
};

struct _NetsukukuMapRouteClass {
	GObjectClass parent_class;
};

typedef enum  {
	NETSUKUKU_CRYPTO_GCRYPT_ERROR_FAILED
} NetsukukuCryptoGCryptError;
#define NETSUKUKU_CRYPTO_GCRYPT_ERROR netsukuku_crypto_gcrypt_error_quark ()
struct _Block1Data {
	int _ref_count_;
	NetsukukuAndna * self;
	gchar* response_msg;
	NetsukukuTimeCapsule* response_ttl;
	NetsukukuAndnaDomainRequest* request;
	zcdSerializableBuffer* signature;
};

typedef gboolean (*NetsukukuAcceptRecordCallback) (void* user_data, GError** error);
typedef void (*NetsukukuForwardRecordCallback) (GObject* obj1, GeeList* replica_nodes, void* user_data, GError** error);
typedef void (*NetsukukuRefuseRecordCallback) (void* user_data, GError** error);
struct _Block2Data {
	int _ref_count_;
	NetsukukuAndna * self;
	gboolean response_response;
	gchar* response_msg;
	NetsukukuArgumentsForDuplicationRegisterSpread* rec;
};


static gpointer netsukuku_rmt_andna_peer_parent_class = NULL;
static NetsukukuIAndnaAsPeerIface* netsukuku_rmt_andna_peer_netsukuku_iandna_as_peer_parent_iface = NULL;
static gpointer netsukuku_andna_service_hashnode_key_parent_class = NULL;
static gpointer netsukuku_arguments_for_duplication_register_spread_parent_class = NULL;
static gpointer netsukuku_arguments_for_duplication_register_main_parent_class = NULL;
static gpointer netsukuku_domain_wanted_parent_class = NULL;
static gpointer netsukuku_andna_parent_class = NULL;
static NetsukukuIAndnaAsPeerIface* netsukuku_andna_netsukuku_iandna_as_peer_parent_iface = NULL;
static NetsukukuIAndnaIface* netsukuku_andna_netsukuku_iandna_parent_iface = NULL;

GType netsukuku_iandna_as_peer_get_type (void) G_GNUC_CONST;
NetsukukuAndnaRegisterMainResponse* netsukuku_iandna_as_peer_register_main_for_pubk (NetsukukuIAndnaAsPeer* self, NetsukukuAndnaDomainRequest* request, zcdSerializableBuffer* signature, gboolean replicate, GError** error);
NetsukukuAndnaGetRegistrarResponse* netsukuku_iandna_as_peer_get_registrar (NetsukukuIAndnaAsPeer* self, const gchar* hashed_domain, GError** error);
NetsukukuAndnaDomainRecord* netsukuku_iandna_as_peer_get_domain_record (NetsukukuIAndnaAsPeer* self, const gchar* hashed_domain, GError** error);
NetsukukuAndnaRegisterSpreadResponse* netsukuku_iandna_as_peer_register_spread_record (NetsukukuIAndnaAsPeer* self, const gchar* hashed_domain, gint spread_number, gboolean replicate, GError** error);
NetsukukuAndnaGetServersResponse* netsukuku_iandna_as_peer_get_servers (NetsukukuIAndnaAsPeer* self, const gchar* hashed_domain, NetsukukuAndnaServiceKey* srv_key, gint spread_number, gboolean chain, GError** error);
NetsukukuAndnaGetCacheRecordsResponse* netsukuku_iandna_as_peer_get_cache_records (NetsukukuIAndnaAsPeer* self, GError** error);
GType netsukuku_rmt_peer_get_type (void) G_GNUC_CONST;
GType netsukuku_rmt_andna_peer_get_type (void) G_GNUC_CONST;
enum  {
	NETSUKUKU_RMT_ANDNA_PEER_DUMMY_PROPERTY
};
GType netsukuku_peer_to_peer_get_type (void) G_GNUC_CONST;
GType netsukuku_aggregated_neighbour_get_type (void) G_GNUC_CONST;
NetsukukuRmtAndnaPeer* netsukuku_rmt_andna_peer_new (NetsukukuPeerToPeer* peer_to_peer_service, GObject* key, NetsukukuNIP* hIP, NetsukukuAggregatedNeighbour* aggregated_neighbour);
NetsukukuRmtAndnaPeer* netsukuku_rmt_andna_peer_construct (GType object_type, NetsukukuPeerToPeer* peer_to_peer_service, GObject* key, NetsukukuNIP* hIP, NetsukukuAggregatedNeighbour* aggregated_neighbour);
NetsukukuRmtPeer* netsukuku_rmt_peer_new (NetsukukuPeerToPeer* peer_to_peer_service, GObject* key, NetsukukuNIP* hIP, NetsukukuAggregatedNeighbour* aggregated_neighbour);
NetsukukuRmtPeer* netsukuku_rmt_peer_construct (GType object_type, NetsukukuPeerToPeer* peer_to_peer_service, GObject* key, NetsukukuNIP* hIP, NetsukukuAggregatedNeighbour* aggregated_neighbour);
static NetsukukuAndnaRegisterMainResponse* netsukuku_rmt_andna_peer_real_register_main_for_pubk (NetsukukuIAndnaAsPeer* base, NetsukukuAndnaDomainRequest* request, zcdSerializableBuffer* signature, gboolean replicate, GError** error);
zcdISerializable* netsukuku_rmt_peer_rmt (NetsukukuRmtPeer* self, zcdRemoteCall* data, GError** error);
static NetsukukuAndnaGetRegistrarResponse* netsukuku_rmt_andna_peer_real_get_registrar (NetsukukuIAndnaAsPeer* base, const gchar* hashed_domain, GError** error);
static NetsukukuAndnaDomainRecord* netsukuku_rmt_andna_peer_real_get_domain_record (NetsukukuIAndnaAsPeer* base, const gchar* hashed_domain, GError** error);
static NetsukukuAndnaRegisterSpreadResponse* netsukuku_rmt_andna_peer_real_register_spread_record (NetsukukuIAndnaAsPeer* base, const gchar* hashed_domain, gint spread_number, gboolean replicate, GError** error);
static NetsukukuAndnaGetServersResponse* netsukuku_rmt_andna_peer_real_get_servers (NetsukukuIAndnaAsPeer* base, const gchar* hashed_domain, NetsukukuAndnaServiceKey* srv_key, gint spread_number, gboolean chain, GError** error);
static NetsukukuAndnaGetCacheRecordsResponse* netsukuku_rmt_andna_peer_real_get_cache_records (NetsukukuIAndnaAsPeer* base, GError** error);
GType netsukuku_andna_service_hashnode_key_get_type (void) G_GNUC_CONST;
#define NETSUKUKU_ANDNA_SERVICE_HASHNODE_KEY_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), NETSUKUKU_TYPE_ANDNA_SERVICE_HASHNODE_KEY, NetsukukuAndnaServiceHashnodeKeyPrivate))
enum  {
	NETSUKUKU_ANDNA_SERVICE_HASHNODE_KEY_DUMMY_PROPERTY,
	NETSUKUKU_ANDNA_SERVICE_HASHNODE_KEY_HASHED_DOMAIN,
	NETSUKUKU_ANDNA_SERVICE_HASHNODE_KEY_SPREAD_NUM
};
NetsukukuAndnaServiceHashnodeKey* netsukuku_andna_service_hashnode_key_new (const gchar* hashed_domain, gint spread_num);
NetsukukuAndnaServiceHashnodeKey* netsukuku_andna_service_hashnode_key_construct (GType object_type, const gchar* hashed_domain, gint spread_num);
static void netsukuku_andna_service_hashnode_key_set_hashed_domain (NetsukukuAndnaServiceHashnodeKey* self, const gchar* value);
static void netsukuku_andna_service_hashnode_key_set_spread_num (NetsukukuAndnaServiceHashnodeKey* self, gint value);
gboolean netsukuku_andna_service_hashnode_key_equal_func (NetsukukuAndnaServiceHashnodeKey* a, NetsukukuAndnaServiceHashnodeKey* b);
const gchar* netsukuku_andna_service_hashnode_key_get_hashed_domain (NetsukukuAndnaServiceHashnodeKey* self);
gint netsukuku_andna_service_hashnode_key_get_spread_num (NetsukukuAndnaServiceHashnodeKey* self);
static void netsukuku_andna_service_hashnode_key_finalize (GObject* obj);
static void _vala_netsukuku_andna_service_hashnode_key_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void _vala_netsukuku_andna_service_hashnode_key_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);
GType netsukuku_arguments_for_duplication_register_spread_get_type (void) G_GNUC_CONST;
enum  {
	NETSUKUKU_ARGUMENTS_FOR_DUPLICATION_REGISTER_SPREAD_DUMMY_PROPERTY
};
NetsukukuArgumentsForDuplicationRegisterSpread* netsukuku_arguments_for_duplication_register_spread_new (void);
NetsukukuArgumentsForDuplicationRegisterSpread* netsukuku_arguments_for_duplication_register_spread_construct (GType object_type);
static void netsukuku_arguments_for_duplication_register_spread_finalize (GObject* obj);
GType netsukuku_arguments_for_duplication_register_main_get_type (void) G_GNUC_CONST;
enum  {
	NETSUKUKU_ARGUMENTS_FOR_DUPLICATION_REGISTER_MAIN_DUMMY_PROPERTY
};
NetsukukuArgumentsForDuplicationRegisterMain* netsukuku_arguments_for_duplication_register_main_new (void);
NetsukukuArgumentsForDuplicationRegisterMain* netsukuku_arguments_for_duplication_register_main_construct (GType object_type);
static void netsukuku_arguments_for_duplication_register_main_finalize (GObject* obj);
GType netsukuku_domain_wanted_get_type (void) G_GNUC_CONST;
enum  {
	NETSUKUKU_DOMAIN_WANTED_DUMMY_PROPERTY
};
gboolean netsukuku_domain_wanted_equal_func (NetsukukuDomainWanted* a, NetsukukuDomainWanted* b);
NetsukukuDomainWanted* netsukuku_domain_wanted_new (void);
NetsukukuDomainWanted* netsukuku_domain_wanted_construct (GType object_type);
static void netsukuku_domain_wanted_finalize (GObject* obj);
GType netsukuku_map_route_get_type (void) G_GNUC_CONST;
GType netsukuku_andna_get_type (void) G_GNUC_CONST;
GType netsukuku_peer_to_peer_all_get_type (void) G_GNUC_CONST;
GType netsukuku_counter_get_type (void) G_GNUC_CONST;
GType netsukuku_key_pair_get_type (void) G_GNUC_CONST;
#define NETSUKUKU_ANDNA_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), NETSUKUKU_TYPE_ANDNA, NetsukukuAndnaPrivate))
enum  {
	NETSUKUKU_ANDNA_DUMMY_PROPERTY
};
#define NETSUKUKU_ANDNA_mypid 3
GType netsukuku_aggregated_neighbour_manager_get_type (void) G_GNUC_CONST;
NetsukukuAndna* netsukuku_andna_new (NetsukukuKeyPair* keypair, NetsukukuCounter* counter, NetsukukuAggregatedNeighbourManager* aggregated_neighbour_manager, NetsukukuMapRoute* maproute, NetsukukuPeerToPeerAll* peer_to_peer_all);
NetsukukuAndna* netsukuku_andna_construct (GType object_type, NetsukukuKeyPair* keypair, NetsukukuCounter* counter, NetsukukuAggregatedNeighbourManager* aggregated_neighbour_manager, NetsukukuMapRoute* maproute, NetsukukuPeerToPeerAll* peer_to_peer_all);
NetsukukuPeerToPeer* netsukuku_peer_to_peer_new (NetsukukuAggregatedNeighbourManager* aggregated_neighbour_manager, NetsukukuMapRoute* maproute, gint pid);
NetsukukuPeerToPeer* netsukuku_peer_to_peer_construct (GType object_type, NetsukukuAggregatedNeighbourManager* aggregated_neighbour_manager, NetsukukuMapRoute* maproute, gint pid);
GQuark netsukuku_peer_to_peer_error_quark (void);
void netsukuku_peer_to_peer_all_peer_to_peer_register (NetsukukuPeerToPeerAll* self, NetsukukuPeerToPeer* peer_to_peer, GError** error);
void netsukuku_andna_init_memory (NetsukukuAndna* self);
static void _netsukuku_andna_init_memory_netsukuku_peer_to_peer_map_peer_to_peer_validated (NetsukukuPeerToPeer* _sender, gpointer self);
static gboolean _netsukuku_domain_wanted_equal_func_gee_equal_data_func (gconstpointer a, gconstpointer b, gpointer self);
NetsukukuRmtAndnaPeer* netsukuku_andna_peer (NetsukukuAndna* self, NetsukukuNIP* hIP, GObject* key, NetsukukuAggregatedNeighbour* aggregated_neighbour);
static zcdISerializable* netsukuku_andna_real__dispatch (NetsukukuPeerToPeer* base, GObject* caller, zcdRemoteCall* data, GError** error);
zcdISerializable* _netsukuku_peer_to_peer_dispatch (NetsukukuPeerToPeer* self, GObject* caller, zcdRemoteCall* data, GError** error);
gchar* netsukuku_andna_crypto_hash (const gchar* hostname);
gchar* netsukuku_andna_utilities_crypto_hash (const gchar* hostname);
static NetsukukuNIP* netsukuku_andna_nip_for_lvl_pos (NetsukukuAndna* self, gint lvl, gint pos);
static void netsukuku_andna_impl_init_memory (NetsukukuAndna* self, GError** error);
void netsukuku_peer_to_peer_find_hook_peers (NetsukukuPeerToPeer* self, gint** ret_first_forward, gint** ret_first_back, gint** ret_last_back, gint lvl, gint num_dupl, gint timeout);
#define NETSUKUKU_ANDNA_DUPLICATION 3
static gboolean _int_equal (const gint* s1, const gint* s2);
NetsukukuNIP* netsukuku_peer_to_peer_h (NetsukukuPeerToPeer* self, GObject* key);
GeeList* netsukuku_peer_to_peer_list_ids (NetsukukuPeerToPeer* self, gint center, gint sign);
#define NETSUKUKU_SPREAD_ANDNA 3
void netsukuku_log_info (const gchar* msg);
static void __lambda8_ (NetsukukuAndna* self, GError** error);
void netsukuku_log_warn (const gchar* msg);
static void ___lambda8__tasklets_tasklet_callback (GObject* obj1, GObject* obj2, GObject* obj3, GObject* obj4, gpointer self, GError** error);
static NetsukukuNIP* netsukuku_andna_real_h (NetsukukuPeerToPeer* base, GObject* key);
NetsukukuNIP* netsukuku_andna_utilities_key_to_hashnode_converter (NetsukukuAndnaServiceHashnodeKey* key, gint levels, gint gsize);
NetsukukuAndnaDomainRequest* netsukuku_andna_make_domain_request (NetsukukuAndna* self, NetsukukuAndnaPrivateConfiguration* cfg);
GType netsukuku_public_key_wrapper_get_type (void) G_GNUC_CONST;
NetsukukuPublicKeyWrapper* netsukuku_key_pair_get_pub_key (NetsukukuKeyPair* self);
NetsukukuPublicKey* netsukuku_public_key_wrapper_to_pubkey (NetsukukuPublicKeyWrapper* self);
NetsukukuAndnaServerRequest* netsukuku_andna_make_server_request (NetsukukuAndna* self, NetsukukuAndnaPrivateConfigurationServer* cfg);
static void netsukuku_andna_impl_register_name (NetsukukuAndna* self, const gchar* hostname);
static NetsukukuAndnaRegisterMainResponse* netsukuku_andna_ask_register_main_for_pubk (NetsukukuAndna* self, const gchar* hostname, GError** error);
static void ________lambda15_ (NetsukukuAndna* self, GObject* tpar1, GObject* tpar2, GError** error);
static void netsukuku_andna_ask_register_spread_record (NetsukukuAndna* self, const gchar* hostname, gint spread_number, GError** error);
static void _________lambda15__tasklets_tasklet_callback (GObject* obj1, GObject* obj2, GObject* obj3, GObject* obj4, gpointer self, GError** error);
#define NETSUKUKU_MAX_WAIT_REFRESH_ANDNA ((((gint64) 1000) * ((gint64) 60)) * ((gint64) 60))
static void netsukuku_andna_register_name (NetsukukuAndna* self, const gchar* hostname);
static void __lambda16_ (NetsukukuAndna* self, GObject* tpar1, GError** error);
static void ___lambda16__tasklets_tasklet_callback (GObject* obj1, GObject* obj2, GObject* obj3, GObject* obj4, gpointer self, GError** error);
void netsukuku_andna_register_my_names (NetsukukuAndna* self);
static NetsukukuAndnaPrivateConfigurationList* netsukuku_andna_get_configuration (NetsukukuAndna* self);
void netsukuku_andna_stop_register_my_names (NetsukukuAndna* self);
gboolean netsukuku_andna_register_my_names_ongoing (NetsukukuAndna* self);
static zcdSerializableBuffer* _netsukuku_andna_sign (NetsukukuAndna* self, NetsukukuAndnaDomainRequest* req, NetsukukuKeyPair* key_pair);
static guchar* netsukuku_andna_prepare_msg (NetsukukuAndna* self, NetsukukuAndnaDomainRequest* req, int* result_length1);
GQuark netsukuku_crypto_gcrypt_error_quark (void);
guchar* netsukuku_key_pair_sign (NetsukukuKeyPair* self, guchar* msg, int msg_length1, int* result_length1, GError** error);
static gboolean _netsukuku_andna_verify (NetsukukuAndna* self, NetsukukuAndnaDomainRequest* req, NetsukukuPublicKey* pubk, zcdSerializableBuffer* signature);
NetsukukuPublicKeyWrapper* netsukuku_public_key_wrapper_new_from_pubk (NetsukukuPublicKey* from_pubk, GError** error);
NetsukukuPublicKeyWrapper* netsukuku_public_key_wrapper_construct_from_pubk (GType object_type, NetsukukuPublicKey* from_pubk, GError** error);
gboolean netsukuku_public_key_wrapper_verify (NetsukukuPublicKeyWrapper* self, guchar* msg, int msg_length1, guchar* signature, int signature_length1, GError** error);
NetsukukuAndnaGetRegistrarResponse* netsukuku_andna_ask_registrar (NetsukukuAndna* self, const gchar* hashed_domain);
NetsukukuAndnaGetServersResponse* netsukuku_andna_ask_get_servers (NetsukukuAndna* self, const gchar* hashed_domain, NetsukukuAndnaServiceKey* srv_key, gboolean chain);
static gboolean _netsukuku_partial_nip_equal_func_gee_equal_data_func (gconstpointer a, gconstpointer b, gpointer self);
static gboolean _netsukuku_andna_service_hashnode_key_equal_func_gee_equal_data_func (gconstpointer a, gconstpointer b, gpointer self);
NetsukukuPartialNIP* netsukuku_peer_to_peer_search_participant_as_nip (NetsukukuPeerToPeer* self, NetsukukuNIP* hIP, gint path_sign, GError** error);
NetsukukuPartialNIP* netsukuku_map_route_choose_fast (NetsukukuMapRoute* self, GeeList* choose_from);
static NetsukukuAndnaServerRecord* netsukuku_andna_make_server_record (NetsukukuAndna* self, NetsukukuAndnaServerRequest* req);
void netsukuku_andna_check_expirations_cache (NetsukukuAndna* self);
static NetsukukuAndnaRegisterMainResponse* netsukuku_andna_real_register_main_for_pubk (NetsukukuIAndnaAsPeer* base, NetsukukuAndnaDomainRequest* request, zcdSerializableBuffer* signature, gboolean replicate, GError** error);
static Block1Data* block1_data_ref (Block1Data* _data1_);
static void block1_data_unref (void * _userdata_);
void netsukuku_check_hash_and_start_replica (NetsukukuPeerToPeer* service, NetsukukuNIP* hash_nip, gboolean replicate, GObject* obj1, gint replica_nodes_max, NetsukukuAcceptRecordCallback accept_callback, void* accept_callback_target, NetsukukuForwardRecordCallback forward_callback, void* forward_callback_target, NetsukukuRefuseRecordCallback refuse_callback, void* refuse_callback_target, GError** error);
static gboolean __lambda9_ (Block1Data* _data1_, GError** error);
NetsukukuCounterCheckHostnameResponse* netsukuku_counter_ask_check_hostname (NetsukukuCounter* self, NetsukukuNIP* nip, const gchar* hashed_domain, NetsukukuPublicKey* pubkey, GError** error);
#define NETSUKUKU_MAX_TTL_ANDNA ((((((gint64) 1000) * ((gint64) 60)) * ((gint64) 60)) * ((gint64) 24)) * ((gint64) 30))
static guint _netsukuku_andna_service_key_hash_func_gee_hash_data_func (gconstpointer v, gpointer self);
static gboolean _netsukuku_andna_service_key_equal_func_gee_equal_data_func (gconstpointer a, gconstpointer b, gpointer self);
static gboolean _netsukuku_andna_server_record_equal_func_gee_equal_data_func (gconstpointer a, gconstpointer b, gpointer self);
static gboolean _netsukuku_register_hostname_arguments_equal_func_for_queue_gee_equal_data_func (gconstpointer a, gconstpointer b, gpointer self);
#define NETSUKUKU_MAX_QUEUE_ANDNA 5
static gboolean ___lambda9__netsukuku_accept_record_callback (gpointer self, GError** error);
static void __lambda10_ (NetsukukuAndna* self, GObject* tasklet_obj1, GeeList* tasklet_replica_nodes, GError** error);
GeeList* netsukuku_peer_to_peer_find_nearest_to_register (NetsukukuPeerToPeer* self, NetsukukuNIP* hash_nip, gint num_dupl);
static void _____lambda11_ (NetsukukuAndna* self, GObject* tpar1, GObject* tpar2, GError** error);
static void ______lambda11__tasklets_tasklet_callback (GObject* obj1, GObject* obj2, GObject* obj3, GObject* obj4, gpointer self, GError** error);
static void ___lambda10__netsukuku_forward_record_callback (GObject* obj1, GeeList* replica_nodes, gpointer self, GError** error);
static NetsukukuAndnaGetRegistrarResponse* netsukuku_andna_real_get_registrar (NetsukukuIAndnaAsPeer* base, const gchar* hashed_domain, GError** error);
NetsukukuHCoord* netsukuku_peer_to_peer_search_participant (NetsukukuPeerToPeer* self, NetsukukuNIP* hIP, gint path_sign, GError** error);
static NetsukukuAndnaDomainRecord* netsukuku_andna_real_get_domain_record (NetsukukuIAndnaAsPeer* base, const gchar* hashed_domain, GError** error);
static NetsukukuAndnaRegisterSpreadResponse* netsukuku_andna_real_register_spread_record (NetsukukuIAndnaAsPeer* base, const gchar* hashed_domain, gint spread_number, gboolean replicate, GError** error);
static Block2Data* block2_data_ref (Block2Data* _data2_);
static void block2_data_unref (void * _userdata_);
static gboolean __lambda12_ (Block2Data* _data2_, GError** error);
static gboolean ___lambda12__netsukuku_accept_record_callback (gpointer self, GError** error);
static void __lambda13_ (NetsukukuAndna* self, GObject* tasklet_obj1, GeeList* tasklet_replica_nodes, GError** error);
static void _____lambda14_ (NetsukukuAndna* self, GObject* tpar1, GObject* tpar2, GError** error);
static void ______lambda14__tasklets_tasklet_callback (GObject* obj1, GObject* obj2, GObject* obj3, GObject* obj4, gpointer self, GError** error);
static void ___lambda13__netsukuku_forward_record_callback (GObject* obj1, GeeList* replica_nodes, gpointer self, GError** error);
static NetsukukuAndnaGetServersResponse* netsukuku_andna_real_get_servers (NetsukukuIAndnaAsPeer* base, const gchar* hashed_domain, NetsukukuAndnaServiceKey* srv_key, gint spread_number, gboolean chain, GError** error);
#define NETSUKUKU_MAX_TTL_OF_NEGATIVE (((gint64) 1000) * ((gint64) 30))
static NetsukukuAndnaGetCacheRecordsResponse* netsukuku_andna_real_get_cache_records (NetsukukuIAndnaAsPeer* base, GError** error);
static NetsukukuAndnaConfirmPubkResponse* netsukuku_andna_real_confirm_pubk (NetsukukuIAndna* base, NetsukukuNIP* yournip, NetsukukuPublicKey* yourpubkey, gint to_be_signed, GError** error);
static NetsukukuPublicKey* netsukuku_andna_get_mypubk (NetsukukuAndna* self);
static GeeList* netsukuku_andna_real_get_your_hostnames (NetsukukuIAndna* base, NetsukukuNIP* yournip, GError** error);
static NetsukukuInfoAndna* netsukuku_andna_real_report_status (NetsukukuIAndna* base, GError** error);
static NetsukukuAndnaPrivateConfigurationList* netsukuku_andna_real_get_mynames (NetsukukuIAndna* base, GError** error);
static void netsukuku_andna_real_set_mynames (NetsukukuIAndna* base, NetsukukuAndnaPrivateConfigurationList* mynames, GError** error);
static NetsukukuPublicKey* netsukuku_andna_real_retrieve_registrar_pubk (NetsukukuIAndna* base, const gchar* hashed_domain, GError** error);
static void netsukuku_andna_finalize (GObject* obj);
static void _vala_netsukuku_andna_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);
static gint _vala_array_length (gpointer array);


NetsukukuAndnaRegisterMainResponse* netsukuku_iandna_as_peer_register_main_for_pubk (NetsukukuIAndnaAsPeer* self, NetsukukuAndnaDomainRequest* request, zcdSerializableBuffer* signature, gboolean replicate, GError** error) {
	g_return_val_if_fail (self != NULL, NULL);
	return NETSUKUKU_IANDNA_AS_PEER_GET_INTERFACE (self)->register_main_for_pubk (self, request, signature, replicate, error);
}


NetsukukuAndnaGetRegistrarResponse* netsukuku_iandna_as_peer_get_registrar (NetsukukuIAndnaAsPeer* self, const gchar* hashed_domain, GError** error) {
	g_return_val_if_fail (self != NULL, NULL);
	return NETSUKUKU_IANDNA_AS_PEER_GET_INTERFACE (self)->get_registrar (self, hashed_domain, error);
}


NetsukukuAndnaDomainRecord* netsukuku_iandna_as_peer_get_domain_record (NetsukukuIAndnaAsPeer* self, const gchar* hashed_domain, GError** error) {
	g_return_val_if_fail (self != NULL, NULL);
	return NETSUKUKU_IANDNA_AS_PEER_GET_INTERFACE (self)->get_domain_record (self, hashed_domain, error);
}


NetsukukuAndnaRegisterSpreadResponse* netsukuku_iandna_as_peer_register_spread_record (NetsukukuIAndnaAsPeer* self, const gchar* hashed_domain, gint spread_number, gboolean replicate, GError** error) {
	g_return_val_if_fail (self != NULL, NULL);
	return NETSUKUKU_IANDNA_AS_PEER_GET_INTERFACE (self)->register_spread_record (self, hashed_domain, spread_number, replicate, error);
}


NetsukukuAndnaGetServersResponse* netsukuku_iandna_as_peer_get_servers (NetsukukuIAndnaAsPeer* self, const gchar* hashed_domain, NetsukukuAndnaServiceKey* srv_key, gint spread_number, gboolean chain, GError** error) {
	g_return_val_if_fail (self != NULL, NULL);
	return NETSUKUKU_IANDNA_AS_PEER_GET_INTERFACE (self)->get_servers (self, hashed_domain, srv_key, spread_number, chain, error);
}


NetsukukuAndnaGetCacheRecordsResponse* netsukuku_iandna_as_peer_get_cache_records (NetsukukuIAndnaAsPeer* self, GError** error) {
	g_return_val_if_fail (self != NULL, NULL);
	return NETSUKUKU_IANDNA_AS_PEER_GET_INTERFACE (self)->get_cache_records (self, error);
}


static void netsukuku_iandna_as_peer_base_init (NetsukukuIAndnaAsPeerIface * iface) {
	static gboolean initialized = FALSE;
	if (!initialized) {
		initialized = TRUE;
	}
}


GType netsukuku_iandna_as_peer_get_type (void) {
	static volatile gsize netsukuku_iandna_as_peer_type_id__volatile = 0;
	if (g_once_init_enter (&netsukuku_iandna_as_peer_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (NetsukukuIAndnaAsPeerIface), (GBaseInitFunc) netsukuku_iandna_as_peer_base_init, (GBaseFinalizeFunc) NULL, (GClassInitFunc) NULL, (GClassFinalizeFunc) NULL, NULL, 0, 0, (GInstanceInitFunc) NULL, NULL };
		GType netsukuku_iandna_as_peer_type_id;
		netsukuku_iandna_as_peer_type_id = g_type_register_static (G_TYPE_INTERFACE, "NetsukukuIAndnaAsPeer", &g_define_type_info, 0);
		g_type_interface_add_prerequisite (netsukuku_iandna_as_peer_type_id, G_TYPE_OBJECT);
		g_once_init_leave (&netsukuku_iandna_as_peer_type_id__volatile, netsukuku_iandna_as_peer_type_id);
	}
	return netsukuku_iandna_as_peer_type_id__volatile;
}


NetsukukuRmtAndnaPeer* netsukuku_rmt_andna_peer_construct (GType object_type, NetsukukuPeerToPeer* peer_to_peer_service, GObject* key, NetsukukuNIP* hIP, NetsukukuAggregatedNeighbour* aggregated_neighbour) {
	NetsukukuRmtAndnaPeer * self = NULL;
	NetsukukuPeerToPeer* _tmp0_;
	GObject* _tmp1_;
	NetsukukuNIP* _tmp2_;
	NetsukukuAggregatedNeighbour* _tmp3_;
	g_return_val_if_fail (peer_to_peer_service != NULL, NULL);
	_tmp0_ = peer_to_peer_service;
	_tmp1_ = key;
	_tmp2_ = hIP;
	_tmp3_ = aggregated_neighbour;
	self = (NetsukukuRmtAndnaPeer*) netsukuku_rmt_peer_construct (object_type, _tmp0_, _tmp1_, _tmp2_, _tmp3_);
	return self;
}


NetsukukuRmtAndnaPeer* netsukuku_rmt_andna_peer_new (NetsukukuPeerToPeer* peer_to_peer_service, GObject* key, NetsukukuNIP* hIP, NetsukukuAggregatedNeighbour* aggregated_neighbour) {
	return netsukuku_rmt_andna_peer_construct (NETSUKUKU_TYPE_RMT_ANDNA_PEER, peer_to_peer_service, key, hIP, aggregated_neighbour);
}


static gpointer _g_error_copy0 (gpointer self) {
	return self ? g_error_copy (self) : NULL;
}


static const gchar* string_to_string (const gchar* self) {
	const gchar* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	result = self;
	return result;
}


static NetsukukuAndnaRegisterMainResponse* netsukuku_rmt_andna_peer_real_register_main_for_pubk (NetsukukuIAndnaAsPeer* base, NetsukukuAndnaDomainRequest* request, zcdSerializableBuffer* signature, gboolean replicate, GError** error) {
	NetsukukuRmtAndnaPeer * self;
	NetsukukuAndnaRegisterMainResponse* result = NULL;
	zcdRemoteCall* _tmp0_;
	zcdRemoteCall* rc;
	zcdRemoteCall* _tmp1_;
	gchar* _tmp2_;
	zcdRemoteCall* _tmp3_;
	NetsukukuAndnaDomainRequest* _tmp4_;
	zcdRemoteCall* _tmp5_;
	zcdSerializableBuffer* _tmp6_;
	zcdRemoteCall* _tmp7_;
	gboolean _tmp8_;
	zcdSerializableBool* _tmp9_;
	zcdSerializableBool* _tmp10_;
	GError * _inner_error_ = NULL;
	self = (NetsukukuRmtAndnaPeer*) base;
	g_return_val_if_fail (request != NULL, NULL);
	g_return_val_if_fail (signature != NULL, NULL);
	_tmp0_ = zcd_remote_call_new ();
	rc = _tmp0_;
	_tmp1_ = rc;
	_tmp2_ = g_strdup ("register_main_for_pubk");
	_g_free0 (_tmp1_->method_name);
	_tmp1_->method_name = _tmp2_;
	_tmp3_ = rc;
	_tmp4_ = request;
	zcd_remote_call_add_parameter (_tmp3_, (zcdISerializable*) _tmp4_);
	_tmp5_ = rc;
	_tmp6_ = signature;
	zcd_remote_call_add_parameter (_tmp5_, (zcdISerializable*) _tmp6_);
	_tmp7_ = rc;
	_tmp8_ = replicate;
	_tmp9_ = zcd_serializable_bool_new (_tmp8_);
	_tmp10_ = _tmp9_;
	zcd_remote_call_add_parameter (_tmp7_, (zcdISerializable*) _tmp10_);
	_g_object_unref0 (_tmp10_);
	{
		zcdRemoteCall* _tmp11_;
		zcdISerializable* _tmp12_ = NULL;
		zcdISerializable* _tmp13_;
		zcdISerializable* _tmp14_;
		zcdISerializable* _tmp15_ = NULL;
		zcdISerializable* _tmp16_;
		zcdISerializable* _tmp17_;
		zcdISerializable* _tmp18_;
		zcdISerializable* _tmp19_ = NULL;
		zcdISerializable* _tmp20_;
		zcdISerializable* _tmp21_;
		_tmp11_ = rc;
		_tmp12_ = netsukuku_rmt_peer_rmt ((NetsukukuRmtPeer*) self, _tmp11_, &_inner_error_);
		_tmp13_ = _tmp12_;
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == ZCD_RPC_ERROR) {
				goto __catch2_zcd_rpc_error;
			}
			goto __catch2_g_error;
		}
		_tmp14_ = _tmp13_;
		_tmp15_ = netsukuku_filter_exception_PeerRefuseServiceError (_tmp14_, &_inner_error_);
		_tmp16_ = _tmp15_;
		_g_object_unref0 (_tmp14_);
		_tmp17_ = _tmp16_;
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == ZCD_RPC_ERROR) {
				goto __catch2_zcd_rpc_error;
			}
			goto __catch2_g_error;
		}
		_tmp18_ = _tmp17_;
		_tmp19_ = zcd_filter_exception (_tmp18_, &_inner_error_);
		_tmp20_ = _tmp19_;
		_g_object_unref0 (_tmp18_);
		_tmp21_ = _tmp20_;
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == ZCD_RPC_ERROR) {
				goto __catch2_zcd_rpc_error;
			}
			goto __catch2_g_error;
		}
		result = G_TYPE_CHECK_INSTANCE_CAST (_tmp21_, NETSUKUKU_TYPE_ANDNA_REGISTER_MAIN_RESPONSE, NetsukukuAndnaRegisterMainResponse);
		_g_object_unref0 (rc);
		return result;
	}
	goto __finally2;
	__catch2_zcd_rpc_error:
	{
		GError* e = NULL;
		GError* _tmp22_;
		GError* _tmp23_;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp22_ = e;
		_tmp23_ = _g_error_copy0 (_tmp22_);
		_inner_error_ = _tmp23_;
		_g_error_free0 (e);
		goto __finally2;
	}
	goto __finally2;
	__catch2_g_error:
	{
		GError* e = NULL;
		GError* _tmp24_;
		GQuark _tmp25_;
		const gchar* _tmp26_ = NULL;
		GError* _tmp27_;
		gint _tmp28_;
		gchar* _tmp29_ = NULL;
		gchar* _tmp30_;
		GError* _tmp31_;
		const gchar* _tmp32_;
		const gchar* _tmp33_ = NULL;
		gchar* _tmp34_ = NULL;
		gchar* _tmp35_;
		GError* _tmp36_;
		GError* _tmp37_;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp24_ = e;
		_tmp25_ = _tmp24_->domain;
		_tmp26_ = g_quark_to_string (_tmp25_);
		_tmp27_ = e;
		_tmp28_ = _tmp27_->code;
		_tmp29_ = g_strdup_printf ("%i", _tmp28_);
		_tmp30_ = _tmp29_;
		_tmp31_ = e;
		_tmp32_ = _tmp31_->message;
		_tmp33_ = string_to_string (_tmp32_);
		_tmp34_ = g_strconcat ("Unexpected error ", _tmp26_, ".", _tmp30_, " '", _tmp33_, "'", NULL);
		_tmp35_ = _tmp34_;
		_tmp36_ = g_error_new_literal (ZCD_RPC_ERROR, ZCD_RPC_ERROR_GENERIC, _tmp35_);
		_tmp37_ = _tmp36_;
		_g_free0 (_tmp35_);
		_g_free0 (_tmp30_);
		_inner_error_ = _tmp37_;
		_g_error_free0 (e);
		goto __finally2;
	}
	__finally2:
	if ((_inner_error_->domain == ZCD_RPC_ERROR) || (_inner_error_->domain == NETSUKUKU_PEER_REFUSE_SERVICE_ERROR)) {
		g_propagate_error (error, _inner_error_);
		_g_object_unref0 (rc);
		return NULL;
	} else {
		_g_object_unref0 (rc);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return NULL;
	}
	_g_object_unref0 (rc);
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


static NetsukukuAndnaGetRegistrarResponse* netsukuku_rmt_andna_peer_real_get_registrar (NetsukukuIAndnaAsPeer* base, const gchar* hashed_domain, GError** error) {
	NetsukukuRmtAndnaPeer * self;
	NetsukukuAndnaGetRegistrarResponse* result = NULL;
	zcdRemoteCall* _tmp0_;
	zcdRemoteCall* rc;
	zcdRemoteCall* _tmp1_;
	gchar* _tmp2_;
	zcdRemoteCall* _tmp3_;
	const gchar* _tmp4_;
	zcdSerializableString* _tmp5_;
	zcdSerializableString* _tmp6_;
	GError * _inner_error_ = NULL;
	self = (NetsukukuRmtAndnaPeer*) base;
	g_return_val_if_fail (hashed_domain != NULL, NULL);
	_tmp0_ = zcd_remote_call_new ();
	rc = _tmp0_;
	_tmp1_ = rc;
	_tmp2_ = g_strdup ("get_registrar");
	_g_free0 (_tmp1_->method_name);
	_tmp1_->method_name = _tmp2_;
	_tmp3_ = rc;
	_tmp4_ = hashed_domain;
	_tmp5_ = zcd_serializable_string_new (_tmp4_);
	_tmp6_ = _tmp5_;
	zcd_remote_call_add_parameter (_tmp3_, (zcdISerializable*) _tmp6_);
	_g_object_unref0 (_tmp6_);
	{
		zcdRemoteCall* _tmp7_;
		zcdISerializable* _tmp8_ = NULL;
		zcdISerializable* _tmp9_;
		zcdISerializable* _tmp10_;
		zcdISerializable* _tmp11_ = NULL;
		zcdISerializable* _tmp12_;
		zcdISerializable* _tmp13_;
		zcdISerializable* _tmp14_;
		zcdISerializable* _tmp15_ = NULL;
		zcdISerializable* _tmp16_;
		zcdISerializable* ret;
		zcdISerializable* _tmp17_;
		GType _tmp18_ = 0UL;
		gboolean _tmp19_ = FALSE;
		_tmp7_ = rc;
		_tmp8_ = netsukuku_rmt_peer_rmt ((NetsukukuRmtPeer*) self, _tmp7_, &_inner_error_);
		_tmp9_ = _tmp8_;
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == ZCD_RPC_ERROR) {
				goto __catch3_zcd_rpc_error;
			}
			goto __catch3_g_error;
		}
		_tmp10_ = _tmp9_;
		_tmp11_ = netsukuku_filter_exception_PeerRefuseServiceError (_tmp10_, &_inner_error_);
		_tmp12_ = _tmp11_;
		_g_object_unref0 (_tmp10_);
		_tmp13_ = _tmp12_;
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == ZCD_RPC_ERROR) {
				goto __catch3_zcd_rpc_error;
			}
			goto __catch3_g_error;
		}
		_tmp14_ = _tmp13_;
		_tmp15_ = zcd_filter_exception (_tmp14_, &_inner_error_);
		_tmp16_ = _tmp15_;
		_g_object_unref0 (_tmp14_);
		ret = _tmp16_;
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == ZCD_RPC_ERROR) {
				goto __catch3_zcd_rpc_error;
			}
			goto __catch3_g_error;
		}
		_tmp17_ = ret;
		_tmp18_ = G_TYPE_FROM_INSTANCE ((GObject*) _tmp17_);
		_tmp19_ = g_type_is_a (_tmp18_, ZCD_TYPE_SERIALIZABLE_NONE);
		if (_tmp19_) {
			result = NULL;
			_g_object_unref0 (ret);
			_g_object_unref0 (rc);
			return result;
		} else {
			zcdISerializable* _tmp20_;
			NetsukukuAndnaGetRegistrarResponse* _tmp21_;
			_tmp20_ = ret;
			_tmp21_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp20_, NETSUKUKU_TYPE_ANDNA_GET_REGISTRAR_RESPONSE, NetsukukuAndnaGetRegistrarResponse));
			result = _tmp21_;
			_g_object_unref0 (ret);
			_g_object_unref0 (rc);
			return result;
		}
		_g_object_unref0 (ret);
	}
	goto __finally3;
	__catch3_zcd_rpc_error:
	{
		GError* e = NULL;
		GError* _tmp22_;
		GError* _tmp23_;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp22_ = e;
		_tmp23_ = _g_error_copy0 (_tmp22_);
		_inner_error_ = _tmp23_;
		_g_error_free0 (e);
		goto __finally3;
	}
	goto __finally3;
	__catch3_g_error:
	{
		GError* e = NULL;
		GError* _tmp24_;
		GQuark _tmp25_;
		const gchar* _tmp26_ = NULL;
		GError* _tmp27_;
		gint _tmp28_;
		gchar* _tmp29_ = NULL;
		gchar* _tmp30_;
		GError* _tmp31_;
		const gchar* _tmp32_;
		const gchar* _tmp33_ = NULL;
		gchar* _tmp34_ = NULL;
		gchar* _tmp35_;
		GError* _tmp36_;
		GError* _tmp37_;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp24_ = e;
		_tmp25_ = _tmp24_->domain;
		_tmp26_ = g_quark_to_string (_tmp25_);
		_tmp27_ = e;
		_tmp28_ = _tmp27_->code;
		_tmp29_ = g_strdup_printf ("%i", _tmp28_);
		_tmp30_ = _tmp29_;
		_tmp31_ = e;
		_tmp32_ = _tmp31_->message;
		_tmp33_ = string_to_string (_tmp32_);
		_tmp34_ = g_strconcat ("Unexpected error ", _tmp26_, ".", _tmp30_, " '", _tmp33_, "'", NULL);
		_tmp35_ = _tmp34_;
		_tmp36_ = g_error_new_literal (ZCD_RPC_ERROR, ZCD_RPC_ERROR_GENERIC, _tmp35_);
		_tmp37_ = _tmp36_;
		_g_free0 (_tmp35_);
		_g_free0 (_tmp30_);
		_inner_error_ = _tmp37_;
		_g_error_free0 (e);
		goto __finally3;
	}
	__finally3:
	if ((_inner_error_->domain == ZCD_RPC_ERROR) || (_inner_error_->domain == NETSUKUKU_PEER_REFUSE_SERVICE_ERROR)) {
		g_propagate_error (error, _inner_error_);
		_g_object_unref0 (rc);
		return NULL;
	} else {
		_g_object_unref0 (rc);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return NULL;
	}
	_g_object_unref0 (rc);
}


static NetsukukuAndnaDomainRecord* netsukuku_rmt_andna_peer_real_get_domain_record (NetsukukuIAndnaAsPeer* base, const gchar* hashed_domain, GError** error) {
	NetsukukuRmtAndnaPeer * self;
	NetsukukuAndnaDomainRecord* result = NULL;
	zcdRemoteCall* _tmp0_;
	zcdRemoteCall* rc;
	zcdRemoteCall* _tmp1_;
	gchar* _tmp2_;
	zcdRemoteCall* _tmp3_;
	const gchar* _tmp4_;
	zcdSerializableString* _tmp5_;
	zcdSerializableString* _tmp6_;
	GError * _inner_error_ = NULL;
	self = (NetsukukuRmtAndnaPeer*) base;
	g_return_val_if_fail (hashed_domain != NULL, NULL);
	_tmp0_ = zcd_remote_call_new ();
	rc = _tmp0_;
	_tmp1_ = rc;
	_tmp2_ = g_strdup ("get_domain_record");
	_g_free0 (_tmp1_->method_name);
	_tmp1_->method_name = _tmp2_;
	_tmp3_ = rc;
	_tmp4_ = hashed_domain;
	_tmp5_ = zcd_serializable_string_new (_tmp4_);
	_tmp6_ = _tmp5_;
	zcd_remote_call_add_parameter (_tmp3_, (zcdISerializable*) _tmp6_);
	_g_object_unref0 (_tmp6_);
	{
		zcdRemoteCall* _tmp7_;
		zcdISerializable* _tmp8_ = NULL;
		zcdISerializable* _tmp9_;
		zcdISerializable* _tmp10_;
		zcdISerializable* _tmp11_ = NULL;
		zcdISerializable* _tmp12_;
		zcdISerializable* _tmp13_;
		zcdISerializable* _tmp14_;
		zcdISerializable* _tmp15_ = NULL;
		zcdISerializable* _tmp16_;
		zcdISerializable* ret;
		zcdISerializable* _tmp17_;
		GType _tmp18_ = 0UL;
		gboolean _tmp19_ = FALSE;
		_tmp7_ = rc;
		_tmp8_ = netsukuku_rmt_peer_rmt ((NetsukukuRmtPeer*) self, _tmp7_, &_inner_error_);
		_tmp9_ = _tmp8_;
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == ZCD_RPC_ERROR) {
				goto __catch4_zcd_rpc_error;
			}
			goto __catch4_g_error;
		}
		_tmp10_ = _tmp9_;
		_tmp11_ = netsukuku_filter_exception_PeerRefuseServiceError (_tmp10_, &_inner_error_);
		_tmp12_ = _tmp11_;
		_g_object_unref0 (_tmp10_);
		_tmp13_ = _tmp12_;
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == ZCD_RPC_ERROR) {
				goto __catch4_zcd_rpc_error;
			}
			goto __catch4_g_error;
		}
		_tmp14_ = _tmp13_;
		_tmp15_ = zcd_filter_exception (_tmp14_, &_inner_error_);
		_tmp16_ = _tmp15_;
		_g_object_unref0 (_tmp14_);
		ret = _tmp16_;
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == ZCD_RPC_ERROR) {
				goto __catch4_zcd_rpc_error;
			}
			goto __catch4_g_error;
		}
		_tmp17_ = ret;
		_tmp18_ = G_TYPE_FROM_INSTANCE ((GObject*) _tmp17_);
		_tmp19_ = g_type_is_a (_tmp18_, ZCD_TYPE_SERIALIZABLE_NONE);
		if (_tmp19_) {
			result = NULL;
			_g_object_unref0 (ret);
			_g_object_unref0 (rc);
			return result;
		} else {
			zcdISerializable* _tmp20_;
			NetsukukuAndnaDomainRecord* _tmp21_;
			_tmp20_ = ret;
			_tmp21_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp20_, NETSUKUKU_TYPE_ANDNA_DOMAIN_RECORD, NetsukukuAndnaDomainRecord));
			result = _tmp21_;
			_g_object_unref0 (ret);
			_g_object_unref0 (rc);
			return result;
		}
		_g_object_unref0 (ret);
	}
	goto __finally4;
	__catch4_zcd_rpc_error:
	{
		GError* e = NULL;
		GError* _tmp22_;
		GError* _tmp23_;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp22_ = e;
		_tmp23_ = _g_error_copy0 (_tmp22_);
		_inner_error_ = _tmp23_;
		_g_error_free0 (e);
		goto __finally4;
	}
	goto __finally4;
	__catch4_g_error:
	{
		GError* e = NULL;
		GError* _tmp24_;
		GQuark _tmp25_;
		const gchar* _tmp26_ = NULL;
		GError* _tmp27_;
		gint _tmp28_;
		gchar* _tmp29_ = NULL;
		gchar* _tmp30_;
		GError* _tmp31_;
		const gchar* _tmp32_;
		const gchar* _tmp33_ = NULL;
		gchar* _tmp34_ = NULL;
		gchar* _tmp35_;
		GError* _tmp36_;
		GError* _tmp37_;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp24_ = e;
		_tmp25_ = _tmp24_->domain;
		_tmp26_ = g_quark_to_string (_tmp25_);
		_tmp27_ = e;
		_tmp28_ = _tmp27_->code;
		_tmp29_ = g_strdup_printf ("%i", _tmp28_);
		_tmp30_ = _tmp29_;
		_tmp31_ = e;
		_tmp32_ = _tmp31_->message;
		_tmp33_ = string_to_string (_tmp32_);
		_tmp34_ = g_strconcat ("Unexpected error ", _tmp26_, ".", _tmp30_, " '", _tmp33_, "'", NULL);
		_tmp35_ = _tmp34_;
		_tmp36_ = g_error_new_literal (ZCD_RPC_ERROR, ZCD_RPC_ERROR_GENERIC, _tmp35_);
		_tmp37_ = _tmp36_;
		_g_free0 (_tmp35_);
		_g_free0 (_tmp30_);
		_inner_error_ = _tmp37_;
		_g_error_free0 (e);
		goto __finally4;
	}
	__finally4:
	if ((_inner_error_->domain == ZCD_RPC_ERROR) || (_inner_error_->domain == NETSUKUKU_PEER_REFUSE_SERVICE_ERROR)) {
		g_propagate_error (error, _inner_error_);
		_g_object_unref0 (rc);
		return NULL;
	} else {
		_g_object_unref0 (rc);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return NULL;
	}
	_g_object_unref0 (rc);
}


static NetsukukuAndnaRegisterSpreadResponse* netsukuku_rmt_andna_peer_real_register_spread_record (NetsukukuIAndnaAsPeer* base, const gchar* hashed_domain, gint spread_number, gboolean replicate, GError** error) {
	NetsukukuRmtAndnaPeer * self;
	NetsukukuAndnaRegisterSpreadResponse* result = NULL;
	zcdRemoteCall* _tmp0_;
	zcdRemoteCall* rc;
	zcdRemoteCall* _tmp1_;
	gchar* _tmp2_;
	zcdRemoteCall* _tmp3_;
	const gchar* _tmp4_;
	zcdSerializableString* _tmp5_;
	zcdSerializableString* _tmp6_;
	zcdRemoteCall* _tmp7_;
	gint _tmp8_;
	zcdSerializableInt* _tmp9_;
	zcdSerializableInt* _tmp10_;
	zcdRemoteCall* _tmp11_;
	gboolean _tmp12_;
	zcdSerializableBool* _tmp13_;
	zcdSerializableBool* _tmp14_;
	GError * _inner_error_ = NULL;
	self = (NetsukukuRmtAndnaPeer*) base;
	g_return_val_if_fail (hashed_domain != NULL, NULL);
	_tmp0_ = zcd_remote_call_new ();
	rc = _tmp0_;
	_tmp1_ = rc;
	_tmp2_ = g_strdup ("register_spread_record");
	_g_free0 (_tmp1_->method_name);
	_tmp1_->method_name = _tmp2_;
	_tmp3_ = rc;
	_tmp4_ = hashed_domain;
	_tmp5_ = zcd_serializable_string_new (_tmp4_);
	_tmp6_ = _tmp5_;
	zcd_remote_call_add_parameter (_tmp3_, (zcdISerializable*) _tmp6_);
	_g_object_unref0 (_tmp6_);
	_tmp7_ = rc;
	_tmp8_ = spread_number;
	_tmp9_ = zcd_serializable_int_new (_tmp8_);
	_tmp10_ = _tmp9_;
	zcd_remote_call_add_parameter (_tmp7_, (zcdISerializable*) _tmp10_);
	_g_object_unref0 (_tmp10_);
	_tmp11_ = rc;
	_tmp12_ = replicate;
	_tmp13_ = zcd_serializable_bool_new (_tmp12_);
	_tmp14_ = _tmp13_;
	zcd_remote_call_add_parameter (_tmp11_, (zcdISerializable*) _tmp14_);
	_g_object_unref0 (_tmp14_);
	{
		zcdRemoteCall* _tmp15_;
		zcdISerializable* _tmp16_ = NULL;
		zcdISerializable* _tmp17_;
		zcdISerializable* _tmp18_;
		zcdISerializable* _tmp19_ = NULL;
		zcdISerializable* _tmp20_;
		zcdISerializable* _tmp21_;
		zcdISerializable* _tmp22_;
		zcdISerializable* _tmp23_ = NULL;
		zcdISerializable* _tmp24_;
		zcdISerializable* _tmp25_;
		_tmp15_ = rc;
		_tmp16_ = netsukuku_rmt_peer_rmt ((NetsukukuRmtPeer*) self, _tmp15_, &_inner_error_);
		_tmp17_ = _tmp16_;
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == ZCD_RPC_ERROR) {
				goto __catch5_zcd_rpc_error;
			}
			goto __catch5_g_error;
		}
		_tmp18_ = _tmp17_;
		_tmp19_ = netsukuku_filter_exception_PeerRefuseServiceError (_tmp18_, &_inner_error_);
		_tmp20_ = _tmp19_;
		_g_object_unref0 (_tmp18_);
		_tmp21_ = _tmp20_;
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == ZCD_RPC_ERROR) {
				goto __catch5_zcd_rpc_error;
			}
			goto __catch5_g_error;
		}
		_tmp22_ = _tmp21_;
		_tmp23_ = zcd_filter_exception (_tmp22_, &_inner_error_);
		_tmp24_ = _tmp23_;
		_g_object_unref0 (_tmp22_);
		_tmp25_ = _tmp24_;
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == ZCD_RPC_ERROR) {
				goto __catch5_zcd_rpc_error;
			}
			goto __catch5_g_error;
		}
		result = G_TYPE_CHECK_INSTANCE_CAST (_tmp25_, NETSUKUKU_TYPE_ANDNA_REGISTER_SPREAD_RESPONSE, NetsukukuAndnaRegisterSpreadResponse);
		_g_object_unref0 (rc);
		return result;
	}
	goto __finally5;
	__catch5_zcd_rpc_error:
	{
		GError* e = NULL;
		GError* _tmp26_;
		GError* _tmp27_;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp26_ = e;
		_tmp27_ = _g_error_copy0 (_tmp26_);
		_inner_error_ = _tmp27_;
		_g_error_free0 (e);
		goto __finally5;
	}
	goto __finally5;
	__catch5_g_error:
	{
		GError* e = NULL;
		GError* _tmp28_;
		GQuark _tmp29_;
		const gchar* _tmp30_ = NULL;
		GError* _tmp31_;
		gint _tmp32_;
		gchar* _tmp33_ = NULL;
		gchar* _tmp34_;
		GError* _tmp35_;
		const gchar* _tmp36_;
		const gchar* _tmp37_ = NULL;
		gchar* _tmp38_ = NULL;
		gchar* _tmp39_;
		GError* _tmp40_;
		GError* _tmp41_;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp28_ = e;
		_tmp29_ = _tmp28_->domain;
		_tmp30_ = g_quark_to_string (_tmp29_);
		_tmp31_ = e;
		_tmp32_ = _tmp31_->code;
		_tmp33_ = g_strdup_printf ("%i", _tmp32_);
		_tmp34_ = _tmp33_;
		_tmp35_ = e;
		_tmp36_ = _tmp35_->message;
		_tmp37_ = string_to_string (_tmp36_);
		_tmp38_ = g_strconcat ("Unexpected error ", _tmp30_, ".", _tmp34_, " '", _tmp37_, "'", NULL);
		_tmp39_ = _tmp38_;
		_tmp40_ = g_error_new_literal (ZCD_RPC_ERROR, ZCD_RPC_ERROR_GENERIC, _tmp39_);
		_tmp41_ = _tmp40_;
		_g_free0 (_tmp39_);
		_g_free0 (_tmp34_);
		_inner_error_ = _tmp41_;
		_g_error_free0 (e);
		goto __finally5;
	}
	__finally5:
	if ((_inner_error_->domain == ZCD_RPC_ERROR) || (_inner_error_->domain == NETSUKUKU_PEER_REFUSE_SERVICE_ERROR)) {
		g_propagate_error (error, _inner_error_);
		_g_object_unref0 (rc);
		return NULL;
	} else {
		_g_object_unref0 (rc);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return NULL;
	}
	_g_object_unref0 (rc);
}


static NetsukukuAndnaGetServersResponse* netsukuku_rmt_andna_peer_real_get_servers (NetsukukuIAndnaAsPeer* base, const gchar* hashed_domain, NetsukukuAndnaServiceKey* srv_key, gint spread_number, gboolean chain, GError** error) {
	NetsukukuRmtAndnaPeer * self;
	NetsukukuAndnaGetServersResponse* result = NULL;
	zcdRemoteCall* _tmp0_;
	zcdRemoteCall* rc;
	zcdRemoteCall* _tmp1_;
	gchar* _tmp2_;
	zcdRemoteCall* _tmp3_;
	const gchar* _tmp4_;
	zcdSerializableString* _tmp5_;
	zcdSerializableString* _tmp6_;
	zcdRemoteCall* _tmp7_;
	NetsukukuAndnaServiceKey* _tmp8_;
	zcdRemoteCall* _tmp9_;
	gint _tmp10_;
	zcdSerializableInt* _tmp11_;
	zcdSerializableInt* _tmp12_;
	zcdRemoteCall* _tmp13_;
	gboolean _tmp14_;
	zcdSerializableBool* _tmp15_;
	zcdSerializableBool* _tmp16_;
	GError * _inner_error_ = NULL;
	self = (NetsukukuRmtAndnaPeer*) base;
	g_return_val_if_fail (hashed_domain != NULL, NULL);
	g_return_val_if_fail (srv_key != NULL, NULL);
	_tmp0_ = zcd_remote_call_new ();
	rc = _tmp0_;
	_tmp1_ = rc;
	_tmp2_ = g_strdup ("get_servers");
	_g_free0 (_tmp1_->method_name);
	_tmp1_->method_name = _tmp2_;
	_tmp3_ = rc;
	_tmp4_ = hashed_domain;
	_tmp5_ = zcd_serializable_string_new (_tmp4_);
	_tmp6_ = _tmp5_;
	zcd_remote_call_add_parameter (_tmp3_, (zcdISerializable*) _tmp6_);
	_g_object_unref0 (_tmp6_);
	_tmp7_ = rc;
	_tmp8_ = srv_key;
	zcd_remote_call_add_parameter (_tmp7_, (zcdISerializable*) _tmp8_);
	_tmp9_ = rc;
	_tmp10_ = spread_number;
	_tmp11_ = zcd_serializable_int_new (_tmp10_);
	_tmp12_ = _tmp11_;
	zcd_remote_call_add_parameter (_tmp9_, (zcdISerializable*) _tmp12_);
	_g_object_unref0 (_tmp12_);
	_tmp13_ = rc;
	_tmp14_ = chain;
	_tmp15_ = zcd_serializable_bool_new (_tmp14_);
	_tmp16_ = _tmp15_;
	zcd_remote_call_add_parameter (_tmp13_, (zcdISerializable*) _tmp16_);
	_g_object_unref0 (_tmp16_);
	{
		zcdRemoteCall* _tmp17_;
		zcdISerializable* _tmp18_ = NULL;
		zcdISerializable* _tmp19_;
		zcdISerializable* _tmp20_;
		zcdISerializable* _tmp21_ = NULL;
		zcdISerializable* _tmp22_;
		zcdISerializable* _tmp23_;
		zcdISerializable* _tmp24_;
		zcdISerializable* _tmp25_ = NULL;
		zcdISerializable* _tmp26_;
		zcdISerializable* _tmp27_;
		_tmp17_ = rc;
		_tmp18_ = netsukuku_rmt_peer_rmt ((NetsukukuRmtPeer*) self, _tmp17_, &_inner_error_);
		_tmp19_ = _tmp18_;
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == ZCD_RPC_ERROR) {
				goto __catch6_zcd_rpc_error;
			}
			goto __catch6_g_error;
		}
		_tmp20_ = _tmp19_;
		_tmp21_ = netsukuku_filter_exception_PeerRefuseServiceError (_tmp20_, &_inner_error_);
		_tmp22_ = _tmp21_;
		_g_object_unref0 (_tmp20_);
		_tmp23_ = _tmp22_;
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == ZCD_RPC_ERROR) {
				goto __catch6_zcd_rpc_error;
			}
			goto __catch6_g_error;
		}
		_tmp24_ = _tmp23_;
		_tmp25_ = zcd_filter_exception (_tmp24_, &_inner_error_);
		_tmp26_ = _tmp25_;
		_g_object_unref0 (_tmp24_);
		_tmp27_ = _tmp26_;
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == ZCD_RPC_ERROR) {
				goto __catch6_zcd_rpc_error;
			}
			goto __catch6_g_error;
		}
		result = G_TYPE_CHECK_INSTANCE_CAST (_tmp27_, NETSUKUKU_TYPE_ANDNA_GET_SERVERS_RESPONSE, NetsukukuAndnaGetServersResponse);
		_g_object_unref0 (rc);
		return result;
	}
	goto __finally6;
	__catch6_zcd_rpc_error:
	{
		GError* e = NULL;
		GError* _tmp28_;
		GError* _tmp29_;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp28_ = e;
		_tmp29_ = _g_error_copy0 (_tmp28_);
		_inner_error_ = _tmp29_;
		_g_error_free0 (e);
		goto __finally6;
	}
	goto __finally6;
	__catch6_g_error:
	{
		GError* e = NULL;
		GError* _tmp30_;
		GQuark _tmp31_;
		const gchar* _tmp32_ = NULL;
		GError* _tmp33_;
		gint _tmp34_;
		gchar* _tmp35_ = NULL;
		gchar* _tmp36_;
		GError* _tmp37_;
		const gchar* _tmp38_;
		const gchar* _tmp39_ = NULL;
		gchar* _tmp40_ = NULL;
		gchar* _tmp41_;
		GError* _tmp42_;
		GError* _tmp43_;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp30_ = e;
		_tmp31_ = _tmp30_->domain;
		_tmp32_ = g_quark_to_string (_tmp31_);
		_tmp33_ = e;
		_tmp34_ = _tmp33_->code;
		_tmp35_ = g_strdup_printf ("%i", _tmp34_);
		_tmp36_ = _tmp35_;
		_tmp37_ = e;
		_tmp38_ = _tmp37_->message;
		_tmp39_ = string_to_string (_tmp38_);
		_tmp40_ = g_strconcat ("Unexpected error ", _tmp32_, ".", _tmp36_, " '", _tmp39_, "'", NULL);
		_tmp41_ = _tmp40_;
		_tmp42_ = g_error_new_literal (ZCD_RPC_ERROR, ZCD_RPC_ERROR_GENERIC, _tmp41_);
		_tmp43_ = _tmp42_;
		_g_free0 (_tmp41_);
		_g_free0 (_tmp36_);
		_inner_error_ = _tmp43_;
		_g_error_free0 (e);
		goto __finally6;
	}
	__finally6:
	if ((_inner_error_->domain == ZCD_RPC_ERROR) || (_inner_error_->domain == NETSUKUKU_PEER_REFUSE_SERVICE_ERROR)) {
		g_propagate_error (error, _inner_error_);
		_g_object_unref0 (rc);
		return NULL;
	} else {
		_g_object_unref0 (rc);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return NULL;
	}
	_g_object_unref0 (rc);
}


static NetsukukuAndnaGetCacheRecordsResponse* netsukuku_rmt_andna_peer_real_get_cache_records (NetsukukuIAndnaAsPeer* base, GError** error) {
	NetsukukuRmtAndnaPeer * self;
	NetsukukuAndnaGetCacheRecordsResponse* result = NULL;
	zcdRemoteCall* _tmp0_;
	zcdRemoteCall* rc;
	zcdRemoteCall* _tmp1_;
	gchar* _tmp2_;
	GError * _inner_error_ = NULL;
	self = (NetsukukuRmtAndnaPeer*) base;
	_tmp0_ = zcd_remote_call_new ();
	rc = _tmp0_;
	_tmp1_ = rc;
	_tmp2_ = g_strdup ("get_cache_records");
	_g_free0 (_tmp1_->method_name);
	_tmp1_->method_name = _tmp2_;
	{
		zcdRemoteCall* _tmp3_;
		zcdISerializable* _tmp4_ = NULL;
		zcdISerializable* _tmp5_;
		zcdISerializable* _tmp6_;
		zcdISerializable* _tmp7_ = NULL;
		zcdISerializable* _tmp8_;
		zcdISerializable* _tmp9_;
		zcdISerializable* _tmp10_;
		zcdISerializable* _tmp11_ = NULL;
		zcdISerializable* _tmp12_;
		zcdISerializable* _tmp13_;
		_tmp3_ = rc;
		_tmp4_ = netsukuku_rmt_peer_rmt ((NetsukukuRmtPeer*) self, _tmp3_, &_inner_error_);
		_tmp5_ = _tmp4_;
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == ZCD_RPC_ERROR) {
				goto __catch7_zcd_rpc_error;
			}
			goto __catch7_g_error;
		}
		_tmp6_ = _tmp5_;
		_tmp7_ = netsukuku_filter_exception_PeerRefuseServiceError (_tmp6_, &_inner_error_);
		_tmp8_ = _tmp7_;
		_g_object_unref0 (_tmp6_);
		_tmp9_ = _tmp8_;
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == ZCD_RPC_ERROR) {
				goto __catch7_zcd_rpc_error;
			}
			goto __catch7_g_error;
		}
		_tmp10_ = _tmp9_;
		_tmp11_ = zcd_filter_exception (_tmp10_, &_inner_error_);
		_tmp12_ = _tmp11_;
		_g_object_unref0 (_tmp10_);
		_tmp13_ = _tmp12_;
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == ZCD_RPC_ERROR) {
				goto __catch7_zcd_rpc_error;
			}
			goto __catch7_g_error;
		}
		result = G_TYPE_CHECK_INSTANCE_CAST (_tmp13_, NETSUKUKU_TYPE_ANDNA_GET_CACHE_RECORDS_RESPONSE, NetsukukuAndnaGetCacheRecordsResponse);
		_g_object_unref0 (rc);
		return result;
	}
	goto __finally7;
	__catch7_zcd_rpc_error:
	{
		GError* e = NULL;
		GError* _tmp14_;
		GError* _tmp15_;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp14_ = e;
		_tmp15_ = _g_error_copy0 (_tmp14_);
		_inner_error_ = _tmp15_;
		_g_error_free0 (e);
		goto __finally7;
	}
	goto __finally7;
	__catch7_g_error:
	{
		GError* e = NULL;
		GError* _tmp16_;
		GQuark _tmp17_;
		const gchar* _tmp18_ = NULL;
		GError* _tmp19_;
		gint _tmp20_;
		gchar* _tmp21_ = NULL;
		gchar* _tmp22_;
		GError* _tmp23_;
		const gchar* _tmp24_;
		const gchar* _tmp25_ = NULL;
		gchar* _tmp26_ = NULL;
		gchar* _tmp27_;
		GError* _tmp28_;
		GError* _tmp29_;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp16_ = e;
		_tmp17_ = _tmp16_->domain;
		_tmp18_ = g_quark_to_string (_tmp17_);
		_tmp19_ = e;
		_tmp20_ = _tmp19_->code;
		_tmp21_ = g_strdup_printf ("%i", _tmp20_);
		_tmp22_ = _tmp21_;
		_tmp23_ = e;
		_tmp24_ = _tmp23_->message;
		_tmp25_ = string_to_string (_tmp24_);
		_tmp26_ = g_strconcat ("Unexpected error ", _tmp18_, ".", _tmp22_, " '", _tmp25_, "'", NULL);
		_tmp27_ = _tmp26_;
		_tmp28_ = g_error_new_literal (ZCD_RPC_ERROR, ZCD_RPC_ERROR_GENERIC, _tmp27_);
		_tmp29_ = _tmp28_;
		_g_free0 (_tmp27_);
		_g_free0 (_tmp22_);
		_inner_error_ = _tmp29_;
		_g_error_free0 (e);
		goto __finally7;
	}
	__finally7:
	if ((_inner_error_->domain == ZCD_RPC_ERROR) || (_inner_error_->domain == NETSUKUKU_PEER_REFUSE_SERVICE_ERROR)) {
		g_propagate_error (error, _inner_error_);
		_g_object_unref0 (rc);
		return NULL;
	} else {
		_g_object_unref0 (rc);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return NULL;
	}
	_g_object_unref0 (rc);
}


static void netsukuku_rmt_andna_peer_class_init (NetsukukuRmtAndnaPeerClass * klass) {
	netsukuku_rmt_andna_peer_parent_class = g_type_class_peek_parent (klass);
}


static void netsukuku_rmt_andna_peer_netsukuku_iandna_as_peer_interface_init (NetsukukuIAndnaAsPeerIface * iface) {
	netsukuku_rmt_andna_peer_netsukuku_iandna_as_peer_parent_iface = g_type_interface_peek_parent (iface);
	iface->register_main_for_pubk = (NetsukukuAndnaRegisterMainResponse* (*)(NetsukukuIAndnaAsPeer*, NetsukukuAndnaDomainRequest*, zcdSerializableBuffer*, gboolean, GError**)) netsukuku_rmt_andna_peer_real_register_main_for_pubk;
	iface->get_registrar = (NetsukukuAndnaGetRegistrarResponse* (*)(NetsukukuIAndnaAsPeer*, const gchar*, GError**)) netsukuku_rmt_andna_peer_real_get_registrar;
	iface->get_domain_record = (NetsukukuAndnaDomainRecord* (*)(NetsukukuIAndnaAsPeer*, const gchar*, GError**)) netsukuku_rmt_andna_peer_real_get_domain_record;
	iface->register_spread_record = (NetsukukuAndnaRegisterSpreadResponse* (*)(NetsukukuIAndnaAsPeer*, const gchar*, gint, gboolean, GError**)) netsukuku_rmt_andna_peer_real_register_spread_record;
	iface->get_servers = (NetsukukuAndnaGetServersResponse* (*)(NetsukukuIAndnaAsPeer*, const gchar*, NetsukukuAndnaServiceKey*, gint, gboolean, GError**)) netsukuku_rmt_andna_peer_real_get_servers;
	iface->get_cache_records = (NetsukukuAndnaGetCacheRecordsResponse* (*)(NetsukukuIAndnaAsPeer*, GError**)) netsukuku_rmt_andna_peer_real_get_cache_records;
}


static void netsukuku_rmt_andna_peer_instance_init (NetsukukuRmtAndnaPeer * self) {
}


GType netsukuku_rmt_andna_peer_get_type (void) {
	static volatile gsize netsukuku_rmt_andna_peer_type_id__volatile = 0;
	if (g_once_init_enter (&netsukuku_rmt_andna_peer_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (NetsukukuRmtAndnaPeerClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) netsukuku_rmt_andna_peer_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (NetsukukuRmtAndnaPeer), 0, (GInstanceInitFunc) netsukuku_rmt_andna_peer_instance_init, NULL };
		static const GInterfaceInfo netsukuku_iandna_as_peer_info = { (GInterfaceInitFunc) netsukuku_rmt_andna_peer_netsukuku_iandna_as_peer_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
		GType netsukuku_rmt_andna_peer_type_id;
		netsukuku_rmt_andna_peer_type_id = g_type_register_static (NETSUKUKU_TYPE_RMT_PEER, "NetsukukuRmtAndnaPeer", &g_define_type_info, 0);
		g_type_add_interface_static (netsukuku_rmt_andna_peer_type_id, NETSUKUKU_TYPE_IANDNA_AS_PEER, &netsukuku_iandna_as_peer_info);
		g_once_init_leave (&netsukuku_rmt_andna_peer_type_id__volatile, netsukuku_rmt_andna_peer_type_id);
	}
	return netsukuku_rmt_andna_peer_type_id__volatile;
}


NetsukukuAndnaServiceHashnodeKey* netsukuku_andna_service_hashnode_key_construct (GType object_type, const gchar* hashed_domain, gint spread_num) {
	NetsukukuAndnaServiceHashnodeKey * self = NULL;
	const gchar* _tmp0_;
	gint _tmp1_;
	g_return_val_if_fail (hashed_domain != NULL, NULL);
	self = (NetsukukuAndnaServiceHashnodeKey*) g_object_new (object_type, NULL);
	_tmp0_ = hashed_domain;
	netsukuku_andna_service_hashnode_key_set_hashed_domain (self, _tmp0_);
	_tmp1_ = spread_num;
	netsukuku_andna_service_hashnode_key_set_spread_num (self, _tmp1_);
	return self;
}


NetsukukuAndnaServiceHashnodeKey* netsukuku_andna_service_hashnode_key_new (const gchar* hashed_domain, gint spread_num) {
	return netsukuku_andna_service_hashnode_key_construct (NETSUKUKU_TYPE_ANDNA_SERVICE_HASHNODE_KEY, hashed_domain, spread_num);
}


gboolean netsukuku_andna_service_hashnode_key_equal_func (NetsukukuAndnaServiceHashnodeKey* a, NetsukukuAndnaServiceHashnodeKey* b) {
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
	NetsukukuAndnaServiceHashnodeKey* _tmp1_;
	const gchar* _tmp2_;
	NetsukukuAndnaServiceHashnodeKey* _tmp3_;
	const gchar* _tmp4_;
	gboolean _tmp9_;
	g_return_val_if_fail (a != NULL, FALSE);
	g_return_val_if_fail (b != NULL, FALSE);
	_tmp1_ = a;
	_tmp2_ = _tmp1_->priv->_hashed_domain;
	_tmp3_ = b;
	_tmp4_ = _tmp3_->priv->_hashed_domain;
	if (g_strcmp0 (_tmp2_, _tmp4_) == 0) {
		NetsukukuAndnaServiceHashnodeKey* _tmp5_;
		gint _tmp6_;
		NetsukukuAndnaServiceHashnodeKey* _tmp7_;
		gint _tmp8_;
		_tmp5_ = a;
		_tmp6_ = _tmp5_->priv->_spread_num;
		_tmp7_ = b;
		_tmp8_ = _tmp7_->priv->_spread_num;
		_tmp0_ = _tmp6_ == _tmp8_;
	} else {
		_tmp0_ = FALSE;
	}
	_tmp9_ = _tmp0_;
	result = _tmp9_;
	return result;
}


const gchar* netsukuku_andna_service_hashnode_key_get_hashed_domain (NetsukukuAndnaServiceHashnodeKey* self) {
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_hashed_domain;
	result = _tmp0_;
	return result;
}


static void netsukuku_andna_service_hashnode_key_set_hashed_domain (NetsukukuAndnaServiceHashnodeKey* self, const gchar* value) {
	const gchar* _tmp0_;
	gchar* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	_tmp1_ = g_strdup (_tmp0_);
	_g_free0 (self->priv->_hashed_domain);
	self->priv->_hashed_domain = _tmp1_;
	g_object_notify ((GObject *) self, "hashed-domain");
}


gint netsukuku_andna_service_hashnode_key_get_spread_num (NetsukukuAndnaServiceHashnodeKey* self) {
	gint result;
	gint _tmp0_;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = self->priv->_spread_num;
	result = _tmp0_;
	return result;
}


static void netsukuku_andna_service_hashnode_key_set_spread_num (NetsukukuAndnaServiceHashnodeKey* self, gint value) {
	gint _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	self->priv->_spread_num = _tmp0_;
	g_object_notify ((GObject *) self, "spread-num");
}


static void netsukuku_andna_service_hashnode_key_class_init (NetsukukuAndnaServiceHashnodeKeyClass * klass) {
	netsukuku_andna_service_hashnode_key_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (NetsukukuAndnaServiceHashnodeKeyPrivate));
	G_OBJECT_CLASS (klass)->get_property = _vala_netsukuku_andna_service_hashnode_key_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_netsukuku_andna_service_hashnode_key_set_property;
	G_OBJECT_CLASS (klass)->finalize = netsukuku_andna_service_hashnode_key_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), NETSUKUKU_ANDNA_SERVICE_HASHNODE_KEY_HASHED_DOMAIN, g_param_spec_string ("hashed-domain", "hashed-domain", "hashed-domain", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), NETSUKUKU_ANDNA_SERVICE_HASHNODE_KEY_SPREAD_NUM, g_param_spec_int ("spread-num", "spread-num", "spread-num", G_MININT, G_MAXINT, 0, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
}


static void netsukuku_andna_service_hashnode_key_instance_init (NetsukukuAndnaServiceHashnodeKey * self) {
	self->priv = NETSUKUKU_ANDNA_SERVICE_HASHNODE_KEY_GET_PRIVATE (self);
}


static void netsukuku_andna_service_hashnode_key_finalize (GObject* obj) {
	NetsukukuAndnaServiceHashnodeKey * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, NETSUKUKU_TYPE_ANDNA_SERVICE_HASHNODE_KEY, NetsukukuAndnaServiceHashnodeKey);
	_g_free0 (self->priv->_hashed_domain);
	G_OBJECT_CLASS (netsukuku_andna_service_hashnode_key_parent_class)->finalize (obj);
}


GType netsukuku_andna_service_hashnode_key_get_type (void) {
	static volatile gsize netsukuku_andna_service_hashnode_key_type_id__volatile = 0;
	if (g_once_init_enter (&netsukuku_andna_service_hashnode_key_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (NetsukukuAndnaServiceHashnodeKeyClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) netsukuku_andna_service_hashnode_key_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (NetsukukuAndnaServiceHashnodeKey), 0, (GInstanceInitFunc) netsukuku_andna_service_hashnode_key_instance_init, NULL };
		GType netsukuku_andna_service_hashnode_key_type_id;
		netsukuku_andna_service_hashnode_key_type_id = g_type_register_static (G_TYPE_OBJECT, "NetsukukuAndnaServiceHashnodeKey", &g_define_type_info, 0);
		g_once_init_leave (&netsukuku_andna_service_hashnode_key_type_id__volatile, netsukuku_andna_service_hashnode_key_type_id);
	}
	return netsukuku_andna_service_hashnode_key_type_id__volatile;
}


static void _vala_netsukuku_andna_service_hashnode_key_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	NetsukukuAndnaServiceHashnodeKey * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, NETSUKUKU_TYPE_ANDNA_SERVICE_HASHNODE_KEY, NetsukukuAndnaServiceHashnodeKey);
	switch (property_id) {
		case NETSUKUKU_ANDNA_SERVICE_HASHNODE_KEY_HASHED_DOMAIN:
		g_value_set_string (value, netsukuku_andna_service_hashnode_key_get_hashed_domain (self));
		break;
		case NETSUKUKU_ANDNA_SERVICE_HASHNODE_KEY_SPREAD_NUM:
		g_value_set_int (value, netsukuku_andna_service_hashnode_key_get_spread_num (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _vala_netsukuku_andna_service_hashnode_key_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	NetsukukuAndnaServiceHashnodeKey * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, NETSUKUKU_TYPE_ANDNA_SERVICE_HASHNODE_KEY, NetsukukuAndnaServiceHashnodeKey);
	switch (property_id) {
		case NETSUKUKU_ANDNA_SERVICE_HASHNODE_KEY_HASHED_DOMAIN:
		netsukuku_andna_service_hashnode_key_set_hashed_domain (self, g_value_get_string (value));
		break;
		case NETSUKUKU_ANDNA_SERVICE_HASHNODE_KEY_SPREAD_NUM:
		netsukuku_andna_service_hashnode_key_set_spread_num (self, g_value_get_int (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


NetsukukuArgumentsForDuplicationRegisterSpread* netsukuku_arguments_for_duplication_register_spread_construct (GType object_type) {
	NetsukukuArgumentsForDuplicationRegisterSpread * self = NULL;
	self = (NetsukukuArgumentsForDuplicationRegisterSpread*) g_object_new (object_type, NULL);
	return self;
}


NetsukukuArgumentsForDuplicationRegisterSpread* netsukuku_arguments_for_duplication_register_spread_new (void) {
	return netsukuku_arguments_for_duplication_register_spread_construct (NETSUKUKU_TYPE_ARGUMENTS_FOR_DUPLICATION_REGISTER_SPREAD);
}


static void netsukuku_arguments_for_duplication_register_spread_class_init (NetsukukuArgumentsForDuplicationRegisterSpreadClass * klass) {
	netsukuku_arguments_for_duplication_register_spread_parent_class = g_type_class_peek_parent (klass);
	G_OBJECT_CLASS (klass)->finalize = netsukuku_arguments_for_duplication_register_spread_finalize;
}


static void netsukuku_arguments_for_duplication_register_spread_instance_init (NetsukukuArgumentsForDuplicationRegisterSpread * self) {
}


static void netsukuku_arguments_for_duplication_register_spread_finalize (GObject* obj) {
	NetsukukuArgumentsForDuplicationRegisterSpread * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, NETSUKUKU_TYPE_ARGUMENTS_FOR_DUPLICATION_REGISTER_SPREAD, NetsukukuArgumentsForDuplicationRegisterSpread);
	_g_free0 (self->hashed_domain);
	_g_object_unref0 (self->hashnode);
	G_OBJECT_CLASS (netsukuku_arguments_for_duplication_register_spread_parent_class)->finalize (obj);
}


GType netsukuku_arguments_for_duplication_register_spread_get_type (void) {
	static volatile gsize netsukuku_arguments_for_duplication_register_spread_type_id__volatile = 0;
	if (g_once_init_enter (&netsukuku_arguments_for_duplication_register_spread_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (NetsukukuArgumentsForDuplicationRegisterSpreadClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) netsukuku_arguments_for_duplication_register_spread_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (NetsukukuArgumentsForDuplicationRegisterSpread), 0, (GInstanceInitFunc) netsukuku_arguments_for_duplication_register_spread_instance_init, NULL };
		GType netsukuku_arguments_for_duplication_register_spread_type_id;
		netsukuku_arguments_for_duplication_register_spread_type_id = g_type_register_static (G_TYPE_OBJECT, "NetsukukuArgumentsForDuplicationRegisterSpread", &g_define_type_info, 0);
		g_once_init_leave (&netsukuku_arguments_for_duplication_register_spread_type_id__volatile, netsukuku_arguments_for_duplication_register_spread_type_id);
	}
	return netsukuku_arguments_for_duplication_register_spread_type_id__volatile;
}


NetsukukuArgumentsForDuplicationRegisterMain* netsukuku_arguments_for_duplication_register_main_construct (GType object_type) {
	NetsukukuArgumentsForDuplicationRegisterMain * self = NULL;
	self = (NetsukukuArgumentsForDuplicationRegisterMain*) g_object_new (object_type, NULL);
	return self;
}


NetsukukuArgumentsForDuplicationRegisterMain* netsukuku_arguments_for_duplication_register_main_new (void) {
	return netsukuku_arguments_for_duplication_register_main_construct (NETSUKUKU_TYPE_ARGUMENTS_FOR_DUPLICATION_REGISTER_MAIN);
}


static void netsukuku_arguments_for_duplication_register_main_class_init (NetsukukuArgumentsForDuplicationRegisterMainClass * klass) {
	netsukuku_arguments_for_duplication_register_main_parent_class = g_type_class_peek_parent (klass);
	G_OBJECT_CLASS (klass)->finalize = netsukuku_arguments_for_duplication_register_main_finalize;
}


static void netsukuku_arguments_for_duplication_register_main_instance_init (NetsukukuArgumentsForDuplicationRegisterMain * self) {
}


static void netsukuku_arguments_for_duplication_register_main_finalize (GObject* obj) {
	NetsukukuArgumentsForDuplicationRegisterMain * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, NETSUKUKU_TYPE_ARGUMENTS_FOR_DUPLICATION_REGISTER_MAIN, NetsukukuArgumentsForDuplicationRegisterMain);
	_g_object_unref0 (self->request);
	_g_object_unref0 (self->signature);
	_g_object_unref0 (self->hashnode);
	G_OBJECT_CLASS (netsukuku_arguments_for_duplication_register_main_parent_class)->finalize (obj);
}


GType netsukuku_arguments_for_duplication_register_main_get_type (void) {
	static volatile gsize netsukuku_arguments_for_duplication_register_main_type_id__volatile = 0;
	if (g_once_init_enter (&netsukuku_arguments_for_duplication_register_main_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (NetsukukuArgumentsForDuplicationRegisterMainClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) netsukuku_arguments_for_duplication_register_main_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (NetsukukuArgumentsForDuplicationRegisterMain), 0, (GInstanceInitFunc) netsukuku_arguments_for_duplication_register_main_instance_init, NULL };
		GType netsukuku_arguments_for_duplication_register_main_type_id;
		netsukuku_arguments_for_duplication_register_main_type_id = g_type_register_static (G_TYPE_OBJECT, "NetsukukuArgumentsForDuplicationRegisterMain", &g_define_type_info, 0);
		g_once_init_leave (&netsukuku_arguments_for_duplication_register_main_type_id__volatile, netsukuku_arguments_for_duplication_register_main_type_id);
	}
	return netsukuku_arguments_for_duplication_register_main_type_id__volatile;
}


gboolean netsukuku_domain_wanted_equal_func (NetsukukuDomainWanted* a, NetsukukuDomainWanted* b) {
	gboolean result = FALSE;
	NetsukukuDomainWanted* _tmp0_;
	const gchar* _tmp1_;
	NetsukukuDomainWanted* _tmp2_;
	const gchar* _tmp3_;
	g_return_val_if_fail (a != NULL, FALSE);
	g_return_val_if_fail (b != NULL, FALSE);
	_tmp0_ = a;
	_tmp1_ = _tmp0_->hostname;
	_tmp2_ = b;
	_tmp3_ = _tmp2_->hostname;
	result = g_strcmp0 (_tmp1_, _tmp3_) == 0;
	return result;
}


NetsukukuDomainWanted* netsukuku_domain_wanted_construct (GType object_type) {
	NetsukukuDomainWanted * self = NULL;
	self = (NetsukukuDomainWanted*) g_object_new (object_type, NULL);
	return self;
}


NetsukukuDomainWanted* netsukuku_domain_wanted_new (void) {
	return netsukuku_domain_wanted_construct (NETSUKUKU_TYPE_DOMAIN_WANTED);
}


static void netsukuku_domain_wanted_class_init (NetsukukuDomainWantedClass * klass) {
	netsukuku_domain_wanted_parent_class = g_type_class_peek_parent (klass);
	G_OBJECT_CLASS (klass)->finalize = netsukuku_domain_wanted_finalize;
}


static void netsukuku_domain_wanted_instance_init (NetsukukuDomainWanted * self) {
}


static void netsukuku_domain_wanted_finalize (GObject* obj) {
	NetsukukuDomainWanted * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, NETSUKUKU_TYPE_DOMAIN_WANTED, NetsukukuDomainWanted);
	_g_free0 (self->hostname);
	_g_object_unref0 (self->ttl_before_request);
	_g_object_unref0 (self->tasklet);
	G_OBJECT_CLASS (netsukuku_domain_wanted_parent_class)->finalize (obj);
}


GType netsukuku_domain_wanted_get_type (void) {
	static volatile gsize netsukuku_domain_wanted_type_id__volatile = 0;
	if (g_once_init_enter (&netsukuku_domain_wanted_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (NetsukukuDomainWantedClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) netsukuku_domain_wanted_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (NetsukukuDomainWanted), 0, (GInstanceInitFunc) netsukuku_domain_wanted_instance_init, NULL };
		GType netsukuku_domain_wanted_type_id;
		netsukuku_domain_wanted_type_id = g_type_register_static (G_TYPE_OBJECT, "NetsukukuDomainWanted", &g_define_type_info, 0);
		g_once_init_leave (&netsukuku_domain_wanted_type_id__volatile, netsukuku_domain_wanted_type_id);
	}
	return netsukuku_domain_wanted_type_id__volatile;
}


static void _netsukuku_andna_init_memory_netsukuku_peer_to_peer_map_peer_to_peer_validated (NetsukukuPeerToPeer* _sender, gpointer self) {
	netsukuku_andna_init_memory (self);
}


static gboolean _netsukuku_domain_wanted_equal_func_gee_equal_data_func (gconstpointer a, gconstpointer b, gpointer self) {
	gboolean result;
	result = netsukuku_domain_wanted_equal_func (a, b);
	return result;
}


NetsukukuAndna* netsukuku_andna_construct (GType object_type, NetsukukuKeyPair* keypair, NetsukukuCounter* counter, NetsukukuAggregatedNeighbourManager* aggregated_neighbour_manager, NetsukukuMapRoute* maproute, NetsukukuPeerToPeerAll* peer_to_peer_all) {
	NetsukukuAndna * self = NULL;
	NetsukukuAggregatedNeighbourManager* _tmp0_;
	NetsukukuMapRoute* _tmp1_;
	NetsukukuPeerToPeerAll* _tmp2_;
	NetsukukuPeerToPeerAll* _tmp3_;
	GeeArrayList* _tmp9_;
	NetsukukuCounter* _tmp10_;
	NetsukukuCounter* _tmp11_;
	NetsukukuKeyPair* _tmp12_;
	NetsukukuKeyPair* _tmp13_;
	GeeHashMap* _tmp14_;
	GeeHashMap* _tmp15_;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (keypair != NULL, NULL);
	g_return_val_if_fail (counter != NULL, NULL);
	g_return_val_if_fail (aggregated_neighbour_manager != NULL, NULL);
	g_return_val_if_fail (maproute != NULL, NULL);
	g_return_val_if_fail (peer_to_peer_all != NULL, NULL);
	_tmp0_ = aggregated_neighbour_manager;
	_tmp1_ = maproute;
	self = (NetsukukuAndna*) netsukuku_peer_to_peer_construct (object_type, _tmp0_, _tmp1_, NETSUKUKU_ANDNA_mypid);
	_tmp2_ = peer_to_peer_all;
	_tmp3_ = _g_object_ref0 (_tmp2_);
	_g_object_unref0 (self->priv->peer_to_peer_all);
	self->priv->peer_to_peer_all = _tmp3_;
	{
		NetsukukuPeerToPeerAll* _tmp4_;
		_tmp4_ = peer_to_peer_all;
		netsukuku_peer_to_peer_all_peer_to_peer_register (_tmp4_, (NetsukukuPeerToPeer*) self, &_inner_error_);
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == NETSUKUKU_PEER_TO_PEER_ERROR) {
				goto __catch8_netsukuku_peer_to_peer_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	}
	goto __finally8;
	__catch8_netsukuku_peer_to_peer_error:
	{
		GError* e = NULL;
		const gchar* _tmp5_;
		const gchar* _tmp6_ = NULL;
		gchar* _tmp7_ = NULL;
		gchar* _tmp8_;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp5_ = e->message;
		_tmp6_ = string_to_string (_tmp5_);
		_tmp7_ = g_strconcat ("Andna: registering failed: ", _tmp6_, NULL);
		_tmp8_ = _tmp7_;
		g_error ("andna.vala:455: %s", _tmp8_);
		_g_free0 (_tmp8_);
		_g_error_free0 (e);
	}
	__finally8:
	if (_inner_error_ != NULL) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return NULL;
	}
	self->memory_initialized = FALSE;
	g_signal_connect_object ((NetsukukuPeerToPeer*) self, "map-peer-to-peer-validated", (GCallback) _netsukuku_andna_init_memory_netsukuku_peer_to_peer_map_peer_to_peer_validated, self, 0);
	_tmp9_ = gee_array_list_new (NETSUKUKU_TYPE_DOMAIN_WANTED, (GBoxedCopyFunc) g_object_ref, g_object_unref, _netsukuku_domain_wanted_equal_func_gee_equal_data_func, NULL, NULL);
	_g_object_unref0 (self->priv->lst_domains);
	self->priv->lst_domains = _tmp9_;
	_tmp10_ = counter;
	_tmp11_ = _g_object_ref0 (_tmp10_);
	_g_object_unref0 (self->priv->counter);
	self->priv->counter = _tmp11_;
	_tmp12_ = keypair;
	_tmp13_ = _g_object_ref0 (_tmp12_);
	_g_object_unref0 (self->priv->my_keys);
	self->priv->my_keys = _tmp13_;
	_tmp14_ = gee_hash_map_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, GEE_TYPE_ARRAY_LIST, (GBoxedCopyFunc) g_object_ref, g_object_unref, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
	_g_object_unref0 (self->priv->request_queue);
	self->priv->request_queue = _tmp14_;
	_tmp15_ = gee_hash_map_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, NETSUKUKU_TYPE_ANDNA_DOMAIN_RECORD, (GBoxedCopyFunc) g_object_ref, g_object_unref, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
	_g_object_unref0 (self->priv->cache);
	self->priv->cache = _tmp15_;
	return self;
}


NetsukukuAndna* netsukuku_andna_new (NetsukukuKeyPair* keypair, NetsukukuCounter* counter, NetsukukuAggregatedNeighbourManager* aggregated_neighbour_manager, NetsukukuMapRoute* maproute, NetsukukuPeerToPeerAll* peer_to_peer_all) {
	return netsukuku_andna_construct (NETSUKUKU_TYPE_ANDNA, keypair, counter, aggregated_neighbour_manager, maproute, peer_to_peer_all);
}


NetsukukuRmtAndnaPeer* netsukuku_andna_peer (NetsukukuAndna* self, NetsukukuNIP* hIP, GObject* key, NetsukukuAggregatedNeighbour* aggregated_neighbour) {
	NetsukukuRmtAndnaPeer* result = NULL;
	gboolean _tmp0_ = FALSE;
	NetsukukuNIP* _tmp1_;
	gboolean _tmp3_;
	GObject* _tmp4_;
	NetsukukuNIP* _tmp5_;
	NetsukukuAggregatedNeighbour* _tmp6_;
	NetsukukuRmtAndnaPeer* _tmp7_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp1_ = hIP;
	if (_tmp1_ != NULL) {
		_tmp0_ = TRUE;
	} else {
		GObject* _tmp2_;
		_tmp2_ = key;
		_tmp0_ = _tmp2_ != NULL;
	}
	_tmp3_ = _tmp0_;
	_vala_assert (_tmp3_, "hIP != null || key != null");
	_tmp4_ = key;
	_tmp5_ = hIP;
	_tmp6_ = aggregated_neighbour;
	_tmp7_ = netsukuku_rmt_andna_peer_new ((NetsukukuPeerToPeer*) self, _tmp4_, _tmp5_, _tmp6_);
	result = _tmp7_;
	return result;
}


/** This method could be called *directly* for a dispatcher that does not need to transform
          * an exception into a remotable.
          */
static zcdISerializable* netsukuku_andna_real__dispatch (NetsukukuPeerToPeer* base, GObject* caller, zcdRemoteCall* data, GError** error) {
	NetsukukuAndna * self;
	zcdISerializable* result = NULL;
	zcdRemoteCall* _tmp0_;
	const gchar* _tmp1_;
	gchar** _tmp2_;
	gchar** _tmp3_ = NULL;
	gchar** pieces;
	gint pieces_length1;
	gint _pieces_size_;
	gchar** _tmp4_;
	gint _tmp4__length1;
	const gchar* _tmp5_;
	gchar** _tmp50_;
	gint _tmp50__length1;
	const gchar* _tmp51_;
	gchar** _tmp76_;
	gint _tmp76__length1;
	const gchar* _tmp77_;
	gchar** _tmp102_;
	gint _tmp102__length1;
	const gchar* _tmp103_;
	gchar** _tmp151_;
	gint _tmp151__length1;
	const gchar* _tmp152_;
	gchar** _tmp211_;
	gint _tmp211__length1;
	const gchar* _tmp212_;
	GObject* _tmp223_;
	zcdRemoteCall* _tmp224_;
	zcdISerializable* _tmp225_ = NULL;
	zcdISerializable* _tmp226_;
	GError * _inner_error_ = NULL;
	self = (NetsukukuAndna*) base;
	g_return_val_if_fail (data != NULL, NULL);
	_tmp0_ = data;
	_tmp1_ = _tmp0_->method_name;
	_tmp3_ = _tmp2_ = g_strsplit (_tmp1_, ".", 0);
	pieces = _tmp3_;
	pieces_length1 = _vala_array_length (_tmp2_);
	_pieces_size_ = pieces_length1;
	_tmp4_ = pieces;
	_tmp4__length1 = pieces_length1;
	_tmp5_ = _tmp4_[0];
	if (g_strcmp0 (_tmp5_, "register_main_for_pubk") == 0) {
		gchar** _tmp6_;
		gint _tmp6__length1;
		zcdRemoteCall* _tmp8_;
		GeeList* _tmp9_;
		GeeList* _tmp10_;
		gint _tmp11_;
		gint _tmp12_;
		zcdRemoteCall* _tmp14_;
		GeeList* _tmp15_;
		GeeList* _tmp16_;
		gpointer _tmp17_ = NULL;
		zcdISerializable* iser0;
		zcdISerializable* _tmp18_;
		GType _tmp19_ = 0UL;
		gboolean _tmp20_ = FALSE;
		zcdISerializable* _tmp22_;
		NetsukukuAndnaDomainRequest* _tmp23_;
		NetsukukuAndnaDomainRequest* request;
		zcdRemoteCall* _tmp24_;
		GeeList* _tmp25_;
		GeeList* _tmp26_;
		gpointer _tmp27_ = NULL;
		zcdISerializable* iser1;
		zcdISerializable* _tmp28_;
		GType _tmp29_ = 0UL;
		gboolean _tmp30_ = FALSE;
		zcdISerializable* _tmp32_;
		zcdSerializableBuffer* _tmp33_;
		zcdSerializableBuffer* signature;
		zcdRemoteCall* _tmp34_;
		GeeList* _tmp35_;
		GeeList* _tmp36_;
		gpointer _tmp37_ = NULL;
		zcdISerializable* iser2;
		zcdISerializable* _tmp38_;
		GType _tmp39_ = 0UL;
		gboolean _tmp40_ = FALSE;
		zcdISerializable* _tmp42_;
		gboolean _tmp43_;
		gboolean _tmp44_;
		gboolean replicate;
		NetsukukuAndnaDomainRequest* _tmp45_;
		zcdSerializableBuffer* _tmp46_;
		gboolean _tmp47_;
		NetsukukuAndnaRegisterMainResponse* _tmp48_ = NULL;
		NetsukukuAndnaRegisterMainResponse* _tmp49_;
		_tmp6_ = pieces;
		_tmp6__length1 = pieces_length1;
		if (_tmp6__length1 != 1) {
			GError* _tmp7_;
			_tmp7_ = g_error_new_literal (ZCD_RPC_ERROR, ZCD_RPC_ERROR_MALFORMED_PACKET, "register_main_for_pubk is a function.");
			_inner_error_ = _tmp7_;
			g_propagate_error (error, _inner_error_);
			pieces = (_vala_array_free (pieces, pieces_length1, (GDestroyNotify) g_free), NULL);
			return NULL;
		}
		_tmp8_ = data;
		_tmp9_ = zcd_remote_call_get_parameters (_tmp8_);
		_tmp10_ = _tmp9_;
		_tmp11_ = gee_collection_get_size ((GeeCollection*) _tmp10_);
		_tmp12_ = _tmp11_;
		if (_tmp12_ != 3) {
			GError* _tmp13_;
			_tmp13_ = g_error_new_literal (ZCD_RPC_ERROR, ZCD_RPC_ERROR_MALFORMED_PACKET, "register_main_for_pubk wants 3 parameters.");
			_inner_error_ = _tmp13_;
			g_propagate_error (error, _inner_error_);
			pieces = (_vala_array_free (pieces, pieces_length1, (GDestroyNotify) g_free), NULL);
			return NULL;
		}
		_tmp14_ = data;
		_tmp15_ = zcd_remote_call_get_parameters (_tmp14_);
		_tmp16_ = _tmp15_;
		_tmp17_ = gee_list_get (_tmp16_, 0);
		iser0 = (zcdISerializable*) _tmp17_;
		_tmp18_ = iser0;
		_tmp19_ = G_TYPE_FROM_INSTANCE ((GObject*) _tmp18_);
		_tmp20_ = g_type_is_a (_tmp19_, NETSUKUKU_TYPE_ANDNA_DOMAIN_REQUEST);
		if (!_tmp20_) {
			GError* _tmp21_;
			_tmp21_ = g_error_new_literal (ZCD_RPC_ERROR, ZCD_RPC_ERROR_MALFORMED_PACKET, "register_main_for_pubk parameter 1 is not a AndnaDomainRequest.");
			_inner_error_ = _tmp21_;
			g_propagate_error (error, _inner_error_);
			_g_object_unref0 (iser0);
			pieces = (_vala_array_free (pieces, pieces_length1, (GDestroyNotify) g_free), NULL);
			return NULL;
		}
		_tmp22_ = iser0;
		_tmp23_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp22_, NETSUKUKU_TYPE_ANDNA_DOMAIN_REQUEST, NetsukukuAndnaDomainRequest));
		request = _tmp23_;
		_tmp24_ = data;
		_tmp25_ = zcd_remote_call_get_parameters (_tmp24_);
		_tmp26_ = _tmp25_;
		_tmp27_ = gee_list_get (_tmp26_, 1);
		iser1 = (zcdISerializable*) _tmp27_;
		_tmp28_ = iser1;
		_tmp29_ = G_TYPE_FROM_INSTANCE ((GObject*) _tmp28_);
		_tmp30_ = g_type_is_a (_tmp29_, ZCD_TYPE_SERIALIZABLE_BUFFER);
		if (!_tmp30_) {
			GError* _tmp31_;
			_tmp31_ = g_error_new_literal (ZCD_RPC_ERROR, ZCD_RPC_ERROR_MALFORMED_PACKET, "register_main_for_pubk parameter 2 is not a SerializableBuffer.");
			_inner_error_ = _tmp31_;
			g_propagate_error (error, _inner_error_);
			_g_object_unref0 (iser1);
			_g_object_unref0 (request);
			_g_object_unref0 (iser0);
			pieces = (_vala_array_free (pieces, pieces_length1, (GDestroyNotify) g_free), NULL);
			return NULL;
		}
		_tmp32_ = iser1;
		_tmp33_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp32_, ZCD_TYPE_SERIALIZABLE_BUFFER, zcdSerializableBuffer));
		signature = _tmp33_;
		_tmp34_ = data;
		_tmp35_ = zcd_remote_call_get_parameters (_tmp34_);
		_tmp36_ = _tmp35_;
		_tmp37_ = gee_list_get (_tmp36_, 2);
		iser2 = (zcdISerializable*) _tmp37_;
		_tmp38_ = iser2;
		_tmp39_ = G_TYPE_FROM_INSTANCE ((GObject*) _tmp38_);
		_tmp40_ = g_type_is_a (_tmp39_, ZCD_TYPE_SERIALIZABLE_BOOL);
		if (!_tmp40_) {
			GError* _tmp41_;
			_tmp41_ = g_error_new_literal (ZCD_RPC_ERROR, ZCD_RPC_ERROR_MALFORMED_PACKET, "register_main_for_pubk parameter 3 is not a bool.");
			_inner_error_ = _tmp41_;
			g_propagate_error (error, _inner_error_);
			_g_object_unref0 (iser2);
			_g_object_unref0 (signature);
			_g_object_unref0 (iser1);
			_g_object_unref0 (request);
			_g_object_unref0 (iser0);
			pieces = (_vala_array_free (pieces, pieces_length1, (GDestroyNotify) g_free), NULL);
			return NULL;
		}
		_tmp42_ = iser2;
		_tmp43_ = zcd_serializable_bool_get_b (G_TYPE_CHECK_INSTANCE_CAST (_tmp42_, ZCD_TYPE_SERIALIZABLE_BOOL, zcdSerializableBool));
		_tmp44_ = _tmp43_;
		replicate = _tmp44_;
		_tmp45_ = request;
		_tmp46_ = signature;
		_tmp47_ = replicate;
		_tmp48_ = netsukuku_iandna_as_peer_register_main_for_pubk ((NetsukukuIAndnaAsPeer*) self, _tmp45_, _tmp46_, _tmp47_, &_inner_error_);
		_tmp49_ = _tmp48_;
		if (_inner_error_ != NULL) {
			g_propagate_error (error, _inner_error_);
			_g_object_unref0 (iser2);
			_g_object_unref0 (signature);
			_g_object_unref0 (iser1);
			_g_object_unref0 (request);
			_g_object_unref0 (iser0);
			pieces = (_vala_array_free (pieces, pieces_length1, (GDestroyNotify) g_free), NULL);
			return NULL;
		}
		result = (zcdISerializable*) _tmp49_;
		_g_object_unref0 (iser2);
		_g_object_unref0 (signature);
		_g_object_unref0 (iser1);
		_g_object_unref0 (request);
		_g_object_unref0 (iser0);
		pieces = (_vala_array_free (pieces, pieces_length1, (GDestroyNotify) g_free), NULL);
		return result;
	}
	_tmp50_ = pieces;
	_tmp50__length1 = pieces_length1;
	_tmp51_ = _tmp50_[0];
	if (g_strcmp0 (_tmp51_, "get_registrar") == 0) {
		gchar** _tmp52_;
		gint _tmp52__length1;
		zcdRemoteCall* _tmp54_;
		GeeList* _tmp55_;
		GeeList* _tmp56_;
		gint _tmp57_;
		gint _tmp58_;
		zcdRemoteCall* _tmp60_;
		GeeList* _tmp61_;
		GeeList* _tmp62_;
		gpointer _tmp63_ = NULL;
		zcdISerializable* iser0;
		zcdISerializable* _tmp64_;
		GType _tmp65_ = 0UL;
		gboolean _tmp66_ = FALSE;
		zcdISerializable* _tmp68_;
		const gchar* _tmp69_;
		const gchar* _tmp70_;
		gchar* _tmp71_;
		gchar* hashed_domain;
		const gchar* _tmp72_;
		NetsukukuAndnaGetRegistrarResponse* _tmp73_ = NULL;
		NetsukukuAndnaGetRegistrarResponse* ret;
		NetsukukuAndnaGetRegistrarResponse* _tmp74_;
		_tmp52_ = pieces;
		_tmp52__length1 = pieces_length1;
		if (_tmp52__length1 != 1) {
			GError* _tmp53_;
			_tmp53_ = g_error_new_literal (ZCD_RPC_ERROR, ZCD_RPC_ERROR_MALFORMED_PACKET, "get_registrar is a function.");
			_inner_error_ = _tmp53_;
			g_propagate_error (error, _inner_error_);
			pieces = (_vala_array_free (pieces, pieces_length1, (GDestroyNotify) g_free), NULL);
			return NULL;
		}
		_tmp54_ = data;
		_tmp55_ = zcd_remote_call_get_parameters (_tmp54_);
		_tmp56_ = _tmp55_;
		_tmp57_ = gee_collection_get_size ((GeeCollection*) _tmp56_);
		_tmp58_ = _tmp57_;
		if (_tmp58_ != 1) {
			GError* _tmp59_;
			_tmp59_ = g_error_new_literal (ZCD_RPC_ERROR, ZCD_RPC_ERROR_MALFORMED_PACKET, "get_registrar wants 1 parameter.");
			_inner_error_ = _tmp59_;
			g_propagate_error (error, _inner_error_);
			pieces = (_vala_array_free (pieces, pieces_length1, (GDestroyNotify) g_free), NULL);
			return NULL;
		}
		_tmp60_ = data;
		_tmp61_ = zcd_remote_call_get_parameters (_tmp60_);
		_tmp62_ = _tmp61_;
		_tmp63_ = gee_list_get (_tmp62_, 0);
		iser0 = (zcdISerializable*) _tmp63_;
		_tmp64_ = iser0;
		_tmp65_ = G_TYPE_FROM_INSTANCE ((GObject*) _tmp64_);
		_tmp66_ = g_type_is_a (_tmp65_, ZCD_TYPE_SERIALIZABLE_STRING);
		if (!_tmp66_) {
			GError* _tmp67_;
			_tmp67_ = g_error_new_literal (ZCD_RPC_ERROR, ZCD_RPC_ERROR_MALFORMED_PACKET, "get_registrar parameter 1 is not a string.");
			_inner_error_ = _tmp67_;
			g_propagate_error (error, _inner_error_);
			_g_object_unref0 (iser0);
			pieces = (_vala_array_free (pieces, pieces_length1, (GDestroyNotify) g_free), NULL);
			return NULL;
		}
		_tmp68_ = iser0;
		_tmp69_ = zcd_serializable_string_get_s (G_TYPE_CHECK_INSTANCE_CAST (_tmp68_, ZCD_TYPE_SERIALIZABLE_STRING, zcdSerializableString));
		_tmp70_ = _tmp69_;
		_tmp71_ = g_strdup (_tmp70_);
		hashed_domain = _tmp71_;
		_tmp72_ = hashed_domain;
		_tmp73_ = netsukuku_iandna_as_peer_get_registrar ((NetsukukuIAndnaAsPeer*) self, _tmp72_, &_inner_error_);
		ret = _tmp73_;
		if (_inner_error_ != NULL) {
			g_propagate_error (error, _inner_error_);
			_g_free0 (hashed_domain);
			_g_object_unref0 (iser0);
			pieces = (_vala_array_free (pieces, pieces_length1, (GDestroyNotify) g_free), NULL);
			return NULL;
		}
		_tmp74_ = ret;
		if (_tmp74_ == NULL) {
			zcdSerializableNone* _tmp75_;
			_tmp75_ = zcd_serializable_none_new ();
			result = (zcdISerializable*) _tmp75_;
			_g_object_unref0 (ret);
			_g_free0 (hashed_domain);
			_g_object_unref0 (iser0);
			pieces = (_vala_array_free (pieces, pieces_length1, (GDestroyNotify) g_free), NULL);
			return result;
		}
		result = (zcdISerializable*) ret;
		_g_free0 (hashed_domain);
		_g_object_unref0 (iser0);
		pieces = (_vala_array_free (pieces, pieces_length1, (GDestroyNotify) g_free), NULL);
		return result;
	}
	_tmp76_ = pieces;
	_tmp76__length1 = pieces_length1;
	_tmp77_ = _tmp76_[0];
	if (g_strcmp0 (_tmp77_, "get_domain_record") == 0) {
		gchar** _tmp78_;
		gint _tmp78__length1;
		zcdRemoteCall* _tmp80_;
		GeeList* _tmp81_;
		GeeList* _tmp82_;
		gint _tmp83_;
		gint _tmp84_;
		zcdRemoteCall* _tmp86_;
		GeeList* _tmp87_;
		GeeList* _tmp88_;
		gpointer _tmp89_ = NULL;
		zcdISerializable* iser0;
		zcdISerializable* _tmp90_;
		GType _tmp91_ = 0UL;
		gboolean _tmp92_ = FALSE;
		zcdISerializable* _tmp94_;
		const gchar* _tmp95_;
		const gchar* _tmp96_;
		gchar* _tmp97_;
		gchar* hashed_domain;
		const gchar* _tmp98_;
		NetsukukuAndnaDomainRecord* _tmp99_ = NULL;
		NetsukukuAndnaDomainRecord* ret;
		NetsukukuAndnaDomainRecord* _tmp100_;
		_tmp78_ = pieces;
		_tmp78__length1 = pieces_length1;
		if (_tmp78__length1 != 1) {
			GError* _tmp79_;
			_tmp79_ = g_error_new_literal (ZCD_RPC_ERROR, ZCD_RPC_ERROR_MALFORMED_PACKET, "get_domain_record is a function.");
			_inner_error_ = _tmp79_;
			g_propagate_error (error, _inner_error_);
			pieces = (_vala_array_free (pieces, pieces_length1, (GDestroyNotify) g_free), NULL);
			return NULL;
		}
		_tmp80_ = data;
		_tmp81_ = zcd_remote_call_get_parameters (_tmp80_);
		_tmp82_ = _tmp81_;
		_tmp83_ = gee_collection_get_size ((GeeCollection*) _tmp82_);
		_tmp84_ = _tmp83_;
		if (_tmp84_ != 1) {
			GError* _tmp85_;
			_tmp85_ = g_error_new_literal (ZCD_RPC_ERROR, ZCD_RPC_ERROR_MALFORMED_PACKET, "get_domain_record wants 1 parameter.");
			_inner_error_ = _tmp85_;
			g_propagate_error (error, _inner_error_);
			pieces = (_vala_array_free (pieces, pieces_length1, (GDestroyNotify) g_free), NULL);
			return NULL;
		}
		_tmp86_ = data;
		_tmp87_ = zcd_remote_call_get_parameters (_tmp86_);
		_tmp88_ = _tmp87_;
		_tmp89_ = gee_list_get (_tmp88_, 0);
		iser0 = (zcdISerializable*) _tmp89_;
		_tmp90_ = iser0;
		_tmp91_ = G_TYPE_FROM_INSTANCE ((GObject*) _tmp90_);
		_tmp92_ = g_type_is_a (_tmp91_, ZCD_TYPE_SERIALIZABLE_STRING);
		if (!_tmp92_) {
			GError* _tmp93_;
			_tmp93_ = g_error_new_literal (ZCD_RPC_ERROR, ZCD_RPC_ERROR_MALFORMED_PACKET, "get_domain_record parameter 1 is not a string.");
			_inner_error_ = _tmp93_;
			g_propagate_error (error, _inner_error_);
			_g_object_unref0 (iser0);
			pieces = (_vala_array_free (pieces, pieces_length1, (GDestroyNotify) g_free), NULL);
			return NULL;
		}
		_tmp94_ = iser0;
		_tmp95_ = zcd_serializable_string_get_s (G_TYPE_CHECK_INSTANCE_CAST (_tmp94_, ZCD_TYPE_SERIALIZABLE_STRING, zcdSerializableString));
		_tmp96_ = _tmp95_;
		_tmp97_ = g_strdup (_tmp96_);
		hashed_domain = _tmp97_;
		_tmp98_ = hashed_domain;
		_tmp99_ = netsukuku_iandna_as_peer_get_domain_record ((NetsukukuIAndnaAsPeer*) self, _tmp98_, &_inner_error_);
		ret = _tmp99_;
		if (_inner_error_ != NULL) {
			g_propagate_error (error, _inner_error_);
			_g_free0 (hashed_domain);
			_g_object_unref0 (iser0);
			pieces = (_vala_array_free (pieces, pieces_length1, (GDestroyNotify) g_free), NULL);
			return NULL;
		}
		_tmp100_ = ret;
		if (_tmp100_ == NULL) {
			zcdSerializableNone* _tmp101_;
			_tmp101_ = zcd_serializable_none_new ();
			result = (zcdISerializable*) _tmp101_;
			_g_object_unref0 (ret);
			_g_free0 (hashed_domain);
			_g_object_unref0 (iser0);
			pieces = (_vala_array_free (pieces, pieces_length1, (GDestroyNotify) g_free), NULL);
			return result;
		}
		result = (zcdISerializable*) ret;
		_g_free0 (hashed_domain);
		_g_object_unref0 (iser0);
		pieces = (_vala_array_free (pieces, pieces_length1, (GDestroyNotify) g_free), NULL);
		return result;
	}
	_tmp102_ = pieces;
	_tmp102__length1 = pieces_length1;
	_tmp103_ = _tmp102_[0];
	if (g_strcmp0 (_tmp103_, "register_spread_record") == 0) {
		gchar** _tmp104_;
		gint _tmp104__length1;
		zcdRemoteCall* _tmp106_;
		GeeList* _tmp107_;
		GeeList* _tmp108_;
		gint _tmp109_;
		gint _tmp110_;
		zcdRemoteCall* _tmp112_;
		GeeList* _tmp113_;
		GeeList* _tmp114_;
		gpointer _tmp115_ = NULL;
		zcdISerializable* iser0;
		zcdISerializable* _tmp116_;
		GType _tmp117_ = 0UL;
		gboolean _tmp118_ = FALSE;
		zcdISerializable* _tmp120_;
		const gchar* _tmp121_;
		const gchar* _tmp122_;
		gchar* _tmp123_;
		gchar* hashed_domain;
		zcdRemoteCall* _tmp124_;
		GeeList* _tmp125_;
		GeeList* _tmp126_;
		gpointer _tmp127_ = NULL;
		zcdISerializable* iser1;
		zcdISerializable* _tmp128_;
		GType _tmp129_ = 0UL;
		gboolean _tmp130_ = FALSE;
		zcdISerializable* _tmp132_;
		gint _tmp133_;
		gint _tmp134_;
		gint spread_number;
		zcdRemoteCall* _tmp135_;
		GeeList* _tmp136_;
		GeeList* _tmp137_;
		gpointer _tmp138_ = NULL;
		zcdISerializable* iser2;
		zcdISerializable* _tmp139_;
		GType _tmp140_ = 0UL;
		gboolean _tmp141_ = FALSE;
		zcdISerializable* _tmp143_;
		gboolean _tmp144_;
		gboolean _tmp145_;
		gboolean replicate;
		const gchar* _tmp146_;
		gint _tmp147_;
		gboolean _tmp148_;
		NetsukukuAndnaRegisterSpreadResponse* _tmp149_ = NULL;
		NetsukukuAndnaRegisterSpreadResponse* _tmp150_;
		_tmp104_ = pieces;
		_tmp104__length1 = pieces_length1;
		if (_tmp104__length1 != 1) {
			GError* _tmp105_;
			_tmp105_ = g_error_new_literal (ZCD_RPC_ERROR, ZCD_RPC_ERROR_MALFORMED_PACKET, "register_spread_record is a function.");
			_inner_error_ = _tmp105_;
			g_propagate_error (error, _inner_error_);
			pieces = (_vala_array_free (pieces, pieces_length1, (GDestroyNotify) g_free), NULL);
			return NULL;
		}
		_tmp106_ = data;
		_tmp107_ = zcd_remote_call_get_parameters (_tmp106_);
		_tmp108_ = _tmp107_;
		_tmp109_ = gee_collection_get_size ((GeeCollection*) _tmp108_);
		_tmp110_ = _tmp109_;
		if (_tmp110_ != 3) {
			GError* _tmp111_;
			_tmp111_ = g_error_new_literal (ZCD_RPC_ERROR, ZCD_RPC_ERROR_MALFORMED_PACKET, "register_spread_record wants 3 parameters.");
			_inner_error_ = _tmp111_;
			g_propagate_error (error, _inner_error_);
			pieces = (_vala_array_free (pieces, pieces_length1, (GDestroyNotify) g_free), NULL);
			return NULL;
		}
		_tmp112_ = data;
		_tmp113_ = zcd_remote_call_get_parameters (_tmp112_);
		_tmp114_ = _tmp113_;
		_tmp115_ = gee_list_get (_tmp114_, 0);
		iser0 = (zcdISerializable*) _tmp115_;
		_tmp116_ = iser0;
		_tmp117_ = G_TYPE_FROM_INSTANCE ((GObject*) _tmp116_);
		_tmp118_ = g_type_is_a (_tmp117_, ZCD_TYPE_SERIALIZABLE_STRING);
		if (!_tmp118_) {
			GError* _tmp119_;
			_tmp119_ = g_error_new_literal (ZCD_RPC_ERROR, ZCD_RPC_ERROR_MALFORMED_PACKET, "register_spread_record parameter 1 is not a string.");
			_inner_error_ = _tmp119_;
			g_propagate_error (error, _inner_error_);
			_g_object_unref0 (iser0);
			pieces = (_vala_array_free (pieces, pieces_length1, (GDestroyNotify) g_free), NULL);
			return NULL;
		}
		_tmp120_ = iser0;
		_tmp121_ = zcd_serializable_string_get_s (G_TYPE_CHECK_INSTANCE_CAST (_tmp120_, ZCD_TYPE_SERIALIZABLE_STRING, zcdSerializableString));
		_tmp122_ = _tmp121_;
		_tmp123_ = g_strdup (_tmp122_);
		hashed_domain = _tmp123_;
		_tmp124_ = data;
		_tmp125_ = zcd_remote_call_get_parameters (_tmp124_);
		_tmp126_ = _tmp125_;
		_tmp127_ = gee_list_get (_tmp126_, 1);
		iser1 = (zcdISerializable*) _tmp127_;
		_tmp128_ = iser1;
		_tmp129_ = G_TYPE_FROM_INSTANCE ((GObject*) _tmp128_);
		_tmp130_ = g_type_is_a (_tmp129_, ZCD_TYPE_SERIALIZABLE_INT);
		if (!_tmp130_) {
			GError* _tmp131_;
			_tmp131_ = g_error_new_literal (ZCD_RPC_ERROR, ZCD_RPC_ERROR_MALFORMED_PACKET, "register_spread_record parameter 2 is not a int.");
			_inner_error_ = _tmp131_;
			g_propagate_error (error, _inner_error_);
			_g_object_unref0 (iser1);
			_g_free0 (hashed_domain);
			_g_object_unref0 (iser0);
			pieces = (_vala_array_free (pieces, pieces_length1, (GDestroyNotify) g_free), NULL);
			return NULL;
		}
		_tmp132_ = iser1;
		_tmp133_ = zcd_serializable_int_get_i (G_TYPE_CHECK_INSTANCE_CAST (_tmp132_, ZCD_TYPE_SERIALIZABLE_INT, zcdSerializableInt));
		_tmp134_ = _tmp133_;
		spread_number = _tmp134_;
		_tmp135_ = data;
		_tmp136_ = zcd_remote_call_get_parameters (_tmp135_);
		_tmp137_ = _tmp136_;
		_tmp138_ = gee_list_get (_tmp137_, 2);
		iser2 = (zcdISerializable*) _tmp138_;
		_tmp139_ = iser2;
		_tmp140_ = G_TYPE_FROM_INSTANCE ((GObject*) _tmp139_);
		_tmp141_ = g_type_is_a (_tmp140_, ZCD_TYPE_SERIALIZABLE_BOOL);
		if (!_tmp141_) {
			GError* _tmp142_;
			_tmp142_ = g_error_new_literal (ZCD_RPC_ERROR, ZCD_RPC_ERROR_MALFORMED_PACKET, "register_spread_record parameter 3 is not a bool.");
			_inner_error_ = _tmp142_;
			g_propagate_error (error, _inner_error_);
			_g_object_unref0 (iser2);
			_g_object_unref0 (iser1);
			_g_free0 (hashed_domain);
			_g_object_unref0 (iser0);
			pieces = (_vala_array_free (pieces, pieces_length1, (GDestroyNotify) g_free), NULL);
			return NULL;
		}
		_tmp143_ = iser2;
		_tmp144_ = zcd_serializable_bool_get_b (G_TYPE_CHECK_INSTANCE_CAST (_tmp143_, ZCD_TYPE_SERIALIZABLE_BOOL, zcdSerializableBool));
		_tmp145_ = _tmp144_;
		replicate = _tmp145_;
		_tmp146_ = hashed_domain;
		_tmp147_ = spread_number;
		_tmp148_ = replicate;
		_tmp149_ = netsukuku_iandna_as_peer_register_spread_record ((NetsukukuIAndnaAsPeer*) self, _tmp146_, _tmp147_, _tmp148_, &_inner_error_);
		_tmp150_ = _tmp149_;
		if (_inner_error_ != NULL) {
			g_propagate_error (error, _inner_error_);
			_g_object_unref0 (iser2);
			_g_object_unref0 (iser1);
			_g_free0 (hashed_domain);
			_g_object_unref0 (iser0);
			pieces = (_vala_array_free (pieces, pieces_length1, (GDestroyNotify) g_free), NULL);
			return NULL;
		}
		result = (zcdISerializable*) _tmp150_;
		_g_object_unref0 (iser2);
		_g_object_unref0 (iser1);
		_g_free0 (hashed_domain);
		_g_object_unref0 (iser0);
		pieces = (_vala_array_free (pieces, pieces_length1, (GDestroyNotify) g_free), NULL);
		return result;
	}
	_tmp151_ = pieces;
	_tmp151__length1 = pieces_length1;
	_tmp152_ = _tmp151_[0];
	if (g_strcmp0 (_tmp152_, "get_servers") == 0) {
		gchar** _tmp153_;
		gint _tmp153__length1;
		zcdRemoteCall* _tmp155_;
		GeeList* _tmp156_;
		GeeList* _tmp157_;
		gint _tmp158_;
		gint _tmp159_;
		zcdRemoteCall* _tmp161_;
		GeeList* _tmp162_;
		GeeList* _tmp163_;
		gpointer _tmp164_ = NULL;
		zcdISerializable* iser0;
		zcdISerializable* _tmp165_;
		GType _tmp166_ = 0UL;
		gboolean _tmp167_ = FALSE;
		zcdISerializable* _tmp169_;
		const gchar* _tmp170_;
		const gchar* _tmp171_;
		gchar* _tmp172_;
		gchar* hashed_domain;
		zcdRemoteCall* _tmp173_;
		GeeList* _tmp174_;
		GeeList* _tmp175_;
		gpointer _tmp176_ = NULL;
		zcdISerializable* iser1;
		zcdISerializable* _tmp177_;
		GType _tmp178_ = 0UL;
		gboolean _tmp179_ = FALSE;
		zcdISerializable* _tmp181_;
		NetsukukuAndnaServiceKey* _tmp182_;
		NetsukukuAndnaServiceKey* srv_key;
		zcdRemoteCall* _tmp183_;
		GeeList* _tmp184_;
		GeeList* _tmp185_;
		gpointer _tmp186_ = NULL;
		zcdISerializable* iser2;
		zcdISerializable* _tmp187_;
		GType _tmp188_ = 0UL;
		gboolean _tmp189_ = FALSE;
		zcdISerializable* _tmp191_;
		gint _tmp192_;
		gint _tmp193_;
		gint spread_number;
		zcdRemoteCall* _tmp194_;
		GeeList* _tmp195_;
		GeeList* _tmp196_;
		gpointer _tmp197_ = NULL;
		zcdISerializable* iser3;
		zcdISerializable* _tmp198_;
		GType _tmp199_ = 0UL;
		gboolean _tmp200_ = FALSE;
		zcdISerializable* _tmp202_;
		gboolean _tmp203_;
		gboolean _tmp204_;
		gboolean chain;
		const gchar* _tmp205_;
		NetsukukuAndnaServiceKey* _tmp206_;
		gint _tmp207_;
		gboolean _tmp208_;
		NetsukukuAndnaGetServersResponse* _tmp209_ = NULL;
		NetsukukuAndnaGetServersResponse* _tmp210_;
		_tmp153_ = pieces;
		_tmp153__length1 = pieces_length1;
		if (_tmp153__length1 != 1) {
			GError* _tmp154_;
			_tmp154_ = g_error_new_literal (ZCD_RPC_ERROR, ZCD_RPC_ERROR_MALFORMED_PACKET, "get_servers is a function.");
			_inner_error_ = _tmp154_;
			g_propagate_error (error, _inner_error_);
			pieces = (_vala_array_free (pieces, pieces_length1, (GDestroyNotify) g_free), NULL);
			return NULL;
		}
		_tmp155_ = data;
		_tmp156_ = zcd_remote_call_get_parameters (_tmp155_);
		_tmp157_ = _tmp156_;
		_tmp158_ = gee_collection_get_size ((GeeCollection*) _tmp157_);
		_tmp159_ = _tmp158_;
		if (_tmp159_ != 4) {
			GError* _tmp160_;
			_tmp160_ = g_error_new_literal (ZCD_RPC_ERROR, ZCD_RPC_ERROR_MALFORMED_PACKET, "get_servers wants 4 parameters.");
			_inner_error_ = _tmp160_;
			g_propagate_error (error, _inner_error_);
			pieces = (_vala_array_free (pieces, pieces_length1, (GDestroyNotify) g_free), NULL);
			return NULL;
		}
		_tmp161_ = data;
		_tmp162_ = zcd_remote_call_get_parameters (_tmp161_);
		_tmp163_ = _tmp162_;
		_tmp164_ = gee_list_get (_tmp163_, 0);
		iser0 = (zcdISerializable*) _tmp164_;
		_tmp165_ = iser0;
		_tmp166_ = G_TYPE_FROM_INSTANCE ((GObject*) _tmp165_);
		_tmp167_ = g_type_is_a (_tmp166_, ZCD_TYPE_SERIALIZABLE_STRING);
		if (!_tmp167_) {
			GError* _tmp168_;
			_tmp168_ = g_error_new_literal (ZCD_RPC_ERROR, ZCD_RPC_ERROR_MALFORMED_PACKET, "get_servers parameter 1 is not a string.");
			_inner_error_ = _tmp168_;
			g_propagate_error (error, _inner_error_);
			_g_object_unref0 (iser0);
			pieces = (_vala_array_free (pieces, pieces_length1, (GDestroyNotify) g_free), NULL);
			return NULL;
		}
		_tmp169_ = iser0;
		_tmp170_ = zcd_serializable_string_get_s (G_TYPE_CHECK_INSTANCE_CAST (_tmp169_, ZCD_TYPE_SERIALIZABLE_STRING, zcdSerializableString));
		_tmp171_ = _tmp170_;
		_tmp172_ = g_strdup (_tmp171_);
		hashed_domain = _tmp172_;
		_tmp173_ = data;
		_tmp174_ = zcd_remote_call_get_parameters (_tmp173_);
		_tmp175_ = _tmp174_;
		_tmp176_ = gee_list_get (_tmp175_, 1);
		iser1 = (zcdISerializable*) _tmp176_;
		_tmp177_ = iser1;
		_tmp178_ = G_TYPE_FROM_INSTANCE ((GObject*) _tmp177_);
		_tmp179_ = g_type_is_a (_tmp178_, NETSUKUKU_TYPE_ANDNA_SERVICE_KEY);
		if (!_tmp179_) {
			GError* _tmp180_;
			_tmp180_ = g_error_new_literal (ZCD_RPC_ERROR, ZCD_RPC_ERROR_MALFORMED_PACKET, "get_servers parameter 2 is not a AndnaServiceKey.");
			_inner_error_ = _tmp180_;
			g_propagate_error (error, _inner_error_);
			_g_object_unref0 (iser1);
			_g_free0 (hashed_domain);
			_g_object_unref0 (iser0);
			pieces = (_vala_array_free (pieces, pieces_length1, (GDestroyNotify) g_free), NULL);
			return NULL;
		}
		_tmp181_ = iser1;
		_tmp182_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp181_, NETSUKUKU_TYPE_ANDNA_SERVICE_KEY, NetsukukuAndnaServiceKey));
		srv_key = _tmp182_;
		_tmp183_ = data;
		_tmp184_ = zcd_remote_call_get_parameters (_tmp183_);
		_tmp185_ = _tmp184_;
		_tmp186_ = gee_list_get (_tmp185_, 2);
		iser2 = (zcdISerializable*) _tmp186_;
		_tmp187_ = iser2;
		_tmp188_ = G_TYPE_FROM_INSTANCE ((GObject*) _tmp187_);
		_tmp189_ = g_type_is_a (_tmp188_, ZCD_TYPE_SERIALIZABLE_INT);
		if (!_tmp189_) {
			GError* _tmp190_;
			_tmp190_ = g_error_new_literal (ZCD_RPC_ERROR, ZCD_RPC_ERROR_MALFORMED_PACKET, "get_servers parameter 3 is not a int.");
			_inner_error_ = _tmp190_;
			g_propagate_error (error, _inner_error_);
			_g_object_unref0 (iser2);
			_g_object_unref0 (srv_key);
			_g_object_unref0 (iser1);
			_g_free0 (hashed_domain);
			_g_object_unref0 (iser0);
			pieces = (_vala_array_free (pieces, pieces_length1, (GDestroyNotify) g_free), NULL);
			return NULL;
		}
		_tmp191_ = iser2;
		_tmp192_ = zcd_serializable_int_get_i (G_TYPE_CHECK_INSTANCE_CAST (_tmp191_, ZCD_TYPE_SERIALIZABLE_INT, zcdSerializableInt));
		_tmp193_ = _tmp192_;
		spread_number = _tmp193_;
		_tmp194_ = data;
		_tmp195_ = zcd_remote_call_get_parameters (_tmp194_);
		_tmp196_ = _tmp195_;
		_tmp197_ = gee_list_get (_tmp196_, 3);
		iser3 = (zcdISerializable*) _tmp197_;
		_tmp198_ = iser3;
		_tmp199_ = G_TYPE_FROM_INSTANCE ((GObject*) _tmp198_);
		_tmp200_ = g_type_is_a (_tmp199_, ZCD_TYPE_SERIALIZABLE_BOOL);
		if (!_tmp200_) {
			GError* _tmp201_;
			_tmp201_ = g_error_new_literal (ZCD_RPC_ERROR, ZCD_RPC_ERROR_MALFORMED_PACKET, "get_servers parameter 4 is not a bool.");
			_inner_error_ = _tmp201_;
			g_propagate_error (error, _inner_error_);
			_g_object_unref0 (iser3);
			_g_object_unref0 (iser2);
			_g_object_unref0 (srv_key);
			_g_object_unref0 (iser1);
			_g_free0 (hashed_domain);
			_g_object_unref0 (iser0);
			pieces = (_vala_array_free (pieces, pieces_length1, (GDestroyNotify) g_free), NULL);
			return NULL;
		}
		_tmp202_ = iser3;
		_tmp203_ = zcd_serializable_bool_get_b (G_TYPE_CHECK_INSTANCE_CAST (_tmp202_, ZCD_TYPE_SERIALIZABLE_BOOL, zcdSerializableBool));
		_tmp204_ = _tmp203_;
		chain = _tmp204_;
		_tmp205_ = hashed_domain;
		_tmp206_ = srv_key;
		_tmp207_ = spread_number;
		_tmp208_ = chain;
		_tmp209_ = netsukuku_iandna_as_peer_get_servers ((NetsukukuIAndnaAsPeer*) self, _tmp205_, _tmp206_, _tmp207_, _tmp208_, &_inner_error_);
		_tmp210_ = _tmp209_;
		if (_inner_error_ != NULL) {
			g_propagate_error (error, _inner_error_);
			_g_object_unref0 (iser3);
			_g_object_unref0 (iser2);
			_g_object_unref0 (srv_key);
			_g_object_unref0 (iser1);
			_g_free0 (hashed_domain);
			_g_object_unref0 (iser0);
			pieces = (_vala_array_free (pieces, pieces_length1, (GDestroyNotify) g_free), NULL);
			return NULL;
		}
		result = (zcdISerializable*) _tmp210_;
		_g_object_unref0 (iser3);
		_g_object_unref0 (iser2);
		_g_object_unref0 (srv_key);
		_g_object_unref0 (iser1);
		_g_free0 (hashed_domain);
		_g_object_unref0 (iser0);
		pieces = (_vala_array_free (pieces, pieces_length1, (GDestroyNotify) g_free), NULL);
		return result;
	}
	_tmp211_ = pieces;
	_tmp211__length1 = pieces_length1;
	_tmp212_ = _tmp211_[0];
	if (g_strcmp0 (_tmp212_, "get_cache_records") == 0) {
		gchar** _tmp213_;
		gint _tmp213__length1;
		zcdRemoteCall* _tmp215_;
		GeeList* _tmp216_;
		GeeList* _tmp217_;
		gint _tmp218_;
		gint _tmp219_;
		NetsukukuAndnaGetCacheRecordsResponse* _tmp221_ = NULL;
		NetsukukuAndnaGetCacheRecordsResponse* _tmp222_;
		_tmp213_ = pieces;
		_tmp213__length1 = pieces_length1;
		if (_tmp213__length1 != 1) {
			GError* _tmp214_;
			_tmp214_ = g_error_new_literal (ZCD_RPC_ERROR, ZCD_RPC_ERROR_MALFORMED_PACKET, "get_cache_records is a function.");
			_inner_error_ = _tmp214_;
			g_propagate_error (error, _inner_error_);
			pieces = (_vala_array_free (pieces, pieces_length1, (GDestroyNotify) g_free), NULL);
			return NULL;
		}
		_tmp215_ = data;
		_tmp216_ = zcd_remote_call_get_parameters (_tmp215_);
		_tmp217_ = _tmp216_;
		_tmp218_ = gee_collection_get_size ((GeeCollection*) _tmp217_);
		_tmp219_ = _tmp218_;
		if (_tmp219_ != 0) {
			GError* _tmp220_;
			_tmp220_ = g_error_new_literal (ZCD_RPC_ERROR, ZCD_RPC_ERROR_MALFORMED_PACKET, "get_cache_records wants no parameters.");
			_inner_error_ = _tmp220_;
			g_propagate_error (error, _inner_error_);
			pieces = (_vala_array_free (pieces, pieces_length1, (GDestroyNotify) g_free), NULL);
			return NULL;
		}
		_tmp221_ = netsukuku_iandna_as_peer_get_cache_records ((NetsukukuIAndnaAsPeer*) self, &_inner_error_);
		_tmp222_ = _tmp221_;
		if (_inner_error_ != NULL) {
			g_propagate_error (error, _inner_error_);
			pieces = (_vala_array_free (pieces, pieces_length1, (GDestroyNotify) g_free), NULL);
			return NULL;
		}
		result = (zcdISerializable*) _tmp222_;
		pieces = (_vala_array_free (pieces, pieces_length1, (GDestroyNotify) g_free), NULL);
		return result;
	}
	_tmp223_ = caller;
	_tmp224_ = data;
	_tmp225_ = NETSUKUKU_PEER_TO_PEER_CLASS (netsukuku_andna_parent_class)->_dispatch (G_TYPE_CHECK_INSTANCE_CAST (self, NETSUKUKU_TYPE_PEER_TO_PEER, NetsukukuPeerToPeer), _tmp223_, _tmp224_, &_inner_error_);
	_tmp226_ = _tmp225_;
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		pieces = (_vala_array_free (pieces, pieces_length1, (GDestroyNotify) g_free), NULL);
		return NULL;
	}
	result = _tmp226_;
	pieces = (_vala_array_free (pieces, pieces_length1, (GDestroyNotify) g_free), NULL);
	return result;
}


gchar* netsukuku_andna_crypto_hash (const gchar* hostname) {
	gchar* result = NULL;
	const gchar* _tmp0_;
	gchar* _tmp1_ = NULL;
	g_return_val_if_fail (hostname != NULL, NULL);
	_tmp0_ = hostname;
	_tmp1_ = netsukuku_andna_utilities_crypto_hash (_tmp0_);
	result = _tmp1_;
	return result;
}


static NetsukukuNIP* netsukuku_andna_nip_for_lvl_pos (NetsukukuAndna* self, gint lvl, gint pos) {
	NetsukukuNIP* result = NULL;
	NetsukukuMapRoute* _tmp0_;
	NetsukukuNIP* _tmp1_;
	gint _tmp2_ = 0;
	gint* _tmp3_ = NULL;
	gint* ret;
	gint ret_length1;
	gint _ret_size_;
	gint _tmp4_;
	gint _tmp5_;
	gint _tmp6_;
	NetsukukuNIP* _tmp7_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = ((NetsukukuPeerToPeer*) self)->maproute;
	_tmp1_ = _tmp0_->me;
	_tmp3_ = netsukuku_partial_nip_get_positions ((NetsukukuPartialNIP*) _tmp1_, &_tmp2_);
	ret = _tmp3_;
	ret_length1 = _tmp2_;
	_ret_size_ = ret_length1;
	_tmp4_ = lvl;
	_tmp5_ = pos;
	ret[_tmp4_] = _tmp5_;
	_tmp6_ = ret[_tmp4_];
	_tmp7_ = netsukuku_nip_new (ret, ret_length1);
	result = _tmp7_;
	ret = (g_free (ret), NULL);
	return result;
}


static gboolean _int_equal (const gint* s1, const gint* s2) {
	if (s1 == s2) {
		return TRUE;
	}
	if (s1 == NULL) {
		return FALSE;
	}
	if (s2 == NULL) {
		return FALSE;
	}
	return (*s1) == (*s2);
}


static void netsukuku_andna_impl_init_memory (NetsukukuAndna* self, GError** error) {
	GeeHashMap* _tmp0_;
	GeeHashMap* _tmp1_;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	tasklets_tasklet_declare_self ("Andna.init_memory");
	_tmp0_ = self->priv->cache;
	gee_abstract_map_clear ((GeeAbstractMap*) _tmp0_);
	_tmp1_ = self->priv->request_queue;
	gee_abstract_map_clear ((GeeAbstractMap*) _tmp1_);
	{
		gint lvl;
		lvl = 0;
		{
			gboolean _tmp2_;
			_tmp2_ = TRUE;
			while (TRUE) {
				gboolean _tmp3_;
				gint _tmp5_;
				NetsukukuMapRoute* _tmp6_;
				gint _tmp7_;
				gint* first_forward = NULL;
				gint* first_back = NULL;
				gint* last_back = NULL;
				gint _tmp8_;
				gint* _tmp9_ = NULL;
				gint* _tmp10_ = NULL;
				gint* _tmp11_ = NULL;
				gint* _tmp12_;
				_tmp3_ = _tmp2_;
				if (!_tmp3_) {
					gint _tmp4_;
					_tmp4_ = lvl;
					lvl = _tmp4_ + 1;
				}
				_tmp2_ = FALSE;
				_tmp5_ = lvl;
				_tmp6_ = ((NetsukukuPeerToPeer*) self)->maproute;
				_tmp7_ = _tmp6_->levels;
				if (!(_tmp5_ < _tmp7_)) {
					break;
				}
				_tmp8_ = lvl;
				netsukuku_peer_to_peer_find_hook_peers ((NetsukukuPeerToPeer*) self, &_tmp9_, &_tmp10_, &_tmp11_, _tmp8_, NETSUKUKU_ANDNA_DUPLICATION, 120000);
				_g_free0 (first_forward);
				first_forward = _tmp9_;
				_g_free0 (first_back);
				first_back = _tmp10_;
				_g_free0 (last_back);
				last_back = _tmp11_;
				_tmp12_ = first_forward;
				if (_tmp12_ == NULL) {
				} else {
					gint* _tmp13_;
					_tmp13_ = first_back;
					if (_tmp13_ == NULL) {
						gint _tmp14_;
						gint* _tmp15_;
						NetsukukuNIP* _tmp16_ = NULL;
						NetsukukuNIP* nip_first_forward;
						NetsukukuNIP* _tmp17_;
						NetsukukuRmtAndnaPeer* _tmp18_ = NULL;
						NetsukukuRmtAndnaPeer* peer_first_forward;
						NetsukukuRmtAndnaPeer* _tmp19_;
						NetsukukuAndnaGetCacheRecordsResponse* _tmp20_ = NULL;
						NetsukukuAndnaGetCacheRecordsResponse* cache_first_forward;
						_tmp14_ = lvl;
						_tmp15_ = first_forward;
						_tmp16_ = netsukuku_andna_nip_for_lvl_pos (self, _tmp14_, *_tmp15_);
						nip_first_forward = _tmp16_;
						_tmp17_ = nip_first_forward;
						_tmp18_ = netsukuku_andna_peer (self, _tmp17_, NULL, NULL);
						peer_first_forward = _tmp18_;
						_tmp19_ = peer_first_forward;
						_tmp20_ = netsukuku_iandna_as_peer_get_cache_records ((NetsukukuIAndnaAsPeer*) _tmp19_, &_inner_error_);
						cache_first_forward = _tmp20_;
						if (_inner_error_ != NULL) {
							g_propagate_error (error, _inner_error_);
							_g_object_unref0 (peer_first_forward);
							_g_object_unref0 (nip_first_forward);
							_g_free0 (last_back);
							_g_free0 (first_back);
							_g_free0 (first_forward);
							return;
						}
						{
							NetsukukuAndnaGetCacheRecordsResponse* _tmp21_;
							GeeHashMap* _tmp22_;
							GeeSet* _tmp23_;
							GeeSet* _tmp24_;
							GeeSet* _tmp25_;
							GeeIterator* _tmp26_ = NULL;
							GeeIterator* _tmp27_;
							GeeIterator* _hashed_domain_it;
							_tmp21_ = cache_first_forward;
							_tmp22_ = _tmp21_->cache;
							_tmp23_ = gee_abstract_map_get_keys ((GeeMap*) _tmp22_);
							_tmp24_ = _tmp23_;
							_tmp25_ = _tmp24_;
							_tmp26_ = gee_iterable_iterator ((GeeIterable*) _tmp25_);
							_tmp27_ = _tmp26_;
							_g_object_unref0 (_tmp25_);
							_hashed_domain_it = _tmp27_;
							while (TRUE) {
								GeeIterator* _tmp28_;
								gboolean _tmp29_ = FALSE;
								GeeIterator* _tmp30_;
								gpointer _tmp31_ = NULL;
								gchar* hashed_domain;
								GeeHashMap* _tmp32_;
								const gchar* _tmp33_;
								gboolean _tmp34_ = FALSE;
								_tmp28_ = _hashed_domain_it;
								_tmp29_ = gee_iterator_next (_tmp28_);
								if (!_tmp29_) {
									break;
								}
								_tmp30_ = _hashed_domain_it;
								_tmp31_ = gee_iterator_get (_tmp30_);
								hashed_domain = (gchar*) _tmp31_;
								_tmp32_ = self->priv->cache;
								_tmp33_ = hashed_domain;
								_tmp34_ = gee_abstract_map_has_key ((GeeAbstractMap*) _tmp32_, _tmp33_);
								if (!_tmp34_) {
									GeeHashMap* _tmp35_;
									const gchar* _tmp36_;
									NetsukukuAndnaGetCacheRecordsResponse* _tmp37_;
									GeeHashMap* _tmp38_;
									const gchar* _tmp39_;
									gpointer _tmp40_ = NULL;
									NetsukukuAndnaDomainRecord* _tmp41_;
									_tmp35_ = self->priv->cache;
									_tmp36_ = hashed_domain;
									_tmp37_ = cache_first_forward;
									_tmp38_ = _tmp37_->cache;
									_tmp39_ = hashed_domain;
									_tmp40_ = gee_abstract_map_get ((GeeAbstractMap*) _tmp38_, _tmp39_);
									_tmp41_ = (NetsukukuAndnaDomainRecord*) _tmp40_;
									gee_abstract_map_set ((GeeAbstractMap*) _tmp35_, _tmp36_, _tmp41_);
									_g_object_unref0 (_tmp41_);
								}
								_g_free0 (hashed_domain);
							}
							_g_object_unref0 (_hashed_domain_it);
						}
						{
							NetsukukuAndnaGetCacheRecordsResponse* _tmp42_;
							GeeHashMap* _tmp43_;
							GeeSet* _tmp44_;
							GeeSet* _tmp45_;
							GeeSet* _tmp46_;
							GeeIterator* _tmp47_ = NULL;
							GeeIterator* _tmp48_;
							GeeIterator* _hashed_domain_it;
							_tmp42_ = cache_first_forward;
							_tmp43_ = _tmp42_->request_queue;
							_tmp44_ = gee_abstract_map_get_keys ((GeeMap*) _tmp43_);
							_tmp45_ = _tmp44_;
							_tmp46_ = _tmp45_;
							_tmp47_ = gee_iterable_iterator ((GeeIterable*) _tmp46_);
							_tmp48_ = _tmp47_;
							_g_object_unref0 (_tmp46_);
							_hashed_domain_it = _tmp48_;
							while (TRUE) {
								GeeIterator* _tmp49_;
								gboolean _tmp50_ = FALSE;
								GeeIterator* _tmp51_;
								gpointer _tmp52_ = NULL;
								gchar* hashed_domain;
								GeeHashMap* _tmp53_;
								const gchar* _tmp54_;
								gboolean _tmp55_ = FALSE;
								_tmp49_ = _hashed_domain_it;
								_tmp50_ = gee_iterator_next (_tmp49_);
								if (!_tmp50_) {
									break;
								}
								_tmp51_ = _hashed_domain_it;
								_tmp52_ = gee_iterator_get (_tmp51_);
								hashed_domain = (gchar*) _tmp52_;
								_tmp53_ = self->priv->request_queue;
								_tmp54_ = hashed_domain;
								_tmp55_ = gee_abstract_map_has_key ((GeeAbstractMap*) _tmp53_, _tmp54_);
								if (!_tmp55_) {
									GeeHashMap* _tmp56_;
									const gchar* _tmp57_;
									NetsukukuAndnaGetCacheRecordsResponse* _tmp58_;
									GeeHashMap* _tmp59_;
									const gchar* _tmp60_;
									gpointer _tmp61_ = NULL;
									GeeArrayList* _tmp62_;
									_tmp56_ = self->priv->request_queue;
									_tmp57_ = hashed_domain;
									_tmp58_ = cache_first_forward;
									_tmp59_ = _tmp58_->request_queue;
									_tmp60_ = hashed_domain;
									_tmp61_ = gee_abstract_map_get ((GeeAbstractMap*) _tmp59_, _tmp60_);
									_tmp62_ = (GeeArrayList*) _tmp61_;
									gee_abstract_map_set ((GeeAbstractMap*) _tmp56_, _tmp57_, _tmp62_);
									_g_object_unref0 (_tmp62_);
								}
								_g_free0 (hashed_domain);
							}
							_g_object_unref0 (_hashed_domain_it);
						}
						_g_object_unref0 (cache_first_forward);
						_g_object_unref0 (peer_first_forward);
						_g_object_unref0 (nip_first_forward);
						_g_free0 (last_back);
						_g_free0 (first_back);
						_g_free0 (first_forward);
						break;
					} else {
						gint* _tmp63_;
						gint* _tmp64_;
						gint _tmp149_;
						gint* _tmp150_;
						NetsukukuNIP* _tmp151_ = NULL;
						NetsukukuNIP* nip_first_forward;
						NetsukukuNIP* _tmp152_;
						NetsukukuRmtAndnaPeer* _tmp153_ = NULL;
						NetsukukuRmtAndnaPeer* peer_first_forward;
						NetsukukuRmtAndnaPeer* _tmp154_;
						NetsukukuAndnaGetCacheRecordsResponse* _tmp155_ = NULL;
						NetsukukuAndnaGetCacheRecordsResponse* cache_first_forward;
						_tmp63_ = first_back;
						_tmp64_ = last_back;
						if (_int_equal (_tmp63_, _tmp64_) != TRUE) {
							gint _tmp65_;
							gint* _tmp66_;
							NetsukukuNIP* _tmp67_ = NULL;
							NetsukukuNIP* nip_first_back;
							NetsukukuNIP* _tmp68_;
							NetsukukuRmtAndnaPeer* _tmp69_ = NULL;
							NetsukukuRmtAndnaPeer* peer_first_back;
							gint _tmp70_;
							gint* _tmp71_;
							NetsukukuNIP* _tmp72_ = NULL;
							NetsukukuNIP* nip_last_back;
							NetsukukuNIP* _tmp73_;
							NetsukukuRmtAndnaPeer* _tmp74_ = NULL;
							NetsukukuRmtAndnaPeer* peer_last_back;
							NetsukukuRmtAndnaPeer* _tmp75_;
							NetsukukuAndnaGetCacheRecordsResponse* _tmp76_ = NULL;
							NetsukukuAndnaGetCacheRecordsResponse* recs_first;
							NetsukukuRmtAndnaPeer* _tmp77_;
							NetsukukuAndnaGetCacheRecordsResponse* _tmp78_ = NULL;
							NetsukukuAndnaGetCacheRecordsResponse* recs_last;
							_tmp65_ = lvl;
							_tmp66_ = first_back;
							_tmp67_ = netsukuku_andna_nip_for_lvl_pos (self, _tmp65_, *_tmp66_);
							nip_first_back = _tmp67_;
							_tmp68_ = nip_first_back;
							_tmp69_ = netsukuku_andna_peer (self, _tmp68_, NULL, NULL);
							peer_first_back = _tmp69_;
							_tmp70_ = lvl;
							_tmp71_ = last_back;
							_tmp72_ = netsukuku_andna_nip_for_lvl_pos (self, _tmp70_, *_tmp71_);
							nip_last_back = _tmp72_;
							_tmp73_ = nip_last_back;
							_tmp74_ = netsukuku_andna_peer (self, _tmp73_, NULL, NULL);
							peer_last_back = _tmp74_;
							_tmp75_ = peer_first_back;
							_tmp76_ = netsukuku_iandna_as_peer_get_cache_records ((NetsukukuIAndnaAsPeer*) _tmp75_, &_inner_error_);
							recs_first = _tmp76_;
							if (_inner_error_ != NULL) {
								g_propagate_error (error, _inner_error_);
								_g_object_unref0 (peer_last_back);
								_g_object_unref0 (nip_last_back);
								_g_object_unref0 (peer_first_back);
								_g_object_unref0 (nip_first_back);
								_g_free0 (last_back);
								_g_free0 (first_back);
								_g_free0 (first_forward);
								return;
							}
							_tmp77_ = peer_last_back;
							_tmp78_ = netsukuku_iandna_as_peer_get_cache_records ((NetsukukuIAndnaAsPeer*) _tmp77_, &_inner_error_);
							recs_last = _tmp78_;
							if (_inner_error_ != NULL) {
								g_propagate_error (error, _inner_error_);
								_g_object_unref0 (recs_first);
								_g_object_unref0 (peer_last_back);
								_g_object_unref0 (nip_last_back);
								_g_object_unref0 (peer_first_back);
								_g_object_unref0 (nip_first_back);
								_g_free0 (last_back);
								_g_free0 (first_back);
								_g_free0 (first_forward);
								return;
							}
							{
								NetsukukuAndnaGetCacheRecordsResponse* _tmp79_;
								GeeHashMap* _tmp80_;
								GeeSet* _tmp81_;
								GeeSet* _tmp82_;
								GeeSet* _tmp83_;
								GeeIterator* _tmp84_ = NULL;
								GeeIterator* _tmp85_;
								GeeIterator* _hashed_domain_it;
								_tmp79_ = recs_first;
								_tmp80_ = _tmp79_->cache;
								_tmp81_ = gee_abstract_map_get_keys ((GeeMap*) _tmp80_);
								_tmp82_ = _tmp81_;
								_tmp83_ = _tmp82_;
								_tmp84_ = gee_iterable_iterator ((GeeIterable*) _tmp83_);
								_tmp85_ = _tmp84_;
								_g_object_unref0 (_tmp83_);
								_hashed_domain_it = _tmp85_;
								while (TRUE) {
									GeeIterator* _tmp86_;
									gboolean _tmp87_ = FALSE;
									GeeIterator* _tmp88_;
									gpointer _tmp89_ = NULL;
									gchar* hashed_domain;
									GeeHashMap* _tmp90_;
									const gchar* _tmp91_;
									gboolean _tmp92_ = FALSE;
									_tmp86_ = _hashed_domain_it;
									_tmp87_ = gee_iterator_next (_tmp86_);
									if (!_tmp87_) {
										break;
									}
									_tmp88_ = _hashed_domain_it;
									_tmp89_ = gee_iterator_get (_tmp88_);
									hashed_domain = (gchar*) _tmp89_;
									_tmp90_ = self->priv->cache;
									_tmp91_ = hashed_domain;
									_tmp92_ = gee_abstract_map_has_key ((GeeAbstractMap*) _tmp90_, _tmp91_);
									if (!_tmp92_) {
										gboolean found;
										gboolean _tmp106_;
										found = FALSE;
										{
											NetsukukuAndnaGetCacheRecordsResponse* _tmp93_;
											GeeHashMap* _tmp94_;
											GeeSet* _tmp95_;
											GeeSet* _tmp96_;
											GeeSet* _tmp97_;
											GeeIterator* _tmp98_ = NULL;
											GeeIterator* _tmp99_;
											GeeIterator* _hashed_domain2_it;
											_tmp93_ = recs_last;
											_tmp94_ = _tmp93_->cache;
											_tmp95_ = gee_abstract_map_get_keys ((GeeMap*) _tmp94_);
											_tmp96_ = _tmp95_;
											_tmp97_ = _tmp96_;
											_tmp98_ = gee_iterable_iterator ((GeeIterable*) _tmp97_);
											_tmp99_ = _tmp98_;
											_g_object_unref0 (_tmp97_);
											_hashed_domain2_it = _tmp99_;
											while (TRUE) {
												GeeIterator* _tmp100_;
												gboolean _tmp101_ = FALSE;
												GeeIterator* _tmp102_;
												gpointer _tmp103_ = NULL;
												gchar* hashed_domain2;
												const gchar* _tmp104_;
												const gchar* _tmp105_;
												_tmp100_ = _hashed_domain2_it;
												_tmp101_ = gee_iterator_next (_tmp100_);
												if (!_tmp101_) {
													break;
												}
												_tmp102_ = _hashed_domain2_it;
												_tmp103_ = gee_iterator_get (_tmp102_);
												hashed_domain2 = (gchar*) _tmp103_;
												_tmp104_ = hashed_domain2;
												_tmp105_ = hashed_domain;
												if (g_strcmp0 (_tmp104_, _tmp105_) == 0) {
													found = TRUE;
													_g_free0 (hashed_domain2);
													break;
												}
												_g_free0 (hashed_domain2);
											}
											_g_object_unref0 (_hashed_domain2_it);
										}
										_tmp106_ = found;
										if (!_tmp106_) {
											GeeHashMap* _tmp107_;
											const gchar* _tmp108_;
											NetsukukuAndnaGetCacheRecordsResponse* _tmp109_;
											GeeHashMap* _tmp110_;
											const gchar* _tmp111_;
											gpointer _tmp112_ = NULL;
											NetsukukuAndnaDomainRecord* _tmp113_;
											_tmp107_ = self->priv->cache;
											_tmp108_ = hashed_domain;
											_tmp109_ = recs_first;
											_tmp110_ = _tmp109_->cache;
											_tmp111_ = hashed_domain;
											_tmp112_ = gee_abstract_map_get ((GeeAbstractMap*) _tmp110_, _tmp111_);
											_tmp113_ = (NetsukukuAndnaDomainRecord*) _tmp112_;
											gee_abstract_map_set ((GeeAbstractMap*) _tmp107_, _tmp108_, _tmp113_);
											_g_object_unref0 (_tmp113_);
										}
									}
									_g_free0 (hashed_domain);
								}
								_g_object_unref0 (_hashed_domain_it);
							}
							{
								NetsukukuAndnaGetCacheRecordsResponse* _tmp114_;
								GeeHashMap* _tmp115_;
								GeeSet* _tmp116_;
								GeeSet* _tmp117_;
								GeeSet* _tmp118_;
								GeeIterator* _tmp119_ = NULL;
								GeeIterator* _tmp120_;
								GeeIterator* _hashed_domain_it;
								_tmp114_ = recs_first;
								_tmp115_ = _tmp114_->request_queue;
								_tmp116_ = gee_abstract_map_get_keys ((GeeMap*) _tmp115_);
								_tmp117_ = _tmp116_;
								_tmp118_ = _tmp117_;
								_tmp119_ = gee_iterable_iterator ((GeeIterable*) _tmp118_);
								_tmp120_ = _tmp119_;
								_g_object_unref0 (_tmp118_);
								_hashed_domain_it = _tmp120_;
								while (TRUE) {
									GeeIterator* _tmp121_;
									gboolean _tmp122_ = FALSE;
									GeeIterator* _tmp123_;
									gpointer _tmp124_ = NULL;
									gchar* hashed_domain;
									GeeHashMap* _tmp125_;
									const gchar* _tmp126_;
									gboolean _tmp127_ = FALSE;
									_tmp121_ = _hashed_domain_it;
									_tmp122_ = gee_iterator_next (_tmp121_);
									if (!_tmp122_) {
										break;
									}
									_tmp123_ = _hashed_domain_it;
									_tmp124_ = gee_iterator_get (_tmp123_);
									hashed_domain = (gchar*) _tmp124_;
									_tmp125_ = self->priv->request_queue;
									_tmp126_ = hashed_domain;
									_tmp127_ = gee_abstract_map_has_key ((GeeAbstractMap*) _tmp125_, _tmp126_);
									if (!_tmp127_) {
										gboolean found;
										gboolean _tmp141_;
										found = FALSE;
										{
											NetsukukuAndnaGetCacheRecordsResponse* _tmp128_;
											GeeHashMap* _tmp129_;
											GeeSet* _tmp130_;
											GeeSet* _tmp131_;
											GeeSet* _tmp132_;
											GeeIterator* _tmp133_ = NULL;
											GeeIterator* _tmp134_;
											GeeIterator* _hashed_domain2_it;
											_tmp128_ = recs_last;
											_tmp129_ = _tmp128_->request_queue;
											_tmp130_ = gee_abstract_map_get_keys ((GeeMap*) _tmp129_);
											_tmp131_ = _tmp130_;
											_tmp132_ = _tmp131_;
											_tmp133_ = gee_iterable_iterator ((GeeIterable*) _tmp132_);
											_tmp134_ = _tmp133_;
											_g_object_unref0 (_tmp132_);
											_hashed_domain2_it = _tmp134_;
											while (TRUE) {
												GeeIterator* _tmp135_;
												gboolean _tmp136_ = FALSE;
												GeeIterator* _tmp137_;
												gpointer _tmp138_ = NULL;
												gchar* hashed_domain2;
												const gchar* _tmp139_;
												const gchar* _tmp140_;
												_tmp135_ = _hashed_domain2_it;
												_tmp136_ = gee_iterator_next (_tmp135_);
												if (!_tmp136_) {
													break;
												}
												_tmp137_ = _hashed_domain2_it;
												_tmp138_ = gee_iterator_get (_tmp137_);
												hashed_domain2 = (gchar*) _tmp138_;
												_tmp139_ = hashed_domain2;
												_tmp140_ = hashed_domain;
												if (g_strcmp0 (_tmp139_, _tmp140_) == 0) {
													found = TRUE;
													_g_free0 (hashed_domain2);
													break;
												}
												_g_free0 (hashed_domain2);
											}
											_g_object_unref0 (_hashed_domain2_it);
										}
										_tmp141_ = found;
										if (!_tmp141_) {
											GeeHashMap* _tmp142_;
											const gchar* _tmp143_;
											NetsukukuAndnaGetCacheRecordsResponse* _tmp144_;
											GeeHashMap* _tmp145_;
											const gchar* _tmp146_;
											gpointer _tmp147_ = NULL;
											GeeArrayList* _tmp148_;
											_tmp142_ = self->priv->request_queue;
											_tmp143_ = hashed_domain;
											_tmp144_ = recs_first;
											_tmp145_ = _tmp144_->request_queue;
											_tmp146_ = hashed_domain;
											_tmp147_ = gee_abstract_map_get ((GeeAbstractMap*) _tmp145_, _tmp146_);
											_tmp148_ = (GeeArrayList*) _tmp147_;
											gee_abstract_map_set ((GeeAbstractMap*) _tmp142_, _tmp143_, _tmp148_);
											_g_object_unref0 (_tmp148_);
										}
									}
									_g_free0 (hashed_domain);
								}
								_g_object_unref0 (_hashed_domain_it);
							}
							_g_object_unref0 (recs_last);
							_g_object_unref0 (recs_first);
							_g_object_unref0 (peer_last_back);
							_g_object_unref0 (nip_last_back);
							_g_object_unref0 (peer_first_back);
							_g_object_unref0 (nip_first_back);
						}
						_tmp149_ = lvl;
						_tmp150_ = first_forward;
						_tmp151_ = netsukuku_andna_nip_for_lvl_pos (self, _tmp149_, *_tmp150_);
						nip_first_forward = _tmp151_;
						_tmp152_ = nip_first_forward;
						_tmp153_ = netsukuku_andna_peer (self, _tmp152_, NULL, NULL);
						peer_first_forward = _tmp153_;
						_tmp154_ = peer_first_forward;
						_tmp155_ = netsukuku_iandna_as_peer_get_cache_records ((NetsukukuIAndnaAsPeer*) _tmp154_, &_inner_error_);
						cache_first_forward = _tmp155_;
						if (_inner_error_ != NULL) {
							g_propagate_error (error, _inner_error_);
							_g_object_unref0 (peer_first_forward);
							_g_object_unref0 (nip_first_forward);
							_g_free0 (last_back);
							_g_free0 (first_back);
							_g_free0 (first_forward);
							return;
						}
						{
							NetsukukuAndnaGetCacheRecordsResponse* _tmp156_;
							GeeHashMap* _tmp157_;
							GeeSet* _tmp158_;
							GeeSet* _tmp159_;
							GeeSet* _tmp160_;
							GeeIterator* _tmp161_ = NULL;
							GeeIterator* _tmp162_;
							GeeIterator* _hashed_domain_it;
							_tmp156_ = cache_first_forward;
							_tmp157_ = _tmp156_->cache;
							_tmp158_ = gee_abstract_map_get_keys ((GeeMap*) _tmp157_);
							_tmp159_ = _tmp158_;
							_tmp160_ = _tmp159_;
							_tmp161_ = gee_iterable_iterator ((GeeIterable*) _tmp160_);
							_tmp162_ = _tmp161_;
							_g_object_unref0 (_tmp160_);
							_hashed_domain_it = _tmp162_;
							while (TRUE) {
								GeeIterator* _tmp163_;
								gboolean _tmp164_ = FALSE;
								GeeIterator* _tmp165_;
								gpointer _tmp166_ = NULL;
								gchar* hashed_domain;
								GeeHashMap* _tmp167_;
								const gchar* _tmp168_;
								gboolean _tmp169_ = FALSE;
								_tmp163_ = _hashed_domain_it;
								_tmp164_ = gee_iterator_next (_tmp163_);
								if (!_tmp164_) {
									break;
								}
								_tmp165_ = _hashed_domain_it;
								_tmp166_ = gee_iterator_get (_tmp165_);
								hashed_domain = (gchar*) _tmp166_;
								_tmp167_ = self->priv->cache;
								_tmp168_ = hashed_domain;
								_tmp169_ = gee_abstract_map_has_key ((GeeAbstractMap*) _tmp167_, _tmp168_);
								if (!_tmp169_) {
									gboolean check;
									const gchar* _tmp170_;
									NetsukukuAndnaServiceHashnodeKey* _tmp171_;
									NetsukukuAndnaServiceHashnodeKey* _tmp172_;
									NetsukukuNIP* _tmp173_ = NULL;
									NetsukukuNIP* _tmp174_;
									gint _tmp175_;
									gint _tmp176_ = 0;
									gint _tmp177_;
									gint hk;
									gint _tmp178_;
									GeeList* _tmp179_ = NULL;
									GeeList* ids;
									GeeList* _tmp180_;
									gint* _tmp181_;
									gint _tmp182_ = 0;
									GeeList* _tmp183_;
									NetsukukuMapRoute* _tmp184_;
									NetsukukuNIP* _tmp185_;
									gint _tmp186_;
									gint _tmp187_ = 0;
									gint _tmp188_ = 0;
									gboolean _tmp189_;
									gboolean _tmp214_;
									check = FALSE;
									_tmp170_ = hashed_domain;
									_tmp171_ = netsukuku_andna_service_hashnode_key_new (_tmp170_, 0);
									_tmp172_ = _tmp171_;
									_tmp173_ = netsukuku_peer_to_peer_h ((NetsukukuPeerToPeer*) self, (GObject*) _tmp172_);
									_tmp174_ = _tmp173_;
									_tmp175_ = lvl;
									_tmp176_ = netsukuku_partial_nip_position_at ((NetsukukuPartialNIP*) _tmp174_, _tmp175_);
									_tmp177_ = _tmp176_;
									_g_object_unref0 (_tmp174_);
									_g_object_unref0 (_tmp172_);
									hk = _tmp177_;
									_tmp178_ = hk;
									_tmp179_ = netsukuku_peer_to_peer_list_ids ((NetsukukuPeerToPeer*) self, _tmp178_, 1);
									ids = _tmp179_;
									_tmp180_ = ids;
									_tmp181_ = first_forward;
									_tmp182_ = gee_list_index_of (_tmp180_, (gpointer) ((gintptr) (*_tmp181_)));
									_tmp183_ = ids;
									_tmp184_ = ((NetsukukuPeerToPeer*) self)->maproute;
									_tmp185_ = _tmp184_->me;
									_tmp186_ = lvl;
									_tmp187_ = netsukuku_partial_nip_position_at ((NetsukukuPartialNIP*) _tmp185_, _tmp186_);
									_tmp188_ = gee_list_index_of (_tmp183_, (gpointer) ((gintptr) _tmp187_));
									if (_tmp182_ > _tmp188_) {
										check = TRUE;
									}
									_tmp189_ = check;
									if (!_tmp189_) {
										{
											gint spr;
											spr = 1;
											{
												gboolean _tmp190_;
												_tmp190_ = TRUE;
												while (TRUE) {
													gboolean _tmp191_;
													gint _tmp193_;
													const gchar* _tmp194_;
													gint _tmp195_;
													NetsukukuAndnaServiceHashnodeKey* _tmp196_;
													NetsukukuAndnaServiceHashnodeKey* _tmp197_;
													NetsukukuNIP* _tmp198_ = NULL;
													NetsukukuNIP* _tmp199_;
													gint _tmp200_;
													gint _tmp201_ = 0;
													gint _tmp202_;
													gint hk2;
													gint _tmp203_;
													GeeList* _tmp204_ = NULL;
													GeeList* ids2;
													GeeList* _tmp205_;
													gint* _tmp206_;
													gint _tmp207_ = 0;
													GeeList* _tmp208_;
													NetsukukuMapRoute* _tmp209_;
													NetsukukuNIP* _tmp210_;
													gint _tmp211_;
													gint _tmp212_ = 0;
													gint _tmp213_ = 0;
													_tmp191_ = _tmp190_;
													if (!_tmp191_) {
														gint _tmp192_;
														_tmp192_ = spr;
														spr = _tmp192_ + 1;
													}
													_tmp190_ = FALSE;
													_tmp193_ = spr;
													if (!(_tmp193_ <= NETSUKUKU_SPREAD_ANDNA)) {
														break;
													}
													_tmp194_ = hashed_domain;
													_tmp195_ = spr;
													_tmp196_ = netsukuku_andna_service_hashnode_key_new (_tmp194_, _tmp195_);
													_tmp197_ = _tmp196_;
													_tmp198_ = netsukuku_peer_to_peer_h ((NetsukukuPeerToPeer*) self, (GObject*) _tmp197_);
													_tmp199_ = _tmp198_;
													_tmp200_ = lvl;
													_tmp201_ = netsukuku_partial_nip_position_at ((NetsukukuPartialNIP*) _tmp199_, _tmp200_);
													_tmp202_ = _tmp201_;
													_g_object_unref0 (_tmp199_);
													_g_object_unref0 (_tmp197_);
													hk2 = _tmp202_;
													_tmp203_ = hk2;
													_tmp204_ = netsukuku_peer_to_peer_list_ids ((NetsukukuPeerToPeer*) self, _tmp203_, 1);
													ids2 = _tmp204_;
													_tmp205_ = ids2;
													_tmp206_ = first_forward;
													_tmp207_ = gee_list_index_of (_tmp205_, (gpointer) ((gintptr) (*_tmp206_)));
													_tmp208_ = ids2;
													_tmp209_ = ((NetsukukuPeerToPeer*) self)->maproute;
													_tmp210_ = _tmp209_->me;
													_tmp211_ = lvl;
													_tmp212_ = netsukuku_partial_nip_position_at ((NetsukukuPartialNIP*) _tmp210_, _tmp211_);
													_tmp213_ = gee_list_index_of (_tmp208_, (gpointer) ((gintptr) _tmp212_));
													if (_tmp207_ > _tmp213_) {
														check = TRUE;
														_g_object_unref0 (ids2);
														break;
													}
													_g_object_unref0 (ids2);
												}
											}
										}
									}
									_tmp214_ = check;
									if (_tmp214_) {
										GeeHashMap* _tmp215_;
										const gchar* _tmp216_;
										NetsukukuAndnaGetCacheRecordsResponse* _tmp217_;
										GeeHashMap* _tmp218_;
										const gchar* _tmp219_;
										gpointer _tmp220_ = NULL;
										NetsukukuAndnaDomainRecord* _tmp221_;
										_tmp215_ = self->priv->cache;
										_tmp216_ = hashed_domain;
										_tmp217_ = cache_first_forward;
										_tmp218_ = _tmp217_->cache;
										_tmp219_ = hashed_domain;
										_tmp220_ = gee_abstract_map_get ((GeeAbstractMap*) _tmp218_, _tmp219_);
										_tmp221_ = (NetsukukuAndnaDomainRecord*) _tmp220_;
										gee_abstract_map_set ((GeeAbstractMap*) _tmp215_, _tmp216_, _tmp221_);
										_g_object_unref0 (_tmp221_);
									}
									_g_object_unref0 (ids);
								}
								_g_free0 (hashed_domain);
							}
							_g_object_unref0 (_hashed_domain_it);
						}
						{
							NetsukukuAndnaGetCacheRecordsResponse* _tmp222_;
							GeeHashMap* _tmp223_;
							GeeSet* _tmp224_;
							GeeSet* _tmp225_;
							GeeSet* _tmp226_;
							GeeIterator* _tmp227_ = NULL;
							GeeIterator* _tmp228_;
							GeeIterator* _hashed_domain_it;
							_tmp222_ = cache_first_forward;
							_tmp223_ = _tmp222_->request_queue;
							_tmp224_ = gee_abstract_map_get_keys ((GeeMap*) _tmp223_);
							_tmp225_ = _tmp224_;
							_tmp226_ = _tmp225_;
							_tmp227_ = gee_iterable_iterator ((GeeIterable*) _tmp226_);
							_tmp228_ = _tmp227_;
							_g_object_unref0 (_tmp226_);
							_hashed_domain_it = _tmp228_;
							while (TRUE) {
								GeeIterator* _tmp229_;
								gboolean _tmp230_ = FALSE;
								GeeIterator* _tmp231_;
								gpointer _tmp232_ = NULL;
								gchar* hashed_domain;
								GeeHashMap* _tmp233_;
								const gchar* _tmp234_;
								gboolean _tmp235_ = FALSE;
								_tmp229_ = _hashed_domain_it;
								_tmp230_ = gee_iterator_next (_tmp229_);
								if (!_tmp230_) {
									break;
								}
								_tmp231_ = _hashed_domain_it;
								_tmp232_ = gee_iterator_get (_tmp231_);
								hashed_domain = (gchar*) _tmp232_;
								_tmp233_ = self->priv->request_queue;
								_tmp234_ = hashed_domain;
								_tmp235_ = gee_abstract_map_has_key ((GeeAbstractMap*) _tmp233_, _tmp234_);
								if (!_tmp235_) {
									gboolean check;
									const gchar* _tmp236_;
									NetsukukuAndnaServiceHashnodeKey* _tmp237_;
									NetsukukuAndnaServiceHashnodeKey* _tmp238_;
									NetsukukuNIP* _tmp239_ = NULL;
									NetsukukuNIP* _tmp240_;
									gint _tmp241_;
									gint _tmp242_ = 0;
									gint _tmp243_;
									gint hk;
									gint _tmp244_;
									GeeList* _tmp245_ = NULL;
									GeeList* ids;
									GeeList* _tmp246_;
									gint* _tmp247_;
									gint _tmp248_ = 0;
									GeeList* _tmp249_;
									NetsukukuMapRoute* _tmp250_;
									NetsukukuNIP* _tmp251_;
									gint _tmp252_;
									gint _tmp253_ = 0;
									gint _tmp254_ = 0;
									gboolean _tmp255_;
									gboolean _tmp280_;
									check = FALSE;
									_tmp236_ = hashed_domain;
									_tmp237_ = netsukuku_andna_service_hashnode_key_new (_tmp236_, 0);
									_tmp238_ = _tmp237_;
									_tmp239_ = netsukuku_peer_to_peer_h ((NetsukukuPeerToPeer*) self, (GObject*) _tmp238_);
									_tmp240_ = _tmp239_;
									_tmp241_ = lvl;
									_tmp242_ = netsukuku_partial_nip_position_at ((NetsukukuPartialNIP*) _tmp240_, _tmp241_);
									_tmp243_ = _tmp242_;
									_g_object_unref0 (_tmp240_);
									_g_object_unref0 (_tmp238_);
									hk = _tmp243_;
									_tmp244_ = hk;
									_tmp245_ = netsukuku_peer_to_peer_list_ids ((NetsukukuPeerToPeer*) self, _tmp244_, 1);
									ids = _tmp245_;
									_tmp246_ = ids;
									_tmp247_ = first_forward;
									_tmp248_ = gee_list_index_of (_tmp246_, (gpointer) ((gintptr) (*_tmp247_)));
									_tmp249_ = ids;
									_tmp250_ = ((NetsukukuPeerToPeer*) self)->maproute;
									_tmp251_ = _tmp250_->me;
									_tmp252_ = lvl;
									_tmp253_ = netsukuku_partial_nip_position_at ((NetsukukuPartialNIP*) _tmp251_, _tmp252_);
									_tmp254_ = gee_list_index_of (_tmp249_, (gpointer) ((gintptr) _tmp253_));
									if (_tmp248_ > _tmp254_) {
										check = TRUE;
									}
									_tmp255_ = check;
									if (!_tmp255_) {
										{
											gint spr;
											spr = 1;
											{
												gboolean _tmp256_;
												_tmp256_ = TRUE;
												while (TRUE) {
													gboolean _tmp257_;
													gint _tmp259_;
													const gchar* _tmp260_;
													gint _tmp261_;
													NetsukukuAndnaServiceHashnodeKey* _tmp262_;
													NetsukukuAndnaServiceHashnodeKey* _tmp263_;
													NetsukukuNIP* _tmp264_ = NULL;
													NetsukukuNIP* _tmp265_;
													gint _tmp266_;
													gint _tmp267_ = 0;
													gint _tmp268_;
													gint hk2;
													gint _tmp269_;
													GeeList* _tmp270_ = NULL;
													GeeList* ids2;
													GeeList* _tmp271_;
													gint* _tmp272_;
													gint _tmp273_ = 0;
													GeeList* _tmp274_;
													NetsukukuMapRoute* _tmp275_;
													NetsukukuNIP* _tmp276_;
													gint _tmp277_;
													gint _tmp278_ = 0;
													gint _tmp279_ = 0;
													_tmp257_ = _tmp256_;
													if (!_tmp257_) {
														gint _tmp258_;
														_tmp258_ = spr;
														spr = _tmp258_ + 1;
													}
													_tmp256_ = FALSE;
													_tmp259_ = spr;
													if (!(_tmp259_ <= NETSUKUKU_SPREAD_ANDNA)) {
														break;
													}
													_tmp260_ = hashed_domain;
													_tmp261_ = spr;
													_tmp262_ = netsukuku_andna_service_hashnode_key_new (_tmp260_, _tmp261_);
													_tmp263_ = _tmp262_;
													_tmp264_ = netsukuku_peer_to_peer_h ((NetsukukuPeerToPeer*) self, (GObject*) _tmp263_);
													_tmp265_ = _tmp264_;
													_tmp266_ = lvl;
													_tmp267_ = netsukuku_partial_nip_position_at ((NetsukukuPartialNIP*) _tmp265_, _tmp266_);
													_tmp268_ = _tmp267_;
													_g_object_unref0 (_tmp265_);
													_g_object_unref0 (_tmp263_);
													hk2 = _tmp268_;
													_tmp269_ = hk2;
													_tmp270_ = netsukuku_peer_to_peer_list_ids ((NetsukukuPeerToPeer*) self, _tmp269_, 1);
													ids2 = _tmp270_;
													_tmp271_ = ids2;
													_tmp272_ = first_forward;
													_tmp273_ = gee_list_index_of (_tmp271_, (gpointer) ((gintptr) (*_tmp272_)));
													_tmp274_ = ids2;
													_tmp275_ = ((NetsukukuPeerToPeer*) self)->maproute;
													_tmp276_ = _tmp275_->me;
													_tmp277_ = lvl;
													_tmp278_ = netsukuku_partial_nip_position_at ((NetsukukuPartialNIP*) _tmp276_, _tmp277_);
													_tmp279_ = gee_list_index_of (_tmp274_, (gpointer) ((gintptr) _tmp278_));
													if (_tmp273_ > _tmp279_) {
														check = TRUE;
														_g_object_unref0 (ids2);
														break;
													}
													_g_object_unref0 (ids2);
												}
											}
										}
									}
									_tmp280_ = check;
									if (_tmp280_) {
										GeeHashMap* _tmp281_;
										const gchar* _tmp282_;
										NetsukukuAndnaGetCacheRecordsResponse* _tmp283_;
										GeeHashMap* _tmp284_;
										const gchar* _tmp285_;
										gpointer _tmp286_ = NULL;
										GeeArrayList* _tmp287_;
										_tmp281_ = self->priv->request_queue;
										_tmp282_ = hashed_domain;
										_tmp283_ = cache_first_forward;
										_tmp284_ = _tmp283_->request_queue;
										_tmp285_ = hashed_domain;
										_tmp286_ = gee_abstract_map_get ((GeeAbstractMap*) _tmp284_, _tmp285_);
										_tmp287_ = (GeeArrayList*) _tmp286_;
										gee_abstract_map_set ((GeeAbstractMap*) _tmp281_, _tmp282_, _tmp287_);
										_g_object_unref0 (_tmp287_);
									}
									_g_object_unref0 (ids);
								}
								_g_free0 (hashed_domain);
							}
							_g_object_unref0 (_hashed_domain_it);
						}
						_g_object_unref0 (cache_first_forward);
						_g_object_unref0 (peer_first_forward);
						_g_object_unref0 (nip_first_forward);
						_g_free0 (last_back);
						_g_free0 (first_back);
						_g_free0 (first_forward);
						break;
					}
				}
				_g_free0 (last_back);
				_g_free0 (first_back);
				_g_free0 (first_forward);
			}
		}
	}
	self->memory_initialized = TRUE;
	netsukuku_log_info ("Andna service: memory ready.");
	g_signal_emit_by_name (self, "andna-ready");
}


static void __lambda8_ (NetsukukuAndna* self, GError** error) {
	GError * _inner_error_ = NULL;
	while (TRUE) {
		{
			netsukuku_andna_impl_init_memory (self, &_inner_error_);
			if (_inner_error_ != NULL) {
				goto __catch9_g_error;
			}
			break;
		}
		goto __finally9;
		__catch9_g_error:
		{
			GError* e = NULL;
			GError* _tmp0_;
			GQuark _tmp1_;
			const gchar* _tmp2_ = NULL;
			const gchar* _tmp3_ = NULL;
			GError* _tmp4_;
			gint _tmp5_;
			gchar* _tmp6_ = NULL;
			gchar* _tmp7_;
			GError* _tmp8_;
			const gchar* _tmp9_;
			const gchar* _tmp10_ = NULL;
			gchar* _tmp11_ = NULL;
			gchar* _tmp12_;
			gchar* _tmp13_;
			gchar* _tmp14_;
			gchar* _tmp15_;
			gchar* _tmp16_;
			e = _inner_error_;
			_inner_error_ = NULL;
			_tmp0_ = e;
			_tmp1_ = _tmp0_->domain;
			_tmp2_ = g_quark_to_string (_tmp1_);
			_tmp3_ = string_to_string (_tmp2_);
			_tmp4_ = e;
			_tmp5_ = _tmp4_->code;
			_tmp6_ = g_strdup_printf ("%i", _tmp5_);
			_tmp7_ = _tmp6_;
			_tmp8_ = e;
			_tmp9_ = _tmp8_->message;
			_tmp10_ = string_to_string (_tmp9_);
			_tmp11_ = g_strconcat ("got ", _tmp3_, " ", _tmp7_, " ", _tmp10_, ". ", NULL);
			_tmp12_ = _tmp11_;
			_tmp13_ = g_strconcat ("Andna.init_memory: ", _tmp12_, NULL);
			_tmp14_ = _tmp13_;
			_tmp15_ = g_strconcat (_tmp14_, "Trying again.\n", NULL);
			_tmp16_ = _tmp15_;
			netsukuku_log_warn (_tmp16_);
			_g_free0 (_tmp16_);
			_g_free0 (_tmp14_);
			_g_free0 (_tmp12_);
			_g_free0 (_tmp7_);
			tasklets_ms_wait ((gint64) 100);
			_g_error_free0 (e);
		}
		__finally9:
		if (_inner_error_ != NULL) {
			g_propagate_error (error, _inner_error_);
			return;
		}
	}
}


static void ___lambda8__tasklets_tasklet_callback (GObject* obj1, GObject* obj2, GObject* obj3, GObject* obj4, gpointer self, GError** error) {
	__lambda8_ (self, error);
}


void netsukuku_andna_init_memory (NetsukukuAndna* self) {
	TaskletsTasklet* _tmp0_ = NULL;
	TaskletsTasklet* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = tasklets_tasklet_tasklet_callback (___lambda8__tasklets_tasklet_callback, self, NULL, NULL, NULL, NULL);
	_tmp1_ = _tmp0_;
	_g_object_unref0 (_tmp1_);
}


/** This is the function h:KEY-->hIP.
          */
static NetsukukuNIP* netsukuku_andna_real_h (NetsukukuPeerToPeer* base, GObject* key) {
	NetsukukuAndna * self;
	NetsukukuNIP* result = NULL;
	GObject* _tmp0_;
	NetsukukuAndnaServiceHashnodeKey* _tmp1_;
	NetsukukuAndnaServiceHashnodeKey* _key;
	NetsukukuMapRoute* _tmp2_;
	gint _tmp3_;
	NetsukukuMapRoute* _tmp4_;
	gint _tmp5_;
	NetsukukuNIP* _tmp6_ = NULL;
	self = (NetsukukuAndna*) base;
	g_return_val_if_fail (key != NULL, NULL);
	_tmp0_ = key;
	_tmp1_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, NETSUKUKU_TYPE_ANDNA_SERVICE_HASHNODE_KEY, NetsukukuAndnaServiceHashnodeKey));
	_key = _tmp1_;
	_tmp2_ = ((NetsukukuPeerToPeer*) self)->maproute;
	_tmp3_ = _tmp2_->levels;
	_tmp4_ = ((NetsukukuPeerToPeer*) self)->maproute;
	_tmp5_ = _tmp4_->gsize;
	_tmp6_ = netsukuku_andna_utilities_key_to_hashnode_converter (_key, _tmp3_, _tmp5_);
	result = _tmp6_;
	_g_object_unref0 (_key);
	return result;
}


NetsukukuAndnaDomainRequest* netsukuku_andna_make_domain_request (NetsukukuAndna* self, NetsukukuAndnaPrivateConfiguration* cfg) {
	NetsukukuAndnaDomainRequest* result = NULL;
	NetsukukuAndnaPrivateConfiguration* _tmp0_;
	const gchar* _tmp1_;
	gchar* _tmp2_ = NULL;
	gchar* hashed_domain;
	NetsukukuKeyPair* _tmp3_;
	NetsukukuPublicKeyWrapper* _tmp4_;
	NetsukukuPublicKeyWrapper* _tmp5_;
	NetsukukuPublicKey* _tmp6_ = NULL;
	NetsukukuPublicKey* pubk;
	NetsukukuMapRoute* _tmp7_;
	NetsukukuNIP* _tmp8_;
	NetsukukuNIP* _tmp9_;
	NetsukukuNIP* nip;
	GeeHashMap* services = NULL;
	GeeHashMap* _tmp10_ = NULL;
	const gchar* _tmp48_;
	NetsukukuPublicKey* _tmp49_;
	NetsukukuNIP* _tmp50_;
	GeeHashMap* _tmp51_;
	NetsukukuAndnaDomainRequest* _tmp52_;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (cfg != NULL, NULL);
	_tmp0_ = cfg;
	_tmp1_ = _tmp0_->domain;
	_tmp2_ = netsukuku_andna_crypto_hash (_tmp1_);
	hashed_domain = _tmp2_;
	_tmp3_ = self->priv->my_keys;
	_tmp4_ = netsukuku_key_pair_get_pub_key (_tmp3_);
	_tmp5_ = _tmp4_;
	_tmp6_ = netsukuku_public_key_wrapper_to_pubkey (_tmp5_);
	pubk = _tmp6_;
	_tmp7_ = ((NetsukukuPeerToPeer*) self)->maproute;
	_tmp8_ = _tmp7_->me;
	_tmp9_ = _g_object_ref0 (_tmp8_);
	nip = _tmp9_;
	_tmp10_ = netsukuku_andna_domain_request_make_empty_services ();
	_g_object_unref0 (services);
	services = _tmp10_;
	{
		NetsukukuAndnaPrivateConfiguration* _tmp11_;
		GeeHashMap* _tmp12_;
		GeeHashMap* _tmp13_;
		GeeSet* _tmp14_;
		GeeSet* _tmp15_;
		GeeSet* _tmp16_;
		GeeIterator* _tmp17_ = NULL;
		GeeIterator* _tmp18_;
		GeeIterator* _k_it;
		_tmp11_ = cfg;
		_tmp12_ = netsukuku_andna_private_configuration_get_services (_tmp11_);
		_tmp13_ = _tmp12_;
		_tmp14_ = gee_abstract_map_get_keys ((GeeMap*) _tmp13_);
		_tmp15_ = _tmp14_;
		_tmp16_ = _tmp15_;
		_tmp17_ = gee_iterable_iterator ((GeeIterable*) _tmp16_);
		_tmp18_ = _tmp17_;
		_g_object_unref0 (_tmp16_);
		_k_it = _tmp18_;
		while (TRUE) {
			GeeIterator* _tmp19_;
			gboolean _tmp20_ = FALSE;
			GeeIterator* _tmp21_;
			gpointer _tmp22_ = NULL;
			NetsukukuAndnaServiceKey* k;
			GeeHashMap* _tmp23_;
			NetsukukuAndnaServiceKey* _tmp24_;
			GeeArrayList* _tmp25_ = NULL;
			GeeArrayList* _tmp26_;
			_tmp19_ = _k_it;
			_tmp20_ = gee_iterator_next (_tmp19_);
			if (!_tmp20_) {
				break;
			}
			_tmp21_ = _k_it;
			_tmp22_ = gee_iterator_get (_tmp21_);
			k = (NetsukukuAndnaServiceKey*) _tmp22_;
			_tmp23_ = services;
			_tmp24_ = k;
			_tmp25_ = netsukuku_andna_server_request_make_empty_list ();
			_tmp26_ = _tmp25_;
			gee_abstract_map_set ((GeeAbstractMap*) _tmp23_, _tmp24_, _tmp26_);
			_g_object_unref0 (_tmp26_);
			{
				NetsukukuAndnaPrivateConfiguration* _tmp27_;
				GeeHashMap* _tmp28_;
				GeeHashMap* _tmp29_;
				NetsukukuAndnaServiceKey* _tmp30_;
				gpointer _tmp31_ = NULL;
				GeeArrayList* _cfg_server_list;
				GeeArrayList* _tmp32_;
				gint _tmp33_;
				gint _tmp34_;
				gint _cfg_server_size;
				gint _cfg_server_index;
				_tmp27_ = cfg;
				_tmp28_ = netsukuku_andna_private_configuration_get_services (_tmp27_);
				_tmp29_ = _tmp28_;
				_tmp30_ = k;
				_tmp31_ = gee_abstract_map_get ((GeeAbstractMap*) _tmp29_, _tmp30_);
				_cfg_server_list = (GeeArrayList*) _tmp31_;
				_tmp32_ = _cfg_server_list;
				_tmp33_ = gee_abstract_collection_get_size ((GeeCollection*) _tmp32_);
				_tmp34_ = _tmp33_;
				_cfg_server_size = _tmp34_;
				_cfg_server_index = -1;
				while (TRUE) {
					gint _tmp35_;
					gint _tmp36_;
					gint _tmp37_;
					GeeArrayList* _tmp38_;
					gint _tmp39_;
					gpointer _tmp40_ = NULL;
					NetsukukuAndnaPrivateConfigurationServer* cfg_server;
					GeeHashMap* _tmp41_;
					NetsukukuAndnaServiceKey* _tmp42_;
					gpointer _tmp43_ = NULL;
					GeeArrayList* _tmp44_;
					NetsukukuAndnaPrivateConfigurationServer* _tmp45_;
					NetsukukuAndnaServerRequest* _tmp46_ = NULL;
					NetsukukuAndnaServerRequest* _tmp47_;
					_tmp35_ = _cfg_server_index;
					_cfg_server_index = _tmp35_ + 1;
					_tmp36_ = _cfg_server_index;
					_tmp37_ = _cfg_server_size;
					if (!(_tmp36_ < _tmp37_)) {
						break;
					}
					_tmp38_ = _cfg_server_list;
					_tmp39_ = _cfg_server_index;
					_tmp40_ = gee_abstract_list_get ((GeeAbstractList*) _tmp38_, _tmp39_);
					cfg_server = (NetsukukuAndnaPrivateConfigurationServer*) _tmp40_;
					_tmp41_ = services;
					_tmp42_ = k;
					_tmp43_ = gee_abstract_map_get ((GeeAbstractMap*) _tmp41_, _tmp42_);
					_tmp44_ = (GeeArrayList*) _tmp43_;
					_tmp45_ = cfg_server;
					_tmp46_ = netsukuku_andna_make_server_request (self, _tmp45_);
					_tmp47_ = _tmp46_;
					gee_abstract_collection_add ((GeeAbstractCollection*) _tmp44_, _tmp47_);
					_g_object_unref0 (_tmp47_);
					_g_object_unref0 (_tmp44_);
					_g_object_unref0 (cfg_server);
				}
				_g_object_unref0 (_cfg_server_list);
			}
			_g_object_unref0 (k);
		}
		_g_object_unref0 (_k_it);
	}
	_tmp48_ = hashed_domain;
	_tmp49_ = pubk;
	_tmp50_ = nip;
	_tmp51_ = services;
	_tmp52_ = netsukuku_andna_domain_request_new (_tmp48_, _tmp49_, _tmp50_, _tmp51_);
	result = _tmp52_;
	_g_object_unref0 (services);
	_g_object_unref0 (nip);
	_g_object_unref0 (pubk);
	_g_free0 (hashed_domain);
	return result;
}


NetsukukuAndnaServerRequest* netsukuku_andna_make_server_request (NetsukukuAndna* self, NetsukukuAndnaPrivateConfigurationServer* cfg) {
	NetsukukuAndnaServerRequest* result = NULL;
	gchar* hashed_alias;
	NetsukukuAndnaPrivateConfigurationServer* _tmp0_;
	const gchar* _tmp1_;
	const gchar* _tmp2_;
	NetsukukuAndnaPrivateConfigurationServer* _tmp7_;
	NetsukukuPublicKey* _tmp8_;
	NetsukukuPublicKey* _tmp9_;
	NetsukukuPublicKey* _tmp10_;
	NetsukukuPublicKey* pubk;
	NetsukukuAndnaPrivateConfigurationServer* _tmp11_;
	gint _tmp12_;
	gint _tmp13_;
	gint port_number;
	NetsukukuAndnaPrivateConfigurationServer* _tmp14_;
	gint _tmp15_;
	gint _tmp16_;
	gint priority;
	NetsukukuAndnaPrivateConfigurationServer* _tmp17_;
	gint _tmp18_;
	gint _tmp19_;
	gint weight;
	const gchar* _tmp20_;
	NetsukukuAndnaServerRequest* _tmp21_;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (cfg != NULL, NULL);
	hashed_alias = NULL;
	_tmp0_ = cfg;
	_tmp1_ = netsukuku_andna_private_configuration_server_get_alias (_tmp0_);
	_tmp2_ = _tmp1_;
	if (_tmp2_ != NULL) {
		NetsukukuAndnaPrivateConfigurationServer* _tmp3_;
		const gchar* _tmp4_;
		const gchar* _tmp5_;
		gchar* _tmp6_ = NULL;
		_tmp3_ = cfg;
		_tmp4_ = netsukuku_andna_private_configuration_server_get_alias (_tmp3_);
		_tmp5_ = _tmp4_;
		_tmp6_ = netsukuku_andna_crypto_hash (_tmp5_);
		_g_free0 (hashed_alias);
		hashed_alias = _tmp6_;
	}
	_tmp7_ = cfg;
	_tmp8_ = netsukuku_andna_private_configuration_server_get_pubk (_tmp7_);
	_tmp9_ = _tmp8_;
	_tmp10_ = _g_object_ref0 (_tmp9_);
	pubk = _tmp10_;
	_tmp11_ = cfg;
	_tmp12_ = netsukuku_andna_private_configuration_server_get_port_number (_tmp11_);
	_tmp13_ = _tmp12_;
	port_number = _tmp13_;
	_tmp14_ = cfg;
	_tmp15_ = netsukuku_andna_private_configuration_server_get_priority (_tmp14_);
	_tmp16_ = _tmp15_;
	priority = _tmp16_;
	_tmp17_ = cfg;
	_tmp18_ = netsukuku_andna_private_configuration_server_get_weight (_tmp17_);
	_tmp19_ = _tmp18_;
	weight = _tmp19_;
	_tmp20_ = hashed_alias;
	_tmp21_ = netsukuku_andna_server_request_new (_tmp20_, pubk, port_number, priority, weight);
	result = _tmp21_;
	_g_object_unref0 (pubk);
	_g_free0 (hashed_alias);
	return result;
}


static void ________lambda15_ (NetsukukuAndna* self, GObject* tpar1, GObject* tpar2, GError** error) {
	GObject* _tmp0_;
	const gchar* _tmp1_;
	const gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* tasklet_hostname;
	GObject* _tmp4_;
	gint _tmp5_;
	gint _tmp6_;
	gint tasklet_i;
	GError * _inner_error_ = NULL;
	_tmp0_ = tpar1;
	_tmp1_ = zcd_serializable_string_get_s (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, ZCD_TYPE_SERIALIZABLE_STRING, zcdSerializableString));
	_tmp2_ = _tmp1_;
	_tmp3_ = g_strdup (_tmp2_);
	tasklet_hostname = _tmp3_;
	_tmp4_ = tpar2;
	_tmp5_ = zcd_serializable_int_get_i (G_TYPE_CHECK_INSTANCE_CAST (_tmp4_, ZCD_TYPE_SERIALIZABLE_INT, zcdSerializableInt));
	_tmp6_ = _tmp5_;
	tasklet_i = _tmp6_;
	tasklets_tasklet_declare_self ("Andna.spread_registration");
	netsukuku_andna_ask_register_spread_record (self, tasklet_hostname, tasklet_i, &_inner_error_);
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		_g_free0 (tasklet_hostname);
		return;
	}
	_g_free0 (tasklet_hostname);
}


static void _________lambda15__tasklets_tasklet_callback (GObject* obj1, GObject* obj2, GObject* obj3, GObject* obj4, gpointer self, GError** error) {
	________lambda15_ (self, obj1, obj2, error);
}


static void netsukuku_andna_impl_register_name (NetsukukuAndna* self, const gchar* hostname) {
	const gchar* _tmp0_;
	const gchar* _tmp1_ = NULL;
	gchar* _tmp2_ = NULL;
	gchar* _tmp3_;
	NetsukukuDomainWanted* _tmp4_;
	NetsukukuDomainWanted* dw;
	NetsukukuDomainWanted* _tmp5_;
	TaskletsTasklet* _tmp6_ = NULL;
	NetsukukuDomainWanted* _tmp7_;
	const gchar* _tmp8_;
	gchar* _tmp9_;
	NetsukukuDomainWanted* _tmp10_;
	NetsukukuDomainWanted* _tmp11_;
	NetsukukuTimeCapsule* _tmp12_;
	GeeArrayList* _tmp13_;
	NetsukukuDomainWanted* _tmp14_;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (hostname != NULL);
	_tmp0_ = hostname;
	_tmp1_ = string_to_string (_tmp0_);
	_tmp2_ = g_strconcat ("Andna.register_name(\"", _tmp1_, "\")", NULL);
	_tmp3_ = _tmp2_;
	tasklets_tasklet_declare_self (_tmp3_);
	_g_free0 (_tmp3_);
	_tmp4_ = netsukuku_domain_wanted_new ();
	dw = _tmp4_;
	_tmp5_ = dw;
	_tmp6_ = tasklets_tasklet_self ();
	_g_object_unref0 (_tmp5_->tasklet);
	_tmp5_->tasklet = _tmp6_;
	_tmp7_ = dw;
	_tmp8_ = hostname;
	_tmp9_ = g_strdup (_tmp8_);
	_g_free0 (_tmp7_->hostname);
	_tmp7_->hostname = _tmp9_;
	_tmp10_ = dw;
	_tmp10_->registered = FALSE;
	_tmp11_ = dw;
	_tmp12_ = netsukuku_time_capsule_new ((gint64) 0);
	_g_object_unref0 (_tmp11_->ttl_before_request);
	_tmp11_->ttl_before_request = _tmp12_;
	_tmp13_ = self->priv->lst_domains;
	_tmp14_ = dw;
	gee_abstract_collection_add ((GeeAbstractCollection*) _tmp13_, _tmp14_);
	while (TRUE) {
		{
			const gchar* _tmp15_;
			NetsukukuAndnaRegisterMainResponse* _tmp16_ = NULL;
			NetsukukuAndnaRegisterMainResponse* resp;
			gboolean _tmp17_ = FALSE;
			NetsukukuAndnaRegisterMainResponse* _tmp18_;
			const gchar* _tmp19_;
			const gchar* _tmp20_;
			gboolean _tmp24_;
			_tmp15_ = hostname;
			_tmp16_ = netsukuku_andna_ask_register_main_for_pubk (self, _tmp15_, &_inner_error_);
			resp = _tmp16_;
			if (_inner_error_ != NULL) {
				goto __catch10_g_error;
			}
			_tmp18_ = resp;
			_tmp19_ = netsukuku_andna_register_main_response_get_response (_tmp18_);
			_tmp20_ = _tmp19_;
			if (g_strcmp0 (_tmp20_, "REGISTERED") == 0) {
				_tmp17_ = TRUE;
			} else {
				NetsukukuAndnaRegisterMainResponse* _tmp21_;
				const gchar* _tmp22_;
				const gchar* _tmp23_;
				_tmp21_ = resp;
				_tmp22_ = netsukuku_andna_register_main_response_get_response (_tmp21_);
				_tmp23_ = _tmp22_;
				_tmp17_ = g_strcmp0 (_tmp23_, "UPDATED") == 0;
			}
			_tmp24_ = _tmp17_;
			if (_tmp24_) {
				const gchar* _tmp25_;
				NetsukukuDomainWanted* _tmp26_;
				NetsukukuDomainWanted* _tmp39_;
				NetsukukuAndnaRegisterMainResponse* _tmp40_;
				NetsukukuTimeCapsule* _tmp41_;
				NetsukukuTimeCapsule* _tmp42_;
				NetsukukuTimeCapsule* _tmp43_;
				NetsukukuDomainWanted* _tmp44_;
				NetsukukuDomainWanted* _tmp45_;
				NetsukukuTimeCapsule* _tmp46_;
				gint64 _tmp47_ = 0LL;
				NetsukukuTimeCapsule* _tmp48_;
				NetsukukuTimeCapsule* _tmp49_;
				NetsukukuTimeCapsule* maxttl;
				NetsukukuDomainWanted* _tmp50_;
				NetsukukuTimeCapsule* _tmp51_;
				NetsukukuTimeCapsule* _tmp52_;
				gboolean _tmp53_ = FALSE;
				_tmp25_ = hostname;
				g_signal_emit_by_name (self, "andna-registered", _tmp25_);
				_tmp26_ = dw;
				_tmp26_->registered = TRUE;
				{
					gint i;
					i = 1;
					{
						gboolean _tmp27_;
						_tmp27_ = TRUE;
						while (TRUE) {
							gboolean _tmp28_;
							gint _tmp30_;
							const gchar* _tmp31_;
							zcdSerializableString* _tmp32_;
							zcdSerializableString* _tmp33_;
							gint _tmp34_;
							zcdSerializableInt* _tmp35_;
							zcdSerializableInt* _tmp36_;
							TaskletsTasklet* _tmp37_ = NULL;
							TaskletsTasklet* _tmp38_;
							_tmp28_ = _tmp27_;
							if (!_tmp28_) {
								gint _tmp29_;
								_tmp29_ = i;
								i = _tmp29_ + 1;
							}
							_tmp27_ = FALSE;
							_tmp30_ = i;
							if (!(_tmp30_ <= NETSUKUKU_SPREAD_ANDNA)) {
								break;
							}
							_tmp31_ = hostname;
							_tmp32_ = zcd_serializable_string_new (_tmp31_);
							_tmp33_ = _tmp32_;
							_tmp34_ = i;
							_tmp35_ = zcd_serializable_int_new (_tmp34_);
							_tmp36_ = _tmp35_;
							_tmp37_ = tasklets_tasklet_tasklet_callback (_________lambda15__tasklets_tasklet_callback, self, (GObject*) _tmp33_, (GObject*) _tmp36_, NULL, NULL);
							_tmp38_ = _tmp37_;
							_g_object_unref0 (_tmp38_);
							_g_object_unref0 (_tmp36_);
							_g_object_unref0 (_tmp33_);
						}
					}
				}
				_tmp39_ = dw;
				_tmp40_ = resp;
				_tmp41_ = netsukuku_andna_register_main_response_get_expires (_tmp40_);
				_tmp42_ = _tmp41_;
				_tmp43_ = _g_object_ref0 (_tmp42_);
				_g_object_unref0 (_tmp39_->ttl_before_request);
				_tmp39_->ttl_before_request = _tmp43_;
				_tmp44_ = dw;
				_tmp45_ = dw;
				_tmp46_ = _tmp45_->ttl_before_request;
				_tmp47_ = tasklets_timer_get_msec_ttl ((TaskletsTimer*) _tmp46_);
				_tmp48_ = netsukuku_time_capsule_new (_tmp47_ - ((((gint64) 1000) * ((gint64) 60)) * ((gint64) 10)));
				_g_object_unref0 (_tmp44_->ttl_before_request);
				_tmp44_->ttl_before_request = _tmp48_;
				_tmp49_ = netsukuku_time_capsule_new (NETSUKUKU_MAX_WAIT_REFRESH_ANDNA);
				maxttl = _tmp49_;
				_tmp50_ = dw;
				_tmp51_ = _tmp50_->ttl_before_request;
				_tmp52_ = maxttl;
				_tmp53_ = tasklets_timer_is_younger ((TaskletsTimer*) _tmp51_, (TaskletsTimer*) _tmp52_);
				if (_tmp53_) {
					NetsukukuDomainWanted* _tmp54_;
					NetsukukuTimeCapsule* _tmp55_;
					NetsukukuTimeCapsule* _tmp56_;
					_tmp54_ = dw;
					_tmp55_ = maxttl;
					_tmp56_ = _g_object_ref0 (_tmp55_);
					_g_object_unref0 (_tmp54_->ttl_before_request);
					_tmp54_->ttl_before_request = _tmp56_;
				}
				_g_object_unref0 (maxttl);
			} else {
				const gchar* _tmp57_;
				const gchar* _tmp58_ = NULL;
				gchar* _tmp59_ = NULL;
				gchar* _tmp60_;
				NetsukukuAndnaRegisterMainResponse* _tmp61_;
				const gchar* _tmp62_;
				const gchar* _tmp63_;
				const gchar* _tmp64_ = NULL;
				gchar* _tmp65_ = NULL;
				gchar* _tmp66_;
				gchar* _tmp67_;
				gchar* _tmp68_;
				NetsukukuDomainWanted* _tmp69_;
				NetsukukuTimeCapsule* _tmp70_;
				_tmp57_ = hostname;
				_tmp58_ = string_to_string (_tmp57_);
				_tmp59_ = g_strconcat ("Andna: register_name('", _tmp58_, "')", NULL);
				_tmp60_ = _tmp59_;
				_tmp61_ = resp;
				_tmp62_ = netsukuku_andna_register_main_response_get_response (_tmp61_);
				_tmp63_ = _tmp62_;
				_tmp64_ = string_to_string (_tmp63_);
				_tmp65_ = g_strconcat (" got '", _tmp64_, "'", NULL);
				_tmp66_ = _tmp65_;
				_tmp67_ = g_strconcat (_tmp60_, _tmp66_, NULL);
				_tmp68_ = _tmp67_;
				netsukuku_log_warn (_tmp68_);
				_g_free0 (_tmp68_);
				_g_free0 (_tmp66_);
				_g_free0 (_tmp60_);
				_tmp69_ = dw;
				_tmp70_ = netsukuku_time_capsule_new ((((gint64) 1000) * ((gint64) 60)) * ((gint64) 2));
				_g_object_unref0 (_tmp69_->ttl_before_request);
				_tmp69_->ttl_before_request = _tmp70_;
			}
			_g_object_unref0 (resp);
		}
		goto __finally10;
		__catch10_g_error:
		{
			GError* e = NULL;
			const gchar* _tmp71_;
			const gchar* _tmp72_ = NULL;
			gchar* _tmp73_ = NULL;
			gchar* _tmp74_;
			GError* _tmp75_;
			GQuark _tmp76_;
			const gchar* _tmp77_ = NULL;
			GError* _tmp78_;
			gint _tmp79_;
			gchar* _tmp80_ = NULL;
			gchar* _tmp81_;
			GError* _tmp82_;
			const gchar* _tmp83_;
			const gchar* _tmp84_ = NULL;
			gchar* _tmp85_ = NULL;
			gchar* _tmp86_;
			gchar* _tmp87_;
			gchar* _tmp88_;
			NetsukukuDomainWanted* _tmp89_;
			NetsukukuTimeCapsule* _tmp90_;
			e = _inner_error_;
			_inner_error_ = NULL;
			_tmp71_ = hostname;
			_tmp72_ = string_to_string (_tmp71_);
			_tmp73_ = g_strconcat ("Andna: register_name('", _tmp72_, "')", NULL);
			_tmp74_ = _tmp73_;
			_tmp75_ = e;
			_tmp76_ = _tmp75_->domain;
			_tmp77_ = g_quark_to_string (_tmp76_);
			_tmp78_ = e;
			_tmp79_ = _tmp78_->code;
			_tmp80_ = g_strdup_printf ("%i", _tmp79_);
			_tmp81_ = _tmp80_;
			_tmp82_ = e;
			_tmp83_ = _tmp82_->message;
			_tmp84_ = string_to_string (_tmp83_);
			_tmp85_ = g_strconcat (" got ", _tmp77_, " code ", _tmp81_, ": ", _tmp84_, "'", NULL);
			_tmp86_ = _tmp85_;
			_tmp87_ = g_strconcat (_tmp74_, _tmp86_, NULL);
			_tmp88_ = _tmp87_;
			netsukuku_log_warn (_tmp88_);
			_g_free0 (_tmp88_);
			_g_free0 (_tmp86_);
			_g_free0 (_tmp81_);
			_g_free0 (_tmp74_);
			_tmp89_ = dw;
			_tmp90_ = netsukuku_time_capsule_new ((((gint64) 1000) * ((gint64) 60)) * ((gint64) 2));
			_g_object_unref0 (_tmp89_->ttl_before_request);
			_tmp89_->ttl_before_request = _tmp90_;
			_g_error_free0 (e);
		}
		__finally10:
		if (_inner_error_ != NULL) {
			_g_object_unref0 (dw);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
		while (TRUE) {
			NetsukukuDomainWanted* _tmp91_;
			NetsukukuTimeCapsule* _tmp92_;
			gboolean _tmp93_ = FALSE;
			_tmp91_ = dw;
			_tmp92_ = _tmp91_->ttl_before_request;
			_tmp93_ = tasklets_timer_is_expired ((TaskletsTimer*) _tmp92_);
			if (!(!_tmp93_)) {
				break;
			}
			tasklets_tasklet_nap ((glong) 0, (glong) 100000);
		}
	}
	_g_object_unref0 (dw);
}


static void __lambda16_ (NetsukukuAndna* self, GObject* tpar1, GError** error) {
	GObject* _tmp0_;
	const gchar* _tmp1_;
	const gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* tasklet_hostname;
	_tmp0_ = tpar1;
	_tmp1_ = zcd_serializable_string_get_s (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, ZCD_TYPE_SERIALIZABLE_STRING, zcdSerializableString));
	_tmp2_ = _tmp1_;
	_tmp3_ = g_strdup (_tmp2_);
	tasklet_hostname = _tmp3_;
	netsukuku_andna_impl_register_name (self, tasklet_hostname);
	_g_free0 (tasklet_hostname);
}


static void ___lambda16__tasklets_tasklet_callback (GObject* obj1, GObject* obj2, GObject* obj3, GObject* obj4, gpointer self, GError** error) {
	__lambda16_ (self, obj1, error);
}


static void netsukuku_andna_register_name (NetsukukuAndna* self, const gchar* hostname) {
	const gchar* _tmp0_;
	zcdSerializableString* _tmp1_;
	zcdSerializableString* _tmp2_;
	TaskletsTasklet* _tmp3_ = NULL;
	TaskletsTasklet* _tmp4_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (hostname != NULL);
	_tmp0_ = hostname;
	_tmp1_ = zcd_serializable_string_new (_tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = tasklets_tasklet_tasklet_callback (___lambda16__tasklets_tasklet_callback, self, (GObject*) _tmp2_, NULL, NULL, NULL);
	_tmp4_ = _tmp3_;
	_g_object_unref0 (_tmp4_);
	_g_object_unref0 (_tmp2_);
}


void netsukuku_andna_register_my_names (NetsukukuAndna* self) {
	g_return_if_fail (self != NULL);
	{
		NetsukukuAndnaPrivateConfigurationList* _tmp0_;
		NetsukukuAndnaPrivateConfigurationList* _tmp1_;
		GeeArrayList* _tmp2_;
		GeeArrayList* _tmp3_;
		GeeArrayList* _tmp4_;
		GeeArrayList* _cfg_list;
		GeeArrayList* _tmp5_;
		gint _tmp6_;
		gint _tmp7_;
		gint _cfg_size;
		gint _cfg_index;
		_tmp0_ = netsukuku_andna_get_configuration (self);
		_tmp1_ = _tmp0_;
		_tmp2_ = netsukuku_andna_private_configuration_list_get_lst (_tmp1_);
		_tmp3_ = _tmp2_;
		_tmp4_ = _g_object_ref0 (_tmp3_);
		_cfg_list = _tmp4_;
		_tmp5_ = _cfg_list;
		_tmp6_ = gee_abstract_collection_get_size ((GeeCollection*) _tmp5_);
		_tmp7_ = _tmp6_;
		_cfg_size = _tmp7_;
		_cfg_index = -1;
		while (TRUE) {
			gint _tmp8_;
			gint _tmp9_;
			gint _tmp10_;
			GeeArrayList* _tmp11_;
			gint _tmp12_;
			gpointer _tmp13_ = NULL;
			NetsukukuAndnaPrivateConfiguration* cfg;
			NetsukukuAndnaPrivateConfiguration* _tmp14_;
			const gchar* _tmp15_;
			gchar* _tmp16_;
			gchar* hostname;
			const gchar* _tmp17_;
			_tmp8_ = _cfg_index;
			_cfg_index = _tmp8_ + 1;
			_tmp9_ = _cfg_index;
			_tmp10_ = _cfg_size;
			if (!(_tmp9_ < _tmp10_)) {
				break;
			}
			_tmp11_ = _cfg_list;
			_tmp12_ = _cfg_index;
			_tmp13_ = gee_abstract_list_get ((GeeAbstractList*) _tmp11_, _tmp12_);
			cfg = (NetsukukuAndnaPrivateConfiguration*) _tmp13_;
			_tmp14_ = cfg;
			_tmp15_ = _tmp14_->domain;
			_tmp16_ = g_strdup (_tmp15_);
			hostname = _tmp16_;
			_tmp17_ = hostname;
			netsukuku_andna_register_name (self, _tmp17_);
			_g_free0 (hostname);
			_g_object_unref0 (cfg);
		}
		_g_object_unref0 (_cfg_list);
	}
}


void netsukuku_andna_stop_register_my_names (NetsukukuAndna* self) {
	GeeArrayList* _tmp13_;
	g_return_if_fail (self != NULL);
	{
		GeeArrayList* _tmp0_;
		GeeArrayList* _tmp1_;
		GeeArrayList* _dw_list;
		GeeArrayList* _tmp2_;
		gint _tmp3_;
		gint _tmp4_;
		gint _dw_size;
		gint _dw_index;
		_tmp0_ = self->priv->lst_domains;
		_tmp1_ = _g_object_ref0 (_tmp0_);
		_dw_list = _tmp1_;
		_tmp2_ = _dw_list;
		_tmp3_ = gee_abstract_collection_get_size ((GeeCollection*) _tmp2_);
		_tmp4_ = _tmp3_;
		_dw_size = _tmp4_;
		_dw_index = -1;
		while (TRUE) {
			gint _tmp5_;
			gint _tmp6_;
			gint _tmp7_;
			GeeArrayList* _tmp8_;
			gint _tmp9_;
			gpointer _tmp10_ = NULL;
			NetsukukuDomainWanted* dw;
			NetsukukuDomainWanted* _tmp11_;
			TaskletsTasklet* _tmp12_;
			_tmp5_ = _dw_index;
			_dw_index = _tmp5_ + 1;
			_tmp6_ = _dw_index;
			_tmp7_ = _dw_size;
			if (!(_tmp6_ < _tmp7_)) {
				break;
			}
			_tmp8_ = _dw_list;
			_tmp9_ = _dw_index;
			_tmp10_ = gee_abstract_list_get ((GeeAbstractList*) _tmp8_, _tmp9_);
			dw = (NetsukukuDomainWanted*) _tmp10_;
			_tmp11_ = dw;
			_tmp12_ = _tmp11_->tasklet;
			tasklets_tasklet_abort (_tmp12_);
			_g_object_unref0 (dw);
		}
		_g_object_unref0 (_dw_list);
	}
	_tmp13_ = self->priv->lst_domains;
	gee_abstract_collection_clear ((GeeAbstractCollection*) _tmp13_);
}


gboolean netsukuku_andna_register_my_names_ongoing (NetsukukuAndna* self) {
	gboolean result = FALSE;
	GeeArrayList* _tmp0_;
	gboolean _tmp1_;
	gboolean _tmp2_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->lst_domains;
	_tmp1_ = gee_collection_get_is_empty ((GeeCollection*) _tmp0_);
	_tmp2_ = _tmp1_;
	result = !_tmp2_;
	return result;
}


static NetsukukuAndnaRegisterMainResponse* netsukuku_andna_ask_register_main_for_pubk (NetsukukuAndna* self, const gchar* hostname, GError** error) {
	NetsukukuAndnaRegisterMainResponse* result = NULL;
	NetsukukuAndnaPrivateConfigurationList* _tmp0_;
	NetsukukuAndnaPrivateConfigurationList* _tmp1_;
	const gchar* _tmp2_;
	NetsukukuAndnaPrivateConfiguration* _tmp3_ = NULL;
	NetsukukuAndnaPrivateConfiguration* cfg;
	NetsukukuAndnaDomainRequest* _tmp4_ = NULL;
	NetsukukuAndnaDomainRequest* request;
	NetsukukuKeyPair* _tmp5_;
	zcdSerializableBuffer* _tmp6_ = NULL;
	zcdSerializableBuffer* signature;
	const gchar* _tmp7_;
	const gchar* _tmp8_;
	NetsukukuAndnaServiceHashnodeKey* _tmp9_;
	NetsukukuAndnaServiceHashnodeKey* _tmp10_;
	NetsukukuRmtAndnaPeer* _tmp11_ = NULL;
	NetsukukuRmtAndnaPeer* _tmp12_;
	NetsukukuAndnaRegisterMainResponse* _tmp13_ = NULL;
	NetsukukuAndnaRegisterMainResponse* _tmp14_;
	NetsukukuAndnaRegisterMainResponse* _tmp15_;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (hostname != NULL, NULL);
	_tmp0_ = netsukuku_andna_get_configuration (self);
	_tmp1_ = _tmp0_;
	_tmp2_ = hostname;
	_tmp3_ = netsukuku_andna_private_configuration_list_get_domain (_tmp1_, _tmp2_);
	cfg = _tmp3_;
	_vala_assert (cfg != NULL, "cfg != null");
	_tmp4_ = netsukuku_andna_make_domain_request (self, cfg);
	request = _tmp4_;
	_tmp5_ = self->priv->my_keys;
	_tmp6_ = _netsukuku_andna_sign (self, request, _tmp5_);
	signature = _tmp6_;
	_tmp7_ = netsukuku_andna_domain_request_get_hashed_domain (request);
	_tmp8_ = _tmp7_;
	_tmp9_ = netsukuku_andna_service_hashnode_key_new (_tmp8_, 0);
	_tmp10_ = _tmp9_;
	_tmp11_ = netsukuku_andna_peer (self, NULL, (GObject*) _tmp10_, NULL);
	_tmp12_ = _tmp11_;
	_tmp13_ = netsukuku_iandna_as_peer_register_main_for_pubk ((NetsukukuIAndnaAsPeer*) _tmp12_, request, signature, TRUE, &_inner_error_);
	_tmp14_ = _tmp13_;
	_g_object_unref0 (_tmp12_);
	_g_object_unref0 (_tmp10_);
	_tmp15_ = _tmp14_;
	if (_inner_error_ != NULL) {
		if ((_inner_error_->domain == ZCD_RPC_ERROR) || (_inner_error_->domain == NETSUKUKU_PEER_REFUSE_SERVICE_ERROR)) {
			g_propagate_error (error, _inner_error_);
			_g_object_unref0 (signature);
			_g_object_unref0 (request);
			_g_object_unref0 (cfg);
			return NULL;
		} else {
			_g_object_unref0 (signature);
			_g_object_unref0 (request);
			_g_object_unref0 (cfg);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	}
	result = _tmp15_;
	_g_object_unref0 (signature);
	_g_object_unref0 (request);
	_g_object_unref0 (cfg);
	return result;
}


static guchar* netsukuku_andna_prepare_msg (NetsukukuAndna* self, NetsukukuAndnaDomainRequest* req, int* result_length1) {
	guchar* result = NULL;
	NetsukukuAndnaDomainRequest* _tmp0_;
	gint _tmp1_ = 0;
	guchar* _tmp2_ = NULL;
	guchar* message;
	gint message_length1;
	gint _message_size_;
	guchar* _tmp3_;
	gint _tmp3__length1;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (req != NULL, NULL);
	_tmp0_ = req;
	_tmp2_ = netsukuku_andna_domain_request_hash_for_signature (_tmp0_, &_tmp1_);
	message = _tmp2_;
	message_length1 = _tmp1_;
	_message_size_ = message_length1;
	_tmp3_ = message;
	_tmp3__length1 = message_length1;
	if (result_length1) {
		*result_length1 = _tmp3__length1;
	}
	result = _tmp3_;
	return result;
}


static zcdSerializableBuffer* _netsukuku_andna_sign (NetsukukuAndna* self, NetsukukuAndnaDomainRequest* req, NetsukukuKeyPair* key_pair) {
	zcdSerializableBuffer* result = NULL;
	NetsukukuKeyPair* _tmp0_;
	NetsukukuAndnaDomainRequest* _tmp1_;
	gint _tmp2_ = 0;
	guchar* _tmp3_ = NULL;
	guchar* _tmp4_;
	gint _tmp4__length1;
	gint _tmp5_ = 0;
	guchar* _tmp6_ = NULL;
	guchar* _tmp7_;
	gint _tmp7__length1;
	guchar* _signed_;
	gint _signed__length1;
	gint __signed__size_;
	zcdSerializableBuffer* _tmp8_;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (req != NULL, NULL);
	g_return_val_if_fail (key_pair != NULL, NULL);
	_tmp0_ = key_pair;
	_tmp1_ = req;
	_tmp3_ = netsukuku_andna_prepare_msg (self, _tmp1_, &_tmp2_);
	_tmp4_ = _tmp3_;
	_tmp4__length1 = _tmp2_;
	_tmp6_ = netsukuku_key_pair_sign (_tmp0_, _tmp4_, _tmp2_, &_tmp5_, &_inner_error_);
	_tmp7_ = _tmp6_;
	_tmp7__length1 = _tmp5_;
	_tmp4_ = (g_free (_tmp4_), NULL);
	_signed_ = _tmp7_;
	_signed__length1 = _tmp7__length1;
	__signed__size_ = _signed__length1;
	if (_inner_error_ != NULL) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return NULL;
	}
	_tmp8_ = zcd_serializable_buffer_new ((guint8*) _signed_, (_signed__length1 * sizeof (guchar)) / sizeof (guint8));
	result = _tmp8_;
	_signed_ = (g_free (_signed_), NULL);
	return result;
}


static gboolean _netsukuku_andna_verify (NetsukukuAndna* self, NetsukukuAndnaDomainRequest* req, NetsukukuPublicKey* pubk, zcdSerializableBuffer* signature) {
	gboolean result = FALSE;
	NetsukukuPublicKey* _tmp0_;
	NetsukukuPublicKeyWrapper* _tmp1_;
	NetsukukuPublicKeyWrapper* pkw;
	NetsukukuPublicKeyWrapper* _tmp2_;
	NetsukukuAndnaDomainRequest* _tmp3_;
	gint _tmp4_ = 0;
	guchar* _tmp5_ = NULL;
	guchar* _tmp6_;
	gint _tmp6__length1;
	zcdSerializableBuffer* _tmp7_;
	guint8* _tmp8_;
	gint _tmp8__length1;
	guint8* _tmp9_;
	gint _tmp9__length1;
	gboolean _tmp10_ = FALSE;
	gboolean _tmp11_;
	gboolean _tmp12_;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (req != NULL, FALSE);
	g_return_val_if_fail (pubk != NULL, FALSE);
	g_return_val_if_fail (signature != NULL, FALSE);
	_tmp0_ = pubk;
	_tmp1_ = netsukuku_public_key_wrapper_new_from_pubk (_tmp0_, &_inner_error_);
	pkw = _tmp1_;
	if (_inner_error_ != NULL) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return FALSE;
	}
	_tmp2_ = pkw;
	_tmp3_ = req;
	_tmp5_ = netsukuku_andna_prepare_msg (self, _tmp3_, &_tmp4_);
	_tmp6_ = _tmp5_;
	_tmp6__length1 = _tmp4_;
	_tmp7_ = signature;
	_tmp8_ = zcd_serializable_buffer_get_buffer (_tmp7_, &_tmp8__length1);
	_tmp9_ = _tmp8_;
	_tmp9__length1 = _tmp8__length1;
	_tmp10_ = netsukuku_public_key_wrapper_verify (_tmp2_, _tmp6_, _tmp4_, (guchar*) _tmp9_, (_tmp9__length1 * sizeof (guint8)) / sizeof (guchar), &_inner_error_);
	_tmp11_ = _tmp10_;
	_tmp6_ = (g_free (_tmp6_), NULL);
	_tmp12_ = _tmp11_;
	if (_inner_error_ != NULL) {
		_g_object_unref0 (pkw);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return FALSE;
	}
	result = _tmp12_;
	_g_object_unref0 (pkw);
	return result;
}


static void netsukuku_andna_ask_register_spread_record (NetsukukuAndna* self, const gchar* hostname, gint spread_number, GError** error) {
	NetsukukuAndnaPrivateConfigurationList* _tmp0_;
	NetsukukuAndnaPrivateConfigurationList* _tmp1_;
	const gchar* _tmp2_;
	NetsukukuAndnaPrivateConfiguration* _tmp3_ = NULL;
	NetsukukuAndnaPrivateConfiguration* cfg;
	NetsukukuAndnaDomainRequest* _tmp4_ = NULL;
	NetsukukuAndnaDomainRequest* request;
	const gchar* _tmp5_;
	const gchar* _tmp6_;
	gchar* _tmp7_;
	gchar* hashed_domain;
	gint _tmp8_;
	NetsukukuAndnaServiceHashnodeKey* _tmp9_;
	NetsukukuAndnaServiceHashnodeKey* _tmp10_;
	NetsukukuRmtAndnaPeer* _tmp11_ = NULL;
	NetsukukuRmtAndnaPeer* _tmp12_;
	gint _tmp13_;
	NetsukukuAndnaRegisterSpreadResponse* _tmp14_ = NULL;
	NetsukukuAndnaRegisterSpreadResponse* _tmp15_;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (hostname != NULL);
	_tmp0_ = netsukuku_andna_get_configuration (self);
	_tmp1_ = _tmp0_;
	_tmp2_ = hostname;
	_tmp3_ = netsukuku_andna_private_configuration_list_get_domain (_tmp1_, _tmp2_);
	cfg = _tmp3_;
	_vala_assert (cfg != NULL, "cfg != null");
	_tmp4_ = netsukuku_andna_make_domain_request (self, cfg);
	request = _tmp4_;
	_tmp5_ = netsukuku_andna_domain_request_get_hashed_domain (request);
	_tmp6_ = _tmp5_;
	_tmp7_ = g_strdup (_tmp6_);
	hashed_domain = _tmp7_;
	_tmp8_ = spread_number;
	_tmp9_ = netsukuku_andna_service_hashnode_key_new (hashed_domain, _tmp8_);
	_tmp10_ = _tmp9_;
	_tmp11_ = netsukuku_andna_peer (self, NULL, (GObject*) _tmp10_, NULL);
	_tmp12_ = _tmp11_;
	_tmp13_ = spread_number;
	_tmp14_ = netsukuku_iandna_as_peer_register_spread_record ((NetsukukuIAndnaAsPeer*) _tmp12_, hashed_domain, _tmp13_, TRUE, &_inner_error_);
	_tmp15_ = _tmp14_;
	_g_object_unref0 (_tmp15_);
	_g_object_unref0 (_tmp12_);
	_g_object_unref0 (_tmp10_);
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		_g_free0 (hashed_domain);
		_g_object_unref0 (request);
		_g_object_unref0 (cfg);
		return;
	}
	_g_free0 (hashed_domain);
	_g_object_unref0 (request);
	_g_object_unref0 (cfg);
}


NetsukukuAndnaGetRegistrarResponse* netsukuku_andna_ask_registrar (NetsukukuAndna* self, const gchar* hashed_domain) {
	NetsukukuAndnaGetRegistrarResponse* result = NULL;
	const gchar* _tmp0_;
	NetsukukuAndnaServiceHashnodeKey* _tmp1_;
	NetsukukuAndnaServiceHashnodeKey* _tmp2_;
	NetsukukuRmtAndnaPeer* _tmp3_ = NULL;
	NetsukukuRmtAndnaPeer* _tmp4_;
	NetsukukuRmtAndnaPeer* andnapeer;
	const gchar* _tmp5_;
	NetsukukuAndnaGetRegistrarResponse* _tmp6_ = NULL;
	NetsukukuAndnaGetRegistrarResponse* _tmp7_;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (hashed_domain != NULL, NULL);
	_tmp0_ = hashed_domain;
	_tmp1_ = netsukuku_andna_service_hashnode_key_new (_tmp0_, 0);
	_tmp2_ = _tmp1_;
	_tmp3_ = netsukuku_andna_peer (self, NULL, (GObject*) _tmp2_, NULL);
	_tmp4_ = _tmp3_;
	_g_object_unref0 (_tmp2_);
	andnapeer = _tmp4_;
	_tmp5_ = hashed_domain;
	_tmp6_ = netsukuku_iandna_as_peer_get_registrar ((NetsukukuIAndnaAsPeer*) andnapeer, _tmp5_, &_inner_error_);
	_tmp7_ = _tmp6_;
	if (_inner_error_ != NULL) {
		_g_object_unref0 (andnapeer);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return NULL;
	}
	result = _tmp7_;
	_g_object_unref0 (andnapeer);
	return result;
}


static gboolean _netsukuku_partial_nip_equal_func_gee_equal_data_func (gconstpointer a, gconstpointer b, gpointer self) {
	gboolean result;
	result = netsukuku_partial_nip_equal_func (a, b);
	return result;
}


static gboolean _netsukuku_andna_service_hashnode_key_equal_func_gee_equal_data_func (gconstpointer a, gconstpointer b, gpointer self) {
	gboolean result;
	result = netsukuku_andna_service_hashnode_key_equal_func (a, b);
	return result;
}


NetsukukuAndnaGetServersResponse* netsukuku_andna_ask_get_servers (NetsukukuAndna* self, const gchar* hashed_domain, NetsukukuAndnaServiceKey* srv_key, gboolean chain) {
	NetsukukuAndnaGetServersResponse* result = NULL;
	GeeArrayList* _tmp0_;
	GeeArrayList* choose_from;
	GeeArrayList* _tmp1_;
	GeeArrayList* keys_from;
	const gchar* _tmp2_;
	NetsukukuAndnaServiceHashnodeKey* _tmp3_;
	NetsukukuAndnaServiceHashnodeKey* k_0;
	NetsukukuAndnaServiceHashnodeKey* _tmp4_;
	NetsukukuNIP* _tmp5_ = NULL;
	NetsukukuNIP* nip_0;
	NetsukukuNIP* _tmp6_;
	NetsukukuPartialNIP* _tmp7_ = NULL;
	NetsukukuPartialNIP* approx_0;
	GeeArrayList* _tmp8_;
	NetsukukuPartialNIP* _tmp9_;
	GeeArrayList* _tmp10_;
	NetsukukuAndnaServiceHashnodeKey* _tmp11_;
	NetsukukuMapRoute* _tmp27_;
	GeeArrayList* _tmp28_;
	NetsukukuPartialNIP* _tmp29_ = NULL;
	NetsukukuPartialNIP* chosen;
	NetsukukuPartialNIP* _tmp30_;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (hashed_domain != NULL, NULL);
	g_return_val_if_fail (srv_key != NULL, NULL);
	_tmp0_ = gee_array_list_new (NETSUKUKU_TYPE_PARTIAL_NIP, (GBoxedCopyFunc) g_object_ref, g_object_unref, _netsukuku_partial_nip_equal_func_gee_equal_data_func, NULL, NULL);
	choose_from = _tmp0_;
	_tmp1_ = gee_array_list_new (NETSUKUKU_TYPE_ANDNA_SERVICE_HASHNODE_KEY, (GBoxedCopyFunc) g_object_ref, g_object_unref, _netsukuku_andna_service_hashnode_key_equal_func_gee_equal_data_func, NULL, NULL);
	keys_from = _tmp1_;
	_tmp2_ = hashed_domain;
	_tmp3_ = netsukuku_andna_service_hashnode_key_new (_tmp2_, 0);
	k_0 = _tmp3_;
	_tmp4_ = k_0;
	_tmp5_ = netsukuku_peer_to_peer_h ((NetsukukuPeerToPeer*) self, (GObject*) _tmp4_);
	nip_0 = _tmp5_;
	_tmp6_ = nip_0;
	_tmp7_ = netsukuku_peer_to_peer_search_participant_as_nip ((NetsukukuPeerToPeer*) self, _tmp6_, 1, &_inner_error_);
	approx_0 = _tmp7_;
	if (_inner_error_ != NULL) {
		_g_object_unref0 (nip_0);
		_g_object_unref0 (k_0);
		_g_object_unref0 (keys_from);
		_g_object_unref0 (choose_from);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return NULL;
	}
	_tmp8_ = choose_from;
	_tmp9_ = approx_0;
	gee_abstract_collection_add ((GeeAbstractCollection*) _tmp8_, _tmp9_);
	_tmp10_ = keys_from;
	_tmp11_ = k_0;
	gee_abstract_collection_add ((GeeAbstractCollection*) _tmp10_, _tmp11_);
	{
		gint i;
		i = 1;
		{
			gboolean _tmp12_;
			_tmp12_ = TRUE;
			while (TRUE) {
				gboolean _tmp13_;
				gint _tmp15_;
				const gchar* _tmp16_;
				gint _tmp17_;
				NetsukukuAndnaServiceHashnodeKey* _tmp18_;
				NetsukukuAndnaServiceHashnodeKey* k_i;
				NetsukukuAndnaServiceHashnodeKey* _tmp19_;
				NetsukukuNIP* _tmp20_ = NULL;
				NetsukukuNIP* nip_i;
				NetsukukuNIP* _tmp21_;
				NetsukukuPartialNIP* _tmp22_ = NULL;
				NetsukukuPartialNIP* approx_i;
				GeeArrayList* _tmp23_;
				NetsukukuPartialNIP* _tmp24_;
				GeeArrayList* _tmp25_;
				NetsukukuAndnaServiceHashnodeKey* _tmp26_;
				_tmp13_ = _tmp12_;
				if (!_tmp13_) {
					gint _tmp14_;
					_tmp14_ = i;
					i = _tmp14_ + 1;
				}
				_tmp12_ = FALSE;
				_tmp15_ = i;
				if (!(_tmp15_ < NETSUKUKU_SPREAD_ANDNA)) {
					break;
				}
				_tmp16_ = hashed_domain;
				_tmp17_ = i;
				_tmp18_ = netsukuku_andna_service_hashnode_key_new (_tmp16_, _tmp17_);
				k_i = _tmp18_;
				_tmp19_ = k_i;
				_tmp20_ = netsukuku_peer_to_peer_h ((NetsukukuPeerToPeer*) self, (GObject*) _tmp19_);
				nip_i = _tmp20_;
				_tmp21_ = nip_i;
				_tmp22_ = netsukuku_peer_to_peer_search_participant_as_nip ((NetsukukuPeerToPeer*) self, _tmp21_, 1, &_inner_error_);
				approx_i = _tmp22_;
				if (_inner_error_ != NULL) {
					_g_object_unref0 (nip_i);
					_g_object_unref0 (k_i);
					_g_object_unref0 (approx_0);
					_g_object_unref0 (nip_0);
					_g_object_unref0 (k_0);
					_g_object_unref0 (keys_from);
					_g_object_unref0 (choose_from);
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
					g_clear_error (&_inner_error_);
					return NULL;
				}
				_tmp23_ = choose_from;
				_tmp24_ = approx_i;
				gee_abstract_collection_add ((GeeAbstractCollection*) _tmp23_, _tmp24_);
				_tmp25_ = keys_from;
				_tmp26_ = k_i;
				gee_abstract_collection_add ((GeeAbstractCollection*) _tmp25_, _tmp26_);
				_g_object_unref0 (approx_i);
				_g_object_unref0 (nip_i);
				_g_object_unref0 (k_i);
			}
		}
	}
	_tmp27_ = ((NetsukukuPeerToPeer*) self)->maproute;
	_tmp28_ = choose_from;
	_tmp29_ = netsukuku_map_route_choose_fast (_tmp27_, (GeeList*) _tmp28_);
	chosen = _tmp29_;
	_tmp30_ = chosen;
	if (_tmp30_ != NULL) {
		GeeArrayList* _tmp31_;
		NetsukukuPartialNIP* _tmp32_;
		gint _tmp33_ = 0;
		gint index;
		GeeArrayList* _tmp34_;
		gint _tmp35_;
		gpointer _tmp36_ = NULL;
		NetsukukuAndnaServiceHashnodeKey* chosen_key;
		NetsukukuAndnaServiceHashnodeKey* _tmp37_;
		gint _tmp38_;
		gint _tmp39_;
		gint spread_number;
		GeeArrayList* _tmp40_;
		gint _tmp41_;
		gpointer _tmp42_ = NULL;
		NetsukukuAndnaServiceHashnodeKey* _tmp43_;
		NetsukukuRmtAndnaPeer* _tmp44_ = NULL;
		NetsukukuRmtAndnaPeer* _tmp45_;
		NetsukukuRmtAndnaPeer* node;
		NetsukukuRmtAndnaPeer* _tmp46_;
		const gchar* _tmp47_;
		NetsukukuAndnaServiceKey* _tmp48_;
		gint _tmp49_;
		gboolean _tmp50_;
		NetsukukuAndnaGetServersResponse* _tmp51_ = NULL;
		NetsukukuAndnaGetServersResponse* ret;
		_tmp31_ = choose_from;
		_tmp32_ = chosen;
		_tmp33_ = gee_abstract_list_index_of ((GeeAbstractList*) _tmp31_, _tmp32_);
		index = _tmp33_;
		_tmp34_ = keys_from;
		_tmp35_ = index;
		_tmp36_ = gee_abstract_list_get ((GeeAbstractList*) _tmp34_, _tmp35_);
		chosen_key = (NetsukukuAndnaServiceHashnodeKey*) _tmp36_;
		_tmp37_ = chosen_key;
		_tmp38_ = netsukuku_andna_service_hashnode_key_get_spread_num (_tmp37_);
		_tmp39_ = _tmp38_;
		spread_number = _tmp39_;
		_tmp40_ = keys_from;
		_tmp41_ = index;
		_tmp42_ = gee_abstract_list_get ((GeeAbstractList*) _tmp40_, _tmp41_);
		_tmp43_ = (NetsukukuAndnaServiceHashnodeKey*) _tmp42_;
		_tmp44_ = netsukuku_andna_peer (self, NULL, (GObject*) _tmp43_, NULL);
		_tmp45_ = _tmp44_;
		_g_object_unref0 (_tmp43_);
		node = _tmp45_;
		_tmp46_ = node;
		_tmp47_ = hashed_domain;
		_tmp48_ = srv_key;
		_tmp49_ = spread_number;
		_tmp50_ = chain;
		_tmp51_ = netsukuku_iandna_as_peer_get_servers ((NetsukukuIAndnaAsPeer*) _tmp46_, _tmp47_, _tmp48_, _tmp49_, _tmp50_, &_inner_error_);
		ret = _tmp51_;
		if (_inner_error_ != NULL) {
			_g_object_unref0 (node);
			_g_object_unref0 (chosen_key);
			_g_object_unref0 (chosen);
			_g_object_unref0 (approx_0);
			_g_object_unref0 (nip_0);
			_g_object_unref0 (k_0);
			_g_object_unref0 (keys_from);
			_g_object_unref0 (choose_from);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
		result = ret;
		_g_object_unref0 (node);
		_g_object_unref0 (chosen_key);
		_g_object_unref0 (chosen);
		_g_object_unref0 (approx_0);
		_g_object_unref0 (nip_0);
		_g_object_unref0 (k_0);
		_g_object_unref0 (keys_from);
		_g_object_unref0 (choose_from);
		return result;
	}
	result = NULL;
	_g_object_unref0 (chosen);
	_g_object_unref0 (approx_0);
	_g_object_unref0 (nip_0);
	_g_object_unref0 (k_0);
	_g_object_unref0 (keys_from);
	_g_object_unref0 (choose_from);
	return result;
}


/** Helper methods used as a server
          */
static NetsukukuAndnaServerRecord* netsukuku_andna_make_server_record (NetsukukuAndna* self, NetsukukuAndnaServerRequest* req) {
	NetsukukuAndnaServerRecord* result = NULL;
	NetsukukuAndnaServerRequest* _tmp0_;
	const gchar* _tmp1_;
	const gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* hashed_alias;
	NetsukukuAndnaServerRequest* _tmp4_;
	NetsukukuPublicKey* _tmp5_;
	NetsukukuPublicKey* _tmp6_;
	NetsukukuPublicKey* _tmp7_;
	NetsukukuPublicKey* pubk;
	NetsukukuAndnaServerRequest* _tmp8_;
	gint _tmp9_;
	gint _tmp10_;
	gint port_number;
	NetsukukuAndnaServerRequest* _tmp11_;
	gint _tmp12_;
	gint _tmp13_;
	gint priority;
	NetsukukuAndnaServerRequest* _tmp14_;
	gint _tmp15_;
	gint _tmp16_;
	gint weight;
	NetsukukuAndnaServerRecord* _tmp17_;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (req != NULL, NULL);
	_tmp0_ = req;
	_tmp1_ = netsukuku_andna_server_request_get_hashed_alias (_tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = g_strdup (_tmp2_);
	hashed_alias = _tmp3_;
	_tmp4_ = req;
	_tmp5_ = netsukuku_andna_server_request_get_pubk (_tmp4_);
	_tmp6_ = _tmp5_;
	_tmp7_ = _g_object_ref0 (_tmp6_);
	pubk = _tmp7_;
	_tmp8_ = req;
	_tmp9_ = netsukuku_andna_server_request_get_port_number (_tmp8_);
	_tmp10_ = _tmp9_;
	port_number = _tmp10_;
	_tmp11_ = req;
	_tmp12_ = netsukuku_andna_server_request_get_priority (_tmp11_);
	_tmp13_ = _tmp12_;
	priority = _tmp13_;
	_tmp14_ = req;
	_tmp15_ = netsukuku_andna_server_request_get_weight (_tmp14_);
	_tmp16_ = _tmp15_;
	weight = _tmp16_;
	_tmp17_ = netsukuku_andna_server_record_new (hashed_alias, pubk, port_number, priority, weight);
	result = _tmp17_;
	_g_object_unref0 (pubk);
	_g_free0 (hashed_alias);
	return result;
}


void netsukuku_andna_check_expirations_cache (NetsukukuAndna* self) {
	GeeArrayList* _tmp0_;
	GeeArrayList* todel;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = gee_array_list_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, NULL, NULL, NULL);
	todel = _tmp0_;
	{
		GeeHashMap* _tmp1_;
		GeeSet* _tmp2_;
		GeeSet* _tmp3_;
		GeeSet* _tmp4_;
		GeeIterator* _tmp5_ = NULL;
		GeeIterator* _tmp6_;
		GeeIterator* _hashed_domain_it;
		_tmp1_ = self->priv->cache;
		_tmp2_ = gee_abstract_map_get_keys ((GeeMap*) _tmp1_);
		_tmp3_ = _tmp2_;
		_tmp4_ = _tmp3_;
		_tmp5_ = gee_iterable_iterator ((GeeIterable*) _tmp4_);
		_tmp6_ = _tmp5_;
		_g_object_unref0 (_tmp4_);
		_hashed_domain_it = _tmp6_;
		while (TRUE) {
			GeeIterator* _tmp7_;
			gboolean _tmp8_ = FALSE;
			GeeIterator* _tmp9_;
			gpointer _tmp10_ = NULL;
			gchar* hashed_domain;
			GeeHashMap* _tmp11_;
			const gchar* _tmp12_;
			gpointer _tmp13_ = NULL;
			NetsukukuAndnaDomainRecord* record;
			NetsukukuAndnaDomainRecord* _tmp14_;
			NetsukukuTimeCapsule* _tmp15_;
			NetsukukuTimeCapsule* _tmp16_;
			gboolean _tmp17_ = FALSE;
			_tmp7_ = _hashed_domain_it;
			_tmp8_ = gee_iterator_next (_tmp7_);
			if (!_tmp8_) {
				break;
			}
			_tmp9_ = _hashed_domain_it;
			_tmp10_ = gee_iterator_get (_tmp9_);
			hashed_domain = (gchar*) _tmp10_;
			_tmp11_ = self->priv->cache;
			_tmp12_ = hashed_domain;
			_tmp13_ = gee_abstract_map_get ((GeeAbstractMap*) _tmp11_, _tmp12_);
			record = (NetsukukuAndnaDomainRecord*) _tmp13_;
			_tmp14_ = record;
			_tmp15_ = netsukuku_andna_domain_record_get_expires (_tmp14_);
			_tmp16_ = _tmp15_;
			_tmp17_ = tasklets_timer_is_expired ((TaskletsTimer*) _tmp16_);
			if (_tmp17_) {
				GeeArrayList* _tmp18_;
				const gchar* _tmp19_;
				_tmp18_ = todel;
				_tmp19_ = hashed_domain;
				gee_abstract_collection_add ((GeeAbstractCollection*) _tmp18_, _tmp19_);
			}
			_g_object_unref0 (record);
			_g_free0 (hashed_domain);
		}
		_g_object_unref0 (_hashed_domain_it);
	}
	{
		GeeArrayList* _tmp20_;
		GeeArrayList* _tmp21_;
		GeeArrayList* _hashed_domain_list;
		GeeArrayList* _tmp22_;
		gint _tmp23_;
		gint _tmp24_;
		gint _hashed_domain_size;
		gint _hashed_domain_index;
		_tmp20_ = todel;
		_tmp21_ = _g_object_ref0 (_tmp20_);
		_hashed_domain_list = _tmp21_;
		_tmp22_ = _hashed_domain_list;
		_tmp23_ = gee_abstract_collection_get_size ((GeeCollection*) _tmp22_);
		_tmp24_ = _tmp23_;
		_hashed_domain_size = _tmp24_;
		_hashed_domain_index = -1;
		while (TRUE) {
			gint _tmp25_;
			gint _tmp26_;
			gint _tmp27_;
			GeeArrayList* _tmp28_;
			gint _tmp29_;
			gpointer _tmp30_ = NULL;
			gchar* hashed_domain;
			NetsukukuAndnaDomainRecord* record = NULL;
			GeeHashMap* _tmp31_;
			const gchar* _tmp32_;
			gpointer _tmp33_ = NULL;
			GeeHashMap* _tmp34_;
			const gchar* _tmp35_;
			gboolean _tmp36_ = FALSE;
			_tmp25_ = _hashed_domain_index;
			_hashed_domain_index = _tmp25_ + 1;
			_tmp26_ = _hashed_domain_index;
			_tmp27_ = _hashed_domain_size;
			if (!(_tmp26_ < _tmp27_)) {
				break;
			}
			_tmp28_ = _hashed_domain_list;
			_tmp29_ = _hashed_domain_index;
			_tmp30_ = gee_abstract_list_get ((GeeAbstractList*) _tmp28_, _tmp29_);
			hashed_domain = (gchar*) _tmp30_;
			_tmp31_ = self->priv->cache;
			_tmp32_ = hashed_domain;
			gee_abstract_map_unset ((GeeAbstractMap*) _tmp31_, _tmp32_, &_tmp33_);
			_g_object_unref0 (record);
			record = _tmp33_;
			_tmp34_ = self->priv->request_queue;
			_tmp35_ = hashed_domain;
			_tmp36_ = gee_abstract_map_has_key ((GeeAbstractMap*) _tmp34_, _tmp35_);
			if (_tmp36_) {
				GeeHashMap* _tmp37_;
				const gchar* _tmp38_;
				gpointer _tmp39_ = NULL;
				GeeArrayList* _tmp40_;
				gint _tmp41_;
				gint _tmp42_;
				gboolean _tmp43_;
				_tmp37_ = self->priv->request_queue;
				_tmp38_ = hashed_domain;
				_tmp39_ = gee_abstract_map_get ((GeeAbstractMap*) _tmp37_, _tmp38_);
				_tmp40_ = (GeeArrayList*) _tmp39_;
				_tmp41_ = gee_abstract_collection_get_size ((GeeCollection*) _tmp40_);
				_tmp42_ = _tmp41_;
				_tmp43_ = _tmp42_ == 0;
				_g_object_unref0 (_tmp40_);
				if (_tmp43_) {
					GeeHashMap* _tmp44_;
					const gchar* _tmp45_;
					_tmp44_ = self->priv->request_queue;
					_tmp45_ = hashed_domain;
					gee_abstract_map_unset ((GeeAbstractMap*) _tmp44_, _tmp45_, NULL);
				} else {
					GeeHashMap* _tmp46_;
					const gchar* _tmp47_;
					gpointer _tmp48_ = NULL;
					GeeArrayList* _tmp49_;
					gpointer _tmp50_ = NULL;
					NetsukukuRegisterHostnameArguments* _tmp51_;
					NetsukukuRegisterHostnameArguments* args;
					NetsukukuRegisterHostnameArguments* _tmp52_;
					NetsukukuAndnaDomainRequest* _tmp53_;
					NetsukukuRegisterHostnameArguments* _tmp54_;
					zcdSerializableBuffer* _tmp55_;
					NetsukukuAndnaRegisterMainResponse* _tmp56_ = NULL;
					NetsukukuAndnaRegisterMainResponse* res;
					_tmp46_ = self->priv->request_queue;
					_tmp47_ = hashed_domain;
					_tmp48_ = gee_abstract_map_get ((GeeAbstractMap*) _tmp46_, _tmp47_);
					_tmp49_ = (GeeArrayList*) _tmp48_;
					_tmp50_ = gee_abstract_list_remove_at ((GeeAbstractList*) _tmp49_, 0);
					_tmp51_ = (NetsukukuRegisterHostnameArguments*) _tmp50_;
					_g_object_unref0 (_tmp49_);
					args = _tmp51_;
					_tmp52_ = args;
					_tmp53_ = _tmp52_->request;
					_tmp54_ = args;
					_tmp55_ = _tmp54_->signature;
					_tmp56_ = netsukuku_iandna_as_peer_register_main_for_pubk ((NetsukukuIAndnaAsPeer*) self, _tmp53_, _tmp55_, TRUE, &_inner_error_);
					res = _tmp56_;
					if (_inner_error_ != NULL) {
						_g_object_unref0 (args);
						_g_object_unref0 (record);
						_g_free0 (hashed_domain);
						_g_object_unref0 (_hashed_domain_list);
						_g_object_unref0 (todel);
						g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
						g_clear_error (&_inner_error_);
						return;
					}
					_g_object_unref0 (res);
					_g_object_unref0 (args);
				}
			}
			_g_object_unref0 (record);
			_g_free0 (hashed_domain);
		}
		_g_object_unref0 (_hashed_domain_list);
	}
	_g_object_unref0 (todel);
}


/** Remotable methods as peer()
          */
static Block1Data* block1_data_ref (Block1Data* _data1_) {
	g_atomic_int_inc (&_data1_->_ref_count_);
	return _data1_;
}


static void block1_data_unref (void * _userdata_) {
	Block1Data* _data1_;
	_data1_ = (Block1Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data1_->_ref_count_)) {
		NetsukukuAndna * self;
		self = _data1_->self;
		_g_object_unref0 (_data1_->response_ttl);
		_g_free0 (_data1_->response_msg);
		_g_object_unref0 (_data1_->request);
		_g_object_unref0 (_data1_->signature);
		_g_object_unref0 (self);
		g_slice_free (Block1Data, _data1_);
	}
}


static guint _netsukuku_andna_service_key_hash_func_gee_hash_data_func (gconstpointer v, gpointer self) {
	guint result;
	result = netsukuku_andna_service_key_hash_func (v);
	return result;
}


static gboolean _netsukuku_andna_service_key_equal_func_gee_equal_data_func (gconstpointer a, gconstpointer b, gpointer self) {
	gboolean result;
	result = netsukuku_andna_service_key_equal_func (a, b);
	return result;
}


static gboolean _netsukuku_andna_server_record_equal_func_gee_equal_data_func (gconstpointer a, gconstpointer b, gpointer self) {
	gboolean result;
	result = netsukuku_andna_server_record_equal_func (a, b);
	return result;
}


static gboolean _netsukuku_register_hostname_arguments_equal_func_for_queue_gee_equal_data_func (gconstpointer a, gconstpointer b, gpointer self) {
	gboolean result;
	result = netsukuku_register_hostname_arguments_equal_func_for_queue (a, b);
	return result;
}


static gboolean __lambda9_ (Block1Data* _data1_, GError** error) {
	NetsukukuAndna * self;
	gboolean result = FALSE;
	NetsukukuAndnaDomainRequest* _tmp0_;
	NetsukukuAndnaDomainRequest* _tmp1_;
	NetsukukuPublicKey* _tmp2_;
	NetsukukuPublicKey* _tmp3_;
	zcdSerializableBuffer* _tmp4_;
	gboolean _tmp5_ = FALSE;
	NetsukukuCounter* _tmp7_;
	NetsukukuAndnaDomainRequest* _tmp8_;
	NetsukukuNIP* _tmp9_;
	NetsukukuNIP* _tmp10_;
	NetsukukuAndnaDomainRequest* _tmp11_;
	const gchar* _tmp12_;
	const gchar* _tmp13_;
	NetsukukuAndnaDomainRequest* _tmp14_;
	NetsukukuPublicKey* _tmp15_;
	NetsukukuPublicKey* _tmp16_;
	NetsukukuCounterCheckHostnameResponse* _tmp17_ = NULL;
	NetsukukuCounterCheckHostnameResponse* checkhostname;
	NetsukukuCounterCheckHostnameResponse* _tmp18_;
	gboolean _tmp19_;
	gboolean _tmp20_;
	GeeHashMap* _tmp22_;
	NetsukukuAndnaDomainRequest* _tmp23_;
	const gchar* _tmp24_;
	const gchar* _tmp25_;
	gboolean _tmp26_ = FALSE;
	GeeHashMap* _tmp44_;
	GeeHashMap* services;
	GeeHashMap* _tmp113_;
	NetsukukuAndnaDomainRequest* _tmp114_;
	const gchar* _tmp115_;
	const gchar* _tmp116_;
	gpointer _tmp117_ = NULL;
	NetsukukuAndnaDomainRecord* rec_in_cache;
	NetsukukuAndnaDomainRecord* _tmp118_;
	NetsukukuPublicKey* _tmp119_;
	NetsukukuPublicKey* _tmp120_;
	NetsukukuAndnaDomainRequest* _tmp121_;
	NetsukukuPublicKey* _tmp122_;
	NetsukukuPublicKey* _tmp123_;
	gboolean _tmp124_ = FALSE;
	GError * _inner_error_ = NULL;
	self = _data1_->self;
	_tmp0_ = _data1_->request;
	_tmp1_ = _data1_->request;
	_tmp2_ = netsukuku_andna_domain_request_get_pubk (_tmp1_);
	_tmp3_ = _tmp2_;
	_tmp4_ = _data1_->signature;
	_tmp5_ = _netsukuku_andna_verify (self, _tmp0_, _tmp3_, _tmp4_);
	if (!_tmp5_) {
		GError* _tmp6_;
		_tmp6_ = g_error_new_literal (NETSUKUKU_PEER_REFUSE_SERVICE_ERROR, NETSUKUKU_PEER_REFUSE_SERVICE_ERROR_GENERIC, "Not your signature.");
		_inner_error_ = _tmp6_;
		if (_inner_error_->domain == NETSUKUKU_PEER_REFUSE_SERVICE_ERROR) {
			g_propagate_error (error, _inner_error_);
			return FALSE;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return FALSE;
		}
	}
	_tmp7_ = self->priv->counter;
	_tmp8_ = _data1_->request;
	_tmp9_ = netsukuku_andna_domain_request_get_nip (_tmp8_);
	_tmp10_ = _tmp9_;
	_tmp11_ = _data1_->request;
	_tmp12_ = netsukuku_andna_domain_request_get_hashed_domain (_tmp11_);
	_tmp13_ = _tmp12_;
	_tmp14_ = _data1_->request;
	_tmp15_ = netsukuku_andna_domain_request_get_pubk (_tmp14_);
	_tmp16_ = _tmp15_;
	_tmp17_ = netsukuku_counter_ask_check_hostname (_tmp7_, _tmp10_, _tmp13_, _tmp16_, &_inner_error_);
	checkhostname = _tmp17_;
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == NETSUKUKU_PEER_REFUSE_SERVICE_ERROR) {
			g_propagate_error (error, _inner_error_);
			return FALSE;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return FALSE;
		}
	}
	_tmp18_ = checkhostname;
	_tmp19_ = netsukuku_counter_check_hostname_response_get_response (_tmp18_);
	_tmp20_ = _tmp19_;
	if (!_tmp20_) {
		GError* _tmp21_;
		_tmp21_ = g_error_new_literal (NETSUKUKU_PEER_REFUSE_SERVICE_ERROR, NETSUKUKU_PEER_REFUSE_SERVICE_ERROR_GENERIC, "Not registered in Counter service.");
		_inner_error_ = _tmp21_;
		if (_inner_error_->domain == NETSUKUKU_PEER_REFUSE_SERVICE_ERROR) {
			g_propagate_error (error, _inner_error_);
			_g_object_unref0 (checkhostname);
			return FALSE;
		} else {
			_g_object_unref0 (checkhostname);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return FALSE;
		}
	}
	_tmp22_ = self->priv->cache;
	_tmp23_ = _data1_->request;
	_tmp24_ = netsukuku_andna_domain_request_get_hashed_domain (_tmp23_);
	_tmp25_ = _tmp24_;
	_tmp26_ = gee_abstract_map_has_key ((GeeAbstractMap*) _tmp22_, _tmp25_);
	if (!_tmp26_) {
		GeeHashMap* _tmp27_;
		NetsukukuAndnaDomainRequest* _tmp28_;
		const gchar* _tmp29_;
		const gchar* _tmp30_;
		NetsukukuAndnaDomainRequest* _tmp31_;
		const gchar* _tmp32_;
		const gchar* _tmp33_;
		NetsukukuAndnaDomainRequest* _tmp34_;
		NetsukukuPublicKey* _tmp35_;
		NetsukukuPublicKey* _tmp36_;
		NetsukukuAndnaDomainRequest* _tmp37_;
		NetsukukuNIP* _tmp38_;
		NetsukukuNIP* _tmp39_;
		NetsukukuAndnaDomainRecord* _tmp40_;
		NetsukukuAndnaDomainRecord* _tmp41_;
		gchar* _tmp42_;
		NetsukukuTimeCapsule* _tmp43_;
		_tmp27_ = self->priv->cache;
		_tmp28_ = _data1_->request;
		_tmp29_ = netsukuku_andna_domain_request_get_hashed_domain (_tmp28_);
		_tmp30_ = _tmp29_;
		_tmp31_ = _data1_->request;
		_tmp32_ = netsukuku_andna_domain_request_get_hashed_domain (_tmp31_);
		_tmp33_ = _tmp32_;
		_tmp34_ = _data1_->request;
		_tmp35_ = netsukuku_andna_domain_request_get_pubk (_tmp34_);
		_tmp36_ = _tmp35_;
		_tmp37_ = _data1_->request;
		_tmp38_ = netsukuku_andna_domain_request_get_nip (_tmp37_);
		_tmp39_ = _tmp38_;
		_tmp40_ = netsukuku_andna_domain_record_new (NETSUKUKU_MAX_TTL_ANDNA, _tmp33_, _tmp36_, _tmp39_, NULL);
		_tmp41_ = _tmp40_;
		gee_abstract_map_set ((GeeAbstractMap*) _tmp27_, _tmp30_, _tmp41_);
		_g_object_unref0 (_tmp41_);
		_tmp42_ = g_strdup ("REGISTERED");
		_g_free0 (_data1_->response_msg);
		_data1_->response_msg = _tmp42_;
		_tmp43_ = netsukuku_time_capsule_new (NETSUKUKU_MAX_TTL_ANDNA);
		_g_object_unref0 (_data1_->response_ttl);
		_data1_->response_ttl = _tmp43_;
	}
	_tmp44_ = gee_hash_map_new (NETSUKUKU_TYPE_ANDNA_SERVICE_KEY, (GBoxedCopyFunc) g_object_ref, g_object_unref, GEE_TYPE_ARRAY_LIST, (GBoxedCopyFunc) g_object_ref, g_object_unref, _netsukuku_andna_service_key_hash_func_gee_hash_data_func, NULL, NULL, _netsukuku_andna_service_key_equal_func_gee_equal_data_func, NULL, NULL, NULL, NULL, NULL);
	services = _tmp44_;
	{
		NetsukukuAndnaDomainRequest* _tmp45_;
		GeeHashMap* _tmp46_;
		GeeHashMap* _tmp47_;
		GeeSet* _tmp48_;
		GeeSet* _tmp49_;
		GeeSet* _tmp50_;
		GeeIterator* _tmp51_ = NULL;
		GeeIterator* _tmp52_;
		GeeIterator* _srvk_it;
		_tmp45_ = _data1_->request;
		_tmp46_ = netsukuku_andna_domain_request_get_services (_tmp45_);
		_tmp47_ = _tmp46_;
		_tmp48_ = gee_abstract_map_get_keys ((GeeMap*) _tmp47_);
		_tmp49_ = _tmp48_;
		_tmp50_ = _tmp49_;
		_tmp51_ = gee_iterable_iterator ((GeeIterable*) _tmp50_);
		_tmp52_ = _tmp51_;
		_g_object_unref0 (_tmp50_);
		_srvk_it = _tmp52_;
		while (TRUE) {
			GeeIterator* _tmp53_;
			gboolean _tmp54_ = FALSE;
			GeeIterator* _tmp55_;
			gpointer _tmp56_ = NULL;
			NetsukukuAndnaServiceKey* srvk;
			GeeHashMap* _tmp57_;
			NetsukukuAndnaServiceKey* _tmp58_;
			GeeArrayList* _tmp59_;
			GeeArrayList* _tmp60_;
			GeeHashMap* _tmp104_;
			NetsukukuAndnaServiceKey* _tmp105_;
			gpointer _tmp106_ = NULL;
			GeeArrayList* _tmp107_;
			gint _tmp108_;
			gint _tmp109_;
			gboolean _tmp110_;
			_tmp53_ = _srvk_it;
			_tmp54_ = gee_iterator_next (_tmp53_);
			if (!_tmp54_) {
				break;
			}
			_tmp55_ = _srvk_it;
			_tmp56_ = gee_iterator_get (_tmp55_);
			srvk = (NetsukukuAndnaServiceKey*) _tmp56_;
			_tmp57_ = services;
			_tmp58_ = srvk;
			_tmp59_ = gee_array_list_new (NETSUKUKU_TYPE_ANDNA_SERVER_RECORD, (GBoxedCopyFunc) g_object_ref, g_object_unref, _netsukuku_andna_server_record_equal_func_gee_equal_data_func, NULL, NULL);
			_tmp60_ = _tmp59_;
			gee_abstract_map_set ((GeeAbstractMap*) _tmp57_, _tmp58_, _tmp60_);
			_g_object_unref0 (_tmp60_);
			{
				NetsukukuAndnaDomainRequest* _tmp61_;
				GeeHashMap* _tmp62_;
				GeeHashMap* _tmp63_;
				NetsukukuAndnaServiceKey* _tmp64_;
				gpointer _tmp65_ = NULL;
				GeeArrayList* _srvrec_list;
				GeeArrayList* _tmp66_;
				gint _tmp67_;
				gint _tmp68_;
				gint _srvrec_size;
				gint _srvrec_index;
				_tmp61_ = _data1_->request;
				_tmp62_ = netsukuku_andna_domain_request_get_services (_tmp61_);
				_tmp63_ = _tmp62_;
				_tmp64_ = srvk;
				_tmp65_ = gee_abstract_map_get ((GeeAbstractMap*) _tmp63_, _tmp64_);
				_srvrec_list = (GeeArrayList*) _tmp65_;
				_tmp66_ = _srvrec_list;
				_tmp67_ = gee_abstract_collection_get_size ((GeeCollection*) _tmp66_);
				_tmp68_ = _tmp67_;
				_srvrec_size = _tmp68_;
				_srvrec_index = -1;
				while (TRUE) {
					gint _tmp69_;
					gint _tmp70_;
					gint _tmp71_;
					GeeArrayList* _tmp72_;
					gint _tmp73_;
					gpointer _tmp74_ = NULL;
					NetsukukuAndnaServerRequest* srvrec;
					NetsukukuAndnaServerRequest* _tmp75_;
					const gchar* _tmp76_;
					const gchar* _tmp77_;
					_tmp69_ = _srvrec_index;
					_srvrec_index = _tmp69_ + 1;
					_tmp70_ = _srvrec_index;
					_tmp71_ = _srvrec_size;
					if (!(_tmp70_ < _tmp71_)) {
						break;
					}
					_tmp72_ = _srvrec_list;
					_tmp73_ = _srvrec_index;
					_tmp74_ = gee_abstract_list_get ((GeeAbstractList*) _tmp72_, _tmp73_);
					srvrec = (NetsukukuAndnaServerRequest*) _tmp74_;
					_tmp75_ = srvrec;
					_tmp76_ = netsukuku_andna_server_request_get_hashed_alias (_tmp75_);
					_tmp77_ = _tmp76_;
					if (_tmp77_ != NULL) {
						NetsukukuAndnaServerRequest* _tmp78_;
						const gchar* _tmp79_;
						const gchar* _tmp80_;
						NetsukukuAndnaGetRegistrarResponse* _tmp81_ = NULL;
						NetsukukuAndnaGetRegistrarResponse* registrar_alias;
						NetsukukuAndnaGetRegistrarResponse* _tmp82_;
						_tmp78_ = srvrec;
						_tmp79_ = netsukuku_andna_server_request_get_hashed_alias (_tmp78_);
						_tmp80_ = _tmp79_;
						_tmp81_ = netsukuku_andna_ask_registrar (self, _tmp80_);
						registrar_alias = _tmp81_;
						_tmp82_ = registrar_alias;
						if (_tmp82_ != NULL) {
							NetsukukuAndnaGetRegistrarResponse* _tmp83_;
							NetsukukuPublicKey* _tmp84_;
							NetsukukuPublicKey* _tmp85_;
							NetsukukuAndnaServerRequest* _tmp86_;
							NetsukukuPublicKey* _tmp87_;
							NetsukukuPublicKey* _tmp88_;
							gboolean _tmp89_ = FALSE;
							_tmp83_ = registrar_alias;
							_tmp84_ = netsukuku_andna_get_registrar_response_get_pubk (_tmp83_);
							_tmp85_ = _tmp84_;
							_tmp86_ = srvrec;
							_tmp87_ = netsukuku_andna_server_request_get_pubk (_tmp86_);
							_tmp88_ = _tmp87_;
							_tmp89_ = netsukuku_public_key_equal_func (_tmp85_, _tmp88_);
							if (_tmp89_) {
								GeeHashMap* _tmp90_;
								NetsukukuAndnaServiceKey* _tmp91_;
								gpointer _tmp92_ = NULL;
								GeeArrayList* _tmp93_;
								NetsukukuAndnaServerRequest* _tmp94_;
								NetsukukuAndnaServerRecord* _tmp95_ = NULL;
								NetsukukuAndnaServerRecord* _tmp96_;
								_tmp90_ = services;
								_tmp91_ = srvk;
								_tmp92_ = gee_abstract_map_get ((GeeAbstractMap*) _tmp90_, _tmp91_);
								_tmp93_ = (GeeArrayList*) _tmp92_;
								_tmp94_ = srvrec;
								_tmp95_ = netsukuku_andna_make_server_record (self, _tmp94_);
								_tmp96_ = _tmp95_;
								gee_abstract_collection_add ((GeeAbstractCollection*) _tmp93_, _tmp96_);
								_g_object_unref0 (_tmp96_);
								_g_object_unref0 (_tmp93_);
							}
						}
						_g_object_unref0 (registrar_alias);
					} else {
						GeeHashMap* _tmp97_;
						NetsukukuAndnaServiceKey* _tmp98_;
						gpointer _tmp99_ = NULL;
						GeeArrayList* _tmp100_;
						NetsukukuAndnaServerRequest* _tmp101_;
						NetsukukuAndnaServerRecord* _tmp102_ = NULL;
						NetsukukuAndnaServerRecord* _tmp103_;
						_tmp97_ = services;
						_tmp98_ = srvk;
						_tmp99_ = gee_abstract_map_get ((GeeAbstractMap*) _tmp97_, _tmp98_);
						_tmp100_ = (GeeArrayList*) _tmp99_;
						_tmp101_ = srvrec;
						_tmp102_ = netsukuku_andna_make_server_record (self, _tmp101_);
						_tmp103_ = _tmp102_;
						gee_abstract_collection_add ((GeeAbstractCollection*) _tmp100_, _tmp103_);
						_g_object_unref0 (_tmp103_);
						_g_object_unref0 (_tmp100_);
					}
					_g_object_unref0 (srvrec);
				}
				_g_object_unref0 (_srvrec_list);
			}
			_tmp104_ = services;
			_tmp105_ = srvk;
			_tmp106_ = gee_abstract_map_get ((GeeAbstractMap*) _tmp104_, _tmp105_);
			_tmp107_ = (GeeArrayList*) _tmp106_;
			_tmp108_ = gee_abstract_collection_get_size ((GeeCollection*) _tmp107_);
			_tmp109_ = _tmp108_;
			_tmp110_ = _tmp109_ == 0;
			_g_object_unref0 (_tmp107_);
			if (_tmp110_) {
				GeeHashMap* _tmp111_;
				NetsukukuAndnaServiceKey* _tmp112_;
				_tmp111_ = services;
				_tmp112_ = srvk;
				gee_abstract_map_unset ((GeeAbstractMap*) _tmp111_, _tmp112_, NULL);
			}
			_g_object_unref0 (srvk);
		}
		_g_object_unref0 (_srvk_it);
	}
	_tmp113_ = self->priv->cache;
	_tmp114_ = _data1_->request;
	_tmp115_ = netsukuku_andna_domain_request_get_hashed_domain (_tmp114_);
	_tmp116_ = _tmp115_;
	_tmp117_ = gee_abstract_map_get ((GeeAbstractMap*) _tmp113_, _tmp116_);
	rec_in_cache = (NetsukukuAndnaDomainRecord*) _tmp117_;
	_tmp118_ = rec_in_cache;
	_tmp119_ = netsukuku_andna_domain_record_get_pubk (_tmp118_);
	_tmp120_ = _tmp119_;
	_tmp121_ = _data1_->request;
	_tmp122_ = netsukuku_andna_domain_request_get_pubk (_tmp121_);
	_tmp123_ = _tmp122_;
	_tmp124_ = netsukuku_public_key_equal_func (_tmp120_, _tmp123_);
	if (_tmp124_) {
		NetsukukuAndnaDomainRecord* _tmp125_;
		NetsukukuAndnaDomainRequest* _tmp126_;
		NetsukukuNIP* _tmp127_;
		NetsukukuNIP* _tmp128_;
		GeeHashMap* _tmp129_;
		const gchar* _tmp130_;
		NetsukukuTimeCapsule* _tmp132_;
		_tmp125_ = rec_in_cache;
		_tmp126_ = _data1_->request;
		_tmp127_ = netsukuku_andna_domain_request_get_nip (_tmp126_);
		_tmp128_ = _tmp127_;
		_tmp129_ = services;
		netsukuku_andna_domain_record_update (_tmp125_, NETSUKUKU_MAX_TTL_ANDNA, _tmp128_, _tmp129_);
		_tmp130_ = _data1_->response_msg;
		if (g_strcmp0 (_tmp130_, "REGISTERED") != 0) {
			gchar* _tmp131_;
			_tmp131_ = g_strdup ("UPDATED");
			_g_free0 (_data1_->response_msg);
			_data1_->response_msg = _tmp131_;
		}
		_tmp132_ = netsukuku_time_capsule_new (NETSUKUKU_MAX_TTL_ANDNA);
		_g_object_unref0 (_data1_->response_ttl);
		_data1_->response_ttl = _tmp132_;
	} else {
		GeeHashMap* _tmp133_;
		NetsukukuAndnaDomainRequest* _tmp134_;
		const gchar* _tmp135_;
		const gchar* _tmp136_;
		gboolean _tmp137_ = FALSE;
		gboolean present;
		gboolean _tmp178_;
		_tmp133_ = self->priv->request_queue;
		_tmp134_ = _data1_->request;
		_tmp135_ = netsukuku_andna_domain_request_get_hashed_domain (_tmp134_);
		_tmp136_ = _tmp135_;
		_tmp137_ = gee_abstract_map_has_key ((GeeAbstractMap*) _tmp133_, _tmp136_);
		if (!_tmp137_) {
			GeeHashMap* _tmp138_;
			NetsukukuAndnaDomainRequest* _tmp139_;
			const gchar* _tmp140_;
			const gchar* _tmp141_;
			GeeArrayList* _tmp142_;
			GeeArrayList* _tmp143_;
			_tmp138_ = self->priv->request_queue;
			_tmp139_ = _data1_->request;
			_tmp140_ = netsukuku_andna_domain_request_get_hashed_domain (_tmp139_);
			_tmp141_ = _tmp140_;
			_tmp142_ = gee_array_list_new (NETSUKUKU_TYPE_REGISTER_HOSTNAME_ARGUMENTS, (GBoxedCopyFunc) g_object_ref, g_object_unref, _netsukuku_register_hostname_arguments_equal_func_for_queue_gee_equal_data_func, NULL, NULL);
			_tmp143_ = _tmp142_;
			gee_abstract_map_set ((GeeAbstractMap*) _tmp138_, _tmp141_, _tmp143_);
			_g_object_unref0 (_tmp143_);
		}
		present = FALSE;
		{
			GeeHashMap* _tmp144_;
			NetsukukuAndnaDomainRequest* _tmp145_;
			const gchar* _tmp146_;
			const gchar* _tmp147_;
			gpointer _tmp148_ = NULL;
			GeeArrayList* _args_list;
			GeeArrayList* _tmp149_;
			gint _tmp150_;
			gint _tmp151_;
			gint _args_size;
			gint _args_index;
			_tmp144_ = self->priv->request_queue;
			_tmp145_ = _data1_->request;
			_tmp146_ = netsukuku_andna_domain_request_get_hashed_domain (_tmp145_);
			_tmp147_ = _tmp146_;
			_tmp148_ = gee_abstract_map_get ((GeeAbstractMap*) _tmp144_, _tmp147_);
			_args_list = (GeeArrayList*) _tmp148_;
			_tmp149_ = _args_list;
			_tmp150_ = gee_abstract_collection_get_size ((GeeCollection*) _tmp149_);
			_tmp151_ = _tmp150_;
			_args_size = _tmp151_;
			_args_index = -1;
			while (TRUE) {
				gint _tmp152_;
				gint _tmp153_;
				gint _tmp154_;
				GeeArrayList* _tmp155_;
				gint _tmp156_;
				gpointer _tmp157_ = NULL;
				NetsukukuRegisterHostnameArguments* args;
				NetsukukuRegisterHostnameArguments* _tmp158_;
				NetsukukuAndnaDomainRequest* _tmp159_;
				NetsukukuPublicKey* _tmp160_;
				NetsukukuPublicKey* _tmp161_;
				NetsukukuAndnaDomainRequest* _tmp162_;
				NetsukukuPublicKey* _tmp163_;
				NetsukukuPublicKey* _tmp164_;
				gboolean _tmp165_ = FALSE;
				_tmp152_ = _args_index;
				_args_index = _tmp152_ + 1;
				_tmp153_ = _args_index;
				_tmp154_ = _args_size;
				if (!(_tmp153_ < _tmp154_)) {
					break;
				}
				_tmp155_ = _args_list;
				_tmp156_ = _args_index;
				_tmp157_ = gee_abstract_list_get ((GeeAbstractList*) _tmp155_, _tmp156_);
				args = (NetsukukuRegisterHostnameArguments*) _tmp157_;
				_tmp158_ = args;
				_tmp159_ = _tmp158_->request;
				_tmp160_ = netsukuku_andna_domain_request_get_pubk (_tmp159_);
				_tmp161_ = _tmp160_;
				_tmp162_ = _data1_->request;
				_tmp163_ = netsukuku_andna_domain_request_get_pubk (_tmp162_);
				_tmp164_ = _tmp163_;
				_tmp165_ = netsukuku_public_key_equal_func (_tmp161_, _tmp164_);
				if (_tmp165_) {
					NetsukukuRegisterHostnameArguments* _tmp166_;
					NetsukukuAndnaDomainRequest* _tmp167_;
					NetsukukuAndnaDomainRequest* _tmp168_;
					NetsukukuRegisterHostnameArguments* _tmp169_;
					zcdSerializableBuffer* _tmp170_;
					zcdSerializableBuffer* _tmp171_;
					NetsukukuRegisterHostnameArguments* _tmp172_;
					NetsukukuTimeCapsule* _tmp173_;
					gchar* _tmp174_;
					NetsukukuRegisterHostnameArguments* _tmp175_;
					NetsukukuTimeCapsule* _tmp176_;
					NetsukukuTimeCapsule* _tmp177_;
					present = TRUE;
					_tmp166_ = args;
					_tmp167_ = _data1_->request;
					_tmp168_ = _g_object_ref0 (_tmp167_);
					_g_object_unref0 (_tmp166_->request);
					_tmp166_->request = _tmp168_;
					_tmp169_ = args;
					_tmp170_ = _data1_->signature;
					_tmp171_ = _g_object_ref0 (_tmp170_);
					_g_object_unref0 (_tmp169_->signature);
					_tmp169_->signature = _tmp171_;
					_tmp172_ = args;
					_tmp173_ = netsukuku_time_capsule_new (NETSUKUKU_MAX_TTL_ANDNA);
					_g_object_unref0 (_tmp172_->expires);
					_tmp172_->expires = _tmp173_;
					_tmp174_ = g_strdup ("QUEUED");
					_g_free0 (_data1_->response_msg);
					_data1_->response_msg = _tmp174_;
					_tmp175_ = args;
					_tmp176_ = _tmp175_->expires;
					_tmp177_ = _g_object_ref0 (_tmp176_);
					_g_object_unref0 (_data1_->response_ttl);
					_data1_->response_ttl = _tmp177_;
				}
				_g_object_unref0 (args);
			}
			_g_object_unref0 (_args_list);
		}
		_tmp178_ = present;
		if (!_tmp178_) {
			GeeHashMap* _tmp179_;
			NetsukukuAndnaDomainRequest* _tmp180_;
			const gchar* _tmp181_;
			const gchar* _tmp182_;
			gpointer _tmp183_ = NULL;
			GeeArrayList* _tmp184_;
			gint _tmp185_;
			gint _tmp186_;
			gboolean _tmp187_;
			_tmp179_ = self->priv->request_queue;
			_tmp180_ = _data1_->request;
			_tmp181_ = netsukuku_andna_domain_request_get_hashed_domain (_tmp180_);
			_tmp182_ = _tmp181_;
			_tmp183_ = gee_abstract_map_get ((GeeAbstractMap*) _tmp179_, _tmp182_);
			_tmp184_ = (GeeArrayList*) _tmp183_;
			_tmp185_ = gee_abstract_collection_get_size ((GeeCollection*) _tmp184_);
			_tmp186_ = _tmp185_;
			_tmp187_ = _tmp186_ < NETSUKUKU_MAX_QUEUE_ANDNA;
			_g_object_unref0 (_tmp184_);
			if (_tmp187_) {
				GeeHashMap* _tmp188_;
				NetsukukuAndnaDomainRequest* _tmp189_;
				const gchar* _tmp190_;
				const gchar* _tmp191_;
				gpointer _tmp192_ = NULL;
				GeeArrayList* _tmp193_;
				NetsukukuAndnaDomainRequest* _tmp194_;
				zcdSerializableBuffer* _tmp195_;
				NetsukukuTimeCapsule* _tmp196_;
				NetsukukuTimeCapsule* _tmp197_;
				NetsukukuRegisterHostnameArguments* _tmp198_;
				NetsukukuRegisterHostnameArguments* _tmp199_;
				_tmp188_ = self->priv->request_queue;
				_tmp189_ = _data1_->request;
				_tmp190_ = netsukuku_andna_domain_request_get_hashed_domain (_tmp189_);
				_tmp191_ = _tmp190_;
				_tmp192_ = gee_abstract_map_get ((GeeAbstractMap*) _tmp188_, _tmp191_);
				_tmp193_ = (GeeArrayList*) _tmp192_;
				_tmp194_ = _data1_->request;
				_tmp195_ = _data1_->signature;
				_tmp196_ = netsukuku_time_capsule_new (NETSUKUKU_MAX_TTL_ANDNA);
				_tmp197_ = _tmp196_;
				_tmp198_ = netsukuku_register_hostname_arguments_new (_tmp194_, _tmp195_, _tmp197_);
				_tmp199_ = _tmp198_;
				gee_abstract_collection_add ((GeeAbstractCollection*) _tmp193_, _tmp199_);
				_g_object_unref0 (_tmp199_);
				_g_object_unref0 (_tmp197_);
				_g_object_unref0 (_tmp193_);
			} else {
				gchar* _tmp200_;
				NetsukukuTimeCapsule* _tmp201_;
				_tmp200_ = g_strdup ("QUEUE_FULL");
				_g_free0 (_data1_->response_msg);
				_data1_->response_msg = _tmp200_;
				_tmp201_ = netsukuku_time_capsule_new ((gint64) 0);
				_g_object_unref0 (_data1_->response_ttl);
				_data1_->response_ttl = _tmp201_;
			}
		}
	}
	result = TRUE;
	_g_object_unref0 (rec_in_cache);
	_g_object_unref0 (services);
	_g_object_unref0 (checkhostname);
	return result;
}


static gboolean ___lambda9__netsukuku_accept_record_callback (gpointer self, GError** error) {
	gboolean result;
	result = __lambda9_ (self, error);
	return result;
}


static void _____lambda11_ (NetsukukuAndna* self, GObject* tpar1, GObject* tpar2, GError** error) {
	GObject* _tmp0_;
	NetsukukuNIP* _tmp1_;
	NetsukukuNIP* tonip;
	GObject* _tmp2_;
	NetsukukuArgumentsForDuplicationRegisterMain* _tmp3_;
	NetsukukuArgumentsForDuplicationRegisterMain* arec;
	GError * _inner_error_ = NULL;
	_tmp0_ = tpar1;
	_tmp1_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, NETSUKUKU_TYPE_NIP, NetsukukuNIP));
	tonip = _tmp1_;
	_tmp2_ = tpar2;
	_tmp3_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp2_, NETSUKUKU_TYPE_ARGUMENTS_FOR_DUPLICATION_REGISTER_MAIN, NetsukukuArgumentsForDuplicationRegisterMain));
	arec = _tmp3_;
	tasklets_tasklet_declare_self ("Andna.forward_record_main");
	{
		NetsukukuRmtAndnaPeer* _tmp4_ = NULL;
		NetsukukuRmtAndnaPeer* _tmp5_;
		NetsukukuAndnaDomainRequest* _tmp6_;
		zcdSerializableBuffer* _tmp7_;
		NetsukukuAndnaRegisterMainResponse* _tmp8_ = NULL;
		NetsukukuAndnaRegisterMainResponse* _tmp9_;
		_tmp4_ = netsukuku_andna_peer (self, tonip, NULL, NULL);
		_tmp5_ = _tmp4_;
		_tmp6_ = arec->request;
		_tmp7_ = arec->signature;
		_tmp8_ = netsukuku_iandna_as_peer_register_main_for_pubk ((NetsukukuIAndnaAsPeer*) _tmp5_, _tmp6_, _tmp7_, FALSE, &_inner_error_);
		_tmp9_ = _tmp8_;
		_g_object_unref0 (_tmp9_);
		_g_object_unref0 (_tmp5_);
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == ZCD_RPC_ERROR) {
				goto __catch11_zcd_rpc_error;
			}
			goto __finally11;
		}
	}
	goto __finally11;
	__catch11_zcd_rpc_error:
	{
		GError* e = NULL;
		gchar* _tmp10_ = NULL;
		gchar* _tmp11_;
		gchar* _tmp12_ = NULL;
		gchar* _tmp13_;
		GError* _tmp14_;
		GQuark _tmp15_;
		const gchar* _tmp16_ = NULL;
		const gchar* _tmp17_ = NULL;
		GError* _tmp18_;
		gint _tmp19_;
		gchar* _tmp20_ = NULL;
		gchar* _tmp21_;
		GError* _tmp22_;
		const gchar* _tmp23_;
		const gchar* _tmp24_ = NULL;
		gchar* _tmp25_ = NULL;
		gchar* _tmp26_;
		gchar* _tmp27_;
		gchar* _tmp28_;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp10_ = netsukuku_partial_nip_to_string ((NetsukukuPartialNIP*) tonip);
		_tmp11_ = _tmp10_;
		_tmp12_ = g_strconcat ("Andna.forward_record_main: forwarding to ", _tmp11_, ":", NULL);
		_tmp13_ = _tmp12_;
		_tmp14_ = e;
		_tmp15_ = _tmp14_->domain;
		_tmp16_ = g_quark_to_string (_tmp15_);
		_tmp17_ = string_to_string (_tmp16_);
		_tmp18_ = e;
		_tmp19_ = _tmp18_->code;
		_tmp20_ = g_strdup_printf ("%i", _tmp19_);
		_tmp21_ = _tmp20_;
		_tmp22_ = e;
		_tmp23_ = _tmp22_->message;
		_tmp24_ = string_to_string (_tmp23_);
		_tmp25_ = g_strconcat (" got ", _tmp17_, " ", _tmp21_, " ", _tmp24_, NULL);
		_tmp26_ = _tmp25_;
		_tmp27_ = g_strconcat (_tmp13_, _tmp26_, NULL);
		_tmp28_ = _tmp27_;
		netsukuku_log_warn (_tmp28_);
		_g_free0 (_tmp28_);
		_g_free0 (_tmp26_);
		_g_free0 (_tmp21_);
		_g_free0 (_tmp13_);
		_g_free0 (_tmp11_);
		_g_error_free0 (e);
	}
	__finally11:
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		_g_object_unref0 (arec);
		_g_object_unref0 (tonip);
		return;
	}
	_g_object_unref0 (arec);
	_g_object_unref0 (tonip);
}


static void ______lambda11__tasklets_tasklet_callback (GObject* obj1, GObject* obj2, GObject* obj3, GObject* obj4, gpointer self, GError** error) {
	_____lambda11_ (self, obj1, obj2, error);
}


static void __lambda10_ (NetsukukuAndna* self, GObject* tasklet_obj1, GeeList* tasklet_replica_nodes, GError** error) {
	GObject* _tmp0_;
	NetsukukuArgumentsForDuplicationRegisterMain* _tmp1_;
	NetsukukuArgumentsForDuplicationRegisterMain* tasklet_rec;
	GeeList* _tmp2_;
	_tmp0_ = tasklet_obj1;
	_tmp1_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, NETSUKUKU_TYPE_ARGUMENTS_FOR_DUPLICATION_REGISTER_MAIN, NetsukukuArgumentsForDuplicationRegisterMain));
	tasklet_rec = _tmp1_;
	_tmp2_ = tasklet_replica_nodes;
	if (_tmp2_ == NULL) {
		NetsukukuArgumentsForDuplicationRegisterMain* _tmp3_;
		NetsukukuNIP* _tmp4_;
		GeeList* _tmp5_ = NULL;
		_tmp3_ = tasklet_rec;
		_tmp4_ = _tmp3_->hashnode;
		_tmp5_ = netsukuku_peer_to_peer_find_nearest_to_register ((NetsukukuPeerToPeer*) self, _tmp4_, NETSUKUKU_ANDNA_DUPLICATION);
		_g_object_unref0 (tasklet_replica_nodes);
		tasklet_replica_nodes = _tmp5_;
	}
	{
		GeeList* _tmp6_;
		GeeList* _tmp7_;
		GeeList* _replica_node_list;
		GeeList* _tmp8_;
		gint _tmp9_;
		gint _tmp10_;
		gint _replica_node_size;
		gint _replica_node_index;
		_tmp6_ = tasklet_replica_nodes;
		_tmp7_ = _g_object_ref0 (_tmp6_);
		_replica_node_list = _tmp7_;
		_tmp8_ = _replica_node_list;
		_tmp9_ = gee_collection_get_size ((GeeCollection*) _tmp8_);
		_tmp10_ = _tmp9_;
		_replica_node_size = _tmp10_;
		_replica_node_index = -1;
		while (TRUE) {
			gint _tmp11_;
			gint _tmp12_;
			gint _tmp13_;
			GeeList* _tmp14_;
			gint _tmp15_;
			gpointer _tmp16_ = NULL;
			NetsukukuNIP* replica_node;
			NetsukukuNIP* _tmp17_;
			NetsukukuMapRoute* _tmp18_;
			NetsukukuNIP* _tmp19_;
			gboolean _tmp20_ = FALSE;
			_tmp11_ = _replica_node_index;
			_replica_node_index = _tmp11_ + 1;
			_tmp12_ = _replica_node_index;
			_tmp13_ = _replica_node_size;
			if (!(_tmp12_ < _tmp13_)) {
				break;
			}
			_tmp14_ = _replica_node_list;
			_tmp15_ = _replica_node_index;
			_tmp16_ = gee_list_get (_tmp14_, _tmp15_);
			replica_node = (NetsukukuNIP*) _tmp16_;
			_tmp17_ = replica_node;
			_tmp18_ = ((NetsukukuPeerToPeer*) self)->maproute;
			_tmp19_ = _tmp18_->me;
			_tmp20_ = netsukuku_partial_nip_is_equal ((NetsukukuPartialNIP*) _tmp17_, (NetsukukuPartialNIP*) _tmp19_);
			if (!_tmp20_) {
				NetsukukuNIP* _tmp21_;
				NetsukukuArgumentsForDuplicationRegisterMain* _tmp22_;
				TaskletsTasklet* _tmp23_ = NULL;
				TaskletsTasklet* _tmp24_;
				_tmp21_ = replica_node;
				_tmp22_ = tasklet_rec;
				_tmp23_ = tasklets_tasklet_tasklet_callback (______lambda11__tasklets_tasklet_callback, self, (GObject*) _tmp21_, (GObject*) _tmp22_, NULL, NULL);
				_tmp24_ = _tmp23_;
				_g_object_unref0 (_tmp24_);
			}
			_g_object_unref0 (replica_node);
		}
		_g_object_unref0 (_replica_node_list);
	}
	_g_object_unref0 (tasklet_rec);
	_g_object_unref0 (tasklet_replica_nodes);
}


static void ___lambda10__netsukuku_forward_record_callback (GObject* obj1, GeeList* replica_nodes, gpointer self, GError** error) {
	__lambda10_ (self, obj1, replica_nodes, error);
}


static NetsukukuAndnaRegisterMainResponse* netsukuku_andna_real_register_main_for_pubk (NetsukukuIAndnaAsPeer* base, NetsukukuAndnaDomainRequest* request, zcdSerializableBuffer* signature, gboolean replicate, GError** error) {
	NetsukukuAndna * self;
	NetsukukuAndnaRegisterMainResponse* result = NULL;
	Block1Data* _data1_;
	NetsukukuAndnaDomainRequest* _tmp0_;
	NetsukukuAndnaDomainRequest* _tmp1_;
	zcdSerializableBuffer* _tmp2_;
	zcdSerializableBuffer* _tmp3_;
	gboolean _tmp4_;
	gchar* _tmp12_;
	NetsukukuTimeCapsule* _tmp13_;
	NetsukukuAndnaDomainRequest* _tmp14_;
	const gchar* _tmp15_;
	const gchar* _tmp16_;
	NetsukukuAndnaServiceHashnodeKey* _tmp17_;
	NetsukukuAndnaServiceHashnodeKey* _tmp18_;
	NetsukukuNIP* _tmp19_ = NULL;
	NetsukukuNIP* _tmp20_;
	NetsukukuNIP* hashnode;
	NetsukukuArgumentsForDuplicationRegisterMain* _tmp21_;
	NetsukukuArgumentsForDuplicationRegisterMain* rec;
	NetsukukuArgumentsForDuplicationRegisterMain* _tmp22_;
	NetsukukuAndnaDomainRequest* _tmp23_;
	NetsukukuAndnaDomainRequest* _tmp24_;
	NetsukukuArgumentsForDuplicationRegisterMain* _tmp25_;
	zcdSerializableBuffer* _tmp26_;
	zcdSerializableBuffer* _tmp27_;
	NetsukukuArgumentsForDuplicationRegisterMain* _tmp28_;
	NetsukukuNIP* _tmp29_;
	NetsukukuNIP* _tmp30_;
	NetsukukuNIP* _tmp31_;
	gboolean _tmp32_;
	NetsukukuArgumentsForDuplicationRegisterMain* _tmp33_;
	const gchar* _tmp34_;
	NetsukukuTimeCapsule* _tmp35_;
	NetsukukuAndnaRegisterMainResponse* _tmp36_;
	GError * _inner_error_ = NULL;
	self = (NetsukukuAndna*) base;
	g_return_val_if_fail (request != NULL, NULL);
	g_return_val_if_fail (signature != NULL, NULL);
	_data1_ = g_slice_new0 (Block1Data);
	_data1_->_ref_count_ = 1;
	_data1_->self = g_object_ref (self);
	_tmp0_ = request;
	_tmp1_ = _g_object_ref0 (_tmp0_);
	_g_object_unref0 (_data1_->request);
	_data1_->request = _tmp1_;
	_tmp2_ = signature;
	_tmp3_ = _g_object_ref0 (_tmp2_);
	_g_object_unref0 (_data1_->signature);
	_data1_->signature = _tmp3_;
	_tmp4_ = self->memory_initialized;
	if (!_tmp4_) {
		gboolean _tmp5_;
		_tmp5_ = replicate;
		if (_tmp5_) {
			TaskletsTimer* _tmp6_;
			TaskletsTimer* w;
			_tmp6_ = tasklets_timer_new ((gint64) 10000);
			w = _tmp6_;
			while (TRUE) {
				gboolean _tmp7_;
				TaskletsTimer* _tmp8_;
				gboolean _tmp9_ = FALSE;
				_tmp7_ = self->memory_initialized;
				if (!(!_tmp7_)) {
					break;
				}
				_tmp8_ = w;
				_tmp9_ = tasklets_timer_is_expired (_tmp8_);
				if (_tmp9_) {
					GError* _tmp10_;
					_tmp10_ = g_error_new_literal (NETSUKUKU_PEER_REFUSE_SERVICE_ERROR, NETSUKUKU_PEER_REFUSE_SERVICE_ERROR_GENERIC, "Memory not ready yet");
					_inner_error_ = _tmp10_;
					if (_inner_error_->domain == NETSUKUKU_PEER_REFUSE_SERVICE_ERROR) {
						g_propagate_error (error, _inner_error_);
						_g_object_unref0 (w);
						block1_data_unref (_data1_);
						_data1_ = NULL;
						return NULL;
					} else {
						_g_object_unref0 (w);
						block1_data_unref (_data1_);
						_data1_ = NULL;
						g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
						g_clear_error (&_inner_error_);
						return NULL;
					}
				}
				tasklets_tasklet_nap ((glong) 0, (glong) 1000);
			}
			_g_object_unref0 (w);
		} else {
			while (TRUE) {
				gboolean _tmp11_;
				_tmp11_ = self->memory_initialized;
				if (!(!_tmp11_)) {
					break;
				}
				tasklets_tasklet_nap ((glong) 0, (glong) 1000);
			}
		}
	}
	_tmp12_ = g_strdup ("Noooo");
	_data1_->response_msg = _tmp12_;
	_tmp13_ = netsukuku_time_capsule_new ((gint64) 0);
	_data1_->response_ttl = _tmp13_;
	netsukuku_andna_check_expirations_cache (self);
	_tmp14_ = _data1_->request;
	_tmp15_ = netsukuku_andna_domain_request_get_hashed_domain (_tmp14_);
	_tmp16_ = _tmp15_;
	_tmp17_ = netsukuku_andna_service_hashnode_key_new (_tmp16_, 0);
	_tmp18_ = _tmp17_;
	_tmp19_ = netsukuku_peer_to_peer_h ((NetsukukuPeerToPeer*) self, (GObject*) _tmp18_);
	_tmp20_ = _tmp19_;
	_g_object_unref0 (_tmp18_);
	hashnode = _tmp20_;
	_tmp21_ = netsukuku_arguments_for_duplication_register_main_new ();
	rec = _tmp21_;
	_tmp22_ = rec;
	_tmp23_ = _data1_->request;
	_tmp24_ = _g_object_ref0 (_tmp23_);
	_g_object_unref0 (_tmp22_->request);
	_tmp22_->request = _tmp24_;
	_tmp25_ = rec;
	_tmp26_ = _data1_->signature;
	_tmp27_ = _g_object_ref0 (_tmp26_);
	_g_object_unref0 (_tmp25_->signature);
	_tmp25_->signature = _tmp27_;
	_tmp28_ = rec;
	_tmp29_ = hashnode;
	_tmp30_ = _g_object_ref0 (_tmp29_);
	_g_object_unref0 (_tmp28_->hashnode);
	_tmp28_->hashnode = _tmp30_;
	_tmp31_ = hashnode;
	_tmp32_ = replicate;
	_tmp33_ = rec;
	netsukuku_check_hash_and_start_replica ((NetsukukuPeerToPeer*) self, _tmp31_, _tmp32_, (GObject*) _tmp33_, NETSUKUKU_ANDNA_DUPLICATION, ___lambda9__netsukuku_accept_record_callback, _data1_, ___lambda10__netsukuku_forward_record_callback, self, NULL, NULL, &_inner_error_);
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == NETSUKUKU_PEER_REFUSE_SERVICE_ERROR) {
			g_propagate_error (error, _inner_error_);
			_g_object_unref0 (rec);
			_g_object_unref0 (hashnode);
			block1_data_unref (_data1_);
			_data1_ = NULL;
			return NULL;
		} else {
			_g_object_unref0 (rec);
			_g_object_unref0 (hashnode);
			block1_data_unref (_data1_);
			_data1_ = NULL;
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	}
	_tmp34_ = _data1_->response_msg;
	_tmp35_ = _data1_->response_ttl;
	_tmp36_ = netsukuku_andna_register_main_response_new (_tmp34_, _tmp35_);
	result = _tmp36_;
	_g_object_unref0 (rec);
	_g_object_unref0 (hashnode);
	block1_data_unref (_data1_);
	_data1_ = NULL;
	return result;
}


static NetsukukuAndnaGetRegistrarResponse* netsukuku_andna_real_get_registrar (NetsukukuIAndnaAsPeer* base, const gchar* hashed_domain, GError** error) {
	NetsukukuAndna * self;
	NetsukukuAndnaGetRegistrarResponse* result = NULL;
	gboolean _tmp0_;
	const gchar* _tmp6_;
	NetsukukuAndnaServiceHashnodeKey* _tmp7_;
	NetsukukuAndnaServiceHashnodeKey* _tmp8_;
	NetsukukuNIP* _tmp9_ = NULL;
	NetsukukuNIP* _tmp10_;
	NetsukukuNIP* hashnode;
	NetsukukuNIP* _tmp11_;
	NetsukukuHCoord* _tmp12_ = NULL;
	NetsukukuHCoord* _tmp13_;
	NetsukukuHCoord* _tmp14_;
	gboolean _tmp15_;
	GeeHashMap* _tmp17_;
	const gchar* _tmp18_;
	gboolean _tmp19_ = FALSE;
	GError * _inner_error_ = NULL;
	self = (NetsukukuAndna*) base;
	g_return_val_if_fail (hashed_domain != NULL, NULL);
	_tmp0_ = self->memory_initialized;
	if (!_tmp0_) {
		TaskletsTimer* _tmp1_;
		TaskletsTimer* w;
		_tmp1_ = tasklets_timer_new ((gint64) 10000);
		w = _tmp1_;
		while (TRUE) {
			gboolean _tmp2_;
			TaskletsTimer* _tmp3_;
			gboolean _tmp4_ = FALSE;
			_tmp2_ = self->memory_initialized;
			if (!(!_tmp2_)) {
				break;
			}
			_tmp3_ = w;
			_tmp4_ = tasklets_timer_is_expired (_tmp3_);
			if (_tmp4_) {
				GError* _tmp5_;
				_tmp5_ = g_error_new_literal (NETSUKUKU_PEER_REFUSE_SERVICE_ERROR, NETSUKUKU_PEER_REFUSE_SERVICE_ERROR_GENERIC, "Memory not ready yet");
				_inner_error_ = _tmp5_;
				if (_inner_error_->domain == NETSUKUKU_PEER_REFUSE_SERVICE_ERROR) {
					g_propagate_error (error, _inner_error_);
					_g_object_unref0 (w);
					return NULL;
				} else {
					_g_object_unref0 (w);
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
					g_clear_error (&_inner_error_);
					return NULL;
				}
			}
			tasklets_tasklet_nap ((glong) 0, (glong) 1000);
		}
		_g_object_unref0 (w);
	}
	netsukuku_andna_check_expirations_cache (self);
	_tmp6_ = hashed_domain;
	_tmp7_ = netsukuku_andna_service_hashnode_key_new (_tmp6_, 0);
	_tmp8_ = _tmp7_;
	_tmp9_ = netsukuku_peer_to_peer_h ((NetsukukuPeerToPeer*) self, (GObject*) _tmp8_);
	_tmp10_ = _tmp9_;
	_g_object_unref0 (_tmp8_);
	hashnode = _tmp10_;
	_tmp11_ = hashnode;
	_tmp12_ = netsukuku_peer_to_peer_search_participant ((NetsukukuPeerToPeer*) self, _tmp11_, 1, &_inner_error_);
	_tmp13_ = _tmp12_;
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == NETSUKUKU_PEER_REFUSE_SERVICE_ERROR) {
			g_propagate_error (error, _inner_error_);
			_g_object_unref0 (hashnode);
			return NULL;
		} else {
			_g_object_unref0 (hashnode);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	}
	_tmp14_ = _tmp13_;
	_tmp15_ = _tmp14_ != NULL;
	_g_object_unref0 (_tmp14_);
	if (_tmp15_) {
		GError* _tmp16_;
		_tmp16_ = g_error_new_literal (NETSUKUKU_PEER_REFUSE_SERVICE_ERROR, NETSUKUKU_PEER_REFUSE_SERVICE_ERROR_GENERIC, "Not the correct hashnode");
		_inner_error_ = _tmp16_;
		if (_inner_error_->domain == NETSUKUKU_PEER_REFUSE_SERVICE_ERROR) {
			g_propagate_error (error, _inner_error_);
			_g_object_unref0 (hashnode);
			return NULL;
		} else {
			_g_object_unref0 (hashnode);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	}
	_tmp17_ = self->priv->cache;
	_tmp18_ = hashed_domain;
	_tmp19_ = gee_abstract_map_has_key ((GeeAbstractMap*) _tmp17_, _tmp18_);
	if (_tmp19_) {
		GeeHashMap* _tmp20_;
		const gchar* _tmp21_;
		gpointer _tmp22_ = NULL;
		NetsukukuAndnaDomainRecord* ret;
		NetsukukuAndnaDomainRecord* _tmp23_;
		NetsukukuPublicKey* _tmp24_;
		NetsukukuPublicKey* _tmp25_;
		NetsukukuAndnaDomainRecord* _tmp26_;
		NetsukukuNIP* _tmp27_;
		NetsukukuNIP* _tmp28_;
		NetsukukuAndnaDomainRecord* _tmp29_;
		NetsukukuTimeCapsule* _tmp30_;
		NetsukukuTimeCapsule* _tmp31_;
		NetsukukuAndnaGetRegistrarResponse* _tmp32_;
		_tmp20_ = self->priv->cache;
		_tmp21_ = hashed_domain;
		_tmp22_ = gee_abstract_map_get ((GeeAbstractMap*) _tmp20_, _tmp21_);
		ret = (NetsukukuAndnaDomainRecord*) _tmp22_;
		_tmp23_ = ret;
		_tmp24_ = netsukuku_andna_domain_record_get_pubk (_tmp23_);
		_tmp25_ = _tmp24_;
		_tmp26_ = ret;
		_tmp27_ = netsukuku_andna_domain_record_get_nip (_tmp26_);
		_tmp28_ = _tmp27_;
		_tmp29_ = ret;
		_tmp30_ = netsukuku_andna_domain_record_get_expires (_tmp29_);
		_tmp31_ = _tmp30_;
		_tmp32_ = netsukuku_andna_get_registrar_response_new (_tmp25_, _tmp28_, _tmp31_);
		result = _tmp32_;
		_g_object_unref0 (ret);
		_g_object_unref0 (hashnode);
		return result;
	} else {
		result = NULL;
		_g_object_unref0 (hashnode);
		return result;
	}
	_g_object_unref0 (hashnode);
}


static NetsukukuAndnaDomainRecord* netsukuku_andna_real_get_domain_record (NetsukukuIAndnaAsPeer* base, const gchar* hashed_domain, GError** error) {
	NetsukukuAndna * self;
	NetsukukuAndnaDomainRecord* result = NULL;
	gboolean _tmp0_;
	const gchar* _tmp6_;
	NetsukukuAndnaServiceHashnodeKey* _tmp7_;
	NetsukukuAndnaServiceHashnodeKey* _tmp8_;
	NetsukukuNIP* _tmp9_ = NULL;
	NetsukukuNIP* _tmp10_;
	NetsukukuNIP* hashnode;
	NetsukukuNIP* _tmp11_;
	NetsukukuHCoord* _tmp12_ = NULL;
	NetsukukuHCoord* _tmp13_;
	NetsukukuHCoord* _tmp14_;
	gboolean _tmp15_;
	GeeHashMap* _tmp17_;
	const gchar* _tmp18_;
	gboolean _tmp19_ = FALSE;
	GeeHashMap* _tmp20_;
	const gchar* _tmp21_;
	gpointer _tmp22_ = NULL;
	GError * _inner_error_ = NULL;
	self = (NetsukukuAndna*) base;
	g_return_val_if_fail (hashed_domain != NULL, NULL);
	_tmp0_ = self->memory_initialized;
	if (!_tmp0_) {
		TaskletsTimer* _tmp1_;
		TaskletsTimer* w;
		_tmp1_ = tasklets_timer_new ((gint64) 10000);
		w = _tmp1_;
		while (TRUE) {
			gboolean _tmp2_;
			TaskletsTimer* _tmp3_;
			gboolean _tmp4_ = FALSE;
			_tmp2_ = self->memory_initialized;
			if (!(!_tmp2_)) {
				break;
			}
			_tmp3_ = w;
			_tmp4_ = tasklets_timer_is_expired (_tmp3_);
			if (_tmp4_) {
				GError* _tmp5_;
				_tmp5_ = g_error_new_literal (NETSUKUKU_PEER_REFUSE_SERVICE_ERROR, NETSUKUKU_PEER_REFUSE_SERVICE_ERROR_GENERIC, "Memory not ready yet");
				_inner_error_ = _tmp5_;
				if (_inner_error_->domain == NETSUKUKU_PEER_REFUSE_SERVICE_ERROR) {
					g_propagate_error (error, _inner_error_);
					_g_object_unref0 (w);
					return NULL;
				} else {
					_g_object_unref0 (w);
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
					g_clear_error (&_inner_error_);
					return NULL;
				}
			}
			tasklets_tasklet_nap ((glong) 0, (glong) 1000);
		}
		_g_object_unref0 (w);
	}
	netsukuku_andna_check_expirations_cache (self);
	_tmp6_ = hashed_domain;
	_tmp7_ = netsukuku_andna_service_hashnode_key_new (_tmp6_, 0);
	_tmp8_ = _tmp7_;
	_tmp9_ = netsukuku_peer_to_peer_h ((NetsukukuPeerToPeer*) self, (GObject*) _tmp8_);
	_tmp10_ = _tmp9_;
	_g_object_unref0 (_tmp8_);
	hashnode = _tmp10_;
	_tmp11_ = hashnode;
	_tmp12_ = netsukuku_peer_to_peer_search_participant ((NetsukukuPeerToPeer*) self, _tmp11_, 1, &_inner_error_);
	_tmp13_ = _tmp12_;
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == NETSUKUKU_PEER_REFUSE_SERVICE_ERROR) {
			g_propagate_error (error, _inner_error_);
			_g_object_unref0 (hashnode);
			return NULL;
		} else {
			_g_object_unref0 (hashnode);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	}
	_tmp14_ = _tmp13_;
	_tmp15_ = _tmp14_ != NULL;
	_g_object_unref0 (_tmp14_);
	if (_tmp15_) {
		GError* _tmp16_;
		_tmp16_ = g_error_new_literal (NETSUKUKU_PEER_REFUSE_SERVICE_ERROR, NETSUKUKU_PEER_REFUSE_SERVICE_ERROR_GENERIC, "Not the correct hashnode");
		_inner_error_ = _tmp16_;
		if (_inner_error_->domain == NETSUKUKU_PEER_REFUSE_SERVICE_ERROR) {
			g_propagate_error (error, _inner_error_);
			_g_object_unref0 (hashnode);
			return NULL;
		} else {
			_g_object_unref0 (hashnode);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	}
	_tmp17_ = self->priv->cache;
	_tmp18_ = hashed_domain;
	_tmp19_ = gee_abstract_map_has_key ((GeeAbstractMap*) _tmp17_, _tmp18_);
	if (!_tmp19_) {
		result = NULL;
		_g_object_unref0 (hashnode);
		return result;
	}
	_tmp20_ = self->priv->cache;
	_tmp21_ = hashed_domain;
	_tmp22_ = gee_abstract_map_get ((GeeAbstractMap*) _tmp20_, _tmp21_);
	result = (NetsukukuAndnaDomainRecord*) _tmp22_;
	_g_object_unref0 (hashnode);
	return result;
}


static Block2Data* block2_data_ref (Block2Data* _data2_) {
	g_atomic_int_inc (&_data2_->_ref_count_);
	return _data2_;
}


static void block2_data_unref (void * _userdata_) {
	Block2Data* _data2_;
	_data2_ = (Block2Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data2_->_ref_count_)) {
		NetsukukuAndna * self;
		self = _data2_->self;
		_g_object_unref0 (_data2_->rec);
		_g_free0 (_data2_->response_msg);
		_g_object_unref0 (self);
		g_slice_free (Block2Data, _data2_);
	}
}


static gboolean __lambda12_ (Block2Data* _data2_, GError** error) {
	NetsukukuAndna * self;
	gboolean result = FALSE;
	NetsukukuArgumentsForDuplicationRegisterSpread* _tmp0_;
	const gchar* _tmp1_;
	NetsukukuAndnaServiceHashnodeKey* _tmp2_;
	NetsukukuAndnaServiceHashnodeKey* _tmp3_;
	NetsukukuRmtAndnaPeer* _tmp4_ = NULL;
	NetsukukuRmtAndnaPeer* _tmp5_;
	NetsukukuRmtAndnaPeer* an_main;
	NetsukukuArgumentsForDuplicationRegisterSpread* _tmp6_;
	const gchar* _tmp7_;
	NetsukukuAndnaDomainRecord* _tmp8_ = NULL;
	NetsukukuAndnaDomainRecord* main_rec;
	GError * _inner_error_ = NULL;
	self = _data2_->self;
	_tmp0_ = _data2_->rec;
	_tmp1_ = _tmp0_->hashed_domain;
	_tmp2_ = netsukuku_andna_service_hashnode_key_new (_tmp1_, 0);
	_tmp3_ = _tmp2_;
	_tmp4_ = netsukuku_andna_peer (self, NULL, (GObject*) _tmp3_, NULL);
	_tmp5_ = _tmp4_;
	_g_object_unref0 (_tmp3_);
	an_main = _tmp5_;
	_tmp6_ = _data2_->rec;
	_tmp7_ = _tmp6_->hashed_domain;
	_tmp8_ = netsukuku_iandna_as_peer_get_domain_record ((NetsukukuIAndnaAsPeer*) an_main, _tmp7_, &_inner_error_);
	main_rec = _tmp8_;
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == NETSUKUKU_PEER_REFUSE_SERVICE_ERROR) {
			g_propagate_error (error, _inner_error_);
			_g_object_unref0 (an_main);
			return FALSE;
		} else {
			_g_object_unref0 (an_main);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return FALSE;
		}
	}
	if (main_rec != NULL) {
		GeeHashMap* _tmp9_;
		NetsukukuArgumentsForDuplicationRegisterSpread* _tmp10_;
		const gchar* _tmp11_;
		_tmp9_ = self->priv->cache;
		_tmp10_ = _data2_->rec;
		_tmp11_ = _tmp10_->hashed_domain;
		gee_abstract_map_set ((GeeAbstractMap*) _tmp9_, _tmp11_, main_rec);
	} else {
		gchar* _tmp12_;
		_data2_->response_response = FALSE;
		_tmp12_ = g_strdup ("MAIN_NOT_FOUND");
		_g_free0 (_data2_->response_msg);
		_data2_->response_msg = _tmp12_;
		result = FALSE;
		_g_object_unref0 (main_rec);
		_g_object_unref0 (an_main);
		return result;
	}
	result = TRUE;
	_g_object_unref0 (main_rec);
	_g_object_unref0 (an_main);
	return result;
}


static gboolean ___lambda12__netsukuku_accept_record_callback (gpointer self, GError** error) {
	gboolean result;
	result = __lambda12_ (self, error);
	return result;
}


static void _____lambda14_ (NetsukukuAndna* self, GObject* tpar1, GObject* tpar2, GError** error) {
	GObject* _tmp0_;
	NetsukukuNIP* _tmp1_;
	NetsukukuNIP* tonip;
	GObject* _tmp2_;
	NetsukukuArgumentsForDuplicationRegisterSpread* _tmp3_;
	NetsukukuArgumentsForDuplicationRegisterSpread* arec;
	GError * _inner_error_ = NULL;
	_tmp0_ = tpar1;
	_tmp1_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, NETSUKUKU_TYPE_NIP, NetsukukuNIP));
	tonip = _tmp1_;
	_tmp2_ = tpar2;
	_tmp3_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp2_, NETSUKUKU_TYPE_ARGUMENTS_FOR_DUPLICATION_REGISTER_SPREAD, NetsukukuArgumentsForDuplicationRegisterSpread));
	arec = _tmp3_;
	tasklets_tasklet_declare_self ("Andna.forward_record_spread");
	{
		NetsukukuRmtAndnaPeer* _tmp4_ = NULL;
		NetsukukuRmtAndnaPeer* _tmp5_;
		const gchar* _tmp6_;
		gint _tmp7_;
		NetsukukuAndnaRegisterSpreadResponse* _tmp8_ = NULL;
		NetsukukuAndnaRegisterSpreadResponse* _tmp9_;
		_tmp4_ = netsukuku_andna_peer (self, tonip, NULL, NULL);
		_tmp5_ = _tmp4_;
		_tmp6_ = arec->hashed_domain;
		_tmp7_ = arec->spread_number;
		_tmp8_ = netsukuku_iandna_as_peer_register_spread_record ((NetsukukuIAndnaAsPeer*) _tmp5_, _tmp6_, _tmp7_, FALSE, &_inner_error_);
		_tmp9_ = _tmp8_;
		_g_object_unref0 (_tmp9_);
		_g_object_unref0 (_tmp5_);
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == ZCD_RPC_ERROR) {
				goto __catch12_zcd_rpc_error;
			}
			goto __finally12;
		}
	}
	goto __finally12;
	__catch12_zcd_rpc_error:
	{
		GError* e = NULL;
		gchar* _tmp10_ = NULL;
		gchar* _tmp11_;
		gchar* _tmp12_ = NULL;
		gchar* _tmp13_;
		GError* _tmp14_;
		GQuark _tmp15_;
		const gchar* _tmp16_ = NULL;
		const gchar* _tmp17_ = NULL;
		GError* _tmp18_;
		gint _tmp19_;
		gchar* _tmp20_ = NULL;
		gchar* _tmp21_;
		GError* _tmp22_;
		const gchar* _tmp23_;
		const gchar* _tmp24_ = NULL;
		gchar* _tmp25_ = NULL;
		gchar* _tmp26_;
		gchar* _tmp27_;
		gchar* _tmp28_;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp10_ = netsukuku_partial_nip_to_string ((NetsukukuPartialNIP*) tonip);
		_tmp11_ = _tmp10_;
		_tmp12_ = g_strconcat ("Andna.forward_record_spread: forwarding to ", _tmp11_, ":", NULL);
		_tmp13_ = _tmp12_;
		_tmp14_ = e;
		_tmp15_ = _tmp14_->domain;
		_tmp16_ = g_quark_to_string (_tmp15_);
		_tmp17_ = string_to_string (_tmp16_);
		_tmp18_ = e;
		_tmp19_ = _tmp18_->code;
		_tmp20_ = g_strdup_printf ("%i", _tmp19_);
		_tmp21_ = _tmp20_;
		_tmp22_ = e;
		_tmp23_ = _tmp22_->message;
		_tmp24_ = string_to_string (_tmp23_);
		_tmp25_ = g_strconcat (" got ", _tmp17_, " ", _tmp21_, " ", _tmp24_, NULL);
		_tmp26_ = _tmp25_;
		_tmp27_ = g_strconcat (_tmp13_, _tmp26_, NULL);
		_tmp28_ = _tmp27_;
		netsukuku_log_warn (_tmp28_);
		_g_free0 (_tmp28_);
		_g_free0 (_tmp26_);
		_g_free0 (_tmp21_);
		_g_free0 (_tmp13_);
		_g_free0 (_tmp11_);
		_g_error_free0 (e);
	}
	__finally12:
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		_g_object_unref0 (arec);
		_g_object_unref0 (tonip);
		return;
	}
	_g_object_unref0 (arec);
	_g_object_unref0 (tonip);
}


static void ______lambda14__tasklets_tasklet_callback (GObject* obj1, GObject* obj2, GObject* obj3, GObject* obj4, gpointer self, GError** error) {
	_____lambda14_ (self, obj1, obj2, error);
}


static void __lambda13_ (NetsukukuAndna* self, GObject* tasklet_obj1, GeeList* tasklet_replica_nodes, GError** error) {
	GObject* _tmp0_;
	NetsukukuArgumentsForDuplicationRegisterSpread* _tmp1_;
	NetsukukuArgumentsForDuplicationRegisterSpread* tasklet_rec;
	GeeList* _tmp2_;
	_tmp0_ = tasklet_obj1;
	_tmp1_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, NETSUKUKU_TYPE_ARGUMENTS_FOR_DUPLICATION_REGISTER_SPREAD, NetsukukuArgumentsForDuplicationRegisterSpread));
	tasklet_rec = _tmp1_;
	_tmp2_ = tasklet_replica_nodes;
	if (_tmp2_ == NULL) {
		NetsukukuArgumentsForDuplicationRegisterSpread* _tmp3_;
		NetsukukuNIP* _tmp4_;
		GeeList* _tmp5_ = NULL;
		_tmp3_ = tasklet_rec;
		_tmp4_ = _tmp3_->hashnode;
		_tmp5_ = netsukuku_peer_to_peer_find_nearest_to_register ((NetsukukuPeerToPeer*) self, _tmp4_, NETSUKUKU_ANDNA_DUPLICATION);
		_g_object_unref0 (tasklet_replica_nodes);
		tasklet_replica_nodes = _tmp5_;
	}
	{
		GeeList* _tmp6_;
		GeeList* _tmp7_;
		GeeList* _replica_node_list;
		GeeList* _tmp8_;
		gint _tmp9_;
		gint _tmp10_;
		gint _replica_node_size;
		gint _replica_node_index;
		_tmp6_ = tasklet_replica_nodes;
		_tmp7_ = _g_object_ref0 (_tmp6_);
		_replica_node_list = _tmp7_;
		_tmp8_ = _replica_node_list;
		_tmp9_ = gee_collection_get_size ((GeeCollection*) _tmp8_);
		_tmp10_ = _tmp9_;
		_replica_node_size = _tmp10_;
		_replica_node_index = -1;
		while (TRUE) {
			gint _tmp11_;
			gint _tmp12_;
			gint _tmp13_;
			GeeList* _tmp14_;
			gint _tmp15_;
			gpointer _tmp16_ = NULL;
			NetsukukuNIP* replica_node;
			NetsukukuNIP* _tmp17_;
			NetsukukuMapRoute* _tmp18_;
			NetsukukuNIP* _tmp19_;
			gboolean _tmp20_ = FALSE;
			_tmp11_ = _replica_node_index;
			_replica_node_index = _tmp11_ + 1;
			_tmp12_ = _replica_node_index;
			_tmp13_ = _replica_node_size;
			if (!(_tmp12_ < _tmp13_)) {
				break;
			}
			_tmp14_ = _replica_node_list;
			_tmp15_ = _replica_node_index;
			_tmp16_ = gee_list_get (_tmp14_, _tmp15_);
			replica_node = (NetsukukuNIP*) _tmp16_;
			_tmp17_ = replica_node;
			_tmp18_ = ((NetsukukuPeerToPeer*) self)->maproute;
			_tmp19_ = _tmp18_->me;
			_tmp20_ = netsukuku_partial_nip_is_equal ((NetsukukuPartialNIP*) _tmp17_, (NetsukukuPartialNIP*) _tmp19_);
			if (!_tmp20_) {
				NetsukukuNIP* _tmp21_;
				NetsukukuArgumentsForDuplicationRegisterSpread* _tmp22_;
				TaskletsTasklet* _tmp23_ = NULL;
				TaskletsTasklet* _tmp24_;
				_tmp21_ = replica_node;
				_tmp22_ = tasklet_rec;
				_tmp23_ = tasklets_tasklet_tasklet_callback (______lambda14__tasklets_tasklet_callback, self, (GObject*) _tmp21_, (GObject*) _tmp22_, NULL, NULL);
				_tmp24_ = _tmp23_;
				_g_object_unref0 (_tmp24_);
			}
			_g_object_unref0 (replica_node);
		}
		_g_object_unref0 (_replica_node_list);
	}
	_g_object_unref0 (tasklet_rec);
	_g_object_unref0 (tasklet_replica_nodes);
}


static void ___lambda13__netsukuku_forward_record_callback (GObject* obj1, GeeList* replica_nodes, gpointer self, GError** error) {
	__lambda13_ (self, obj1, replica_nodes, error);
}


static NetsukukuAndnaRegisterSpreadResponse* netsukuku_andna_real_register_spread_record (NetsukukuIAndnaAsPeer* base, const gchar* hashed_domain, gint spread_number, gboolean replicate, GError** error) {
	NetsukukuAndna * self;
	NetsukukuAndnaRegisterSpreadResponse* result = NULL;
	Block2Data* _data2_;
	gboolean _tmp0_;
	gchar* _tmp6_;
	const gchar* _tmp7_;
	gint _tmp8_;
	NetsukukuAndnaServiceHashnodeKey* _tmp9_;
	NetsukukuAndnaServiceHashnodeKey* _tmp10_;
	NetsukukuNIP* _tmp11_ = NULL;
	NetsukukuNIP* _tmp12_;
	NetsukukuNIP* hashnode;
	NetsukukuArgumentsForDuplicationRegisterSpread* _tmp13_;
	NetsukukuArgumentsForDuplicationRegisterSpread* _tmp14_;
	const gchar* _tmp15_;
	gchar* _tmp16_;
	NetsukukuArgumentsForDuplicationRegisterSpread* _tmp17_;
	gint _tmp18_;
	NetsukukuArgumentsForDuplicationRegisterSpread* _tmp19_;
	NetsukukuNIP* _tmp20_;
	NetsukukuNIP* _tmp21_;
	NetsukukuNIP* _tmp22_;
	gboolean _tmp23_;
	NetsukukuArgumentsForDuplicationRegisterSpread* _tmp24_;
	gboolean _tmp25_;
	const gchar* _tmp26_;
	NetsukukuAndnaRegisterSpreadResponse* _tmp27_;
	GError * _inner_error_ = NULL;
	self = (NetsukukuAndna*) base;
	g_return_val_if_fail (hashed_domain != NULL, NULL);
	_data2_ = g_slice_new0 (Block2Data);
	_data2_->_ref_count_ = 1;
	_data2_->self = g_object_ref (self);
	_tmp0_ = self->memory_initialized;
	if (!_tmp0_) {
		TaskletsTimer* _tmp1_;
		TaskletsTimer* w;
		_tmp1_ = tasklets_timer_new ((gint64) 10000);
		w = _tmp1_;
		while (TRUE) {
			gboolean _tmp2_;
			TaskletsTimer* _tmp3_;
			gboolean _tmp4_ = FALSE;
			_tmp2_ = self->memory_initialized;
			if (!(!_tmp2_)) {
				break;
			}
			_tmp3_ = w;
			_tmp4_ = tasklets_timer_is_expired (_tmp3_);
			if (_tmp4_) {
				GError* _tmp5_;
				_tmp5_ = g_error_new_literal (NETSUKUKU_PEER_REFUSE_SERVICE_ERROR, NETSUKUKU_PEER_REFUSE_SERVICE_ERROR_GENERIC, "Memory not ready yet");
				_inner_error_ = _tmp5_;
				if (_inner_error_->domain == NETSUKUKU_PEER_REFUSE_SERVICE_ERROR) {
					g_propagate_error (error, _inner_error_);
					_g_object_unref0 (w);
					block2_data_unref (_data2_);
					_data2_ = NULL;
					return NULL;
				} else {
					_g_object_unref0 (w);
					block2_data_unref (_data2_);
					_data2_ = NULL;
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
					g_clear_error (&_inner_error_);
					return NULL;
				}
			}
			tasklets_tasklet_nap ((glong) 0, (glong) 1000);
		}
		_g_object_unref0 (w);
	}
	_data2_->response_response = TRUE;
	_tmp6_ = g_strdup ("OK");
	_data2_->response_msg = _tmp6_;
	netsukuku_andna_check_expirations_cache (self);
	_tmp7_ = hashed_domain;
	_tmp8_ = spread_number;
	_tmp9_ = netsukuku_andna_service_hashnode_key_new (_tmp7_, _tmp8_);
	_tmp10_ = _tmp9_;
	_tmp11_ = netsukuku_peer_to_peer_h ((NetsukukuPeerToPeer*) self, (GObject*) _tmp10_);
	_tmp12_ = _tmp11_;
	_g_object_unref0 (_tmp10_);
	hashnode = _tmp12_;
	_tmp13_ = netsukuku_arguments_for_duplication_register_spread_new ();
	_data2_->rec = _tmp13_;
	_tmp14_ = _data2_->rec;
	_tmp15_ = hashed_domain;
	_tmp16_ = g_strdup (_tmp15_);
	_g_free0 (_tmp14_->hashed_domain);
	_tmp14_->hashed_domain = _tmp16_;
	_tmp17_ = _data2_->rec;
	_tmp18_ = spread_number;
	_tmp17_->spread_number = _tmp18_;
	_tmp19_ = _data2_->rec;
	_tmp20_ = hashnode;
	_tmp21_ = _g_object_ref0 (_tmp20_);
	_g_object_unref0 (_tmp19_->hashnode);
	_tmp19_->hashnode = _tmp21_;
	_tmp22_ = hashnode;
	_tmp23_ = replicate;
	_tmp24_ = _data2_->rec;
	netsukuku_check_hash_and_start_replica ((NetsukukuPeerToPeer*) self, _tmp22_, _tmp23_, (GObject*) _tmp24_, NETSUKUKU_ANDNA_DUPLICATION, ___lambda12__netsukuku_accept_record_callback, _data2_, ___lambda13__netsukuku_forward_record_callback, self, NULL, NULL, &_inner_error_);
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == NETSUKUKU_PEER_REFUSE_SERVICE_ERROR) {
			g_propagate_error (error, _inner_error_);
			_g_object_unref0 (hashnode);
			block2_data_unref (_data2_);
			_data2_ = NULL;
			return NULL;
		} else {
			_g_object_unref0 (hashnode);
			block2_data_unref (_data2_);
			_data2_ = NULL;
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	}
	_tmp25_ = _data2_->response_response;
	_tmp26_ = _data2_->response_msg;
	_tmp27_ = netsukuku_andna_register_spread_response_new (_tmp25_, _tmp26_);
	result = _tmp27_;
	_g_object_unref0 (hashnode);
	block2_data_unref (_data2_);
	_data2_ = NULL;
	return result;
}


static NetsukukuAndnaGetServersResponse* netsukuku_andna_real_get_servers (NetsukukuIAndnaAsPeer* base, const gchar* hashed_domain, NetsukukuAndnaServiceKey* srv_key, gint spread_number, gboolean chain, GError** error) {
	NetsukukuAndna * self;
	NetsukukuAndnaGetServersResponse* result = NULL;
	gboolean _tmp0_;
	const gchar* _tmp6_;
	gint _tmp7_;
	NetsukukuAndnaServiceHashnodeKey* _tmp8_;
	NetsukukuAndnaServiceHashnodeKey* _tmp9_;
	NetsukukuNIP* _tmp10_ = NULL;
	NetsukukuNIP* _tmp11_;
	NetsukukuNIP* hashnode;
	NetsukukuNIP* _tmp12_;
	NetsukukuHCoord* _tmp13_ = NULL;
	NetsukukuHCoord* _tmp14_;
	NetsukukuHCoord* _tmp15_;
	gboolean _tmp16_;
	NetsukukuTimeCapsule* expires = NULL;
	NetsukukuAndnaServers* response = NULL;
	GeeHashMap* _tmp18_;
	const gchar* _tmp19_;
	gboolean _tmp20_ = FALSE;
	NetsukukuAndnaServers* _tmp94_;
	NetsukukuTimeCapsule* _tmp95_;
	NetsukukuAndnaGetServersResponse* _tmp96_;
	GError * _inner_error_ = NULL;
	self = (NetsukukuAndna*) base;
	g_return_val_if_fail (hashed_domain != NULL, NULL);
	g_return_val_if_fail (srv_key != NULL, NULL);
	_tmp0_ = self->memory_initialized;
	if (!_tmp0_) {
		TaskletsTimer* _tmp1_;
		TaskletsTimer* w;
		_tmp1_ = tasklets_timer_new ((gint64) 10000);
		w = _tmp1_;
		while (TRUE) {
			gboolean _tmp2_;
			TaskletsTimer* _tmp3_;
			gboolean _tmp4_ = FALSE;
			_tmp2_ = self->memory_initialized;
			if (!(!_tmp2_)) {
				break;
			}
			_tmp3_ = w;
			_tmp4_ = tasklets_timer_is_expired (_tmp3_);
			if (_tmp4_) {
				GError* _tmp5_;
				_tmp5_ = g_error_new_literal (NETSUKUKU_PEER_REFUSE_SERVICE_ERROR, NETSUKUKU_PEER_REFUSE_SERVICE_ERROR_GENERIC, "Memory not ready yet");
				_inner_error_ = _tmp5_;
				if (_inner_error_->domain == NETSUKUKU_PEER_REFUSE_SERVICE_ERROR) {
					g_propagate_error (error, _inner_error_);
					_g_object_unref0 (w);
					return NULL;
				} else {
					_g_object_unref0 (w);
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
					g_clear_error (&_inner_error_);
					return NULL;
				}
			}
			tasklets_tasklet_nap ((glong) 0, (glong) 1000);
		}
		_g_object_unref0 (w);
	}
	netsukuku_andna_check_expirations_cache (self);
	_tmp6_ = hashed_domain;
	_tmp7_ = spread_number;
	_tmp8_ = netsukuku_andna_service_hashnode_key_new (_tmp6_, _tmp7_);
	_tmp9_ = _tmp8_;
	_tmp10_ = netsukuku_peer_to_peer_h ((NetsukukuPeerToPeer*) self, (GObject*) _tmp9_);
	_tmp11_ = _tmp10_;
	_g_object_unref0 (_tmp9_);
	hashnode = _tmp11_;
	_tmp12_ = hashnode;
	_tmp13_ = netsukuku_peer_to_peer_search_participant ((NetsukukuPeerToPeer*) self, _tmp12_, 1, &_inner_error_);
	_tmp14_ = _tmp13_;
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == NETSUKUKU_PEER_REFUSE_SERVICE_ERROR) {
			g_propagate_error (error, _inner_error_);
			_g_object_unref0 (hashnode);
			return NULL;
		} else {
			_g_object_unref0 (hashnode);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	}
	_tmp15_ = _tmp14_;
	_tmp16_ = _tmp15_ != NULL;
	_g_object_unref0 (_tmp15_);
	if (_tmp16_) {
		GError* _tmp17_;
		_tmp17_ = g_error_new_literal (NETSUKUKU_PEER_REFUSE_SERVICE_ERROR, NETSUKUKU_PEER_REFUSE_SERVICE_ERROR_GENERIC, "Not the correct hashnode");
		_inner_error_ = _tmp17_;
		if (_inner_error_->domain == NETSUKUKU_PEER_REFUSE_SERVICE_ERROR) {
			g_propagate_error (error, _inner_error_);
			_g_object_unref0 (hashnode);
			return NULL;
		} else {
			_g_object_unref0 (hashnode);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	}
	_tmp18_ = self->priv->cache;
	_tmp19_ = hashed_domain;
	_tmp20_ = gee_abstract_map_has_key ((GeeAbstractMap*) _tmp18_, _tmp19_);
	if (_tmp20_) {
		GeeHashMap* _tmp21_;
		const gchar* _tmp22_;
		gpointer _tmp23_ = NULL;
		NetsukukuAndnaDomainRecord* _tmp24_;
		NetsukukuAndnaServiceKey* _tmp25_;
		NetsukukuAndnaServers* _tmp26_ = NULL;
		NetsukukuAndnaServers* _tmp27_;
		NetsukukuTimeCapsule* _tmp28_;
		NetsukukuTimeCapsule* _tmp29_;
		NetsukukuTimeCapsule* _tmp30_;
		GeeArrayList* _tmp31_;
		GeeArrayList* todel;
		_tmp21_ = self->priv->cache;
		_tmp22_ = hashed_domain;
		_tmp23_ = gee_abstract_map_get ((GeeAbstractMap*) _tmp21_, _tmp22_);
		_tmp24_ = (NetsukukuAndnaDomainRecord*) _tmp23_;
		_tmp25_ = srv_key;
		_tmp26_ = netsukuku_andna_domain_record_get_servers (_tmp24_, _tmp25_);
		_g_object_unref0 (response);
		response = _tmp26_;
		_g_object_unref0 (_tmp24_);
		_tmp27_ = response;
		_tmp28_ = netsukuku_andna_servers_get_expires (_tmp27_);
		_tmp29_ = _tmp28_;
		_tmp30_ = _g_object_ref0 (_tmp29_);
		_g_object_unref0 (expires);
		expires = _tmp30_;
		_tmp31_ = gee_array_list_new (NETSUKUKU_TYPE_ANDNA_SERVER, (GBoxedCopyFunc) g_object_ref, g_object_unref, NULL, NULL, NULL);
		todel = _tmp31_;
		{
			NetsukukuAndnaServers* _tmp32_;
			GeeList* _tmp33_;
			GeeList* _tmp34_;
			GeeList* _tmp35_;
			GeeList* _result_list;
			GeeList* _tmp36_;
			gint _tmp37_;
			gint _tmp38_;
			gint _result_size;
			gint _result_index;
			_tmp32_ = response;
			_tmp33_ = netsukuku_andna_servers_get_servers (_tmp32_);
			_tmp34_ = _tmp33_;
			_tmp35_ = _g_object_ref0 (_tmp34_);
			_result_list = _tmp35_;
			_tmp36_ = _result_list;
			_tmp37_ = gee_collection_get_size ((GeeCollection*) _tmp36_);
			_tmp38_ = _tmp37_;
			_result_size = _tmp38_;
			_result_index = -1;
			while (TRUE) {
				gint _tmp39_;
				gint _tmp40_;
				gint _tmp41_;
				GeeList* _tmp42_;
				gint _tmp43_;
				gpointer _tmp44_ = NULL;
				NetsukukuAndnaServer* _result_;
				NetsukukuAndnaServer* _tmp45_;
				const gchar* _tmp46_;
				const gchar* _tmp47_;
				_tmp39_ = _result_index;
				_result_index = _tmp39_ + 1;
				_tmp40_ = _result_index;
				_tmp41_ = _result_size;
				if (!(_tmp40_ < _tmp41_)) {
					break;
				}
				_tmp42_ = _result_list;
				_tmp43_ = _result_index;
				_tmp44_ = gee_list_get (_tmp42_, _tmp43_);
				_result_ = (NetsukukuAndnaServer*) _tmp44_;
				_tmp45_ = _result_;
				_tmp46_ = netsukuku_andna_server_get_alias_name (_tmp45_);
				_tmp47_ = _tmp46_;
				if (_tmp47_ != NULL) {
					gboolean _tmp48_;
					_tmp48_ = chain;
					if (!_tmp48_) {
						GeeArrayList* _tmp49_;
						NetsukukuAndnaServer* _tmp50_;
						_tmp49_ = todel;
						_tmp50_ = _result_;
						gee_abstract_collection_add ((GeeAbstractCollection*) _tmp49_, _tmp50_);
					} else {
						NetsukukuAndnaServiceKey* _tmp51_;
						NetsukukuAndnaServiceKey* _tmp52_;
						NetsukukuAndnaServiceKey* _tmp53_;
						gboolean _tmp54_ = FALSE;
						_tmp51_ = srv_key;
						_tmp52_ = netsukuku_andna_service_key_get_NULL_SERV_KEY ();
						_tmp53_ = _tmp52_;
						_tmp54_ = netsukuku_andna_service_key_equal_func (_tmp51_, _tmp53_);
						if (_tmp54_) {
							const gchar* _tmp55_;
							NetsukukuAndnaServiceKey* _tmp56_;
							NetsukukuAndnaServiceKey* _tmp57_;
							NetsukukuAndnaGetServersResponse* _tmp58_ = NULL;
							NetsukukuAndnaGetServersResponse* resolved_alias;
							NetsukukuAndnaGetServersResponse* _tmp59_;
							NetsukukuAndnaServers* _tmp60_;
							NetsukukuAndnaServers* _tmp61_;
							NetsukukuAndnaServers* _tmp62_;
							NetsukukuAndnaServers* alias_servers;
							NetsukukuAndnaServers* _tmp63_;
							gboolean _tmp64_;
							gboolean _tmp65_;
							_tmp55_ = hashed_domain;
							_tmp56_ = netsukuku_andna_service_key_get_NULL_SERV_KEY ();
							_tmp57_ = _tmp56_;
							_tmp58_ = netsukuku_andna_ask_get_servers (self, _tmp55_, _tmp57_, FALSE);
							resolved_alias = _tmp58_;
							_tmp59_ = resolved_alias;
							_tmp60_ = netsukuku_andna_get_servers_response_get_response (_tmp59_);
							_tmp61_ = _tmp60_;
							_tmp62_ = _g_object_ref0 (_tmp61_);
							alias_servers = _tmp62_;
							_tmp63_ = alias_servers;
							_tmp64_ = netsukuku_andna_servers_get_is_not_found (_tmp63_);
							_tmp65_ = _tmp64_;
							if (_tmp65_) {
								GeeArrayList* _tmp66_;
								NetsukukuAndnaServer* _tmp67_;
								_tmp66_ = todel;
								_tmp67_ = _result_;
								gee_abstract_collection_add ((GeeAbstractCollection*) _tmp66_, _tmp67_);
							} else {
								NetsukukuAndnaServer* _tmp68_;
								NetsukukuAndnaServers* _tmp69_;
								GeeList* _tmp70_;
								GeeList* _tmp71_;
								gpointer _tmp72_ = NULL;
								NetsukukuAndnaServer* _tmp73_;
								NetsukukuNIP* _tmp74_;
								NetsukukuNIP* _tmp75_;
								_tmp68_ = _result_;
								_tmp69_ = alias_servers;
								_tmp70_ = netsukuku_andna_servers_get_servers (_tmp69_);
								_tmp71_ = _tmp70_;
								_tmp72_ = gee_list_get (_tmp71_, 0);
								_tmp73_ = (NetsukukuAndnaServer*) _tmp72_;
								_tmp74_ = netsukuku_andna_server_get_registrar_nip (_tmp73_);
								_tmp75_ = _tmp74_;
								netsukuku_andna_server_set_nip (_tmp68_, _tmp75_);
								_g_object_unref0 (_tmp73_);
							}
							_g_object_unref0 (alias_servers);
							_g_object_unref0 (resolved_alias);
						} else {
						}
					}
				}
				_g_object_unref0 (_result_);
			}
			_g_object_unref0 (_result_list);
		}
		{
			GeeArrayList* _tmp76_;
			GeeArrayList* _tmp77_;
			GeeArrayList* _result_list;
			GeeArrayList* _tmp78_;
			gint _tmp79_;
			gint _tmp80_;
			gint _result_size;
			gint _result_index;
			_tmp76_ = todel;
			_tmp77_ = _g_object_ref0 (_tmp76_);
			_result_list = _tmp77_;
			_tmp78_ = _result_list;
			_tmp79_ = gee_abstract_collection_get_size ((GeeCollection*) _tmp78_);
			_tmp80_ = _tmp79_;
			_result_size = _tmp80_;
			_result_index = -1;
			while (TRUE) {
				gint _tmp81_;
				gint _tmp82_;
				gint _tmp83_;
				GeeArrayList* _tmp84_;
				gint _tmp85_;
				gpointer _tmp86_ = NULL;
				NetsukukuAndnaServer* _result_;
				NetsukukuAndnaServers* _tmp87_;
				GeeList* _tmp88_;
				GeeList* _tmp89_;
				NetsukukuAndnaServer* _tmp90_;
				_tmp81_ = _result_index;
				_result_index = _tmp81_ + 1;
				_tmp82_ = _result_index;
				_tmp83_ = _result_size;
				if (!(_tmp82_ < _tmp83_)) {
					break;
				}
				_tmp84_ = _result_list;
				_tmp85_ = _result_index;
				_tmp86_ = gee_abstract_list_get ((GeeAbstractList*) _tmp84_, _tmp85_);
				_result_ = (NetsukukuAndnaServer*) _tmp86_;
				_tmp87_ = response;
				_tmp88_ = netsukuku_andna_servers_get_servers (_tmp87_);
				_tmp89_ = _tmp88_;
				_tmp90_ = _result_;
				gee_collection_remove ((GeeCollection*) _tmp89_, _tmp90_);
				_g_object_unref0 (_result_);
			}
			_g_object_unref0 (_result_list);
		}
		_g_object_unref0 (todel);
	} else {
		NetsukukuTimeCapsule* _tmp91_;
		NetsukukuTimeCapsule* _tmp92_;
		NetsukukuAndnaServers* _tmp93_;
		_tmp91_ = netsukuku_time_capsule_new (NETSUKUKU_MAX_TTL_OF_NEGATIVE);
		_g_object_unref0 (expires);
		expires = _tmp91_;
		_tmp92_ = expires;
		_tmp93_ = netsukuku_andna_servers_new_not_found (_tmp92_);
		_g_object_unref0 (response);
		response = _tmp93_;
	}
	_tmp94_ = response;
	_tmp95_ = expires;
	_tmp96_ = netsukuku_andna_get_servers_response_new (_tmp94_, _tmp95_);
	result = _tmp96_;
	_g_object_unref0 (response);
	_g_object_unref0 (expires);
	_g_object_unref0 (hashnode);
	return result;
}


static NetsukukuAndnaGetCacheRecordsResponse* netsukuku_andna_real_get_cache_records (NetsukukuIAndnaAsPeer* base, GError** error) {
	NetsukukuAndna * self;
	NetsukukuAndnaGetCacheRecordsResponse* result = NULL;
	gboolean _tmp0_;
	GeeHashMap* _tmp6_;
	GeeHashMap* _tmp7_;
	NetsukukuAndnaGetCacheRecordsResponse* _tmp8_;
	GError * _inner_error_ = NULL;
	self = (NetsukukuAndna*) base;
	_tmp0_ = self->memory_initialized;
	if (!_tmp0_) {
		TaskletsTimer* _tmp1_;
		TaskletsTimer* w;
		_tmp1_ = tasklets_timer_new ((gint64) 10000);
		w = _tmp1_;
		while (TRUE) {
			gboolean _tmp2_;
			TaskletsTimer* _tmp3_;
			gboolean _tmp4_ = FALSE;
			_tmp2_ = self->memory_initialized;
			if (!(!_tmp2_)) {
				break;
			}
			_tmp3_ = w;
			_tmp4_ = tasklets_timer_is_expired (_tmp3_);
			if (_tmp4_) {
				GError* _tmp5_;
				_tmp5_ = g_error_new_literal (NETSUKUKU_PEER_REFUSE_SERVICE_ERROR, NETSUKUKU_PEER_REFUSE_SERVICE_ERROR_GENERIC, "Memory not ready yet");
				_inner_error_ = _tmp5_;
				if (_inner_error_->domain == NETSUKUKU_PEER_REFUSE_SERVICE_ERROR) {
					g_propagate_error (error, _inner_error_);
					_g_object_unref0 (w);
					return NULL;
				} else {
					_g_object_unref0 (w);
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
					g_clear_error (&_inner_error_);
					return NULL;
				}
			}
			tasklets_tasklet_nap ((glong) 0, (glong) 1000);
		}
		_g_object_unref0 (w);
	}
	_tmp6_ = self->priv->cache;
	_tmp7_ = self->priv->request_queue;
	_tmp8_ = netsukuku_andna_get_cache_records_response_new (_tmp6_, _tmp7_);
	result = _tmp8_;
	return result;
}


/** Remotable methods as AddressManager...client
          */
static guint8* string_get_data (const gchar* self, int* result_length1) {
	guint8* result;
	guint8* res;
	gint res_length1;
	gint _res_size_;
	gint _tmp0_;
	gint _tmp1_;
	gint _tmp2_;
	guint8* _tmp3_;
	gint _tmp3__length1;
	guint8* _tmp4_;
	gint _tmp4__length1;
	g_return_val_if_fail (self != NULL, NULL);
	res = (guint8*) self;
	res_length1 = -1;
	_res_size_ = res_length1;
	_tmp0_ = strlen (self);
	_tmp1_ = _tmp0_;
	res_length1 = (gint) _tmp1_;
	_tmp2_ = res_length1;
	_tmp3_ = res;
	_tmp3__length1 = res_length1;
	_tmp4_ = _tmp3_;
	_tmp4__length1 = _tmp3__length1;
	if (result_length1) {
		*result_length1 = _tmp4__length1;
	}
	result = _tmp4_;
	return result;
}


static NetsukukuAndnaConfirmPubkResponse* netsukuku_andna_real_confirm_pubk (NetsukukuIAndna* base, NetsukukuNIP* yournip, NetsukukuPublicKey* yourpubkey, gint to_be_signed, GError** error) {
	NetsukukuAndna * self;
	NetsukukuAndnaConfirmPubkResponse* result = NULL;
	gboolean _tmp0_ = FALSE;
	NetsukukuMapRoute* _tmp1_;
	NetsukukuNIP* _tmp2_;
	NetsukukuNIP* _tmp3_;
	gboolean _tmp4_ = FALSE;
	gboolean _tmp9_;
	guint8* _tmp24_ = NULL;
	guint8* _tmp25_;
	gint _tmp25__length1;
	zcdSerializableBuffer* _tmp26_;
	zcdSerializableBuffer* _tmp27_;
	NetsukukuAndnaConfirmPubkResponse* _tmp28_;
	NetsukukuAndnaConfirmPubkResponse* _tmp29_;
	GError * _inner_error_ = NULL;
	self = (NetsukukuAndna*) base;
	g_return_val_if_fail (yournip != NULL, NULL);
	g_return_val_if_fail (yourpubkey != NULL, NULL);
	_tmp1_ = ((NetsukukuPeerToPeer*) self)->maproute;
	_tmp2_ = _tmp1_->me;
	_tmp3_ = yournip;
	_tmp4_ = netsukuku_partial_nip_is_equal ((NetsukukuPartialNIP*) _tmp2_, (NetsukukuPartialNIP*) _tmp3_);
	if (_tmp4_) {
		NetsukukuPublicKey* _tmp5_;
		NetsukukuPublicKey* _tmp6_;
		NetsukukuPublicKey* _tmp7_;
		gboolean _tmp8_ = FALSE;
		_tmp5_ = netsukuku_andna_get_mypubk (self);
		_tmp6_ = _tmp5_;
		_tmp7_ = yourpubkey;
		_tmp8_ = netsukuku_public_key_equal_func (_tmp6_, _tmp7_);
		_tmp0_ = _tmp8_;
	} else {
		_tmp0_ = FALSE;
	}
	_tmp9_ = _tmp0_;
	if (_tmp9_) {
		NetsukukuKeyPair* _tmp10_;
		gint _tmp11_;
		gchar* _tmp12_ = NULL;
		gchar* _tmp13_;
		guint8* _tmp14_;
		gint _tmp14__length1;
		guint8* _tmp15_;
		gint _tmp15__length1;
		gint _tmp16_ = 0;
		guchar* _tmp17_ = NULL;
		guchar* _tmp18_;
		gint _tmp18__length1;
		guchar* _tmp19_;
		gint _tmp19__length1;
		gint __tmp19__size_;
		guint8* buf;
		gint buf_length1;
		gint _buf_size_;
		guint8* _tmp20_;
		gint _tmp20__length1;
		zcdSerializableBuffer* _tmp21_;
		zcdSerializableBuffer* signature;
		zcdSerializableBuffer* _tmp22_;
		NetsukukuAndnaConfirmPubkResponse* _tmp23_;
		_tmp10_ = self->priv->my_keys;
		_tmp11_ = to_be_signed;
		_tmp12_ = g_strdup_printf ("%i", _tmp11_);
		_tmp13_ = _tmp12_;
		_tmp14_ = string_get_data (_tmp13_, &_tmp14__length1);
		_tmp15_ = _tmp14_;
		_tmp15__length1 = _tmp14__length1;
		_tmp17_ = netsukuku_key_pair_sign (_tmp10_, (guchar*) _tmp15_, (_tmp15__length1 * sizeof (guint8)) / sizeof (guchar), &_tmp16_, &_inner_error_);
		_tmp18_ = _tmp17_;
		_tmp18__length1 = _tmp16_;
		_g_free0 (_tmp13_);
		_tmp19_ = _tmp18_;
		_tmp19__length1 = _tmp18__length1;
		__tmp19__size_ = _tmp19__length1;
		if (_inner_error_ != NULL) {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
		buf = (guint8*) _tmp19_;
		buf_length1 = (_tmp19__length1 * sizeof (guchar)) / sizeof (guint8);
		_buf_size_ = buf_length1;
		_tmp20_ = buf;
		_tmp20__length1 = buf_length1;
		_tmp21_ = zcd_serializable_buffer_new (_tmp20_, _tmp20__length1);
		signature = _tmp21_;
		_tmp22_ = signature;
		_tmp23_ = netsukuku_andna_confirm_pubk_response_new ("OK", _tmp22_);
		result = _tmp23_;
		_g_object_unref0 (signature);
		buf = (g_free (buf), NULL);
		return result;
	}
	_tmp24_ = g_new0 (guint8, 0);
	_tmp25_ = _tmp24_;
	_tmp25__length1 = 0;
	_tmp26_ = zcd_serializable_buffer_new (_tmp25_, 0);
	_tmp27_ = _tmp26_;
	_tmp28_ = netsukuku_andna_confirm_pubk_response_new ("NO", _tmp27_);
	_tmp29_ = _tmp28_;
	_g_object_unref0 (_tmp27_);
	_tmp25_ = (g_free (_tmp25_), NULL);
	result = _tmp29_;
	return result;
}


static GeeList* netsukuku_andna_real_get_your_hostnames (NetsukukuIAndna* base, NetsukukuNIP* yournip, GError** error) {
	NetsukukuAndna * self;
	GeeList* result = NULL;
	GeeArrayList* _tmp0_;
	GeeArrayList* ret;
	self = (NetsukukuAndna*) base;
	g_return_val_if_fail (yournip != NULL, NULL);
	_tmp0_ = gee_array_list_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, NULL, NULL, NULL);
	ret = _tmp0_;
	{
		NetsukukuAndnaPrivateConfigurationList* _tmp1_;
		NetsukukuAndnaPrivateConfigurationList* _tmp2_;
		GeeArrayList* _tmp3_;
		GeeArrayList* _tmp4_;
		GeeArrayList* _tmp5_;
		GeeArrayList* _c_list;
		GeeArrayList* _tmp6_;
		gint _tmp7_;
		gint _tmp8_;
		gint _c_size;
		gint _c_index;
		_tmp1_ = netsukuku_andna_get_configuration (self);
		_tmp2_ = _tmp1_;
		_tmp3_ = netsukuku_andna_private_configuration_list_get_lst (_tmp2_);
		_tmp4_ = _tmp3_;
		_tmp5_ = _g_object_ref0 (_tmp4_);
		_c_list = _tmp5_;
		_tmp6_ = _c_list;
		_tmp7_ = gee_abstract_collection_get_size ((GeeCollection*) _tmp6_);
		_tmp8_ = _tmp7_;
		_c_size = _tmp8_;
		_c_index = -1;
		while (TRUE) {
			gint _tmp9_;
			gint _tmp10_;
			gint _tmp11_;
			GeeArrayList* _tmp12_;
			gint _tmp13_;
			gpointer _tmp14_ = NULL;
			NetsukukuAndnaPrivateConfiguration* c;
			GeeArrayList* _tmp15_;
			NetsukukuAndnaPrivateConfiguration* _tmp16_;
			const gchar* _tmp17_;
			_tmp9_ = _c_index;
			_c_index = _tmp9_ + 1;
			_tmp10_ = _c_index;
			_tmp11_ = _c_size;
			if (!(_tmp10_ < _tmp11_)) {
				break;
			}
			_tmp12_ = _c_list;
			_tmp13_ = _c_index;
			_tmp14_ = gee_abstract_list_get ((GeeAbstractList*) _tmp12_, _tmp13_);
			c = (NetsukukuAndnaPrivateConfiguration*) _tmp14_;
			_tmp15_ = ret;
			_tmp16_ = c;
			_tmp17_ = _tmp16_->domain;
			gee_abstract_collection_add ((GeeAbstractCollection*) _tmp15_, _tmp17_);
			_g_object_unref0 (c);
		}
		_g_object_unref0 (_c_list);
	}
	result = (GeeList*) ret;
	return result;
}


static NetsukukuInfoAndna* netsukuku_andna_real_report_status (NetsukukuIAndna* base, GError** error) {
	NetsukukuAndna * self;
	NetsukukuInfoAndna* result = NULL;
	NetsukukuInfoAndna* _tmp0_;
	NetsukukuInfoAndna* ret;
	NetsukukuInfoAndna* _tmp1_;
	gboolean _tmp2_;
	NetsukukuInfoAndna* _tmp3_;
	gboolean _tmp4_ = FALSE;
	NetsukukuInfoAndna* _tmp5_;
	NetsukukuPublicKey* _tmp6_;
	NetsukukuPublicKey* _tmp7_;
	gchar* _tmp8_ = NULL;
	self = (NetsukukuAndna*) base;
	_tmp0_ = netsukuku_info_andna_new ();
	ret = _tmp0_;
	_tmp1_ = ret;
	_tmp2_ = self->memory_initialized;
	_tmp1_->memory_initialized = _tmp2_;
	_tmp3_ = ret;
	_tmp4_ = netsukuku_andna_register_my_names_ongoing (self);
	_tmp3_->register_ongoing = _tmp4_;
	_tmp5_ = ret;
	_tmp6_ = netsukuku_andna_get_mypubk (self);
	_tmp7_ = _tmp6_;
	_tmp8_ = netsukuku_public_key_to_string (_tmp7_);
	_g_free0 (_tmp5_->pubk);
	_tmp5_->pubk = _tmp8_;
	{
		GeeHashMap* _tmp9_;
		GeeSet* _tmp10_;
		GeeSet* _tmp11_;
		GeeSet* _tmp12_;
		GeeIterator* _tmp13_ = NULL;
		GeeIterator* _tmp14_;
		GeeIterator* _hashed_domain_it;
		_tmp9_ = self->priv->cache;
		_tmp10_ = gee_abstract_map_get_keys ((GeeMap*) _tmp9_);
		_tmp11_ = _tmp10_;
		_tmp12_ = _tmp11_;
		_tmp13_ = gee_iterable_iterator ((GeeIterable*) _tmp12_);
		_tmp14_ = _tmp13_;
		_g_object_unref0 (_tmp12_);
		_hashed_domain_it = _tmp14_;
		while (TRUE) {
			GeeIterator* _tmp15_;
			gboolean _tmp16_ = FALSE;
			GeeIterator* _tmp17_;
			gpointer _tmp18_ = NULL;
			gchar* hashed_domain;
			NetsukukuInfoAndnaCache* _tmp19_;
			NetsukukuInfoAndnaCache* c;
			NetsukukuInfoAndnaCache* _tmp20_;
			const gchar* _tmp21_;
			gchar* _tmp22_;
			NetsukukuInfoAndnaCache* _tmp23_;
			GeeHashMap* _tmp24_;
			const gchar* _tmp25_;
			gpointer _tmp26_ = NULL;
			NetsukukuInfoAndna* _tmp27_;
			GeeArrayList* _tmp28_;
			GeeArrayList* _tmp29_;
			NetsukukuInfoAndnaCache* _tmp30_;
			_tmp15_ = _hashed_domain_it;
			_tmp16_ = gee_iterator_next (_tmp15_);
			if (!_tmp16_) {
				break;
			}
			_tmp17_ = _hashed_domain_it;
			_tmp18_ = gee_iterator_get (_tmp17_);
			hashed_domain = (gchar*) _tmp18_;
			_tmp19_ = netsukuku_info_andna_cache_new ();
			c = _tmp19_;
			_tmp20_ = c;
			_tmp21_ = hashed_domain;
			_tmp22_ = g_strdup (_tmp21_);
			_g_free0 (_tmp20_->domain);
			_tmp20_->domain = _tmp22_;
			_tmp23_ = c;
			_tmp24_ = self->priv->cache;
			_tmp25_ = hashed_domain;
			_tmp26_ = gee_abstract_map_get ((GeeAbstractMap*) _tmp24_, _tmp25_);
			_g_object_unref0 (_tmp23_->rec);
			_tmp23_->rec = (NetsukukuAndnaDomainRecord*) _tmp26_;
			_tmp27_ = ret;
			_tmp28_ = netsukuku_info_andna_get_cache (_tmp27_);
			_tmp29_ = _tmp28_;
			_tmp30_ = c;
			gee_abstract_collection_add ((GeeAbstractCollection*) _tmp29_, _tmp30_);
			_g_object_unref0 (c);
			_g_free0 (hashed_domain);
		}
		_g_object_unref0 (_hashed_domain_it);
	}
	{
		GeeArrayList* _tmp31_;
		GeeArrayList* _tmp32_;
		GeeArrayList* _dw_list;
		GeeArrayList* _tmp33_;
		gint _tmp34_;
		gint _tmp35_;
		gint _dw_size;
		gint _dw_index;
		_tmp31_ = self->priv->lst_domains;
		_tmp32_ = _g_object_ref0 (_tmp31_);
		_dw_list = _tmp32_;
		_tmp33_ = _dw_list;
		_tmp34_ = gee_abstract_collection_get_size ((GeeCollection*) _tmp33_);
		_tmp35_ = _tmp34_;
		_dw_size = _tmp35_;
		_dw_index = -1;
		while (TRUE) {
			gint _tmp36_;
			gint _tmp37_;
			gint _tmp38_;
			GeeArrayList* _tmp39_;
			gint _tmp40_;
			gpointer _tmp41_ = NULL;
			NetsukukuDomainWanted* dw;
			NetsukukuInfoAndnaRegistration* _tmp42_;
			NetsukukuInfoAndnaRegistration* r;
			NetsukukuInfoAndnaRegistration* _tmp43_;
			NetsukukuDomainWanted* _tmp44_;
			const gchar* _tmp45_;
			gchar* _tmp46_;
			NetsukukuInfoAndnaRegistration* _tmp47_;
			NetsukukuDomainWanted* _tmp48_;
			gboolean _tmp49_;
			NetsukukuInfoAndnaRegistration* _tmp50_;
			NetsukukuDomainWanted* _tmp51_;
			NetsukukuTimeCapsule* _tmp52_;
			NetsukukuTimeCapsule* _tmp53_;
			NetsukukuInfoAndna* _tmp54_;
			GeeArrayList* _tmp55_;
			GeeArrayList* _tmp56_;
			NetsukukuInfoAndnaRegistration* _tmp57_;
			_tmp36_ = _dw_index;
			_dw_index = _tmp36_ + 1;
			_tmp37_ = _dw_index;
			_tmp38_ = _dw_size;
			if (!(_tmp37_ < _tmp38_)) {
				break;
			}
			_tmp39_ = _dw_list;
			_tmp40_ = _dw_index;
			_tmp41_ = gee_abstract_list_get ((GeeAbstractList*) _tmp39_, _tmp40_);
			dw = (NetsukukuDomainWanted*) _tmp41_;
			_tmp42_ = netsukuku_info_andna_registration_new ();
			r = _tmp42_;
			_tmp43_ = r;
			_tmp44_ = dw;
			_tmp45_ = _tmp44_->hostname;
			_tmp46_ = g_strdup (_tmp45_);
			_g_free0 (_tmp43_->domain);
			_tmp43_->domain = _tmp46_;
			_tmp47_ = r;
			_tmp48_ = dw;
			_tmp49_ = _tmp48_->registered;
			_tmp47_->registered = _tmp49_;
			_tmp50_ = r;
			_tmp51_ = dw;
			_tmp52_ = _tmp51_->ttl_before_request;
			_tmp53_ = _g_object_ref0 (_tmp52_);
			_g_object_unref0 (_tmp50_->ttl_before_request);
			_tmp50_->ttl_before_request = _tmp53_;
			_tmp54_ = ret;
			_tmp55_ = netsukuku_info_andna_get_registrations (_tmp54_);
			_tmp56_ = _tmp55_;
			_tmp57_ = r;
			gee_abstract_collection_add ((GeeAbstractCollection*) _tmp56_, _tmp57_);
			_g_object_unref0 (r);
			_g_object_unref0 (dw);
		}
		_g_object_unref0 (_dw_list);
	}
	result = ret;
	return result;
}


static NetsukukuAndnaPrivateConfigurationList* netsukuku_andna_real_get_mynames (NetsukukuIAndna* base, GError** error) {
	NetsukukuAndna * self;
	NetsukukuAndnaPrivateConfigurationList* result = NULL;
	NetsukukuAndnaPrivateConfigurationList* _tmp0_;
	NetsukukuAndnaPrivateConfigurationList* _tmp1_;
	NetsukukuAndnaPrivateConfigurationList* _tmp2_;
	self = (NetsukukuAndna*) base;
	_tmp0_ = netsukuku_andna_get_configuration (self);
	_tmp1_ = _tmp0_;
	_tmp2_ = _g_object_ref0 (_tmp1_);
	result = _tmp2_;
	return result;
}


static void netsukuku_andna_real_set_mynames (NetsukukuIAndna* base, NetsukukuAndnaPrivateConfigurationList* mynames, GError** error) {
	NetsukukuAndna * self;
	NetsukukuAndnaPrivateConfigurationList* _tmp0_;
	NetsukukuAndnaPrivateConfigurationList* _tmp1_;
	self = (NetsukukuAndna*) base;
	g_return_if_fail (mynames != NULL);
	netsukuku_andna_stop_register_my_names (self);
	_tmp0_ = mynames;
	_tmp1_ = _g_object_ref0 (_tmp0_);
	_g_object_unref0 (self->priv->_configuration);
	self->priv->_configuration = _tmp1_;
	netsukuku_andna_register_my_names (self);
}


static NetsukukuPublicKey* netsukuku_andna_real_retrieve_registrar_pubk (NetsukukuIAndna* base, const gchar* hashed_domain, GError** error) {
	NetsukukuAndna * self;
	NetsukukuPublicKey* result = NULL;
	const gchar* _tmp0_;
	NetsukukuAndnaGetRegistrarResponse* _tmp1_ = NULL;
	NetsukukuAndnaGetRegistrarResponse* ret;
	NetsukukuAndnaGetRegistrarResponse* _tmp2_;
	NetsukukuAndnaGetRegistrarResponse* _tmp3_;
	NetsukukuPublicKey* _tmp4_;
	NetsukukuPublicKey* _tmp5_;
	NetsukukuPublicKey* _tmp6_;
	self = (NetsukukuAndna*) base;
	g_return_val_if_fail (hashed_domain != NULL, NULL);
	_tmp0_ = hashed_domain;
	_tmp1_ = netsukuku_andna_ask_registrar (self, _tmp0_);
	ret = _tmp1_;
	_tmp2_ = ret;
	if (_tmp2_ == NULL) {
		result = NULL;
		_g_object_unref0 (ret);
		return result;
	}
	_tmp3_ = ret;
	_tmp4_ = netsukuku_andna_get_registrar_response_get_pubk (_tmp3_);
	_tmp5_ = _tmp4_;
	_tmp6_ = _g_object_ref0 (_tmp5_);
	result = _tmp6_;
	_g_object_unref0 (ret);
	return result;
}


static NetsukukuAndnaPrivateConfigurationList* netsukuku_andna_get_configuration (NetsukukuAndna* self) {
	NetsukukuAndnaPrivateConfigurationList* result;
	NetsukukuAndnaPrivateConfigurationList* _tmp0_;
	NetsukukuAndnaPrivateConfigurationList* _tmp20_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_configuration;
	if (_tmp0_ == NULL) {
		NetsukukuAndnaPrivateConfigurationList* _tmp1_;
		gchar buffer[256] = {0};
		gchar* myhostname;
		gint _tmp2_ = 0;
		const gchar* _tmp13_;
		_tmp1_ = netsukuku_andna_private_configuration_list_new ();
		_g_object_unref0 (self->priv->_configuration);
		self->priv->_configuration = _tmp1_;
		myhostname = NULL;
		_tmp2_ = gethostname (buffer, 256);
		if (_tmp2_ == 0) {
			GString* _tmp3_;
			GString* sb;
			gint pos;
			GString* _tmp9_;
			GString* _tmp10_;
			const gchar* _tmp11_;
			gchar* _tmp12_;
			_tmp3_ = g_string_new ("");
			sb = _tmp3_;
			pos = 0;
			while (TRUE) {
				gint _tmp4_;
				gchar _tmp5_;
				GString* _tmp6_;
				gint _tmp7_;
				gchar _tmp8_;
				_tmp4_ = pos;
				_tmp5_ = buffer[_tmp4_];
				if (!(_tmp5_ != '\0')) {
					break;
				}
				_tmp6_ = sb;
				_tmp7_ = pos;
				pos = _tmp7_ + 1;
				_tmp8_ = buffer[_tmp7_];
				g_string_append_c (_tmp6_, _tmp8_);
			}
			_tmp9_ = sb;
			g_string_append_c (_tmp9_, '\0');
			_tmp10_ = sb;
			_tmp11_ = _tmp10_->str;
			_tmp12_ = g_strdup (_tmp11_);
			_g_free0 (myhostname);
			myhostname = _tmp12_;
			_g_string_free0 (sb);
		}
		_tmp13_ = myhostname;
		if (_tmp13_ != NULL) {
			const gchar* _tmp14_;
			NetsukukuAndnaPrivateConfiguration* _tmp15_;
			NetsukukuAndnaPrivateConfiguration* cfg;
			NetsukukuAndnaPrivateConfigurationList* _tmp16_;
			GeeArrayList* _tmp17_;
			GeeArrayList* _tmp18_;
			NetsukukuAndnaPrivateConfiguration* _tmp19_;
			_tmp14_ = myhostname;
			_tmp15_ = netsukuku_andna_private_configuration_new (_tmp14_, NULL);
			cfg = _tmp15_;
			_tmp16_ = self->priv->_configuration;
			_tmp17_ = netsukuku_andna_private_configuration_list_get_lst (_tmp16_);
			_tmp18_ = _tmp17_;
			_tmp19_ = cfg;
			gee_abstract_collection_add ((GeeAbstractCollection*) _tmp18_, _tmp19_);
			_g_object_unref0 (cfg);
		}
		_g_free0 (myhostname);
	}
	_tmp20_ = self->priv->_configuration;
	result = _tmp20_;
	return result;
}


static NetsukukuPublicKey* netsukuku_andna_get_mypubk (NetsukukuAndna* self) {
	NetsukukuPublicKey* result;
	NetsukukuPublicKey* _tmp0_;
	NetsukukuPublicKey* _tmp5_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_mypubk;
	if (_tmp0_ == NULL) {
		NetsukukuKeyPair* _tmp1_;
		NetsukukuPublicKeyWrapper* _tmp2_;
		NetsukukuPublicKeyWrapper* _tmp3_;
		NetsukukuPublicKey* _tmp4_ = NULL;
		_tmp1_ = self->priv->my_keys;
		_tmp2_ = netsukuku_key_pair_get_pub_key (_tmp1_);
		_tmp3_ = _tmp2_;
		_tmp4_ = netsukuku_public_key_wrapper_to_pubkey (_tmp3_);
		_g_object_unref0 (self->priv->_mypubk);
		self->priv->_mypubk = _tmp4_;
	}
	_tmp5_ = self->priv->_mypubk;
	result = _tmp5_;
	return result;
}


static void netsukuku_andna_class_init (NetsukukuAndnaClass * klass) {
	netsukuku_andna_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (NetsukukuAndnaPrivate));
	NETSUKUKU_PEER_TO_PEER_CLASS (klass)->_dispatch = netsukuku_andna_real__dispatch;
	NETSUKUKU_PEER_TO_PEER_CLASS (klass)->h = netsukuku_andna_real_h;
	G_OBJECT_CLASS (klass)->get_property = _vala_netsukuku_andna_get_property;
	G_OBJECT_CLASS (klass)->finalize = netsukuku_andna_finalize;
	g_signal_new ("andna_ready", NETSUKUKU_TYPE_ANDNA, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
	g_signal_new ("andna_registered", NETSUKUKU_TYPE_ANDNA, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__STRING, G_TYPE_NONE, 1, G_TYPE_STRING);
}


static void netsukuku_andna_netsukuku_iandna_as_peer_interface_init (NetsukukuIAndnaAsPeerIface * iface) {
	netsukuku_andna_netsukuku_iandna_as_peer_parent_iface = g_type_interface_peek_parent (iface);
	iface->register_main_for_pubk = (NetsukukuAndnaRegisterMainResponse* (*)(NetsukukuIAndnaAsPeer*, NetsukukuAndnaDomainRequest*, zcdSerializableBuffer*, gboolean, GError**)) netsukuku_andna_real_register_main_for_pubk;
	iface->get_registrar = (NetsukukuAndnaGetRegistrarResponse* (*)(NetsukukuIAndnaAsPeer*, const gchar*, GError**)) netsukuku_andna_real_get_registrar;
	iface->get_domain_record = (NetsukukuAndnaDomainRecord* (*)(NetsukukuIAndnaAsPeer*, const gchar*, GError**)) netsukuku_andna_real_get_domain_record;
	iface->register_spread_record = (NetsukukuAndnaRegisterSpreadResponse* (*)(NetsukukuIAndnaAsPeer*, const gchar*, gint, gboolean, GError**)) netsukuku_andna_real_register_spread_record;
	iface->get_servers = (NetsukukuAndnaGetServersResponse* (*)(NetsukukuIAndnaAsPeer*, const gchar*, NetsukukuAndnaServiceKey*, gint, gboolean, GError**)) netsukuku_andna_real_get_servers;
	iface->get_cache_records = (NetsukukuAndnaGetCacheRecordsResponse* (*)(NetsukukuIAndnaAsPeer*, GError**)) netsukuku_andna_real_get_cache_records;
}


static void netsukuku_andna_netsukuku_iandna_interface_init (NetsukukuIAndnaIface * iface) {
	netsukuku_andna_netsukuku_iandna_parent_iface = g_type_interface_peek_parent (iface);
	iface->confirm_pubk = (NetsukukuAndnaConfirmPubkResponse* (*)(NetsukukuIAndna*, NetsukukuNIP*, NetsukukuPublicKey*, gint, GError**)) netsukuku_andna_real_confirm_pubk;
	iface->get_your_hostnames = (GeeList* (*)(NetsukukuIAndna*, NetsukukuNIP*, GError**)) netsukuku_andna_real_get_your_hostnames;
	iface->report_status = (NetsukukuInfoAndna* (*)(NetsukukuIAndna*, GError**)) netsukuku_andna_real_report_status;
	iface->get_mynames = (NetsukukuAndnaPrivateConfigurationList* (*)(NetsukukuIAndna*, GError**)) netsukuku_andna_real_get_mynames;
	iface->set_mynames = (void (*)(NetsukukuIAndna*, NetsukukuAndnaPrivateConfigurationList*, GError**)) netsukuku_andna_real_set_mynames;
	iface->retrieve_registrar_pubk = (NetsukukuPublicKey* (*)(NetsukukuIAndna*, const gchar*, GError**)) netsukuku_andna_real_retrieve_registrar_pubk;
}


static void netsukuku_andna_instance_init (NetsukukuAndna * self) {
	self->priv = NETSUKUKU_ANDNA_GET_PRIVATE (self);
}


static void netsukuku_andna_finalize (GObject* obj) {
	NetsukukuAndna * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, NETSUKUKU_TYPE_ANDNA, NetsukukuAndna);
	_g_object_unref0 (self->priv->_configuration);
	_g_object_unref0 (self->priv->peer_to_peer_all);
	_g_object_unref0 (self->priv->counter);
	_g_object_unref0 (self->priv->my_keys);
	_g_object_unref0 (self->priv->request_queue);
	_g_object_unref0 (self->priv->cache);
	_g_object_unref0 (self->priv->lst_domains);
	_g_object_unref0 (self->priv->_mypubk);
	G_OBJECT_CLASS (netsukuku_andna_parent_class)->finalize (obj);
}


GType netsukuku_andna_get_type (void) {
	static volatile gsize netsukuku_andna_type_id__volatile = 0;
	if (g_once_init_enter (&netsukuku_andna_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (NetsukukuAndnaClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) netsukuku_andna_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (NetsukukuAndna), 0, (GInstanceInitFunc) netsukuku_andna_instance_init, NULL };
		static const GInterfaceInfo netsukuku_iandna_as_peer_info = { (GInterfaceInitFunc) netsukuku_andna_netsukuku_iandna_as_peer_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
		static const GInterfaceInfo netsukuku_iandna_info = { (GInterfaceInitFunc) netsukuku_andna_netsukuku_iandna_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
		GType netsukuku_andna_type_id;
		netsukuku_andna_type_id = g_type_register_static (NETSUKUKU_TYPE_PEER_TO_PEER, "NetsukukuAndna", &g_define_type_info, 0);
		g_type_add_interface_static (netsukuku_andna_type_id, NETSUKUKU_TYPE_IANDNA_AS_PEER, &netsukuku_iandna_as_peer_info);
		g_type_add_interface_static (netsukuku_andna_type_id, NETSUKUKU_TYPE_IANDNA, &netsukuku_iandna_info);
		g_once_init_leave (&netsukuku_andna_type_id__volatile, netsukuku_andna_type_id);
	}
	return netsukuku_andna_type_id__volatile;
}


static void _vala_netsukuku_andna_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	NetsukukuAndna * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, NETSUKUKU_TYPE_ANDNA, NetsukukuAndna);
	switch (property_id) {
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}


static gint _vala_array_length (gpointer array) {
	int length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}



