/* andna_tester.c generated by valac 0.20.1, the Vala compiler
 * generated from andna_tester.vala, do not modify */

/*
 *  This file is part of Netsukuku.
 *  (c) Copyright 2011-2014 Luca Dionisi aka lukisi <luca.dionisi@gmail.com>
 *
 *  Netsukuku is free software: you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation, either version 3 of the License, or
 *  (at your option) any later version.
 *
 *  Netsukuku is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with Netsukuku.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <tasklet.h>
#include <netsukuku-rpc.h>
#include <zcd.h>
#include <gee.h>

#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

#define NTK_TEST_TYPE_ANDNA_TESTER (ntk_test_andna_tester_get_type ())
#define NTK_TEST_ANDNA_TESTER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), NTK_TEST_TYPE_ANDNA_TESTER, NtkTestAndnaTester))
#define NTK_TEST_ANDNA_TESTER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), NTK_TEST_TYPE_ANDNA_TESTER, NtkTestAndnaTesterClass))
#define NTK_TEST_IS_ANDNA_TESTER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), NTK_TEST_TYPE_ANDNA_TESTER))
#define NTK_TEST_IS_ANDNA_TESTER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), NTK_TEST_TYPE_ANDNA_TESTER))
#define NTK_TEST_ANDNA_TESTER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), NTK_TEST_TYPE_ANDNA_TESTER, NtkTestAndnaTesterClass))

typedef struct _NtkTestAndnaTester NtkTestAndnaTester;
typedef struct _NtkTestAndnaTesterClass NtkTestAndnaTesterClass;
typedef struct _NtkTestAndnaTesterPrivate NtkTestAndnaTesterPrivate;
#define _vala_assert(expr, msg) if G_LIKELY (expr) ; else g_assertion_message_expr (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);

struct _NtkTestAndnaTester {
	GObject parent_instance;
	NtkTestAndnaTesterPrivate * priv;
};

struct _NtkTestAndnaTesterClass {
	GObjectClass parent_class;
};


extern gint64 netsukuku_andna_const_MAX_TTL_ANDNA;
gint64 netsukuku_andna_const_MAX_TTL_ANDNA = (((((gint64) 1000) * ((gint64) 60)) * ((gint64) 60)) * ((gint64) 24)) * ((gint64) 30);
extern gchar* ntk_test_logger;
gchar* ntk_test_logger = NULL;
static gpointer ntk_test_andna_tester_parent_class = NULL;

gchar* netsukuku_tasklet_id (void);
void netsukuku_log_debug (const gchar* msg);
void ntk_test_print_out (const gchar* s);
void netsukuku_log_info (const gchar* msg);
void netsukuku_log_notice (const gchar* msg);
void netsukuku_log_warn (const gchar* msg);
void netsukuku_log_error (const gchar* msg);
void netsukuku_log_critical (const gchar* msg);
#define NTK_TEST_output FALSE
GType ntk_test_andna_tester_get_type (void) G_GNUC_CONST;
enum  {
	NTK_TEST_ANDNA_TESTER_DUMMY_PROPERTY
};
void ntk_test_andna_tester_set_up (NtkTestAndnaTester* self);
void ntk_test_andna_tester_tear_down (NtkTestAndnaTester* self);
void ntk_test_andna_tester_test_timers_boundary (NtkTestAndnaTester* self);
static void _vala_array_add1 (TaskletsTimer*** array, int* length, int* size, TaskletsTimer* value);
void ntk_test_andna_tester_test_ser_servkey (NtkTestAndnaTester* self);
void ntk_test_andna_tester_test_ser_publickey (NtkTestAndnaTester* self);
void ntk_test_andna_tester_test_server_record_equal_func (NtkTestAndnaTester* self);
void ntk_test_andna_tester_test_ser_domain_record (NtkTestAndnaTester* self);
static gboolean _netsukuku_andna_server_record_equal_func_gee_equal_data_func (gconstpointer a, gconstpointer b, gpointer self);
static guint _netsukuku_andna_service_key_hash_func_gee_hash_data_func (gconstpointer v, gpointer self);
static gboolean _netsukuku_andna_service_key_equal_func_gee_equal_data_func (gconstpointer a, gconstpointer b, gpointer self);
void ntk_test_andna_tester_test_ser_get_cache (NtkTestAndnaTester* self);
static gboolean _netsukuku_register_hostname_arguments_equal_func_for_queue_gee_equal_data_func (gconstpointer a, gconstpointer b, gpointer self);
void ntk_test_andna_tester_test_ser_info_andna (NtkTestAndnaTester* self);
gint ntk_test_andna_tester_main (gchar** args, int args_length1);
static void __lambda2_ (void);
NtkTestAndnaTester* ntk_test_andna_tester_new (void);
NtkTestAndnaTester* ntk_test_andna_tester_construct (GType object_type);
static void ___lambda2__gcallback (void);
static void __lambda3_ (void);
static void ___lambda3__gcallback (void);
static void __lambda4_ (void);
static void ___lambda4__gcallback (void);
static void __lambda5_ (void);
static void ___lambda5__gcallback (void);
static void __lambda6_ (void);
static void ___lambda6__gcallback (void);
static void __lambda7_ (void);
static void ___lambda7__gcallback (void);
static void __lambda8_ (void);
static void ___lambda8__gcallback (void);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);


gchar* netsukuku_tasklet_id (void) {
	gchar* result = NULL;
	TaskletsTasklet* _tmp0_ = NULL;
	TaskletsTasklet* _tmp1_;
	gint _tmp2_;
	gint _tmp3_;
	gchar* _tmp4_ = NULL;
	gchar* _tmp5_;
	gchar* _tmp6_ = NULL;
	gchar* _tmp7_;
	_tmp0_ = tasklets_tasklet_self ();
	_tmp1_ = _tmp0_;
	_tmp2_ = tasklets_tasklet_get_id (_tmp1_);
	_tmp3_ = _tmp2_;
	_tmp4_ = g_strdup_printf ("%i", _tmp3_);
	_tmp5_ = _tmp4_;
	_tmp6_ = g_strconcat ("[", _tmp5_, "] ", NULL);
	_tmp7_ = _tmp6_;
	_g_free0 (_tmp5_);
	_g_object_unref0 (_tmp1_);
	result = _tmp7_;
	return result;
}


void netsukuku_log_debug (const gchar* msg) {
	gchar* _tmp0_ = NULL;
	gchar* _tmp1_;
	const gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	gchar* _tmp5_;
	gchar* _tmp6_;
	g_return_if_fail (msg != NULL);
	_tmp0_ = netsukuku_tasklet_id ();
	_tmp1_ = _tmp0_;
	_tmp2_ = msg;
	_tmp3_ = g_strconcat (_tmp1_, _tmp2_, NULL);
	_tmp4_ = _tmp3_;
	_tmp5_ = g_strconcat (_tmp4_, "\n", NULL);
	_tmp6_ = _tmp5_;
	ntk_test_print_out (_tmp6_);
	_g_free0 (_tmp6_);
	_g_free0 (_tmp4_);
	_g_free0 (_tmp1_);
}


void netsukuku_log_info (const gchar* msg) {
	gchar* _tmp0_ = NULL;
	gchar* _tmp1_;
	const gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	gchar* _tmp5_;
	gchar* _tmp6_;
	g_return_if_fail (msg != NULL);
	_tmp0_ = netsukuku_tasklet_id ();
	_tmp1_ = _tmp0_;
	_tmp2_ = msg;
	_tmp3_ = g_strconcat (_tmp1_, _tmp2_, NULL);
	_tmp4_ = _tmp3_;
	_tmp5_ = g_strconcat (_tmp4_, "\n", NULL);
	_tmp6_ = _tmp5_;
	ntk_test_print_out (_tmp6_);
	_g_free0 (_tmp6_);
	_g_free0 (_tmp4_);
	_g_free0 (_tmp1_);
}


void netsukuku_log_notice (const gchar* msg) {
	gchar* _tmp0_ = NULL;
	gchar* _tmp1_;
	const gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	gchar* _tmp5_;
	gchar* _tmp6_;
	g_return_if_fail (msg != NULL);
	_tmp0_ = netsukuku_tasklet_id ();
	_tmp1_ = _tmp0_;
	_tmp2_ = msg;
	_tmp3_ = g_strconcat (_tmp1_, _tmp2_, NULL);
	_tmp4_ = _tmp3_;
	_tmp5_ = g_strconcat (_tmp4_, "\n", NULL);
	_tmp6_ = _tmp5_;
	ntk_test_print_out (_tmp6_);
	_g_free0 (_tmp6_);
	_g_free0 (_tmp4_);
	_g_free0 (_tmp1_);
}


void netsukuku_log_warn (const gchar* msg) {
	gchar* _tmp0_ = NULL;
	gchar* _tmp1_;
	const gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	gchar* _tmp5_;
	gchar* _tmp6_;
	g_return_if_fail (msg != NULL);
	_tmp0_ = netsukuku_tasklet_id ();
	_tmp1_ = _tmp0_;
	_tmp2_ = msg;
	_tmp3_ = g_strconcat (_tmp1_, _tmp2_, NULL);
	_tmp4_ = _tmp3_;
	_tmp5_ = g_strconcat (_tmp4_, "\n", NULL);
	_tmp6_ = _tmp5_;
	ntk_test_print_out (_tmp6_);
	_g_free0 (_tmp6_);
	_g_free0 (_tmp4_);
	_g_free0 (_tmp1_);
}


void netsukuku_log_error (const gchar* msg) {
	gchar* _tmp0_ = NULL;
	gchar* _tmp1_;
	const gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	gchar* _tmp5_;
	gchar* _tmp6_;
	g_return_if_fail (msg != NULL);
	_tmp0_ = netsukuku_tasklet_id ();
	_tmp1_ = _tmp0_;
	_tmp2_ = msg;
	_tmp3_ = g_strconcat (_tmp1_, _tmp2_, NULL);
	_tmp4_ = _tmp3_;
	_tmp5_ = g_strconcat (_tmp4_, "\n", NULL);
	_tmp6_ = _tmp5_;
	ntk_test_print_out (_tmp6_);
	_g_free0 (_tmp6_);
	_g_free0 (_tmp4_);
	_g_free0 (_tmp1_);
}


void netsukuku_log_critical (const gchar* msg) {
	gchar* _tmp0_ = NULL;
	gchar* _tmp1_;
	const gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	gchar* _tmp5_;
	gchar* _tmp6_;
	g_return_if_fail (msg != NULL);
	_tmp0_ = netsukuku_tasklet_id ();
	_tmp1_ = _tmp0_;
	_tmp2_ = msg;
	_tmp3_ = g_strconcat (_tmp1_, _tmp2_, NULL);
	_tmp4_ = _tmp3_;
	_tmp5_ = g_strconcat (_tmp4_, "\n", NULL);
	_tmp6_ = _tmp5_;
	ntk_test_print_out (_tmp6_);
	_g_free0 (_tmp6_);
	_g_free0 (_tmp4_);
	_g_free0 (_tmp1_);
}


void ntk_test_print_out (const gchar* s) {
	g_return_if_fail (s != NULL);
	if (NTK_TEST_output) {
		const gchar* _tmp0_;
		_tmp0_ = s;
		g_print ("%s", _tmp0_);
	}
}


void ntk_test_andna_tester_set_up (NtkTestAndnaTester* self) {
	gchar* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = g_strdup ("");
	_g_free0 (ntk_test_logger);
	ntk_test_logger = _tmp0_;
}


void ntk_test_andna_tester_tear_down (NtkTestAndnaTester* self) {
	gchar* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = g_strdup ("");
	_g_free0 (ntk_test_logger);
	ntk_test_logger = _tmp0_;
}


static void _vala_array_add1 (TaskletsTimer*** array, int* length, int* size, TaskletsTimer* value) {
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (TaskletsTimer*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


static const gchar* string_to_string (const gchar* self) {
	const gchar* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	result = self;
	return result;
}


static gchar* bool_to_string (gboolean self) {
	gchar* result = NULL;
	if (self) {
		gchar* _tmp0_;
		_tmp0_ = g_strdup ("true");
		result = _tmp0_;
		return result;
	} else {
		gchar* _tmp1_;
		_tmp1_ = g_strdup ("false");
		result = _tmp1_;
		return result;
	}
}


void ntk_test_andna_tester_test_timers_boundary (NtkTestAndnaTester* self) {
	TaskletsTimer** _tmp0_ = NULL;
	TaskletsTimer** t;
	gint t_length1;
	gint _t_size_;
	gint64 ms;
	TaskletsTimer** _tmp11_;
	gint _tmp11__length1;
	TaskletsTimer* _tmp25_;
	TaskletsTimer* t_two;
	gint64 _tmp26_ = 0LL;
	TaskletsTimer* _tmp27_;
	TaskletsTimer* t_decr;
	gboolean _tmp28_ = FALSE;
	gboolean _tmp29_ = FALSE;
	gint64 _tmp30_ = 0LL;
	TaskletsTimer* _tmp31_;
	TaskletsTimer* t_expired;
	gboolean _tmp32_ = FALSE;
	g_return_if_fail (self != NULL);
	_tmp0_ = g_new0 (TaskletsTimer*, 0 + 1);
	t = _tmp0_;
	t_length1 = 0;
	_t_size_ = t_length1;
	ms = (gint64) 2000;
	while (TRUE) {
		gint64 _tmp1_;
		gchar* _tmp2_ = NULL;
		gchar* _tmp3_;
		gchar* _tmp4_ = NULL;
		gchar* _tmp5_;
		TaskletsTimer** _tmp6_;
		gint _tmp6__length1;
		gint64 _tmp7_;
		TaskletsTimer* _tmp8_;
		gint64 _tmp9_;
		gint64 _tmp10_;
		_tmp1_ = ms;
		_tmp2_ = g_strdup_printf ("%" G_GINT64_FORMAT, _tmp1_);
		_tmp3_ = _tmp2_;
		_tmp4_ = g_strconcat ("create timer ", _tmp3_, "\n", NULL);
		_tmp5_ = _tmp4_;
		ntk_test_print_out (_tmp5_);
		_g_free0 (_tmp5_);
		_g_free0 (_tmp3_);
		_tmp6_ = t;
		_tmp6__length1 = t_length1;
		_tmp7_ = ms;
		_tmp8_ = tasklets_timer_new (_tmp7_);
		_vala_array_add1 (&t, &t_length1, &_t_size_, _tmp8_);
		_tmp9_ = ms;
		ms = _tmp9_ * ((gint64) 2);
		_tmp10_ = ms;
		if (_tmp10_ > 600000000000LL) {
			break;
		}
	}
	tasklets_tasklet_nap ((glong) 0, (glong) 10000);
	_tmp11_ = t;
	_tmp11__length1 = t_length1;
	{
		TaskletsTimer** t0_collection = NULL;
		gint t0_collection_length1 = 0;
		gint _t0_collection_size_ = 0;
		gint t0_it = 0;
		t0_collection = _tmp11_;
		t0_collection_length1 = _tmp11__length1;
		for (t0_it = 0; t0_it < _tmp11__length1; t0_it = t0_it + 1) {
			TaskletsTimer* _tmp12_;
			TaskletsTimer* t0 = NULL;
			_tmp12_ = _g_object_ref0 (t0_collection[t0_it]);
			t0 = _tmp12_;
			{
				TaskletsTimer* _tmp13_;
				gchar* _tmp14_ = NULL;
				gchar* _tmp15_;
				const gchar* _tmp16_ = NULL;
				TaskletsTimer* _tmp17_;
				gboolean _tmp18_ = FALSE;
				gchar* _tmp19_ = NULL;
				gchar* _tmp20_;
				gchar* _tmp21_ = NULL;
				gchar* _tmp22_;
				TaskletsTimer* _tmp23_;
				gboolean _tmp24_ = FALSE;
				_tmp13_ = t0;
				_tmp14_ = tasklets_timer_get_string_msec_ttl (_tmp13_);
				_tmp15_ = _tmp14_;
				_tmp16_ = string_to_string (_tmp15_);
				_tmp17_ = t0;
				_tmp18_ = tasklets_timer_is_expired (_tmp17_);
				_tmp19_ = bool_to_string (_tmp18_);
				_tmp20_ = _tmp19_;
				_tmp21_ = g_strconcat (_tmp16_, "   ", _tmp20_, "\n", NULL);
				_tmp22_ = _tmp21_;
				ntk_test_print_out (_tmp22_);
				_g_free0 (_tmp22_);
				_g_free0 (_tmp20_);
				_g_free0 (_tmp15_);
				_tmp23_ = t0;
				_tmp24_ = tasklets_timer_is_expired (_tmp23_);
				_vala_assert (!_tmp24_, "! t0.is_expired()");
				_g_object_unref0 (t0);
			}
		}
	}
	_tmp25_ = tasklets_timer_new ((gint64) 2000);
	t_two = _tmp25_;
	_tmp26_ = tasklets_timer_get_msec_ttl (t_two);
	_tmp27_ = tasklets_timer_new (_tmp26_ - 1000);
	t_decr = _tmp27_;
	_tmp28_ = tasklets_timer_is_younger (t_two, t_decr);
	_vala_assert (_tmp28_, "t_two.is_younger(t_decr)");
	_tmp29_ = tasklets_timer_is_expired (t_decr);
	_vala_assert (!_tmp29_, "!t_decr.is_expired()");
	_tmp30_ = tasklets_timer_get_msec_ttl (t_two);
	_tmp31_ = tasklets_timer_new (_tmp30_ - 2001);
	t_expired = _tmp31_;
	_tmp32_ = tasklets_timer_is_expired (t_expired);
	_vala_assert (_tmp32_, "t_expired.is_expired()");
	_g_object_unref0 (t_expired);
	_g_object_unref0 (t_decr);
	_g_object_unref0 (t_two);
	t = (_vala_array_free (t, t_length1, (GDestroyNotify) g_object_unref), NULL);
}


void ntk_test_andna_tester_test_ser_servkey (NtkTestAndnaTester* self) {
	NetsukukuAndnaServiceKey* sk0 = NULL;
	NetsukukuAndnaServiceKey* _tmp22_;
	gchar* _tmp23_ = NULL;
	gchar* _tmp24_;
	gchar* _tmp25_ = NULL;
	gchar* _tmp26_;
	NetsukukuAndnaServiceKey* _tmp27_;
	NetsukukuAndnaServiceKey* _tmp28_;
	NetsukukuAndnaServiceKey* _tmp29_;
	gboolean _tmp30_ = FALSE;
	NetsukukuAndnaServiceKey* sk1 = NULL;
	NetsukukuAndnaServiceKey* _tmp51_;
	NetsukukuAndnaServiceKey* _tmp52_;
	gboolean _tmp53_ = FALSE;
	NetsukukuAndnaServiceKey* _tmp54_;
	gchar* _tmp55_ = NULL;
	gchar* _tmp56_;
	gchar* _tmp57_ = NULL;
	gchar* _tmp58_;
	NetsukukuAndnaServiceKey* _tmp59_;
	NetsukukuAndnaServiceKey* sk0001;
	NetsukukuAndnaServiceKey* _tmp60_;
	NetsukukuAndnaServiceKey* sk0002;
	NetsukukuAndnaServiceKey* _tmp61_;
	NetsukukuAndnaServiceKey* sk0003;
	NetsukukuAndnaServiceKey* _tmp62_;
	NetsukukuAndnaServiceKey* _tmp63_;
	NetsukukuAndnaServiceKey* _tmp64_;
	NetsukukuAndnaServiceKey* sk0004;
	NetsukukuAndnaServiceKey* _tmp65_;
	NetsukukuAndnaServiceKey* _tmp66_;
	gboolean _tmp67_ = FALSE;
	NetsukukuAndnaServiceKey* _tmp68_;
	NetsukukuAndnaServiceKey* _tmp69_;
	gboolean _tmp70_ = FALSE;
	NetsukukuAndnaServiceKey* _tmp71_;
	NetsukukuAndnaServiceKey* _tmp72_;
	gboolean _tmp73_ = FALSE;
	NetsukukuAndnaServiceKey* _tmp74_;
	NetsukukuAndnaServiceKey* _tmp75_;
	gboolean _tmp76_ = FALSE;
	NetsukukuAndnaServiceKey* _tmp77_;
	NetsukukuAndnaServiceKey* _tmp78_;
	gboolean _tmp79_ = FALSE;
	NetsukukuAndnaServiceKey* _tmp80_;
	gint _tmp81_ = 0;
	guchar* _tmp82_ = NULL;
	guchar* _tmp83_;
	gint _tmp83__length1;
	zcdISerializable* _tmp84_ = NULL;
	zcdISerializable* _tmp85_;
	zcdISerializable* _tmp86_;
	NetsukukuAndnaServiceKey* sk0005;
	NetsukukuAndnaServiceKey* _tmp87_;
	NetsukukuAndnaServiceKey* _tmp88_;
	gboolean _tmp89_ = FALSE;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	{
		guchar* orig = NULL;
		gint orig_length1 = 0;
		gint _orig_size_ = 0;
		guchar* _tmp6_;
		gint _tmp6__length1;
		guchar* _tmp7_ = NULL;
		guchar* dest;
		gint dest_length1;
		gint _dest_size_;
		guchar* _tmp19_;
		gint _tmp19__length1;
		zcdISerializable* _tmp20_ = NULL;
		zcdISerializable* _tmp21_;
		{
			NetsukukuAndnaServiceKey* _tmp0_;
			NetsukukuAndnaServiceKey* _tmp1_;
			NetsukukuAndnaServiceKey* _tmp2_;
			NetsukukuAndnaServiceKey* sk;
			NetsukukuAndnaServiceKey* _tmp3_;
			gint _tmp4_ = 0;
			guchar* _tmp5_ = NULL;
			_tmp0_ = netsukuku_andna_service_key_get_NULL_SERV_KEY ();
			_tmp1_ = _tmp0_;
			_tmp2_ = _g_object_ref0 (_tmp1_);
			sk = _tmp2_;
			_tmp3_ = sk;
			_tmp5_ = zcd_iserializable_serialize ((zcdISerializable*) _tmp3_, &_tmp4_);
			orig = (g_free (orig), NULL);
			orig = _tmp5_;
			orig_length1 = _tmp4_;
			_orig_size_ = orig_length1;
			_g_object_unref0 (sk);
		}
		_tmp6_ = orig;
		_tmp6__length1 = orig_length1;
		_tmp7_ = g_new0 (guchar, _tmp6__length1);
		dest = _tmp7_;
		dest_length1 = _tmp6__length1;
		_dest_size_ = dest_length1;
		{
			gint i;
			i = 0;
			{
				gboolean _tmp8_;
				_tmp8_ = TRUE;
				while (TRUE) {
					gboolean _tmp9_;
					gint _tmp11_;
					guchar* _tmp12_;
					gint _tmp12__length1;
					guchar* _tmp13_;
					gint _tmp13__length1;
					gint _tmp14_;
					guchar* _tmp15_;
					gint _tmp15__length1;
					gint _tmp16_;
					guchar _tmp17_;
					guchar _tmp18_;
					_tmp9_ = _tmp8_;
					if (!_tmp9_) {
						gint _tmp10_;
						_tmp10_ = i;
						i = _tmp10_ + 1;
					}
					_tmp8_ = FALSE;
					_tmp11_ = i;
					_tmp12_ = orig;
					_tmp12__length1 = orig_length1;
					if (!(_tmp11_ < _tmp12__length1)) {
						break;
					}
					_tmp13_ = dest;
					_tmp13__length1 = dest_length1;
					_tmp14_ = i;
					_tmp15_ = orig;
					_tmp15__length1 = orig_length1;
					_tmp16_ = i;
					_tmp17_ = _tmp15_[_tmp16_];
					_tmp13_[_tmp14_] = _tmp17_;
					_tmp18_ = _tmp13_[_tmp14_];
				}
			}
		}
		_tmp19_ = dest;
		_tmp19__length1 = dest_length1;
		_tmp20_ = zcd_iserializable_deserialize (_tmp19_, _tmp19__length1, &_inner_error_);
		_tmp21_ = _tmp20_;
		if (_inner_error_ != NULL) {
			dest = (g_free (dest), NULL);
			orig = (g_free (orig), NULL);
			_g_object_unref0 (sk0);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
		_g_object_unref0 (sk0);
		sk0 = G_TYPE_CHECK_INSTANCE_CAST (_tmp21_, NETSUKUKU_TYPE_ANDNA_SERVICE_KEY, NetsukukuAndnaServiceKey);
		dest = (g_free (dest), NULL);
		orig = (g_free (orig), NULL);
	}
	_tmp22_ = sk0;
	_tmp23_ = netsukuku_andna_service_key_to_string (_tmp22_);
	_tmp24_ = _tmp23_;
	_tmp25_ = g_strconcat ("sk0 ", _tmp24_, "\n", NULL);
	_tmp26_ = _tmp25_;
	ntk_test_print_out (_tmp26_);
	_g_free0 (_tmp26_);
	_g_free0 (_tmp24_);
	_tmp27_ = sk0;
	_tmp28_ = netsukuku_andna_service_key_get_NULL_SERV_KEY ();
	_tmp29_ = _tmp28_;
	_tmp30_ = netsukuku_andna_service_key_equal_func (_tmp27_, _tmp29_);
	_vala_assert (_tmp30_, "AndnaServiceKey.equal_func(sk0, AndnaServiceKey.NULL_SERV_KEY)");
	{
		guchar* orig = NULL;
		gint orig_length1 = 0;
		gint _orig_size_ = 0;
		guchar* _tmp35_;
		gint _tmp35__length1;
		guchar* _tmp36_ = NULL;
		guchar* dest;
		gint dest_length1;
		gint _dest_size_;
		guchar* _tmp48_;
		gint _tmp48__length1;
		zcdISerializable* _tmp49_ = NULL;
		zcdISerializable* _tmp50_;
		{
			NetsukukuAndnaServiceKey* _tmp31_;
			NetsukukuAndnaServiceKey* sk;
			NetsukukuAndnaServiceKey* _tmp32_;
			gint _tmp33_ = 0;
			guchar* _tmp34_ = NULL;
			_tmp31_ = netsukuku_andna_service_key_new ("imaps", "tcp");
			sk = _tmp31_;
			_tmp32_ = sk;
			_tmp34_ = zcd_iserializable_serialize ((zcdISerializable*) _tmp32_, &_tmp33_);
			orig = (g_free (orig), NULL);
			orig = _tmp34_;
			orig_length1 = _tmp33_;
			_orig_size_ = orig_length1;
			_g_object_unref0 (sk);
		}
		_tmp35_ = orig;
		_tmp35__length1 = orig_length1;
		_tmp36_ = g_new0 (guchar, _tmp35__length1);
		dest = _tmp36_;
		dest_length1 = _tmp35__length1;
		_dest_size_ = dest_length1;
		{
			gint i;
			i = 0;
			{
				gboolean _tmp37_;
				_tmp37_ = TRUE;
				while (TRUE) {
					gboolean _tmp38_;
					gint _tmp40_;
					guchar* _tmp41_;
					gint _tmp41__length1;
					guchar* _tmp42_;
					gint _tmp42__length1;
					gint _tmp43_;
					guchar* _tmp44_;
					gint _tmp44__length1;
					gint _tmp45_;
					guchar _tmp46_;
					guchar _tmp47_;
					_tmp38_ = _tmp37_;
					if (!_tmp38_) {
						gint _tmp39_;
						_tmp39_ = i;
						i = _tmp39_ + 1;
					}
					_tmp37_ = FALSE;
					_tmp40_ = i;
					_tmp41_ = orig;
					_tmp41__length1 = orig_length1;
					if (!(_tmp40_ < _tmp41__length1)) {
						break;
					}
					_tmp42_ = dest;
					_tmp42__length1 = dest_length1;
					_tmp43_ = i;
					_tmp44_ = orig;
					_tmp44__length1 = orig_length1;
					_tmp45_ = i;
					_tmp46_ = _tmp44_[_tmp45_];
					_tmp42_[_tmp43_] = _tmp46_;
					_tmp47_ = _tmp42_[_tmp43_];
				}
			}
		}
		_tmp48_ = dest;
		_tmp48__length1 = dest_length1;
		_tmp49_ = zcd_iserializable_deserialize (_tmp48_, _tmp48__length1, &_inner_error_);
		_tmp50_ = _tmp49_;
		if (_inner_error_ != NULL) {
			dest = (g_free (dest), NULL);
			orig = (g_free (orig), NULL);
			_g_object_unref0 (sk1);
			_g_object_unref0 (sk0);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
		_g_object_unref0 (sk1);
		sk1 = G_TYPE_CHECK_INSTANCE_CAST (_tmp50_, NETSUKUKU_TYPE_ANDNA_SERVICE_KEY, NetsukukuAndnaServiceKey);
		dest = (g_free (dest), NULL);
		orig = (g_free (orig), NULL);
	}
	_tmp51_ = sk0;
	_tmp52_ = sk1;
	_tmp53_ = netsukuku_andna_service_key_equal_func (_tmp51_, _tmp52_);
	_vala_assert (!_tmp53_, "! AndnaServiceKey.equal_func(sk0, sk1)");
	_tmp54_ = sk1;
	_tmp55_ = netsukuku_andna_service_key_to_string (_tmp54_);
	_tmp56_ = _tmp55_;
	_tmp57_ = g_strconcat ("sk1 ", _tmp56_, "\n", NULL);
	_tmp58_ = _tmp57_;
	ntk_test_print_out (_tmp58_);
	_g_free0 (_tmp58_);
	_g_free0 (_tmp56_);
	_tmp59_ = netsukuku_andna_service_key_new ("a", "b");
	sk0001 = _tmp59_;
	_tmp60_ = netsukuku_andna_service_key_new ("", "");
	sk0002 = _tmp60_;
	_tmp61_ = netsukuku_andna_service_key_new ("a", "b");
	sk0003 = _tmp61_;
	_tmp62_ = netsukuku_andna_service_key_get_NULL_SERV_KEY ();
	_tmp63_ = _tmp62_;
	_tmp64_ = _g_object_ref0 (_tmp63_);
	sk0004 = _tmp64_;
	_tmp65_ = sk0001;
	_tmp66_ = sk0003;
	_tmp67_ = netsukuku_andna_service_key_equal_func (_tmp65_, _tmp66_);
	_vala_assert (_tmp67_, "AndnaServiceKey.equal_func(sk0001, sk0003)");
	_tmp68_ = sk0001;
	_tmp69_ = sk0002;
	_tmp70_ = netsukuku_andna_service_key_equal_func (_tmp68_, _tmp69_);
	_vala_assert (!_tmp70_, "!AndnaServiceKey.equal_func(sk0001, sk0002)");
	_tmp71_ = sk0001;
	_tmp72_ = sk0004;
	_tmp73_ = netsukuku_andna_service_key_equal_func (_tmp71_, _tmp72_);
	_vala_assert (!_tmp73_, "!AndnaServiceKey.equal_func(sk0001, sk0004)");
	_tmp74_ = sk0002;
	_tmp75_ = sk0004;
	_tmp76_ = netsukuku_andna_service_key_equal_func (_tmp74_, _tmp75_);
	_vala_assert (!_tmp76_, "!AndnaServiceKey.equal_func(sk0002, sk0004)");
	_tmp77_ = sk0003;
	_tmp78_ = sk0004;
	_tmp79_ = netsukuku_andna_service_key_equal_func (_tmp77_, _tmp78_);
	_vala_assert (!_tmp79_, "!AndnaServiceKey.equal_func(sk0003, sk0004)");
	_tmp80_ = sk0001;
	_tmp82_ = zcd_iserializable_serialize ((zcdISerializable*) _tmp80_, &_tmp81_);
	_tmp83_ = _tmp82_;
	_tmp83__length1 = _tmp81_;
	_tmp84_ = zcd_iserializable_deserialize (_tmp83_, _tmp81_, &_inner_error_);
	_tmp85_ = _tmp84_;
	_tmp83_ = (g_free (_tmp83_), NULL);
	_tmp86_ = _tmp85_;
	if (_inner_error_ != NULL) {
		_g_object_unref0 (sk0004);
		_g_object_unref0 (sk0003);
		_g_object_unref0 (sk0002);
		_g_object_unref0 (sk0001);
		_g_object_unref0 (sk1);
		_g_object_unref0 (sk0);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
	sk0005 = G_TYPE_CHECK_INSTANCE_CAST (_tmp86_, NETSUKUKU_TYPE_ANDNA_SERVICE_KEY, NetsukukuAndnaServiceKey);
	_tmp87_ = sk0001;
	_tmp88_ = sk0005;
	_tmp89_ = netsukuku_andna_service_key_equal_func (_tmp87_, _tmp88_);
	_vala_assert (_tmp89_, "AndnaServiceKey.equal_func(sk0001, sk0005)");
	_g_object_unref0 (sk0005);
	_g_object_unref0 (sk0004);
	_g_object_unref0 (sk0003);
	_g_object_unref0 (sk0002);
	_g_object_unref0 (sk0001);
	_g_object_unref0 (sk1);
	_g_object_unref0 (sk0);
}


static guint8* string_get_data (const gchar* self, int* result_length1) {
	guint8* result;
	guint8* res;
	gint res_length1;
	gint _res_size_;
	gint _tmp0_;
	gint _tmp1_;
	gint _tmp2_;
	guint8* _tmp3_;
	gint _tmp3__length1;
	guint8* _tmp4_;
	gint _tmp4__length1;
	g_return_val_if_fail (self != NULL, NULL);
	res = (guint8*) self;
	res_length1 = -1;
	_res_size_ = res_length1;
	_tmp0_ = strlen (self);
	_tmp1_ = _tmp0_;
	res_length1 = (gint) _tmp1_;
	_tmp2_ = res_length1;
	_tmp3_ = res;
	_tmp3__length1 = res_length1;
	_tmp4_ = _tmp3_;
	_tmp4__length1 = _tmp3__length1;
	if (result_length1) {
		*result_length1 = _tmp4__length1;
	}
	result = _tmp4_;
	return result;
}


void ntk_test_andna_tester_test_ser_publickey (NtkTestAndnaTester* self) {
	NetsukukuPublicKey* pk0 = NULL;
	NetsukukuPublicKey* pk1 = NULL;
	NetsukukuPublicKey* _tmp50_;
	gchar* _tmp51_ = NULL;
	gchar* _tmp52_;
	gchar* _tmp53_ = NULL;
	gchar* _tmp54_;
	NetsukukuPublicKey* _tmp55_;
	NetsukukuPublicKey* _tmp56_;
	gboolean _tmp57_ = FALSE;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	{
		guchar* orig = NULL;
		gint orig_length1 = 0;
		gint _orig_size_ = 0;
		guchar* _tmp9_;
		gint _tmp9__length1;
		guchar* _tmp10_ = NULL;
		guchar* dest;
		gint dest_length1;
		gint _dest_size_;
		guchar* _tmp22_;
		gint _tmp22__length1;
		zcdISerializable* _tmp23_ = NULL;
		zcdISerializable* _tmp24_;
		{
			guint8* _tmp0_;
			gint _tmp0__length1;
			guint8* _tmp1_;
			gint _tmp1__length1;
			zcdSerializableBuffer* _tmp2_;
			zcdSerializableBuffer* _tmp3_;
			NetsukukuPublicKey* _tmp4_;
			NetsukukuPublicKey* _tmp5_;
			NetsukukuPublicKey* garbage_pk;
			NetsukukuPublicKey* _tmp6_;
			gint _tmp7_ = 0;
			guchar* _tmp8_ = NULL;
			_tmp0_ = string_get_data ("skjflvisejkrvolseuirnlvsejrnvlisuenvlsjenrivubdd" "qwsdkrjgsblieurvnlseiunrvlosienriosveirvdqvdfbdd" "kdjahriguhisdtrhsrtjruigkolgjhdsetgsjwjvn", &_tmp0__length1);
			_tmp1_ = _tmp0_;
			_tmp1__length1 = _tmp0__length1;
			_tmp2_ = zcd_serializable_buffer_new (_tmp1_, _tmp1__length1);
			_tmp3_ = _tmp2_;
			_tmp4_ = netsukuku_public_key_new (_tmp3_);
			_tmp5_ = _tmp4_;
			_g_object_unref0 (_tmp3_);
			garbage_pk = _tmp5_;
			_tmp6_ = garbage_pk;
			_tmp8_ = zcd_iserializable_serialize ((zcdISerializable*) _tmp6_, &_tmp7_);
			orig = (g_free (orig), NULL);
			orig = _tmp8_;
			orig_length1 = _tmp7_;
			_orig_size_ = orig_length1;
			_g_object_unref0 (garbage_pk);
		}
		_tmp9_ = orig;
		_tmp9__length1 = orig_length1;
		_tmp10_ = g_new0 (guchar, _tmp9__length1);
		dest = _tmp10_;
		dest_length1 = _tmp9__length1;
		_dest_size_ = dest_length1;
		{
			gint i;
			i = 0;
			{
				gboolean _tmp11_;
				_tmp11_ = TRUE;
				while (TRUE) {
					gboolean _tmp12_;
					gint _tmp14_;
					guchar* _tmp15_;
					gint _tmp15__length1;
					guchar* _tmp16_;
					gint _tmp16__length1;
					gint _tmp17_;
					guchar* _tmp18_;
					gint _tmp18__length1;
					gint _tmp19_;
					guchar _tmp20_;
					guchar _tmp21_;
					_tmp12_ = _tmp11_;
					if (!_tmp12_) {
						gint _tmp13_;
						_tmp13_ = i;
						i = _tmp13_ + 1;
					}
					_tmp11_ = FALSE;
					_tmp14_ = i;
					_tmp15_ = orig;
					_tmp15__length1 = orig_length1;
					if (!(_tmp14_ < _tmp15__length1)) {
						break;
					}
					_tmp16_ = dest;
					_tmp16__length1 = dest_length1;
					_tmp17_ = i;
					_tmp18_ = orig;
					_tmp18__length1 = orig_length1;
					_tmp19_ = i;
					_tmp20_ = _tmp18_[_tmp19_];
					_tmp16_[_tmp17_] = _tmp20_;
					_tmp21_ = _tmp16_[_tmp17_];
				}
			}
		}
		_tmp22_ = dest;
		_tmp22__length1 = dest_length1;
		_tmp23_ = zcd_iserializable_deserialize (_tmp22_, _tmp22__length1, &_inner_error_);
		_tmp24_ = _tmp23_;
		if (_inner_error_ != NULL) {
			dest = (g_free (dest), NULL);
			orig = (g_free (orig), NULL);
			_g_object_unref0 (pk0);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
		_g_object_unref0 (pk0);
		pk0 = G_TYPE_CHECK_INSTANCE_CAST (_tmp24_, NETSUKUKU_TYPE_PUBLIC_KEY, NetsukukuPublicKey);
		dest = (g_free (dest), NULL);
		orig = (g_free (orig), NULL);
	}
	{
		guchar* orig = NULL;
		gint orig_length1 = 0;
		gint _orig_size_ = 0;
		guchar* _tmp34_;
		gint _tmp34__length1;
		guchar* _tmp35_ = NULL;
		guchar* dest;
		gint dest_length1;
		gint _dest_size_;
		guchar* _tmp47_;
		gint _tmp47__length1;
		zcdISerializable* _tmp48_ = NULL;
		zcdISerializable* _tmp49_;
		{
			guint8* _tmp25_;
			gint _tmp25__length1;
			guint8* _tmp26_;
			gint _tmp26__length1;
			zcdSerializableBuffer* _tmp27_;
			zcdSerializableBuffer* _tmp28_;
			NetsukukuPublicKey* _tmp29_;
			NetsukukuPublicKey* _tmp30_;
			NetsukukuPublicKey* garbage_pk;
			NetsukukuPublicKey* _tmp31_;
			gint _tmp32_ = 0;
			guchar* _tmp33_ = NULL;
			_tmp25_ = string_get_data ("skjflvisejkrvolseuirnlvsejrnvlisuenvlsjenrivubdd" "qwsdkrjgsblieurvnlseiunrvlosienriosveirvdqvdfbdd" "kdjahriguhisdtrhsrtjruigkolgjhdsetgsjwjvn", &_tmp25__length1);
			_tmp26_ = _tmp25_;
			_tmp26__length1 = _tmp25__length1;
			_tmp27_ = zcd_serializable_buffer_new (_tmp26_, _tmp26__length1);
			_tmp28_ = _tmp27_;
			_tmp29_ = netsukuku_public_key_new (_tmp28_);
			_tmp30_ = _tmp29_;
			_g_object_unref0 (_tmp28_);
			garbage_pk = _tmp30_;
			_tmp31_ = garbage_pk;
			_tmp33_ = zcd_iserializable_serialize ((zcdISerializable*) _tmp31_, &_tmp32_);
			orig = (g_free (orig), NULL);
			orig = _tmp33_;
			orig_length1 = _tmp32_;
			_orig_size_ = orig_length1;
			_g_object_unref0 (garbage_pk);
		}
		_tmp34_ = orig;
		_tmp34__length1 = orig_length1;
		_tmp35_ = g_new0 (guchar, _tmp34__length1);
		dest = _tmp35_;
		dest_length1 = _tmp34__length1;
		_dest_size_ = dest_length1;
		{
			gint i;
			i = 0;
			{
				gboolean _tmp36_;
				_tmp36_ = TRUE;
				while (TRUE) {
					gboolean _tmp37_;
					gint _tmp39_;
					guchar* _tmp40_;
					gint _tmp40__length1;
					guchar* _tmp41_;
					gint _tmp41__length1;
					gint _tmp42_;
					guchar* _tmp43_;
					gint _tmp43__length1;
					gint _tmp44_;
					guchar _tmp45_;
					guchar _tmp46_;
					_tmp37_ = _tmp36_;
					if (!_tmp37_) {
						gint _tmp38_;
						_tmp38_ = i;
						i = _tmp38_ + 1;
					}
					_tmp36_ = FALSE;
					_tmp39_ = i;
					_tmp40_ = orig;
					_tmp40__length1 = orig_length1;
					if (!(_tmp39_ < _tmp40__length1)) {
						break;
					}
					_tmp41_ = dest;
					_tmp41__length1 = dest_length1;
					_tmp42_ = i;
					_tmp43_ = orig;
					_tmp43__length1 = orig_length1;
					_tmp44_ = i;
					_tmp45_ = _tmp43_[_tmp44_];
					_tmp41_[_tmp42_] = _tmp45_;
					_tmp46_ = _tmp41_[_tmp42_];
				}
			}
		}
		_tmp47_ = dest;
		_tmp47__length1 = dest_length1;
		_tmp48_ = zcd_iserializable_deserialize (_tmp47_, _tmp47__length1, &_inner_error_);
		_tmp49_ = _tmp48_;
		if (_inner_error_ != NULL) {
			dest = (g_free (dest), NULL);
			orig = (g_free (orig), NULL);
			_g_object_unref0 (pk1);
			_g_object_unref0 (pk0);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
		_g_object_unref0 (pk1);
		pk1 = G_TYPE_CHECK_INSTANCE_CAST (_tmp49_, NETSUKUKU_TYPE_PUBLIC_KEY, NetsukukuPublicKey);
		dest = (g_free (dest), NULL);
		orig = (g_free (orig), NULL);
	}
	_tmp50_ = pk1;
	_tmp51_ = netsukuku_public_key_to_string (_tmp50_);
	_tmp52_ = _tmp51_;
	_tmp53_ = g_strconcat ("pk1 ", _tmp52_, "\n", NULL);
	_tmp54_ = _tmp53_;
	ntk_test_print_out (_tmp54_);
	_g_free0 (_tmp54_);
	_g_free0 (_tmp52_);
	_tmp55_ = pk0;
	_tmp56_ = pk1;
	_tmp57_ = netsukuku_public_key_equal_func (_tmp55_, _tmp56_);
	_vala_assert (_tmp57_, "PublicKey.equal_func(pk0, pk1)");
	_g_object_unref0 (pk1);
	_g_object_unref0 (pk0);
}


void ntk_test_andna_tester_test_server_record_equal_func (NtkTestAndnaTester* self) {
	guint8* _tmp0_;
	gint _tmp0__length1;
	guint8* _tmp1_;
	gint _tmp1__length1;
	zcdSerializableBuffer* _tmp2_;
	zcdSerializableBuffer* _tmp3_;
	NetsukukuPublicKey* _tmp4_;
	NetsukukuPublicKey* _tmp5_;
	NetsukukuPublicKey* pk0;
	guint8* _tmp6_;
	gint _tmp6__length1;
	guint8* _tmp7_;
	gint _tmp7__length1;
	zcdSerializableBuffer* _tmp8_;
	zcdSerializableBuffer* _tmp9_;
	NetsukukuPublicKey* _tmp10_;
	NetsukukuPublicKey* _tmp11_;
	NetsukukuPublicKey* pk1;
	NetsukukuAndnaServerRecord* _tmp12_;
	NetsukukuAndnaServerRecord* sar1;
	NetsukukuPublicKey* _tmp13_;
	NetsukukuAndnaServerRecord* _tmp14_;
	NetsukukuAndnaServerRecord* sar2;
	NetsukukuPublicKey* _tmp15_;
	NetsukukuAndnaServerRecord* _tmp16_;
	NetsukukuAndnaServerRecord* sar3;
	NetsukukuAndnaServerRecord* _tmp17_;
	NetsukukuAndnaServerRecord* sar4;
	NetsukukuAndnaServerRecord* _tmp18_;
	NetsukukuAndnaServerRecord* _tmp19_;
	gboolean _tmp20_ = FALSE;
	NetsukukuAndnaServerRecord* _tmp21_;
	NetsukukuAndnaServerRecord* _tmp22_;
	gboolean _tmp23_ = FALSE;
	NetsukukuAndnaServerRecord* _tmp24_;
	NetsukukuAndnaServerRecord* _tmp25_;
	gboolean _tmp26_ = FALSE;
	NetsukukuAndnaServerRecord* _tmp27_;
	NetsukukuAndnaServerRecord* _tmp28_;
	gboolean _tmp29_ = FALSE;
	NetsukukuAndnaServerRecord* _tmp30_;
	gint _tmp31_ = 0;
	guchar* _tmp32_ = NULL;
	guchar* _tmp33_;
	gint _tmp33__length1;
	zcdISerializable* _tmp34_ = NULL;
	zcdISerializable* _tmp35_;
	zcdISerializable* _tmp36_;
	NetsukukuAndnaServerRecord* sar5;
	NetsukukuAndnaServerRecord* _tmp37_;
	NetsukukuAndnaServerRecord* _tmp38_;
	gboolean _tmp39_ = FALSE;
	NetsukukuAndnaServerRecord* _tmp40_;
	gint _tmp41_ = 0;
	guchar* _tmp42_ = NULL;
	guchar* _tmp43_;
	gint _tmp43__length1;
	zcdISerializable* _tmp44_ = NULL;
	zcdISerializable* _tmp45_;
	zcdISerializable* _tmp46_;
	NetsukukuAndnaServerRecord* sar6;
	NetsukukuAndnaServerRecord* _tmp47_;
	NetsukukuAndnaServerRecord* _tmp48_;
	gboolean _tmp49_ = FALSE;
	NetsukukuAndnaServerRecord* _tmp50_;
	NetsukukuAndnaServerRecord* sar7;
	NetsukukuAndnaServerRecord* _tmp51_;
	NetsukukuAndnaServerRecord* _tmp52_;
	gboolean _tmp53_ = FALSE;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = string_get_data ("skjflvisejkrvolseuirnlvsejrnvlisuenvlsjenrivubdd" "qwsdkrjgsblieurvnlseiunrvlosienriosveirvdqvdfbdd" "kdjahriguhisdtrhsrtjruigkolgjhdsetgsjwjvn", &_tmp0__length1);
	_tmp1_ = _tmp0_;
	_tmp1__length1 = _tmp0__length1;
	_tmp2_ = zcd_serializable_buffer_new (_tmp1_, _tmp1__length1);
	_tmp3_ = _tmp2_;
	_tmp4_ = netsukuku_public_key_new (_tmp3_);
	_tmp5_ = _tmp4_;
	_g_object_unref0 (_tmp3_);
	pk0 = _tmp5_;
	_tmp6_ = string_get_data ("skjflvisejkrvolseuirnlvsejrnvlisuenvlsjenrivubdd" "qwsdkrjgsblieurvnlseiunrvlosienriosveirvdqvdfbdd" "kdjahriguhisdtrhsrtjruigkolgjhdsetgsjwjvn", &_tmp6__length1);
	_tmp7_ = _tmp6_;
	_tmp7__length1 = _tmp6__length1;
	_tmp8_ = zcd_serializable_buffer_new (_tmp7_, _tmp7__length1);
	_tmp9_ = _tmp8_;
	_tmp10_ = netsukuku_public_key_new (_tmp9_);
	_tmp11_ = _tmp10_;
	_g_object_unref0 (_tmp9_);
	pk1 = _tmp11_;
	_tmp12_ = netsukuku_andna_server_record_new (NULL, NULL, 555, 13, 1);
	sar1 = _tmp12_;
	_tmp13_ = pk0;
	_tmp14_ = netsukuku_andna_server_record_new ("aa", _tmp13_, 21, 1, 4);
	sar2 = _tmp14_;
	_tmp15_ = pk1;
	_tmp16_ = netsukuku_andna_server_record_new ("aa", _tmp15_, 21, 1, 4);
	sar3 = _tmp16_;
	_tmp17_ = netsukuku_andna_server_record_new (NULL, NULL, 555, 13, 1);
	sar4 = _tmp17_;
	_tmp18_ = sar1;
	_tmp19_ = sar4;
	_tmp20_ = netsukuku_andna_server_record_equal_func (_tmp18_, _tmp19_);
	_vala_assert (_tmp20_, "AndnaServerRecord.equal_func(sar1, sar4)");
	_tmp21_ = sar2;
	_tmp22_ = sar3;
	_tmp23_ = netsukuku_andna_server_record_equal_func (_tmp21_, _tmp22_);
	_vala_assert (_tmp23_, "AndnaServerRecord.equal_func(sar2, sar3)");
	_tmp24_ = sar1;
	_tmp25_ = sar3;
	_tmp26_ = netsukuku_andna_server_record_equal_func (_tmp24_, _tmp25_);
	_vala_assert (!_tmp26_, "!AndnaServerRecord.equal_func(sar1, sar3)");
	_tmp27_ = sar2;
	_tmp28_ = sar4;
	_tmp29_ = netsukuku_andna_server_record_equal_func (_tmp27_, _tmp28_);
	_vala_assert (!_tmp29_, "!AndnaServerRecord.equal_func(sar2, sar4)");
	_tmp30_ = sar1;
	_tmp32_ = zcd_iserializable_serialize ((zcdISerializable*) _tmp30_, &_tmp31_);
	_tmp33_ = _tmp32_;
	_tmp33__length1 = _tmp31_;
	_tmp34_ = zcd_iserializable_deserialize (_tmp33_, _tmp31_, &_inner_error_);
	_tmp35_ = _tmp34_;
	_tmp33_ = (g_free (_tmp33_), NULL);
	_tmp36_ = _tmp35_;
	if (_inner_error_ != NULL) {
		_g_object_unref0 (sar4);
		_g_object_unref0 (sar3);
		_g_object_unref0 (sar2);
		_g_object_unref0 (sar1);
		_g_object_unref0 (pk1);
		_g_object_unref0 (pk0);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
	sar5 = G_TYPE_CHECK_INSTANCE_CAST (_tmp36_, NETSUKUKU_TYPE_ANDNA_SERVER_RECORD, NetsukukuAndnaServerRecord);
	_tmp37_ = sar1;
	_tmp38_ = sar5;
	_tmp39_ = netsukuku_andna_server_record_equal_func (_tmp37_, _tmp38_);
	_vala_assert (_tmp39_, "AndnaServerRecord.equal_func(sar1, sar5)");
	_tmp40_ = sar2;
	_tmp42_ = zcd_iserializable_serialize ((zcdISerializable*) _tmp40_, &_tmp41_);
	_tmp43_ = _tmp42_;
	_tmp43__length1 = _tmp41_;
	_tmp44_ = zcd_iserializable_deserialize (_tmp43_, _tmp41_, &_inner_error_);
	_tmp45_ = _tmp44_;
	_tmp43_ = (g_free (_tmp43_), NULL);
	_tmp46_ = _tmp45_;
	if (_inner_error_ != NULL) {
		_g_object_unref0 (sar5);
		_g_object_unref0 (sar4);
		_g_object_unref0 (sar3);
		_g_object_unref0 (sar2);
		_g_object_unref0 (sar1);
		_g_object_unref0 (pk1);
		_g_object_unref0 (pk0);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
	sar6 = G_TYPE_CHECK_INSTANCE_CAST (_tmp46_, NETSUKUKU_TYPE_ANDNA_SERVER_RECORD, NetsukukuAndnaServerRecord);
	_tmp47_ = sar3;
	_tmp48_ = sar6;
	_tmp49_ = netsukuku_andna_server_record_equal_func (_tmp47_, _tmp48_);
	_vala_assert (_tmp49_, "AndnaServerRecord.equal_func(sar3, sar6)");
	_tmp50_ = netsukuku_andna_server_record_new (NULL, NULL, 22, 13, 1);
	sar7 = _tmp50_;
	_tmp51_ = sar7;
	_tmp52_ = sar4;
	_tmp53_ = netsukuku_andna_server_record_equal_func (_tmp51_, _tmp52_);
	_vala_assert (!_tmp53_, "!AndnaServerRecord.equal_func(sar7, sar4)");
	_g_object_unref0 (sar7);
	_g_object_unref0 (sar6);
	_g_object_unref0 (sar5);
	_g_object_unref0 (sar4);
	_g_object_unref0 (sar3);
	_g_object_unref0 (sar2);
	_g_object_unref0 (sar1);
	_g_object_unref0 (pk1);
	_g_object_unref0 (pk0);
}


static gboolean _netsukuku_andna_server_record_equal_func_gee_equal_data_func (gconstpointer a, gconstpointer b, gpointer self) {
	gboolean result;
	result = netsukuku_andna_server_record_equal_func (a, b);
	return result;
}


static guint _netsukuku_andna_service_key_hash_func_gee_hash_data_func (gconstpointer v, gpointer self) {
	guint result;
	result = netsukuku_andna_service_key_hash_func (v);
	return result;
}


static gboolean _netsukuku_andna_service_key_equal_func_gee_equal_data_func (gconstpointer a, gconstpointer b, gpointer self) {
	gboolean result;
	result = netsukuku_andna_service_key_equal_func (a, b);
	return result;
}


void ntk_test_andna_tester_test_ser_domain_record (NtkTestAndnaTester* self) {
	NetsukukuAndnaServers* servers = NULL;
	NetsukukuAndnaServers* _tmp232_;
	NetsukukuTimeCapsule* _tmp233_;
	NetsukukuTimeCapsule* _tmp234_;
	gboolean _tmp235_ = FALSE;
	gboolean found1;
	gboolean found2;
	gboolean _tmp273_;
	gboolean _tmp274_;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	{
		zcdISerializable* i0 = NULL;
		zcdISerializable* _tmp64_;
		NetsukukuAndnaDomainRecord* _tmp65_;
		NetsukukuAndnaDomainRecord* another;
		NetsukukuAndnaDomainRecord* _tmp66_;
		gchar* _tmp67_ = NULL;
		gchar* _tmp68_;
		gchar* _tmp69_ = NULL;
		gchar* _tmp70_;
		{
			guchar* orig = NULL;
			gint orig_length1 = 0;
			gint _orig_size_ = 0;
			guchar* _tmp48_;
			gint _tmp48__length1;
			guchar* _tmp49_ = NULL;
			guchar* dest;
			gint dest_length1;
			gint _dest_size_;
			guchar* _tmp61_;
			gint _tmp61__length1;
			zcdISerializable* _tmp62_ = NULL;
			zcdISerializable* _tmp63_;
			{
				guint8* _tmp0_;
				gint _tmp0__length1;
				guint8* _tmp1_;
				gint _tmp1__length1;
				zcdSerializableBuffer* _tmp2_;
				zcdSerializableBuffer* _tmp3_;
				NetsukukuPublicKey* _tmp4_;
				NetsukukuPublicKey* _tmp5_;
				NetsukukuPublicKey* alice_pub;
				NetsukukuAndnaServerRecord* _tmp6_;
				NetsukukuAndnaServerRecord* rebelfreedom_1;
				NetsukukuPublicKey* _tmp7_;
				NetsukukuAndnaServerRecord* _tmp8_;
				NetsukukuAndnaServerRecord* rebelfreedom_2;
				GeeArrayList* _tmp9_;
				GeeArrayList* lst_alice_rebel;
				GeeArrayList* _tmp10_;
				NetsukukuAndnaServerRecord* _tmp11_;
				GeeArrayList* _tmp12_;
				NetsukukuAndnaServerRecord* _tmp13_;
				NetsukukuPublicKey* _tmp14_;
				NetsukukuAndnaServerRecord* _tmp15_;
				NetsukukuAndnaServerRecord* webfreedom_1;
				NetsukukuAndnaServerRecord* _tmp16_;
				NetsukukuAndnaServerRecord* webfreedom_2;
				GeeArrayList* _tmp17_;
				GeeArrayList* lst_alice_web;
				GeeArrayList* _tmp18_;
				NetsukukuAndnaServerRecord* _tmp19_;
				GeeArrayList* _tmp20_;
				NetsukukuAndnaServerRecord* _tmp21_;
				GeeHashMap* _tmp22_;
				GeeHashMap* alice_services;
				GeeHashMap* _tmp23_;
				NetsukukuAndnaServiceKey* _tmp24_;
				NetsukukuAndnaServiceKey* _tmp25_;
				GeeArrayList* _tmp26_;
				GeeHashMap* _tmp27_;
				NetsukukuAndnaServiceKey* _tmp28_;
				NetsukukuAndnaServiceKey* _tmp29_;
				GeeArrayList* _tmp30_;
				gint64 _tmp31_;
				NetsukukuPublicKey* _tmp32_;
				gint* _tmp33_ = NULL;
				gint* _tmp34_;
				gint _tmp34__length1;
				NetsukukuNIP* _tmp35_;
				NetsukukuNIP* _tmp36_;
				GeeHashMap* _tmp37_;
				NetsukukuAndnaDomainRecord* _tmp38_;
				NetsukukuAndnaDomainRecord* _tmp39_;
				NetsukukuAndnaDomainRecord* arec;
				NetsukukuAndnaDomainRecord* _tmp40_;
				gchar* _tmp41_ = NULL;
				gchar* _tmp42_;
				gchar* _tmp43_ = NULL;
				gchar* _tmp44_;
				NetsukukuAndnaDomainRecord* _tmp45_;
				gint _tmp46_ = 0;
				guchar* _tmp47_ = NULL;
				_tmp0_ = string_get_data ("qwertyioplkjhgfdszxvbnmmedcjikmurgbvisindqweejfifvdvdfbdd" "kdjahriguhiluvhiukijebkuianlsjnvwopijwkmnvosidjjvn", &_tmp0__length1);
				_tmp1_ = _tmp0_;
				_tmp1__length1 = _tmp0__length1;
				_tmp2_ = zcd_serializable_buffer_new (_tmp1_, _tmp1__length1);
				_tmp3_ = _tmp2_;
				_tmp4_ = netsukuku_public_key_new (_tmp3_);
				_tmp5_ = _tmp4_;
				_g_object_unref0 (_tmp3_);
				alice_pub = _tmp5_;
				_tmp6_ = netsukuku_andna_server_record_new (NULL, NULL, 555, 13, 1);
				rebelfreedom_1 = _tmp6_;
				_tmp7_ = alice_pub;
				_tmp8_ = netsukuku_andna_server_record_new ("aa", _tmp7_, 21, 1, 4);
				rebelfreedom_2 = _tmp8_;
				_tmp9_ = gee_array_list_new (NETSUKUKU_TYPE_ANDNA_SERVER_RECORD, (GBoxedCopyFunc) g_object_ref, g_object_unref, _netsukuku_andna_server_record_equal_func_gee_equal_data_func, NULL, NULL);
				lst_alice_rebel = _tmp9_;
				_tmp10_ = lst_alice_rebel;
				_tmp11_ = rebelfreedom_1;
				gee_abstract_collection_add ((GeeAbstractCollection*) _tmp10_, _tmp11_);
				_tmp12_ = lst_alice_rebel;
				_tmp13_ = rebelfreedom_2;
				gee_abstract_collection_add ((GeeAbstractCollection*) _tmp12_, _tmp13_);
				_tmp14_ = alice_pub;
				_tmp15_ = netsukuku_andna_server_record_new ("aa", _tmp14_, 222, 13, 1);
				webfreedom_1 = _tmp15_;
				_tmp16_ = netsukuku_andna_server_record_new (NULL, NULL, 333, 1, 4);
				webfreedom_2 = _tmp16_;
				_tmp17_ = gee_array_list_new (NETSUKUKU_TYPE_ANDNA_SERVER_RECORD, (GBoxedCopyFunc) g_object_ref, g_object_unref, _netsukuku_andna_server_record_equal_func_gee_equal_data_func, NULL, NULL);
				lst_alice_web = _tmp17_;
				_tmp18_ = lst_alice_web;
				_tmp19_ = webfreedom_1;
				gee_abstract_collection_add ((GeeAbstractCollection*) _tmp18_, _tmp19_);
				_tmp20_ = lst_alice_web;
				_tmp21_ = webfreedom_2;
				gee_abstract_collection_add ((GeeAbstractCollection*) _tmp20_, _tmp21_);
				_tmp22_ = gee_hash_map_new (NETSUKUKU_TYPE_ANDNA_SERVICE_KEY, (GBoxedCopyFunc) g_object_ref, g_object_unref, GEE_TYPE_ARRAY_LIST, (GBoxedCopyFunc) g_object_ref, g_object_unref, _netsukuku_andna_service_key_hash_func_gee_hash_data_func, NULL, NULL, _netsukuku_andna_service_key_equal_func_gee_equal_data_func, NULL, NULL, NULL, NULL, NULL);
				alice_services = _tmp22_;
				_tmp23_ = alice_services;
				_tmp24_ = netsukuku_andna_service_key_new ("rebel", "tcp");
				_tmp25_ = _tmp24_;
				_tmp26_ = lst_alice_rebel;
				gee_abstract_map_set ((GeeAbstractMap*) _tmp23_, _tmp25_, _tmp26_);
				_g_object_unref0 (_tmp25_);
				_tmp27_ = alice_services;
				_tmp28_ = netsukuku_andna_service_key_new ("web", "tcp");
				_tmp29_ = _tmp28_;
				_tmp30_ = lst_alice_web;
				gee_abstract_map_set ((GeeAbstractMap*) _tmp27_, _tmp29_, _tmp30_);
				_g_object_unref0 (_tmp29_);
				_tmp31_ = netsukuku_andna_const_MAX_TTL_ANDNA;
				_tmp32_ = alice_pub;
				_tmp33_ = g_new0 (gint, 4);
				_tmp33_[0] = 1;
				_tmp33_[1] = 2;
				_tmp33_[2] = 3;
				_tmp33_[3] = 4;
				_tmp34_ = _tmp33_;
				_tmp34__length1 = 4;
				_tmp35_ = netsukuku_nip_new (_tmp34_, 4);
				_tmp36_ = _tmp35_;
				_tmp37_ = alice_services;
				_tmp38_ = netsukuku_andna_domain_record_new (_tmp31_, "freedom.riot", _tmp32_, _tmp36_, _tmp37_);
				_tmp39_ = _tmp38_;
				_g_object_unref0 (_tmp36_);
				_tmp34_ = (g_free (_tmp34_), NULL);
				arec = _tmp39_;
				_tmp40_ = arec;
				_tmp41_ = netsukuku_andna_domain_record_to_string (_tmp40_);
				_tmp42_ = _tmp41_;
				_tmp43_ = g_strconcat ("arec ", _tmp42_, "\n", NULL);
				_tmp44_ = _tmp43_;
				ntk_test_print_out (_tmp44_);
				_g_free0 (_tmp44_);
				_g_free0 (_tmp42_);
				_tmp45_ = arec;
				_tmp47_ = zcd_iserializable_serialize ((zcdISerializable*) _tmp45_, &_tmp46_);
				orig = (g_free (orig), NULL);
				orig = _tmp47_;
				orig_length1 = _tmp46_;
				_orig_size_ = orig_length1;
				_g_object_unref0 (arec);
				_g_object_unref0 (alice_services);
				_g_object_unref0 (lst_alice_web);
				_g_object_unref0 (webfreedom_2);
				_g_object_unref0 (webfreedom_1);
				_g_object_unref0 (lst_alice_rebel);
				_g_object_unref0 (rebelfreedom_2);
				_g_object_unref0 (rebelfreedom_1);
				_g_object_unref0 (alice_pub);
			}
			_tmp48_ = orig;
			_tmp48__length1 = orig_length1;
			_tmp49_ = g_new0 (guchar, _tmp48__length1);
			dest = _tmp49_;
			dest_length1 = _tmp48__length1;
			_dest_size_ = dest_length1;
			{
				gint i;
				i = 0;
				{
					gboolean _tmp50_;
					_tmp50_ = TRUE;
					while (TRUE) {
						gboolean _tmp51_;
						gint _tmp53_;
						guchar* _tmp54_;
						gint _tmp54__length1;
						guchar* _tmp55_;
						gint _tmp55__length1;
						gint _tmp56_;
						guchar* _tmp57_;
						gint _tmp57__length1;
						gint _tmp58_;
						guchar _tmp59_;
						guchar _tmp60_;
						_tmp51_ = _tmp50_;
						if (!_tmp51_) {
							gint _tmp52_;
							_tmp52_ = i;
							i = _tmp52_ + 1;
						}
						_tmp50_ = FALSE;
						_tmp53_ = i;
						_tmp54_ = orig;
						_tmp54__length1 = orig_length1;
						if (!(_tmp53_ < _tmp54__length1)) {
							break;
						}
						_tmp55_ = dest;
						_tmp55__length1 = dest_length1;
						_tmp56_ = i;
						_tmp57_ = orig;
						_tmp57__length1 = orig_length1;
						_tmp58_ = i;
						_tmp59_ = _tmp57_[_tmp58_];
						_tmp55_[_tmp56_] = _tmp59_;
						_tmp60_ = _tmp55_[_tmp56_];
					}
				}
			}
			_tmp61_ = dest;
			_tmp61__length1 = dest_length1;
			_tmp62_ = zcd_iserializable_deserialize (_tmp61_, _tmp61__length1, &_inner_error_);
			_tmp63_ = _tmp62_;
			if (_inner_error_ != NULL) {
				dest = (g_free (dest), NULL);
				orig = (g_free (orig), NULL);
				_g_object_unref0 (i0);
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return;
			}
			_g_object_unref0 (i0);
			i0 = _tmp63_;
			dest = (g_free (dest), NULL);
			orig = (g_free (orig), NULL);
		}
		_tmp64_ = i0;
		_tmp65_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp64_, NETSUKUKU_TYPE_ANDNA_DOMAIN_RECORD, NetsukukuAndnaDomainRecord));
		another = _tmp65_;
		_tmp66_ = another;
		_tmp67_ = netsukuku_andna_domain_record_to_string (_tmp66_);
		_tmp68_ = _tmp67_;
		_tmp69_ = g_strconcat ("another ", _tmp68_, "\n", NULL);
		_tmp70_ = _tmp69_;
		ntk_test_print_out (_tmp70_);
		_g_free0 (_tmp70_);
		_g_free0 (_tmp68_);
		_g_object_unref0 (another);
		_g_object_unref0 (i0);
	}
	{
		guchar* orig2 = NULL;
		gint orig2_length1 = 0;
		gint _orig2_size_ = 0;
		guchar* _tmp216_;
		gint _tmp216__length1;
		guchar* _tmp217_ = NULL;
		guchar* dest2;
		gint dest2_length1;
		gint _dest2_size_;
		guchar* _tmp229_;
		gint _tmp229__length1;
		zcdISerializable* _tmp230_ = NULL;
		zcdISerializable* _tmp231_;
		{
			NetsukukuAndnaDomainRecord* arec = NULL;
			NetsukukuAndnaDomainRecord* _tmp153_;
			gchar* _tmp154_ = NULL;
			gchar* _tmp155_;
			gchar* _tmp156_ = NULL;
			gchar* _tmp157_;
			NetsukukuAndnaDomainRecord* _tmp158_;
			const gchar* _tmp159_;
			const gchar* _tmp160_;
			NetsukukuAndnaDomainRecord* _tmp161_;
			NetsukukuTimeCapsule* _tmp162_;
			NetsukukuTimeCapsule* _tmp163_;
			gboolean _tmp164_ = FALSE;
			NetsukukuAndnaDomainRecord* _tmp165_;
			NetsukukuAndnaServiceKey* _tmp166_;
			NetsukukuAndnaServiceKey* _tmp167_;
			NetsukukuAndnaServers* _tmp168_ = NULL;
			NetsukukuAndnaServers* _tmp169_;
			NetsukukuAndnaServers* in_servers;
			NetsukukuAndnaServers* _tmp170_;
			NetsukukuTimeCapsule* _tmp171_;
			NetsukukuTimeCapsule* _tmp172_;
			gboolean _tmp173_ = FALSE;
			gboolean in_found1;
			gboolean in_found2;
			gboolean _tmp211_;
			gboolean _tmp212_;
			NetsukukuAndnaServers* _tmp213_;
			gint _tmp214_ = 0;
			guchar* _tmp215_ = NULL;
			{
				guchar* orig = NULL;
				gint orig_length1 = 0;
				gint _orig_size_ = 0;
				guchar* _tmp137_;
				gint _tmp137__length1;
				guchar* _tmp138_ = NULL;
				guchar* dest;
				gint dest_length1;
				gint _dest_size_;
				guchar* _tmp150_;
				gint _tmp150__length1;
				zcdISerializable* _tmp151_ = NULL;
				zcdISerializable* _tmp152_;
				{
					guint8* _tmp71_;
					gint _tmp71__length1;
					guint8* _tmp72_;
					gint _tmp72__length1;
					zcdSerializableBuffer* _tmp73_;
					zcdSerializableBuffer* _tmp74_;
					NetsukukuPublicKey* _tmp75_;
					NetsukukuPublicKey* _tmp76_;
					NetsukukuPublicKey* alice_pub;
					gint* _tmp77_ = NULL;
					gint* _tmp78_;
					gint _tmp78__length1;
					NetsukukuNIP* _tmp79_;
					NetsukukuNIP* _tmp80_;
					NetsukukuNIP* alice_nip;
					guint8* _tmp81_;
					gint _tmp81__length1;
					guint8* _tmp82_;
					gint _tmp82__length1;
					zcdSerializableBuffer* _tmp83_;
					zcdSerializableBuffer* _tmp84_;
					NetsukukuPublicKey* _tmp85_;
					NetsukukuPublicKey* _tmp86_;
					NetsukukuPublicKey* bob_pub;
					gint* _tmp87_ = NULL;
					gint* _tmp88_;
					gint _tmp88__length1;
					NetsukukuNIP* _tmp89_;
					NetsukukuNIP* _tmp90_;
					NetsukukuNIP* bob_nip;
					NetsukukuPublicKey* _tmp91_;
					NetsukukuPublicKey* _tmp92_;
					gboolean _tmp93_ = FALSE;
					NetsukukuAndnaServerRecord* _tmp94_;
					NetsukukuAndnaServerRecord* defaultfreedom;
					GeeArrayList* _tmp95_;
					GeeArrayList* lst_alice_default;
					GeeArrayList* _tmp96_;
					NetsukukuAndnaServerRecord* _tmp97_;
					NetsukukuPublicKey* _tmp98_;
					NetsukukuAndnaServerRecord* _tmp99_;
					NetsukukuAndnaServerRecord* webfreedom;
					GeeArrayList* _tmp100_;
					GeeArrayList* lst_alice_web;
					GeeArrayList* _tmp101_;
					NetsukukuAndnaServerRecord* _tmp102_;
					NetsukukuAndnaServerRecord* _tmp103_;
					NetsukukuAndnaServerRecord* rebelfreedom_1;
					NetsukukuPublicKey* _tmp104_;
					NetsukukuAndnaServerRecord* _tmp105_;
					NetsukukuAndnaServerRecord* rebelfreedom_2;
					GeeArrayList* _tmp106_;
					GeeArrayList* lst_alice_rebel;
					GeeArrayList* _tmp107_;
					NetsukukuAndnaServerRecord* _tmp108_;
					GeeArrayList* _tmp109_;
					NetsukukuAndnaServerRecord* _tmp110_;
					GeeHashMap* _tmp111_;
					GeeHashMap* alice_services;
					GeeHashMap* _tmp112_;
					NetsukukuAndnaServiceKey* _tmp113_;
					NetsukukuAndnaServiceKey* _tmp114_;
					GeeArrayList* _tmp115_;
					GeeHashMap* _tmp116_;
					NetsukukuAndnaServiceKey* _tmp117_;
					NetsukukuAndnaServiceKey* _tmp118_;
					GeeArrayList* _tmp119_;
					GeeHashMap* _tmp120_;
					NetsukukuAndnaServiceKey* _tmp121_;
					NetsukukuAndnaServiceKey* _tmp122_;
					GeeArrayList* _tmp123_;
					gint64 _tmp124_;
					NetsukukuPublicKey* _tmp125_;
					NetsukukuNIP* _tmp126_;
					GeeHashMap* _tmp127_;
					NetsukukuAndnaDomainRecord* _tmp128_;
					NetsukukuAndnaDomainRecord* freedomriot;
					NetsukukuAndnaDomainRecord* _tmp129_;
					gchar* _tmp130_ = NULL;
					gchar* _tmp131_;
					gchar* _tmp132_ = NULL;
					gchar* _tmp133_;
					NetsukukuAndnaDomainRecord* _tmp134_;
					gint _tmp135_ = 0;
					guchar* _tmp136_ = NULL;
					_tmp71_ = string_get_data ("qwertyioplkjhgfdszxvbnmmedcjikmurgbvisindqweejfifvdvdfbdd" "kdjahriguhiluvhiukijebkuianlsjnvwopijwkmnvosidjjvn", &_tmp71__length1);
					_tmp72_ = _tmp71_;
					_tmp72__length1 = _tmp71__length1;
					_tmp73_ = zcd_serializable_buffer_new (_tmp72_, _tmp72__length1);
					_tmp74_ = _tmp73_;
					_tmp75_ = netsukuku_public_key_new (_tmp74_);
					_tmp76_ = _tmp75_;
					_g_object_unref0 (_tmp74_);
					alice_pub = _tmp76_;
					_tmp77_ = g_new0 (gint, 4);
					_tmp77_[0] = 1;
					_tmp77_[1] = 0;
					_tmp77_[2] = 3;
					_tmp77_[3] = 2;
					_tmp78_ = _tmp77_;
					_tmp78__length1 = 4;
					_tmp79_ = netsukuku_nip_new (_tmp78_, 4);
					_tmp80_ = _tmp79_;
					_tmp78_ = (g_free (_tmp78_), NULL);
					alice_nip = _tmp80_;
					_tmp81_ = string_get_data ("jdfiwrjlieurvhkisejroaiuwnlcsinceujvnjkdfvbkiseubrvsjihbr" "kjdsbklajwerblviuaenlvksjhgfsjhgfkbvkjdsrlujerlivu", &_tmp81__length1);
					_tmp82_ = _tmp81_;
					_tmp82__length1 = _tmp81__length1;
					_tmp83_ = zcd_serializable_buffer_new (_tmp82_, _tmp82__length1);
					_tmp84_ = _tmp83_;
					_tmp85_ = netsukuku_public_key_new (_tmp84_);
					_tmp86_ = _tmp85_;
					_g_object_unref0 (_tmp84_);
					bob_pub = _tmp86_;
					_tmp87_ = g_new0 (gint, 4);
					_tmp87_[0] = 1;
					_tmp87_[1] = 0;
					_tmp87_[2] = 2;
					_tmp87_[3] = 1;
					_tmp88_ = _tmp87_;
					_tmp88__length1 = 4;
					_tmp89_ = netsukuku_nip_new (_tmp88_, 4);
					_tmp90_ = _tmp89_;
					_tmp88_ = (g_free (_tmp88_), NULL);
					bob_nip = _tmp90_;
					_tmp91_ = alice_pub;
					_tmp92_ = bob_pub;
					_tmp93_ = netsukuku_public_key_equal_func (_tmp91_, _tmp92_);
					_vala_assert (!_tmp93_, "! PublicKey.equal_func(alice_pub, bob_pub)");
					_tmp94_ = netsukuku_andna_server_record_new (NULL, NULL, 1, 1, 1);
					defaultfreedom = _tmp94_;
					_tmp95_ = gee_array_list_new (NETSUKUKU_TYPE_ANDNA_SERVER_RECORD, (GBoxedCopyFunc) g_object_ref, g_object_unref, _netsukuku_andna_server_record_equal_func_gee_equal_data_func, NULL, NULL);
					lst_alice_default = _tmp95_;
					_tmp96_ = lst_alice_default;
					_tmp97_ = defaultfreedom;
					gee_abstract_collection_add ((GeeAbstractCollection*) _tmp96_, _tmp97_);
					_tmp98_ = bob_pub;
					_tmp99_ = netsukuku_andna_server_record_new ("business.biz", _tmp98_, 123, 1, 1);
					webfreedom = _tmp99_;
					_tmp100_ = gee_array_list_new (NETSUKUKU_TYPE_ANDNA_SERVER_RECORD, (GBoxedCopyFunc) g_object_ref, g_object_unref, _netsukuku_andna_server_record_equal_func_gee_equal_data_func, NULL, NULL);
					lst_alice_web = _tmp100_;
					_tmp101_ = lst_alice_web;
					_tmp102_ = webfreedom;
					gee_abstract_collection_add ((GeeAbstractCollection*) _tmp101_, _tmp102_);
					_tmp103_ = netsukuku_andna_server_record_new (NULL, NULL, 555, 1, 10);
					rebelfreedom_1 = _tmp103_;
					_tmp104_ = bob_pub;
					_tmp105_ = netsukuku_andna_server_record_new ("business.biz", _tmp104_, 1055, 1, 20);
					rebelfreedom_2 = _tmp105_;
					_tmp106_ = gee_array_list_new (NETSUKUKU_TYPE_ANDNA_SERVER_RECORD, (GBoxedCopyFunc) g_object_ref, g_object_unref, _netsukuku_andna_server_record_equal_func_gee_equal_data_func, NULL, NULL);
					lst_alice_rebel = _tmp106_;
					_tmp107_ = lst_alice_rebel;
					_tmp108_ = rebelfreedom_1;
					gee_abstract_collection_add ((GeeAbstractCollection*) _tmp107_, _tmp108_);
					_tmp109_ = lst_alice_rebel;
					_tmp110_ = rebelfreedom_2;
					gee_abstract_collection_add ((GeeAbstractCollection*) _tmp109_, _tmp110_);
					_tmp111_ = gee_hash_map_new (NETSUKUKU_TYPE_ANDNA_SERVICE_KEY, (GBoxedCopyFunc) g_object_ref, g_object_unref, GEE_TYPE_ARRAY_LIST, (GBoxedCopyFunc) g_object_ref, g_object_unref, _netsukuku_andna_service_key_hash_func_gee_hash_data_func, NULL, NULL, _netsukuku_andna_service_key_equal_func_gee_equal_data_func, NULL, NULL, NULL, NULL, NULL);
					alice_services = _tmp111_;
					_tmp112_ = alice_services;
					_tmp113_ = netsukuku_andna_service_key_get_NULL_SERV_KEY ();
					_tmp114_ = _tmp113_;
					_tmp115_ = lst_alice_default;
					gee_abstract_map_set ((GeeAbstractMap*) _tmp112_, _tmp114_, _tmp115_);
					_tmp116_ = alice_services;
					_tmp117_ = netsukuku_andna_service_key_new ("www", "tcp");
					_tmp118_ = _tmp117_;
					_tmp119_ = lst_alice_web;
					gee_abstract_map_set ((GeeAbstractMap*) _tmp116_, _tmp118_, _tmp119_);
					_g_object_unref0 (_tmp118_);
					_tmp120_ = alice_services;
					_tmp121_ = netsukuku_andna_service_key_new ("rebelgame", "udp");
					_tmp122_ = _tmp121_;
					_tmp123_ = lst_alice_rebel;
					gee_abstract_map_set ((GeeAbstractMap*) _tmp120_, _tmp122_, _tmp123_);
					_g_object_unref0 (_tmp122_);
					_tmp124_ = netsukuku_andna_const_MAX_TTL_ANDNA;
					_tmp125_ = alice_pub;
					_tmp126_ = alice_nip;
					_tmp127_ = alice_services;
					_tmp128_ = netsukuku_andna_domain_record_new (_tmp124_, "freedom.riot", _tmp125_, _tmp126_, _tmp127_);
					freedomriot = _tmp128_;
					_tmp129_ = freedomriot;
					_tmp130_ = netsukuku_andna_domain_record_to_string (_tmp129_);
					_tmp131_ = _tmp130_;
					_tmp132_ = g_strconcat ("freedomriot ", _tmp131_, "\n", NULL);
					_tmp133_ = _tmp132_;
					ntk_test_print_out (_tmp133_);
					_g_free0 (_tmp133_);
					_g_free0 (_tmp131_);
					_tmp134_ = freedomriot;
					_tmp136_ = zcd_iserializable_serialize ((zcdISerializable*) _tmp134_, &_tmp135_);
					orig = (g_free (orig), NULL);
					orig = _tmp136_;
					orig_length1 = _tmp135_;
					_orig_size_ = orig_length1;
					_g_object_unref0 (freedomriot);
					_g_object_unref0 (alice_services);
					_g_object_unref0 (lst_alice_rebel);
					_g_object_unref0 (rebelfreedom_2);
					_g_object_unref0 (rebelfreedom_1);
					_g_object_unref0 (lst_alice_web);
					_g_object_unref0 (webfreedom);
					_g_object_unref0 (lst_alice_default);
					_g_object_unref0 (defaultfreedom);
					_g_object_unref0 (bob_nip);
					_g_object_unref0 (bob_pub);
					_g_object_unref0 (alice_nip);
					_g_object_unref0 (alice_pub);
				}
				_tmp137_ = orig;
				_tmp137__length1 = orig_length1;
				_tmp138_ = g_new0 (guchar, _tmp137__length1);
				dest = _tmp138_;
				dest_length1 = _tmp137__length1;
				_dest_size_ = dest_length1;
				{
					gint i;
					i = 0;
					{
						gboolean _tmp139_;
						_tmp139_ = TRUE;
						while (TRUE) {
							gboolean _tmp140_;
							gint _tmp142_;
							guchar* _tmp143_;
							gint _tmp143__length1;
							guchar* _tmp144_;
							gint _tmp144__length1;
							gint _tmp145_;
							guchar* _tmp146_;
							gint _tmp146__length1;
							gint _tmp147_;
							guchar _tmp148_;
							guchar _tmp149_;
							_tmp140_ = _tmp139_;
							if (!_tmp140_) {
								gint _tmp141_;
								_tmp141_ = i;
								i = _tmp141_ + 1;
							}
							_tmp139_ = FALSE;
							_tmp142_ = i;
							_tmp143_ = orig;
							_tmp143__length1 = orig_length1;
							if (!(_tmp142_ < _tmp143__length1)) {
								break;
							}
							_tmp144_ = dest;
							_tmp144__length1 = dest_length1;
							_tmp145_ = i;
							_tmp146_ = orig;
							_tmp146__length1 = orig_length1;
							_tmp147_ = i;
							_tmp148_ = _tmp146_[_tmp147_];
							_tmp144_[_tmp145_] = _tmp148_;
							_tmp149_ = _tmp144_[_tmp145_];
						}
					}
				}
				_tmp150_ = dest;
				_tmp150__length1 = dest_length1;
				_tmp151_ = zcd_iserializable_deserialize (_tmp150_, _tmp150__length1, &_inner_error_);
				_tmp152_ = _tmp151_;
				if (_inner_error_ != NULL) {
					dest = (g_free (dest), NULL);
					orig = (g_free (orig), NULL);
					_g_object_unref0 (arec);
					orig2 = (g_free (orig2), NULL);
					_g_object_unref0 (servers);
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
					g_clear_error (&_inner_error_);
					return;
				}
				_g_object_unref0 (arec);
				arec = G_TYPE_CHECK_INSTANCE_CAST (_tmp152_, NETSUKUKU_TYPE_ANDNA_DOMAIN_RECORD, NetsukukuAndnaDomainRecord);
				dest = (g_free (dest), NULL);
				orig = (g_free (orig), NULL);
			}
			_tmp153_ = arec;
			_tmp154_ = netsukuku_andna_domain_record_to_string (_tmp153_);
			_tmp155_ = _tmp154_;
			_tmp156_ = g_strconcat ("arec ", _tmp155_, "\n", NULL);
			_tmp157_ = _tmp156_;
			ntk_test_print_out (_tmp157_);
			_g_free0 (_tmp157_);
			_g_free0 (_tmp155_);
			_tmp158_ = arec;
			_tmp159_ = netsukuku_andna_domain_record_get_hashed_domain (_tmp158_);
			_tmp160_ = _tmp159_;
			_vala_assert (g_strcmp0 (_tmp160_, "freedom.riot") == 0, "arec.hashed_domain == \"freedom.riot\"");
			_tmp161_ = arec;
			_tmp162_ = netsukuku_andna_domain_record_get_expires (_tmp161_);
			_tmp163_ = _tmp162_;
			_tmp164_ = tasklets_timer_is_expired ((TaskletsTimer*) _tmp163_);
			_vala_assert (!_tmp164_, "!arec.expires.is_expired()");
			_tmp165_ = arec;
			_tmp166_ = netsukuku_andna_service_key_new ("rebelgame", "udp");
			_tmp167_ = _tmp166_;
			_tmp168_ = netsukuku_andna_domain_record_get_servers (_tmp165_, _tmp167_);
			_tmp169_ = _tmp168_;
			_g_object_unref0 (_tmp167_);
			in_servers = _tmp169_;
			_tmp170_ = in_servers;
			_tmp171_ = netsukuku_andna_servers_get_expires (_tmp170_);
			_tmp172_ = _tmp171_;
			_tmp173_ = tasklets_timer_is_expired ((TaskletsTimer*) _tmp172_);
			_vala_assert (!_tmp173_, "!in_servers.expires.is_expired()");
			in_found1 = FALSE;
			in_found2 = FALSE;
			{
				NetsukukuAndnaServers* _tmp174_;
				GeeList* _tmp175_;
				GeeList* _tmp176_;
				GeeList* _tmp177_;
				GeeList* _srv_list;
				GeeList* _tmp178_;
				gint _tmp179_;
				gint _tmp180_;
				gint _srv_size;
				gint _srv_index;
				_tmp174_ = in_servers;
				_tmp175_ = netsukuku_andna_servers_get_servers (_tmp174_);
				_tmp176_ = _tmp175_;
				_tmp177_ = _g_object_ref0 (_tmp176_);
				_srv_list = _tmp177_;
				_tmp178_ = _srv_list;
				_tmp179_ = gee_collection_get_size ((GeeCollection*) _tmp178_);
				_tmp180_ = _tmp179_;
				_srv_size = _tmp180_;
				_srv_index = -1;
				while (TRUE) {
					gint _tmp181_;
					gint _tmp182_;
					gint _tmp183_;
					GeeList* _tmp184_;
					gint _tmp185_;
					gpointer _tmp186_ = NULL;
					NetsukukuAndnaServer* srv;
					NetsukukuAndnaServer* _tmp187_;
					const gchar* _tmp188_;
					const gchar* _tmp189_;
					NetsukukuAndnaServer* _tmp196_;
					NetsukukuNIP* _tmp197_;
					NetsukukuNIP* _tmp198_;
					gint* _tmp199_ = NULL;
					gint* _tmp200_;
					gint _tmp200__length1;
					NetsukukuNIP* _tmp201_;
					NetsukukuNIP* _tmp202_;
					gboolean _tmp203_ = FALSE;
					gboolean _tmp204_;
					_tmp181_ = _srv_index;
					_srv_index = _tmp181_ + 1;
					_tmp182_ = _srv_index;
					_tmp183_ = _srv_size;
					if (!(_tmp182_ < _tmp183_)) {
						break;
					}
					_tmp184_ = _srv_list;
					_tmp185_ = _srv_index;
					_tmp186_ = gee_list_get (_tmp184_, _tmp185_);
					srv = (NetsukukuAndnaServer*) _tmp186_;
					_tmp187_ = srv;
					_tmp188_ = netsukuku_andna_server_get_alias_name (_tmp187_);
					_tmp189_ = _tmp188_;
					if (g_strcmp0 (_tmp189_, "business.biz") == 0) {
						NetsukukuAndnaServer* _tmp190_;
						gint _tmp191_;
						gint _tmp192_;
						NetsukukuAndnaServer* _tmp193_;
						NetsukukuNIP* _tmp194_;
						NetsukukuNIP* _tmp195_;
						in_found1 = TRUE;
						_tmp190_ = srv;
						_tmp191_ = netsukuku_andna_server_get_port_number (_tmp190_);
						_tmp192_ = _tmp191_;
						_vala_assert (_tmp192_ == 1055, "srv.port_number == 1055");
						_tmp193_ = srv;
						_tmp194_ = netsukuku_andna_server_get_registrar_nip (_tmp193_);
						_tmp195_ = _tmp194_;
						_vala_assert (_tmp195_ == NULL, "srv.registrar_nip == null");
					}
					_tmp196_ = srv;
					_tmp197_ = netsukuku_andna_server_get_registrar_nip (_tmp196_);
					_tmp198_ = _tmp197_;
					_tmp199_ = g_new0 (gint, 4);
					_tmp199_[0] = 1;
					_tmp199_[1] = 0;
					_tmp199_[2] = 3;
					_tmp199_[3] = 2;
					_tmp200_ = _tmp199_;
					_tmp200__length1 = 4;
					_tmp201_ = netsukuku_nip_new (_tmp200_, 4);
					_tmp202_ = _tmp201_;
					_tmp203_ = netsukuku_partial_nip_equal_func ((NetsukukuPartialNIP*) _tmp198_, (NetsukukuPartialNIP*) _tmp202_);
					_tmp204_ = _tmp203_;
					_g_object_unref0 (_tmp202_);
					_tmp200_ = (g_free (_tmp200_), NULL);
					if (_tmp204_) {
						NetsukukuAndnaServer* _tmp205_;
						gint _tmp206_;
						gint _tmp207_;
						NetsukukuAndnaServer* _tmp208_;
						const gchar* _tmp209_;
						const gchar* _tmp210_;
						in_found2 = TRUE;
						_tmp205_ = srv;
						_tmp206_ = netsukuku_andna_server_get_port_number (_tmp205_);
						_tmp207_ = _tmp206_;
						_vala_assert (_tmp207_ == 555, "srv.port_number == 555");
						_tmp208_ = srv;
						_tmp209_ = netsukuku_andna_server_get_alias_name (_tmp208_);
						_tmp210_ = _tmp209_;
						_vala_assert (_tmp210_ == NULL, "srv.alias_name == null");
					}
					_g_object_unref0 (srv);
				}
				_g_object_unref0 (_srv_list);
			}
			_tmp211_ = in_found1;
			_vala_assert (_tmp211_, "in_found1");
			_tmp212_ = in_found2;
			_vala_assert (_tmp212_, "in_found2");
			_tmp213_ = in_servers;
			_tmp215_ = zcd_iserializable_serialize ((zcdISerializable*) _tmp213_, &_tmp214_);
			orig2 = (g_free (orig2), NULL);
			orig2 = _tmp215_;
			orig2_length1 = _tmp214_;
			_orig2_size_ = orig2_length1;
			_g_object_unref0 (in_servers);
			_g_object_unref0 (arec);
		}
		_tmp216_ = orig2;
		_tmp216__length1 = orig2_length1;
		_tmp217_ = g_new0 (guchar, _tmp216__length1);
		dest2 = _tmp217_;
		dest2_length1 = _tmp216__length1;
		_dest2_size_ = dest2_length1;
		{
			gint i;
			i = 0;
			{
				gboolean _tmp218_;
				_tmp218_ = TRUE;
				while (TRUE) {
					gboolean _tmp219_;
					gint _tmp221_;
					guchar* _tmp222_;
					gint _tmp222__length1;
					guchar* _tmp223_;
					gint _tmp223__length1;
					gint _tmp224_;
					guchar* _tmp225_;
					gint _tmp225__length1;
					gint _tmp226_;
					guchar _tmp227_;
					guchar _tmp228_;
					_tmp219_ = _tmp218_;
					if (!_tmp219_) {
						gint _tmp220_;
						_tmp220_ = i;
						i = _tmp220_ + 1;
					}
					_tmp218_ = FALSE;
					_tmp221_ = i;
					_tmp222_ = orig2;
					_tmp222__length1 = orig2_length1;
					if (!(_tmp221_ < _tmp222__length1)) {
						break;
					}
					_tmp223_ = dest2;
					_tmp223__length1 = dest2_length1;
					_tmp224_ = i;
					_tmp225_ = orig2;
					_tmp225__length1 = orig2_length1;
					_tmp226_ = i;
					_tmp227_ = _tmp225_[_tmp226_];
					_tmp223_[_tmp224_] = _tmp227_;
					_tmp228_ = _tmp223_[_tmp224_];
				}
			}
		}
		_tmp229_ = dest2;
		_tmp229__length1 = dest2_length1;
		_tmp230_ = zcd_iserializable_deserialize (_tmp229_, _tmp229__length1, &_inner_error_);
		_tmp231_ = _tmp230_;
		if (_inner_error_ != NULL) {
			dest2 = (g_free (dest2), NULL);
			orig2 = (g_free (orig2), NULL);
			_g_object_unref0 (servers);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
		_g_object_unref0 (servers);
		servers = G_TYPE_CHECK_INSTANCE_CAST (_tmp231_, NETSUKUKU_TYPE_ANDNA_SERVERS, NetsukukuAndnaServers);
		dest2 = (g_free (dest2), NULL);
		orig2 = (g_free (orig2), NULL);
	}
	_tmp232_ = servers;
	_tmp233_ = netsukuku_andna_servers_get_expires (_tmp232_);
	_tmp234_ = _tmp233_;
	_tmp235_ = tasklets_timer_is_expired ((TaskletsTimer*) _tmp234_);
	_vala_assert (!_tmp235_, "!servers.expires.is_expired()");
	found1 = FALSE;
	found2 = FALSE;
	{
		NetsukukuAndnaServers* _tmp236_;
		GeeList* _tmp237_;
		GeeList* _tmp238_;
		GeeList* _tmp239_;
		GeeList* _srv_list;
		GeeList* _tmp240_;
		gint _tmp241_;
		gint _tmp242_;
		gint _srv_size;
		gint _srv_index;
		_tmp236_ = servers;
		_tmp237_ = netsukuku_andna_servers_get_servers (_tmp236_);
		_tmp238_ = _tmp237_;
		_tmp239_ = _g_object_ref0 (_tmp238_);
		_srv_list = _tmp239_;
		_tmp240_ = _srv_list;
		_tmp241_ = gee_collection_get_size ((GeeCollection*) _tmp240_);
		_tmp242_ = _tmp241_;
		_srv_size = _tmp242_;
		_srv_index = -1;
		while (TRUE) {
			gint _tmp243_;
			gint _tmp244_;
			gint _tmp245_;
			GeeList* _tmp246_;
			gint _tmp247_;
			gpointer _tmp248_ = NULL;
			NetsukukuAndnaServer* srv;
			NetsukukuAndnaServer* _tmp249_;
			const gchar* _tmp250_;
			const gchar* _tmp251_;
			NetsukukuAndnaServer* _tmp258_;
			NetsukukuNIP* _tmp259_;
			NetsukukuNIP* _tmp260_;
			gint* _tmp261_ = NULL;
			gint* _tmp262_;
			gint _tmp262__length1;
			NetsukukuNIP* _tmp263_;
			NetsukukuNIP* _tmp264_;
			gboolean _tmp265_ = FALSE;
			gboolean _tmp266_;
			_tmp243_ = _srv_index;
			_srv_index = _tmp243_ + 1;
			_tmp244_ = _srv_index;
			_tmp245_ = _srv_size;
			if (!(_tmp244_ < _tmp245_)) {
				break;
			}
			_tmp246_ = _srv_list;
			_tmp247_ = _srv_index;
			_tmp248_ = gee_list_get (_tmp246_, _tmp247_);
			srv = (NetsukukuAndnaServer*) _tmp248_;
			_tmp249_ = srv;
			_tmp250_ = netsukuku_andna_server_get_alias_name (_tmp249_);
			_tmp251_ = _tmp250_;
			if (g_strcmp0 (_tmp251_, "business.biz") == 0) {
				NetsukukuAndnaServer* _tmp252_;
				gint _tmp253_;
				gint _tmp254_;
				NetsukukuAndnaServer* _tmp255_;
				NetsukukuNIP* _tmp256_;
				NetsukukuNIP* _tmp257_;
				found1 = TRUE;
				_tmp252_ = srv;
				_tmp253_ = netsukuku_andna_server_get_port_number (_tmp252_);
				_tmp254_ = _tmp253_;
				_vala_assert (_tmp254_ == 1055, "srv.port_number == 1055");
				_tmp255_ = srv;
				_tmp256_ = netsukuku_andna_server_get_registrar_nip (_tmp255_);
				_tmp257_ = _tmp256_;
				_vala_assert (_tmp257_ == NULL, "srv.registrar_nip == null");
			}
			_tmp258_ = srv;
			_tmp259_ = netsukuku_andna_server_get_registrar_nip (_tmp258_);
			_tmp260_ = _tmp259_;
			_tmp261_ = g_new0 (gint, 4);
			_tmp261_[0] = 1;
			_tmp261_[1] = 0;
			_tmp261_[2] = 3;
			_tmp261_[3] = 2;
			_tmp262_ = _tmp261_;
			_tmp262__length1 = 4;
			_tmp263_ = netsukuku_nip_new (_tmp262_, 4);
			_tmp264_ = _tmp263_;
			_tmp265_ = netsukuku_partial_nip_equal_func ((NetsukukuPartialNIP*) _tmp260_, (NetsukukuPartialNIP*) _tmp264_);
			_tmp266_ = _tmp265_;
			_g_object_unref0 (_tmp264_);
			_tmp262_ = (g_free (_tmp262_), NULL);
			if (_tmp266_) {
				NetsukukuAndnaServer* _tmp267_;
				gint _tmp268_;
				gint _tmp269_;
				NetsukukuAndnaServer* _tmp270_;
				const gchar* _tmp271_;
				const gchar* _tmp272_;
				found2 = TRUE;
				_tmp267_ = srv;
				_tmp268_ = netsukuku_andna_server_get_port_number (_tmp267_);
				_tmp269_ = _tmp268_;
				_vala_assert (_tmp269_ == 555, "srv.port_number == 555");
				_tmp270_ = srv;
				_tmp271_ = netsukuku_andna_server_get_alias_name (_tmp270_);
				_tmp272_ = _tmp271_;
				_vala_assert (_tmp272_ == NULL, "srv.alias_name == null");
			}
			_g_object_unref0 (srv);
		}
		_g_object_unref0 (_srv_list);
	}
	_tmp273_ = found1;
	_vala_assert (_tmp273_, "found1");
	_tmp274_ = found2;
	_vala_assert (_tmp274_, "found2");
	_g_object_unref0 (servers);
}


static gboolean _netsukuku_register_hostname_arguments_equal_func_for_queue_gee_equal_data_func (gconstpointer a, gconstpointer b, gpointer self) {
	gboolean result;
	result = netsukuku_register_hostname_arguments_equal_func_for_queue (a, b);
	return result;
}


void ntk_test_andna_tester_test_ser_get_cache (NtkTestAndnaTester* self) {
	NetsukukuAndnaGetCacheRecordsResponse* cachequeue = NULL;
	NetsukukuAndnaGetCacheRecordsResponse* _tmp90_;
	GeeHashMap* _tmp91_;
	GeeSet* _tmp92_;
	GeeSet* _tmp93_;
	GeeSet* _tmp94_;
	gint _tmp95_;
	gint _tmp96_;
	NetsukukuAndnaGetCacheRecordsResponse* _tmp97_;
	GeeHashMap* _tmp98_;
	GeeSet* _tmp99_;
	GeeSet* _tmp100_;
	GeeSet* _tmp101_;
	gint _tmp102_;
	gint _tmp103_;
	NetsukukuAndnaGetCacheRecordsResponse* _tmp104_;
	GeeHashMap* _tmp105_;
	gpointer _tmp106_ = NULL;
	GeeArrayList* _tmp107_;
	gint _tmp108_;
	gint _tmp109_;
	NetsukukuAndnaGetCacheRecordsResponse* _tmp110_;
	GeeHashMap* _tmp111_;
	gpointer _tmp112_ = NULL;
	NetsukukuAndnaDomainRecord* _tmp113_;
	NetsukukuTimeCapsule* _tmp114_;
	NetsukukuTimeCapsule* _tmp115_;
	gboolean _tmp116_ = FALSE;
	NetsukukuAndnaGetCacheRecordsResponse* _tmp117_;
	GeeHashMap* _tmp118_;
	gpointer _tmp119_ = NULL;
	NetsukukuAndnaDomainRecord* _tmp120_;
	NetsukukuNIP* _tmp121_;
	NetsukukuNIP* _tmp122_;
	gint* _tmp123_ = NULL;
	gint* _tmp124_;
	gint _tmp124__length1;
	NetsukukuNIP* _tmp125_;
	NetsukukuNIP* _tmp126_;
	gboolean _tmp127_ = FALSE;
	NetsukukuAndnaGetCacheRecordsResponse* _tmp128_;
	GeeHashMap* _tmp129_;
	gpointer _tmp130_ = NULL;
	NetsukukuAndnaDomainRecord* _tmp131_;
	GeeHashMap* _tmp132_;
	GeeHashMap* _tmp133_;
	NetsukukuAndnaServiceKey* _tmp134_;
	NetsukukuAndnaServiceKey* _tmp135_;
	gpointer _tmp136_ = NULL;
	GeeArrayList* _tmp137_;
	gpointer _tmp138_ = NULL;
	NetsukukuAndnaServerRecord* _tmp139_;
	const gchar* _tmp140_;
	const gchar* _tmp141_;
	NetsukukuAndnaGetCacheRecordsResponse* _tmp142_;
	GeeHashMap* _tmp143_;
	gpointer _tmp144_ = NULL;
	GeeArrayList* _tmp145_;
	gpointer _tmp146_ = NULL;
	NetsukukuRegisterHostnameArguments* _tmp147_;
	NetsukukuAndnaDomainRequest* _tmp148_;
	NetsukukuNIP* _tmp149_;
	NetsukukuNIP* _tmp150_;
	gint* _tmp151_ = NULL;
	gint* _tmp152_;
	gint _tmp152__length1;
	NetsukukuNIP* _tmp153_;
	NetsukukuNIP* _tmp154_;
	gboolean _tmp155_ = FALSE;
	NetsukukuAndnaGetCacheRecordsResponse* _tmp156_;
	GeeHashMap* _tmp157_;
	gpointer _tmp158_ = NULL;
	GeeArrayList* _tmp159_;
	gpointer _tmp160_ = NULL;
	NetsukukuRegisterHostnameArguments* _tmp161_;
	NetsukukuAndnaDomainRequest* _tmp162_;
	NetsukukuNIP* _tmp163_;
	NetsukukuNIP* _tmp164_;
	gint* _tmp165_ = NULL;
	gint* _tmp166_;
	gint _tmp166__length1;
	NetsukukuNIP* _tmp167_;
	NetsukukuNIP* _tmp168_;
	gboolean _tmp169_ = FALSE;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	{
		guchar* orig = NULL;
		gint orig_length1 = 0;
		gint _orig_size_ = 0;
		guchar* _tmp74_;
		gint _tmp74__length1;
		guchar* _tmp75_ = NULL;
		guchar* dest;
		gint dest_length1;
		gint _dest_size_;
		guchar* _tmp87_;
		gint _tmp87__length1;
		zcdISerializable* _tmp88_ = NULL;
		zcdISerializable* _tmp89_;
		{
			NetsukukuAndnaDomainRecord* record_owner = NULL;
			NetsukukuPublicKey* pubk_owner = NULL;
			NetsukukuNIP* nip_owner = NULL;
			NetsukukuAndnaDomainRequest* request_queued_a = NULL;
			NetsukukuPublicKey* pubk_a = NULL;
			NetsukukuNIP* nip_a = NULL;
			zcdSerializableBuffer* signature_a = NULL;
			NetsukukuRegisterHostnameArguments* args_a = NULL;
			NetsukukuAndnaDomainRequest* request_queued_b = NULL;
			NetsukukuPublicKey* pubk_b = NULL;
			NetsukukuNIP* nip_b = NULL;
			zcdSerializableBuffer* signature_b = NULL;
			NetsukukuRegisterHostnameArguments* args_b = NULL;
			guint8* _tmp0_ = NULL;
			guint8* _tmp1_;
			gint _tmp1__length1;
			zcdSerializableBuffer* _tmp2_;
			zcdSerializableBuffer* _tmp3_;
			NetsukukuPublicKey* _tmp4_;
			gint* _tmp5_ = NULL;
			gint* _tmp6_;
			gint _tmp6__length1;
			NetsukukuNIP* _tmp7_;
			NetsukukuPublicKey* _tmp8_;
			NetsukukuNIP* _tmp9_;
			NetsukukuAndnaDomainRecord* _tmp10_;
			guint8* _tmp11_ = NULL;
			guint8* _tmp12_;
			gint _tmp12__length1;
			zcdSerializableBuffer* _tmp13_;
			zcdSerializableBuffer* _tmp14_;
			NetsukukuPublicKey* _tmp15_;
			gint* _tmp16_ = NULL;
			gint* _tmp17_;
			gint _tmp17__length1;
			NetsukukuNIP* _tmp18_;
			guint8* _tmp19_ = NULL;
			guint8* _tmp20_;
			gint _tmp20__length1;
			zcdSerializableBuffer* _tmp21_;
			NetsukukuPublicKey* _tmp22_;
			NetsukukuNIP* _tmp23_;
			GeeHashMap* _tmp24_ = NULL;
			GeeHashMap* _tmp25_;
			NetsukukuAndnaDomainRequest* _tmp26_;
			NetsukukuAndnaDomainRequest* _tmp27_;
			zcdSerializableBuffer* _tmp28_;
			NetsukukuTimeCapsule* _tmp29_;
			NetsukukuTimeCapsule* _tmp30_;
			NetsukukuRegisterHostnameArguments* _tmp31_;
			guint8* _tmp32_ = NULL;
			guint8* _tmp33_;
			gint _tmp33__length1;
			zcdSerializableBuffer* _tmp34_;
			zcdSerializableBuffer* _tmp35_;
			NetsukukuPublicKey* _tmp36_;
			gint* _tmp37_ = NULL;
			gint* _tmp38_;
			gint _tmp38__length1;
			NetsukukuNIP* _tmp39_;
			guint8* _tmp40_ = NULL;
			guint8* _tmp41_;
			gint _tmp41__length1;
			zcdSerializableBuffer* _tmp42_;
			NetsukukuPublicKey* _tmp43_;
			NetsukukuNIP* _tmp44_;
			GeeHashMap* _tmp45_ = NULL;
			GeeHashMap* _tmp46_;
			NetsukukuAndnaDomainRequest* _tmp47_;
			NetsukukuAndnaDomainRequest* _tmp48_;
			zcdSerializableBuffer* _tmp49_;
			NetsukukuTimeCapsule* _tmp50_;
			NetsukukuTimeCapsule* _tmp51_;
			NetsukukuRegisterHostnameArguments* _tmp52_;
			GeeHashMap* _tmp53_;
			GeeHashMap* cache;
			GeeHashMap* _tmp54_;
			NetsukukuAndnaDomainRecord* _tmp55_;
			GeeHashMap* _tmp56_;
			GeeHashMap* request_queue;
			GeeHashMap* _tmp57_;
			GeeArrayList* _tmp58_;
			GeeArrayList* _tmp59_;
			GeeHashMap* _tmp60_;
			gpointer _tmp61_ = NULL;
			GeeArrayList* _tmp62_;
			NetsukukuRegisterHostnameArguments* _tmp63_;
			GeeHashMap* _tmp64_;
			gpointer _tmp65_ = NULL;
			GeeArrayList* _tmp66_;
			NetsukukuRegisterHostnameArguments* _tmp67_;
			GeeHashMap* _tmp68_;
			GeeHashMap* _tmp69_;
			NetsukukuAndnaGetCacheRecordsResponse* _tmp70_;
			NetsukukuAndnaGetCacheRecordsResponse* in_cachequeue;
			NetsukukuAndnaGetCacheRecordsResponse* _tmp71_;
			gint _tmp72_ = 0;
			guchar* _tmp73_ = NULL;
			_tmp0_ = g_new0 (guint8, 4);
			_tmp0_[0] = (guint8) 1;
			_tmp0_[1] = (guint8) 2;
			_tmp0_[2] = (guint8) 3;
			_tmp0_[3] = (guint8) 4;
			_tmp1_ = _tmp0_;
			_tmp1__length1 = 4;
			_tmp2_ = zcd_serializable_buffer_new (_tmp1_, 4);
			_tmp3_ = _tmp2_;
			_tmp4_ = netsukuku_public_key_new (_tmp3_);
			_g_object_unref0 (pubk_owner);
			pubk_owner = _tmp4_;
			_g_object_unref0 (_tmp3_);
			_tmp1_ = (g_free (_tmp1_), NULL);
			_tmp5_ = g_new0 (gint, 4);
			_tmp5_[0] = 23;
			_tmp5_[1] = 12;
			_tmp5_[2] = 45;
			_tmp5_[3] = 6;
			_tmp6_ = _tmp5_;
			_tmp6__length1 = 4;
			_tmp7_ = netsukuku_nip_new (_tmp6_, 4);
			_g_object_unref0 (nip_owner);
			nip_owner = _tmp7_;
			_tmp6_ = (g_free (_tmp6_), NULL);
			_tmp8_ = pubk_owner;
			_tmp9_ = nip_owner;
			_tmp10_ = netsukuku_andna_domain_record_new ((gint64) 34589790, "qwerty", _tmp8_, _tmp9_, NULL);
			_g_object_unref0 (record_owner);
			record_owner = _tmp10_;
			_tmp11_ = g_new0 (guint8, 4);
			_tmp11_[0] = (guint8) 31;
			_tmp11_[1] = (guint8) 42;
			_tmp11_[2] = (guint8) 23;
			_tmp11_[3] = (guint8) 54;
			_tmp12_ = _tmp11_;
			_tmp12__length1 = 4;
			_tmp13_ = zcd_serializable_buffer_new (_tmp12_, 4);
			_tmp14_ = _tmp13_;
			_tmp15_ = netsukuku_public_key_new (_tmp14_);
			_g_object_unref0 (pubk_a);
			pubk_a = _tmp15_;
			_g_object_unref0 (_tmp14_);
			_tmp12_ = (g_free (_tmp12_), NULL);
			_tmp16_ = g_new0 (gint, 4);
			_tmp16_[0] = 12;
			_tmp16_[1] = 7;
			_tmp16_[2] = 145;
			_tmp16_[3] = 6;
			_tmp17_ = _tmp16_;
			_tmp17__length1 = 4;
			_tmp18_ = netsukuku_nip_new (_tmp17_, 4);
			_g_object_unref0 (nip_a);
			nip_a = _tmp18_;
			_tmp17_ = (g_free (_tmp17_), NULL);
			_tmp19_ = g_new0 (guint8, 4);
			_tmp19_[0] = (guint8) 13;
			_tmp19_[1] = (guint8) 42;
			_tmp19_[2] = (guint8) 73;
			_tmp19_[3] = (guint8) 64;
			_tmp20_ = _tmp19_;
			_tmp20__length1 = 4;
			_tmp21_ = zcd_serializable_buffer_new (_tmp20_, 4);
			_g_object_unref0 (signature_a);
			signature_a = _tmp21_;
			_tmp20_ = (g_free (_tmp20_), NULL);
			_tmp22_ = pubk_a;
			_tmp23_ = nip_a;
			_tmp24_ = netsukuku_andna_domain_request_make_empty_services ();
			_tmp25_ = _tmp24_;
			_tmp26_ = netsukuku_andna_domain_request_new ("qwerty", _tmp22_, _tmp23_, _tmp25_);
			_g_object_unref0 (request_queued_a);
			request_queued_a = _tmp26_;
			_g_object_unref0 (_tmp25_);
			_tmp27_ = request_queued_a;
			_tmp28_ = signature_a;
			_tmp29_ = netsukuku_time_capsule_new ((gint64) 123);
			_tmp30_ = _tmp29_;
			_tmp31_ = netsukuku_register_hostname_arguments_new (_tmp27_, _tmp28_, _tmp30_);
			_g_object_unref0 (args_a);
			args_a = _tmp31_;
			_g_object_unref0 (_tmp30_);
			_tmp32_ = g_new0 (guint8, 4);
			_tmp32_[0] = (guint8) 6;
			_tmp32_[1] = (guint8) 2;
			_tmp32_[2] = (guint8) 4;
			_tmp32_[3] = (guint8) 54;
			_tmp33_ = _tmp32_;
			_tmp33__length1 = 4;
			_tmp34_ = zcd_serializable_buffer_new (_tmp33_, 4);
			_tmp35_ = _tmp34_;
			_tmp36_ = netsukuku_public_key_new (_tmp35_);
			_g_object_unref0 (pubk_b);
			pubk_b = _tmp36_;
			_g_object_unref0 (_tmp35_);
			_tmp33_ = (g_free (_tmp33_), NULL);
			_tmp37_ = g_new0 (gint, 4);
			_tmp37_[0] = 5;
			_tmp37_[1] = 6;
			_tmp37_[2] = 7;
			_tmp37_[3] = 8;
			_tmp38_ = _tmp37_;
			_tmp38__length1 = 4;
			_tmp39_ = netsukuku_nip_new (_tmp38_, 4);
			_g_object_unref0 (nip_b);
			nip_b = _tmp39_;
			_tmp38_ = (g_free (_tmp38_), NULL);
			_tmp40_ = g_new0 (guint8, 4);
			_tmp40_[0] = (guint8) 54;
			_tmp40_[1] = (guint8) 1;
			_tmp40_[2] = (guint8) 4;
			_tmp40_[3] = (guint8) 75;
			_tmp41_ = _tmp40_;
			_tmp41__length1 = 4;
			_tmp42_ = zcd_serializable_buffer_new (_tmp41_, 4);
			_g_object_unref0 (signature_b);
			signature_b = _tmp42_;
			_tmp41_ = (g_free (_tmp41_), NULL);
			_tmp43_ = pubk_b;
			_tmp44_ = nip_b;
			_tmp45_ = netsukuku_andna_domain_request_make_empty_services ();
			_tmp46_ = _tmp45_;
			_tmp47_ = netsukuku_andna_domain_request_new ("qwerty", _tmp43_, _tmp44_, _tmp46_);
			_g_object_unref0 (request_queued_b);
			request_queued_b = _tmp47_;
			_g_object_unref0 (_tmp46_);
			_tmp48_ = request_queued_b;
			_tmp49_ = signature_b;
			_tmp50_ = netsukuku_time_capsule_new ((gint64) 123);
			_tmp51_ = _tmp50_;
			_tmp52_ = netsukuku_register_hostname_arguments_new (_tmp48_, _tmp49_, _tmp51_);
			_g_object_unref0 (args_b);
			args_b = _tmp52_;
			_g_object_unref0 (_tmp51_);
			_tmp53_ = gee_hash_map_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, NETSUKUKU_TYPE_ANDNA_DOMAIN_RECORD, (GBoxedCopyFunc) g_object_ref, g_object_unref, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
			cache = _tmp53_;
			_tmp54_ = cache;
			_tmp55_ = record_owner;
			gee_abstract_map_set ((GeeAbstractMap*) _tmp54_, "qwerty", _tmp55_);
			_tmp56_ = gee_hash_map_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, GEE_TYPE_ARRAY_LIST, (GBoxedCopyFunc) g_object_ref, g_object_unref, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
			request_queue = _tmp56_;
			_tmp57_ = request_queue;
			_tmp58_ = gee_array_list_new (NETSUKUKU_TYPE_REGISTER_HOSTNAME_ARGUMENTS, (GBoxedCopyFunc) g_object_ref, g_object_unref, _netsukuku_register_hostname_arguments_equal_func_for_queue_gee_equal_data_func, NULL, NULL);
			_tmp59_ = _tmp58_;
			gee_abstract_map_set ((GeeAbstractMap*) _tmp57_, "qwerty", _tmp59_);
			_g_object_unref0 (_tmp59_);
			_tmp60_ = request_queue;
			_tmp61_ = gee_abstract_map_get ((GeeAbstractMap*) _tmp60_, "qwerty");
			_tmp62_ = (GeeArrayList*) _tmp61_;
			_tmp63_ = args_a;
			gee_abstract_collection_add ((GeeAbstractCollection*) _tmp62_, _tmp63_);
			_g_object_unref0 (_tmp62_);
			_tmp64_ = request_queue;
			_tmp65_ = gee_abstract_map_get ((GeeAbstractMap*) _tmp64_, "qwerty");
			_tmp66_ = (GeeArrayList*) _tmp65_;
			_tmp67_ = args_b;
			gee_abstract_collection_add ((GeeAbstractCollection*) _tmp66_, _tmp67_);
			_g_object_unref0 (_tmp66_);
			_tmp68_ = cache;
			_tmp69_ = request_queue;
			_tmp70_ = netsukuku_andna_get_cache_records_response_new (_tmp68_, _tmp69_);
			in_cachequeue = _tmp70_;
			_tmp71_ = in_cachequeue;
			_tmp73_ = zcd_iserializable_serialize ((zcdISerializable*) _tmp71_, &_tmp72_);
			orig = (g_free (orig), NULL);
			orig = _tmp73_;
			orig_length1 = _tmp72_;
			_orig_size_ = orig_length1;
			_g_object_unref0 (in_cachequeue);
			_g_object_unref0 (request_queue);
			_g_object_unref0 (cache);
			_g_object_unref0 (args_b);
			_g_object_unref0 (signature_b);
			_g_object_unref0 (nip_b);
			_g_object_unref0 (pubk_b);
			_g_object_unref0 (request_queued_b);
			_g_object_unref0 (args_a);
			_g_object_unref0 (signature_a);
			_g_object_unref0 (nip_a);
			_g_object_unref0 (pubk_a);
			_g_object_unref0 (request_queued_a);
			_g_object_unref0 (nip_owner);
			_g_object_unref0 (pubk_owner);
			_g_object_unref0 (record_owner);
		}
		_tmp74_ = orig;
		_tmp74__length1 = orig_length1;
		_tmp75_ = g_new0 (guchar, _tmp74__length1);
		dest = _tmp75_;
		dest_length1 = _tmp74__length1;
		_dest_size_ = dest_length1;
		{
			gint i;
			i = 0;
			{
				gboolean _tmp76_;
				_tmp76_ = TRUE;
				while (TRUE) {
					gboolean _tmp77_;
					gint _tmp79_;
					guchar* _tmp80_;
					gint _tmp80__length1;
					guchar* _tmp81_;
					gint _tmp81__length1;
					gint _tmp82_;
					guchar* _tmp83_;
					gint _tmp83__length1;
					gint _tmp84_;
					guchar _tmp85_;
					guchar _tmp86_;
					_tmp77_ = _tmp76_;
					if (!_tmp77_) {
						gint _tmp78_;
						_tmp78_ = i;
						i = _tmp78_ + 1;
					}
					_tmp76_ = FALSE;
					_tmp79_ = i;
					_tmp80_ = orig;
					_tmp80__length1 = orig_length1;
					if (!(_tmp79_ < _tmp80__length1)) {
						break;
					}
					_tmp81_ = dest;
					_tmp81__length1 = dest_length1;
					_tmp82_ = i;
					_tmp83_ = orig;
					_tmp83__length1 = orig_length1;
					_tmp84_ = i;
					_tmp85_ = _tmp83_[_tmp84_];
					_tmp81_[_tmp82_] = _tmp85_;
					_tmp86_ = _tmp81_[_tmp82_];
				}
			}
		}
		_tmp87_ = dest;
		_tmp87__length1 = dest_length1;
		_tmp88_ = zcd_iserializable_deserialize (_tmp87_, _tmp87__length1, &_inner_error_);
		_tmp89_ = _tmp88_;
		if (_inner_error_ != NULL) {
			dest = (g_free (dest), NULL);
			orig = (g_free (orig), NULL);
			_g_object_unref0 (cachequeue);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
		_g_object_unref0 (cachequeue);
		cachequeue = G_TYPE_CHECK_INSTANCE_CAST (_tmp89_, NETSUKUKU_TYPE_ANDNA_GET_CACHE_RECORDS_RESPONSE, NetsukukuAndnaGetCacheRecordsResponse);
		dest = (g_free (dest), NULL);
		orig = (g_free (orig), NULL);
	}
	_tmp90_ = cachequeue;
	_tmp91_ = _tmp90_->cache;
	_tmp92_ = gee_abstract_map_get_keys ((GeeMap*) _tmp91_);
	_tmp93_ = _tmp92_;
	_tmp94_ = _tmp93_;
	_tmp95_ = gee_collection_get_size ((GeeCollection*) _tmp94_);
	_tmp96_ = _tmp95_;
	_vala_assert (_tmp96_ == 1, "cachequeue.cache.keys.size == 1");
	_g_object_unref0 (_tmp94_);
	_tmp97_ = cachequeue;
	_tmp98_ = _tmp97_->request_queue;
	_tmp99_ = gee_abstract_map_get_keys ((GeeMap*) _tmp98_);
	_tmp100_ = _tmp99_;
	_tmp101_ = _tmp100_;
	_tmp102_ = gee_collection_get_size ((GeeCollection*) _tmp101_);
	_tmp103_ = _tmp102_;
	_vala_assert (_tmp103_ == 1, "cachequeue.request_queue.keys.size == 1");
	_g_object_unref0 (_tmp101_);
	_tmp104_ = cachequeue;
	_tmp105_ = _tmp104_->request_queue;
	_tmp106_ = gee_abstract_map_get ((GeeAbstractMap*) _tmp105_, "qwerty");
	_tmp107_ = (GeeArrayList*) _tmp106_;
	_tmp108_ = gee_abstract_collection_get_size ((GeeCollection*) _tmp107_);
	_tmp109_ = _tmp108_;
	_vala_assert (_tmp109_ == 2, "cachequeue.request_queue[\"qwerty\"].size == 2");
	_g_object_unref0 (_tmp107_);
	_tmp110_ = cachequeue;
	_tmp111_ = _tmp110_->cache;
	_tmp112_ = gee_abstract_map_get ((GeeAbstractMap*) _tmp111_, "qwerty");
	_tmp113_ = (NetsukukuAndnaDomainRecord*) _tmp112_;
	_tmp114_ = netsukuku_andna_domain_record_get_expires (_tmp113_);
	_tmp115_ = _tmp114_;
	_tmp116_ = tasklets_timer_is_expired ((TaskletsTimer*) _tmp115_);
	_vala_assert (!_tmp116_, "! cachequeue.cache[\"qwerty\"].expires.is_expired()");
	_g_object_unref0 (_tmp113_);
	_tmp117_ = cachequeue;
	_tmp118_ = _tmp117_->cache;
	_tmp119_ = gee_abstract_map_get ((GeeAbstractMap*) _tmp118_, "qwerty");
	_tmp120_ = (NetsukukuAndnaDomainRecord*) _tmp119_;
	_tmp121_ = netsukuku_andna_domain_record_get_nip (_tmp120_);
	_tmp122_ = _tmp121_;
	_tmp123_ = g_new0 (gint, 4);
	_tmp123_[0] = 23;
	_tmp123_[1] = 12;
	_tmp123_[2] = 45;
	_tmp123_[3] = 6;
	_tmp124_ = _tmp123_;
	_tmp124__length1 = 4;
	_tmp125_ = netsukuku_nip_new (_tmp124_, 4);
	_tmp126_ = _tmp125_;
	_tmp127_ = netsukuku_partial_nip_is_equal ((NetsukukuPartialNIP*) _tmp122_, (NetsukukuPartialNIP*) _tmp126_);
	_vala_assert (_tmp127_, "cachequeue.cache[\"qwerty\"].nip.is_equal(new NIP({23,12,45,6}))");
	_g_object_unref0 (_tmp126_);
	_tmp124_ = (g_free (_tmp124_), NULL);
	_g_object_unref0 (_tmp120_);
	_tmp128_ = cachequeue;
	_tmp129_ = _tmp128_->cache;
	_tmp130_ = gee_abstract_map_get ((GeeAbstractMap*) _tmp129_, "qwerty");
	_tmp131_ = (NetsukukuAndnaDomainRecord*) _tmp130_;
	_tmp132_ = netsukuku_andna_domain_record_get_services (_tmp131_);
	_tmp133_ = _tmp132_;
	_tmp134_ = netsukuku_andna_service_key_get_NULL_SERV_KEY ();
	_tmp135_ = _tmp134_;
	_tmp136_ = gee_abstract_map_get ((GeeAbstractMap*) _tmp133_, _tmp135_);
	_tmp137_ = (GeeArrayList*) _tmp136_;
	_tmp138_ = gee_abstract_list_get ((GeeAbstractList*) _tmp137_, 0);
	_tmp139_ = (NetsukukuAndnaServerRecord*) _tmp138_;
	_tmp140_ = netsukuku_andna_server_record_get_hashed_alias (_tmp139_);
	_tmp141_ = _tmp140_;
	_vala_assert (_tmp141_ == NULL, "cachequeue.cache[\"qwerty\"].services[AndnaServiceKey.NULL_SERV_KEY][0].hashed_alias == null");
	_g_object_unref0 (_tmp139_);
	_g_object_unref0 (_tmp137_);
	_g_object_unref0 (_tmp131_);
	_tmp142_ = cachequeue;
	_tmp143_ = _tmp142_->request_queue;
	_tmp144_ = gee_abstract_map_get ((GeeAbstractMap*) _tmp143_, "qwerty");
	_tmp145_ = (GeeArrayList*) _tmp144_;
	_tmp146_ = gee_abstract_list_get ((GeeAbstractList*) _tmp145_, 0);
	_tmp147_ = (NetsukukuRegisterHostnameArguments*) _tmp146_;
	_tmp148_ = _tmp147_->request;
	_tmp149_ = netsukuku_andna_domain_request_get_nip (_tmp148_);
	_tmp150_ = _tmp149_;
	_tmp151_ = g_new0 (gint, 4);
	_tmp151_[0] = 12;
	_tmp151_[1] = 7;
	_tmp151_[2] = 145;
	_tmp151_[3] = 6;
	_tmp152_ = _tmp151_;
	_tmp152__length1 = 4;
	_tmp153_ = netsukuku_nip_new (_tmp152_, 4);
	_tmp154_ = _tmp153_;
	_tmp155_ = netsukuku_partial_nip_is_equal ((NetsukukuPartialNIP*) _tmp150_, (NetsukukuPartialNIP*) _tmp154_);
	_vala_assert (_tmp155_, "cachequeue.request_queue[\"qwerty\"][0].request.nip.is_equal(new NIP({12,7,145,6}))");
	_g_object_unref0 (_tmp154_);
	_tmp152_ = (g_free (_tmp152_), NULL);
	_g_object_unref0 (_tmp147_);
	_g_object_unref0 (_tmp145_);
	_tmp156_ = cachequeue;
	_tmp157_ = _tmp156_->request_queue;
	_tmp158_ = gee_abstract_map_get ((GeeAbstractMap*) _tmp157_, "qwerty");
	_tmp159_ = (GeeArrayList*) _tmp158_;
	_tmp160_ = gee_abstract_list_get ((GeeAbstractList*) _tmp159_, 1);
	_tmp161_ = (NetsukukuRegisterHostnameArguments*) _tmp160_;
	_tmp162_ = _tmp161_->request;
	_tmp163_ = netsukuku_andna_domain_request_get_nip (_tmp162_);
	_tmp164_ = _tmp163_;
	_tmp165_ = g_new0 (gint, 4);
	_tmp165_[0] = 5;
	_tmp165_[1] = 6;
	_tmp165_[2] = 7;
	_tmp165_[3] = 8;
	_tmp166_ = _tmp165_;
	_tmp166__length1 = 4;
	_tmp167_ = netsukuku_nip_new (_tmp166_, 4);
	_tmp168_ = _tmp167_;
	_tmp169_ = netsukuku_partial_nip_is_equal ((NetsukukuPartialNIP*) _tmp164_, (NetsukukuPartialNIP*) _tmp168_);
	_vala_assert (_tmp169_, "cachequeue.request_queue[\"qwerty\"][1].request.nip.is_equal(new NIP({5,6,7,8}))");
	_g_object_unref0 (_tmp168_);
	_tmp166_ = (g_free (_tmp166_), NULL);
	_g_object_unref0 (_tmp161_);
	_g_object_unref0 (_tmp159_);
	_g_object_unref0 (cachequeue);
}


void ntk_test_andna_tester_test_ser_info_andna (NtkTestAndnaTester* self) {
	NetsukukuInfoAndna* info = NULL;
	NetsukukuInfoAndna* _tmp55_;
	const gchar* _tmp56_;
	const gchar* _tmp57_ = NULL;
	gchar* _tmp58_ = NULL;
	gchar* _tmp59_;
	NetsukukuInfoAndna* _tmp60_;
	const gchar* _tmp61_;
	NetsukukuInfoAndna* _tmp62_;
	gboolean _tmp63_;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	{
		guchar* orig = NULL;
		gint orig_length1 = 0;
		gint _orig_size_ = 0;
		guchar* _tmp39_;
		gint _tmp39__length1;
		guchar* _tmp40_ = NULL;
		guchar* dest;
		gint dest_length1;
		gint _dest_size_;
		guchar* _tmp52_;
		gint _tmp52__length1;
		zcdISerializable* _tmp53_ = NULL;
		zcdISerializable* _tmp54_;
		{
			NetsukukuInfoAndna* _tmp0_;
			NetsukukuInfoAndna* ret;
			NetsukukuInfoAndna* _tmp1_;
			NetsukukuInfoAndna* _tmp2_;
			NetsukukuInfoAndna* _tmp3_;
			gchar* _tmp4_;
			NetsukukuInfoAndnaCache* _tmp5_;
			NetsukukuInfoAndnaCache* c;
			NetsukukuInfoAndnaCache* _tmp6_;
			gchar* _tmp7_;
			guint8* _tmp8_ = NULL;
			guint8* _tmp9_;
			gint _tmp9__length1;
			zcdSerializableBuffer* _tmp10_;
			zcdSerializableBuffer* _tmp11_;
			NetsukukuPublicKey* _tmp12_;
			NetsukukuPublicKey* _tmp13_;
			NetsukukuPublicKey* pubk_fake;
			gint* _tmp14_ = NULL;
			gint* _tmp15_;
			gint _tmp15__length1;
			NetsukukuNIP* _tmp16_;
			NetsukukuNIP* _tmp17_;
			NetsukukuNIP* nip_fake;
			NetsukukuInfoAndnaCache* _tmp18_;
			NetsukukuPublicKey* _tmp19_;
			NetsukukuNIP* _tmp20_;
			NetsukukuAndnaDomainRecord* _tmp21_;
			NetsukukuInfoAndna* _tmp22_;
			GeeArrayList* _tmp23_;
			GeeArrayList* _tmp24_;
			NetsukukuInfoAndnaCache* _tmp25_;
			NetsukukuInfoAndnaRegistration* _tmp26_;
			NetsukukuInfoAndnaRegistration* r;
			NetsukukuInfoAndnaRegistration* _tmp27_;
			gchar* _tmp28_;
			NetsukukuInfoAndnaRegistration* _tmp29_;
			NetsukukuInfoAndnaRegistration* _tmp30_;
			NetsukukuTimeCapsule* _tmp31_;
			NetsukukuInfoAndna* _tmp32_;
			GeeArrayList* _tmp33_;
			GeeArrayList* _tmp34_;
			NetsukukuInfoAndnaRegistration* _tmp35_;
			NetsukukuInfoAndna* _tmp36_;
			gint _tmp37_ = 0;
			guchar* _tmp38_ = NULL;
			_tmp0_ = netsukuku_info_andna_new ();
			ret = _tmp0_;
			_tmp1_ = ret;
			_tmp1_->memory_initialized = TRUE;
			_tmp2_ = ret;
			_tmp2_->register_ongoing = TRUE;
			_tmp3_ = ret;
			_tmp4_ = g_strdup ("A7C84D9F02AB");
			_g_free0 (_tmp3_->pubk);
			_tmp3_->pubk = _tmp4_;
			_tmp5_ = netsukuku_info_andna_cache_new ();
			c = _tmp5_;
			_tmp6_ = c;
			_tmp7_ = g_strdup ("394icenorkv03orgIUGOb8ytfyi");
			_g_free0 (_tmp6_->domain);
			_tmp6_->domain = _tmp7_;
			_tmp8_ = g_new0 (guint8, 4);
			_tmp8_[0] = (guint8) 31;
			_tmp8_[1] = (guint8) 42;
			_tmp8_[2] = (guint8) 23;
			_tmp8_[3] = (guint8) 54;
			_tmp9_ = _tmp8_;
			_tmp9__length1 = 4;
			_tmp10_ = zcd_serializable_buffer_new (_tmp9_, 4);
			_tmp11_ = _tmp10_;
			_tmp12_ = netsukuku_public_key_new (_tmp11_);
			_tmp13_ = _tmp12_;
			_g_object_unref0 (_tmp11_);
			_tmp9_ = (g_free (_tmp9_), NULL);
			pubk_fake = _tmp13_;
			_tmp14_ = g_new0 (gint, 4);
			_tmp14_[0] = 12;
			_tmp14_[1] = 7;
			_tmp14_[2] = 145;
			_tmp14_[3] = 6;
			_tmp15_ = _tmp14_;
			_tmp15__length1 = 4;
			_tmp16_ = netsukuku_nip_new (_tmp15_, 4);
			_tmp17_ = _tmp16_;
			_tmp15_ = (g_free (_tmp15_), NULL);
			nip_fake = _tmp17_;
			_tmp18_ = c;
			_tmp19_ = pubk_fake;
			_tmp20_ = nip_fake;
			_tmp21_ = netsukuku_andna_domain_record_new ((gint64) 0, "qwerty", _tmp19_, _tmp20_, NULL);
			_g_object_unref0 (_tmp18_->rec);
			_tmp18_->rec = _tmp21_;
			_tmp22_ = ret;
			_tmp23_ = netsukuku_info_andna_get_cache (_tmp22_);
			_tmp24_ = _tmp23_;
			_tmp25_ = c;
			gee_abstract_collection_add ((GeeAbstractCollection*) _tmp24_, _tmp25_);
			_tmp26_ = netsukuku_info_andna_registration_new ();
			r = _tmp26_;
			_tmp27_ = r;
			_tmp28_ = g_strdup ("PEGASUS");
			_g_free0 (_tmp27_->domain);
			_tmp27_->domain = _tmp28_;
			_tmp29_ = r;
			_tmp29_->registered = TRUE;
			_tmp30_ = r;
			_tmp31_ = netsukuku_time_capsule_new ((gint64) 0);
			_g_object_unref0 (_tmp30_->ttl_before_request);
			_tmp30_->ttl_before_request = _tmp31_;
			_tmp32_ = ret;
			_tmp33_ = netsukuku_info_andna_get_registrations (_tmp32_);
			_tmp34_ = _tmp33_;
			_tmp35_ = r;
			gee_abstract_collection_add ((GeeAbstractCollection*) _tmp34_, _tmp35_);
			_tmp36_ = ret;
			_tmp38_ = zcd_iserializable_serialize ((zcdISerializable*) _tmp36_, &_tmp37_);
			orig = (g_free (orig), NULL);
			orig = _tmp38_;
			orig_length1 = _tmp37_;
			_orig_size_ = orig_length1;
			_g_object_unref0 (r);
			_g_object_unref0 (nip_fake);
			_g_object_unref0 (pubk_fake);
			_g_object_unref0 (c);
			_g_object_unref0 (ret);
		}
		_tmp39_ = orig;
		_tmp39__length1 = orig_length1;
		_tmp40_ = g_new0 (guchar, _tmp39__length1);
		dest = _tmp40_;
		dest_length1 = _tmp39__length1;
		_dest_size_ = dest_length1;
		{
			gint i;
			i = 0;
			{
				gboolean _tmp41_;
				_tmp41_ = TRUE;
				while (TRUE) {
					gboolean _tmp42_;
					gint _tmp44_;
					guchar* _tmp45_;
					gint _tmp45__length1;
					guchar* _tmp46_;
					gint _tmp46__length1;
					gint _tmp47_;
					guchar* _tmp48_;
					gint _tmp48__length1;
					gint _tmp49_;
					guchar _tmp50_;
					guchar _tmp51_;
					_tmp42_ = _tmp41_;
					if (!_tmp42_) {
						gint _tmp43_;
						_tmp43_ = i;
						i = _tmp43_ + 1;
					}
					_tmp41_ = FALSE;
					_tmp44_ = i;
					_tmp45_ = orig;
					_tmp45__length1 = orig_length1;
					if (!(_tmp44_ < _tmp45__length1)) {
						break;
					}
					_tmp46_ = dest;
					_tmp46__length1 = dest_length1;
					_tmp47_ = i;
					_tmp48_ = orig;
					_tmp48__length1 = orig_length1;
					_tmp49_ = i;
					_tmp50_ = _tmp48_[_tmp49_];
					_tmp46_[_tmp47_] = _tmp50_;
					_tmp51_ = _tmp46_[_tmp47_];
				}
			}
		}
		_tmp52_ = dest;
		_tmp52__length1 = dest_length1;
		_tmp53_ = zcd_iserializable_deserialize (_tmp52_, _tmp52__length1, &_inner_error_);
		_tmp54_ = _tmp53_;
		if (_inner_error_ != NULL) {
			dest = (g_free (dest), NULL);
			orig = (g_free (orig), NULL);
			_g_object_unref0 (info);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
		_g_object_unref0 (info);
		info = G_TYPE_CHECK_INSTANCE_CAST (_tmp54_, NETSUKUKU_TYPE_INFO_ANDNA, NetsukukuInfoAndna);
		dest = (g_free (dest), NULL);
		orig = (g_free (orig), NULL);
	}
	_tmp55_ = info;
	_tmp56_ = _tmp55_->pubk;
	_tmp57_ = string_to_string (_tmp56_);
	_tmp58_ = g_strconcat ("pubk ", _tmp57_, "\n", NULL);
	_tmp59_ = _tmp58_;
	ntk_test_print_out (_tmp59_);
	_g_free0 (_tmp59_);
	_tmp60_ = info;
	_tmp61_ = _tmp60_->pubk;
	_vala_assert (g_strcmp0 (_tmp61_, "A7C84D9F02AB") == 0, "info.pubk == \"A7C84D9F02AB\"");
	_tmp62_ = info;
	_tmp63_ = _tmp62_->memory_initialized;
	_vala_assert (_tmp63_, "info.memory_initialized");
	_g_object_unref0 (info);
}


static void __lambda2_ (void) {
	NtkTestAndnaTester* _tmp0_;
	NtkTestAndnaTester* x;
	_tmp0_ = ntk_test_andna_tester_new ();
	x = _tmp0_;
	ntk_test_andna_tester_set_up (x);
	ntk_test_andna_tester_test_timers_boundary (x);
	ntk_test_andna_tester_tear_down (x);
	_g_object_unref0 (x);
}


static void ___lambda2__gcallback (void) {
	__lambda2_ ();
}


static void __lambda3_ (void) {
	NtkTestAndnaTester* _tmp0_;
	NtkTestAndnaTester* x;
	_tmp0_ = ntk_test_andna_tester_new ();
	x = _tmp0_;
	ntk_test_andna_tester_set_up (x);
	ntk_test_andna_tester_test_ser_servkey (x);
	ntk_test_andna_tester_tear_down (x);
	_g_object_unref0 (x);
}


static void ___lambda3__gcallback (void) {
	__lambda3_ ();
}


static void __lambda4_ (void) {
	NtkTestAndnaTester* _tmp0_;
	NtkTestAndnaTester* x;
	_tmp0_ = ntk_test_andna_tester_new ();
	x = _tmp0_;
	ntk_test_andna_tester_set_up (x);
	ntk_test_andna_tester_test_ser_publickey (x);
	ntk_test_andna_tester_tear_down (x);
	_g_object_unref0 (x);
}


static void ___lambda4__gcallback (void) {
	__lambda4_ ();
}


static void __lambda5_ (void) {
	NtkTestAndnaTester* _tmp0_;
	NtkTestAndnaTester* x;
	_tmp0_ = ntk_test_andna_tester_new ();
	x = _tmp0_;
	ntk_test_andna_tester_set_up (x);
	ntk_test_andna_tester_test_server_record_equal_func (x);
	ntk_test_andna_tester_tear_down (x);
	_g_object_unref0 (x);
}


static void ___lambda5__gcallback (void) {
	__lambda5_ ();
}


static void __lambda6_ (void) {
	NtkTestAndnaTester* _tmp0_;
	NtkTestAndnaTester* x;
	_tmp0_ = ntk_test_andna_tester_new ();
	x = _tmp0_;
	ntk_test_andna_tester_set_up (x);
	ntk_test_andna_tester_test_ser_domain_record (x);
	ntk_test_andna_tester_tear_down (x);
	_g_object_unref0 (x);
}


static void ___lambda6__gcallback (void) {
	__lambda6_ ();
}


static void __lambda7_ (void) {
	NtkTestAndnaTester* _tmp0_;
	NtkTestAndnaTester* x;
	_tmp0_ = ntk_test_andna_tester_new ();
	x = _tmp0_;
	ntk_test_andna_tester_set_up (x);
	ntk_test_andna_tester_test_ser_get_cache (x);
	ntk_test_andna_tester_tear_down (x);
	_g_object_unref0 (x);
}


static void ___lambda7__gcallback (void) {
	__lambda7_ ();
}


static void __lambda8_ (void) {
	NtkTestAndnaTester* _tmp0_;
	NtkTestAndnaTester* x;
	_tmp0_ = ntk_test_andna_tester_new ();
	x = _tmp0_;
	ntk_test_andna_tester_set_up (x);
	ntk_test_andna_tester_test_ser_info_andna (x);
	ntk_test_andna_tester_tear_down (x);
	_g_object_unref0 (x);
}


static void ___lambda8__gcallback (void) {
	__lambda8_ ();
}


gint ntk_test_andna_tester_main (gchar** args, int args_length1) {
	gint result = 0;
	g_test_init (&args_length1, &args, NULL);
	tasklets_tasklet_init (64);
	g_test_add_func ("/Andna/Timers", ___lambda2__gcallback);
	g_test_add_func ("/Andna/SerializationServiceKey", ___lambda3__gcallback);
	g_test_add_func ("/Andna/SerializationPublicKey", ___lambda4__gcallback);
	g_test_add_func ("/Andna/DiscriminationServerRecord", ___lambda5__gcallback);
	g_test_add_func ("/Andna/SerializationDomainRecord", ___lambda6__gcallback);
	g_test_add_func ("/Andna/SerializationGetCacheResponse", ___lambda7__gcallback);
	g_test_add_func ("/Andna/SerializationInfoAndna", ___lambda8__gcallback);
	g_test_run ();
	tasklets_tasklet_kill ();
	result = 0;
	return result;
}


int main (int argc, char ** argv) {
	g_type_init ();
	return ntk_test_andna_tester_main (argv, argc);
}


NtkTestAndnaTester* ntk_test_andna_tester_construct (GType object_type) {
	NtkTestAndnaTester * self = NULL;
	self = (NtkTestAndnaTester*) g_object_new (object_type, NULL);
	return self;
}


NtkTestAndnaTester* ntk_test_andna_tester_new (void) {
	return ntk_test_andna_tester_construct (NTK_TEST_TYPE_ANDNA_TESTER);
}


static void ntk_test_andna_tester_class_init (NtkTestAndnaTesterClass * klass) {
	ntk_test_andna_tester_parent_class = g_type_class_peek_parent (klass);
}


static void ntk_test_andna_tester_instance_init (NtkTestAndnaTester * self) {
}


GType ntk_test_andna_tester_get_type (void) {
	static volatile gsize ntk_test_andna_tester_type_id__volatile = 0;
	if (g_once_init_enter (&ntk_test_andna_tester_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (NtkTestAndnaTesterClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) ntk_test_andna_tester_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (NtkTestAndnaTester), 0, (GInstanceInitFunc) ntk_test_andna_tester_instance_init, NULL };
		GType ntk_test_andna_tester_type_id;
		ntk_test_andna_tester_type_id = g_type_register_static (G_TYPE_OBJECT, "NtkTestAndnaTester", &g_define_type_info, 0);
		g_once_init_leave (&ntk_test_andna_tester_type_id__volatile, ntk_test_andna_tester_type_id);
	}
	return ntk_test_andna_tester_type_id__volatile;
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}



