/*
 *  This file is part of Netsukuku.
 *  (c) Copyright 2011-2014 Luca Dionisi aka lukisi <luca.dionisi@gmail.com>
 *
 *  Netsukuku is free software: you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation, either version 3 of the License, or
 *  (at your option) any later version.
 *
 *  Netsukuku is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with Netsukuku.  If not, see <http://www.gnu.org/licenses/>.
 */

using Gee;
using Netsukuku;
using zcd;
using Tasklets;

namespace Ntk.Test
{
    string logger;
    const bool output = true;
    public void print_out(string s)
    {
        if (output) print(s);
    }

    public class CoordinatorTester : Object
    {
        public void set_up ()
        {
            logger = "";
        }

        public void tear_down ()
        {
            logger = "";
        }

        void display_memory(CoordinatorMemory mem)
        {
            foreach (PartialNIP i in mem.keys)
            {
                print_out(@"gnode $(i):\n");
                int eld = mem.get_last_assigned_eldership(i);
                print_out(@"  last assigned eldership was $(eld)\n");
                Gee.List<CoordinatorBooking> b_list = mem.get_bookings(i);
                print_out(@"  it has $(b_list.size) reserved positions\n");
                foreach (CoordinatorBooking b in b_list)
                {
                    print_out(@"  pos $(b.pos) for $(b.tc_expire.get_string_msec_ttl()) msec\n");
                }
            }
        }

        public void test_ser_memory ()
        {
            CoordinatorMemory mem;
            {
                uchar[] orig;
                {
                    // create and valorize a memory object
                    CoordinatorMemory ret = new CoordinatorMemory(new NIP({1,2,3,4}));
                    LinkedList<CoordinatorBooking> b0 =
                        new LinkedList<CoordinatorBooking>(CoordinatorBooking.equal_func);
                    b0.add(new CoordinatorBooking(3));
                    b0.add(new CoordinatorBooking(2));
                    ret.set_gnode(new PartialNIP({-1,2,3,4}), 3, b0);
                    LinkedList<CoordinatorBooking> b1 =
                        new LinkedList<CoordinatorBooking>(CoordinatorBooking.equal_func);
                    b1.add(new CoordinatorBooking(3));
                    b1.add(new CoordinatorBooking(2));
                    ret.set_gnode(new PartialNIP({-1,-1,3,4}), 5, b1);
                    // see its content right now
                    print_out("\n");
                    display_memory(ret);
                    // serialize
                    orig = ret.serialize();
                }
                uchar []dest = new uchar[orig.length];
                for (int i = 0; i < orig.length; i++) dest[i] = orig[i];
                mem = (CoordinatorMemory)ISerializable.deserialize(dest);
            }
            display_memory(mem);
            // check state of this gnode
            PartialNIP checkgnode = new PartialNIP({-1,-1,3,4});
            assert(mem.get_last_assigned_eldership(checkgnode) == 5);
            bool three_reserved = false;
            foreach (CoordinatorBooking b in mem.get_bookings(checkgnode))
            {
                if (b.pos == 3) three_reserved = true;
            }
            assert(three_reserved);
        }

        public static int main(string[] args)
        {
            GLib.Test.init(ref args);
            Tasklet.init();
            GLib.Test.add_func ("/Coordinator/SerializationMemory", () => {
                var x = new CoordinatorTester();
                x.set_up();
                x.test_ser_memory();
                x.tear_down();
            });
            GLib.Test.run();
            Tasklet.kill();
            return 0;
        }
    }
}
