/* qspn_tester_1.c generated by valac 0.20.1, the Vala compiler
 * generated from qspn_tester_1.vala, do not modify */

/*
 *  This file is part of Netsukuku.
 *  (c) Copyright 2011-2014 Luca Dionisi aka lukisi <luca.dionisi@gmail.com>
 *
 *  Netsukuku is free software: you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation, either version 3 of the License, or
 *  (at your option) any later version.
 *
 *  Netsukuku is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with Netsukuku.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <tasklet.h>
#include <syslog.h>
#include <netsukuku-rpc.h>
#include <gee.h>
#include <zcd.h>
#include <stdio.h>
#include <gobject/gvaluecollector.h>

#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

#define NETSUKUKU_TYPE_ROUTE (netsukuku_route_get_type ())
#define NETSUKUKU_ROUTE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), NETSUKUKU_TYPE_ROUTE, NetsukukuRoute))
#define NETSUKUKU_ROUTE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), NETSUKUKU_TYPE_ROUTE, NetsukukuRouteClass))
#define NETSUKUKU_IS_ROUTE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), NETSUKUKU_TYPE_ROUTE))
#define NETSUKUKU_IS_ROUTE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), NETSUKUKU_TYPE_ROUTE))
#define NETSUKUKU_ROUTE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), NETSUKUKU_TYPE_ROUTE, NetsukukuRouteClass))

typedef struct _NetsukukuRoute NetsukukuRoute;
typedef struct _NetsukukuRouteClass NetsukukuRouteClass;
typedef struct _NetsukukuRoutePrivate NetsukukuRoutePrivate;

#define NETSUKUKU_TYPE_ROUTE_NODE (netsukuku_route_node_get_type ())
#define NETSUKUKU_ROUTE_NODE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), NETSUKUKU_TYPE_ROUTE_NODE, NetsukukuRouteNode))
#define NETSUKUKU_ROUTE_NODE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), NETSUKUKU_TYPE_ROUTE_NODE, NetsukukuRouteNodeClass))
#define NETSUKUKU_IS_ROUTE_NODE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), NETSUKUKU_TYPE_ROUTE_NODE))
#define NETSUKUKU_IS_ROUTE_NODE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), NETSUKUKU_TYPE_ROUTE_NODE))
#define NETSUKUKU_ROUTE_NODE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), NETSUKUKU_TYPE_ROUTE_NODE, NetsukukuRouteNodeClass))

typedef struct _NetsukukuRouteNode NetsukukuRouteNode;
typedef struct _NetsukukuRouteNodeClass NetsukukuRouteNodeClass;
typedef struct _NetsukukuRouteNodePrivate NetsukukuRouteNodePrivate;

#define NETSUKUKU_TYPE_AGGREGATED_NEIGHBOUR (netsukuku_aggregated_neighbour_get_type ())
#define NETSUKUKU_AGGREGATED_NEIGHBOUR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), NETSUKUKU_TYPE_AGGREGATED_NEIGHBOUR, NetsukukuAggregatedNeighbour))
#define NETSUKUKU_AGGREGATED_NEIGHBOUR_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), NETSUKUKU_TYPE_AGGREGATED_NEIGHBOUR, NetsukukuAggregatedNeighbourClass))
#define NETSUKUKU_IS_AGGREGATED_NEIGHBOUR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), NETSUKUKU_TYPE_AGGREGATED_NEIGHBOUR))
#define NETSUKUKU_IS_AGGREGATED_NEIGHBOUR_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), NETSUKUKU_TYPE_AGGREGATED_NEIGHBOUR))
#define NETSUKUKU_AGGREGATED_NEIGHBOUR_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), NETSUKUKU_TYPE_AGGREGATED_NEIGHBOUR, NetsukukuAggregatedNeighbourClass))

typedef struct _NetsukukuAggregatedNeighbour NetsukukuAggregatedNeighbour;
typedef struct _NetsukukuAggregatedNeighbourClass NetsukukuAggregatedNeighbourClass;

#define NETSUKUKU_TYPE_MAP_ROUTE (netsukuku_map_route_get_type ())
#define NETSUKUKU_MAP_ROUTE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), NETSUKUKU_TYPE_MAP_ROUTE, NetsukukuMapRoute))
#define NETSUKUKU_MAP_ROUTE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), NETSUKUKU_TYPE_MAP_ROUTE, NetsukukuMapRouteClass))
#define NETSUKUKU_IS_MAP_ROUTE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), NETSUKUKU_TYPE_MAP_ROUTE))
#define NETSUKUKU_IS_MAP_ROUTE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), NETSUKUKU_TYPE_MAP_ROUTE))
#define NETSUKUKU_MAP_ROUTE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), NETSUKUKU_TYPE_MAP_ROUTE, NetsukukuMapRouteClass))

typedef struct _NetsukukuMapRoute NetsukukuMapRoute;
typedef struct _NetsukukuMapRouteClass NetsukukuMapRouteClass;
typedef struct _NetsukukuMapRoutePrivate NetsukukuMapRoutePrivate;

#define NETSUKUKU_TYPE_ADDRESS_MANAGER (netsukuku_address_manager_get_type ())
#define NETSUKUKU_ADDRESS_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), NETSUKUKU_TYPE_ADDRESS_MANAGER, NetsukukuAddressManager))
#define NETSUKUKU_ADDRESS_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), NETSUKUKU_TYPE_ADDRESS_MANAGER, NetsukukuAddressManagerClass))
#define NETSUKUKU_IS_ADDRESS_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), NETSUKUKU_TYPE_ADDRESS_MANAGER))
#define NETSUKUKU_IS_ADDRESS_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), NETSUKUKU_TYPE_ADDRESS_MANAGER))
#define NETSUKUKU_ADDRESS_MANAGER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), NETSUKUKU_TYPE_ADDRESS_MANAGER, NetsukukuAddressManagerClass))

typedef struct _NetsukukuAddressManager NetsukukuAddressManager;
typedef struct _NetsukukuAddressManagerClass NetsukukuAddressManagerClass;
typedef struct _NetsukukuAddressManagerPrivate NetsukukuAddressManagerPrivate;

#define NETSUKUKU_TYPE_NETWORK_INTERFACE_MANAGER (netsukuku_network_interface_manager_get_type ())
#define NETSUKUKU_NETWORK_INTERFACE_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), NETSUKUKU_TYPE_NETWORK_INTERFACE_MANAGER, NetsukukuNetworkInterfaceManager))
#define NETSUKUKU_NETWORK_INTERFACE_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), NETSUKUKU_TYPE_NETWORK_INTERFACE_MANAGER, NetsukukuNetworkInterfaceManagerClass))
#define NETSUKUKU_IS_NETWORK_INTERFACE_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), NETSUKUKU_TYPE_NETWORK_INTERFACE_MANAGER))
#define NETSUKUKU_IS_NETWORK_INTERFACE_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), NETSUKUKU_TYPE_NETWORK_INTERFACE_MANAGER))
#define NETSUKUKU_NETWORK_INTERFACE_MANAGER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), NETSUKUKU_TYPE_NETWORK_INTERFACE_MANAGER, NetsukukuNetworkInterfaceManagerClass))

typedef struct _NetsukukuNetworkInterfaceManager NetsukukuNetworkInterfaceManager;
typedef struct _NetsukukuNetworkInterfaceManagerClass NetsukukuNetworkInterfaceManagerClass;

#define NETSUKUKU_TYPE_INCOMING_NODES (netsukuku_incoming_nodes_get_type ())
#define NETSUKUKU_INCOMING_NODES(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), NETSUKUKU_TYPE_INCOMING_NODES, NetsukukuIncomingNodes))
#define NETSUKUKU_INCOMING_NODES_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), NETSUKUKU_TYPE_INCOMING_NODES, NetsukukuIncomingNodesClass))
#define NETSUKUKU_IS_INCOMING_NODES(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), NETSUKUKU_TYPE_INCOMING_NODES))
#define NETSUKUKU_IS_INCOMING_NODES_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), NETSUKUKU_TYPE_INCOMING_NODES))
#define NETSUKUKU_INCOMING_NODES_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), NETSUKUKU_TYPE_INCOMING_NODES, NetsukukuIncomingNodesClass))

typedef struct _NetsukukuIncomingNodes NetsukukuIncomingNodes;
typedef struct _NetsukukuIncomingNodesClass NetsukukuIncomingNodesClass;
#define _netsukuku_incoming_nodes_unref0(var) ((var == NULL) ? NULL : (var = (netsukuku_incoming_nodes_unref (var), NULL)))

#define NETSUKUKU_TYPE_FAKE_ADDRESS_MANAGER_FAKE_RMT (netsukuku_fake_address_manager_fake_rmt_get_type ())
#define NETSUKUKU_FAKE_ADDRESS_MANAGER_FAKE_RMT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), NETSUKUKU_TYPE_FAKE_ADDRESS_MANAGER_FAKE_RMT, NetsukukuFakeAddressManagerFakeRmt))
#define NETSUKUKU_FAKE_ADDRESS_MANAGER_FAKE_RMT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), NETSUKUKU_TYPE_FAKE_ADDRESS_MANAGER_FAKE_RMT, NetsukukuFakeAddressManagerFakeRmtClass))
#define NETSUKUKU_IS_FAKE_ADDRESS_MANAGER_FAKE_RMT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), NETSUKUKU_TYPE_FAKE_ADDRESS_MANAGER_FAKE_RMT))
#define NETSUKUKU_IS_FAKE_ADDRESS_MANAGER_FAKE_RMT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), NETSUKUKU_TYPE_FAKE_ADDRESS_MANAGER_FAKE_RMT))
#define NETSUKUKU_FAKE_ADDRESS_MANAGER_FAKE_RMT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), NETSUKUKU_TYPE_FAKE_ADDRESS_MANAGER_FAKE_RMT, NetsukukuFakeAddressManagerFakeRmtClass))

typedef struct _NetsukukuFakeAddressManagerFakeRmt NetsukukuFakeAddressManagerFakeRmt;
typedef struct _NetsukukuFakeAddressManagerFakeRmtClass NetsukukuFakeAddressManagerFakeRmtClass;

#define NETSUKUKU_TYPE_NIC (netsukuku_nic_get_type ())
#define NETSUKUKU_NIC(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), NETSUKUKU_TYPE_NIC, NetsukukuNIC))
#define NETSUKUKU_NIC_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), NETSUKUKU_TYPE_NIC, NetsukukuNICClass))
#define NETSUKUKU_IS_NIC(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), NETSUKUKU_TYPE_NIC))
#define NETSUKUKU_IS_NIC_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), NETSUKUKU_TYPE_NIC))
#define NETSUKUKU_NIC_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), NETSUKUKU_TYPE_NIC, NetsukukuNICClass))

typedef struct _NetsukukuNIC NetsukukuNIC;
typedef struct _NetsukukuNICClass NetsukukuNICClass;
typedef struct _NetsukukuNICPrivate NetsukukuNICPrivate;
typedef struct _NetsukukuNetworkInterfaceManagerPrivate NetsukukuNetworkInterfaceManagerPrivate;

#define NETSUKUKU_TYPE_AGGREGATED_NEIGHBOUR_MANAGER (netsukuku_aggregated_neighbour_manager_get_type ())
#define NETSUKUKU_AGGREGATED_NEIGHBOUR_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), NETSUKUKU_TYPE_AGGREGATED_NEIGHBOUR_MANAGER, NetsukukuAggregatedNeighbourManager))
#define NETSUKUKU_AGGREGATED_NEIGHBOUR_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), NETSUKUKU_TYPE_AGGREGATED_NEIGHBOUR_MANAGER, NetsukukuAggregatedNeighbourManagerClass))
#define NETSUKUKU_IS_AGGREGATED_NEIGHBOUR_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), NETSUKUKU_TYPE_AGGREGATED_NEIGHBOUR_MANAGER))
#define NETSUKUKU_IS_AGGREGATED_NEIGHBOUR_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), NETSUKUKU_TYPE_AGGREGATED_NEIGHBOUR_MANAGER))
#define NETSUKUKU_AGGREGATED_NEIGHBOUR_MANAGER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), NETSUKUKU_TYPE_AGGREGATED_NEIGHBOUR_MANAGER, NetsukukuAggregatedNeighbourManagerClass))

typedef struct _NetsukukuAggregatedNeighbourManager NetsukukuAggregatedNeighbourManager;
typedef struct _NetsukukuAggregatedNeighbourManagerClass NetsukukuAggregatedNeighbourManagerClass;
typedef struct _NetsukukuAggregatedNeighbourManagerPrivate NetsukukuAggregatedNeighbourManagerPrivate;
typedef struct _NetsukukuAggregatedNeighbourPrivate NetsukukuAggregatedNeighbourPrivate;
typedef struct _NetsukukuFakeAddressManagerFakeRmtPrivate NetsukukuFakeAddressManagerFakeRmtPrivate;

#define NETSUKUKU_TYPE_ETP (netsukuku_etp_get_type ())
#define NETSUKUKU_ETP(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), NETSUKUKU_TYPE_ETP, NetsukukuEtp))
#define NETSUKUKU_ETP_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), NETSUKUKU_TYPE_ETP, NetsukukuEtpClass))
#define NETSUKUKU_IS_ETP(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), NETSUKUKU_TYPE_ETP))
#define NETSUKUKU_IS_ETP_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), NETSUKUKU_TYPE_ETP))
#define NETSUKUKU_ETP_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), NETSUKUKU_TYPE_ETP, NetsukukuEtpClass))

typedef struct _NetsukukuEtp NetsukukuEtp;
typedef struct _NetsukukuEtpClass NetsukukuEtpClass;
typedef struct _NetsukukuIncomingNodesPrivate NetsukukuIncomingNodesPrivate;
typedef struct _NetsukukuParamSpecIncomingNodes NetsukukuParamSpecIncomingNodes;

#define NTK_TEST_TYPE_QSPN_TESTER (ntk_test_qspn_tester_get_type ())
#define NTK_TEST_QSPN_TESTER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), NTK_TEST_TYPE_QSPN_TESTER, NtkTestQspnTester))
#define NTK_TEST_QSPN_TESTER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), NTK_TEST_TYPE_QSPN_TESTER, NtkTestQspnTesterClass))
#define NTK_TEST_IS_QSPN_TESTER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), NTK_TEST_TYPE_QSPN_TESTER))
#define NTK_TEST_IS_QSPN_TESTER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), NTK_TEST_TYPE_QSPN_TESTER))
#define NTK_TEST_QSPN_TESTER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), NTK_TEST_TYPE_QSPN_TESTER, NtkTestQspnTesterClass))

typedef struct _NtkTestQspnTester NtkTestQspnTester;
typedef struct _NtkTestQspnTesterClass NtkTestQspnTesterClass;
typedef struct _NtkTestQspnTesterPrivate NtkTestQspnTesterPrivate;
#define _vala_assert(expr, msg) if G_LIKELY (expr) ; else g_assertion_message_expr (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);

typedef enum  {
	NETSUKUKU_CRYPTO_GCRYPT_ERROR_GENERIC
} NetsukukuCryptoGCryptError;
#define NETSUKUKU_CRYPTO_GCRYPT_ERROR netsukuku_crypto_gcrypt_error_quark ()
typedef enum  {
	NETSUKUKU_INCOMING_NODES_ERROR_GENERIC
} NetsukukuIncomingNodesError;
#define NETSUKUKU_INCOMING_NODES_ERROR netsukuku_incoming_nodes_error_quark ()
typedef enum  {
	NETSUKUKU_RPC_ERROR_FUNCTION_NOT_REMOTABLE,
	NETSUKUKU_RPC_ERROR_MALFORMED_PACKET,
	NETSUKUKU_RPC_ERROR_NETWORK_ERROR,
	NETSUKUKU_RPC_ERROR_NOT_VALID_MAP_YET,
	NETSUKUKU_RPC_ERROR_DROP,
	NETSUKUKU_RPC_ERROR_GENERIC
} NetsukukuRPCError;
#define NETSUKUKU_RPC_ERROR netsukuku_rpc_error_quark ()
struct _NetsukukuRoute {
	GObject parent_instance;
	NetsukukuRoutePrivate * priv;
	NetsukukuREM* rem;
	NetsukukuREM* rem_at_gw;
	GeeList* hops;
	NetsukukuGNodeID* gid;
	GeeList* hops_with_gw;
};

struct _NetsukukuRouteClass {
	GObjectClass parent_class;
};

struct _NetsukukuRouteNode {
	GObject parent_instance;
	NetsukukuRouteNodePrivate * priv;
};

struct _NetsukukuRouteNodeClass {
	GObjectClass parent_class;
};

struct _NetsukukuMapRoute {
	GObject parent_instance;
	NetsukukuMapRoutePrivate * priv;
	NetsukukuAddressManager* address_manager;
	gint gsize;
	gint levels;
	NetsukukuNIP* me;
};

struct _NetsukukuMapRouteClass {
	GObjectClass parent_class;
};

struct _NetsukukuMapRoutePrivate {
	NetsukukuGNodeID** _id_myself;
	gint _id_myself_length1;
	gint __id_myself_size_;
};

struct _NetsukukuAddressManager {
	GObject parent_instance;
	NetsukukuAddressManagerPrivate * priv;
	GeeArrayList* nics;
	NetsukukuIncomingNodes* incoming_nodes;
	gboolean is_mature;
};

struct _NetsukukuAddressManagerClass {
	GObjectClass parent_class;
};

struct _NetsukukuNIC {
	GObject parent_instance;
	NetsukukuNICPrivate * priv;
	gchar* mac;
};

struct _NetsukukuNICClass {
	GObjectClass parent_class;
};

struct _NetsukukuNetworkInterfaceManager {
	GObject parent_instance;
	NetsukukuNetworkInterfaceManagerPrivate * priv;
	gboolean to_be_managed;
	gboolean to_be_copied;
	gboolean initialized;
};

struct _NetsukukuNetworkInterfaceManagerClass {
	GObjectClass parent_class;
};

struct _NetsukukuNetworkInterfaceManagerPrivate {
	NetsukukuNIC* _nic_class;
	gchar* _nic_name;
};

struct _NetsukukuAggregatedNeighbourManager {
	GObject parent_instance;
	NetsukukuAggregatedNeighbourManagerPrivate * priv;
};

struct _NetsukukuAggregatedNeighbourManagerClass {
	GObjectClass parent_class;
};

struct _NetsukukuAggregatedNeighbour {
	GObject parent_instance;
	NetsukukuAggregatedNeighbourPrivate * priv;
	NetsukukuNIP* nip;
	NetsukukuREM* rem;
	gint mod_seq_num;
	NetsukukuNetworkID* netid;
	NetsukukuAddressManagerFakeRmt* neighbour_client;
	gint nodeid;
};

struct _NetsukukuAggregatedNeighbourClass {
	GObjectClass parent_class;
};

struct _NetsukukuFakeAddressManagerFakeRmt {
	NetsukukuAddressManagerFakeRmt parent_instance;
	NetsukukuFakeAddressManagerFakeRmtPrivate * priv;
	NetsukukuEtp* etp;
};

struct _NetsukukuFakeAddressManagerFakeRmtClass {
	NetsukukuAddressManagerFakeRmtClass parent_class;
};

struct _NetsukukuIncomingNodes {
	GTypeInstance parent_instance;
	volatile int ref_count;
	NetsukukuIncomingNodesPrivate * priv;
};

struct _NetsukukuIncomingNodesClass {
	GTypeClass parent_class;
	void (*finalize) (NetsukukuIncomingNodes *self);
};

struct _NetsukukuParamSpecIncomingNodes {
	GParamSpec parent_instance;
};

struct _NtkTestQspnTester {
	GObject parent_instance;
	NtkTestQspnTesterPrivate * priv;
};

struct _NtkTestQspnTesterClass {
	GObjectClass parent_class;
};

struct _NtkTestQspnTesterPrivate {
	gchar* logger;
};


static gpointer netsukuku_route_parent_class = NULL;
static gpointer netsukuku_route_node_parent_class = NULL;
static gpointer netsukuku_map_route_parent_class = NULL;
static gpointer netsukuku_address_manager_parent_class = NULL;
static gpointer netsukuku_nic_parent_class = NULL;
static gpointer netsukuku_network_interface_manager_parent_class = NULL;
static gpointer netsukuku_aggregated_neighbour_manager_parent_class = NULL;
static gpointer netsukuku_aggregated_neighbour_parent_class = NULL;
static gpointer netsukuku_fake_address_manager_fake_rmt_parent_class = NULL;
static gpointer netsukuku_incoming_nodes_parent_class = NULL;
static gpointer ntk_test_qspn_tester_parent_class = NULL;

gchar* netsukuku_tasklet_id (void);
void netsukuku_log_debug (const gchar* msg);
void netsukuku_log_info (const gchar* msg);
void netsukuku_log_notice (const gchar* msg);
void netsukuku_log_warn (const gchar* msg);
void netsukuku_log_error (const gchar* msg);
void netsukuku_log_critical (const gchar* msg);
GQuark netsukuku_crypto_gcrypt_error_quark (void);
guint32 netsukuku_crypto_fnv_32 (guchar* data, int data_length1);
GQuark netsukuku_incoming_nodes_error_quark (void);
GQuark netsukuku_rpc_error_quark (void);
GeeArrayList* netsukuku_valid_ids (gint levels, gint gsize, gint lvl, NetsukukuPartialNIP* partial_nip);
gchar* netsukuku_nip_to_str (gint levels, gint gsize, NetsukukuNIP* nip);
GType netsukuku_route_get_type (void) G_GNUC_CONST;
enum  {
	NETSUKUKU_ROUTE_DUMMY_PROPERTY
};
NetsukukuRoute* netsukuku_route_new (void);
NetsukukuRoute* netsukuku_route_construct (GType object_type);
static void netsukuku_route_finalize (GObject* obj);
GType netsukuku_route_node_get_type (void) G_GNUC_CONST;
enum  {
	NETSUKUKU_ROUTE_NODE_DUMMY_PROPERTY
};
gboolean netsukuku_route_node_is_empty (NetsukukuRouteNode* self);
gboolean netsukuku_route_node_is_free (NetsukukuRouteNode* self);
NetsukukuGNodeID* netsukuku_route_node_get_eldest_gid (NetsukukuRouteNode* self);
gint netsukuku_route_node_nroutes (NetsukukuRouteNode* self);
NetsukukuRoute* netsukuku_route_node_best_route (NetsukukuRouteNode* self);
NetsukukuRoute* netsukuku_route_node_best_route_without (NetsukukuRouteNode* self, NetsukukuHCoord* hop);
GType netsukuku_aggregated_neighbour_get_type (void) G_GNUC_CONST;
NetsukukuRoute* netsukuku_route_node_route_get_by_gw (NetsukukuRouteNode* self, NetsukukuAggregatedNeighbour* aggregated_neighbour);
NetsukukuRouteNode* netsukuku_route_node_new (void);
NetsukukuRouteNode* netsukuku_route_node_construct (GType object_type);
GType netsukuku_map_route_get_type (void) G_GNUC_CONST;
GType netsukuku_address_manager_get_type (void) G_GNUC_CONST;
#define NETSUKUKU_MAP_ROUTE_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), NETSUKUKU_TYPE_MAP_ROUTE, NetsukukuMapRoutePrivate))
enum  {
	NETSUKUKU_MAP_ROUTE_DUMMY_PROPERTY
};
NetsukukuHCoord* netsukuku_map_route_nip_to_lvlid (NetsukukuMapRoute* self, NetsukukuNIP* nip_caller);
NetsukukuRouteNode* netsukuku_map_route_node_get (NetsukukuMapRoute* self, gint lvl, gint pos);
GeeList* netsukuku_map_route_list_lvl_id_from_nip (NetsukukuMapRoute* self, GeeList* lvl_ids, NetsukukuNIP* sender_nip);
GeeList* netsukuku_map_route_list_lvl_id_to_nip (NetsukukuMapRoute* self, GeeList* lvl_ids, NetsukukuNIP* to_nip);
gint netsukuku_map_route_nip_cmp (NetsukukuMapRoute* self, gint* nipA, int nipA_length1);
void netsukuku_map_route_update_route_by_gw (NetsukukuMapRoute* self, NetsukukuHCoord* dest, NetsukukuAggregatedNeighbour* nr, NetsukukuREM* rem_at_gw, GeeList* hops, NetsukukuGNodeID* gid);
gint netsukuku_map_route_busy_nodes_nb (NetsukukuMapRoute* self, gint lvl);
void netsukuku_map_route_route_signal_rem_changed (NetsukukuMapRoute* self, gint lvl, gint dst);
void netsukuku_map_route_delete_routes_via_neighbour (NetsukukuMapRoute* self, NetsukukuAggregatedNeighbour* aggregated_neighbour);
NetsukukuMapRoute* netsukuku_map_route_new (void);
NetsukukuMapRoute* netsukuku_map_route_construct (GType object_type);
NetsukukuGNodeID** netsukuku_map_route_get_id_myself (NetsukukuMapRoute* self, int* result_length1);
static void netsukuku_map_route_set_id_myself (NetsukukuMapRoute* self, NetsukukuGNodeID** value, int value_length1);
static NetsukukuGNodeID** _vala_array_dup1 (NetsukukuGNodeID** self, int length);
static void netsukuku_map_route_finalize (GObject* obj);
static void _vala_netsukuku_map_route_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void _vala_netsukuku_map_route_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);
GType netsukuku_network_interface_manager_get_type (void) G_GNUC_CONST;
gpointer netsukuku_incoming_nodes_ref (gpointer instance);
void netsukuku_incoming_nodes_unref (gpointer instance);
GParamSpec* netsukuku_param_spec_incoming_nodes (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void netsukuku_value_set_incoming_nodes (GValue* value, gpointer v_object);
void netsukuku_value_take_incoming_nodes (GValue* value, gpointer v_object);
gpointer netsukuku_value_get_incoming_nodes (const GValue* value);
GType netsukuku_incoming_nodes_get_type (void) G_GNUC_CONST;
enum  {
	NETSUKUKU_ADDRESS_MANAGER_DUMMY_PROPERTY
};
NetsukukuNetworkID* netsukuku_address_manager_get_main_netid (NetsukukuAddressManager* self);
gboolean netsukuku_address_manager_is_in_my_network (NetsukukuAddressManager* self, NetsukukuNetworkID* netid);
gboolean netsukuku_address_manager_do_i_act_as_gateway_for (NetsukukuAddressManager* self, NetsukukuNIP* nip, gint nodeid, NetsukukuNetworkID* netid);
gint netsukuku_address_manager_get_my_id (NetsukukuAddressManager* self);
NetsukukuAddressManagerFakeRmt* netsukuku_address_manager_get_broadcast_client (NetsukukuAddressManager* self);
NetsukukuFakeAddressManagerFakeRmt* netsukuku_fake_address_manager_fake_rmt_new (void);
NetsukukuFakeAddressManagerFakeRmt* netsukuku_fake_address_manager_fake_rmt_construct (GType object_type);
GType netsukuku_fake_address_manager_fake_rmt_get_type (void) G_GNUC_CONST;
gboolean netsukuku_address_manager_is_preferred_network (NetsukukuAddressManager* self, NetsukukuNetworkID* netid);
NetsukukuAddressManager* netsukuku_address_manager_new (void);
NetsukukuAddressManager* netsukuku_address_manager_construct (GType object_type);
static void netsukuku_address_manager_finalize (GObject* obj);
GType netsukuku_nic_get_type (void) G_GNUC_CONST;
enum  {
	NETSUKUKU_NIC_DUMMY_PROPERTY
};
NetsukukuNIC* netsukuku_nic_new (void);
NetsukukuNIC* netsukuku_nic_construct (GType object_type);
static void netsukuku_nic_finalize (GObject* obj);
#define NETSUKUKU_NETWORK_INTERFACE_MANAGER_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), NETSUKUKU_TYPE_NETWORK_INTERFACE_MANAGER, NetsukukuNetworkInterfaceManagerPrivate))
enum  {
	NETSUKUKU_NETWORK_INTERFACE_MANAGER_DUMMY_PROPERTY,
	NETSUKUKU_NETWORK_INTERFACE_MANAGER_NIC_CLASS,
	NETSUKUKU_NETWORK_INTERFACE_MANAGER_NIC_NAME
};
NetsukukuNetworkInterfaceManager* netsukuku_network_interface_manager_new (void);
NetsukukuNetworkInterfaceManager* netsukuku_network_interface_manager_construct (GType object_type);
NetsukukuNIC* netsukuku_network_interface_manager_get_nic_class (NetsukukuNetworkInterfaceManager* self);
static void netsukuku_network_interface_manager_set_nic_class (NetsukukuNetworkInterfaceManager* self, NetsukukuNIC* value);
const gchar* netsukuku_network_interface_manager_get_nic_name (NetsukukuNetworkInterfaceManager* self);
static void netsukuku_network_interface_manager_set_nic_name (NetsukukuNetworkInterfaceManager* self, const gchar* value);
static void netsukuku_network_interface_manager_finalize (GObject* obj);
static void _vala_netsukuku_network_interface_manager_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void _vala_netsukuku_network_interface_manager_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);
GType netsukuku_aggregated_neighbour_manager_get_type (void) G_GNUC_CONST;
enum  {
	NETSUKUKU_AGGREGATED_NEIGHBOUR_MANAGER_DUMMY_PROPERTY
};
GeeList* netsukuku_aggregated_neighbour_manager_neighbour_list (NetsukukuAggregatedNeighbourManager* self, gboolean* b, NetsukukuNetworkID* with_this_netid);
NetsukukuAggregatedNeighbour* netsukuku_aggregated_neighbour_manager_key_to_neighbour (NetsukukuAggregatedNeighbourManager* self, NetsukukuNIP* nip, gint nodeid);
NetsukukuAggregatedNeighbourManager* netsukuku_aggregated_neighbour_manager_new (void);
NetsukukuAggregatedNeighbourManager* netsukuku_aggregated_neighbour_manager_construct (GType object_type);
static void g_cclosure_user_marshal_VOID__OBJECT_OBJECT (GClosure * closure, GValue * return_value, guint n_param_values, const GValue * param_values, gpointer invocation_hint, gpointer marshal_data);
enum  {
	NETSUKUKU_AGGREGATED_NEIGHBOUR_DUMMY_PROPERTY
};
gchar* netsukuku_aggregated_neighbour_to_string (NetsukukuAggregatedNeighbour* self);
NetsukukuAddressManagerFakeRmt* netsukuku_aggregated_neighbour_create_neighbour_client (NetsukukuAggregatedNeighbour* self, gboolean response);
gboolean netsukuku_aggregated_neighbour_equal_func (NetsukukuAggregatedNeighbour* a, NetsukukuAggregatedNeighbour* b);
guint netsukuku_aggregated_neighbour_hash_func (NetsukukuAggregatedNeighbour* a);
NetsukukuAggregatedNeighbour* netsukuku_aggregated_neighbour_new (void);
NetsukukuAggregatedNeighbour* netsukuku_aggregated_neighbour_construct (GType object_type);
static void netsukuku_aggregated_neighbour_finalize (GObject* obj);
GType netsukuku_etp_get_type (void) G_GNUC_CONST;
enum  {
	NETSUKUKU_FAKE_ADDRESS_MANAGER_FAKE_RMT_DUMMY_PROPERTY
};
static zcdISerializable* netsukuku_fake_address_manager_fake_rmt_real_rmt (NetsukukuAddressManagerFakeRmt* base, zcdRemoteCall* data, GError** error);
static void netsukuku_fake_address_manager_fake_rmt_finalize (GObject* obj);
enum  {
	NETSUKUKU_INCOMING_NODES_DUMMY_PROPERTY
};
gboolean netsukuku_incoming_nodes_contains (NetsukukuIncomingNodes* self, NetsukukuNIP* nip, gint nodeid);
NetsukukuRoutesSet* netsukuku_incoming_nodes_get_knowledge (NetsukukuIncomingNodes* self, NetsukukuNIP* nip, gint nodeid, gint prev_seq_num);
void netsukuku_incoming_nodes_update (NetsukukuIncomingNodes* self, NetsukukuNIP* nip, gint nodeid, GeeList* macs, gint* ttl);
void netsukuku_incoming_nodes_log_knowledge (NetsukukuIncomingNodes* self, NetsukukuNIP* nip, gint nodeid, gint my_seq_num, NetsukukuRoutesSet* destinations);
void netsukuku_incoming_nodes_purge (NetsukukuIncomingNodes* self);
NetsukukuIncomingNodes* netsukuku_incoming_nodes_new (void);
NetsukukuIncomingNodes* netsukuku_incoming_nodes_construct (GType object_type);
static void netsukuku_incoming_nodes_finalize (NetsukukuIncomingNodes* obj);
GType ntk_test_qspn_tester_get_type (void) G_GNUC_CONST;
#define NTK_TEST_QSPN_TESTER_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), NTK_TEST_TYPE_QSPN_TESTER, NtkTestQspnTesterPrivate))
enum  {
	NTK_TEST_QSPN_TESTER_DUMMY_PROPERTY
};
#define NTK_TEST_QSPN_TESTER_output FALSE
void ntk_test_qspn_tester_set_up (NtkTestQspnTester* self);
void ntk_test_qspn_tester_tear_down (NtkTestQspnTester* self);
void ntk_test_qspn_tester_test_basics (NtkTestQspnTester* self);
static gboolean _netsukuku_hcoord_equal_func_gee_equal_data_func (gconstpointer a, gconstpointer b, gpointer self);
gint ntk_test_qspn_tester_main (gchar** args, int args_length1);
static void __lambda2_ (void);
NtkTestQspnTester* ntk_test_qspn_tester_new (void);
NtkTestQspnTester* ntk_test_qspn_tester_construct (GType object_type);
static void ___lambda2__gcallback (void);
static void ntk_test_qspn_tester_finalize (GObject* obj);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);


gchar* netsukuku_tasklet_id (void) {
	gchar* result = NULL;
	TaskletsTasklet* _tmp0_ = NULL;
	TaskletsTasklet* _tmp1_;
	gint _tmp2_;
	gint _tmp3_;
	gchar* _tmp4_ = NULL;
	gchar* _tmp5_;
	gchar* _tmp6_ = NULL;
	gchar* _tmp7_;
	_tmp0_ = tasklets_tasklet_self ();
	_tmp1_ = _tmp0_;
	_tmp2_ = tasklets_tasklet_get_id (_tmp1_);
	_tmp3_ = _tmp2_;
	_tmp4_ = g_strdup_printf ("%i", _tmp3_);
	_tmp5_ = _tmp4_;
	_tmp6_ = g_strconcat ("[", _tmp5_, "] ", NULL);
	_tmp7_ = _tmp6_;
	_g_free0 (_tmp5_);
	_g_object_unref0 (_tmp1_);
	result = _tmp7_;
	return result;
}


void netsukuku_log_debug (const gchar* msg) {
	gchar* _tmp0_ = NULL;
	gchar* _tmp1_;
	const gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	g_return_if_fail (msg != NULL);
	_tmp0_ = netsukuku_tasklet_id ();
	_tmp1_ = _tmp0_;
	_tmp2_ = msg;
	_tmp3_ = g_strconcat (_tmp1_, _tmp2_, NULL);
	_tmp4_ = _tmp3_;
	syslog (LOG_DEBUG, _tmp4_, NULL);
	_g_free0 (_tmp4_);
	_g_free0 (_tmp1_);
}


void netsukuku_log_info (const gchar* msg) {
	gchar* _tmp0_ = NULL;
	gchar* _tmp1_;
	const gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	g_return_if_fail (msg != NULL);
	_tmp0_ = netsukuku_tasklet_id ();
	_tmp1_ = _tmp0_;
	_tmp2_ = msg;
	_tmp3_ = g_strconcat (_tmp1_, _tmp2_, NULL);
	_tmp4_ = _tmp3_;
	syslog (LOG_INFO, _tmp4_, NULL);
	_g_free0 (_tmp4_);
	_g_free0 (_tmp1_);
}


void netsukuku_log_notice (const gchar* msg) {
	gchar* _tmp0_ = NULL;
	gchar* _tmp1_;
	const gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	g_return_if_fail (msg != NULL);
	_tmp0_ = netsukuku_tasklet_id ();
	_tmp1_ = _tmp0_;
	_tmp2_ = msg;
	_tmp3_ = g_strconcat (_tmp1_, _tmp2_, NULL);
	_tmp4_ = _tmp3_;
	syslog (LOG_NOTICE, _tmp4_, NULL);
	_g_free0 (_tmp4_);
	_g_free0 (_tmp1_);
}


void netsukuku_log_warn (const gchar* msg) {
	gchar* _tmp0_ = NULL;
	gchar* _tmp1_;
	const gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	g_return_if_fail (msg != NULL);
	_tmp0_ = netsukuku_tasklet_id ();
	_tmp1_ = _tmp0_;
	_tmp2_ = msg;
	_tmp3_ = g_strconcat (_tmp1_, _tmp2_, NULL);
	_tmp4_ = _tmp3_;
	syslog (LOG_WARNING, _tmp4_, NULL);
	_g_free0 (_tmp4_);
	_g_free0 (_tmp1_);
}


void netsukuku_log_error (const gchar* msg) {
	gchar* _tmp0_ = NULL;
	gchar* _tmp1_;
	const gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	g_return_if_fail (msg != NULL);
	_tmp0_ = netsukuku_tasklet_id ();
	_tmp1_ = _tmp0_;
	_tmp2_ = msg;
	_tmp3_ = g_strconcat (_tmp1_, _tmp2_, NULL);
	_tmp4_ = _tmp3_;
	syslog (LOG_ERR, _tmp4_, NULL);
	_g_free0 (_tmp4_);
	_g_free0 (_tmp1_);
}


void netsukuku_log_critical (const gchar* msg) {
	gchar* _tmp0_ = NULL;
	gchar* _tmp1_;
	const gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	g_return_if_fail (msg != NULL);
	_tmp0_ = netsukuku_tasklet_id ();
	_tmp1_ = _tmp0_;
	_tmp2_ = msg;
	_tmp3_ = g_strconcat (_tmp1_, _tmp2_, NULL);
	_tmp4_ = _tmp3_;
	syslog (LOG_CRIT, _tmp4_, NULL);
	_g_free0 (_tmp4_);
	_g_free0 (_tmp1_);
}


GQuark netsukuku_crypto_gcrypt_error_quark (void) {
	return g_quark_from_static_string ("netsukuku_crypto_gcrypt_error-quark");
}


guint32 netsukuku_crypto_fnv_32 (guchar* data, int data_length1) {
	guint32 result = 0U;
	result = (guint32) 0;
	return result;
}


GQuark netsukuku_incoming_nodes_error_quark (void) {
	return g_quark_from_static_string ("netsukuku_incoming_nodes_error-quark");
}


GQuark netsukuku_rpc_error_quark (void) {
	return g_quark_from_static_string ("netsukuku_rpc_error-quark");
}


GeeArrayList* netsukuku_valid_ids (gint levels, gint gsize, gint lvl, NetsukukuPartialNIP* partial_nip) {
	GeeArrayList* result = NULL;
	GeeArrayList* _tmp0_;
	GeeArrayList* ret;
	g_return_val_if_fail (partial_nip != NULL, NULL);
	_tmp0_ = gee_array_list_new (G_TYPE_INT, NULL, NULL, NULL, NULL, NULL);
	ret = _tmp0_;
	{
		gint i;
		i = 0;
		{
			gboolean _tmp1_;
			_tmp1_ = TRUE;
			while (TRUE) {
				gboolean _tmp2_;
				gint _tmp4_;
				gint _tmp5_;
				GeeArrayList* _tmp6_;
				gint _tmp7_;
				_tmp2_ = _tmp1_;
				if (!_tmp2_) {
					gint _tmp3_;
					_tmp3_ = i;
					i = _tmp3_ + 1;
				}
				_tmp1_ = FALSE;
				_tmp4_ = i;
				_tmp5_ = gsize;
				if (!(_tmp4_ < _tmp5_)) {
					break;
				}
				_tmp6_ = ret;
				_tmp7_ = i;
				gee_abstract_collection_add ((GeeAbstractCollection*) _tmp6_, (gpointer) ((gintptr) _tmp7_));
			}
		}
	}
	result = ret;
	return result;
}


gchar* netsukuku_nip_to_str (gint levels, gint gsize, NetsukukuNIP* nip) {
	gchar* result = NULL;
	gchar* _tmp0_;
	g_return_val_if_fail (nip != NULL, NULL);
	_tmp0_ = g_strdup ("");
	result = _tmp0_;
	return result;
}


NetsukukuRoute* netsukuku_route_construct (GType object_type) {
	NetsukukuRoute * self = NULL;
	self = (NetsukukuRoute*) g_object_new (object_type, NULL);
	return self;
}


NetsukukuRoute* netsukuku_route_new (void) {
	return netsukuku_route_construct (NETSUKUKU_TYPE_ROUTE);
}


static void netsukuku_route_class_init (NetsukukuRouteClass * klass) {
	netsukuku_route_parent_class = g_type_class_peek_parent (klass);
	G_OBJECT_CLASS (klass)->finalize = netsukuku_route_finalize;
}


static void netsukuku_route_instance_init (NetsukukuRoute * self) {
}


static void netsukuku_route_finalize (GObject* obj) {
	NetsukukuRoute * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, NETSUKUKU_TYPE_ROUTE, NetsukukuRoute);
	_g_object_unref0 (self->rem);
	_g_object_unref0 (self->rem_at_gw);
	_g_object_unref0 (self->hops);
	_g_object_unref0 (self->gid);
	_g_object_unref0 (self->hops_with_gw);
	G_OBJECT_CLASS (netsukuku_route_parent_class)->finalize (obj);
}


GType netsukuku_route_get_type (void) {
	static volatile gsize netsukuku_route_type_id__volatile = 0;
	if (g_once_init_enter (&netsukuku_route_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (NetsukukuRouteClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) netsukuku_route_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (NetsukukuRoute), 0, (GInstanceInitFunc) netsukuku_route_instance_init, NULL };
		GType netsukuku_route_type_id;
		netsukuku_route_type_id = g_type_register_static (G_TYPE_OBJECT, "NetsukukuRoute", &g_define_type_info, 0);
		g_once_init_leave (&netsukuku_route_type_id__volatile, netsukuku_route_type_id);
	}
	return netsukuku_route_type_id__volatile;
}


gboolean netsukuku_route_node_is_empty (NetsukukuRouteNode* self) {
	gboolean result = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	result = FALSE;
	return result;
}


gboolean netsukuku_route_node_is_free (NetsukukuRouteNode* self) {
	gboolean result = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	result = FALSE;
	return result;
}


NetsukukuGNodeID* netsukuku_route_node_get_eldest_gid (NetsukukuRouteNode* self) {
	NetsukukuGNodeID* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	result = NULL;
	return result;
}


gint netsukuku_route_node_nroutes (NetsukukuRouteNode* self) {
	gint result = 0;
	g_return_val_if_fail (self != NULL, 0);
	result = 0;
	return result;
}


NetsukukuRoute* netsukuku_route_node_best_route (NetsukukuRouteNode* self) {
	NetsukukuRoute* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	result = NULL;
	return result;
}


NetsukukuRoute* netsukuku_route_node_best_route_without (NetsukukuRouteNode* self, NetsukukuHCoord* hop) {
	NetsukukuRoute* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (hop != NULL, NULL);
	result = NULL;
	return result;
}


NetsukukuRoute* netsukuku_route_node_route_get_by_gw (NetsukukuRouteNode* self, NetsukukuAggregatedNeighbour* aggregated_neighbour) {
	NetsukukuRoute* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (aggregated_neighbour != NULL, NULL);
	result = NULL;
	return result;
}


NetsukukuRouteNode* netsukuku_route_node_construct (GType object_type) {
	NetsukukuRouteNode * self = NULL;
	self = (NetsukukuRouteNode*) g_object_new (object_type, NULL);
	return self;
}


NetsukukuRouteNode* netsukuku_route_node_new (void) {
	return netsukuku_route_node_construct (NETSUKUKU_TYPE_ROUTE_NODE);
}


static void netsukuku_route_node_class_init (NetsukukuRouteNodeClass * klass) {
	netsukuku_route_node_parent_class = g_type_class_peek_parent (klass);
}


static void netsukuku_route_node_instance_init (NetsukukuRouteNode * self) {
}


GType netsukuku_route_node_get_type (void) {
	static volatile gsize netsukuku_route_node_type_id__volatile = 0;
	if (g_once_init_enter (&netsukuku_route_node_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (NetsukukuRouteNodeClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) netsukuku_route_node_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (NetsukukuRouteNode), 0, (GInstanceInitFunc) netsukuku_route_node_instance_init, NULL };
		GType netsukuku_route_node_type_id;
		netsukuku_route_node_type_id = g_type_register_static (G_TYPE_OBJECT, "NetsukukuRouteNode", &g_define_type_info, 0);
		g_once_init_leave (&netsukuku_route_node_type_id__volatile, netsukuku_route_node_type_id);
	}
	return netsukuku_route_node_type_id__volatile;
}


NetsukukuHCoord* netsukuku_map_route_nip_to_lvlid (NetsukukuMapRoute* self, NetsukukuNIP* nip_caller) {
	NetsukukuHCoord* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (nip_caller != NULL, NULL);
	result = NULL;
	return result;
}


NetsukukuRouteNode* netsukuku_map_route_node_get (NetsukukuMapRoute* self, gint lvl, gint pos) {
	NetsukukuRouteNode* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	result = NULL;
	return result;
}


GeeList* netsukuku_map_route_list_lvl_id_from_nip (NetsukukuMapRoute* self, GeeList* lvl_ids, NetsukukuNIP* sender_nip) {
	GeeList* result = NULL;
	GeeArrayList* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (lvl_ids != NULL, NULL);
	g_return_val_if_fail (sender_nip != NULL, NULL);
	_tmp0_ = gee_array_list_new (NETSUKUKU_TYPE_HCOORD, (GBoxedCopyFunc) g_object_ref, g_object_unref, NULL, NULL, NULL);
	result = (GeeList*) _tmp0_;
	return result;
}


GeeList* netsukuku_map_route_list_lvl_id_to_nip (NetsukukuMapRoute* self, GeeList* lvl_ids, NetsukukuNIP* to_nip) {
	GeeList* result = NULL;
	GeeArrayList* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (lvl_ids != NULL, NULL);
	g_return_val_if_fail (to_nip != NULL, NULL);
	_tmp0_ = gee_array_list_new (NETSUKUKU_TYPE_HCOORD, (GBoxedCopyFunc) g_object_ref, g_object_unref, NULL, NULL, NULL);
	result = (GeeList*) _tmp0_;
	return result;
}


gint netsukuku_map_route_nip_cmp (NetsukukuMapRoute* self, gint* nipA, int nipA_length1) {
	gint result = 0;
	gint* _tmp0_;
	gint _tmp0__length1;
	NetsukukuNIP* _tmp1_;
	gint _tmp2_ = 0;
	gint* _tmp3_ = NULL;
	gint* _tmp4_;
	gint _tmp4__length1;
	gint _tmp5_ = 0;
	gint _tmp6_;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = nipA;
	_tmp0__length1 = nipA_length1;
	_tmp1_ = self->me;
	_tmp3_ = netsukuku_partial_nip_get_positions ((NetsukukuPartialNIP*) _tmp1_, &_tmp2_);
	_tmp4_ = _tmp3_;
	_tmp4__length1 = _tmp2_;
	_tmp5_ = netsukuku_nip_nip_cmp (_tmp0_, _tmp0__length1, _tmp4_, _tmp2_);
	_tmp6_ = _tmp5_;
	_tmp4_ = (g_free (_tmp4_), NULL);
	result = _tmp6_;
	return result;
}


void netsukuku_map_route_update_route_by_gw (NetsukukuMapRoute* self, NetsukukuHCoord* dest, NetsukukuAggregatedNeighbour* nr, NetsukukuREM* rem_at_gw, GeeList* hops, NetsukukuGNodeID* gid) {
	g_return_if_fail (self != NULL);
	g_return_if_fail (dest != NULL);
	g_return_if_fail (nr != NULL);
	g_return_if_fail (rem_at_gw != NULL);
	g_return_if_fail (hops != NULL);
	g_return_if_fail (gid != NULL);
}


gint netsukuku_map_route_busy_nodes_nb (NetsukukuMapRoute* self, gint lvl) {
	gint result = 0;
	g_return_val_if_fail (self != NULL, 0);
	result = 1;
	return result;
}


void netsukuku_map_route_route_signal_rem_changed (NetsukukuMapRoute* self, gint lvl, gint dst) {
	g_return_if_fail (self != NULL);
}


void netsukuku_map_route_delete_routes_via_neighbour (NetsukukuMapRoute* self, NetsukukuAggregatedNeighbour* aggregated_neighbour) {
	g_return_if_fail (self != NULL);
	g_return_if_fail (aggregated_neighbour != NULL);
}


NetsukukuMapRoute* netsukuku_map_route_construct (GType object_type) {
	NetsukukuMapRoute * self = NULL;
	self = (NetsukukuMapRoute*) g_object_new (object_type, NULL);
	return self;
}


NetsukukuMapRoute* netsukuku_map_route_new (void) {
	return netsukuku_map_route_construct (NETSUKUKU_TYPE_MAP_ROUTE);
}


NetsukukuGNodeID** netsukuku_map_route_get_id_myself (NetsukukuMapRoute* self, int* result_length1) {
	NetsukukuGNodeID** result;
	NetsukukuGNodeID** _tmp0_;
	gint _tmp0__length1;
	NetsukukuGNodeID** _tmp1_;
	gint _tmp1__length1;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_id_myself;
	_tmp0__length1 = self->priv->_id_myself_length1;
	_tmp1_ = _tmp0_;
	_tmp1__length1 = _tmp0__length1;
	if (result_length1) {
		*result_length1 = _tmp1__length1;
	}
	result = _tmp1_;
	return result;
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


static NetsukukuGNodeID** _vala_array_dup1 (NetsukukuGNodeID** self, int length) {
	NetsukukuGNodeID** result;
	int i;
	result = g_new0 (NetsukukuGNodeID*, length + 1);
	for (i = 0; i < length; i++) {
		NetsukukuGNodeID* _tmp0_;
		_tmp0_ = _g_object_ref0 (self[i]);
		result[i] = _tmp0_;
	}
	return result;
}


static void netsukuku_map_route_set_id_myself (NetsukukuMapRoute* self, NetsukukuGNodeID** value, int value_length1) {
	NetsukukuGNodeID** _tmp0_;
	gint _tmp0__length1;
	NetsukukuGNodeID** _tmp1_;
	gint _tmp1__length1;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	_tmp0__length1 = value_length1;
	_tmp1_ = (_tmp0_ != NULL) ? _vala_array_dup1 (_tmp0_, _tmp0__length1) : ((gpointer) _tmp0_);
	_tmp1__length1 = _tmp0__length1;
	self->priv->_id_myself = (_vala_array_free (self->priv->_id_myself, self->priv->_id_myself_length1, (GDestroyNotify) g_object_unref), NULL);
	self->priv->_id_myself = _tmp1_;
	self->priv->_id_myself_length1 = _tmp1__length1;
	self->priv->__id_myself_size_ = self->priv->_id_myself_length1;
}


static void netsukuku_map_route_class_init (NetsukukuMapRouteClass * klass) {
	netsukuku_map_route_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (NetsukukuMapRoutePrivate));
	G_OBJECT_CLASS (klass)->get_property = _vala_netsukuku_map_route_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_netsukuku_map_route_set_property;
	G_OBJECT_CLASS (klass)->finalize = netsukuku_map_route_finalize;
}


static void netsukuku_map_route_instance_init (NetsukukuMapRoute * self) {
	self->priv = NETSUKUKU_MAP_ROUTE_GET_PRIVATE (self);
}


static void netsukuku_map_route_finalize (GObject* obj) {
	NetsukukuMapRoute * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, NETSUKUKU_TYPE_MAP_ROUTE, NetsukukuMapRoute);
	_g_object_unref0 (self->address_manager);
	self->priv->_id_myself = (_vala_array_free (self->priv->_id_myself, self->priv->_id_myself_length1, (GDestroyNotify) g_object_unref), NULL);
	_g_object_unref0 (self->me);
	G_OBJECT_CLASS (netsukuku_map_route_parent_class)->finalize (obj);
}


GType netsukuku_map_route_get_type (void) {
	static volatile gsize netsukuku_map_route_type_id__volatile = 0;
	if (g_once_init_enter (&netsukuku_map_route_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (NetsukukuMapRouteClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) netsukuku_map_route_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (NetsukukuMapRoute), 0, (GInstanceInitFunc) netsukuku_map_route_instance_init, NULL };
		GType netsukuku_map_route_type_id;
		netsukuku_map_route_type_id = g_type_register_static (G_TYPE_OBJECT, "NetsukukuMapRoute", &g_define_type_info, 0);
		g_once_init_leave (&netsukuku_map_route_type_id__volatile, netsukuku_map_route_type_id);
	}
	return netsukuku_map_route_type_id__volatile;
}


static void _vala_netsukuku_map_route_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	NetsukukuMapRoute * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, NETSUKUKU_TYPE_MAP_ROUTE, NetsukukuMapRoute);
	switch (property_id) {
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _vala_netsukuku_map_route_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	NetsukukuMapRoute * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, NETSUKUKU_TYPE_MAP_ROUTE, NetsukukuMapRoute);
	switch (property_id) {
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


NetsukukuNetworkID* netsukuku_address_manager_get_main_netid (NetsukukuAddressManager* self) {
	NetsukukuNetworkID* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	result = NULL;
	return result;
}


gboolean netsukuku_address_manager_is_in_my_network (NetsukukuAddressManager* self, NetsukukuNetworkID* netid) {
	gboolean result = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (netid != NULL, FALSE);
	result = TRUE;
	return result;
}


gboolean netsukuku_address_manager_do_i_act_as_gateway_for (NetsukukuAddressManager* self, NetsukukuNIP* nip, gint nodeid, NetsukukuNetworkID* netid) {
	gboolean result = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (nip != NULL, FALSE);
	g_return_val_if_fail (netid != NULL, FALSE);
	result = FALSE;
	return result;
}


gint netsukuku_address_manager_get_my_id (NetsukukuAddressManager* self) {
	gint result = 0;
	g_return_val_if_fail (self != NULL, 0);
	result = 0;
	return result;
}


NetsukukuAddressManagerFakeRmt* netsukuku_address_manager_get_broadcast_client (NetsukukuAddressManager* self) {
	NetsukukuAddressManagerFakeRmt* result = NULL;
	NetsukukuFakeAddressManagerFakeRmt* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = netsukuku_fake_address_manager_fake_rmt_new ();
	result = (NetsukukuAddressManagerFakeRmt*) _tmp0_;
	return result;
}


gboolean netsukuku_address_manager_is_preferred_network (NetsukukuAddressManager* self, NetsukukuNetworkID* netid) {
	gboolean result = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (netid != NULL, FALSE);
	result = FALSE;
	return result;
}


NetsukukuAddressManager* netsukuku_address_manager_construct (GType object_type) {
	NetsukukuAddressManager * self = NULL;
	self = (NetsukukuAddressManager*) g_object_new (object_type, NULL);
	return self;
}


NetsukukuAddressManager* netsukuku_address_manager_new (void) {
	return netsukuku_address_manager_construct (NETSUKUKU_TYPE_ADDRESS_MANAGER);
}


static void netsukuku_address_manager_class_init (NetsukukuAddressManagerClass * klass) {
	netsukuku_address_manager_parent_class = g_type_class_peek_parent (klass);
	G_OBJECT_CLASS (klass)->finalize = netsukuku_address_manager_finalize;
}


static void netsukuku_address_manager_instance_init (NetsukukuAddressManager * self) {
}


static void netsukuku_address_manager_finalize (GObject* obj) {
	NetsukukuAddressManager * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, NETSUKUKU_TYPE_ADDRESS_MANAGER, NetsukukuAddressManager);
	_g_object_unref0 (self->nics);
	_netsukuku_incoming_nodes_unref0 (self->incoming_nodes);
	G_OBJECT_CLASS (netsukuku_address_manager_parent_class)->finalize (obj);
}


GType netsukuku_address_manager_get_type (void) {
	static volatile gsize netsukuku_address_manager_type_id__volatile = 0;
	if (g_once_init_enter (&netsukuku_address_manager_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (NetsukukuAddressManagerClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) netsukuku_address_manager_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (NetsukukuAddressManager), 0, (GInstanceInitFunc) netsukuku_address_manager_instance_init, NULL };
		GType netsukuku_address_manager_type_id;
		netsukuku_address_manager_type_id = g_type_register_static (G_TYPE_OBJECT, "NetsukukuAddressManager", &g_define_type_info, 0);
		g_once_init_leave (&netsukuku_address_manager_type_id__volatile, netsukuku_address_manager_type_id);
	}
	return netsukuku_address_manager_type_id__volatile;
}


NetsukukuNIC* netsukuku_nic_construct (GType object_type) {
	NetsukukuNIC * self = NULL;
	self = (NetsukukuNIC*) g_object_new (object_type, NULL);
	return self;
}


NetsukukuNIC* netsukuku_nic_new (void) {
	return netsukuku_nic_construct (NETSUKUKU_TYPE_NIC);
}


static void netsukuku_nic_class_init (NetsukukuNICClass * klass) {
	netsukuku_nic_parent_class = g_type_class_peek_parent (klass);
	G_OBJECT_CLASS (klass)->finalize = netsukuku_nic_finalize;
}


static void netsukuku_nic_instance_init (NetsukukuNIC * self) {
}


static void netsukuku_nic_finalize (GObject* obj) {
	NetsukukuNIC * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, NETSUKUKU_TYPE_NIC, NetsukukuNIC);
	_g_free0 (self->mac);
	G_OBJECT_CLASS (netsukuku_nic_parent_class)->finalize (obj);
}


GType netsukuku_nic_get_type (void) {
	static volatile gsize netsukuku_nic_type_id__volatile = 0;
	if (g_once_init_enter (&netsukuku_nic_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (NetsukukuNICClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) netsukuku_nic_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (NetsukukuNIC), 0, (GInstanceInitFunc) netsukuku_nic_instance_init, NULL };
		GType netsukuku_nic_type_id;
		netsukuku_nic_type_id = g_type_register_static (G_TYPE_OBJECT, "NetsukukuNIC", &g_define_type_info, 0);
		g_once_init_leave (&netsukuku_nic_type_id__volatile, netsukuku_nic_type_id);
	}
	return netsukuku_nic_type_id__volatile;
}


NetsukukuNetworkInterfaceManager* netsukuku_network_interface_manager_construct (GType object_type) {
	NetsukukuNetworkInterfaceManager * self = NULL;
	self = (NetsukukuNetworkInterfaceManager*) g_object_new (object_type, NULL);
	return self;
}


NetsukukuNetworkInterfaceManager* netsukuku_network_interface_manager_new (void) {
	return netsukuku_network_interface_manager_construct (NETSUKUKU_TYPE_NETWORK_INTERFACE_MANAGER);
}


NetsukukuNIC* netsukuku_network_interface_manager_get_nic_class (NetsukukuNetworkInterfaceManager* self) {
	NetsukukuNIC* result;
	NetsukukuNIC* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_nic_class;
	result = _tmp0_;
	return result;
}


static void netsukuku_network_interface_manager_set_nic_class (NetsukukuNetworkInterfaceManager* self, NetsukukuNIC* value) {
	NetsukukuNIC* _tmp0_;
	NetsukukuNIC* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	_tmp1_ = _g_object_ref0 (_tmp0_);
	_g_object_unref0 (self->priv->_nic_class);
	self->priv->_nic_class = _tmp1_;
	g_object_notify ((GObject *) self, "nic-class");
}


const gchar* netsukuku_network_interface_manager_get_nic_name (NetsukukuNetworkInterfaceManager* self) {
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_nic_name;
	result = _tmp0_;
	return result;
}


static void netsukuku_network_interface_manager_set_nic_name (NetsukukuNetworkInterfaceManager* self, const gchar* value) {
	const gchar* _tmp0_;
	gchar* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	_tmp1_ = g_strdup (_tmp0_);
	_g_free0 (self->priv->_nic_name);
	self->priv->_nic_name = _tmp1_;
	g_object_notify ((GObject *) self, "nic-name");
}


static void netsukuku_network_interface_manager_class_init (NetsukukuNetworkInterfaceManagerClass * klass) {
	netsukuku_network_interface_manager_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (NetsukukuNetworkInterfaceManagerPrivate));
	G_OBJECT_CLASS (klass)->get_property = _vala_netsukuku_network_interface_manager_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_netsukuku_network_interface_manager_set_property;
	G_OBJECT_CLASS (klass)->finalize = netsukuku_network_interface_manager_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), NETSUKUKU_NETWORK_INTERFACE_MANAGER_NIC_CLASS, g_param_spec_object ("nic-class", "nic-class", "nic-class", NETSUKUKU_TYPE_NIC, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), NETSUKUKU_NETWORK_INTERFACE_MANAGER_NIC_NAME, g_param_spec_string ("nic-name", "nic-name", "nic-name", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
}


static void netsukuku_network_interface_manager_instance_init (NetsukukuNetworkInterfaceManager * self) {
	self->priv = NETSUKUKU_NETWORK_INTERFACE_MANAGER_GET_PRIVATE (self);
}


static void netsukuku_network_interface_manager_finalize (GObject* obj) {
	NetsukukuNetworkInterfaceManager * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, NETSUKUKU_TYPE_NETWORK_INTERFACE_MANAGER, NetsukukuNetworkInterfaceManager);
	_g_object_unref0 (self->priv->_nic_class);
	_g_free0 (self->priv->_nic_name);
	G_OBJECT_CLASS (netsukuku_network_interface_manager_parent_class)->finalize (obj);
}


GType netsukuku_network_interface_manager_get_type (void) {
	static volatile gsize netsukuku_network_interface_manager_type_id__volatile = 0;
	if (g_once_init_enter (&netsukuku_network_interface_manager_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (NetsukukuNetworkInterfaceManagerClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) netsukuku_network_interface_manager_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (NetsukukuNetworkInterfaceManager), 0, (GInstanceInitFunc) netsukuku_network_interface_manager_instance_init, NULL };
		GType netsukuku_network_interface_manager_type_id;
		netsukuku_network_interface_manager_type_id = g_type_register_static (G_TYPE_OBJECT, "NetsukukuNetworkInterfaceManager", &g_define_type_info, 0);
		g_once_init_leave (&netsukuku_network_interface_manager_type_id__volatile, netsukuku_network_interface_manager_type_id);
	}
	return netsukuku_network_interface_manager_type_id__volatile;
}


static void _vala_netsukuku_network_interface_manager_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	NetsukukuNetworkInterfaceManager * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, NETSUKUKU_TYPE_NETWORK_INTERFACE_MANAGER, NetsukukuNetworkInterfaceManager);
	switch (property_id) {
		case NETSUKUKU_NETWORK_INTERFACE_MANAGER_NIC_CLASS:
		g_value_set_object (value, netsukuku_network_interface_manager_get_nic_class (self));
		break;
		case NETSUKUKU_NETWORK_INTERFACE_MANAGER_NIC_NAME:
		g_value_set_string (value, netsukuku_network_interface_manager_get_nic_name (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _vala_netsukuku_network_interface_manager_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	NetsukukuNetworkInterfaceManager * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, NETSUKUKU_TYPE_NETWORK_INTERFACE_MANAGER, NetsukukuNetworkInterfaceManager);
	switch (property_id) {
		case NETSUKUKU_NETWORK_INTERFACE_MANAGER_NIC_CLASS:
		netsukuku_network_interface_manager_set_nic_class (self, g_value_get_object (value));
		break;
		case NETSUKUKU_NETWORK_INTERFACE_MANAGER_NIC_NAME:
		netsukuku_network_interface_manager_set_nic_name (self, g_value_get_string (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


GeeList* netsukuku_aggregated_neighbour_manager_neighbour_list (NetsukukuAggregatedNeighbourManager* self, gboolean* b, NetsukukuNetworkID* with_this_netid) {
	GeeList* result = NULL;
	GeeArrayList* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = gee_array_list_new (NETSUKUKU_TYPE_AGGREGATED_NEIGHBOUR, (GBoxedCopyFunc) g_object_ref, g_object_unref, NULL, NULL, NULL);
	result = (GeeList*) _tmp0_;
	return result;
}


NetsukukuAggregatedNeighbour* netsukuku_aggregated_neighbour_manager_key_to_neighbour (NetsukukuAggregatedNeighbourManager* self, NetsukukuNIP* nip, gint nodeid) {
	NetsukukuAggregatedNeighbour* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (nip != NULL, NULL);
	result = NULL;
	return result;
}


NetsukukuAggregatedNeighbourManager* netsukuku_aggregated_neighbour_manager_construct (GType object_type) {
	NetsukukuAggregatedNeighbourManager * self = NULL;
	self = (NetsukukuAggregatedNeighbourManager*) g_object_new (object_type, NULL);
	return self;
}


NetsukukuAggregatedNeighbourManager* netsukuku_aggregated_neighbour_manager_new (void) {
	return netsukuku_aggregated_neighbour_manager_construct (NETSUKUKU_TYPE_AGGREGATED_NEIGHBOUR_MANAGER);
}


static void g_cclosure_user_marshal_VOID__OBJECT_OBJECT (GClosure * closure, GValue * return_value, guint n_param_values, const GValue * param_values, gpointer invocation_hint, gpointer marshal_data) {
	typedef void (*GMarshalFunc_VOID__OBJECT_OBJECT) (gpointer data1, gpointer arg_1, gpointer arg_2, gpointer data2);
	register GMarshalFunc_VOID__OBJECT_OBJECT callback;
	register GCClosure * cc;
	register gpointer data1;
	register gpointer data2;
	cc = (GCClosure *) closure;
	g_return_if_fail (n_param_values == 3);
	if (G_CCLOSURE_SWAP_DATA (closure)) {
		data1 = closure->data;
		data2 = param_values->data[0].v_pointer;
	} else {
		data1 = param_values->data[0].v_pointer;
		data2 = closure->data;
	}
	callback = (GMarshalFunc_VOID__OBJECT_OBJECT) (marshal_data ? marshal_data : cc->callback);
	callback (data1, g_value_get_object (param_values + 1), g_value_get_object (param_values + 2), data2);
}


static void netsukuku_aggregated_neighbour_manager_class_init (NetsukukuAggregatedNeighbourManagerClass * klass) {
	netsukuku_aggregated_neighbour_manager_parent_class = g_type_class_peek_parent (klass);
	g_signal_new ("aggregated_neighbour_new", NETSUKUKU_TYPE_AGGREGATED_NEIGHBOUR_MANAGER, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__OBJECT, G_TYPE_NONE, 1, NETSUKUKU_TYPE_AGGREGATED_NEIGHBOUR);
	g_signal_new ("aggregated_neighbour_new_before", NETSUKUKU_TYPE_AGGREGATED_NEIGHBOUR_MANAGER, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__OBJECT, G_TYPE_NONE, 1, NETSUKUKU_TYPE_AGGREGATED_NEIGHBOUR);
	g_signal_new ("aggregated_neighbour_deleted", NETSUKUKU_TYPE_AGGREGATED_NEIGHBOUR_MANAGER, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__OBJECT, G_TYPE_NONE, 1, NETSUKUKU_TYPE_AGGREGATED_NEIGHBOUR);
	g_signal_new ("aggregated_neighbour_deleted_after", NETSUKUKU_TYPE_AGGREGATED_NEIGHBOUR_MANAGER, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__OBJECT, G_TYPE_NONE, 1, NETSUKUKU_TYPE_AGGREGATED_NEIGHBOUR);
	g_signal_new ("aggregated_neighbour_rem_chged", NETSUKUKU_TYPE_AGGREGATED_NEIGHBOUR_MANAGER, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_user_marshal_VOID__OBJECT_OBJECT, G_TYPE_NONE, 2, NETSUKUKU_TYPE_AGGREGATED_NEIGHBOUR, NETSUKUKU_TYPE_REM);
	g_signal_new ("aggregated_neighbour_rem_chged_before", NETSUKUKU_TYPE_AGGREGATED_NEIGHBOUR_MANAGER, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_user_marshal_VOID__OBJECT_OBJECT, G_TYPE_NONE, 2, NETSUKUKU_TYPE_AGGREGATED_NEIGHBOUR, NETSUKUKU_TYPE_REM);
	g_signal_new ("aggregated_neighbour_going_new", NETSUKUKU_TYPE_AGGREGATED_NEIGHBOUR_MANAGER, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__OBJECT, G_TYPE_NONE, 1, NETSUKUKU_TYPE_AGGREGATED_NEIGHBOUR);
	g_signal_new ("aggregated_neighbour_going_deleted", NETSUKUKU_TYPE_AGGREGATED_NEIGHBOUR_MANAGER, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__OBJECT, G_TYPE_NONE, 1, NETSUKUKU_TYPE_AGGREGATED_NEIGHBOUR);
	g_signal_new ("aggregated_neighbour_going_rem_chged", NETSUKUKU_TYPE_AGGREGATED_NEIGHBOUR_MANAGER, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__OBJECT, G_TYPE_NONE, 1, NETSUKUKU_TYPE_AGGREGATED_NEIGHBOUR);
	g_signal_new ("aggregated_neighbour_colliding_new", NETSUKUKU_TYPE_AGGREGATED_NEIGHBOUR_MANAGER, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__OBJECT, G_TYPE_NONE, 1, NETSUKUKU_TYPE_AGGREGATED_NEIGHBOUR);
	g_signal_new ("aggregated_neighbour_colliding_deleted", NETSUKUKU_TYPE_AGGREGATED_NEIGHBOUR_MANAGER, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__OBJECT, G_TYPE_NONE, 1, NETSUKUKU_TYPE_AGGREGATED_NEIGHBOUR);
	g_signal_new ("aggregated_neighbour_colliding_rem_chged", NETSUKUKU_TYPE_AGGREGATED_NEIGHBOUR_MANAGER, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_user_marshal_VOID__OBJECT_OBJECT, G_TYPE_NONE, 2, NETSUKUKU_TYPE_AGGREGATED_NEIGHBOUR, NETSUKUKU_TYPE_REM);
	g_signal_new ("aggregated_neighbour_colliding_going_new", NETSUKUKU_TYPE_AGGREGATED_NEIGHBOUR_MANAGER, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__OBJECT, G_TYPE_NONE, 1, NETSUKUKU_TYPE_AGGREGATED_NEIGHBOUR);
	g_signal_new ("aggregated_neighbour_colliding_going_deleted", NETSUKUKU_TYPE_AGGREGATED_NEIGHBOUR_MANAGER, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__OBJECT, G_TYPE_NONE, 1, NETSUKUKU_TYPE_AGGREGATED_NEIGHBOUR);
	g_signal_new ("aggregated_neighbour_colliding_going_rem_chged", NETSUKUKU_TYPE_AGGREGATED_NEIGHBOUR_MANAGER, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__OBJECT, G_TYPE_NONE, 1, NETSUKUKU_TYPE_AGGREGATED_NEIGHBOUR);
}


static void netsukuku_aggregated_neighbour_manager_instance_init (NetsukukuAggregatedNeighbourManager * self) {
}


GType netsukuku_aggregated_neighbour_manager_get_type (void) {
	static volatile gsize netsukuku_aggregated_neighbour_manager_type_id__volatile = 0;
	if (g_once_init_enter (&netsukuku_aggregated_neighbour_manager_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (NetsukukuAggregatedNeighbourManagerClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) netsukuku_aggregated_neighbour_manager_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (NetsukukuAggregatedNeighbourManager), 0, (GInstanceInitFunc) netsukuku_aggregated_neighbour_manager_instance_init, NULL };
		GType netsukuku_aggregated_neighbour_manager_type_id;
		netsukuku_aggregated_neighbour_manager_type_id = g_type_register_static (G_TYPE_OBJECT, "NetsukukuAggregatedNeighbourManager", &g_define_type_info, 0);
		g_once_init_leave (&netsukuku_aggregated_neighbour_manager_type_id__volatile, netsukuku_aggregated_neighbour_manager_type_id);
	}
	return netsukuku_aggregated_neighbour_manager_type_id__volatile;
}


gchar* netsukuku_aggregated_neighbour_to_string (NetsukukuAggregatedNeighbour* self) {
	gchar* result = NULL;
	gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = g_strdup ("");
	result = _tmp0_;
	return result;
}


NetsukukuAddressManagerFakeRmt* netsukuku_aggregated_neighbour_create_neighbour_client (NetsukukuAggregatedNeighbour* self, gboolean response) {
	NetsukukuAddressManagerFakeRmt* result = NULL;
	NetsukukuFakeAddressManagerFakeRmt* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = netsukuku_fake_address_manager_fake_rmt_new ();
	result = (NetsukukuAddressManagerFakeRmt*) _tmp0_;
	return result;
}


gboolean netsukuku_aggregated_neighbour_equal_func (NetsukukuAggregatedNeighbour* a, NetsukukuAggregatedNeighbour* b) {
	gboolean result = FALSE;
	result = TRUE;
	return result;
}


guint netsukuku_aggregated_neighbour_hash_func (NetsukukuAggregatedNeighbour* a) {
	guint result = 0U;
	g_return_val_if_fail (a != NULL, 0U);
	result = (guint) 0;
	return result;
}


NetsukukuAggregatedNeighbour* netsukuku_aggregated_neighbour_construct (GType object_type) {
	NetsukukuAggregatedNeighbour * self = NULL;
	self = (NetsukukuAggregatedNeighbour*) g_object_new (object_type, NULL);
	return self;
}


NetsukukuAggregatedNeighbour* netsukuku_aggregated_neighbour_new (void) {
	return netsukuku_aggregated_neighbour_construct (NETSUKUKU_TYPE_AGGREGATED_NEIGHBOUR);
}


static void netsukuku_aggregated_neighbour_class_init (NetsukukuAggregatedNeighbourClass * klass) {
	netsukuku_aggregated_neighbour_parent_class = g_type_class_peek_parent (klass);
	G_OBJECT_CLASS (klass)->finalize = netsukuku_aggregated_neighbour_finalize;
}


static void netsukuku_aggregated_neighbour_instance_init (NetsukukuAggregatedNeighbour * self) {
}


static void netsukuku_aggregated_neighbour_finalize (GObject* obj) {
	NetsukukuAggregatedNeighbour * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, NETSUKUKU_TYPE_AGGREGATED_NEIGHBOUR, NetsukukuAggregatedNeighbour);
	_g_object_unref0 (self->nip);
	_g_object_unref0 (self->rem);
	_g_object_unref0 (self->netid);
	_g_object_unref0 (self->neighbour_client);
	G_OBJECT_CLASS (netsukuku_aggregated_neighbour_parent_class)->finalize (obj);
}


GType netsukuku_aggregated_neighbour_get_type (void) {
	static volatile gsize netsukuku_aggregated_neighbour_type_id__volatile = 0;
	if (g_once_init_enter (&netsukuku_aggregated_neighbour_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (NetsukukuAggregatedNeighbourClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) netsukuku_aggregated_neighbour_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (NetsukukuAggregatedNeighbour), 0, (GInstanceInitFunc) netsukuku_aggregated_neighbour_instance_init, NULL };
		GType netsukuku_aggregated_neighbour_type_id;
		netsukuku_aggregated_neighbour_type_id = g_type_register_static (G_TYPE_OBJECT, "NetsukukuAggregatedNeighbour", &g_define_type_info, 0);
		g_once_init_leave (&netsukuku_aggregated_neighbour_type_id__volatile, netsukuku_aggregated_neighbour_type_id);
	}
	return netsukuku_aggregated_neighbour_type_id__volatile;
}


static zcdISerializable* netsukuku_fake_address_manager_fake_rmt_real_rmt (NetsukukuAddressManagerFakeRmt* base, zcdRemoteCall* data, GError** error) {
	NetsukukuFakeAddressManagerFakeRmt * self;
	zcdISerializable* result = NULL;
	self = (NetsukukuFakeAddressManagerFakeRmt*) base;
	g_return_val_if_fail (data != NULL, NULL);
	result = NULL;
	return result;
}


NetsukukuFakeAddressManagerFakeRmt* netsukuku_fake_address_manager_fake_rmt_construct (GType object_type) {
	NetsukukuFakeAddressManagerFakeRmt * self = NULL;
	self = (NetsukukuFakeAddressManagerFakeRmt*) netsukuku_address_manager_fake_rmt_construct (object_type);
	return self;
}


NetsukukuFakeAddressManagerFakeRmt* netsukuku_fake_address_manager_fake_rmt_new (void) {
	return netsukuku_fake_address_manager_fake_rmt_construct (NETSUKUKU_TYPE_FAKE_ADDRESS_MANAGER_FAKE_RMT);
}


static void netsukuku_fake_address_manager_fake_rmt_class_init (NetsukukuFakeAddressManagerFakeRmtClass * klass) {
	netsukuku_fake_address_manager_fake_rmt_parent_class = g_type_class_peek_parent (klass);
	NETSUKUKU_ADDRESS_MANAGER_FAKE_RMT_CLASS (klass)->rmt = netsukuku_fake_address_manager_fake_rmt_real_rmt;
	G_OBJECT_CLASS (klass)->finalize = netsukuku_fake_address_manager_fake_rmt_finalize;
}


static void netsukuku_fake_address_manager_fake_rmt_instance_init (NetsukukuFakeAddressManagerFakeRmt * self) {
}


static void netsukuku_fake_address_manager_fake_rmt_finalize (GObject* obj) {
	NetsukukuFakeAddressManagerFakeRmt * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, NETSUKUKU_TYPE_FAKE_ADDRESS_MANAGER_FAKE_RMT, NetsukukuFakeAddressManagerFakeRmt);
	_g_object_unref0 (self->etp);
	G_OBJECT_CLASS (netsukuku_fake_address_manager_fake_rmt_parent_class)->finalize (obj);
}


GType netsukuku_fake_address_manager_fake_rmt_get_type (void) {
	static volatile gsize netsukuku_fake_address_manager_fake_rmt_type_id__volatile = 0;
	if (g_once_init_enter (&netsukuku_fake_address_manager_fake_rmt_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (NetsukukuFakeAddressManagerFakeRmtClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) netsukuku_fake_address_manager_fake_rmt_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (NetsukukuFakeAddressManagerFakeRmt), 0, (GInstanceInitFunc) netsukuku_fake_address_manager_fake_rmt_instance_init, NULL };
		GType netsukuku_fake_address_manager_fake_rmt_type_id;
		netsukuku_fake_address_manager_fake_rmt_type_id = g_type_register_static (NETSUKUKU_TYPE_ADDRESS_MANAGER_FAKE_RMT, "NetsukukuFakeAddressManagerFakeRmt", &g_define_type_info, 0);
		g_once_init_leave (&netsukuku_fake_address_manager_fake_rmt_type_id__volatile, netsukuku_fake_address_manager_fake_rmt_type_id);
	}
	return netsukuku_fake_address_manager_fake_rmt_type_id__volatile;
}


gboolean netsukuku_incoming_nodes_contains (NetsukukuIncomingNodes* self, NetsukukuNIP* nip, gint nodeid) {
	gboolean result = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (nip != NULL, FALSE);
	result = FALSE;
	return result;
}


NetsukukuRoutesSet* netsukuku_incoming_nodes_get_knowledge (NetsukukuIncomingNodes* self, NetsukukuNIP* nip, gint nodeid, gint prev_seq_num) {
	NetsukukuRoutesSet* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (nip != NULL, NULL);
	result = NULL;
	return result;
}


void netsukuku_incoming_nodes_update (NetsukukuIncomingNodes* self, NetsukukuNIP* nip, gint nodeid, GeeList* macs, gint* ttl) {
	g_return_if_fail (self != NULL);
	g_return_if_fail (nip != NULL);
	g_return_if_fail (macs != NULL);
}


void netsukuku_incoming_nodes_log_knowledge (NetsukukuIncomingNodes* self, NetsukukuNIP* nip, gint nodeid, gint my_seq_num, NetsukukuRoutesSet* destinations) {
	g_return_if_fail (self != NULL);
	g_return_if_fail (nip != NULL);
	g_return_if_fail (destinations != NULL);
}


void netsukuku_incoming_nodes_purge (NetsukukuIncomingNodes* self) {
	g_return_if_fail (self != NULL);
}


NetsukukuIncomingNodes* netsukuku_incoming_nodes_construct (GType object_type) {
	NetsukukuIncomingNodes* self = NULL;
	self = (NetsukukuIncomingNodes*) g_type_create_instance (object_type);
	return self;
}


NetsukukuIncomingNodes* netsukuku_incoming_nodes_new (void) {
	return netsukuku_incoming_nodes_construct (NETSUKUKU_TYPE_INCOMING_NODES);
}


static void netsukuku_value_incoming_nodes_init (GValue* value) {
	value->data[0].v_pointer = NULL;
}


static void netsukuku_value_incoming_nodes_free_value (GValue* value) {
	if (value->data[0].v_pointer) {
		netsukuku_incoming_nodes_unref (value->data[0].v_pointer);
	}
}


static void netsukuku_value_incoming_nodes_copy_value (const GValue* src_value, GValue* dest_value) {
	if (src_value->data[0].v_pointer) {
		dest_value->data[0].v_pointer = netsukuku_incoming_nodes_ref (src_value->data[0].v_pointer);
	} else {
		dest_value->data[0].v_pointer = NULL;
	}
}


static gpointer netsukuku_value_incoming_nodes_peek_pointer (const GValue* value) {
	return value->data[0].v_pointer;
}


static gchar* netsukuku_value_incoming_nodes_collect_value (GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
	if (collect_values[0].v_pointer) {
		NetsukukuIncomingNodes* object;
		object = collect_values[0].v_pointer;
		if (object->parent_instance.g_class == NULL) {
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		}
		value->data[0].v_pointer = netsukuku_incoming_nodes_ref (object);
	} else {
		value->data[0].v_pointer = NULL;
	}
	return NULL;
}


static gchar* netsukuku_value_incoming_nodes_lcopy_value (const GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
	NetsukukuIncomingNodes** object_p;
	object_p = collect_values[0].v_pointer;
	if (!object_p) {
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
	}
	if (!value->data[0].v_pointer) {
		*object_p = NULL;
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
		*object_p = value->data[0].v_pointer;
	} else {
		*object_p = netsukuku_incoming_nodes_ref (value->data[0].v_pointer);
	}
	return NULL;
}


GParamSpec* netsukuku_param_spec_incoming_nodes (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags) {
	NetsukukuParamSpecIncomingNodes* spec;
	g_return_val_if_fail (g_type_is_a (object_type, NETSUKUKU_TYPE_INCOMING_NODES), NULL);
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
	G_PARAM_SPEC (spec)->value_type = object_type;
	return G_PARAM_SPEC (spec);
}


gpointer netsukuku_value_get_incoming_nodes (const GValue* value) {
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, NETSUKUKU_TYPE_INCOMING_NODES), NULL);
	return value->data[0].v_pointer;
}


void netsukuku_value_set_incoming_nodes (GValue* value, gpointer v_object) {
	NetsukukuIncomingNodes* old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, NETSUKUKU_TYPE_INCOMING_NODES));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, NETSUKUKU_TYPE_INCOMING_NODES));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
		netsukuku_incoming_nodes_ref (value->data[0].v_pointer);
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		netsukuku_incoming_nodes_unref (old);
	}
}


void netsukuku_value_take_incoming_nodes (GValue* value, gpointer v_object) {
	NetsukukuIncomingNodes* old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, NETSUKUKU_TYPE_INCOMING_NODES));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, NETSUKUKU_TYPE_INCOMING_NODES));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		netsukuku_incoming_nodes_unref (old);
	}
}


static void netsukuku_incoming_nodes_class_init (NetsukukuIncomingNodesClass * klass) {
	netsukuku_incoming_nodes_parent_class = g_type_class_peek_parent (klass);
	NETSUKUKU_INCOMING_NODES_CLASS (klass)->finalize = netsukuku_incoming_nodes_finalize;
}


static void netsukuku_incoming_nodes_instance_init (NetsukukuIncomingNodes * self) {
	self->ref_count = 1;
}


static void netsukuku_incoming_nodes_finalize (NetsukukuIncomingNodes* obj) {
	NetsukukuIncomingNodes * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, NETSUKUKU_TYPE_INCOMING_NODES, NetsukukuIncomingNodes);
}


GType netsukuku_incoming_nodes_get_type (void) {
	static volatile gsize netsukuku_incoming_nodes_type_id__volatile = 0;
	if (g_once_init_enter (&netsukuku_incoming_nodes_type_id__volatile)) {
		static const GTypeValueTable g_define_type_value_table = { netsukuku_value_incoming_nodes_init, netsukuku_value_incoming_nodes_free_value, netsukuku_value_incoming_nodes_copy_value, netsukuku_value_incoming_nodes_peek_pointer, "p", netsukuku_value_incoming_nodes_collect_value, "p", netsukuku_value_incoming_nodes_lcopy_value };
		static const GTypeInfo g_define_type_info = { sizeof (NetsukukuIncomingNodesClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) netsukuku_incoming_nodes_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (NetsukukuIncomingNodes), 0, (GInstanceInitFunc) netsukuku_incoming_nodes_instance_init, &g_define_type_value_table };
		static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
		GType netsukuku_incoming_nodes_type_id;
		netsukuku_incoming_nodes_type_id = g_type_register_fundamental (g_type_fundamental_next (), "NetsukukuIncomingNodes", &g_define_type_info, &g_define_type_fundamental_info, 0);
		g_once_init_leave (&netsukuku_incoming_nodes_type_id__volatile, netsukuku_incoming_nodes_type_id);
	}
	return netsukuku_incoming_nodes_type_id__volatile;
}


gpointer netsukuku_incoming_nodes_ref (gpointer instance) {
	NetsukukuIncomingNodes* self;
	self = instance;
	g_atomic_int_inc (&self->ref_count);
	return instance;
}


void netsukuku_incoming_nodes_unref (gpointer instance) {
	NetsukukuIncomingNodes* self;
	self = instance;
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
		NETSUKUKU_INCOMING_NODES_GET_CLASS (self)->finalize (self);
		g_type_free_instance ((GTypeInstance *) self);
	}
}


void ntk_test_qspn_tester_set_up (NtkTestQspnTester* self) {
	gchar* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = g_strdup ("");
	_g_free0 (self->priv->logger);
	self->priv->logger = _tmp0_;
}


void ntk_test_qspn_tester_tear_down (NtkTestQspnTester* self) {
	gchar* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = g_strdup ("");
	_g_free0 (self->priv->logger);
	self->priv->logger = _tmp0_;
}


static gboolean _netsukuku_hcoord_equal_func_gee_equal_data_func (gconstpointer a, gconstpointer b, gpointer self) {
	gboolean result;
	result = netsukuku_hcoord_equal_func (a, b);
	return result;
}


void ntk_test_qspn_tester_test_basics (NtkTestQspnTester* self) {
	NetsukukuTracerPacketList* _tmp0_;
	NetsukukuTracerPacketList* l1;
	NetsukukuTracerPacketList* _tmp1_;
	NetsukukuNullREM* _tmp2_;
	NetsukukuNullREM* _tmp3_;
	NetsukukuTracerPacketList* _tmp4_;
	NetsukukuTracerPacketList* _tmp5_ = NULL;
	NetsukukuTracerPacketList* l2;
	NetsukukuTracerPacketList* _tmp6_;
	NetsukukuTracerPacketList* _tmp7_;
	gint* _tmp8_ = NULL;
	gint* _tmp9_;
	gint _tmp9__length1;
	NetsukukuNIP* _tmp10_;
	NetsukukuNIP* _tmp11_;
	gboolean _tmp12_ = FALSE;
	NetsukukuTracerPacketList* _tmp13_;
	NetsukukuRTT* _tmp14_;
	NetsukukuRTT* _tmp15_;
	NetsukukuRoutesSet* _tmp22_;
	NetsukukuRoutesSet* r;
	NetsukukuRoutesSet* _tmp23_;
	NetsukukuNullREM* _tmp24_;
	NetsukukuNullREM* _tmp25_;
	GeeArrayList* _tmp26_;
	GeeArrayList* _tmp27_;
	NetsukukuGNodeID* _tmp28_;
	NetsukukuGNodeID* _tmp29_;
	NetsukukuRoutesSet* _tmp30_;
	NetsukukuNullREM* _tmp31_;
	NetsukukuNullREM* _tmp32_;
	GeeArrayList* _tmp33_;
	GeeArrayList* _tmp34_;
	NetsukukuGNodeID* _tmp35_;
	NetsukukuGNodeID* _tmp36_;
	NetsukukuRoutesSet* _tmp37_;
	NetsukukuNullREM* _tmp38_;
	NetsukukuNullREM* _tmp39_;
	GeeArrayList* _tmp40_;
	GeeArrayList* _tmp41_;
	NetsukukuGNodeID* _tmp42_;
	NetsukukuGNodeID* _tmp43_;
	gboolean has_one;
	gboolean has_two;
	gboolean _tmp66_ = FALSE;
	gboolean _tmp67_;
	gboolean _tmp69_;
	NetsukukuRouteInSet* ris0 = NULL;
	NetsukukuRouteInSet* _tmp99_;
	GeeList* _tmp100_;
	GeeList* _tmp101_;
	gboolean _tmp102_;
	gboolean _tmp103_;
	NetsukukuRouteInSet* _tmp104_;
	NetsukukuREM* _tmp105_;
	NetsukukuREM* _tmp106_;
	GType _tmp107_ = 0UL;
	NetsukukuRouteInSet* _tmp133_;
	GeeList* _tmp134_;
	GeeList* _tmp135_;
	gboolean _tmp136_;
	gboolean _tmp137_;
	NetsukukuRouteInSet* _tmp138_;
	NetsukukuREM* _tmp139_;
	NetsukukuREM* _tmp140_;
	GType _tmp141_ = 0UL;
	NetsukukuRoutesSetPerLevel* rsl0 = NULL;
	NetsukukuRoutesSet* rs0 = NULL;
	NetsukukuRoutesSet* _tmp243_;
	NetsukukuRoutesSetPerLevel** _tmp244_;
	gint _tmp244__length1;
	NetsukukuRoutesSet* _tmp338_;
	NetsukukuRouteInSet* _tmp339_ = NULL;
	NetsukukuRouteInSet* ris12;
	NetsukukuRouteInSet* _tmp340_;
	NetsukukuREM* _tmp341_;
	NetsukukuREM* _tmp342_;
	GType _tmp343_ = 0UL;
	NetsukukuRouteInSet* _tmp344_;
	GeeList* _tmp345_;
	GeeList* _tmp346_;
	gint _tmp347_;
	gint _tmp348_;
	NetsukukuRouteInSet* _tmp349_;
	NetsukukuGNodeID* _tmp350_;
	NetsukukuGNodeID* _tmp351_;
	gint _tmp352_;
	gint _tmp353_;
	NetsukukuRoutesSet* _tmp354_;
	NetsukukuRouteInSet* _tmp355_ = NULL;
	NetsukukuRouteInSet* ris34;
	NetsukukuRouteInSet* _tmp356_;
	NetsukukuREM* _tmp357_;
	NetsukukuREM* _tmp358_;
	GType _tmp359_ = 0UL;
	NetsukukuRouteInSet* _tmp360_;
	GeeList* _tmp361_;
	GeeList* _tmp362_;
	gint _tmp363_;
	gint _tmp364_;
	NetsukukuRouteInSet* _tmp365_;
	NetsukukuGNodeID* _tmp366_;
	NetsukukuGNodeID* _tmp367_;
	gint _tmp368_;
	gint _tmp369_;
	NetsukukuRoutesSet* _tmp370_;
	NetsukukuRouteInSet* _tmp371_ = NULL;
	NetsukukuRouteInSet* ris01;
	NetsukukuRouteInSet* _tmp372_;
	NetsukukuREM* _tmp373_;
	NetsukukuREM* _tmp374_;
	GType _tmp375_ = 0UL;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = netsukuku_tracer_packet_list_new ();
	l1 = _tmp0_;
	_tmp1_ = l1;
	_tmp2_ = netsukuku_null_rem_new ();
	_tmp3_ = _tmp2_;
	netsukuku_tracer_packet_list_append (_tmp1_, 3, (NetsukukuREM*) _tmp3_);
	_g_object_unref0 (_tmp3_);
	_tmp4_ = l1;
	_tmp5_ = netsukuku_tracer_packet_list_clone (_tmp4_);
	l2 = _tmp5_;
	_tmp6_ = l2;
	netsukuku_tracer_packet_list_group (_tmp6_, 2, 1);
	_tmp7_ = l2;
	_tmp8_ = g_new0 (gint, 3);
	_tmp8_[0] = 5;
	_tmp8_[1] = 4;
	_tmp8_[2] = 3;
	_tmp9_ = _tmp8_;
	_tmp9__length1 = 3;
	_tmp10_ = netsukuku_nip_new (_tmp9_, 3);
	_tmp11_ = _tmp10_;
	_tmp12_ = netsukuku_tracer_packet_list_contains (_tmp7_, _tmp11_);
	_vala_assert (!_tmp12_, "! l2.contains(new NIP({5, 4, 3}))");
	_g_object_unref0 (_tmp11_);
	_tmp9_ = (g_free (_tmp9_), NULL);
	_tmp13_ = l2;
	_tmp14_ = netsukuku_rtt_new (100);
	_tmp15_ = _tmp14_;
	netsukuku_tracer_packet_list_append (_tmp13_, 5, (NetsukukuREM*) _tmp15_);
	_g_object_unref0 (_tmp15_);
	if (NTK_TEST_QSPN_TESTER_output) {
		FILE* _tmp16_;
		NetsukukuTracerPacketList* _tmp17_;
		gchar* _tmp18_ = NULL;
		gchar* _tmp19_;
		gchar* _tmp20_ = NULL;
		gchar* _tmp21_;
		_tmp16_ = stdout;
		_tmp17_ = l2;
		_tmp18_ = netsukuku_tracer_packet_list_to_string (_tmp17_);
		_tmp19_ = _tmp18_;
		_tmp20_ = g_strconcat ("\nTPL = ", _tmp19_, "\n", NULL);
		_tmp21_ = _tmp20_;
		fprintf (_tmp16_, "%s", _tmp21_);
		_g_free0 (_tmp21_);
		_g_free0 (_tmp19_);
	}
	_tmp22_ = netsukuku_routes_set_new (4);
	r = _tmp22_;
	_tmp23_ = r;
	_tmp24_ = netsukuku_null_rem_new ();
	_tmp25_ = _tmp24_;
	_tmp26_ = gee_array_list_new (NETSUKUKU_TYPE_HCOORD, (GBoxedCopyFunc) g_object_ref, g_object_unref, _netsukuku_hcoord_equal_func_gee_equal_data_func, NULL, NULL);
	_tmp27_ = _tmp26_;
	_tmp28_ = netsukuku_gnode_id_new (0, 0, 1234);
	_tmp29_ = _tmp28_;
	netsukuku_routes_set_add_replace (_tmp23_, 3, 1, (NetsukukuREM*) _tmp25_, (GeeList*) _tmp27_, _tmp29_);
	_g_object_unref0 (_tmp29_);
	_g_object_unref0 (_tmp27_);
	_g_object_unref0 (_tmp25_);
	_tmp30_ = r;
	_tmp31_ = netsukuku_null_rem_new ();
	_tmp32_ = _tmp31_;
	_tmp33_ = gee_array_list_new (NETSUKUKU_TYPE_HCOORD, (GBoxedCopyFunc) g_object_ref, g_object_unref, _netsukuku_hcoord_equal_func_gee_equal_data_func, NULL, NULL);
	_tmp34_ = _tmp33_;
	_tmp35_ = netsukuku_gnode_id_new (0, 0, 1234);
	_tmp36_ = _tmp35_;
	netsukuku_routes_set_add_replace (_tmp30_, 3, 2, (NetsukukuREM*) _tmp32_, (GeeList*) _tmp34_, _tmp36_);
	_g_object_unref0 (_tmp36_);
	_g_object_unref0 (_tmp34_);
	_g_object_unref0 (_tmp32_);
	_tmp37_ = r;
	_tmp38_ = netsukuku_null_rem_new ();
	_tmp39_ = _tmp38_;
	_tmp40_ = gee_array_list_new (NETSUKUKU_TYPE_HCOORD, (GBoxedCopyFunc) g_object_ref, g_object_unref, _netsukuku_hcoord_equal_func_gee_equal_data_func, NULL, NULL);
	_tmp41_ = _tmp40_;
	_tmp42_ = netsukuku_gnode_id_new (0, 0, 1234);
	_tmp43_ = _tmp42_;
	netsukuku_routes_set_add_replace (_tmp37_, 2, 1, (NetsukukuREM*) _tmp39_, (GeeList*) _tmp41_, _tmp43_);
	_g_object_unref0 (_tmp43_);
	_g_object_unref0 (_tmp41_);
	_g_object_unref0 (_tmp39_);
	has_one = FALSE;
	has_two = FALSE;
	{
		NetsukukuRoutesSet* _tmp44_;
		NetsukukuRoutesSetPerLevel** _tmp45_;
		gint _tmp45__length1;
		NetsukukuRoutesSetPerLevel* _tmp46_;
		GeeIterator* _tmp47_ = NULL;
		GeeIterator* _dst_it;
		_tmp44_ = r;
		_tmp45_ = _tmp44_->per_level;
		_tmp45__length1 = _tmp44_->per_level_length1;
		_tmp46_ = _tmp45_[3];
		_tmp47_ = netsukuku_routes_set_per_level_iterator (_tmp46_);
		_dst_it = _tmp47_;
		while (TRUE) {
			GeeIterator* _tmp48_;
			gboolean _tmp49_ = FALSE;
			GeeIterator* _tmp50_;
			gpointer _tmp51_ = NULL;
			gint dst;
			gint _tmp52_;
			gint _tmp53_;
			NetsukukuRoutesSet* _tmp54_;
			gint _tmp55_;
			NetsukukuRouteInSet* _tmp56_ = NULL;
			NetsukukuRouteInSet* ris;
			NetsukukuRouteInSet* _tmp57_;
			NetsukukuREM* _tmp58_;
			NetsukukuREM* _tmp59_;
			GType _tmp60_ = 0UL;
			NetsukukuRouteInSet* _tmp61_;
			GeeList* _tmp62_;
			GeeList* _tmp63_;
			gboolean _tmp64_;
			gboolean _tmp65_;
			_tmp48_ = _dst_it;
			_tmp49_ = gee_iterator_next (_tmp48_);
			if (!_tmp49_) {
				break;
			}
			_tmp50_ = _dst_it;
			_tmp51_ = gee_iterator_get (_tmp50_);
			dst = (gint) ((gintptr) _tmp51_);
			_tmp52_ = dst;
			if (_tmp52_ == 1) {
				has_one = TRUE;
			}
			_tmp53_ = dst;
			if (_tmp53_ == 2) {
				has_two = TRUE;
			}
			_tmp54_ = r;
			_tmp55_ = dst;
			_tmp56_ = netsukuku_routes_set_get_value (_tmp54_, 3, _tmp55_);
			ris = _tmp56_;
			_tmp57_ = ris;
			_tmp58_ = netsukuku_route_in_set_get_rem (_tmp57_);
			_tmp59_ = _tmp58_;
			_tmp60_ = G_TYPE_FROM_INSTANCE ((GObject*) _tmp59_);
			_vala_assert (_tmp60_ == NETSUKUKU_TYPE_NULL_REM, "ris.rem.get_type() == typeof(NullREM)");
			_tmp61_ = ris;
			_tmp62_ = netsukuku_route_in_set_get_hops (_tmp61_);
			_tmp63_ = _tmp62_;
			_tmp64_ = gee_collection_get_is_empty ((GeeCollection*) _tmp63_);
			_tmp65_ = _tmp64_;
			_vala_assert (_tmp65_, "ris.hops.is_empty");
			_g_object_unref0 (ris);
		}
		_g_object_unref0 (_dst_it);
	}
	_tmp67_ = has_one;
	if (_tmp67_) {
		gboolean _tmp68_;
		_tmp68_ = has_two;
		_tmp66_ = _tmp68_;
	} else {
		_tmp66_ = FALSE;
	}
	_tmp69_ = _tmp66_;
	_vala_assert (_tmp69_, "has_one && has_two");
	{
		guchar* orig = NULL;
		gint orig_length1 = 0;
		gint _orig_size_ = 0;
		guchar* _tmp83_;
		gint _tmp83__length1;
		guchar* _tmp84_ = NULL;
		guchar* dest;
		gint dest_length1;
		gint _dest_size_;
		guchar* _tmp96_;
		gint _tmp96__length1;
		zcdISerializable* _tmp97_ = NULL;
		zcdISerializable* _tmp98_;
		{
			gint dst;
			NetsukukuNullREM* _tmp70_;
			NetsukukuREM* rem;
			GeeArrayList* _tmp71_;
			GeeList* hops;
			GeeList* _tmp72_;
			NetsukukuHCoord* _tmp73_;
			NetsukukuHCoord* _tmp74_;
			NetsukukuGNodeID* _tmp75_;
			NetsukukuGNodeID* gid;
			NetsukukuREM* _tmp76_;
			GeeList* _tmp77_;
			NetsukukuGNodeID* _tmp78_;
			NetsukukuRouteInSet* _tmp79_;
			NetsukukuRouteInSet* ris;
			NetsukukuRouteInSet* _tmp80_;
			gint _tmp81_ = 0;
			guchar* _tmp82_ = NULL;
			dst = 2;
			_tmp70_ = netsukuku_null_rem_new ();
			rem = (NetsukukuREM*) _tmp70_;
			_tmp71_ = gee_array_list_new (NETSUKUKU_TYPE_HCOORD, (GBoxedCopyFunc) g_object_ref, g_object_unref, _netsukuku_hcoord_equal_func_gee_equal_data_func, NULL, NULL);
			hops = (GeeList*) _tmp71_;
			_tmp72_ = hops;
			_tmp73_ = netsukuku_hcoord_new (3, 4);
			_tmp74_ = _tmp73_;
			gee_collection_add ((GeeCollection*) _tmp72_, _tmp74_);
			_g_object_unref0 (_tmp74_);
			_tmp75_ = netsukuku_gnode_id_new (1, 1, 12345);
			gid = _tmp75_;
			_tmp76_ = rem;
			_tmp77_ = hops;
			_tmp78_ = gid;
			_tmp79_ = netsukuku_route_in_set_new (_tmp76_, _tmp77_, _tmp78_);
			ris = _tmp79_;
			_tmp80_ = ris;
			_tmp82_ = zcd_iserializable_serialize ((zcdISerializable*) _tmp80_, &_tmp81_);
			orig = (g_free (orig), NULL);
			orig = _tmp82_;
			orig_length1 = _tmp81_;
			_orig_size_ = orig_length1;
			_g_object_unref0 (ris);
			_g_object_unref0 (gid);
			_g_object_unref0 (hops);
			_g_object_unref0 (rem);
		}
		_tmp83_ = orig;
		_tmp83__length1 = orig_length1;
		_tmp84_ = g_new0 (guchar, _tmp83__length1);
		dest = _tmp84_;
		dest_length1 = _tmp83__length1;
		_dest_size_ = dest_length1;
		{
			gint i;
			i = 0;
			{
				gboolean _tmp85_;
				_tmp85_ = TRUE;
				while (TRUE) {
					gboolean _tmp86_;
					gint _tmp88_;
					guchar* _tmp89_;
					gint _tmp89__length1;
					guchar* _tmp90_;
					gint _tmp90__length1;
					gint _tmp91_;
					guchar* _tmp92_;
					gint _tmp92__length1;
					gint _tmp93_;
					guchar _tmp94_;
					guchar _tmp95_;
					_tmp86_ = _tmp85_;
					if (!_tmp86_) {
						gint _tmp87_;
						_tmp87_ = i;
						i = _tmp87_ + 1;
					}
					_tmp85_ = FALSE;
					_tmp88_ = i;
					_tmp89_ = orig;
					_tmp89__length1 = orig_length1;
					if (!(_tmp88_ < _tmp89__length1)) {
						break;
					}
					_tmp90_ = dest;
					_tmp90__length1 = dest_length1;
					_tmp91_ = i;
					_tmp92_ = orig;
					_tmp92__length1 = orig_length1;
					_tmp93_ = i;
					_tmp94_ = _tmp92_[_tmp93_];
					_tmp90_[_tmp91_] = _tmp94_;
					_tmp95_ = _tmp90_[_tmp91_];
				}
			}
		}
		_tmp96_ = dest;
		_tmp96__length1 = dest_length1;
		_tmp97_ = zcd_iserializable_deserialize (_tmp96_, _tmp96__length1, &_inner_error_);
		_tmp98_ = _tmp97_;
		if (_inner_error_ != NULL) {
			dest = (g_free (dest), NULL);
			orig = (g_free (orig), NULL);
			_g_object_unref0 (ris0);
			_g_object_unref0 (r);
			_g_object_unref0 (l2);
			_g_object_unref0 (l1);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
		_g_object_unref0 (ris0);
		ris0 = G_TYPE_CHECK_INSTANCE_CAST (_tmp98_, NETSUKUKU_TYPE_ROUTE_IN_SET, NetsukukuRouteInSet);
		dest = (g_free (dest), NULL);
		orig = (g_free (orig), NULL);
	}
	_tmp99_ = ris0;
	_tmp100_ = netsukuku_route_in_set_get_hops (_tmp99_);
	_tmp101_ = _tmp100_;
	_tmp102_ = gee_collection_get_is_empty ((GeeCollection*) _tmp101_);
	_tmp103_ = _tmp102_;
	_vala_assert (!_tmp103_, "! ris0.hops.is_empty");
	_tmp104_ = ris0;
	_tmp105_ = netsukuku_route_in_set_get_rem (_tmp104_);
	_tmp106_ = _tmp105_;
	_tmp107_ = G_TYPE_FROM_INSTANCE ((GObject*) _tmp106_);
	_vala_assert (_tmp107_ == NETSUKUKU_TYPE_NULL_REM, "ris0.rem.get_type() == typeof(NullREM)");
	{
		guchar* orig = NULL;
		gint orig_length1 = 0;
		gint _orig_size_ = 0;
		guchar* _tmp117_;
		gint _tmp117__length1;
		guchar* _tmp118_ = NULL;
		guchar* dest;
		gint dest_length1;
		gint _dest_size_;
		guchar* _tmp130_;
		gint _tmp130__length1;
		zcdISerializable* _tmp131_ = NULL;
		zcdISerializable* _tmp132_;
		{
			gint dst;
			NetsukukuDeadREM* _tmp108_;
			NetsukukuREM* rem;
			GeeArrayList* _tmp109_;
			GeeList* hops;
			NetsukukuGNodeID* gid;
			NetsukukuREM* _tmp110_;
			GeeList* _tmp111_;
			NetsukukuGNodeID* _tmp112_;
			NetsukukuRouteInSet* _tmp113_;
			NetsukukuRouteInSet* ris;
			NetsukukuRouteInSet* _tmp114_;
			gint _tmp115_ = 0;
			guchar* _tmp116_ = NULL;
			dst = 2;
			_tmp108_ = netsukuku_dead_rem_new ();
			rem = (NetsukukuREM*) _tmp108_;
			_tmp109_ = gee_array_list_new (NETSUKUKU_TYPE_HCOORD, (GBoxedCopyFunc) g_object_ref, g_object_unref, _netsukuku_hcoord_equal_func_gee_equal_data_func, NULL, NULL);
			hops = (GeeList*) _tmp109_;
			gid = NULL;
			_tmp110_ = rem;
			_tmp111_ = hops;
			_tmp112_ = gid;
			_tmp113_ = netsukuku_route_in_set_new (_tmp110_, _tmp111_, _tmp112_);
			ris = _tmp113_;
			_tmp114_ = ris;
			_tmp116_ = zcd_iserializable_serialize ((zcdISerializable*) _tmp114_, &_tmp115_);
			orig = (g_free (orig), NULL);
			orig = _tmp116_;
			orig_length1 = _tmp115_;
			_orig_size_ = orig_length1;
			_g_object_unref0 (ris);
			_g_object_unref0 (gid);
			_g_object_unref0 (hops);
			_g_object_unref0 (rem);
		}
		_tmp117_ = orig;
		_tmp117__length1 = orig_length1;
		_tmp118_ = g_new0 (guchar, _tmp117__length1);
		dest = _tmp118_;
		dest_length1 = _tmp117__length1;
		_dest_size_ = dest_length1;
		{
			gint i;
			i = 0;
			{
				gboolean _tmp119_;
				_tmp119_ = TRUE;
				while (TRUE) {
					gboolean _tmp120_;
					gint _tmp122_;
					guchar* _tmp123_;
					gint _tmp123__length1;
					guchar* _tmp124_;
					gint _tmp124__length1;
					gint _tmp125_;
					guchar* _tmp126_;
					gint _tmp126__length1;
					gint _tmp127_;
					guchar _tmp128_;
					guchar _tmp129_;
					_tmp120_ = _tmp119_;
					if (!_tmp120_) {
						gint _tmp121_;
						_tmp121_ = i;
						i = _tmp121_ + 1;
					}
					_tmp119_ = FALSE;
					_tmp122_ = i;
					_tmp123_ = orig;
					_tmp123__length1 = orig_length1;
					if (!(_tmp122_ < _tmp123__length1)) {
						break;
					}
					_tmp124_ = dest;
					_tmp124__length1 = dest_length1;
					_tmp125_ = i;
					_tmp126_ = orig;
					_tmp126__length1 = orig_length1;
					_tmp127_ = i;
					_tmp128_ = _tmp126_[_tmp127_];
					_tmp124_[_tmp125_] = _tmp128_;
					_tmp129_ = _tmp124_[_tmp125_];
				}
			}
		}
		_tmp130_ = dest;
		_tmp130__length1 = dest_length1;
		_tmp131_ = zcd_iserializable_deserialize (_tmp130_, _tmp130__length1, &_inner_error_);
		_tmp132_ = _tmp131_;
		if (_inner_error_ != NULL) {
			dest = (g_free (dest), NULL);
			orig = (g_free (orig), NULL);
			_g_object_unref0 (ris0);
			_g_object_unref0 (r);
			_g_object_unref0 (l2);
			_g_object_unref0 (l1);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
		_g_object_unref0 (ris0);
		ris0 = G_TYPE_CHECK_INSTANCE_CAST (_tmp132_, NETSUKUKU_TYPE_ROUTE_IN_SET, NetsukukuRouteInSet);
		dest = (g_free (dest), NULL);
		orig = (g_free (orig), NULL);
	}
	_tmp133_ = ris0;
	_tmp134_ = netsukuku_route_in_set_get_hops (_tmp133_);
	_tmp135_ = _tmp134_;
	_tmp136_ = gee_collection_get_is_empty ((GeeCollection*) _tmp135_);
	_tmp137_ = _tmp136_;
	_vala_assert (_tmp137_, "ris0.hops.is_empty");
	_tmp138_ = ris0;
	_tmp139_ = netsukuku_route_in_set_get_rem (_tmp138_);
	_tmp140_ = _tmp139_;
	_tmp141_ = G_TYPE_FROM_INSTANCE ((GObject*) _tmp140_);
	_vala_assert (_tmp141_ == NETSUKUKU_TYPE_DEAD_REM, "ris0.rem.get_type() == typeof(DeadREM)");
	{
		guchar* orig = NULL;
		gint orig_length1 = 0;
		gint _orig_size_ = 0;
		guchar* _tmp146_;
		gint _tmp146__length1;
		guchar* _tmp147_ = NULL;
		guchar* dest;
		gint dest_length1;
		gint _dest_size_;
		guchar* _tmp159_;
		gint _tmp159__length1;
		zcdISerializable* _tmp160_ = NULL;
		zcdISerializable* _tmp161_;
		{
			NetsukukuRoutesSetPerLevel* _tmp142_;
			NetsukukuRoutesSetPerLevel* rsl;
			NetsukukuRoutesSetPerLevel* _tmp143_;
			gint _tmp144_ = 0;
			guchar* _tmp145_ = NULL;
			_tmp142_ = netsukuku_routes_set_per_level_new ();
			rsl = _tmp142_;
			_tmp143_ = rsl;
			_tmp145_ = zcd_iserializable_serialize ((zcdISerializable*) _tmp143_, &_tmp144_);
			orig = (g_free (orig), NULL);
			orig = _tmp145_;
			orig_length1 = _tmp144_;
			_orig_size_ = orig_length1;
			_g_object_unref0 (rsl);
		}
		_tmp146_ = orig;
		_tmp146__length1 = orig_length1;
		_tmp147_ = g_new0 (guchar, _tmp146__length1);
		dest = _tmp147_;
		dest_length1 = _tmp146__length1;
		_dest_size_ = dest_length1;
		{
			gint i;
			i = 0;
			{
				gboolean _tmp148_;
				_tmp148_ = TRUE;
				while (TRUE) {
					gboolean _tmp149_;
					gint _tmp151_;
					guchar* _tmp152_;
					gint _tmp152__length1;
					guchar* _tmp153_;
					gint _tmp153__length1;
					gint _tmp154_;
					guchar* _tmp155_;
					gint _tmp155__length1;
					gint _tmp156_;
					guchar _tmp157_;
					guchar _tmp158_;
					_tmp149_ = _tmp148_;
					if (!_tmp149_) {
						gint _tmp150_;
						_tmp150_ = i;
						i = _tmp150_ + 1;
					}
					_tmp148_ = FALSE;
					_tmp151_ = i;
					_tmp152_ = orig;
					_tmp152__length1 = orig_length1;
					if (!(_tmp151_ < _tmp152__length1)) {
						break;
					}
					_tmp153_ = dest;
					_tmp153__length1 = dest_length1;
					_tmp154_ = i;
					_tmp155_ = orig;
					_tmp155__length1 = orig_length1;
					_tmp156_ = i;
					_tmp157_ = _tmp155_[_tmp156_];
					_tmp153_[_tmp154_] = _tmp157_;
					_tmp158_ = _tmp153_[_tmp154_];
				}
			}
		}
		_tmp159_ = dest;
		_tmp159__length1 = dest_length1;
		_tmp160_ = zcd_iserializable_deserialize (_tmp159_, _tmp159__length1, &_inner_error_);
		_tmp161_ = _tmp160_;
		if (_inner_error_ != NULL) {
			dest = (g_free (dest), NULL);
			orig = (g_free (orig), NULL);
			_g_object_unref0 (rsl0);
			_g_object_unref0 (ris0);
			_g_object_unref0 (r);
			_g_object_unref0 (l2);
			_g_object_unref0 (l1);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
		_g_object_unref0 (rsl0);
		rsl0 = G_TYPE_CHECK_INSTANCE_CAST (_tmp161_, NETSUKUKU_TYPE_ROUTES_SET_PER_LEVEL, NetsukukuRoutesSetPerLevel);
		dest = (g_free (dest), NULL);
		orig = (g_free (orig), NULL);
	}
	{
		NetsukukuRoutesSetPerLevel* _tmp162_;
		GeeIterator* _tmp163_ = NULL;
		GeeIterator* _i_it;
		_tmp162_ = rsl0;
		_tmp163_ = netsukuku_routes_set_per_level_iterator (_tmp162_);
		_i_it = _tmp163_;
		while (TRUE) {
			GeeIterator* _tmp164_;
			gboolean _tmp165_ = FALSE;
			GeeIterator* _tmp166_;
			gpointer _tmp167_ = NULL;
			gint i;
			_tmp164_ = _i_it;
			_tmp165_ = gee_iterator_next (_tmp164_);
			if (!_tmp165_) {
				break;
			}
			_tmp166_ = _i_it;
			_tmp167_ = gee_iterator_get (_tmp166_);
			i = (gint) ((gintptr) _tmp167_);
			_vala_assert (FALSE, "false");
		}
		_g_object_unref0 (_i_it);
	}
	{
		guchar* orig = NULL;
		gint orig_length1 = 0;
		gint _orig_size_ = 0;
		guchar* _tmp183_;
		gint _tmp183__length1;
		guchar* _tmp184_ = NULL;
		guchar* dest;
		gint dest_length1;
		gint _dest_size_;
		guchar* _tmp196_;
		gint _tmp196__length1;
		zcdISerializable* _tmp197_ = NULL;
		zcdISerializable* _tmp198_;
		{
			gint dst;
			NetsukukuNullREM* _tmp168_;
			NetsukukuREM* rem;
			GeeArrayList* _tmp169_;
			GeeList* hops;
			GeeList* _tmp170_;
			NetsukukuHCoord* _tmp171_;
			NetsukukuHCoord* _tmp172_;
			NetsukukuGNodeID* _tmp173_;
			NetsukukuGNodeID* gid;
			NetsukukuRoutesSetPerLevel* _tmp174_;
			NetsukukuRoutesSetPerLevel* rsl;
			NetsukukuRoutesSetPerLevel* _tmp175_;
			gint _tmp176_;
			NetsukukuREM* _tmp177_;
			GeeList* _tmp178_;
			NetsukukuGNodeID* _tmp179_;
			NetsukukuRoutesSetPerLevel* _tmp180_;
			gint _tmp181_ = 0;
			guchar* _tmp182_ = NULL;
			dst = 2;
			_tmp168_ = netsukuku_null_rem_new ();
			rem = (NetsukukuREM*) _tmp168_;
			_tmp169_ = gee_array_list_new (NETSUKUKU_TYPE_HCOORD, (GBoxedCopyFunc) g_object_ref, g_object_unref, _netsukuku_hcoord_equal_func_gee_equal_data_func, NULL, NULL);
			hops = (GeeList*) _tmp169_;
			_tmp170_ = hops;
			_tmp171_ = netsukuku_hcoord_new (3, 4);
			_tmp172_ = _tmp171_;
			gee_collection_add ((GeeCollection*) _tmp170_, _tmp172_);
			_g_object_unref0 (_tmp172_);
			_tmp173_ = netsukuku_gnode_id_new (1, 1, 12345);
			gid = _tmp173_;
			_tmp174_ = netsukuku_routes_set_per_level_new ();
			rsl = _tmp174_;
			_tmp175_ = rsl;
			_tmp176_ = dst;
			_tmp177_ = rem;
			_tmp178_ = hops;
			_tmp179_ = gid;
			netsukuku_routes_set_per_level_add_replace (_tmp175_, _tmp176_, _tmp177_, _tmp178_, _tmp179_);
			_tmp180_ = rsl;
			_tmp182_ = zcd_iserializable_serialize ((zcdISerializable*) _tmp180_, &_tmp181_);
			orig = (g_free (orig), NULL);
			orig = _tmp182_;
			orig_length1 = _tmp181_;
			_orig_size_ = orig_length1;
			_g_object_unref0 (rsl);
			_g_object_unref0 (gid);
			_g_object_unref0 (hops);
			_g_object_unref0 (rem);
		}
		_tmp183_ = orig;
		_tmp183__length1 = orig_length1;
		_tmp184_ = g_new0 (guchar, _tmp183__length1);
		dest = _tmp184_;
		dest_length1 = _tmp183__length1;
		_dest_size_ = dest_length1;
		{
			gint i;
			i = 0;
			{
				gboolean _tmp185_;
				_tmp185_ = TRUE;
				while (TRUE) {
					gboolean _tmp186_;
					gint _tmp188_;
					guchar* _tmp189_;
					gint _tmp189__length1;
					guchar* _tmp190_;
					gint _tmp190__length1;
					gint _tmp191_;
					guchar* _tmp192_;
					gint _tmp192__length1;
					gint _tmp193_;
					guchar _tmp194_;
					guchar _tmp195_;
					_tmp186_ = _tmp185_;
					if (!_tmp186_) {
						gint _tmp187_;
						_tmp187_ = i;
						i = _tmp187_ + 1;
					}
					_tmp185_ = FALSE;
					_tmp188_ = i;
					_tmp189_ = orig;
					_tmp189__length1 = orig_length1;
					if (!(_tmp188_ < _tmp189__length1)) {
						break;
					}
					_tmp190_ = dest;
					_tmp190__length1 = dest_length1;
					_tmp191_ = i;
					_tmp192_ = orig;
					_tmp192__length1 = orig_length1;
					_tmp193_ = i;
					_tmp194_ = _tmp192_[_tmp193_];
					_tmp190_[_tmp191_] = _tmp194_;
					_tmp195_ = _tmp190_[_tmp191_];
				}
			}
		}
		_tmp196_ = dest;
		_tmp196__length1 = dest_length1;
		_tmp197_ = zcd_iserializable_deserialize (_tmp196_, _tmp196__length1, &_inner_error_);
		_tmp198_ = _tmp197_;
		if (_inner_error_ != NULL) {
			dest = (g_free (dest), NULL);
			orig = (g_free (orig), NULL);
			_g_object_unref0 (rsl0);
			_g_object_unref0 (ris0);
			_g_object_unref0 (r);
			_g_object_unref0 (l2);
			_g_object_unref0 (l1);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
		_g_object_unref0 (rsl0);
		rsl0 = G_TYPE_CHECK_INSTANCE_CAST (_tmp198_, NETSUKUKU_TYPE_ROUTES_SET_PER_LEVEL, NetsukukuRoutesSetPerLevel);
		dest = (g_free (dest), NULL);
		orig = (g_free (orig), NULL);
	}
	{
		NetsukukuRoutesSetPerLevel* _tmp199_;
		GeeIterator* _tmp200_ = NULL;
		GeeIterator* _i_it;
		_tmp199_ = rsl0;
		_tmp200_ = netsukuku_routes_set_per_level_iterator (_tmp199_);
		_i_it = _tmp200_;
		while (TRUE) {
			GeeIterator* _tmp201_;
			gboolean _tmp202_ = FALSE;
			GeeIterator* _tmp203_;
			gpointer _tmp204_ = NULL;
			gint i;
			gint _tmp205_;
			NetsukukuRoutesSetPerLevel* _tmp206_;
			gint _tmp207_;
			NetsukukuRouteInSet* _tmp208_ = NULL;
			NetsukukuRouteInSet* ris;
			NetsukukuRouteInSet* _tmp209_;
			NetsukukuREM* _tmp210_;
			NetsukukuREM* _tmp211_;
			GType _tmp212_ = 0UL;
			NetsukukuRouteInSet* _tmp213_;
			GeeList* _tmp214_;
			GeeList* _tmp215_;
			gint _tmp216_;
			gint _tmp217_;
			NetsukukuRouteInSet* _tmp218_;
			NetsukukuGNodeID* _tmp219_;
			NetsukukuGNodeID* _tmp220_;
			gint _tmp221_;
			gint _tmp222_;
			_tmp201_ = _i_it;
			_tmp202_ = gee_iterator_next (_tmp201_);
			if (!_tmp202_) {
				break;
			}
			_tmp203_ = _i_it;
			_tmp204_ = gee_iterator_get (_tmp203_);
			i = (gint) ((gintptr) _tmp204_);
			_tmp205_ = i;
			_vala_assert (_tmp205_ == 2, "i == 2");
			_tmp206_ = rsl0;
			_tmp207_ = i;
			_tmp208_ = netsukuku_routes_set_per_level_get_value (_tmp206_, _tmp207_);
			ris = _tmp208_;
			_tmp209_ = ris;
			_tmp210_ = netsukuku_route_in_set_get_rem (_tmp209_);
			_tmp211_ = _tmp210_;
			_tmp212_ = G_TYPE_FROM_INSTANCE ((GObject*) _tmp211_);
			_vala_assert (_tmp212_ == NETSUKUKU_TYPE_NULL_REM, "ris.rem.get_type() == typeof(NullREM)");
			_tmp213_ = ris;
			_tmp214_ = netsukuku_route_in_set_get_hops (_tmp213_);
			_tmp215_ = _tmp214_;
			_tmp216_ = gee_collection_get_size ((GeeCollection*) _tmp215_);
			_tmp217_ = _tmp216_;
			_vala_assert (_tmp217_ == 1, "ris.hops.size == 1");
			_tmp218_ = ris;
			_tmp219_ = netsukuku_route_in_set_get_gid (_tmp218_);
			_tmp220_ = _tmp219_;
			_tmp221_ = netsukuku_gnode_id_get_ident (_tmp220_);
			_tmp222_ = _tmp221_;
			_vala_assert (_tmp222_ == 12345, "ris.gid.ident == 12345");
			_g_object_unref0 (ris);
		}
		_g_object_unref0 (_i_it);
	}
	{
		guchar* orig = NULL;
		gint orig_length1 = 0;
		gint _orig_size_ = 0;
		guchar* _tmp227_;
		gint _tmp227__length1;
		guchar* _tmp228_ = NULL;
		guchar* dest;
		gint dest_length1;
		gint _dest_size_;
		guchar* _tmp240_;
		gint _tmp240__length1;
		zcdISerializable* _tmp241_ = NULL;
		zcdISerializable* _tmp242_;
		{
			NetsukukuRoutesSet* _tmp223_;
			NetsukukuRoutesSet* rs;
			NetsukukuRoutesSet* _tmp224_;
			gint _tmp225_ = 0;
			guchar* _tmp226_ = NULL;
			_tmp223_ = netsukuku_routes_set_new (4);
			rs = _tmp223_;
			_tmp224_ = rs;
			_tmp226_ = zcd_iserializable_serialize ((zcdISerializable*) _tmp224_, &_tmp225_);
			orig = (g_free (orig), NULL);
			orig = _tmp226_;
			orig_length1 = _tmp225_;
			_orig_size_ = orig_length1;
			_g_object_unref0 (rs);
		}
		_tmp227_ = orig;
		_tmp227__length1 = orig_length1;
		_tmp228_ = g_new0 (guchar, _tmp227__length1);
		dest = _tmp228_;
		dest_length1 = _tmp227__length1;
		_dest_size_ = dest_length1;
		{
			gint i;
			i = 0;
			{
				gboolean _tmp229_;
				_tmp229_ = TRUE;
				while (TRUE) {
					gboolean _tmp230_;
					gint _tmp232_;
					guchar* _tmp233_;
					gint _tmp233__length1;
					guchar* _tmp234_;
					gint _tmp234__length1;
					gint _tmp235_;
					guchar* _tmp236_;
					gint _tmp236__length1;
					gint _tmp237_;
					guchar _tmp238_;
					guchar _tmp239_;
					_tmp230_ = _tmp229_;
					if (!_tmp230_) {
						gint _tmp231_;
						_tmp231_ = i;
						i = _tmp231_ + 1;
					}
					_tmp229_ = FALSE;
					_tmp232_ = i;
					_tmp233_ = orig;
					_tmp233__length1 = orig_length1;
					if (!(_tmp232_ < _tmp233__length1)) {
						break;
					}
					_tmp234_ = dest;
					_tmp234__length1 = dest_length1;
					_tmp235_ = i;
					_tmp236_ = orig;
					_tmp236__length1 = orig_length1;
					_tmp237_ = i;
					_tmp238_ = _tmp236_[_tmp237_];
					_tmp234_[_tmp235_] = _tmp238_;
					_tmp239_ = _tmp234_[_tmp235_];
				}
			}
		}
		_tmp240_ = dest;
		_tmp240__length1 = dest_length1;
		_tmp241_ = zcd_iserializable_deserialize (_tmp240_, _tmp240__length1, &_inner_error_);
		_tmp242_ = _tmp241_;
		if (_inner_error_ != NULL) {
			dest = (g_free (dest), NULL);
			orig = (g_free (orig), NULL);
			_g_object_unref0 (rs0);
			_g_object_unref0 (rsl0);
			_g_object_unref0 (ris0);
			_g_object_unref0 (r);
			_g_object_unref0 (l2);
			_g_object_unref0 (l1);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
		_g_object_unref0 (rs0);
		rs0 = G_TYPE_CHECK_INSTANCE_CAST (_tmp242_, NETSUKUKU_TYPE_ROUTES_SET, NetsukukuRoutesSet);
		dest = (g_free (dest), NULL);
		orig = (g_free (orig), NULL);
	}
	_tmp243_ = rs0;
	_tmp244_ = _tmp243_->per_level;
	_tmp244__length1 = _tmp243_->per_level_length1;
	_vala_assert (_tmp244__length1 == 4, "rs0.per_level.length == 4");
	{
		NetsukukuRoutesSet* _tmp245_;
		NetsukukuRoutesSetPerLevel** _tmp246_;
		gint _tmp246__length1;
		NetsukukuRoutesSetPerLevel* _tmp247_;
		GeeIterator* _tmp248_ = NULL;
		GeeIterator* _i_it;
		_tmp245_ = rs0;
		_tmp246_ = _tmp245_->per_level;
		_tmp246__length1 = _tmp245_->per_level_length1;
		_tmp247_ = _tmp246_[3];
		_tmp248_ = netsukuku_routes_set_per_level_iterator (_tmp247_);
		_i_it = _tmp248_;
		while (TRUE) {
			GeeIterator* _tmp249_;
			gboolean _tmp250_ = FALSE;
			GeeIterator* _tmp251_;
			gpointer _tmp252_ = NULL;
			gint i;
			_tmp249_ = _i_it;
			_tmp250_ = gee_iterator_next (_tmp249_);
			if (!_tmp250_) {
				break;
			}
			_tmp251_ = _i_it;
			_tmp252_ = gee_iterator_get (_tmp251_);
			i = (gint) ((gintptr) _tmp252_);
			_vala_assert (FALSE, "false");
		}
		_g_object_unref0 (_i_it);
	}
	{
		guchar* orig = NULL;
		gint orig_length1 = 0;
		gint _orig_size_ = 0;
		guchar* _tmp279_;
		gint _tmp279__length1;
		guchar* _tmp280_ = NULL;
		guchar* dest;
		gint dest_length1;
		gint _dest_size_;
		guchar* _tmp292_;
		gint _tmp292__length1;
		zcdISerializable* _tmp293_ = NULL;
		zcdISerializable* _tmp294_;
		{
			NetsukukuRoutesSet* _tmp253_;
			NetsukukuRoutesSet* rs;
			gint lvl1;
			gint dst1;
			NetsukukuNullREM* _tmp254_;
			NetsukukuREM* rem1;
			GeeArrayList* _tmp255_;
			GeeList* hops1;
			GeeList* _tmp256_;
			NetsukukuHCoord* _tmp257_;
			NetsukukuHCoord* _tmp258_;
			NetsukukuGNodeID* _tmp259_;
			NetsukukuGNodeID* gid1;
			NetsukukuRoutesSet* _tmp260_;
			gint _tmp261_;
			gint _tmp262_;
			NetsukukuREM* _tmp263_;
			GeeList* _tmp264_;
			NetsukukuGNodeID* _tmp265_;
			gint lvl2;
			gint dst2;
			NetsukukuNullREM* _tmp266_;
			NetsukukuREM* rem2;
			GeeArrayList* _tmp267_;
			GeeList* hops2;
			NetsukukuGNodeID* _tmp268_;
			NetsukukuGNodeID* gid2;
			NetsukukuRoutesSet* _tmp269_;
			gint _tmp270_;
			gint _tmp271_;
			NetsukukuREM* _tmp272_;
			GeeList* _tmp273_;
			NetsukukuGNodeID* _tmp274_;
			NetsukukuRoutesSet* _tmp275_;
			NetsukukuRoutesSet* _tmp276_;
			gint _tmp277_ = 0;
			guchar* _tmp278_ = NULL;
			_tmp253_ = netsukuku_routes_set_new (4);
			rs = _tmp253_;
			lvl1 = 1;
			dst1 = 2;
			_tmp254_ = netsukuku_null_rem_new ();
			rem1 = (NetsukukuREM*) _tmp254_;
			_tmp255_ = gee_array_list_new (NETSUKUKU_TYPE_HCOORD, (GBoxedCopyFunc) g_object_ref, g_object_unref, _netsukuku_hcoord_equal_func_gee_equal_data_func, NULL, NULL);
			hops1 = (GeeList*) _tmp255_;
			_tmp256_ = hops1;
			_tmp257_ = netsukuku_hcoord_new (3, 4);
			_tmp258_ = _tmp257_;
			gee_collection_add ((GeeCollection*) _tmp256_, _tmp258_);
			_g_object_unref0 (_tmp258_);
			_tmp259_ = netsukuku_gnode_id_new (1, 1, 12345);
			gid1 = _tmp259_;
			_tmp260_ = rs;
			_tmp261_ = lvl1;
			_tmp262_ = dst1;
			_tmp263_ = rem1;
			_tmp264_ = hops1;
			_tmp265_ = gid1;
			netsukuku_routes_set_add_replace (_tmp260_, _tmp261_, _tmp262_, _tmp263_, _tmp264_, _tmp265_);
			lvl2 = 3;
			dst2 = 4;
			_tmp266_ = netsukuku_null_rem_new ();
			rem2 = (NetsukukuREM*) _tmp266_;
			_tmp267_ = gee_array_list_new (NETSUKUKU_TYPE_HCOORD, (GBoxedCopyFunc) g_object_ref, g_object_unref, _netsukuku_hcoord_equal_func_gee_equal_data_func, NULL, NULL);
			hops2 = (GeeList*) _tmp267_;
			_tmp268_ = netsukuku_gnode_id_new (1, 1, 54321);
			gid2 = _tmp268_;
			_tmp269_ = rs;
			_tmp270_ = lvl2;
			_tmp271_ = dst2;
			_tmp272_ = rem2;
			_tmp273_ = hops2;
			_tmp274_ = gid2;
			netsukuku_routes_set_add_replace (_tmp269_, _tmp270_, _tmp271_, _tmp272_, _tmp273_, _tmp274_);
			_tmp275_ = rs;
			netsukuku_routes_set_add_replace_no_route (_tmp275_, 0, 1);
			_tmp276_ = rs;
			_tmp278_ = zcd_iserializable_serialize ((zcdISerializable*) _tmp276_, &_tmp277_);
			orig = (g_free (orig), NULL);
			orig = _tmp278_;
			orig_length1 = _tmp277_;
			_orig_size_ = orig_length1;
			_g_object_unref0 (gid2);
			_g_object_unref0 (hops2);
			_g_object_unref0 (rem2);
			_g_object_unref0 (gid1);
			_g_object_unref0 (hops1);
			_g_object_unref0 (rem1);
			_g_object_unref0 (rs);
		}
		_tmp279_ = orig;
		_tmp279__length1 = orig_length1;
		_tmp280_ = g_new0 (guchar, _tmp279__length1);
		dest = _tmp280_;
		dest_length1 = _tmp279__length1;
		_dest_size_ = dest_length1;
		{
			gint i;
			i = 0;
			{
				gboolean _tmp281_;
				_tmp281_ = TRUE;
				while (TRUE) {
					gboolean _tmp282_;
					gint _tmp284_;
					guchar* _tmp285_;
					gint _tmp285__length1;
					guchar* _tmp286_;
					gint _tmp286__length1;
					gint _tmp287_;
					guchar* _tmp288_;
					gint _tmp288__length1;
					gint _tmp289_;
					guchar _tmp290_;
					guchar _tmp291_;
					_tmp282_ = _tmp281_;
					if (!_tmp282_) {
						gint _tmp283_;
						_tmp283_ = i;
						i = _tmp283_ + 1;
					}
					_tmp281_ = FALSE;
					_tmp284_ = i;
					_tmp285_ = orig;
					_tmp285__length1 = orig_length1;
					if (!(_tmp284_ < _tmp285__length1)) {
						break;
					}
					_tmp286_ = dest;
					_tmp286__length1 = dest_length1;
					_tmp287_ = i;
					_tmp288_ = orig;
					_tmp288__length1 = orig_length1;
					_tmp289_ = i;
					_tmp290_ = _tmp288_[_tmp289_];
					_tmp286_[_tmp287_] = _tmp290_;
					_tmp291_ = _tmp286_[_tmp287_];
				}
			}
		}
		_tmp292_ = dest;
		_tmp292__length1 = dest_length1;
		_tmp293_ = zcd_iserializable_deserialize (_tmp292_, _tmp292__length1, &_inner_error_);
		_tmp294_ = _tmp293_;
		if (_inner_error_ != NULL) {
			dest = (g_free (dest), NULL);
			orig = (g_free (orig), NULL);
			_g_object_unref0 (rs0);
			_g_object_unref0 (rsl0);
			_g_object_unref0 (ris0);
			_g_object_unref0 (r);
			_g_object_unref0 (l2);
			_g_object_unref0 (l1);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
		_g_object_unref0 (rs0);
		rs0 = G_TYPE_CHECK_INSTANCE_CAST (_tmp294_, NETSUKUKU_TYPE_ROUTES_SET, NetsukukuRoutesSet);
		dest = (g_free (dest), NULL);
		orig = (g_free (orig), NULL);
	}
	{
		gint lvl;
		lvl = 0;
		{
			gboolean _tmp295_;
			_tmp295_ = TRUE;
			while (TRUE) {
				gboolean _tmp296_;
				gint _tmp298_;
				NetsukukuRoutesSet* _tmp299_;
				NetsukukuRoutesSetPerLevel** _tmp300_;
				gint _tmp300__length1;
				_tmp296_ = _tmp295_;
				if (!_tmp296_) {
					gint _tmp297_;
					_tmp297_ = lvl;
					lvl = _tmp297_ + 1;
				}
				_tmp295_ = FALSE;
				_tmp298_ = lvl;
				_tmp299_ = rs0;
				_tmp300_ = _tmp299_->per_level;
				_tmp300__length1 = _tmp299_->per_level_length1;
				if (!(_tmp298_ < _tmp300__length1)) {
					break;
				}
				{
					NetsukukuRoutesSet* _tmp301_;
					NetsukukuRoutesSetPerLevel** _tmp302_;
					gint _tmp302__length1;
					gint _tmp303_;
					NetsukukuRoutesSetPerLevel* _tmp304_;
					GeeIterator* _tmp305_ = NULL;
					GeeIterator* _dst_it;
					_tmp301_ = rs0;
					_tmp302_ = _tmp301_->per_level;
					_tmp302__length1 = _tmp301_->per_level_length1;
					_tmp303_ = lvl;
					_tmp304_ = _tmp302_[_tmp303_];
					_tmp305_ = netsukuku_routes_set_per_level_iterator (_tmp304_);
					_dst_it = _tmp305_;
					while (TRUE) {
						GeeIterator* _tmp306_;
						gboolean _tmp307_ = FALSE;
						GeeIterator* _tmp308_;
						gpointer _tmp309_ = NULL;
						gint dst;
						NetsukukuRoutesSet* _tmp319_;
						gint _tmp320_;
						gint _tmp321_;
						NetsukukuRouteInSet* _tmp322_ = NULL;
						NetsukukuRouteInSet* ris;
						gboolean _tmp323_ = FALSE;
						gboolean _tmp325_;
						gboolean _tmp327_ = FALSE;
						gboolean _tmp329_;
						_tmp306_ = _dst_it;
						_tmp307_ = gee_iterator_next (_tmp306_);
						if (!_tmp307_) {
							break;
						}
						_tmp308_ = _dst_it;
						_tmp309_ = gee_iterator_get (_tmp308_);
						dst = (gint) ((gintptr) _tmp309_);
						if (NTK_TEST_QSPN_TESTER_output) {
							FILE* _tmp310_;
							gint _tmp311_;
							gchar* _tmp312_ = NULL;
							gchar* _tmp313_;
							gint _tmp314_;
							gchar* _tmp315_ = NULL;
							gchar* _tmp316_;
							gchar* _tmp317_ = NULL;
							gchar* _tmp318_;
							_tmp310_ = stdout;
							_tmp311_ = lvl;
							_tmp312_ = g_strdup_printf ("%i", _tmp311_);
							_tmp313_ = _tmp312_;
							_tmp314_ = dst;
							_tmp315_ = g_strdup_printf ("%i", _tmp314_);
							_tmp316_ = _tmp315_;
							_tmp317_ = g_strconcat ("one item in ", _tmp313_, ", ", _tmp316_, ".\n", NULL);
							_tmp318_ = _tmp317_;
							fprintf (_tmp310_, "%s", _tmp318_);
							_g_free0 (_tmp318_);
							_g_free0 (_tmp316_);
							_g_free0 (_tmp313_);
						}
						_tmp319_ = rs0;
						_tmp320_ = lvl;
						_tmp321_ = dst;
						_tmp322_ = netsukuku_routes_set_get_value (_tmp319_, _tmp320_, _tmp321_);
						ris = _tmp322_;
						if (NTK_TEST_QSPN_TESTER_output) {
							NetsukukuRouteInSet* _tmp324_;
							_tmp324_ = ris;
							_tmp323_ = _tmp324_ == NULL;
						} else {
							_tmp323_ = FALSE;
						}
						_tmp325_ = _tmp323_;
						if (_tmp325_) {
							FILE* _tmp326_;
							_tmp326_ = stdout;
							fprintf (_tmp326_, "no routes to it.\n");
						}
						if (NTK_TEST_QSPN_TESTER_output) {
							NetsukukuRouteInSet* _tmp328_;
							_tmp328_ = ris;
							_tmp327_ = _tmp328_ != NULL;
						} else {
							_tmp327_ = FALSE;
						}
						_tmp329_ = _tmp327_;
						if (_tmp329_) {
							FILE* _tmp330_;
							NetsukukuRouteInSet* _tmp331_;
							NetsukukuREM* _tmp332_;
							NetsukukuREM* _tmp333_;
							gchar* _tmp334_ = NULL;
							gchar* _tmp335_;
							gchar* _tmp336_ = NULL;
							gchar* _tmp337_;
							_tmp330_ = stdout;
							_tmp331_ = ris;
							_tmp332_ = netsukuku_route_in_set_get_rem (_tmp331_);
							_tmp333_ = _tmp332_;
							_tmp334_ = netsukuku_rem_to_string (_tmp333_);
							_tmp335_ = _tmp334_;
							_tmp336_ = g_strconcat ("REM = ", _tmp335_, ".\n", NULL);
							_tmp337_ = _tmp336_;
							fprintf (_tmp330_, "%s", _tmp337_);
							_g_free0 (_tmp337_);
							_g_free0 (_tmp335_);
						}
						_g_object_unref0 (ris);
					}
					_g_object_unref0 (_dst_it);
				}
			}
		}
	}
	_tmp338_ = rs0;
	_tmp339_ = netsukuku_routes_set_get_value (_tmp338_, 1, 2);
	ris12 = _tmp339_;
	_tmp340_ = ris12;
	_tmp341_ = netsukuku_route_in_set_get_rem (_tmp340_);
	_tmp342_ = _tmp341_;
	_tmp343_ = G_TYPE_FROM_INSTANCE ((GObject*) _tmp342_);
	_vala_assert (_tmp343_ == NETSUKUKU_TYPE_NULL_REM, "ris12.rem.get_type() == typeof(NullREM)");
	_tmp344_ = ris12;
	_tmp345_ = netsukuku_route_in_set_get_hops (_tmp344_);
	_tmp346_ = _tmp345_;
	_tmp347_ = gee_collection_get_size ((GeeCollection*) _tmp346_);
	_tmp348_ = _tmp347_;
	_vala_assert (_tmp348_ == 1, "ris12.hops.size == 1");
	_tmp349_ = ris12;
	_tmp350_ = netsukuku_route_in_set_get_gid (_tmp349_);
	_tmp351_ = _tmp350_;
	_tmp352_ = netsukuku_gnode_id_get_ident (_tmp351_);
	_tmp353_ = _tmp352_;
	_vala_assert (_tmp353_ == 12345, "ris12.gid.ident == 12345");
	_tmp354_ = rs0;
	_tmp355_ = netsukuku_routes_set_get_value (_tmp354_, 3, 4);
	ris34 = _tmp355_;
	_tmp356_ = ris34;
	_tmp357_ = netsukuku_route_in_set_get_rem (_tmp356_);
	_tmp358_ = _tmp357_;
	_tmp359_ = G_TYPE_FROM_INSTANCE ((GObject*) _tmp358_);
	_vala_assert (_tmp359_ == NETSUKUKU_TYPE_NULL_REM, "ris34.rem.get_type() == typeof(NullREM)");
	_tmp360_ = ris34;
	_tmp361_ = netsukuku_route_in_set_get_hops (_tmp360_);
	_tmp362_ = _tmp361_;
	_tmp363_ = gee_collection_get_size ((GeeCollection*) _tmp362_);
	_tmp364_ = _tmp363_;
	_vala_assert (_tmp364_ == 0, "ris34.hops.size == 0");
	_tmp365_ = ris34;
	_tmp366_ = netsukuku_route_in_set_get_gid (_tmp365_);
	_tmp367_ = _tmp366_;
	_tmp368_ = netsukuku_gnode_id_get_ident (_tmp367_);
	_tmp369_ = _tmp368_;
	_vala_assert (_tmp369_ == 54321, "ris34.gid.ident == 54321");
	_tmp370_ = rs0;
	_tmp371_ = netsukuku_routes_set_get_value (_tmp370_, 0, 1);
	ris01 = _tmp371_;
	_tmp372_ = ris01;
	_tmp373_ = netsukuku_route_in_set_get_rem (_tmp372_);
	_tmp374_ = _tmp373_;
	_tmp375_ = G_TYPE_FROM_INSTANCE ((GObject*) _tmp374_);
	_vala_assert (_tmp375_ == NETSUKUKU_TYPE_DEAD_REM, "ris01.rem.get_type() == typeof(DeadREM)");
	_g_object_unref0 (ris01);
	_g_object_unref0 (ris34);
	_g_object_unref0 (ris12);
	_g_object_unref0 (rs0);
	_g_object_unref0 (rsl0);
	_g_object_unref0 (ris0);
	_g_object_unref0 (r);
	_g_object_unref0 (l2);
	_g_object_unref0 (l1);
}


static void __lambda2_ (void) {
	NtkTestQspnTester* _tmp0_;
	NtkTestQspnTester* x;
	_tmp0_ = ntk_test_qspn_tester_new ();
	x = _tmp0_;
	ntk_test_qspn_tester_set_up (x);
	ntk_test_qspn_tester_test_basics (x);
	ntk_test_qspn_tester_tear_down (x);
	_g_object_unref0 (x);
}


static void ___lambda2__gcallback (void) {
	__lambda2_ ();
}


gint ntk_test_qspn_tester_main (gchar** args, int args_length1) {
	gint result = 0;
	g_test_init (&args_length1, &args, NULL);
	tasklets_tasklet_init (64);
	g_test_add_func ("/Qspn/Basics", ___lambda2__gcallback);
	g_test_run ();
	tasklets_tasklet_kill ();
	result = 0;
	return result;
}


int main (int argc, char ** argv) {
	g_type_init ();
	return ntk_test_qspn_tester_main (argv, argc);
}


NtkTestQspnTester* ntk_test_qspn_tester_construct (GType object_type) {
	NtkTestQspnTester * self = NULL;
	self = (NtkTestQspnTester*) g_object_new (object_type, NULL);
	return self;
}


NtkTestQspnTester* ntk_test_qspn_tester_new (void) {
	return ntk_test_qspn_tester_construct (NTK_TEST_TYPE_QSPN_TESTER);
}


static void ntk_test_qspn_tester_class_init (NtkTestQspnTesterClass * klass) {
	ntk_test_qspn_tester_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (NtkTestQspnTesterPrivate));
	G_OBJECT_CLASS (klass)->finalize = ntk_test_qspn_tester_finalize;
}


static void ntk_test_qspn_tester_instance_init (NtkTestQspnTester * self) {
	self->priv = NTK_TEST_QSPN_TESTER_GET_PRIVATE (self);
}


static void ntk_test_qspn_tester_finalize (GObject* obj) {
	NtkTestQspnTester * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, NTK_TEST_TYPE_QSPN_TESTER, NtkTestQspnTester);
	_g_free0 (self->priv->logger);
	G_OBJECT_CLASS (ntk_test_qspn_tester_parent_class)->finalize (obj);
}


GType ntk_test_qspn_tester_get_type (void) {
	static volatile gsize ntk_test_qspn_tester_type_id__volatile = 0;
	if (g_once_init_enter (&ntk_test_qspn_tester_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (NtkTestQspnTesterClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) ntk_test_qspn_tester_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (NtkTestQspnTester), 0, (GInstanceInitFunc) ntk_test_qspn_tester_instance_init, NULL };
		GType ntk_test_qspn_tester_type_id;
		ntk_test_qspn_tester_type_id = g_type_register_static (G_TYPE_OBJECT, "NtkTestQspnTester", &g_define_type_info, 0);
		g_once_init_leave (&ntk_test_qspn_tester_type_id__volatile, ntk_test_qspn_tester_type_id);
	}
	return ntk_test_qspn_tester_type_id__volatile;
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}



