/**  Skeleton classes generated by rpcdesign.
  */

using Gee;
using zcd;

namespace Netsukuku
{
    public class AddressManagerDispatcher : RPCDispatcher
    {
        private IAddressManagerRootDispatcher root;
        public AddressManagerDispatcher(IAddressManagerRootDispatcher root)
        {
            this.root = root;
        }

        /** This method adds the feature that a model-specific exception is made serializable.
          */
        public override ISerializable remoteexception_dispatch(Object? caller, RemoteCall data) throws Error
        {
            try
            {
                return _dispatch(caller, data);
            }
            catch (HookingError e)
            {
                RemotableException re = new RemotableException();
                re.message = e.message;
                re.domain = "HookingError";
                if (e is HookingError.INEXISTENT_GNODE) re.code = "INEXISTENT_GNODE";
                if (e is HookingError.GENERIC) re.code = "GENERIC";
                return re;
            }
            catch (QspnError e)
            {
                RemotableException re = new RemotableException();
                re.message = e.message;
                re.domain = "QspnError";
                if (e is QspnError.NOT_YOUR_GATEWAY) re.code = "NOT_YOUR_GATEWAY";
                if (e is QspnError.ALREADY_UP_TO_DATE) re.code = "ALREADY_UP_TO_DATE";
                if (e is QspnError.GENERIC) re.code = "GENERIC";
                return re;
            }
            catch (PeerRefuseServiceError e)
            {
                RemotableException re = new RemotableException();
                re.message = e.message;
                re.domain = "PeerRefuseServiceError";
                if (e is PeerRefuseServiceError.GENERIC) re.code = "GENERIC";
                return re;
            }
            catch (TunnelError e)
            {
                RemotableException re = new RemotableException();
                re.message = e.message;
                re.domain = "TunnelError";
                if (e is TunnelError.GENERIC) re.code = "GENERIC";
                return re;
            }
            catch (BorderNodesError e)
            {
                RemotableException re = new RemotableException();
                re.message = e.message;
                re.domain = "BorderNodesError";
                if (e is BorderNodesError.WRONG_GNODE) re.code = "WRONG_GNODE";
                if (e is BorderNodesError.NOT_BORDER_NODE) re.code = "NOT_BORDER_NODE";
                if (e is BorderNodesError.WILL_NOT_TUNNEL) re.code = "WILL_NOT_TUNNEL";
                if (e is BorderNodesError.TIMEOUT) re.code = "TIMEOUT";
                if (e is BorderNodesError.GENERIC) re.code = "GENERIC";
                return re;
            }
            catch (AndnaError e)
            {
                RemotableException re = new RemotableException();
                re.message = e.message;
                re.domain = "AndnaError";
                if (e is AndnaError.GENERIC) re.code = "GENERIC";
                return re;
            }
        }

        /** This method could be called *directly* for a dispatcher that does not need to transform
          * an exception into a remotable.
          */
        public override ISerializable _dispatch(Object? caller, RemoteCall data) throws Error
        {
            string[] pieces = data.method_name.split(".");
            if (pieces[0] == "etp")
            {
                if (pieces[1] == "request_etp")
                {
                    if (pieces.length != 2)
                        throw new RPCError.MALFORMED_PACKET(
                            "etp.request_etp is a function.");
                    if (data.parameters.size != 5)
                        throw new RPCError.MALFORMED_PACKET(
                            "etp.request_etp wants 5 parameters.");
                    ISerializable iser0 = data.parameters[0];
                    if (! iser0.get_type().is_a(typeof(SerializableInt)))
                        throw new RPCError.MALFORMED_PACKET(
                            "etp.request_etp parameter 1 is not a int.");
                    int prev_mod_seq_num = ((SerializableInt)iser0).i;
                    ISerializable iser1 = data.parameters[1];
                    if (! iser1.get_type().is_a(typeof(NIP)))
                        throw new RPCError.MALFORMED_PACKET(
                            "etp.request_etp parameter 2 is not a NIP.");
                    NIP nip_caller = (NIP)iser1;
                    ISerializable iser2 = data.parameters[2];
                    if (! iser2.get_type().is_a(typeof(SerializableInt)))
                        throw new RPCError.MALFORMED_PACKET(
                            "etp.request_etp parameter 3 is not a int.");
                    int nodeid_caller = ((SerializableInt)iser2).i;
                    ISerializable iser3 = data.parameters[3];
                    if (! iser3.get_type().is_a(typeof(NetworkID)))
                        throw new RPCError.MALFORMED_PACKET(
                            "etp.request_etp parameter 4 is not a NetworkID.");
                    NetworkID netid_caller = (NetworkID)iser3;
                    ISerializable iser4 = data.parameters[4];
                    if (! iser4.get_type().is_a(typeof(ListString)))
                        throw new RPCError.MALFORMED_PACKET(
                            "etp.request_etp parameter 5 is not a List<string>.");
                    ListString _macs_caller = (ListString)iser4;
                    Gee.List<string> macs_caller = _macs_caller.backed;
                    return root.etp.request_etp(prev_mod_seq_num, nip_caller, nodeid_caller, netid_caller, macs_caller);
                }
                if (pieces[1] == "request_size")
                {
                    if (pieces.length != 2)
                        throw new RPCError.MALFORMED_PACKET(
                            "etp.request_size is a function.");
                    if (data.parameters.size != 0)
                        throw new RPCError.MALFORMED_PACKET(
                            "etp.request_size wants no parameters.");
                    return new SerializableInt(root.etp.request_size());
                }
                if (pieces[1] == "new_sequence_number")
                {
                    if (pieces.length != 2)
                        throw new RPCError.MALFORMED_PACKET(
                            "etp.new_sequence_number is a function.");
                    if (data.parameters.size != 3)
                        throw new RPCError.MALFORMED_PACKET(
                            "etp.new_sequence_number wants 3 parameters.");
                    ISerializable iser0 = data.parameters[0];
                    if (! iser0.get_type().is_a(typeof(NIP)))
                        throw new RPCError.MALFORMED_PACKET(
                            "etp.new_sequence_number parameter 1 is not a NIP.");
                    NIP nip_x = (NIP)iser0;
                    ISerializable iser1 = data.parameters[1];
                    if (! iser1.get_type().is_a(typeof(SerializableInt)))
                        throw new RPCError.MALFORMED_PACKET(
                            "etp.new_sequence_number parameter 2 is not a int.");
                    int nodeid_x = ((SerializableInt)iser1).i;
                    ISerializable iser2 = data.parameters[2];
                    if (! iser2.get_type().is_a(typeof(SerializableInt)))
                        throw new RPCError.MALFORMED_PACKET(
                            "etp.new_sequence_number parameter 3 is not a int.");
                    int seq_num_x = ((SerializableInt)iser2).i;
                    root.etp.new_sequence_number(nip_x, nodeid_x, seq_num_x);
                    return new SerializableNone();
                }
                if (pieces[1] == "act_as_gateway")
                {
                    if (pieces.length != 2)
                        throw new RPCError.MALFORMED_PACKET(
                            "etp.act_as_gateway is a function.");
                    if (data.parameters.size != 4)
                        throw new RPCError.MALFORMED_PACKET(
                            "etp.act_as_gateway wants 4 parameters.");
                    ISerializable iser0 = data.parameters[0];
                    if (! iser0.get_type().is_a(typeof(NIP)))
                        throw new RPCError.MALFORMED_PACKET(
                            "etp.act_as_gateway parameter 1 is not a NIP.");
                    NIP nip_caller = (NIP)iser0;
                    ISerializable iser1 = data.parameters[1];
                    if (! iser1.get_type().is_a(typeof(SerializableInt)))
                        throw new RPCError.MALFORMED_PACKET(
                            "etp.act_as_gateway parameter 2 is not a int.");
                    int nodeid_caller = ((SerializableInt)iser1).i;
                    ISerializable iser2 = data.parameters[2];
                    if (! iser2.get_type().is_a(typeof(NetworkID)))
                        throw new RPCError.MALFORMED_PACKET(
                            "etp.act_as_gateway parameter 3 is not a NetworkID.");
                    NetworkID netid_caller = (NetworkID)iser2;
                    ISerializable iser3 = data.parameters[3];
                    if (! iser3.get_type().is_a(typeof(ListString)))
                        throw new RPCError.MALFORMED_PACKET(
                            "etp.act_as_gateway parameter 4 is not a List<string>.");
                    ListString _macs = (ListString)iser3;
                    Gee.List<string> macs = _macs.backed;
                    root.etp.act_as_gateway(nip_caller, nodeid_caller, netid_caller, macs);
                    return new SerializableNone();
                }
                if (pieces[1] == "report_qspn_stats")
                {
                    if (pieces.length != 2)
                        throw new RPCError.MALFORMED_PACKET(
                            "etp.report_qspn_stats is a function.");
                    if (data.parameters.size != 0)
                        throw new RPCError.MALFORMED_PACKET(
                            "etp.report_qspn_stats wants no parameters.");
                    return root.etp.report_qspn_stats();
                }
            }
            if (pieces[0] == "tunnel_manager")
            {
                if (pieces[1] == "choose_tunnel_protocol")
                {
                    if (pieces.length != 2)
                        throw new RPCError.MALFORMED_PACKET(
                            "tunnel_manager.choose_tunnel_protocol is a function.");
                    if (data.parameters.size != 1)
                        throw new RPCError.MALFORMED_PACKET(
                            "tunnel_manager.choose_tunnel_protocol wants 1 parameter.");
                    ISerializable iser0 = data.parameters[0];
                    if (! iser0.get_type().is_a(typeof(ListString)))
                        throw new RPCError.MALFORMED_PACKET(
                            "tunnel_manager.choose_tunnel_protocol parameter 1 is not a List<string>.");
                    ListString _protocols = (ListString)iser0;
                    Gee.List<string> protocols = _protocols.backed;
                    string? ret = root.tunnel_manager.choose_tunnel_protocol(protocols);
                    if (ret == null) return new SerializableNone();
                    return new SerializableString(ret);
                }
                if (pieces[1] == "handshake")
                {
                    if (pieces.length != 2)
                        throw new RPCError.MALFORMED_PACKET(
                            "tunnel_manager.handshake is a function.");
                    if (data.parameters.size != 2)
                        throw new RPCError.MALFORMED_PACKET(
                            "tunnel_manager.handshake wants 2 parameters.");
                    ISerializable iser0 = data.parameters[0];
                    if (! iser0.get_type().is_a(typeof(ISerializable)))
                        throw new RPCError.MALFORMED_PACKET(
                            "tunnel_manager.handshake parameter 1 is not a ISerializable.");
                    ISerializable mesg = iser0;
                    ISerializable iser1 = data.parameters[1];
                    if (! iser1.get_type().is_a(typeof(SerializableInt)))
                        throw new RPCError.MALFORMED_PACKET(
                            "tunnel_manager.handshake parameter 2 is not a int.");
                    int handler_id = ((SerializableInt)iser1).i;
                    root.tunnel_manager.handshake(mesg, handler_id);
                    return new SerializableNone();
                }
                if (pieces[1] == "request_tunnel")
                {
                    if (pieces.length != 2)
                        throw new RPCError.MALFORMED_PACKET(
                            "tunnel_manager.request_tunnel is a function.");
                    if (data.parameters.size != 2)
                        throw new RPCError.MALFORMED_PACKET(
                            "tunnel_manager.request_tunnel wants 2 parameters.");
                    ISerializable iser0 = data.parameters[0];
                    if (! iser0.get_type().is_a(typeof(SerializableString)))
                        throw new RPCError.MALFORMED_PACKET(
                            "tunnel_manager.request_tunnel parameter 1 is not a string.");
                    string protocol = ((SerializableString)iser0).s;
                    ISerializable iser1 = data.parameters[1];
                    if (! iser1.get_type().is_a(typeof(SerializableInt)))
                        throw new RPCError.MALFORMED_PACKET(
                            "tunnel_manager.request_tunnel parameter 2 is not a int.");
                    int peer_handler_id = ((SerializableInt)iser1).i;
                    return new SerializableInt(root.tunnel_manager.request_tunnel(protocol, peer_handler_id, (CallerInfo)caller));
                }
                if (pieces[1] == "close_tunnel")
                {
                    if (pieces.length != 2)
                        throw new RPCError.MALFORMED_PACKET(
                            "tunnel_manager.close_tunnel is a function.");
                    if (data.parameters.size != 1)
                        throw new RPCError.MALFORMED_PACKET(
                            "tunnel_manager.close_tunnel wants 1 parameter.");
                    ISerializable iser0 = data.parameters[0];
                    if (! iser0.get_type().is_a(typeof(SerializableString)))
                        throw new RPCError.MALFORMED_PACKET(
                            "tunnel_manager.close_tunnel parameter 1 is not a string.");
                    string nic_name = ((SerializableString)iser0).s;
                    root.tunnel_manager.close_tunnel(nic_name, (CallerInfo)caller);
                    return new SerializableNone();
                }
            }
            if (pieces[0] == "hook")
            {
                if (pieces[1] == "list_non_saturated_levels")
                {
                    if (pieces.length != 2)
                        throw new RPCError.MALFORMED_PACKET(
                            "hook.list_non_saturated_levels is a function.");
                    if (data.parameters.size != 0)
                        throw new RPCError.MALFORMED_PACKET(
                            "hook.list_non_saturated_levels wants no parameters.");
                    Gee.List<PairLvlNumberOfFreeNodes> _ret = root.hook.list_non_saturated_levels();
                    ListISerializable ret = new ListISerializable.with_backer(_ret);
                    return ret;
                }
            }
            if (pieces[0] == "aggregated_neighbour_manager")
            {
                if (pieces[1] == "reply")
                {
                    if (pieces.length != 2)
                        throw new RPCError.MALFORMED_PACKET(
                            "aggregated_neighbour_manager.reply is a function.");
                    if (data.parameters.size != 4)
                        throw new RPCError.MALFORMED_PACKET(
                            "aggregated_neighbour_manager.reply wants 4 parameters.");
                    ISerializable iser0 = data.parameters[0];
                    if (! iser0.get_type().is_a(typeof(SerializableInt)))
                        throw new RPCError.MALFORMED_PACKET(
                            "aggregated_neighbour_manager.reply parameter 1 is not a int.");
                    int radar_id = ((SerializableInt)iser0).i;
                    ISerializable iser1 = data.parameters[1];
                    if (! iser1.get_type().is_a(typeof(NIP)))
                        throw new RPCError.MALFORMED_PACKET(
                            "aggregated_neighbour_manager.reply parameter 2 is not a NIP.");
                    NIP nip = (NIP)iser1;
                    ISerializable iser2 = data.parameters[2];
                    if (! iser2.get_type().is_a(typeof(SerializableInt)))
                        throw new RPCError.MALFORMED_PACKET(
                            "aggregated_neighbour_manager.reply parameter 3 is not a int.");
                    int nodeid = ((SerializableInt)iser2).i;
                    ISerializable iser3 = data.parameters[3];
                    if (! iser3.get_type().is_a(typeof(NetworkID)))
                        throw new RPCError.MALFORMED_PACKET(
                            "aggregated_neighbour_manager.reply parameter 4 is not a NetworkID.");
                    NetworkID netid = (NetworkID)iser3;
                    root.aggregated_neighbour_manager.reply(radar_id, nip, nodeid, netid, (CallerInfo)caller);
                    return new SerializableNone();
                }
                if (pieces[1] == "time_register")
                {
                    if (pieces.length != 2)
                        throw new RPCError.MALFORMED_PACKET(
                            "aggregated_neighbour_manager.time_register is a function.");
                    if (data.parameters.size != 9)
                        throw new RPCError.MALFORMED_PACKET(
                            "aggregated_neighbour_manager.time_register wants 9 parameters.");
                    ISerializable iser0 = data.parameters[0];
                    if (! iser0.get_type().is_a(typeof(SerializableInt)))
                        throw new RPCError.MALFORMED_PACKET(
                            "aggregated_neighbour_manager.time_register parameter 1 is not a int.");
                    int radar_id = ((SerializableInt)iser0).i;
                    ISerializable iser1 = data.parameters[1];
                    if (! iser1.get_type().is_a(typeof(SerializableInt)))
                        throw new RPCError.MALFORMED_PACKET(
                            "aggregated_neighbour_manager.time_register parameter 2 is not a int.");
                    int levels = ((SerializableInt)iser1).i;
                    ISerializable iser2 = data.parameters[2];
                    if (! iser2.get_type().is_a(typeof(SerializableInt)))
                        throw new RPCError.MALFORMED_PACKET(
                            "aggregated_neighbour_manager.time_register parameter 3 is not a int.");
                    int gsize = ((SerializableInt)iser2).i;
                    ISerializable iser3 = data.parameters[3];
                    if (! iser3.get_type().is_a(typeof(NIP)))
                        throw new RPCError.MALFORMED_PACKET(
                            "aggregated_neighbour_manager.time_register parameter 4 is not a NIP.");
                    NIP nip = (NIP)iser3;
                    ISerializable iser4 = data.parameters[4];
                    if (! iser4.get_type().is_a(typeof(SerializableInt)))
                        throw new RPCError.MALFORMED_PACKET(
                            "aggregated_neighbour_manager.time_register parameter 5 is not a int.");
                    int nodeid = ((SerializableInt)iser4).i;
                    ISerializable iser5 = data.parameters[5];
                    if (! iser5.get_type().is_a(typeof(NetworkID)))
                        throw new RPCError.MALFORMED_PACKET(
                            "aggregated_neighbour_manager.time_register parameter 6 is not a NetworkID.");
                    NetworkID netid = (NetworkID)iser5;
                    ISerializable iser6 = data.parameters[6];
                    if (! iser6.get_type().is_a(typeof(SerializableString)))
                        throw new RPCError.MALFORMED_PACKET(
                            "aggregated_neighbour_manager.time_register parameter 7 is not a string.");
                    string mac = ((SerializableString)iser6).s;
                    ISerializable iser7 = data.parameters[7];
                    if (! iser7.get_type().is_a(typeof(SerializableBool)))
                        throw new RPCError.MALFORMED_PACKET(
                            "aggregated_neighbour_manager.time_register parameter 8 is not a bool.");
                    bool is_primary = ((SerializableBool)iser7).b;
                    ISerializable iser8 = data.parameters[8];
                    if (! iser8.get_type().is_a(typeof(SerializableBool)))
                        throw new RPCError.MALFORMED_PACKET(
                            "aggregated_neighbour_manager.time_register parameter 9 is not a bool.");
                    bool is_auxiliary = ((SerializableBool)iser8).b;
                    root.aggregated_neighbour_manager.time_register(radar_id, levels, gsize, nip, nodeid, netid, mac, is_primary, is_auxiliary);
                    return new SerializableNone();
                }
                if (pieces[1] == "declare_dead")
                {
                    if (pieces.length != 2)
                        throw new RPCError.MALFORMED_PACKET(
                            "aggregated_neighbour_manager.declare_dead is a function.");
                    if (data.parameters.size != 2)
                        throw new RPCError.MALFORMED_PACKET(
                            "aggregated_neighbour_manager.declare_dead wants 2 parameters.");
                    ISerializable iser0 = data.parameters[0];
                    if (! iser0.get_type().is_a(typeof(NIP)))
                        throw new RPCError.MALFORMED_PACKET(
                            "aggregated_neighbour_manager.declare_dead parameter 1 is not a NIP.");
                    NIP nip = (NIP)iser0;
                    ISerializable iser1 = data.parameters[1];
                    if (! iser1.get_type().is_a(typeof(SerializableInt)))
                        throw new RPCError.MALFORMED_PACKET(
                            "aggregated_neighbour_manager.declare_dead parameter 2 is not a int.");
                    int nodeid = ((SerializableInt)iser1).i;
                    root.aggregated_neighbour_manager.declare_dead(nip, nodeid);
                    return new SerializableNone();
                }
                if (pieces[1] == "report_neighbours")
                {
                    if (pieces.length != 2)
                        throw new RPCError.MALFORMED_PACKET(
                            "aggregated_neighbour_manager.report_neighbours is a function.");
                    if (data.parameters.size != 0)
                        throw new RPCError.MALFORMED_PACKET(
                            "aggregated_neighbour_manager.report_neighbours wants no parameters.");
                    Gee.List<InfoNeighbour> _ret = root.aggregated_neighbour_manager.report_neighbours();
                    ListISerializable ret = new ListISerializable.with_backer(_ret);
                    return ret;
                }
            }
            if (pieces[0] == "maproute")
            {
                if (pieces[1] == "free_nodes_nb")
                {
                    if (pieces.length != 2)
                        throw new RPCError.MALFORMED_PACKET(
                            "maproute.free_nodes_nb is a function.");
                    if (data.parameters.size != 1)
                        throw new RPCError.MALFORMED_PACKET(
                            "maproute.free_nodes_nb wants 1 parameter.");
                    ISerializable iser0 = data.parameters[0];
                    if (! iser0.get_type().is_a(typeof(SerializableInt)))
                        throw new RPCError.MALFORMED_PACKET(
                            "maproute.free_nodes_nb parameter 1 is not a int.");
                    int lvl = ((SerializableInt)iser0).i;
                    return new SerializableInt(root.maproute.free_nodes_nb(lvl));
                }
                if (pieces[1] == "worst_internal_bestrem")
                {
                    if (pieces.length != 2)
                        throw new RPCError.MALFORMED_PACKET(
                            "maproute.worst_internal_bestrem is a function.");
                    if (data.parameters.size != 1)
                        throw new RPCError.MALFORMED_PACKET(
                            "maproute.worst_internal_bestrem wants 1 parameter.");
                    ISerializable iser0 = data.parameters[0];
                    if (! iser0.get_type().is_a(typeof(SerializableInt)))
                        throw new RPCError.MALFORMED_PACKET(
                            "maproute.worst_internal_bestrem parameter 1 is not a int.");
                    int level_of_gnode = ((SerializableInt)iser0).i;
                    return root.maproute.worst_internal_bestrem(level_of_gnode);
                }
                if (pieces[1] == "request_gid")
                {
                    if (pieces.length != 2)
                        throw new RPCError.MALFORMED_PACKET(
                            "maproute.request_gid is a function.");
                    if (data.parameters.size != 3)
                        throw new RPCError.MALFORMED_PACKET(
                            "maproute.request_gid wants 3 parameters.");
                    ISerializable iser0 = data.parameters[0];
                    if (! iser0.get_type().is_a(typeof(SerializableInt)))
                        throw new RPCError.MALFORMED_PACKET(
                            "maproute.request_gid parameter 1 is not a int.");
                    int request_id = ((SerializableInt)iser0).i;
                    ISerializable iser1 = data.parameters[1];
                    if (! iser1.get_type().is_a(typeof(NetworkID)))
                        throw new RPCError.MALFORMED_PACKET(
                            "maproute.request_gid parameter 2 is not a NetworkID.");
                    NetworkID gnetid = (NetworkID)iser1;
                    ISerializable iser2 = data.parameters[2];
                    if (! iser2.get_type().is_a(typeof(PartialNIP)))
                        throw new RPCError.MALFORMED_PACKET(
                            "maproute.request_gid parameter 3 is not a PartialNIP.");
                    PartialNIP gprefix = (PartialNIP)iser2;
                    root.maproute.request_gid(request_id, gnetid, gprefix);
                    return new SerializableNone();
                }
                if (pieces[1] == "answer_gid")
                {
                    if (pieces.length != 2)
                        throw new RPCError.MALFORMED_PACKET(
                            "maproute.answer_gid is a function.");
                    if (data.parameters.size != 3)
                        throw new RPCError.MALFORMED_PACKET(
                            "maproute.answer_gid wants 3 parameters.");
                    ISerializable iser0 = data.parameters[0];
                    if (! iser0.get_type().is_a(typeof(NIP)))
                        throw new RPCError.MALFORMED_PACKET(
                            "maproute.answer_gid parameter 1 is not a NIP.");
                    NIP answering_nip = (NIP)iser0;
                    ISerializable iser1 = data.parameters[1];
                    if (! iser1.get_type().is_a(typeof(SerializableInt)))
                        throw new RPCError.MALFORMED_PACKET(
                            "maproute.answer_gid parameter 2 is not a int.");
                    int request_id = ((SerializableInt)iser1).i;
                    ISerializable iser2 = data.parameters[2];
                    if (! iser2.get_type().is_a(typeof(GNodeID)))
                        throw new RPCError.MALFORMED_PACKET(
                            "maproute.answer_gid parameter 3 is not a GNodeID.");
                    GNodeID actual_gid = (GNodeID)iser2;
                    root.maproute.answer_gid(answering_nip, request_id, actual_gid);
                    return new SerializableNone();
                }
                if (pieces[1] == "report_routes")
                {
                    if (pieces.length != 2)
                        throw new RPCError.MALFORMED_PACKET(
                            "maproute.report_routes is a function.");
                    if (data.parameters.size != 0)
                        throw new RPCError.MALFORMED_PACKET(
                            "maproute.report_routes wants no parameters.");
                    Gee.List<InfoRoute> _ret = root.maproute.report_routes();
                    ListISerializable ret = new ListISerializable.with_backer(_ret);
                    return ret;
                }
                if (pieces[1] == "report_gid_list")
                {
                    if (pieces.length != 2)
                        throw new RPCError.MALFORMED_PACKET(
                            "maproute.report_gid_list is a function.");
                    if (data.parameters.size != 0)
                        throw new RPCError.MALFORMED_PACKET(
                            "maproute.report_gid_list wants no parameters.");
                    Gee.List<GNodeID> _ret = root.maproute.report_gid_list();
                    ListISerializable ret = new ListISerializable.with_backer(_ret);
                    return ret;
                }
                if (pieces[1] == "report_yourself")
                {
                    if (pieces.length != 2)
                        throw new RPCError.MALFORMED_PACKET(
                            "maproute.report_yourself is a function.");
                    if (data.parameters.size != 0)
                        throw new RPCError.MALFORMED_PACKET(
                            "maproute.report_yourself wants no parameters.");
                    return root.maproute.report_yourself();
                }
            }
            if (pieces[0] == "border_nodes_manager")
            {
                if (pieces[1] == "get_distances")
                {
                    if (pieces.length != 2)
                        throw new RPCError.MALFORMED_PACKET(
                            "border_nodes_manager.get_distances is a function.");
                    if (data.parameters.size != 2)
                        throw new RPCError.MALFORMED_PACKET(
                            "border_nodes_manager.get_distances wants 2 parameters.");
                    ISerializable iser0 = data.parameters[0];
                    if (! iser0.get_type().is_a(typeof(PartialNIP)))
                        throw new RPCError.MALFORMED_PACKET(
                            "border_nodes_manager.get_distances parameter 1 is not a PartialNIP.");
                    PartialNIP gnode = (PartialNIP)iser0;
                    ISerializable iser1 = data.parameters[1];
                    if (! iser1.get_type().is_a(typeof(ListISerializable)))
                        throw new RPCError.MALFORMED_PACKET(
                            "border_nodes_manager.get_distances parameter 2 is not a List<NIP>.");
                    ListISerializable _list_of_nips = (ListISerializable)iser1;
                    Gee.List<NIP> list_of_nips = (Gee.List<NIP>)_list_of_nips.backed;
                    Gee.List<PairNipDistance> _ret = root.border_nodes_manager.get_distances(gnode, list_of_nips, (CallerInfo)caller);
                    ListISerializable ret = new ListISerializable.with_backer(_ret);
                    return ret;
                }
                if (pieces[1] == "get_new_address")
                {
                    if (pieces.length != 2)
                        throw new RPCError.MALFORMED_PACKET(
                            "border_nodes_manager.get_new_address is a function.");
                    if (data.parameters.size != 2)
                        throw new RPCError.MALFORMED_PACKET(
                            "border_nodes_manager.get_new_address wants 2 parameters.");
                    ISerializable iser0 = data.parameters[0];
                    if (! iser0.get_type().is_a(typeof(PartialNIP)))
                        throw new RPCError.MALFORMED_PACKET(
                            "border_nodes_manager.get_new_address parameter 1 is not a PartialNIP.");
                    PartialNIP gnode = (PartialNIP)iser0;
                    ISerializable iser1 = data.parameters[1];
                        if (! iser1.get_type().is_a(typeof(NIP)) && ! iser1.get_type().is_a(typeof(SerializableNone)))
                            throw new RPCError.MALFORMED_PACKET(
                                "border_nodes_manager.get_new_address parameter 2 is not a NIP?.");
                        NIP? peer_nip = null;
                        if (iser1.get_type().is_a(typeof(NIP))) peer_nip = (NIP) iser1;
                    return root.border_nodes_manager.get_new_address(gnode, peer_nip, (CallerInfo)caller);
                }
                if (pieces[1] == "assign_peer_nip")
                {
                    if (pieces.length != 2)
                        throw new RPCError.MALFORMED_PACKET(
                            "border_nodes_manager.assign_peer_nip is a function.");
                    if (data.parameters.size != 2)
                        throw new RPCError.MALFORMED_PACKET(
                            "border_nodes_manager.assign_peer_nip wants 2 parameters.");
                    ISerializable iser0 = data.parameters[0];
                    if (! iser0.get_type().is_a(typeof(NIP)))
                        throw new RPCError.MALFORMED_PACKET(
                            "border_nodes_manager.assign_peer_nip parameter 1 is not a NIP.");
                    NIP nip_x_secondary = (NIP)iser0;
                    ISerializable iser1 = data.parameters[1];
                    if (! iser1.get_type().is_a(typeof(NIP)))
                        throw new RPCError.MALFORMED_PACKET(
                            "border_nodes_manager.assign_peer_nip parameter 2 is not a NIP.");
                    NIP nip_y_secondary = (NIP)iser1;
                    root.border_nodes_manager.assign_peer_nip(nip_x_secondary, nip_y_secondary);
                    return new SerializableNone();
                }
                if (pieces[1] == "report_bordernodes_status")
                {
                    if (pieces.length != 2)
                        throw new RPCError.MALFORMED_PACKET(
                            "border_nodes_manager.report_bordernodes_status is a function.");
                    if (data.parameters.size != 0)
                        throw new RPCError.MALFORMED_PACKET(
                            "border_nodes_manager.report_bordernodes_status wants no parameters.");
                    Gee.List<InfoBorderNode> _ret = root.border_nodes_manager.report_bordernodes_status();
                    ListISerializable ret = new ListISerializable.with_backer(_ret);
                    return ret;
                }
            }
            if (pieces[0] == "peer_to_peer_all")
            {
                if (pieces[1] == "get_optional_participants")
                {
                    if (pieces.length != 2)
                        throw new RPCError.MALFORMED_PACKET(
                            "peer_to_peer_all.get_optional_participants is a function.");
                    if (data.parameters.size != 0)
                        throw new RPCError.MALFORMED_PACKET(
                            "peer_to_peer_all.get_optional_participants wants no parameters.");
                    return root.peer_to_peer_all.get_optional_participants();
                }
            }
            if (pieces[0] == "coordnode")
            {
                if (pieces[1] == "duplicate_all_knowledge")
                {
                    if (pieces.length != 2)
                        throw new RPCError.MALFORMED_PACKET(
                            "coordnode.duplicate_all_knowledge is a function.");
                    if (data.parameters.size != 2)
                        throw new RPCError.MALFORMED_PACKET(
                            "coordnode.duplicate_all_knowledge wants 2 parameters.");
                    ISerializable iser0 = data.parameters[0];
                    if (! iser0.get_type().is_a(typeof(PartialNIP)))
                        throw new RPCError.MALFORMED_PACKET(
                            "coordnode.duplicate_all_knowledge parameter 1 is not a PartialNIP.");
                    PartialNIP gnode = (PartialNIP)iser0;
                    ISerializable iser1 = data.parameters[1];
                    if (! iser1.get_type().is_a(typeof(CoordinatorKnowledge)))
                        throw new RPCError.MALFORMED_PACKET(
                            "coordnode.duplicate_all_knowledge parameter 2 is not a CoordinatorKnowledge.");
                    CoordinatorKnowledge coordinator_knowledge = (CoordinatorKnowledge)iser1;
                    root.coordnode.duplicate_all_knowledge(gnode, coordinator_knowledge);
                    return new SerializableNone();
                }
                if (pieces[1] == "reserve")
                {
                    if (pieces.length != 2)
                        throw new RPCError.MALFORMED_PACKET(
                            "coordnode.reserve is a function.");
                    if (data.parameters.size != 1)
                        throw new RPCError.MALFORMED_PACKET(
                            "coordnode.reserve wants 1 parameter.");
                    ISerializable iser0 = data.parameters[0];
                    if (! iser0.get_type().is_a(typeof(PartialNIP)))
                        throw new RPCError.MALFORMED_PACKET(
                            "coordnode.reserve parameter 1 is not a PartialNIP.");
                    PartialNIP gnode = (PartialNIP)iser0;
                    HookReservation? ret = root.coordnode.reserve(gnode);
                    if (ret == null) return new SerializableNone();
                    return ret;
                }
                if (pieces[1] == "free")
                {
                    if (pieces.length != 2)
                        throw new RPCError.MALFORMED_PACKET(
                            "coordnode.free is a function.");
                    if (data.parameters.size != 2)
                        throw new RPCError.MALFORMED_PACKET(
                            "coordnode.free wants 2 parameters.");
                    ISerializable iser0 = data.parameters[0];
                    if (! iser0.get_type().is_a(typeof(PartialNIP)))
                        throw new RPCError.MALFORMED_PACKET(
                            "coordnode.free parameter 1 is not a PartialNIP.");
                    PartialNIP gnode = (PartialNIP)iser0;
                    ISerializable iser1 = data.parameters[1];
                    if (! iser1.get_type().is_a(typeof(SerializableInt)))
                        throw new RPCError.MALFORMED_PACKET(
                            "coordnode.free parameter 2 is not a int.");
                    int pos = ((SerializableInt)iser1).i;
                    root.coordnode.free(gnode, pos);
                    return new SerializableNone();
                }
                if (pieces[1] == "duplicate_free")
                {
                    if (pieces.length != 2)
                        throw new RPCError.MALFORMED_PACKET(
                            "coordnode.duplicate_free is a function.");
                    if (data.parameters.size != 2)
                        throw new RPCError.MALFORMED_PACKET(
                            "coordnode.duplicate_free wants 2 parameters.");
                    ISerializable iser0 = data.parameters[0];
                    if (! iser0.get_type().is_a(typeof(PartialNIP)))
                        throw new RPCError.MALFORMED_PACKET(
                            "coordnode.duplicate_free parameter 1 is not a PartialNIP.");
                    PartialNIP gnode = (PartialNIP)iser0;
                    ISerializable iser1 = data.parameters[1];
                    if (! iser1.get_type().is_a(typeof(SerializableInt)))
                        throw new RPCError.MALFORMED_PACKET(
                            "coordnode.duplicate_free parameter 2 is not a int.");
                    int pos = ((SerializableInt)iser1).i;
                    root.coordnode.duplicate_free(gnode, pos);
                    return new SerializableNone();
                }
                if (pieces[1] == "register_bnode")
                {
                    if (pieces.length != 2)
                        throw new RPCError.MALFORMED_PACKET(
                            "coordnode.register_bnode is a function.");
                    if (data.parameters.size != 5)
                        throw new RPCError.MALFORMED_PACKET(
                            "coordnode.register_bnode wants 5 parameters.");
                    ISerializable iser0 = data.parameters[0];
                    if (! iser0.get_type().is_a(typeof(PartialNIP)))
                        throw new RPCError.MALFORMED_PACKET(
                            "coordnode.register_bnode parameter 1 is not a PartialNIP.");
                    PartialNIP gnode = (PartialNIP)iser0;
                    ISerializable iser1 = data.parameters[1];
                    if (! iser1.get_type().is_a(typeof(NIP)))
                        throw new RPCError.MALFORMED_PACKET(
                            "coordnode.register_bnode parameter 2 is not a NIP.");
                    NIP nip = (NIP)iser1;
                    ISerializable iser2 = data.parameters[2];
                    if (! iser2.get_type().is_a(typeof(SerializableBool)))
                        throw new RPCError.MALFORMED_PACKET(
                            "coordnode.register_bnode parameter 3 is not a bool.");
                    bool is_border = ((SerializableBool)iser2).b;
                    ISerializable iser3 = data.parameters[3];
                    if (! iser3.get_type().is_a(typeof(SerializableBool)))
                        throw new RPCError.MALFORMED_PACKET(
                            "coordnode.register_bnode parameter 4 is not a bool.");
                    bool has_tunnel = ((SerializableBool)iser3).b;
                    ISerializable iser4 = data.parameters[4];
                    if (! iser4.get_type().is_a(typeof(SerializableBool)))
                        throw new RPCError.MALFORMED_PACKET(
                            "coordnode.register_bnode parameter 5 is not a bool.");
                    bool is_willing = ((SerializableBool)iser4).b;
                    return new SerializableBool(root.coordnode.register_bnode(gnode, nip, is_border, has_tunnel, is_willing));
                }
                if (pieces[1] == "report_status")
                {
                    if (pieces.length != 2)
                        throw new RPCError.MALFORMED_PACKET(
                            "coordnode.report_status is a function.");
                    if (data.parameters.size != 0)
                        throw new RPCError.MALFORMED_PACKET(
                            "coordnode.report_status wants no parameters.");
                    Gee.List<InfoCoord> _ret = root.coordnode.report_status();
                    ListISerializable ret = new ListISerializable.with_backer(_ret);
                    return ret;
                }
            }
            if (pieces[0] == "andna")
            {
                if (pieces[1] == "confirm_pubk")
                {
                    if (pieces.length != 2)
                        throw new RPCError.MALFORMED_PACKET(
                            "andna.confirm_pubk is a function.");
                    if (data.parameters.size != 3)
                        throw new RPCError.MALFORMED_PACKET(
                            "andna.confirm_pubk wants 3 parameters.");
                    ISerializable iser0 = data.parameters[0];
                    if (! iser0.get_type().is_a(typeof(NIP)))
                        throw new RPCError.MALFORMED_PACKET(
                            "andna.confirm_pubk parameter 1 is not a NIP.");
                    NIP yournip = (NIP)iser0;
                    ISerializable iser1 = data.parameters[1];
                    if (! iser1.get_type().is_a(typeof(PublicKey)))
                        throw new RPCError.MALFORMED_PACKET(
                            "andna.confirm_pubk parameter 2 is not a PublicKey.");
                    PublicKey yourpubkey = (PublicKey)iser1;
                    ISerializable iser2 = data.parameters[2];
                    if (! iser2.get_type().is_a(typeof(SerializableInt)))
                        throw new RPCError.MALFORMED_PACKET(
                            "andna.confirm_pubk parameter 3 is not a int.");
                    int to_be_signed = ((SerializableInt)iser2).i;
                    return root.andna.confirm_pubk(yournip, yourpubkey, to_be_signed);
                }
                if (pieces[1] == "get_your_hostnames")
                {
                    if (pieces.length != 2)
                        throw new RPCError.MALFORMED_PACKET(
                            "andna.get_your_hostnames is a function.");
                    if (data.parameters.size != 1)
                        throw new RPCError.MALFORMED_PACKET(
                            "andna.get_your_hostnames wants 1 parameter.");
                    ISerializable iser0 = data.parameters[0];
                    if (! iser0.get_type().is_a(typeof(NIP)))
                        throw new RPCError.MALFORMED_PACKET(
                            "andna.get_your_hostnames parameter 1 is not a NIP.");
                    NIP yournip = (NIP)iser0;
                    Gee.List<string> _ret = root.andna.get_your_hostnames(yournip);
                    ListString ret = new ListString.with_backer(_ret);
                    return ret;
                }
                if (pieces[1] == "report_status")
                {
                    if (pieces.length != 2)
                        throw new RPCError.MALFORMED_PACKET(
                            "andna.report_status is a function.");
                    if (data.parameters.size != 0)
                        throw new RPCError.MALFORMED_PACKET(
                            "andna.report_status wants no parameters.");
                    return root.andna.report_status();
                }
                if (pieces[1] == "get_mynames")
                {
                    if (pieces.length != 2)
                        throw new RPCError.MALFORMED_PACKET(
                            "andna.get_mynames is a function.");
                    if (data.parameters.size != 0)
                        throw new RPCError.MALFORMED_PACKET(
                            "andna.get_mynames wants no parameters.");
                    return root.andna.get_mynames();
                }
                if (pieces[1] == "set_mynames")
                {
                    if (pieces.length != 2)
                        throw new RPCError.MALFORMED_PACKET(
                            "andna.set_mynames is a function.");
                    if (data.parameters.size != 1)
                        throw new RPCError.MALFORMED_PACKET(
                            "andna.set_mynames wants 1 parameter.");
                    ISerializable iser0 = data.parameters[0];
                    if (! iser0.get_type().is_a(typeof(AndnaPrivateConfigurationList)))
                        throw new RPCError.MALFORMED_PACKET(
                            "andna.set_mynames parameter 1 is not a AndnaPrivateConfigurationList.");
                    AndnaPrivateConfigurationList mynames = (AndnaPrivateConfigurationList)iser0;
                    root.andna.set_mynames(mynames);
                    return new SerializableNone();
                }
                if (pieces[1] == "retrieve_registrar_pubk")
                {
                    if (pieces.length != 2)
                        throw new RPCError.MALFORMED_PACKET(
                            "andna.retrieve_registrar_pubk is a function.");
                    if (data.parameters.size != 1)
                        throw new RPCError.MALFORMED_PACKET(
                            "andna.retrieve_registrar_pubk wants 1 parameter.");
                    ISerializable iser0 = data.parameters[0];
                    if (! iser0.get_type().is_a(typeof(SerializableString)))
                        throw new RPCError.MALFORMED_PACKET(
                            "andna.retrieve_registrar_pubk parameter 1 is not a string.");
                    string hashed_domain = ((SerializableString)iser0).s;
                    PublicKey? ret = root.andna.retrieve_registrar_pubk(hashed_domain);
                    if (ret == null) return new SerializableNone();
                    return ret;
                }
            }
            if (pieces[0].length > 25 && pieces[0].substring(0, 25) == "get_peer_to_peer_service(")
            {
                string remaining = pieces[0].substring(25);
                string curarg = "";
                while (remaining.substring(0, 1) in "1234567890")
                {
                    curarg += remaining.substring(0, 1);
                    remaining = remaining.substring(1);
                }
                remaining = remaining.substring(1);
                int pid = int.parse(curarg);
                if (pieces[1] == "msg_deliver")
                {
                    if (pieces.length != 2)
                        throw new RPCError.MALFORMED_PACKET(
                            "get_peer_to_peer_service(pid).msg_deliver is a function.");
                    if (data.parameters.size != 4)
                        throw new RPCError.MALFORMED_PACKET(
                            "get_peer_to_peer_service(pid).msg_deliver wants 4 parameters.");
                    ISerializable iser0 = data.parameters[0];
                    if (! iser0.get_type().is_a(typeof(PeerToPeerTracerPacketList)))
                        throw new RPCError.MALFORMED_PACKET(
                            "get_peer_to_peer_service(pid).msg_deliver parameter 1 is not a PeerToPeerTracerPacketList.");
                    PeerToPeerTracerPacketList peer_to_peer_tpl = (PeerToPeerTracerPacketList)iser0;
                    ISerializable iser1 = data.parameters[1];
                    if (! iser1.get_type().is_a(typeof(NIP)))
                        throw new RPCError.MALFORMED_PACKET(
                            "get_peer_to_peer_service(pid).msg_deliver parameter 2 is not a NIP.");
                    NIP sender_nip = (NIP)iser1;
                    ISerializable iser2 = data.parameters[2];
                    if (! iser2.get_type().is_a(typeof(NIP)))
                        throw new RPCError.MALFORMED_PACKET(
                            "get_peer_to_peer_service(pid).msg_deliver parameter 3 is not a NIP.");
                    NIP hip = (NIP)iser2;
                    ISerializable iser3 = data.parameters[3];
                    if (! iser3.get_type().is_a(typeof(RemoteCall)))
                        throw new RPCError.MALFORMED_PACKET(
                            "get_peer_to_peer_service(pid).msg_deliver parameter 4 is not a RemoteCall.");
                    RemoteCall rcdata = (RemoteCall)iser3;
                    return root.get_peer_to_peer_service(pid).msg_deliver(peer_to_peer_tpl, sender_nip, hip, rcdata);
                }
                if (pieces[1] == "msg_send")
                {
                    if (pieces.length != 2)
                        throw new RPCError.MALFORMED_PACKET(
                            "get_peer_to_peer_service(pid).msg_send is a function.");
                    if (data.parameters.size != 3)
                        throw new RPCError.MALFORMED_PACKET(
                            "get_peer_to_peer_service(pid).msg_send wants 3 parameters.");
                    ISerializable iser0 = data.parameters[0];
                    if (! iser0.get_type().is_a(typeof(NIP)))
                        throw new RPCError.MALFORMED_PACKET(
                            "get_peer_to_peer_service(pid).msg_send parameter 1 is not a NIP.");
                    NIP sender_nip = (NIP)iser0;
                    ISerializable iser1 = data.parameters[1];
                    if (! iser1.get_type().is_a(typeof(NIP)))
                        throw new RPCError.MALFORMED_PACKET(
                            "get_peer_to_peer_service(pid).msg_send parameter 2 is not a NIP.");
                    NIP hip = (NIP)iser1;
                    ISerializable iser2 = data.parameters[2];
                    if (! iser2.get_type().is_a(typeof(RemoteCall)))
                        throw new RPCError.MALFORMED_PACKET(
                            "get_peer_to_peer_service(pid).msg_send parameter 3 is not a RemoteCall.");
                    RemoteCall rcdata = (RemoteCall)iser2;
                    return root.get_peer_to_peer_service(pid).msg_send(sender_nip, hip, rcdata);
                }
                if (pieces[1] == "find_nearest")
                {
                    if (pieces.length != 2)
                        throw new RPCError.MALFORMED_PACKET(
                            "get_peer_to_peer_service(pid).find_nearest is a function.");
                    if (data.parameters.size != 5)
                        throw new RPCError.MALFORMED_PACKET(
                            "get_peer_to_peer_service(pid).find_nearest wants 5 parameters.");
                    ISerializable iser0 = data.parameters[0];
                    if (! iser0.get_type().is_a(typeof(PeerToPeerTracerPacketList)))
                        throw new RPCError.MALFORMED_PACKET(
                            "get_peer_to_peer_service(pid).find_nearest parameter 1 is not a PeerToPeerTracerPacketList.");
                    PeerToPeerTracerPacketList peer_to_peer_tpl = (PeerToPeerTracerPacketList)iser0;
                    ISerializable iser1 = data.parameters[1];
                    if (! iser1.get_type().is_a(typeof(NIP)))
                        throw new RPCError.MALFORMED_PACKET(
                            "get_peer_to_peer_service(pid).find_nearest parameter 2 is not a NIP.");
                    NIP hash_nip = (NIP)iser1;
                    ISerializable iser2 = data.parameters[2];
                    if (! iser2.get_type().is_a(typeof(SerializableInt)))
                        throw new RPCError.MALFORMED_PACKET(
                            "get_peer_to_peer_service(pid).find_nearest parameter 3 is not a int.");
                    int num_dupl = ((SerializableInt)iser2).i;
                    ISerializable iser3 = data.parameters[3];
                    if (! iser3.get_type().is_a(typeof(SerializableInt)))
                        throw new RPCError.MALFORMED_PACKET(
                            "get_peer_to_peer_service(pid).find_nearest parameter 4 is not a int.");
                    int lvl = ((SerializableInt)iser3).i;
                    ISerializable iser4 = data.parameters[4];
                    if (! iser4.get_type().is_a(typeof(SerializableInt)))
                        throw new RPCError.MALFORMED_PACKET(
                            "get_peer_to_peer_service(pid).find_nearest parameter 5 is not a int.");
                    int pos = ((SerializableInt)iser4).i;
                    Gee.List<NIP> _ret = root.get_peer_to_peer_service(pid).find_nearest(peer_to_peer_tpl, hash_nip, num_dupl, lvl, pos);
                    ListISerializable ret = new ListISerializable.with_backer(_ret);
                    return ret;
                }
                if (pieces[1] == "number_of_participants")
                {
                    if (pieces.length != 2)
                        throw new RPCError.MALFORMED_PACKET(
                            "get_peer_to_peer_service(pid).number_of_participants is a function.");
                    if (data.parameters.size != 3)
                        throw new RPCError.MALFORMED_PACKET(
                            "get_peer_to_peer_service(pid).number_of_participants wants 3 parameters.");
                    ISerializable iser0 = data.parameters[0];
                    if (! iser0.get_type().is_a(typeof(PeerToPeerTracerPacketList)))
                        throw new RPCError.MALFORMED_PACKET(
                            "get_peer_to_peer_service(pid).number_of_participants parameter 1 is not a PeerToPeerTracerPacketList.");
                    PeerToPeerTracerPacketList peer_to_peer_tpl = (PeerToPeerTracerPacketList)iser0;
                    ISerializable iser1 = data.parameters[1];
                    if (! iser1.get_type().is_a(typeof(SerializableInt)))
                        throw new RPCError.MALFORMED_PACKET(
                            "get_peer_to_peer_service(pid).number_of_participants parameter 2 is not a int.");
                    int lvl = ((SerializableInt)iser1).i;
                    ISerializable iser2 = data.parameters[2];
                    if (! iser2.get_type().is_a(typeof(SerializableInt)))
                        throw new RPCError.MALFORMED_PACKET(
                            "get_peer_to_peer_service(pid).number_of_participants parameter 3 is not a int.");
                    int pos = ((SerializableInt)iser2).i;
                    return new SerializableInt(root.get_peer_to_peer_service(pid).number_of_participants(peer_to_peer_tpl, lvl, pos));
                }
            }
            if (pieces[0].length > 34 && pieces[0].substring(0, 34) == "get_optional_peer_to_peer_service(")
            {
                string remaining = pieces[0].substring(34);
                string curarg = "";
                while (remaining.substring(0, 1) in "1234567890")
                {
                    curarg += remaining.substring(0, 1);
                    remaining = remaining.substring(1);
                }
                remaining = remaining.substring(1);
                int pid = int.parse(curarg);
                if (pieces[1] == "participant_set")
                {
                    if (pieces.length != 2)
                        throw new RPCError.MALFORMED_PACKET(
                            "get_optional_peer_to_peer_service(pid).participant_set is a function.");
                    if (data.parameters.size != 4)
                        throw new RPCError.MALFORMED_PACKET(
                            "get_optional_peer_to_peer_service(pid).participant_set wants 4 parameters.");
                    ISerializable iser0 = data.parameters[0];
                    if (! iser0.get_type().is_a(typeof(NIP)))
                        throw new RPCError.MALFORMED_PACKET(
                            "get_optional_peer_to_peer_service(pid).participant_set parameter 1 is not a NIP.");
                    NIP nip = (NIP)iser0;
                    ISerializable iser1 = data.parameters[1];
                    if (! iser1.get_type().is_a(typeof(SerializableInt)))
                        throw new RPCError.MALFORMED_PACKET(
                            "get_optional_peer_to_peer_service(pid).participant_set parameter 2 is not a int.");
                    int lvl = ((SerializableInt)iser1).i;
                    ISerializable iser2 = data.parameters[2];
                    if (! iser2.get_type().is_a(typeof(SerializableInt)))
                        throw new RPCError.MALFORMED_PACKET(
                            "get_optional_peer_to_peer_service(pid).participant_set parameter 3 is not a int.");
                    int pos = ((SerializableInt)iser2).i;
                    ISerializable iser3 = data.parameters[3];
                    if (! iser3.get_type().is_a(typeof(ParticipantNode)))
                        throw new RPCError.MALFORMED_PACKET(
                            "get_optional_peer_to_peer_service(pid).participant_set parameter 4 is not a ParticipantNode.");
                    ParticipantNode participant_node = (ParticipantNode)iser3;
                    root.get_optional_peer_to_peer_service(pid).participant_set(nip, lvl, pos, participant_node);
                    return new SerializableNone();
                }
                if (pieces[1] == "participant_refresh")
                {
                    if (pieces.length != 2)
                        throw new RPCError.MALFORMED_PACKET(
                            "get_optional_peer_to_peer_service(pid).participant_refresh is a function.");
                    if (data.parameters.size != 2)
                        throw new RPCError.MALFORMED_PACKET(
                            "get_optional_peer_to_peer_service(pid).participant_refresh wants 2 parameters.");
                    ISerializable iser0 = data.parameters[0];
                    if (! iser0.get_type().is_a(typeof(NIP)))
                        throw new RPCError.MALFORMED_PACKET(
                            "get_optional_peer_to_peer_service(pid).participant_refresh parameter 1 is not a NIP.");
                    NIP nip = (NIP)iser0;
                    ISerializable iser1 = data.parameters[1];
                    if (! iser1.get_type().is_a(typeof(PackedParticipantNodes)))
                        throw new RPCError.MALFORMED_PACKET(
                            "get_optional_peer_to_peer_service(pid).participant_refresh parameter 2 is not a PackedParticipantNodes.");
                    PackedParticipantNodes packed_nodes = (PackedParticipantNodes)iser1;
                    root.get_optional_peer_to_peer_service(pid).participant_refresh(nip, packed_nodes);
                    return new SerializableNone();
                }
            }
            if (pieces[0] == "dht_stor")
            {
                if (pieces.length != 1)
                    throw new RPCError.MALFORMED_PACKET(
                        "dht_stor is a function.");
                if (data.parameters.size != 1)
                    throw new RPCError.MALFORMED_PACKET(
                        "dht_stor wants 1 parameter.");
                ISerializable iser0 = data.parameters[0];
                if (! iser0.get_type().is_a(typeof(DHTRecord)))
                    throw new RPCError.MALFORMED_PACKET(
                        "dht_stor parameter 1 is not a DHTRecord.");
                DHTRecord rec = (DHTRecord)iser0;
                root.dht_stor(rec);
                return new SerializableNone();
            }
            if (pieces[0] == "dht_retr")
            {
                if (pieces.length != 1)
                    throw new RPCError.MALFORMED_PACKET(
                        "dht_retr is a function.");
                if (data.parameters.size != 1)
                    throw new RPCError.MALFORMED_PACKET(
                        "dht_retr wants 1 parameter.");
                ISerializable iser0 = data.parameters[0];
                if (! iser0.get_type().is_a(typeof(DHTKey)))
                    throw new RPCError.MALFORMED_PACKET(
                        "dht_retr parameter 1 is not a DHTKey.");
                DHTKey k = (DHTKey)iser0;
                DHTRecord? ret = root.dht_retr(k);
                if (ret == null) return new SerializableNone();
                return ret;
            }
            if (pieces[0] == "dht_list")
            {
                if (pieces.length != 1)
                    throw new RPCError.MALFORMED_PACKET(
                        "dht_list is a function.");
                if (data.parameters.size != 0)
                    throw new RPCError.MALFORMED_PACKET(
                        "dht_list wants no parameters.");
                Gee.List<DHTRecord> _ret = root.dht_list();
                ListISerializable ret = new ListISerializable.with_backer(_ret);
                return ret;
            }
            if (pieces[0] == "report_tasklets_stats")
            {
                if (pieces.length != 1)
                    throw new RPCError.MALFORMED_PACKET(
                        "report_tasklets_stats is a function.");
                if (data.parameters.size != 1)
                    throw new RPCError.MALFORMED_PACKET(
                        "report_tasklets_stats wants 1 parameter.");
                ISerializable iser0 = data.parameters[0];
                if (! iser0.get_type().is_a(typeof(SerializableInt)))
                    throw new RPCError.MALFORMED_PACKET(
                        "report_tasklets_stats parameter 1 is not a int.");
                int minutes = ((SerializableInt)iser0).i;
                Gee.List<TaskletStats> _ret = root.report_tasklets_stats(minutes);
                ListISerializable ret = new ListISerializable.with_backer(_ret);
                return ret;
            }
            return base._dispatch(caller, data);
        }
    }
}
