/*
 *  This file is part of Netsukuku.
 *  (c) Copyright 2013 Luca Dionisi aka lukisi <luca.dionisi@gmail.com>
 *
 *  Netsukuku is free software: you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation, either version 3 of the License, or
 *  (at your option) any later version.
 *
 *  Netsukuku is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with Netsukuku.  If not, see <http://www.gnu.org/licenses/>.
 */

using Gtk;
using Gee;
using zcd;
using Tasklets;
using Netsukuku;

namespace Monitor
{
    public delegate PublicKey? RetrievePubkDelegate(string domain);
    public RetrievePubkDelegate retrieve_pubk;

    // position of fields in treemodel
    enum LISTNAMES {
        STR_NAME,
        NUMCOLUMNS
    }

    public class NamesApp : Object
    {
        public Window win_names {get; private set;}
        public Widget widget_root {get; private set;}
        private AndnaPrivateConfigurationList names;
        private ListStore liststore_names;
        private TreeView tv_names;
        private Button but_add;
        private Button but_remove;
        private Button but_details;
        public signal void go_back();

        public
        NamesApp
        (AndnaPrivateConfigurationList names,
         RetrievePubkDelegate retrieve_pubk_func)
        {
            this.names = names;
            retrieve_pubk = retrieve_pubk_func;

            Builder builder = new Builder ();
            builder.add_from_resource ("/org/netsukuku/monitorradar/names.ui");
            builder.connect_signals (this);

            win_names = builder.get_object ("win_names") as Window;
            widget_root = builder.get_object ("widget_root") as Widget;
            liststore_names = builder.get_object ("liststore_names") as ListStore;
            tv_names = builder.get_object ("tv_names") as TreeView;
            but_add = builder.get_object ("but_add") as Button;
            but_remove = builder.get_object ("but_remove") as Button;
            but_details = builder.get_object ("but_details") as Button;
            win_names.destroy.connect(going_back);

            TreeSelection sel_names = tv_names.get_selection();
            sel_names.set_mode(SelectionMode.SINGLE);
            sel_names.changed.connect(() => {tv_names_selection_changed();});

            refresh();
        }

        bool names_has_key(string domain)
        {
            foreach (AndnaPrivateConfiguration n in names.lst)
                if (n.domain == domain) return true;
            return false;
        }

        AndnaPrivateConfiguration? names_get(string domain)
        {
            foreach (AndnaPrivateConfiguration n in names.lst)
                if (n.domain == domain) return n;
            return null;
        }

        void names_unset(string domain)
        {
            foreach (AndnaPrivateConfiguration n in names.lst)
            {
                if (n.domain == domain)
                {
                    names.lst.remove(n);
                    return;
                }
            }
        }

        void going_back()
        {
            go_back();
        }

        [CCode (instance_pos = -1)]
        public void add_name_clicked(Button source)
        {
            string added = add_name();
            /*
            // scan treemodel for it
            TreeIter? found_iter = null;
            liststore_names.@foreach((model, path, iter) => {
                string str_name;
                model.@get(iter,
                        LISTNAMES.STR_NAME,
                        out str_name);
                if (str_name == added)
                {
                    found_iter = iter;
                    return true;
                }
                return false;
            });
            if (found_iter != null)
            {
                // select it
                tv_names.get_selection().select_iter(found_iter);
            }
            */
        }

        string add_name()
        {
            // adds name "untitled[N]" to the names
            int n = 0;
            string name = "untitled";
            string tentative;
            while (true)
            {
                tentative = name;
                if (n > 0) tentative = name + @"$(n)";
                // verify if it is already present
                bool present = names_has_key(tentative);
                if (present) n++;
                else break;
            }
            names.lst.add(new AndnaPrivateConfiguration(tentative));
            refresh();
            return tentative;
        }

        [CCode (instance_pos = -1)]
        public void remove_name_clicked(Button source)
        {
            names_unset(selected_name);
            refresh();
        }

        private Services services;
        [CCode (instance_pos = -1)]
        public void details_name_clicked(Button source)
        {
            services = new Services(names_get(selected_name));
            Window w = services.win_services;
            w.title = "services";
            w.show_all();
            // TODO uncomment: modal is buggy in ubuntu right now
            // w.modal = true;
            // w.set_transient_for(win_names);
            w.set_position(WindowPosition.CENTER_ON_PARENT);
            services.go_back.connect(update);
        }

        public void update()
        {
            selected_name = null;
            tv_names.get_selection().unselect_all();
            refresh();
        }

        public void refresh()
        {
            // refresh UI
            liststore_names.clear();
            TreeIter iter;

            foreach (AndnaPrivateConfiguration n in names.lst)
            {
                liststore_names.append(out iter);
                liststore_names.@set(iter,
                        LISTNAMES.STR_NAME, n.domain);
            }
        }

        private string? selected_name;
        void tv_names_selection_changed()
        {
            TreePath? path;
            unowned TreeViewColumn? column;
            TreeIter iter;
            tv_names.get_cursor(out path, out column);
            if (path != null)
            {
                if (liststore_names.get_iter(out iter, path))
                {
                    liststore_names.@get(iter,
                            LISTNAMES.STR_NAME,
                            out selected_name);
                    but_remove.sensitive = true;
                    but_details.sensitive = true;
                }
                else
                {
                    selected_name = null;
                    but_remove.sensitive = false;
                    but_details.sensitive = false;
                }
            }
            else
            {
                selected_name = null;
                but_remove.sensitive = false;
                but_details.sensitive = false;
            }
        }
    }
}

