/*
 *  This file is part of Netsukuku.
 *  (c) Copyright 2013 Luca Dionisi aka lukisi <luca.dionisi@gmail.com>
 *
 *  Netsukuku is free software: you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation, either version 3 of the License, or
 *  (at your option) any later version.
 *
 *  Netsukuku is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with Netsukuku.  If not, see <http://www.gnu.org/licenses/>.
 */

using Gtk;
using Gee;
using zcd;
using Tasklets;
using Netsukuku;

namespace Monitor
{
    // position of fields in treemodel
    enum LISTGIDS {
        INT_ELDERLINESS,
        INT_ELDEST_INTERNALE_ELDERLINESS,
        INT_IDENT,
        INT_LEVEL,
        NUMCOLUMNS
    }

    public class NodeGnodes : Object
    {
        private AddressManagerFakeRmtGetter client_getter;
        private ListStore liststore_gids;

        public NodeGnodes(Builder builder, Box box_parent, AddressManagerFakeRmtGetter client_getter)
        {
            this.client_getter = client_getter;
            liststore_gids = builder.get_object ("liststore_gids") as ListStore;
            builder.connect_signals (this);
            Widget widget_gnodes = builder.get_object ("widget_root") as Widget;
            widget_gnodes.reparent(box_parent);
        }

        private int impl_start_operations()
        {
            while (true)
            {
                try { refresh_gids();
                } catch (Error e) {}

                if (nap_until_condition(1000,
                    () => {
                        return t_op_aborting;
                    })) break;
            }
            return 0;
        }

        private Thread<int>? t_op;
        private bool t_op_aborting;
        public void start_operations()
        {
            if (t_op == null)
            {
                t_op_aborting = false;
                t_op = new Thread<int>(null, impl_start_operations);
            }
        }

        public void stop_operations()
        {
            if (t_op != null)
            {
                t_op_aborting = true;
                t_op.join();
                t_op = null;
            }
        }

        /** retrieve and display data
          */
        private void refresh_gids() throws Error
        {
            try
            {
                Gee.List<GNodeID> ret = client_getter.get_client().maproute.report_gid_list();

                MainContext.@default().invoke(() => {display_gids(ret); return false;});
            }
            catch (Error e)
            {
                string e_message = e.message;
                MainContext.@default().invoke(() => {display_error(e_message); return false;});
            }
        }

        void display_gids(Gee.List<GNodeID> gids)
        {
            liststore_gids.clear();
            int lvl = 0;
            foreach (GNodeID gid in gids)
            {
                TreeIter iter;
                liststore_gids.prepend(out iter);
                liststore_gids.@set(iter, LISTGIDS.INT_ELDERLINESS, gid.elderliness);
                liststore_gids.@set(iter, LISTGIDS.INT_ELDEST_INTERNALE_ELDERLINESS, gid.eldest_internal_elderliness);
                liststore_gids.@set(iter, LISTGIDS.INT_IDENT, gid.ident);
                liststore_gids.@set(iter, LISTGIDS.INT_LEVEL, lvl++);
            }
        }

        void display_error(string e_message)
        {
            //TreeIter iter;
            liststore_gids.clear();
            //liststore_gids.append(out iter);
            //liststore_gids.@set(iter, LISTGIDS.INT_ELDERLINESS, e_message);
        }
    }
}
