/* inetutils.c generated by valac 0.20.1, the Vala compiler
 * generated from inetutils.vala, do not modify */

/*
 *  This file is part of Netsukuku.
 *  (c) Copyright 2014 Luca Dionisi aka lukisi <luca.dionisi@gmail.com>
 *
 *  Netsukuku is free software: you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation, either version 3 of the License, or
 *  (at your option) any later version.
 *
 *  Netsukuku is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with Netsukuku.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <arpa/inet.h>
#include <sys/socket.h>
#include <netinet/in.h>

#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_checksum_free0(var) ((var == NULL) ? NULL : (var = (g_checksum_free (var), NULL)))
#define _g_bytes_unref0(var) ((var == NULL) ? NULL : (var = (g_bytes_unref (var), NULL)))
#define _vala_assert(expr, msg) if G_LIKELY (expr) ; else g_assertion_message_expr (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);



void netsukuku_inet_utils_address_v4_str_to_bytes (const gchar* ipstr, guint8* dst);
void netsukuku_inet_utils_address_v6_str_to_bytes (const gchar* ipstr, guint8* dst);
gchar* netsukuku_inet_utils_address_v4_bytes_to_str (guint8* addr, int addr_length1);
gchar* netsukuku_inet_utils_address_v6_bytes_to_str (guint8* addr, int addr_length1);
guint32 netsukuku_inet_utils_address_v4_bytes_to_int (guint8* addr, int addr_length1);
void netsukuku_inet_utils_address_v4_int_to_bytes (guint32 num, guint8* dst);
gchar* netsukuku_inet_utils_crypto_hash (const gchar* hostname);


/** Given a IPv4 address in a dotted format, this function puts the
      *  address in 4 contiguous bytes, such as those in a Posix.InAddr
      *  or those in a AndnaResponseAnswer or AndnaQuery.
      */
void netsukuku_inet_utils_address_v4_str_to_bytes (const gchar* ipstr, guint8* dst) {
	const gchar* _tmp0_;
	guint8* _tmp1_;
	g_return_if_fail (ipstr != NULL);
	_tmp0_ = ipstr;
	_tmp1_ = dst;
	inet_pton (AF_INET, _tmp0_, _tmp1_);
}


/** Given a IPv6 address in a string (eg 2001:ffff::), this function puts the
      *  address in 16 contiguous bytes, such as those in a Posix.In6Addr
      *  or those in a AndnaResponseAnswer or AndnaQuery.
      */
void netsukuku_inet_utils_address_v6_str_to_bytes (const gchar* ipstr, guint8* dst) {
	const gchar* _tmp0_;
	guint8* _tmp1_;
	g_return_if_fail (ipstr != NULL);
	_tmp0_ = ipstr;
	_tmp1_ = dst;
	inet_pton (AF_INET6, _tmp0_, _tmp1_);
}


/** Given 4 contiguous bytes, such as those in a Posix.InAddr
      *  or those in a AndnaResponseAnswer or AndnaQuery, this function returns
      *  a dotted string, for displaying to the user or for a "ip" command.
      */
gchar* netsukuku_inet_utils_address_v4_bytes_to_str (guint8* addr, int addr_length1) {
	gchar* result = NULL;
	guint8* _tmp0_;
	gint _tmp0__length1;
	gchar* ret = NULL;
	struct in_addr _tmp1_ = {0};
	struct in_addr inaddr;
	void* p;
	void* _tmp2_;
	guint8* inaddr_p;
	guint8 dst[16] = {0};
	guint8* _tmp13_;
	const gchar* _tmp14_ = NULL;
	const gchar* w_ret;
	gchar* _tmp15_;
	_tmp0_ = addr;
	_tmp0__length1 = addr_length1;
	_vala_assert (_tmp0__length1 == 4, "addr.length == 4");
	inaddr = _tmp1_;
	p = &inaddr.s_addr;
	_tmp2_ = p;
	inaddr_p = (guint8*) _tmp2_;
	{
		gint i;
		i = 0;
		{
			gboolean _tmp3_;
			_tmp3_ = TRUE;
			while (TRUE) {
				gboolean _tmp4_;
				gint _tmp6_;
				guint8* _tmp7_;
				gint _tmp8_;
				guint8* _tmp9_;
				gint _tmp9__length1;
				gint _tmp10_;
				guint8 _tmp11_;
				guint8 _tmp12_;
				_tmp4_ = _tmp3_;
				if (!_tmp4_) {
					gint _tmp5_;
					_tmp5_ = i;
					i = _tmp5_ + 1;
				}
				_tmp3_ = FALSE;
				_tmp6_ = i;
				if (!(_tmp6_ < 4)) {
					break;
				}
				_tmp7_ = inaddr_p;
				_tmp8_ = i;
				_tmp9_ = addr;
				_tmp9__length1 = addr_length1;
				_tmp10_ = i;
				_tmp11_ = _tmp9_[_tmp10_];
				_tmp7_[_tmp8_] = _tmp11_;
				_tmp12_ = _tmp7_[_tmp8_];
			}
		}
	}
	_vala_assert (INET_ADDRSTRLEN == 16, "Posix.INET_ADDRSTRLEN == 16");
	_tmp13_ = inaddr_p;
	_tmp14_ = inet_ntop (AF_INET, _tmp13_, dst, 16);
	w_ret = _tmp14_;
	_tmp15_ = g_strdup (w_ret);
	_g_free0 (ret);
	ret = _tmp15_;
	result = ret;
	 (inaddr);
	return result;
}


/** Given 16 contiguous bytes, such as those in a Posix.In6Addr
      *  or those in a AndnaResponseAnswer or AndnaQuery, this function returns
      *  a dotted string, for displaying to the user or for a "ip" command.
      */
gchar* netsukuku_inet_utils_address_v6_bytes_to_str (guint8* addr, int addr_length1) {
	gchar* result = NULL;
	guint8* _tmp0_;
	gint _tmp0__length1;
	gchar* ret = NULL;
	struct in6_addr _tmp1_ = {0};
	struct in6_addr inaddr;
	guint8 dst[46] = {0};
	const gchar* _tmp11_ = NULL;
	const gchar* w_ret;
	gchar* _tmp12_;
	_tmp0_ = addr;
	_tmp0__length1 = addr_length1;
	_vala_assert (_tmp0__length1 == 16, "addr.length == 16");
	inaddr = _tmp1_;
	{
		gint i;
		i = 0;
		{
			gboolean _tmp2_;
			_tmp2_ = TRUE;
			while (TRUE) {
				gboolean _tmp3_;
				gint _tmp5_;
				gint _tmp6_;
				guint8* _tmp7_;
				gint _tmp7__length1;
				gint _tmp8_;
				guint8 _tmp9_;
				guint8 _tmp10_;
				_tmp3_ = _tmp2_;
				if (!_tmp3_) {
					gint _tmp4_;
					_tmp4_ = i;
					i = _tmp4_ + 1;
				}
				_tmp2_ = FALSE;
				_tmp5_ = i;
				if (!(_tmp5_ < 16)) {
					break;
				}
				_tmp6_ = i;
				_tmp7_ = addr;
				_tmp7__length1 = addr_length1;
				_tmp8_ = i;
				_tmp9_ = _tmp7_[_tmp8_];
				inaddr.s6_addr[_tmp6_] = _tmp9_;
				_tmp10_ = inaddr.s6_addr[_tmp6_];
			}
		}
	}
	_vala_assert (INET6_ADDRSTRLEN == 46, "Posix.INET6_ADDRSTRLEN == 46");
	_tmp11_ = inet_ntop (AF_INET6, &inaddr, dst, 46);
	w_ret = _tmp11_;
	_tmp12_ = g_strdup (w_ret);
	_g_free0 (ret);
	ret = _tmp12_;
	result = ret;
	 (&inaddr);
	return result;
}


/** Given 4 contiguous bytes, such as those in a Posix.InAddr
      *  or those in a AndnaResponseAnswer or AndnaQuery, this function returns
      *  a uint32. This is useful, as long as IPv4 is used, in order to make
      *  arithmetic computations with IP addresses.
      */
guint32 netsukuku_inet_utils_address_v4_bytes_to_int (guint8* addr, int addr_length1) {
	guint32 result = 0U;
	guint8* _tmp0_;
	gint _tmp0__length1;
	guint32 ret = 0U;
	guint8* _tmp1_;
	gint _tmp1__length1;
	guint32* p;
	guint32 _tmp2_;
	guint32 _tmp3_ = 0U;
	_tmp0_ = addr;
	_tmp0__length1 = addr_length1;
	_vala_assert (_tmp0__length1 == 4, "addr.length == 4");
	_tmp1_ = addr;
	_tmp1__length1 = addr_length1;
	p = (guint32*) _tmp1_;
	ret = *p;
	_tmp2_ = ret;
	_tmp3_ = ntohl (_tmp2_);
	ret = _tmp3_;
	result = ret;
	return result;
}


/** Given a uint32 that represent a IPv4 address, this function puts the
      *  address in 4 contiguous bytes, such as those in a Posix.InAddr
      *  or those in a AndnaResponseAnswer or AndnaQuery.
      */
void netsukuku_inet_utils_address_v4_int_to_bytes (guint32 num, guint8* dst) {
	guint32 _tmp0_;
	guint32 _tmp1_ = 0U;
	guint32 num_h;
	guint32* lp;
	guint32* _tmp2_;
	guint8* p;
	_tmp0_ = num;
	_tmp1_ = htonl (_tmp0_);
	num_h = _tmp1_;
	lp = &num_h;
	_tmp2_ = lp;
	p = (guint8*) _tmp2_;
	{
		gint i;
		i = 0;
		{
			gboolean _tmp3_;
			_tmp3_ = TRUE;
			while (TRUE) {
				gboolean _tmp4_;
				gint _tmp6_;
				guint8* _tmp7_;
				gint _tmp8_;
				guint8* _tmp9_;
				gint _tmp10_;
				guint8 _tmp11_;
				guint8 _tmp12_;
				_tmp4_ = _tmp3_;
				if (!_tmp4_) {
					gint _tmp5_;
					_tmp5_ = i;
					i = _tmp5_ + 1;
				}
				_tmp3_ = FALSE;
				_tmp6_ = i;
				if (!(_tmp6_ < 4)) {
					break;
				}
				_tmp7_ = dst;
				_tmp8_ = i;
				_tmp9_ = p;
				_tmp10_ = i;
				_tmp11_ = _tmp9_[_tmp10_];
				_tmp7_[_tmp8_] = _tmp11_;
				_tmp12_ = _tmp7_[_tmp8_];
			}
		}
	}
}


static guint8* string_get_data (const gchar* self, int* result_length1) {
	guint8* result;
	guint8* res;
	gint res_length1;
	gint _res_size_;
	gint _tmp0_;
	gint _tmp1_;
	gint _tmp2_;
	guint8* _tmp3_;
	gint _tmp3__length1;
	guint8* _tmp4_;
	gint _tmp4__length1;
	g_return_val_if_fail (self != NULL, NULL);
	res = (guint8*) self;
	res_length1 = -1;
	_res_size_ = res_length1;
	_tmp0_ = strlen (self);
	_tmp1_ = _tmp0_;
	res_length1 = (gint) _tmp1_;
	_tmp2_ = res_length1;
	_tmp3_ = res;
	_tmp3__length1 = res_length1;
	_tmp4_ = _tmp3_;
	_tmp4__length1 = _tmp3__length1;
	if (result_length1) {
		*result_length1 = _tmp4__length1;
	}
	result = _tmp4_;
	return result;
}


static glong string_strnlen (gchar* str, glong maxlen) {
	glong result = 0L;
	gchar* _tmp0_;
	glong _tmp1_;
	gchar* _tmp2_ = NULL;
	gchar* end;
	gchar* _tmp3_;
	_tmp0_ = str;
	_tmp1_ = maxlen;
	_tmp2_ = memchr (_tmp0_, 0, (gsize) _tmp1_);
	end = _tmp2_;
	_tmp3_ = end;
	if (_tmp3_ == NULL) {
		glong _tmp4_;
		_tmp4_ = maxlen;
		result = _tmp4_;
		return result;
	} else {
		gchar* _tmp5_;
		gchar* _tmp6_;
		_tmp5_ = end;
		_tmp6_ = str;
		result = (glong) (_tmp5_ - _tmp6_);
		return result;
	}
}


static gchar* string_substring (const gchar* self, glong offset, glong len) {
	gchar* result = NULL;
	glong string_length = 0L;
	gboolean _tmp0_ = FALSE;
	glong _tmp1_;
	gboolean _tmp3_;
	glong _tmp9_;
	glong _tmp15_;
	glong _tmp18_;
	glong _tmp19_;
	glong _tmp20_;
	glong _tmp21_;
	glong _tmp22_;
	gchar* _tmp23_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp1_ = offset;
	if (_tmp1_ >= ((glong) 0)) {
		glong _tmp2_;
		_tmp2_ = len;
		_tmp0_ = _tmp2_ >= ((glong) 0);
	} else {
		_tmp0_ = FALSE;
	}
	_tmp3_ = _tmp0_;
	if (_tmp3_) {
		glong _tmp4_;
		glong _tmp5_;
		glong _tmp6_ = 0L;
		_tmp4_ = offset;
		_tmp5_ = len;
		_tmp6_ = string_strnlen ((gchar*) self, _tmp4_ + _tmp5_);
		string_length = _tmp6_;
	} else {
		gint _tmp7_;
		gint _tmp8_;
		_tmp7_ = strlen (self);
		_tmp8_ = _tmp7_;
		string_length = (glong) _tmp8_;
	}
	_tmp9_ = offset;
	if (_tmp9_ < ((glong) 0)) {
		glong _tmp10_;
		glong _tmp11_;
		glong _tmp12_;
		_tmp10_ = string_length;
		_tmp11_ = offset;
		offset = _tmp10_ + _tmp11_;
		_tmp12_ = offset;
		g_return_val_if_fail (_tmp12_ >= ((glong) 0), NULL);
	} else {
		glong _tmp13_;
		glong _tmp14_;
		_tmp13_ = offset;
		_tmp14_ = string_length;
		g_return_val_if_fail (_tmp13_ <= _tmp14_, NULL);
	}
	_tmp15_ = len;
	if (_tmp15_ < ((glong) 0)) {
		glong _tmp16_;
		glong _tmp17_;
		_tmp16_ = string_length;
		_tmp17_ = offset;
		len = _tmp16_ - _tmp17_;
	}
	_tmp18_ = offset;
	_tmp19_ = len;
	_tmp20_ = string_length;
	g_return_val_if_fail ((_tmp18_ + _tmp19_) <= _tmp20_, NULL);
	_tmp21_ = offset;
	_tmp22_ = len;
	_tmp23_ = g_strndup (((gchar*) self) + _tmp21_, (gsize) _tmp22_);
	result = _tmp23_;
	return result;
}


gchar* netsukuku_inet_utils_crypto_hash (const gchar* hostname) {
	gchar* result = NULL;
	const gchar* _tmp0_;
	gchar* _tmp1_ = NULL;
	gchar* ci_hname;
	guint8* _tmp2_;
	gint _tmp2__length1;
	guint8* _tmp3_;
	gint _tmp3__length1;
	GBytes* _tmp4_;
	GBytes* b;
	GChecksum* _tmp5_;
	GChecksum* s;
	gsize _tmp6_;
	guint8* _tmp7_ = NULL;
	gsize _tmp8_ = 0UL;
	guint8* _tmp9_ = NULL;
	guint8* hash;
	gint hash_length1;
	gint _hash_size_;
	gsize digest_len;
	gchar* _tmp10_ = NULL;
	gchar* _tmp11_;
	gchar* _tmp12_ = NULL;
	gchar* _tmp13_;
	gchar* ret;
	g_return_val_if_fail (hostname != NULL, NULL);
	_tmp0_ = hostname;
	_tmp1_ = g_utf8_strup (_tmp0_, (gssize) (-1));
	ci_hname = _tmp1_;
	_tmp2_ = string_get_data (ci_hname, &_tmp2__length1);
	_tmp3_ = _tmp2_;
	_tmp3__length1 = _tmp2__length1;
	_tmp4_ = g_bytes_new (_tmp3_, _tmp3__length1);
	b = _tmp4_;
	_tmp5_ = g_checksum_new (G_CHECKSUM_MD5);
	s = _tmp5_;
	_tmp7_ = g_bytes_get_data (b, &_tmp6_);
	_tmp8_ = g_bytes_get_size (b);
	g_checksum_update (s, (guchar*) _tmp7_, _tmp8_);
	_tmp9_ = g_new0 (guint8, 16);
	hash = _tmp9_;
	hash_length1 = 16;
	_hash_size_ = hash_length1;
	digest_len = (gsize) 16;
	g_checksum_get_digest (s, hash, &digest_len);
	_tmp10_ = g_base64_encode ((guchar*) hash, (hash_length1 * sizeof (guint8)) / sizeof (guchar));
	_tmp11_ = _tmp10_;
	_tmp12_ = string_substring (_tmp11_, (glong) 0, (glong) 22);
	_tmp13_ = _tmp12_;
	_g_free0 (_tmp11_);
	ret = _tmp13_;
	result = ret;
	hash = (g_free (hash), NULL);
	_g_checksum_free0 (s);
	_g_bytes_unref0 (b);
	_g_free0 (ci_hname);
	return result;
}



