/* libntkresolv.c generated by valac 0.20.1, the Vala compiler
 * generated from libntkresolv.vala, do not modify */

/*
 *  This file is part of Netsukuku.
 *  (c) Copyright 2014 Luca Dionisi aka lukisi <luca.dionisi@gmail.com>
 *
 *  Netsukuku is free software: you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation, either version 3 of the License, or
 *  (at your option) any later version.
 *
 *  Netsukuku is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with Netsukuku.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <syslog.h>
#include <zcd-tcpclient.h>
#include <andns-rpc-tcpclient.h>
#include <gee.h>
#include "ntkutils.h"

#define _g_free0(var) (var = (g_free (var), NULL))

#define NTKRESOLV_TYPE_NTK_ADDR (ntkresolv_ntk_addr_get_type ())
#define NTKRESOLV_NTK_ADDR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), NTKRESOLV_TYPE_NTK_ADDR, NtkresolvNtkAddr))
#define NTKRESOLV_NTK_ADDR_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), NTKRESOLV_TYPE_NTK_ADDR, NtkresolvNtkAddrClass))
#define NTKRESOLV_IS_NTK_ADDR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), NTKRESOLV_TYPE_NTK_ADDR))
#define NTKRESOLV_IS_NTK_ADDR_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), NTKRESOLV_TYPE_NTK_ADDR))
#define NTKRESOLV_NTK_ADDR_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), NTKRESOLV_TYPE_NTK_ADDR, NtkresolvNtkAddrClass))

typedef struct _NtkresolvNtkAddr NtkresolvNtkAddr;
typedef struct _NtkresolvNtkAddrClass NtkresolvNtkAddrClass;
typedef struct _NtkresolvNtkAddrPrivate NtkresolvNtkAddrPrivate;

#define NTKRESOLV_TYPE_NTK_INET_ADDR (ntkresolv_ntk_inet_addr_get_type ())
#define NTKRESOLV_NTK_INET_ADDR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), NTKRESOLV_TYPE_NTK_INET_ADDR, NtkresolvNtkInetAddr))
#define NTKRESOLV_NTK_INET_ADDR_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), NTKRESOLV_TYPE_NTK_INET_ADDR, NtkresolvNtkInetAddrClass))
#define NTKRESOLV_IS_NTK_INET_ADDR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), NTKRESOLV_TYPE_NTK_INET_ADDR))
#define NTKRESOLV_IS_NTK_INET_ADDR_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), NTKRESOLV_TYPE_NTK_INET_ADDR))
#define NTKRESOLV_NTK_INET_ADDR_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), NTKRESOLV_TYPE_NTK_INET_ADDR, NtkresolvNtkInetAddrClass))

typedef struct _NtkresolvNtkInetAddr NtkresolvNtkInetAddr;
typedef struct _NtkresolvNtkInetAddrClass NtkresolvNtkInetAddrClass;
typedef struct _NtkresolvNtkInetAddrPrivate NtkresolvNtkInetAddrPrivate;

#define NTKRESOLV_TYPE_IP_FAMILY (ntkresolv_ip_family_get_type ())

#define NTKRESOLV_TYPE_IP_PROTOCOL (ntkresolv_ip_protocol_get_type ())

#define NTKRESOLV_TYPE_SOCKET_TYPE (ntkresolv_socket_type_get_type ())

#define NTKRESOLV_TYPE_NTK_ADDR_INFO (ntkresolv_ntk_addr_info_get_type ())
#define NTKRESOLV_NTK_ADDR_INFO(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), NTKRESOLV_TYPE_NTK_ADDR_INFO, NtkresolvNtkAddrInfo))
#define NTKRESOLV_NTK_ADDR_INFO_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), NTKRESOLV_TYPE_NTK_ADDR_INFO, NtkresolvNtkAddrInfoClass))
#define NTKRESOLV_IS_NTK_ADDR_INFO(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), NTKRESOLV_TYPE_NTK_ADDR_INFO))
#define NTKRESOLV_IS_NTK_ADDR_INFO_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), NTKRESOLV_TYPE_NTK_ADDR_INFO))
#define NTKRESOLV_NTK_ADDR_INFO_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), NTKRESOLV_TYPE_NTK_ADDR_INFO, NtkresolvNtkAddrInfoClass))

typedef struct _NtkresolvNtkAddrInfo NtkresolvNtkAddrInfo;
typedef struct _NtkresolvNtkAddrInfoClass NtkresolvNtkAddrInfoClass;
typedef struct _NtkresolvNtkAddrInfoPrivate NtkresolvNtkAddrInfoPrivate;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _vala_assert(expr, msg) if G_LIKELY (expr) ; else g_assertion_message_expr (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);

struct _NtkresolvNtkAddr {
	GObject parent_instance;
	NtkresolvNtkAddrPrivate * priv;
};

struct _NtkresolvNtkAddrClass {
	GObjectClass parent_class;
};

struct _NtkresolvNtkInetAddr {
	NtkresolvNtkAddr parent_instance;
	NtkresolvNtkInetAddrPrivate * priv;
	guint8 addr[4];
	guint16 port;
};

struct _NtkresolvNtkInetAddrClass {
	NtkresolvNtkAddrClass parent_class;
};

typedef enum  {
	NTKRESOLV_IP_FAMILY_IPV4,
	NTKRESOLV_IP_FAMILY_IPV6,
	NTKRESOLV_IP_FAMILY_UNSPEC
} NtkresolvIpFamily;

typedef enum  {
	NTKRESOLV_IP_PROTOCOL_IP,
	NTKRESOLV_IP_PROTOCOL_TCP,
	NTKRESOLV_IP_PROTOCOL_UDP
} NtkresolvIpProtocol;

typedef enum  {
	NTKRESOLV_SOCKET_TYPE_DATAGRAM,
	NTKRESOLV_SOCKET_TYPE_STREAM,
	NTKRESOLV_SOCKET_TYPE_UNSPEC
} NtkresolvSocketType;

struct _NtkresolvNtkAddrInfo {
	GObject parent_instance;
	NtkresolvNtkAddrInfoPrivate * priv;
	NtkresolvIpFamily family;
	NtkresolvSocketType socket_type;
	NtkresolvIpProtocol protocol;
	NtkresolvNtkAddr* address;
};

struct _NtkresolvNtkAddrInfoClass {
	GObjectClass parent_class;
};

typedef enum  {
	NTKRESOLV_NTKRESOLV_ERROR_GENERIC
} NtkresolvNtkresolvError;
#define NTKRESOLV_NTKRESOLV_ERROR ntkresolv_ntkresolv_error_quark ()

static gpointer ntkresolv_ntk_addr_parent_class = NULL;
static gpointer ntkresolv_ntk_inet_addr_parent_class = NULL;
static gpointer ntkresolv_ntk_addr_info_parent_class = NULL;
extern gboolean ntkresolv_init_done;
gboolean ntkresolv_init_done = FALSE;

void ntkresolv_log_debug (const gchar* msg);
void ntkresolv_log_info (const gchar* msg);
void ntkresolv_log_notice (const gchar* msg);
void ntkresolv_log_warn (const gchar* msg);
void ntkresolv_log_error (const gchar* msg);
void ntkresolv_log_critical (const gchar* msg);
GType ntkresolv_ntk_addr_get_type (void) G_GNUC_CONST;
enum  {
	NTKRESOLV_NTK_ADDR_DUMMY_PROPERTY
};
NtkresolvNtkAddr* ntkresolv_ntk_addr_new (void);
NtkresolvNtkAddr* ntkresolv_ntk_addr_construct (GType object_type);
GType ntkresolv_ntk_inet_addr_get_type (void) G_GNUC_CONST;
enum  {
	NTKRESOLV_NTK_INET_ADDR_DUMMY_PROPERTY
};
NtkresolvNtkInetAddr* ntkresolv_ntk_inet_addr_new (guint8* addr, int addr_length1, guint16 port);
NtkresolvNtkInetAddr* ntkresolv_ntk_inet_addr_construct (GType object_type, guint8* addr, int addr_length1, guint16 port);
NtkresolvNtkInetAddr* ntkresolv_ntk_inet_addr_new_from_pointer (guint8* addr, guint16 port);
NtkresolvNtkInetAddr* ntkresolv_ntk_inet_addr_construct_from_pointer (GType object_type, guint8* addr, guint16 port);
static void ntkresolv_ntk_inet_addr_finalize (GObject* obj);
GType ntkresolv_ip_family_get_type (void) G_GNUC_CONST;
GType ntkresolv_ip_protocol_get_type (void) G_GNUC_CONST;
GType ntkresolv_socket_type_get_type (void) G_GNUC_CONST;
GType ntkresolv_ntk_addr_info_get_type (void) G_GNUC_CONST;
enum  {
	NTKRESOLV_NTK_ADDR_INFO_DUMMY_PROPERTY
};
NtkresolvNtkAddrInfo* ntkresolv_ntk_addr_info_new (void);
NtkresolvNtkAddrInfo* ntkresolv_ntk_addr_info_construct (GType object_type);
static void ntkresolv_ntk_addr_info_finalize (GObject* obj);
GQuark ntkresolv_ntkresolv_error_quark (void);
void ntkresolv_init (void);
GeeList* ntkresolv_resolv (const gchar* node, const gchar* service, NtkresolvNtkAddrInfo* _hints, const gchar* tcpaddress, GError** error);
const gchar* andns_andna_response_code_to_string (AndnsAndnaResponseCode self);
GeeList* ntkresolv_inverse (NtkresolvIpFamily family, NtkresolvNtkAddr* addr, const gchar* tcpaddress, GError** error);


void ntkresolv_log_debug (const gchar* msg) {
	const gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	g_return_if_fail (msg != NULL);
	_tmp0_ = msg;
	_tmp1_ = g_strconcat ("DEBUG ", _tmp0_, NULL);
	_tmp2_ = _tmp1_;
	syslog (LOG_DEBUG, _tmp2_, NULL);
	_g_free0 (_tmp2_);
}


void ntkresolv_log_info (const gchar* msg) {
	const gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	g_return_if_fail (msg != NULL);
	_tmp0_ = msg;
	_tmp1_ = g_strconcat ("INFO ", _tmp0_, NULL);
	_tmp2_ = _tmp1_;
	syslog (LOG_INFO, _tmp2_, NULL);
	_g_free0 (_tmp2_);
}


void ntkresolv_log_notice (const gchar* msg) {
	const gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	g_return_if_fail (msg != NULL);
	_tmp0_ = msg;
	_tmp1_ = g_strconcat ("INFO+ ", _tmp0_, NULL);
	_tmp2_ = _tmp1_;
	syslog (LOG_NOTICE, _tmp2_, NULL);
	_g_free0 (_tmp2_);
}


void ntkresolv_log_warn (const gchar* msg) {
	const gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	g_return_if_fail (msg != NULL);
	_tmp0_ = msg;
	_tmp1_ = g_strconcat ("INFO++ ", _tmp0_, NULL);
	_tmp2_ = _tmp1_;
	syslog (LOG_WARNING, _tmp2_, NULL);
	_g_free0 (_tmp2_);
}


void ntkresolv_log_error (const gchar* msg) {
	const gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	g_return_if_fail (msg != NULL);
	_tmp0_ = msg;
	_tmp1_ = g_strconcat ("ERROR ", _tmp0_, NULL);
	_tmp2_ = _tmp1_;
	syslog (LOG_ERR, _tmp2_, NULL);
	_g_free0 (_tmp2_);
}


void ntkresolv_log_critical (const gchar* msg) {
	const gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	g_return_if_fail (msg != NULL);
	_tmp0_ = msg;
	_tmp1_ = g_strconcat ("ERROR+ ", _tmp0_, NULL);
	_tmp2_ = _tmp1_;
	syslog (LOG_CRIT, _tmp2_, NULL);
	_g_free0 (_tmp2_);
}


NtkresolvNtkAddr* ntkresolv_ntk_addr_construct (GType object_type) {
	NtkresolvNtkAddr * self = NULL;
	self = (NtkresolvNtkAddr*) g_object_new (object_type, NULL);
	return self;
}


NtkresolvNtkAddr* ntkresolv_ntk_addr_new (void) {
	return ntkresolv_ntk_addr_construct (NTKRESOLV_TYPE_NTK_ADDR);
}


static void ntkresolv_ntk_addr_class_init (NtkresolvNtkAddrClass * klass) {
	ntkresolv_ntk_addr_parent_class = g_type_class_peek_parent (klass);
}


static void ntkresolv_ntk_addr_instance_init (NtkresolvNtkAddr * self) {
}


GType ntkresolv_ntk_addr_get_type (void) {
	static volatile gsize ntkresolv_ntk_addr_type_id__volatile = 0;
	if (g_once_init_enter (&ntkresolv_ntk_addr_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (NtkresolvNtkAddrClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) ntkresolv_ntk_addr_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (NtkresolvNtkAddr), 0, (GInstanceInitFunc) ntkresolv_ntk_addr_instance_init, NULL };
		GType ntkresolv_ntk_addr_type_id;
		ntkresolv_ntk_addr_type_id = g_type_register_static (G_TYPE_OBJECT, "NtkresolvNtkAddr", &g_define_type_info, 0);
		g_once_init_leave (&ntkresolv_ntk_addr_type_id__volatile, ntkresolv_ntk_addr_type_id);
	}
	return ntkresolv_ntk_addr_type_id__volatile;
}


NtkresolvNtkInetAddr* ntkresolv_ntk_inet_addr_construct (GType object_type, guint8* addr, int addr_length1, guint16 port) {
	NtkresolvNtkInetAddr * self = NULL;
	guint8* _tmp0_;
	gint _tmp0__length1;
	guint16 _tmp10_;
	self = (NtkresolvNtkInetAddr*) ntkresolv_ntk_addr_construct (object_type);
	_tmp0_ = addr;
	_tmp0__length1 = addr_length1;
	_vala_assert (_tmp0__length1 == 4, "addr.length == 4");
	{
		gint i;
		i = 0;
		{
			gboolean _tmp1_;
			_tmp1_ = TRUE;
			while (TRUE) {
				gboolean _tmp2_;
				gint _tmp4_;
				gint _tmp5_;
				guint8* _tmp6_;
				gint _tmp6__length1;
				gint _tmp7_;
				guint8 _tmp8_;
				guint8 _tmp9_;
				_tmp2_ = _tmp1_;
				if (!_tmp2_) {
					gint _tmp3_;
					_tmp3_ = i;
					i = _tmp3_ + 1;
				}
				_tmp1_ = FALSE;
				_tmp4_ = i;
				if (!(_tmp4_ < 4)) {
					break;
				}
				_tmp5_ = i;
				_tmp6_ = addr;
				_tmp6__length1 = addr_length1;
				_tmp7_ = i;
				_tmp8_ = _tmp6_[_tmp7_];
				self->addr[_tmp5_] = _tmp8_;
				_tmp9_ = self->addr[_tmp5_];
			}
		}
	}
	_tmp10_ = port;
	self->port = _tmp10_;
	return self;
}


NtkresolvNtkInetAddr* ntkresolv_ntk_inet_addr_new (guint8* addr, int addr_length1, guint16 port) {
	return ntkresolv_ntk_inet_addr_construct (NTKRESOLV_TYPE_NTK_INET_ADDR, addr, addr_length1, port);
}


NtkresolvNtkInetAddr* ntkresolv_ntk_inet_addr_construct_from_pointer (GType object_type, guint8* addr, guint16 port) {
	NtkresolvNtkInetAddr * self = NULL;
	guint16 _tmp9_;
	self = (NtkresolvNtkInetAddr*) ntkresolv_ntk_addr_construct (object_type);
	{
		gint i;
		i = 0;
		{
			gboolean _tmp0_;
			_tmp0_ = TRUE;
			while (TRUE) {
				gboolean _tmp1_;
				gint _tmp3_;
				gint _tmp4_;
				guint8* _tmp5_;
				gint _tmp6_;
				guint8 _tmp7_;
				guint8 _tmp8_;
				_tmp1_ = _tmp0_;
				if (!_tmp1_) {
					gint _tmp2_;
					_tmp2_ = i;
					i = _tmp2_ + 1;
				}
				_tmp0_ = FALSE;
				_tmp3_ = i;
				if (!(_tmp3_ < 4)) {
					break;
				}
				_tmp4_ = i;
				_tmp5_ = addr;
				_tmp6_ = i;
				_tmp7_ = _tmp5_[_tmp6_];
				self->addr[_tmp4_] = _tmp7_;
				_tmp8_ = self->addr[_tmp4_];
			}
		}
	}
	_tmp9_ = port;
	self->port = _tmp9_;
	return self;
}


NtkresolvNtkInetAddr* ntkresolv_ntk_inet_addr_new_from_pointer (guint8* addr, guint16 port) {
	return ntkresolv_ntk_inet_addr_construct_from_pointer (NTKRESOLV_TYPE_NTK_INET_ADDR, addr, port);
}


static void ntkresolv_ntk_inet_addr_class_init (NtkresolvNtkInetAddrClass * klass) {
	ntkresolv_ntk_inet_addr_parent_class = g_type_class_peek_parent (klass);
	G_OBJECT_CLASS (klass)->finalize = ntkresolv_ntk_inet_addr_finalize;
}


static void ntkresolv_ntk_inet_addr_instance_init (NtkresolvNtkInetAddr * self) {
}


static void ntkresolv_ntk_inet_addr_finalize (GObject* obj) {
	NtkresolvNtkInetAddr * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, NTKRESOLV_TYPE_NTK_INET_ADDR, NtkresolvNtkInetAddr);
	G_OBJECT_CLASS (ntkresolv_ntk_inet_addr_parent_class)->finalize (obj);
}


GType ntkresolv_ntk_inet_addr_get_type (void) {
	static volatile gsize ntkresolv_ntk_inet_addr_type_id__volatile = 0;
	if (g_once_init_enter (&ntkresolv_ntk_inet_addr_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (NtkresolvNtkInetAddrClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) ntkresolv_ntk_inet_addr_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (NtkresolvNtkInetAddr), 0, (GInstanceInitFunc) ntkresolv_ntk_inet_addr_instance_init, NULL };
		GType ntkresolv_ntk_inet_addr_type_id;
		ntkresolv_ntk_inet_addr_type_id = g_type_register_static (NTKRESOLV_TYPE_NTK_ADDR, "NtkresolvNtkInetAddr", &g_define_type_info, 0);
		g_once_init_leave (&ntkresolv_ntk_inet_addr_type_id__volatile, ntkresolv_ntk_inet_addr_type_id);
	}
	return ntkresolv_ntk_inet_addr_type_id__volatile;
}


GType ntkresolv_ip_family_get_type (void) {
	static volatile gsize ntkresolv_ip_family_type_id__volatile = 0;
	if (g_once_init_enter (&ntkresolv_ip_family_type_id__volatile)) {
		static const GEnumValue values[] = {{NTKRESOLV_IP_FAMILY_IPV4, "NTKRESOLV_IP_FAMILY_IPV4", "ipv4"}, {NTKRESOLV_IP_FAMILY_IPV6, "NTKRESOLV_IP_FAMILY_IPV6", "ipv6"}, {NTKRESOLV_IP_FAMILY_UNSPEC, "NTKRESOLV_IP_FAMILY_UNSPEC", "unspec"}, {0, NULL, NULL}};
		GType ntkresolv_ip_family_type_id;
		ntkresolv_ip_family_type_id = g_enum_register_static ("NtkresolvIpFamily", values);
		g_once_init_leave (&ntkresolv_ip_family_type_id__volatile, ntkresolv_ip_family_type_id);
	}
	return ntkresolv_ip_family_type_id__volatile;
}


GType ntkresolv_ip_protocol_get_type (void) {
	static volatile gsize ntkresolv_ip_protocol_type_id__volatile = 0;
	if (g_once_init_enter (&ntkresolv_ip_protocol_type_id__volatile)) {
		static const GEnumValue values[] = {{NTKRESOLV_IP_PROTOCOL_IP, "NTKRESOLV_IP_PROTOCOL_IP", "ip"}, {NTKRESOLV_IP_PROTOCOL_TCP, "NTKRESOLV_IP_PROTOCOL_TCP", "tcp"}, {NTKRESOLV_IP_PROTOCOL_UDP, "NTKRESOLV_IP_PROTOCOL_UDP", "udp"}, {0, NULL, NULL}};
		GType ntkresolv_ip_protocol_type_id;
		ntkresolv_ip_protocol_type_id = g_enum_register_static ("NtkresolvIpProtocol", values);
		g_once_init_leave (&ntkresolv_ip_protocol_type_id__volatile, ntkresolv_ip_protocol_type_id);
	}
	return ntkresolv_ip_protocol_type_id__volatile;
}


GType ntkresolv_socket_type_get_type (void) {
	static volatile gsize ntkresolv_socket_type_type_id__volatile = 0;
	if (g_once_init_enter (&ntkresolv_socket_type_type_id__volatile)) {
		static const GEnumValue values[] = {{NTKRESOLV_SOCKET_TYPE_DATAGRAM, "NTKRESOLV_SOCKET_TYPE_DATAGRAM", "datagram"}, {NTKRESOLV_SOCKET_TYPE_STREAM, "NTKRESOLV_SOCKET_TYPE_STREAM", "stream"}, {NTKRESOLV_SOCKET_TYPE_UNSPEC, "NTKRESOLV_SOCKET_TYPE_UNSPEC", "unspec"}, {0, NULL, NULL}};
		GType ntkresolv_socket_type_type_id;
		ntkresolv_socket_type_type_id = g_enum_register_static ("NtkresolvSocketType", values);
		g_once_init_leave (&ntkresolv_socket_type_type_id__volatile, ntkresolv_socket_type_type_id);
	}
	return ntkresolv_socket_type_type_id__volatile;
}


NtkresolvNtkAddrInfo* ntkresolv_ntk_addr_info_construct (GType object_type) {
	NtkresolvNtkAddrInfo * self = NULL;
	self = (NtkresolvNtkAddrInfo*) g_object_new (object_type, NULL);
	return self;
}


NtkresolvNtkAddrInfo* ntkresolv_ntk_addr_info_new (void) {
	return ntkresolv_ntk_addr_info_construct (NTKRESOLV_TYPE_NTK_ADDR_INFO);
}


static void ntkresolv_ntk_addr_info_class_init (NtkresolvNtkAddrInfoClass * klass) {
	ntkresolv_ntk_addr_info_parent_class = g_type_class_peek_parent (klass);
	G_OBJECT_CLASS (klass)->finalize = ntkresolv_ntk_addr_info_finalize;
}


static void ntkresolv_ntk_addr_info_instance_init (NtkresolvNtkAddrInfo * self) {
}


static void ntkresolv_ntk_addr_info_finalize (GObject* obj) {
	NtkresolvNtkAddrInfo * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, NTKRESOLV_TYPE_NTK_ADDR_INFO, NtkresolvNtkAddrInfo);
	_g_object_unref0 (self->address);
	G_OBJECT_CLASS (ntkresolv_ntk_addr_info_parent_class)->finalize (obj);
}


GType ntkresolv_ntk_addr_info_get_type (void) {
	static volatile gsize ntkresolv_ntk_addr_info_type_id__volatile = 0;
	if (g_once_init_enter (&ntkresolv_ntk_addr_info_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (NtkresolvNtkAddrInfoClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) ntkresolv_ntk_addr_info_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (NtkresolvNtkAddrInfo), 0, (GInstanceInitFunc) ntkresolv_ntk_addr_info_instance_init, NULL };
		GType ntkresolv_ntk_addr_info_type_id;
		ntkresolv_ntk_addr_info_type_id = g_type_register_static (G_TYPE_OBJECT, "NtkresolvNtkAddrInfo", &g_define_type_info, 0);
		g_once_init_leave (&ntkresolv_ntk_addr_info_type_id__volatile, ntkresolv_ntk_addr_info_type_id);
	}
	return ntkresolv_ntk_addr_info_type_id__volatile;
}


GQuark ntkresolv_ntkresolv_error_quark (void) {
	return g_quark_from_static_string ("ntkresolv_ntkresolv_error-quark");
}


void ntkresolv_init (void) {
	gboolean _tmp0_;
	_tmp0_ = ntkresolv_init_done;
	if (_tmp0_) {
		return;
	}
	zcd_serializer_init ();
	andns_rpc_andns_init ();
	ntkresolv_init_done = TRUE;
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


GeeList* ntkresolv_resolv (const gchar* node, const gchar* service, NtkresolvNtkAddrInfo* _hints, const gchar* tcpaddress, GError** error) {
	GeeList* result = NULL;
	NtkresolvNtkAddrInfo* hints = NULL;
	NtkresolvNtkAddrInfo* _tmp0_;
	NetsukukuAndnaServiceKey* _tmp7_;
	NetsukukuAndnaServiceKey* _tmp8_;
	NetsukukuAndnaServiceKey* _tmp9_;
	NetsukukuAndnaServiceKey* serv_key;
	gboolean _tmp10_ = FALSE;
	const gchar* _tmp11_;
	gboolean _tmp14_;
	const gchar* _tmp23_;
	guint16 _tmp24_;
	AndnsAndnaResolveTCPClient* _tmp25_;
	AndnsAndnaResolveTCPClient* client;
	AndnsAndnaResolveTCPClient* _tmp26_;
	const gchar* _tmp27_;
	gchar* _tmp28_ = NULL;
	gchar* _tmp29_;
	NetsukukuAndnaServiceKey* _tmp30_;
	AndnsAndnaQuery* _tmp31_;
	AndnsAndnaQuery* _tmp32_;
	AndnsAndnaQuery* query;
	gint32 _tmp33_ = 0;
	gint id;
	GeeArrayList* _tmp34_;
	GeeArrayList* ret;
	AndnsAndnaResolveTCPClient* _tmp35_;
	gint _tmp36_;
	AndnsIAndnaQueryHandler* _tmp37_ = NULL;
	AndnsIAndnaQueryHandler* _tmp38_;
	AndnsAndnaQuery* _tmp39_;
	AndnsAndnaResponse* _tmp40_ = NULL;
	AndnsAndnaResponse* _tmp41_;
	AndnsAndnaResponse* resp;
	AndnsAndnaResponse* _tmp42_;
	AndnsAndnaResponseCode _tmp43_;
	AndnsAndnaResponseCode _tmp44_;
	AndnsAndnaResponse* _tmp45_;
	AndnsAndnaResponseCode _tmp46_;
	AndnsAndnaResponseCode _tmp47_;
	AndnsAndnaResponse* _tmp53_;
	GeeArrayList* _tmp54_;
	GeeArrayList* _tmp55_;
	gint _tmp56_;
	gint _tmp57_;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (node != NULL, NULL);
	g_return_val_if_fail (tcpaddress != NULL, NULL);
	ntkresolv_init ();
	_tmp0_ = _hints;
	if (_tmp0_ == NULL) {
		NtkresolvNtkAddrInfo* _tmp1_;
		NtkresolvNtkAddrInfo* _tmp2_;
		NtkresolvNtkAddrInfo* _tmp3_;
		NtkresolvNtkAddrInfo* _tmp4_;
		_tmp1_ = ntkresolv_ntk_addr_info_new ();
		_g_object_unref0 (hints);
		hints = _tmp1_;
		_tmp2_ = hints;
		_tmp2_->family = NTKRESOLV_IP_FAMILY_IPV4;
		_tmp3_ = hints;
		_tmp3_->protocol = NTKRESOLV_IP_PROTOCOL_IP;
		_tmp4_ = hints;
		_tmp4_->socket_type = NTKRESOLV_SOCKET_TYPE_UNSPEC;
	} else {
		NtkresolvNtkAddrInfo* _tmp5_;
		NtkresolvNtkAddrInfo* _tmp6_;
		_tmp5_ = _hints;
		_tmp6_ = _g_object_ref0 (_tmp5_);
		_g_object_unref0 (hints);
		hints = _tmp6_;
	}
	_tmp7_ = netsukuku_andna_service_key_get_NULL_SERV_KEY ();
	_tmp8_ = _tmp7_;
	_tmp9_ = _g_object_ref0 (_tmp8_);
	serv_key = _tmp9_;
	_tmp11_ = service;
	if (_tmp11_ != NULL) {
		NtkresolvNtkAddrInfo* _tmp12_;
		NtkresolvIpProtocol _tmp13_;
		_tmp12_ = hints;
		_tmp13_ = _tmp12_->protocol;
		_tmp10_ = _tmp13_ != NTKRESOLV_IP_PROTOCOL_IP;
	} else {
		_tmp10_ = FALSE;
	}
	_tmp14_ = _tmp10_;
	if (_tmp14_) {
		const gchar* _tmp15_ = NULL;
		NtkresolvNtkAddrInfo* _tmp16_;
		NtkresolvIpProtocol _tmp17_;
		const gchar* _tmp18_;
		gchar* _tmp19_;
		gchar* proto;
		const gchar* _tmp20_;
		const gchar* _tmp21_;
		NetsukukuAndnaServiceKey* _tmp22_;
		_tmp16_ = hints;
		_tmp17_ = _tmp16_->protocol;
		if (_tmp17_ == NTKRESOLV_IP_PROTOCOL_TCP) {
			_tmp15_ = "tcp";
		} else {
			_tmp15_ = "udp";
		}
		_tmp18_ = _tmp15_;
		_tmp19_ = g_strdup (_tmp18_);
		proto = _tmp19_;
		_tmp20_ = service;
		_tmp21_ = proto;
		_tmp22_ = netsukuku_andna_service_key_new (_tmp20_, _tmp21_);
		_g_object_unref0 (serv_key);
		serv_key = _tmp22_;
		_g_free0 (proto);
	}
	_tmp23_ = tcpaddress;
	_tmp24_ = (guint16) 53000;
	_tmp25_ = andns_andna_resolve_tcp_client_new (_tmp23_, &_tmp24_, NULL, TRUE);
	client = _tmp25_;
	_tmp26_ = client;
	andns_andna_resolve_tcp_client_set_retry_connect (_tmp26_, FALSE);
	_tmp27_ = node;
	_tmp28_ = netsukuku_inet_utils_crypto_hash (_tmp27_);
	_tmp29_ = _tmp28_;
	_tmp30_ = serv_key;
	_tmp31_ = andns_andna_query_new_name_to_ip_ntk (FALSE, FALSE, ANDNS_ANDNA_QUERY_PROTOCOL_TCP, ANDNS_ANDNA_QUERY_IP_VERSION_IPV4, _tmp29_, _tmp30_);
	_tmp32_ = _tmp31_;
	_g_free0 (_tmp29_);
	query = _tmp32_;
	_tmp33_ = g_random_int_range ((gint32) 0, (gint32) 32767);
	id = (gint) _tmp33_;
	_tmp34_ = gee_array_list_new (NTKRESOLV_TYPE_NTK_ADDR_INFO, (GBoxedCopyFunc) g_object_ref, g_object_unref, NULL, NULL, NULL);
	ret = _tmp34_;
	_tmp35_ = client;
	_tmp36_ = id;
	_tmp37_ = andns_iandna_resolve_root_dispatcher_get_query_handler ((AndnsIAndnaResolveRootDispatcher*) _tmp35_, _tmp36_);
	_tmp38_ = _tmp37_;
	_tmp39_ = query;
	_tmp40_ = andns_iandna_query_handler_resolve (_tmp38_, _tmp39_, &_inner_error_);
	_tmp41_ = _tmp40_;
	_g_object_unref0 (_tmp38_);
	resp = _tmp41_;
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		_g_object_unref0 (ret);
		_g_object_unref0 (query);
		_g_object_unref0 (client);
		_g_object_unref0 (serv_key);
		_g_object_unref0 (hints);
		return NULL;
	}
	_tmp42_ = resp;
	_tmp43_ = andns_andna_response_get_rcode (_tmp42_);
	_tmp44_ = _tmp43_;
	if (_tmp44_ == ANDNS_ANDNA_RESPONSE_CODE_NO_DOMAIN) {
		result = (GeeList*) ret;
		_g_object_unref0 (resp);
		_g_object_unref0 (query);
		_g_object_unref0 (client);
		_g_object_unref0 (serv_key);
		_g_object_unref0 (hints);
		return result;
	}
	_tmp45_ = resp;
	_tmp46_ = andns_andna_response_get_rcode (_tmp45_);
	_tmp47_ = _tmp46_;
	if (_tmp47_ != ANDNS_ANDNA_RESPONSE_CODE_NO_ERROR) {
		AndnsAndnaResponse* _tmp48_;
		AndnsAndnaResponseCode _tmp49_;
		AndnsAndnaResponseCode _tmp50_;
		GEnumValue* _tmp51_;
		GError* _tmp52_;
		_tmp48_ = resp;
		_tmp49_ = andns_andna_response_get_rcode (_tmp48_);
		_tmp50_ = _tmp49_;
		_tmp51_ = g_enum_get_value (g_type_class_ref (ANDNS_TYPE_ANDNA_RESPONSE_CODE), _tmp50_);
		_tmp52_ = g_error_new_literal (NTKRESOLV_NTKRESOLV_ERROR, NTKRESOLV_NTKRESOLV_ERROR_GENERIC, (_tmp51_ != NULL) ? _tmp51_->value_name : NULL);
		_inner_error_ = _tmp52_;
		g_propagate_error (error, _inner_error_);
		_g_object_unref0 (resp);
		_g_object_unref0 (ret);
		_g_object_unref0 (query);
		_g_object_unref0 (client);
		_g_object_unref0 (serv_key);
		_g_object_unref0 (hints);
		return NULL;
	}
	_tmp53_ = resp;
	_tmp54_ = andns_andna_response_get_answers (_tmp53_);
	_tmp55_ = _tmp54_;
	_tmp56_ = gee_abstract_collection_get_size ((GeeCollection*) _tmp55_);
	_tmp57_ = _tmp56_;
	if (_tmp57_ == 0) {
		GError* _tmp58_;
		_tmp58_ = g_error_new_literal (NTKRESOLV_NTKRESOLV_ERROR, NTKRESOLV_NTKRESOLV_ERROR_GENERIC, "Response Code is NoError but list is empty.");
		_inner_error_ = _tmp58_;
		g_propagate_error (error, _inner_error_);
		_g_object_unref0 (resp);
		_g_object_unref0 (ret);
		_g_object_unref0 (query);
		_g_object_unref0 (client);
		_g_object_unref0 (serv_key);
		_g_object_unref0 (hints);
		return NULL;
	}
	{
		AndnsAndnaResponse* _tmp59_;
		GeeArrayList* _tmp60_;
		GeeArrayList* _tmp61_;
		GeeArrayList* _tmp62_;
		GeeArrayList* _a_list;
		GeeArrayList* _tmp63_;
		gint _tmp64_;
		gint _tmp65_;
		gint _a_size;
		gint _a_index;
		_tmp59_ = resp;
		_tmp60_ = andns_andna_response_get_answers (_tmp59_);
		_tmp61_ = _tmp60_;
		_tmp62_ = _g_object_ref0 (_tmp61_);
		_a_list = _tmp62_;
		_tmp63_ = _a_list;
		_tmp64_ = gee_abstract_collection_get_size ((GeeCollection*) _tmp63_);
		_tmp65_ = _tmp64_;
		_a_size = _tmp65_;
		_a_index = -1;
		while (TRUE) {
			gint _tmp66_;
			gint _tmp67_;
			gint _tmp68_;
			GeeArrayList* _tmp69_;
			gint _tmp70_;
			gpointer _tmp71_ = NULL;
			AndnsAndnaResponseAnswer* a;
			NtkresolvNtkAddrInfo* _tmp72_;
			NtkresolvNtkAddrInfo* ainfo;
			NtkresolvNtkAddrInfo* _tmp73_;
			NtkresolvNtkAddrInfo* _tmp74_;
			NtkresolvNtkAddrInfo* _tmp75_;
			NtkresolvIpProtocol _tmp76_;
			NtkresolvNtkAddrInfo* _tmp77_;
			NtkresolvNtkAddrInfo* _tmp78_;
			NtkresolvSocketType _tmp79_;
			NtkresolvNtkAddrInfo* _tmp80_;
			AndnsAndnaResponseAnswer* _tmp81_;
			AndnsAndnaResponseAnswer* _tmp82_;
			guint16 _tmp83_;
			guint16 _tmp84_;
			NtkresolvNtkInetAddr* _tmp85_;
			GeeArrayList* _tmp86_;
			NtkresolvNtkAddrInfo* _tmp87_;
			_tmp66_ = _a_index;
			_a_index = _tmp66_ + 1;
			_tmp67_ = _a_index;
			_tmp68_ = _a_size;
			if (!(_tmp67_ < _tmp68_)) {
				break;
			}
			_tmp69_ = _a_list;
			_tmp70_ = _a_index;
			_tmp71_ = gee_abstract_list_get ((GeeAbstractList*) _tmp69_, _tmp70_);
			a = (AndnsAndnaResponseAnswer*) _tmp71_;
			_tmp72_ = ntkresolv_ntk_addr_info_new ();
			ainfo = _tmp72_;
			_tmp73_ = ainfo;
			_tmp73_->family = NTKRESOLV_IP_FAMILY_IPV4;
			_tmp74_ = ainfo;
			_tmp75_ = hints;
			_tmp76_ = _tmp75_->protocol;
			_tmp74_->protocol = _tmp76_;
			_tmp77_ = ainfo;
			_tmp78_ = hints;
			_tmp79_ = _tmp78_->socket_type;
			_tmp77_->socket_type = _tmp79_;
			_tmp80_ = ainfo;
			_tmp81_ = a;
			_tmp82_ = a;
			_tmp83_ = andns_andna_response_answer_get_port_number (_tmp82_);
			_tmp84_ = _tmp83_;
			_tmp85_ = ntkresolv_ntk_inet_addr_new (_tmp81_->ipv4_ip, 4, _tmp84_);
			_g_object_unref0 (_tmp80_->address);
			_tmp80_->address = (NtkresolvNtkAddr*) _tmp85_;
			_tmp86_ = ret;
			_tmp87_ = ainfo;
			gee_abstract_collection_add ((GeeAbstractCollection*) _tmp86_, _tmp87_);
			_g_object_unref0 (ainfo);
			_g_object_unref0 (a);
		}
		_g_object_unref0 (_a_list);
	}
	result = (GeeList*) ret;
	_g_object_unref0 (resp);
	_g_object_unref0 (query);
	_g_object_unref0 (client);
	_g_object_unref0 (serv_key);
	_g_object_unref0 (hints);
	return result;
}


GeeList* ntkresolv_inverse (NtkresolvIpFamily family, NtkresolvNtkAddr* addr, const gchar* tcpaddress, GError** error) {
	GeeList* result = NULL;
	AndnsAndnaQueryIPVersion ipversion;
	guint8* addr_bytes;
	gint addr_bytes_length1;
	gint _addr_bytes_size_;
	NtkresolvIpFamily _tmp0_;
	const gchar* _tmp2_;
	guint16 _tmp3_;
	AndnsAndnaResolveTCPClient* _tmp4_;
	AndnsAndnaResolveTCPClient* client;
	AndnsAndnaResolveTCPClient* _tmp5_;
	AndnsAndnaQueryIPVersion _tmp6_;
	guint8* _tmp7_;
	gint _tmp7__length1;
	AndnsAndnaQuery* _tmp8_;
	AndnsAndnaQuery* query;
	gint32 _tmp9_ = 0;
	gint id;
	GeeArrayList* _tmp10_;
	GeeArrayList* ret;
	AndnsAndnaResolveTCPClient* _tmp11_;
	gint _tmp12_;
	AndnsIAndnaQueryHandler* _tmp13_ = NULL;
	AndnsIAndnaQueryHandler* _tmp14_;
	AndnsAndnaQuery* _tmp15_;
	AndnsAndnaResponse* _tmp16_ = NULL;
	AndnsAndnaResponse* _tmp17_;
	AndnsAndnaResponse* resp;
	AndnsAndnaResponse* _tmp18_;
	AndnsAndnaResponseCode _tmp19_;
	AndnsAndnaResponseCode _tmp20_;
	AndnsAndnaResponse* _tmp21_;
	AndnsAndnaResponseCode _tmp22_;
	AndnsAndnaResponseCode _tmp23_;
	AndnsAndnaResponse* _tmp29_;
	GeeArrayList* _tmp30_;
	GeeArrayList* _tmp31_;
	gint _tmp32_;
	gint _tmp33_;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (addr != NULL, NULL);
	g_return_val_if_fail (tcpaddress != NULL, NULL);
	ntkresolv_init ();
	ipversion = ANDNS_ANDNA_QUERY_IP_VERSION_IPV4;
	addr_bytes = NULL;
	addr_bytes_length1 = 0;
	_addr_bytes_size_ = addr_bytes_length1;
	_tmp0_ = family;
	if (_tmp0_ == NTKRESOLV_IP_FAMILY_IPV6) {
	} else {
		NtkresolvNtkAddr* _tmp1_;
		_tmp1_ = addr;
		addr_bytes = (G_TYPE_CHECK_INSTANCE_TYPE (_tmp1_, NTKRESOLV_TYPE_NTK_INET_ADDR) ? ((NtkresolvNtkInetAddr*) _tmp1_) : NULL)->addr;
		addr_bytes_length1 = 4;
		_addr_bytes_size_ = addr_bytes_length1;
	}
	_tmp2_ = tcpaddress;
	_tmp3_ = (guint16) 53000;
	_tmp4_ = andns_andna_resolve_tcp_client_new (_tmp2_, &_tmp3_, NULL, TRUE);
	client = _tmp4_;
	_tmp5_ = client;
	andns_andna_resolve_tcp_client_set_retry_connect (_tmp5_, FALSE);
	_tmp6_ = ipversion;
	_tmp7_ = addr_bytes;
	_tmp7__length1 = addr_bytes_length1;
	_tmp8_ = andns_andna_query_new_ip_to_name_ntk (FALSE, ANDNS_ANDNA_QUERY_PROTOCOL_TCP, _tmp6_, _tmp7_, _tmp7__length1);
	query = _tmp8_;
	_tmp9_ = g_random_int_range ((gint32) 0, (gint32) 32767);
	id = (gint) _tmp9_;
	_tmp10_ = gee_array_list_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, NULL, NULL, NULL);
	ret = _tmp10_;
	_tmp11_ = client;
	_tmp12_ = id;
	_tmp13_ = andns_iandna_resolve_root_dispatcher_get_query_handler ((AndnsIAndnaResolveRootDispatcher*) _tmp11_, _tmp12_);
	_tmp14_ = _tmp13_;
	_tmp15_ = query;
	_tmp16_ = andns_iandna_query_handler_resolve (_tmp14_, _tmp15_, &_inner_error_);
	_tmp17_ = _tmp16_;
	_g_object_unref0 (_tmp14_);
	resp = _tmp17_;
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		_g_object_unref0 (ret);
		_g_object_unref0 (query);
		_g_object_unref0 (client);
		return NULL;
	}
	_tmp18_ = resp;
	_tmp19_ = andns_andna_response_get_rcode (_tmp18_);
	_tmp20_ = _tmp19_;
	if (_tmp20_ == ANDNS_ANDNA_RESPONSE_CODE_NO_DOMAIN) {
		result = (GeeList*) ret;
		_g_object_unref0 (resp);
		_g_object_unref0 (query);
		_g_object_unref0 (client);
		return result;
	}
	_tmp21_ = resp;
	_tmp22_ = andns_andna_response_get_rcode (_tmp21_);
	_tmp23_ = _tmp22_;
	if (_tmp23_ != ANDNS_ANDNA_RESPONSE_CODE_NO_ERROR) {
		AndnsAndnaResponse* _tmp24_;
		AndnsAndnaResponseCode _tmp25_;
		AndnsAndnaResponseCode _tmp26_;
		GEnumValue* _tmp27_;
		GError* _tmp28_;
		_tmp24_ = resp;
		_tmp25_ = andns_andna_response_get_rcode (_tmp24_);
		_tmp26_ = _tmp25_;
		_tmp27_ = g_enum_get_value (g_type_class_ref (ANDNS_TYPE_ANDNA_RESPONSE_CODE), _tmp26_);
		_tmp28_ = g_error_new_literal (NTKRESOLV_NTKRESOLV_ERROR, NTKRESOLV_NTKRESOLV_ERROR_GENERIC, (_tmp27_ != NULL) ? _tmp27_->value_name : NULL);
		_inner_error_ = _tmp28_;
		g_propagate_error (error, _inner_error_);
		_g_object_unref0 (resp);
		_g_object_unref0 (ret);
		_g_object_unref0 (query);
		_g_object_unref0 (client);
		return NULL;
	}
	_tmp29_ = resp;
	_tmp30_ = andns_andna_response_get_answers (_tmp29_);
	_tmp31_ = _tmp30_;
	_tmp32_ = gee_abstract_collection_get_size ((GeeCollection*) _tmp31_);
	_tmp33_ = _tmp32_;
	if (_tmp33_ == 0) {
		GError* _tmp34_;
		_tmp34_ = g_error_new_literal (NTKRESOLV_NTKRESOLV_ERROR, NTKRESOLV_NTKRESOLV_ERROR_GENERIC, "Response Code is NoError but list is empty.");
		_inner_error_ = _tmp34_;
		g_propagate_error (error, _inner_error_);
		_g_object_unref0 (resp);
		_g_object_unref0 (ret);
		_g_object_unref0 (query);
		_g_object_unref0 (client);
		return NULL;
	}
	{
		AndnsAndnaResponse* _tmp35_;
		GeeArrayList* _tmp36_;
		GeeArrayList* _tmp37_;
		GeeArrayList* _tmp38_;
		GeeArrayList* _a_list;
		GeeArrayList* _tmp39_;
		gint _tmp40_;
		gint _tmp41_;
		gint _a_size;
		gint _a_index;
		_tmp35_ = resp;
		_tmp36_ = andns_andna_response_get_answers (_tmp35_);
		_tmp37_ = _tmp36_;
		_tmp38_ = _g_object_ref0 (_tmp37_);
		_a_list = _tmp38_;
		_tmp39_ = _a_list;
		_tmp40_ = gee_abstract_collection_get_size ((GeeCollection*) _tmp39_);
		_tmp41_ = _tmp40_;
		_a_size = _tmp41_;
		_a_index = -1;
		while (TRUE) {
			gint _tmp42_;
			gint _tmp43_;
			gint _tmp44_;
			GeeArrayList* _tmp45_;
			gint _tmp46_;
			gpointer _tmp47_ = NULL;
			AndnsAndnaResponseAnswer* a;
			GeeArrayList* _tmp48_;
			AndnsAndnaResponseAnswer* _tmp49_;
			const gchar* _tmp50_;
			const gchar* _tmp51_;
			_tmp42_ = _a_index;
			_a_index = _tmp42_ + 1;
			_tmp43_ = _a_index;
			_tmp44_ = _a_size;
			if (!(_tmp43_ < _tmp44_)) {
				break;
			}
			_tmp45_ = _a_list;
			_tmp46_ = _a_index;
			_tmp47_ = gee_abstract_list_get ((GeeAbstractList*) _tmp45_, _tmp46_);
			a = (AndnsAndnaResponseAnswer*) _tmp47_;
			_tmp48_ = ret;
			_tmp49_ = a;
			_tmp50_ = andns_andna_response_answer_get_hostname (_tmp49_);
			_tmp51_ = _tmp50_;
			gee_abstract_collection_add ((GeeAbstractCollection*) _tmp48_, _tmp51_);
			_g_object_unref0 (a);
		}
		_g_object_unref0 (_a_list);
	}
	result = (GeeList*) ret;
	_g_object_unref0 (resp);
	_g_object_unref0 (query);
	_g_object_unref0 (client);
	return result;
}



