/*
 *  This file is part of Netsukuku.
 *  (c) Copyright 2014 Luca Dionisi aka lukisi <luca.dionisi@gmail.com>
 *
 *  Netsukuku is free software: you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation, either version 3 of the License, or
 *  (at your option) any later version.
 *
 *  Netsukuku is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with Netsukuku.  If not, see <http://www.gnu.org/licenses/>.
 */

namespace Ntkresolv.Test
{
    /** This class is associated to a thread that executes its method call_resolv().
      */
    public class ResolvArg : Object
    {
        public string n;
        public bool exited;
        public ResolvArg(string n) {this.n = n; exited = false;}
        public int call_resolv()
        {
            try {
                init();
                print_out(@"try calling: resolv(\"$(n)\");\n");
                Gee.List<NtkAddrInfo> resp = resolv(n);
            } catch (Error e) {
                print_out(@"$(e.message)\n");
            }
            exited = true;
            return 0;
        }
    }

    string logger;
    const bool output = true;
    public void print_out(string s)
    {
        if (output) print(s);
    }

    public class ResolvTester : Object
    {
        public void set_up ()
        {
            logger = "";
        }

        public void tear_down ()
        {
            logger = "";
        }

        public void test_link()
        {
            // This test ensures that the library can be linked to a program.
            // We call one method, but this could fail because there is no
            //  server to respond. This would not invalidate our test. So we
            //  call it in a thread and prepare to ignore it.
            ResolvArg a = new ResolvArg("pippo");
            Thread<int> thread = new Thread<int>.@try ("resolv", a.call_resolv);

            // every 2 milliseconds check if thread exited, for a max of 0.5 seconds.
            Timer timeout = new Timer();
            while (true)
            {
                if (timeout.elapsed() > 0.5) break;
                if (a.exited) break;
                Thread.usleep(2000);
            }
        }

        public static int main(string[] args)
        {
            GLib.Test.init(ref args);
            GLib.Test.add_func ("/Ntkresolv/Linking", () => {
                var x = new ResolvTester();
                x.set_up();
                x.test_link();
                x.tear_down();
            });
            GLib.Test.run();
            return 0;
        }
    }
}
