/* getaddrinfo.c generated by valac 0.20.1, the Vala compiler
 * generated from getaddrinfo.vala, do not modify */

/*
 *  This file is part of Netsukuku.
 *  (c) Copyright 2014 Luca Dionisi aka lukisi <luca.dionisi@gmail.com>
 *
 *  Netsukuku is free software: you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation, either version 3 of the License, or
 *  (at your option) any later version.
 *
 *  Netsukuku is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with Netsukuku.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <netdb.h>
#include <sys/socket.h>
#include <netinet/in.h>
#include <arpa/inet.h>

#define _g_free0(var) (var = (g_free (var), NULL))



void name_to_ip (const gchar* hostname);
void ip_to_name (const gchar* addr);
gint _vala_main (gchar** args, int args_length1);


static const gchar* string_to_string (const gchar* self) {
	const gchar* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	result = self;
	return result;
}


void name_to_ip (const gchar* hostname) {
	struct addrinfo _tmp0_ = {0};
	struct addrinfo hints;
	struct addrinfo* res = NULL;
	const gchar* _tmp1_;
	struct addrinfo _tmp2_;
	struct addrinfo* _tmp3_ = NULL;
	gint _tmp4_ = 0;
	gint r;
	gint _tmp5_;
	g_return_if_fail (hostname != NULL);
	hints = _tmp0_;
	hints.ai_family = AF_UNSPEC;
	hints.ai_socktype = SOCK_STREAM;
	hints.ai_protocol = 0;
	_tmp1_ = hostname;
	_tmp2_ = hints;
	_tmp4_ = getaddrinfo (_tmp1_, NULL, &_tmp2_, &_tmp3_);
	res = _tmp3_;
	r = _tmp4_;
	_tmp5_ = r;
	if (_tmp5_ == 0) {
		struct addrinfo* _tmp6_;
		struct addrinfo* p;
		struct addrinfo* _tmp23_;
		_tmp6_ = res;
		p = _tmp6_;
		while (TRUE) {
			struct addrinfo* _tmp7_;
			struct addrinfo* _tmp8_;
			gint _tmp9_;
			struct addrinfo* _tmp21_;
			struct addrinfo* _tmp22_;
			_tmp7_ = p;
			if (!(_tmp7_ != NULL)) {
				break;
			}
			_tmp8_ = p;
			_tmp9_ = (*_tmp8_).ai_family;
			if (_tmp9_ == AF_INET) {
				struct addrinfo* _tmp10_;
				struct sockaddr* _tmp11_;
				struct sockaddr_in* sa_in;
				struct sockaddr_in* _tmp12_;
				struct in_addr _tmp13_;
				guint32 _tmp14_;
				guint32 ipv4addr;
				guint8 dest[20] = {0};
				const gchar* _tmp15_ = NULL;
				gchar* _tmp16_;
				gchar* ipstr;
				const gchar* _tmp17_;
				const gchar* _tmp18_ = NULL;
				gchar* _tmp19_ = NULL;
				gchar* _tmp20_;
				_tmp10_ = p;
				_tmp11_ = (*_tmp10_).ai_addr;
				sa_in = (struct sockaddr_in*) _tmp11_;
				_tmp12_ = sa_in;
				_tmp13_ = (*_tmp12_).sin_addr;
				_tmp14_ = _tmp13_.s_addr;
				ipv4addr = _tmp14_;
				_tmp15_ = inet_ntop (AF_INET, &ipv4addr, dest, 20);
				_tmp16_ = g_strdup (_tmp15_);
				ipstr = _tmp16_;
				_tmp17_ = ipstr;
				_tmp18_ = string_to_string (_tmp17_);
				_tmp19_ = g_strconcat (" ", _tmp18_, "\n", NULL);
				_tmp20_ = _tmp19_;
				g_print ("%s", _tmp20_);
				_g_free0 (_tmp20_);
				_g_free0 (ipstr);
			} else {
				g_print (" IPv6?\n");
			}
			_tmp21_ = p;
			_tmp22_ = (*_tmp21_).ai_next;
			p = _tmp22_;
		}
		_tmp23_ = res;
		freeaddrinfo (_tmp23_);
	} else {
		gboolean _tmp24_ = FALSE;
		gint _tmp25_;
		gboolean _tmp27_;
		_tmp25_ = r;
		if (_tmp25_ == EAI_NONAME) {
			_tmp24_ = TRUE;
		} else {
			gint _tmp26_;
			_tmp26_ = r;
			_tmp24_ = _tmp26_ == (-5);
		}
		_tmp27_ = _tmp24_;
		if (_tmp27_) {
			const gchar* _tmp28_;
			const gchar* _tmp29_ = NULL;
			gchar* _tmp30_ = NULL;
			gchar* _tmp31_;
			_tmp28_ = hostname;
			_tmp29_ = string_to_string (_tmp28_);
			_tmp30_ = g_strconcat ("Unknown host ", _tmp29_, "\n", NULL);
			_tmp31_ = _tmp30_;
			g_print ("%s", _tmp31_);
			_g_free0 (_tmp31_);
		} else {
			gint _tmp32_;
			gchar* _tmp33_ = NULL;
			gchar* _tmp34_;
			gchar* _tmp35_ = NULL;
			gchar* _tmp36_;
			_tmp32_ = r;
			_tmp33_ = g_strdup_printf ("%i", _tmp32_);
			_tmp34_ = _tmp33_;
			_tmp35_ = g_strconcat ("Unexpected error: ", _tmp34_, "\n", NULL);
			_tmp36_ = _tmp35_;
			g_print ("%s", _tmp36_);
			_g_free0 (_tmp36_);
			_g_free0 (_tmp34_);
		}
	}
	 (&hints);
}


void ip_to_name (const gchar* addr) {
	struct sockaddr_in _tmp0_ = {0};
	struct sockaddr_in sain;
	struct sockaddr_in* sain_p;
	const gchar* _tmp1_;
	gchar node[500] = {0};
	struct sockaddr_in* _tmp2_;
	struct sockaddr* sa_p;
	struct sockaddr* _tmp3_;
	struct sockaddr _tmp4_;
	gint _tmp5_ = 0;
	gint r;
	gint _tmp6_;
	g_return_if_fail (addr != NULL);
	sain = _tmp0_;
	sain_p = &sain;
	sain.sin_family = AF_INET;
	sain.sin_port = (guint16) 0;
	_tmp1_ = addr;
	inet_pton (AF_INET, _tmp1_, &sain.sin_addr);
	_tmp2_ = sain_p;
	sa_p = (struct sockaddr*) _tmp2_;
	_tmp3_ = sa_p;
	_tmp4_ = *_tmp3_;
	_tmp5_ = getnameinfo (&_tmp4_, (socklen_t) sizeof (struct sockaddr_in), node, 500, NULL, 0, NI_NAMEREQD);
	r = _tmp5_;
	_tmp6_ = r;
	if (_tmp6_ == 0) {
		gchar* _tmp7_;
		gchar* s;
		const gchar* _tmp14_;
		const gchar* _tmp15_ = NULL;
		gchar* _tmp16_ = NULL;
		gchar* _tmp17_;
		_tmp7_ = g_strdup ("");
		s = _tmp7_;
		{
			gchar* c_collection = NULL;
			gint c_collection_length1 = 0;
			gint _c_collection_size_ = 0;
			gint c_it = 0;
			c_collection = node;
			c_collection_length1 = 500;
			for (c_it = 0; c_it < 500; c_it = c_it + 1) {
				gchar c = '\0';
				c = c_collection[c_it];
				{
					gchar _tmp8_;
					const gchar* _tmp9_;
					gchar _tmp10_;
					gchar* _tmp11_ = NULL;
					gchar* _tmp12_;
					gchar* _tmp13_;
					_tmp8_ = c;
					if (_tmp8_ == '\0') {
						break;
					}
					_tmp9_ = s;
					_tmp10_ = c;
					_tmp11_ = g_strdup_printf ("%c", _tmp10_);
					_tmp12_ = _tmp11_;
					_tmp13_ = g_strconcat (_tmp9_, _tmp12_, NULL);
					_g_free0 (s);
					s = _tmp13_;
					_g_free0 (_tmp12_);
				}
			}
		}
		_tmp14_ = s;
		_tmp15_ = string_to_string (_tmp14_);
		_tmp16_ = g_strconcat (" ", _tmp15_, "\n", NULL);
		_tmp17_ = _tmp16_;
		g_print ("%s", _tmp17_);
		_g_free0 (_tmp17_);
		_g_free0 (s);
	} else {
		gint _tmp18_;
		_tmp18_ = r;
		if (_tmp18_ == EAI_NONAME) {
			const gchar* _tmp19_;
			const gchar* _tmp20_ = NULL;
			gchar* _tmp21_ = NULL;
			gchar* _tmp22_;
			_tmp19_ = addr;
			_tmp20_ = string_to_string (_tmp19_);
			_tmp21_ = g_strconcat ("Unknown host ", _tmp20_, "\n", NULL);
			_tmp22_ = _tmp21_;
			g_print ("%s", _tmp22_);
			_g_free0 (_tmp22_);
		} else {
			gint _tmp23_;
			_tmp23_ = r;
			if (_tmp23_ == EAI_AGAIN) {
				g_print ("%s", "Error: try again later.\n");
			} else {
				gint _tmp24_;
				gchar* _tmp25_ = NULL;
				gchar* _tmp26_;
				gchar* _tmp27_ = NULL;
				gchar* _tmp28_;
				_tmp24_ = r;
				_tmp25_ = g_strdup_printf ("%i", _tmp24_);
				_tmp26_ = _tmp25_;
				_tmp27_ = g_strconcat ("Unexpected error: ", _tmp26_, "\n", NULL);
				_tmp28_ = _tmp27_;
				g_print ("%s", _tmp28_);
				_g_free0 (_tmp28_);
				_g_free0 (_tmp26_);
			}
		}
	}
	 (&sain);
}


gint _vala_main (gchar** args, int args_length1) {
	gint result = 0;
	gboolean _tmp0_ = FALSE;
	gchar** _tmp1_;
	gint _tmp1__length1;
	gboolean _tmp4_;
	_tmp1_ = args;
	_tmp1__length1 = args_length1;
	if (_tmp1__length1 == 3) {
		gchar** _tmp2_;
		gint _tmp2__length1;
		const gchar* _tmp3_;
		_tmp2_ = args;
		_tmp2__length1 = args_length1;
		_tmp3_ = _tmp2_[1];
		_tmp0_ = g_strcmp0 (_tmp3_, "name") == 0;
	} else {
		_tmp0_ = FALSE;
	}
	_tmp4_ = _tmp0_;
	if (_tmp4_) {
		gchar** _tmp5_;
		gint _tmp5__length1;
		const gchar* _tmp6_;
		_tmp5_ = args;
		_tmp5__length1 = args_length1;
		_tmp6_ = _tmp5_[2];
		name_to_ip (_tmp6_);
	} else {
		gboolean _tmp7_ = FALSE;
		gchar** _tmp8_;
		gint _tmp8__length1;
		gboolean _tmp11_;
		_tmp8_ = args;
		_tmp8__length1 = args_length1;
		if (_tmp8__length1 == 3) {
			gchar** _tmp9_;
			gint _tmp9__length1;
			const gchar* _tmp10_;
			_tmp9_ = args;
			_tmp9__length1 = args_length1;
			_tmp10_ = _tmp9_[1];
			_tmp7_ = g_strcmp0 (_tmp10_, "addr") == 0;
		} else {
			_tmp7_ = FALSE;
		}
		_tmp11_ = _tmp7_;
		if (_tmp11_) {
			gchar** _tmp12_;
			gint _tmp12__length1;
			const gchar* _tmp13_;
			_tmp12_ = args;
			_tmp12__length1 = args_length1;
			_tmp13_ = _tmp12_[2];
			ip_to_name (_tmp13_);
		} else {
			gchar** _tmp14_;
			gint _tmp14__length1;
			const gchar* _tmp15_;
			const gchar* _tmp16_ = NULL;
			gchar** _tmp17_;
			gint _tmp17__length1;
			const gchar* _tmp18_;
			const gchar* _tmp19_ = NULL;
			gchar* _tmp20_ = NULL;
			gchar* _tmp21_;
			_tmp14_ = args;
			_tmp14__length1 = args_length1;
			_tmp15_ = _tmp14_[0];
			_tmp16_ = string_to_string (_tmp15_);
			_tmp17_ = args;
			_tmp17__length1 = args_length1;
			_tmp18_ = _tmp17_[0];
			_tmp19_ = string_to_string (_tmp18_);
			_tmp20_ = g_strconcat ("usage:  ", _tmp16_, " name <hostname>   ||   ", _tmp19_, " addr <ip>\n", NULL);
			_tmp21_ = _tmp20_;
			g_print ("%s", _tmp21_);
			_g_free0 (_tmp21_);
			result = 1;
			return result;
		}
	}
	result = 0;
	return result;
}


int main (int argc, char ** argv) {
	g_type_init ();
	return _vala_main (argv, argc);
}



