/* tasklet_blocking_sockets.c generated by valac 0.20.1, the Vala compiler
 * generated from tasklet_blocking_sockets.vala, do not modify */

/*
 *  This file is part of Netsukuku.
 *  (c) Copyright 2011 Luca Dionisi aka lukisi <luca.dionisi@gmail.com>
 *
 *  Netsukuku is free software: you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation, either version 3 of the License, or
 *  (at your option) any later version.
 *
 *  Netsukuku is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with Netsukuku.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <netinet/in.h>
#include <arpa/inet.h>
#include <gio/gio.h>
#include <linux/if.h>
#include <sys/socket.h>
#include <errno.h>


#define TASKLETS_TYPE_ICONNECTED_STREAM_SOCKET (tasklets_iconnected_stream_socket_get_type ())
#define TASKLETS_ICONNECTED_STREAM_SOCKET(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TASKLETS_TYPE_ICONNECTED_STREAM_SOCKET, TaskletsIConnectedStreamSocket))
#define TASKLETS_IS_ICONNECTED_STREAM_SOCKET(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TASKLETS_TYPE_ICONNECTED_STREAM_SOCKET))
#define TASKLETS_ICONNECTED_STREAM_SOCKET_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), TASKLETS_TYPE_ICONNECTED_STREAM_SOCKET, TaskletsIConnectedStreamSocketIface))

typedef struct _TaskletsIConnectedStreamSocket TaskletsIConnectedStreamSocket;
typedef struct _TaskletsIConnectedStreamSocketIface TaskletsIConnectedStreamSocketIface;

#define TASKLETS_TYPE_SERVER_STREAM_SOCKET (tasklets_server_stream_socket_get_type ())
#define TASKLETS_SERVER_STREAM_SOCKET(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TASKLETS_TYPE_SERVER_STREAM_SOCKET, TaskletsServerStreamSocket))
#define TASKLETS_SERVER_STREAM_SOCKET_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TASKLETS_TYPE_SERVER_STREAM_SOCKET, TaskletsServerStreamSocketClass))
#define TASKLETS_IS_SERVER_STREAM_SOCKET(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TASKLETS_TYPE_SERVER_STREAM_SOCKET))
#define TASKLETS_IS_SERVER_STREAM_SOCKET_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TASKLETS_TYPE_SERVER_STREAM_SOCKET))
#define TASKLETS_SERVER_STREAM_SOCKET_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TASKLETS_TYPE_SERVER_STREAM_SOCKET, TaskletsServerStreamSocketClass))

typedef struct _TaskletsServerStreamSocket TaskletsServerStreamSocket;
typedef struct _TaskletsServerStreamSocketClass TaskletsServerStreamSocketClass;
typedef struct _TaskletsServerStreamSocketPrivate TaskletsServerStreamSocketPrivate;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

#define TASKLETS_TYPE_CONNECTED_STREAM_SOCKET (tasklets_connected_stream_socket_get_type ())
#define TASKLETS_CONNECTED_STREAM_SOCKET(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TASKLETS_TYPE_CONNECTED_STREAM_SOCKET, TaskletsConnectedStreamSocket))
#define TASKLETS_CONNECTED_STREAM_SOCKET_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TASKLETS_TYPE_CONNECTED_STREAM_SOCKET, TaskletsConnectedStreamSocketClass))
#define TASKLETS_IS_CONNECTED_STREAM_SOCKET(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TASKLETS_TYPE_CONNECTED_STREAM_SOCKET))
#define TASKLETS_IS_CONNECTED_STREAM_SOCKET_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TASKLETS_TYPE_CONNECTED_STREAM_SOCKET))
#define TASKLETS_CONNECTED_STREAM_SOCKET_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TASKLETS_TYPE_CONNECTED_STREAM_SOCKET, TaskletsConnectedStreamSocketClass))

typedef struct _TaskletsConnectedStreamSocket TaskletsConnectedStreamSocket;
typedef struct _TaskletsConnectedStreamSocketClass TaskletsConnectedStreamSocketClass;

#define TASKLETS_TYPE_CLIENT_STREAM_SOCKET (tasklets_client_stream_socket_get_type ())
#define TASKLETS_CLIENT_STREAM_SOCKET(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TASKLETS_TYPE_CLIENT_STREAM_SOCKET, TaskletsClientStreamSocket))
#define TASKLETS_CLIENT_STREAM_SOCKET_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TASKLETS_TYPE_CLIENT_STREAM_SOCKET, TaskletsClientStreamSocketClass))
#define TASKLETS_IS_CLIENT_STREAM_SOCKET(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TASKLETS_TYPE_CLIENT_STREAM_SOCKET))
#define TASKLETS_IS_CLIENT_STREAM_SOCKET_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TASKLETS_TYPE_CLIENT_STREAM_SOCKET))
#define TASKLETS_CLIENT_STREAM_SOCKET_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TASKLETS_TYPE_CLIENT_STREAM_SOCKET, TaskletsClientStreamSocketClass))

typedef struct _TaskletsClientStreamSocket TaskletsClientStreamSocket;
typedef struct _TaskletsClientStreamSocketClass TaskletsClientStreamSocketClass;
typedef struct _TaskletsClientStreamSocketPrivate TaskletsClientStreamSocketPrivate;
typedef struct _TaskletsConnectedStreamSocketPrivate TaskletsConnectedStreamSocketPrivate;
#define _g_free0(var) (var = (g_free (var), NULL))

#define TASKLETS_TYPE_SERVER_DATAGRAM_SOCKET (tasklets_server_datagram_socket_get_type ())
#define TASKLETS_SERVER_DATAGRAM_SOCKET(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TASKLETS_TYPE_SERVER_DATAGRAM_SOCKET, TaskletsServerDatagramSocket))
#define TASKLETS_SERVER_DATAGRAM_SOCKET_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TASKLETS_TYPE_SERVER_DATAGRAM_SOCKET, TaskletsServerDatagramSocketClass))
#define TASKLETS_IS_SERVER_DATAGRAM_SOCKET(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TASKLETS_TYPE_SERVER_DATAGRAM_SOCKET))
#define TASKLETS_IS_SERVER_DATAGRAM_SOCKET_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TASKLETS_TYPE_SERVER_DATAGRAM_SOCKET))
#define TASKLETS_SERVER_DATAGRAM_SOCKET_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TASKLETS_TYPE_SERVER_DATAGRAM_SOCKET, TaskletsServerDatagramSocketClass))

typedef struct _TaskletsServerDatagramSocket TaskletsServerDatagramSocket;
typedef struct _TaskletsServerDatagramSocketClass TaskletsServerDatagramSocketClass;
typedef struct _TaskletsServerDatagramSocketPrivate TaskletsServerDatagramSocketPrivate;

#define TASKLETS_TYPE_BROADCAST_CLIENT_DATAGRAM_SOCKET (tasklets_broadcast_client_datagram_socket_get_type ())
#define TASKLETS_BROADCAST_CLIENT_DATAGRAM_SOCKET(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TASKLETS_TYPE_BROADCAST_CLIENT_DATAGRAM_SOCKET, TaskletsBroadcastClientDatagramSocket))
#define TASKLETS_BROADCAST_CLIENT_DATAGRAM_SOCKET_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TASKLETS_TYPE_BROADCAST_CLIENT_DATAGRAM_SOCKET, TaskletsBroadcastClientDatagramSocketClass))
#define TASKLETS_IS_BROADCAST_CLIENT_DATAGRAM_SOCKET(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TASKLETS_TYPE_BROADCAST_CLIENT_DATAGRAM_SOCKET))
#define TASKLETS_IS_BROADCAST_CLIENT_DATAGRAM_SOCKET_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TASKLETS_TYPE_BROADCAST_CLIENT_DATAGRAM_SOCKET))
#define TASKLETS_BROADCAST_CLIENT_DATAGRAM_SOCKET_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TASKLETS_TYPE_BROADCAST_CLIENT_DATAGRAM_SOCKET, TaskletsBroadcastClientDatagramSocketClass))

typedef struct _TaskletsBroadcastClientDatagramSocket TaskletsBroadcastClientDatagramSocket;
typedef struct _TaskletsBroadcastClientDatagramSocketClass TaskletsBroadcastClientDatagramSocketClass;
typedef struct _TaskletsBroadcastClientDatagramSocketPrivate TaskletsBroadcastClientDatagramSocketPrivate;
#define _vala_assert(expr, msg) if G_LIKELY (expr) ; else g_assertion_message_expr (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);

struct _TaskletsIConnectedStreamSocketIface {
	GTypeInterface parent_iface;
	guint16 (*_peer_port_getter) (TaskletsIConnectedStreamSocket* self);
	const gchar* (*_peer_address_getter) (TaskletsIConnectedStreamSocket* self);
	guint16 (*_my_port_getter) (TaskletsIConnectedStreamSocket* self);
	const gchar* (*_my_address_getter) (TaskletsIConnectedStreamSocket* self);
	gint (*send_part) (TaskletsIConnectedStreamSocket* self, guchar* data, int data_length1, gint maxlen, GError** error);
	guchar* (*recv) (TaskletsIConnectedStreamSocket* self, gint maxlen, int* result_length1, GError** error);
	void (*close) (TaskletsIConnectedStreamSocket* self, GError** error);
};

struct _TaskletsServerStreamSocket {
	GObject parent_instance;
	TaskletsServerStreamSocketPrivate * priv;
};

struct _TaskletsServerStreamSocketClass {
	GObjectClass parent_class;
};

struct _TaskletsServerStreamSocketPrivate {
	GSocket* s;
};

struct _TaskletsClientStreamSocket {
	GObject parent_instance;
	TaskletsClientStreamSocketPrivate * priv;
};

struct _TaskletsClientStreamSocketClass {
	GObjectClass parent_class;
};

struct _TaskletsClientStreamSocketPrivate {
	GSocket* s;
};

struct _TaskletsConnectedStreamSocket {
	GObject parent_instance;
	TaskletsConnectedStreamSocketPrivate * priv;
};

struct _TaskletsConnectedStreamSocketClass {
	GObjectClass parent_class;
};

struct _TaskletsConnectedStreamSocketPrivate {
	GSocket* s;
	gchar* remote_addr;
	guint16 remote_port;
	gchar* local_addr;
	guint16 local_port;
};

struct _TaskletsServerDatagramSocket {
	GObject parent_instance;
	TaskletsServerDatagramSocketPrivate * priv;
};

struct _TaskletsServerDatagramSocketClass {
	GObjectClass parent_class;
};

struct _TaskletsServerDatagramSocketPrivate {
	GSocket* s;
};

struct _TaskletsBroadcastClientDatagramSocket {
	GObject parent_instance;
	TaskletsBroadcastClientDatagramSocketPrivate * priv;
};

struct _TaskletsBroadcastClientDatagramSocketClass {
	GObjectClass parent_class;
};

struct _TaskletsBroadcastClientDatagramSocketPrivate {
	GSocket* s;
	guint16 port;
	gchar* _dev;
};


static gpointer tasklets_server_stream_socket_parent_class = NULL;
static gpointer tasklets_client_stream_socket_parent_class = NULL;
static gpointer tasklets_connected_stream_socket_parent_class = NULL;
static TaskletsIConnectedStreamSocketIface* tasklets_connected_stream_socket_tasklets_iconnected_stream_socket_parent_iface = NULL;
static gpointer tasklets_server_datagram_socket_parent_class = NULL;
static gpointer tasklets_broadcast_client_datagram_socket_parent_class = NULL;

gchar* tasklets_s_addr_to_string (const gchar* family, guint32 s_addr);
guint32 tasklets_string_to_s_addr (const gchar* family, const gchar* dotted);
gchar* tasklets_pip_to_dotted (const gchar* family, guchar* pip, int pip_length1);
guchar* tasklets_dotted_to_pip (const gchar* family, const gchar* dotted, int* result_length1);
GType tasklets_iconnected_stream_socket_get_type (void) G_GNUC_CONST;
guint16 _tasklets_iconnected_stream_socket_peer_port_getter (TaskletsIConnectedStreamSocket* self);
const gchar* _tasklets_iconnected_stream_socket_peer_address_getter (TaskletsIConnectedStreamSocket* self);
guint16 _tasklets_iconnected_stream_socket_my_port_getter (TaskletsIConnectedStreamSocket* self);
const gchar* _tasklets_iconnected_stream_socket_my_address_getter (TaskletsIConnectedStreamSocket* self);
void tasklets_iconnected_stream_socket_send (TaskletsIConnectedStreamSocket* self, guchar* data, int data_length1, GError** error);
gint tasklets_iconnected_stream_socket_send_part (TaskletsIConnectedStreamSocket* self, guchar* data, int data_length1, gint maxlen, GError** error);
guchar* tasklets_iconnected_stream_socket_recv (TaskletsIConnectedStreamSocket* self, gint maxlen, int* result_length1, GError** error);
void tasklets_iconnected_stream_socket_close (TaskletsIConnectedStreamSocket* self, GError** error);
guint16 tasklets_iconnected_stream_socket_get_peer_port (TaskletsIConnectedStreamSocket* self);
const gchar* tasklets_iconnected_stream_socket_get_peer_address (TaskletsIConnectedStreamSocket* self);
guint16 tasklets_iconnected_stream_socket_get_my_port (TaskletsIConnectedStreamSocket* self);
const gchar* tasklets_iconnected_stream_socket_get_my_address (TaskletsIConnectedStreamSocket* self);
GType tasklets_server_stream_socket_get_type (void) G_GNUC_CONST;
#define TASKLETS_SERVER_STREAM_SOCKET_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TASKLETS_TYPE_SERVER_STREAM_SOCKET, TaskletsServerStreamSocketPrivate))
enum  {
	TASKLETS_SERVER_STREAM_SOCKET_DUMMY_PROPERTY
};
void tasklets_server_stream_socket_close (TaskletsServerStreamSocket* self, GError** error);
TaskletsServerStreamSocket* tasklets_server_stream_socket_new (guint16 port, gint backlog, const gchar* my_addr, GError** error);
TaskletsServerStreamSocket* tasklets_server_stream_socket_construct (GType object_type, guint16 port, gint backlog, const gchar* my_addr, GError** error);
TaskletsIConnectedStreamSocket* tasklets_server_stream_socket_accept (TaskletsServerStreamSocket* self, GError** error);
void tasklets_tasklet_tasklet_leaves (const gchar* reason);
GSocket* wrapped_lib_pth_pth_thread_socket_accept (GSocket* s, GError** error);
void tasklets_tasklet_tasklet_regains (const gchar* reason);
TaskletsConnectedStreamSocket* tasklets_connected_stream_socket_new (GSocket* soc, GError** error);
TaskletsConnectedStreamSocket* tasklets_connected_stream_socket_construct (GType object_type, GSocket* soc, GError** error);
GType tasklets_connected_stream_socket_get_type (void) G_GNUC_CONST;
static void tasklets_server_stream_socket_finalize (GObject* obj);
GType tasklets_client_stream_socket_get_type (void) G_GNUC_CONST;
#define TASKLETS_CLIENT_STREAM_SOCKET_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TASKLETS_TYPE_CLIENT_STREAM_SOCKET, TaskletsClientStreamSocketPrivate))
enum  {
	TASKLETS_CLIENT_STREAM_SOCKET_DUMMY_PROPERTY
};
TaskletsClientStreamSocket* tasklets_client_stream_socket_new (const gchar* my_addr, GError** error);
TaskletsClientStreamSocket* tasklets_client_stream_socket_construct (GType object_type, const gchar* my_addr, GError** error);
TaskletsIConnectedStreamSocket* tasklets_client_stream_socket_socket_connect (TaskletsClientStreamSocket* self, const gchar* addr, guint16 port, GError** error);
void wrapped_lib_pth_pth_thread_socket_connect (GSocket* s, const gchar* address, guint16 port, GError** error);
static void tasklets_client_stream_socket_finalize (GObject* obj);
#define TASKLETS_CONNECTED_STREAM_SOCKET_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TASKLETS_TYPE_CONNECTED_STREAM_SOCKET, TaskletsConnectedStreamSocketPrivate))
enum  {
	TASKLETS_CONNECTED_STREAM_SOCKET_DUMMY_PROPERTY
};
static guint16 tasklets_connected_stream_socket_real__peer_port_getter (TaskletsIConnectedStreamSocket* base);
static const gchar* tasklets_connected_stream_socket_real__peer_address_getter (TaskletsIConnectedStreamSocket* base);
static guint16 tasklets_connected_stream_socket_real__my_port_getter (TaskletsIConnectedStreamSocket* base);
static const gchar* tasklets_connected_stream_socket_real__my_address_getter (TaskletsIConnectedStreamSocket* base);
static gint tasklets_connected_stream_socket_real_send_part (TaskletsIConnectedStreamSocket* base, guchar* data, int data_length1, gint maxlen, GError** error);
gssize wrapped_lib_pth_pth_thread_socket_send (GSocket* s, guchar* data, int data_length1, GError** error);
static guchar* tasklets_connected_stream_socket_real_recv (TaskletsIConnectedStreamSocket* base, gint maxlen, int* result_length1, GError** error);
gssize wrapped_lib_pth_pth_thread_socket_recv (GSocket* s, guchar** data, int* data_length1, gint maxlen, GError** error);
static void tasklets_connected_stream_socket_real_close (TaskletsIConnectedStreamSocket* base, GError** error);
static void tasklets_connected_stream_socket_finalize (GObject* obj);
GType tasklets_server_datagram_socket_get_type (void) G_GNUC_CONST;
#define TASKLETS_SERVER_DATAGRAM_SOCKET_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TASKLETS_TYPE_SERVER_DATAGRAM_SOCKET, TaskletsServerDatagramSocketPrivate))
enum  {
	TASKLETS_SERVER_DATAGRAM_SOCKET_DUMMY_PROPERTY
};
void tasklets_server_datagram_socket_close (TaskletsServerDatagramSocket* self, GError** error);
TaskletsServerDatagramSocket* tasklets_server_datagram_socket_new (guint16 port, const gchar* bind_ip, const gchar* dev, GError** error);
TaskletsServerDatagramSocket* tasklets_server_datagram_socket_construct (GType object_type, guint16 port, const gchar* bind_ip, const gchar* dev, GError** error);
void tasklets_sk_bindtodevice (GSocket* s, const gchar* ifname, GError** error);
guchar* tasklets_server_datagram_socket_recvfrom (TaskletsServerDatagramSocket* self, gint maxsize, gchar** rmt_ip, guint16* rmt_port, int* result_length1, GError** error);
gssize wrapped_lib_pth_pth_thread_socket_recvfrom (GSocket* s, guchar** data, int* data_length1, gint maxlen, gchar** rmt_ip, guint16* rmt_port, GError** error);
void tasklets_server_datagram_socket_sendto (TaskletsServerDatagramSocket* self, guchar* mesg, int mesg_length1, const gchar* rmt_ip, guint16 rmt_port, GError** error);
gssize wrapped_lib_pth_pth_thread_socket_sendto (GSocket* s, guchar* data, int data_length1, const gchar* address, guint16 port, GError** error);
static void tasklets_server_datagram_socket_finalize (GObject* obj);
GType tasklets_broadcast_client_datagram_socket_get_type (void) G_GNUC_CONST;
#define TASKLETS_BROADCAST_CLIENT_DATAGRAM_SOCKET_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TASKLETS_TYPE_BROADCAST_CLIENT_DATAGRAM_SOCKET, TaskletsBroadcastClientDatagramSocketPrivate))
enum  {
	TASKLETS_BROADCAST_CLIENT_DATAGRAM_SOCKET_DUMMY_PROPERTY,
	TASKLETS_BROADCAST_CLIENT_DATAGRAM_SOCKET_DEV
};
TaskletsBroadcastClientDatagramSocket* tasklets_broadcast_client_datagram_socket_new (const gchar* dev, guint16 port, GError** error);
TaskletsBroadcastClientDatagramSocket* tasklets_broadcast_client_datagram_socket_construct (GType object_type, const gchar* dev, guint16 port, GError** error);
static void tasklets_broadcast_client_datagram_socket_set_dev (TaskletsBroadcastClientDatagramSocket* self, const gchar* value);
void tasklets_sk_setbroadcast (GSocket* s, GError** error);
void tasklets_broadcast_client_datagram_socket_send (TaskletsBroadcastClientDatagramSocket* self, guchar* mesg, int mesg_length1, GError** error);
void tasklets_broadcast_client_datagram_socket_close (TaskletsBroadcastClientDatagramSocket* self, GError** error);
const gchar* tasklets_broadcast_client_datagram_socket_get_dev (TaskletsBroadcastClientDatagramSocket* self);
static void tasklets_broadcast_client_datagram_socket_finalize (GObject* obj);
static void _vala_tasklets_broadcast_client_datagram_socket_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void _vala_tasklets_broadcast_client_datagram_socket_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);


/** Emulate inet_ntop and pton. In python we have:
            >>> socket.inet_ntop(socket.AF_INET,'1234')
            '49.50.51.52'
            >>> socket.inet_pton(socket.AF_INET,'49.50.51.52')
            '1234'
      * These emulation will work only with IPV4.
      * For now this is not a problem because IPV6 is currently disabled.
      */
gchar* tasklets_s_addr_to_string (const gchar* family, guint32 s_addr) {
	gchar* result = NULL;
	const gchar* _tmp0_;
	struct sockaddr_in saddr = {0};
	guint32 _tmp1_;
	guint32 _tmp2_ = 0U;
	struct sockaddr_in _tmp3_;
	struct in_addr _tmp4_;
	const gchar* _tmp5_ = NULL;
	gchar* _tmp6_;
#line 37 "/home/luca/repo/wip/tasklet/tasklet_blocking_sockets.vala"
	g_return_val_if_fail (family != NULL, NULL);
#line 39 "/home/luca/repo/wip/tasklet/tasklet_blocking_sockets.vala"
	_tmp0_ = family;
#line 39 "/home/luca/repo/wip/tasklet/tasklet_blocking_sockets.vala"
	_vala_assert (g_strcmp0 (_tmp0_, "AF_INET") == 0, "family == \"AF_INET\"");
#line 40 "/home/luca/repo/wip/tasklet/tasklet_blocking_sockets.vala"
	memset (&saddr, 0, sizeof (struct sockaddr_in));
#line 41 "/home/luca/repo/wip/tasklet/tasklet_blocking_sockets.vala"
	_tmp1_ = s_addr;
#line 41 "/home/luca/repo/wip/tasklet/tasklet_blocking_sockets.vala"
	_tmp2_ = htonl (_tmp1_);
#line 41 "/home/luca/repo/wip/tasklet/tasklet_blocking_sockets.vala"
	saddr.sin_addr.s_addr = _tmp2_;
#line 42 "/home/luca/repo/wip/tasklet/tasklet_blocking_sockets.vala"
	_tmp3_ = saddr;
#line 42 "/home/luca/repo/wip/tasklet/tasklet_blocking_sockets.vala"
	_tmp4_ = _tmp3_.sin_addr;
#line 42 "/home/luca/repo/wip/tasklet/tasklet_blocking_sockets.vala"
	_tmp5_ = inet_ntoa (_tmp4_);
#line 42 "/home/luca/repo/wip/tasklet/tasklet_blocking_sockets.vala"
	_tmp6_ = g_strdup (_tmp5_);
#line 42 "/home/luca/repo/wip/tasklet/tasklet_blocking_sockets.vala"
	result = _tmp6_;
#line 42 "/home/luca/repo/wip/tasklet/tasklet_blocking_sockets.vala"
	 (&saddr);
#line 42 "/home/luca/repo/wip/tasklet/tasklet_blocking_sockets.vala"
	return result;
#line 326 "tasklet_blocking_sockets.c"
}


guint32 tasklets_string_to_s_addr (const gchar* family, const gchar* dotted) {
	guint32 result = 0U;
	const gchar* _tmp0_;
	const gchar* _tmp1_;
	guint32 _tmp2_ = 0U;
	guint32 _tmp3_ = 0U;
#line 44 "/home/luca/repo/wip/tasklet/tasklet_blocking_sockets.vala"
	g_return_val_if_fail (family != NULL, 0U);
#line 44 "/home/luca/repo/wip/tasklet/tasklet_blocking_sockets.vala"
	g_return_val_if_fail (dotted != NULL, 0U);
#line 46 "/home/luca/repo/wip/tasklet/tasklet_blocking_sockets.vala"
	_tmp0_ = family;
#line 46 "/home/luca/repo/wip/tasklet/tasklet_blocking_sockets.vala"
	_vala_assert (g_strcmp0 (_tmp0_, "AF_INET") == 0, "family == \"AF_INET\"");
#line 47 "/home/luca/repo/wip/tasklet/tasklet_blocking_sockets.vala"
	_tmp1_ = dotted;
#line 47 "/home/luca/repo/wip/tasklet/tasklet_blocking_sockets.vala"
	_tmp2_ = inet_addr (_tmp1_);
#line 47 "/home/luca/repo/wip/tasklet/tasklet_blocking_sockets.vala"
	_tmp3_ = ntohl (_tmp2_);
#line 47 "/home/luca/repo/wip/tasklet/tasklet_blocking_sockets.vala"
	result = _tmp3_;
#line 47 "/home/luca/repo/wip/tasklet/tasklet_blocking_sockets.vala"
	return result;
#line 354 "tasklet_blocking_sockets.c"
}


gchar* tasklets_pip_to_dotted (const gchar* family, guchar* pip, int pip_length1) {
	gchar* result = NULL;
	guchar* _tmp0_;
	gint _tmp0__length1;
	guchar* _tmp1_;
	gint _tmp1__length1;
	guchar _tmp2_;
	gint a1;
	guchar* _tmp3_;
	gint _tmp3__length1;
	guchar _tmp4_;
	gint a2;
	guchar* _tmp5_;
	gint _tmp5__length1;
	guchar _tmp6_;
	gint a3;
	guchar* _tmp7_;
	gint _tmp7__length1;
	guchar _tmp8_;
	gint a4;
	guint32 s_addr;
	const gchar* _tmp9_;
	gchar* _tmp10_ = NULL;
#line 49 "/home/luca/repo/wip/tasklet/tasklet_blocking_sockets.vala"
	g_return_val_if_fail (family != NULL, NULL);
#line 51 "/home/luca/repo/wip/tasklet/tasklet_blocking_sockets.vala"
	_tmp0_ = pip;
#line 51 "/home/luca/repo/wip/tasklet/tasklet_blocking_sockets.vala"
	_tmp0__length1 = pip_length1;
#line 51 "/home/luca/repo/wip/tasklet/tasklet_blocking_sockets.vala"
	_vala_assert (_tmp0__length1 == 4, "pip.length == 4");
#line 52 "/home/luca/repo/wip/tasklet/tasklet_blocking_sockets.vala"
	_tmp1_ = pip;
#line 52 "/home/luca/repo/wip/tasklet/tasklet_blocking_sockets.vala"
	_tmp1__length1 = pip_length1;
#line 52 "/home/luca/repo/wip/tasklet/tasklet_blocking_sockets.vala"
	_tmp2_ = _tmp1_[0];
#line 52 "/home/luca/repo/wip/tasklet/tasklet_blocking_sockets.vala"
	a1 = (gint) _tmp2_;
#line 53 "/home/luca/repo/wip/tasklet/tasklet_blocking_sockets.vala"
	_tmp3_ = pip;
#line 53 "/home/luca/repo/wip/tasklet/tasklet_blocking_sockets.vala"
	_tmp3__length1 = pip_length1;
#line 53 "/home/luca/repo/wip/tasklet/tasklet_blocking_sockets.vala"
	_tmp4_ = _tmp3_[1];
#line 53 "/home/luca/repo/wip/tasklet/tasklet_blocking_sockets.vala"
	a2 = (gint) _tmp4_;
#line 54 "/home/luca/repo/wip/tasklet/tasklet_blocking_sockets.vala"
	_tmp5_ = pip;
#line 54 "/home/luca/repo/wip/tasklet/tasklet_blocking_sockets.vala"
	_tmp5__length1 = pip_length1;
#line 54 "/home/luca/repo/wip/tasklet/tasklet_blocking_sockets.vala"
	_tmp6_ = _tmp5_[2];
#line 54 "/home/luca/repo/wip/tasklet/tasklet_blocking_sockets.vala"
	a3 = (gint) _tmp6_;
#line 55 "/home/luca/repo/wip/tasklet/tasklet_blocking_sockets.vala"
	_tmp7_ = pip;
#line 55 "/home/luca/repo/wip/tasklet/tasklet_blocking_sockets.vala"
	_tmp7__length1 = pip_length1;
#line 55 "/home/luca/repo/wip/tasklet/tasklet_blocking_sockets.vala"
	_tmp8_ = _tmp7_[3];
#line 55 "/home/luca/repo/wip/tasklet/tasklet_blocking_sockets.vala"
	a4 = (gint) _tmp8_;
#line 56 "/home/luca/repo/wip/tasklet/tasklet_blocking_sockets.vala"
	s_addr = (guint32) (((a4 + (a3 * 256)) + ((a2 * 256) * 256)) + (((a1 * 256) * 256) * 256));
#line 57 "/home/luca/repo/wip/tasklet/tasklet_blocking_sockets.vala"
	_tmp9_ = family;
#line 57 "/home/luca/repo/wip/tasklet/tasklet_blocking_sockets.vala"
	_tmp10_ = tasklets_s_addr_to_string (_tmp9_, s_addr);
#line 57 "/home/luca/repo/wip/tasklet/tasklet_blocking_sockets.vala"
	result = _tmp10_;
#line 57 "/home/luca/repo/wip/tasklet/tasklet_blocking_sockets.vala"
	return result;
#line 431 "tasklet_blocking_sockets.c"
}


guchar* tasklets_dotted_to_pip (const gchar* family, const gchar* dotted, int* result_length1) {
	guchar* result = NULL;
	const gchar* _tmp0_;
	const gchar* _tmp1_;
	guint32 _tmp2_ = 0U;
	guint32 s_addr;
	guint32 _tmp3_;
	gint a1;
	guint32 _tmp4_;
	guint32 _tmp5_;
	gint a2;
	guint32 _tmp6_;
	guint32 _tmp7_;
	gint a3;
	guint32 _tmp8_;
	guint32 _tmp9_;
	gint a4;
	guchar c1;
	guchar c2;
	guchar c3;
	guchar c4;
	guchar* _tmp10_ = NULL;
	guchar* ret;
	gint ret_length1;
	gint _ret_size_;
	guchar* _tmp11_;
	gint _tmp11__length1;
#line 59 "/home/luca/repo/wip/tasklet/tasklet_blocking_sockets.vala"
	g_return_val_if_fail (family != NULL, NULL);
#line 59 "/home/luca/repo/wip/tasklet/tasklet_blocking_sockets.vala"
	g_return_val_if_fail (dotted != NULL, NULL);
#line 61 "/home/luca/repo/wip/tasklet/tasklet_blocking_sockets.vala"
	_tmp0_ = family;
#line 61 "/home/luca/repo/wip/tasklet/tasklet_blocking_sockets.vala"
	_tmp1_ = dotted;
#line 61 "/home/luca/repo/wip/tasklet/tasklet_blocking_sockets.vala"
	_tmp2_ = tasklets_string_to_s_addr (_tmp0_, _tmp1_);
#line 61 "/home/luca/repo/wip/tasklet/tasklet_blocking_sockets.vala"
	s_addr = _tmp2_;
#line 62 "/home/luca/repo/wip/tasklet/tasklet_blocking_sockets.vala"
	_tmp3_ = s_addr;
#line 62 "/home/luca/repo/wip/tasklet/tasklet_blocking_sockets.vala"
	a1 = (gint) (_tmp3_ / ((256 * 256) * 256));
#line 63 "/home/luca/repo/wip/tasklet/tasklet_blocking_sockets.vala"
	_tmp4_ = s_addr;
#line 63 "/home/luca/repo/wip/tasklet/tasklet_blocking_sockets.vala"
	s_addr = _tmp4_ - (((a1 * 256) * 256) * 256);
#line 64 "/home/luca/repo/wip/tasklet/tasklet_blocking_sockets.vala"
	_tmp5_ = s_addr;
#line 64 "/home/luca/repo/wip/tasklet/tasklet_blocking_sockets.vala"
	a2 = (gint) (_tmp5_ / (256 * 256));
#line 65 "/home/luca/repo/wip/tasklet/tasklet_blocking_sockets.vala"
	_tmp6_ = s_addr;
#line 65 "/home/luca/repo/wip/tasklet/tasklet_blocking_sockets.vala"
	s_addr = _tmp6_ - ((a2 * 256) * 256);
#line 66 "/home/luca/repo/wip/tasklet/tasklet_blocking_sockets.vala"
	_tmp7_ = s_addr;
#line 66 "/home/luca/repo/wip/tasklet/tasklet_blocking_sockets.vala"
	a3 = (gint) (_tmp7_ / 256);
#line 67 "/home/luca/repo/wip/tasklet/tasklet_blocking_sockets.vala"
	_tmp8_ = s_addr;
#line 67 "/home/luca/repo/wip/tasklet/tasklet_blocking_sockets.vala"
	s_addr = _tmp8_ - (a3 * 256);
#line 68 "/home/luca/repo/wip/tasklet/tasklet_blocking_sockets.vala"
	_tmp9_ = s_addr;
#line 68 "/home/luca/repo/wip/tasklet/tasklet_blocking_sockets.vala"
	a4 = (gint) _tmp9_;
#line 69 "/home/luca/repo/wip/tasklet/tasklet_blocking_sockets.vala"
	c1 = (guchar) a1;
#line 70 "/home/luca/repo/wip/tasklet/tasklet_blocking_sockets.vala"
	c2 = (guchar) a2;
#line 71 "/home/luca/repo/wip/tasklet/tasklet_blocking_sockets.vala"
	c3 = (guchar) a3;
#line 72 "/home/luca/repo/wip/tasklet/tasklet_blocking_sockets.vala"
	c4 = (guchar) a4;
#line 73 "/home/luca/repo/wip/tasklet/tasklet_blocking_sockets.vala"
	_tmp10_ = g_new0 (guchar, 4);
#line 73 "/home/luca/repo/wip/tasklet/tasklet_blocking_sockets.vala"
	_tmp10_[0] = c1;
#line 73 "/home/luca/repo/wip/tasklet/tasklet_blocking_sockets.vala"
	_tmp10_[1] = c2;
#line 73 "/home/luca/repo/wip/tasklet/tasklet_blocking_sockets.vala"
	_tmp10_[2] = c3;
#line 73 "/home/luca/repo/wip/tasklet/tasklet_blocking_sockets.vala"
	_tmp10_[3] = c4;
#line 73 "/home/luca/repo/wip/tasklet/tasklet_blocking_sockets.vala"
	ret = _tmp10_;
#line 73 "/home/luca/repo/wip/tasklet/tasklet_blocking_sockets.vala"
	ret_length1 = 4;
#line 73 "/home/luca/repo/wip/tasklet/tasklet_blocking_sockets.vala"
	_ret_size_ = ret_length1;
#line 74 "/home/luca/repo/wip/tasklet/tasklet_blocking_sockets.vala"
	_tmp11_ = ret;
#line 74 "/home/luca/repo/wip/tasklet/tasklet_blocking_sockets.vala"
	_tmp11__length1 = ret_length1;
#line 74 "/home/luca/repo/wip/tasklet/tasklet_blocking_sockets.vala"
	if (result_length1) {
#line 74 "/home/luca/repo/wip/tasklet/tasklet_blocking_sockets.vala"
		*result_length1 = _tmp11__length1;
#line 534 "tasklet_blocking_sockets.c"
	}
#line 74 "/home/luca/repo/wip/tasklet/tasklet_blocking_sockets.vala"
	result = _tmp11_;
#line 74 "/home/luca/repo/wip/tasklet/tasklet_blocking_sockets.vala"
	return result;
#line 540 "tasklet_blocking_sockets.c"
}


guint16 _tasklets_iconnected_stream_socket_peer_port_getter (TaskletsIConnectedStreamSocket* self) {
#line 87 "/home/luca/repo/wip/tasklet/tasklet_blocking_sockets.vala"
	g_return_val_if_fail (self != NULL, 0U);
#line 87 "/home/luca/repo/wip/tasklet/tasklet_blocking_sockets.vala"
	return TASKLETS_ICONNECTED_STREAM_SOCKET_GET_INTERFACE (self)->_peer_port_getter (self);
#line 549 "tasklet_blocking_sockets.c"
}


const gchar* _tasklets_iconnected_stream_socket_peer_address_getter (TaskletsIConnectedStreamSocket* self) {
#line 94 "/home/luca/repo/wip/tasklet/tasklet_blocking_sockets.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 94 "/home/luca/repo/wip/tasklet/tasklet_blocking_sockets.vala"
	return TASKLETS_ICONNECTED_STREAM_SOCKET_GET_INTERFACE (self)->_peer_address_getter (self);
#line 558 "tasklet_blocking_sockets.c"
}


guint16 _tasklets_iconnected_stream_socket_my_port_getter (TaskletsIConnectedStreamSocket* self) {
#line 101 "/home/luca/repo/wip/tasklet/tasklet_blocking_sockets.vala"
	g_return_val_if_fail (self != NULL, 0U);
#line 101 "/home/luca/repo/wip/tasklet/tasklet_blocking_sockets.vala"
	return TASKLETS_ICONNECTED_STREAM_SOCKET_GET_INTERFACE (self)->_my_port_getter (self);
#line 567 "tasklet_blocking_sockets.c"
}


const gchar* _tasklets_iconnected_stream_socket_my_address_getter (TaskletsIConnectedStreamSocket* self) {
#line 108 "/home/luca/repo/wip/tasklet/tasklet_blocking_sockets.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 108 "/home/luca/repo/wip/tasklet/tasklet_blocking_sockets.vala"
	return TASKLETS_ICONNECTED_STREAM_SOCKET_GET_INTERFACE (self)->_my_address_getter (self);
#line 576 "tasklet_blocking_sockets.c"
}


/** Sends all the bytes. Returns when all the bytes have been reliably sent.
          */
void tasklets_iconnected_stream_socket_send (TaskletsIConnectedStreamSocket* self, guchar* data, int data_length1, GError** error) {
	guchar* _tmp0_;
	gint _tmp0__length1;
	gint remain;
	GError * _inner_error_ = NULL;
#line 114 "/home/luca/repo/wip/tasklet/tasklet_blocking_sockets.vala"
	_tmp0_ = data;
#line 114 "/home/luca/repo/wip/tasklet/tasklet_blocking_sockets.vala"
	_tmp0__length1 = data_length1;
#line 114 "/home/luca/repo/wip/tasklet/tasklet_blocking_sockets.vala"
	remain = _tmp0__length1;
#line 115 "/home/luca/repo/wip/tasklet/tasklet_blocking_sockets.vala"
	while (TRUE) {
#line 595 "tasklet_blocking_sockets.c"
		gint _tmp1_;
		guchar* _tmp2_;
		gint _tmp2__length1;
		gint _tmp3_;
		gint _tmp4_ = 0;
		gint done;
		gint _tmp5_;
		gint _tmp6_;
		guchar* _tmp7_;
		gint _tmp7__length1;
		gint _tmp8_;
		gint _tmp9_;
		gint _tmp10_;
#line 115 "/home/luca/repo/wip/tasklet/tasklet_blocking_sockets.vala"
		_tmp1_ = remain;
#line 115 "/home/luca/repo/wip/tasklet/tasklet_blocking_sockets.vala"
		if (!(_tmp1_ > 0)) {
#line 115 "/home/luca/repo/wip/tasklet/tasklet_blocking_sockets.vala"
			break;
#line 615 "tasklet_blocking_sockets.c"
		}
#line 117 "/home/luca/repo/wip/tasklet/tasklet_blocking_sockets.vala"
		_tmp2_ = data;
#line 117 "/home/luca/repo/wip/tasklet/tasklet_blocking_sockets.vala"
		_tmp2__length1 = data_length1;
#line 117 "/home/luca/repo/wip/tasklet/tasklet_blocking_sockets.vala"
		_tmp3_ = remain;
#line 117 "/home/luca/repo/wip/tasklet/tasklet_blocking_sockets.vala"
		_tmp4_ = tasklets_iconnected_stream_socket_send_part (self, _tmp2_, _tmp2__length1, _tmp3_, &_inner_error_);
#line 117 "/home/luca/repo/wip/tasklet/tasklet_blocking_sockets.vala"
		done = _tmp4_;
#line 117 "/home/luca/repo/wip/tasklet/tasklet_blocking_sockets.vala"
		if (_inner_error_ != NULL) {
#line 117 "/home/luca/repo/wip/tasklet/tasklet_blocking_sockets.vala"
			g_propagate_error (error, _inner_error_);
#line 117 "/home/luca/repo/wip/tasklet/tasklet_blocking_sockets.vala"
			return;
#line 633 "tasklet_blocking_sockets.c"
		}
#line 118 "/home/luca/repo/wip/tasklet/tasklet_blocking_sockets.vala"
		_tmp5_ = remain;
#line 118 "/home/luca/repo/wip/tasklet/tasklet_blocking_sockets.vala"
		_tmp6_ = done;
#line 118 "/home/luca/repo/wip/tasklet/tasklet_blocking_sockets.vala"
		remain = _tmp5_ - _tmp6_;
#line 119 "/home/luca/repo/wip/tasklet/tasklet_blocking_sockets.vala"
		_tmp7_ = data;
#line 119 "/home/luca/repo/wip/tasklet/tasklet_blocking_sockets.vala"
		_tmp7__length1 = data_length1;
#line 119 "/home/luca/repo/wip/tasklet/tasklet_blocking_sockets.vala"
		_tmp8_ = done;
#line 119 "/home/luca/repo/wip/tasklet/tasklet_blocking_sockets.vala"
		_tmp9_ = done;
#line 119 "/home/luca/repo/wip/tasklet/tasklet_blocking_sockets.vala"
		_tmp10_ = remain;
#line 119 "/home/luca/repo/wip/tasklet/tasklet_blocking_sockets.vala"
		data = _tmp7_ + _tmp8_;
#line 119 "/home/luca/repo/wip/tasklet/tasklet_blocking_sockets.vala"
		data_length1 = (_tmp9_ + _tmp10_) - _tmp8_;
#line 655 "tasklet_blocking_sockets.c"
	}
}


gint tasklets_iconnected_stream_socket_send_part (TaskletsIConnectedStreamSocket* self, guchar* data, int data_length1, gint maxlen, GError** error) {
#line 123 "/home/luca/repo/wip/tasklet/tasklet_blocking_sockets.vala"
	g_return_val_if_fail (self != NULL, 0);
#line 123 "/home/luca/repo/wip/tasklet/tasklet_blocking_sockets.vala"
	return TASKLETS_ICONNECTED_STREAM_SOCKET_GET_INTERFACE (self)->send_part (self, data, data_length1, maxlen, error);
#line 665 "tasklet_blocking_sockets.c"
}


guchar* tasklets_iconnected_stream_socket_recv (TaskletsIConnectedStreamSocket* self, gint maxlen, int* result_length1, GError** error) {
#line 124 "/home/luca/repo/wip/tasklet/tasklet_blocking_sockets.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 124 "/home/luca/repo/wip/tasklet/tasklet_blocking_sockets.vala"
	return TASKLETS_ICONNECTED_STREAM_SOCKET_GET_INTERFACE (self)->recv (self, maxlen, result_length1, error);
#line 674 "tasklet_blocking_sockets.c"
}


void tasklets_iconnected_stream_socket_close (TaskletsIConnectedStreamSocket* self, GError** error) {
#line 125 "/home/luca/repo/wip/tasklet/tasklet_blocking_sockets.vala"
	g_return_if_fail (self != NULL);
#line 125 "/home/luca/repo/wip/tasklet/tasklet_blocking_sockets.vala"
	TASKLETS_ICONNECTED_STREAM_SOCKET_GET_INTERFACE (self)->close (self, error);
#line 683 "tasklet_blocking_sockets.c"
}


guint16 tasklets_iconnected_stream_socket_get_peer_port (TaskletsIConnectedStreamSocket* self) {
	guint16 result;
	guint16 _tmp0_ = 0U;
#line 83 "/home/luca/repo/wip/tasklet/tasklet_blocking_sockets.vala"
	g_return_val_if_fail (self != NULL, 0U);
#line 84 "/home/luca/repo/wip/tasklet/tasklet_blocking_sockets.vala"
	_tmp0_ = _tasklets_iconnected_stream_socket_peer_port_getter (self);
#line 84 "/home/luca/repo/wip/tasklet/tasklet_blocking_sockets.vala"
	result = _tmp0_;
#line 84 "/home/luca/repo/wip/tasklet/tasklet_blocking_sockets.vala"
	return result;
#line 698 "tasklet_blocking_sockets.c"
}


const gchar* tasklets_iconnected_stream_socket_get_peer_address (TaskletsIConnectedStreamSocket* self) {
	const gchar* result;
	const gchar* _tmp0_ = NULL;
#line 90 "/home/luca/repo/wip/tasklet/tasklet_blocking_sockets.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 91 "/home/luca/repo/wip/tasklet/tasklet_blocking_sockets.vala"
	_tmp0_ = _tasklets_iconnected_stream_socket_peer_address_getter (self);
#line 91 "/home/luca/repo/wip/tasklet/tasklet_blocking_sockets.vala"
	result = _tmp0_;
#line 91 "/home/luca/repo/wip/tasklet/tasklet_blocking_sockets.vala"
	return result;
#line 713 "tasklet_blocking_sockets.c"
}


guint16 tasklets_iconnected_stream_socket_get_my_port (TaskletsIConnectedStreamSocket* self) {
	guint16 result;
	guint16 _tmp0_ = 0U;
#line 97 "/home/luca/repo/wip/tasklet/tasklet_blocking_sockets.vala"
	g_return_val_if_fail (self != NULL, 0U);
#line 98 "/home/luca/repo/wip/tasklet/tasklet_blocking_sockets.vala"
	_tmp0_ = _tasklets_iconnected_stream_socket_my_port_getter (self);
#line 98 "/home/luca/repo/wip/tasklet/tasklet_blocking_sockets.vala"
	result = _tmp0_;
#line 98 "/home/luca/repo/wip/tasklet/tasklet_blocking_sockets.vala"
	return result;
#line 728 "tasklet_blocking_sockets.c"
}


const gchar* tasklets_iconnected_stream_socket_get_my_address (TaskletsIConnectedStreamSocket* self) {
	const gchar* result;
	const gchar* _tmp0_ = NULL;
#line 104 "/home/luca/repo/wip/tasklet/tasklet_blocking_sockets.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 105 "/home/luca/repo/wip/tasklet/tasklet_blocking_sockets.vala"
	_tmp0_ = _tasklets_iconnected_stream_socket_my_address_getter (self);
#line 105 "/home/luca/repo/wip/tasklet/tasklet_blocking_sockets.vala"
	result = _tmp0_;
#line 105 "/home/luca/repo/wip/tasklet/tasklet_blocking_sockets.vala"
	return result;
#line 743 "tasklet_blocking_sockets.c"
}


static void tasklets_iconnected_stream_socket_base_init (TaskletsIConnectedStreamSocketIface * iface) {
#line 80 "/home/luca/repo/wip/tasklet/tasklet_blocking_sockets.vala"
	static gboolean initialized = FALSE;
#line 80 "/home/luca/repo/wip/tasklet/tasklet_blocking_sockets.vala"
	if (!initialized) {
#line 80 "/home/luca/repo/wip/tasklet/tasklet_blocking_sockets.vala"
		initialized = TRUE;
#line 754 "tasklet_blocking_sockets.c"
	}
}


/** When you have a socket connected to a server, or when you receive
      *  a connection, you get an obscure object that implements this API.
      */
GType tasklets_iconnected_stream_socket_get_type (void) {
	static volatile gsize tasklets_iconnected_stream_socket_type_id__volatile = 0;
	if (g_once_init_enter (&tasklets_iconnected_stream_socket_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (TaskletsIConnectedStreamSocketIface), (GBaseInitFunc) tasklets_iconnected_stream_socket_base_init, (GBaseFinalizeFunc) NULL, (GClassInitFunc) NULL, (GClassFinalizeFunc) NULL, NULL, 0, 0, (GInstanceInitFunc) NULL, NULL };
		GType tasklets_iconnected_stream_socket_type_id;
		tasklets_iconnected_stream_socket_type_id = g_type_register_static (G_TYPE_INTERFACE, "TaskletsIConnectedStreamSocket", &g_define_type_info, 0);
		g_type_interface_add_prerequisite (tasklets_iconnected_stream_socket_type_id, G_TYPE_OBJECT);
		g_once_init_leave (&tasklets_iconnected_stream_socket_type_id__volatile, tasklets_iconnected_stream_socket_type_id);
	}
	return tasklets_iconnected_stream_socket_type_id__volatile;
}


TaskletsServerStreamSocket* tasklets_server_stream_socket_construct (GType object_type, guint16 port, gint backlog, const gchar* my_addr, GError** error) {
	TaskletsServerStreamSocket * self = NULL;
	GSocket* _tmp0_;
	GSocket* _tmp1_;
	const gchar* _tmp2_;
	GSocket* _tmp16_;
	gint _tmp17_;
	GSocket* _tmp18_;
	GError * _inner_error_ = NULL;
#line 136 "/home/luca/repo/wip/tasklet/tasklet_blocking_sockets.vala"
	self = (TaskletsServerStreamSocket*) g_object_new (object_type, NULL);
#line 138 "/home/luca/repo/wip/tasklet/tasklet_blocking_sockets.vala"
	_tmp0_ = g_socket_new (G_SOCKET_FAMILY_IPV4, G_SOCKET_TYPE_STREAM, G_SOCKET_PROTOCOL_TCP, &_inner_error_);
#line 138 "/home/luca/repo/wip/tasklet/tasklet_blocking_sockets.vala"
	_tmp1_ = _tmp0_;
#line 138 "/home/luca/repo/wip/tasklet/tasklet_blocking_sockets.vala"
	if (_inner_error_ != NULL) {
#line 138 "/home/luca/repo/wip/tasklet/tasklet_blocking_sockets.vala"
		g_propagate_error (error, _inner_error_);
#line 138 "/home/luca/repo/wip/tasklet/tasklet_blocking_sockets.vala"
		_g_object_unref0 (self);
#line 138 "/home/luca/repo/wip/tasklet/tasklet_blocking_sockets.vala"
		return NULL;
#line 798 "tasklet_blocking_sockets.c"
	}
#line 138 "/home/luca/repo/wip/tasklet/tasklet_blocking_sockets.vala"
	_g_object_unref0 (self->priv->s);
#line 138 "/home/luca/repo/wip/tasklet/tasklet_blocking_sockets.vala"
	self->priv->s = _tmp1_;
#line 139 "/home/luca/repo/wip/tasklet/tasklet_blocking_sockets.vala"
	_tmp2_ = my_addr;
#line 139 "/home/luca/repo/wip/tasklet/tasklet_blocking_sockets.vala"
	if (_tmp2_ == NULL) {
#line 808 "tasklet_blocking_sockets.c"
		GSocket* _tmp3_;
		GInetAddress* _tmp4_;
		GInetAddress* _tmp5_;
		guint16 _tmp6_;
		GInetSocketAddress* _tmp7_;
		GInetSocketAddress* _tmp8_;
#line 140 "/home/luca/repo/wip/tasklet/tasklet_blocking_sockets.vala"
		_tmp3_ = self->priv->s;
#line 140 "/home/luca/repo/wip/tasklet/tasklet_blocking_sockets.vala"
		_tmp4_ = g_inet_address_new_any (G_SOCKET_FAMILY_IPV4);
#line 140 "/home/luca/repo/wip/tasklet/tasklet_blocking_sockets.vala"
		_tmp5_ = _tmp4_;
#line 140 "/home/luca/repo/wip/tasklet/tasklet_blocking_sockets.vala"
		_tmp6_ = port;
#line 140 "/home/luca/repo/wip/tasklet/tasklet_blocking_sockets.vala"
		_tmp7_ = (GInetSocketAddress*) g_inet_socket_address_new (_tmp5_, _tmp6_);
#line 140 "/home/luca/repo/wip/tasklet/tasklet_blocking_sockets.vala"
		_tmp8_ = _tmp7_;
#line 140 "/home/luca/repo/wip/tasklet/tasklet_blocking_sockets.vala"
		g_socket_bind (_tmp3_, (GSocketAddress*) _tmp8_, TRUE, &_inner_error_);
#line 140 "/home/luca/repo/wip/tasklet/tasklet_blocking_sockets.vala"
		_g_object_unref0 (_tmp8_);
#line 140 "/home/luca/repo/wip/tasklet/tasklet_blocking_sockets.vala"
		_g_object_unref0 (_tmp5_);
#line 140 "/home/luca/repo/wip/tasklet/tasklet_blocking_sockets.vala"
		if (_inner_error_ != NULL) {
#line 140 "/home/luca/repo/wip/tasklet/tasklet_blocking_sockets.vala"
			g_propagate_error (error, _inner_error_);
#line 140 "/home/luca/repo/wip/tasklet/tasklet_blocking_sockets.vala"
			_g_object_unref0 (self);
#line 140 "/home/luca/repo/wip/tasklet/tasklet_blocking_sockets.vala"
			return NULL;
#line 841 "tasklet_blocking_sockets.c"
		}
	} else {
		GSocket* _tmp9_;
		const gchar* _tmp10_;
		GInetAddress* _tmp11_;
		GInetAddress* _tmp12_;
		guint16 _tmp13_;
		GInetSocketAddress* _tmp14_;
		GInetSocketAddress* _tmp15_;
#line 142 "/home/luca/repo/wip/tasklet/tasklet_blocking_sockets.vala"
		_tmp9_ = self->priv->s;
#line 142 "/home/luca/repo/wip/tasklet/tasklet_blocking_sockets.vala"
		_tmp10_ = my_addr;
#line 142 "/home/luca/repo/wip/tasklet/tasklet_blocking_sockets.vala"
		_tmp11_ = g_inet_address_new_from_string (_tmp10_);
#line 142 "/home/luca/repo/wip/tasklet/tasklet_blocking_sockets.vala"
		_tmp12_ = _tmp11_;
#line 142 "/home/luca/repo/wip/tasklet/tasklet_blocking_sockets.vala"
		_tmp13_ = port;
#line 142 "/home/luca/repo/wip/tasklet/tasklet_blocking_sockets.vala"
		_tmp14_ = (GInetSocketAddress*) g_inet_socket_address_new (_tmp12_, _tmp13_);
#line 142 "/home/luca/repo/wip/tasklet/tasklet_blocking_sockets.vala"
		_tmp15_ = _tmp14_;
#line 142 "/home/luca/repo/wip/tasklet/tasklet_blocking_sockets.vala"
		g_socket_bind (_tmp9_, (GSocketAddress*) _tmp15_, TRUE, &_inner_error_);
#line 142 "/home/luca/repo/wip/tasklet/tasklet_blocking_sockets.vala"
		_g_object_unref0 (_tmp15_);
#line 142 "/home/luca/repo/wip/tasklet/tasklet_blocking_sockets.vala"
		_g_object_unref0 (_tmp12_);
#line 142 "/home/luca/repo/wip/tasklet/tasklet_blocking_sockets.vala"
		if (_inner_error_ != NULL) {
#line 142 "/home/luca/repo/wip/tasklet/tasklet_blocking_sockets.vala"
			g_propagate_error (error, _inner_error_);
#line 142 "/home/luca/repo/wip/tasklet/tasklet_blocking_sockets.vala"
			_g_object_unref0 (self);
#line 142 "/home/luca/repo/wip/tasklet/tasklet_blocking_sockets.vala"
			return NULL;
#line 879 "tasklet_blocking_sockets.c"
		}
	}
#line 143 "/home/luca/repo/wip/tasklet/tasklet_blocking_sockets.vala"
	_tmp16_ = self->priv->s;
#line 143 "/home/luca/repo/wip/tasklet/tasklet_blocking_sockets.vala"
	_tmp17_ = backlog;
#line 143 "/home/luca/repo/wip/tasklet/tasklet_blocking_sockets.vala"
	g_socket_set_listen_backlog (_tmp16_, _tmp17_);
#line 144 "/home/luca/repo/wip/tasklet/tasklet_blocking_sockets.vala"
	_tmp18_ = self->priv->s;
#line 144 "/home/luca/repo/wip/tasklet/tasklet_blocking_sockets.vala"
	g_socket_listen (_tmp18_, &_inner_error_);
#line 144 "/home/luca/repo/wip/tasklet/tasklet_blocking_sockets.vala"
	if (_inner_error_ != NULL) {
#line 144 "/home/luca/repo/wip/tasklet/tasklet_blocking_sockets.vala"
		g_propagate_error (error, _inner_error_);
#line 144 "/home/luca/repo/wip/tasklet/tasklet_blocking_sockets.vala"
		_g_object_unref0 (self);
#line 144 "/home/luca/repo/wip/tasklet/tasklet_blocking_sockets.vala"
		return NULL;
#line 900 "tasklet_blocking_sockets.c"
	}
#line 136 "/home/luca/repo/wip/tasklet/tasklet_blocking_sockets.vala"
	return self;
#line 904 "tasklet_blocking_sockets.c"
}


TaskletsServerStreamSocket* tasklets_server_stream_socket_new (guint16 port, gint backlog, const gchar* my_addr, GError** error) {
#line 136 "/home/luca/repo/wip/tasklet/tasklet_blocking_sockets.vala"
	return tasklets_server_stream_socket_construct (TASKLETS_TYPE_SERVER_STREAM_SOCKET, port, backlog, my_addr, error);
#line 911 "tasklet_blocking_sockets.c"
}


/** When the method returns, start a new tasklet and pass the
          *  returned object to handle the request. With this instance,
          *  instead, call accept again to wait for more clients.
          */
TaskletsIConnectedStreamSocket* tasklets_server_stream_socket_accept (TaskletsServerStreamSocket* self, GError** error) {
	TaskletsIConnectedStreamSocket* result = NULL;
	GSocket* _tmp0_;
	GSocket* _tmp1_ = NULL;
	GSocket* s2;
	GSocket* _tmp2_;
	TaskletsConnectedStreamSocket* _tmp3_;
	TaskletsConnectedStreamSocket* _tmp4_;
	GError * _inner_error_ = NULL;
#line 151 "/home/luca/repo/wip/tasklet/tasklet_blocking_sockets.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 153 "/home/luca/repo/wip/tasklet/tasklet_blocking_sockets.vala"
	tasklets_tasklet_tasklet_leaves ("with socket_accept");
#line 154 "/home/luca/repo/wip/tasklet/tasklet_blocking_sockets.vala"
	_tmp0_ = self->priv->s;
#line 154 "/home/luca/repo/wip/tasklet/tasklet_blocking_sockets.vala"
	_tmp1_ = wrapped_lib_pth_pth_thread_socket_accept (_tmp0_, &_inner_error_);
#line 154 "/home/luca/repo/wip/tasklet/tasklet_blocking_sockets.vala"
	s2 = _tmp1_;
#line 154 "/home/luca/repo/wip/tasklet/tasklet_blocking_sockets.vala"
	if (_inner_error_ != NULL) {
#line 154 "/home/luca/repo/wip/tasklet/tasklet_blocking_sockets.vala"
		g_propagate_error (error, _inner_error_);
#line 154 "/home/luca/repo/wip/tasklet/tasklet_blocking_sockets.vala"
		return NULL;
#line 944 "tasklet_blocking_sockets.c"
	}
#line 155 "/home/luca/repo/wip/tasklet/tasklet_blocking_sockets.vala"
	tasklets_tasklet_tasklet_regains ("from socket_accept");
#line 156 "/home/luca/repo/wip/tasklet/tasklet_blocking_sockets.vala"
	_tmp2_ = s2;
#line 156 "/home/luca/repo/wip/tasklet/tasklet_blocking_sockets.vala"
	_tmp3_ = tasklets_connected_stream_socket_new (_tmp2_, &_inner_error_);
#line 156 "/home/luca/repo/wip/tasklet/tasklet_blocking_sockets.vala"
	_tmp4_ = _tmp3_;
#line 156 "/home/luca/repo/wip/tasklet/tasklet_blocking_sockets.vala"
	if (_inner_error_ != NULL) {
#line 156 "/home/luca/repo/wip/tasklet/tasklet_blocking_sockets.vala"
		g_propagate_error (error, _inner_error_);
#line 156 "/home/luca/repo/wip/tasklet/tasklet_blocking_sockets.vala"
		_g_object_unref0 (s2);
#line 156 "/home/luca/repo/wip/tasklet/tasklet_blocking_sockets.vala"
		return NULL;
#line 962 "tasklet_blocking_sockets.c"
	}
#line 156 "/home/luca/repo/wip/tasklet/tasklet_blocking_sockets.vala"
	result = (TaskletsIConnectedStreamSocket*) _tmp4_;
#line 156 "/home/luca/repo/wip/tasklet/tasklet_blocking_sockets.vala"
	_g_object_unref0 (s2);
#line 156 "/home/luca/repo/wip/tasklet/tasklet_blocking_sockets.vala"
	return result;
#line 970 "tasklet_blocking_sockets.c"
}


void tasklets_server_stream_socket_close (TaskletsServerStreamSocket* self, GError** error) {
	GSocket* _tmp0_;
	GError * _inner_error_ = NULL;
#line 159 "/home/luca/repo/wip/tasklet/tasklet_blocking_sockets.vala"
	g_return_if_fail (self != NULL);
#line 161 "/home/luca/repo/wip/tasklet/tasklet_blocking_sockets.vala"
	_tmp0_ = self->priv->s;
#line 161 "/home/luca/repo/wip/tasklet/tasklet_blocking_sockets.vala"
	g_socket_close (_tmp0_, &_inner_error_);
#line 161 "/home/luca/repo/wip/tasklet/tasklet_blocking_sockets.vala"
	if (_inner_error_ != NULL) {
#line 161 "/home/luca/repo/wip/tasklet/tasklet_blocking_sockets.vala"
		g_propagate_error (error, _inner_error_);
#line 161 "/home/luca/repo/wip/tasklet/tasklet_blocking_sockets.vala"
		return;
#line 989 "tasklet_blocking_sockets.c"
	}
}


static void tasklets_server_stream_socket_class_init (TaskletsServerStreamSocketClass * klass) {
#line 132 "/home/luca/repo/wip/tasklet/tasklet_blocking_sockets.vala"
	tasklets_server_stream_socket_parent_class = g_type_class_peek_parent (klass);
#line 132 "/home/luca/repo/wip/tasklet/tasklet_blocking_sockets.vala"
	g_type_class_add_private (klass, sizeof (TaskletsServerStreamSocketPrivate));
#line 132 "/home/luca/repo/wip/tasklet/tasklet_blocking_sockets.vala"
	G_OBJECT_CLASS (klass)->finalize = tasklets_server_stream_socket_finalize;
#line 1001 "tasklet_blocking_sockets.c"
}


static void tasklets_server_stream_socket_instance_init (TaskletsServerStreamSocket * self) {
#line 132 "/home/luca/repo/wip/tasklet/tasklet_blocking_sockets.vala"
	self->priv = TASKLETS_SERVER_STREAM_SOCKET_GET_PRIVATE (self);
#line 1008 "tasklet_blocking_sockets.c"
}


static void tasklets_server_stream_socket_finalize (GObject* obj) {
	TaskletsServerStreamSocket * self;
	GError * _inner_error_ = NULL;
#line 132 "/home/luca/repo/wip/tasklet/tasklet_blocking_sockets.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TASKLETS_TYPE_SERVER_STREAM_SOCKET, TaskletsServerStreamSocket);
#line 166 "/home/luca/repo/wip/tasklet/tasklet_blocking_sockets.vala"
	tasklets_server_stream_socket_close (self, &_inner_error_);
#line 166 "/home/luca/repo/wip/tasklet/tasklet_blocking_sockets.vala"
	if (_inner_error_ != NULL) {
#line 166 "/home/luca/repo/wip/tasklet/tasklet_blocking_sockets.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 166 "/home/luca/repo/wip/tasklet/tasklet_blocking_sockets.vala"
		g_clear_error (&_inner_error_);
#line 1025 "tasklet_blocking_sockets.c"
	}
#line 134 "/home/luca/repo/wip/tasklet/tasklet_blocking_sockets.vala"
	_g_object_unref0 (self->priv->s);
#line 132 "/home/luca/repo/wip/tasklet/tasklet_blocking_sockets.vala"
	G_OBJECT_CLASS (tasklets_server_stream_socket_parent_class)->finalize (obj);
#line 1031 "tasklet_blocking_sockets.c"
}


/** Use this class to implement a TCP connection oriented service.
      * In particular, you can wait for a connection without blocking the
      *  rest of the application.
      */
GType tasklets_server_stream_socket_get_type (void) {
	static volatile gsize tasklets_server_stream_socket_type_id__volatile = 0;
	if (g_once_init_enter (&tasklets_server_stream_socket_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (TaskletsServerStreamSocketClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) tasklets_server_stream_socket_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (TaskletsServerStreamSocket), 0, (GInstanceInitFunc) tasklets_server_stream_socket_instance_init, NULL };
		GType tasklets_server_stream_socket_type_id;
		tasklets_server_stream_socket_type_id = g_type_register_static (G_TYPE_OBJECT, "TaskletsServerStreamSocket", &g_define_type_info, 0);
		g_once_init_leave (&tasklets_server_stream_socket_type_id__volatile, tasklets_server_stream_socket_type_id);
	}
	return tasklets_server_stream_socket_type_id__volatile;
}


TaskletsClientStreamSocket* tasklets_client_stream_socket_construct (GType object_type, const gchar* my_addr, GError** error) {
	TaskletsClientStreamSocket * self = NULL;
	GSocket* _tmp0_;
	GSocket* _tmp1_;
	const gchar* _tmp2_;
	GError * _inner_error_ = NULL;
#line 178 "/home/luca/repo/wip/tasklet/tasklet_blocking_sockets.vala"
	self = (TaskletsClientStreamSocket*) g_object_new (object_type, NULL);
#line 180 "/home/luca/repo/wip/tasklet/tasklet_blocking_sockets.vala"
	_tmp0_ = g_socket_new (G_SOCKET_FAMILY_IPV4, G_SOCKET_TYPE_STREAM, G_SOCKET_PROTOCOL_TCP, &_inner_error_);
#line 180 "/home/luca/repo/wip/tasklet/tasklet_blocking_sockets.vala"
	_tmp1_ = _tmp0_;
#line 180 "/home/luca/repo/wip/tasklet/tasklet_blocking_sockets.vala"
	if (_inner_error_ != NULL) {
#line 180 "/home/luca/repo/wip/tasklet/tasklet_blocking_sockets.vala"
		g_propagate_error (error, _inner_error_);
#line 180 "/home/luca/repo/wip/tasklet/tasklet_blocking_sockets.vala"
		_g_object_unref0 (self);
#line 180 "/home/luca/repo/wip/tasklet/tasklet_blocking_sockets.vala"
		return NULL;
#line 1071 "tasklet_blocking_sockets.c"
	}
#line 180 "/home/luca/repo/wip/tasklet/tasklet_blocking_sockets.vala"
	_g_object_unref0 (self->priv->s);
#line 180 "/home/luca/repo/wip/tasklet/tasklet_blocking_sockets.vala"
	self->priv->s = _tmp1_;
#line 181 "/home/luca/repo/wip/tasklet/tasklet_blocking_sockets.vala"
	_tmp2_ = my_addr;
#line 181 "/home/luca/repo/wip/tasklet/tasklet_blocking_sockets.vala"
	if (_tmp2_ != NULL) {
#line 1081 "tasklet_blocking_sockets.c"
		GSocket* _tmp3_;
		const gchar* _tmp4_;
		GInetAddress* _tmp5_;
		GInetAddress* _tmp6_;
		GInetSocketAddress* _tmp7_;
		GInetSocketAddress* _tmp8_;
#line 182 "/home/luca/repo/wip/tasklet/tasklet_blocking_sockets.vala"
		_tmp3_ = self->priv->s;
#line 182 "/home/luca/repo/wip/tasklet/tasklet_blocking_sockets.vala"
		_tmp4_ = my_addr;
#line 182 "/home/luca/repo/wip/tasklet/tasklet_blocking_sockets.vala"
		_tmp5_ = g_inet_address_new_from_string (_tmp4_);
#line 182 "/home/luca/repo/wip/tasklet/tasklet_blocking_sockets.vala"
		_tmp6_ = _tmp5_;
#line 182 "/home/luca/repo/wip/tasklet/tasklet_blocking_sockets.vala"
		_tmp7_ = (GInetSocketAddress*) g_inet_socket_address_new (_tmp6_, (guint16) 0);
#line 182 "/home/luca/repo/wip/tasklet/tasklet_blocking_sockets.vala"
		_tmp8_ = _tmp7_;
#line 182 "/home/luca/repo/wip/tasklet/tasklet_blocking_sockets.vala"
		g_socket_bind (_tmp3_, (GSocketAddress*) _tmp8_, FALSE, &_inner_error_);
#line 182 "/home/luca/repo/wip/tasklet/tasklet_blocking_sockets.vala"
		_g_object_unref0 (_tmp8_);
#line 182 "/home/luca/repo/wip/tasklet/tasklet_blocking_sockets.vala"
		_g_object_unref0 (_tmp6_);
#line 182 "/home/luca/repo/wip/tasklet/tasklet_blocking_sockets.vala"
		if (_inner_error_ != NULL) {
#line 182 "/home/luca/repo/wip/tasklet/tasklet_blocking_sockets.vala"
			g_propagate_error (error, _inner_error_);
#line 182 "/home/luca/repo/wip/tasklet/tasklet_blocking_sockets.vala"
			_g_object_unref0 (self);
#line 182 "/home/luca/repo/wip/tasklet/tasklet_blocking_sockets.vala"
			return NULL;
#line 1114 "tasklet_blocking_sockets.c"
		}
	}
#line 178 "/home/luca/repo/wip/tasklet/tasklet_blocking_sockets.vala"
	return self;
#line 1119 "tasklet_blocking_sockets.c"
}


TaskletsClientStreamSocket* tasklets_client_stream_socket_new (const gchar* my_addr, GError** error) {
#line 178 "/home/luca/repo/wip/tasklet/tasklet_blocking_sockets.vala"
	return tasklets_client_stream_socket_construct (TASKLETS_TYPE_CLIENT_STREAM_SOCKET, my_addr, error);
#line 1126 "tasklet_blocking_sockets.c"
}


/** When the method returns, use the returned object
          *  to carry on the communication. Discard this instance, instead.
          */
TaskletsIConnectedStreamSocket* tasklets_client_stream_socket_socket_connect (TaskletsClientStreamSocket* self, const gchar* addr, guint16 port, GError** error) {
	TaskletsIConnectedStreamSocket* result = NULL;
	GSocket* _tmp0_;
	GSocket* _tmp1_;
	const gchar* _tmp2_;
	guint16 _tmp3_;
	GSocket* _tmp4_;
	TaskletsConnectedStreamSocket* _tmp5_;
	TaskletsIConnectedStreamSocket* ret;
	GError * _inner_error_ = NULL;
#line 188 "/home/luca/repo/wip/tasklet/tasklet_blocking_sockets.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 188 "/home/luca/repo/wip/tasklet/tasklet_blocking_sockets.vala"
	g_return_val_if_fail (addr != NULL, NULL);
#line 190 "/home/luca/repo/wip/tasklet/tasklet_blocking_sockets.vala"
	_tmp0_ = self->priv->s;
#line 190 "/home/luca/repo/wip/tasklet/tasklet_blocking_sockets.vala"
	_vala_assert (_tmp0_ != NULL, "s != null");
#line 191 "/home/luca/repo/wip/tasklet/tasklet_blocking_sockets.vala"
	tasklets_tasklet_tasklet_leaves ("with socket_connect");
#line 192 "/home/luca/repo/wip/tasklet/tasklet_blocking_sockets.vala"
	_tmp1_ = self->priv->s;
#line 192 "/home/luca/repo/wip/tasklet/tasklet_blocking_sockets.vala"
	_tmp2_ = addr;
#line 192 "/home/luca/repo/wip/tasklet/tasklet_blocking_sockets.vala"
	_tmp3_ = port;
#line 192 "/home/luca/repo/wip/tasklet/tasklet_blocking_sockets.vala"
	wrapped_lib_pth_pth_thread_socket_connect (_tmp1_, _tmp2_, _tmp3_, &_inner_error_);
#line 192 "/home/luca/repo/wip/tasklet/tasklet_blocking_sockets.vala"
	if (_inner_error_ != NULL) {
#line 192 "/home/luca/repo/wip/tasklet/tasklet_blocking_sockets.vala"
		g_propagate_error (error, _inner_error_);
#line 192 "/home/luca/repo/wip/tasklet/tasklet_blocking_sockets.vala"
		return NULL;
#line 1167 "tasklet_blocking_sockets.c"
	}
#line 193 "/home/luca/repo/wip/tasklet/tasklet_blocking_sockets.vala"
	tasklets_tasklet_tasklet_regains ("from socket_connect");
#line 194 "/home/luca/repo/wip/tasklet/tasklet_blocking_sockets.vala"
	_tmp4_ = self->priv->s;
#line 194 "/home/luca/repo/wip/tasklet/tasklet_blocking_sockets.vala"
	_tmp5_ = tasklets_connected_stream_socket_new (_tmp4_, &_inner_error_);
#line 194 "/home/luca/repo/wip/tasklet/tasklet_blocking_sockets.vala"
	ret = (TaskletsIConnectedStreamSocket*) _tmp5_;
#line 194 "/home/luca/repo/wip/tasklet/tasklet_blocking_sockets.vala"
	if (_inner_error_ != NULL) {
#line 194 "/home/luca/repo/wip/tasklet/tasklet_blocking_sockets.vala"
		g_propagate_error (error, _inner_error_);
#line 194 "/home/luca/repo/wip/tasklet/tasklet_blocking_sockets.vala"
		return NULL;
#line 1183 "tasklet_blocking_sockets.c"
	}
#line 195 "/home/luca/repo/wip/tasklet/tasklet_blocking_sockets.vala"
	_g_object_unref0 (self->priv->s);
#line 195 "/home/luca/repo/wip/tasklet/tasklet_blocking_sockets.vala"
	self->priv->s = NULL;
#line 196 "/home/luca/repo/wip/tasklet/tasklet_blocking_sockets.vala"
	result = ret;
#line 196 "/home/luca/repo/wip/tasklet/tasklet_blocking_sockets.vala"
	return result;
#line 1193 "tasklet_blocking_sockets.c"
}


static void tasklets_client_stream_socket_class_init (TaskletsClientStreamSocketClass * klass) {
#line 174 "/home/luca/repo/wip/tasklet/tasklet_blocking_sockets.vala"
	tasklets_client_stream_socket_parent_class = g_type_class_peek_parent (klass);
#line 174 "/home/luca/repo/wip/tasklet/tasklet_blocking_sockets.vala"
	g_type_class_add_private (klass, sizeof (TaskletsClientStreamSocketPrivate));
#line 174 "/home/luca/repo/wip/tasklet/tasklet_blocking_sockets.vala"
	G_OBJECT_CLASS (klass)->finalize = tasklets_client_stream_socket_finalize;
#line 1204 "tasklet_blocking_sockets.c"
}


static void tasklets_client_stream_socket_instance_init (TaskletsClientStreamSocket * self) {
#line 174 "/home/luca/repo/wip/tasklet/tasklet_blocking_sockets.vala"
	self->priv = TASKLETS_CLIENT_STREAM_SOCKET_GET_PRIVATE (self);
#line 1211 "tasklet_blocking_sockets.c"
}


static void tasklets_client_stream_socket_finalize (GObject* obj) {
	TaskletsClientStreamSocket * self;
#line 174 "/home/luca/repo/wip/tasklet/tasklet_blocking_sockets.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TASKLETS_TYPE_CLIENT_STREAM_SOCKET, TaskletsClientStreamSocket);
#line 176 "/home/luca/repo/wip/tasklet/tasklet_blocking_sockets.vala"
	_g_object_unref0 (self->priv->s);
#line 174 "/home/luca/repo/wip/tasklet/tasklet_blocking_sockets.vala"
	G_OBJECT_CLASS (tasklets_client_stream_socket_parent_class)->finalize (obj);
#line 1223 "tasklet_blocking_sockets.c"
}


/** Use this class to make a connection to a TCP service.
      * In particular, you can wait for the connect to complete without
      *  blocking the rest of the application.
      */
GType tasklets_client_stream_socket_get_type (void) {
	static volatile gsize tasklets_client_stream_socket_type_id__volatile = 0;
	if (g_once_init_enter (&tasklets_client_stream_socket_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (TaskletsClientStreamSocketClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) tasklets_client_stream_socket_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (TaskletsClientStreamSocket), 0, (GInstanceInitFunc) tasklets_client_stream_socket_instance_init, NULL };
		GType tasklets_client_stream_socket_type_id;
		tasklets_client_stream_socket_type_id = g_type_register_static (G_TYPE_OBJECT, "TaskletsClientStreamSocket", &g_define_type_info, 0);
		g_once_init_leave (&tasklets_client_stream_socket_type_id__volatile, tasklets_client_stream_socket_type_id);
	}
	return tasklets_client_stream_socket_type_id__volatile;
}


static gpointer _g_object_ref0 (gpointer self) {
#line 209 "/home/luca/repo/wip/tasklet/tasklet_blocking_sockets.vala"
	return self ? g_object_ref (self) : NULL;
#line 1246 "tasklet_blocking_sockets.c"
}


TaskletsConnectedStreamSocket* tasklets_connected_stream_socket_construct (GType object_type, GSocket* soc, GError** error) {
	TaskletsConnectedStreamSocket * self = NULL;
	GSocket* _tmp0_;
	GSocket* _tmp1_;
	GSocket* _tmp2_;
	GSocketAddress* _tmp3_ = NULL;
	GSocketAddress* _tmp4_;
	GInetSocketAddress* x;
	GInetSocketAddress* _tmp5_;
	GInetAddress* _tmp6_;
	GInetAddress* _tmp7_;
	gchar* _tmp8_ = NULL;
	GInetSocketAddress* _tmp9_;
	guint _tmp10_;
	guint _tmp11_;
	GSocket* _tmp12_;
	GSocketAddress* _tmp13_ = NULL;
	GSocketAddress* _tmp14_;
	GInetSocketAddress* y;
	GInetSocketAddress* _tmp15_;
	GInetAddress* _tmp16_;
	GInetAddress* _tmp17_;
	gchar* _tmp18_ = NULL;
	GInetSocketAddress* _tmp19_;
	guint _tmp20_;
	guint _tmp21_;
	GError * _inner_error_ = NULL;
#line 207 "/home/luca/repo/wip/tasklet/tasklet_blocking_sockets.vala"
	g_return_val_if_fail (soc != NULL, NULL);
#line 207 "/home/luca/repo/wip/tasklet/tasklet_blocking_sockets.vala"
	self = (TaskletsConnectedStreamSocket*) g_object_new (object_type, NULL);
#line 209 "/home/luca/repo/wip/tasklet/tasklet_blocking_sockets.vala"
	_tmp0_ = soc;
#line 209 "/home/luca/repo/wip/tasklet/tasklet_blocking_sockets.vala"
	_tmp1_ = _g_object_ref0 (_tmp0_);
#line 209 "/home/luca/repo/wip/tasklet/tasklet_blocking_sockets.vala"
	_g_object_unref0 (self->priv->s);
#line 209 "/home/luca/repo/wip/tasklet/tasklet_blocking_sockets.vala"
	self->priv->s = _tmp1_;
#line 210 "/home/luca/repo/wip/tasklet/tasklet_blocking_sockets.vala"
	_tmp2_ = self->priv->s;
#line 210 "/home/luca/repo/wip/tasklet/tasklet_blocking_sockets.vala"
	_tmp3_ = g_socket_get_remote_address (_tmp2_, &_inner_error_);
#line 210 "/home/luca/repo/wip/tasklet/tasklet_blocking_sockets.vala"
	_tmp4_ = _tmp3_;
#line 210 "/home/luca/repo/wip/tasklet/tasklet_blocking_sockets.vala"
	if (_inner_error_ != NULL) {
#line 210 "/home/luca/repo/wip/tasklet/tasklet_blocking_sockets.vala"
		g_propagate_error (error, _inner_error_);
#line 210 "/home/luca/repo/wip/tasklet/tasklet_blocking_sockets.vala"
		_g_object_unref0 (self);
#line 210 "/home/luca/repo/wip/tasklet/tasklet_blocking_sockets.vala"
		return NULL;
#line 1303 "tasklet_blocking_sockets.c"
	}
#line 210 "/home/luca/repo/wip/tasklet/tasklet_blocking_sockets.vala"
	x = G_TYPE_CHECK_INSTANCE_CAST (_tmp4_, g_inet_socket_address_get_type (), GInetSocketAddress);
#line 211 "/home/luca/repo/wip/tasklet/tasklet_blocking_sockets.vala"
	_tmp5_ = x;
#line 211 "/home/luca/repo/wip/tasklet/tasklet_blocking_sockets.vala"
	_tmp6_ = g_inet_socket_address_get_address (_tmp5_);
#line 211 "/home/luca/repo/wip/tasklet/tasklet_blocking_sockets.vala"
	_tmp7_ = _tmp6_;
#line 211 "/home/luca/repo/wip/tasklet/tasklet_blocking_sockets.vala"
	_tmp8_ = g_inet_address_to_string (_tmp7_);
#line 211 "/home/luca/repo/wip/tasklet/tasklet_blocking_sockets.vala"
	_g_free0 (self->priv->remote_addr);
#line 211 "/home/luca/repo/wip/tasklet/tasklet_blocking_sockets.vala"
	self->priv->remote_addr = _tmp8_;
#line 212 "/home/luca/repo/wip/tasklet/tasklet_blocking_sockets.vala"
	_tmp9_ = x;
#line 212 "/home/luca/repo/wip/tasklet/tasklet_blocking_sockets.vala"
	_tmp10_ = g_inet_socket_address_get_port (_tmp9_);
#line 212 "/home/luca/repo/wip/tasklet/tasklet_blocking_sockets.vala"
	_tmp11_ = _tmp10_;
#line 212 "/home/luca/repo/wip/tasklet/tasklet_blocking_sockets.vala"
	self->priv->remote_port = (guint16) _tmp11_;
#line 213 "/home/luca/repo/wip/tasklet/tasklet_blocking_sockets.vala"
	_tmp12_ = self->priv->s;
#line 213 "/home/luca/repo/wip/tasklet/tasklet_blocking_sockets.vala"
	_tmp13_ = g_socket_get_local_address (_tmp12_, &_inner_error_);
#line 213 "/home/luca/repo/wip/tasklet/tasklet_blocking_sockets.vala"
	_tmp14_ = _tmp13_;
#line 213 "/home/luca/repo/wip/tasklet/tasklet_blocking_sockets.vala"
	if (_inner_error_ != NULL) {
#line 213 "/home/luca/repo/wip/tasklet/tasklet_blocking_sockets.vala"
		g_propagate_error (error, _inner_error_);
#line 213 "/home/luca/repo/wip/tasklet/tasklet_blocking_sockets.vala"
		_g_object_unref0 (x);
#line 213 "/home/luca/repo/wip/tasklet/tasklet_blocking_sockets.vala"
		_g_object_unref0 (self);
#line 213 "/home/luca/repo/wip/tasklet/tasklet_blocking_sockets.vala"
		return NULL;
#line 1343 "tasklet_blocking_sockets.c"
	}
#line 213 "/home/luca/repo/wip/tasklet/tasklet_blocking_sockets.vala"
	y = G_TYPE_CHECK_INSTANCE_CAST (_tmp14_, g_inet_socket_address_get_type (), GInetSocketAddress);
#line 214 "/home/luca/repo/wip/tasklet/tasklet_blocking_sockets.vala"
	_tmp15_ = y;
#line 214 "/home/luca/repo/wip/tasklet/tasklet_blocking_sockets.vala"
	_tmp16_ = g_inet_socket_address_get_address (_tmp15_);
#line 214 "/home/luca/repo/wip/tasklet/tasklet_blocking_sockets.vala"
	_tmp17_ = _tmp16_;
#line 214 "/home/luca/repo/wip/tasklet/tasklet_blocking_sockets.vala"
	_tmp18_ = g_inet_address_to_string (_tmp17_);
#line 214 "/home/luca/repo/wip/tasklet/tasklet_blocking_sockets.vala"
	_g_free0 (self->priv->local_addr);
#line 214 "/home/luca/repo/wip/tasklet/tasklet_blocking_sockets.vala"
	self->priv->local_addr = _tmp18_;
#line 215 "/home/luca/repo/wip/tasklet/tasklet_blocking_sockets.vala"
	_tmp19_ = y;
#line 215 "/home/luca/repo/wip/tasklet/tasklet_blocking_sockets.vala"
	_tmp20_ = g_inet_socket_address_get_port (_tmp19_);
#line 215 "/home/luca/repo/wip/tasklet/tasklet_blocking_sockets.vala"
	_tmp21_ = _tmp20_;
#line 215 "/home/luca/repo/wip/tasklet/tasklet_blocking_sockets.vala"
	self->priv->local_port = (guint16) _tmp21_;
#line 207 "/home/luca/repo/wip/tasklet/tasklet_blocking_sockets.vala"
	_g_object_unref0 (y);
#line 207 "/home/luca/repo/wip/tasklet/tasklet_blocking_sockets.vala"
	_g_object_unref0 (x);
#line 207 "/home/luca/repo/wip/tasklet/tasklet_blocking_sockets.vala"
	return self;
#line 1373 "tasklet_blocking_sockets.c"
}


TaskletsConnectedStreamSocket* tasklets_connected_stream_socket_new (GSocket* soc, GError** error) {
#line 207 "/home/luca/repo/wip/tasklet/tasklet_blocking_sockets.vala"
	return tasklets_connected_stream_socket_construct (TASKLETS_TYPE_CONNECTED_STREAM_SOCKET, soc, error);
#line 1380 "tasklet_blocking_sockets.c"
}


static guint16 tasklets_connected_stream_socket_real__peer_port_getter (TaskletsIConnectedStreamSocket* base) {
	TaskletsConnectedStreamSocket * self;
	guint16 result = 0U;
	guint16 _tmp0_;
#line 218 "/home/luca/repo/wip/tasklet/tasklet_blocking_sockets.vala"
	self = (TaskletsConnectedStreamSocket*) base;
#line 220 "/home/luca/repo/wip/tasklet/tasklet_blocking_sockets.vala"
	_tmp0_ = self->priv->remote_port;
#line 220 "/home/luca/repo/wip/tasklet/tasklet_blocking_sockets.vala"
	result = _tmp0_;
#line 220 "/home/luca/repo/wip/tasklet/tasklet_blocking_sockets.vala"
	return result;
#line 1396 "tasklet_blocking_sockets.c"
}


static const gchar* tasklets_connected_stream_socket_real__peer_address_getter (TaskletsIConnectedStreamSocket* base) {
	TaskletsConnectedStreamSocket * self;
	const gchar* result = NULL;
	const gchar* _tmp0_;
#line 223 "/home/luca/repo/wip/tasklet/tasklet_blocking_sockets.vala"
	self = (TaskletsConnectedStreamSocket*) base;
#line 225 "/home/luca/repo/wip/tasklet/tasklet_blocking_sockets.vala"
	_tmp0_ = self->priv->remote_addr;
#line 225 "/home/luca/repo/wip/tasklet/tasklet_blocking_sockets.vala"
	result = _tmp0_;
#line 225 "/home/luca/repo/wip/tasklet/tasklet_blocking_sockets.vala"
	return result;
#line 1412 "tasklet_blocking_sockets.c"
}


static guint16 tasklets_connected_stream_socket_real__my_port_getter (TaskletsIConnectedStreamSocket* base) {
	TaskletsConnectedStreamSocket * self;
	guint16 result = 0U;
	guint16 _tmp0_;
#line 228 "/home/luca/repo/wip/tasklet/tasklet_blocking_sockets.vala"
	self = (TaskletsConnectedStreamSocket*) base;
#line 230 "/home/luca/repo/wip/tasklet/tasklet_blocking_sockets.vala"
	_tmp0_ = self->priv->local_port;
#line 230 "/home/luca/repo/wip/tasklet/tasklet_blocking_sockets.vala"
	result = _tmp0_;
#line 230 "/home/luca/repo/wip/tasklet/tasklet_blocking_sockets.vala"
	return result;
#line 1428 "tasklet_blocking_sockets.c"
}


static const gchar* tasklets_connected_stream_socket_real__my_address_getter (TaskletsIConnectedStreamSocket* base) {
	TaskletsConnectedStreamSocket * self;
	const gchar* result = NULL;
	const gchar* _tmp0_;
#line 233 "/home/luca/repo/wip/tasklet/tasklet_blocking_sockets.vala"
	self = (TaskletsConnectedStreamSocket*) base;
#line 235 "/home/luca/repo/wip/tasklet/tasklet_blocking_sockets.vala"
	_tmp0_ = self->priv->local_addr;
#line 235 "/home/luca/repo/wip/tasklet/tasklet_blocking_sockets.vala"
	result = _tmp0_;
#line 235 "/home/luca/repo/wip/tasklet/tasklet_blocking_sockets.vala"
	return result;
#line 1444 "tasklet_blocking_sockets.c"
}


static gint tasklets_connected_stream_socket_real_send_part (TaskletsIConnectedStreamSocket* base, guchar* data, int data_length1, gint maxlen, GError** error) {
	TaskletsConnectedStreamSocket * self;
	gint result = 0;
	gint _tmp0_;
	guchar* _tmp1_ = NULL;
	guchar* buffer;
	gint buffer_length1;
	gint _buffer_size_;
	guchar* _tmp2_;
	gint _tmp2__length1;
	gint _tmp3_;
	GSocket* _tmp4_;
	gssize _tmp5_ = 0L;
	gssize _tmp6_;
	gint ret;
	GError * _inner_error_ = NULL;
#line 238 "/home/luca/repo/wip/tasklet/tasklet_blocking_sockets.vala"
	self = (TaskletsConnectedStreamSocket*) base;
#line 240 "/home/luca/repo/wip/tasklet/tasklet_blocking_sockets.vala"
	_tmp0_ = maxlen;
#line 240 "/home/luca/repo/wip/tasklet/tasklet_blocking_sockets.vala"
	_tmp1_ = g_new0 (guchar, _tmp0_);
#line 240 "/home/luca/repo/wip/tasklet/tasklet_blocking_sockets.vala"
	buffer = _tmp1_;
#line 240 "/home/luca/repo/wip/tasklet/tasklet_blocking_sockets.vala"
	buffer_length1 = _tmp0_;
#line 240 "/home/luca/repo/wip/tasklet/tasklet_blocking_sockets.vala"
	_buffer_size_ = buffer_length1;
#line 241 "/home/luca/repo/wip/tasklet/tasklet_blocking_sockets.vala"
	_tmp2_ = data;
#line 241 "/home/luca/repo/wip/tasklet/tasklet_blocking_sockets.vala"
	_tmp2__length1 = data_length1;
#line 241 "/home/luca/repo/wip/tasklet/tasklet_blocking_sockets.vala"
	_tmp3_ = maxlen;
#line 241 "/home/luca/repo/wip/tasklet/tasklet_blocking_sockets.vala"
	memcpy (buffer, _tmp2_, (gsize) _tmp3_);
#line 242 "/home/luca/repo/wip/tasklet/tasklet_blocking_sockets.vala"
	tasklets_tasklet_tasklet_leaves ("with socket_send");
#line 243 "/home/luca/repo/wip/tasklet/tasklet_blocking_sockets.vala"
	_tmp4_ = self->priv->s;
#line 243 "/home/luca/repo/wip/tasklet/tasklet_blocking_sockets.vala"
	_tmp5_ = wrapped_lib_pth_pth_thread_socket_send (_tmp4_, buffer, buffer_length1, &_inner_error_);
#line 243 "/home/luca/repo/wip/tasklet/tasklet_blocking_sockets.vala"
	_tmp6_ = _tmp5_;
#line 243 "/home/luca/repo/wip/tasklet/tasklet_blocking_sockets.vala"
	if (_inner_error_ != NULL) {
#line 243 "/home/luca/repo/wip/tasklet/tasklet_blocking_sockets.vala"
		g_propagate_error (error, _inner_error_);
#line 243 "/home/luca/repo/wip/tasklet/tasklet_blocking_sockets.vala"
		buffer = (g_free (buffer), NULL);
#line 243 "/home/luca/repo/wip/tasklet/tasklet_blocking_sockets.vala"
		return 0;
#line 1500 "tasklet_blocking_sockets.c"
	}
#line 243 "/home/luca/repo/wip/tasklet/tasklet_blocking_sockets.vala"
	ret = (gint) _tmp6_;
#line 244 "/home/luca/repo/wip/tasklet/tasklet_blocking_sockets.vala"
	tasklets_tasklet_tasklet_regains ("from socket_send");
#line 245 "/home/luca/repo/wip/tasklet/tasklet_blocking_sockets.vala"
	result = ret;
#line 245 "/home/luca/repo/wip/tasklet/tasklet_blocking_sockets.vala"
	buffer = (g_free (buffer), NULL);
#line 245 "/home/luca/repo/wip/tasklet/tasklet_blocking_sockets.vala"
	return result;
#line 1512 "tasklet_blocking_sockets.c"
}


static guchar* tasklets_connected_stream_socket_real_recv (TaskletsIConnectedStreamSocket* base, gint maxlen, int* result_length1, GError** error) {
	TaskletsConnectedStreamSocket * self;
	guchar* result = NULL;
	guchar* ret = NULL;
	gint ret_length1 = 0;
	gint _ret_size_ = 0;
	GSocket* _tmp0_;
	gint _tmp1_;
	guchar* _tmp2_ = NULL;
	gint _tmp3_ = 0;
	guchar* _tmp4_;
	gint _tmp4__length1;
	GError * _inner_error_ = NULL;
#line 248 "/home/luca/repo/wip/tasklet/tasklet_blocking_sockets.vala"
	self = (TaskletsConnectedStreamSocket*) base;
#line 251 "/home/luca/repo/wip/tasklet/tasklet_blocking_sockets.vala"
	tasklets_tasklet_tasklet_leaves ("with socket_recv");
#line 252 "/home/luca/repo/wip/tasklet/tasklet_blocking_sockets.vala"
	_tmp0_ = self->priv->s;
#line 252 "/home/luca/repo/wip/tasklet/tasklet_blocking_sockets.vala"
	_tmp1_ = maxlen;
#line 252 "/home/luca/repo/wip/tasklet/tasklet_blocking_sockets.vala"
	wrapped_lib_pth_pth_thread_socket_recv (_tmp0_, &_tmp2_, &_tmp3_, _tmp1_, &_inner_error_);
#line 252 "/home/luca/repo/wip/tasklet/tasklet_blocking_sockets.vala"
	ret = (g_free (ret), NULL);
#line 252 "/home/luca/repo/wip/tasklet/tasklet_blocking_sockets.vala"
	ret = _tmp2_;
#line 252 "/home/luca/repo/wip/tasklet/tasklet_blocking_sockets.vala"
	ret_length1 = _tmp3_;
#line 252 "/home/luca/repo/wip/tasklet/tasklet_blocking_sockets.vala"
	_ret_size_ = ret_length1;
#line 252 "/home/luca/repo/wip/tasklet/tasklet_blocking_sockets.vala"
	if (_inner_error_ != NULL) {
#line 252 "/home/luca/repo/wip/tasklet/tasklet_blocking_sockets.vala"
		g_propagate_error (error, _inner_error_);
#line 252 "/home/luca/repo/wip/tasklet/tasklet_blocking_sockets.vala"
		ret = (g_free (ret), NULL);
#line 252 "/home/luca/repo/wip/tasklet/tasklet_blocking_sockets.vala"
		return NULL;
#line 1555 "tasklet_blocking_sockets.c"
	}
#line 253 "/home/luca/repo/wip/tasklet/tasklet_blocking_sockets.vala"
	tasklets_tasklet_tasklet_regains ("from socket_recv");
#line 254 "/home/luca/repo/wip/tasklet/tasklet_blocking_sockets.vala"
	_tmp4_ = ret;
#line 254 "/home/luca/repo/wip/tasklet/tasklet_blocking_sockets.vala"
	_tmp4__length1 = ret_length1;
#line 254 "/home/luca/repo/wip/tasklet/tasklet_blocking_sockets.vala"
	if (result_length1) {
#line 254 "/home/luca/repo/wip/tasklet/tasklet_blocking_sockets.vala"
		*result_length1 = _tmp4__length1;
#line 1567 "tasklet_blocking_sockets.c"
	}
#line 254 "/home/luca/repo/wip/tasklet/tasklet_blocking_sockets.vala"
	result = _tmp4_;
#line 254 "/home/luca/repo/wip/tasklet/tasklet_blocking_sockets.vala"
	return result;
#line 1573 "tasklet_blocking_sockets.c"
}


static void tasklets_connected_stream_socket_real_close (TaskletsIConnectedStreamSocket* base, GError** error) {
	TaskletsConnectedStreamSocket * self;
	GSocket* _tmp0_;
	GError * _inner_error_ = NULL;
#line 257 "/home/luca/repo/wip/tasklet/tasklet_blocking_sockets.vala"
	self = (TaskletsConnectedStreamSocket*) base;
#line 259 "/home/luca/repo/wip/tasklet/tasklet_blocking_sockets.vala"
	_tmp0_ = self->priv->s;
#line 259 "/home/luca/repo/wip/tasklet/tasklet_blocking_sockets.vala"
	g_socket_close (_tmp0_, &_inner_error_);
#line 259 "/home/luca/repo/wip/tasklet/tasklet_blocking_sockets.vala"
	if (_inner_error_ != NULL) {
#line 259 "/home/luca/repo/wip/tasklet/tasklet_blocking_sockets.vala"
		g_propagate_error (error, _inner_error_);
#line 259 "/home/luca/repo/wip/tasklet/tasklet_blocking_sockets.vala"
		return;
#line 1593 "tasklet_blocking_sockets.c"
	}
}


static void tasklets_connected_stream_socket_class_init (TaskletsConnectedStreamSocketClass * klass) {
#line 200 "/home/luca/repo/wip/tasklet/tasklet_blocking_sockets.vala"
	tasklets_connected_stream_socket_parent_class = g_type_class_peek_parent (klass);
#line 200 "/home/luca/repo/wip/tasklet/tasklet_blocking_sockets.vala"
	g_type_class_add_private (klass, sizeof (TaskletsConnectedStreamSocketPrivate));
#line 200 "/home/luca/repo/wip/tasklet/tasklet_blocking_sockets.vala"
	G_OBJECT_CLASS (klass)->finalize = tasklets_connected_stream_socket_finalize;
#line 1605 "tasklet_blocking_sockets.c"
}


static void tasklets_connected_stream_socket_tasklets_iconnected_stream_socket_interface_init (TaskletsIConnectedStreamSocketIface * iface) {
#line 200 "/home/luca/repo/wip/tasklet/tasklet_blocking_sockets.vala"
	tasklets_connected_stream_socket_tasklets_iconnected_stream_socket_parent_iface = g_type_interface_peek_parent (iface);
#line 200 "/home/luca/repo/wip/tasklet/tasklet_blocking_sockets.vala"
	iface->_peer_port_getter = (guint16 (*)(TaskletsIConnectedStreamSocket*)) tasklets_connected_stream_socket_real__peer_port_getter;
#line 200 "/home/luca/repo/wip/tasklet/tasklet_blocking_sockets.vala"
	iface->_peer_address_getter = (const gchar* (*)(TaskletsIConnectedStreamSocket*)) tasklets_connected_stream_socket_real__peer_address_getter;
#line 200 "/home/luca/repo/wip/tasklet/tasklet_blocking_sockets.vala"
	iface->_my_port_getter = (guint16 (*)(TaskletsIConnectedStreamSocket*)) tasklets_connected_stream_socket_real__my_port_getter;
#line 200 "/home/luca/repo/wip/tasklet/tasklet_blocking_sockets.vala"
	iface->_my_address_getter = (const gchar* (*)(TaskletsIConnectedStreamSocket*)) tasklets_connected_stream_socket_real__my_address_getter;
#line 200 "/home/luca/repo/wip/tasklet/tasklet_blocking_sockets.vala"
	iface->send_part = (gint (*)(TaskletsIConnectedStreamSocket*, guchar*, int, gint, GError**)) tasklets_connected_stream_socket_real_send_part;
#line 200 "/home/luca/repo/wip/tasklet/tasklet_blocking_sockets.vala"
	iface->recv = (guchar* (*)(TaskletsIConnectedStreamSocket*, gint, int*, GError**)) tasklets_connected_stream_socket_real_recv;
#line 200 "/home/luca/repo/wip/tasklet/tasklet_blocking_sockets.vala"
	iface->close = (void (*)(TaskletsIConnectedStreamSocket*, GError**)) tasklets_connected_stream_socket_real_close;
#line 1626 "tasklet_blocking_sockets.c"
}


static void tasklets_connected_stream_socket_instance_init (TaskletsConnectedStreamSocket * self) {
#line 200 "/home/luca/repo/wip/tasklet/tasklet_blocking_sockets.vala"
	self->priv = TASKLETS_CONNECTED_STREAM_SOCKET_GET_PRIVATE (self);
#line 1633 "tasklet_blocking_sockets.c"
}


static void tasklets_connected_stream_socket_finalize (GObject* obj) {
	TaskletsConnectedStreamSocket * self;
#line 200 "/home/luca/repo/wip/tasklet/tasklet_blocking_sockets.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TASKLETS_TYPE_CONNECTED_STREAM_SOCKET, TaskletsConnectedStreamSocket);
#line 202 "/home/luca/repo/wip/tasklet/tasklet_blocking_sockets.vala"
	_g_object_unref0 (self->priv->s);
#line 203 "/home/luca/repo/wip/tasklet/tasklet_blocking_sockets.vala"
	_g_free0 (self->priv->remote_addr);
#line 205 "/home/luca/repo/wip/tasklet/tasklet_blocking_sockets.vala"
	_g_free0 (self->priv->local_addr);
#line 200 "/home/luca/repo/wip/tasklet/tasklet_blocking_sockets.vala"
	G_OBJECT_CLASS (tasklets_connected_stream_socket_parent_class)->finalize (obj);
#line 1649 "tasklet_blocking_sockets.c"
}


GType tasklets_connected_stream_socket_get_type (void) {
	static volatile gsize tasklets_connected_stream_socket_type_id__volatile = 0;
	if (g_once_init_enter (&tasklets_connected_stream_socket_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (TaskletsConnectedStreamSocketClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) tasklets_connected_stream_socket_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (TaskletsConnectedStreamSocket), 0, (GInstanceInitFunc) tasklets_connected_stream_socket_instance_init, NULL };
		static const GInterfaceInfo tasklets_iconnected_stream_socket_info = { (GInterfaceInitFunc) tasklets_connected_stream_socket_tasklets_iconnected_stream_socket_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
		GType tasklets_connected_stream_socket_type_id;
		tasklets_connected_stream_socket_type_id = g_type_register_static (G_TYPE_OBJECT, "TaskletsConnectedStreamSocket", &g_define_type_info, 0);
		g_type_add_interface_static (tasklets_connected_stream_socket_type_id, TASKLETS_TYPE_ICONNECTED_STREAM_SOCKET, &tasklets_iconnected_stream_socket_info);
		g_once_init_leave (&tasklets_connected_stream_socket_type_id__volatile, tasklets_connected_stream_socket_type_id);
	}
	return tasklets_connected_stream_socket_type_id__volatile;
}


TaskletsServerDatagramSocket* tasklets_server_datagram_socket_construct (GType object_type, guint16 port, const gchar* bind_ip, const gchar* dev, GError** error) {
	TaskletsServerDatagramSocket * self = NULL;
	GSocket* _tmp0_;
	GSocket* _tmp1_;
	const gchar* _tmp2_;
	const gchar* _tmp5_;
	GError * _inner_error_ = NULL;
#line 274 "/home/luca/repo/wip/tasklet/tasklet_blocking_sockets.vala"
	self = (TaskletsServerDatagramSocket*) g_object_new (object_type, NULL);
#line 276 "/home/luca/repo/wip/tasklet/tasklet_blocking_sockets.vala"
	_tmp0_ = g_socket_new (G_SOCKET_FAMILY_IPV4, G_SOCKET_TYPE_DATAGRAM, G_SOCKET_PROTOCOL_UDP, &_inner_error_);
#line 276 "/home/luca/repo/wip/tasklet/tasklet_blocking_sockets.vala"
	_tmp1_ = _tmp0_;
#line 276 "/home/luca/repo/wip/tasklet/tasklet_blocking_sockets.vala"
	if (_inner_error_ != NULL) {
#line 276 "/home/luca/repo/wip/tasklet/tasklet_blocking_sockets.vala"
		g_propagate_error (error, _inner_error_);
#line 276 "/home/luca/repo/wip/tasklet/tasklet_blocking_sockets.vala"
		_g_object_unref0 (self);
#line 276 "/home/luca/repo/wip/tasklet/tasklet_blocking_sockets.vala"
		return NULL;
#line 1688 "tasklet_blocking_sockets.c"
	}
#line 276 "/home/luca/repo/wip/tasklet/tasklet_blocking_sockets.vala"
	_g_object_unref0 (self->priv->s);
#line 276 "/home/luca/repo/wip/tasklet/tasklet_blocking_sockets.vala"
	self->priv->s = _tmp1_;
#line 277 "/home/luca/repo/wip/tasklet/tasklet_blocking_sockets.vala"
	_tmp2_ = dev;
#line 277 "/home/luca/repo/wip/tasklet/tasklet_blocking_sockets.vala"
	if (_tmp2_ != NULL) {
#line 1698 "tasklet_blocking_sockets.c"
		GSocket* _tmp3_;
		const gchar* _tmp4_;
#line 278 "/home/luca/repo/wip/tasklet/tasklet_blocking_sockets.vala"
		_tmp3_ = self->priv->s;
#line 278 "/home/luca/repo/wip/tasklet/tasklet_blocking_sockets.vala"
		_tmp4_ = dev;
#line 278 "/home/luca/repo/wip/tasklet/tasklet_blocking_sockets.vala"
		tasklets_sk_bindtodevice (_tmp3_, _tmp4_, &_inner_error_);
#line 278 "/home/luca/repo/wip/tasklet/tasklet_blocking_sockets.vala"
		if (_inner_error_ != NULL) {
#line 278 "/home/luca/repo/wip/tasklet/tasklet_blocking_sockets.vala"
			g_propagate_error (error, _inner_error_);
#line 278 "/home/luca/repo/wip/tasklet/tasklet_blocking_sockets.vala"
			_g_object_unref0 (self);
#line 278 "/home/luca/repo/wip/tasklet/tasklet_blocking_sockets.vala"
			return NULL;
#line 1715 "tasklet_blocking_sockets.c"
		}
	}
#line 279 "/home/luca/repo/wip/tasklet/tasklet_blocking_sockets.vala"
	_tmp5_ = bind_ip;
#line 279 "/home/luca/repo/wip/tasklet/tasklet_blocking_sockets.vala"
	if (_tmp5_ == NULL) {
#line 1722 "tasklet_blocking_sockets.c"
		GSocket* _tmp6_;
		GInetAddress* _tmp7_;
		GInetAddress* _tmp8_;
		guint16 _tmp9_;
		GInetSocketAddress* _tmp10_;
		GInetSocketAddress* _tmp11_;
#line 280 "/home/luca/repo/wip/tasklet/tasklet_blocking_sockets.vala"
		_tmp6_ = self->priv->s;
#line 280 "/home/luca/repo/wip/tasklet/tasklet_blocking_sockets.vala"
		_tmp7_ = g_inet_address_new_any (G_SOCKET_FAMILY_IPV4);
#line 280 "/home/luca/repo/wip/tasklet/tasklet_blocking_sockets.vala"
		_tmp8_ = _tmp7_;
#line 280 "/home/luca/repo/wip/tasklet/tasklet_blocking_sockets.vala"
		_tmp9_ = port;
#line 280 "/home/luca/repo/wip/tasklet/tasklet_blocking_sockets.vala"
		_tmp10_ = (GInetSocketAddress*) g_inet_socket_address_new (_tmp8_, _tmp9_);
#line 280 "/home/luca/repo/wip/tasklet/tasklet_blocking_sockets.vala"
		_tmp11_ = _tmp10_;
#line 280 "/home/luca/repo/wip/tasklet/tasklet_blocking_sockets.vala"
		g_socket_bind (_tmp6_, (GSocketAddress*) _tmp11_, TRUE, &_inner_error_);
#line 280 "/home/luca/repo/wip/tasklet/tasklet_blocking_sockets.vala"
		_g_object_unref0 (_tmp11_);
#line 280 "/home/luca/repo/wip/tasklet/tasklet_blocking_sockets.vala"
		_g_object_unref0 (_tmp8_);
#line 280 "/home/luca/repo/wip/tasklet/tasklet_blocking_sockets.vala"
		if (_inner_error_ != NULL) {
#line 280 "/home/luca/repo/wip/tasklet/tasklet_blocking_sockets.vala"
			g_propagate_error (error, _inner_error_);
#line 280 "/home/luca/repo/wip/tasklet/tasklet_blocking_sockets.vala"
			_g_object_unref0 (self);
#line 280 "/home/luca/repo/wip/tasklet/tasklet_blocking_sockets.vala"
			return NULL;
#line 1755 "tasklet_blocking_sockets.c"
		}
	} else {
		GSocket* _tmp12_;
		const gchar* _tmp13_;
		GInetAddress* _tmp14_;
		GInetAddress* _tmp15_;
		guint16 _tmp16_;
		GInetSocketAddress* _tmp17_;
		GInetSocketAddress* _tmp18_;
#line 282 "/home/luca/repo/wip/tasklet/tasklet_blocking_sockets.vala"
		_tmp12_ = self->priv->s;
#line 282 "/home/luca/repo/wip/tasklet/tasklet_blocking_sockets.vala"
		_tmp13_ = bind_ip;
#line 282 "/home/luca/repo/wip/tasklet/tasklet_blocking_sockets.vala"
		_tmp14_ = g_inet_address_new_from_string (_tmp13_);
#line 282 "/home/luca/repo/wip/tasklet/tasklet_blocking_sockets.vala"
		_tmp15_ = _tmp14_;
#line 282 "/home/luca/repo/wip/tasklet/tasklet_blocking_sockets.vala"
		_tmp16_ = port;
#line 282 "/home/luca/repo/wip/tasklet/tasklet_blocking_sockets.vala"
		_tmp17_ = (GInetSocketAddress*) g_inet_socket_address_new (_tmp15_, _tmp16_);
#line 282 "/home/luca/repo/wip/tasklet/tasklet_blocking_sockets.vala"
		_tmp18_ = _tmp17_;
#line 282 "/home/luca/repo/wip/tasklet/tasklet_blocking_sockets.vala"
		g_socket_bind (_tmp12_, (GSocketAddress*) _tmp18_, TRUE, &_inner_error_);
#line 282 "/home/luca/repo/wip/tasklet/tasklet_blocking_sockets.vala"
		_g_object_unref0 (_tmp18_);
#line 282 "/home/luca/repo/wip/tasklet/tasklet_blocking_sockets.vala"
		_g_object_unref0 (_tmp15_);
#line 282 "/home/luca/repo/wip/tasklet/tasklet_blocking_sockets.vala"
		if (_inner_error_ != NULL) {
#line 282 "/home/luca/repo/wip/tasklet/tasklet_blocking_sockets.vala"
			g_propagate_error (error, _inner_error_);
#line 282 "/home/luca/repo/wip/tasklet/tasklet_blocking_sockets.vala"
			_g_object_unref0 (self);
#line 282 "/home/luca/repo/wip/tasklet/tasklet_blocking_sockets.vala"
			return NULL;
#line 1793 "tasklet_blocking_sockets.c"
		}
	}
#line 274 "/home/luca/repo/wip/tasklet/tasklet_blocking_sockets.vala"
	return self;
#line 1798 "tasklet_blocking_sockets.c"
}


TaskletsServerDatagramSocket* tasklets_server_datagram_socket_new (guint16 port, const gchar* bind_ip, const gchar* dev, GError** error) {
#line 274 "/home/luca/repo/wip/tasklet/tasklet_blocking_sockets.vala"
	return tasklets_server_datagram_socket_construct (TASKLETS_TYPE_SERVER_DATAGRAM_SOCKET, port, bind_ip, dev, error);
#line 1805 "tasklet_blocking_sockets.c"
}


guchar* tasklets_server_datagram_socket_recvfrom (TaskletsServerDatagramSocket* self, gint maxsize, gchar** rmt_ip, guint16* rmt_port, int* result_length1, GError** error) {
	gchar* _vala_rmt_ip = NULL;
	guint16 _vala_rmt_port = 0U;
	guchar* result = NULL;
	guchar* ret = NULL;
	gint ret_length1 = 0;
	gint _ret_size_ = 0;
	GSocket* _tmp0_;
	gint _tmp1_;
	guchar* _tmp2_ = NULL;
	gint _tmp3_ = 0;
	gchar* _tmp4_ = NULL;
	guint16 _tmp5_ = 0U;
	guchar* _tmp6_;
	gint _tmp6__length1;
	GError * _inner_error_ = NULL;
#line 285 "/home/luca/repo/wip/tasklet/tasklet_blocking_sockets.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 288 "/home/luca/repo/wip/tasklet/tasklet_blocking_sockets.vala"
	tasklets_tasklet_tasklet_leaves ("with socket_recvfrom");
#line 289 "/home/luca/repo/wip/tasklet/tasklet_blocking_sockets.vala"
	_tmp0_ = self->priv->s;
#line 289 "/home/luca/repo/wip/tasklet/tasklet_blocking_sockets.vala"
	_tmp1_ = maxsize;
#line 289 "/home/luca/repo/wip/tasklet/tasklet_blocking_sockets.vala"
	wrapped_lib_pth_pth_thread_socket_recvfrom (_tmp0_, &_tmp2_, &_tmp3_, _tmp1_, &_tmp4_, &_tmp5_, &_inner_error_);
#line 289 "/home/luca/repo/wip/tasklet/tasklet_blocking_sockets.vala"
	ret = (g_free (ret), NULL);
#line 289 "/home/luca/repo/wip/tasklet/tasklet_blocking_sockets.vala"
	ret = _tmp2_;
#line 289 "/home/luca/repo/wip/tasklet/tasklet_blocking_sockets.vala"
	ret_length1 = _tmp3_;
#line 289 "/home/luca/repo/wip/tasklet/tasklet_blocking_sockets.vala"
	_ret_size_ = ret_length1;
#line 289 "/home/luca/repo/wip/tasklet/tasklet_blocking_sockets.vala"
	_g_free0 (_vala_rmt_ip);
#line 289 "/home/luca/repo/wip/tasklet/tasklet_blocking_sockets.vala"
	_vala_rmt_ip = _tmp4_;
#line 289 "/home/luca/repo/wip/tasklet/tasklet_blocking_sockets.vala"
	_vala_rmt_port = _tmp5_;
#line 289 "/home/luca/repo/wip/tasklet/tasklet_blocking_sockets.vala"
	if (_inner_error_ != NULL) {
#line 289 "/home/luca/repo/wip/tasklet/tasklet_blocking_sockets.vala"
		g_propagate_error (error, _inner_error_);
#line 289 "/home/luca/repo/wip/tasklet/tasklet_blocking_sockets.vala"
		ret = (g_free (ret), NULL);
#line 289 "/home/luca/repo/wip/tasklet/tasklet_blocking_sockets.vala"
		return NULL;
#line 1857 "tasklet_blocking_sockets.c"
	}
#line 290 "/home/luca/repo/wip/tasklet/tasklet_blocking_sockets.vala"
	tasklets_tasklet_tasklet_regains ("from socket_recvfrom");
#line 291 "/home/luca/repo/wip/tasklet/tasklet_blocking_sockets.vala"
	_tmp6_ = ret;
#line 291 "/home/luca/repo/wip/tasklet/tasklet_blocking_sockets.vala"
	_tmp6__length1 = ret_length1;
#line 291 "/home/luca/repo/wip/tasklet/tasklet_blocking_sockets.vala"
	if (result_length1) {
#line 291 "/home/luca/repo/wip/tasklet/tasklet_blocking_sockets.vala"
		*result_length1 = _tmp6__length1;
#line 1869 "tasklet_blocking_sockets.c"
	}
#line 291 "/home/luca/repo/wip/tasklet/tasklet_blocking_sockets.vala"
	result = _tmp6_;
#line 291 "/home/luca/repo/wip/tasklet/tasklet_blocking_sockets.vala"
	if (rmt_ip) {
#line 291 "/home/luca/repo/wip/tasklet/tasklet_blocking_sockets.vala"
		*rmt_ip = _vala_rmt_ip;
#line 1877 "tasklet_blocking_sockets.c"
	} else {
#line 291 "/home/luca/repo/wip/tasklet/tasklet_blocking_sockets.vala"
		_g_free0 (_vala_rmt_ip);
#line 1881 "tasklet_blocking_sockets.c"
	}
#line 291 "/home/luca/repo/wip/tasklet/tasklet_blocking_sockets.vala"
	if (rmt_port) {
#line 291 "/home/luca/repo/wip/tasklet/tasklet_blocking_sockets.vala"
		*rmt_port = _vala_rmt_port;
#line 1887 "tasklet_blocking_sockets.c"
	}
#line 291 "/home/luca/repo/wip/tasklet/tasklet_blocking_sockets.vala"
	return result;
#line 1891 "tasklet_blocking_sockets.c"
}


void tasklets_server_datagram_socket_sendto (TaskletsServerDatagramSocket* self, guchar* mesg, int mesg_length1, const gchar* rmt_ip, guint16 rmt_port, GError** error) {
	GSocket* _tmp0_;
	guchar* _tmp1_;
	gint _tmp1__length1;
	const gchar* _tmp2_;
	guint16 _tmp3_;
	GError * _inner_error_ = NULL;
#line 294 "/home/luca/repo/wip/tasklet/tasklet_blocking_sockets.vala"
	g_return_if_fail (self != NULL);
#line 294 "/home/luca/repo/wip/tasklet/tasklet_blocking_sockets.vala"
	g_return_if_fail (rmt_ip != NULL);
#line 296 "/home/luca/repo/wip/tasklet/tasklet_blocking_sockets.vala"
	tasklets_tasklet_tasklet_leaves ("with socket_sendto");
#line 297 "/home/luca/repo/wip/tasklet/tasklet_blocking_sockets.vala"
	_tmp0_ = self->priv->s;
#line 297 "/home/luca/repo/wip/tasklet/tasklet_blocking_sockets.vala"
	_tmp1_ = mesg;
#line 297 "/home/luca/repo/wip/tasklet/tasklet_blocking_sockets.vala"
	_tmp1__length1 = mesg_length1;
#line 297 "/home/luca/repo/wip/tasklet/tasklet_blocking_sockets.vala"
	_tmp2_ = rmt_ip;
#line 297 "/home/luca/repo/wip/tasklet/tasklet_blocking_sockets.vala"
	_tmp3_ = rmt_port;
#line 297 "/home/luca/repo/wip/tasklet/tasklet_blocking_sockets.vala"
	wrapped_lib_pth_pth_thread_socket_sendto (_tmp0_, _tmp1_, _tmp1__length1, _tmp2_, _tmp3_, &_inner_error_);
#line 297 "/home/luca/repo/wip/tasklet/tasklet_blocking_sockets.vala"
	if (_inner_error_ != NULL) {
#line 297 "/home/luca/repo/wip/tasklet/tasklet_blocking_sockets.vala"
		g_propagate_error (error, _inner_error_);
#line 297 "/home/luca/repo/wip/tasklet/tasklet_blocking_sockets.vala"
		return;
#line 1926 "tasklet_blocking_sockets.c"
	}
#line 298 "/home/luca/repo/wip/tasklet/tasklet_blocking_sockets.vala"
	tasklets_tasklet_tasklet_regains ("from socket_sendto");
#line 1930 "tasklet_blocking_sockets.c"
}


void tasklets_server_datagram_socket_close (TaskletsServerDatagramSocket* self, GError** error) {
	GSocket* _tmp0_;
	GError * _inner_error_ = NULL;
#line 301 "/home/luca/repo/wip/tasklet/tasklet_blocking_sockets.vala"
	g_return_if_fail (self != NULL);
#line 303 "/home/luca/repo/wip/tasklet/tasklet_blocking_sockets.vala"
	_tmp0_ = self->priv->s;
#line 303 "/home/luca/repo/wip/tasklet/tasklet_blocking_sockets.vala"
	g_socket_close (_tmp0_, &_inner_error_);
#line 303 "/home/luca/repo/wip/tasklet/tasklet_blocking_sockets.vala"
	if (_inner_error_ != NULL) {
#line 303 "/home/luca/repo/wip/tasklet/tasklet_blocking_sockets.vala"
		g_propagate_error (error, _inner_error_);
#line 303 "/home/luca/repo/wip/tasklet/tasklet_blocking_sockets.vala"
		return;
#line 1949 "tasklet_blocking_sockets.c"
	}
}


static void tasklets_server_datagram_socket_class_init (TaskletsServerDatagramSocketClass * klass) {
#line 270 "/home/luca/repo/wip/tasklet/tasklet_blocking_sockets.vala"
	tasklets_server_datagram_socket_parent_class = g_type_class_peek_parent (klass);
#line 270 "/home/luca/repo/wip/tasklet/tasklet_blocking_sockets.vala"
	g_type_class_add_private (klass, sizeof (TaskletsServerDatagramSocketPrivate));
#line 270 "/home/luca/repo/wip/tasklet/tasklet_blocking_sockets.vala"
	G_OBJECT_CLASS (klass)->finalize = tasklets_server_datagram_socket_finalize;
#line 1961 "tasklet_blocking_sockets.c"
}


static void tasklets_server_datagram_socket_instance_init (TaskletsServerDatagramSocket * self) {
#line 270 "/home/luca/repo/wip/tasklet/tasklet_blocking_sockets.vala"
	self->priv = TASKLETS_SERVER_DATAGRAM_SOCKET_GET_PRIVATE (self);
#line 1968 "tasklet_blocking_sockets.c"
}


static void tasklets_server_datagram_socket_finalize (GObject* obj) {
	TaskletsServerDatagramSocket * self;
	GError * _inner_error_ = NULL;
#line 270 "/home/luca/repo/wip/tasklet/tasklet_blocking_sockets.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TASKLETS_TYPE_SERVER_DATAGRAM_SOCKET, TaskletsServerDatagramSocket);
#line 308 "/home/luca/repo/wip/tasklet/tasklet_blocking_sockets.vala"
	tasklets_server_datagram_socket_close (self, &_inner_error_);
#line 308 "/home/luca/repo/wip/tasklet/tasklet_blocking_sockets.vala"
	if (_inner_error_ != NULL) {
#line 308 "/home/luca/repo/wip/tasklet/tasklet_blocking_sockets.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 308 "/home/luca/repo/wip/tasklet/tasklet_blocking_sockets.vala"
		g_clear_error (&_inner_error_);
#line 1985 "tasklet_blocking_sockets.c"
	}
#line 272 "/home/luca/repo/wip/tasklet/tasklet_blocking_sockets.vala"
	_g_object_unref0 (self->priv->s);
#line 270 "/home/luca/repo/wip/tasklet/tasklet_blocking_sockets.vala"
	G_OBJECT_CLASS (tasklets_server_datagram_socket_parent_class)->finalize (obj);
#line 1991 "tasklet_blocking_sockets.c"
}


/** Use this class to implement a UDP datagram oriented service.
      * The call to recvfrom blocks only the current tasklet, not the whole
      *  application.
      * You can use this same object to send a response to the caller.
      * Or else handle the request on another tasklet and, when necessary,
      *  use an BroadcastClientDatagramSocket to send a reply.
      */
GType tasklets_server_datagram_socket_get_type (void) {
	static volatile gsize tasklets_server_datagram_socket_type_id__volatile = 0;
	if (g_once_init_enter (&tasklets_server_datagram_socket_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (TaskletsServerDatagramSocketClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) tasklets_server_datagram_socket_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (TaskletsServerDatagramSocket), 0, (GInstanceInitFunc) tasklets_server_datagram_socket_instance_init, NULL };
		GType tasklets_server_datagram_socket_type_id;
		tasklets_server_datagram_socket_type_id = g_type_register_static (G_TYPE_OBJECT, "TaskletsServerDatagramSocket", &g_define_type_info, 0);
		g_once_init_leave (&tasklets_server_datagram_socket_type_id__volatile, tasklets_server_datagram_socket_type_id);
	}
	return tasklets_server_datagram_socket_type_id__volatile;
}


TaskletsBroadcastClientDatagramSocket* tasklets_broadcast_client_datagram_socket_construct (GType object_type, const gchar* dev, guint16 port, GError** error) {
	TaskletsBroadcastClientDatagramSocket * self = NULL;
	guint16 _tmp0_;
	const gchar* _tmp1_;
	GSocket* _tmp2_;
	GSocket* _tmp3_;
	GSocket* _tmp4_;
	const gchar* _tmp5_;
	GSocket* _tmp6_;
	GError * _inner_error_ = NULL;
#line 321 "/home/luca/repo/wip/tasklet/tasklet_blocking_sockets.vala"
	g_return_val_if_fail (dev != NULL, NULL);
#line 321 "/home/luca/repo/wip/tasklet/tasklet_blocking_sockets.vala"
	self = (TaskletsBroadcastClientDatagramSocket*) g_object_new (object_type, NULL);
#line 323 "/home/luca/repo/wip/tasklet/tasklet_blocking_sockets.vala"
	_tmp0_ = port;
#line 323 "/home/luca/repo/wip/tasklet/tasklet_blocking_sockets.vala"
	self->priv->port = _tmp0_;
#line 324 "/home/luca/repo/wip/tasklet/tasklet_blocking_sockets.vala"
	_tmp1_ = dev;
#line 324 "/home/luca/repo/wip/tasklet/tasklet_blocking_sockets.vala"
	tasklets_broadcast_client_datagram_socket_set_dev (self, _tmp1_);
#line 325 "/home/luca/repo/wip/tasklet/tasklet_blocking_sockets.vala"
	_tmp2_ = g_socket_new (G_SOCKET_FAMILY_IPV4, G_SOCKET_TYPE_DATAGRAM, G_SOCKET_PROTOCOL_UDP, &_inner_error_);
#line 325 "/home/luca/repo/wip/tasklet/tasklet_blocking_sockets.vala"
	_tmp3_ = _tmp2_;
#line 325 "/home/luca/repo/wip/tasklet/tasklet_blocking_sockets.vala"
	if (_inner_error_ != NULL) {
#line 325 "/home/luca/repo/wip/tasklet/tasklet_blocking_sockets.vala"
		g_propagate_error (error, _inner_error_);
#line 325 "/home/luca/repo/wip/tasklet/tasklet_blocking_sockets.vala"
		_g_object_unref0 (self);
#line 325 "/home/luca/repo/wip/tasklet/tasklet_blocking_sockets.vala"
		return NULL;
#line 2048 "tasklet_blocking_sockets.c"
	}
#line 325 "/home/luca/repo/wip/tasklet/tasklet_blocking_sockets.vala"
	_g_object_unref0 (self->priv->s);
#line 325 "/home/luca/repo/wip/tasklet/tasklet_blocking_sockets.vala"
	self->priv->s = _tmp3_;
#line 326 "/home/luca/repo/wip/tasklet/tasklet_blocking_sockets.vala"
	_tmp4_ = self->priv->s;
#line 326 "/home/luca/repo/wip/tasklet/tasklet_blocking_sockets.vala"
	_tmp5_ = dev;
#line 326 "/home/luca/repo/wip/tasklet/tasklet_blocking_sockets.vala"
	tasklets_sk_bindtodevice (_tmp4_, _tmp5_, &_inner_error_);
#line 326 "/home/luca/repo/wip/tasklet/tasklet_blocking_sockets.vala"
	if (_inner_error_ != NULL) {
#line 326 "/home/luca/repo/wip/tasklet/tasklet_blocking_sockets.vala"
		g_propagate_error (error, _inner_error_);
#line 326 "/home/luca/repo/wip/tasklet/tasklet_blocking_sockets.vala"
		_g_object_unref0 (self);
#line 326 "/home/luca/repo/wip/tasklet/tasklet_blocking_sockets.vala"
		return NULL;
#line 2068 "tasklet_blocking_sockets.c"
	}
#line 327 "/home/luca/repo/wip/tasklet/tasklet_blocking_sockets.vala"
	_tmp6_ = self->priv->s;
#line 327 "/home/luca/repo/wip/tasklet/tasklet_blocking_sockets.vala"
	tasklets_sk_setbroadcast (_tmp6_, &_inner_error_);
#line 327 "/home/luca/repo/wip/tasklet/tasklet_blocking_sockets.vala"
	if (_inner_error_ != NULL) {
#line 327 "/home/luca/repo/wip/tasklet/tasklet_blocking_sockets.vala"
		g_propagate_error (error, _inner_error_);
#line 327 "/home/luca/repo/wip/tasklet/tasklet_blocking_sockets.vala"
		_g_object_unref0 (self);
#line 327 "/home/luca/repo/wip/tasklet/tasklet_blocking_sockets.vala"
		return NULL;
#line 2082 "tasklet_blocking_sockets.c"
	}
#line 321 "/home/luca/repo/wip/tasklet/tasklet_blocking_sockets.vala"
	return self;
#line 2086 "tasklet_blocking_sockets.c"
}


TaskletsBroadcastClientDatagramSocket* tasklets_broadcast_client_datagram_socket_new (const gchar* dev, guint16 port, GError** error) {
#line 321 "/home/luca/repo/wip/tasklet/tasklet_blocking_sockets.vala"
	return tasklets_broadcast_client_datagram_socket_construct (TASKLETS_TYPE_BROADCAST_CLIENT_DATAGRAM_SOCKET, dev, port, error);
#line 2093 "tasklet_blocking_sockets.c"
}


void tasklets_broadcast_client_datagram_socket_send (TaskletsBroadcastClientDatagramSocket* self, guchar* mesg, int mesg_length1, GError** error) {
	GSocket* _tmp0_;
	guchar* _tmp1_;
	gint _tmp1__length1;
	guint16 _tmp2_;
	GError * _inner_error_ = NULL;
#line 330 "/home/luca/repo/wip/tasklet/tasklet_blocking_sockets.vala"
	g_return_if_fail (self != NULL);
#line 332 "/home/luca/repo/wip/tasklet/tasklet_blocking_sockets.vala"
	tasklets_tasklet_tasklet_leaves ("with socket_sendtobroad");
#line 333 "/home/luca/repo/wip/tasklet/tasklet_blocking_sockets.vala"
	_tmp0_ = self->priv->s;
#line 333 "/home/luca/repo/wip/tasklet/tasklet_blocking_sockets.vala"
	_tmp1_ = mesg;
#line 333 "/home/luca/repo/wip/tasklet/tasklet_blocking_sockets.vala"
	_tmp1__length1 = mesg_length1;
#line 333 "/home/luca/repo/wip/tasklet/tasklet_blocking_sockets.vala"
	_tmp2_ = self->priv->port;
#line 333 "/home/luca/repo/wip/tasklet/tasklet_blocking_sockets.vala"
	wrapped_lib_pth_pth_thread_socket_sendto (_tmp0_, _tmp1_, _tmp1__length1, "255.255.255.255", _tmp2_, &_inner_error_);
#line 333 "/home/luca/repo/wip/tasklet/tasklet_blocking_sockets.vala"
	if (_inner_error_ != NULL) {
#line 333 "/home/luca/repo/wip/tasklet/tasklet_blocking_sockets.vala"
		g_propagate_error (error, _inner_error_);
#line 333 "/home/luca/repo/wip/tasklet/tasklet_blocking_sockets.vala"
		return;
#line 2123 "tasklet_blocking_sockets.c"
	}
#line 334 "/home/luca/repo/wip/tasklet/tasklet_blocking_sockets.vala"
	tasklets_tasklet_tasklet_regains ("from socket_sendtobroad");
#line 2127 "tasklet_blocking_sockets.c"
}


void tasklets_broadcast_client_datagram_socket_close (TaskletsBroadcastClientDatagramSocket* self, GError** error) {
	GSocket* _tmp0_;
	GError * _inner_error_ = NULL;
#line 337 "/home/luca/repo/wip/tasklet/tasklet_blocking_sockets.vala"
	g_return_if_fail (self != NULL);
#line 339 "/home/luca/repo/wip/tasklet/tasklet_blocking_sockets.vala"
	_tmp0_ = self->priv->s;
#line 339 "/home/luca/repo/wip/tasklet/tasklet_blocking_sockets.vala"
	g_socket_close (_tmp0_, &_inner_error_);
#line 339 "/home/luca/repo/wip/tasklet/tasklet_blocking_sockets.vala"
	if (_inner_error_ != NULL) {
#line 339 "/home/luca/repo/wip/tasklet/tasklet_blocking_sockets.vala"
		g_propagate_error (error, _inner_error_);
#line 339 "/home/luca/repo/wip/tasklet/tasklet_blocking_sockets.vala"
		return;
#line 2146 "tasklet_blocking_sockets.c"
	}
}


const gchar* tasklets_broadcast_client_datagram_socket_get_dev (TaskletsBroadcastClientDatagramSocket* self) {
	const gchar* result;
	const gchar* _tmp0_;
#line 319 "/home/luca/repo/wip/tasklet/tasklet_blocking_sockets.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 319 "/home/luca/repo/wip/tasklet/tasklet_blocking_sockets.vala"
	_tmp0_ = self->priv->_dev;
#line 319 "/home/luca/repo/wip/tasklet/tasklet_blocking_sockets.vala"
	result = _tmp0_;
#line 319 "/home/luca/repo/wip/tasklet/tasklet_blocking_sockets.vala"
	return result;
#line 2162 "tasklet_blocking_sockets.c"
}


static void tasklets_broadcast_client_datagram_socket_set_dev (TaskletsBroadcastClientDatagramSocket* self, const gchar* value) {
	const gchar* _tmp0_;
	gchar* _tmp1_;
#line 319 "/home/luca/repo/wip/tasklet/tasklet_blocking_sockets.vala"
	g_return_if_fail (self != NULL);
#line 319 "/home/luca/repo/wip/tasklet/tasklet_blocking_sockets.vala"
	_tmp0_ = value;
#line 319 "/home/luca/repo/wip/tasklet/tasklet_blocking_sockets.vala"
	_tmp1_ = g_strdup (_tmp0_);
#line 319 "/home/luca/repo/wip/tasklet/tasklet_blocking_sockets.vala"
	_g_free0 (self->priv->_dev);
#line 319 "/home/luca/repo/wip/tasklet/tasklet_blocking_sockets.vala"
	self->priv->_dev = _tmp1_;
#line 319 "/home/luca/repo/wip/tasklet/tasklet_blocking_sockets.vala"
	g_object_notify ((GObject *) self, "dev");
#line 2181 "tasklet_blocking_sockets.c"
}


static void tasklets_broadcast_client_datagram_socket_class_init (TaskletsBroadcastClientDatagramSocketClass * klass) {
#line 315 "/home/luca/repo/wip/tasklet/tasklet_blocking_sockets.vala"
	tasklets_broadcast_client_datagram_socket_parent_class = g_type_class_peek_parent (klass);
#line 315 "/home/luca/repo/wip/tasklet/tasklet_blocking_sockets.vala"
	g_type_class_add_private (klass, sizeof (TaskletsBroadcastClientDatagramSocketPrivate));
#line 315 "/home/luca/repo/wip/tasklet/tasklet_blocking_sockets.vala"
	G_OBJECT_CLASS (klass)->get_property = _vala_tasklets_broadcast_client_datagram_socket_get_property;
#line 315 "/home/luca/repo/wip/tasklet/tasklet_blocking_sockets.vala"
	G_OBJECT_CLASS (klass)->set_property = _vala_tasklets_broadcast_client_datagram_socket_set_property;
#line 315 "/home/luca/repo/wip/tasklet/tasklet_blocking_sockets.vala"
	G_OBJECT_CLASS (klass)->finalize = tasklets_broadcast_client_datagram_socket_finalize;
#line 315 "/home/luca/repo/wip/tasklet/tasklet_blocking_sockets.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), TASKLETS_BROADCAST_CLIENT_DATAGRAM_SOCKET_DEV, g_param_spec_string ("dev", "dev", "dev", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
#line 2198 "tasklet_blocking_sockets.c"
}


static void tasklets_broadcast_client_datagram_socket_instance_init (TaskletsBroadcastClientDatagramSocket * self) {
#line 315 "/home/luca/repo/wip/tasklet/tasklet_blocking_sockets.vala"
	self->priv = TASKLETS_BROADCAST_CLIENT_DATAGRAM_SOCKET_GET_PRIVATE (self);
#line 2205 "tasklet_blocking_sockets.c"
}


static void tasklets_broadcast_client_datagram_socket_finalize (GObject* obj) {
	TaskletsBroadcastClientDatagramSocket * self;
#line 315 "/home/luca/repo/wip/tasklet/tasklet_blocking_sockets.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TASKLETS_TYPE_BROADCAST_CLIENT_DATAGRAM_SOCKET, TaskletsBroadcastClientDatagramSocket);
#line 317 "/home/luca/repo/wip/tasklet/tasklet_blocking_sockets.vala"
	_g_object_unref0 (self->priv->s);
#line 319 "/home/luca/repo/wip/tasklet/tasklet_blocking_sockets.vala"
	_g_free0 (self->priv->_dev);
#line 315 "/home/luca/repo/wip/tasklet/tasklet_blocking_sockets.vala"
	G_OBJECT_CLASS (tasklets_broadcast_client_datagram_socket_parent_class)->finalize (obj);
#line 2219 "tasklet_blocking_sockets.c"
}


/** Use this class to send a single UDP datagram in broadcast over
      *  a particular interface.
      */
GType tasklets_broadcast_client_datagram_socket_get_type (void) {
	static volatile gsize tasklets_broadcast_client_datagram_socket_type_id__volatile = 0;
	if (g_once_init_enter (&tasklets_broadcast_client_datagram_socket_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (TaskletsBroadcastClientDatagramSocketClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) tasklets_broadcast_client_datagram_socket_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (TaskletsBroadcastClientDatagramSocket), 0, (GInstanceInitFunc) tasklets_broadcast_client_datagram_socket_instance_init, NULL };
		GType tasklets_broadcast_client_datagram_socket_type_id;
		tasklets_broadcast_client_datagram_socket_type_id = g_type_register_static (G_TYPE_OBJECT, "TaskletsBroadcastClientDatagramSocket", &g_define_type_info, 0);
		g_once_init_leave (&tasklets_broadcast_client_datagram_socket_type_id__volatile, tasklets_broadcast_client_datagram_socket_type_id);
	}
	return tasklets_broadcast_client_datagram_socket_type_id__volatile;
}


static void _vala_tasklets_broadcast_client_datagram_socket_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	TaskletsBroadcastClientDatagramSocket * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TASKLETS_TYPE_BROADCAST_CLIENT_DATAGRAM_SOCKET, TaskletsBroadcastClientDatagramSocket);
#line 315 "/home/luca/repo/wip/tasklet/tasklet_blocking_sockets.vala"
	switch (property_id) {
#line 315 "/home/luca/repo/wip/tasklet/tasklet_blocking_sockets.vala"
		case TASKLETS_BROADCAST_CLIENT_DATAGRAM_SOCKET_DEV:
#line 315 "/home/luca/repo/wip/tasklet/tasklet_blocking_sockets.vala"
		g_value_set_string (value, tasklets_broadcast_client_datagram_socket_get_dev (self));
#line 315 "/home/luca/repo/wip/tasklet/tasklet_blocking_sockets.vala"
		break;
#line 2249 "tasklet_blocking_sockets.c"
		default:
#line 315 "/home/luca/repo/wip/tasklet/tasklet_blocking_sockets.vala"
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
#line 315 "/home/luca/repo/wip/tasklet/tasklet_blocking_sockets.vala"
		break;
#line 2255 "tasklet_blocking_sockets.c"
	}
}


static void _vala_tasklets_broadcast_client_datagram_socket_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	TaskletsBroadcastClientDatagramSocket * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TASKLETS_TYPE_BROADCAST_CLIENT_DATAGRAM_SOCKET, TaskletsBroadcastClientDatagramSocket);
#line 315 "/home/luca/repo/wip/tasklet/tasklet_blocking_sockets.vala"
	switch (property_id) {
#line 315 "/home/luca/repo/wip/tasklet/tasklet_blocking_sockets.vala"
		case TASKLETS_BROADCAST_CLIENT_DATAGRAM_SOCKET_DEV:
#line 315 "/home/luca/repo/wip/tasklet/tasklet_blocking_sockets.vala"
		tasklets_broadcast_client_datagram_socket_set_dev (self, g_value_get_string (value));
#line 315 "/home/luca/repo/wip/tasklet/tasklet_blocking_sockets.vala"
		break;
#line 2271 "tasklet_blocking_sockets.c"
		default:
#line 315 "/home/luca/repo/wip/tasklet/tasklet_blocking_sockets.vala"
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
#line 315 "/home/luca/repo/wip/tasklet/tasklet_blocking_sockets.vala"
		break;
#line 2277 "tasklet_blocking_sockets.c"
	}
}


static guint8* string_get_data (const gchar* self, int* result_length1) {
	guint8* result;
	guint8* res;
	gint res_length1;
	gint _res_size_;
	gint _tmp0_;
	gint _tmp1_;
	gint _tmp2_;
	guint8* _tmp3_;
	gint _tmp3__length1;
	guint8* _tmp4_;
	gint _tmp4__length1;
#line 1260 "/usr/share/vala-0.20/vapi/glib-2.0.vapi"
	g_return_val_if_fail (self != NULL, NULL);
#line 1261 "/usr/share/vala-0.20/vapi/glib-2.0.vapi"
	res = (guint8*) self;
#line 1261 "/usr/share/vala-0.20/vapi/glib-2.0.vapi"
	res_length1 = -1;
#line 1261 "/usr/share/vala-0.20/vapi/glib-2.0.vapi"
	_res_size_ = res_length1;
#line 1262 "/usr/share/vala-0.20/vapi/glib-2.0.vapi"
	_tmp0_ = strlen (self);
#line 1262 "/usr/share/vala-0.20/vapi/glib-2.0.vapi"
	_tmp1_ = _tmp0_;
#line 1262 "/usr/share/vala-0.20/vapi/glib-2.0.vapi"
	res_length1 = (gint) _tmp1_;
#line 1262 "/usr/share/vala-0.20/vapi/glib-2.0.vapi"
	_tmp2_ = res_length1;
#line 1263 "/usr/share/vala-0.20/vapi/glib-2.0.vapi"
	_tmp3_ = res;
#line 1263 "/usr/share/vala-0.20/vapi/glib-2.0.vapi"
	_tmp3__length1 = res_length1;
#line 1263 "/usr/share/vala-0.20/vapi/glib-2.0.vapi"
	_tmp4_ = _tmp3_;
#line 1263 "/usr/share/vala-0.20/vapi/glib-2.0.vapi"
	_tmp4__length1 = _tmp3__length1;
#line 1263 "/usr/share/vala-0.20/vapi/glib-2.0.vapi"
	if (result_length1) {
#line 1263 "/usr/share/vala-0.20/vapi/glib-2.0.vapi"
		*result_length1 = _tmp4__length1;
#line 2322 "tasklet_blocking_sockets.c"
	}
#line 1263 "/usr/share/vala-0.20/vapi/glib-2.0.vapi"
	result = _tmp4_;
#line 1263 "/usr/share/vala-0.20/vapi/glib-2.0.vapi"
	return result;
#line 2328 "tasklet_blocking_sockets.c"
}


static const gchar* string_to_string (const gchar* self) {
	const gchar* result = NULL;
#line 1274 "/usr/share/vala-0.20/vapi/glib-2.0.vapi"
	g_return_val_if_fail (self != NULL, NULL);
#line 1275 "/usr/share/vala-0.20/vapi/glib-2.0.vapi"
	result = self;
#line 1275 "/usr/share/vala-0.20/vapi/glib-2.0.vapi"
	return result;
#line 2340 "tasklet_blocking_sockets.c"
}


void tasklets_sk_bindtodevice (GSocket* s, const gchar* ifname, GError** error) {
	const gchar* _tmp0_;
	gint _tmp1_;
	gint _tmp2_;
	GSocket* _tmp3_;
	gint _tmp4_ = 0;
	gint fd;
	struct ifreq xx = {0};
	const gchar* _tmp5_;
	guint8* _tmp6_;
	gint _tmp6__length1;
	guint8* _tmp7_;
	gint _tmp7__length1;
	const gchar* _tmp8_;
	gint _tmp9_;
	gint _tmp10_;
	gint _tmp11_;
	gint _tmp12_ = 0;
	gint ret;
	gint _tmp13_;
	gint errnum;
	gint _tmp14_;
	GError * _inner_error_ = NULL;
#line 343 "/home/luca/repo/wip/tasklet/tasklet_blocking_sockets.vala"
	g_return_if_fail (s != NULL);
#line 343 "/home/luca/repo/wip/tasklet/tasklet_blocking_sockets.vala"
	g_return_if_fail (ifname != NULL);
#line 347 "/home/luca/repo/wip/tasklet/tasklet_blocking_sockets.vala"
	_tmp0_ = ifname;
#line 347 "/home/luca/repo/wip/tasklet/tasklet_blocking_sockets.vala"
	_tmp1_ = strlen (_tmp0_);
#line 347 "/home/luca/repo/wip/tasklet/tasklet_blocking_sockets.vala"
	_tmp2_ = _tmp1_;
#line 347 "/home/luca/repo/wip/tasklet/tasklet_blocking_sockets.vala"
	_vala_assert (_tmp2_ <= 16, "ifname.length <= 16");
#line 349 "/home/luca/repo/wip/tasklet/tasklet_blocking_sockets.vala"
	_tmp3_ = s;
#line 349 "/home/luca/repo/wip/tasklet/tasklet_blocking_sockets.vala"
	_tmp4_ = g_socket_get_fd (_tmp3_);
#line 349 "/home/luca/repo/wip/tasklet/tasklet_blocking_sockets.vala"
	fd = _tmp4_;
#line 350 "/home/luca/repo/wip/tasklet/tasklet_blocking_sockets.vala"
	memset (&xx, 0, sizeof (struct ifreq));
#line 351 "/home/luca/repo/wip/tasklet/tasklet_blocking_sockets.vala"
	_tmp5_ = ifname;
#line 351 "/home/luca/repo/wip/tasklet/tasklet_blocking_sockets.vala"
	_tmp6_ = string_get_data (_tmp5_, &_tmp6__length1);
#line 351 "/home/luca/repo/wip/tasklet/tasklet_blocking_sockets.vala"
	_tmp7_ = _tmp6_;
#line 351 "/home/luca/repo/wip/tasklet/tasklet_blocking_sockets.vala"
	_tmp7__length1 = _tmp6__length1;
#line 351 "/home/luca/repo/wip/tasklet/tasklet_blocking_sockets.vala"
	_tmp8_ = ifname;
#line 351 "/home/luca/repo/wip/tasklet/tasklet_blocking_sockets.vala"
	_tmp9_ = strlen (_tmp8_);
#line 351 "/home/luca/repo/wip/tasklet/tasklet_blocking_sockets.vala"
	_tmp10_ = _tmp9_;
#line 351 "/home/luca/repo/wip/tasklet/tasklet_blocking_sockets.vala"
	memcpy (&xx.ifr_name, _tmp7_, (gsize) _tmp10_);
#line 352 "/home/luca/repo/wip/tasklet/tasklet_blocking_sockets.vala"
	_tmp11_ = fd;
#line 352 "/home/luca/repo/wip/tasklet/tasklet_blocking_sockets.vala"
	_tmp12_ = setsockopt (_tmp11_, SOL_SOCKET, SO_BINDTODEVICE, &xx, (socklen_t) sizeof (struct ifreq));
#line 352 "/home/luca/repo/wip/tasklet/tasklet_blocking_sockets.vala"
	ret = _tmp12_;
#line 353 "/home/luca/repo/wip/tasklet/tasklet_blocking_sockets.vala"
	_tmp13_ = errno;
#line 353 "/home/luca/repo/wip/tasklet/tasklet_blocking_sockets.vala"
	errnum = _tmp13_;
#line 354 "/home/luca/repo/wip/tasklet/tasklet_blocking_sockets.vala"
	_tmp14_ = ret;
#line 354 "/home/luca/repo/wip/tasklet/tasklet_blocking_sockets.vala"
	if (_tmp14_ != 0) {
#line 2417 "tasklet_blocking_sockets.c"
		const gchar* _tmp15_;
		const gchar* _tmp16_ = NULL;
		gint _tmp17_;
		const gchar* _tmp18_ = NULL;
		const gchar* _tmp19_ = NULL;
		gchar* _tmp20_ = NULL;
		gchar* _tmp21_;
		GError* _tmp22_;
		GError* _tmp23_;
#line 355 "/home/luca/repo/wip/tasklet/tasklet_blocking_sockets.vala"
		_tmp15_ = ifname;
#line 355 "/home/luca/repo/wip/tasklet/tasklet_blocking_sockets.vala"
		_tmp16_ = string_to_string (_tmp15_);
#line 355 "/home/luca/repo/wip/tasklet/tasklet_blocking_sockets.vala"
		_tmp17_ = errnum;
#line 355 "/home/luca/repo/wip/tasklet/tasklet_blocking_sockets.vala"
		_tmp18_ = g_strerror (_tmp17_);
#line 355 "/home/luca/repo/wip/tasklet/tasklet_blocking_sockets.vala"
		_tmp19_ = string_to_string (_tmp18_);
#line 355 "/home/luca/repo/wip/tasklet/tasklet_blocking_sockets.vala"
		_tmp20_ = g_strconcat ("setsockopt(BINDTODEVICE, ", _tmp16_, "): ", _tmp19_, NULL);
#line 355 "/home/luca/repo/wip/tasklet/tasklet_blocking_sockets.vala"
		_tmp21_ = _tmp20_;
#line 355 "/home/luca/repo/wip/tasklet/tasklet_blocking_sockets.vala"
		_tmp22_ = g_error_new_literal (G_IO_ERROR, G_IO_ERROR_FAILED, _tmp21_);
#line 355 "/home/luca/repo/wip/tasklet/tasklet_blocking_sockets.vala"
		_tmp23_ = _tmp22_;
#line 355 "/home/luca/repo/wip/tasklet/tasklet_blocking_sockets.vala"
		_g_free0 (_tmp21_);
#line 355 "/home/luca/repo/wip/tasklet/tasklet_blocking_sockets.vala"
		_inner_error_ = _tmp23_;
#line 355 "/home/luca/repo/wip/tasklet/tasklet_blocking_sockets.vala"
		g_propagate_error (error, _inner_error_);
#line 355 "/home/luca/repo/wip/tasklet/tasklet_blocking_sockets.vala"
		 (&xx);
#line 355 "/home/luca/repo/wip/tasklet/tasklet_blocking_sockets.vala"
		return;
#line 2455 "tasklet_blocking_sockets.c"
	}
#line 343 "/home/luca/repo/wip/tasklet/tasklet_blocking_sockets.vala"
	 (&xx);
#line 2459 "tasklet_blocking_sockets.c"
}


void tasklets_sk_setbroadcast (GSocket* s, GError** error) {
	gint broadcast_value;
	GSocket* _tmp0_;
	gint _tmp1_ = 0;
	gint fd;
	gint _tmp2_;
	gint _tmp3_ = 0;
	gint ret;
	gint _tmp4_;
	gint errnum;
	gint _tmp5_;
	GError * _inner_error_ = NULL;
#line 358 "/home/luca/repo/wip/tasklet/tasklet_blocking_sockets.vala"
	g_return_if_fail (s != NULL);
#line 361 "/home/luca/repo/wip/tasklet/tasklet_blocking_sockets.vala"
	broadcast_value = 1;
#line 362 "/home/luca/repo/wip/tasklet/tasklet_blocking_sockets.vala"
	_tmp0_ = s;
#line 362 "/home/luca/repo/wip/tasklet/tasklet_blocking_sockets.vala"
	_tmp1_ = g_socket_get_fd (_tmp0_);
#line 362 "/home/luca/repo/wip/tasklet/tasklet_blocking_sockets.vala"
	fd = _tmp1_;
#line 363 "/home/luca/repo/wip/tasklet/tasklet_blocking_sockets.vala"
	_tmp2_ = fd;
#line 363 "/home/luca/repo/wip/tasklet/tasklet_blocking_sockets.vala"
	_tmp3_ = setsockopt (_tmp2_, SOL_SOCKET, SO_BROADCAST, &broadcast_value, (socklen_t) sizeof (gint));
#line 363 "/home/luca/repo/wip/tasklet/tasklet_blocking_sockets.vala"
	ret = _tmp3_;
#line 364 "/home/luca/repo/wip/tasklet/tasklet_blocking_sockets.vala"
	_tmp4_ = errno;
#line 364 "/home/luca/repo/wip/tasklet/tasklet_blocking_sockets.vala"
	errnum = _tmp4_;
#line 365 "/home/luca/repo/wip/tasklet/tasklet_blocking_sockets.vala"
	_tmp5_ = ret;
#line 365 "/home/luca/repo/wip/tasklet/tasklet_blocking_sockets.vala"
	if (_tmp5_ != 0) {
#line 2499 "tasklet_blocking_sockets.c"
		gint _tmp6_;
		const gchar* _tmp7_ = NULL;
		const gchar* _tmp8_ = NULL;
		gchar* _tmp9_ = NULL;
		gchar* _tmp10_;
		GError* _tmp11_;
		GError* _tmp12_;
#line 366 "/home/luca/repo/wip/tasklet/tasklet_blocking_sockets.vala"
		_tmp6_ = errnum;
#line 366 "/home/luca/repo/wip/tasklet/tasklet_blocking_sockets.vala"
		_tmp7_ = g_strerror (_tmp6_);
#line 366 "/home/luca/repo/wip/tasklet/tasklet_blocking_sockets.vala"
		_tmp8_ = string_to_string (_tmp7_);
#line 366 "/home/luca/repo/wip/tasklet/tasklet_blocking_sockets.vala"
		_tmp9_ = g_strconcat ("setsockopt(BROADCAST, true): ", _tmp8_, NULL);
#line 366 "/home/luca/repo/wip/tasklet/tasklet_blocking_sockets.vala"
		_tmp10_ = _tmp9_;
#line 366 "/home/luca/repo/wip/tasklet/tasklet_blocking_sockets.vala"
		_tmp11_ = g_error_new_literal (G_IO_ERROR, G_IO_ERROR_FAILED, _tmp10_);
#line 366 "/home/luca/repo/wip/tasklet/tasklet_blocking_sockets.vala"
		_tmp12_ = _tmp11_;
#line 366 "/home/luca/repo/wip/tasklet/tasklet_blocking_sockets.vala"
		_g_free0 (_tmp10_);
#line 366 "/home/luca/repo/wip/tasklet/tasklet_blocking_sockets.vala"
		_inner_error_ = _tmp12_;
#line 366 "/home/luca/repo/wip/tasklet/tasklet_blocking_sockets.vala"
		g_propagate_error (error, _inner_error_);
#line 366 "/home/luca/repo/wip/tasklet/tasklet_blocking_sockets.vala"
		return;
#line 2529 "tasklet_blocking_sockets.c"
	}
}



