/* serializer.c generated by valac 0.20.1, the Vala compiler
 * generated from serializer.vala, do not modify */

/*
 *  This file is part of Netsukuku.
 *  (c) Copyright 2011 Luca Dionisi aka lukisi <luca.dionisi@gmail.com>
 *
 *  Netsukuku is free software: you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation, either version 3 of the License, or
 *  (at your option) any later version.
 *
 *  Netsukuku is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with Netsukuku.  If not, see <http://www.gnu.org/licenses/>.
 */
/** Serializable classes for basic types **/

#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <gee.h>
#include <arpa/inet.h>


#define ZCD_TYPE_ISERIALIZABLE (zcd_iserializable_get_type ())
#define ZCD_ISERIALIZABLE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), ZCD_TYPE_ISERIALIZABLE, zcdISerializable))
#define ZCD_IS_ISERIALIZABLE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), ZCD_TYPE_ISERIALIZABLE))
#define ZCD_ISERIALIZABLE_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), ZCD_TYPE_ISERIALIZABLE, zcdISerializableIface))

typedef struct _zcdISerializable zcdISerializable;
typedef struct _zcdISerializableIface zcdISerializableIface;
#define _g_variant_unref0(var) ((var == NULL) ? NULL : (var = (g_variant_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))

#define ZCD_TYPE_BUFFER_OWNER (zcd_buffer_owner_get_type ())
#define ZCD_BUFFER_OWNER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), ZCD_TYPE_BUFFER_OWNER, zcdBufferOwner))
#define ZCD_BUFFER_OWNER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), ZCD_TYPE_BUFFER_OWNER, zcdBufferOwnerClass))
#define ZCD_IS_BUFFER_OWNER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), ZCD_TYPE_BUFFER_OWNER))
#define ZCD_IS_BUFFER_OWNER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), ZCD_TYPE_BUFFER_OWNER))
#define ZCD_BUFFER_OWNER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), ZCD_TYPE_BUFFER_OWNER, zcdBufferOwnerClass))

typedef struct _zcdBufferOwner zcdBufferOwner;
typedef struct _zcdBufferOwnerClass zcdBufferOwnerClass;
#define _g_variant_type_free0(var) ((var == NULL) ? NULL : (var = (g_variant_type_free (var), NULL)))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
typedef struct _zcdBufferOwnerPrivate zcdBufferOwnerPrivate;

#define ZCD_TYPE_SERIALIZABLE_NONE (zcd_serializable_none_get_type ())
#define ZCD_SERIALIZABLE_NONE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), ZCD_TYPE_SERIALIZABLE_NONE, zcdSerializableNone))
#define ZCD_SERIALIZABLE_NONE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), ZCD_TYPE_SERIALIZABLE_NONE, zcdSerializableNoneClass))
#define ZCD_IS_SERIALIZABLE_NONE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), ZCD_TYPE_SERIALIZABLE_NONE))
#define ZCD_IS_SERIALIZABLE_NONE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), ZCD_TYPE_SERIALIZABLE_NONE))
#define ZCD_SERIALIZABLE_NONE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), ZCD_TYPE_SERIALIZABLE_NONE, zcdSerializableNoneClass))

typedef struct _zcdSerializableNone zcdSerializableNone;
typedef struct _zcdSerializableNoneClass zcdSerializableNoneClass;
typedef struct _zcdSerializableNonePrivate zcdSerializableNonePrivate;

#define ZCD_TYPE_SERIALIZABLE_INT (zcd_serializable_int_get_type ())
#define ZCD_SERIALIZABLE_INT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), ZCD_TYPE_SERIALIZABLE_INT, zcdSerializableInt))
#define ZCD_SERIALIZABLE_INT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), ZCD_TYPE_SERIALIZABLE_INT, zcdSerializableIntClass))
#define ZCD_IS_SERIALIZABLE_INT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), ZCD_TYPE_SERIALIZABLE_INT))
#define ZCD_IS_SERIALIZABLE_INT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), ZCD_TYPE_SERIALIZABLE_INT))
#define ZCD_SERIALIZABLE_INT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), ZCD_TYPE_SERIALIZABLE_INT, zcdSerializableIntClass))

typedef struct _zcdSerializableInt zcdSerializableInt;
typedef struct _zcdSerializableIntClass zcdSerializableIntClass;
typedef struct _zcdSerializableIntPrivate zcdSerializableIntPrivate;

#define ZCD_TYPE_SERIALIZABLE_BOOL (zcd_serializable_bool_get_type ())
#define ZCD_SERIALIZABLE_BOOL(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), ZCD_TYPE_SERIALIZABLE_BOOL, zcdSerializableBool))
#define ZCD_SERIALIZABLE_BOOL_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), ZCD_TYPE_SERIALIZABLE_BOOL, zcdSerializableBoolClass))
#define ZCD_IS_SERIALIZABLE_BOOL(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), ZCD_TYPE_SERIALIZABLE_BOOL))
#define ZCD_IS_SERIALIZABLE_BOOL_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), ZCD_TYPE_SERIALIZABLE_BOOL))
#define ZCD_SERIALIZABLE_BOOL_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), ZCD_TYPE_SERIALIZABLE_BOOL, zcdSerializableBoolClass))

typedef struct _zcdSerializableBool zcdSerializableBool;
typedef struct _zcdSerializableBoolClass zcdSerializableBoolClass;
typedef struct _zcdSerializableBoolPrivate zcdSerializableBoolPrivate;

#define ZCD_TYPE_SERIALIZABLE_STRING (zcd_serializable_string_get_type ())
#define ZCD_SERIALIZABLE_STRING(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), ZCD_TYPE_SERIALIZABLE_STRING, zcdSerializableString))
#define ZCD_SERIALIZABLE_STRING_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), ZCD_TYPE_SERIALIZABLE_STRING, zcdSerializableStringClass))
#define ZCD_IS_SERIALIZABLE_STRING(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), ZCD_TYPE_SERIALIZABLE_STRING))
#define ZCD_IS_SERIALIZABLE_STRING_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), ZCD_TYPE_SERIALIZABLE_STRING))
#define ZCD_SERIALIZABLE_STRING_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), ZCD_TYPE_SERIALIZABLE_STRING, zcdSerializableStringClass))

typedef struct _zcdSerializableString zcdSerializableString;
typedef struct _zcdSerializableStringClass zcdSerializableStringClass;
typedef struct _zcdSerializableStringPrivate zcdSerializableStringPrivate;

#define ZCD_TYPE_SERIALIZABLE_BUFFER (zcd_serializable_buffer_get_type ())
#define ZCD_SERIALIZABLE_BUFFER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), ZCD_TYPE_SERIALIZABLE_BUFFER, zcdSerializableBuffer))
#define ZCD_SERIALIZABLE_BUFFER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), ZCD_TYPE_SERIALIZABLE_BUFFER, zcdSerializableBufferClass))
#define ZCD_IS_SERIALIZABLE_BUFFER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), ZCD_TYPE_SERIALIZABLE_BUFFER))
#define ZCD_IS_SERIALIZABLE_BUFFER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), ZCD_TYPE_SERIALIZABLE_BUFFER))
#define ZCD_SERIALIZABLE_BUFFER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), ZCD_TYPE_SERIALIZABLE_BUFFER, zcdSerializableBufferClass))

typedef struct _zcdSerializableBuffer zcdSerializableBuffer;
typedef struct _zcdSerializableBufferClass zcdSerializableBufferClass;
typedef struct _zcdSerializableBufferPrivate zcdSerializableBufferPrivate;

#define ZCD_TYPE_LIST_STRING (zcd_list_string_get_type ())
#define ZCD_LIST_STRING(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), ZCD_TYPE_LIST_STRING, zcdListString))
#define ZCD_LIST_STRING_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), ZCD_TYPE_LIST_STRING, zcdListStringClass))
#define ZCD_IS_LIST_STRING(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), ZCD_TYPE_LIST_STRING))
#define ZCD_IS_LIST_STRING_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), ZCD_TYPE_LIST_STRING))
#define ZCD_LIST_STRING_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), ZCD_TYPE_LIST_STRING, zcdListStringClass))

typedef struct _zcdListString zcdListString;
typedef struct _zcdListStringClass zcdListStringClass;
typedef struct _zcdListStringPrivate zcdListStringPrivate;

#define ZCD_TYPE_LIST_ISERIALIZABLE (zcd_list_iserializable_get_type ())
#define ZCD_LIST_ISERIALIZABLE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), ZCD_TYPE_LIST_ISERIALIZABLE, zcdListISerializable))
#define ZCD_LIST_ISERIALIZABLE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), ZCD_TYPE_LIST_ISERIALIZABLE, zcdListISerializableClass))
#define ZCD_IS_LIST_ISERIALIZABLE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), ZCD_TYPE_LIST_ISERIALIZABLE))
#define ZCD_IS_LIST_ISERIALIZABLE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), ZCD_TYPE_LIST_ISERIALIZABLE))
#define ZCD_LIST_ISERIALIZABLE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), ZCD_TYPE_LIST_ISERIALIZABLE, zcdListISerializableClass))

typedef struct _zcdListISerializable zcdListISerializable;
typedef struct _zcdListISerializableClass zcdListISerializableClass;
typedef struct _zcdListISerializablePrivate zcdListISerializablePrivate;

#define ZCD_TYPE_REMOTE_CALL (zcd_remote_call_get_type ())
#define ZCD_REMOTE_CALL(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), ZCD_TYPE_REMOTE_CALL, zcdRemoteCall))
#define ZCD_REMOTE_CALL_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), ZCD_TYPE_REMOTE_CALL, zcdRemoteCallClass))
#define ZCD_IS_REMOTE_CALL(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), ZCD_TYPE_REMOTE_CALL))
#define ZCD_IS_REMOTE_CALL_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), ZCD_TYPE_REMOTE_CALL))
#define ZCD_REMOTE_CALL_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), ZCD_TYPE_REMOTE_CALL, zcdRemoteCallClass))

typedef struct _zcdRemoteCall zcdRemoteCall;
typedef struct _zcdRemoteCallClass zcdRemoteCallClass;

#define ZCD_TYPE_REMOTABLE_EXCEPTION (zcd_remotable_exception_get_type ())
#define ZCD_REMOTABLE_EXCEPTION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), ZCD_TYPE_REMOTABLE_EXCEPTION, zcdRemotableException))
#define ZCD_REMOTABLE_EXCEPTION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), ZCD_TYPE_REMOTABLE_EXCEPTION, zcdRemotableExceptionClass))
#define ZCD_IS_REMOTABLE_EXCEPTION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), ZCD_TYPE_REMOTABLE_EXCEPTION))
#define ZCD_IS_REMOTABLE_EXCEPTION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), ZCD_TYPE_REMOTABLE_EXCEPTION))
#define ZCD_REMOTABLE_EXCEPTION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), ZCD_TYPE_REMOTABLE_EXCEPTION, zcdRemotableExceptionClass))

typedef struct _zcdRemotableException zcdRemotableException;
typedef struct _zcdRemotableExceptionClass zcdRemotableExceptionClass;

#define ZCD_TYPE_TCP_REQUEST (zcd_tcp_request_get_type ())
#define ZCD_TCP_REQUEST(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), ZCD_TYPE_TCP_REQUEST, zcdTCPRequest))
#define ZCD_TCP_REQUEST_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), ZCD_TYPE_TCP_REQUEST, zcdTCPRequestClass))
#define ZCD_IS_TCP_REQUEST(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), ZCD_TYPE_TCP_REQUEST))
#define ZCD_IS_TCP_REQUEST_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), ZCD_TYPE_TCP_REQUEST))
#define ZCD_TCP_REQUEST_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), ZCD_TYPE_TCP_REQUEST, zcdTCPRequestClass))

typedef struct _zcdTCPRequest zcdTCPRequest;
typedef struct _zcdTCPRequestClass zcdTCPRequestClass;

#define ZCD_TYPE_UDP_MESSAGE (zcd_udp_message_get_type ())
#define ZCD_UDP_MESSAGE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), ZCD_TYPE_UDP_MESSAGE, zcdUDPMessage))
#define ZCD_UDP_MESSAGE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), ZCD_TYPE_UDP_MESSAGE, zcdUDPMessageClass))
#define ZCD_IS_UDP_MESSAGE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), ZCD_TYPE_UDP_MESSAGE))
#define ZCD_IS_UDP_MESSAGE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), ZCD_TYPE_UDP_MESSAGE))
#define ZCD_UDP_MESSAGE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), ZCD_TYPE_UDP_MESSAGE, zcdUDPMessageClass))

typedef struct _zcdUDPMessage zcdUDPMessage;
typedef struct _zcdUDPMessageClass zcdUDPMessageClass;

#define ZCD_TYPE_UDP_PAYLOAD (zcd_udp_payload_get_type ())
#define ZCD_UDP_PAYLOAD(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), ZCD_TYPE_UDP_PAYLOAD, zcdUDPPayload))
#define ZCD_UDP_PAYLOAD_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), ZCD_TYPE_UDP_PAYLOAD, zcdUDPPayloadClass))
#define ZCD_IS_UDP_PAYLOAD(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), ZCD_TYPE_UDP_PAYLOAD))
#define ZCD_IS_UDP_PAYLOAD_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), ZCD_TYPE_UDP_PAYLOAD))
#define ZCD_UDP_PAYLOAD_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), ZCD_TYPE_UDP_PAYLOAD, zcdUDPPayloadClass))

typedef struct _zcdUDPPayload zcdUDPPayload;
typedef struct _zcdUDPPayloadClass zcdUDPPayloadClass;
#define _g_variant_iter_free0(var) ((var == NULL) ? NULL : (var = (g_variant_iter_free (var), NULL)))
#define _vala_assert(expr, msg) if G_LIKELY (expr) ; else g_assertion_message_expr (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);

typedef enum  {
	ZCD_SERIALIZER_ERROR_GENERIC
} zcdSerializerError;
#define ZCD_SERIALIZER_ERROR zcd_serializer_error_quark ()
struct _zcdISerializableIface {
	GTypeInterface parent_iface;
	GVariant* (*serialize_to_variant) (zcdISerializable* self);
	void (*deserialize_from_variant) (zcdISerializable* self, GVariant* v, GError** error);
};

struct _zcdBufferOwner {
	GObject parent_instance;
	zcdBufferOwnerPrivate * priv;
};

struct _zcdBufferOwnerClass {
	GObjectClass parent_class;
};

struct _zcdBufferOwnerPrivate {
	guchar* _buf;
	gint _buf_length1;
	gint __buf_size_;
};

struct _zcdSerializableNone {
	GObject parent_instance;
	zcdSerializableNonePrivate * priv;
};

struct _zcdSerializableNoneClass {
	GObjectClass parent_class;
};

struct _zcdSerializableInt {
	GObject parent_instance;
	zcdSerializableIntPrivate * priv;
};

struct _zcdSerializableIntClass {
	GObjectClass parent_class;
};

struct _zcdSerializableIntPrivate {
	gint _i;
};

struct _zcdSerializableBool {
	GObject parent_instance;
	zcdSerializableBoolPrivate * priv;
};

struct _zcdSerializableBoolClass {
	GObjectClass parent_class;
};

struct _zcdSerializableBoolPrivate {
	gint _i;
};

struct _zcdSerializableString {
	GObject parent_instance;
	zcdSerializableStringPrivate * priv;
};

struct _zcdSerializableStringClass {
	GObjectClass parent_class;
};

struct _zcdSerializableStringPrivate {
	gchar* _s;
};

struct _zcdSerializableBuffer {
	GObject parent_instance;
	zcdSerializableBufferPrivate * priv;
};

struct _zcdSerializableBufferClass {
	GObjectClass parent_class;
};

struct _zcdSerializableBufferPrivate {
	guint8* _buffer;
	gint _buffer_length1;
	gint __buffer_size_;
};

struct _zcdListString {
	GObject parent_instance;
	zcdListStringPrivate * priv;
	GeeList* backed;
};

struct _zcdListStringClass {
	GObjectClass parent_class;
};

struct _zcdListISerializable {
	GObject parent_instance;
	zcdListISerializablePrivate * priv;
	GeeList* backed;
};

struct _zcdListISerializableClass {
	GObjectClass parent_class;
};


extern gboolean zcd_endianness_network;
gboolean zcd_endianness_network = FALSE;
static gpointer zcd_buffer_owner_parent_class = NULL;
static gpointer zcd_serializable_none_parent_class = NULL;
static zcdISerializableIface* zcd_serializable_none_zcd_iserializable_parent_iface = NULL;
static gpointer zcd_serializable_int_parent_class = NULL;
static zcdISerializableIface* zcd_serializable_int_zcd_iserializable_parent_iface = NULL;
static gpointer zcd_serializable_bool_parent_class = NULL;
static zcdISerializableIface* zcd_serializable_bool_zcd_iserializable_parent_iface = NULL;
static gpointer zcd_serializable_string_parent_class = NULL;
static zcdISerializableIface* zcd_serializable_string_zcd_iserializable_parent_iface = NULL;
static gpointer zcd_serializable_buffer_parent_class = NULL;
static zcdISerializableIface* zcd_serializable_buffer_zcd_iserializable_parent_iface = NULL;
static gpointer zcd_list_string_parent_class = NULL;
static zcdISerializableIface* zcd_list_string_zcd_iserializable_parent_iface = NULL;
static gpointer zcd_list_iserializable_parent_class = NULL;
static zcdISerializableIface* zcd_list_iserializable_zcd_iserializable_parent_iface = NULL;

GQuark zcd_serializer_error_quark (void);
GType zcd_iserializable_get_type (void) G_GNUC_CONST;
GVariant* zcd_iserializable_serialize_to_variant (zcdISerializable* self);
void zcd_iserializable_deserialize_from_variant (zcdISerializable* self, GVariant* v, GError** error);
guchar* zcd_iserializable_serialize (zcdISerializable* self, int* result_length1);
zcdISerializable* zcd_iserializable_deserialize (guchar* ser, int ser_length1, GError** error);
zcdBufferOwner* zcd_buffer_owner_new (guchar* seed, int seed_length1);
zcdBufferOwner* zcd_buffer_owner_construct (GType object_type, guchar* seed, int seed_length1);
GType zcd_buffer_owner_get_type (void) G_GNUC_CONST;
guchar* zcd_buffer_owner_get_buf (zcdBufferOwner* self, int* result_length1);
gboolean zcd_iserializable_is_instance_of (GType t1, guchar* ser, int ser_length1);
gchar* zcd_iserializable_typename (guchar* ser, int ser_length1);
#define ZCD_BUFFER_OWNER_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), ZCD_TYPE_BUFFER_OWNER, zcdBufferOwnerPrivate))
enum  {
	ZCD_BUFFER_OWNER_DUMMY_PROPERTY
};
static void zcd_buffer_owner_finalize (GObject* obj);
static void _vala_zcd_buffer_owner_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
GType zcd_serializable_none_get_type (void) G_GNUC_CONST;
enum  {
	ZCD_SERIALIZABLE_NONE_DUMMY_PROPERTY
};
static GVariant* zcd_serializable_none_real_serialize_to_variant (zcdISerializable* base);
GVariant* zcd_serializer_int_to_variant (gint i);
static void zcd_serializable_none_real_deserialize_from_variant (zcdISerializable* base, GVariant* v, GError** error);
zcdSerializableNone* zcd_serializable_none_new (void);
zcdSerializableNone* zcd_serializable_none_construct (GType object_type);
GType zcd_serializable_int_get_type (void) G_GNUC_CONST;
#define ZCD_SERIALIZABLE_INT_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), ZCD_TYPE_SERIALIZABLE_INT, zcdSerializableIntPrivate))
enum  {
	ZCD_SERIALIZABLE_INT_DUMMY_PROPERTY,
	ZCD_SERIALIZABLE_INT_I
};
zcdSerializableInt* zcd_serializable_int_new (gint i);
zcdSerializableInt* zcd_serializable_int_construct (GType object_type, gint i);
static GVariant* zcd_serializable_int_real_serialize_to_variant (zcdISerializable* base);
static void zcd_serializable_int_real_deserialize_from_variant (zcdISerializable* base, GVariant* v, GError** error);
gint zcd_serializer_variant_to_int (GVariant* v);
gint zcd_serializable_int_get_i (zcdSerializableInt* self);
static void zcd_serializable_int_finalize (GObject* obj);
static void _vala_zcd_serializable_int_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
GType zcd_serializable_bool_get_type (void) G_GNUC_CONST;
#define ZCD_SERIALIZABLE_BOOL_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), ZCD_TYPE_SERIALIZABLE_BOOL, zcdSerializableBoolPrivate))
enum  {
	ZCD_SERIALIZABLE_BOOL_DUMMY_PROPERTY,
	ZCD_SERIALIZABLE_BOOL_B
};
zcdSerializableBool* zcd_serializable_bool_new (gboolean b);
zcdSerializableBool* zcd_serializable_bool_construct (GType object_type, gboolean b);
static GVariant* zcd_serializable_bool_real_serialize_to_variant (zcdISerializable* base);
static void zcd_serializable_bool_real_deserialize_from_variant (zcdISerializable* base, GVariant* v, GError** error);
gboolean zcd_serializable_bool_get_b (zcdSerializableBool* self);
static void zcd_serializable_bool_finalize (GObject* obj);
static void _vala_zcd_serializable_bool_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
GType zcd_serializable_string_get_type (void) G_GNUC_CONST;
#define ZCD_SERIALIZABLE_STRING_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), ZCD_TYPE_SERIALIZABLE_STRING, zcdSerializableStringPrivate))
enum  {
	ZCD_SERIALIZABLE_STRING_DUMMY_PROPERTY,
	ZCD_SERIALIZABLE_STRING_S
};
zcdSerializableString* zcd_serializable_string_new (const gchar* s);
zcdSerializableString* zcd_serializable_string_construct (GType object_type, const gchar* s);
static GVariant* zcd_serializable_string_real_serialize_to_variant (zcdISerializable* base);
GVariant* zcd_serializer_string_to_variant (const gchar* s);
static void zcd_serializable_string_real_deserialize_from_variant (zcdISerializable* base, GVariant* v, GError** error);
gchar* zcd_serializer_variant_to_string (GVariant* v);
const gchar* zcd_serializable_string_get_s (zcdSerializableString* self);
static void zcd_serializable_string_finalize (GObject* obj);
static void _vala_zcd_serializable_string_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
GType zcd_serializable_buffer_get_type (void) G_GNUC_CONST;
#define ZCD_SERIALIZABLE_BUFFER_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), ZCD_TYPE_SERIALIZABLE_BUFFER, zcdSerializableBufferPrivate))
enum  {
	ZCD_SERIALIZABLE_BUFFER_DUMMY_PROPERTY
};
zcdSerializableBuffer* zcd_serializable_buffer_new (guint8* buffer, int buffer_length1);
zcdSerializableBuffer* zcd_serializable_buffer_construct (GType object_type, guint8* buffer, int buffer_length1);
static guint8* _vala_array_dup14 (guint8* self, int length);
static GVariant* zcd_serializable_buffer_real_serialize_to_variant (zcdISerializable* base);
GVariant* zcd_serializer_uchar_array_to_variant (guchar* auc, int auc_length1);
static void zcd_serializable_buffer_real_deserialize_from_variant (zcdISerializable* base, GVariant* v, GError** error);
guchar* zcd_serializer_variant_to_uchar_array (GVariant* v, int* result_length1);
guint8* zcd_serializable_buffer_get_buffer (zcdSerializableBuffer* self, int* result_length1);
static void zcd_serializable_buffer_finalize (GObject* obj);
static void _vala_zcd_serializable_buffer_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
GType zcd_list_string_get_type (void) G_GNUC_CONST;
enum  {
	ZCD_LIST_STRING_DUMMY_PROPERTY,
	ZCD_LIST_STRING_SIZE
};
zcdListString* zcd_list_string_new (void);
zcdListString* zcd_list_string_construct (GType object_type);
zcdListString* zcd_list_string_new_with_backer (GeeList* backed);
zcdListString* zcd_list_string_construct_with_backer (GType object_type, GeeList* backed);
GeeIterator* zcd_list_string_iterator (zcdListString* self);
void zcd_list_string_add (zcdListString* self, const gchar* el);
guchar* zcd_list_string_hash_for_signature (zcdListString* self, int* result_length1);
static void _vala_array_add1 (guchar** array, int* length, int* size, guchar value);
static GVariant* zcd_list_string_real_serialize_to_variant (zcdISerializable* base);
GVariant* zcd_serializer_string_array_to_variant (gchar** ars, int ars_length1);
static void zcd_list_string_real_deserialize_from_variant (zcdISerializable* base, GVariant* v, GError** error);
gchar** zcd_serializer_variant_to_string_array (GVariant* v, int* result_length1);
gint zcd_list_string_get_size (zcdListString* self);
static void zcd_list_string_finalize (GObject* obj);
static void _vala_zcd_list_string_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
GType zcd_list_iserializable_get_type (void) G_GNUC_CONST;
enum  {
	ZCD_LIST_ISERIALIZABLE_DUMMY_PROPERTY,
	ZCD_LIST_ISERIALIZABLE_SIZE
};
static gboolean zcd_list_iserializable_not_impl_equal_func (GObject* a, GObject* b);
zcdListISerializable* zcd_list_iserializable_new (void);
zcdListISerializable* zcd_list_iserializable_construct (GType object_type);
zcdListISerializable* zcd_list_iserializable_new_with_backer (GeeList* backed);
zcdListISerializable* zcd_list_iserializable_construct_with_backer (GType object_type, GeeList* backed);
GeeIterator* zcd_list_iserializable_iterator (zcdListISerializable* self);
void zcd_list_iserializable_add (zcdListISerializable* self, zcdISerializable* el);
static GVariant* zcd_list_iserializable_real_serialize_to_variant (zcdISerializable* base);
GVariant* zcd_serializer_variant_array_to_variant (GVariant** av, int av_length1);
GVariant* zcd_serializer_tuple_to_variant (GVariant* v0, GVariant* v1);
static void zcd_list_iserializable_real_deserialize_from_variant (zcdISerializable* base, GVariant* v, GError** error);
void zcd_serializer_variant_to_tuple (GVariant* v, GVariant** v0, GVariant** v1);
GVariant** zcd_serializer_variant_to_variant_array (GVariant* v, int* result_length1);
gint zcd_list_iserializable_get_size (zcdListISerializable* self);
static void zcd_list_iserializable_finalize (GObject* obj);
static void _vala_zcd_list_iserializable_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
void zcd_serializer_init (void);
GType zcd_remote_call_get_type (void) G_GNUC_CONST;
GType zcd_remotable_exception_get_type (void) G_GNUC_CONST;
GType zcd_tcp_request_get_type (void) G_GNUC_CONST;
GType zcd_udp_message_get_type (void) G_GNUC_CONST;
GType zcd_udp_payload_get_type (void) G_GNUC_CONST;
static GVariant* _variant_new3 (gint value);
static gint _variant_get4 (GVariant* value);
GVariant* zcd_serializer_int64_to_variant (gint64 i);
static GVariant* _variant_new5 (gint64 value);
gint64 zcd_serializer_variant_to_int64 (GVariant* v);
static gint64 _variant_get6 (GVariant* value);
GVariant* zcd_serializer_uchar_to_variant (guchar y);
static GVariant* _variant_new7 (guchar value);
guchar zcd_serializer_variant_to_uchar (GVariant* v);
static guchar _variant_get8 (GVariant* value);
static GVariant* _variant_new9 (const gchar* value);
GVariant* zcd_serializer_int_array_to_variant (gint* ai, int ai_length1);
static GVariant* _variant_new10 (gint* value, gint value_length1);
gint* zcd_serializer_variant_to_int_array (GVariant* v, int* result_length1);
static gint _variant_get11 (GVariant* value);
static void _vala_array_add2 (gint** array, int* length, int* size, gint value);
static GVariant* _variant_new12 (guchar* value, gint value_length1);
static guchar _variant_get13 (GVariant* value);
static void _vala_array_add3 (guchar** array, int* length, int* size, guchar value);
static GVariant* _variant_new14 (gchar** value, gint value_length1);
static void _vala_array_add4 (gchar*** array, int* length, int* size, gchar* value);
static GVariant* _variant_new15 (GVariant** value, gint value_length1);
static void _vala_array_add5 (GVariant*** array, int* length, int* size, GVariant* value);
GVariant* zcd_serializer_tuple_to_variant_3 (GVariant* v0, GVariant* v1, GVariant* v2);
void zcd_serializer_variant_to_tuple_3 (GVariant* v, GVariant** v0, GVariant** v1, GVariant** v2);
GVariant* zcd_serializer_tuple_to_variant_4 (GVariant* v0, GVariant* v1, GVariant* v2, GVariant* v3);
void zcd_serializer_variant_to_tuple_4 (GVariant* v, GVariant** v0, GVariant** v1, GVariant** v2, GVariant** v3);
GVariant* zcd_serializer_tuple_to_variant_5 (GVariant* v0, GVariant* v1, GVariant* v2, GVariant* v3, GVariant* v4);
void zcd_serializer_variant_to_tuple_5 (GVariant* v, GVariant** v0, GVariant** v1, GVariant** v2, GVariant** v3, GVariant** v4);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);


GQuark zcd_serializer_error_quark (void) {
#line 154 "/home/luca/repo/wip/zcd/udpmessage.vala"
	return g_quark_from_static_string ("zcd_serializer_error-quark");
#line 478 "serializer.c"
}


GVariant* zcd_iserializable_serialize_to_variant (zcdISerializable* self) {
#line 41 "/home/luca/repo/wip/zcd/serializer.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 41 "/home/luca/repo/wip/zcd/serializer.vala"
	return ZCD_ISERIALIZABLE_GET_INTERFACE (self)->serialize_to_variant (self);
#line 487 "serializer.c"
}


void zcd_iserializable_deserialize_from_variant (zcdISerializable* self, GVariant* v, GError** error) {
#line 42 "/home/luca/repo/wip/zcd/serializer.vala"
	g_return_if_fail (self != NULL);
#line 42 "/home/luca/repo/wip/zcd/serializer.vala"
	ZCD_ISERIALIZABLE_GET_INTERFACE (self)->deserialize_from_variant (self, v, error);
#line 496 "serializer.c"
}


guchar* zcd_iserializable_serialize (zcdISerializable* self, int* result_length1) {
	guchar* result = NULL;
	GVariant* _tmp0_ = NULL;
	GVariant* vtuple;
	GType _tmp1_ = 0UL;
	const gchar* _tmp2_ = NULL;
	gchar* _tmp3_;
	gchar* s;
	const gchar* _tmp4_;
	GVariant* _tmp5_;
	GVariant* _tmp6_;
	GVariant* v1;
	guchar* ser;
	gint ser_length1;
	gint _ser_size_;
	gboolean _tmp7_;
	GVariant* _tmp10_;
	gsize _tmp11_ = 0UL;
	gsize siz;
	guchar* _tmp12_ = NULL;
	GVariant* _tmp13_;
	guchar* _tmp14_;
	gint _tmp14__length1;
	guchar* _tmp15_;
	gint _tmp15__length1;
#line 45 "/home/luca/repo/wip/zcd/serializer.vala"
	_tmp0_ = zcd_iserializable_serialize_to_variant (self);
#line 45 "/home/luca/repo/wip/zcd/serializer.vala"
	vtuple = _tmp0_;
#line 46 "/home/luca/repo/wip/zcd/serializer.vala"
	_tmp1_ = G_TYPE_FROM_INSTANCE ((GObject*) self);
#line 46 "/home/luca/repo/wip/zcd/serializer.vala"
	_tmp2_ = g_type_name (_tmp1_);
#line 46 "/home/luca/repo/wip/zcd/serializer.vala"
	_tmp3_ = g_strdup (_tmp2_);
#line 46 "/home/luca/repo/wip/zcd/serializer.vala"
	s = _tmp3_;
#line 47 "/home/luca/repo/wip/zcd/serializer.vala"
	_tmp4_ = s;
#line 47 "/home/luca/repo/wip/zcd/serializer.vala"
	_tmp5_ = vtuple;
#line 47 "/home/luca/repo/wip/zcd/serializer.vala"
	_tmp6_ = g_variant_new ("(sv)", _tmp4_, _tmp5_, NULL);
#line 47 "/home/luca/repo/wip/zcd/serializer.vala"
	g_variant_ref_sink (_tmp6_);
#line 47 "/home/luca/repo/wip/zcd/serializer.vala"
	v1 = _tmp6_;
#line 48 "/home/luca/repo/wip/zcd/serializer.vala"
	ser = NULL;
#line 48 "/home/luca/repo/wip/zcd/serializer.vala"
	ser_length1 = 0;
#line 48 "/home/luca/repo/wip/zcd/serializer.vala"
	_ser_size_ = ser_length1;
#line 49 "/home/luca/repo/wip/zcd/serializer.vala"
	_tmp7_ = zcd_endianness_network;
#line 49 "/home/luca/repo/wip/zcd/serializer.vala"
	if (!_tmp7_) {
#line 557 "serializer.c"
		GVariant* _tmp8_;
		GVariant* _tmp9_ = NULL;
#line 49 "/home/luca/repo/wip/zcd/serializer.vala"
		_tmp8_ = v1;
#line 49 "/home/luca/repo/wip/zcd/serializer.vala"
		_tmp9_ = g_variant_byteswap (_tmp8_);
#line 49 "/home/luca/repo/wip/zcd/serializer.vala"
		_g_variant_unref0 (v1);
#line 49 "/home/luca/repo/wip/zcd/serializer.vala"
		v1 = _tmp9_;
#line 568 "serializer.c"
	}
#line 50 "/home/luca/repo/wip/zcd/serializer.vala"
	_tmp10_ = v1;
#line 50 "/home/luca/repo/wip/zcd/serializer.vala"
	_tmp11_ = g_variant_get_size (_tmp10_);
#line 50 "/home/luca/repo/wip/zcd/serializer.vala"
	siz = _tmp11_;
#line 51 "/home/luca/repo/wip/zcd/serializer.vala"
	_tmp12_ = g_new0 (guchar, siz);
#line 51 "/home/luca/repo/wip/zcd/serializer.vala"
	ser = (g_free (ser), NULL);
#line 51 "/home/luca/repo/wip/zcd/serializer.vala"
	ser = _tmp12_;
#line 51 "/home/luca/repo/wip/zcd/serializer.vala"
	ser_length1 = siz;
#line 51 "/home/luca/repo/wip/zcd/serializer.vala"
	_ser_size_ = ser_length1;
#line 52 "/home/luca/repo/wip/zcd/serializer.vala"
	_tmp13_ = v1;
#line 52 "/home/luca/repo/wip/zcd/serializer.vala"
	_tmp14_ = ser;
#line 52 "/home/luca/repo/wip/zcd/serializer.vala"
	_tmp14__length1 = ser_length1;
#line 52 "/home/luca/repo/wip/zcd/serializer.vala"
	g_variant_store (_tmp13_, _tmp14_);
#line 53 "/home/luca/repo/wip/zcd/serializer.vala"
	_tmp15_ = ser;
#line 53 "/home/luca/repo/wip/zcd/serializer.vala"
	_tmp15__length1 = ser_length1;
#line 53 "/home/luca/repo/wip/zcd/serializer.vala"
	if (result_length1) {
#line 53 "/home/luca/repo/wip/zcd/serializer.vala"
		*result_length1 = _tmp15__length1;
#line 602 "serializer.c"
	}
#line 53 "/home/luca/repo/wip/zcd/serializer.vala"
	result = _tmp15_;
#line 53 "/home/luca/repo/wip/zcd/serializer.vala"
	_g_variant_unref0 (v1);
#line 53 "/home/luca/repo/wip/zcd/serializer.vala"
	_g_free0 (s);
#line 53 "/home/luca/repo/wip/zcd/serializer.vala"
	_g_variant_unref0 (vtuple);
#line 53 "/home/luca/repo/wip/zcd/serializer.vala"
	return result;
#line 614 "serializer.c"
}


static gpointer _g_object_ref0 (gpointer self) {
#line 59 "/home/luca/repo/wip/zcd/serializer.vala"
	return self ? g_object_ref (self) : NULL;
#line 621 "serializer.c"
}


static const gchar* string_to_string (const gchar* self) {
	const gchar* result = NULL;
#line 1274 "/usr/share/vala-0.20/vapi/glib-2.0.vapi"
	g_return_val_if_fail (self != NULL, NULL);
#line 1275 "/usr/share/vala-0.20/vapi/glib-2.0.vapi"
	result = self;
#line 1275 "/usr/share/vala-0.20/vapi/glib-2.0.vapi"
	return result;
#line 633 "serializer.c"
}


zcdISerializable* zcd_iserializable_deserialize (guchar* ser, int ser_length1, GError** error) {
	zcdISerializable* result = NULL;
	guchar* _tmp0_;
	gint _tmp0__length1;
	zcdBufferOwner* _tmp1_;
	zcdBufferOwner* owner;
	GVariantType* _tmp2_;
	GVariantType* vt;
	const GVariantType* _tmp3_;
	zcdBufferOwner* _tmp4_;
	guchar* _tmp5_;
	gint _tmp5__length1;
	guchar* _tmp6_;
	gint _tmp6__length1;
	zcdBufferOwner* _tmp7_;
	zcdBufferOwner* _tmp8_;
	GVariant* _tmp9_ = NULL;
	GVariant* v2;
	gboolean _tmp10_;
	gchar* typename = NULL;
	GVariant* vtuple = NULL;
	GVariant* _tmp13_;
	gboolean _tmp14_ = FALSE;
	const gchar* _tmp15_;
	gboolean _tmp17_;
	const gchar* _tmp19_;
	GType _tmp20_ = 0UL;
	GType type;
	GType _tmp21_;
	GType _tmp28_;
	gboolean _tmp29_ = FALSE;
	GType _tmp36_;
	GObject* _tmp37_ = NULL;
	GObject* _tmp38_;
	GObject* obj;
	GObject* _tmp39_;
	zcdISerializable* _tmp40_;
	zcdISerializable* retval;
	zcdISerializable* _tmp41_;
	GVariant* _tmp42_;
	GError * _inner_error_ = NULL;
#line 57 "/home/luca/repo/wip/zcd/serializer.vala"
	_tmp0_ = ser;
#line 57 "/home/luca/repo/wip/zcd/serializer.vala"
	_tmp0__length1 = ser_length1;
#line 57 "/home/luca/repo/wip/zcd/serializer.vala"
	_tmp1_ = zcd_buffer_owner_new (_tmp0_, _tmp0__length1);
#line 57 "/home/luca/repo/wip/zcd/serializer.vala"
	owner = _tmp1_;
#line 58 "/home/luca/repo/wip/zcd/serializer.vala"
	_tmp2_ = g_variant_type_new ("(sv)");
#line 58 "/home/luca/repo/wip/zcd/serializer.vala"
	vt = _tmp2_;
#line 59 "/home/luca/repo/wip/zcd/serializer.vala"
	_tmp3_ = vt;
#line 59 "/home/luca/repo/wip/zcd/serializer.vala"
	_tmp4_ = owner;
#line 59 "/home/luca/repo/wip/zcd/serializer.vala"
	_tmp5_ = zcd_buffer_owner_get_buf (_tmp4_, &_tmp5__length1);
#line 59 "/home/luca/repo/wip/zcd/serializer.vala"
	_tmp6_ = _tmp5_;
#line 59 "/home/luca/repo/wip/zcd/serializer.vala"
	_tmp6__length1 = _tmp5__length1;
#line 59 "/home/luca/repo/wip/zcd/serializer.vala"
	_tmp7_ = owner;
#line 59 "/home/luca/repo/wip/zcd/serializer.vala"
	_tmp8_ = _g_object_ref0 (_tmp7_);
#line 59 "/home/luca/repo/wip/zcd/serializer.vala"
	_tmp9_ = g_variant_new_from_data (_tmp3_, _tmp6_, _tmp6__length1, FALSE, g_object_unref, _tmp8_);
#line 59 "/home/luca/repo/wip/zcd/serializer.vala"
	g_variant_ref_sink (_tmp9_);
#line 59 "/home/luca/repo/wip/zcd/serializer.vala"
	v2 = _tmp9_;
#line 60 "/home/luca/repo/wip/zcd/serializer.vala"
	_tmp10_ = zcd_endianness_network;
#line 60 "/home/luca/repo/wip/zcd/serializer.vala"
	if (!_tmp10_) {
#line 714 "serializer.c"
		GVariant* _tmp11_;
		GVariant* _tmp12_ = NULL;
#line 60 "/home/luca/repo/wip/zcd/serializer.vala"
		_tmp11_ = v2;
#line 60 "/home/luca/repo/wip/zcd/serializer.vala"
		_tmp12_ = g_variant_byteswap (_tmp11_);
#line 60 "/home/luca/repo/wip/zcd/serializer.vala"
		_g_variant_unref0 (v2);
#line 60 "/home/luca/repo/wip/zcd/serializer.vala"
		v2 = _tmp12_;
#line 725 "serializer.c"
	}
#line 63 "/home/luca/repo/wip/zcd/serializer.vala"
	_tmp13_ = v2;
#line 63 "/home/luca/repo/wip/zcd/serializer.vala"
	g_variant_get (_tmp13_, "(sv)", &typename, &vtuple, NULL);
#line 64 "/home/luca/repo/wip/zcd/serializer.vala"
	_tmp15_ = typename;
#line 64 "/home/luca/repo/wip/zcd/serializer.vala"
	if (_tmp15_ == NULL) {
#line 64 "/home/luca/repo/wip/zcd/serializer.vala"
		_tmp14_ = TRUE;
#line 737 "serializer.c"
	} else {
		const gchar* _tmp16_;
#line 64 "/home/luca/repo/wip/zcd/serializer.vala"
		_tmp16_ = typename;
#line 64 "/home/luca/repo/wip/zcd/serializer.vala"
		_tmp14_ = g_strcmp0 (_tmp16_, "") == 0;
#line 744 "serializer.c"
	}
#line 64 "/home/luca/repo/wip/zcd/serializer.vala"
	_tmp17_ = _tmp14_;
#line 64 "/home/luca/repo/wip/zcd/serializer.vala"
	if (_tmp17_) {
#line 750 "serializer.c"
		GError* _tmp18_;
#line 64 "/home/luca/repo/wip/zcd/serializer.vala"
		_tmp18_ = g_error_new_literal (ZCD_SERIALIZER_ERROR, ZCD_SERIALIZER_ERROR_GENERIC, "Typename not specified.");
#line 64 "/home/luca/repo/wip/zcd/serializer.vala"
		_inner_error_ = _tmp18_;
#line 64 "/home/luca/repo/wip/zcd/serializer.vala"
		if (_inner_error_->domain == ZCD_SERIALIZER_ERROR) {
#line 64 "/home/luca/repo/wip/zcd/serializer.vala"
			g_propagate_error (error, _inner_error_);
#line 64 "/home/luca/repo/wip/zcd/serializer.vala"
			_g_variant_unref0 (vtuple);
#line 64 "/home/luca/repo/wip/zcd/serializer.vala"
			_g_free0 (typename);
#line 64 "/home/luca/repo/wip/zcd/serializer.vala"
			_g_variant_unref0 (v2);
#line 64 "/home/luca/repo/wip/zcd/serializer.vala"
			_g_variant_type_free0 (vt);
#line 64 "/home/luca/repo/wip/zcd/serializer.vala"
			_g_object_unref0 (owner);
#line 64 "/home/luca/repo/wip/zcd/serializer.vala"
			return NULL;
#line 772 "serializer.c"
		} else {
#line 64 "/home/luca/repo/wip/zcd/serializer.vala"
			_g_variant_unref0 (vtuple);
#line 64 "/home/luca/repo/wip/zcd/serializer.vala"
			_g_free0 (typename);
#line 64 "/home/luca/repo/wip/zcd/serializer.vala"
			_g_variant_unref0 (v2);
#line 64 "/home/luca/repo/wip/zcd/serializer.vala"
			_g_variant_type_free0 (vt);
#line 64 "/home/luca/repo/wip/zcd/serializer.vala"
			_g_object_unref0 (owner);
#line 64 "/home/luca/repo/wip/zcd/serializer.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 64 "/home/luca/repo/wip/zcd/serializer.vala"
			g_clear_error (&_inner_error_);
#line 64 "/home/luca/repo/wip/zcd/serializer.vala"
			return NULL;
#line 790 "serializer.c"
		}
	}
#line 65 "/home/luca/repo/wip/zcd/serializer.vala"
	_tmp19_ = typename;
#line 65 "/home/luca/repo/wip/zcd/serializer.vala"
	_tmp20_ = g_type_from_name (_tmp19_);
#line 65 "/home/luca/repo/wip/zcd/serializer.vala"
	type = _tmp20_;
#line 66 "/home/luca/repo/wip/zcd/serializer.vala"
	_tmp21_ = type;
#line 66 "/home/luca/repo/wip/zcd/serializer.vala"
	if (_tmp21_ == ((GType) 0)) {
#line 803 "serializer.c"
		const gchar* _tmp22_;
		const gchar* _tmp23_ = NULL;
		gchar* _tmp24_ = NULL;
		gchar* _tmp25_;
		GError* _tmp26_;
		GError* _tmp27_;
#line 66 "/home/luca/repo/wip/zcd/serializer.vala"
		_tmp22_ = typename;
#line 66 "/home/luca/repo/wip/zcd/serializer.vala"
		_tmp23_ = string_to_string (_tmp22_);
#line 66 "/home/luca/repo/wip/zcd/serializer.vala"
		_tmp24_ = g_strconcat ("Typename '", _tmp23_, "' is unknown.", NULL);
#line 66 "/home/luca/repo/wip/zcd/serializer.vala"
		_tmp25_ = _tmp24_;
#line 66 "/home/luca/repo/wip/zcd/serializer.vala"
		_tmp26_ = g_error_new_literal (ZCD_SERIALIZER_ERROR, ZCD_SERIALIZER_ERROR_GENERIC, _tmp25_);
#line 66 "/home/luca/repo/wip/zcd/serializer.vala"
		_tmp27_ = _tmp26_;
#line 66 "/home/luca/repo/wip/zcd/serializer.vala"
		_g_free0 (_tmp25_);
#line 66 "/home/luca/repo/wip/zcd/serializer.vala"
		_inner_error_ = _tmp27_;
#line 66 "/home/luca/repo/wip/zcd/serializer.vala"
		if (_inner_error_->domain == ZCD_SERIALIZER_ERROR) {
#line 66 "/home/luca/repo/wip/zcd/serializer.vala"
			g_propagate_error (error, _inner_error_);
#line 66 "/home/luca/repo/wip/zcd/serializer.vala"
			_g_variant_unref0 (vtuple);
#line 66 "/home/luca/repo/wip/zcd/serializer.vala"
			_g_free0 (typename);
#line 66 "/home/luca/repo/wip/zcd/serializer.vala"
			_g_variant_unref0 (v2);
#line 66 "/home/luca/repo/wip/zcd/serializer.vala"
			_g_variant_type_free0 (vt);
#line 66 "/home/luca/repo/wip/zcd/serializer.vala"
			_g_object_unref0 (owner);
#line 66 "/home/luca/repo/wip/zcd/serializer.vala"
			return NULL;
#line 842 "serializer.c"
		} else {
#line 66 "/home/luca/repo/wip/zcd/serializer.vala"
			_g_variant_unref0 (vtuple);
#line 66 "/home/luca/repo/wip/zcd/serializer.vala"
			_g_free0 (typename);
#line 66 "/home/luca/repo/wip/zcd/serializer.vala"
			_g_variant_unref0 (v2);
#line 66 "/home/luca/repo/wip/zcd/serializer.vala"
			_g_variant_type_free0 (vt);
#line 66 "/home/luca/repo/wip/zcd/serializer.vala"
			_g_object_unref0 (owner);
#line 66 "/home/luca/repo/wip/zcd/serializer.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 66 "/home/luca/repo/wip/zcd/serializer.vala"
			g_clear_error (&_inner_error_);
#line 66 "/home/luca/repo/wip/zcd/serializer.vala"
			return NULL;
#line 860 "serializer.c"
		}
	}
#line 67 "/home/luca/repo/wip/zcd/serializer.vala"
	_tmp28_ = type;
#line 67 "/home/luca/repo/wip/zcd/serializer.vala"
	_tmp29_ = g_type_is_a (_tmp28_, ZCD_TYPE_ISERIALIZABLE);
#line 67 "/home/luca/repo/wip/zcd/serializer.vala"
	if (!_tmp29_) {
#line 869 "serializer.c"
		const gchar* _tmp30_;
		const gchar* _tmp31_ = NULL;
		gchar* _tmp32_ = NULL;
		gchar* _tmp33_;
		GError* _tmp34_;
		GError* _tmp35_;
#line 67 "/home/luca/repo/wip/zcd/serializer.vala"
		_tmp30_ = typename;
#line 67 "/home/luca/repo/wip/zcd/serializer.vala"
		_tmp31_ = string_to_string (_tmp30_);
#line 67 "/home/luca/repo/wip/zcd/serializer.vala"
		_tmp32_ = g_strconcat ("Typename '", _tmp31_, "' is not serializable.", NULL);
#line 67 "/home/luca/repo/wip/zcd/serializer.vala"
		_tmp33_ = _tmp32_;
#line 67 "/home/luca/repo/wip/zcd/serializer.vala"
		_tmp34_ = g_error_new_literal (ZCD_SERIALIZER_ERROR, ZCD_SERIALIZER_ERROR_GENERIC, _tmp33_);
#line 67 "/home/luca/repo/wip/zcd/serializer.vala"
		_tmp35_ = _tmp34_;
#line 67 "/home/luca/repo/wip/zcd/serializer.vala"
		_g_free0 (_tmp33_);
#line 67 "/home/luca/repo/wip/zcd/serializer.vala"
		_inner_error_ = _tmp35_;
#line 67 "/home/luca/repo/wip/zcd/serializer.vala"
		if (_inner_error_->domain == ZCD_SERIALIZER_ERROR) {
#line 67 "/home/luca/repo/wip/zcd/serializer.vala"
			g_propagate_error (error, _inner_error_);
#line 67 "/home/luca/repo/wip/zcd/serializer.vala"
			_g_variant_unref0 (vtuple);
#line 67 "/home/luca/repo/wip/zcd/serializer.vala"
			_g_free0 (typename);
#line 67 "/home/luca/repo/wip/zcd/serializer.vala"
			_g_variant_unref0 (v2);
#line 67 "/home/luca/repo/wip/zcd/serializer.vala"
			_g_variant_type_free0 (vt);
#line 67 "/home/luca/repo/wip/zcd/serializer.vala"
			_g_object_unref0 (owner);
#line 67 "/home/luca/repo/wip/zcd/serializer.vala"
			return NULL;
#line 908 "serializer.c"
		} else {
#line 67 "/home/luca/repo/wip/zcd/serializer.vala"
			_g_variant_unref0 (vtuple);
#line 67 "/home/luca/repo/wip/zcd/serializer.vala"
			_g_free0 (typename);
#line 67 "/home/luca/repo/wip/zcd/serializer.vala"
			_g_variant_unref0 (v2);
#line 67 "/home/luca/repo/wip/zcd/serializer.vala"
			_g_variant_type_free0 (vt);
#line 67 "/home/luca/repo/wip/zcd/serializer.vala"
			_g_object_unref0 (owner);
#line 67 "/home/luca/repo/wip/zcd/serializer.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 67 "/home/luca/repo/wip/zcd/serializer.vala"
			g_clear_error (&_inner_error_);
#line 67 "/home/luca/repo/wip/zcd/serializer.vala"
			return NULL;
#line 926 "serializer.c"
		}
	}
#line 68 "/home/luca/repo/wip/zcd/serializer.vala"
	_tmp36_ = type;
#line 68 "/home/luca/repo/wip/zcd/serializer.vala"
	_tmp37_ = g_object_new (_tmp36_, NULL);
#line 68 "/home/luca/repo/wip/zcd/serializer.vala"
	_tmp38_ = G_IS_INITIALLY_UNOWNED (_tmp37_) ? g_object_ref_sink (_tmp37_) : _tmp37_;
#line 68 "/home/luca/repo/wip/zcd/serializer.vala"
	obj = _tmp38_;
#line 69 "/home/luca/repo/wip/zcd/serializer.vala"
	_tmp39_ = obj;
#line 69 "/home/luca/repo/wip/zcd/serializer.vala"
	_tmp40_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp39_, ZCD_TYPE_ISERIALIZABLE, zcdISerializable));
#line 69 "/home/luca/repo/wip/zcd/serializer.vala"
	retval = _tmp40_;
#line 70 "/home/luca/repo/wip/zcd/serializer.vala"
	_tmp41_ = retval;
#line 70 "/home/luca/repo/wip/zcd/serializer.vala"
	_tmp42_ = vtuple;
#line 70 "/home/luca/repo/wip/zcd/serializer.vala"
	zcd_iserializable_deserialize_from_variant (_tmp41_, _tmp42_, &_inner_error_);
#line 70 "/home/luca/repo/wip/zcd/serializer.vala"
	if (_inner_error_ != NULL) {
#line 70 "/home/luca/repo/wip/zcd/serializer.vala"
		if (_inner_error_->domain == ZCD_SERIALIZER_ERROR) {
#line 70 "/home/luca/repo/wip/zcd/serializer.vala"
			g_propagate_error (error, _inner_error_);
#line 70 "/home/luca/repo/wip/zcd/serializer.vala"
			_g_object_unref0 (retval);
#line 70 "/home/luca/repo/wip/zcd/serializer.vala"
			_g_object_unref0 (obj);
#line 70 "/home/luca/repo/wip/zcd/serializer.vala"
			_g_variant_unref0 (vtuple);
#line 70 "/home/luca/repo/wip/zcd/serializer.vala"
			_g_free0 (typename);
#line 70 "/home/luca/repo/wip/zcd/serializer.vala"
			_g_variant_unref0 (v2);
#line 70 "/home/luca/repo/wip/zcd/serializer.vala"
			_g_variant_type_free0 (vt);
#line 70 "/home/luca/repo/wip/zcd/serializer.vala"
			_g_object_unref0 (owner);
#line 70 "/home/luca/repo/wip/zcd/serializer.vala"
			return NULL;
#line 971 "serializer.c"
		} else {
#line 70 "/home/luca/repo/wip/zcd/serializer.vala"
			_g_object_unref0 (retval);
#line 70 "/home/luca/repo/wip/zcd/serializer.vala"
			_g_object_unref0 (obj);
#line 70 "/home/luca/repo/wip/zcd/serializer.vala"
			_g_variant_unref0 (vtuple);
#line 70 "/home/luca/repo/wip/zcd/serializer.vala"
			_g_free0 (typename);
#line 70 "/home/luca/repo/wip/zcd/serializer.vala"
			_g_variant_unref0 (v2);
#line 70 "/home/luca/repo/wip/zcd/serializer.vala"
			_g_variant_type_free0 (vt);
#line 70 "/home/luca/repo/wip/zcd/serializer.vala"
			_g_object_unref0 (owner);
#line 70 "/home/luca/repo/wip/zcd/serializer.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 70 "/home/luca/repo/wip/zcd/serializer.vala"
			g_clear_error (&_inner_error_);
#line 70 "/home/luca/repo/wip/zcd/serializer.vala"
			return NULL;
#line 993 "serializer.c"
		}
	}
#line 71 "/home/luca/repo/wip/zcd/serializer.vala"
	result = retval;
#line 71 "/home/luca/repo/wip/zcd/serializer.vala"
	_g_object_unref0 (obj);
#line 71 "/home/luca/repo/wip/zcd/serializer.vala"
	_g_variant_unref0 (vtuple);
#line 71 "/home/luca/repo/wip/zcd/serializer.vala"
	_g_free0 (typename);
#line 71 "/home/luca/repo/wip/zcd/serializer.vala"
	_g_variant_unref0 (v2);
#line 71 "/home/luca/repo/wip/zcd/serializer.vala"
	_g_variant_type_free0 (vt);
#line 71 "/home/luca/repo/wip/zcd/serializer.vala"
	_g_object_unref0 (owner);
#line 71 "/home/luca/repo/wip/zcd/serializer.vala"
	return result;
#line 1012 "serializer.c"
}


gboolean zcd_iserializable_is_instance_of (GType t1, guchar* ser, int ser_length1) {
	gboolean result = FALSE;
	guchar* _tmp0_;
	gint _tmp0__length1;
	zcdBufferOwner* _tmp1_;
	zcdBufferOwner* owner;
	GVariantType* _tmp2_;
	GVariantType* vt;
	const GVariantType* _tmp3_;
	zcdBufferOwner* _tmp4_;
	guchar* _tmp5_;
	gint _tmp5__length1;
	guchar* _tmp6_;
	gint _tmp6__length1;
	zcdBufferOwner* _tmp7_;
	zcdBufferOwner* _tmp8_;
	GVariant* _tmp9_ = NULL;
	GVariant* v2;
	gboolean _tmp10_;
	gchar* typename = NULL;
	GVariant* vtuple = NULL;
	GVariant* _tmp13_;
	GType _tmp14_ = 0UL;
	GType t2;
	GType _tmp15_;
	gboolean _tmp16_ = FALSE;
#line 75 "/home/luca/repo/wip/zcd/serializer.vala"
	_tmp0_ = ser;
#line 75 "/home/luca/repo/wip/zcd/serializer.vala"
	_tmp0__length1 = ser_length1;
#line 75 "/home/luca/repo/wip/zcd/serializer.vala"
	_tmp1_ = zcd_buffer_owner_new (_tmp0_, _tmp0__length1);
#line 75 "/home/luca/repo/wip/zcd/serializer.vala"
	owner = _tmp1_;
#line 76 "/home/luca/repo/wip/zcd/serializer.vala"
	_tmp2_ = g_variant_type_new ("(sv)");
#line 76 "/home/luca/repo/wip/zcd/serializer.vala"
	vt = _tmp2_;
#line 77 "/home/luca/repo/wip/zcd/serializer.vala"
	_tmp3_ = vt;
#line 77 "/home/luca/repo/wip/zcd/serializer.vala"
	_tmp4_ = owner;
#line 77 "/home/luca/repo/wip/zcd/serializer.vala"
	_tmp5_ = zcd_buffer_owner_get_buf (_tmp4_, &_tmp5__length1);
#line 77 "/home/luca/repo/wip/zcd/serializer.vala"
	_tmp6_ = _tmp5_;
#line 77 "/home/luca/repo/wip/zcd/serializer.vala"
	_tmp6__length1 = _tmp5__length1;
#line 77 "/home/luca/repo/wip/zcd/serializer.vala"
	_tmp7_ = owner;
#line 77 "/home/luca/repo/wip/zcd/serializer.vala"
	_tmp8_ = _g_object_ref0 (_tmp7_);
#line 77 "/home/luca/repo/wip/zcd/serializer.vala"
	_tmp9_ = g_variant_new_from_data (_tmp3_, _tmp6_, _tmp6__length1, FALSE, g_object_unref, _tmp8_);
#line 77 "/home/luca/repo/wip/zcd/serializer.vala"
	g_variant_ref_sink (_tmp9_);
#line 77 "/home/luca/repo/wip/zcd/serializer.vala"
	v2 = _tmp9_;
#line 78 "/home/luca/repo/wip/zcd/serializer.vala"
	_tmp10_ = zcd_endianness_network;
#line 78 "/home/luca/repo/wip/zcd/serializer.vala"
	if (!_tmp10_) {
#line 1078 "serializer.c"
		GVariant* _tmp11_;
		GVariant* _tmp12_ = NULL;
#line 78 "/home/luca/repo/wip/zcd/serializer.vala"
		_tmp11_ = v2;
#line 78 "/home/luca/repo/wip/zcd/serializer.vala"
		_tmp12_ = g_variant_byteswap (_tmp11_);
#line 78 "/home/luca/repo/wip/zcd/serializer.vala"
		_g_variant_unref0 (v2);
#line 78 "/home/luca/repo/wip/zcd/serializer.vala"
		v2 = _tmp12_;
#line 1089 "serializer.c"
	}
#line 81 "/home/luca/repo/wip/zcd/serializer.vala"
	_tmp13_ = v2;
#line 81 "/home/luca/repo/wip/zcd/serializer.vala"
	g_variant_get (_tmp13_, "(sv)", &typename, &vtuple, NULL);
#line 82 "/home/luca/repo/wip/zcd/serializer.vala"
	_tmp14_ = g_type_from_name (typename);
#line 82 "/home/luca/repo/wip/zcd/serializer.vala"
	t2 = _tmp14_;
#line 83 "/home/luca/repo/wip/zcd/serializer.vala"
	_tmp15_ = t1;
#line 83 "/home/luca/repo/wip/zcd/serializer.vala"
	_tmp16_ = g_type_is_a (t2, _tmp15_);
#line 83 "/home/luca/repo/wip/zcd/serializer.vala"
	result = _tmp16_;
#line 83 "/home/luca/repo/wip/zcd/serializer.vala"
	_g_variant_unref0 (vtuple);
#line 83 "/home/luca/repo/wip/zcd/serializer.vala"
	_g_free0 (typename);
#line 83 "/home/luca/repo/wip/zcd/serializer.vala"
	_g_variant_unref0 (v2);
#line 83 "/home/luca/repo/wip/zcd/serializer.vala"
	_g_variant_type_free0 (vt);
#line 83 "/home/luca/repo/wip/zcd/serializer.vala"
	_g_object_unref0 (owner);
#line 83 "/home/luca/repo/wip/zcd/serializer.vala"
	return result;
#line 1117 "serializer.c"
}


gchar* zcd_iserializable_typename (guchar* ser, int ser_length1) {
	gchar* result = NULL;
	guchar* _tmp0_;
	gint _tmp0__length1;
	zcdBufferOwner* _tmp1_;
	zcdBufferOwner* owner;
	GVariantType* _tmp2_;
	GVariantType* vt;
	const GVariantType* _tmp3_;
	zcdBufferOwner* _tmp4_;
	guchar* _tmp5_;
	gint _tmp5__length1;
	guchar* _tmp6_;
	gint _tmp6__length1;
	zcdBufferOwner* _tmp7_;
	zcdBufferOwner* _tmp8_;
	GVariant* _tmp9_ = NULL;
	GVariant* v2;
	gboolean _tmp10_;
	gchar* typename = NULL;
	GVariant* vtuple = NULL;
	GVariant* _tmp13_;
#line 87 "/home/luca/repo/wip/zcd/serializer.vala"
	_tmp0_ = ser;
#line 87 "/home/luca/repo/wip/zcd/serializer.vala"
	_tmp0__length1 = ser_length1;
#line 87 "/home/luca/repo/wip/zcd/serializer.vala"
	_tmp1_ = zcd_buffer_owner_new (_tmp0_, _tmp0__length1);
#line 87 "/home/luca/repo/wip/zcd/serializer.vala"
	owner = _tmp1_;
#line 88 "/home/luca/repo/wip/zcd/serializer.vala"
	_tmp2_ = g_variant_type_new ("(sv)");
#line 88 "/home/luca/repo/wip/zcd/serializer.vala"
	vt = _tmp2_;
#line 89 "/home/luca/repo/wip/zcd/serializer.vala"
	_tmp3_ = vt;
#line 89 "/home/luca/repo/wip/zcd/serializer.vala"
	_tmp4_ = owner;
#line 89 "/home/luca/repo/wip/zcd/serializer.vala"
	_tmp5_ = zcd_buffer_owner_get_buf (_tmp4_, &_tmp5__length1);
#line 89 "/home/luca/repo/wip/zcd/serializer.vala"
	_tmp6_ = _tmp5_;
#line 89 "/home/luca/repo/wip/zcd/serializer.vala"
	_tmp6__length1 = _tmp5__length1;
#line 89 "/home/luca/repo/wip/zcd/serializer.vala"
	_tmp7_ = owner;
#line 89 "/home/luca/repo/wip/zcd/serializer.vala"
	_tmp8_ = _g_object_ref0 (_tmp7_);
#line 89 "/home/luca/repo/wip/zcd/serializer.vala"
	_tmp9_ = g_variant_new_from_data (_tmp3_, _tmp6_, _tmp6__length1, FALSE, g_object_unref, _tmp8_);
#line 89 "/home/luca/repo/wip/zcd/serializer.vala"
	g_variant_ref_sink (_tmp9_);
#line 89 "/home/luca/repo/wip/zcd/serializer.vala"
	v2 = _tmp9_;
#line 90 "/home/luca/repo/wip/zcd/serializer.vala"
	_tmp10_ = zcd_endianness_network;
#line 90 "/home/luca/repo/wip/zcd/serializer.vala"
	if (!_tmp10_) {
#line 1179 "serializer.c"
		GVariant* _tmp11_;
		GVariant* _tmp12_ = NULL;
#line 90 "/home/luca/repo/wip/zcd/serializer.vala"
		_tmp11_ = v2;
#line 90 "/home/luca/repo/wip/zcd/serializer.vala"
		_tmp12_ = g_variant_byteswap (_tmp11_);
#line 90 "/home/luca/repo/wip/zcd/serializer.vala"
		_g_variant_unref0 (v2);
#line 90 "/home/luca/repo/wip/zcd/serializer.vala"
		v2 = _tmp12_;
#line 1190 "serializer.c"
	}
#line 93 "/home/luca/repo/wip/zcd/serializer.vala"
	_tmp13_ = v2;
#line 93 "/home/luca/repo/wip/zcd/serializer.vala"
	g_variant_get (_tmp13_, "(sv)", &typename, &vtuple, NULL);
#line 94 "/home/luca/repo/wip/zcd/serializer.vala"
	result = typename;
#line 94 "/home/luca/repo/wip/zcd/serializer.vala"
	_g_variant_unref0 (vtuple);
#line 94 "/home/luca/repo/wip/zcd/serializer.vala"
	_g_variant_unref0 (v2);
#line 94 "/home/luca/repo/wip/zcd/serializer.vala"
	_g_variant_type_free0 (vt);
#line 94 "/home/luca/repo/wip/zcd/serializer.vala"
	_g_object_unref0 (owner);
#line 94 "/home/luca/repo/wip/zcd/serializer.vala"
	return result;
#line 1208 "serializer.c"
}


static void zcd_iserializable_base_init (zcdISerializableIface * iface) {
#line 55 "/home/luca/repo/wip/zcd/serializer.vala"
	static gboolean initialized = FALSE;
#line 55 "/home/luca/repo/wip/zcd/serializer.vala"
	if (!initialized) {
#line 55 "/home/luca/repo/wip/zcd/serializer.vala"
		initialized = TRUE;
#line 1219 "serializer.c"
	}
}


/** The interface ISerializable has to be implemented by any
      * class whose instances we want to be able to serialize and
      * transmit over the net.
      * The class that we want to be serializeable needs to know how
      * to put in a Variant its data and retrieve it from a Variant.
      * But the code that wants to serialize an instance of those classes
      * will use the methods serialize and deserialize, which treat
      * simple uchar arrays.
      */
GType zcd_iserializable_get_type (void) {
	static volatile gsize zcd_iserializable_type_id__volatile = 0;
	if (g_once_init_enter (&zcd_iserializable_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (zcdISerializableIface), (GBaseInitFunc) zcd_iserializable_base_init, (GBaseFinalizeFunc) NULL, (GClassInitFunc) NULL, (GClassFinalizeFunc) NULL, NULL, 0, 0, (GInstanceInitFunc) NULL, NULL };
		GType zcd_iserializable_type_id;
		zcd_iserializable_type_id = g_type_register_static (G_TYPE_INTERFACE, "zcdISerializable", &g_define_type_info, 0);
		g_type_interface_add_prerequisite (zcd_iserializable_type_id, G_TYPE_OBJECT);
		g_once_init_leave (&zcd_iserializable_type_id__volatile, zcd_iserializable_type_id);
	}
	return zcd_iserializable_type_id__volatile;
}


zcdBufferOwner* zcd_buffer_owner_construct (GType object_type, guchar* seed, int seed_length1) {
	zcdBufferOwner * self = NULL;
	guchar* _tmp0_;
	gint _tmp0__length1;
	guchar* _tmp1_ = NULL;
	guchar* _tmp2_;
	gint _tmp2__length1;
	guchar* _tmp3_;
	gint _tmp3__length1;
	guchar* _tmp4_;
	gint _tmp4__length1;
#line 106 "/home/luca/repo/wip/zcd/serializer.vala"
	self = (zcdBufferOwner*) g_object_new (object_type, NULL);
#line 108 "/home/luca/repo/wip/zcd/serializer.vala"
	_tmp0_ = seed;
#line 108 "/home/luca/repo/wip/zcd/serializer.vala"
	_tmp0__length1 = seed_length1;
#line 108 "/home/luca/repo/wip/zcd/serializer.vala"
	_tmp1_ = g_new0 (guchar, _tmp0__length1);
#line 108 "/home/luca/repo/wip/zcd/serializer.vala"
	self->priv->_buf = (g_free (self->priv->_buf), NULL);
#line 108 "/home/luca/repo/wip/zcd/serializer.vala"
	self->priv->_buf = _tmp1_;
#line 108 "/home/luca/repo/wip/zcd/serializer.vala"
	self->priv->_buf_length1 = _tmp0__length1;
#line 108 "/home/luca/repo/wip/zcd/serializer.vala"
	self->priv->__buf_size_ = self->priv->_buf_length1;
#line 109 "/home/luca/repo/wip/zcd/serializer.vala"
	_tmp2_ = self->priv->_buf;
#line 109 "/home/luca/repo/wip/zcd/serializer.vala"
	_tmp2__length1 = self->priv->_buf_length1;
#line 109 "/home/luca/repo/wip/zcd/serializer.vala"
	_tmp3_ = seed;
#line 109 "/home/luca/repo/wip/zcd/serializer.vala"
	_tmp3__length1 = seed_length1;
#line 109 "/home/luca/repo/wip/zcd/serializer.vala"
	_tmp4_ = seed;
#line 109 "/home/luca/repo/wip/zcd/serializer.vala"
	_tmp4__length1 = seed_length1;
#line 109 "/home/luca/repo/wip/zcd/serializer.vala"
	memcpy ((void*) _tmp2_, (void*) _tmp3_, ((gsize) _tmp4__length1) * sizeof (guchar));
#line 106 "/home/luca/repo/wip/zcd/serializer.vala"
	return self;
#line 1289 "serializer.c"
}


zcdBufferOwner* zcd_buffer_owner_new (guchar* seed, int seed_length1) {
#line 106 "/home/luca/repo/wip/zcd/serializer.vala"
	return zcd_buffer_owner_construct (ZCD_TYPE_BUFFER_OWNER, seed, seed_length1);
#line 1296 "serializer.c"
}


guchar* zcd_buffer_owner_get_buf (zcdBufferOwner* self, int* result_length1) {
	guchar* result;
	guchar* _tmp0_;
	gint _tmp0__length1;
	guchar* _tmp1_;
	gint _tmp1__length1;
#line 102 "/home/luca/repo/wip/zcd/serializer.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 103 "/home/luca/repo/wip/zcd/serializer.vala"
	_tmp0_ = self->priv->_buf;
#line 103 "/home/luca/repo/wip/zcd/serializer.vala"
	_tmp0__length1 = self->priv->_buf_length1;
#line 103 "/home/luca/repo/wip/zcd/serializer.vala"
	_tmp1_ = _tmp0_;
#line 103 "/home/luca/repo/wip/zcd/serializer.vala"
	_tmp1__length1 = _tmp0__length1;
#line 103 "/home/luca/repo/wip/zcd/serializer.vala"
	if (result_length1) {
#line 103 "/home/luca/repo/wip/zcd/serializer.vala"
		*result_length1 = _tmp1__length1;
#line 1320 "serializer.c"
	}
#line 103 "/home/luca/repo/wip/zcd/serializer.vala"
	result = _tmp1_;
#line 103 "/home/luca/repo/wip/zcd/serializer.vala"
	return result;
#line 1326 "serializer.c"
}


static void zcd_buffer_owner_class_init (zcdBufferOwnerClass * klass) {
#line 98 "/home/luca/repo/wip/zcd/serializer.vala"
	zcd_buffer_owner_parent_class = g_type_class_peek_parent (klass);
#line 98 "/home/luca/repo/wip/zcd/serializer.vala"
	g_type_class_add_private (klass, sizeof (zcdBufferOwnerPrivate));
#line 98 "/home/luca/repo/wip/zcd/serializer.vala"
	G_OBJECT_CLASS (klass)->get_property = _vala_zcd_buffer_owner_get_property;
#line 98 "/home/luca/repo/wip/zcd/serializer.vala"
	G_OBJECT_CLASS (klass)->finalize = zcd_buffer_owner_finalize;
#line 1339 "serializer.c"
}


static void zcd_buffer_owner_instance_init (zcdBufferOwner * self) {
#line 98 "/home/luca/repo/wip/zcd/serializer.vala"
	self->priv = ZCD_BUFFER_OWNER_GET_PRIVATE (self);
#line 1346 "serializer.c"
}


static void zcd_buffer_owner_finalize (GObject* obj) {
	zcdBufferOwner * self;
#line 98 "/home/luca/repo/wip/zcd/serializer.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, ZCD_TYPE_BUFFER_OWNER, zcdBufferOwner);
#line 100 "/home/luca/repo/wip/zcd/serializer.vala"
	self->priv->_buf = (g_free (self->priv->_buf), NULL);
#line 98 "/home/luca/repo/wip/zcd/serializer.vala"
	G_OBJECT_CLASS (zcd_buffer_owner_parent_class)->finalize (obj);
#line 1358 "serializer.c"
}


GType zcd_buffer_owner_get_type (void) {
	static volatile gsize zcd_buffer_owner_type_id__volatile = 0;
	if (g_once_init_enter (&zcd_buffer_owner_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (zcdBufferOwnerClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) zcd_buffer_owner_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (zcdBufferOwner), 0, (GInstanceInitFunc) zcd_buffer_owner_instance_init, NULL };
		GType zcd_buffer_owner_type_id;
		zcd_buffer_owner_type_id = g_type_register_static (G_TYPE_OBJECT, "zcdBufferOwner", &g_define_type_info, 0);
		g_once_init_leave (&zcd_buffer_owner_type_id__volatile, zcd_buffer_owner_type_id);
	}
	return zcd_buffer_owner_type_id__volatile;
}


static void _vala_zcd_buffer_owner_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	zcdBufferOwner * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, ZCD_TYPE_BUFFER_OWNER, zcdBufferOwner);
#line 98 "/home/luca/repo/wip/zcd/serializer.vala"
	switch (property_id) {
#line 1379 "serializer.c"
		default:
#line 98 "/home/luca/repo/wip/zcd/serializer.vala"
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
#line 98 "/home/luca/repo/wip/zcd/serializer.vala"
		break;
#line 1385 "serializer.c"
	}
}


static GVariant* zcd_serializable_none_real_serialize_to_variant (zcdISerializable* base) {
	zcdSerializableNone * self;
	GVariant* result = NULL;
	GVariant* _tmp0_ = NULL;
	GVariant* v;
#line 119 "/home/luca/repo/wip/zcd/serializer.vala"
	self = (zcdSerializableNone*) base;
#line 121 "/home/luca/repo/wip/zcd/serializer.vala"
	_tmp0_ = zcd_serializer_int_to_variant (0);
#line 121 "/home/luca/repo/wip/zcd/serializer.vala"
	v = _tmp0_;
#line 122 "/home/luca/repo/wip/zcd/serializer.vala"
	result = v;
#line 122 "/home/luca/repo/wip/zcd/serializer.vala"
	return result;
#line 1405 "serializer.c"
}


static void zcd_serializable_none_real_deserialize_from_variant (zcdISerializable* base, GVariant* v, GError** error) {
	zcdSerializableNone * self;
#line 125 "/home/luca/repo/wip/zcd/serializer.vala"
	self = (zcdSerializableNone*) base;
#line 125 "/home/luca/repo/wip/zcd/serializer.vala"
	g_return_if_fail (v != NULL);
#line 1415 "serializer.c"
}


zcdSerializableNone* zcd_serializable_none_construct (GType object_type) {
	zcdSerializableNone * self = NULL;
#line 117 "/home/luca/repo/wip/zcd/serializer.vala"
	self = (zcdSerializableNone*) g_object_new (object_type, NULL);
#line 117 "/home/luca/repo/wip/zcd/serializer.vala"
	return self;
#line 1425 "serializer.c"
}


zcdSerializableNone* zcd_serializable_none_new (void) {
#line 117 "/home/luca/repo/wip/zcd/serializer.vala"
	return zcd_serializable_none_construct (ZCD_TYPE_SERIALIZABLE_NONE);
#line 1432 "serializer.c"
}


static void zcd_serializable_none_class_init (zcdSerializableNoneClass * klass) {
#line 117 "/home/luca/repo/wip/zcd/serializer.vala"
	zcd_serializable_none_parent_class = g_type_class_peek_parent (klass);
#line 1439 "serializer.c"
}


static void zcd_serializable_none_zcd_iserializable_interface_init (zcdISerializableIface * iface) {
#line 117 "/home/luca/repo/wip/zcd/serializer.vala"
	zcd_serializable_none_zcd_iserializable_parent_iface = g_type_interface_peek_parent (iface);
#line 117 "/home/luca/repo/wip/zcd/serializer.vala"
	iface->serialize_to_variant = (GVariant* (*)(zcdISerializable*)) zcd_serializable_none_real_serialize_to_variant;
#line 117 "/home/luca/repo/wip/zcd/serializer.vala"
	iface->deserialize_from_variant = (void (*)(zcdISerializable*, GVariant*, GError**)) zcd_serializable_none_real_deserialize_from_variant;
#line 1450 "serializer.c"
}


static void zcd_serializable_none_instance_init (zcdSerializableNone * self) {
}


/** Return value for "void"
      */
GType zcd_serializable_none_get_type (void) {
	static volatile gsize zcd_serializable_none_type_id__volatile = 0;
	if (g_once_init_enter (&zcd_serializable_none_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (zcdSerializableNoneClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) zcd_serializable_none_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (zcdSerializableNone), 0, (GInstanceInitFunc) zcd_serializable_none_instance_init, NULL };
		static const GInterfaceInfo zcd_iserializable_info = { (GInterfaceInitFunc) zcd_serializable_none_zcd_iserializable_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
		GType zcd_serializable_none_type_id;
		zcd_serializable_none_type_id = g_type_register_static (G_TYPE_OBJECT, "zcdSerializableNone", &g_define_type_info, 0);
		g_type_add_interface_static (zcd_serializable_none_type_id, ZCD_TYPE_ISERIALIZABLE, &zcd_iserializable_info);
		g_once_init_leave (&zcd_serializable_none_type_id__volatile, zcd_serializable_none_type_id);
	}
	return zcd_serializable_none_type_id__volatile;
}


zcdSerializableInt* zcd_serializable_int_construct (GType object_type, gint i) {
	zcdSerializableInt * self = NULL;
	gint _tmp0_;
#line 135 "/home/luca/repo/wip/zcd/serializer.vala"
	self = (zcdSerializableInt*) g_object_new (object_type, NULL);
#line 137 "/home/luca/repo/wip/zcd/serializer.vala"
	_tmp0_ = i;
#line 137 "/home/luca/repo/wip/zcd/serializer.vala"
	self->priv->_i = _tmp0_;
#line 135 "/home/luca/repo/wip/zcd/serializer.vala"
	return self;
#line 1485 "serializer.c"
}


zcdSerializableInt* zcd_serializable_int_new (gint i) {
#line 135 "/home/luca/repo/wip/zcd/serializer.vala"
	return zcd_serializable_int_construct (ZCD_TYPE_SERIALIZABLE_INT, i);
#line 1492 "serializer.c"
}


static GVariant* zcd_serializable_int_real_serialize_to_variant (zcdISerializable* base) {
	zcdSerializableInt * self;
	GVariant* result = NULL;
	gint _tmp0_;
	GVariant* _tmp1_ = NULL;
	GVariant* v;
#line 145 "/home/luca/repo/wip/zcd/serializer.vala"
	self = (zcdSerializableInt*) base;
#line 147 "/home/luca/repo/wip/zcd/serializer.vala"
	_tmp0_ = self->priv->_i;
#line 147 "/home/luca/repo/wip/zcd/serializer.vala"
	_tmp1_ = zcd_serializer_int_to_variant (_tmp0_);
#line 147 "/home/luca/repo/wip/zcd/serializer.vala"
	v = _tmp1_;
#line 148 "/home/luca/repo/wip/zcd/serializer.vala"
	result = v;
#line 148 "/home/luca/repo/wip/zcd/serializer.vala"
	return result;
#line 1514 "serializer.c"
}


static void zcd_serializable_int_real_deserialize_from_variant (zcdISerializable* base, GVariant* v, GError** error) {
	zcdSerializableInt * self;
	GVariant* _tmp0_;
	gint _tmp1_ = 0;
#line 150 "/home/luca/repo/wip/zcd/serializer.vala"
	self = (zcdSerializableInt*) base;
#line 150 "/home/luca/repo/wip/zcd/serializer.vala"
	g_return_if_fail (v != NULL);
#line 152 "/home/luca/repo/wip/zcd/serializer.vala"
	_tmp0_ = v;
#line 152 "/home/luca/repo/wip/zcd/serializer.vala"
	_tmp1_ = zcd_serializer_variant_to_int (_tmp0_);
#line 152 "/home/luca/repo/wip/zcd/serializer.vala"
	self->priv->_i = _tmp1_;
#line 1532 "serializer.c"
}


gint zcd_serializable_int_get_i (zcdSerializableInt* self) {
	gint result;
	gint _tmp0_;
#line 140 "/home/luca/repo/wip/zcd/serializer.vala"
	g_return_val_if_fail (self != NULL, 0);
#line 141 "/home/luca/repo/wip/zcd/serializer.vala"
	_tmp0_ = self->priv->_i;
#line 141 "/home/luca/repo/wip/zcd/serializer.vala"
	result = _tmp0_;
#line 141 "/home/luca/repo/wip/zcd/serializer.vala"
	return result;
#line 1547 "serializer.c"
}


static void zcd_serializable_int_class_init (zcdSerializableIntClass * klass) {
#line 132 "/home/luca/repo/wip/zcd/serializer.vala"
	zcd_serializable_int_parent_class = g_type_class_peek_parent (klass);
#line 132 "/home/luca/repo/wip/zcd/serializer.vala"
	g_type_class_add_private (klass, sizeof (zcdSerializableIntPrivate));
#line 132 "/home/luca/repo/wip/zcd/serializer.vala"
	G_OBJECT_CLASS (klass)->get_property = _vala_zcd_serializable_int_get_property;
#line 132 "/home/luca/repo/wip/zcd/serializer.vala"
	G_OBJECT_CLASS (klass)->finalize = zcd_serializable_int_finalize;
#line 132 "/home/luca/repo/wip/zcd/serializer.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), ZCD_SERIALIZABLE_INT_I, g_param_spec_int ("i", "i", "i", G_MININT, G_MAXINT, 0, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
#line 1562 "serializer.c"
}


static void zcd_serializable_int_zcd_iserializable_interface_init (zcdISerializableIface * iface) {
#line 132 "/home/luca/repo/wip/zcd/serializer.vala"
	zcd_serializable_int_zcd_iserializable_parent_iface = g_type_interface_peek_parent (iface);
#line 132 "/home/luca/repo/wip/zcd/serializer.vala"
	iface->serialize_to_variant = (GVariant* (*)(zcdISerializable*)) zcd_serializable_int_real_serialize_to_variant;
#line 132 "/home/luca/repo/wip/zcd/serializer.vala"
	iface->deserialize_from_variant = (void (*)(zcdISerializable*, GVariant*, GError**)) zcd_serializable_int_real_deserialize_from_variant;
#line 1573 "serializer.c"
}


static void zcd_serializable_int_instance_init (zcdSerializableInt * self) {
#line 132 "/home/luca/repo/wip/zcd/serializer.vala"
	self->priv = ZCD_SERIALIZABLE_INT_GET_PRIVATE (self);
#line 1580 "serializer.c"
}


static void zcd_serializable_int_finalize (GObject* obj) {
	zcdSerializableInt * self;
#line 132 "/home/luca/repo/wip/zcd/serializer.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, ZCD_TYPE_SERIALIZABLE_INT, zcdSerializableInt);
#line 132 "/home/luca/repo/wip/zcd/serializer.vala"
	G_OBJECT_CLASS (zcd_serializable_int_parent_class)->finalize (obj);
#line 1590 "serializer.c"
}


/** Serializable class for int
      */
GType zcd_serializable_int_get_type (void) {
	static volatile gsize zcd_serializable_int_type_id__volatile = 0;
	if (g_once_init_enter (&zcd_serializable_int_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (zcdSerializableIntClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) zcd_serializable_int_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (zcdSerializableInt), 0, (GInstanceInitFunc) zcd_serializable_int_instance_init, NULL };
		static const GInterfaceInfo zcd_iserializable_info = { (GInterfaceInitFunc) zcd_serializable_int_zcd_iserializable_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
		GType zcd_serializable_int_type_id;
		zcd_serializable_int_type_id = g_type_register_static (G_TYPE_OBJECT, "zcdSerializableInt", &g_define_type_info, 0);
		g_type_add_interface_static (zcd_serializable_int_type_id, ZCD_TYPE_ISERIALIZABLE, &zcd_iserializable_info);
		g_once_init_leave (&zcd_serializable_int_type_id__volatile, zcd_serializable_int_type_id);
	}
	return zcd_serializable_int_type_id__volatile;
}


static void _vala_zcd_serializable_int_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	zcdSerializableInt * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, ZCD_TYPE_SERIALIZABLE_INT, zcdSerializableInt);
#line 132 "/home/luca/repo/wip/zcd/serializer.vala"
	switch (property_id) {
#line 132 "/home/luca/repo/wip/zcd/serializer.vala"
		case ZCD_SERIALIZABLE_INT_I:
#line 132 "/home/luca/repo/wip/zcd/serializer.vala"
		g_value_set_int (value, zcd_serializable_int_get_i (self));
#line 132 "/home/luca/repo/wip/zcd/serializer.vala"
		break;
#line 1621 "serializer.c"
		default:
#line 132 "/home/luca/repo/wip/zcd/serializer.vala"
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
#line 132 "/home/luca/repo/wip/zcd/serializer.vala"
		break;
#line 1627 "serializer.c"
	}
}


zcdSerializableBool* zcd_serializable_bool_construct (GType object_type, gboolean b) {
	zcdSerializableBool * self = NULL;
	gint _tmp0_ = 0;
	gboolean _tmp1_;
	gint _tmp2_;
#line 161 "/home/luca/repo/wip/zcd/serializer.vala"
	self = (zcdSerializableBool*) g_object_new (object_type, NULL);
#line 163 "/home/luca/repo/wip/zcd/serializer.vala"
	_tmp1_ = b;
#line 163 "/home/luca/repo/wip/zcd/serializer.vala"
	if (_tmp1_) {
#line 163 "/home/luca/repo/wip/zcd/serializer.vala"
		_tmp0_ = 1;
#line 1645 "serializer.c"
	} else {
#line 163 "/home/luca/repo/wip/zcd/serializer.vala"
		_tmp0_ = 0;
#line 1649 "serializer.c"
	}
#line 163 "/home/luca/repo/wip/zcd/serializer.vala"
	_tmp2_ = _tmp0_;
#line 163 "/home/luca/repo/wip/zcd/serializer.vala"
	self->priv->_i = _tmp2_;
#line 161 "/home/luca/repo/wip/zcd/serializer.vala"
	return self;
#line 1657 "serializer.c"
}


zcdSerializableBool* zcd_serializable_bool_new (gboolean b) {
#line 161 "/home/luca/repo/wip/zcd/serializer.vala"
	return zcd_serializable_bool_construct (ZCD_TYPE_SERIALIZABLE_BOOL, b);
#line 1664 "serializer.c"
}


static GVariant* zcd_serializable_bool_real_serialize_to_variant (zcdISerializable* base) {
	zcdSerializableBool * self;
	GVariant* result = NULL;
	gint _tmp0_;
	GVariant* _tmp1_ = NULL;
	GVariant* v;
#line 171 "/home/luca/repo/wip/zcd/serializer.vala"
	self = (zcdSerializableBool*) base;
#line 173 "/home/luca/repo/wip/zcd/serializer.vala"
	_tmp0_ = self->priv->_i;
#line 173 "/home/luca/repo/wip/zcd/serializer.vala"
	_tmp1_ = zcd_serializer_int_to_variant (_tmp0_);
#line 173 "/home/luca/repo/wip/zcd/serializer.vala"
	v = _tmp1_;
#line 174 "/home/luca/repo/wip/zcd/serializer.vala"
	result = v;
#line 174 "/home/luca/repo/wip/zcd/serializer.vala"
	return result;
#line 1686 "serializer.c"
}


static void zcd_serializable_bool_real_deserialize_from_variant (zcdISerializable* base, GVariant* v, GError** error) {
	zcdSerializableBool * self;
	GVariant* _tmp0_;
	gint _tmp1_ = 0;
#line 176 "/home/luca/repo/wip/zcd/serializer.vala"
	self = (zcdSerializableBool*) base;
#line 176 "/home/luca/repo/wip/zcd/serializer.vala"
	g_return_if_fail (v != NULL);
#line 178 "/home/luca/repo/wip/zcd/serializer.vala"
	_tmp0_ = v;
#line 178 "/home/luca/repo/wip/zcd/serializer.vala"
	_tmp1_ = zcd_serializer_variant_to_int (_tmp0_);
#line 178 "/home/luca/repo/wip/zcd/serializer.vala"
	self->priv->_i = _tmp1_;
#line 1704 "serializer.c"
}


gboolean zcd_serializable_bool_get_b (zcdSerializableBool* self) {
	gboolean result;
	gint _tmp0_;
#line 166 "/home/luca/repo/wip/zcd/serializer.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 167 "/home/luca/repo/wip/zcd/serializer.vala"
	_tmp0_ = self->priv->_i;
#line 167 "/home/luca/repo/wip/zcd/serializer.vala"
	result = _tmp0_ == 1;
#line 167 "/home/luca/repo/wip/zcd/serializer.vala"
	return result;
#line 1719 "serializer.c"
}


static void zcd_serializable_bool_class_init (zcdSerializableBoolClass * klass) {
#line 158 "/home/luca/repo/wip/zcd/serializer.vala"
	zcd_serializable_bool_parent_class = g_type_class_peek_parent (klass);
#line 158 "/home/luca/repo/wip/zcd/serializer.vala"
	g_type_class_add_private (klass, sizeof (zcdSerializableBoolPrivate));
#line 158 "/home/luca/repo/wip/zcd/serializer.vala"
	G_OBJECT_CLASS (klass)->get_property = _vala_zcd_serializable_bool_get_property;
#line 158 "/home/luca/repo/wip/zcd/serializer.vala"
	G_OBJECT_CLASS (klass)->finalize = zcd_serializable_bool_finalize;
#line 158 "/home/luca/repo/wip/zcd/serializer.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), ZCD_SERIALIZABLE_BOOL_B, g_param_spec_boolean ("b", "b", "b", FALSE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
#line 1734 "serializer.c"
}


static void zcd_serializable_bool_zcd_iserializable_interface_init (zcdISerializableIface * iface) {
#line 158 "/home/luca/repo/wip/zcd/serializer.vala"
	zcd_serializable_bool_zcd_iserializable_parent_iface = g_type_interface_peek_parent (iface);
#line 158 "/home/luca/repo/wip/zcd/serializer.vala"
	iface->serialize_to_variant = (GVariant* (*)(zcdISerializable*)) zcd_serializable_bool_real_serialize_to_variant;
#line 158 "/home/luca/repo/wip/zcd/serializer.vala"
	iface->deserialize_from_variant = (void (*)(zcdISerializable*, GVariant*, GError**)) zcd_serializable_bool_real_deserialize_from_variant;
#line 1745 "serializer.c"
}


static void zcd_serializable_bool_instance_init (zcdSerializableBool * self) {
#line 158 "/home/luca/repo/wip/zcd/serializer.vala"
	self->priv = ZCD_SERIALIZABLE_BOOL_GET_PRIVATE (self);
#line 1752 "serializer.c"
}


static void zcd_serializable_bool_finalize (GObject* obj) {
	zcdSerializableBool * self;
#line 158 "/home/luca/repo/wip/zcd/serializer.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, ZCD_TYPE_SERIALIZABLE_BOOL, zcdSerializableBool);
#line 158 "/home/luca/repo/wip/zcd/serializer.vala"
	G_OBJECT_CLASS (zcd_serializable_bool_parent_class)->finalize (obj);
#line 1762 "serializer.c"
}


/** Serializable class for bool
      */
GType zcd_serializable_bool_get_type (void) {
	static volatile gsize zcd_serializable_bool_type_id__volatile = 0;
	if (g_once_init_enter (&zcd_serializable_bool_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (zcdSerializableBoolClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) zcd_serializable_bool_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (zcdSerializableBool), 0, (GInstanceInitFunc) zcd_serializable_bool_instance_init, NULL };
		static const GInterfaceInfo zcd_iserializable_info = { (GInterfaceInitFunc) zcd_serializable_bool_zcd_iserializable_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
		GType zcd_serializable_bool_type_id;
		zcd_serializable_bool_type_id = g_type_register_static (G_TYPE_OBJECT, "zcdSerializableBool", &g_define_type_info, 0);
		g_type_add_interface_static (zcd_serializable_bool_type_id, ZCD_TYPE_ISERIALIZABLE, &zcd_iserializable_info);
		g_once_init_leave (&zcd_serializable_bool_type_id__volatile, zcd_serializable_bool_type_id);
	}
	return zcd_serializable_bool_type_id__volatile;
}


static void _vala_zcd_serializable_bool_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	zcdSerializableBool * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, ZCD_TYPE_SERIALIZABLE_BOOL, zcdSerializableBool);
#line 158 "/home/luca/repo/wip/zcd/serializer.vala"
	switch (property_id) {
#line 158 "/home/luca/repo/wip/zcd/serializer.vala"
		case ZCD_SERIALIZABLE_BOOL_B:
#line 158 "/home/luca/repo/wip/zcd/serializer.vala"
		g_value_set_boolean (value, zcd_serializable_bool_get_b (self));
#line 158 "/home/luca/repo/wip/zcd/serializer.vala"
		break;
#line 1793 "serializer.c"
		default:
#line 158 "/home/luca/repo/wip/zcd/serializer.vala"
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
#line 158 "/home/luca/repo/wip/zcd/serializer.vala"
		break;
#line 1799 "serializer.c"
	}
}


zcdSerializableString* zcd_serializable_string_construct (GType object_type, const gchar* s) {
	zcdSerializableString * self = NULL;
	const gchar* _tmp0_;
	gchar* _tmp1_;
#line 187 "/home/luca/repo/wip/zcd/serializer.vala"
	g_return_val_if_fail (s != NULL, NULL);
#line 187 "/home/luca/repo/wip/zcd/serializer.vala"
	self = (zcdSerializableString*) g_object_new (object_type, NULL);
#line 189 "/home/luca/repo/wip/zcd/serializer.vala"
	_tmp0_ = s;
#line 189 "/home/luca/repo/wip/zcd/serializer.vala"
	_tmp1_ = g_strdup (_tmp0_);
#line 189 "/home/luca/repo/wip/zcd/serializer.vala"
	_g_free0 (self->priv->_s);
#line 189 "/home/luca/repo/wip/zcd/serializer.vala"
	self->priv->_s = _tmp1_;
#line 187 "/home/luca/repo/wip/zcd/serializer.vala"
	return self;
#line 1822 "serializer.c"
}


zcdSerializableString* zcd_serializable_string_new (const gchar* s) {
#line 187 "/home/luca/repo/wip/zcd/serializer.vala"
	return zcd_serializable_string_construct (ZCD_TYPE_SERIALIZABLE_STRING, s);
#line 1829 "serializer.c"
}


static GVariant* zcd_serializable_string_real_serialize_to_variant (zcdISerializable* base) {
	zcdSerializableString * self;
	GVariant* result = NULL;
	const gchar* _tmp0_;
	GVariant* _tmp1_ = NULL;
	GVariant* v;
#line 197 "/home/luca/repo/wip/zcd/serializer.vala"
	self = (zcdSerializableString*) base;
#line 199 "/home/luca/repo/wip/zcd/serializer.vala"
	_tmp0_ = self->priv->_s;
#line 199 "/home/luca/repo/wip/zcd/serializer.vala"
	_tmp1_ = zcd_serializer_string_to_variant (_tmp0_);
#line 199 "/home/luca/repo/wip/zcd/serializer.vala"
	v = _tmp1_;
#line 200 "/home/luca/repo/wip/zcd/serializer.vala"
	result = v;
#line 200 "/home/luca/repo/wip/zcd/serializer.vala"
	return result;
#line 1851 "serializer.c"
}


static void zcd_serializable_string_real_deserialize_from_variant (zcdISerializable* base, GVariant* v, GError** error) {
	zcdSerializableString * self;
	GVariant* _tmp0_;
	gchar* _tmp1_ = NULL;
#line 202 "/home/luca/repo/wip/zcd/serializer.vala"
	self = (zcdSerializableString*) base;
#line 202 "/home/luca/repo/wip/zcd/serializer.vala"
	g_return_if_fail (v != NULL);
#line 204 "/home/luca/repo/wip/zcd/serializer.vala"
	_tmp0_ = v;
#line 204 "/home/luca/repo/wip/zcd/serializer.vala"
	_tmp1_ = zcd_serializer_variant_to_string (_tmp0_);
#line 204 "/home/luca/repo/wip/zcd/serializer.vala"
	_g_free0 (self->priv->_s);
#line 204 "/home/luca/repo/wip/zcd/serializer.vala"
	self->priv->_s = _tmp1_;
#line 1871 "serializer.c"
}


const gchar* zcd_serializable_string_get_s (zcdSerializableString* self) {
	const gchar* result;
	const gchar* _tmp0_;
#line 192 "/home/luca/repo/wip/zcd/serializer.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 193 "/home/luca/repo/wip/zcd/serializer.vala"
	_tmp0_ = self->priv->_s;
#line 193 "/home/luca/repo/wip/zcd/serializer.vala"
	result = _tmp0_;
#line 193 "/home/luca/repo/wip/zcd/serializer.vala"
	return result;
#line 1886 "serializer.c"
}


static void zcd_serializable_string_class_init (zcdSerializableStringClass * klass) {
#line 184 "/home/luca/repo/wip/zcd/serializer.vala"
	zcd_serializable_string_parent_class = g_type_class_peek_parent (klass);
#line 184 "/home/luca/repo/wip/zcd/serializer.vala"
	g_type_class_add_private (klass, sizeof (zcdSerializableStringPrivate));
#line 184 "/home/luca/repo/wip/zcd/serializer.vala"
	G_OBJECT_CLASS (klass)->get_property = _vala_zcd_serializable_string_get_property;
#line 184 "/home/luca/repo/wip/zcd/serializer.vala"
	G_OBJECT_CLASS (klass)->finalize = zcd_serializable_string_finalize;
#line 184 "/home/luca/repo/wip/zcd/serializer.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), ZCD_SERIALIZABLE_STRING_S, g_param_spec_string ("s", "s", "s", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
#line 1901 "serializer.c"
}


static void zcd_serializable_string_zcd_iserializable_interface_init (zcdISerializableIface * iface) {
#line 184 "/home/luca/repo/wip/zcd/serializer.vala"
	zcd_serializable_string_zcd_iserializable_parent_iface = g_type_interface_peek_parent (iface);
#line 184 "/home/luca/repo/wip/zcd/serializer.vala"
	iface->serialize_to_variant = (GVariant* (*)(zcdISerializable*)) zcd_serializable_string_real_serialize_to_variant;
#line 184 "/home/luca/repo/wip/zcd/serializer.vala"
	iface->deserialize_from_variant = (void (*)(zcdISerializable*, GVariant*, GError**)) zcd_serializable_string_real_deserialize_from_variant;
#line 1912 "serializer.c"
}


static void zcd_serializable_string_instance_init (zcdSerializableString * self) {
#line 184 "/home/luca/repo/wip/zcd/serializer.vala"
	self->priv = ZCD_SERIALIZABLE_STRING_GET_PRIVATE (self);
#line 1919 "serializer.c"
}


static void zcd_serializable_string_finalize (GObject* obj) {
	zcdSerializableString * self;
#line 184 "/home/luca/repo/wip/zcd/serializer.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, ZCD_TYPE_SERIALIZABLE_STRING, zcdSerializableString);
#line 186 "/home/luca/repo/wip/zcd/serializer.vala"
	_g_free0 (self->priv->_s);
#line 184 "/home/luca/repo/wip/zcd/serializer.vala"
	G_OBJECT_CLASS (zcd_serializable_string_parent_class)->finalize (obj);
#line 1931 "serializer.c"
}


/** Serializable class for string
      */
GType zcd_serializable_string_get_type (void) {
	static volatile gsize zcd_serializable_string_type_id__volatile = 0;
	if (g_once_init_enter (&zcd_serializable_string_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (zcdSerializableStringClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) zcd_serializable_string_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (zcdSerializableString), 0, (GInstanceInitFunc) zcd_serializable_string_instance_init, NULL };
		static const GInterfaceInfo zcd_iserializable_info = { (GInterfaceInitFunc) zcd_serializable_string_zcd_iserializable_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
		GType zcd_serializable_string_type_id;
		zcd_serializable_string_type_id = g_type_register_static (G_TYPE_OBJECT, "zcdSerializableString", &g_define_type_info, 0);
		g_type_add_interface_static (zcd_serializable_string_type_id, ZCD_TYPE_ISERIALIZABLE, &zcd_iserializable_info);
		g_once_init_leave (&zcd_serializable_string_type_id__volatile, zcd_serializable_string_type_id);
	}
	return zcd_serializable_string_type_id__volatile;
}


static void _vala_zcd_serializable_string_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	zcdSerializableString * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, ZCD_TYPE_SERIALIZABLE_STRING, zcdSerializableString);
#line 184 "/home/luca/repo/wip/zcd/serializer.vala"
	switch (property_id) {
#line 184 "/home/luca/repo/wip/zcd/serializer.vala"
		case ZCD_SERIALIZABLE_STRING_S:
#line 184 "/home/luca/repo/wip/zcd/serializer.vala"
		g_value_set_string (value, zcd_serializable_string_get_s (self));
#line 184 "/home/luca/repo/wip/zcd/serializer.vala"
		break;
#line 1962 "serializer.c"
		default:
#line 184 "/home/luca/repo/wip/zcd/serializer.vala"
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
#line 184 "/home/luca/repo/wip/zcd/serializer.vala"
		break;
#line 1968 "serializer.c"
	}
}


static guint8* _vala_array_dup14 (guint8* self, int length) {
#line 215 "/home/luca/repo/wip/zcd/serializer.vala"
	return g_memdup (self, length * sizeof (guint8));
#line 1976 "serializer.c"
}


zcdSerializableBuffer* zcd_serializable_buffer_construct (GType object_type, guint8* buffer, int buffer_length1) {
	zcdSerializableBuffer * self = NULL;
	guint8* _tmp0_;
	gint _tmp0__length1;
	guint8* _tmp1_;
	gint _tmp1__length1;
#line 213 "/home/luca/repo/wip/zcd/serializer.vala"
	self = (zcdSerializableBuffer*) g_object_new (object_type, NULL);
#line 215 "/home/luca/repo/wip/zcd/serializer.vala"
	_tmp0_ = buffer;
#line 215 "/home/luca/repo/wip/zcd/serializer.vala"
	_tmp0__length1 = buffer_length1;
#line 215 "/home/luca/repo/wip/zcd/serializer.vala"
	_tmp1_ = (_tmp0_ != NULL) ? _vala_array_dup14 (_tmp0_, _tmp0__length1) : ((gpointer) _tmp0_);
#line 215 "/home/luca/repo/wip/zcd/serializer.vala"
	_tmp1__length1 = _tmp0__length1;
#line 215 "/home/luca/repo/wip/zcd/serializer.vala"
	self->priv->_buffer = (g_free (self->priv->_buffer), NULL);
#line 215 "/home/luca/repo/wip/zcd/serializer.vala"
	self->priv->_buffer = _tmp1_;
#line 215 "/home/luca/repo/wip/zcd/serializer.vala"
	self->priv->_buffer_length1 = _tmp1__length1;
#line 215 "/home/luca/repo/wip/zcd/serializer.vala"
	self->priv->__buffer_size_ = self->priv->_buffer_length1;
#line 213 "/home/luca/repo/wip/zcd/serializer.vala"
	return self;
#line 2006 "serializer.c"
}


zcdSerializableBuffer* zcd_serializable_buffer_new (guint8* buffer, int buffer_length1) {
#line 213 "/home/luca/repo/wip/zcd/serializer.vala"
	return zcd_serializable_buffer_construct (ZCD_TYPE_SERIALIZABLE_BUFFER, buffer, buffer_length1);
#line 2013 "serializer.c"
}


static GVariant* zcd_serializable_buffer_real_serialize_to_variant (zcdISerializable* base) {
	zcdSerializableBuffer * self;
	GVariant* result = NULL;
	guint8* _tmp0_;
	gint _tmp0__length1;
	GVariant* _tmp1_ = NULL;
#line 223 "/home/luca/repo/wip/zcd/serializer.vala"
	self = (zcdSerializableBuffer*) base;
#line 225 "/home/luca/repo/wip/zcd/serializer.vala"
	_tmp0_ = self->priv->_buffer;
#line 225 "/home/luca/repo/wip/zcd/serializer.vala"
	_tmp0__length1 = self->priv->_buffer_length1;
#line 225 "/home/luca/repo/wip/zcd/serializer.vala"
	_tmp1_ = zcd_serializer_uchar_array_to_variant ((guchar*) _tmp0_, (_tmp0__length1 * sizeof (guint8)) / sizeof (guchar));
#line 225 "/home/luca/repo/wip/zcd/serializer.vala"
	result = _tmp1_;
#line 225 "/home/luca/repo/wip/zcd/serializer.vala"
	return result;
#line 2035 "serializer.c"
}


static void zcd_serializable_buffer_real_deserialize_from_variant (zcdISerializable* base, GVariant* v, GError** error) {
	zcdSerializableBuffer * self;
	GVariant* _tmp0_;
	gint _tmp1_ = 0;
	guchar* _tmp2_ = NULL;
#line 227 "/home/luca/repo/wip/zcd/serializer.vala"
	self = (zcdSerializableBuffer*) base;
#line 227 "/home/luca/repo/wip/zcd/serializer.vala"
	g_return_if_fail (v != NULL);
#line 229 "/home/luca/repo/wip/zcd/serializer.vala"
	_tmp0_ = v;
#line 229 "/home/luca/repo/wip/zcd/serializer.vala"
	_tmp2_ = zcd_serializer_variant_to_uchar_array (_tmp0_, &_tmp1_);
#line 229 "/home/luca/repo/wip/zcd/serializer.vala"
	self->priv->_buffer = (g_free (self->priv->_buffer), NULL);
#line 229 "/home/luca/repo/wip/zcd/serializer.vala"
	self->priv->_buffer = (guint8*) _tmp2_;
#line 229 "/home/luca/repo/wip/zcd/serializer.vala"
	self->priv->_buffer_length1 = (_tmp1_ * sizeof (guchar)) / sizeof (guint8);
#line 229 "/home/luca/repo/wip/zcd/serializer.vala"
	self->priv->__buffer_size_ = self->priv->_buffer_length1;
#line 2060 "serializer.c"
}


guint8* zcd_serializable_buffer_get_buffer (zcdSerializableBuffer* self, int* result_length1) {
	guint8* result;
	guint8* _tmp0_;
	gint _tmp0__length1;
	guint8* _tmp1_;
	gint _tmp1__length1;
#line 218 "/home/luca/repo/wip/zcd/serializer.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 219 "/home/luca/repo/wip/zcd/serializer.vala"
	_tmp0_ = self->priv->_buffer;
#line 219 "/home/luca/repo/wip/zcd/serializer.vala"
	_tmp0__length1 = self->priv->_buffer_length1;
#line 219 "/home/luca/repo/wip/zcd/serializer.vala"
	_tmp1_ = _tmp0_;
#line 219 "/home/luca/repo/wip/zcd/serializer.vala"
	_tmp1__length1 = _tmp0__length1;
#line 219 "/home/luca/repo/wip/zcd/serializer.vala"
	if (result_length1) {
#line 219 "/home/luca/repo/wip/zcd/serializer.vala"
		*result_length1 = _tmp1__length1;
#line 2084 "serializer.c"
	}
#line 219 "/home/luca/repo/wip/zcd/serializer.vala"
	result = _tmp1_;
#line 219 "/home/luca/repo/wip/zcd/serializer.vala"
	return result;
#line 2090 "serializer.c"
}


static void zcd_serializable_buffer_class_init (zcdSerializableBufferClass * klass) {
#line 210 "/home/luca/repo/wip/zcd/serializer.vala"
	zcd_serializable_buffer_parent_class = g_type_class_peek_parent (klass);
#line 210 "/home/luca/repo/wip/zcd/serializer.vala"
	g_type_class_add_private (klass, sizeof (zcdSerializableBufferPrivate));
#line 210 "/home/luca/repo/wip/zcd/serializer.vala"
	G_OBJECT_CLASS (klass)->get_property = _vala_zcd_serializable_buffer_get_property;
#line 210 "/home/luca/repo/wip/zcd/serializer.vala"
	G_OBJECT_CLASS (klass)->finalize = zcd_serializable_buffer_finalize;
#line 2103 "serializer.c"
}


static void zcd_serializable_buffer_zcd_iserializable_interface_init (zcdISerializableIface * iface) {
#line 210 "/home/luca/repo/wip/zcd/serializer.vala"
	zcd_serializable_buffer_zcd_iserializable_parent_iface = g_type_interface_peek_parent (iface);
#line 210 "/home/luca/repo/wip/zcd/serializer.vala"
	iface->serialize_to_variant = (GVariant* (*)(zcdISerializable*)) zcd_serializable_buffer_real_serialize_to_variant;
#line 210 "/home/luca/repo/wip/zcd/serializer.vala"
	iface->deserialize_from_variant = (void (*)(zcdISerializable*, GVariant*, GError**)) zcd_serializable_buffer_real_deserialize_from_variant;
#line 2114 "serializer.c"
}


static void zcd_serializable_buffer_instance_init (zcdSerializableBuffer * self) {
#line 210 "/home/luca/repo/wip/zcd/serializer.vala"
	self->priv = ZCD_SERIALIZABLE_BUFFER_GET_PRIVATE (self);
#line 2121 "serializer.c"
}


static void zcd_serializable_buffer_finalize (GObject* obj) {
	zcdSerializableBuffer * self;
#line 210 "/home/luca/repo/wip/zcd/serializer.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, ZCD_TYPE_SERIALIZABLE_BUFFER, zcdSerializableBuffer);
#line 212 "/home/luca/repo/wip/zcd/serializer.vala"
	self->priv->_buffer = (g_free (self->priv->_buffer), NULL);
#line 210 "/home/luca/repo/wip/zcd/serializer.vala"
	G_OBJECT_CLASS (zcd_serializable_buffer_parent_class)->finalize (obj);
#line 2133 "serializer.c"
}


/** Serializable class for uint8[]
      */
GType zcd_serializable_buffer_get_type (void) {
	static volatile gsize zcd_serializable_buffer_type_id__volatile = 0;
	if (g_once_init_enter (&zcd_serializable_buffer_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (zcdSerializableBufferClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) zcd_serializable_buffer_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (zcdSerializableBuffer), 0, (GInstanceInitFunc) zcd_serializable_buffer_instance_init, NULL };
		static const GInterfaceInfo zcd_iserializable_info = { (GInterfaceInitFunc) zcd_serializable_buffer_zcd_iserializable_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
		GType zcd_serializable_buffer_type_id;
		zcd_serializable_buffer_type_id = g_type_register_static (G_TYPE_OBJECT, "zcdSerializableBuffer", &g_define_type_info, 0);
		g_type_add_interface_static (zcd_serializable_buffer_type_id, ZCD_TYPE_ISERIALIZABLE, &zcd_iserializable_info);
		g_once_init_leave (&zcd_serializable_buffer_type_id__volatile, zcd_serializable_buffer_type_id);
	}
	return zcd_serializable_buffer_type_id__volatile;
}


static void _vala_zcd_serializable_buffer_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	zcdSerializableBuffer * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, ZCD_TYPE_SERIALIZABLE_BUFFER, zcdSerializableBuffer);
#line 210 "/home/luca/repo/wip/zcd/serializer.vala"
	switch (property_id) {
#line 2158 "serializer.c"
		default:
#line 210 "/home/luca/repo/wip/zcd/serializer.vala"
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
#line 210 "/home/luca/repo/wip/zcd/serializer.vala"
		break;
#line 2164 "serializer.c"
	}
}


zcdListString* zcd_list_string_construct (GType object_type) {
	zcdListString * self = NULL;
	GeeArrayList* _tmp0_;
#line 239 "/home/luca/repo/wip/zcd/serializer.vala"
	self = (zcdListString*) g_object_new (object_type, NULL);
#line 241 "/home/luca/repo/wip/zcd/serializer.vala"
	_tmp0_ = gee_array_list_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, NULL, NULL, NULL);
#line 241 "/home/luca/repo/wip/zcd/serializer.vala"
	_g_object_unref0 (self->backed);
#line 241 "/home/luca/repo/wip/zcd/serializer.vala"
	self->backed = (GeeList*) _tmp0_;
#line 239 "/home/luca/repo/wip/zcd/serializer.vala"
	return self;
#line 2182 "serializer.c"
}


zcdListString* zcd_list_string_new (void) {
#line 239 "/home/luca/repo/wip/zcd/serializer.vala"
	return zcd_list_string_construct (ZCD_TYPE_LIST_STRING);
#line 2189 "serializer.c"
}


zcdListString* zcd_list_string_construct_with_backer (GType object_type, GeeList* backed) {
	zcdListString * self = NULL;
	GeeList* _tmp0_;
	GeeList* _tmp1_;
#line 244 "/home/luca/repo/wip/zcd/serializer.vala"
	g_return_val_if_fail (backed != NULL, NULL);
#line 244 "/home/luca/repo/wip/zcd/serializer.vala"
	self = (zcdListString*) g_object_new (object_type, NULL);
#line 246 "/home/luca/repo/wip/zcd/serializer.vala"
	_tmp0_ = backed;
#line 246 "/home/luca/repo/wip/zcd/serializer.vala"
	_tmp1_ = _g_object_ref0 (_tmp0_);
#line 246 "/home/luca/repo/wip/zcd/serializer.vala"
	_g_object_unref0 (self->backed);
#line 246 "/home/luca/repo/wip/zcd/serializer.vala"
	self->backed = _tmp1_;
#line 244 "/home/luca/repo/wip/zcd/serializer.vala"
	return self;
#line 2211 "serializer.c"
}


zcdListString* zcd_list_string_new_with_backer (GeeList* backed) {
#line 244 "/home/luca/repo/wip/zcd/serializer.vala"
	return zcd_list_string_construct_with_backer (ZCD_TYPE_LIST_STRING, backed);
#line 2218 "serializer.c"
}


GeeIterator* zcd_list_string_iterator (zcdListString* self) {
	GeeIterator* result = NULL;
	GeeList* _tmp0_;
	GeeIterator* _tmp1_ = NULL;
#line 255 "/home/luca/repo/wip/zcd/serializer.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 257 "/home/luca/repo/wip/zcd/serializer.vala"
	_tmp0_ = self->backed;
#line 257 "/home/luca/repo/wip/zcd/serializer.vala"
	_tmp1_ = gee_iterable_iterator ((GeeIterable*) _tmp0_);
#line 257 "/home/luca/repo/wip/zcd/serializer.vala"
	result = _tmp1_;
#line 257 "/home/luca/repo/wip/zcd/serializer.vala"
	return result;
#line 2236 "serializer.c"
}


void zcd_list_string_add (zcdListString* self, const gchar* el) {
	GeeList* _tmp0_;
	const gchar* _tmp1_;
#line 260 "/home/luca/repo/wip/zcd/serializer.vala"
	g_return_if_fail (self != NULL);
#line 260 "/home/luca/repo/wip/zcd/serializer.vala"
	g_return_if_fail (el != NULL);
#line 262 "/home/luca/repo/wip/zcd/serializer.vala"
	_tmp0_ = self->backed;
#line 262 "/home/luca/repo/wip/zcd/serializer.vala"
	_tmp1_ = el;
#line 262 "/home/luca/repo/wip/zcd/serializer.vala"
	gee_collection_add ((GeeCollection*) _tmp0_, _tmp1_);
#line 2253 "serializer.c"
}


static guint8* string_get_data (const gchar* self, int* result_length1) {
	guint8* result;
	guint8* res;
	gint res_length1;
	gint _res_size_;
	gint _tmp0_;
	gint _tmp1_;
	gint _tmp2_;
	guint8* _tmp3_;
	gint _tmp3__length1;
	guint8* _tmp4_;
	gint _tmp4__length1;
#line 1260 "/usr/share/vala-0.20/vapi/glib-2.0.vapi"
	g_return_val_if_fail (self != NULL, NULL);
#line 1261 "/usr/share/vala-0.20/vapi/glib-2.0.vapi"
	res = (guint8*) self;
#line 1261 "/usr/share/vala-0.20/vapi/glib-2.0.vapi"
	res_length1 = -1;
#line 1261 "/usr/share/vala-0.20/vapi/glib-2.0.vapi"
	_res_size_ = res_length1;
#line 1262 "/usr/share/vala-0.20/vapi/glib-2.0.vapi"
	_tmp0_ = strlen (self);
#line 1262 "/usr/share/vala-0.20/vapi/glib-2.0.vapi"
	_tmp1_ = _tmp0_;
#line 1262 "/usr/share/vala-0.20/vapi/glib-2.0.vapi"
	res_length1 = (gint) _tmp1_;
#line 1262 "/usr/share/vala-0.20/vapi/glib-2.0.vapi"
	_tmp2_ = res_length1;
#line 1263 "/usr/share/vala-0.20/vapi/glib-2.0.vapi"
	_tmp3_ = res;
#line 1263 "/usr/share/vala-0.20/vapi/glib-2.0.vapi"
	_tmp3__length1 = res_length1;
#line 1263 "/usr/share/vala-0.20/vapi/glib-2.0.vapi"
	_tmp4_ = _tmp3_;
#line 1263 "/usr/share/vala-0.20/vapi/glib-2.0.vapi"
	_tmp4__length1 = _tmp3__length1;
#line 1263 "/usr/share/vala-0.20/vapi/glib-2.0.vapi"
	if (result_length1) {
#line 1263 "/usr/share/vala-0.20/vapi/glib-2.0.vapi"
		*result_length1 = _tmp4__length1;
#line 2297 "serializer.c"
	}
#line 1263 "/usr/share/vala-0.20/vapi/glib-2.0.vapi"
	result = _tmp4_;
#line 1263 "/usr/share/vala-0.20/vapi/glib-2.0.vapi"
	return result;
#line 2303 "serializer.c"
}


static void _vala_array_add1 (guchar** array, int* length, int* size, guchar value) {
#line 271 "/home/luca/repo/wip/zcd/serializer.vala"
	if ((*length) == (*size)) {
#line 271 "/home/luca/repo/wip/zcd/serializer.vala"
		*size = (*size) ? (2 * (*size)) : 4;
#line 271 "/home/luca/repo/wip/zcd/serializer.vala"
		*array = g_renew (guchar, *array, *size);
#line 2314 "serializer.c"
	}
#line 271 "/home/luca/repo/wip/zcd/serializer.vala"
	(*array)[(*length)++] = value;
#line 2318 "serializer.c"
}


guchar* zcd_list_string_hash_for_signature (zcdListString* self, int* result_length1) {
	guchar* result = NULL;
	GeeList* _tmp0_;
	gint _tmp1_;
	gint _tmp2_;
	guchar* _tmp5_ = NULL;
	guchar* ret;
	gint ret_length1;
	gint _ret_size_;
	guchar* _tmp22_;
	gint _tmp22__length1;
#line 265 "/home/luca/repo/wip/zcd/serializer.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 267 "/home/luca/repo/wip/zcd/serializer.vala"
	_tmp0_ = self->backed;
#line 267 "/home/luca/repo/wip/zcd/serializer.vala"
	_tmp1_ = gee_collection_get_size ((GeeCollection*) _tmp0_);
#line 267 "/home/luca/repo/wip/zcd/serializer.vala"
	_tmp2_ = _tmp1_;
#line 267 "/home/luca/repo/wip/zcd/serializer.vala"
	if (_tmp2_ == 0) {
#line 2343 "serializer.c"
		guchar* _tmp3_ = NULL;
		guchar* _tmp4_;
		gint _tmp4__length1;
#line 267 "/home/luca/repo/wip/zcd/serializer.vala"
		_tmp3_ = g_new0 (guchar, 1);
#line 267 "/home/luca/repo/wip/zcd/serializer.vala"
		_tmp3_[0] = (guchar) 0;
#line 267 "/home/luca/repo/wip/zcd/serializer.vala"
		_tmp4_ = _tmp3_;
#line 267 "/home/luca/repo/wip/zcd/serializer.vala"
		_tmp4__length1 = 1;
#line 267 "/home/luca/repo/wip/zcd/serializer.vala"
		if (result_length1) {
#line 267 "/home/luca/repo/wip/zcd/serializer.vala"
			*result_length1 = _tmp4__length1;
#line 2359 "serializer.c"
		}
#line 267 "/home/luca/repo/wip/zcd/serializer.vala"
		result = _tmp4_;
#line 267 "/home/luca/repo/wip/zcd/serializer.vala"
		return result;
#line 2365 "serializer.c"
	}
#line 268 "/home/luca/repo/wip/zcd/serializer.vala"
	_tmp5_ = g_new0 (guchar, 1);
#line 268 "/home/luca/repo/wip/zcd/serializer.vala"
	_tmp5_[0] = (guchar) 1;
#line 268 "/home/luca/repo/wip/zcd/serializer.vala"
	ret = _tmp5_;
#line 268 "/home/luca/repo/wip/zcd/serializer.vala"
	ret_length1 = 1;
#line 268 "/home/luca/repo/wip/zcd/serializer.vala"
	_ret_size_ = ret_length1;
#line 2377 "serializer.c"
	{
		GeeList* _tmp6_;
		GeeList* _tmp7_;
		GeeList* _s_list;
		GeeList* _tmp8_;
		gint _tmp9_;
		gint _tmp10_;
		gint _s_size;
		gint _s_index;
#line 269 "/home/luca/repo/wip/zcd/serializer.vala"
		_tmp6_ = self->backed;
#line 269 "/home/luca/repo/wip/zcd/serializer.vala"
		_tmp7_ = _g_object_ref0 (_tmp6_);
#line 269 "/home/luca/repo/wip/zcd/serializer.vala"
		_s_list = _tmp7_;
#line 269 "/home/luca/repo/wip/zcd/serializer.vala"
		_tmp8_ = _s_list;
#line 269 "/home/luca/repo/wip/zcd/serializer.vala"
		_tmp9_ = gee_collection_get_size ((GeeCollection*) _tmp8_);
#line 269 "/home/luca/repo/wip/zcd/serializer.vala"
		_tmp10_ = _tmp9_;
#line 269 "/home/luca/repo/wip/zcd/serializer.vala"
		_s_size = _tmp10_;
#line 269 "/home/luca/repo/wip/zcd/serializer.vala"
		_s_index = -1;
#line 269 "/home/luca/repo/wip/zcd/serializer.vala"
		while (TRUE) {
#line 2405 "serializer.c"
			gint _tmp11_;
			gint _tmp12_;
			gint _tmp13_;
			GeeList* _tmp14_;
			gint _tmp15_;
			gpointer _tmp16_ = NULL;
			gchar* s;
			const gchar* _tmp17_;
			guint8* _tmp18_;
			gint _tmp18__length1;
			guint8* _tmp19_;
			gint _tmp19__length1;
#line 269 "/home/luca/repo/wip/zcd/serializer.vala"
			_tmp11_ = _s_index;
#line 269 "/home/luca/repo/wip/zcd/serializer.vala"
			_s_index = _tmp11_ + 1;
#line 269 "/home/luca/repo/wip/zcd/serializer.vala"
			_tmp12_ = _s_index;
#line 269 "/home/luca/repo/wip/zcd/serializer.vala"
			_tmp13_ = _s_size;
#line 269 "/home/luca/repo/wip/zcd/serializer.vala"
			if (!(_tmp12_ < _tmp13_)) {
#line 269 "/home/luca/repo/wip/zcd/serializer.vala"
				break;
#line 2430 "serializer.c"
			}
#line 269 "/home/luca/repo/wip/zcd/serializer.vala"
			_tmp14_ = _s_list;
#line 269 "/home/luca/repo/wip/zcd/serializer.vala"
			_tmp15_ = _s_index;
#line 269 "/home/luca/repo/wip/zcd/serializer.vala"
			_tmp16_ = gee_list_get (_tmp14_, _tmp15_);
#line 269 "/home/luca/repo/wip/zcd/serializer.vala"
			s = (gchar*) _tmp16_;
#line 270 "/home/luca/repo/wip/zcd/serializer.vala"
			_tmp17_ = s;
#line 270 "/home/luca/repo/wip/zcd/serializer.vala"
			_tmp18_ = string_get_data (_tmp17_, &_tmp18__length1);
#line 270 "/home/luca/repo/wip/zcd/serializer.vala"
			_tmp19_ = _tmp18_;
#line 270 "/home/luca/repo/wip/zcd/serializer.vala"
			_tmp19__length1 = _tmp18__length1;
#line 2448 "serializer.c"
			{
				guint8* u_collection = NULL;
				gint u_collection_length1 = 0;
				gint _u_collection_size_ = 0;
				gint u_it = 0;
#line 270 "/home/luca/repo/wip/zcd/serializer.vala"
				u_collection = _tmp19_;
#line 270 "/home/luca/repo/wip/zcd/serializer.vala"
				u_collection_length1 = _tmp19__length1;
#line 270 "/home/luca/repo/wip/zcd/serializer.vala"
				for (u_it = 0; u_it < _tmp19__length1; u_it = u_it + 1) {
#line 2460 "serializer.c"
					guchar u = '\0';
#line 270 "/home/luca/repo/wip/zcd/serializer.vala"
					u = (guchar) u_collection[u_it];
#line 2464 "serializer.c"
					{
						guchar* _tmp20_;
						gint _tmp20__length1;
						guchar _tmp21_;
#line 271 "/home/luca/repo/wip/zcd/serializer.vala"
						_tmp20_ = ret;
#line 271 "/home/luca/repo/wip/zcd/serializer.vala"
						_tmp20__length1 = ret_length1;
#line 271 "/home/luca/repo/wip/zcd/serializer.vala"
						_tmp21_ = u;
#line 271 "/home/luca/repo/wip/zcd/serializer.vala"
						_vala_array_add1 (&ret, &ret_length1, &_ret_size_, _tmp21_);
#line 2477 "serializer.c"
					}
				}
			}
#line 269 "/home/luca/repo/wip/zcd/serializer.vala"
			_g_free0 (s);
#line 2483 "serializer.c"
		}
#line 269 "/home/luca/repo/wip/zcd/serializer.vala"
		_g_object_unref0 (_s_list);
#line 2487 "serializer.c"
	}
#line 272 "/home/luca/repo/wip/zcd/serializer.vala"
	_tmp22_ = ret;
#line 272 "/home/luca/repo/wip/zcd/serializer.vala"
	_tmp22__length1 = ret_length1;
#line 272 "/home/luca/repo/wip/zcd/serializer.vala"
	if (result_length1) {
#line 272 "/home/luca/repo/wip/zcd/serializer.vala"
		*result_length1 = _tmp22__length1;
#line 2497 "serializer.c"
	}
#line 272 "/home/luca/repo/wip/zcd/serializer.vala"
	result = _tmp22_;
#line 272 "/home/luca/repo/wip/zcd/serializer.vala"
	return result;
#line 2503 "serializer.c"
}


static GVariant* zcd_list_string_real_serialize_to_variant (zcdISerializable* base) {
	zcdListString * self;
	GVariant* result = NULL;
	GeeList* _tmp0_;
	gint _tmp1_;
	gint _tmp2_;
	GeeList* _tmp4_;
	gint _tmp5_;
	gint _tmp6_;
	gchar** _tmp7_ = NULL;
	gchar** toar;
	gint toar_length1;
	gint _toar_size_;
	gchar** _tmp21_;
	gint _tmp21__length1;
	GVariant* _tmp22_ = NULL;
#line 275 "/home/luca/repo/wip/zcd/serializer.vala"
	self = (zcdListString*) base;
#line 277 "/home/luca/repo/wip/zcd/serializer.vala"
	_tmp0_ = self->backed;
#line 277 "/home/luca/repo/wip/zcd/serializer.vala"
	_tmp1_ = gee_collection_get_size ((GeeCollection*) _tmp0_);
#line 277 "/home/luca/repo/wip/zcd/serializer.vala"
	_tmp2_ = _tmp1_;
#line 277 "/home/luca/repo/wip/zcd/serializer.vala"
	if (_tmp2_ == 0) {
#line 2533 "serializer.c"
		GVariant* _tmp3_ = NULL;
#line 277 "/home/luca/repo/wip/zcd/serializer.vala"
		_tmp3_ = zcd_serializer_int_to_variant (0);
#line 277 "/home/luca/repo/wip/zcd/serializer.vala"
		result = _tmp3_;
#line 277 "/home/luca/repo/wip/zcd/serializer.vala"
		return result;
#line 2541 "serializer.c"
	}
#line 278 "/home/luca/repo/wip/zcd/serializer.vala"
	_tmp4_ = self->backed;
#line 278 "/home/luca/repo/wip/zcd/serializer.vala"
	_tmp5_ = gee_collection_get_size ((GeeCollection*) _tmp4_);
#line 278 "/home/luca/repo/wip/zcd/serializer.vala"
	_tmp6_ = _tmp5_;
#line 278 "/home/luca/repo/wip/zcd/serializer.vala"
	_tmp7_ = g_new0 (gchar*, _tmp6_ + 1);
#line 278 "/home/luca/repo/wip/zcd/serializer.vala"
	toar = _tmp7_;
#line 278 "/home/luca/repo/wip/zcd/serializer.vala"
	toar_length1 = _tmp6_;
#line 278 "/home/luca/repo/wip/zcd/serializer.vala"
	_toar_size_ = toar_length1;
#line 2557 "serializer.c"
	{
		gint i;
#line 279 "/home/luca/repo/wip/zcd/serializer.vala"
		i = 0;
#line 2562 "serializer.c"
		{
			gboolean _tmp8_;
#line 279 "/home/luca/repo/wip/zcd/serializer.vala"
			_tmp8_ = TRUE;
#line 279 "/home/luca/repo/wip/zcd/serializer.vala"
			while (TRUE) {
#line 2569 "serializer.c"
				gboolean _tmp9_;
				gint _tmp11_;
				GeeList* _tmp12_;
				gint _tmp13_;
				gint _tmp14_;
				gchar** _tmp15_;
				gint _tmp15__length1;
				gint _tmp16_;
				GeeList* _tmp17_;
				gint _tmp18_;
				gpointer _tmp19_ = NULL;
				gchar* _tmp20_;
#line 279 "/home/luca/repo/wip/zcd/serializer.vala"
				_tmp9_ = _tmp8_;
#line 279 "/home/luca/repo/wip/zcd/serializer.vala"
				if (!_tmp9_) {
#line 2586 "serializer.c"
					gint _tmp10_;
#line 279 "/home/luca/repo/wip/zcd/serializer.vala"
					_tmp10_ = i;
#line 279 "/home/luca/repo/wip/zcd/serializer.vala"
					i = _tmp10_ + 1;
#line 2592 "serializer.c"
				}
#line 279 "/home/luca/repo/wip/zcd/serializer.vala"
				_tmp8_ = FALSE;
#line 279 "/home/luca/repo/wip/zcd/serializer.vala"
				_tmp11_ = i;
#line 279 "/home/luca/repo/wip/zcd/serializer.vala"
				_tmp12_ = self->backed;
#line 279 "/home/luca/repo/wip/zcd/serializer.vala"
				_tmp13_ = gee_collection_get_size ((GeeCollection*) _tmp12_);
#line 279 "/home/luca/repo/wip/zcd/serializer.vala"
				_tmp14_ = _tmp13_;
#line 279 "/home/luca/repo/wip/zcd/serializer.vala"
				if (!(_tmp11_ < _tmp14_)) {
#line 279 "/home/luca/repo/wip/zcd/serializer.vala"
					break;
#line 2608 "serializer.c"
				}
#line 279 "/home/luca/repo/wip/zcd/serializer.vala"
				_tmp15_ = toar;
#line 279 "/home/luca/repo/wip/zcd/serializer.vala"
				_tmp15__length1 = toar_length1;
#line 279 "/home/luca/repo/wip/zcd/serializer.vala"
				_tmp16_ = i;
#line 279 "/home/luca/repo/wip/zcd/serializer.vala"
				_tmp17_ = self->backed;
#line 279 "/home/luca/repo/wip/zcd/serializer.vala"
				_tmp18_ = i;
#line 279 "/home/luca/repo/wip/zcd/serializer.vala"
				_tmp19_ = gee_list_get (_tmp17_, _tmp18_);
#line 279 "/home/luca/repo/wip/zcd/serializer.vala"
				_g_free0 (_tmp15_[_tmp16_]);
#line 279 "/home/luca/repo/wip/zcd/serializer.vala"
				_tmp15_[_tmp16_] = (gchar*) _tmp19_;
#line 279 "/home/luca/repo/wip/zcd/serializer.vala"
				_tmp20_ = _tmp15_[_tmp16_];
#line 2628 "serializer.c"
			}
		}
	}
#line 280 "/home/luca/repo/wip/zcd/serializer.vala"
	_tmp21_ = toar;
#line 280 "/home/luca/repo/wip/zcd/serializer.vala"
	_tmp21__length1 = toar_length1;
#line 280 "/home/luca/repo/wip/zcd/serializer.vala"
	_tmp22_ = zcd_serializer_string_array_to_variant (_tmp21_, _tmp21__length1);
#line 280 "/home/luca/repo/wip/zcd/serializer.vala"
	result = _tmp22_;
#line 280 "/home/luca/repo/wip/zcd/serializer.vala"
	toar = (_vala_array_free (toar, toar_length1, (GDestroyNotify) g_free), NULL);
#line 280 "/home/luca/repo/wip/zcd/serializer.vala"
	return result;
#line 2644 "serializer.c"
}


static void zcd_list_string_real_deserialize_from_variant (zcdISerializable* base, GVariant* v, GError** error) {
	zcdListString * self;
	GVariant* _tmp0_;
	const gchar* _tmp1_ = NULL;
	gchar* _tmp2_;
	gchar* vt;
	GeeArrayList* _tmp3_;
	const gchar* _tmp4_;
#line 283 "/home/luca/repo/wip/zcd/serializer.vala"
	self = (zcdListString*) base;
#line 283 "/home/luca/repo/wip/zcd/serializer.vala"
	g_return_if_fail (v != NULL);
#line 285 "/home/luca/repo/wip/zcd/serializer.vala"
	_tmp0_ = v;
#line 285 "/home/luca/repo/wip/zcd/serializer.vala"
	_tmp1_ = g_variant_get_type_string (_tmp0_);
#line 285 "/home/luca/repo/wip/zcd/serializer.vala"
	_tmp2_ = g_strdup (_tmp1_);
#line 285 "/home/luca/repo/wip/zcd/serializer.vala"
	vt = _tmp2_;
#line 286 "/home/luca/repo/wip/zcd/serializer.vala"
	_tmp3_ = gee_array_list_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, NULL, NULL, NULL);
#line 286 "/home/luca/repo/wip/zcd/serializer.vala"
	_g_object_unref0 (self->backed);
#line 286 "/home/luca/repo/wip/zcd/serializer.vala"
	self->backed = (GeeList*) _tmp3_;
#line 287 "/home/luca/repo/wip/zcd/serializer.vala"
	_tmp4_ = vt;
#line 287 "/home/luca/repo/wip/zcd/serializer.vala"
	if (g_strcmp0 (_tmp4_, "i") != 0) {
#line 2678 "serializer.c"
		GVariant* _tmp5_;
		gint _tmp6_ = 0;
		gchar** _tmp7_ = NULL;
		gchar** toar;
		gint toar_length1;
		gint _toar_size_;
#line 289 "/home/luca/repo/wip/zcd/serializer.vala"
		_tmp5_ = v;
#line 289 "/home/luca/repo/wip/zcd/serializer.vala"
		_tmp7_ = zcd_serializer_variant_to_string_array (_tmp5_, &_tmp6_);
#line 289 "/home/luca/repo/wip/zcd/serializer.vala"
		toar = _tmp7_;
#line 289 "/home/luca/repo/wip/zcd/serializer.vala"
		toar_length1 = _tmp6_;
#line 289 "/home/luca/repo/wip/zcd/serializer.vala"
		_toar_size_ = toar_length1;
#line 2695 "serializer.c"
		{
			gint i;
#line 290 "/home/luca/repo/wip/zcd/serializer.vala"
			i = 0;
#line 2700 "serializer.c"
			{
				gboolean _tmp8_;
#line 290 "/home/luca/repo/wip/zcd/serializer.vala"
				_tmp8_ = TRUE;
#line 290 "/home/luca/repo/wip/zcd/serializer.vala"
				while (TRUE) {
#line 2707 "serializer.c"
					gboolean _tmp9_;
					gint _tmp11_;
					gchar** _tmp12_;
					gint _tmp12__length1;
					GeeList* _tmp13_;
					gchar** _tmp14_;
					gint _tmp14__length1;
					gint _tmp15_;
					const gchar* _tmp16_;
#line 290 "/home/luca/repo/wip/zcd/serializer.vala"
					_tmp9_ = _tmp8_;
#line 290 "/home/luca/repo/wip/zcd/serializer.vala"
					if (!_tmp9_) {
#line 2721 "serializer.c"
						gint _tmp10_;
#line 290 "/home/luca/repo/wip/zcd/serializer.vala"
						_tmp10_ = i;
#line 290 "/home/luca/repo/wip/zcd/serializer.vala"
						i = _tmp10_ + 1;
#line 2727 "serializer.c"
					}
#line 290 "/home/luca/repo/wip/zcd/serializer.vala"
					_tmp8_ = FALSE;
#line 290 "/home/luca/repo/wip/zcd/serializer.vala"
					_tmp11_ = i;
#line 290 "/home/luca/repo/wip/zcd/serializer.vala"
					_tmp12_ = toar;
#line 290 "/home/luca/repo/wip/zcd/serializer.vala"
					_tmp12__length1 = toar_length1;
#line 290 "/home/luca/repo/wip/zcd/serializer.vala"
					if (!(_tmp11_ < _tmp12__length1)) {
#line 290 "/home/luca/repo/wip/zcd/serializer.vala"
						break;
#line 2741 "serializer.c"
					}
#line 290 "/home/luca/repo/wip/zcd/serializer.vala"
					_tmp13_ = self->backed;
#line 290 "/home/luca/repo/wip/zcd/serializer.vala"
					_tmp14_ = toar;
#line 290 "/home/luca/repo/wip/zcd/serializer.vala"
					_tmp14__length1 = toar_length1;
#line 290 "/home/luca/repo/wip/zcd/serializer.vala"
					_tmp15_ = i;
#line 290 "/home/luca/repo/wip/zcd/serializer.vala"
					_tmp16_ = _tmp14_[_tmp15_];
#line 290 "/home/luca/repo/wip/zcd/serializer.vala"
					gee_collection_add ((GeeCollection*) _tmp13_, _tmp16_);
#line 2755 "serializer.c"
				}
			}
		}
#line 287 "/home/luca/repo/wip/zcd/serializer.vala"
		toar = (_vala_array_free (toar, toar_length1, (GDestroyNotify) g_free), NULL);
#line 2761 "serializer.c"
	}
#line 283 "/home/luca/repo/wip/zcd/serializer.vala"
	_g_free0 (vt);
#line 2765 "serializer.c"
}


gint zcd_list_string_get_size (zcdListString* self) {
	gint result;
	GeeList* _tmp0_;
	gint _tmp1_;
	gint _tmp2_;
#line 250 "/home/luca/repo/wip/zcd/serializer.vala"
	g_return_val_if_fail (self != NULL, 0);
#line 251 "/home/luca/repo/wip/zcd/serializer.vala"
	_tmp0_ = self->backed;
#line 251 "/home/luca/repo/wip/zcd/serializer.vala"
	_tmp1_ = gee_collection_get_size ((GeeCollection*) _tmp0_);
#line 251 "/home/luca/repo/wip/zcd/serializer.vala"
	_tmp2_ = _tmp1_;
#line 251 "/home/luca/repo/wip/zcd/serializer.vala"
	result = _tmp2_;
#line 251 "/home/luca/repo/wip/zcd/serializer.vala"
	return result;
#line 2786 "serializer.c"
}


static void zcd_list_string_class_init (zcdListStringClass * klass) {
#line 235 "/home/luca/repo/wip/zcd/serializer.vala"
	zcd_list_string_parent_class = g_type_class_peek_parent (klass);
#line 235 "/home/luca/repo/wip/zcd/serializer.vala"
	G_OBJECT_CLASS (klass)->get_property = _vala_zcd_list_string_get_property;
#line 235 "/home/luca/repo/wip/zcd/serializer.vala"
	G_OBJECT_CLASS (klass)->finalize = zcd_list_string_finalize;
#line 235 "/home/luca/repo/wip/zcd/serializer.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), ZCD_LIST_STRING_SIZE, g_param_spec_int ("size", "size", "size", G_MININT, G_MAXINT, 0, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
#line 2799 "serializer.c"
}


static void zcd_list_string_zcd_iserializable_interface_init (zcdISerializableIface * iface) {
#line 235 "/home/luca/repo/wip/zcd/serializer.vala"
	zcd_list_string_zcd_iserializable_parent_iface = g_type_interface_peek_parent (iface);
#line 235 "/home/luca/repo/wip/zcd/serializer.vala"
	iface->serialize_to_variant = (GVariant* (*)(zcdISerializable*)) zcd_list_string_real_serialize_to_variant;
#line 235 "/home/luca/repo/wip/zcd/serializer.vala"
	iface->deserialize_from_variant = (void (*)(zcdISerializable*, GVariant*, GError**)) zcd_list_string_real_deserialize_from_variant;
#line 2810 "serializer.c"
}


static void zcd_list_string_instance_init (zcdListString * self) {
}


static void zcd_list_string_finalize (GObject* obj) {
	zcdListString * self;
#line 235 "/home/luca/repo/wip/zcd/serializer.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, ZCD_TYPE_LIST_STRING, zcdListString);
#line 237 "/home/luca/repo/wip/zcd/serializer.vala"
	_g_object_unref0 (self->backed);
#line 235 "/home/luca/repo/wip/zcd/serializer.vala"
	G_OBJECT_CLASS (zcd_list_string_parent_class)->finalize (obj);
#line 2826 "serializer.c"
}


/** Serializable class for List<string>
      */
GType zcd_list_string_get_type (void) {
	static volatile gsize zcd_list_string_type_id__volatile = 0;
	if (g_once_init_enter (&zcd_list_string_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (zcdListStringClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) zcd_list_string_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (zcdListString), 0, (GInstanceInitFunc) zcd_list_string_instance_init, NULL };
		static const GInterfaceInfo zcd_iserializable_info = { (GInterfaceInitFunc) zcd_list_string_zcd_iserializable_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
		GType zcd_list_string_type_id;
		zcd_list_string_type_id = g_type_register_static (G_TYPE_OBJECT, "zcdListString", &g_define_type_info, 0);
		g_type_add_interface_static (zcd_list_string_type_id, ZCD_TYPE_ISERIALIZABLE, &zcd_iserializable_info);
		g_once_init_leave (&zcd_list_string_type_id__volatile, zcd_list_string_type_id);
	}
	return zcd_list_string_type_id__volatile;
}


static void _vala_zcd_list_string_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	zcdListString * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, ZCD_TYPE_LIST_STRING, zcdListString);
#line 235 "/home/luca/repo/wip/zcd/serializer.vala"
	switch (property_id) {
#line 235 "/home/luca/repo/wip/zcd/serializer.vala"
		case ZCD_LIST_STRING_SIZE:
#line 235 "/home/luca/repo/wip/zcd/serializer.vala"
		g_value_set_int (value, zcd_list_string_get_size (self));
#line 235 "/home/luca/repo/wip/zcd/serializer.vala"
		break;
#line 2857 "serializer.c"
		default:
#line 235 "/home/luca/repo/wip/zcd/serializer.vala"
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
#line 235 "/home/luca/repo/wip/zcd/serializer.vala"
		break;
#line 2863 "serializer.c"
	}
}


static gboolean zcd_list_iserializable_not_impl_equal_func (GObject* a, GObject* b) {
	gboolean result = FALSE;
	gchar* _tmp0_;
	gchar* astr;
	GObject* _tmp1_;
	gchar* _tmp6_;
	gchar* bstr;
	GObject* _tmp7_;
	const gchar* _tmp12_;
	const gchar* _tmp13_ = NULL;
	const gchar* _tmp14_;
	const gchar* _tmp15_ = NULL;
	gchar* _tmp16_ = NULL;
	gchar* _tmp17_;
#line 320 "/home/luca/repo/wip/zcd/serializer.vala"
	_tmp0_ = g_strdup ("null");
#line 320 "/home/luca/repo/wip/zcd/serializer.vala"
	astr = _tmp0_;
#line 321 "/home/luca/repo/wip/zcd/serializer.vala"
	_tmp1_ = a;
#line 321 "/home/luca/repo/wip/zcd/serializer.vala"
	if (_tmp1_ != NULL) {
#line 2890 "serializer.c"
		GObject* _tmp2_;
		GType _tmp3_ = 0UL;
		const gchar* _tmp4_ = NULL;
		gchar* _tmp5_;
#line 321 "/home/luca/repo/wip/zcd/serializer.vala"
		_tmp2_ = a;
#line 321 "/home/luca/repo/wip/zcd/serializer.vala"
		_tmp3_ = G_TYPE_FROM_INSTANCE (_tmp2_);
#line 321 "/home/luca/repo/wip/zcd/serializer.vala"
		_tmp4_ = g_type_name (_tmp3_);
#line 321 "/home/luca/repo/wip/zcd/serializer.vala"
		_tmp5_ = g_strdup (_tmp4_);
#line 321 "/home/luca/repo/wip/zcd/serializer.vala"
		_g_free0 (astr);
#line 321 "/home/luca/repo/wip/zcd/serializer.vala"
		astr = _tmp5_;
#line 2907 "serializer.c"
	}
#line 322 "/home/luca/repo/wip/zcd/serializer.vala"
	_tmp6_ = g_strdup ("null");
#line 322 "/home/luca/repo/wip/zcd/serializer.vala"
	bstr = _tmp6_;
#line 323 "/home/luca/repo/wip/zcd/serializer.vala"
	_tmp7_ = b;
#line 323 "/home/luca/repo/wip/zcd/serializer.vala"
	if (_tmp7_ != NULL) {
#line 2917 "serializer.c"
		GObject* _tmp8_;
		GType _tmp9_ = 0UL;
		const gchar* _tmp10_ = NULL;
		gchar* _tmp11_;
#line 323 "/home/luca/repo/wip/zcd/serializer.vala"
		_tmp8_ = b;
#line 323 "/home/luca/repo/wip/zcd/serializer.vala"
		_tmp9_ = G_TYPE_FROM_INSTANCE (_tmp8_);
#line 323 "/home/luca/repo/wip/zcd/serializer.vala"
		_tmp10_ = g_type_name (_tmp9_);
#line 323 "/home/luca/repo/wip/zcd/serializer.vala"
		_tmp11_ = g_strdup (_tmp10_);
#line 323 "/home/luca/repo/wip/zcd/serializer.vala"
		_g_free0 (bstr);
#line 323 "/home/luca/repo/wip/zcd/serializer.vala"
		bstr = _tmp11_;
#line 2934 "serializer.c"
	}
#line 324 "/home/luca/repo/wip/zcd/serializer.vala"
	_tmp12_ = astr;
#line 324 "/home/luca/repo/wip/zcd/serializer.vala"
	_tmp13_ = string_to_string (_tmp12_);
#line 324 "/home/luca/repo/wip/zcd/serializer.vala"
	_tmp14_ = bstr;
#line 324 "/home/luca/repo/wip/zcd/serializer.vala"
	_tmp15_ = string_to_string (_tmp14_);
#line 324 "/home/luca/repo/wip/zcd/serializer.vala"
	_tmp16_ = g_strconcat ("equal_func not implemented: compare between ", _tmp13_, " and ", _tmp15_, NULL);
#line 324 "/home/luca/repo/wip/zcd/serializer.vala"
	_tmp17_ = _tmp16_;
#line 324 "/home/luca/repo/wip/zcd/serializer.vala"
	g_error ("serializer.vala:324: %s", _tmp17_);
#line 324 "/home/luca/repo/wip/zcd/serializer.vala"
	_g_free0 (_tmp17_);
#line 318 "/home/luca/repo/wip/zcd/serializer.vala"
	_g_free0 (bstr);
#line 318 "/home/luca/repo/wip/zcd/serializer.vala"
	_g_free0 (astr);
#line 318 "/home/luca/repo/wip/zcd/serializer.vala"
	return result;
#line 2958 "serializer.c"
}


zcdListISerializable* zcd_list_iserializable_construct (GType object_type) {
	zcdListISerializable * self = NULL;
	GeeArrayList* _tmp0_;
#line 326 "/home/luca/repo/wip/zcd/serializer.vala"
	self = (zcdListISerializable*) g_object_new (object_type, NULL);
#line 328 "/home/luca/repo/wip/zcd/serializer.vala"
	_tmp0_ = gee_array_list_new (ZCD_TYPE_ISERIALIZABLE, (GBoxedCopyFunc) g_object_ref, g_object_unref, (GeeEqualDataFunc) zcd_list_iserializable_not_impl_equal_func, NULL, NULL);
#line 328 "/home/luca/repo/wip/zcd/serializer.vala"
	_g_object_unref0 (self->backed);
#line 328 "/home/luca/repo/wip/zcd/serializer.vala"
	self->backed = (GeeList*) _tmp0_;
#line 326 "/home/luca/repo/wip/zcd/serializer.vala"
	return self;
#line 2975 "serializer.c"
}


zcdListISerializable* zcd_list_iserializable_new (void) {
#line 326 "/home/luca/repo/wip/zcd/serializer.vala"
	return zcd_list_iserializable_construct (ZCD_TYPE_LIST_ISERIALIZABLE);
#line 2982 "serializer.c"
}


zcdListISerializable* zcd_list_iserializable_construct_with_backer (GType object_type, GeeList* backed) {
	zcdListISerializable * self = NULL;
	GeeList* _tmp0_;
	GeeList* _tmp1_;
#line 331 "/home/luca/repo/wip/zcd/serializer.vala"
	g_return_val_if_fail (backed != NULL, NULL);
#line 331 "/home/luca/repo/wip/zcd/serializer.vala"
	self = (zcdListISerializable*) g_object_new (object_type, NULL);
#line 333 "/home/luca/repo/wip/zcd/serializer.vala"
	_tmp0_ = backed;
#line 333 "/home/luca/repo/wip/zcd/serializer.vala"
	_tmp1_ = _g_object_ref0 (_tmp0_);
#line 333 "/home/luca/repo/wip/zcd/serializer.vala"
	_g_object_unref0 (self->backed);
#line 333 "/home/luca/repo/wip/zcd/serializer.vala"
	self->backed = _tmp1_;
#line 331 "/home/luca/repo/wip/zcd/serializer.vala"
	return self;
#line 3004 "serializer.c"
}


zcdListISerializable* zcd_list_iserializable_new_with_backer (GeeList* backed) {
#line 331 "/home/luca/repo/wip/zcd/serializer.vala"
	return zcd_list_iserializable_construct_with_backer (ZCD_TYPE_LIST_ISERIALIZABLE, backed);
#line 3011 "serializer.c"
}


GeeIterator* zcd_list_iserializable_iterator (zcdListISerializable* self) {
	GeeIterator* result = NULL;
	GeeList* _tmp0_;
	GeeIterator* _tmp1_ = NULL;
#line 342 "/home/luca/repo/wip/zcd/serializer.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 344 "/home/luca/repo/wip/zcd/serializer.vala"
	_tmp0_ = self->backed;
#line 344 "/home/luca/repo/wip/zcd/serializer.vala"
	_tmp1_ = gee_iterable_iterator ((GeeIterable*) _tmp0_);
#line 344 "/home/luca/repo/wip/zcd/serializer.vala"
	result = _tmp1_;
#line 344 "/home/luca/repo/wip/zcd/serializer.vala"
	return result;
#line 3029 "serializer.c"
}


void zcd_list_iserializable_add (zcdListISerializable* self, zcdISerializable* el) {
	GeeList* _tmp0_;
	zcdISerializable* _tmp1_;
#line 347 "/home/luca/repo/wip/zcd/serializer.vala"
	g_return_if_fail (self != NULL);
#line 347 "/home/luca/repo/wip/zcd/serializer.vala"
	g_return_if_fail (el != NULL);
#line 349 "/home/luca/repo/wip/zcd/serializer.vala"
	_tmp0_ = self->backed;
#line 349 "/home/luca/repo/wip/zcd/serializer.vala"
	_tmp1_ = el;
#line 349 "/home/luca/repo/wip/zcd/serializer.vala"
	gee_collection_add ((GeeCollection*) _tmp0_, _tmp1_);
#line 3046 "serializer.c"
}


static GVariant* zcd_list_iserializable_real_serialize_to_variant (zcdISerializable* base) {
	zcdListISerializable * self;
	GVariant* result = NULL;
	GeeList* _tmp0_;
	gint _tmp1_;
	gint _tmp2_;
	GeeList* _tmp4_;
	gint _tmp5_;
	gint _tmp6_;
	GVariant** _tmp7_ = NULL;
	GVariant** toar;
	gint toar_length1;
	gint _toar_size_;
	GVariant** _tmp23_;
	gint _tmp23__length1;
	GVariant* _tmp24_ = NULL;
	GVariant* v0;
	GeeList* _tmp25_;
	gpointer _tmp26_ = NULL;
	zcdISerializable* _tmp27_;
	GType _tmp28_ = 0UL;
	const gchar* _tmp29_ = NULL;
	GVariant* _tmp30_ = NULL;
	GVariant* _tmp31_;
	GVariant* v1;
	GVariant* _tmp32_;
	GVariant* _tmp33_;
	GVariant* _tmp34_ = NULL;
#line 352 "/home/luca/repo/wip/zcd/serializer.vala"
	self = (zcdListISerializable*) base;
#line 354 "/home/luca/repo/wip/zcd/serializer.vala"
	_tmp0_ = self->backed;
#line 354 "/home/luca/repo/wip/zcd/serializer.vala"
	_tmp1_ = gee_collection_get_size ((GeeCollection*) _tmp0_);
#line 354 "/home/luca/repo/wip/zcd/serializer.vala"
	_tmp2_ = _tmp1_;
#line 354 "/home/luca/repo/wip/zcd/serializer.vala"
	if (_tmp2_ == 0) {
#line 3088 "serializer.c"
		GVariant* _tmp3_ = NULL;
#line 354 "/home/luca/repo/wip/zcd/serializer.vala"
		_tmp3_ = zcd_serializer_int_to_variant (0);
#line 354 "/home/luca/repo/wip/zcd/serializer.vala"
		result = _tmp3_;
#line 354 "/home/luca/repo/wip/zcd/serializer.vala"
		return result;
#line 3096 "serializer.c"
	}
#line 355 "/home/luca/repo/wip/zcd/serializer.vala"
	_tmp4_ = self->backed;
#line 355 "/home/luca/repo/wip/zcd/serializer.vala"
	_tmp5_ = gee_collection_get_size ((GeeCollection*) _tmp4_);
#line 355 "/home/luca/repo/wip/zcd/serializer.vala"
	_tmp6_ = _tmp5_;
#line 355 "/home/luca/repo/wip/zcd/serializer.vala"
	_tmp7_ = g_new0 (GVariant*, _tmp6_ + 1);
#line 355 "/home/luca/repo/wip/zcd/serializer.vala"
	toar = _tmp7_;
#line 355 "/home/luca/repo/wip/zcd/serializer.vala"
	toar_length1 = _tmp6_;
#line 355 "/home/luca/repo/wip/zcd/serializer.vala"
	_toar_size_ = toar_length1;
#line 3112 "serializer.c"
	{
		gint i;
#line 356 "/home/luca/repo/wip/zcd/serializer.vala"
		i = 0;
#line 3117 "serializer.c"
		{
			gboolean _tmp8_;
#line 356 "/home/luca/repo/wip/zcd/serializer.vala"
			_tmp8_ = TRUE;
#line 356 "/home/luca/repo/wip/zcd/serializer.vala"
			while (TRUE) {
#line 3124 "serializer.c"
				gboolean _tmp9_;
				gint _tmp11_;
				GeeList* _tmp12_;
				gint _tmp13_;
				gint _tmp14_;
				GeeList* _tmp15_;
				gint _tmp16_;
				gpointer _tmp17_ = NULL;
				zcdISerializable* el;
				GVariant** _tmp18_;
				gint _tmp18__length1;
				gint _tmp19_;
				zcdISerializable* _tmp20_;
				GVariant* _tmp21_ = NULL;
				GVariant* _tmp22_;
#line 356 "/home/luca/repo/wip/zcd/serializer.vala"
				_tmp9_ = _tmp8_;
#line 356 "/home/luca/repo/wip/zcd/serializer.vala"
				if (!_tmp9_) {
#line 3144 "serializer.c"
					gint _tmp10_;
#line 356 "/home/luca/repo/wip/zcd/serializer.vala"
					_tmp10_ = i;
#line 356 "/home/luca/repo/wip/zcd/serializer.vala"
					i = _tmp10_ + 1;
#line 3150 "serializer.c"
				}
#line 356 "/home/luca/repo/wip/zcd/serializer.vala"
				_tmp8_ = FALSE;
#line 356 "/home/luca/repo/wip/zcd/serializer.vala"
				_tmp11_ = i;
#line 356 "/home/luca/repo/wip/zcd/serializer.vala"
				_tmp12_ = self->backed;
#line 356 "/home/luca/repo/wip/zcd/serializer.vala"
				_tmp13_ = gee_collection_get_size ((GeeCollection*) _tmp12_);
#line 356 "/home/luca/repo/wip/zcd/serializer.vala"
				_tmp14_ = _tmp13_;
#line 356 "/home/luca/repo/wip/zcd/serializer.vala"
				if (!(_tmp11_ < _tmp14_)) {
#line 356 "/home/luca/repo/wip/zcd/serializer.vala"
					break;
#line 3166 "serializer.c"
				}
#line 358 "/home/luca/repo/wip/zcd/serializer.vala"
				_tmp15_ = self->backed;
#line 358 "/home/luca/repo/wip/zcd/serializer.vala"
				_tmp16_ = i;
#line 358 "/home/luca/repo/wip/zcd/serializer.vala"
				_tmp17_ = gee_list_get (_tmp15_, _tmp16_);
#line 358 "/home/luca/repo/wip/zcd/serializer.vala"
				el = G_TYPE_CHECK_INSTANCE_CAST ((zcdISerializable*) _tmp17_, ZCD_TYPE_ISERIALIZABLE, zcdISerializable);
#line 359 "/home/luca/repo/wip/zcd/serializer.vala"
				_tmp18_ = toar;
#line 359 "/home/luca/repo/wip/zcd/serializer.vala"
				_tmp18__length1 = toar_length1;
#line 359 "/home/luca/repo/wip/zcd/serializer.vala"
				_tmp19_ = i;
#line 359 "/home/luca/repo/wip/zcd/serializer.vala"
				_tmp20_ = el;
#line 359 "/home/luca/repo/wip/zcd/serializer.vala"
				_tmp21_ = zcd_iserializable_serialize_to_variant (_tmp20_);
#line 359 "/home/luca/repo/wip/zcd/serializer.vala"
				_g_variant_unref0 (_tmp18_[_tmp19_]);
#line 359 "/home/luca/repo/wip/zcd/serializer.vala"
				_tmp18_[_tmp19_] = _tmp21_;
#line 359 "/home/luca/repo/wip/zcd/serializer.vala"
				_tmp22_ = _tmp18_[_tmp19_];
#line 356 "/home/luca/repo/wip/zcd/serializer.vala"
				_g_object_unref0 (el);
#line 3194 "serializer.c"
			}
		}
	}
#line 361 "/home/luca/repo/wip/zcd/serializer.vala"
	_tmp23_ = toar;
#line 361 "/home/luca/repo/wip/zcd/serializer.vala"
	_tmp23__length1 = toar_length1;
#line 361 "/home/luca/repo/wip/zcd/serializer.vala"
	_tmp24_ = zcd_serializer_variant_array_to_variant (_tmp23_, _tmp23__length1);
#line 361 "/home/luca/repo/wip/zcd/serializer.vala"
	v0 = _tmp24_;
#line 362 "/home/luca/repo/wip/zcd/serializer.vala"
	_tmp25_ = self->backed;
#line 362 "/home/luca/repo/wip/zcd/serializer.vala"
	_tmp26_ = gee_list_get (_tmp25_, 0);
#line 362 "/home/luca/repo/wip/zcd/serializer.vala"
	_tmp27_ = (zcdISerializable*) _tmp26_;
#line 362 "/home/luca/repo/wip/zcd/serializer.vala"
	_tmp28_ = G_TYPE_FROM_INSTANCE ((GObject*) _tmp27_);
#line 362 "/home/luca/repo/wip/zcd/serializer.vala"
	_tmp29_ = g_type_name (_tmp28_);
#line 362 "/home/luca/repo/wip/zcd/serializer.vala"
	_tmp30_ = zcd_serializer_string_to_variant (_tmp29_);
#line 362 "/home/luca/repo/wip/zcd/serializer.vala"
	_tmp31_ = _tmp30_;
#line 362 "/home/luca/repo/wip/zcd/serializer.vala"
	_g_object_unref0 (_tmp27_);
#line 362 "/home/luca/repo/wip/zcd/serializer.vala"
	v1 = _tmp31_;
#line 363 "/home/luca/repo/wip/zcd/serializer.vala"
	_tmp32_ = v0;
#line 363 "/home/luca/repo/wip/zcd/serializer.vala"
	_tmp33_ = v1;
#line 363 "/home/luca/repo/wip/zcd/serializer.vala"
	_tmp34_ = zcd_serializer_tuple_to_variant (_tmp32_, _tmp33_);
#line 363 "/home/luca/repo/wip/zcd/serializer.vala"
	result = _tmp34_;
#line 363 "/home/luca/repo/wip/zcd/serializer.vala"
	_g_variant_unref0 (v1);
#line 363 "/home/luca/repo/wip/zcd/serializer.vala"
	_g_variant_unref0 (v0);
#line 363 "/home/luca/repo/wip/zcd/serializer.vala"
	toar = (_vala_array_free (toar, toar_length1, (GDestroyNotify) g_variant_unref), NULL);
#line 363 "/home/luca/repo/wip/zcd/serializer.vala"
	return result;
#line 3240 "serializer.c"
}


static void zcd_list_iserializable_real_deserialize_from_variant (zcdISerializable* base, GVariant* v, GError** error) {
	zcdListISerializable * self;
	GVariant* _tmp0_;
	const gchar* _tmp1_ = NULL;
	gchar* _tmp2_;
	gchar* vt;
	GeeArrayList* _tmp3_;
	const gchar* _tmp4_;
	GError * _inner_error_ = NULL;
#line 366 "/home/luca/repo/wip/zcd/serializer.vala"
	self = (zcdListISerializable*) base;
#line 366 "/home/luca/repo/wip/zcd/serializer.vala"
	g_return_if_fail (v != NULL);
#line 368 "/home/luca/repo/wip/zcd/serializer.vala"
	_tmp0_ = v;
#line 368 "/home/luca/repo/wip/zcd/serializer.vala"
	_tmp1_ = g_variant_get_type_string (_tmp0_);
#line 368 "/home/luca/repo/wip/zcd/serializer.vala"
	_tmp2_ = g_strdup (_tmp1_);
#line 368 "/home/luca/repo/wip/zcd/serializer.vala"
	vt = _tmp2_;
#line 369 "/home/luca/repo/wip/zcd/serializer.vala"
	_tmp3_ = gee_array_list_new (ZCD_TYPE_ISERIALIZABLE, (GBoxedCopyFunc) g_object_ref, g_object_unref, (GeeEqualDataFunc) zcd_list_iserializable_not_impl_equal_func, NULL, NULL);
#line 369 "/home/luca/repo/wip/zcd/serializer.vala"
	_g_object_unref0 (self->backed);
#line 369 "/home/luca/repo/wip/zcd/serializer.vala"
	self->backed = (GeeList*) _tmp3_;
#line 370 "/home/luca/repo/wip/zcd/serializer.vala"
	_tmp4_ = vt;
#line 370 "/home/luca/repo/wip/zcd/serializer.vala"
	if (g_strcmp0 (_tmp4_, "i") != 0) {
#line 3275 "serializer.c"
		GVariant* v0 = NULL;
		GVariant* v1 = NULL;
		GVariant* _tmp5_;
		GVariant* _tmp6_ = NULL;
		GVariant* _tmp7_ = NULL;
		GVariant* _tmp8_;
		gint _tmp9_ = 0;
		GVariant** _tmp10_ = NULL;
		GVariant** toar;
		gint toar_length1;
		gint _toar_size_;
		GVariant* _tmp11_;
		gchar* _tmp12_ = NULL;
		gchar* typename;
		gboolean _tmp13_ = FALSE;
		const gchar* _tmp14_;
		gboolean _tmp16_;
		const gchar* _tmp18_;
		GType _tmp19_ = 0UL;
		GType type;
		GType _tmp20_;
		GType _tmp27_;
		gboolean _tmp28_ = FALSE;
#line 374 "/home/luca/repo/wip/zcd/serializer.vala"
		_tmp5_ = v;
#line 374 "/home/luca/repo/wip/zcd/serializer.vala"
		zcd_serializer_variant_to_tuple (_tmp5_, &_tmp6_, &_tmp7_);
#line 374 "/home/luca/repo/wip/zcd/serializer.vala"
		_g_variant_unref0 (v0);
#line 374 "/home/luca/repo/wip/zcd/serializer.vala"
		v0 = _tmp6_;
#line 374 "/home/luca/repo/wip/zcd/serializer.vala"
		_g_variant_unref0 (v1);
#line 374 "/home/luca/repo/wip/zcd/serializer.vala"
		v1 = _tmp7_;
#line 375 "/home/luca/repo/wip/zcd/serializer.vala"
		_tmp8_ = v0;
#line 375 "/home/luca/repo/wip/zcd/serializer.vala"
		_tmp10_ = zcd_serializer_variant_to_variant_array (_tmp8_, &_tmp9_);
#line 375 "/home/luca/repo/wip/zcd/serializer.vala"
		toar = _tmp10_;
#line 375 "/home/luca/repo/wip/zcd/serializer.vala"
		toar_length1 = _tmp9_;
#line 375 "/home/luca/repo/wip/zcd/serializer.vala"
		_toar_size_ = toar_length1;
#line 376 "/home/luca/repo/wip/zcd/serializer.vala"
		_tmp11_ = v1;
#line 376 "/home/luca/repo/wip/zcd/serializer.vala"
		_tmp12_ = zcd_serializer_variant_to_string (_tmp11_);
#line 376 "/home/luca/repo/wip/zcd/serializer.vala"
		typename = _tmp12_;
#line 377 "/home/luca/repo/wip/zcd/serializer.vala"
		_tmp14_ = typename;
#line 377 "/home/luca/repo/wip/zcd/serializer.vala"
		if (_tmp14_ == NULL) {
#line 377 "/home/luca/repo/wip/zcd/serializer.vala"
			_tmp13_ = TRUE;
#line 3333 "serializer.c"
		} else {
			const gchar* _tmp15_;
#line 377 "/home/luca/repo/wip/zcd/serializer.vala"
			_tmp15_ = typename;
#line 377 "/home/luca/repo/wip/zcd/serializer.vala"
			_tmp13_ = g_strcmp0 (_tmp15_, "") == 0;
#line 3340 "serializer.c"
		}
#line 377 "/home/luca/repo/wip/zcd/serializer.vala"
		_tmp16_ = _tmp13_;
#line 377 "/home/luca/repo/wip/zcd/serializer.vala"
		if (_tmp16_) {
#line 3346 "serializer.c"
			GError* _tmp17_;
#line 377 "/home/luca/repo/wip/zcd/serializer.vala"
			_tmp17_ = g_error_new_literal (ZCD_SERIALIZER_ERROR, ZCD_SERIALIZER_ERROR_GENERIC, "Typename not specified.");
#line 377 "/home/luca/repo/wip/zcd/serializer.vala"
			_inner_error_ = _tmp17_;
#line 377 "/home/luca/repo/wip/zcd/serializer.vala"
			if (_inner_error_->domain == ZCD_SERIALIZER_ERROR) {
#line 377 "/home/luca/repo/wip/zcd/serializer.vala"
				g_propagate_error (error, _inner_error_);
#line 377 "/home/luca/repo/wip/zcd/serializer.vala"
				_g_free0 (typename);
#line 377 "/home/luca/repo/wip/zcd/serializer.vala"
				toar = (_vala_array_free (toar, toar_length1, (GDestroyNotify) g_variant_unref), NULL);
#line 377 "/home/luca/repo/wip/zcd/serializer.vala"
				_g_variant_unref0 (v1);
#line 377 "/home/luca/repo/wip/zcd/serializer.vala"
				_g_variant_unref0 (v0);
#line 377 "/home/luca/repo/wip/zcd/serializer.vala"
				_g_free0 (vt);
#line 377 "/home/luca/repo/wip/zcd/serializer.vala"
				return;
#line 3368 "serializer.c"
			} else {
#line 377 "/home/luca/repo/wip/zcd/serializer.vala"
				_g_free0 (typename);
#line 377 "/home/luca/repo/wip/zcd/serializer.vala"
				toar = (_vala_array_free (toar, toar_length1, (GDestroyNotify) g_variant_unref), NULL);
#line 377 "/home/luca/repo/wip/zcd/serializer.vala"
				_g_variant_unref0 (v1);
#line 377 "/home/luca/repo/wip/zcd/serializer.vala"
				_g_variant_unref0 (v0);
#line 377 "/home/luca/repo/wip/zcd/serializer.vala"
				_g_free0 (vt);
#line 377 "/home/luca/repo/wip/zcd/serializer.vala"
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 377 "/home/luca/repo/wip/zcd/serializer.vala"
				g_clear_error (&_inner_error_);
#line 377 "/home/luca/repo/wip/zcd/serializer.vala"
				return;
#line 3386 "serializer.c"
			}
		}
#line 378 "/home/luca/repo/wip/zcd/serializer.vala"
		_tmp18_ = typename;
#line 378 "/home/luca/repo/wip/zcd/serializer.vala"
		_tmp19_ = g_type_from_name (_tmp18_);
#line 378 "/home/luca/repo/wip/zcd/serializer.vala"
		type = _tmp19_;
#line 379 "/home/luca/repo/wip/zcd/serializer.vala"
		_tmp20_ = type;
#line 379 "/home/luca/repo/wip/zcd/serializer.vala"
		if (_tmp20_ == ((GType) 0)) {
#line 3399 "serializer.c"
			const gchar* _tmp21_;
			const gchar* _tmp22_ = NULL;
			gchar* _tmp23_ = NULL;
			gchar* _tmp24_;
			GError* _tmp25_;
			GError* _tmp26_;
#line 379 "/home/luca/repo/wip/zcd/serializer.vala"
			_tmp21_ = typename;
#line 379 "/home/luca/repo/wip/zcd/serializer.vala"
			_tmp22_ = string_to_string (_tmp21_);
#line 379 "/home/luca/repo/wip/zcd/serializer.vala"
			_tmp23_ = g_strconcat ("Typename '", _tmp22_, "' is unknown.", NULL);
#line 379 "/home/luca/repo/wip/zcd/serializer.vala"
			_tmp24_ = _tmp23_;
#line 379 "/home/luca/repo/wip/zcd/serializer.vala"
			_tmp25_ = g_error_new_literal (ZCD_SERIALIZER_ERROR, ZCD_SERIALIZER_ERROR_GENERIC, _tmp24_);
#line 379 "/home/luca/repo/wip/zcd/serializer.vala"
			_tmp26_ = _tmp25_;
#line 379 "/home/luca/repo/wip/zcd/serializer.vala"
			_g_free0 (_tmp24_);
#line 379 "/home/luca/repo/wip/zcd/serializer.vala"
			_inner_error_ = _tmp26_;
#line 379 "/home/luca/repo/wip/zcd/serializer.vala"
			if (_inner_error_->domain == ZCD_SERIALIZER_ERROR) {
#line 379 "/home/luca/repo/wip/zcd/serializer.vala"
				g_propagate_error (error, _inner_error_);
#line 379 "/home/luca/repo/wip/zcd/serializer.vala"
				_g_free0 (typename);
#line 379 "/home/luca/repo/wip/zcd/serializer.vala"
				toar = (_vala_array_free (toar, toar_length1, (GDestroyNotify) g_variant_unref), NULL);
#line 379 "/home/luca/repo/wip/zcd/serializer.vala"
				_g_variant_unref0 (v1);
#line 379 "/home/luca/repo/wip/zcd/serializer.vala"
				_g_variant_unref0 (v0);
#line 379 "/home/luca/repo/wip/zcd/serializer.vala"
				_g_free0 (vt);
#line 379 "/home/luca/repo/wip/zcd/serializer.vala"
				return;
#line 3438 "serializer.c"
			} else {
#line 379 "/home/luca/repo/wip/zcd/serializer.vala"
				_g_free0 (typename);
#line 379 "/home/luca/repo/wip/zcd/serializer.vala"
				toar = (_vala_array_free (toar, toar_length1, (GDestroyNotify) g_variant_unref), NULL);
#line 379 "/home/luca/repo/wip/zcd/serializer.vala"
				_g_variant_unref0 (v1);
#line 379 "/home/luca/repo/wip/zcd/serializer.vala"
				_g_variant_unref0 (v0);
#line 379 "/home/luca/repo/wip/zcd/serializer.vala"
				_g_free0 (vt);
#line 379 "/home/luca/repo/wip/zcd/serializer.vala"
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 379 "/home/luca/repo/wip/zcd/serializer.vala"
				g_clear_error (&_inner_error_);
#line 379 "/home/luca/repo/wip/zcd/serializer.vala"
				return;
#line 3456 "serializer.c"
			}
		}
#line 380 "/home/luca/repo/wip/zcd/serializer.vala"
		_tmp27_ = type;
#line 380 "/home/luca/repo/wip/zcd/serializer.vala"
		_tmp28_ = g_type_is_a (_tmp27_, ZCD_TYPE_ISERIALIZABLE);
#line 380 "/home/luca/repo/wip/zcd/serializer.vala"
		if (!_tmp28_) {
#line 3465 "serializer.c"
			const gchar* _tmp29_;
			const gchar* _tmp30_ = NULL;
			gchar* _tmp31_ = NULL;
			gchar* _tmp32_;
			GError* _tmp33_;
			GError* _tmp34_;
#line 380 "/home/luca/repo/wip/zcd/serializer.vala"
			_tmp29_ = typename;
#line 380 "/home/luca/repo/wip/zcd/serializer.vala"
			_tmp30_ = string_to_string (_tmp29_);
#line 380 "/home/luca/repo/wip/zcd/serializer.vala"
			_tmp31_ = g_strconcat ("Typename '", _tmp30_, "' is not serializable.", NULL);
#line 380 "/home/luca/repo/wip/zcd/serializer.vala"
			_tmp32_ = _tmp31_;
#line 380 "/home/luca/repo/wip/zcd/serializer.vala"
			_tmp33_ = g_error_new_literal (ZCD_SERIALIZER_ERROR, ZCD_SERIALIZER_ERROR_GENERIC, _tmp32_);
#line 380 "/home/luca/repo/wip/zcd/serializer.vala"
			_tmp34_ = _tmp33_;
#line 380 "/home/luca/repo/wip/zcd/serializer.vala"
			_g_free0 (_tmp32_);
#line 380 "/home/luca/repo/wip/zcd/serializer.vala"
			_inner_error_ = _tmp34_;
#line 380 "/home/luca/repo/wip/zcd/serializer.vala"
			if (_inner_error_->domain == ZCD_SERIALIZER_ERROR) {
#line 380 "/home/luca/repo/wip/zcd/serializer.vala"
				g_propagate_error (error, _inner_error_);
#line 380 "/home/luca/repo/wip/zcd/serializer.vala"
				_g_free0 (typename);
#line 380 "/home/luca/repo/wip/zcd/serializer.vala"
				toar = (_vala_array_free (toar, toar_length1, (GDestroyNotify) g_variant_unref), NULL);
#line 380 "/home/luca/repo/wip/zcd/serializer.vala"
				_g_variant_unref0 (v1);
#line 380 "/home/luca/repo/wip/zcd/serializer.vala"
				_g_variant_unref0 (v0);
#line 380 "/home/luca/repo/wip/zcd/serializer.vala"
				_g_free0 (vt);
#line 380 "/home/luca/repo/wip/zcd/serializer.vala"
				return;
#line 3504 "serializer.c"
			} else {
#line 380 "/home/luca/repo/wip/zcd/serializer.vala"
				_g_free0 (typename);
#line 380 "/home/luca/repo/wip/zcd/serializer.vala"
				toar = (_vala_array_free (toar, toar_length1, (GDestroyNotify) g_variant_unref), NULL);
#line 380 "/home/luca/repo/wip/zcd/serializer.vala"
				_g_variant_unref0 (v1);
#line 380 "/home/luca/repo/wip/zcd/serializer.vala"
				_g_variant_unref0 (v0);
#line 380 "/home/luca/repo/wip/zcd/serializer.vala"
				_g_free0 (vt);
#line 380 "/home/luca/repo/wip/zcd/serializer.vala"
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 380 "/home/luca/repo/wip/zcd/serializer.vala"
				g_clear_error (&_inner_error_);
#line 380 "/home/luca/repo/wip/zcd/serializer.vala"
				return;
#line 3522 "serializer.c"
			}
		}
		{
			gint i;
#line 381 "/home/luca/repo/wip/zcd/serializer.vala"
			i = 0;
#line 3529 "serializer.c"
			{
				gboolean _tmp35_;
#line 381 "/home/luca/repo/wip/zcd/serializer.vala"
				_tmp35_ = TRUE;
#line 381 "/home/luca/repo/wip/zcd/serializer.vala"
				while (TRUE) {
#line 3536 "serializer.c"
					gboolean _tmp36_;
					gint _tmp38_;
					GVariant** _tmp39_;
					gint _tmp39__length1;
					GType _tmp40_;
					GObject* _tmp41_ = NULL;
					GObject* _tmp42_;
					zcdISerializable* el;
					zcdISerializable* _tmp43_;
					GVariant** _tmp44_;
					gint _tmp44__length1;
					gint _tmp45_;
					GVariant* _tmp46_;
					GeeList* _tmp47_;
					zcdISerializable* _tmp48_;
#line 381 "/home/luca/repo/wip/zcd/serializer.vala"
					_tmp36_ = _tmp35_;
#line 381 "/home/luca/repo/wip/zcd/serializer.vala"
					if (!_tmp36_) {
#line 3556 "serializer.c"
						gint _tmp37_;
#line 381 "/home/luca/repo/wip/zcd/serializer.vala"
						_tmp37_ = i;
#line 381 "/home/luca/repo/wip/zcd/serializer.vala"
						i = _tmp37_ + 1;
#line 3562 "serializer.c"
					}
#line 381 "/home/luca/repo/wip/zcd/serializer.vala"
					_tmp35_ = FALSE;
#line 381 "/home/luca/repo/wip/zcd/serializer.vala"
					_tmp38_ = i;
#line 381 "/home/luca/repo/wip/zcd/serializer.vala"
					_tmp39_ = toar;
#line 381 "/home/luca/repo/wip/zcd/serializer.vala"
					_tmp39__length1 = toar_length1;
#line 381 "/home/luca/repo/wip/zcd/serializer.vala"
					if (!(_tmp38_ < _tmp39__length1)) {
#line 381 "/home/luca/repo/wip/zcd/serializer.vala"
						break;
#line 3576 "serializer.c"
					}
#line 383 "/home/luca/repo/wip/zcd/serializer.vala"
					_tmp40_ = type;
#line 383 "/home/luca/repo/wip/zcd/serializer.vala"
					_tmp41_ = g_object_new (_tmp40_, NULL);
#line 383 "/home/luca/repo/wip/zcd/serializer.vala"
					_tmp42_ = G_IS_INITIALLY_UNOWNED (_tmp41_) ? g_object_ref_sink (_tmp41_) : _tmp41_;
#line 383 "/home/luca/repo/wip/zcd/serializer.vala"
					el = G_TYPE_CHECK_INSTANCE_CAST (_tmp42_, ZCD_TYPE_ISERIALIZABLE, zcdISerializable);
#line 384 "/home/luca/repo/wip/zcd/serializer.vala"
					_tmp43_ = el;
#line 384 "/home/luca/repo/wip/zcd/serializer.vala"
					_tmp44_ = toar;
#line 384 "/home/luca/repo/wip/zcd/serializer.vala"
					_tmp44__length1 = toar_length1;
#line 384 "/home/luca/repo/wip/zcd/serializer.vala"
					_tmp45_ = i;
#line 384 "/home/luca/repo/wip/zcd/serializer.vala"
					_tmp46_ = _tmp44_[_tmp45_];
#line 384 "/home/luca/repo/wip/zcd/serializer.vala"
					zcd_iserializable_deserialize_from_variant (_tmp43_, _tmp46_, &_inner_error_);
#line 384 "/home/luca/repo/wip/zcd/serializer.vala"
					if (_inner_error_ != NULL) {
#line 384 "/home/luca/repo/wip/zcd/serializer.vala"
						if (_inner_error_->domain == ZCD_SERIALIZER_ERROR) {
#line 384 "/home/luca/repo/wip/zcd/serializer.vala"
							g_propagate_error (error, _inner_error_);
#line 384 "/home/luca/repo/wip/zcd/serializer.vala"
							_g_object_unref0 (el);
#line 384 "/home/luca/repo/wip/zcd/serializer.vala"
							_g_free0 (typename);
#line 384 "/home/luca/repo/wip/zcd/serializer.vala"
							toar = (_vala_array_free (toar, toar_length1, (GDestroyNotify) g_variant_unref), NULL);
#line 384 "/home/luca/repo/wip/zcd/serializer.vala"
							_g_variant_unref0 (v1);
#line 384 "/home/luca/repo/wip/zcd/serializer.vala"
							_g_variant_unref0 (v0);
#line 384 "/home/luca/repo/wip/zcd/serializer.vala"
							_g_free0 (vt);
#line 384 "/home/luca/repo/wip/zcd/serializer.vala"
							return;
#line 3618 "serializer.c"
						} else {
#line 384 "/home/luca/repo/wip/zcd/serializer.vala"
							_g_object_unref0 (el);
#line 384 "/home/luca/repo/wip/zcd/serializer.vala"
							_g_free0 (typename);
#line 384 "/home/luca/repo/wip/zcd/serializer.vala"
							toar = (_vala_array_free (toar, toar_length1, (GDestroyNotify) g_variant_unref), NULL);
#line 384 "/home/luca/repo/wip/zcd/serializer.vala"
							_g_variant_unref0 (v1);
#line 384 "/home/luca/repo/wip/zcd/serializer.vala"
							_g_variant_unref0 (v0);
#line 384 "/home/luca/repo/wip/zcd/serializer.vala"
							_g_free0 (vt);
#line 384 "/home/luca/repo/wip/zcd/serializer.vala"
							g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 384 "/home/luca/repo/wip/zcd/serializer.vala"
							g_clear_error (&_inner_error_);
#line 384 "/home/luca/repo/wip/zcd/serializer.vala"
							return;
#line 3638 "serializer.c"
						}
					}
#line 385 "/home/luca/repo/wip/zcd/serializer.vala"
					_tmp47_ = self->backed;
#line 385 "/home/luca/repo/wip/zcd/serializer.vala"
					_tmp48_ = el;
#line 385 "/home/luca/repo/wip/zcd/serializer.vala"
					gee_collection_add ((GeeCollection*) _tmp47_, _tmp48_);
#line 383 "/home/luca/repo/wip/zcd/serializer.vala"
					_g_object_unref0 (el);
#line 3649 "serializer.c"
				}
			}
		}
#line 381 "/home/luca/repo/wip/zcd/serializer.vala"
		_g_free0 (typename);
#line 381 "/home/luca/repo/wip/zcd/serializer.vala"
		toar = (_vala_array_free (toar, toar_length1, (GDestroyNotify) g_variant_unref), NULL);
#line 381 "/home/luca/repo/wip/zcd/serializer.vala"
		_g_variant_unref0 (v1);
#line 381 "/home/luca/repo/wip/zcd/serializer.vala"
		_g_variant_unref0 (v0);
#line 3661 "serializer.c"
	}
#line 370 "/home/luca/repo/wip/zcd/serializer.vala"
	_g_free0 (vt);
#line 3665 "serializer.c"
}


gint zcd_list_iserializable_get_size (zcdListISerializable* self) {
	gint result;
	GeeList* _tmp0_;
	gint _tmp1_;
	gint _tmp2_;
#line 337 "/home/luca/repo/wip/zcd/serializer.vala"
	g_return_val_if_fail (self != NULL, 0);
#line 338 "/home/luca/repo/wip/zcd/serializer.vala"
	_tmp0_ = self->backed;
#line 338 "/home/luca/repo/wip/zcd/serializer.vala"
	_tmp1_ = gee_collection_get_size ((GeeCollection*) _tmp0_);
#line 338 "/home/luca/repo/wip/zcd/serializer.vala"
	_tmp2_ = _tmp1_;
#line 338 "/home/luca/repo/wip/zcd/serializer.vala"
	result = _tmp2_;
#line 338 "/home/luca/repo/wip/zcd/serializer.vala"
	return result;
#line 3686 "serializer.c"
}


static void zcd_list_iserializable_class_init (zcdListISerializableClass * klass) {
#line 314 "/home/luca/repo/wip/zcd/serializer.vala"
	zcd_list_iserializable_parent_class = g_type_class_peek_parent (klass);
#line 314 "/home/luca/repo/wip/zcd/serializer.vala"
	G_OBJECT_CLASS (klass)->get_property = _vala_zcd_list_iserializable_get_property;
#line 314 "/home/luca/repo/wip/zcd/serializer.vala"
	G_OBJECT_CLASS (klass)->finalize = zcd_list_iserializable_finalize;
#line 314 "/home/luca/repo/wip/zcd/serializer.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), ZCD_LIST_ISERIALIZABLE_SIZE, g_param_spec_int ("size", "size", "size", G_MININT, G_MAXINT, 0, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
#line 3699 "serializer.c"
}


static void zcd_list_iserializable_zcd_iserializable_interface_init (zcdISerializableIface * iface) {
#line 366 "/home/luca/repo/wip/zcd/serializer.vala"
	zcd_list_iserializable_zcd_iserializable_parent_iface = g_type_interface_peek_parent (iface);
#line 366 "/home/luca/repo/wip/zcd/serializer.vala"
	iface->serialize_to_variant = (GVariant* (*)(zcdISerializable*)) zcd_list_iserializable_real_serialize_to_variant;
#line 366 "/home/luca/repo/wip/zcd/serializer.vala"
	iface->deserialize_from_variant = (void (*)(zcdISerializable*, GVariant*, GError**)) zcd_list_iserializable_real_deserialize_from_variant;
#line 3710 "serializer.c"
}


static void zcd_list_iserializable_instance_init (zcdListISerializable * self) {
}


static void zcd_list_iserializable_finalize (GObject* obj) {
	zcdListISerializable * self;
#line 314 "/home/luca/repo/wip/zcd/serializer.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, ZCD_TYPE_LIST_ISERIALIZABLE, zcdListISerializable);
#line 316 "/home/luca/repo/wip/zcd/serializer.vala"
	_g_object_unref0 (self->backed);
#line 366 "/home/luca/repo/wip/zcd/serializer.vala"
	G_OBJECT_CLASS (zcd_list_iserializable_parent_class)->finalize (obj);
#line 3726 "serializer.c"
}


/** Serializable class for List<ISerializable>
      *
      * This class is used for passing or returning a list of objects, all of the
      *  same type and that implement ISerializable.
      * With this class, the objects contained in the list are serialized when we
      *  call "serialize()" on the list, and are deserialized when we call deserialize()
      *  for the list.
      * A different approach has to be used if we need to
      *   § serialize a list of serializable objects, obtaining a
      *     list of uchar[]
      *   § put the list of uchar[] in a serializable container
      *   § serialize the container
      *   § deserialize the container WITHOUT deserializing the objects
      * This situation is needed for remotable methods in optional peer to peer
      *  services; because we need to pass the arguments to hops that might not
      *  implement the service and might not have knowledge of the classes involved.
      * For this see an example of SerializedList in the serializer_tester_1 module.
      * Such a class is RemoteCall, in module messages.
      */
GType zcd_list_iserializable_get_type (void) {
	static volatile gsize zcd_list_iserializable_type_id__volatile = 0;
	if (g_once_init_enter (&zcd_list_iserializable_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (zcdListISerializableClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) zcd_list_iserializable_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (zcdListISerializable), 0, (GInstanceInitFunc) zcd_list_iserializable_instance_init, NULL };
		static const GInterfaceInfo zcd_iserializable_info = { (GInterfaceInitFunc) zcd_list_iserializable_zcd_iserializable_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
		GType zcd_list_iserializable_type_id;
		zcd_list_iserializable_type_id = g_type_register_static (G_TYPE_OBJECT, "zcdListISerializable", &g_define_type_info, 0);
		g_type_add_interface_static (zcd_list_iserializable_type_id, ZCD_TYPE_ISERIALIZABLE, &zcd_iserializable_info);
		g_once_init_leave (&zcd_list_iserializable_type_id__volatile, zcd_list_iserializable_type_id);
	}
	return zcd_list_iserializable_type_id__volatile;
}


static void _vala_zcd_list_iserializable_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	zcdListISerializable * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, ZCD_TYPE_LIST_ISERIALIZABLE, zcdListISerializable);
#line 314 "/home/luca/repo/wip/zcd/serializer.vala"
	switch (property_id) {
#line 314 "/home/luca/repo/wip/zcd/serializer.vala"
		case ZCD_LIST_ISERIALIZABLE_SIZE:
#line 314 "/home/luca/repo/wip/zcd/serializer.vala"
		g_value_set_int (value, zcd_list_iserializable_get_size (self));
#line 314 "/home/luca/repo/wip/zcd/serializer.vala"
		break;
#line 3774 "serializer.c"
		default:
#line 314 "/home/luca/repo/wip/zcd/serializer.vala"
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
#line 314 "/home/luca/repo/wip/zcd/serializer.vala"
		break;
#line 3780 "serializer.c"
	}
}


void zcd_serializer_init (void) {
	guint16 _tmp0_ = 0U;
#line 396 "/home/luca/repo/wip/zcd/serializer.vala"
	_tmp0_ = ntohs ((guint16) 1);
#line 396 "/home/luca/repo/wip/zcd/serializer.vala"
	zcd_endianness_network = ((gint) _tmp0_) == 1;
#line 398 "/home/luca/repo/wip/zcd/serializer.vala"
	g_type_class_peek (ZCD_TYPE_REMOTE_CALL);
#line 399 "/home/luca/repo/wip/zcd/serializer.vala"
	g_type_class_peek (ZCD_TYPE_REMOTABLE_EXCEPTION);
#line 400 "/home/luca/repo/wip/zcd/serializer.vala"
	g_type_class_peek (ZCD_TYPE_TCP_REQUEST);
#line 401 "/home/luca/repo/wip/zcd/serializer.vala"
	g_type_class_peek (ZCD_TYPE_UDP_MESSAGE);
#line 402 "/home/luca/repo/wip/zcd/serializer.vala"
	g_type_class_peek (ZCD_TYPE_UDP_PAYLOAD);
#line 403 "/home/luca/repo/wip/zcd/serializer.vala"
	g_type_class_peek (ZCD_TYPE_SERIALIZABLE_NONE);
#line 404 "/home/luca/repo/wip/zcd/serializer.vala"
	g_type_class_peek (ZCD_TYPE_SERIALIZABLE_INT);
#line 405 "/home/luca/repo/wip/zcd/serializer.vala"
	g_type_class_peek (ZCD_TYPE_SERIALIZABLE_BOOL);
#line 406 "/home/luca/repo/wip/zcd/serializer.vala"
	g_type_class_peek (ZCD_TYPE_SERIALIZABLE_STRING);
#line 407 "/home/luca/repo/wip/zcd/serializer.vala"
	g_type_class_peek (ZCD_TYPE_SERIALIZABLE_BUFFER);
#line 408 "/home/luca/repo/wip/zcd/serializer.vala"
	g_type_class_peek (ZCD_TYPE_LIST_STRING);
#line 409 "/home/luca/repo/wip/zcd/serializer.vala"
	g_type_class_peek (ZCD_TYPE_LIST_ISERIALIZABLE);
#line 3815 "serializer.c"
}


static GVariant* _variant_new3 (gint value) {
#line 414 "/home/luca/repo/wip/zcd/serializer.vala"
	return g_variant_ref_sink (g_variant_new_int32 (value));
#line 3822 "serializer.c"
}


GVariant* zcd_serializer_int_to_variant (gint i) {
	GVariant* result = NULL;
	gint _tmp0_;
	GVariant* _tmp1_;
#line 414 "/home/luca/repo/wip/zcd/serializer.vala"
	_tmp0_ = i;
#line 414 "/home/luca/repo/wip/zcd/serializer.vala"
	_tmp1_ = _variant_new3 (_tmp0_);
#line 414 "/home/luca/repo/wip/zcd/serializer.vala"
	result = _tmp1_;
#line 414 "/home/luca/repo/wip/zcd/serializer.vala"
	return result;
#line 3838 "serializer.c"
}


static gint _variant_get4 (GVariant* value) {
#line 419 "/home/luca/repo/wip/zcd/serializer.vala"
	return g_variant_get_int32 (value);
#line 3845 "serializer.c"
}


gint zcd_serializer_variant_to_int (GVariant* v) {
	gint result = 0;
	GVariant* _tmp0_;
	gint _tmp1_;
#line 417 "/home/luca/repo/wip/zcd/serializer.vala"
	g_return_val_if_fail (v != NULL, 0);
#line 419 "/home/luca/repo/wip/zcd/serializer.vala"
	_tmp0_ = v;
#line 419 "/home/luca/repo/wip/zcd/serializer.vala"
	_tmp1_ = _variant_get4 (_tmp0_);
#line 419 "/home/luca/repo/wip/zcd/serializer.vala"
	result = _tmp1_;
#line 419 "/home/luca/repo/wip/zcd/serializer.vala"
	return result;
#line 3863 "serializer.c"
}


static GVariant* _variant_new5 (gint64 value) {
#line 424 "/home/luca/repo/wip/zcd/serializer.vala"
	return g_variant_ref_sink (g_variant_new_int64 (value));
#line 3870 "serializer.c"
}


GVariant* zcd_serializer_int64_to_variant (gint64 i) {
	GVariant* result = NULL;
	gint64 _tmp0_;
	GVariant* _tmp1_;
#line 424 "/home/luca/repo/wip/zcd/serializer.vala"
	_tmp0_ = i;
#line 424 "/home/luca/repo/wip/zcd/serializer.vala"
	_tmp1_ = _variant_new5 (_tmp0_);
#line 424 "/home/luca/repo/wip/zcd/serializer.vala"
	result = _tmp1_;
#line 424 "/home/luca/repo/wip/zcd/serializer.vala"
	return result;
#line 3886 "serializer.c"
}


static gint64 _variant_get6 (GVariant* value) {
#line 429 "/home/luca/repo/wip/zcd/serializer.vala"
	return g_variant_get_int64 (value);
#line 3893 "serializer.c"
}


gint64 zcd_serializer_variant_to_int64 (GVariant* v) {
	gint64 result = 0LL;
	GVariant* _tmp0_;
	gint64 _tmp1_;
#line 427 "/home/luca/repo/wip/zcd/serializer.vala"
	g_return_val_if_fail (v != NULL, 0LL);
#line 429 "/home/luca/repo/wip/zcd/serializer.vala"
	_tmp0_ = v;
#line 429 "/home/luca/repo/wip/zcd/serializer.vala"
	_tmp1_ = _variant_get6 (_tmp0_);
#line 429 "/home/luca/repo/wip/zcd/serializer.vala"
	result = _tmp1_;
#line 429 "/home/luca/repo/wip/zcd/serializer.vala"
	return result;
#line 3911 "serializer.c"
}


static GVariant* _variant_new7 (guchar value) {
#line 434 "/home/luca/repo/wip/zcd/serializer.vala"
	return g_variant_ref_sink (g_variant_new_byte (value));
#line 3918 "serializer.c"
}


GVariant* zcd_serializer_uchar_to_variant (guchar y) {
	GVariant* result = NULL;
	guchar _tmp0_;
	GVariant* _tmp1_;
#line 434 "/home/luca/repo/wip/zcd/serializer.vala"
	_tmp0_ = y;
#line 434 "/home/luca/repo/wip/zcd/serializer.vala"
	_tmp1_ = _variant_new7 (_tmp0_);
#line 434 "/home/luca/repo/wip/zcd/serializer.vala"
	result = _tmp1_;
#line 434 "/home/luca/repo/wip/zcd/serializer.vala"
	return result;
#line 3934 "serializer.c"
}


static guchar _variant_get8 (GVariant* value) {
#line 439 "/home/luca/repo/wip/zcd/serializer.vala"
	return g_variant_get_byte (value);
#line 3941 "serializer.c"
}


guchar zcd_serializer_variant_to_uchar (GVariant* v) {
	guchar result = '\0';
	GVariant* _tmp0_;
	guchar _tmp1_;
#line 437 "/home/luca/repo/wip/zcd/serializer.vala"
	g_return_val_if_fail (v != NULL, '\0');
#line 439 "/home/luca/repo/wip/zcd/serializer.vala"
	_tmp0_ = v;
#line 439 "/home/luca/repo/wip/zcd/serializer.vala"
	_tmp1_ = _variant_get8 (_tmp0_);
#line 439 "/home/luca/repo/wip/zcd/serializer.vala"
	result = _tmp1_;
#line 439 "/home/luca/repo/wip/zcd/serializer.vala"
	return result;
#line 3959 "serializer.c"
}


static GVariant* _variant_new9 (const gchar* value) {
#line 444 "/home/luca/repo/wip/zcd/serializer.vala"
	return g_variant_ref_sink (g_variant_new_string (value));
#line 3966 "serializer.c"
}


GVariant* zcd_serializer_string_to_variant (const gchar* s) {
	GVariant* result = NULL;
	const gchar* _tmp0_;
	GVariant* _tmp1_;
#line 442 "/home/luca/repo/wip/zcd/serializer.vala"
	g_return_val_if_fail (s != NULL, NULL);
#line 444 "/home/luca/repo/wip/zcd/serializer.vala"
	_tmp0_ = s;
#line 444 "/home/luca/repo/wip/zcd/serializer.vala"
	_tmp1_ = _variant_new9 (_tmp0_);
#line 444 "/home/luca/repo/wip/zcd/serializer.vala"
	result = _tmp1_;
#line 444 "/home/luca/repo/wip/zcd/serializer.vala"
	return result;
#line 3984 "serializer.c"
}


gchar* zcd_serializer_variant_to_string (GVariant* v) {
	gchar* result = NULL;
	gchar* t2 = NULL;
	GVariant* _tmp0_;
	const gchar* _tmp1_ = NULL;
	GVariant* _tmp2_;
#line 447 "/home/luca/repo/wip/zcd/serializer.vala"
	g_return_val_if_fail (v != NULL, NULL);
#line 452 "/home/luca/repo/wip/zcd/serializer.vala"
	_tmp0_ = v;
#line 452 "/home/luca/repo/wip/zcd/serializer.vala"
	_tmp1_ = g_variant_get_type_string (_tmp0_);
#line 452 "/home/luca/repo/wip/zcd/serializer.vala"
	_vala_assert (g_strcmp0 (_tmp1_, "s") == 0, "v.get_type_string() == \"s\"");
#line 453 "/home/luca/repo/wip/zcd/serializer.vala"
	_tmp2_ = v;
#line 453 "/home/luca/repo/wip/zcd/serializer.vala"
	g_variant_get (_tmp2_, "s", &t2, NULL);
#line 454 "/home/luca/repo/wip/zcd/serializer.vala"
	result = t2;
#line 454 "/home/luca/repo/wip/zcd/serializer.vala"
	return result;
#line 4010 "serializer.c"
}


static GVariant* _variant_new10 (gint* value, gint value_length1) {
	gint* _tmp1_;
	GVariantBuilder _tmp2_;
	int _tmp3_;
#line 459 "/home/luca/repo/wip/zcd/serializer.vala"
	_tmp1_ = value;
#line 459 "/home/luca/repo/wip/zcd/serializer.vala"
	g_variant_builder_init (&_tmp2_, G_VARIANT_TYPE ("ai"));
#line 459 "/home/luca/repo/wip/zcd/serializer.vala"
	for (_tmp3_ = 0; _tmp3_ < value_length1; _tmp3_++) {
#line 459 "/home/luca/repo/wip/zcd/serializer.vala"
		g_variant_builder_add_value (&_tmp2_, g_variant_new_int32 (*_tmp1_));
#line 459 "/home/luca/repo/wip/zcd/serializer.vala"
		_tmp1_++;
#line 4028 "serializer.c"
	}
#line 459 "/home/luca/repo/wip/zcd/serializer.vala"
	return g_variant_ref_sink (g_variant_builder_end (&_tmp2_));
#line 4032 "serializer.c"
}


GVariant* zcd_serializer_int_array_to_variant (gint* ai, int ai_length1) {
	GVariant* result = NULL;
	gint* _tmp0_;
	gint _tmp0__length1;
	GVariant* _tmp4_;
#line 459 "/home/luca/repo/wip/zcd/serializer.vala"
	_tmp0_ = ai;
#line 459 "/home/luca/repo/wip/zcd/serializer.vala"
	_tmp0__length1 = ai_length1;
#line 459 "/home/luca/repo/wip/zcd/serializer.vala"
	_tmp4_ = _variant_new10 (_tmp0_, _tmp0__length1);
#line 459 "/home/luca/repo/wip/zcd/serializer.vala"
	result = _tmp4_;
#line 459 "/home/luca/repo/wip/zcd/serializer.vala"
	return result;
#line 4051 "serializer.c"
}


static gint _variant_get11 (GVariant* value) {
#line 473 "/home/luca/repo/wip/zcd/serializer.vala"
	return g_variant_get_int32 (value);
#line 4058 "serializer.c"
}


static void _vala_array_add2 (gint** array, int* length, int* size, gint value) {
#line 474 "/home/luca/repo/wip/zcd/serializer.vala"
	if ((*length) == (*size)) {
#line 474 "/home/luca/repo/wip/zcd/serializer.vala"
		*size = (*size) ? (2 * (*size)) : 4;
#line 474 "/home/luca/repo/wip/zcd/serializer.vala"
		*array = g_renew (gint, *array, *size);
#line 4069 "serializer.c"
	}
#line 474 "/home/luca/repo/wip/zcd/serializer.vala"
	(*array)[(*length)++] = value;
#line 4073 "serializer.c"
}


gint* zcd_serializer_variant_to_int_array (GVariant* v, int* result_length1) {
	gint* result = NULL;
	gint* _tmp0_ = NULL;
	gint* ret;
	gint ret_length1;
	gint _ret_size_;
	GVariant* _tmp1_;
	GVariantIter* _tmp2_;
	GVariantIter* iter;
	GVariantIter* _tmp3_;
	GVariant* _tmp4_ = NULL;
	GVariant* v0;
	gint* _tmp12_;
	gint _tmp12__length1;
#line 462 "/home/luca/repo/wip/zcd/serializer.vala"
	g_return_val_if_fail (v != NULL, NULL);
#line 468 "/home/luca/repo/wip/zcd/serializer.vala"
	_tmp0_ = g_new0 (gint, 0);
#line 468 "/home/luca/repo/wip/zcd/serializer.vala"
	ret = _tmp0_;
#line 468 "/home/luca/repo/wip/zcd/serializer.vala"
	ret_length1 = 0;
#line 468 "/home/luca/repo/wip/zcd/serializer.vala"
	_ret_size_ = ret_length1;
#line 469 "/home/luca/repo/wip/zcd/serializer.vala"
	_tmp1_ = v;
#line 469 "/home/luca/repo/wip/zcd/serializer.vala"
	_tmp2_ = g_variant_iter_new (_tmp1_);
#line 469 "/home/luca/repo/wip/zcd/serializer.vala"
	iter = _tmp2_;
#line 470 "/home/luca/repo/wip/zcd/serializer.vala"
	_tmp3_ = iter;
#line 470 "/home/luca/repo/wip/zcd/serializer.vala"
	_tmp4_ = g_variant_iter_next_value (_tmp3_);
#line 470 "/home/luca/repo/wip/zcd/serializer.vala"
	v0 = _tmp4_;
#line 471 "/home/luca/repo/wip/zcd/serializer.vala"
	while (TRUE) {
#line 4115 "serializer.c"
		GVariant* _tmp5_;
		GVariant* _tmp6_;
		gint _tmp7_;
		gint i;
		gint* _tmp8_;
		gint _tmp8__length1;
		gint _tmp9_;
		GVariantIter* _tmp10_;
		GVariant* _tmp11_ = NULL;
#line 471 "/home/luca/repo/wip/zcd/serializer.vala"
		_tmp5_ = v0;
#line 471 "/home/luca/repo/wip/zcd/serializer.vala"
		if (!(_tmp5_ != NULL)) {
#line 471 "/home/luca/repo/wip/zcd/serializer.vala"
			break;
#line 4131 "serializer.c"
		}
#line 473 "/home/luca/repo/wip/zcd/serializer.vala"
		_tmp6_ = v0;
#line 473 "/home/luca/repo/wip/zcd/serializer.vala"
		_tmp7_ = _variant_get11 (_tmp6_);
#line 473 "/home/luca/repo/wip/zcd/serializer.vala"
		i = _tmp7_;
#line 474 "/home/luca/repo/wip/zcd/serializer.vala"
		_tmp8_ = ret;
#line 474 "/home/luca/repo/wip/zcd/serializer.vala"
		_tmp8__length1 = ret_length1;
#line 474 "/home/luca/repo/wip/zcd/serializer.vala"
		_tmp9_ = i;
#line 474 "/home/luca/repo/wip/zcd/serializer.vala"
		_vala_array_add2 (&ret, &ret_length1, &_ret_size_, _tmp9_);
#line 475 "/home/luca/repo/wip/zcd/serializer.vala"
		_tmp10_ = iter;
#line 475 "/home/luca/repo/wip/zcd/serializer.vala"
		_tmp11_ = g_variant_iter_next_value (_tmp10_);
#line 475 "/home/luca/repo/wip/zcd/serializer.vala"
		_g_variant_unref0 (v0);
#line 475 "/home/luca/repo/wip/zcd/serializer.vala"
		v0 = _tmp11_;
#line 4155 "serializer.c"
	}
#line 477 "/home/luca/repo/wip/zcd/serializer.vala"
	_tmp12_ = ret;
#line 477 "/home/luca/repo/wip/zcd/serializer.vala"
	_tmp12__length1 = ret_length1;
#line 477 "/home/luca/repo/wip/zcd/serializer.vala"
	if (result_length1) {
#line 477 "/home/luca/repo/wip/zcd/serializer.vala"
		*result_length1 = _tmp12__length1;
#line 4165 "serializer.c"
	}
#line 477 "/home/luca/repo/wip/zcd/serializer.vala"
	result = _tmp12_;
#line 477 "/home/luca/repo/wip/zcd/serializer.vala"
	_g_variant_unref0 (v0);
#line 477 "/home/luca/repo/wip/zcd/serializer.vala"
	_g_variant_iter_free0 (iter);
#line 477 "/home/luca/repo/wip/zcd/serializer.vala"
	return result;
#line 4175 "serializer.c"
}


static GVariant* _variant_new12 (guchar* value, gint value_length1) {
	guchar* _tmp1_;
	GVariantBuilder _tmp2_;
	int _tmp3_;
#line 484 "/home/luca/repo/wip/zcd/serializer.vala"
	_tmp1_ = value;
#line 484 "/home/luca/repo/wip/zcd/serializer.vala"
	g_variant_builder_init (&_tmp2_, G_VARIANT_TYPE ("ay"));
#line 484 "/home/luca/repo/wip/zcd/serializer.vala"
	for (_tmp3_ = 0; _tmp3_ < value_length1; _tmp3_++) {
#line 484 "/home/luca/repo/wip/zcd/serializer.vala"
		g_variant_builder_add_value (&_tmp2_, g_variant_new_byte (*_tmp1_));
#line 484 "/home/luca/repo/wip/zcd/serializer.vala"
		_tmp1_++;
#line 4193 "serializer.c"
	}
#line 484 "/home/luca/repo/wip/zcd/serializer.vala"
	return g_variant_ref_sink (g_variant_builder_end (&_tmp2_));
#line 4197 "serializer.c"
}


GVariant* zcd_serializer_uchar_array_to_variant (guchar* auc, int auc_length1) {
	GVariant* result = NULL;
	guchar* _tmp0_;
	gint _tmp0__length1;
	GVariant* _tmp4_;
#line 484 "/home/luca/repo/wip/zcd/serializer.vala"
	_tmp0_ = auc;
#line 484 "/home/luca/repo/wip/zcd/serializer.vala"
	_tmp0__length1 = auc_length1;
#line 484 "/home/luca/repo/wip/zcd/serializer.vala"
	_tmp4_ = _variant_new12 (_tmp0_, _tmp0__length1);
#line 484 "/home/luca/repo/wip/zcd/serializer.vala"
	result = _tmp4_;
#line 484 "/home/luca/repo/wip/zcd/serializer.vala"
	return result;
#line 4216 "serializer.c"
}


static guchar _variant_get13 (GVariant* value) {
#line 500 "/home/luca/repo/wip/zcd/serializer.vala"
	return g_variant_get_byte (value);
#line 4223 "serializer.c"
}


static void _vala_array_add3 (guchar** array, int* length, int* size, guchar value) {
#line 501 "/home/luca/repo/wip/zcd/serializer.vala"
	if ((*length) == (*size)) {
#line 501 "/home/luca/repo/wip/zcd/serializer.vala"
		*size = (*size) ? (2 * (*size)) : 4;
#line 501 "/home/luca/repo/wip/zcd/serializer.vala"
		*array = g_renew (guchar, *array, *size);
#line 4234 "serializer.c"
	}
#line 501 "/home/luca/repo/wip/zcd/serializer.vala"
	(*array)[(*length)++] = value;
#line 4238 "serializer.c"
}


guchar* zcd_serializer_variant_to_uchar_array (GVariant* v, int* result_length1) {
	guchar* result = NULL;
	guchar* _tmp0_ = NULL;
	guchar* ret;
	gint ret_length1;
	gint _ret_size_;
	GVariant* _tmp1_;
	GVariantIter* _tmp2_;
	GVariantIter* iter;
	GVariantIter* _tmp3_;
	GVariant* _tmp4_ = NULL;
	GVariant* v0;
	guchar* _tmp12_;
	gint _tmp12__length1;
#line 487 "/home/luca/repo/wip/zcd/serializer.vala"
	g_return_val_if_fail (v != NULL, NULL);
#line 495 "/home/luca/repo/wip/zcd/serializer.vala"
	_tmp0_ = g_new0 (guchar, 0);
#line 495 "/home/luca/repo/wip/zcd/serializer.vala"
	ret = _tmp0_;
#line 495 "/home/luca/repo/wip/zcd/serializer.vala"
	ret_length1 = 0;
#line 495 "/home/luca/repo/wip/zcd/serializer.vala"
	_ret_size_ = ret_length1;
#line 496 "/home/luca/repo/wip/zcd/serializer.vala"
	_tmp1_ = v;
#line 496 "/home/luca/repo/wip/zcd/serializer.vala"
	_tmp2_ = g_variant_iter_new (_tmp1_);
#line 496 "/home/luca/repo/wip/zcd/serializer.vala"
	iter = _tmp2_;
#line 497 "/home/luca/repo/wip/zcd/serializer.vala"
	_tmp3_ = iter;
#line 497 "/home/luca/repo/wip/zcd/serializer.vala"
	_tmp4_ = g_variant_iter_next_value (_tmp3_);
#line 497 "/home/luca/repo/wip/zcd/serializer.vala"
	v0 = _tmp4_;
#line 498 "/home/luca/repo/wip/zcd/serializer.vala"
	while (TRUE) {
#line 4280 "serializer.c"
		GVariant* _tmp5_;
		GVariant* _tmp6_;
		guchar _tmp7_;
		guchar i;
		guchar* _tmp8_;
		gint _tmp8__length1;
		guchar _tmp9_;
		GVariantIter* _tmp10_;
		GVariant* _tmp11_ = NULL;
#line 498 "/home/luca/repo/wip/zcd/serializer.vala"
		_tmp5_ = v0;
#line 498 "/home/luca/repo/wip/zcd/serializer.vala"
		if (!(_tmp5_ != NULL)) {
#line 498 "/home/luca/repo/wip/zcd/serializer.vala"
			break;
#line 4296 "serializer.c"
		}
#line 500 "/home/luca/repo/wip/zcd/serializer.vala"
		_tmp6_ = v0;
#line 500 "/home/luca/repo/wip/zcd/serializer.vala"
		_tmp7_ = _variant_get13 (_tmp6_);
#line 500 "/home/luca/repo/wip/zcd/serializer.vala"
		i = _tmp7_;
#line 501 "/home/luca/repo/wip/zcd/serializer.vala"
		_tmp8_ = ret;
#line 501 "/home/luca/repo/wip/zcd/serializer.vala"
		_tmp8__length1 = ret_length1;
#line 501 "/home/luca/repo/wip/zcd/serializer.vala"
		_tmp9_ = i;
#line 501 "/home/luca/repo/wip/zcd/serializer.vala"
		_vala_array_add3 (&ret, &ret_length1, &_ret_size_, _tmp9_);
#line 502 "/home/luca/repo/wip/zcd/serializer.vala"
		_tmp10_ = iter;
#line 502 "/home/luca/repo/wip/zcd/serializer.vala"
		_tmp11_ = g_variant_iter_next_value (_tmp10_);
#line 502 "/home/luca/repo/wip/zcd/serializer.vala"
		_g_variant_unref0 (v0);
#line 502 "/home/luca/repo/wip/zcd/serializer.vala"
		v0 = _tmp11_;
#line 4320 "serializer.c"
	}
#line 504 "/home/luca/repo/wip/zcd/serializer.vala"
	_tmp12_ = ret;
#line 504 "/home/luca/repo/wip/zcd/serializer.vala"
	_tmp12__length1 = ret_length1;
#line 504 "/home/luca/repo/wip/zcd/serializer.vala"
	if (result_length1) {
#line 504 "/home/luca/repo/wip/zcd/serializer.vala"
		*result_length1 = _tmp12__length1;
#line 4330 "serializer.c"
	}
#line 504 "/home/luca/repo/wip/zcd/serializer.vala"
	result = _tmp12_;
#line 504 "/home/luca/repo/wip/zcd/serializer.vala"
	_g_variant_unref0 (v0);
#line 504 "/home/luca/repo/wip/zcd/serializer.vala"
	_g_variant_iter_free0 (iter);
#line 504 "/home/luca/repo/wip/zcd/serializer.vala"
	return result;
#line 4340 "serializer.c"
}


static GVariant* _variant_new14 (gchar** value, gint value_length1) {
	gchar** _tmp1_;
	GVariantBuilder _tmp2_;
	int _tmp3_;
#line 509 "/home/luca/repo/wip/zcd/serializer.vala"
	_tmp1_ = value;
#line 509 "/home/luca/repo/wip/zcd/serializer.vala"
	g_variant_builder_init (&_tmp2_, G_VARIANT_TYPE ("as"));
#line 509 "/home/luca/repo/wip/zcd/serializer.vala"
	for (_tmp3_ = 0; _tmp3_ < value_length1; _tmp3_++) {
#line 509 "/home/luca/repo/wip/zcd/serializer.vala"
		g_variant_builder_add_value (&_tmp2_, g_variant_new_string (*_tmp1_));
#line 509 "/home/luca/repo/wip/zcd/serializer.vala"
		_tmp1_++;
#line 4358 "serializer.c"
	}
#line 509 "/home/luca/repo/wip/zcd/serializer.vala"
	return g_variant_ref_sink (g_variant_builder_end (&_tmp2_));
#line 4362 "serializer.c"
}


GVariant* zcd_serializer_string_array_to_variant (gchar** ars, int ars_length1) {
	GVariant* result = NULL;
	gchar** _tmp0_;
	gint _tmp0__length1;
	GVariant* _tmp4_;
#line 509 "/home/luca/repo/wip/zcd/serializer.vala"
	_tmp0_ = ars;
#line 509 "/home/luca/repo/wip/zcd/serializer.vala"
	_tmp0__length1 = ars_length1;
#line 509 "/home/luca/repo/wip/zcd/serializer.vala"
	_tmp4_ = _variant_new14 (_tmp0_, _tmp0__length1);
#line 509 "/home/luca/repo/wip/zcd/serializer.vala"
	result = _tmp4_;
#line 509 "/home/luca/repo/wip/zcd/serializer.vala"
	return result;
#line 4381 "serializer.c"
}


static void _vala_array_add4 (gchar*** array, int* length, int* size, gchar* value) {
#line 528 "/home/luca/repo/wip/zcd/serializer.vala"
	if ((*length) == (*size)) {
#line 528 "/home/luca/repo/wip/zcd/serializer.vala"
		*size = (*size) ? (2 * (*size)) : 4;
#line 528 "/home/luca/repo/wip/zcd/serializer.vala"
		*array = g_renew (gchar*, *array, (*size) + 1);
#line 4392 "serializer.c"
	}
#line 528 "/home/luca/repo/wip/zcd/serializer.vala"
	(*array)[(*length)++] = value;
#line 528 "/home/luca/repo/wip/zcd/serializer.vala"
	(*array)[*length] = NULL;
#line 4398 "serializer.c"
}


gchar** zcd_serializer_variant_to_string_array (GVariant* v, int* result_length1) {
	gchar** result = NULL;
	gchar** _tmp0_ = NULL;
	gchar** ret;
	gint ret_length1;
	gint _ret_size_;
	GVariant* _tmp1_;
	GVariantIter* _tmp2_;
	GVariantIter* iter;
	GVariantIter* _tmp3_;
	GVariant* _tmp4_ = NULL;
	GVariant* v0;
	gchar** _tmp14_;
	gint _tmp14__length1;
#line 512 "/home/luca/repo/wip/zcd/serializer.vala"
	g_return_val_if_fail (v != NULL, NULL);
#line 518 "/home/luca/repo/wip/zcd/serializer.vala"
	_tmp0_ = g_new0 (gchar*, 0 + 1);
#line 518 "/home/luca/repo/wip/zcd/serializer.vala"
	ret = _tmp0_;
#line 518 "/home/luca/repo/wip/zcd/serializer.vala"
	ret_length1 = 0;
#line 518 "/home/luca/repo/wip/zcd/serializer.vala"
	_ret_size_ = ret_length1;
#line 519 "/home/luca/repo/wip/zcd/serializer.vala"
	_tmp1_ = v;
#line 519 "/home/luca/repo/wip/zcd/serializer.vala"
	_tmp2_ = g_variant_iter_new (_tmp1_);
#line 519 "/home/luca/repo/wip/zcd/serializer.vala"
	iter = _tmp2_;
#line 520 "/home/luca/repo/wip/zcd/serializer.vala"
	_tmp3_ = iter;
#line 520 "/home/luca/repo/wip/zcd/serializer.vala"
	_tmp4_ = g_variant_iter_next_value (_tmp3_);
#line 520 "/home/luca/repo/wip/zcd/serializer.vala"
	v0 = _tmp4_;
#line 521 "/home/luca/repo/wip/zcd/serializer.vala"
	while (TRUE) {
#line 4440 "serializer.c"
		GVariant* _tmp5_;
		gchar* s = NULL;
		GVariant* _tmp6_;
		const gchar* _tmp7_ = NULL;
		GVariant* _tmp8_;
		gchar** _tmp9_;
		gint _tmp9__length1;
		const gchar* _tmp10_;
		gchar* _tmp11_;
		GVariantIter* _tmp12_;
		GVariant* _tmp13_ = NULL;
#line 521 "/home/luca/repo/wip/zcd/serializer.vala"
		_tmp5_ = v0;
#line 521 "/home/luca/repo/wip/zcd/serializer.vala"
		if (!(_tmp5_ != NULL)) {
#line 521 "/home/luca/repo/wip/zcd/serializer.vala"
			break;
#line 4458 "serializer.c"
		}
#line 526 "/home/luca/repo/wip/zcd/serializer.vala"
		_tmp6_ = v0;
#line 526 "/home/luca/repo/wip/zcd/serializer.vala"
		_tmp7_ = g_variant_get_type_string (_tmp6_);
#line 526 "/home/luca/repo/wip/zcd/serializer.vala"
		_vala_assert (g_strcmp0 (_tmp7_, "s") == 0, "v0.get_type_string() == \"s\"");
#line 527 "/home/luca/repo/wip/zcd/serializer.vala"
		_tmp8_ = v0;
#line 527 "/home/luca/repo/wip/zcd/serializer.vala"
		g_variant_get (_tmp8_, "s", &s, NULL);
#line 528 "/home/luca/repo/wip/zcd/serializer.vala"
		_tmp9_ = ret;
#line 528 "/home/luca/repo/wip/zcd/serializer.vala"
		_tmp9__length1 = ret_length1;
#line 528 "/home/luca/repo/wip/zcd/serializer.vala"
		_tmp10_ = s;
#line 528 "/home/luca/repo/wip/zcd/serializer.vala"
		_tmp11_ = g_strdup (_tmp10_);
#line 528 "/home/luca/repo/wip/zcd/serializer.vala"
		_vala_array_add4 (&ret, &ret_length1, &_ret_size_, _tmp11_);
#line 529 "/home/luca/repo/wip/zcd/serializer.vala"
		_tmp12_ = iter;
#line 529 "/home/luca/repo/wip/zcd/serializer.vala"
		_tmp13_ = g_variant_iter_next_value (_tmp12_);
#line 529 "/home/luca/repo/wip/zcd/serializer.vala"
		_g_variant_unref0 (v0);
#line 529 "/home/luca/repo/wip/zcd/serializer.vala"
		v0 = _tmp13_;
#line 521 "/home/luca/repo/wip/zcd/serializer.vala"
		_g_free0 (s);
#line 4490 "serializer.c"
	}
#line 531 "/home/luca/repo/wip/zcd/serializer.vala"
	_tmp14_ = ret;
#line 531 "/home/luca/repo/wip/zcd/serializer.vala"
	_tmp14__length1 = ret_length1;
#line 531 "/home/luca/repo/wip/zcd/serializer.vala"
	if (result_length1) {
#line 531 "/home/luca/repo/wip/zcd/serializer.vala"
		*result_length1 = _tmp14__length1;
#line 4500 "serializer.c"
	}
#line 531 "/home/luca/repo/wip/zcd/serializer.vala"
	result = _tmp14_;
#line 531 "/home/luca/repo/wip/zcd/serializer.vala"
	_g_variant_unref0 (v0);
#line 531 "/home/luca/repo/wip/zcd/serializer.vala"
	_g_variant_iter_free0 (iter);
#line 531 "/home/luca/repo/wip/zcd/serializer.vala"
	return result;
#line 4510 "serializer.c"
}


static GVariant* _variant_new15 (GVariant** value, gint value_length1) {
	GVariant** _tmp1_;
	GVariantBuilder _tmp2_;
	int _tmp3_;
#line 536 "/home/luca/repo/wip/zcd/serializer.vala"
	_tmp1_ = value;
#line 536 "/home/luca/repo/wip/zcd/serializer.vala"
	g_variant_builder_init (&_tmp2_, G_VARIANT_TYPE ("av"));
#line 536 "/home/luca/repo/wip/zcd/serializer.vala"
	for (_tmp3_ = 0; _tmp3_ < value_length1; _tmp3_++) {
#line 536 "/home/luca/repo/wip/zcd/serializer.vala"
		g_variant_builder_add_value (&_tmp2_, g_variant_new_variant (*_tmp1_));
#line 536 "/home/luca/repo/wip/zcd/serializer.vala"
		_tmp1_++;
#line 4528 "serializer.c"
	}
#line 536 "/home/luca/repo/wip/zcd/serializer.vala"
	return g_variant_ref_sink (g_variant_builder_end (&_tmp2_));
#line 4532 "serializer.c"
}


GVariant* zcd_serializer_variant_array_to_variant (GVariant** av, int av_length1) {
	GVariant* result = NULL;
	GVariant** _tmp0_;
	gint _tmp0__length1;
	GVariant* _tmp4_;
#line 536 "/home/luca/repo/wip/zcd/serializer.vala"
	_tmp0_ = av;
#line 536 "/home/luca/repo/wip/zcd/serializer.vala"
	_tmp0__length1 = av_length1;
#line 536 "/home/luca/repo/wip/zcd/serializer.vala"
	_tmp4_ = _variant_new15 (_tmp0_, _tmp0__length1);
#line 536 "/home/luca/repo/wip/zcd/serializer.vala"
	result = _tmp4_;
#line 536 "/home/luca/repo/wip/zcd/serializer.vala"
	return result;
#line 4551 "serializer.c"
}


static gpointer _g_variant_ref0 (gpointer self) {
#line 551 "/home/luca/repo/wip/zcd/serializer.vala"
	return self ? g_variant_ref (self) : NULL;
#line 4558 "serializer.c"
}


static void _vala_array_add5 (GVariant*** array, int* length, int* size, GVariant* value) {
#line 551 "/home/luca/repo/wip/zcd/serializer.vala"
	if ((*length) == (*size)) {
#line 551 "/home/luca/repo/wip/zcd/serializer.vala"
		*size = (*size) ? (2 * (*size)) : 4;
#line 551 "/home/luca/repo/wip/zcd/serializer.vala"
		*array = g_renew (GVariant*, *array, (*size) + 1);
#line 4569 "serializer.c"
	}
#line 551 "/home/luca/repo/wip/zcd/serializer.vala"
	(*array)[(*length)++] = value;
#line 551 "/home/luca/repo/wip/zcd/serializer.vala"
	(*array)[*length] = NULL;
#line 4575 "serializer.c"
}


GVariant** zcd_serializer_variant_to_variant_array (GVariant* v, int* result_length1) {
	GVariant** result = NULL;
	GVariant** _tmp0_ = NULL;
	GVariant** ret;
	gint ret_length1;
	gint _ret_size_;
	GVariant* _tmp1_;
	GVariantIter* _tmp2_;
	GVariantIter* iter;
	GVariantIter* _tmp3_;
	GVariant* _tmp4_ = NULL;
	GVariant* v0;
	GVariant** _tmp13_;
	gint _tmp13__length1;
#line 539 "/home/luca/repo/wip/zcd/serializer.vala"
	g_return_val_if_fail (v != NULL, NULL);
#line 545 "/home/luca/repo/wip/zcd/serializer.vala"
	_tmp0_ = g_new0 (GVariant*, 0 + 1);
#line 545 "/home/luca/repo/wip/zcd/serializer.vala"
	ret = _tmp0_;
#line 545 "/home/luca/repo/wip/zcd/serializer.vala"
	ret_length1 = 0;
#line 545 "/home/luca/repo/wip/zcd/serializer.vala"
	_ret_size_ = ret_length1;
#line 546 "/home/luca/repo/wip/zcd/serializer.vala"
	_tmp1_ = v;
#line 546 "/home/luca/repo/wip/zcd/serializer.vala"
	_tmp2_ = g_variant_iter_new (_tmp1_);
#line 546 "/home/luca/repo/wip/zcd/serializer.vala"
	iter = _tmp2_;
#line 547 "/home/luca/repo/wip/zcd/serializer.vala"
	_tmp3_ = iter;
#line 547 "/home/luca/repo/wip/zcd/serializer.vala"
	_tmp4_ = g_variant_iter_next_value (_tmp3_);
#line 547 "/home/luca/repo/wip/zcd/serializer.vala"
	v0 = _tmp4_;
#line 548 "/home/luca/repo/wip/zcd/serializer.vala"
	while (TRUE) {
#line 4617 "serializer.c"
		GVariant* _tmp5_;
		GVariant* _tmp6_;
		GVariant* _tmp7_ = NULL;
		GVariant* v1;
		GVariant** _tmp8_;
		gint _tmp8__length1;
		GVariant* _tmp9_;
		GVariant* _tmp10_;
		GVariantIter* _tmp11_;
		GVariant* _tmp12_ = NULL;
#line 548 "/home/luca/repo/wip/zcd/serializer.vala"
		_tmp5_ = v0;
#line 548 "/home/luca/repo/wip/zcd/serializer.vala"
		if (!(_tmp5_ != NULL)) {
#line 548 "/home/luca/repo/wip/zcd/serializer.vala"
			break;
#line 4634 "serializer.c"
		}
#line 550 "/home/luca/repo/wip/zcd/serializer.vala"
		_tmp6_ = v0;
#line 550 "/home/luca/repo/wip/zcd/serializer.vala"
		_tmp7_ = g_variant_get_variant (_tmp6_);
#line 550 "/home/luca/repo/wip/zcd/serializer.vala"
		v1 = _tmp7_;
#line 551 "/home/luca/repo/wip/zcd/serializer.vala"
		_tmp8_ = ret;
#line 551 "/home/luca/repo/wip/zcd/serializer.vala"
		_tmp8__length1 = ret_length1;
#line 551 "/home/luca/repo/wip/zcd/serializer.vala"
		_tmp9_ = v1;
#line 551 "/home/luca/repo/wip/zcd/serializer.vala"
		_tmp10_ = _g_variant_ref0 (_tmp9_);
#line 551 "/home/luca/repo/wip/zcd/serializer.vala"
		_vala_array_add5 (&ret, &ret_length1, &_ret_size_, _tmp10_);
#line 552 "/home/luca/repo/wip/zcd/serializer.vala"
		_tmp11_ = iter;
#line 552 "/home/luca/repo/wip/zcd/serializer.vala"
		_tmp12_ = g_variant_iter_next_value (_tmp11_);
#line 552 "/home/luca/repo/wip/zcd/serializer.vala"
		_g_variant_unref0 (v0);
#line 552 "/home/luca/repo/wip/zcd/serializer.vala"
		v0 = _tmp12_;
#line 548 "/home/luca/repo/wip/zcd/serializer.vala"
		_g_variant_unref0 (v1);
#line 4662 "serializer.c"
	}
#line 554 "/home/luca/repo/wip/zcd/serializer.vala"
	_tmp13_ = ret;
#line 554 "/home/luca/repo/wip/zcd/serializer.vala"
	_tmp13__length1 = ret_length1;
#line 554 "/home/luca/repo/wip/zcd/serializer.vala"
	if (result_length1) {
#line 554 "/home/luca/repo/wip/zcd/serializer.vala"
		*result_length1 = _tmp13__length1;
#line 4672 "serializer.c"
	}
#line 554 "/home/luca/repo/wip/zcd/serializer.vala"
	result = _tmp13_;
#line 554 "/home/luca/repo/wip/zcd/serializer.vala"
	_g_variant_unref0 (v0);
#line 554 "/home/luca/repo/wip/zcd/serializer.vala"
	_g_variant_iter_free0 (iter);
#line 554 "/home/luca/repo/wip/zcd/serializer.vala"
	return result;
#line 4682 "serializer.c"
}


GVariant* zcd_serializer_tuple_to_variant (GVariant* v0, GVariant* v1) {
	GVariant* result = NULL;
	GVariant* _tmp0_;
	GVariant* _tmp1_;
	GVariant* _tmp2_;
#line 557 "/home/luca/repo/wip/zcd/serializer.vala"
	g_return_val_if_fail (v0 != NULL, NULL);
#line 557 "/home/luca/repo/wip/zcd/serializer.vala"
	g_return_val_if_fail (v1 != NULL, NULL);
#line 559 "/home/luca/repo/wip/zcd/serializer.vala"
	_tmp0_ = v0;
#line 559 "/home/luca/repo/wip/zcd/serializer.vala"
	_tmp1_ = v1;
#line 559 "/home/luca/repo/wip/zcd/serializer.vala"
	_tmp2_ = g_variant_new ("(vv)", _tmp0_, _tmp1_, NULL);
#line 559 "/home/luca/repo/wip/zcd/serializer.vala"
	g_variant_ref_sink (_tmp2_);
#line 559 "/home/luca/repo/wip/zcd/serializer.vala"
	result = _tmp2_;
#line 559 "/home/luca/repo/wip/zcd/serializer.vala"
	return result;
#line 4707 "serializer.c"
}


void zcd_serializer_variant_to_tuple (GVariant* v, GVariant** v0, GVariant** v1) {
	GVariant* _vala_v0 = NULL;
	GVariant* _vala_v1 = NULL;
	GVariant* _tmp0_;
#line 562 "/home/luca/repo/wip/zcd/serializer.vala"
	g_return_if_fail (v != NULL);
#line 564 "/home/luca/repo/wip/zcd/serializer.vala"
	_tmp0_ = v;
#line 564 "/home/luca/repo/wip/zcd/serializer.vala"
	g_variant_get (_tmp0_, "(vv)", &_vala_v0, &_vala_v1, NULL);
#line 562 "/home/luca/repo/wip/zcd/serializer.vala"
	if (v0) {
#line 562 "/home/luca/repo/wip/zcd/serializer.vala"
		*v0 = _vala_v0;
#line 4725 "serializer.c"
	} else {
#line 562 "/home/luca/repo/wip/zcd/serializer.vala"
		_g_variant_unref0 (_vala_v0);
#line 4729 "serializer.c"
	}
#line 562 "/home/luca/repo/wip/zcd/serializer.vala"
	if (v1) {
#line 562 "/home/luca/repo/wip/zcd/serializer.vala"
		*v1 = _vala_v1;
#line 4735 "serializer.c"
	} else {
#line 562 "/home/luca/repo/wip/zcd/serializer.vala"
		_g_variant_unref0 (_vala_v1);
#line 4739 "serializer.c"
	}
}


GVariant* zcd_serializer_tuple_to_variant_3 (GVariant* v0, GVariant* v1, GVariant* v2) {
	GVariant* result = NULL;
	GVariant* _tmp0_;
	GVariant* _tmp1_;
	GVariant* _tmp2_;
	GVariant* _tmp3_;
#line 567 "/home/luca/repo/wip/zcd/serializer.vala"
	g_return_val_if_fail (v0 != NULL, NULL);
#line 567 "/home/luca/repo/wip/zcd/serializer.vala"
	g_return_val_if_fail (v1 != NULL, NULL);
#line 567 "/home/luca/repo/wip/zcd/serializer.vala"
	g_return_val_if_fail (v2 != NULL, NULL);
#line 569 "/home/luca/repo/wip/zcd/serializer.vala"
	_tmp0_ = v0;
#line 569 "/home/luca/repo/wip/zcd/serializer.vala"
	_tmp1_ = v1;
#line 569 "/home/luca/repo/wip/zcd/serializer.vala"
	_tmp2_ = v2;
#line 569 "/home/luca/repo/wip/zcd/serializer.vala"
	_tmp3_ = g_variant_new ("(vvv)", _tmp0_, _tmp1_, _tmp2_, NULL);
#line 569 "/home/luca/repo/wip/zcd/serializer.vala"
	g_variant_ref_sink (_tmp3_);
#line 569 "/home/luca/repo/wip/zcd/serializer.vala"
	result = _tmp3_;
#line 569 "/home/luca/repo/wip/zcd/serializer.vala"
	return result;
#line 4770 "serializer.c"
}


void zcd_serializer_variant_to_tuple_3 (GVariant* v, GVariant** v0, GVariant** v1, GVariant** v2) {
	GVariant* _vala_v0 = NULL;
	GVariant* _vala_v1 = NULL;
	GVariant* _vala_v2 = NULL;
	GVariant* _tmp0_;
#line 572 "/home/luca/repo/wip/zcd/serializer.vala"
	g_return_if_fail (v != NULL);
#line 574 "/home/luca/repo/wip/zcd/serializer.vala"
	_tmp0_ = v;
#line 574 "/home/luca/repo/wip/zcd/serializer.vala"
	g_variant_get (_tmp0_, "(vvv)", &_vala_v0, &_vala_v1, &_vala_v2, NULL);
#line 572 "/home/luca/repo/wip/zcd/serializer.vala"
	if (v0) {
#line 572 "/home/luca/repo/wip/zcd/serializer.vala"
		*v0 = _vala_v0;
#line 4789 "serializer.c"
	} else {
#line 572 "/home/luca/repo/wip/zcd/serializer.vala"
		_g_variant_unref0 (_vala_v0);
#line 4793 "serializer.c"
	}
#line 572 "/home/luca/repo/wip/zcd/serializer.vala"
	if (v1) {
#line 572 "/home/luca/repo/wip/zcd/serializer.vala"
		*v1 = _vala_v1;
#line 4799 "serializer.c"
	} else {
#line 572 "/home/luca/repo/wip/zcd/serializer.vala"
		_g_variant_unref0 (_vala_v1);
#line 4803 "serializer.c"
	}
#line 572 "/home/luca/repo/wip/zcd/serializer.vala"
	if (v2) {
#line 572 "/home/luca/repo/wip/zcd/serializer.vala"
		*v2 = _vala_v2;
#line 4809 "serializer.c"
	} else {
#line 572 "/home/luca/repo/wip/zcd/serializer.vala"
		_g_variant_unref0 (_vala_v2);
#line 4813 "serializer.c"
	}
}


GVariant* zcd_serializer_tuple_to_variant_4 (GVariant* v0, GVariant* v1, GVariant* v2, GVariant* v3) {
	GVariant* result = NULL;
	GVariant* _tmp0_;
	GVariant* _tmp1_;
	GVariant* _tmp2_;
	GVariant* _tmp3_;
	GVariant* _tmp4_;
#line 577 "/home/luca/repo/wip/zcd/serializer.vala"
	g_return_val_if_fail (v0 != NULL, NULL);
#line 577 "/home/luca/repo/wip/zcd/serializer.vala"
	g_return_val_if_fail (v1 != NULL, NULL);
#line 577 "/home/luca/repo/wip/zcd/serializer.vala"
	g_return_val_if_fail (v2 != NULL, NULL);
#line 577 "/home/luca/repo/wip/zcd/serializer.vala"
	g_return_val_if_fail (v3 != NULL, NULL);
#line 579 "/home/luca/repo/wip/zcd/serializer.vala"
	_tmp0_ = v0;
#line 579 "/home/luca/repo/wip/zcd/serializer.vala"
	_tmp1_ = v1;
#line 579 "/home/luca/repo/wip/zcd/serializer.vala"
	_tmp2_ = v2;
#line 579 "/home/luca/repo/wip/zcd/serializer.vala"
	_tmp3_ = v3;
#line 579 "/home/luca/repo/wip/zcd/serializer.vala"
	_tmp4_ = g_variant_new ("(vvvv)", _tmp0_, _tmp1_, _tmp2_, _tmp3_, NULL);
#line 579 "/home/luca/repo/wip/zcd/serializer.vala"
	g_variant_ref_sink (_tmp4_);
#line 579 "/home/luca/repo/wip/zcd/serializer.vala"
	result = _tmp4_;
#line 579 "/home/luca/repo/wip/zcd/serializer.vala"
	return result;
#line 4849 "serializer.c"
}


void zcd_serializer_variant_to_tuple_4 (GVariant* v, GVariant** v0, GVariant** v1, GVariant** v2, GVariant** v3) {
	GVariant* _vala_v0 = NULL;
	GVariant* _vala_v1 = NULL;
	GVariant* _vala_v2 = NULL;
	GVariant* _vala_v3 = NULL;
	GVariant* _tmp0_;
#line 582 "/home/luca/repo/wip/zcd/serializer.vala"
	g_return_if_fail (v != NULL);
#line 584 "/home/luca/repo/wip/zcd/serializer.vala"
	_tmp0_ = v;
#line 584 "/home/luca/repo/wip/zcd/serializer.vala"
	g_variant_get (_tmp0_, "(vvvv)", &_vala_v0, &_vala_v1, &_vala_v2, &_vala_v3, NULL);
#line 582 "/home/luca/repo/wip/zcd/serializer.vala"
	if (v0) {
#line 582 "/home/luca/repo/wip/zcd/serializer.vala"
		*v0 = _vala_v0;
#line 4869 "serializer.c"
	} else {
#line 582 "/home/luca/repo/wip/zcd/serializer.vala"
		_g_variant_unref0 (_vala_v0);
#line 4873 "serializer.c"
	}
#line 582 "/home/luca/repo/wip/zcd/serializer.vala"
	if (v1) {
#line 582 "/home/luca/repo/wip/zcd/serializer.vala"
		*v1 = _vala_v1;
#line 4879 "serializer.c"
	} else {
#line 582 "/home/luca/repo/wip/zcd/serializer.vala"
		_g_variant_unref0 (_vala_v1);
#line 4883 "serializer.c"
	}
#line 582 "/home/luca/repo/wip/zcd/serializer.vala"
	if (v2) {
#line 582 "/home/luca/repo/wip/zcd/serializer.vala"
		*v2 = _vala_v2;
#line 4889 "serializer.c"
	} else {
#line 582 "/home/luca/repo/wip/zcd/serializer.vala"
		_g_variant_unref0 (_vala_v2);
#line 4893 "serializer.c"
	}
#line 582 "/home/luca/repo/wip/zcd/serializer.vala"
	if (v3) {
#line 582 "/home/luca/repo/wip/zcd/serializer.vala"
		*v3 = _vala_v3;
#line 4899 "serializer.c"
	} else {
#line 582 "/home/luca/repo/wip/zcd/serializer.vala"
		_g_variant_unref0 (_vala_v3);
#line 4903 "serializer.c"
	}
}


GVariant* zcd_serializer_tuple_to_variant_5 (GVariant* v0, GVariant* v1, GVariant* v2, GVariant* v3, GVariant* v4) {
	GVariant* result = NULL;
	GVariant* _tmp0_;
	GVariant* _tmp1_;
	GVariant* _tmp2_;
	GVariant* _tmp3_;
	GVariant* _tmp4_;
	GVariant* _tmp5_;
#line 587 "/home/luca/repo/wip/zcd/serializer.vala"
	g_return_val_if_fail (v0 != NULL, NULL);
#line 587 "/home/luca/repo/wip/zcd/serializer.vala"
	g_return_val_if_fail (v1 != NULL, NULL);
#line 587 "/home/luca/repo/wip/zcd/serializer.vala"
	g_return_val_if_fail (v2 != NULL, NULL);
#line 587 "/home/luca/repo/wip/zcd/serializer.vala"
	g_return_val_if_fail (v3 != NULL, NULL);
#line 587 "/home/luca/repo/wip/zcd/serializer.vala"
	g_return_val_if_fail (v4 != NULL, NULL);
#line 589 "/home/luca/repo/wip/zcd/serializer.vala"
	_tmp0_ = v0;
#line 589 "/home/luca/repo/wip/zcd/serializer.vala"
	_tmp1_ = v1;
#line 589 "/home/luca/repo/wip/zcd/serializer.vala"
	_tmp2_ = v2;
#line 589 "/home/luca/repo/wip/zcd/serializer.vala"
	_tmp3_ = v3;
#line 589 "/home/luca/repo/wip/zcd/serializer.vala"
	_tmp4_ = v4;
#line 589 "/home/luca/repo/wip/zcd/serializer.vala"
	_tmp5_ = g_variant_new ("(vvvvv)", _tmp0_, _tmp1_, _tmp2_, _tmp3_, _tmp4_, NULL);
#line 589 "/home/luca/repo/wip/zcd/serializer.vala"
	g_variant_ref_sink (_tmp5_);
#line 589 "/home/luca/repo/wip/zcd/serializer.vala"
	result = _tmp5_;
#line 589 "/home/luca/repo/wip/zcd/serializer.vala"
	return result;
#line 4944 "serializer.c"
}


void zcd_serializer_variant_to_tuple_5 (GVariant* v, GVariant** v0, GVariant** v1, GVariant** v2, GVariant** v3, GVariant** v4) {
	GVariant* _vala_v0 = NULL;
	GVariant* _vala_v1 = NULL;
	GVariant* _vala_v2 = NULL;
	GVariant* _vala_v3 = NULL;
	GVariant* _vala_v4 = NULL;
	GVariant* _tmp0_;
#line 592 "/home/luca/repo/wip/zcd/serializer.vala"
	g_return_if_fail (v != NULL);
#line 594 "/home/luca/repo/wip/zcd/serializer.vala"
	_tmp0_ = v;
#line 594 "/home/luca/repo/wip/zcd/serializer.vala"
	g_variant_get (_tmp0_, "(vvvvv)", &_vala_v0, &_vala_v1, &_vala_v2, &_vala_v3, &_vala_v4, NULL);
#line 592 "/home/luca/repo/wip/zcd/serializer.vala"
	if (v0) {
#line 592 "/home/luca/repo/wip/zcd/serializer.vala"
		*v0 = _vala_v0;
#line 4965 "serializer.c"
	} else {
#line 592 "/home/luca/repo/wip/zcd/serializer.vala"
		_g_variant_unref0 (_vala_v0);
#line 4969 "serializer.c"
	}
#line 592 "/home/luca/repo/wip/zcd/serializer.vala"
	if (v1) {
#line 592 "/home/luca/repo/wip/zcd/serializer.vala"
		*v1 = _vala_v1;
#line 4975 "serializer.c"
	} else {
#line 592 "/home/luca/repo/wip/zcd/serializer.vala"
		_g_variant_unref0 (_vala_v1);
#line 4979 "serializer.c"
	}
#line 592 "/home/luca/repo/wip/zcd/serializer.vala"
	if (v2) {
#line 592 "/home/luca/repo/wip/zcd/serializer.vala"
		*v2 = _vala_v2;
#line 4985 "serializer.c"
	} else {
#line 592 "/home/luca/repo/wip/zcd/serializer.vala"
		_g_variant_unref0 (_vala_v2);
#line 4989 "serializer.c"
	}
#line 592 "/home/luca/repo/wip/zcd/serializer.vala"
	if (v3) {
#line 592 "/home/luca/repo/wip/zcd/serializer.vala"
		*v3 = _vala_v3;
#line 4995 "serializer.c"
	} else {
#line 592 "/home/luca/repo/wip/zcd/serializer.vala"
		_g_variant_unref0 (_vala_v3);
#line 4999 "serializer.c"
	}
#line 592 "/home/luca/repo/wip/zcd/serializer.vala"
	if (v4) {
#line 592 "/home/luca/repo/wip/zcd/serializer.vala"
		*v4 = _vala_v4;
#line 5005 "serializer.c"
	} else {
#line 592 "/home/luca/repo/wip/zcd/serializer.vala"
		_g_variant_unref0 (_vala_v4);
#line 5009 "serializer.c"
	}
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
#line 314 "/home/luca/repo/wip/zcd/serializer.vala"
	if ((array != NULL) && (destroy_func != NULL)) {
#line 5017 "serializer.c"
		int i;
#line 314 "/home/luca/repo/wip/zcd/serializer.vala"
		for (i = 0; i < array_length; i = i + 1) {
#line 314 "/home/luca/repo/wip/zcd/serializer.vala"
			if (((gpointer*) array)[i] != NULL) {
#line 314 "/home/luca/repo/wip/zcd/serializer.vala"
				destroy_func (((gpointer*) array)[i]);
#line 5025 "serializer.c"
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
#line 314 "/home/luca/repo/wip/zcd/serializer.vala"
	_vala_array_destroy (array, array_length, destroy_func);
#line 314 "/home/luca/repo/wip/zcd/serializer.vala"
	g_free (array);
#line 5037 "serializer.c"
}



