/*
 *  This file is part of Netsukuku.
 *  (c) Copyright 2014 Luca Dionisi aka lukisi <luca.dionisi@gmail.com>
 *
 *  Netsukuku is free software: you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation, either version 3 of the License, or
 *  (at your option) any later version.
 *
 *  Netsukuku is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with Netsukuku.  If not, see <http://www.gnu.org/licenses/>.
 */

using Gee;

namespace zcd
{
    /** A message that uses TCP as transport.
      */
    public class TCPRequest : Object, ISerializable
    {
        public bool wait_response;
        public RemoteCall data;
        public TCPRequest(bool wait_response, RemoteCall data)
        {
            this.wait_response = wait_response;
            this.data = data;
        }
        
        public Variant serialize_to_variant()
        {
            Variant v0 = Serializer.int_to_variant(wait_response?1:0);
            Variant v1 = data.serialize_to_variant();
            Variant vret = Serializer.tuple_to_variant(v0, v1);
            return vret;
        }
        
        public void deserialize_from_variant(Variant v) throws SerializerError
        {
            Variant v0;
            Variant v1;
            Serializer.variant_to_tuple(v, out v0, out v1);
            wait_response = Serializer.variant_to_int(v0) == 1;
            data = (RemoteCall)Object.new(typeof(RemoteCall));
            data.deserialize_from_variant(v1);
        }

        public string to_string()
        {
            string wait_str = wait_response ? "wait_response" : "no_wait_response";
            return @"<TCPRequest $(data) $(wait_str)>";
        }
    }
}
