/**
 * WebAdmin
 * Copyright (C) 2006 Netwosix Team
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License 
 * along with this program; if not, write to the Free Software 
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA
 *
 * Linking WebAdmin statically or dynamically with other modules is making
 * a combined work based on WebAdmin. Thus, the terms and conditions of the 
 * GNU General Public License cover the whole combination.
 *
 * In addition, as a special exception, the copyright holders of
 * WebAdmin give you permission to combine WebAdmin with free software
 * programs or libraries that are released under the GNU LGPL and with
 * code included in the standard release of OpenSSL under the OpenSSL
 * License and SSLeay License (or modified versions of such code, with
 * unchanged licenses). You may copy and distribute such a system
 * following the terms of the GNU GPL for WebAdmin and the licenses of
 * the other code concerned, provided that you include the source code of
 * that other code when and as the GNU GPL requires distribution of
 * source code.
 *
 * Note that people who make modified versions of WebAdmin are not obligated
 * to grant this special exception for their modified versions; 
 * it is their choice whether to do so. The GNU General Public License 
 * gives permission to release a modified version without this exception; 
 * this exception also makes it possible to release a modified 
 * version which carries forward this exception.
 */

#include "agentd.h"



/**
 */
AgentdAgent * agentd_agent_find(const AgentdRequest * request)
{
	AgentdAgent    * agent;
	AlXmlNode      * agent_node;


	al_return_val_if_fail(request, NULL);

	if ((agent_node = al_xml_get_node_in_list(agentd_config(), "agents", "agent", "name", request->agent_name)) == NULL)
		return NULL;

	agent = agentd_agent_new();

	agentd_agent_set_name(agent, al_xml_get_attribute_value(agent_node, "name"));
	agentd_agent_set_bin(agent, al_xml_get_attribute_value(agent_node, "bin"));

	/* Verify integriti of data */
	if (agent->bin == NULL || agent->name == NULL)
	{
		syslog(LOG_WARNING, "Agent %s is not configured.The agent is not executed.\n", agentd_agent_get_name(agent));
		agentd_agent_delete(agent);
		agent = NULL;
	}
	else if (agent->bin[0] != '/')
	{
		syslog(LOG_WARNING, "Agent %s bin %s is not full path. The agent is not executed.\n", agentd_agent_get_name(agent), agentd_agent_get_bin(agent));
		agentd_agent_delete(agent);
		agent = NULL;
	}

	return agent;
}


/**
 */
AgentdAgent * agentd_agent_new(void)
{
	AgentdAgent * agent = al_new(AgentdAgent);

	agent->name = NULL;
	agent->bin = NULL;
	agent->user = NULL;

	return agent;
}


/**
 */
void agentd_agent_delete(AgentdAgent * agent)
{

	al_return_if_fail (agent);

	al_delete(agent->name);
	al_delete(agent->bin);
	al_delete(agent->user);
	al_delete(agent);

}


/**
 */
void agentd_agent_execute(const AgentdAgent * agent, const AgentdRequest * request, AgentdResponse * response)
{
	int             status;
	AlXml         * xml;
	AlXml         * agent_xml;
	AlXmlNode     * node;
	AlXmlList     * list;
	const char    * data;
	AlString      * s;


	al_return_if_fail(agent && request && response);

	s = al_string_new();
	if (al_spawn(agentd_agent_get_bin(agent), agentd_agent_get_user(agent), agentd_request_get_agent_data(request), s, &status) || status)
	{
		agentd_response_set_type(response, AGENTD_RESPONSE_AGENTD_FAILED);
	}

	agentd_response_set_agent_data(response, al_string_get(s));
	al_string_delete(s);

	xml = al_xml_new_from_string(agentd_response_get_agent_data(response));

	if (al_xml_verify(xml))
	{
		al_log (("Invalid response agent-data\n"));
		agentd_response_set_type(response, AGENTD_RESPONSE_INVALID_AGENT_DATA);
	}
	else
	{
		/* Verify the agent returned data */
		list = al_xml_get_list(xml, "responses");
		if (list)
		{
			for (node=list->nodes;node;node=node->next)
			{
				data = al_xml_get_attribute_value(node, "data");

				al_log (("agent response : %s\n",data));

				agent_xml = al_xml_new_from_string(data);
				if (al_xml_verify(agent_xml))
				{
					al_log (("Invalid response agent-data\n"));
					agentd_response_set_type(response, AGENTD_RESPONSE_INVALID_AGENT_DATA);
					al_xml_delete(agent_xml);
					break;
				}
				al_xml_delete(agent_xml);
			}
		}
	}

	al_xml_delete(xml);

}
