/**
 * WebAdmin
 * Copyright (C) 2006 Netwosix Team
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License 
 * along with this program; if not, write to the Free Software 
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA
 *
 * Linking WebAdmin statically or dynamically with other modules is making
 * a combined work based on WebAdmin. Thus, the terms and conditions of the 
 * GNU General Public License cover the whole combination.
 *
 * In addition, as a special exception, the copyright holders of
 * WebAdmin give you permission to combine WebAdmin with free software
 * programs or libraries that are released under the GNU LGPL and with
 * code included in the standard release of OpenSSL under the OpenSSL
 * License and SSLeay License (or modified versions of such code, with
 * unchanged licenses). You may copy and distribute such a system
 * following the terms of the GNU GPL for WebAdmin and the licenses of
 * the other code concerned, provided that you include the source code of
 * that other code when and as the GNU GPL requires distribution of
 * source code.
 *
 * Note that people who make modified versions of WebAdmin are not obligated
 * to grant this special exception for their modified versions; 
 * it is their choice whether to do so. The GNU General Public License 
 * gives permission to release a modified version without this exception; 
 * this exception also makes it possible to release a modified 
 * version which carries forward this exception.
 */

#include "agents.h"



/**
 */
void syntax(void);


#ifdef AL_SSL
static const char * supported[] = { "stdio", "tcp", "ssl", NULL };
#else
static const char * supported[] = { "stdio", "tcp", NULL };
#endif


/**
 */
int main(int argc, char ** argv)
{
	AlConnectionManager     * connection_manager = NULL;
	AlConnection            * connection = NULL;
	char                    * connection_type = NULL;
	char                    * s_port;
	int                       port;
	AlXmlNode               * node;
	AlString                * s;
	AlString                * input;
	int                       i;
	AgentsRequestPacket     * request_packet = NULL;
	AgentsResponsePacket    * response_packet = NULL;



	/** Parse the command line */
	for (i=1;i<argc;i++)
	{

		if (!strcmp(argv[i],"-h") || !strcmp(argv[i],"--help"))
		{
			syntax();
		}
		else if (!strcmp(argv[i],"-v") || !strcmp(argv[i],"--version"))
		{
			al_exit(0, "%s\n", AGENTS_VERSION);
		}
		else if (!strcmp(argv[i],"-c") || !strcmp(argv[i],"--connection"))
		{
			if ((++i) < argc)
			{
				connection_type = argv[i];
				al_connection_supported_list(connection_type, AGENTS_VERSION, supported);
			}
			else
			{
				syntax();
			}
		}
		else
		{
			syntax();
		}

	}


	if ((node = al_xml_get_node(agents_config(), "connection")) == NULL)
		al_exit(1, "%s\nInvalid config file.\n", AGENTS_VERSION);

	if (!(connection_manager = al_connection_manager_from_string(connection_type, supported, node)))
		al_exit(1, "%s\nInvalid connection type.\n", AGENTS_VERSION);


	openlog(AGENTS_VERSION, LOG_PID, LOG_DAEMON);

	
	input = al_read_file(stdin);
	if (al_xml_verify_from_string(al_string_get(input)))
		al_exit(1, "Invalid xml packet from stdin.\n");


	request_packet = agents_request_packet_from_xml_string(input);
	response_packet = agents_response_packet_from_request_packet(request_packet, connection_manager);
	if (response_packet)
	{
		s = agents_response_packet_to_xml_string(response_packet);
		fprintf(stdout,"%s\n", al_string_get(s));
		al_string_delete(s);
	}

	if (connection_manager) al_connection_manager_delete(connection_manager);

	al_exit(0, NULL);

	return 0;
}


/**
 */
void syntax(void)
{

	printf("Usage: agents [OPTION ...]\n");
	printf(" Options:\n");
	printf("\n");
	printf("  -c, --connection       Override the connection type given in config file.\n");
	printf("                         Use -c list to show the supported connection type.\n");
	printf("  -h, --help             Give this help list.\n");
	printf("  -v, --version          Show version and exit.\n");


	al_exit(0, NULL);
}
