/**
 * WebAdmin
 * Copyright (C) 2006 Netwosix Team
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License 
 * along with this program; if not, write to the Free Software 
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA
 *
 * Linking WebAdmin statically or dynamically with other modules is making
 * a combined work based on WebAdmin. Thus, the terms and conditions of the 
 * GNU General Public License cover the whole combination.
 *
 * In addition, as a special exception, the copyright holders of
 * WebAdmin give you permission to combine WebAdmin with free software
 * programs or libraries that are released under the GNU LGPL and with
 * code included in the standard release of OpenSSL under the OpenSSL
 * License and SSLeay License (or modified versions of such code, with
 * unchanged licenses). You may copy and distribute such a system
 * following the terms of the GNU GPL for WebAdmin and the licenses of
 * the other code concerned, provided that you include the source code of
 * that other code when and as the GNU GPL requires distribution of
 * source code.
 *
 * Note that people who make modified versions of WebAdmin are not obligated
 * to grant this special exception for their modified versions; 
 * it is their choice whether to do so. The GNU General Public License 
 * gives permission to release a modified version without this exception; 
 * this exception also makes it possible to release a modified 
 * version which carries forward this exception.
 */

#ifndef RESPONSE_H_
#define RESPONSE_H_


/**
 * Type of response
 */
enum _AgentsResponseType
{

	AGENTS_RESPONSE_OK                    = 0, /* everything is ok                */
	AGENTS_RESPONSE_SERVER_NOT_FOUND      = 1, /* server not found                */
	AGENTS_RESPONSE_UNKNOWN_ERROR         = 2, /* unknown error                   */
	AGENTS_RESPONSE_INVALID_SERVER_DATA   = 3  /* invalid response from server    */

};

typedef int AgentsResponseType;


/**
 * Structure representing a response
 */
struct _AgentsResponse
{

	struct _AgentsResponse * prev;
	struct _AgentsResponse * next;

	char                   * id;          /* request id               */
	AgentsResponseType       type;        /* type of response         */
	char                   * server_name; /* name of requested server */
	char                   * server_data; /* data for agent           */

};

typedef struct _AgentsResponse AgentsResponse;


/**
 */
#define agents_response_set_id(response,v)                   (response)->id = al_strdup(v)


/**
 */
#define agents_response_get_id(response)                    (response)->id


/**
 */
#define agents_response_set_server_name(response,v)         (response)->server_name = al_strdup(v)


/**
 */
#define agents_response_get_server_name(response)           (response)->server_name


/**
 */
#define agents_response_set_server_data(response,v)         (response)->server_data = al_strdup(v)


/**
 */
#define agents_response_get_server_data(response)           (response)->server_data


/**
 */
#define agents_response_set_type(response,v)                (response)->type = v


/**
 */
#define agents_response_get_type(response)                  (response)->type


/**
 * Structure representing a packet with one or many response.
 */
struct _AgentsResponsePacket
{

	struct _AgentsResponse * responses; /* list of response in the packet */

};

typedef struct _AgentsResponsePacket AgentsResponsePacket;


/**
 * Create a new response.
 *
 * @return the new response.
 */
AgentsResponse * agents_response_new(void);


/**
 * Delete a response.
 *
 * @param response response to free
 */
void agents_response_delete(AgentsResponse * response);


/**
 * Create a new response packet.
 *
 * @return the new response packet.
 */
AgentsResponsePacket * agents_response_packet_new(void);


/**
 * Delete a response packet and all response in list.
 *
 * @param response_packet response packet to free
 */
void agents_response_packet_delete(AgentsResponsePacket * response_packet);


/**
 * Add a response to a response packet.
 *
 * @param response_packet response packet
 * @param response response to add
 */
void agents_response_packet_response_add(AgentsResponsePacket * response_packet, AgentsResponse * response);


/**
 * Create a new response basend on a request.
 * This process the request.
 *
 * @param request request who response is based
 *
 * @return the new response
 */
AgentsResponse * agents_response_from_request(const AgentsRequest * request, AlConnectionManager * connection_manager);


/**
 * Create a new response packet basend on a request packet.
 * This process every request in the packet.
 *
 * @param request_packet request packet who response is based
 *
 * @return the new response packet
 */
AgentsResponsePacket * agents_response_packet_from_request_packet(const AgentsRequestPacket * request_packet, AlConnectionManager * connection_manager);


/**
 * Dump the response packet to xml.
 *
 * @param response_packet response packet to dump
 *
 * @return response packet in xml
 */
AlXmlList * agents_response_packet_to_xml(const AgentsResponsePacket * response_packet);


/**
 * Dump the response packet to xml.
 *
 * @param response_packet response packet to dump
 *
 * @return response packet in xml
 */
AlString * agents_response_packet_to_xml_string(const AgentsResponsePacket * response_packet);


/**
 * Dump the response to xml.
 *
 * @param response response to dump
 *
 * @return response in xml node
 */
AlXmlNode * agents_response_to_xml(const AgentsResponse * response);


#endif /* RESPONSE_H_ */
