/**
 * WebAdmin
 * Copyright (C) 2006 Netwosix Team
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License 
 * along with this program; if not, write to the Free Software 
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA
 *
 * Linking WebAdmin statically or dynamically with other modules is making
 * a combined work based on WebAdmin. Thus, the terms and conditions of the 
 * GNU General Public License cover the whole combination.
 *
 * In addition, as a special exception, the copyright holders of
 * WebAdmin give you permission to combine WebAdmin with free software
 * programs or libraries that are released under the GNU LGPL and with
 * code included in the standard release of OpenSSL under the OpenSSL
 * License and SSLeay License (or modified versions of such code, with
 * unchanged licenses). You may copy and distribute such a system
 * following the terms of the GNU GPL for WebAdmin and the licenses of
 * the other code concerned, provided that you include the source code of
 * that other code when and as the GNU GPL requires distribution of
 * source code.
 *
 * Note that people who make modified versions of WebAdmin are not obligated
 * to grant this special exception for their modified versions; 
 * it is their choice whether to do so. The GNU General Public License 
 * gives permission to release a modified version without this exception; 
 * this exception also makes it possible to release a modified 
 * version which carries forward this exception.
 */

#include "al.h"

#include <spawn.h>
#include <sys/types.h>
#include <sys/stat.h>


#define AL_SPAWN_SU_CMD           "su -c %s - %s"


/**
 */
int al_spawn(const char * bin, const char * user, const char * std_in, AlString * std_out, int * status)
{
	char                       * r_bin = NULL;
	char                         buf;
	int                          sts;
	int                          i;
	int                          len;
	int                          err;
	pid_t                        pid;
	posix_spawn_file_actions_t   actions;
	posix_spawnattr_t            attrs;
	int                          ifd[2];
	int                          ofd[2];


	al_return_val_if_fail(bin, 99);


	if ((err = posix_spawn_file_actions_init (&actions)) != 0)
	{
		fprintf(stderr, "Error %d executing posix_spawn_file_actions_init\n", err);
		return 1;
	}


	/* Create pipe for redirect stdin e stdout */
	if (pipe (ifd) == -1)
	{
		fprintf(stderr, "Error %d executing pipe\n", errno);
		return 2;
	}

	if (pipe (ofd) == -1)
	{
		fprintf(stderr, "Error %d executing pipe\n", errno);
		return 3;
	}

	posix_spawn_file_actions_adddup2 (&actions, ofd[0], STDIN_FILENO);
	posix_spawn_file_actions_adddup2 (&actions,ifd[1], STDOUT_FILENO);
	posix_spawn_file_actions_addclose (&actions, ofd[0]);
	posix_spawn_file_actions_addclose (&actions, ifd[1]);
	posix_spawn_file_actions_addclose (&actions, ofd[1]);
	posix_spawn_file_actions_addclose (&actions, ifd[0]);


	if (std_in)
	{
		write(ofd[1], std_in, strlen(std_in));
		write(ofd[1], "\n", 1);
	}

	if (user)
	{
		r_bin = (char*)malloc(sizeof(char) * ( strlen(user) + strlen(bin) + strlen(AL_SPAWN_SU_CMD) +1));
		sprintf(r_bin, AL_SPAWN_SU_CMD, bin, user);
		if ((err = posix_spawn (&pid, bin, &actions, NULL, NULL, NULL)) != 0)
		{
			fprintf(stderr, "Error %d during posix_spawn\n", err);
			al_delete(r_bin);
			return 4;
		}
		al_delete(r_bin);
	}
	else
	{
		if ((err = posix_spawn (&pid, bin, &actions, NULL, NULL, NULL)) != 0)
		{
			fprintf(stderr, "Error %d during posix_spawn\n", err);
			return 4;
		}
	}

	close(ifd[1]);
	close(ofd[0]);
	close(ofd[1]);

	if (std_out == NULL)
		close(ifd[0]);
	
	/* .. and wait to end */
	waitpid(pid, &sts, 0);

	if (status) (*status) = sts;

	if (std_out)
	{
		while (read(ifd[0], &buf, 1) > 0)
			al_string_append_char(std_out, buf);

		close(ifd[0]);
	}
	

	return 0;
}
