/**
 * WebAdmin
 * Copyright (C) 2006 Netwosix Team
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License 
 * along with this program; if not, write to the Free Software 
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA
 *
 * Linking WebAdmin statically or dynamically with other modules is making
 * a combined work based on WebAdmin. Thus, the terms and conditions of the 
 * GNU General Public License cover the whole combination.
 *
 * In addition, as a special exception, the copyright holders of
 * WebAdmin give you permission to combine WebAdmin with free software
 * programs or libraries that are released under the GNU LGPL and with
 * code included in the standard release of OpenSSL under the OpenSSL
 * License and SSLeay License (or modified versions of such code, with
 * unchanged licenses). You may copy and distribute such a system
 * following the terms of the GNU GPL for WebAdmin and the licenses of
 * the other code concerned, provided that you include the source code of
 * that other code when and as the GNU GPL requires distribution of
 * source code.
 *
 * Note that people who make modified versions of WebAdmin are not obligated
 * to grant this special exception for their modified versions; 
 * it is their choice whether to do so. The GNU General Public License 
 * gives permission to release a modified version without this exception; 
 * this exception also makes it possible to release a modified 
 * version which carries forward this exception.
 */

#include "al.h"




/**
 */
AlString * al_read_file_by_name(const char * file_name)
{
	AlString * s;
	FILE         * file;


	al_return_val_if_fail (file_name, NULL);

	if ((file = fopen(file_name,"r")) == NULL) return NULL;

	s = al_read_file(file);

	fclose(file);

	return s;
}


/**
 */
AlString * al_read_file(FILE * file)
{
	AlString * s;
	char           buf;


	al_return_val_if_fail(file, NULL);

	s = al_string_new();
	while (!feof(file))
	{
		fread(&buf,1,1,file);
		if (feof(file)) break;

		al_string_append_char(s, buf);
	}


	return s;
}


/**
 */
void al_exit(int ret, const char * fmt, ...)
{
	va_list ap;

	va_start(ap, fmt);

	if (fmt) vfprintf(stderr, fmt, ap);

	va_end(ap);

	exit(ret);
}


/**
 */
void al_real_log(const char * fmt, ...)
{
	va_list ap;

	va_start (ap, fmt);

	if (fmt) vfprintf(stderr, fmt, ap);

	va_end (ap);
	
}


/**
 */
char ** al_split(const char * s, char sep)
{
	int     i,j,l;
	int     c = 1;
	char ** splits = NULL;


	for(i=0;s[i] != '\0'; i++)
		if (s[i] == sep && (i == 0 || s[i-1] != sep)) c++;

	splits = al_new_n0(char *, c + 1);

	l = 0;
	for(i=j=0;s[i] != '\0'; i++)
	{
		if (s[i] == sep && (i == 0 || s[i-1] != sep))
		{
			splits[j] = al_new_n0(char, i - l +1);
			strncpy(splits[j], &s[l], i-l);
			j++;
			l = i+1;
		}
	}

	if (l != i)
	{
		splits[j] = al_new_n0(char, i - l +1);
		strncpy(splits[j], &s[l], i-l);
		j++;
	}
	
	splits[j] = NULL;


	return splits;
}


/**
 */
char * al_string_array_to_string(const char ** s, int size, char sep)
{
	int    i,j,k;
	char * ret;
	int    len = 0;

	for (i=0;i<size;i++)
		len += strlen(s[i]);

	ret = al_new_n0(char, len + (size * 1) + 1);

	for (i=j=0;i<size;i++)
	{
		for (k=0;s[i][k] != '\0';k++)
			ret[j++] = s[i][k];
		ret[j++] = sep;
	}


	return ret;
}

